@component('mail::layout')
{{-- Header --}}
@slot('header')
@include('email.admin.includes.header')
@endslot
<style>
    .bordered-table {
        width: 100%;
        border-collapse: collapse;
    }
    .bordered-table th, .bordered-table td {
        border: 1px solid #dee2e6;
        padding: 0.75rem;
    }
</style>
{{-- Body --}}
<!-- Email Body -->
{{-- Greeting --}}
{{-- Greeting --}}
@if (! empty($greeting))
# {{ $greeting }}
@else
@if ($level === 'error')
# @lang('Whoops!')
@else
# Dear Admin,
@endif
@endif
<p>This is the daily report summarising credit submissions completed by lawyers.</p>
<p><strong>Total completed submissions in the last 24 hours: {{$count}} </strong></p>


@if(!empty($userHoursData))
<table class="bordered-table">
    <thead>
        <tr>
            <th>Lawyer Name</th>
            <th>Hours spent</th>
        </tr>
    </thead>
    <tbody>
        @foreach($userHoursData as $userId => $userData)
            @foreach($userData['bars'] as $bar)
                <tr>
                    <td style="text-align: center">{{ $userData['user_name'] }}</td>
                    <td style="text-align: center">{{ $bar['hours_spent'] }} hours</td>
                </tr>
            @endforeach
        @endforeach
    </tbody>
</table>
<br>
@endif

<p>Please note: This is an automated email. Replies to this message will not be received.</p>

Thank you,
@if (! empty($salutation))
<br>
{{ $salutation }}
@endif
{{-- Subcopy --}}
@isset($subcopy)
@slot('subcopy')
@component('mail::subcopy')
{{ $subcopy }}
@endcomponent
@endslot
@endisset
{{-- Footer --}}
@slot('footer')
@include('email.admin.includes.footer')
@endslot
@endcomponent
