@component('mail::layout')
{{-- Header --}}
@slot('header')
@include('email.admin.includes.header')
@endslot


<style>
.table-wrapper-1 {
  display: table;
  table-layout: fixed;
  width: 100%;
}

.table-wrapper-2 {
  display: table-cell;
  overflow-x: auto;
  width: 100%;
}
    .bordered-table {
        border-collapse: collapse;
        max-width: 100%;
    }
    .bordered-table th, .bordered-table td {
        border: 1px solid #dee2e6;
        padding: 0.75rem;
    }
</style>

{{-- Body --}}
<!-- Email Body -->
{{-- Greeting --}}
{{-- Greeting --}}
@if (! empty($greeting))
# {{ $greeting }}
@else
@if ($level === 'error')
# @lang('Whoops!')
@else
# Dear Admin,
@endif
@endif
<p>The following users activated their account in the last week.</p>
@if($subscriptions->isNotEmpty())
<div class="table-wrapper-1">
    <div class="table-wrapper-2">
        <table class="bordered-table">
            <thead>
                <tr>
                    <th><strong>User</strong></th>
                    <th><strong>Phone</strong></th>
                    <th><strong>Subscription Start Date</strong></th>
                </tr>
            </thead>
            <tbody>
                @foreach ($subscriptions as $subscription)
                    <tr>
                        <td>{{ $subscription->user->first_name . ' ' . $subscription->user->last_name }} <br> {{ $subscription->user->email }}</td>
                        <td>{{ $subscription->user->phone }}</td>
                        <td>{{ Carbon\Carbon::parse($subscription->start_date)->format(config('app.db_date_format'))  }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@else
<p>No users activated their account in the last week.</p>
@endif
<br/>
<p>Please note: This is an automated email that cannot accept replies.</p>

Thank you,
<br>
@if (! empty($salutation))
{{ $salutation }}
@endif
{{-- Subcopy --}}
@isset($subcopy)
@slot('subcopy')
@component('mail::subcopy')
{{ $subcopy }}
@endcomponent
@endslot
@endisset
{{-- Footer --}}
@slot('footer')
@include('email.admin.includes.footer')
@endslot
@endcomponent
