@component('mail::layout')
{{-- Header --}}
@slot('header')
@include('email.admin.includes.header')
@endslot

<style>
    .bordered-table {
        width: 100%;
        border-collapse: collapse;
    }
    .bordered-table th, .bordered-table td {
        border: 1px solid #dee2e6;
        padding: 0.75rem;
    }
</style>

{{-- Body --}}
<!-- Email Body -->
{{-- Greeting --}}
{{-- Greeting --}}
@if (! empty($greeting))
# {{ $greeting }}
@else
@if ($level === 'error')
# @lang('Whoops!')
@else
# Dear {{ $user->first_name.'  '.$user->last_name }},
@endif
@endif
<p>We are pleased to inform you that your podcast submissions have been approved! Below are the details of your approved submissions:</p>

{{-- Table --}}
<table class="bordered-table">
    <thead>
        <tr>
            <th>Podcast Name</th>
            <th>BAR Name</th>
            <th>BAR ID</th>
            <th>Submission Credits</th>
            <th>Submitted Date</th>
            <th>Approved Credits</th>
            <th>Date of Approval</th>
        </tr>
    </thead>
    <tbody>
        @foreach($submissions as $submission)
        <tr>
            <td>{{ $submission->podcast_title }}</td>
            <td>{{ $submission->state_name }}</td>
            <td>{{ $submission->podcast_bar_id }}</td>
            <td>{{ $submission->credits_submitted }}</td>
            <td>{{ $submission->created_at }}</td>
            <td>{{ $submission->credits_submitted }}</td>
            <td>{{ \Carbon\Carbon::parse($submission->approved_at)->format(config('app.datetime_format')) }}</td>
        </tr>
        @endforeach
    </tbody>
</table>
<br />            
<strong>Total Approved Credits: {{ $approved_credits }}</strong>
<br/>
<p>If you have any further questions or need assistance, feel free to reach out to us at <a href="mailto:support@clearly.legal ">support@clearly.legal</a> </p>

<strong>Important Note:</strong>
<p>The Date of Approval mentioned above reflects when the status of your submissions was updated in our local portal. This date may differ from the actual approval date by the respective BAR due to processing timelines. If you need the exact approval date from the BAR, please contact your BAR directly.</p>
<br />
<p>Best regards,<br />
@if (! empty($salutation))
<p>{{ $salutation }}</p>
@endif
{{-- Subcopy --}}
@isset($subcopy)
@slot('subcopy')
@component('mail::subcopy')
{{ $subcopy }}
@endcomponent
@endslot
@endisset
{{-- Footer --}}
@slot('footer')
@include('email.admin.includes.footer')
@endslot
@endcomponent
