@component('mail::layout')
{{-- Header --}}
@slot('header')
@include('email.admin.includes.header')
@endslot
{{-- Body --}}

{{-- Greeting --}}
@if (! empty($greeting))
# {{ $greeting }}
@else
@if ($level === 'error')
# @lang('Whoops!')
@endif
@endif
{{-- Intro Lines --}}
A customer is interested in contacting you.
<br>
<strong>Name:</strong> {{ $contact->first_name }}&nbsp;{{ $contact->last_name }} <br>
@empty(!$contact->subject)
<strong>Subject:</strong> {{ $contact->subject }} <br>
@endempty
<strong>Email:</strong> <a href="mailto:{{ $contact->email }}">{{ $contact->email }}</a> <br>
<strong>Page:</strong> <a href="{{ (@unserialize($contact->page) !== false) ? (unserialize($contact->page)['page']) ? unserialize($contact->page)['page'] : '' : '' }}" target="_blank" rel="noopener">{{ (@unserialize($contact->page) !== false) ? (unserialize($contact->page)['page_name']) ? unserialize($contact->page)['page_name'] : '' : '' }}</a><br>
@empty(!$contact->phone)
<strong>Phone:</strong> {{ formatPhoneNumber($contact->phone) }} <br>
@endempty
<strong>Message:</strong> {!! nl2br($contact->message) !!}<br>
@if (! empty($salutation))
<p>{{ $salutation }}</p>
@endif
{{-- Subcopy --}}
@isset($subcopy)
@slot('subcopy')
@component('mail::subcopy')
{{ $subcopy }}
@endcomponent
@endslot
@endisset
{{-- Footer --}}
@slot('footer')
@include('email.admin.includes.footer')
@endslot
@endcomponent
