@component('mail::layout')
{{-- Header --}}
@slot('header')
@include('email.admin.includes.header')
@endslot
{{-- Body --}}
<!-- Email Body -->
{{-- Greeting --}}
@if (! empty($greeting))
# {{ $greeting }}
@else
@if ($level === 'error')
# @lang('Whoops!')
@else
@endif
@endif
<p>
Dear {{ $firm_admin->fullname }},
</p>
<p>
    A new user, {{ $user->fullname }}, has requested to join your firm on {{ \Carbon\Carbon::parse($user->created_at)->format('d M Y') }}. They have entered the firm code {{ $user->firmcode }} and selected the following state bar(s):
</p>
@foreach (getUserBarsNeedTopay($user->id) as $bar)
<li>{{ $bar->state_name ?? 'N/A' }}</li>
@endforeach
<br/>
<p>
    To activate {{ $user->fullname }}'s account, you have two options:
</p>
<p>
    1. <b>Accept and Pay:</b> You can choose to cover the cost of {{ $user->fullname }}'s state bar membership(s) on behalf of the firm. This will activate their account immediately. The total cost will be ${{ retrieveTotalProductAmountByUser($user->id) }} for {{ getUserBarsNeedTopay($user->id)->count() }} state bar(s).
</p>
<p>
    2. <b>Accept without Pay:</b> You can choose to approve {{ $user->fullname }}'s request, but they will need to pay for their own state bar membership(s) within the app. They will receive instructions on how to make the payment upon your approval.
</p>
<p>
    To review and take action on {{ $user->fullname }}'s request, please log in to the firm admin portal:
</p>
<a href="{{ route('student.list') }}" class="button button-primary" target="_blank" rel="noopener" >@lang('Admin Portal')</a>



<p>
Best regards,<br/>The CLEarly Legal Team
</p>
{{-- Subcopy --}}
@isset($subcopy)
@slot('subcopy')
@component('mail::subcopy')
{{ $subcopy }}
@endcomponent
@endslot
@endisset
{{-- Footer --}}
@slot('footer')
@if (! empty($salutation))
{{ $salutation }}
@else
@include('email.admin.includes.footer')
@endif
@endslot
@endcomponent
