@component('mail::layout')
{{-- Header --}}
@slot('header')
@include('email.admin.includes.header')
@endslot
{{-- Body --}}
<!-- Email Body -->
{{-- Greeting --}}
@if (! empty($greeting))
# {{ $greeting }}
@else
@if ($level === 'error')
# @lang('Whoops!')
@else
@endif
@endif
<p>
Dear {{ $user->first_name }} {{ $user->last_name }},
</p>
<p>
    Welcome to Clearly Legal! We're thrilled to have you join us on behalf of {{ $firmname }}. Your firm will be taking care of the subscription, so you're just a step away from accessing premium features and content. To get started, please activate your account by clicking on the link below:
</p>
<p>
<a href="{{ $veryfy_link }}" class="button button-primary" target="_blank" rel="noopener" >@lang('Verify Email Address')</a>
</p>

<p>
    Once your account is activated, {{ $firmname }} will handle the subscription process on your behalf. If you have any questions or need assistance, our support team is here to help. Reach out to us at contact@clearly.legal.
</p>

<p>
    Thank you for being a part of Clearly Legal with {{ $firmname }}. We look forward to serving you both!
</p>

<p>
Best regards,<br/>The CLEarly Legal Team
</p>
{{-- Subcopy --}}
@isset($subcopy)
@slot('subcopy')
@component('mail::subcopy')
{{ $subcopy }}
@endcomponent
@endslot
@endisset
{{-- Footer --}}
@slot('footer')
@if (! empty($salutation))
{{ $salutation }}
@else
@include('email.admin.includes.footer')
@endif
@endslot
@endcomponent
