@component('mail::layout')
{{-- Header --}}
@slot('header')
@include('email.admin.includes.header')
@endslot
{{-- Body --}}
<!-- Email Body -->
{{-- Greeting --}}
@if (! empty($greeting))
# {{ $greeting }}
@else
@if ($level === 'error')
# @lang('Whoops!')
@else
@endif
@endif
<p>
Dear {{ $user->first_name }} {{ $user->last_name }},
</p>
<p>
    Welcome to Clearly Legal! We're excited to have you on board. To start enjoying our premium features and content, please activate your account by clicking on the link below:
</p>
<p>
<a href="https://app.clearly.legal" class="button button-primary" target="_blank" rel="noopener" >@lang('Activate Account')</a>
</p>

<p>
    Once your account is activated, you'll be prompted to proceed with the subscription payment process. Your commitment to Clearly Legal's offerings is greatly appreciated. If you have any questions or need assistance, feel free to reach out to our support team at contact@clearly.legal.
</p>

<p>
    Thank you for being a part of Clearly Legal. We look forward to serving you!
</p>

<p>
Best regards,<br/>The CLEarly Legal Team
</p>
{{-- Subcopy --}}
@isset($subcopy)
@slot('subcopy')
@component('mail::subcopy')
{{ $subcopy }}
@endcomponent
@endslot
@endisset
{{-- Footer --}}
@slot('footer')
@if (! empty($salutation))
{{ $salutation }}
@else
@include('email.admin.includes.footer')
@endif
@endslot
@endcomponent
