@component('mail::layout')
{{-- Header --}}
@slot('header')
@include('email.admin.includes.header')
@endslot

<style>
    .bordered-table {
        width: 100%;
        border-collapse: collapse;
    }
    .bordered-table th, .bordered-table td {
        border: 1px solid #dee2e6;
        padding: 0.75rem;
    }
</style>

{{-- Body --}}
<!-- Email Body -->
{{-- Greeting --}}
{{-- Greeting --}}
@if (! empty($greeting))
# {{ $greeting }}
@else
@if ($level === 'error')
# @lang('Whoops!')
@else
Hi {{ $user->first_name }},
@endif
@endif
<p>We hope you had a great week of learning and growing through our podcasts! Here’s your weekly activity summary:</p>


<span>🎙️</span> Podcasts You’ve Listened To:
@if (!empty($podcastsCL))
<table class="bordered-table">
    <tbody>
        @foreach ($podcastsCL as $pcl)
            <tr>
                <td>{{ $pcl->file_name }}</td>
            </tr>
        @endforeach
    </tbody>
</table>
@else
    <p>No podcasts listened to in the last week.</p>
@endif

<br>

<span>📌</span> Podcasts Yet to Submit for CLE Credit:
@if (!empty($podcastYetToSubmit))
<table class="bordered-table">
    <tbody>
        @foreach ($podcastYetToSubmit as $pyts)
            <tr>
                <td>{{ $pyts->file_name }}</td>
            </tr>
        @endforeach
    </tbody>
</table>
@else
    <p>No podcasts left to submit in the last week.</p>
@endif

<br>

<span>🏆</span> CLE Earned Last Week:
@if ($credits_earned != 0)
    {{ $credits_earned }} credits earned but not submitted
@else
    {{ $credits_earned }} earned credits
@endif


<strong></strong>
<p>Stay on top of your CLE goals by submitting the required forms for podcasts you’ve completed. If you’re looking for more learning opportunities, check out our latest podcast releases </p>
<ul>
@foreach ($latestPodcasts as $lps)
<li>
    <a href="{{ env('CL_APP_URL') }}">{{ $lps->file_name }}</a>
</li>
@endforeach
</ul>   
<br/> 

<p>Have questions? Reach out to us anytime at <a href="mailto:support@clearly.legal">support@clearly.legal</a>!</p>
<p>Happy listening,</p>
@if (! empty($salutation))
<p>{{ $salutation }}</p>
@endif
{{-- Subcopy --}}
@isset($subcopy)
@slot('subcopy')
@component('mail::subcopy')
{{ $subcopy }}
@endcomponent
@endslot
@endisset
{{-- Footer --}}
@slot('footer')
@include('email.admin.includes.footer')
@endslot
@endcomponent
