<?xml version="1.0" encoding="UTF-8"?>
<rss version="2.0" xmlns:itunes="http://www.itunes.com/dtds/podcast-1.0.dtd" xmlns:atom="http://www.w3.org/2005/Atom">
    <channel>
        <atom:link href="{{ env('APP_URL') }}/rss.xml" rel="self" type="application/rss+xml" />
        <title>CLEarly Legal</title>
        <link>{{ env('APP_URL') }}</link>
        <description>Clearly Legal, the future of legal learning is the official podcast of Clearly.Legal, a platform
            dedicated to empowering attorneys with curated content, meaningful conversations, and career guidance.
            In each episode, we explore the diverse dimensions of legal practice—from wellness and ethics to emerging
            trends in tech, DEI, litigation strategy, and professional development. Whether you’re a solo practitioner,
            law student, or part of a big firm, this show brings you insights and stories that matter.
            Hosted by seasoned legal minds. Powered by community. Inspired by clarity.
        </description>
        <copyright>© {{ date('Y') }} Clearly Legal, LLC. All rights reserved.</copyright>
        <language>en-us</language>
        <pubDate>{{ now()->toRssString() }}</pubDate>
        <lastBuildDate>{{ now()->toRssString() }}</lastBuildDate>
        <image>
            <url>{{ asset('assets/web/images/logo/CLELogo.png') }}</url>
            <title>CLEarly Legal</title>
            <link>{{ env('APP_URL') }}</link>
        </image>
        <itunes:explicit>no</itunes:explicit>
        <itunes:type>episodic</itunes:type>
        <itunes:subtitle />
        <itunes:author>Sean Martin, Joel Surber</itunes:author>
        <itunes:summary>Clearly Legal, the future of legal learning is the official podcast of Clearly.Legal, a platform
            dedicated to empowering attorneys with curated content, meaningful conversations, and career guidance.
            In each episode, we explore the diverse dimensions of legal practice—from wellness and ethics to emerging
            trends in tech, DEI, litigation strategy, and professional development. Whether you’re a solo practitioner,
            law student, or part of a big firm, this show brings you insights and stories that matter.
            Hosted by seasoned legal minds. Powered by community. Inspired by clarity.
        </itunes:summary>
        <itunes:owner>
            <itunes:name>Sean Martin</itunes:name>
            <itunes:email>sean@seanjmartin.com</itunes:email>
        </itunes:owner>
        <itunes:image href="{{ asset('assets/player/assets/podcast_placeholder_square.svg') }}" />
        <itunes:category text="Business" />
        <itunes:category text="Education" />
        <itunes:category text="Society &amp; Culture" />
        @foreach ($contents as $content)
            @php
                $activeSpeakers = collect($content->speakers)
                    ->filter(function ($speaker) {
                        return optional($speaker->speaker)->status == 1;
                    })
                    ->values(); // reindex
            @endphp
            <item>
                <title>
                    <![CDATA[{{ $content->podcast_title }}]]>
                </title>
                <link>{{ route('library.show', $content->title_crc32) }}</link>
                <description>
                    <![CDATA[{{ $content->short_description }}]]>
                </description>
                <guid isPermaLink="true">{{ route('library.show', $content->title_crc32) }}</guid>
                <pubDate>{{ \Carbon\Carbon::createFromFormat('m/d/Y g:i a', $content->created_at)->toRssString() }}
                </pubDate>
                <itunes:author>@foreach ($activeSpeakers as $key => $speaker)@if ($speaker->speaker->status == 1){{ optional($speaker->speaker)->name ?? '' }}@if ($key !== count($activeSpeakers) - 1 && $speaker->speaker->status == 1 && count($activeSpeakers) > 1),@endif @endif @endforeach
                </itunes:author>
                <itunes:summary>{{ strip_tags(html_entity_decode($content->short_description)) }}</itunes:summary>
                <itunes:duration>{{ minutesToSeconds($content->lengthOfPodcast()) }}</itunes:duration>
                <itunes:explicit>no</itunes:explicit>
                <itunes:image href="{{ asset($content->image_path) }}" />
                @if (!$content->contentFiles->isEmpty())
                    <enclosure
                        url="{{ route('secure.web.audio', ['filePath' => Crypt::encryptString($content->contentFiles->first()->file)]) }}"
                        length="{{ round(optional($content->contentFiles->first())->size) }}" type="audio/mpeg" />
                @endif
            </item>
        @endforeach
    </channel>
</rss>
