@foreach ($contents as $content)
    @if (!$content == null)
        <li data-category="{{ $content->category }}">
            <a href="{{ route('library.show', $content->title_crc32) }}">
                <div class="podcast">
                    <div class="podcast_ctn">
                        <div class="podcast_scroll">
                            <div class='podcast_title'>{{ $content->podcast_title }}</div>
                        </div>

                        <h6>{{ $content->speakers }}</h6>

                        <div class="podcast_detail d-block podcast_detail_first">
                            <div class="badge_block">
                                <div class="badges d-inline-block">
                                    {{ config('cl_type')[$content->cl_type] }}
                                </div>
                            </div>
                            <div class="podcast_time d-inline-block">
                                {{ $content->lengthOfPodcast }} mins
                            </div>
                            <div class="podcast_credit d-inline-block">
                                {{ $content->totalCreditsOfPodcast }} credits
                            </div>
                            <div class="podcast_date d-inline-block">
                                {{ \Carbon\Carbon::parse($content->published_on)->format('M d, Y') }}
                            </div>
                        </div>

                    </div>
                </div>
            </a>
            @if (!$content->contentFiles->isEmpty())
                <a href="#" data-toggle="modal" data-target="#playerconfig" class="podcast_detail_view share-btn"
                    data-content-id="{{ $content->id }}"
                    data-content-file-id="{{ optional($content->contentFiles->first())->id }}"
                    data-podcast-title='{{ $content->podcast_title }}'
                    data-podcast-length="{{ optional($content->contentFiles->first())->length }}"
                    data-podcast-speakers="{{ $content->speakers }}"
                    data-file="{{ optional($content->contentFiles->first())->file }}"><img
                        src="{{ asset('assets/web/images/icons/share.svg') }}" class="img-fluid"></a>
            @endif
        </li>
    @endif
@endforeach
