<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    @if(!empty($content->meta_title) && ( empty($content->slug) || (!empty($content->slug) && $content->slug != '/' )))
    <title>{{ $content->meta_title }} | {{ siteconfig('site_title') }}
        {{ !empty(siteconfig('tagline')) ? ' - '.siteconfig('tagline') : '' }}</title>
    <meta property="og:title"
        content="{{ $content->meta_title }} | {{ siteconfig('site_title') }}{{ !empty(siteconfig('tagline')) ? ' - '.siteconfig('tagline') : '' }}" />
    @elseif(!empty($content->title) && ( empty($content->slug) || (!empty($content->slug) && $content->slug != '/' )))
    <title>{{ $content->title }} | {{ siteconfig('site_title') }}
        {{ !empty(siteconfig('tagline')) ? ' - '.siteconfig('tagline') : '' }}</title>
    <meta property="og:title"
        content="{{ $content->title }} | {{ siteconfig('site_title') }}{{ !empty(siteconfig('tagline')) ? ' - '.siteconfig('tagline') : '' }}" />
    @else
    <title>{{ siteconfig('site_title') }}{{ !empty(siteconfig('tagline')) ? ' - '.siteconfig('tagline') : '' }}</title>
    <meta property="og:title"
        content="{{ siteconfig('site_title') }}{{ !empty(siteconfig('tagline')) ? ' - '.siteconfig('tagline') : '' }}" />
        <meta property="og:image" content="{{ asset('assets/common/images/img_social_og.jpg') }}" />
    @endif

    @php
    $meta_desc = '';
    if(!empty($content->meta_desc) && isset($content->meta_desc)){
    $meta_desc = $content->meta_desc;
    }
    if(!empty($content->meta_description) && isset($content->meta_description))
    {
    $meta_desc = $content->meta_description;
    }
    @endphp
    @if(!empty($meta_desc))
    <meta name="description" content="{{ $meta_desc }}" />
    <meta property="og:description" content="{{ $meta_desc }}" />
    @elseif(!empty(siteconfig('meta_description_for_front')))
    <meta name="description" content="{{ siteconfig('meta_description_for_front') }}" />
    <meta property="og:description" content="{{ siteconfig('meta_description_for_front') }}" />
    @endif
    <meta property="og:site_name" content="{{ siteconfig('site_title') }}" />
    @if(!empty($content->main_image) && in_array(Route::currentRouteName(),['category.blog.show','blog.show']))
    <script type='text/javascript'
        src='https://platform-api.sharethis.com/js/sharethis.js#property=5dd4e53c12574600123b5505&product=inline-share-buttons&cms=sop'
        async='async'></script>

    <meta property="og:type" content="blog" />
    <meta property="og:image" content="{{ getImageUrl($content->main_image, 'blog')  }}" />
    @php
    $recomadationData = getImageRecommandedDataByModuleName('blog');
    @endphp
    <meta property="og:image:width" content="{{ $recomadationData['width'] }}" />
    <meta property="og:image:height" content="{{ $recomadationData['height'] }}" />
    <meta property="og:url" content="{{ url()->current() }}" />
    @endif
    {!! siteconfig('robots_meta_tag') !!}
    {!! siteconfig('google_analytics_code') !!}

    <link href="{{ asset('assets/web/images/logo/favicon.png') }}" rel="icon">
    <link href="{{ asset('assets/web/images/logo/apple-touch-icon.png') }}" rel="apple-touch-icon">




    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- Main CSS -->
    <link href="{{ asset('assets/front/css/ddscss.css') }}" type="text/css" rel="stylesheet" />


    <!-- Script Start -->
    <!-- App JS -->
    <script src="{{ asset('app.js') }}"></script>
</head>
