<div class="collapse navbar-collapse" id="navbarNavAltMarkup">
    <ul class="navbar-nav ml-auto align-items-lg-center">
        @if(isset($pages) && count($pages) > 0)
        <li class="nav-item dropdown {{isAdminActiveMenu('pageshow','') ? 'active' : ''}}">
            <a class="nav-link dropdown-toggle" id="pages" href="javascript:void(0)" data-toggle="dropdown"
                aria-haspopup="true" aria-expanded="false">PAGES</a>
            <div class="dropdown-menu" aria-labelledby="pages">
                @foreach ($pages as $page)
                <a class="nav-link " href="{{ route('pageshow',$page->slug) }}">{{ $page->title }}</a>
                @endforeach
            </div>
        </li>
        @endif
        
        {{-- frontend User login links end --}}
        <li class="nav-item d-flex justify-content-center">
            @if(!empty(siteconfig("facebook_link")))
            <a href="{{siteconfig('facebook_link')}}" title="@lang('facebook')"
                class="top-social-icon d-flex align-items-center justify-content-center" target="_blank" rel="noopener">
                <img class="svg m-2" src="{{ asset('assets/front/images/svg/icon_fb.svg')}}" alt="Facebook" />
            </a>
            @endif

            @if(!empty(siteconfig("twitter_link")))
            <a href="{{siteconfig('twitter_link')}}" title="@lang('twitter')"
                class="top-social-icon d-flex align-items-center justify-content-center" target="_blank" rel="noopener">
                <img class="svg m-2" src="{{ asset('assets/front/images/svg/icon_twitter.svg')}}" alt="Twitter" />
            </a>
            @endif

            @if(!empty(siteconfig("linkedin_link")))
            <a href="{{siteconfig('linkedin_link')}}" title="@lang('linkedin')"
                class="top-social-icon d-flex align-items-center justify-content-center" target="_blank" rel="noopener">
                <span class="icon-linkedin"><img class="svg m-2"
                        src="{{ asset('assets/front/images/svg/icon_linkedIn.svg')}}" alt="linkedin" /></span>
            </a>
            @endif
        </li>
    </ul>
</div>
