@extends('front.layouts.mobile_app')
@section('content')
@empty(!$content->banner)
<div class="main-banner">
    <div id="carouselExampleCaptions" class="carousel slide" data-ride="carousel">
        <div class="carousel-inner">
            <div class="carousel-item active">
				<div class="embed-responsive embed-responsive-16by9">
				<picture>
					<source media="(max-width:680px)" srcset="{{ getImageUrl($content->banner, 'banner' ,'fit-mobile') }}">
					<source media="(max-width:1024px)" srcset="{{ getImageUrl($content->banner, 'banner','fit-ipad') }}">
					<source media="(max-width:1440px)" srcset="{{ getImageUrl($content->banner, 'banner','fit-laptop') }}">
					<img src="{{ getImageUrl($content->banner, 'banner', 'fit-setting') }}" class="d-block w-100 embed-responsive-item" alt="{{ !empty($content->banner_alt) ? $content->banner_alt : $content->title }}">
				</picture>	
                
				
                @empty(!$content->banner_content)
                    <div class="carousel-caption d-none d-md-flex flex-column justify-content-center text-left h-100">
                        {!! $content->banner_content !!}
                    </div>
                @endempty
				</div>
            </div>
        </div>
        <div class="carousel-navigation">
            <a class="carousel-control-prev" href="#carouselExampleCaptions" role="button" data-slide="prev">
                <span class="icon-arrow_back"></span>
            </a>
            <a class="carousel-control-next" href="#carouselExampleCaptions" role="button" data-slide="next">
                <span class="icon-arrow_forward"></span>
            </a>
        </div>
    </div>
    <div class="mouse-holder">
        <a href="javascript:void(0)" class="mouse-icon"></a>
    </div>
</div>
@endempty
@if(!empty($content->title))
    <div class="container">
        <h1 class="mt-5">{!! $content->title !!}</h1>
    </div>
@endif
@if ($content->description != NULL)
<div class="container py-2 cms-default">
    {!! $content->description !!}
</div>
@endif
<!-- Note: Bellow code is for adding new section like contact or FAQ with page. For that we have to add in module columns of page record like ["front.modules.section.contact"] -->
@if ($content->modules != NULL)
@foreach ($content->modules as $module)
@includeIf($module)
@endforeach
@endif
@endsection