@extends('front.modules.player.includes.master')
@section('playercontent')
    <div class="player-mini-width">
        <div class="musicplayer bg_white clearfix">
            <div class="placeholder">
                <div class="placeholder_image loader-bg">
                    <img src="{{ asset('assets/player/assets/podcast_placeholder_square.svg')}}" alt="" class="img-fluid ">
                    <span class="loader" id="audioLoader" ></span>
                </div>
                <a href="{{ env('APP_URL') }}" target="__blank" class="logo"> <img src="{{ asset('assets/player/assets/logo/logo_whitebg.svg')}}"></a>

            </div>
            <div class="song_info text-white">
                <h3>{{ $podcastTitle }}</h3>
                <p>{{ $podcastSpeakers }}</p>

                <audio id="song" preload="auto">
                    <source src="{{ route('secure.audio', ['token' => $token]) }}" type="audio/mp3">
                </audio>
                <div class="rangeslider">
                    <input type="range" value="0" step="" id="progress" class="range" />
                </div>
                <div class="timer">
                    <div class="left"></div>
                    <div class="right">{{ secondsToMinuteSecond($podcastLength) }}</div>
                </div>


                <div class="volume_controls">
                    <div class="volume-chooser">
                        <div class="volume-button"><i class="fa fa-volume-up"></i></div>
                        <div class="volume-control">
                            <input class="volume" type="range" value="100" max="100" />
                        </div>
                    </div>
                </div>

                <div class="controls">
                    <div onclick="rewind()" class="rewindbtn">
                        <svg width="20" height="20" viewBox="0 0 30 30" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M12.6789 9.21436C12.8553 9.29917 13.0041 9.43206 13.1083 9.59774C13.2124 9.76343 13.2677 9.95516 13.2677 10.1509V19.8484C13.2677 20.1239 13.1582 20.3882 12.9633 20.583C12.7685 20.7779 12.5042 20.8874 12.2286 20.8874C11.9531 20.8874 11.6888 20.7779 11.4939 20.583C11.2991 20.3882 11.1896 20.1239 11.1896 19.8484V12.312L9.41498 13.7334C9.30837 13.8186 9.18601 13.882 9.0549 13.92C8.92379 13.9579 8.78649 13.9697 8.65084 13.9546C8.51518 13.9394 8.38383 13.8978 8.26429 13.8319C8.14475 13.766 8.03935 13.6772 7.95412 13.5706C7.86889 13.464 7.80549 13.3417 7.76754 13.2105C7.72959 13.0794 7.71784 12.9421 7.73296 12.8065C7.76348 12.5325 7.90159 12.2819 8.1169 12.1098L11.5803 9.33904C11.7331 9.21697 11.9173 9.1405 12.1116 9.11844C12.306 9.09639 12.5026 9.12963 12.6789 9.21436ZM15.9345 10.2949C16.0495 9.95052 16.2699 9.65097 16.5645 9.43866C16.8591 9.22635 17.213 9.11202 17.5761 9.11185H21.2334C21.509 9.11185 21.7733 9.22131 21.9681 9.41617C22.163 9.61102 22.2725 9.8753 22.2725 10.1509C22.2725 10.4264 22.163 10.6907 21.9681 10.8856C21.7733 11.0804 21.509 11.1899 21.2334 11.1899H17.8255L17.1328 13.2679H18.4627C19.4731 13.2679 20.4422 13.6693 21.1566 14.3838C21.8711 15.0982 22.2725 16.0672 22.2725 17.0776C22.2725 18.088 21.8711 19.0571 21.1566 19.7715C20.4422 20.486 19.4731 20.8874 18.4627 20.8874H15.692C15.4165 20.8874 15.1522 20.7779 14.9573 20.583C14.7625 20.3882 14.653 20.1239 14.653 19.8484C14.653 19.5728 14.7625 19.3085 14.9573 19.1137C15.1522 18.9188 15.4165 18.8093 15.692 18.8093H18.4627C18.922 18.8093 19.3625 18.6269 19.6872 18.3021C20.012 17.9774 20.1944 17.5369 20.1944 17.0776C20.1944 16.6184 20.012 16.1779 19.6872 15.8531C19.3625 15.5284 18.922 15.3459 18.4627 15.3459H16.6535C16.3791 15.346 16.1087 15.2808 15.8644 15.1558C15.6202 15.0308 15.4092 14.8495 15.2487 14.627C15.0883 14.4044 14.983 14.1469 14.9416 13.8757C14.9001 13.6045 14.9237 13.3273 15.0104 13.067L15.9345 10.2949Z"
                                fill="#282147" />
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M0.702567 16.04C0.525581 15.9565 0.375784 15.8247 0.270424 15.6598C0.165063 15.4948 0.108423 15.3035 0.107026 15.1078C0.101491 14.0882 0.193585 13.0947 0.383306 12.1272C1.71388 5.32086 7.68496 0.159992 14.8914 0.107818C23.116 0.0482728 29.8318 6.66754 29.8914 14.8922C29.9509 23.1168 23.3317 29.8326 15.107 29.8922C8.99777 29.9364 3.72494 26.2964 1.39001 21.0557C1.32953 20.9304 1.29484 20.7942 1.28798 20.6553C1.28112 20.5163 1.30224 20.3774 1.35009 20.2467C1.39794 20.1161 1.47154 19.9964 1.56652 19.8947C1.66151 19.7931 1.77595 19.7115 1.90305 19.6549C2.03015 19.5983 2.16732 19.5678 2.30643 19.5652C2.44554 19.5626 2.58375 19.588 2.71286 19.6399C2.84198 19.6917 2.95936 19.7689 3.05806 19.867C3.15676 19.9651 3.23476 20.082 3.28742 20.2107C4.22679 22.3213 5.71921 24.1386 7.60677 25.4705C9.49433 26.8024 11.7068 27.5992 14.0101 27.7767C16.3135 27.9542 18.6219 27.5057 20.6912 26.4788C22.7606 25.4519 24.5138 23.8846 25.7655 21.9429C27.0171 20.0012 27.7206 17.7573 27.8014 15.4486C27.8823 13.1398 27.3375 10.8522 26.2248 8.82769C25.1121 6.80319 23.4728 5.11713 21.4804 3.94793C19.488 2.77873 17.2165 2.16988 14.9064 2.1858C12.1731 2.20601 9.51785 3.0992 7.32803 4.73503C5.1382 6.37086 3.52846 8.6637 2.73372 11.279L4.58173 11.2656C4.7972 11.2638 5.0079 11.329 5.18467 11.4522C5.36144 11.5754 5.49553 11.7505 5.56837 11.9533C5.64121 12.1561 5.6492 12.3765 5.59124 12.5841C5.53328 12.7916 5.41223 12.976 5.24485 13.1117L1.80161 15.9074C1.64954 16.0308 1.46568 16.1088 1.27122 16.1323C1.07677 16.1557 0.879636 16.1238 0.702567 16.04Z"
                                fill="#282147" />
                        </svg>


                    </div>
                    <div onclick="playPause()" id="playbutton">
                        <i class="fa-solid fa-play" id="ctrlIcon"></i>
                    </div>
                    <div onclick="forward()" class="forwardbtn">

                        <svg width="20" height="20" viewBox="0 0 30 30" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M12.6789 9.21436C12.8553 9.29917 13.0041 9.43206 13.1083 9.59774C13.2124 9.76343 13.2677 9.95516 13.2677 10.1509V19.8484C13.2677 20.1239 13.1582 20.3882 12.9633 20.583C12.7685 20.7779 12.5042 20.8874 12.2286 20.8874C11.9531 20.8874 11.6888 20.7779 11.4939 20.583C11.2991 20.3882 11.1896 20.1239 11.1896 19.8484V12.312L9.41498 13.7334C9.30837 13.8186 9.18601 13.882 9.0549 13.92C8.92379 13.9579 8.78649 13.9697 8.65084 13.9546C8.51518 13.9394 8.38383 13.8978 8.26429 13.8319C8.14475 13.766 8.03935 13.6772 7.95412 13.5706C7.86889 13.464 7.80549 13.3417 7.76754 13.2105C7.72959 13.0794 7.71784 12.9421 7.73296 12.8065C7.76348 12.5325 7.90159 12.2819 8.1169 12.1098L11.5803 9.33904C11.7331 9.21697 11.9173 9.1405 12.1116 9.11844C12.306 9.09639 12.5026 9.12963 12.6789 9.21436ZM15.9345 10.2949C16.0495 9.95052 16.2699 9.65097 16.5645 9.43866C16.8591 9.22635 17.213 9.11202 17.5761 9.11185H21.2334C21.509 9.11185 21.7733 9.22131 21.9681 9.41617C22.163 9.61102 22.2725 9.8753 22.2725 10.1509C22.2725 10.4264 22.163 10.6907 21.9681 10.8856C21.7733 11.0804 21.509 11.1899 21.2334 11.1899H17.8255L17.1328 13.2679H18.4627C19.4731 13.2679 20.4422 13.6693 21.1566 14.3838C21.8711 15.0982 22.2725 16.0672 22.2725 17.0776C22.2725 18.088 21.8711 19.0571 21.1566 19.7715C20.4422 20.486 19.4731 20.8874 18.4627 20.8874H15.692C15.4165 20.8874 15.1522 20.7779 14.9573 20.583C14.7625 20.3882 14.653 20.1239 14.653 19.8484C14.653 19.5728 14.7625 19.3085 14.9573 19.1137C15.1522 18.9188 15.4165 18.8093 15.692 18.8093H18.4627C18.922 18.8093 19.3625 18.6269 19.6872 18.3021C20.012 17.9774 20.1944 17.5369 20.1944 17.0776C20.1944 16.6184 20.012 16.1779 19.6872 15.8531C19.3625 15.5284 18.922 15.3459 18.4627 15.3459H16.6535C16.3791 15.346 16.1087 15.2808 15.8644 15.1558C15.6202 15.0308 15.4092 14.8495 15.2487 14.627C15.0883 14.4044 14.983 14.1469 14.9416 13.8757C14.9001 13.6045 14.9237 13.3273 15.0104 13.067L15.9345 10.2949Z"
                                fill="#282147" />
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M29.2974 16.04C29.4744 15.9565 29.6242 15.8247 29.7296 15.6598C29.8349 15.4948 29.8916 15.3035 29.893 15.1078C29.8985 14.0882 29.8064 13.0947 29.6167 12.1272C28.2861 5.32086 22.315 0.159992 15.1086 0.107818C6.88397 0.0482728 0.168155 6.66754 0.10861 14.8922C0.0490644 23.1168 6.66833 29.8326 14.893 29.8922C21.0022 29.9364 26.2751 26.2964 28.61 21.0557C28.6705 20.9304 28.7052 20.7942 28.712 20.6553C28.7189 20.5163 28.6978 20.3774 28.6499 20.2467C28.6021 20.1161 28.5285 19.9964 28.4335 19.8947C28.3385 19.7931 28.2241 19.7115 28.097 19.6549C27.9699 19.5983 27.8327 19.5678 27.6936 19.5652C27.5545 19.5626 27.4163 19.588 27.2871 19.6399C27.158 19.6917 27.0406 19.7689 26.9419 19.867C26.8432 19.9651 26.7652 20.082 26.7126 20.2107C25.7732 22.3213 24.2808 24.1386 22.3932 25.4705C20.5057 26.8024 18.2932 27.5992 15.9899 27.7767C13.6865 27.9542 11.3781 27.5057 9.30875 26.4788C7.23942 25.4519 5.48617 23.8846 4.23454 21.9429C2.98291 20.0012 2.27945 17.7573 2.19859 15.4486C2.11773 13.1398 2.66248 10.8522 3.7752 8.82769C4.88792 6.80319 6.52721 5.11713 8.51963 3.94793C10.512 2.77873 12.7835 2.16988 15.0936 2.1858C17.8269 2.20601 20.4821 3.0992 22.672 4.73503C24.8618 6.37086 26.4715 8.6637 27.2663 11.279L25.4183 11.2656C25.2028 11.2638 24.9921 11.329 24.8153 11.4522C24.6386 11.5754 24.5045 11.7505 24.4316 11.9533C24.3588 12.1561 24.3508 12.3765 24.4088 12.5841C24.4667 12.7916 24.5878 12.976 24.7552 13.1117L28.1984 15.9074C28.3505 16.0308 28.5343 16.1088 28.7288 16.1323C28.9232 16.1557 29.1204 16.1238 29.2974 16.04Z"
                                fill="#282147" />
                        </svg>
                    </div>
                </div>

                <span class="tooltip"
                    data-tooltip=" Disclaimer: Listening to this podcast will not earn you any credit. If you want to earn credits, login to clearly.legal and start listening the podcast. "
                    data-tooltip-pos="left" data-tooltip-length="medium"> <i class="fa fa-info"></i></span>
            </div>
        </div>
    </div>
@endsection
