<!-- Modal -->
<div class="modal fade d-example-modal-lg podcast-modal" id="playerconfig" tabindex="-1"
    aria-labelledby="exampleModalLabel" aria-hidden="true" role="dialog">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Share Podcast</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="playerConfigForm">
                @csrf
                <input type="hidden" name="content_id" id="content_id">
                <input type="hidden" name="content_file_id" id="content_file_id">
                <input type="hidden" name="podcast_title" id="podcast_title">
                <input type="hidden" name="podcast_length" id="podcast_length">
                <input type="hidden" name="podcast_speakers" id="podcast_speakers">
                <input type="hidden" name="file" id="file">

                <div class="modal-body">
                    <div class="row">
                        <div class="col-xl-7 col-lg-7 col-sm-12">
                            <div class="toggle_group">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="toggle_label">
                                            <img src="{{ asset('assets/web/images/icons/Size.svg') }}" />
                                            <span> Podcast Size</span>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <fieldset class="radio-switch">
                                            @foreach (config('player_sizes') as $key => $size)
                                                <input type="radio" id="size_{{ $key }}" name="player_size"
                                                    value="{{ $key }}" checked />
                                                <label for="size_{{ $key }}">{{ $size }}</label>
                                            @endforeach
                                        </fieldset>
                                        <span class="error-text" id="player_size_error"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="toggle_group">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="toggle_label">
                                            <img src="{{ asset('assets/web/images/icons/theme.svg') }}" />
                                            <span> Podcast Theme</span>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <fieldset class="radio-switch">
                                            @foreach (config('player_themes') as $key => $theme)
                                                <input type="radio" id="theme_{{ $key }}" name="player_theme"
                                                    value="{{ $key }}" checked />
                                                <label for="theme_{{ $key }}">{{ $theme }}</label>
                                            @endforeach
                                        </fieldset>
                                        <span class="error-text" id="player_theme_error"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="toggle_group clearfix mb-0">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="toggle_label">
                                            <img src="{{ asset('assets/web/images/icons/Embed.svg') }}" />
                                            <span> Embed code</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="text-wrap my-4">
                                    <textarea id="embedCodeTextarea" readonly class="form-control .embed-text" rows="9"></textarea>
                                    <div class="clipboard fa fa-copy copyEmbedBtn"></div>
                                </div>
                                <button type="button" class="btn btn-primary fa-pull-right copybtn copyEmbedBtn">
                                    Copy
                                </button>
                                {{-- <button type="submit" class="btn btn-primary">Save changes</button> --}}
                            </div>
                        </div>
                        <div class="col-xl-5 col-lg-5 col-sm-12 preview-tab d-flex flex-column">
                            <h5>Preview</h5>
                            <div class="row" style="height: 100%;">
                                {{-- <img src="" alt="" class="img-fluid"
                                    style="max-height: 100%; object-fit: contain;"> --}}
                                <div class="embed_iframe w-100" style="pointer-events: none"></div>
                            </div>
                        </div>
                    </div>
                </div>
                {{-- <div class="modal-footer">
                    <textarea id="embedCodeTextarea" class="form-control" rows="3" readonly style="display:none;"></textarea>
                    <button type="button" id="copyEmbedBtn" class="btn btn-secondary" style="display:none;">Copy Embed
                        Code</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div> --}}
            </form>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        function savePlayerConfig() {
            var playerSize = $("input[name='player_size']:checked").val();
            var playerTheme = $("input[name='player_theme']:checked").val();

            if (!playerSize || !playerTheme) {
                return;
            }

            var url = "{{ route('share-config') }}";
            var formData = $("#playerConfigForm").serialize();

            // Show loader in textarea
            $("#embedCodeTextarea").val("").addClass("loading");

            $.ajax({
                type: "POST",
                url: url,
                data: formData,
                success: function(response) {
                    console.log("Player configuration saved successfully!");
                    $(".preview-tab img").attr("src", response.previewImage);
                    $(".embed_iframe").html(response.embed_code);
                    $("#embedCodeTextarea").val(response.embed_code).removeClass("loading").show();
                    $(".copyEmbedBtn").show();
                    $('.error-text').hide();
                },

                error: function() {
                    console.error("Failed to save configuration. Please try again.");
                    $("#embedCodeTextarea").val("Error retrieving data").removeClass("loading");
                }
            });
        }

        $(".share-btn").click(function() {
            var contentId = $(this).data("content-id");
            var contentFileId = $(this).data("content-file-id");
            var podcastTitle = $(this).data("podcast-title");
            var podcastLength = $(this).data("podcast-length");
            var podcastSpeakers = $(this).data("podcast-speakers");
            var file = $(this).data("file");

            $("#content_id").val(contentId);
            $("#content_file_id").val(contentFileId);
            $("#podcast_title").val(podcastTitle);
            $("#podcast_length").val(podcastLength);
            $("#podcast_speakers").val(podcastSpeakers);
            $("#file").val(file);

            savePlayerConfig();
        });

        $("#playerconfig").on("shown.bs.modal", function() {
            savePlayerConfig();
        });

        $("input[name='player_size'], input[name='player_theme']").change(function() {
            savePlayerConfig();
        });

        $("#playerConfigForm").on("submit", function(event) {
            event.preventDefault();
            savePlayerConfig();
        });

        $(".copyEmbedBtn").click(function() {
            var embedCode = $("#embedCodeTextarea").val();
            navigator.clipboard.writeText(embedCode).then(() => {
                toastr.success("Embed code copied!");
                $("#playerconfig .close").click();
            });
        });

        $("#playerconfig .close").click(function() {
            // Attempt to pause audio/video inside same-origin iframes
            document.querySelectorAll("iframe").forEach(function(iframe) {
                try {
                    const iframeDoc = iframe.contentDocument || iframe.contentWindow.document;
                    iframeDoc.querySelectorAll("audio, video").forEach(function(media) {
                        media.pause();
                        media.currentTime = 0;
                    });
                } catch (err) {
                    console.warn("Can't access iframe media:", err);
                }
            });
        });
    });
</script>
