@extends('front.layouts.app')
@section('content')
    <section class="innerpage_wrap about_wrap">
        <div class="container">

            @foreach ($pages as $page)
                @if ($page->slug == 'about-us')
                    {!! $page->description !!}
                @endif
            @endforeach

        </div>
    </section>



    <section class="section-height  pt-5 about_wrap">
        <div class="container">

            @foreach ($members as $member)
                @if ($loop->iteration % 2 != 0)
                    <div class="row align-items-center facultybox pb-4">
                        <div class="col-sm-4">
                            <div class="faculty_left">
                                <div class="faculty_box">
                                    {{-- <div class="faculty_left_block"><img
                                            src="{{ asset('assets/web/images/faculty/faculty_left_block.png') }}"
                                            alt="faculty_left_block" class="">
                                    </div> --}}
                                    <div class="faculty_box_in">

                                        <img src="{{ $member->image_path }}" alt="Sean"
                                            class="img-fluid mx-auto d-block faculty_image">
                                    </div>

                                </div>
                                {{-- <img src="{{ asset('assets/web/images/faculty/faculty_left_main_bg.png') }}" alt=""
                                    class="img-fluid mx-auto d-block"> --}}
                            </div>

                        </div>
                        <div class="col-sm-8">
                            <h5 class="py-2">{{ $member->name }}</h5>
                            {!! $member->description !!}
                        </div>
                    </div>
                @else
                    <div class="row align-items-center facultybox pb-4">
                        <div class="col-sm-4">
                            <div class="faculty_right">
                                <div class="faculty_box">
                                    {{-- <div class="faculty_right_block"><img
                                            src="{{ asset('assets/web/images/faculty/faculty_right_block.png') }}"
                                            alt="faculty_left_block" class="">
                                    </div> --}}
                                    <div class="faculty_box_in">

                                        <img src="{{ $member->image_path }}" alt="Joel"
                                            class="img-fluid mx-auto d-block faculty_image">
                                    </div>

                                </div>
                                {{-- <img src="{{ asset('assets/web/images/faculty/faculty_right_main_bg.png') }}" alt=""
                                    class="img-fluid mx-auto d-block"> --}}
                            </div>
                        </div>
                        <div class="col-sm-8">
                            <h5 class="py-2">{{ $member->name }}</h5>
                            {!! $member->description !!}
                        </div>
                    </div>
                @endif
            @endforeach
        </div>
    </section>

    @if (!$releases->isEmpty())
        <section class="section-height pt-0 about_press_wrap">

            <div class="container">
                <div class="row text-center mb-5">
                    <div class="col-sm-12">
                        <div class="common-heading ">
                            <h2>See What The Press Says About CLEarly</h2>

                        </div>
                    </div>
                </div>

                <div class="row">
                    @foreach ($releases as $index => $release)
                        <div class="col-sm-4 
                               {{ count($releases) === 1 ? 'mx-auto' : '' }}"
                            {{-- Center align if there's only one release --}}>
                            <div class="releasebox">
                                <a href="{{ route('press') }}">
                                    <img src="{{ $release->image_path }}" class="img-fluid mx-auto d-block"
                                        alt="Release image">
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>

            </div>
        </section>
    @endif

    <section class="bottom_line mb-5">
        <img src="{{ asset('assets/web/images/background/course_bottom_line.png') }}" width="" height="" class=" mx-auto d-block"
            alt="course_bottom_line">
    </section>

    <!-- ======= Subscribe Section ======= -->
    @include('front.modules.subscribe.index')
    <!-- End Subscribe Section -->

    <!-- ======= Account Section ======= -->
    @include('front.modules.contact.index')
    <!-- End Contact Section -->
@endsection
