@extends('front.layouts.app')
@section('content')
    <section class="speaker_detail_wrap section-height">

        <div class="container">

            <div class="row align-items-start speaker_detailbox facultybox">
                <div class="col-sm-4 order-sm-2">
                    <div class="faculty_left">
                        <div class="faculty_box">
                            {{-- <div class="faculty_left_block"><img
                                    src="{{ asset('assets/web/images/faculty/faculty_left_block.png') }}"
                                    alt="faculty_left_block" class="">
                            </div> --}}
                            <div class="faculty_box_in">

                                <img src="{{ asset($faculty->image_path) }}" alt="Sean"
                                    class="img-fluid mx-auto d-block faculty_image">
                            </div>

                        </div>
                        {{-- <img src="{{ asset('assets/web/images/faculty/faculty_left_main_bg.png') }}" alt=""
                            class="img-fluid mx-auto d-block"> --}}
                    </div>

                </div>
                <div class="col-sm-8 order-sm-1">
                    <h3>{{ $faculty->name }} @if (!empty($faculty->profile_url))
                        <a href="{{ $faculty->profile_url }}" target="_blank">
                            <span class="material-symbols-outlined">link</span>
                        </a>
                    @endif</h3>
                    <h5 class="pb-2">{{ $faculty->firm_name }}</h5>
                    <p>{!! $faculty->description !!}</p>


                    {{-- <a href="{{ $faculty->profile_url }}" target="_blank" class="btn btn-primary">View More</a> --}}
                </div>
            </div>

            <hr>

            @if (!$contents->isEmpty() && !is_null($contents) && optional($contents->filter())->isNotEmpty())
                <div class="speaker_btm_wrap mt-5">
                    <div class="row">
                        <div class="col-sm-7 col-lg-8">

                            <h4 class="mb-4">Podcasts</h4>

                            <ul class="card-list list-unstyled p-0 m-0 ">
                                @include('front.includes.faculty_course_card')
                            </ul>




                        </div>
                        <div class="col-sm-5 col-lg-4">
                            <h4 class="mb-4 category_title d-flex align-items-center justify-content-between">
                                Categories
                                <button id="clear-category-filter" class="btn btn-sm p-0 ml-2 d-none" title="Clear filter"
                                    style="background: none; border: none;">
                                    <img src="{{ asset('assets/admin/images/cms/close.svg') }}" alt="Clear"
                                        width="16" height="16">
                                </button>
                            </h4>

                            <div class="category-list">

                                <ul class="category-list-group">
                                    @foreach ($categories as $category)
                                        <li class=""><a href="#" class="category-filter"
                                                data-category="{{ $category }}">{{ $category }}
                                            </a></li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const categoryLinks = document.querySelectorAll('.category-filter');
            const podcastCards = document.querySelectorAll('.card-list > li');
            const clearFilterBtn = document.getElementById('clear-category-filter');

            categoryLinks.forEach(link => {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    const selectedCategory = this.dataset.category;

                    // Remove 'selected' from all
                    categoryLinks.forEach(l => l.classList.remove('selected'));

                    if (selectedCategory === 'all') {
                        podcastCards.forEach(card => card.style.display = 'block');
                        clearFilterBtn.classList.add('d-none');
                    } else {
                        podcastCards.forEach(card => {
                            card.style.display = (card.dataset.category ===
                                selectedCategory) ? 'block' : 'none';
                        });
                        clearFilterBtn.classList.remove('d-none');

                        // Add 'selected' class to this link
                        this.classList.add('selected');
                    }
                });
            });

            clearFilterBtn.addEventListener('click', function() {
                podcastCards.forEach(card => card.style.display = 'block');
                clearFilterBtn.classList.add('d-none');

                // Remove selection highlight
                categoryLinks.forEach(link => link.classList.remove('selected'));
            });
        });
    </script>



    @include('front.modules.player.modal')
@endsection
