@extends('front.layouts.app')
@section('content')
    <section class="innerpage_wrap">
        <div class="container">
            {{-- <div class="innerpagebg"><img src="{{ asset('assets/web/images/background/innerpagebg.png') }}" class="img-fluid"
                    alt="innerpagebg"></div> --}}

            @foreach ($pages as $page)
                @if ($page->slug == 'press')
                    {!! $page->description !!}
                @endif
            @endforeach
        </div>
    </section>

    <section class="pb-5 press_wrap pt-5">
        <div class="container">
            <div class="row">
                @if (!$news->isEmpty())
                    <div class="col-sm-8">
                        @foreach ($news as $n)
                            <div class="single-press">
                                <div class="press-img">
                                    <a href="{{ route('press.detail', $n->slug) }}" class="release_detail_click">
                                        <img src="{{ $n->banner_path }}" class="img-fluid mx-auto d-block"
                                            alt="Release image">
                                    </a>
                                </div>
                                <div class="press-content">
                                    <h3 class="entry-title">
                                        <a href="{{ route('press.detail', $n->slug) }}"
                                            class="release_detail_click">{{ $n->title }}</a>
                                    </h3>
                                    <ul class="list-unstyled nav nav-pills">
                                        <li class="nav-item">
                                            <div class="entry-date">
                                                {{ \Carbon\Carbon::parse($n->created_at)->format(config('app.db_des_long')) }},
                                                Posted by: {{ $n->author }}
                                            </div>
                                        </li>
                                    </ul>
                                    <p class="blog-short-disp">{!! strip_tags($n->description) !!}</p>
                                    <a href="{{ route('press.detail', $n->slug) }}"
                                        class="btn btn-light readmore_btn release_detail_click">Read More</a>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <div class="col-sm-4">
                        <div class="widget widget-block">
                            <h3 class="widget-heading">Archives </h3>
                            <div class="archive-dropdown">
                                <select name="archive-dropdown" class="form-control mt-3" id="archive-dropdown"
                                    tabindex="7">
                                    <option value="">Select Month</option>
                                    @foreach ($archiveMonths as $month)
                                        <option value="{{ $month['year'] }}-{{ $month['month'] }}">
                                            {{ $month['name'] }} {{ $month['year'] }} ({{ $month['count'] }})
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="col w-100 justify-content-center align-items-center d-flex">
                        <p>No press releases available.</p>
                    </div>
                @endif
            </div>

        </div>
    </section>

    <section class="bottom_line mb-5">
        <img src="{{ asset('assets/web/images/background/course_bottom_line.png') }}" width="" height=""
            class=" mx-auto d-block" alt="course_bottom_line">
    </section>

    <!-- ======= Subscribe Section ======= -->
    @include('front.modules.subscribe.index')
    <!-- End Subscribe Section -->

    <!-- ======= Account Section ======= -->
    @include('front.modules.contact.index')
    <!-- End Contact Section -->

    <script>
        $(document).ready(function() {
            $('#archive-dropdown').on('change', function() {
                let monthYear = $(this).val();

                $.ajax({
                    url: "{{ route('press.filter') }}",
                    type: "POST",
                    data: {
                        month_year: monthYear,
                        _token: "{{ csrf_token() }}",
                    },
                    success: function(response) {
                        if (response.success) {
                            $('.col-sm-8').html(response.data);
                        }
                    },
                    error: function() {
                        alert('Error fetching filtered news.');
                    }
                });
            });
        });
    </script>
@endsection
