<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<title>Certificate of Completion</title>
<script src="/assets/admin/js/jquery-3.6.0.min.js"></script>
<script src="/assets/admin/js/html2canvas.min.js"></script>
<script src="/assets/admin/js/canvas2image.js"></script>
<style>
    body {
        background-color: #ffffff;
        font-family: Arial, Helvetica, sans-serif;
    }
    .page {
        position: relative;
        width: 700px;
        margin: 0 auto;
    }
    .background-img {
        position: absolute;
        width: 100%;
        max-width: 700px;
        z-index: 0;
        height: 500px;
    }
    table {
        width: 100%;
        position: relative;
        z-index: 1;
        margin: 0 auto;
    }
    table.innertable {
        width: 86%;
        position: relative;
        z-index: 1;
        margin: 0 auto;
    }
    table.podcasttable{
        width: 86%;
        position: relative;
        z-index: 1;
        margin: 0 auto;
        text-align: center
    }
    .content {
        text-align: center;
    }
    .header-img, .footer-img {
        display: block;
        margin: 0 auto;
        width: 100%;
        max-width: 500px;
    }

    .title {
        font-size: 26px;
        font-weight: 700;
        color: #000000;
        line-height: 36px;
        padding: 10px  10px 5px 10px;
         border-bottom: solid 1px #222222;
    }
    .description {
        font-size: 18px;
        font-weight: 400;
        color: #594B77;
        text-align: center;
        padding: 5px    0 0 0;
    }
    .footer {
        font-size: 17px;
        font-weight: 700;
        color: #594B77;
        text-align: left;
        padding: 17px 0;
    }
    .authorized {
        font-size: 20px;
        font-weight: 700;
        color: #594B77;
        text-align: right;
    }
    .authorized-by {
        font-size: 15px;
        font-weight: 400;
        color: #594B77;
        text-align: right;
    }
    .note {
        font-size: 9px;
        font-weight: 400;
        color: #594B77;
        text-align: right;
    }
</style>
</head>
<body>
    <div id="content-container" style="height: 500px;width:700px">
        <div class="page">
            <img src="/assets/front/images/pdf_mainbg2.jpg" alt="" class="background-img"/>
            <table cellpadding="0" cellspacing="0">
                <tr>
                    <td height="60">&nbsp;</td>
                </tr>
                <tr>
                    <td class="content">
                        <img src="/assets/front/images/pdf_logo.png" alt="" class="header-img"/>
                    </td>
                </tr>
                <tr>
                    <td height="30">&nbsp;</td>
                </tr>
                <tr>
                    <td class="content">
                        <img src="/assets/front/images/pdf_text.png" alt="" class="header-img"/>
                    </td>
                </tr>
                <tr>
                    <td height="10">&nbsp;</td>
                </tr>
                <tr>
                    <td class="content">
                        <table class="podcasttable">
                            <tr>
                                <td class=" title"> {{ $submission->user->fullname }}</td>
                            </tr>
                        </table>

                    </td>
                </tr>

                <tr>
                    <td class="content description">
                        <table class="podcasttable">
                            <tr>
                                <td style="font-size:16px;height:70px">
                                    has successfully earned {{ $submission->credit_submitted }} credit for {{ getBarName($submission->bar_id) }} BAR from {{ preg_replace('/\.[^.]*$/', '', $submission->content_file_name) }} of {{ $submission->content_name }}.
                                </td>
                            </tr>
                        </table>

                    </td>
                </tr>
                <tr>
                    <td height="80">&nbsp;</td>
                </tr>
                <tr>
                    <td>
                        <table class="innertable">
                            <tr>
                                <td class="footer" width="60%">{{ \Carbon\Carbon::parse($submission->submitted_at)->format('F j, Y') }}</br>
                                    <span class="note">This is an electronically generated certificate, hence does not require a signature</span>
                                </td>

                                <td class="authorized" width="40%">
                                    <table>
                                        <tr>
                                            <td class="authorized">clearly.legal</td>
                                        </tr>
                                        <tr>
                                            <td class="authorized-by">Authorized by</td>
                                        </tr>

                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td height="10">&nbsp;</td>
                </tr>
            </table>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            html2canvas(document.getElementById('content-container'), {
                onrendered: function(canvas) {
                    return Canvas2Image.saveAsPNG(canvas);
                }
            });
        });
    </script>
</body>
</html>

