<?php
/*
|--------------------------------------------------------------------------
| Admin Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register admin routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

    // Authentication Routes...

use App\Http\Controllers\Admin\EventStatisticsController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

    Route::get('/', 'Auth\LoginController@showLoginForm')->name('authlogin');
    Route::post('/', 'Auth\LoginController@login');
    Route::get('/enter-security-code', 'Admin\SecurityCodeController@showForm')->name('security-code.form');
    Route::get('/clear-security-code', 'Admin\SecurityCodeController@clear')->name('security-code.clear');
    Route::post('/enter-security-code', 'Admin\SecurityCodeController@verify')->name('security-code.verify');
    Route::get('logout', 'Auth\LoginController@logout'); // define get logout to resolve error for guest user

    Route::get('/mail-verification/{token}/{email}', 'Admin\UserController@mail_verifaction')->name('user.mail_verification');
    /**
     * Modern auth routes
     */
    Route::get('mailoauth2', 'MailController@oauth2')->name('mailoauth2');

    // File Uploader
    Route::post('upload','Common\UploadController@store')->name('adminupload');
    Route::post('upload/uploadMultipleFile', 'Common\UploadController@uploadMultipleFile')->name('upload.uploadMultipleFile');
    Route::post('upload/deleteFile', 'Common\UploadController@deleteFile')->name('upload.deleteFile');

    Auth::routes(['verify' => true, 'register' => false]);
    Route::get('reset/student/{id}','Auth\ResetPasswordController@redirectStudent')->name('studentredirectreset');
    Route::get('student-firm-approved-status', 'Admin\UserController@firmApprovedStatus')->name('student.firmApprovedStatus');

Route::middleware(['sessiontimeout.admin', 'auth', 'verified', 'admin','role'])->group(function () {
    /*
    * Dashboard Routes...
    */
    Route::get('dashboard', 'Admin\DashboardController@index')->name('dashboard');
    Route::get('profile', 'Admin\ProfileController@edit')->name('profile');
    Route::post('profile/update', 'Admin\ProfileController@update')->name('profile.update');

    // Change Password Routes...
    Route::get('user/change-password', 'Auth\ChangePassword@showChangePasswordForm')->name('user.change-password');
    Route::post('user/change-password', 'Auth\ChangePassword@updateAdminPassword')->name('user.update-password');

    // Site Config Routes...
    Route::get('site-config/{module}', 'Admin\SiteConfigController@index')->name('site-config');
    Route::post('site-config/{module}', 'Admin\SiteConfigController@store')->name('site-config.save');

    /*
    * User Routes...
    */
    // Bulk Action: Active/ Inactive / Delete Users
    Route::post('user/bulkaction', 'Admin\UserController@bulkaction')->name('user.bulkaction');
    Route::get('user/changestatus', 'Admin\UserController@changestatus')->name('user.changestatus');
    // Reset Password
    Route::get('user/{email}/usertype/{usertypeid}/reset-password', 'Admin\UserController@resetPassword')->name('user.reset-password');
    Route::get('student', 'Admin\UserController@student')->name('student.list');
    Route::get('student/create', 'Admin\UserController@create')->name('student.create');
    Route::get('student/{id}/edit', 'Admin\UserController@edit')->name('student.edit');
    Route::get('firmuser', 'Admin\UserController@firmuser')->name('firmuser.list');
    Route::get('firmuser/create', 'Admin\UserController@create')->name('firmuser.create');
    Route::get('firmuser/{id}/edit', 'Admin\UserController@edit')->name('firmuser.edit');
    Route::get('/student/license/{id}/{userid}', 'Admin\UserController@licenseDelete')->name('deletelicense');
    Route::delete('user/{user}', 'Admin\UserController@destroy')->name('user.destroy');
    Route::resource('user', 'Admin\UserController')->except(['destroy']);
    Route::get('student/{id}/progress', 'Admin\UserController@studentProgress')->name('student.progress');

    Route::post('update-site-config', 'Admin\SiteConfigController@update')->name('admin.siteconfig.update');

    /*
    * Page Routes...
    */
    Route::post('page/bulkaction', 'Common\PageController@bulkaction')->name('page.bulkaction');
    Route::get('page/changestatus', 'Common\PageController@changestatus')->name('page.changestatus');
    Route::resource('page', 'Common\PageController')->except(['destroy','show']);
    /*
    * Firm Routes...
    */
    Route::post('firm/bulkaction', 'Admin\FirmController@bulkaction')->name('firm.bulkaction');
    Route::get('firm/changestatus', 'Admin\FirmController@changestatus')->name('firm.changestatus');
    Route::resource('firm', 'Admin\FirmController')->except(['destroy']);
    /*
    * Bar Routes...
    */

    Route::post('bar/bulkaction', 'Admin\BarController@bulkaction')->name('bar.bulkaction');
    Route::get('bar/changestatus', 'Admin\BarController@changestatus')->name('bar.changestatus');
    Route::resource('bar', 'Admin\BarController')->except(['destroy']);
    /*
    * content Routes...
    */
    Route::post('content/bulkaction', 'Admin\ContentController@bulkaction')->name('content.bulkaction');
    Route::get('content/changestatus', 'Admin\ContentController@changestatus')->name('content.changestatus');
    Route::resource('content', 'Admin\ContentController')->except(['destroy']);
    Route::post('speaker/create', 'Admin\ContentController@addNewSpeaker')->name('speaker.store');


    /**
     * Ip tracker
     */
    Route::post('iptracker/getData', 'Admin\IpTrackerController@getMoreData')->name('iptracker.getdata');
    Route::resource('iptracker', 'Admin\IpTrackerController')->except(['create', 'store', 'show', 'edit', 'update', 'destroy']);



    /**
     * User Role permission Route
     */
    Route::post('role/bulkaction', 'Admin\RoleController@bulkaction')->name('role.bulkaction');
    Route::get('role/changestatus', 'Admin\RoleController@changestatus')->name('role.changestatus');
    Route::post('role/sort', 'Admin\RoleController@sort')->name('role.sort');
    Route::resource('role', 'Admin\RoleController')->except(['destroy']);


    //contact Us page
    Route::get('contact-us', 'Admin\ContactUsController@index')->name('contact-us.index');
    Route::post('contact-us/bulkaction', 'Admin\ContactUsController@bulkAction')->name('contact-us.bulkaction');

    // Faculty Inquiry page
    Route::get('faculty-inquiries', 'Admin\FacultyInquiryController@index')->name('facultyinquiry.index');
    Route::post('faculty-inquiries/bulkaction', 'Admin\FacultyInquiryController@bulkAction')->name('facultyinquiry.bulkaction');

    //support page
    Route::get('support', 'Admin\SupportController@index')->name('support.index');
    Route::post('support/bulkaction', 'Admin\SupportController@bulkAction')->name('support.bulkaction');

    // submissions page
    Route::get('submissions', 'Admin\SubmissionController@index')->name('submissions.index');
    Route::post('submissions/bulkaction', 'Admin\SubmissionController@bulkAction')->name('submissions.bulkaction');

    // subscriptions page
    Route::get('subscriptions', 'Admin\SubscriptionsController@index')->name('subscriptions.index');
    Route::post('subscriptions/bulkaction', 'Admin\SubscriptionsController@bulkAction')->name('subscriptions.bulkaction');

    //get all admin user for author in content
    Route::get('getAdminUsers', 'Admin\UserController@getAdminUsers')->name('user.getAdminUsers');

    //get all sponsored users user for author in content
    Route::get('getSponsoredList', 'Admin\UserController@getSponsoredList')->name('user.getSponsoredList');

    //get all partner for author in content
    Route::get('getPartnerList', 'Admin\UserController@getPartnerList')->name('user.getPartnerList');

    /*
    * Faculty...
    */
    Route::post('faculty/bulkaction', 'Admin\FacultyController@bulkaction')->name('faculty.bulkaction');
    Route::get('faculty/changestatus', 'Admin\FacultyController@changestatus')->name('faculty.changestatus');
    Route::resource('faculty', 'Admin\FacultyController')->except(['destroy','show']);

    
    /*
    * News...
    */
    Route::post('news/bulkaction', 'Admin\NewsController@bulkaction')->name('news.bulkaction');
    Route::get('news/changestatus', 'Admin\NewsController@changestatus')->name('news.changestatus');
    Route::resource('news', 'Admin\NewsController')->except(['destroy','show']);

    /*
    * Events...
    */
    Route::post('events/bulkaction', 'Admin\EventStatisticsController@bulkaction')->name('events.bulkaction');
    Route::get('events/changestatus', 'Admin\EventStatisticsController@changestatus')->name('events.changestatus');
    Route::resource('events', 'Admin\EventStatisticsController')->except(['destroy']);

    
    /*
    * Releases...
    */
    Route::post('releases/bulkaction', 'Admin\ReleasesController@bulkaction')->name('releases.bulkaction');
    Route::get('releases/changestatus', 'Admin\ReleasesController@changestatus')->name('releases.changestatus');
    Route::resource('releases', 'Admin\ReleasesController')->except(['destroy','show']);

    /*
    * FAQS...
    */
    Route::post('faqs/bulkaction', 'Admin\FAQsController@bulkaction')->name('faqs.bulkaction');
    Route::get('faqs/changestatus', 'Admin\FAQsController@changestatus')->name('faqs.changestatus');
    Route::resource('faqs', 'Admin\FAQsController')->except(['destroy','show']);

    /*
    * Members...
    */
    Route::post('members/bulkaction', 'Admin\MemberController@bulkaction')->name('members.bulkaction');
    Route::get('members/changestatus', 'Admin\MemberController@changestatus')->name('members.changestatus');
    Route::resource('members', 'Admin\MemberController')->except(['destroy','show']);

    /*
    * Podcast Statistics...
    */
    Route::post('podcast/getData', 'Admin\PodcastStatisticsController@getMoreData')->name('podcast.getdata');
    Route::resource('podcast', 'Admin\PodcastStatisticsController')->except(['destroy', 'store', 'edit', 'update','create']);
    

});

Route::middleware(['sessiontimeout.admin', 'auth', 'verified', 'admin'])->group(function () {
    Route::get('checkout/{id}', 'Common\StripeController@checkout')->name('checkout');
    Route::get('renewalSubscription/{id}/{subscription_id}/{bar_user_references_id}', 'Common\StripeController@renewalSubscription')->name('renewalSubscription');
    //Route::post('pay', 'Common\StripeController@pay')->name('pay');
    Route::get('firmPaySuccess', 'Common\StripeController@firmPaySuccess')->name('firmPaySuccess');
    Route::get('firmPayRenewalSuccess', 'Common\StripeController@firmPayRenewalSuccess')->name('firmPayRenewalSuccess');
    Route::get('cancelSubscriptionByFirm/{subscription_id}', 'Common\StripeController@cancelSubscriptionByFirm')->name('cancelSubscriptionByFirm');
});
Route::get('mobilePaySuccess', 'Common\StripeController@mobilePaySuccess')->name('mobilePaySuccess');
Route::get('mobilePayRenewalSuccess', 'Common\StripeController@mobilePayRenewalSuccess')->name('mobilePayRenewalSuccess');
Route::get('/event/{id}/download-qr', 'Admin\EventStatisticsController@downloadQr')->name('events.downloadQr');
