<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['prefix' => 'v1',  'middleware' => ['api.response']], function () {
    Route::post('login', 'Api\Auth\ApiLoginController@login');
    Route::get('logout', 'Api\Auth\ApiLoginController@logout'); // define get logout to resolve error for guest user
    Route::post('getnewaccesstoken', 'Api\BaseController@getNewAccessToken');
    Route::post('password/reset', 'Auth\ResetPasswordController@reset')->name('apipassword.update');



    Route::post('forgotpassword', 'Api\Auth\ApiForgotPasswordController@sendResetLinkEmail');
    Route::post('checkversion', 'Api\BaseController@checkAppVersion');
    Route::post('register', 'Auth\RegisterController@create')->name('register');
    Route::post('resend-activation', 'Auth\RegisterController@resendActivation');
    Route::post('resendemail', 'Auth\RegisterController@resendActivationEmail');
    Route::get('settings', 'Api\BaseController@settings');
    Route::get('get-firm-approved-status', 'Api\BaseController@getFirmApprovedStatus');
    Route::middleware('auth:api')->group(function () {
        Route::post('updatedeviceinfo', 'Api\BaseController@updateDeviceInfo');
        Route::post('logout', 'Api\Auth\ApiLoginController@logout');
        /*
        * Profile Routes...
        */
        Route::get('profile', 'Api\v1\ProfileController@edit')->name('apiprofile');
        Route::put('profile', 'Api\v1\ProfileController@update')->name('apiprofile.update');
        Route::post('updateprofileimage', 'Api\v1\ProfileController@profileImageUpload')->name('updateprofileimage');
        Route::delete('user', 'Api\v1\UserController@deleteUserAccount')->name('deleteUserAccount');
        Route::get('check-firm-approved-status', 'Api\v1\ProfileController@checkFirmApprovedStatus')->name('checkFirmApprovedStatus');

        // File Uploader
        Route::post('upload', 'Common\UploadController@store')->name('apiupload');

        Route::resource('users', 'Api\v1\UserController');
        Route::get('bars', 'Api\v1\BarController@getActiveBar')->name('apiactivebars');
        Route::get('getBarPrice/{id}', 'Api\v1\BarController@getBarPrice')->name('getBarPrice');

        // Change Password
        Route::put('change-password', 'Auth\ChangePassword@updatePassword')->name('apiuser.change-password');

        //Bar
        Route::post('addyourbar', 'Api\v1\UserController@barReference')->name('apiuser.addbar');
        Route::delete('deleteyourbar/{id}', 'Api\v1\UserController@deleteBarFromUser');

        //Content Modules
        Route::post('contents', 'Api\v1\ContentController@getActiveContent')->name('apiactivecontent');
        Route::post('content-file-listen', 'Api\v1\ContentController@contentFileListen')->name('apicontentfilelisten');
        Route::post('content-listen-history', 'Api\v1\ContentController@contentListenHistory')->name('apicontentlistenhistory');

        //Speaker Module 
        Route::get('speaker/{id}', 'Api\v1\SpeakerController@show')->name('speaker.show');

        //Subscription Modules
        Route::post('create-subscription', 'Common\StripeController@createSubscription');

        //User Credit List
        Route::get('getUserCredit', 'Api\v1\UserCreditsController@getUserCredit')->name('getUserCredit');
        Route::get('getUserCreditForBar/{id}', 'Api\v1\UserCreditsController@getUserCreditById')->name('getUserCreditForBar');
        Route::get('getSubscriptions', 'Api\v1\UserController@getSubscriptions')->name('getSubscriptions');
        Route::post('getVideoCredits', 'Api\v1\UserCreditsController@getVideoCredits')->name('getVideoCredits');

        //Submissions
        Route::post('submission', 'Api\v1\SubmissionController@checkSubmissionType')->name('storeSubmissions');
        // Route::post('multiple-submission', 'Api\v1\SubmissionController@checkSubmissionType')->name('multipleStoreSubmissions');
        Route::post('submission-partial', 'Api\v1\SubmissionController@submitPartialCredits')->name('submitPartialCredits');
        Route::get('getUserSubscriptionCredits/{bar_id}', 'Api\v1\SubmissionController@getSubscriptions')->name('getUserSubscriptionCredits');
        Route::post('cancel-subscription', 'Common\StripeController@cancelSubscription');
        Route::post('renew-subscription', 'Common\StripeController@reNewSubscription');
        Route::get('getPaymentMethods', 'Common\StripeController@getPaymentMethodsOfUser');
        Route::post('addNewCardToUser', 'Common\StripeController@addNewCardToUser');
        Route::post('deleteCardFromUser', 'Common\StripeController@deleteCardFromUser');

        //Support
        Route::post('support', 'Api\v1\SupportController@store')->name('submitSupportRequest');

        //Dashboard Search
        Route::post('search', 'Api\v1\DashboardController@getAllRecords')->name('dashboardSearch');
        Route::post('library', 'Api\v1\DashboardController@getFilteredContent')->name('getfiltercontent');

        //Stripe Payment
        Route::get('checkout-mobile', 'Common\StripeController@checkoutMobile')->name('checkoutmobile');

        Route::get('renewalSubscriptionMobile/{subscription_id}/{bar_user_references_id}', 'Common\StripeController@renewalSubscriptionMobile')->name('renewalSubscriptionMobile');

        Route::get('getBarSubscription/{bar_id}/{bar_user_references_id}', 'Api\v1\UserController@getBarSubscription')->name('getBarSubscription');

    });
});

Route::group(['prefix' => 'v2',  'middleware' => ['api.response']], function () {
    Route::post('login', 'Api\Auth\ApiLoginController@login');
    Route::get('logout', 'Api\Auth\ApiLoginController@logout'); // define get logout to resolve error for guest user
    Route::post('getnewaccesstoken', 'Api\BaseController@getNewAccessToken');
    Route::post('password/reset', 'Auth\ResetPasswordController@reset')->name('apipassword.update');



    Route::post('forgotpassword', 'Api\Auth\ApiForgotPasswordController@sendResetLinkEmail');
    Route::post('checkversion', 'Api\BaseController@checkAppVersion');
    Route::post('register', 'Auth\RegisterController@create')->name('register');
    Route::post('resend-activation', 'Auth\RegisterController@resendActivation');
    Route::post('resendemail', 'Auth\RegisterController@resendActivationEmail');
    Route::get('settings', 'Api\BaseController@settings');
    Route::get('get-firm-approved-status', 'Api\BaseController@getFirmApprovedStatus');
    Route::middleware('auth:api')->group(function () {
        Route::post('updatedeviceinfo', 'Api\BaseController@updateDeviceInfo');
        Route::post('logout', 'Api\Auth\ApiLoginController@logout');
        /*
        * Profile Routes...
        */
        Route::get('profile', 'Api\v2\ProfileController@edit')->name('apiprofile');
        Route::put('profile', 'Api\v2\ProfileController@update')->name('apiprofile.update');
        Route::post('updateprofileimage', 'Api\v2\ProfileController@profileImageUpload')->name('updateprofileimage');
        Route::delete('user', 'Api\v2\UserController@deleteUserAccount')->name('deleteUserAccount');
        Route::get('check-firm-approved-status', 'Api\v2\ProfileController@checkFirmApprovedStatus')->name('checkFirmApprovedStatus');

        // File Uploader
        Route::post('upload', 'Common\UploadController@store')->name('apiupload');

        Route::resource('users', 'Api\v2\UserController');
        Route::get('bars', 'Api\v2\BarController@getActiveBar')->name('apiactivebars');
        Route::get('getBarPrice/{id}', 'Api\v2\BarController@getBarPrice')->name('getBarPrice');

        // Change Password
        Route::put('change-password', 'Auth\ChangePassword@updatePassword')->name('apiuser.change-password');

        //Bar
        Route::post('addyourbar', 'Api\v2\UserController@barReference')->name('apiuser.addbar');
        Route::delete('deleteyourbar/{id}', 'Api\v2\UserController@deleteBarFromUser');

        //Content Modules
        Route::post('contents', 'Api\v2\ContentController@getActiveContent')->name('apiactivecontent');
        Route::post('content-file-listen', 'Api\v2\ContentController@contentFileListen')->name('apicontentfilelisten');
        Route::post('content-listen-history', 'Api\v2\ContentController@contentListenHistory')->name('apicontentlistenhistory');

        //Speaker Module 
        Route::get('speaker/{id}', 'Api\v2\SpeakerController@show')->name('speaker.show');

        //Subscription Modules
        Route::post('create-subscription', 'Common\StripeController@createSubscription');

        //User Credit List
        Route::get('getUserCredit', 'Api\v2\UserCreditsController@getUserCredit')->name('getUserCredit');
        Route::get('getUserCreditForBar/{id}', 'Api\v2\UserCreditsController@getUserCreditById')->name('getUserCreditForBar');
        Route::get('getSubscriptions', 'Api\v2\UserController@getSubscriptions')->name('getSubscriptions');
        Route::post('getVideoCredits', 'Api\v2\UserCreditsController@getVideoCredits')->name('getVideoCredits');

        //Submissions
        Route::post('submission', 'Api\v2\SubmissionController@checkSubmissionType')->name('storeSubmissions');
        // Route::post('multiple-submission', 'Api\v2\SubmissionController@checkSubmissionType')->name('multipleStoreSubmissions');
        Route::post('submission-partial', 'Api\v2\SubmissionController@submitPartialCredits')->name('submitPartialCredits');
        Route::get('getUserSubscriptionCredits/{bar_id}', 'Api\v2\SubmissionController@getSubscriptions')->name('getUserSubscriptionCredits');
        Route::post('cancel-subscription', 'Common\StripeController@cancelSubscription');
        Route::post('renew-subscription', 'Common\StripeController@reNewSubscription');
        Route::get('getPaymentMethods', 'Common\StripeController@getPaymentMethodsOfUser');
        Route::post('addNewCardToUser', 'Common\StripeController@addNewCardToUser');
        Route::post('deleteCardFromUser', 'Common\StripeController@deleteCardFromUser');

        //Support
        Route::post('support', 'Api\v2\SupportController@store')->name('submitSupportRequest');

        //Dashboard Search
        Route::post('search', 'Api\v2\DashboardController@getAllRecords')->name('dashboardSearch');
        Route::post('library', 'Api\v2\DashboardController@getFilteredContent')->name('getfiltercontent');

        //Stripe Payment
        Route::get('checkout-mobile', 'Common\StripeController@checkoutMobile')->name('checkoutmobile');

        Route::get('renewalSubscriptionMobile/{subscription_id}/{bar_user_references_id}', 'Common\StripeController@renewalSubscriptionMobile')->name('renewalSubscriptionMobile');

        Route::get('getBarSubscription/{bar_id}/{bar_user_references_id}', 'Api\v2\UserController@getBarSubscription')->name('getBarSubscription');

    });
});
