<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Front Routes
|--------------------------------------------------------------------------
|
| Here is where you can register front routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "front" middleware group. Now create something great!
|
*/
//Admin dashboard and login route
Route::get('/', 'Front\HomeController@index')->name('home');
Route::post('submit-contact-us', 'Front\ContactController@submitContactUs')->name('submit-contact-us');

//share podcast start
Route::post('share-config', 'Front\SharePodcastController@shareConfig')->name('share-config');
Route::post('track-embed', 'Front\SharePodcastController@trackEmbedCode')->name('track.embed');
Route::post('track-podcast-play', 'Front\SharePodcastController@trackPodcastPlay')->name('track.podcast.play');
Route::get('/embed-player', 'Front\SharePodcastController@embedPlayer')->name('podcast.embed');
Route::get('/player/{token}', 'Front\SharePodcastController@serveAudio')->name('secure.audio');
//share podcast end

// secure audio on web 
Route::get('/player/web/{filePath}', 'Front\SharePodcastController@serveAudioForWeb')->name('secure.web.audio');

Route::get('/about', 'Front\PagesController@about')->name('about');
Route::get('/courses', 'Front\PagesController@library')->name('library');
Route::get('/pricing', 'Front\PagesController@pricing')->name('pricing');
// faculty 
Route::get('/faculty', 'Front\PagesController@faculty')->name('faculty');
Route::get('/faculty/{slug}', 'Front\PagesController@facultyShow')->name('faculty.show');

//podcast
Route::get('/library/{encodedTitle}', 'Front\PagesController@podcastShow')->name('library.show');

//Press
Route::get('/press', 'Front\PagesController@press')->name('press');
Route::post('/press/filter', 'Front\PagesController@filterNews')->name('press.filter');
Route::get('/press/{slug}', 'Front\PagesController@pressDetail')->name('press.detail');

// Contact Us
Route::get('/contact-us', 'Front\ContactController@index')->name('contactus');
Route::post('faculty-inquiry', 'Front\ContactController@storeFacultyInquiry')->name('storeFacultyInquiry');

//subscription
Route::get('/subscribe/{uuid?}', 'Front\PagesController@subscribe')->name('subscribe');

Route::post('/submit-subscription', 'Front\PagesController@submitSubscription')->name('submit-subscription');
Route::get('/subscription-success', 'Front\PagesController@subscribeSuccess')->name('subscribe.success');
Route::get('/subscription-failed', 'Front\PagesController@subscribeFailed')->name('subscribe.failed');

Route::get('/privacy', 'Front\PagesController@privacy')->name('privacy');
Route::get('/terms', 'Front\PagesController@terms')->name('terms');
Route::get('/press-release', 'Front\PagesController@pressRelease')->name('press-release');
Route::get('/more', 'Front\PagesController@more')->name('more');