<?php

use App\Http\Controllers\Common\RssFeedController;
use App\Http\Controllers\StripeWebhookController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
//Admin dashboard and login route
Route::get('page/{slug}', 'Common\PageController@show')->name('pageshow');

Route::get('/account-activated', 'Auth\LoginController@accountActivated')->name('accountActivated');

Route::post('/stripe/webhook', [StripeWebhookController::class, 'handleWebhook']);

Route::get('/app-download','Common\PageController@appRedirect')->name('appRedirect');


Route::get('/downloadCertificate/{encoded_id}', 'Common\PageController@downloadCertificate')->name('downloadCertificate');

Route::get('/checkIfPromocodeExists/{promocode}', 'Common\StripeController@checkIfPromocodeExists')->name('checkIfPromocodeExists');

Route::get('/rss.xml', [RssFeedController::class, 'index'])->name('rss.feed');