<!DOCTYPE html>
<html lang="en">

<?php echo $__env->make('front.modules.player.includes.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<body>
    <?php echo $__env->yieldContent('playercontent'); ?>
</body>

<script src="<?php echo e(asset('assets/player/js/custom.js')); ?>"></script>



<script>
    async function getDeviceInfo() {
        const userAgent = navigator.userAgent.toLowerCase();
        let deviceType = "Unknown";
        let browserName = "Unknown";

        // Detect Device Type
        if (/android/.test(userAgent)) {
            deviceType = "android";
        } else if (/iphone|ipad|ipod/.test(userAgent)) {
            deviceType = "iPhone";
        } else {
            deviceType = "web";
        }

        // Detect Browser
        if (userAgent.includes("chrome")) {
            browserName = "Google Chrome";
        } else if (userAgent.includes("firefox")) {
            browserName = "Mozilla Firefox";
        } else if (userAgent.includes("safari") && !userAgent.includes("chrome")) {
            browserName = "Safari";
        } else if (userAgent.includes("edge")) {
            browserName = "Microsoft Edge";
        } else if (userAgent.includes("opr") || userAgent.includes("opera")) {
            browserName = "Opera";
        } else if (userAgent.includes("msie") || userAgent.includes("trident")) {
            browserName = "Internet Explorer";
        }

        // Get IP Address
        let ipAddress = "Unknown";
        try {
            const response = await fetch("https://api64.ipify.org?format=json");
            const data = await response.json();
            ipAddress = data.ip;
        } catch (error) {
            console.error("Error fetching IP:", error);
        }

        return {
            deviceType,
            browserName,
            ipAddress
        };
    }

    // Call the function and log the results
    // getDeviceInfo().then(info => console.log(info));
</script>

<script src="//ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
<script>
    $(document).ready(function() {

        var referrer = document.referrer;
        var currentOrigin = window.location.origin;

        let referrerOrigin = "";
        try {
            referrerOrigin = new URL(referrer).origin;
        } catch (e) {
            referrerOrigin = "";
        }

        console.log(referrer, referrerOrigin, currentOrigin)

        if (referrer && (referrerOrigin != currentOrigin)) {

            getDeviceInfo().then(info => {
                var websiteUrl = document.referrer || (document.location.ancestorOrigins && document
                    .location.ancestorOrigins[0]) || "Unknown";
                var token = "<?php echo e($token); ?>";
                var contentId = "<?php echo e($contentId); ?>";
                var contentFileId = "<?php echo e($contentFileId); ?>";
                var url = "<?php echo e(route('track.embed')); ?>";


                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        websiteUrl,
                        token,
                        contentId,
                        contentFileId,
                        deviceType: info.deviceType,
                        browserName: info.browserName,
                        ipAddress: info.ipAddress
                    },
                    error: function() {
                        console.error("Failed to save configuration. Please try again.");
                    }
                });
            });
        }
    });
</script>



<script>
    document.addEventListener("DOMContentLoaded", function() {

        var referrer = document.referrer;
        var currentOrigin = window.location.origin;

        let referrerOrigin = "";
        try {
            referrerOrigin = new URL(referrer).origin;
        } catch (e) {
            referrerOrigin = "";
        }

        console.log(referrer, referrerOrigin, currentOrigin)

        if (referrer && (referrerOrigin != currentOrigin)) {
            getDeviceInfo().then(info => {
                const audioElement = document.getElementById("song");
                const playButton = document.getElementById("playbutton");
                var websiteUrl = document.referrer || document.location.ancestorOrigins[0] || "Unknown";
                var token = "<?php echo e($token); ?>";
                var contentId = "<?php echo e($contentId); ?>";
                var contentFileId = "<?php echo e($contentFileId); ?>";
                var key = contentId + contentFileId + websiteUrl + token;

                playButton.addEventListener("click", function() {
                    let playedPodcasts = JSON.parse(sessionStorage.getItem("playedPodcasts")) ||
                    {};

                    if (!playedPodcasts[key]) {
                        playedPodcasts[key] = true;
                        sessionStorage.setItem("playedPodcasts", JSON.stringify(
                            playedPodcasts));

                        trackPodcastPlay(contentId, contentFileId);
                    }
                });

                function trackPodcastPlay(contentId, contentFileId) {
                    var url = "<?php echo e(route('track.podcast.play')); ?>";
                    var deviceType = info.deviceType;
                    $.ajax({
                        type: "POST",
                        url: url,
                        data: {
                            contentId,
                            contentFileId,
                            key,
                            deviceType
                        },
                        success: function(response) {
                            console.log("Track played")
                        },
                        error: function() {
                            console.error("Error tracking play:", error)
                        }
                    });
                }
            });
        }
    });
</script>


</html>
<?php /**PATH /var/www/html/clearlylegal_production/resources/views/front/modules/player/includes/master.blade.php ENDPATH**/ ?>