<?php $__env->startComponent('mail::layout'); ?>

<?php $__env->slot('header'); ?>
<?php echo $__env->make('email.admin.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->endSlot(); ?>

<style>
    .bordered-table {
        width: 100%;
        border-collapse: collapse;
    }
    .bordered-table th, .bordered-table td {
        border: 1px solid #dee2e6;
        padding: 0.75rem;
    }
</style>


<!-- Email Body -->


<?php if(! empty($greeting)): ?>
# <?php echo e($greeting); ?>

<?php else: ?>
<?php if($level === 'error'): ?>
# <?php echo app('translator')->get('Whoops!'); ?>
<?php else: ?>
# Dear <?php echo e($user->first_name.'  '.$user->last_name); ?>,
<?php endif; ?>
<?php endif; ?>
<p>We are pleased to inform you that your podcast submissions have been approved! Below are the details of your approved submissions:</p>


<table class="bordered-table">
    <thead>
        <tr>
            <th>Podcast Name</th>
            <th>BAR Name</th>
            <th>BAR ID</th>
            <th>Submission Credits</th>
            <th>Submitted Date</th>
            <th>Approved Credits</th>
            <th>Date of Approval</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $submissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($submission->podcast_title); ?></td>
            <td><?php echo e($submission->state_name); ?></td>
            <td><?php echo e($submission->podcast_bar_id); ?></td>
            <td><?php echo e($submission->credits_submitted); ?></td>
            <td><?php echo e($submission->created_at); ?></td>
            <td><?php echo e($submission->credits_submitted); ?></td>
            <td><?php echo e(\Carbon\Carbon::parse($submission->approved_at)->format(config('app.datetime_format'))); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<br />            
<strong>Total Approved Credits: <?php echo e($approved_credits); ?></strong>
<br/>
<p>If you have any further questions or need assistance, feel free to reach out to us at <a href="mailto:support@clearly.legal ">support@clearly.legal</a> </p>

<strong>Important Note:</strong>
<p>The Date of Approval mentioned above reflects when the status of your submissions was updated in our local portal. This date may differ from the actual approval date by the respective BAR due to processing timelines. If you need the exact approval date from the BAR, please contact your BAR directly.</p>
<br />
<p>Best regards,<br />
<?php if(! empty($salutation)): ?>
<p><?php echo e($salutation); ?></p>
<?php endif; ?>

<?php if(isset($subcopy)): ?>
<?php $__env->slot('subcopy'); ?>
<?php $__env->startComponent('mail::subcopy'); ?>
<?php echo e($subcopy); ?>

<?php echo $__env->renderComponent(); ?>
<?php $__env->endSlot(); ?>
<?php endif; ?>

<?php $__env->slot('footer'); ?>
<?php echo $__env->make('email.admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /var/www/html/clearlylegal_production/resources/views/email/admin/submissionapproved.blade.php ENDPATH**/ ?>