<?php $__env->startSection('content'); ?>
    <div class="row mx-0 mb-3">
        <div class="col-6">
            <h1 class="page-title"><?php echo __('support.pagetitle'); ?></h1>
        </div>
        <div class="top-btn-box col-6" id="normal_btns">
            <div class="top-btn-box d-flex justify-content-end align-items-center h-100">
                <a tabindex="1" href="javascript:void(0)" class="btn btn-primary mr-1 search-btn btn-sm show hide"
                    id="search-btn">
                    <em class="icon-search-icon top-icon"></em>
                    <span class="btn-title"><?php echo e(__('common.search')); ?></span>
                </a>
            </div>
        </div>

        <div class="top-btn-box hide col-6" id="action_btns">
            <div class="top-btn-box d-flex justify-content-end align-items-center h-100 ">
                <a href="javascript:void(0)" class="btn btn-dark btn-sm delete-btn" onclick="submitactionform('delete');"
                    id="delete-btn" title="<?php echo e(__('common.delete')); ?>">
                    <em class="icon-close-icon top-icon"></em>
                    <span class="btn-title"><?php echo e(__('common.delete')); ?></span>
                </a>
            </div>

        </div>
    </div>

    <div class="col-12 admin-holder">
        <div class="row">
            <div class="<?php echo e(Request::has('search') ? 'show' : 'hide'); ?>" id="searchbox">
                <form name="frmsearch" id="frmsearch"
                    action="<?php echo e($supportData->appends(prepareInputRequestArray())->url(1)); ?>" method="GET" class="col-12">
                    <?php $__currentLoopData = Request::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(in_array($key, ['search', 'status', 'btnsearch'])): ?>
                            <?php continue; ?>
                        <?php else: ?>
                            <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="row">
                        <div class="form-group col-md-6 col-12">
                            <label><?php echo e(__('support.name')); ?> / <?php echo e(__('support.email')); ?> /
                                <?php echo e(__('support.phone_number')); ?></label>
                            <input tabindex="3" name="search" id="search"
                                placeholder="<?php echo e(__('common.search') . ' ' . __('support.pagetitle')); ?>" type="text"
                                class="form-control rounded" value="<?php echo e(Request::get('search')); ?>">
                        </div>


                        <div class="form-group col-12">
                            <button tabindex="6" type="submit" class="btn btn-primary submit-btn" id="btnsearch"
                                name="btnsearch"><?php echo e(__('common.search')); ?></button>
                            <a href="<?php echo e($reset_link); ?>" class="btn btn-primary reset-btn"
                                id="search_reset"><?php echo e(__('common.reset')); ?></a>
                            <button tabindex="7" type="button" class="btn btn-dark close-btn"
                                id="search-btn-h"><?php echo e(__('common.close')); ?></button>
                            <hr>
                        </div>
                    </div>
                </form>
            </div>

            <div class="col-12 photos-main">
                <section id="wrapper">
                    <form name="frmlist" id="frmlist" action="<?php echo e(route('support.bulkaction')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="bulk-action" value="">
                        <div class="table-responsive">
                        <table data-orders="4" data-target="<?php if(canUserAccess('manage-support')): ?> 3 <?php else: ?> 1 <?php endif; ?>"
                            class="admintable table table-hover mb-0" aria-describedby="DataTableDesc" style="width: 100%">
                            <thead>
                                <tr>
                                    <th class="hide" scope="col">
                                        <!-- this blank column is for primary column -->

                                    </th>
                                    <?php if(canUserAccess('manage-support')): ?>
                                        <th class="active-box"></th>
                                        <th class="check-box nosort" scope="col">
                                            <div class="custom-control custom-checkbox text-center">
                                                <input type="checkbox" class="custom-control-input" name="selectAll"
                                                    id="selectAll" onclick="checkAll();">
                                                <label class="custom-control-label" for="selectAll"></label>
                                            </div>
                                        </th>
                                    <?php endif; ?>
                                    <th scope="col" class="control nosort">
                                        <!-- this blank column is responsive controll -->

                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('support.name')); ?>

                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('support.phone_number')); ?>

                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('support.email')); ?>

                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('support.comment')); ?>

                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('support.created_at')); ?>

                                            </span>
                                        </div>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $supportData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $support): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="active-box hide">
                                            <em style="display:none"><?php echo e($support->id); ?></em>
                                        </td>
                                        <?php if(canUserAccess('manage-support')): ?>
                                            <td></td>
                                            <td class="check-box">
                                                <div class="custom-control custom-checkbox text-center">
                                                    <input type="checkbox"
                                                        class="custom-control-input chkbox action-checkbox"
                                                        id="filled-in-box_<?php echo e($support->id); ?>" name="id[]"
                                                        value="<?php echo e($support->id); ?>">
                                                    <label class="custom-control-label"
                                                        for="filled-in-box_<?php echo e($support->id); ?>"></label>
                                                </div>
                                            </td>
                                        <?php endif; ?>
                                        <td></td>
                                        <td><?php echo e($support->firstName); ?> <?php echo e($support->lastName); ?></td>
                                        <td><?php echo e(formatPhoneNumber($support->phone)); ?></td>

                                        <td>
                                            <div class="email-add"><a
                                                    href="mailto:<?php echo e($support->email); ?>"><?php echo e($support->email); ?></a>
                                            </div>
                                        </td>

                                        <td>
                                            <p><?php echo e($support->comment); ?></p>
                                        </td>
                                        <td
                                            data-sort="<?php echo e(\Carbon\Carbon::parse($support->created_at)->format('Y/m/d H:i:s')); ?>">
                                            <?php echo e($support->created_at); ?></td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($supportData->total() == 0): ?>
                                    <tr class="noreocrd">
                                        <td colspan="10" class="text-center">

                                            <?php echo e(__(Request::segment(2) . '.no_result')); ?>

                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        </div>
                    </form>
                </section>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/clearlylegal_production/resources/views/admin/modules/support/index.blade.php ENDPATH**/ ?>