<?php $__env->startSection('content'); ?>
<div class="row mx-0 mb-3">
    <div class="col-6">
        <h1 class="firm-title"><?php echo __('firm.pagetitle'); ?></h1>
    </div>
    <div class="top-btn-box col-6" id="normal_btns">
        <div class="top-btn-box d-flex justify-content-end align-items-center h-100">
            <a tabindex="1" href="javascript:void(0)" class="btn search-btn btn-sm show hide btn-primary mr-1" id="search-btn">
                <em class="icon-search-icon top-icon"></em>
                <span class="btn-title"><?php echo e(__('common.search')); ?></span>
            </a>
            <?php if(canUserAccess('manage-firm') || canUserAccess('manage-firm') ): ?>
            <a tabindex="2" href="<?php echo e(route('firm.create')); ?>" class="btn btn-primary addnew-btn btn-sm" id="add-btn">
                <em class="icon-addnew top-icon"></em>
                <span class="btn-title"><?php echo e(__('common.add')); ?></span>
            </a>
            <?php endif; ?>
        </div>
    </div>
    <div class="top-btn-box hide col-6" id="action_btns">
        <div class="top-btn-box d-flex justify-content-end align-items-center h-100 ">
            <a href="javascript:void(0)" class="btn btn-primary mr-1 btn-sm active-btn"
                onclick="submitactionform('active');" id="active-btn" title="<?php echo e(__('common.active')); ?>">
                <em class="icon-radiobutton_checked top-icon"></em>
                <span class="btn-title"><?php echo e(__('common.active')); ?></span>
            </a>
            <a href="javascript:void(0)" class="btn btn-primary mr-1 btn-sm inactive-btn"
                onclick="submitactionform('inactive');" id="inactive-btn" title="<?php echo e(__('common.inactive')); ?>">
                <em class="icon-radio_button_unchecked top-icon"></em>
                <span class="btn-title"><?php echo e(__('common.inactive')); ?></span>
            </a>
            <a href="javascript:void(0)" class="btn btn-dark btn-sm delete-btn" onclick="submitactionform('delete');" id="delete-btn" title="<?php echo e(__('common.delete')); ?>">
                <em class="icon-close-icon top-icon"></em>
                <span class="btn-title"><?php echo e(__('common.delete')); ?></span>
            </a>
        </div>
    </div>
</div>
<div class="col-12 admin-holder">
    <div class="row">
        <div class="<?php echo e(Request::has('status') && Request::has('search') ? 'show' : 'hide'); ?>" id="searchbox">
            <form name="frmsearch" id="frmsearch" action="<?php echo e($firms->appends(prepareInputRequestArray())->url(1)); ?>" method="GET" class="col-12">
                <?php $__currentLoopData = Request::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(in_array($key,['search','status','btnsearch'])): ?>
                <?php continue; ?>
                <?php else: ?>
                <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="row">
                    <div class="form-group col-md-6 col-12">
                        <label><?php echo e(__('firm.name')); ?></label>
                        <input tabindex="3" name="search" id="search" placeholder="<?php echo e(__('common.search')); ?>" type="text" class="form-control rounded" value="<?php echo e(Request::get('search')); ?>">
                    </div>
                    <div class="form-group col-xl-2 col-lg-4 col-md-5 col-12">
                        <label><?php echo e(__('firm.status')); ?></label>
                        <select tabindex="4" name="status" id="status" class="form-control rounded">
                            <option value=""><?php echo e(__('common.select_status')); ?></option>
                            <?php $__currentLoopData = config('status'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($value); ?>" <?php echo e(Request::get('status') != "" && intval(Request::get('status')) === $value ? 'selected' : ''); ?>>
                                <?php echo e($label); ?>

                            </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group col-12">
                        <button tabindex="5" type="submit" class="btn submit-btn btn-primary mr-1" id="btnsearch" name="btnsearch"><?php echo e(__('common.search')); ?></button>
                        <a href="<?php echo e(route('firm.index', ['search' => '', 'status' => ''])); ?>" class="btn btn-primary reset-btn"><?php echo e(__('common.reset')); ?></a>
                        <button tabindex="7" type="button" class="btn close-btn btn-dark" id="search-btn-h"><?php echo e(__('common.close')); ?></button>
                        <hr>
                    </div>
                </div>
            </form>
        </div>
        <div class="col-12 photos-main">
            <section id="wrapper">
                <form name="frmlist" id="frmlist" action="<?php echo e(route('firm.bulkaction')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="bulk-action" value="">
                    <div class="table-responsive">
                    <table data-orders="8" defaultdir="desc" data-target=" <?php if(canUserAccess('manage-firm')): ?> 3 <?php else: ?> 1 <?php endif; ?>" class="admintable table table-hover mb-0" aria-describedby="DataTableDesc" style="width: 100%">
                        <thead>
                            <tr>
                                <th class="hide" scope="col">

                                </th>
                                <?php if(canUserAccess('manage-firm')): ?>
                                <th class="active-box status-column" scope="col">
                                    <em class="sort"></em>
                                </th>
                                <th class="check-box nosort" scope="col">
                                    <div class="custom-control custom-checkbox text-center">
                                        <input type="checkbox" class="custom-control-input" name="selectAll" id="selectAll" onclick="checkAll();">
                                        <label class="custom-control-label" for="selectAll"></label>
                                    </div>
                                </th>
                                <?php endif; ?>
                                <th scope="col" class="control nosort">
                                    <!-- this blank column is responsive controll -->

                                </th>
                                <th scope="col">
                                    <span><?php echo e(__('firm.name')); ?></span>
                                </th>
                                <th scope="col">
                                    <span><?php echo e(__('firm.adminname')); ?></span>
                                </th>
                                <th scope="col">
                                    <span><?php echo e(__('firm.code')); ?></span>
                                </th>
                                <th scope="col">
                                    <span><?php echo e(__('firm.firmusercount')); ?></span>
                                </th>
                                <th scope="col">
                                    <span><?php echo e(__('firm.updated-at')); ?></span>
                                </th>

                                <th class="text-right nosort" scope="col"><?php echo e(__('common.action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $firms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $firm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="active-box hide">
                                    <em style="display:none"><?php echo e($firm->id); ?></em>
                                </td>
                                <?php if(canUserAccess('manage-firm')): ?>
                                <td class="active-box">
                                    <a href="<?php echo e(route('firm.changestatus', ['id' => $firm->id])); ?> ">
                                        <em style="display:none"><?php echo e($firm->status); ?></em>
                                        <span class="sort <?php echo e($firm->status == 1 ? 'active' : 'inactive'); ?> "></span>
                                    </a>
                                </td>
                                <td class="check-box">
                                    <div class="custom-control custom-checkbox text-center">
                                        <input type="checkbox" class="custom-control-input chkbox action-checkbox" id="filled-in-box_<?php echo e($firm->id); ?>" name="id[]" value="<?php echo e($firm->id); ?>">
                                        <label class="custom-control-label" for="filled-in-box_<?php echo e($firm->id); ?>"></label>
                                    </div>
                                </td>
                                <?php endif; ?>
                                <td></td>
                                <td>
                                    <?php if(canUserAccess('manage-firm')): ?>
                                    <a href="<?php echo e(route('firm.edit', ['firm' => $firm->id])); ?>"><?php echo e($firm->name); ?></a>
                                    <?php else: ?> <?php echo e($firm->name); ?>

                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($firm->adminname); ?><br/><?php echo e($firm->adminemail); ?></td>
                                <td><?php echo e($firm->code); ?></td>
                                <td><?php echo e($firm->firmUsers()->count()); ?></td>
                                <td data-sort="<?php echo e(\Carbon\Carbon::parse( $firm->updated_at)->format('Y/m/d H:i:s')); ?>">
                                    <?php echo e($firm->updated_at); ?>

                                </td>

                                <td class="text-right">
                                    <?php if(canUserAccess('manage-firm')): ?>
                                        <a href="<?php echo e(route('firm.edit', ['firm' => $firm->id])); ?>"><em class="icon-edit-icon left"></em></a>
                                    <?php endif; ?>
                                </td>

                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php if($firms->total() == 0): ?>
                            <tr class="noreocrd">
                                <td colspan="9" class="text-center">
                                    <?php echo e(__('firm.no_result')); ?>

                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                    </div>
                </form>
            </section>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/clearlylegal_production/resources/views/admin/modules/firm/index.blade.php ENDPATH**/ ?>