<?php $__env->startSection('content'); ?>

    <div class="row mx-0 mb-3">
        <div class="col-6">
            <h1 class="page-title"><?php echo __('submissions.pagetitle'); ?></h1>
        </div>
    </div>

    <div class="col-12 admin-holder">
        <div class="row">
            <div class="<?php echo e(Request::has('search') ? 'show' : 'show'); ?>" id="searchbox">
                <form name="frmsearch" id="frmsearch" action="<?php echo e($submissions->appends(prepareInputRequestArray())->url(1)); ?>"
                    method="GET" class="col-12">
                    <?php $__currentLoopData = Request::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(in_array($key, ['search', 'status', 'btnsearch', 'type', 'export'])): ?>
                            <?php continue; ?>
                        <?php else: ?>
                            <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="row">
                        <div class="form-group col-md-4 col-12">
                            <label><?php echo e(__('submissions.username')); ?> / <?php echo e(__('submissions.podcast_name')); ?> /
                                <?php echo e(__('submissions.bar')); ?></label>
                            <input tabindex="3" name="search" id="search"
                                placeholder="<?php echo e(__('common.search') . ' ' . __('submissions.pagetitle')); ?>" type="text"
                                class="form-control rounded" value="<?php echo e(Request::get('search')); ?>">
                        </div>

                        
                        <div class="form-group col-xl-2 col-lg-4 col-md-5 col-12">
                            <label><?php echo e(__('submissions.filter')); ?></label>
                            <select tabindex="5" name="status" id="status" class="form-control">
                                <option value=""><?php echo e(__('user.select_status')); ?></option>

                                <?php
                                    $selectedValue = Request::get('status') != '' ? intval(Request::get('status')) : '';
                                ?>
                                <?php $__currentLoopData = config('submission_status'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php echo e($selectedValue === $key ? 'selected' : ''); ?>>
                                        <?php echo e(config('submission_status')[$key]); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                        </div>

                        
                        <?php if(Auth::user()->user_type_id == 1): ?>
                            <div class="form-group col-xl-2 col-lg-4 col-md-5 col-12">
                                <label><?php echo e(__('submissions.firm')); ?></label>
                                <select tabindex="5" name="firm" id="firm" class="form-control">
                                    <option value=""><?php echo e(__('submissions.select_firm')); ?></option>

                                    <?php
                                        $selectedValue = Request::get('firm') != '' ? Request::get('firm') : '';

                                    ?>
                                    <?php $__currentLoopData = $firmList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>"
                                            <?php echo e($selectedValue === $key ? 'selected' : ''); ?>>
                                            <?php echo e($val); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                            </div>
                        <?php endif; ?>

                        
                        <div class="form-group col-xl-2 col-lg-4 col-md-5 col-12">
                            <label><?php echo e(__('submissions.filter')); ?></label>
                            <select tabindex="5" name="type" id="type" class="form-control">
                                <option value=""><?php echo e(__('user.select_type')); ?></option>
                                <?php if(!empty($filters)): ?>
                                    <?php
                                        $selectedValue = Request::get('type') != '' ? intval(Request::get('type')) : 5;
                                    ?>
                                    <?php $__currentLoopData = $filters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $filter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($filter['id']); ?>"
                                            <?php echo e($selectedValue === $filter['id'] ? 'selected' : ''); ?>>
                                            <?php echo e($filter['title']); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                        </div>

                        <div class="form-group col" id="dateRange" style="display:none">
                            <div class=row>
                                <div class="col">
                                    <label><?php echo e(__('submissions.start_date')); ?></label>
                                    <input type="text" name="start_date"
                                        value="<?php echo e(Request::get('start_date') != '' ? Request::get('start_date') : ''); ?>"
                                        class="form-control datepicker" />
                                </div>
                                <div class="col">
                                    <label><?php echo e(__('submissions.end_date')); ?></label>
                                    <input type="text" name="end_date"
                                        value="<?php echo e(Request::get('end_date') != '' ? Request::get('end_date') : ''); ?>"
                                        class="form-control datepicker" />
                                </div>
                            </div>

                        </div>

                        <div class="form-group col-12">
                            <button tabindex="6" type="submit" class="btn btn-primary submit-btn" id="btnsearch"
                                name="btnsearch"><?php echo e(__('common.search')); ?></button>
                            <a href="<?php echo e($reset_link); ?>" class="btn btn-primary reset-btn"
                                id="search_reset"><?php echo e(__('common.reset')); ?></a>
                            
                            
                            <hr>
                        </div>
                    </div>
                </form>


                <div class="top-btn-box hide col-12" id="action_btns-submissions">
                    <div class="top-btn-box d-flex justify-content-end align-items-center h-100 ">
                        <?php if(Auth::user()->user_type_id == 1): ?>
                            <a href="javascript:void(0)" class="btn btn-dark export-btn ml-2"
                                onclick="submitactionformSubmission('export');" title="<?php echo e(__('common.export')); ?>">
                                <?php echo e(__('submissions.export_btn')); ?>

                            </a>

                            <a href="javascript:void(0)" class="btn btn-dark submitted-btn ml-2"
                                onclick="submitactionformSubmission('submit');" title="<?php echo e(__('common.submit')); ?>">
                                <?php echo e(__('submissions.submit_btn')); ?>


                            </a>

                            <a href="javascript:void(0)" class="btn btn-dark approved-btn ml-2"
                                onclick="submitactionformSubmission('approve');" title="<?php echo e(__('common.approve')); ?>">
                                <?php echo e(__('submissions.approve_btn')); ?>


                            </a>
                        <?php endif; ?>
                        
                    </div>
                </div>

            </div>
            <iframe id="downloadIframe" name="downloadIframe" style="display:none;"></iframe>

            <div class="col-12 photos-main">
                <section id="wrapper">
                    <form name="frmlist" id="frmlist" action="<?php echo e(route('submissions.bulkaction')); ?>" method="POST"
                        target="downloadIframe">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="bulk-action" value="">
                        <div class="table-responsive">
                        <table data-orders="0" data-target="0" class="admintable table table-hover mb-0"
                            aria-describedby="DataTableDesc" style="width: 100%">
                            <thead>
                                <tr>
                                    <th class="hide" scope="col">
                                        <!-- this blank column is for primary column -->

                                    </th>
                                    <?php if(canUserAccess('manage-student')): ?>
                                        <th class="check-box nosort" scope="col">
                                            <div class="custom-control custom-checkbox text-center">
                                                <input type="checkbox" class="custom-control-input" name="selectAll"
                                                    id="selectAllSubmissions" onclick="checkAllSubmissions();">
                                                <label class="custom-control-label" for="selectAllSubmissions"></label>
                                            </div>
                                        </th>
                                    <?php endif; ?>
                                    <th scope="col" class="control nosort">
                                        <!-- this blank column is responsive controll -->

                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('submissions.username')); ?>

                                            </span>
                                        </div>
                                    </th>

                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('submissions.bar')); ?>

                                            </span>
                                        </div>
                                    </th>


                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('submissions.podcast_name')); ?>

                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('submissions.submitted_credits')); ?>

                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('submissions.status')); ?>

                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('submissions.received_on')); ?>

                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('submissions.exported_on')); ?>

                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('submissions.submitted_on')); ?>

                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col"  class="d-none" id="approved_on_header">
                                        <div>
                                            <span>
                                                <?php echo e(__('submissions.approved_on')); ?>

                                            </span>
                                        </div>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td class="active-box hide">
                                        <em style="display:none"><?php echo e($detail->id); ?></em>
                                    </td>
                                    <?php if(canUserAccess('manage-student')): ?>
                                        <td class="check-box">
                                            <div class="custom-control custom-checkbox text-center">

                                                <input type="hidden"
                                                    class="custom-control-input action-checkbox-submissions"
                                                    id="filled-in-box_<?php echo e($detail->status); ?>"
                                                    name="status[<?php echo e($detail->id); ?>]" value="<?php echo e($detail->status); ?>">

                                                <input type="checkbox"
                                                    class="custom-control-input action-checkbox-submissions"
                                                    id="filled-in-box_<?php echo e($detail->id); ?>" name="id[]"
                                                    value="<?php echo e($detail->id); ?>">
                                                <label class="custom-control-label"
                                                    for="filled-in-box_<?php echo e($detail->id); ?>"></label>

                                            </div>
                                    <?php endif; ?>
                                    </td>
                                    <td>

                                    </td>
                                    <td><?php echo e($detail->user_name); ?></br><?php echo e($detail->user_bar_id); ?></td>

                                    <td><?php echo e($detail->state_name); ?></td>
                                    <td><?php echo e($detail->podcast_title); ?></br><?php echo e($detail->podcast_id_for_bar); ?></td>
                                    <td><?php echo e($detail->credits_submitted); ?></td>
                                    <td><?php echo e(config('submission_status')[$detail->status]); ?></td>

                                    <td
                                        data-sort="<?php echo e(\Carbon\Carbon::parse($detail->created_at)->format('Y/m/d H:i:s')); ?>">
                                        <?php echo e($detail->created_at); ?>

                                    </td>
                                    <td
                                        data-sort="<?php echo e(\Carbon\Carbon::parse($detail->exported_at)->format('Y/m/d H:i:s')); ?>">
                                        <?php echo e($detail->exported_at ? \Carbon\Carbon::parse($detail->exported_at)->format(config('app.datetime_format')) : ''); ?>

                                    </td>
                                    <td
                                        data-sort="<?php echo e(\Carbon\Carbon::parse($detail->submitted_at)->format('Y/m/d H:i:s')); ?>">

                                        <?php echo e($detail->submitted_at ? \Carbon\Carbon::parse($detail->submitted_at)->format(config('app.datetime_format')) : ''); ?>

                                    </td>

                                    <td data-sort="<?php echo e(\Carbon\Carbon::parse($detail->approved_at)->format('Y/m/d H:i:s')); ?>"  class="approved_on_content d-none">

                                        <?php echo e($detail->approved_at ? \Carbon\Carbon::parse($detail->approved_at)->format(config('app.datetime_format')) : ''); ?>

                                    </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($submissions->total() == 0): ?>
                                    <tr class="noreocrd">
                                        <td colspan="10" class="text-center">
                                            <?php echo e(__('submissions.empty')); ?>

                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        </div>
                    </form>
                </section>
            </div>
        </div>
    </div>
    <div class="modal fade" id="confirm-action-modal-submission" tabindex="-1" role="dialog" aria-hidden="true">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"><img
                    src="<?php echo e(asset('assets/front/images/close-model.svg')); ?>" alt="close button"></span>
        </button>
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h2><strong>Confirm</strong></h2>
                </div>
                <div class="modal-body">
                    <div id="dependent_msg_submission"></div>
                    Are you sure you want to <strong class="modal-action-name"></strong> the selected
                    <?php echo e(collect(request()->segments())->last()); ?>(s) ?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-sm btn-dark" data-dismiss="modal">Cancel</button>
                    <a href="#" id="display_submit_btn"
                        class="confirm-action-submissions-submit btn btn-sm btn-primary"><?php echo e(__('submissions.submit_btn')); ?></a>
                    <a href="#" id="display_export_btn"
                        class="confirm-action-submissions-submit btn btn-sm btn-primary"><?php echo e(__('submissions.export_btn')); ?></a>
                    <a href="#" id="display_certificate_btn"
                        class="confirm-action-submissions-submit btn btn-sm btn-primary hide"><?php echo e(__('submissions.certificate_btn')); ?></a>
                    <a href="#" id="display_approve_btn"
                        class="confirm-action-submissions-submit btn btn-sm btn-primary hide"><?php echo e(__('submissions.approve_btn')); ?></a>
                </div>
            </div>
        </div>
    </div>
    <script>
        checkStatusOfSelection();
        // Function to show or hide dateRange based on selected value
        function toggleDateRange(selectedValue) {
            if (selectedValue == 3) {
                $('#dateRange').show();
            } else {
                $('#dateRange').hide();
            }
        }

        function toggleApprovedOnColumn(selectedValueStatus) {
            if (selectedValueStatus == 4) {
                $('#approved_on_header').removeClass("d-none");
                $('.approved_on_content').removeClass("d-none");
            } else {
                $('#approved_on_header').addClass("d-none");
                $('.approved_on_content').addClass("d-none");
            }
        }

        var selectedValue = $('#type').val();
        var selectedValueStatus = $('#status').val();
        toggleDateRange(selectedValue);
        toggleApprovedOnColumn(selectedValueStatus);

        $('#type').change(function() {
            var selectedValue = $(this).val();
            toggleDateRange(selectedValue);
        });
        $('#status').change(function() {
            var selectedValueStatus = $(this).val();
            toggleApprovedOnColumn(selectedValueStatus);
        });

        $(document).on("click", "#export_btn", function() {
            $('#frmsearch').append('<input type="hidden" name="export" value="<?php echo e(__('submissions.export')); ?>">');
            $('#frmsearch').attr('target', '_blank').submit();
            $(".loader").hide();
            location.reload();
        });

        $(document).on("change", "input.action-checkbox-submissions[name='id[]']", function() {

            checkStatusOfSelection();
            if (
                $("input.action-checkbox-submissions[name='id[]']").filter(":checked").length ==
                $("input.action-checkbox-submissions[name='id[]']").length
            ) {
                $("#selectAllSubmissions").prop("checked", true);
            } else {
                $("#selectAllSubmissions").prop("checked", false);
            }
        });

        /* Start: Check All */
        function checkAllSubmissions() {
            if ($("#selectAllSubmissions").prop("checked") == true) {
                $("input.action-checkbox-submissions[name='id[]']").each(function() {
                    $(this).prop("checked", true);
                });
            } else {
                $("input.action-checkbox-submissions[name='id[]']").each(function() {
                    $(this).prop("checked", false);
                });
            }
            checkStatusOfSelection();
        }

        function checkStatusOfSelection() {
            $('.export-btn').hide();
            $('.submitted-btn').hide();
            $('.approved-btn').hide();
            $('#action_btns-submissions').hide();
            $('#display_export_btn').hide();
            $('#display_submit_btn').hide();
            $('#display_approve_btn').hide();
            $('#display_certificate_btn').hide();
            var checkedValues = [];
            var countReceived = 0;
            var countExported = 0;
            var countSubmitted = 0;
            var countApproved = 0;

            $("input.action-checkbox-submissions[name='id[]']:checked").each(function() {
                var idValue = $(this).val();
                checkedValues.push(idValue);
                var statusValue = $("input.action-checkbox-submissions[name='status[" + idValue + "]']").val();

                if (statusValue == 0) {
                    countReceived++;
                } else if (statusValue == 1) {
                    countExported++;
                } else if (statusValue == 2) {
                    countSubmitted++;
                } else if (statusValue == 4) {
                    countApproved++;
                }
            });
            if (checkedValues.length > 0) {
                $('#action_btns-submissions').show();
            } else {
                $('#action_btns-submissions').hide();
            }

            if (checkedValues.length > 0 && checkedValues.length === countReceived) {
                $('.export-btn').show();
            } else if (checkedValues.length > 0 && checkedValues.length === countExported) {
                $('.submitted-btn').show();
            } else if (checkedValues.length > 0 && checkedValues.length === countSubmitted) {
                $('.approved-btn').show();
            } else {
                $('.export-btn').hide();
                $('.submitted-btn').hide();
                $('.approved-btn').hide();
            }
        }

        function submitactionformSubmission(action) {
            $("input[name='bulk-action']").val(action);
            if (action == "export") {
                $("#display_export_btn").show();
            } else if (action == "submit") {
                $("#display_submit_btn").show();
            } else if (action == "send certificate") {
                $("#display_certificate_btn").show();
            } else if (action == "approve") {
                $("#display_approve_btn").show();
            }
            var html = "";
            $("#dependent_msg_submission").html(html);
            var actionText = action;
            $(".modal-action-name").html(actionText.toUpperCase());
            $("#confirm-action-modal-submission").modal("show");
        }

        $(".confirm-action-submissions-submit").click(function() {
            if ($("input[name='bulk-action']").val() == "export") {
                $('#frmlist').submit();

                $("#confirm-action-modal-submission").modal("hide");

                $(".ajax_message").removeClass("d-none");
                $(".ajax_message")
                    .find("span")
                    .addClass("successmessage")
                    .addClass("text-success")
                    .html("<?php echo e(__('submissions.exported_success')); ?>");
                setTimeout(function() {
                    $(".ajax_message")
                        .find("span")
                        .html("");
                    location.reload();
                }, message_display_time);
            } else if ($("input[name='bulk-action']").val() == "submit") {
                var html = ""
                if ($("input[name='bulk-action']").val() == "submit") {
                    html = "<?php echo e(__('submissions.submitted_success')); ?>";
                } else if ($("input[name='bulk-action']").val() == "send certificate") {
                    html = "<?php echo e(__('submissions.send_certificated_success')); ?>";
                }
                $('#frmlist').submit();

                $("#confirm-action-modal-submission").modal("hide");

                $(".ajax_message").removeClass("d-none");
                $(".ajax_message")
                    .find("span")
                    .addClass("successmessage")
                    .addClass("text-success")
                    .html(html);
                setTimeout(function() {
                    $(".ajax_message")
                        .find("span")
                        .html("");
                    location.reload();
                }, 2000);
            } else {
                var html = ""
                if ($("input[name='bulk-action']").val() == "approve") {
                    html = "<?php echo e(__('submissions.approved_success')); ?>";
                } else if ($("input[name='bulk-action']").val() == "send certificate") {
                    html = "<?php echo e(__('submissions.send_certificated_success')); ?>";
                }
                $('#frmlist').submit();

                $("#confirm-action-modal-submission").modal("hide");

                $(".ajax_message").removeClass("d-none");
                $(".ajax_message")
                    .find("span")
                    .addClass("successmessage")
                    .addClass("text-success")
                    .html(html);
                setTimeout(function() {
                    $(".ajax_message")
                        .find("span")
                        .html("");
                    location.reload();
                }, 2000);
            }


        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/clearlylegal_production/resources/views/admin/modules/submissions/index.blade.php ENDPATH**/ ?>