<?php $__env->startSection('content'); ?>
    <form method="post" name="frmaddedit" id="frmaddedit" action="<?php echo e(route('site-config.save', ['module' => $module])); ?>"
        name="pwdform" id="pwdform" class="col s12">
        <?php echo csrf_field(); ?>
        <div class="row mb-3">
            <h1 class="col-lg-6 page-title"><?php echo e(__('siteconfig.pagetitle')); ?></h1>
            <div class="top-btn-box col-lg-6 text-center text-lg-right">
                <button tabindex="9" type="submit" class="btn btn-primary btn-sm" id="btnsave" name="btnsave"><em
                        class="icon-save_icon top-icon"></em> <span><?php echo e(__('common.save')); ?></span></button>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 site-config">
                <div class="accordion" id="site-config-accordion">
                    <?php $i = 0; ?>
                    <?php $__currentLoopData = config('siteconfig'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $config_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $showfirst = false; ?>
                        <?php if($i == 0): ?>
                            <?php $showfirst = true; ?>
                        <?php endif; ?>
                        <?php if($errors->any()): ?>
                            <?php $showfirst = false; ?>
                        <?php endif; ?>
                        <?php if($config_group['module'] != $module): ?>
                            <?php continue; ?>
                        <?php endif; ?>
                        <?php if($config_group['module'] != $module): ?>
                            <?php continue; ?>
                        <?php endif; ?>
                        <div class="card">
                            <?php
                                $i++;
                                $is_error = false;
                                $fileds = collect($config_group['inputs'])->pluck('name')->flatten()->all();
                                foreach ($fileds as $field):
                                    if ($errors->has($field)):
                                        $is_error = true;
                                    endif;
                                endforeach;
                            ?>
                            <div class="card-header p-0 bg-primary text-white" id="site-config-heading-<?php echo e($k); ?>">
                                <h5 class="mb-0">
                                    <a class="btn px-3 py-2 d-block text-left text-white" href="javacript:void(0);"
                                        data-toggle="collapse" data-target="#accordion-item-<?php echo e($k); ?>"
                                        aria-expanded="<?php echo e($is_error || $showfirst ? 'true' : 'false'); ?>"
                                        aria-controls="accordion-item-<?php echo e($k); ?>">
                                        <?php echo e(__($config_group['title'])); ?>

                                    </a>
                                </h5>
                            </div>

                            <div id="accordion-item-<?php echo e($k); ?>"
                                class="collapse <?php echo e($is_error || $showfirst ? 'show' : ''); ?>"
                                aria-labelledby="site-config-heading-<?php echo e($k); ?>">
                                <div class="card-body">
                                    <div class="row">
                                        <?php $__currentLoopData = $config_group['inputs']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $input): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if ($__env->exists('admin.modules.siteconfig.fields.' . $input['type'])) echo $__env->make('admin.modules.siteconfig.fields.' . $input['type'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </form>


    <script>
        $(document).ready(function() {
            let debounceTimer;
            let isPromocodeValid = true;

            const promocodeInput = $("input[name='stripe_discount_code']");
            const promocodeKeyInput = $("input[name='stripe_discount_key']");
            const promocodeValue = $("input[name='subscribe_popup_discount_value']");
            const promocodeExpireDate = $("input[name='subscribe_popup_date_value']");
            const promocodeExpireDateId = $("input[id='subscribe_popup_date_value']");
            const showSubscribePopupSelect = $("select[name='show_subscribe_popup']");
            const form = $("#frmaddedit");

            const errorSelectors = {
                key: "#stripe_discount_key_error",
                value: "#subscribe_popup_discount_value_error",
                expireDate: "#subscribe_popup_date_value_error"
            };

            const inputFields = {
                key: promocodeKeyInput,
                value: promocodeValue,
                expireDate: promocodeExpireDate
            };

            const errorMessages = {
                key: "<?php echo e(__('Unable to fetch discount key. Please check discount code and try again.')); ?>",
                value: "<?php echo e(__('Unable to fetch discount value. Please check discount code and try again.')); ?>",
                expireDate: "<?php echo e(__('Unable to fetch discount expire date. Please check discount code and try again.')); ?>"
            };

            // Ensure error containers exist
            $.each(errorSelectors, function(key, selector) {
                if ($(selector).length === 0) {
                    inputFields[key].after(
                        `<div class="errormessage" id="${selector.replace('#', '')}"></div>`);
                }
            });

            function callAjax(promocode) {
                const url = "<?php echo e(route('checkIfPromocodeExists', 'PROMOCODE')); ?>".replace('PROMOCODE',
                    encodeURIComponent(promocode));

                $.ajax({
                    type: "GET",
                    url: url,
                    success: function(response) {
                        const coupon = response.coupon;

                        if (!coupon) {
                            isPromocodeValid = false;
                            showErrorMessages();
                            return;
                        }

                        isPromocodeValid = true;

                        // Set discount display
                        let discountDisplay = '';
                        if (coupon.percent_off !== null) {
                            discountDisplay = `${coupon.percent_off}%`;
                        } else if (coupon.amount_off !== null) {
                            discountDisplay = `$${(coupon.amount_off / 100)}`;
                        }

                        promocodeValue.val(discountDisplay);

                        // Format expiration date
                        let formattedDate = '';
                        if (response.expires_at) {
                            const date = new Date(response.expires_at * 1000);
                            // Format date to YYYY-MM-DD
                            formattedDate = date.toISOString().split('T')[0];
                            console.log(formattedDate);
                        }

                        promocodeExpireDateId.val(formattedDate);
                    },
                    error: function() {
                        isPromocodeValid = false;
                        showErrorMessages();
                    }
                });
            }

            function showErrorMessages() {
                $.each(inputFields, function(key, input) {
                    input.val('').addClass('is-invalid');
                    $(errorSelectors[key]).text(errorMessages[key]);
                });
            }

            function clearErrorMessages() {
                $.each(inputFields, function(key, input) {
                    input.removeClass('is-invalid');
                    $(errorSelectors[key]).text('');
                });
            }

            function togglePromocodeFields() {
                const showFields = showSubscribePopupSelect.val() === "1";
                const displayStyle = showFields ? 'block' : 'none';

                promocodeInput.closest('.form-group, .input-group, .field-wrapper').css('display', displayStyle);
                promocodeValue.closest('.form-group, .input-group, .field-wrapper').css('display', displayStyle);
                promocodeExpireDate.closest('.form-group, .input-group, .field-wrapper').css('display',
                    displayStyle);
            }

            // Initial visibility check
            togglePromocodeFields();

            // Change event for dropdown
            showSubscribePopupSelect.on("change", function() {
                togglePromocodeFields();

                const shouldShow = $(this).val() === "1";
                if (shouldShow) {
                    const promocode = promocodeInput.val().trim();
                    if (promocode.length > 0) {
                        callAjax(promocode);
                    }
                } else {
                    isPromocodeValid = true;
                    $.each(inputFields, (key, input) => input.val('').removeClass('is-invalid'));
                    clearErrorMessages();
                }
            });

            // Debounced promocode input
            promocodeInput.on("input", function() {
                if (showSubscribePopupSelect.val() !== "1") return;

                clearTimeout(debounceTimer);

                debounceTimer = setTimeout(function() {
                    const promocode = promocodeInput.val().trim();

                    clearErrorMessages();

                    if (promocode.length === 0) {
                        $.each(inputFields, (key, input) => input.val(''));
                        return;
                    }

                    callAjax(promocode);
                }, 500);
            });

            // Prevent form submission if promocode is invalid
            form.on("submit", function(e) {
                if (showSubscribePopupSelect.val() === "1" && !isPromocodeValid) {
                    e.preventDefault();
                    alert("Invalid promocode. Please correct it before submitting the form.");
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/clearlylegal_production/resources/views/admin/modules/siteconfig/index.blade.php ENDPATH**/ ?>