<!doctype html>
<html class="nojs">
<!--[if IE 7]><html lang="en" class="ie7"><![endif]-->
<!--[if IE 8]><html lang="en" class="ie8"><![endif]-->
<!--[if IE 9]><html lang="en" class="ie9"><![endif]-->
<!--[if (gt IE 9)|!(IE)]><html lang="en"><![endif]-->
<!--[if !IE]><html lang="en-US"><![endif]-->

<head>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>Successful</title>

    <!-- OG Tag -->
    <meta name="description"
        content="CLE on-the-go by podcast. No more boring conference rooms or CLE during billable hours.">
    <meta name="keywords" content="">
    <meta name="og:title" content="CLEarly Legal">
    <meta property="og:image" content="<?php echo e(asset('assets/web/images/assets/img_social_og.jpg')); ?>" />
    <meta name="og:description"
        content="CLE on-the-go by podcast. No more boring conference rooms or CLE during billable hours.">


    <!-- Favicon icon -->
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/web/images/logo/favicon.png')); ?>" sizes="16x16">

    <!-- Apple touch icon -->
    <link rel="apple-touch-icon" href="<?php echo e(asset('assets/web/images/logo/apple-touch-icon.png')); ?>" />


    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/web/styles/bootstrap.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/web/styles/custom.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/web/styles/layout.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/web/styles/fonts.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/web/styles/font-awesome.min.css')); ?>">

    <!--	JS  -->

    <!--[if lt IE 9]>
 <script src="js/html5shiv.js"></script>
 <script src="js/respond.min.js"></script>
<![endif]-->
    <!--[if !IE]><!-->
    <script>
        if ( /*@cc_on!@*/ false) {
            document.documentElement.className += ' ie10';
        }
    </script><!--<![endif]-->

    <!-- =======================================================
  
  ======================================================== -->
    <!-- Google reCAPTCHA CDN -->
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>

</head>

<body class="p-0">
    <div class="successful_bg d-flex justify-content-center align-items-center ">
        <div class="container">


            <div class="row justify-content-center text-center">
                <div class="col-sm-10">
                    <img src="<?php echo e(asset('assets/web/images/icons/successful.svg')); ?>"
                        class="img-fluid mx-auto d-block mb-5">
                    <h2 class="payment_msg_head">Payment Successful!</h2>
                    <p>Your payment has been processed.</p>
                    <p>If you weren’t automatically redirected, please click here to <a href="<?php echo e(env('CL_APP_URL')); ?>">log in</a></p>
                </div>
            </div>
        </div>
    </div>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
          setTimeout(() => {
            window.location.href = "<?php echo e(env('CL_APP_URL')); ?>"; 
          }, 5000);
        })
      </script>
</body>

</html>
<?php /**PATH /var/www/html/clearlylegal_production/resources/views/admin/payment/success.blade.php ENDPATH**/ ?>