<?php $__env->startSection('content'); ?>
    <div class="row mx-0 mb-3">
        <div class="col-6">
            <h1 class="page-title"><?php echo __('subscriptions.pagetitle'); ?></h1>
        </div>
        <div class="top-btn-box col-6" id="normal_btns">
            <div class="top-btn-box d-flex justify-content-end align-items-center h-100">
                <a tabindex="1" href="javascript:void(0)" class="btn btn-primary mr-1 search-btn btn-sm show hide"
                    id="search-btn">
                    <em class="icon-search-icon top-icon"></em>
                    <span class="btn-title"><?php echo e(__('common.search')); ?></span>
                </a>
            </div>
        </div>

        <div class="top-btn-box hide col-6" id="action_btns">
            <div class="top-btn-box d-flex justify-content-end align-items-center h-100 ">
                <a href="javascript:void(0)" class="btn btn-dark btn-sm delete-btn" onclick="submitactionform('delete');"
                    id="delete-btn" title="<?php echo e(__('common.delete')); ?>">
                    <em class="icon-close-icon top-icon"></em>
                    <span class="btn-title"><?php echo e(__('common.delete')); ?></span>
                </a>
            </div>

        </div>
    </div>

    <div class="col-12 admin-holder">
        <div class="row">
            <div class="<?php echo e(Request::has('search') ? 'show' : 'hide'); ?>" id="searchbox">
                <form name="frmsearch" id="frmsearch"
                    action="<?php echo e($subscriptions->appends(prepareInputRequestArray())->url(1)); ?>" method="GET"
                    class="col-12">
                    <?php $__currentLoopData = Request::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(in_array($key, ['search', 'status', 'btnsearch', 'name', 'bar', 'status', 'firm', 'export'])): ?>
                            <?php continue; ?>
                        <?php else: ?>
                            <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="row">
                        

                        
                        
                        <div class="form-group col-xl-3 col-lg-5 col-md-6 col-12">
                            <label><?php echo e(__('subscriptions.name_filter')); ?></label>
                            <select tabindex="5" name="name" id="name-filter" class="form-control selectpicker" data-live-search="true">
                                <option value=""><?php echo e(__('subscriptions.select_name')); ?></option>
                                <?php if(!empty($namefilter)): ?>
                                    <?php $__currentLoopData = $namefilter; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($id); ?>"
                                            <?php echo e(Request::get('name') != '' && intval(Request::get('name')) === $id ? 'selected' : ''); ?>>
                                            <?php echo e($name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                        </div>

                        
                        <div class="form-group  col-xl-3 col-lg-5 col-md-6 col-12">
                            <label><?php echo e(__('subscriptions.bar_filter')); ?></label>
                            <select tabindex="5" name="bar" id="bar-filter" class="form-control selectpicker">
                                <option value=""><?php echo e(__('subscriptions.select_bar')); ?></option>
                                <?php if(!empty($barfilter)): ?>
                                    <?php $__currentLoopData = $barfilter; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($id); ?>"
                                            <?php echo e(Request::get('bar') != '' && intval(Request::get('bar')) === $id ? 'selected' : ''); ?>>
                                            <?php echo e($name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                        </div>

                        
                        <div class="form-group  col-xl-3 col-lg-5 col-md-6 col-12">
                            <label><?php echo e(__('subscriptions.status_filter')); ?></label>
                            <select tabindex="5" name="status" id="status-filter" class="form-control selectpicker">
                                <option value=""><?php echo e(__('subscriptions.select_status')); ?></option>
                                <?php if(!empty($statusfilter)): ?>
                                    <?php $__currentLoopData = $statusfilter; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($id); ?>"
                                            <?php echo e(Request::get('status') != '' && Request::get('status') === $id ? 'selected' : ''); ?>>
                                            <?php echo e($name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                        </div>

                        
                        <?php if(Auth::user()->user_type_id == 1): ?>
                            <div class="form-group  col-xl-3 col-lg-5 col-md-6 col-12">
                                <label><?php echo e(__('subscriptions.firm_filter')); ?></label>
                                <select tabindex="5" name="firm" id="firm-filter" class="form-control selectpicker">
                                    <option value=""><?php echo e(__('subscriptions.select_firm')); ?></option>
                                    <?php if(!empty($firmfilter)): ?>
                                        <?php $__currentLoopData = $firmfilter; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(!empty($name)): ?>
                                                <option value="<?php echo e($id); ?>"
                                                    <?php echo e(Request::get('firm') != '' && Request::get('firm') === $id ? 'selected' : ''); ?>>
                                                    <?php echo e($name); ?>

                                                </option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        <?php endif; ?>

                        

                        <div class="form-group col-12">
                            <button tabindex="6" type="submit" class="btn btn-primary submit-btn" id="btnsearch"
                                name="btnsearch"><?php echo e(__('common.search')); ?></button>
                            <a href="<?php echo e($reset_link); ?>" class="btn btn-primary reset-btn"
                                id="search_reset"><?php echo e(__('common.reset')); ?></a>
                            <button tabindex="7" type="button" class="btn btn-dark close-btn"
                                id="search-btn-h"><?php echo e(__('common.close')); ?></button>
                            <input tabindex="8" type="button" class="btn btn-primary submit-btn" id="export_btn"
                                 value=<?php echo e(__('subscriptions.export')); ?> />
                            <hr>
                        </div>
                    </div>
                </form>
            </div>

            <div class="col-12 photos-main">
                <section id="wrapper">
                    <form name="frmlist" id="frmlist" action="<?php echo e(route('subscriptions.bulkaction')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="bulk-action" value="">
                        <div class="table-responsive">
                        <table data-orders="0" data-target="0"
                            class="admintable table table-hover mb-0" aria-describedby="DataTableDesc" style="width: 100%">
                            <thead>
                                <tr>
                                    <th scope="col" class="control nosort">
                                        <!-- this blank column is responsive controll -->
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('subscriptions.username')); ?>

                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('subscriptions.bar')); ?>

                                            </span>
                                        </div>
                                    </th>
                                    <?php if(Auth::user()->user_type_id == 1): ?>
                                        <th scope="col">
                                            <div>
                                                <span>
                                                    <?php echo e(__('subscriptions.firm_name')); ?>

                                                </span>
                                            </div>
                                        </th>
                                    <?php endif; ?>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('subscriptions.subscription_status')); ?>

                                            </span>
                                        </div>
                                    </th>

                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('subscriptions.start_date')); ?>

                                            </span>
                                        </div>
                                    </th>
                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('subscriptions.end_date')); ?>

                                            </span>
                                        </div>
                                    </th>

                                    <th scope="col">
                                        <div>
                                            <span>
                                                <?php echo e(__('subscriptions.paid_by')); ?>

                                            </span>
                                        </div>
                                    </th>
                                    <?php if(Auth::user()->user_type_id == 2): ?>
                                        <th scope="col">
                                            <div>
                                                <span>
                                                    <?php echo e(__('subscriptions.action')); ?>

                                                </span>
                                            </div>
                                        </th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td></td>
                                        <td><?php echo e($detail->user_firstname); ?> <?php echo e($detail->user_lastname); ?></td>
                                        <td><?php echo e($detail->bar_name); ?></td>
                                        <?php if(Auth::user()->user_type_id == 1): ?>
                                            <td><?php echo e($detail->firm_name); ?></td>
                                        <?php endif; ?>
                                        <td>
                                            <span style="text-transform: uppercase;"><?php echo e($detail->stripe_subscription_status); ?></span>
                                            <?php if($detail->cancel_at_period_end == 1): ?>
                                                <br><span><?php echo e(__('subscriptions.canceled_renewal')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($detail->start_date); ?></td>
                                        <td><?php echo e($detail->end_date); ?></td>
                                        <td><?php echo e(($detail->paid_by == 2)?"FIRM":"USER"); ?></td>
                                        <?php if(Auth::user()->user_type_id == 2): ?>
                                            <td>
                                                <?php if($detail->paid_by == 2): ?>
                                                    <button type="button" class="btn btn-primary m-2 renewClick" data-user_id=<?php echo e($detail->user_id); ?> data-subscription_id=<?php echo e($detail->id); ?> data-bar_user_references_id=<?php echo e($detail->bar_user_references_id); ?>>Renew</button>
                                                    <?php if($detail->stripe_subscription_status != "canceled"): ?>
                                                        <?php if($detail->cancel_at_period_end != 1): ?>
                                                            <button type="button" class="btn btn-danger cancelCLick" data-subscription_id=<?php echo e($detail->id); ?> >Cancel</button>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($subscriptions->total() == 0): ?>
                                    <tr class="noreocrd">
                                        <td colspan="10" class="text-center">
                                            <?php echo e(__('subscriptions.empty')); ?>

                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        </div>
                    </form>
                </section>
            </div>
        </div>
    </div>
    <!-- Confirmation Modal -->
<div class="modal fade" id="confirmationModal" tabindex="-1" role="dialog" aria-labelledby="confirmationModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="confirmationModalLabel">Are you sure?</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          Proceed for payment now.
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="button" class="btn btn-primary" id="confirmProceedButton">Yes, Proceed!</button>
        </div>
      </div>
    </div>
  </div>
    <!-- Cancel Confirmation Modal -->
<div class="modal fade" id="cancelconfirmationModal" tabindex="-1" role="dialog" aria-labelledby="cancelconfirmationModal" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Are you sure?</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
            <b>You want to cancel your subscription?</b>
            <p>You'll still be able to use your subscription features till current plan expire.</p>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Not Now</button>
          <button type="button" class="btn btn-primary" id="cancelconfirmProceedButton">Yes, Proceed!</button>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra-js-2'); ?>
<script>
    $(document).ready(function() {

        var reloadRequired = <?php echo json_encode(session('reload'), 15, 512) ?>;
        if (reloadRequired) {
            $(".loader").addClass('d-flex');
            setTimeout(function() {
                $(".loader").removeClass('d-flex');
                window.location.href = "<?php echo e(route('subscriptions.index')); ?>";
            }, 3000); // 3000 milliseconds = 3 seconds
        }

        var bar_user_references_id = 0
        var subscription_id = 0
        var user_id = 0
        $(document).on('click','.renewClick',function() {
            subscription_id = $(this).attr("data-subscription_id")
            bar_user_references_id = $(this).attr("data-bar_user_references_id")
            user_id = $(this).attr("data-user_id")
            $('#confirmationModal').modal('show');
        });

        $(document).on('click','.cancelCLick',function() {
            subscription_id = $(this).attr("data-subscription_id")
            $('#cancelconfirmationModal').modal('show');
        });

        $('#confirmProceedButton').on('click', function() {
            window.location.href = "<?php echo e(route('renewalSubscription', [':id', 'subscription_id', 'bar_user_references_id'])); ?>".replace(':id', user_id).replace('subscription_id', subscription_id).replace('bar_user_references_id', bar_user_references_id);
        });
        $('#cancelconfirmProceedButton').on('click', function() {
            window.location.href = "<?php echo e(route('cancelSubscriptionByFirm', ':subscription_id')); ?>".replace(':subscription_id', subscription_id);
        });

        $(document).on("click", "#export_btn", function() {
            $('#frmsearch').append('<input type="hidden" name="export" value="<?php echo e(__('subscriptions.export')); ?>">');
            $('#frmsearch').attr('target', '_blank').submit();
            $(".loader").hide();
            location.reload();
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/clearlylegal_production/resources/views/admin/modules/subscriptions/index.blade.php ENDPATH**/ ?>