<?php $__env->startSection('content'); ?>
    <section class="innerpage_wrap">
        <div class="container">
            

            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($page->slug == 'press'): ?>
                    <?php echo $page->description; ?>

                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </section>

    <section class="pb-5 press_wrap pt-5">
        <div class="container">
            <div class="row">
                <?php if(!$news->isEmpty()): ?>
                    <div class="col-sm-8">
                        <?php $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $n): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="single-press">
                                <div class="press-img">
                                    <a href="<?php echo e(route('press.detail', $n->slug)); ?>" class="release_detail_click">
                                        <img src="<?php echo e($n->banner_path); ?>" class="img-fluid mx-auto d-block"
                                            alt="Release image">
                                    </a>
                                </div>
                                <div class="press-content">
                                    <h3 class="entry-title">
                                        <a href="<?php echo e(route('press.detail', $n->slug)); ?>"
                                            class="release_detail_click"><?php echo e($n->title); ?></a>
                                    </h3>
                                    <ul class="list-unstyled nav nav-pills">
                                        <li class="nav-item">
                                            <div class="entry-date">
                                                <?php echo e(\Carbon\Carbon::parse($n->created_at)->format(config('app.db_des_long'))); ?>,
                                                Posted by: <?php echo e($n->author); ?>

                                            </div>
                                        </li>
                                    </ul>
                                    <p class="blog-short-disp"><?php echo strip_tags($n->description); ?></p>
                                    <a href="<?php echo e(route('press.detail', $n->slug)); ?>"
                                        class="btn btn-light readmore_btn release_detail_click">Read More</a>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="col-sm-4">
                        <div class="widget widget-block">
                            <h3 class="widget-heading">Archives </h3>
                            <div class="archive-dropdown">
                                <select name="archive-dropdown" class="form-control mt-3" id="archive-dropdown"
                                    tabindex="7">
                                    <option value="">Select Month</option>
                                    <?php $__currentLoopData = $archiveMonths; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($month['year']); ?>-<?php echo e($month['month']); ?>">
                                            <?php echo e($month['name']); ?> <?php echo e($month['year']); ?> (<?php echo e($month['count']); ?>)
                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="col w-100 justify-content-center align-items-center d-flex">
                        <p>No press releases available.</p>
                    </div>
                <?php endif; ?>
            </div>

        </div>
    </section>

    <section class="bottom_line mb-5">
        <img src="<?php echo e(asset('assets/web/images/background/course_bottom_line.png')); ?>" width="" height=""
            class=" mx-auto d-block" alt="course_bottom_line">
    </section>

    <!-- ======= Subscribe Section ======= -->
    <?php echo $__env->make('front.modules.subscribe.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- End Subscribe Section -->

    <!-- ======= Account Section ======= -->
    <?php echo $__env->make('front.modules.contact.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- End Contact Section -->

    <script>
        $(document).ready(function() {
            $('#archive-dropdown').on('change', function() {
                let monthYear = $(this).val();

                $.ajax({
                    url: "<?php echo e(route('press.filter')); ?>",
                    type: "POST",
                    data: {
                        month_year: monthYear,
                        _token: "<?php echo e(csrf_token()); ?>",
                    },
                    success: function(response) {
                        if (response.success) {
                            $('.col-sm-8').html(response.data);
                        }
                    },
                    error: function() {
                        alert('Error fetching filtered news.');
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/clearlylegal_production/resources/views/front/pages/press.blade.php ENDPATH**/ ?>