<?php $__env->startSection('content'); ?>
    <form method="post" action="<?php echo e(isset($content->id) ? route('content.update', $content->id) : route('content.store')); ?>"
        name="frmaddedit" id="frmaddedit">
        <div class="row mx-0 mb-3">
            <div class="col-lg-6">
                <h1 class="content-title">
                    <?php echo e(isset($content->id) ? __('content.editpagetitle') : __('content.addpagetitle')); ?></h1>
            </div>
            <div class="col-lg-6 d-flex justify-content-lg-end justify-content-center align-items-center">
                <div class="top-btn-box">
                    <div class="top-btn-box d-flex">
                        <a tabindex="500" id="btncancel" href="<?php echo e(route('content.index')); ?>"
                            class="btn btn-sm btn-dark mr-1"><em class="icon-close-icon top-icon"></em>
                            <span><?php echo e(__('common.cancel')); ?></span></a>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1 formbtnsave" id="btnsave"
                            name="btnsave" value='save'><em class="icon-save_icon top-icon"></em>
                            <span><?php echo e(__('common.save')); ?></span></button>
                        <button tabindex="900" type="submit" class="btn btn-sm btn-primary mr-1" id="btnsave"
                            name="btnsave" value='savecontinue'><em class="icon-save_icon top-icon"></em>
                            <span><?php echo e(__('common.savecontinue')); ?></span></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <?php echo csrf_field(); ?>
            <?php if(isset($content->id)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>
            <div class="row">
                <div class="col-md-12">
                    <h2><?php echo e(__('content.content_content')); ?></h2>
                </div>
                

                <div class="form-group col-md-6">
                    <label for="podcast_title"><?php echo e(__('content.podcast_title')); ?><span class="text-danger">*</span></label>
                    <input id="podcast_title" type="text"
                        class="form-control <?php $__errorArgs = ['podcast_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="podcast_title"
                        value="<?php echo e(old('podcast_title', $content->podcast_title)); ?>" data-validator="required|max:100"
                        tabindex="1">

                    <div class="errormessage"> <?php $__errorArgs = ['podcast_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="form-group col-md-6" style="visibility:hidden;">
                    <label for="internal_cl_podcast_id"><?php echo e(__('content.internal_cl_podcast_id')); ?><span
                            class="text-danger">*</span></label>
                    <input id="internal_cl_podcast_id" type="text"
                        class="form-control <?php $__errorArgs = ['internal_cl_podcast_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        name="internal_cl_podcast_id"
                        value="<?php echo e(old('internal_cl_podcast_id', $content->internal_cl_podcast_id)); ?>"
                        data-validator="required|max:100" tabindex="2" disabled>

                    <div class="errormessage"> <?php $__errorArgs = ['internal_cl_podcast_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>


                <div class="form-group col-md-12">
                    <label for="short_description"><?php echo e(__('content.short_description')); ?></label>
                    <textarea id="short_description" type="text" class="form-control <?php $__errorArgs = ['short_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        name="short_description" tabindex="3"><?php echo e(old('short_description', $content->short_description)); ?></textarea>
                    <div class="errormessage">
                        <?php $__errorArgs = ['short_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="provider_type"><?php echo e(__('content.provider_type')); ?>

                        <span class="text-danger">*
                            <div id="tooltip" class="tooltip"></div>
                            <img src=<?php echo e(asset('assets/admin/images/info-black-popup.svg')); ?>

                                onclick="showTitle(this, event)">
                        </span>
                    </label>

                    <select id="provider_type" type="text"
                        class="form-control contentfield <?php $__errorArgs = ['provider_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="provider_type"
                        data-validator="required" tabindex="4">
                        <option value>Select <?php echo e(__('content.provider_type')); ?></option>
                        <?php $__currentLoopData = config('provider_type'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($value); ?>"
                                <?php echo e((int) old('provider_type', $content->provider_type) === $value ? 'selected' : ''); ?>>
                                <?php echo e($label); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <div class="errormessage">
                        <?php $__errorArgs = ['provider_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="provider_id"><?php echo e(__('content.provider_id')); ?><span class="text-danger">*</span></label>
                    <input type="hidden" id="selected_provider_id"
                        value="<?php echo e(old('provider_id', $content->provider_id)); ?>">

                    <select id="provider_id" type="text"
                        class="form-control contentfield <?php $__errorArgs = ['provider_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="provider_id"
                        data-validator="required" tabindex="5">
                        <option value>Select <?php echo e(__('content.provider_id')); ?></option>
                        <?php $__currentLoopData = $providersList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($value); ?>"
                                <?php echo e(old('provider_id', $content->provider_id) === $value ? 'selected' : ''); ?>>
                                <?php echo e($label); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <div class="errormessage">
                        <?php $__errorArgs = ['provider_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div id="otherOption" style="display: none;" class="form-group col-md-6">
                    <label for="provider_name"><?php echo e(__('content.provider_name')); ?><span class="text-danger">*</span></label>
                    <input id="provider_name" type="text"
                        class="form-control <?php $__errorArgs = ['provider_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="provider_name"
                        value="<?php echo e(old('provider_name', $content->provider_name)); ?>" tabindex="6">

                    <div class="errormessage"> <?php $__errorArgs = ['provider_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="form-group col-md-6" style="display:none">
                    <label for="file_type"><?php echo e(__('content.file_type')); ?><span class="text-danger">*</span></label>
                    <select id="file_type" type="text"
                        class="form-control contentfield <?php $__errorArgs = ['file_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="file_type"
                        data-validator="required" tabindex="7">
                        <option value>Select <?php echo e(__('content.file_type')); ?></option>
                        <?php $__currentLoopData = config('file_type'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($value); ?>"
                                <?php echo e((int) old('file_type', $content->file_type) === $value || $value == 1 ? 'selected' : ''); ?>>
                                <?php echo e($label); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <div class="errormessage">
                        <?php $__errorArgs = ['file_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="form-group col-md-6">
                    <label for="speaker"><?php echo e(__('content.speaker')); ?><span class="text-danger">*</span></label>
                    <input type="hidden" id="selected_speaker" value="<?php echo e(old('speaker', $content->speaker)); ?>">

                    <select id="speaker" class="form-control selectpicker <?php $__errorArgs = ['speaker'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        name="speaker[]" multiple data-live-search="true" title="Select Speakers"
                        data-validator="required" tabindex="5">
                        <?php
                            $selectedSpeakers = isset($podcastSpeakers)
                                ? $podcastSpeakers->pluck('speaker_id')->toArray()
                                : [];
                        ?>

                        <?php $__currentLoopData = $faculty; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($value->id); ?>"
                                <?php echo e(in_array($value->id, old('speaker', $selectedSpeakers)) ? 'selected' : ''); ?>>
                                <?php echo e($value->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </select>

                    <div class="errormessage">
                        <?php $__errorArgs = ['speaker'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <!-- Add Speaker Modal -->
                <div class="modal fade" id="addSpeakerModal" tabindex="-1" role="dialog"
                    aria-labelledby="addSpeakerModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="addSpeakerModalLabel">Add New Speaker</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <label for="newSpeakerName">Speaker Name<span class="text-danger">*</span></label>
                                <input type="text" id="newSpeakerName" class="form-control"
                                    placeholder="Enter speaker name">

                                <div class="errormessage">
                                    <span id="namefounderror" class="text-danger"></span>
                                </div>
                                <label for="newSpeakerEmail">Speaker Email<span class="text-danger">*</span></label>
                                <input type="text" id="newSpeakerEmail" class="form-control"
                                    placeholder="Enter speaker email">

                                <div class="errormessage">
                                    <span id="emailfounderror" class="text-danger"></span>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                <button type="button" id="saveSpeaker" class="btn btn-primary">Save Speaker</button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group col-md-6">
                    <label for="category_id"><?php echo e(__('content.category')); ?><span class="text-danger">*</span></label>
                    <select id="category_id" class="form-control contentfield <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        name="category_id" data-validator="required" tabindex="8">
                        <option value>Select <?php echo e(__('content.category')); ?></option>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category->id); ?>"
                                <?php echo e(isset($content->category_id) ? ($content->category_id == $category->id ? 'selected' : '') : ''); ?>>
                                <?php echo e($category->name ?? ''); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <div class="errormessage">
                        <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="cl_type"><?php echo e(__('content.cl_type')); ?><span class="text-danger">*</span></label>
                    <select id="cl_type" type="text"
                        class="form-control contentfield <?php $__errorArgs = ['cl_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="cl_type"
                        data-validator="required" tabindex="9">
                        <option value>Select <?php echo e(__('content.cl_type')); ?></option>
                        <?php $__currentLoopData = config('cl_type'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($value); ?>"
                                <?php echo e((int) old('cl_type', $content->cl_type) === $value ? 'selected' : ''); ?>>
                                <?php echo e($label); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <div class="errormessage">
                        <?php $__errorArgs = ['cl_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="form-group col-md-6">
                    <label><?php echo e(__('content.expire_date')); ?></label>
                    <input id="expire_date" type="text"
                        class="form-control datepicker <?php $__errorArgs = ['expire_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="expire_date"
                        value="<?php echo e(old('expire_date', $content->expire_date != null ? \Carbon\Carbon::parse($content->expire_date)->format(config('app.db_date_format')) : null)); ?>"
                        tabindex="11">
                    <div class="errormessage">
                        <?php $__errorArgs = ['expire_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="form-group col-md-6">
                    <?php $__env->startComponent('admin.component.status_dropdown', [
                        'refModel' => 'content',
                        'status' => $content->status,
                        'required' => false,
                        'default' => 1,
                        'tabindex' => 12,
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                </div>

                <div class="form-group col-md-6">
                    <label><?php echo e(__('content.published_on')); ?></label>
                    <input id="published_on" type="text"
                        class="form-control datetimepicker <?php $__errorArgs = ['published_on'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        name="published_on" value="<?php echo e(old('published_on', $content->published_on)); ?>" tabindex="11">
                    <div class="errormessage" id="published_on_error">
                        <?php $__errorArgs = ['published_on'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="form-group col-md-12">
                    <label for="prerequisites"><?php echo e(__('content.prerequisites')); ?></label>
                    <textarea id="prerequisites" type="text" class="form-control <?php $__errorArgs = ['prerequisites'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        name="prerequisites" value="<?php echo e(old('prerequisites', $content->prerequisites)); ?>" tabindex="10"maxlength="240"></textarea>
                    <div class="errormessage">
                        <?php $__errorArgs = ['prerequisites'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="col-md-12 banner-section">
                    <div class="form-group">
                        <label for="temp_image"><?php echo e(__('content.image')); ?></label>
                        <input type="file" id="temp_image" data-size="<?php echo e(getImageUploadSizeInMB('coursecategory')); ?>"
                            class="dropify image-upload" name="temp_image" data-folder="content"
                            <?php echo e(old('image', $content->image) != '' ? 'data-default-file=' . getImageUrl(old('image', $content->image), 'content') : ''); ?>

                            tabindex="14">
                        <div><small><?php echo e(getImageRecommendedSize('coursecategory')); ?></small></div>
                        <input name="image" type="hidden" value="<?php echo e(old('image', $content->image)); ?>">
                        <div id="error_image" class="errormessage  <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php else: ?><?php echo e('d-none'); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <?php echo e($message); ?>

                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>
                <div class="form-group col-md-6">
                    <label for="image_alt"><?php echo e(__('content.image_alt')); ?></label>
                    <input id="image_alt" type="text" class="form-control <?php $__errorArgs = ['image_alt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        name="image_alt" value="<?php echo e(old('image_alt', $content->image_alt ?? '')); ?>" tabindex="13">
                    <div class="errormessage">
                        <?php $__errorArgs = ['image_alt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <h2><?php echo e(__('content.upload_file')); ?></h2>
                </div>
                <div class="form-group col-md-12">
                    <div class="banner-section">
                        
                        
                        <div id="basic-uploader-audio" style="padding-top: 15px;">
                            <div class="row fileupload-buttonbar mb-1">
                                <div class="col-lg-7">
                                    <!-- The fileinput-button span is used to style the file input field as button -->
                                    <span class="btn btn-success fileinput-button" id="addfiles_audio">
                                        <em class="glyphicon glyphicon-plus"></em>
                                        <span>Add files...</span>
                                        <input type="file" name="files[]" multiple>
                                    </span>
                                    <button type="submit" id="startall" class="btn btn-primary start">
                                        <em class="glyphicon glyphicon-upload"></em>
                                        <span>Start Upload</span>
                                    </button>
                                    <span class="fileupload-process"></span>
                                    <div id="multiimage_error_image"
                                        class="errormessage  <?php $__errorArgs = ['multiimage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php else: ?><?php echo e('d-none'); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <?php $__errorArgs = ['multiimage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <?php echo e($message); ?>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <!-- The global progress state -->
                                <div class="col-lg-5 fileupload-progress">
                                    <!-- The global progress bar -->
                                    <div class="progress progress-striped active hide" role="progressbar"
                                        aria-valuemin="0" aria-valuemax="100">
                                        <div class="progress-bar progress-bar-success" style="width:0%;"></div>
                                    </div>
                                    <!-- The extended global progress state -->
                                    <div class="progress-extended">&nbsp;</div>
                                </div>
                                <div class="col-lg-12">
                                    <em class="text-muted"><small><?php echo e(getImageRecommendedSize('upload_file')); ?>

                                        </small></em>
                                </div>
                            </div>

                            <!-- dropzone -->
                            

                            <!-- file list -->
                            <div class="table-responsive">
                                <table class="table table-striped table-hovered upload-lists"
                                    aria-describedby="DataTableDesc">
                                    <thead style="display:none">
                                        <tr>
                                            <th scope="col"></th>
                                        </tr>
                                        <tr>
                                            <th scope="col"></th>
                                        </tr>

                                    </thead>
                                    <tbody class="files">

                                        <?php if(count(old('state_id', []))): ?>
                                            <?php $__currentLoopData = old('multiimage_ids', []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $imageIds): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <lable>File Name<span class="text-danger">*</span></lable></br>
                                                        <input type="text" name="multiimagefilename[]"
                                                            value="<?php echo e(old("multiimagefilename.$key")); ?>">
                                                        <div class="errormessage">
                                                            <?php $__errorArgs = ["multiimagefilename.$key"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <?php echo e($message); ?>

                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <lable>CLE ID<span class="text-danger">*</span></lable></br>
                                                        <input type="text" name="multiimagebarid[]"
                                                            value="<?php echo e(old("multiimagebarid.$key")); ?>">
                                                        <div class="errormessage">
                                                            <?php $__errorArgs = ["multiimagebarid.$key"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <?php echo e($message); ?>

                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <input type="hidden" name="multiimage_ids[]"
                                                            value="<?php echo e($imageIds); ?>">
                                                        <input type="hidden" name="multiimage[]"
                                                            value="<?php echo e(old("multiimage.$key")); ?>">
                                                        <input type="hidden" name="multiimageduration[]"
                                                            value="<?php echo e(old("multiimageduration.$key")); ?>">
                                                        <input type="hidden" name="multiimagesize[]"
                                                            value="<?php echo e(old("multiimagesize.$key")); ?>">
                                                        <a href="<?php echo e(getImageUrl(old("multiimage.$key"), 'upload_file')); ?>"
                                                            target="_blank"><?php echo e(old("multiimage.$key")); ?> </a>
                                                    </td>
                                                    <td>(<?php echo e(old("multiimageduration.$key")); ?>)</td>
                                                    <td></td>
                                                    <td style="text-align: right;">
                                                        <?php if($imageIds == 0): ?>
                                                            <button type="button"
                                                                class="btn btn-outline-danger remove_upload_file ">X</button>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php elseif($content): ?>
                                            <?php $__currentLoopData = $content->contentFiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <lable>File Name<span class="text-danger">*</span></lable></br>
                                                        <input type="text" name="multiimagefilename[]"
                                                            value="<?php echo e($file->view_file_name); ?>">
                                                        <div class="errormessage">
                                                            <?php $__errorArgs = ["multiimagefilename.$key"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <?php echo e($message); ?>

                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <lable>CLE ID<span class="text-danger">*</span></lable></br>
                                                        <input type="text" name="multiimagebarid[]"
                                                            value="<?php echo e($file->bar_id); ?>">
                                                        <div class="errormessage">
                                                            <?php $__errorArgs = ["multiimagebarid.$key"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <?php echo e($message); ?>

                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <input type="hidden" name="multiimage_ids[]"
                                                            value="<?php echo e($file->id); ?>">
                                                        <input type="hidden" name="multiimage[]"
                                                            value="<?php echo e($file->file); ?>">
                                                        <input type="hidden" name="multiimageduration[]"
                                                            value="<?php echo e(secondsToMinuteSecond($file->length)); ?>">
                                                        <input type="hidden" name="multiimagesize[]"
                                                            value="<?php echo e(bytesToMB($file->size)); ?>">
                                                        <a href="<?php echo e(getImageUrl($file->file, 'upload_file')); ?>"
                                                            target="_blank"><?php echo e($file->file); ?> </a>
                                                    </td>
                                                    <td>(<?php echo e(secondsToMinuteSecond($file->length)); ?>)</td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12 d-flex" style="justify-content: space-between">
                    <h2><?php echo e(__('content.add_state')); ?></h2>
                    <button type="button" class="btn btn-primary addnew-btn btn-sm" id="add_approve_state_btn"><em
                            class="icon-addnew top-icon"></em></button>
                </div>
                <div class="col-md-12">
                    <div class="add_more_approved_state">
                        <?php if(count(old('state_id', []))): ?>
                            <?php $__currentLoopData = old('state_id', []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $stateId): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <input type="hidden" name="state_id[]" value="<?php echo e($stateId); ?>">
                                        <label for="state"><?php echo e(__('content.state')); ?><span
                                                class="text-danger">*</span></label>
                                        <select id="state" type="text"
                                            class="form-control contentfield stateSelectCheck" data-validator="required"
                                            name="state[]" tabindex="15"
                                            data-validator-label="<?php echo e(__('content.state')); ?>">
                                            <option value>Select <?php echo e(__('content.state')); ?></option>
                                            <?php $__currentLoopData = $approvedstates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($value->id); ?>"
                                                    <?php if(old("state.$key") == $value->id): ?> selected <?php endif; ?>>
                                                    <?php echo e($value->state_name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <div class="errormessage">
                                            <?php $__errorArgs = ["state.$key"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <?php echo e($message); ?>

                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label
                                            for="credit_provided_by_the_course"><?php echo e(__('content.credit_provided_by_the_course')); ?><span
                                                class="text-danger">*</span></label>

                                        <div class="input-group ">
                                            <select id="credit_provided_by_the_course" type="text"
                                                class="form-control contentfield credit_field_by_the_course"
                                                data-validator="required" name="credit_provided_by_the_course[]"
                                                tabindex="16"
                                                data-validator-label="<?php echo e(__('content.credit_provided_by_the_course')); ?>">
                                                <option value>Select
                                                    <?php echo e(__('content.credit_provided_by_the_course')); ?>

                                                </option>
                                                <?php $__currentLoopData = config('lengthInMinutes'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $length): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($length); ?>"
                                                        <?php if(old("credit_provided_by_the_course.$key") == $length): ?> selected <?php endif; ?>
                                                        <?php if(old("state.$key") >= $length): ?> disabled <?php endif; ?>>
                                                        <?php echo e($length); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div class="input-group-append">
                                                <button type="button"
                                                    class="btn btn-outline-danger remove_approved_state_row">X</button>
                                            </div>
                                        </div>

                                        <div class="errormessage">
                                            <?php $__errorArgs = ["credit_provided_by_the_course.$key"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <?php echo e($message); ?>

                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <input type="hidden" class="form-control contentfield " name="state_bar_id[]"
                                        placeholder="CLE ID" tabindex="17" value="0">

                                    


                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php elseif($content->contentsStates && count($content->contentsStates) > 0): ?>
                            <?php $__currentLoopData = $content->contentsStates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $contentsState): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <input type="hidden" name="state_id[]" value="<?php echo e($contentsState->id); ?>">
                                        <label for="state"><?php echo e(__('content.state')); ?><span
                                                class="text-danger">*</span></label>

                                        <select id="state" type="text"
                                            class="form-control contentfield stateSelectCheck" data-validator="required"
                                            name="state[]" tabindex="18"
                                            data-validator-label="<?php echo e(__('content.state')); ?>">
                                            <option value>Select <?php echo e(__('content.state')); ?></option>
                                            <?php $__currentLoopData = $approvedstates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($value->id); ?>" <?php if($value->id == $contentsState->bar_id): echo 'selected'; endif; ?>>
                                                    <?php echo e($value->state_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <div class="errormessage">
                                            <?php $__errorArgs = ["state.$key"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <?php echo e($message); ?>

                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label
                                            for="credit_provided_by_the_course"><?php echo e(__('content.credit_provided_by_the_course')); ?><span
                                                class="text-danger">*</span></label>

                                        <div class="input-group ">
                                            <select id="credit_provided_by_the_course" type="text"
                                                class="form-control contentfield credit_field_by_the_course"
                                                data-validator="required" name="credit_provided_by_the_course[]"
                                                tabindex="19"
                                                data-validator-label="<?php echo e(__('content.credit_provided_by_the_course')); ?>">
                                                <option value>Select <?php echo e(__('content.credit_provided_by_the_course')); ?>

                                                </option>
                                                <?php $__currentLoopData = config('lengthInMinutes'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $length): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($length); ?>" <?php if($getStatesMinLength[$contentsState->bar_id] > $length): echo 'disabled'; endif; ?>
                                                        <?php if($length == $contentsState->credit_provided_by_the_course && !($getStatesMinLength[$contentsState->bar_id] > $length)): echo 'selected'; endif; ?>>
                                                        <?php echo e($length); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div class="input-group-append">
                                                <button type="button"
                                                    class="btn btn-outline-danger remove_approved_state_row">X</button>
                                            </div>
                                        </div>

                                        <div class="errormessage">
                                            <?php $__errorArgs = ["credit_provided_by_the_course.$key"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <?php echo e($message); ?>

                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <input type="hidden" class="form-control contentfield " name="state_bar_id[]"
                                        placeholder="CLE ID" tabindex="17" value="0">

                                    


                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <input type="hidden" name="state_id[]" value="0">
                                    <label for="state"><?php echo e(__('content.state')); ?><span
                                            class="text-danger">*</span></label>
                                    <select id="state" type="text"
                                        class="form-control contentfield stateSelectCheck" name="state[]"
                                        data-validator="required" data-validator-label="<?php echo e(__('content.state')); ?>"
                                        tabindex="21">
                                        <option value>Select <?php echo e(__('content.state')); ?></option>
                                        <?php $__currentLoopData = $approvedstates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($value->id); ?>">
                                                <?php echo e($value->state_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="errormessage">
                                        <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <?php echo e($message); ?>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label
                                        for="credit_provided_by_the_course"><?php echo e(__('content.credit_provided_by_the_course')); ?><span
                                            class="text-danger">*</span></label>

                                    <select id="credit_provided_by_the_course" type="text"
                                        class="form-control contentfield credit_field_by_the_course"
                                        data-validator="required" name="credit_provided_by_the_course[]" tabindex="22"
                                        data-validator-label="<?php echo e(__('content.credit_provided_by_the_course')); ?>">
                                        <option value>Select <?php echo e(__('content.credit_provided_by_the_course')); ?></option>
                                        <?php $__currentLoopData = config('lengthInMinutes'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $length): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($length); ?>">
                                                <?php echo e($length); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="errormessage">
                                        <?php $__errorArgs = ['credit_provided_by_the_course'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <?php echo e($message); ?>

                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <input type="hidden" class="form-control contentfield " name="state_bar_id[]"
                                    placeholder="CLE ID" tabindex="17" value="0">

                                
                            </div>
                        <?php endif; ?>


                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group col-sm-2">
                        <!-- comment as per discussion on call with rahul -->
                        
                    </div>
                </div>
            </div>

        </div>
    </form>

    <script>
        function repopulateProviderIdDropdown(providerTypeValue) {
            $('#provider_id').empty();
            $('#provider_id').append($('<option>', {
                value: "",
                text: "Select <?php echo e(__('content.provider_id')); ?>"
            }));

            let url = '';

            if (providerTypeValue == 1) {
                url = '<?php echo e(route('user.getAdminUsers')); ?>';
            } else if (providerTypeValue == 2) {
                url = '<?php echo e(route('user.getSponsoredList')); ?>';
            } else if (providerTypeValue == 3) {
                url = '<?php echo e(route('user.getPartnerList')); ?>';
            }

            // Make AJAX request to repopulate the dropdown
            $.ajax({
                url: url,
                type: 'GET',
                success: function(response) {
                    // Append new options based on the response data
                    $.each(response.data, function(index, element) {
                        $('#provider_id').append($('<option>', {
                            value: index,
                            text: element
                        }));
                    });
                    var selectedProviderId = $('#selected_provider_id').val();
                    if (selectedProviderId != 0) {
                        $('#provider_id').val(selectedProviderId)
                        if (selectedProviderId == "other") {
                            $('#otherOption').show();
                            $('#provider_name').attr("data-validator", "required|max:100");
                        }
                    }
                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });


        }

        function removeValidateForcly() {
            // based on changes
            //if all okay then remove all data-validator class. and this code also
            $('input').each(function(i) {
                $(this).removeAttr("data-validator");
            });
            $('select').each(function(i) {
                $(this).removeAttr("data-validator");
            });
        }
        $(document).ready(function() {
            removeValidateForcly(); // based on changes
            var providerTypeValue = $('#provider_type').val(); // Store the selected value
            if (providerTypeValue) {
                // Repopulate the dropdown based on the stored value
                repopulateProviderIdDropdown(providerTypeValue);
            }
            //Manage or add new option or other option based on provider selection of other
            $(document).on('change', '#provider_id', function(data) {
                var selectedValue = this.value;
                $("#provider_name").val('');
                if (selectedValue === 'other') {
                    $('#otherOption').show();
                    $('#provider_name').attr("data-validator", "required|max:100");
                } else {
                    $('#otherOption').hide();
                    $('#provider_name').removeAttr("data-validator");
                    $('#provider_name').addClass("is-invalid");
                }
                removeValidateForcly(); // based on changes
            });

            //load provider name based on selection of provider_type
            $(document).on('change', '#provider_type', function(data) {
                var providerTypeValue = $(this).val(); // Get the selected value
                // Repopulate the dropdown based on the selected value
                $('#selected_provider_id').val(0);
                repopulateProviderIdDropdown(providerTypeValue);
            });



            $(document).on('change', '.stateSelectCheck', function(data) {

                if ($(this).val() != '') {
                    $(this).parent().find('.errormessage').text("");
                    var selectedId = $(this).val();
                    var minLength = <?php echo json_encode($getStatesMinLength); ?>[selectedId];

                    $(this).parent().parent().find('.credit_field_by_the_course option').each(function() {
                        if (parseInt(minLength) <= parseInt($(this).val())) {
                            $(this).prop('disabled', false);
                        } else {
                            $(this).prop('disabled', true);
                        }
                    });
                    $(this).parent().parent().find('.credit_field_by_the_course').val(parseInt(minLength))

                    var selectedValueArray = [];
                    $('.stateSelectCheck').not(this).each(function() {
                        selectedValueArray.push($(this).val());
                    });

                    if (selectedValueArray.includes($(this).val())) {
                        $(this).parent().find('.errormessage').text(
                            "<?php echo e(__('content.duplicate_selection_found')); ?>");
                        $(this).val('');
                    }
                }
            });


            /*$('.single-audio-upload-file-name').hide();
            $(document).on('change', '#temp_upload_file', function(data) {
                var fileList = event.target.files;
                if (fileList.length > 0) {
                    var uploadedFile = fileList[0];
                    var fileName = uploadedFile.name;
                    console.log('Uploaded file name:', fileName);
                    $('#single-audio-upload-file-name').text(fileName);
                    $('.single-audio-upload-file-name').show();
                }
            });
            $(document).on('click', '.dropify-clear', function(data) {
                $('.single-audio-upload-file-name').hide();
            }); */

            //Add more approved state button functionality
            $(document).on('click', '.remove_upload_file', function() {

                // let row = $(this).closest('tr');
                // let file = row.find('input[name="multiimage[]"]').val(); // Get the file Name
                // if (file) {
                //     $.ajax({
                //         url: "<?php echo e(route('upload.deleteFile')); ?>",
                //         type: "POST",
                //         data: {
                //             _token: "<?php echo e(csrf_token()); ?>",
                //             file: file
                //         },
                //         success: function(response) {
                //             if (response.success) {
                //                 // alert("Success: " + response.message);

                //             } else {
                //                 console.log("Error: " + response.message);
                //             }
                //         },
                //         error: function() {
                //            console.log('Something went wrong. Please try again.')
                //         }
                //     });
                // }
                $(this).parent().parent().remove();
            });
            $(document).on('click', '#add_approve_state_btn', function() {
                var row_col = `<div class="row remove"><div class="form-group col-md-6">
                    <input type="hidden" name="state_id[]" value="0">
                        <label for="state"><?php echo e(__('content.state')); ?><span
                                class="text-danger">*</span></label>
                        <select id="state" type="text" class="form-control contentfield stateSelectCheck"
                            name="state[]" tabindex="24" data-validator="required" data-validator-label="<?php echo e(__('content.state')); ?>">
                            <option value>Select <?php echo e(__('content.state')); ?></option>
                            <?php $__currentLoopData = $approvedstates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($value->id); ?>">
                                    <?php echo e($value->state_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <div class="errormessage">
                            <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <?php echo e($message); ?>

                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="credit_provided_by_the_course"><?php echo e(__('content.credit_provided_by_the_course')); ?><span class="text-danger">*</span></label>

                        <div class="input-group ">
                        <select id="credit_provided_by_the_course" type="text" class="form-control contentfield credit_field_by_the_course"
                            data-validator="required" name="credit_provided_by_the_course[]" tabindex="25"
                            data-validator-label="<?php echo e(__('content.credit_provided_by_the_course')); ?>">
                            <option value>Select <?php echo e(__('content.credit_provided_by_the_course')); ?></option>
                            <?php $__currentLoopData = config('lengthInMinutes'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $length): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($length); ?>">
                                    <?php echo e($length); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <div class="input-group-append">
                            <button type="button" class="btn btn-outline-danger remove_approved_state_row">X</button>
                        </div>
                        </div>

                        <div class="errormessage">
                            <?php $__errorArgs = ['credit_provided_by_the_course'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <?php echo e($message); ?>

                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <input type="hidden" class="form-control contentfield " name="state_bar_id[]" placeholder="CLE ID" tabindex="17" value="0">

                </div>`;

                // <div class="form-group col-md-4 ">
                //         <label for="state_bar_id"><?php echo e(__('content.state_bar_id')); ?><span
                //                 class="text-danger">*</span></label>
                //         <div id="state_container">
                //             <div class="input-group ">
                //                 <input type="text"
                //                     class="form-control contentfield <?php $__errorArgs = ['state_bar_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                //                     name="state_bar_id[]" placeholder="State id" data-validator="required"
                //                     value="" data-validator-label="state"
                //                     aria-label="State id" >
                //                 <div class="input-group-append">
                //                     <button type="button"
                //                         class="btn btn-outline-danger remove_approved_state_row">X</button>
                //                 </div>
                //             </div>
                //             <div class="errormessage">
                //                     <?php $__errorArgs = ['state_bar_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                //                         <?php echo e($message); ?>

                //                     <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                //                 </div>
                //         </div>
                //     </div>
                $('.add_more_approved_state').append(row_col);
                removeValidateForcly(); // based on changes
            });

            $(document).on('click', '.remove_approved_state_row', function() {
                $(this).closest('.row').remove();
            });
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const publishedOnInput = document.getElementById("published_on");
            const form = document.querySelector("#frmaddedit");
            const errorMessage = document.querySelector("#published_on_error");

            // Date format: MM/DD/YYYY HH:mm (24-hour format)
            function isValidDateFormat(dateStr) {
                const dateTimeRegex = /^\d{2}\/\d{2}\/\d{4} \d{2}:\d{2}$/; // MM/DD/YYYY HH:mm
                return dateTimeRegex.test(dateStr);
            }

            // Validate on input change
            publishedOnInput.addEventListener("input", function() {
                if (!isValidDateFormat(publishedOnInput.value)) {

                    if (publishedOnInput.value == "") {
                        publishedOnInput.classList.remove("is-invalid");
                        errorMessage.textContent = "";
                    } else {
                        publishedOnInput.classList.add("is-invalid");
                        errorMessage.textContent = "Invalid date format. Use MM/DD/YYYY HH:mm.";
                    }

                } else {
                    publishedOnInput.classList.remove("is-invalid");
                    errorMessage.textContent = "";
                }
            });

            // Validate on form submission
            form.addEventListener('submit', event => {
                if (!isValidDateFormat(publishedOnInput.value)) {
                    console.log("Invalid date format detected, preventing submission");
                    if (publishedOnInput.value == "") {
                        errorMessage.textContent = "";
                    } else {
                        // event.preventDefault(); // Stop form submission
                        publishedOnInput.classList.add("is-invalid");
                        errorMessage.textContent = "Invalid date format. Use MM/DD/YYYY HH:mm.";
                        // return false; // Ensure it stops execution
                    }

                }
            });
        });
    </script>

    <!-- JavaScript to Handle Search & Adding Speaker -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let speakerSelect = document.getElementById("speaker");
            let selectpicker = $(".selectpicker");
            let typingTimer;
            const typingDelay = 500; // Time in milliseconds to wait after user stops typing

            function updateAddSpeakerOption() {

                $(speakerSelect).on("shown.bs.select", function() {
                    let searchInput = document.querySelector(".bs-searchbox input");

                    if (searchInput) {
                        searchInput.addEventListener("input", function() {

                            clearTimeout(typingTimer);

                            typingTimer = setTimeout(() => {

                                let searchValue = this.value.trim().toLowerCase();
                                let found = false;

                                $("#speaker option").each(function() {
                                    if ($(this).text().toLowerCase().includes(
                                            searchValue)) {

                                        found = true;
                                    }
                                });

                                let noResultsMessage = $(".no-results");
                                let addNewSpeakerOption = $("#add_new_speaker_option");

                                // Remove old "Add Speaker" option if it exists
                                addNewSpeakerOption.remove();

                                if (!found && searchValue.length > 0) {

                                    if (noResultsMessage.length > 0) {
                                        // Append the "Add Speaker" button right after "No results found"
                                        noResultsMessage.after(
                                            `<li id="add_new_speaker_option" class="text-primary dropdown-item add-speaker-btn" style="cursor: pointer;">
                                            + Add "${searchValue}"
                                        </li>`
                                        );
                                    }
                                }
                            }, typingDelay);
                        });
                    }
                });
            }

            selectpicker.on("shown.bs.select", updateAddSpeakerOption());

            // Listen for clicks on the "Add New Speaker" option
            $(document).on("click", "#add_new_speaker_option", function() {
                let searchValue = $(".bs-searchbox input").val();
                $("#newSpeakerName").val(searchValue);
                $("#namefounderror").text("");
                $("#emailfounderror").text("");
                $("#addSpeakerModal").modal("show");

                // Close the dropdown
                selectpicker.selectpicker("toggle");
            });

            document.getElementById("saveSpeaker").addEventListener("click", function() {
                let newSpeakerName = document.getElementById("newSpeakerName").value.trim();
                let newSpeakerEmail = document.getElementById("newSpeakerEmail").value.trim();

                if (newSpeakerName !== "") {
                    $.ajax({
                        url: "<?php echo e(route('speaker.store')); ?>",
                        type: "POST",
                        data: {
                            name: newSpeakerName,
                            email: newSpeakerEmail,
                            _token: $('meta[name="csrf-token"]').attr("content") // CSRF token
                        },
                        success: function(data) {
                            if (data.success) {
                                let newOption = new Option(newSpeakerName, data.id, false,
                                    true);
                                $("#speaker").append(newOption);
                                $(".selectpicker").selectpicker("refresh");
                                $("#addSpeakerModal").modal("hide");
                                $("#speaker").val([...$("#speaker").val(), data.id])
                                    .selectpicker("refresh").trigger('change');

                                // success toast
                                var html = "Speaker added successfully."
                                $(".ajax_message").removeClass("d-none");
                                $(".ajax_message")
                                    .find("span")
                                    .addClass("successmessage")
                                    .addClass("text-success")
                                    .html(html);
                                setTimeout(function() {
                                    $(".ajax_message")
                                        .find("span")
                                        .html("");
                                }, 2000);
                            }
                        },
                        error: function(xhr) {
                            try {
                                let response = JSON.parse(xhr.responseText); // manually parse
                                if (response.errors) {
                                    if (response.errors.name) {
                                        $("#namefounderror").text(response.errors.name[0]);
                                    } else {
                                        $("#namefounderror").text("");
                                    }

                                    if (response.errors.email) {
                                        $("#emailfounderror").text(response.errors.email[0]);
                                    } else {
                                        $("#emailfounderror").text("");
                                    }
                                } else {
                                    alert("Error adding speaker.");
                                }
                            } catch (e) {
                                alert("Error adding speaker.");
                            }
                        }
                    });

                } else {
                    $("#namefounderror").text("Speaker name is required.");
                    $("#emailfounderror").text("Speaker email is required.");
                }
            });
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.querySelector('form'); // Change selector if needed
            form.addEventListener('submit', function(e) {
                let isValid = true;

                // Clear previous error messages
                document.querySelectorAll('.errormessage').forEach(div => {
                    div.innerHTML = '';
                });

                // Loop through all rows
                document.querySelectorAll('tr').forEach(function(row, index) {
                    const fileInput = row.querySelector('input[name="multiimage[]"]');
                    const fileNameInput = row.querySelector('input[name="multiimagefilename[]"]');
                    const cleIdInput = row.querySelector('input[name="multiimagebarid[]"]');

                    if (fileInput && fileInput.value) {
                        if (!fileNameInput || !fileNameInput.value.trim()) {
                            const errorDiv = fileNameInput.nextElementSibling;
                            if (errorDiv) {
                                errorDiv.innerHTML = 'File Name is required.';
                            }
                            isValid = false;
                        }

                        if (!cleIdInput || !cleIdInput.value.trim()) {
                            const errorDiv = cleIdInput.nextElementSibling;
                            if (errorDiv) {
                                errorDiv.innerHTML = 'CLE ID is required.';
                            }
                            isValid = false;
                        }
                    }
                });

                if (!isValid) {
                    e.preventDefault(); // Prevent form submit if validation fails
                }
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/clearlylegal_production/resources/views/admin/modules/content/addedit.blade.php ENDPATH**/ ?>