<?php $__env->startComponent('mail::layout'); ?>

<?php $__env->slot('header'); ?>
<?php echo $__env->make('email.admin.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->endSlot(); ?>

<!-- Email Body -->


<?php if(! empty($greeting)): ?>
# <?php echo e($greeting); ?>

<?php else: ?>
<?php if($level === 'error'): ?>
# <?php echo app('translator')->get('Whoops!'); ?>
<?php else: ?>
# Dear Admin,
<?php endif; ?>
<?php endif; ?>
<p>The following user account has been activated. </p>
<table style="width: 100%; border-collapse: collapse;">
    <tr>
        <td style="padding: 8px; border: 1px solid #ddd;"><strong>Name</strong></td>
        <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e($user->first_name . ' ' . $user->last_name); ?></td>
    </tr>
    <tr>
        <td style="padding: 8px; border: 1px solid #ddd;"><strong>Email</strong></td>
        <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e($user->email); ?></td>
    </tr>
    <tr>
        <td style="padding: 8px; border: 1px solid #ddd;"><strong>Phone</strong></td>
        <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e($user->phone); ?></td>
    </tr>
    <?php if(userFirmAdmin($user->id)): ?>
        <tr>
            <td style="padding: 8px; border: 1px solid #ddd;"><strong>Firm Code</strong></td>
            <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e(userFirmAdmin($user->id)->name); ?></td>
        </tr>
    <?php endif; ?>
    <tr>
        <td style="padding: 8px; border: 1px solid #ddd;"><strong>Subscription Start Date</strong></td>
        <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e(date('Y-m-d H:i:s', $subscription->current_period_start)); ?></td>
    </tr>
    <tr>
        <td style="padding: 8px; border: 1px solid #ddd;"><strong>Subscription End Date</strong></td>
        <td style="padding: 8px; border: 1px solid #ddd;"><?php echo e(date('Y-m-d H:i:s', $subscription->current_period_end)); ?></td>
    </tr>
</table>

<table style="width: 100%; border-collapse: collapse; margin-top: 20px;">
    <thead>
        <tr>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: left;">Description</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: center;">Qty</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: right;">Unit Price</th>
            <th style="border: 1px solid #ddd; padding: 8px; text-align: right;">Amount</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $subscription->items->data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td style="border: 1px solid #ddd; padding: 8px;">
                    <?php echo e($item->price->metadata->productName); ?>

                </td>
                <td style="border: 1px solid #ddd; padding: 8px; text-align: center;"><?php echo e($item->quantity); ?></td>
                <td style="border: 1px solid #ddd; padding: 8px; text-align: right;">$<?php echo e(number_format($item->price->unit_amount / 100, 2)); ?></td>
                <td style="border: 1px solid #ddd; padding: 8px; text-align: right;">$<?php echo e(number_format(($item->price->unit_amount * $item->quantity)/100, 2)); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td colspan="3" style="border: 1px solid #ddd; padding: 8px; text-align: right;">
                <strong>Subtotal</strong>
            </td>
            <td style="border: 1px solid #ddd; padding: 8px; text-align: right;">
                $<?php echo e(number_format($subtotal / 100, 2)); ?>

            </td>
        </tr>
        <?php if(!empty($subscription->discount->coupon)): ?>
        <tr>
            <td colspan="3" style="border: 1px solid #ddd; padding: 8px; text-align: right;">
                <strong>PROMOCODE : <?php echo e($subscription->discount->coupon->name); ?> (<?php if($is_discount_percentage): ?><?php echo e($subscription->discount->coupon->percent_off); ?>% off <?php else: ?>$<?php echo e(number_format($discount / 100, 2)); ?> off <?php endif; ?>)</strong>
            </td>
            <td style="border: 1px solid #ddd; padding: 8px; text-align: right;">
                -$<?php echo e(number_format($discount / 100, 2)); ?>

            </td>
        </tr>
        <?php endif; ?>
        <tr>
            <td colspan="3" style="border: 1px solid #ddd; padding: 8px; text-align: right;">
                <strong>Total</strong>
            </td>
            <td style="border: 1px solid #ddd; padding: 8px; text-align: right;">
                <strong>$<?php echo e(number_format(($total/100), 2)); ?></strong>
            </td>
        </tr>
    </tbody>
</table>

<br/>
<p>Please note: This is an automated email that cannot accept replies.</p>

Thank you,
<br>
<?php if(! empty($salutation)): ?>
<?php echo e($salutation); ?>

<?php endif; ?>

<?php if(isset($subcopy)): ?>
<?php $__env->slot('subcopy'); ?>
<?php $__env->startComponent('mail::subcopy'); ?>
<?php echo e($subcopy); ?>

<?php echo $__env->renderComponent(); ?>
<?php $__env->endSlot(); ?>
<?php endif; ?>

<?php $__env->slot('footer'); ?>
<?php echo $__env->make('email.admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /var/www/html/clearlylegal_production/resources/views/email/admin/sendaccountactivatedemailtoadmin.blade.php ENDPATH**/ ?>