<?php $__env->startSection('content'); ?>
    <section class="innerpage_wrap">
        <div class="container">
            <div class="row text-center">
                <div class="col-sm-12">
                    <div class="common-heading py-5">
                        <img src="<?php echo e(asset('assets/web/images/assets/subscribe_logo.svg')); ?>" class="img-fluid"
                            alt="subscribe_logo">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="subscribe-wrapper py-5">
        <div class="container">
            <ul class="nav nav-tabs justify-content-center contact_tab" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="question-tab" data-toggle="tab" data-target="#question" type="button"
                        role="tab" aria-controls="question" aria-selected="false">I have a question</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="faculty-tab" data-toggle="tab" data-target="#faculty" type="button"
                        role="tab" aria-controls="faculty" aria-selected="true"> I want to join as faculty</button>
                </li>
            </ul>
            <div class="tab-content pb-5" id="myTabContent">
                <div class="tab-pane fade" id="faculty" role="tabpanel" aria-labelledby="faculty-tab">
                    <div class="row text-center pb-4 pt-5">
                        <div class="col-sm-12">
                            <div class="common-heading">
                                <h2> Interested in joining the Faculty?</h2>
                            </div>
                        </div>
                    </div>
                    <div class="graybg contact-box">
                        <form id="facultyInquiryFrm" action="<?php echo e(route('storeFacultyInquiry')); ?>" method="POST">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <input type="text" class="form-control" id="faculty_first_name" name="first_name"
                                            placeholder="First Name*" required maxlength="30">
                                        <span class="error-text" id="faculty_first_name_error"></span>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <input type="text" class="form-control" id="faculty_last_name" name="last_name"
                                            placeholder="Last Name*" required maxlength="30">
                                        <span class="error-text" id="faculty_last_name_error"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control" id="faculty_email" name="email"
                                            placeholder="Email*" required maxlength="50">
                                        <span class="error-text" id="faculty_email_error"></span>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control" id="faculty_phone_number" maxlength="12"
                                            name="phone_number" placeholder="Phone Number (Optional)"
                                            data-mask='000-000-0000'>
                                        <span class="error-text" id="faculty_phone_number_error"></span>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control" id="bio_link" name="bio_link"
                                            placeholder="Bio Link (Optional)">
                                        <span class="error-text" id="bio_link_error"></span>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control" id="firm_name" name="firm_name"
                                            placeholder="Firm Name (Optional)">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <select id="multiple" name="categories[]" class="js-states form-control select2"
                                            multiple>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <span class="error-text" id="faculty_categories_error"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12 col-lg-6 ">
                                    <div class="form-group mb-4 faculty-recaptcha-container">
                                        
                                    </div>
                                </div>
                            </div>
                            <div class="row text-center">
                                <div class="col-sm-12 ">
                                    <button type="submit" class="btn btn-primary text-uppercase"
                                        id="facultyInquirySubmitButton" onclick="facultyInquirySubmit();">Submit</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="tab-pane fade show active" id="question" role="tabpanel" aria-labelledby="profile-tab">
                    <?php echo $__env->make('front.modules.contact.contact', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </section>


    <script>
        function onRecaptchaLoadCallback() {
            const siteKey = "<?php echo e(env('GOOGLE_RECAPTCHA_DATA_SITEKEY')); ?>";

            const renderFacultyRecaptcha = () => {
                const container = document.querySelector('.faculty-recaptcha-container');
                container.innerHTML =
                    `<div id="faculty_grecaptcha"></div><span class="error-text" id="faculty_recaptcha_error"></span>`;
                grecaptcha.render('faculty_grecaptcha', {
                    sitekey: siteKey
                });
            };

            const renderContactRecaptcha = () => {
                const container = document.querySelector('.contact-recaptcha-container');
                container.innerHTML =
                    `<div id="g-recaptcha"></div><span class="error-text" id="recaptcha_error"></span>`;
                grecaptcha.render('g-recaptcha', {
                    sitekey: siteKey
                });
            };

            // Initial render for faculty
            renderFacultyRecaptcha();

            // Tab switching
            document.querySelectorAll('.nav-link').forEach(button => {
                button.addEventListener('click', () => {
                    const targetId = button.getAttribute('data-target').substring(1);
                    console.log("Active tab:", targetId);

                    if (targetId === "question") {
                        document.querySelector('.faculty-recaptcha-container').innerHTML = "";
                        renderContactRecaptcha();
                    } else {
                        document.querySelector('.contact-recaptcha-container').innerHTML = "";
                        renderFacultyRecaptcha();
                    }
                });
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/clearlylegal_production/resources/views/front/modules/contact/inquiry.blade.php ENDPATH**/ ?>