<?php $__env->startComponent('mail::layout'); ?>

<?php $__env->slot('header'); ?>
<?php echo $__env->make('email.admin.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->endSlot(); ?>


<style>
.table-wrapper-1 {
  display: table;
  table-layout: fixed;
  width: 100%;
}

.table-wrapper-2 {
  display: table-cell;
  overflow-x: auto;
  width: 100%;
}
    .bordered-table {
        border-collapse: collapse;
        max-width: 100%;
    }
    .bordered-table th, .bordered-table td {
        border: 1px solid #dee2e6;
        padding: 0.75rem;
    }
</style>


<!-- Email Body -->


<?php if(! empty($greeting)): ?>
# <?php echo e($greeting); ?>

<?php else: ?>
<?php if($level === 'error'): ?>
# <?php echo app('translator')->get('Whoops!'); ?>
<?php else: ?>
# Dear Admin,
<?php endif; ?>
<?php endif; ?>
<p>The following users activated their account in the last week.</p>
<?php if($subscriptions->isNotEmpty()): ?>
<div class="table-wrapper-1">
    <div class="table-wrapper-2">
        <table class="bordered-table">
            <thead>
                <tr>
                    <th><strong>User</strong></th>
                    <th><strong>Phone</strong></th>
                    <th><strong>Subscription Start Date</strong></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($subscription->user->first_name . ' ' . $subscription->user->last_name); ?> <br> <?php echo e($subscription->user->email); ?></td>
                        <td><?php echo e($subscription->user->phone); ?></td>
                        <td><?php echo e(Carbon\Carbon::parse($subscription->start_date)->format(config('app.db_date_format'))); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php else: ?>
<p>No users activated their account in the last week.</p>
<?php endif; ?>
<br/>
<p>Please note: This is an automated email that cannot accept replies.</p>

Thank you,
<br>
<?php if(! empty($salutation)): ?>
<?php echo e($salutation); ?>

<?php endif; ?>

<?php if(isset($subcopy)): ?>
<?php $__env->slot('subcopy'); ?>
<?php $__env->startComponent('mail::subcopy'); ?>
<?php echo e($subcopy); ?>

<?php echo $__env->renderComponent(); ?>
<?php $__env->endSlot(); ?>
<?php endif; ?>

<?php $__env->slot('footer'); ?>
<?php echo $__env->make('email.admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /var/www/html/clearlylegal_production/resources/views/email/admin/sendweeklysubscriptionsummary.blade.php ENDPATH**/ ?>