<?xml version="1.0" encoding="UTF-8"?>
<rss version="2.0" xmlns:itunes="http://www.itunes.com/dtds/podcast-1.0.dtd" xmlns:atom="http://www.w3.org/2005/Atom">
    <channel>
        <atom:link href="<?php echo e(env('APP_URL')); ?>/rss.xml" rel="self" type="application/rss+xml" />
        <title>CLEarly Legal</title>
        <link><?php echo e(env('APP_URL')); ?></link>
        <description>Clearly Legal, the future of legal learning is the official podcast of Clearly.Legal, a platform
            dedicated to empowering attorneys with curated content, meaningful conversations, and career guidance.
            In each episode, we explore the diverse dimensions of legal practice—from wellness and ethics to emerging
            trends in tech, DEI, litigation strategy, and professional development. Whether you’re a solo practitioner,
            law student, or part of a big firm, this show brings you insights and stories that matter.
            Hosted by seasoned legal minds. Powered by community. Inspired by clarity.
        </description>
        <copyright>© <?php echo e(date('Y')); ?> Clearly Legal, LLC. All rights reserved.</copyright>
        <language>en-us</language>
        <pubDate><?php echo e(now()->toRssString()); ?></pubDate>
        <lastBuildDate><?php echo e(now()->toRssString()); ?></lastBuildDate>
        <image>
            <url><?php echo e(asset('assets/web/images/logo/CLELogo.png')); ?></url>
            <title>CLEarly Legal</title>
            <link><?php echo e(env('APP_URL')); ?></link>
        </image>
        <itunes:explicit>no</itunes:explicit>
        <itunes:type>episodic</itunes:type>
        <itunes:subtitle />
        <itunes:author>Sean Martin, Joel Surber</itunes:author>
        <itunes:summary>Clearly Legal, the future of legal learning is the official podcast of Clearly.Legal, a platform
            dedicated to empowering attorneys with curated content, meaningful conversations, and career guidance.
            In each episode, we explore the diverse dimensions of legal practice—from wellness and ethics to emerging
            trends in tech, DEI, litigation strategy, and professional development. Whether you’re a solo practitioner,
            law student, or part of a big firm, this show brings you insights and stories that matter.
            Hosted by seasoned legal minds. Powered by community. Inspired by clarity.
        </itunes:summary>
        <itunes:owner>
            <itunes:name>Sean Martin</itunes:name>
            <itunes:email>sean@seanjmartin.com</itunes:email>
        </itunes:owner>
        <itunes:image href="<?php echo e(asset('assets/player/assets/podcast_placeholder_square.svg')); ?>" />
        <itunes:category text="Business" />
        <itunes:category text="Education" />
        <itunes:category text="Society &amp; Culture" />
        <?php $__currentLoopData = $contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $activeSpeakers = collect($content->speakers)
                    ->filter(function ($speaker) {
                        return optional($speaker->speaker)->status == 1;
                    })
                    ->values(); // reindex
            ?>
            <item>
                <title>
                    <![CDATA[<?php echo e($content->podcast_title); ?>]]>
                </title>
                <link><?php echo e(route('library.show', $content->title_crc32)); ?></link>
                <description>
                    <![CDATA[<?php echo e($content->short_description); ?>]]>
                </description>
                <guid isPermaLink="true"><?php echo e(route('library.show', $content->title_crc32)); ?></guid>
                <pubDate><?php echo e(\Carbon\Carbon::createFromFormat('m/d/Y g:i a', $content->created_at)->toRssString()); ?>

                </pubDate>
                <itunes:author><?php $__currentLoopData = $activeSpeakers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $speaker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if($speaker->speaker->status == 1): ?><?php echo e(optional($speaker->speaker)->name ?? ''); ?><?php if($key !== count($activeSpeakers) - 1 && $speaker->speaker->status == 1 && count($activeSpeakers) > 1): ?>,<?php endif; ?> <?php endif; ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </itunes:author>
                <itunes:summary><?php echo e(strip_tags(html_entity_decode($content->short_description))); ?></itunes:summary>
                <itunes:duration><?php echo e(minutesToSeconds($content->lengthOfPodcast())); ?></itunes:duration>
                <itunes:explicit>no</itunes:explicit>
                <itunes:image href="<?php echo e(asset($content->image_path)); ?>" />
                <?php if(!$content->contentFiles->isEmpty()): ?>
                    <enclosure
                        url="<?php echo e(route('secure.web.audio', ['filePath' => Crypt::encryptString($content->contentFiles->first()->file)])); ?>"
                        length="<?php echo e(round(optional($content->contentFiles->first())->size)); ?>" type="audio/mpeg" />
                <?php endif; ?>
            </item>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </channel>
</rss>
<?php /**PATH /var/www/html/clearlylegal_production/resources/views/feed/rss.blade.php ENDPATH**/ ?>