<?php $__env->startSection('content'); ?>
    <div class="container-fluid dashboard-cms  pb-5">
        <div class="row">
            <div class="col-md-12">
                <h4>View <?php echo e($student->fullname); ?>'s Details</h4>
            </div>
        </div>
        <div class="row">
            <div class="form-group col-12"><?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?></div>

            <div class="form-group col-12">
                <div class="email-add"><a href="mailto:<?php echo e($student->email); ?>"><?php echo e($student->email); ?></a>
                </div>
            </div>
            <div class="form-group col-12">
                <div><?php echo e(formatPhoneNumber($student->phone)); ?></div>
            </div>
            <div class="form-group col-12"><?php echo e($student->firmcode); ?></div>
            <div class="form-group col-12"><?php echo e($student->subscription_status); ?></div>
            <div class="form-group col-12">
                <?php if(!empty($student->last_login_at)): ?>
                    <?php echo e(\Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $student->last_login_at)->format(config('app.datetime_format'))); ?>

                <?php else: ?>
                <?php endif; ?>
            </div>
            <div class="form-group col-12">
                <?php echo e($student->created_at); ?></div>

            <?php if(canUserAccess('manage-user')): ?>
                <div class="form-group col-12">
                    <?php if($student->email_verified_at == null): ?>
                        <a
                            href="<?php echo e(route('user.reset-password', [$student->email, $student->user_type_id])); ?>"><?php echo e(__('user.account_activation')); ?></a>
                    <?php elseif($student->status == 1): ?>
                        <a
                            href="<?php echo e(route('user.reset-password', [$student->email, $student->user_type_id])); ?>"><?php echo e(__('user.reset_password')); ?></a>
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/clearlylegal_production/resources/views/admin/modules/user/student-progress.blade.php ENDPATH**/ ?>