<?php $__env->startComponent('mail::layout'); ?>

<?php $__env->slot('header'); ?>
<?php echo $__env->make('email.admin.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->endSlot(); ?>

<style>
    .bordered-table {
        width: 100%;
        border-collapse: collapse;
    }
    .bordered-table th, .bordered-table td {
        border: 1px solid #dee2e6;
        padding: 0.75rem;
    }
</style>


<!-- Email Body -->


<?php if(! empty($greeting)): ?>
# <?php echo e($greeting); ?>

<?php else: ?>
<?php if($level === 'error'): ?>
# <?php echo app('translator')->get('Whoops!'); ?>
<?php else: ?>
Hi <?php echo e($user->first_name); ?>,
<?php endif; ?>
<?php endif; ?>
<p>We hope you had a great week of learning and growing through our podcasts! Here’s your weekly activity summary:</p>


<span>🎙️</span> Podcasts You’ve Listened To:
<?php if(!empty($podcastsCL)): ?>
<table class="bordered-table">
    <tbody>
        <?php $__currentLoopData = $podcastsCL; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pcl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($pcl->file_name); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php else: ?>
    <p>No podcasts listened to in the last week.</p>
<?php endif; ?>

<br>

<span>📌</span> Podcasts Yet to Submit for CLE Credit:
<?php if(!empty($podcastYetToSubmit)): ?>
<table class="bordered-table">
    <tbody>
        <?php $__currentLoopData = $podcastYetToSubmit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pyts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($pyts->file_name); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php else: ?>
    <p>No podcasts left to submit in the last week.</p>
<?php endif; ?>

<br>

<span>🏆</span> CLE Earned Last Week:
<?php if($credits_earned != 0): ?>
    <?php echo e($credits_earned); ?> credits earned but not submitted
<?php else: ?>
    <?php echo e($credits_earned); ?> earned credits
<?php endif; ?>


<strong></strong>
<p>Stay on top of your CLE goals by submitting the required forms for podcasts you’ve completed. If you’re looking for more learning opportunities, check out our latest podcast releases </p>
<ul>
<?php $__currentLoopData = $latestPodcasts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lps): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<li>
    <a href="<?php echo e(env('CL_APP_URL')); ?>"><?php echo e($lps->file_name); ?></a>
</li>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</ul>   
<br/> 

<p>Have questions? Reach out to us anytime at <a href="mailto:support@clearly.legal">support@clearly.legal</a>!</p>
<p>Happy listening,</p>
<?php if(! empty($salutation)): ?>
<p><?php echo e($salutation); ?></p>
<?php endif; ?>

<?php if(isset($subcopy)): ?>
<?php $__env->slot('subcopy'); ?>
<?php $__env->startComponent('mail::subcopy'); ?>
<?php echo e($subcopy); ?>

<?php echo $__env->renderComponent(); ?>
<?php $__env->endSlot(); ?>
<?php endif; ?>

<?php $__env->slot('footer'); ?>
<?php echo $__env->make('email.admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /var/www/html/clearlylegal_production/resources/views/email/weeklysummary.blade.php ENDPATH**/ ?>