<?php

namespace Tests\Feature\Controllers\Admin;

use Tests\TestCase;
use App\User;
use App\IpTracker;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Foundation\Testing\RefreshDatabase;

class IpTrackerControllerTest extends TestCase
{
    use RefreshDatabase, WithFaker;

    protected function setUp(): void
    {
        parent::setUp();

        $this->user = factory(User::class)->create();
    }

      /** @test */
      public function testIndex()
      {
          $this->actingAs($this->user)
              ->get(route('iptracker.index'))
              ->assertOk()
              ->assertViewIs('admin.modules.iptracker.index')
              ->assertViewHas('iptrackers');
      }

}
