<?php
 
namespace Tests\Feature\Controllers\Admin;
 
use App\User;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
use Tests\TestCase;
 
class UploadControllerTest extends TestCase
{
    protected function setUp(): void
    {
        parent::setUp();

        $this->user = factory(User::class)->create();
    }
    
    /** @test for reqiored single image validation*/
    public function testUploadImageRequiredValidation()
    {  
        $image = ['file'=>''];
        $this->actingAs($this->user)
            ->post(route('adminupload'), $image)
            ->assertStatus(302); 
    }
    /** @test for reqiored single image validation*/
    public function testUploadImageFileTypeValidation()
    { 
        Storage::fake('team'); 
        $file = UploadedFile::fake()->image('abc.pdf');
        $image = ['file'=>$file];
        $this->actingAs($this->user)
            ->post(route('adminupload'), $image)
            ->assertStatus(302)
            ->assertSessionHasErrors(['file' => 'The uploaded image extension is invalid. Image must be file of type: JPEG/JPG/PNG/GIF']);
    }

    /** @test for reqiored single image validation*/
    public function testUploadImageFileSizeValidation()
    { 
        Storage::fake('team'); 
        $file = UploadedFile::fake()->image('abc.pdf')->size(3000);
        $image = ['file'=>$file,'size'=>2];
        $this->actingAs($this->user)
            ->post(route('adminupload'), $image)
            ->assertStatus(302)
            ->assertSessionHasErrors(['file' => 'The file may not be greater than '.$image['size'].' MB.']);
    }
}