<?php

namespace Tests\Feature;

use App\User;
use Tests\TestCase;
use Illuminate\Foundation\Testing\RefreshDatabase;

class ExampleTest extends TestCase
{
    use RefreshDatabase;

    /** @test */
    public function only_logged_in_user_cand_see_admin_dashboard()
    {
         $this->get('admin/dashboard')
                        ->assertRedirect('/admin/login');

    }

    /** @test */
    public function authenticated_user_can_see_admin_dashboard()
    {
        $user = factory(User::class)->create();
        $this->actingAs($user);

         $this->get('/admin/dashboard')
                        ->assertOk();
    }
}
