# CHANGELOG

## 3.316.2 - 2024-07-10

* `Aws\EC2` - Add parameters to enable provisioning IPAM BYOIPv4 space at a Local Zone Network Border Group level
* `Aws\Batch` - This feature allows AWS Batch Jobs with EKS container orchestration type to be run as Multi-Node Parallel Jobs.
* `Aws\BedrockRuntime` - Add support for contextual grounding check and ApplyGuardrail API for Guardrails for Amazon Bedrock.
* `Aws\Bedrock` - Add support for contextual grounding check for Guardrails for Amazon Bedrock.
* `Aws\LicenseManagerLinuxSubscriptions` - Add support for third party subscription providers, starting with RHEL subscriptions through Red Hat Subscription Manager (RHSM). Additionally, add support for tagging subscription provider resources, and detect when an instance has more than one Linux subscription and notify the customer.
* `Aws\GroundStation` - Documentation update specifying OEM ephemeris units of measurement
* `Aws\Glue` - Add recipe step support for recipe node
* `Aws\MediaConnect` - AWS Elemental MediaConnect introduces the ability to disable outputs. Disabling an output allows you to keep the output attached to the flow, but stop streaming to the output destination. A disabled output does not incur data transfer costs.
* `Aws\BedrockAgentRuntime` - Introduces query decomposition, enhanced Agents integration with Knowledge bases, session summary generation, and code interpretation (preview) for Claude V3 Sonnet and Haiku models. Also introduces Prompt Flows (preview) to link prompts, foundational models, and resources for end-to-end solutions.
* `Aws\BedrockAgent` - Introduces new data sources and chunking strategies for Knowledge bases, advanced parsing logic using FMs, session summary generation, and code interpretation (preview) for Claude V3 Sonnet and Haiku models. Also introduces Prompt Flows (preview) to link prompts, foundational models, and resources.

## 3.316.1 - 2024-07-09

* `Aws\OpenSearchService` - This release adds support for enabling or disabling Natural Language Query Processing feature for Amazon OpenSearch Service domains, and provides visibility into the current state of the setup or tear-down.
* `Aws\DataZone` - This release deprecates dataProductItem field from SearchInventoryResultItem, along with some unused DataProduct shapes
* `Aws\FSx` - Adds support for FSx for NetApp ONTAP 2nd Generation file systems, and FSx for OpenZFS Single AZ HA file systems.
* `Aws\SageMaker` - This release 1/ enables optimization jobs that allows customers to perform Ahead-of-time compilation and quantization. 2/ allows customers to control access to Amazon Q integration in SageMaker Studio. 3/ enables AdditionalModelDataSources for CreateModel action.

## 3.316.0 - 2024-07-08

* `Aws\ElasticBeanstalk` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\CodeDeploy` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\DatabaseMigrationService` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\Firehose` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\DeviceFarm` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\SES` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\GameLift` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\Route53Resolver` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\QApps` - This is a general availability (GA) release of Amazon Q Apps, a capability of Amazon Q Business. Q Apps leverages data sources your company has provided to enable users to build, share, and customize apps within your organization.
* `Aws\ElasticsearchService` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.

## 3.315.6 - 2024-07-05

* `Aws\ECR` - This release for Amazon ECR makes change to bring the SDK into sync with the API.
* `Aws\PaymentCryptographyData` - Added further restrictions on logging of potentially sensitive inputs and outputs.
* `Aws\QBusiness` - Add personalization to Q Applications. Customers can enable or disable personalization when creating or updating a Q application with the personalization configuration.
* `Aws\ACM` - Documentation updates, including fixes for xml formatting, broken links, and ListCertificates description.

## 3.315.5 - 2024-07-03

* `Aws\WorkSpaces` - Fix create workspace bundle RootStorage/UserStorage to accept non null values
* `Aws\DirectConnect` - This update includes documentation for support of new native 400 GBps ports for Direct Connect.
* `Aws\Rekognition` - This release adds support for tagging projects and datasets with the CreateProject and CreateDataset APIs.
* `Aws\Organizations` - Added a new reason under ConstraintViolationException in RegisterDelegatedAdministrator API to prevent registering suspended accounts as delegated administrator of a service.
* `Aws\ApplicationAutoScaling` - Doc only update for Application Auto Scaling that fixes resource name.

## 3.315.4 - 2024-07-02

* `Aws\S3` - Added response overrides to Head Object requests.
* `Aws\FMS` - Increases Customer API's ManagedServiceData length
* `Aws\EC2` - Documentation updates for Elastic Compute Cloud (EC2).

## 3.315.3 - 2024-07-01

* `Aws\PaymentCryptographyData` - Adding support for dynamic keys for encrypt, decrypt, re-encrypt and translate pin functions. With this change, customers can use one-time TR-31 keys directly in dataplane operations without the need to first import them into the service.
* `Aws\DocDB` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\PaymentCryptography` - Added further restrictions on logging of potentially sensitive inputs and outputs.
* `Aws\WAFV2` - JSON body inspection: Update documentation to clarify that JSON parsing doesn't include full validation.
* `Aws\APIGateway` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\CognitoIdentity` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\Connect` - Authentication profiles are Amazon Connect resources (in gated preview) that allow you to configure authentication settings for users in your contact center. This release adds support for new ListAuthenticationProfiles, DescribeAuthenticationProfile and UpdateAuthenticationProfile APIs.
* `Aws\EKS` - Updates EKS managed node groups to support EC2 Capacity Blocks for ML
* `Aws\SWF` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\SFN` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.

## 3.315.2 - 2024-06-28

* `Aws\Glue` - Added AttributesToGet parameter to Glue GetDatabases, allowing caller to limit output to include only the database name.
* `Aws\CloudHSMV2` - Added 3 new APIs to support backup sharing: GetResourcePolicy, PutResourcePolicy, and DeleteResourcePolicy. Added BackupArn to the output of the DescribeBackups API. Added support for BackupArn in the CreateCluster API.
* `Aws\PI` - Noting that the filter db.sql.db_id isn't available for RDS for SQL Server DB instances.
* `Aws\WorkSpaces` - Added support for Red Hat Enterprise Linux 8 on Amazon WorkSpaces Personal.
* `Aws\OpenSearchService` - This release removes support for enabling or disabling Natural Language Query Processing feature for Amazon OpenSearch Service domains.
* `Aws\ACMPCA` - Added CCPC_LEVEL_1_OR_HIGHER KeyStorageSecurityStandard and SM2 KeyAlgorithm and SM3WITHSM2 SigningAlgorithm for China regions.
* `Aws\EMR` - This release provides the support for new allocation strategies i.e. CAPACITY_OPTIMIZED_PRIORITIZED for Spot and PRIORITIZED for On-Demand by taking input of priority value for each instance type for instance fleet clusters.
* `Aws\KinesisAnalyticsV2` - Support for Flink 1.19 in Managed Service for Apache Flink
* `Aws\Connect` - This release supports showing PreferredAgentRouting step via DescribeContact API.

## 3.315.1 - 2024-06-27

* `Aws\ElastiCache` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\ChimeSDKMediaPipelines` - Added Amazon Transcribe multi language identification to Chime SDK call analytics. Enabling customers sending single stream audio to generate call recordings using Chime SDK call analytics
* `Aws\SageMaker` - Add capability for Admins to customize Studio experience for the user by showing or hiding Apps and MLTools.
* `Aws\CloudFront` - Doc only update for CloudFront that fixes customer-reported issue
* `Aws\MQ` - This release makes the EngineVersion field optional for both broker and configuration and uses the latest available version by default. The AutoMinorVersionUpgrade field is also now optional for broker creation and defaults to 'true'.
* `Aws\WorkSpaces` - Added support for WorkSpaces Pools.
* `Aws\QuickSight` - Adding support for Repeating Sections, Nested Filters
* `Aws\ApplicationAutoScaling` - Amazon WorkSpaces customers can now use Application Auto Scaling to automatically scale the number of virtual desktops in a WorkSpaces pool.
* `Aws\QConnect` - Adds CreateContentAssociation, ListContentAssociations, GetContentAssociation, and DeleteContentAssociation APIs.
* `Aws\DataZone` - This release supports the data lineage feature of business data catalog in Amazon DataZone.
* `Aws\RDS` - Updates Amazon RDS documentation for TAZ export to S3.

## 3.315.0 - 2024-06-26

* `Aws\` - Decodes URL returned by CompleteMultipartUpload operation so special characters are removed.
* `Aws\ControlTower` - Added ListLandingZoneOperations API.
* `Aws\EKS` - Added support for disabling unmanaged addons during cluster creation.
* `Aws\IVSRealTime` - IVS Real-Time now offers customers the ability to upload public keys for customer vended participant tokens.
* `Aws\KinesisAnalyticsV2` - This release adds support for new ListApplicationOperations and DescribeApplicationOperation APIs. It adds a new configuration to enable system rollbacks, adds field ApplicationVersionCreateTimestamp for clarity and improves support for pagination for APIs.
* `Aws\OpenSearchService` - This release adds support for enabling or disabling Natural Language Query Processing feature for Amazon OpenSearch Service domains, and provides visibility into the current state of the setup or tear-down.

## 3.314.8 - 2024-06-25

* `Aws\EC2` - This release is for the launch of the new u7ib-12tb.224xlarge, R8g, c7gn.metal and mac2-m1ultra.metal instance types
* `Aws\AutoScaling` - Doc only update for Auto Scaling's TargetTrackingMetricDataQuery
* `Aws\NetworkManager` - This is model changes & documentation update for the Asynchronous Error Reporting feature for AWS Cloud WAN. This feature allows customers to view errors that occur while their resources are being provisioned, enabling customers to fix their resources without needing external support.
* `Aws\WorkSpacesThinClient` - This release adds the deviceCreationTags field to CreateEnvironment API input, UpdateEnvironment API input and GetEnvironment API output.

## 3.314.7 - 2024-06-24

* `Aws\SSM` - Add sensitive trait to SSM IPAddress property for CloudTrail redaction
* `Aws\EC2` - Fix EC2 multi-protocol info in models.
* `Aws\BedrockRuntime` - Increases Converse API's document name length
* `Aws\QBusiness` - Allow enable/disable Q Apps when creating/updating a Q application; Return the Q Apps enablement information when getting a Q application.
* `Aws\CustomerProfiles` - This release includes changes to ProfileObjectType APIs, adds functionality top set and get capacity for profile object types.
* `Aws\WorkSpacesWeb` - Added ability to enable DeepLinking functionality on a Portal via UserSettings as well as added support for IdentityProvider resource tagging.

## 3.314.6 - 2024-06-20

* `Aws\DynamoDB` - Doc-only update for DynamoDB. Fixed Important note in 6 Global table APIs - CreateGlobalTable, DescribeGlobalTable, DescribeGlobalTableSettings, ListGlobalTables, UpdateGlobalTable, and UpdateGlobalTableSettings.
* `Aws\BedrockRuntime` - This release adds document support to Converse and ConverseStream APIs
* `Aws\Glue` - Fix Glue paginators for Jobs, JobRuns, Triggers, Blueprints and Workflows.
* `Aws\SecurityHub` - Documentation updates for Security Hub
* `Aws\SageMaker` - Adds support for model references in Hub service, and adds support for cross-account access of Hubs
* `Aws\CostOptimizationHub` - This release enables AWS Cost Optimization Hub to show cost optimization recommendations for Amazon RDS MySQL and RDS PostgreSQL.
* `Aws\IVSRealTime` - IVS Real-Time now offers customers the ability to record individual stage participants to S3.
* `Aws\ComputeOptimizer` - This release enables AWS Compute Optimizer to analyze and generate optimization recommendations for Amazon RDS MySQL and RDS PostgreSQL.
* `Aws\CodeArtifact` - Add support for the Cargo package format.

## 3.314.5 - 2024-06-19

* `Aws\DirectConnect` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\CostandUsageReportService` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\Artifact` - This release adds an acceptanceType field to the ReportSummary structure (used in the ListReports API response).
* `Aws\ElasticTranscoder` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\Athena` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\OpenSearchService` - This release enables customers to use JSON Web Tokens (JWT) for authentication on their Amazon OpenSearch Service domains.

## 3.314.4 - 2024-06-18

* `Aws\Auth` - Corrects an issue with modeling for `noAuth` auth types.
* `Aws\Lightsail` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\Rekognition` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\BedrockRuntime` - This release adds support for using Guardrails with the Converse and ConverseStream APIs.
* `Aws\SageMaker` - Launched a new feature in SageMaker to provide managed MLflow Tracking Servers for customers to track ML experiments. This release also adds a new capability of attaching additional storage to SageMaker HyperPod cluster instances.
* `Aws\ConfigService` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\EKS` - This release adds support to surface async fargate customer errors from async path to customer through describe-fargate-profile API response.
* `Aws\CloudTrail` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\Shield` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\Snowball` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\Polly` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.

## 3.314.3 - 2024-06-17

* `Aws\MediaConvert` - This release includes support for creating I-frame only video segments for DASH trick play.
* `Aws\SecretsManager` - Doc only update for Secrets Manager
* `Aws\Glue` - This release introduces a new feature, Usage profiles. Usage profiles allow the AWS Glue admin to create different profiles for various classes of users within the account, enforcing limits and defaults for jobs and sessions.
* `Aws\WAF` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\Batch` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\KMS` - Updating SDK example for KMS DeriveSharedSecret API.
* `Aws\CodeBuild` - AWS CodeBuild now supports global and organization GitHub webhooks
* `Aws\DirectoryService` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\EFS` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\CognitoIdentityProvider` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\ACMPCA` - Doc-only update that adds name constraints as an allowed extension for ImportCertificateAuthorityCertificate.

## 3.314.2 - 2024-06-14

* `Aws\DataZone` - This release introduces a new default service blueprint for custom environment creation.
* `Aws\MediaConvert` - This release adds the ability to search for historical job records within the management console using a search box and/or via the SDK/CLI with partial string matching search on input file name.
* `Aws\Macie2` - This release adds support for managing the status of automated sensitive data discovery for individual accounts in an organization, and determining whether individual S3 buckets are included in the scope of the analyses.
* `Aws\EC2` - Documentation updates for Amazon EC2.
* `Aws\Route53Domains` - Add v2 smoke tests and smithy smokeTests trait for SDK testing.

## 3.314.1 - 2024-06-13

* `Aws\Glue` - This release adds support for configuration of evaluation method for composite rules in Glue Data Quality rulesets.
* `Aws\IoTWireless` - Add RoamingDeviceSNR and RoamingDeviceRSSI to Customer Metrics.
* `Aws\CloudHSMV2` - Added support for hsm type hsm2m.medium. Added supported for creating a cluster in FIPS or NON_FIPS mode.
* `Aws\KMS` - This feature allows customers to use their keys stored in KMS to derive a shared secret which can then be used to establish a secured channel for communication, provide proof of possession, or establish trust with other parties.
* `Aws\MediaPackageV2` - This release adds support for CMAF ingest (DASH-IF live media ingest protocol interface 1)

## 3.314.0 - 2024-06-12

* `Aws\` - Removes Backup Storage client, which has been deprecated.
* `Aws\OSIS` - SDK changes for self-managed vpc endpoint to OpenSearch ingestion pipelines.
* `Aws\SecretsManager` - Introducing RotationToken parameter for PutSecretValue API
* `Aws\Redshift` - Updates to remove DC1 and DS2 node types.
* `Aws\SecurityLake` - This release updates request validation regex to account for non-commercial aws partitions.
* `Aws\SESv2` - This release adds support for Amazon EventBridge as an email sending events destination.
* `Aws\AppTest` - AWS Mainframe Modernization Application Testing is an AWS Mainframe Modernization service feature that automates functional equivalence testing for mainframe application modernization and migration to AWS, and regression testing.
* `Aws\EC2` - Tagging support for Traffic Mirroring FilterRule resource

## 3.313.0 - 2024-06-11

* `Aws\Serializer` - Fixes empty list serialization on empty lists
* `Aws\AccessAnalyzer` - IAM Access Analyzer now provides policy recommendations to help resolve unused permissions for IAM roles and users. Additionally, IAM Access Analyzer now extends its custom policy checks to detect when IAM policies grant public access or access to critical resources ahead of deployments.
* `Aws\NetworkManager` - This is model changes & documentation update for Service Insertion feature for AWS Cloud WAN. This feature allows insertion of AWS/3rd party security services on Cloud WAN. This allows to steer inter/intra segment traffic via security appliances and provide visibility to the route updates.
* `Aws\PcaConnectorScep` - Connector for SCEP allows you to use a managed, cloud CA to enroll mobile devices and networking gear. SCEP is a widely-adopted protocol used by mobile device management (MDM) solutions for enrolling mobile devices. With the connector, you can use AWS Private CA with popular MDM solutions.
* `Aws\SageMaker` - Introduced Scope and AuthenticationRequestExtraParams to SageMaker Workforce OIDC configuration; this allows customers to modify these options for their private Workforce IdP integration. Model Registry Cross-account model package groups are discoverable.
* `Aws\GuardDuty` - Added API support for GuardDuty Malware Protection for S3.

## 3.312.0 - 2024-06-10

* `Aws\ApplicationSignals` - This is the initial SDK release for Amazon CloudWatch Application Signals. Amazon CloudWatch Application Signals provides curated application performance monitoring for developers to monitor and troubleshoot application health using pre-built dashboards and Service Level Objectives.
* `Aws\ECS` - This release introduces a new cluster configuration to support the customer-managed keys for ECS managed storage encryption.
* `Aws\imagebuilder` - This release updates the regex pattern for Image Builder ARNs.

## 3.311.2 - 2024-06-07

* `Aws\CodePipeline` - CodePipeline now supports overriding S3 Source Object Key during StartPipelineExecution, as part of Source Overrides.
* `Aws\AuditManager` - New feature: common controls. When creating custom controls, you can now use pre-grouped AWS data sources based on common compliance themes. Also, the awsServices parameter is deprecated because we now manage services in scope for you. If used, the input is ignored and an empty list is returned.
* `Aws\B2bi` - Added exceptions to B2Bi List operations and ConflictException to B2Bi StartTransformerJob operation. Also made capabilities field explicitly required when creating a Partnership.
* `Aws\VerifiedPermissions` - This release adds OpenIdConnect (OIDC) configuration support for IdentitySources, allowing for external IDPs to be used in authorization requests.
* `Aws\SageMaker` - This release introduces a new optional parameter: InferenceAmiVersion, in ProductionVariant.

## 3.311.1 - 2024-06-06

* `Aws\` - Updates error level on deprecated `Command` methods.  Removes suppressed call to deprecated method.
* `Aws\Glue` - This release adds support for creating and updating Glue Data Catalog Views.
* `Aws\FSx` - This release adds support to increase metadata performance on FSx for Lustre file systems beyond the default level provisioned when a file system is created. This can be done by specifying MetadataConfiguration during the creation of Persistent_2 file systems or by updating it on demand.
* `Aws\Firehose` - Adds integration with Secrets Manager for Redshift, Splunk, HttpEndpoint, and Snowflake destinations
* `Aws\StorageGateway` - Adds SoftwareUpdatePreferences to DescribeMaintenanceStartTime and UpdateMaintenanceStartTime, a structure which contains AutomaticUpdatePolicy.
* `Aws\LocationService` - Added two new APIs, VerifyDevicePosition and ForecastGeofenceEvents. Added support for putting larger geofences up to 100,000 vertices with Geobuf fields.
* `Aws\SQS` - Doc only updates for SQS. These updates include customer-reported issues and TCX3 modifications.
* `Aws\IoTWireless` - Adds support for wireless device to be in Conflict FUOTA Device Status due to a FUOTA Task, so it couldn't be attached to a new one.
* `Aws\SNS` - Doc-only update for SNS. These changes include customer-reported issues and TXC3 updates.
* `Aws\Account` - This release adds 3 new APIs (AcceptPrimaryEmailUpdate, GetPrimaryEmail, and StartPrimaryEmailUpdate) used to centrally manage the root user email address of member accounts within an AWS organization.

## 3.311.0 - 2024-06-05

* `Aws\Auth` - Adds support for the `auth` service trait.  This allows for auth scheme selection at both the service and operation level.
* `Aws\GlobalAccelerator` - This release contains a new optional ip-addresses input field for the update accelerator and update custom routing accelerator apis. This input enables consumers to replace IPv4 addresses on existing accelerators with addresses provided in the input.
* `Aws\Glue` - AWS Glue now supports native SaaS connectivity: Salesforce connector available now
* `Aws\S3` - Added new params copySource and key to copyObject API for supporting S3 Access Grants plugin. These changes will not change any of the existing S3 API functionality.

## 3.310.0 - 2024-06-04

* `Aws\Pipes` - This release adds Timestream for LiveAnalytics as a supported target in EventBridge Pipes
* `Aws\EC2` - U7i instances with up to 32 TiB of DDR5 memory and 896 vCPUs are now available. C7i-flex instances are launched and are lower-priced variants of the Amazon EC2 C7i instances that offer a baseline level of CPU performance with the ability to scale up to the full compute performance 95% of the time.
* `Aws\SageMaker` - Extend DescribeClusterNode response with private DNS hostname and IP address, and placement information about availability zone and availability zone ID.
* `Aws\TaxSettings` - Initial release of AWS Tax Settings API

## 3.309.0 - 2024-06-03

* `Aws\EcsCredentialsProvider` - Add support for retries in the ECS credentials provider
* `Aws\Amplify` - This doc-only update identifies fields that are specific to Gen 1 and Gen 2 applications.
* `Aws\IoTTwinMaker` - Support RESET_VALUE UpdateType for PropertyUpdates to reset property value to default or null
* `Aws\EKS` - Adds support for EKS add-ons pod identity associations integration
* `Aws\Batch` - This release adds support for the AWS Batch GetJobQueueSnapshot API operation.

## 3.308.7 - 2024-05-31

* `Aws\LaunchWizard` - This release adds support for describing workload deployment specifications, deploying additional workload types, and managing tags for Launch Wizard resources with API operations.
* `Aws\CodeBuild` - AWS CodeBuild now supports Self-hosted GitHub Actions runners for Github Enterprise
* `Aws\ElastiCache` - Update to attributes of TestFailover and minor revisions.
* `Aws\CodeGuruSecurity` - This release includes minor model updates and documentation updates.

## 3.308.6 - 2024-05-30

* `Aws\BedrockRuntime` - This release adds Converse and ConverseStream APIs to Bedrock Runtime
* `Aws\ACM` - add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\EMRServerless` - The release adds support for spark structured streaming.
* `Aws\Connect` - Adding associatedQueueIds as a SearchCriteria and response field to the SearchRoutingProfiles API
* `Aws\BedrockAgent` - With this release, Knowledge bases for Bedrock adds support for Titan Text Embedding v2.
* `Aws\SageMaker` - Adds Model Card information as a new component to Model Package. Autopilot launches algorithm selection for TimeSeries modality to generate AutoML candidates per algorithm.
* `Aws\CloudTrail` - CloudTrail Lake returns PartitionKeys in the GetEventDataStore API response. Events are grouped into partitions based on these keys for better query performance. For example, the calendarday key groups events by day, while combining the calendarday key with the hour key groups them by day and hour.
* `Aws\RDS` - Updates Amazon RDS documentation for Aurora Postgres DBname.

## 3.308.5 - 2024-05-29

* `Aws\Credentials` - Clears cached path for authorization token when necessary on ECS credentials provider.
* `Aws\CodeBuild` - AWS CodeBuild now supports manually creating GitHub webhooks
* `Aws\Connect` - This release includes changes to DescribeContact API's response by including ConnectedToSystemTimestamp, RoutingCriteria, Customer, Campaign, AnsweringMachineDetectionStatus, CustomerVoiceActivity, QualityMetrics, DisconnectDetails, and SegmentAttributes information from a contact in Amazon Connect.
* `Aws\Athena` - Throwing validation errors on CreateNotebook with Name containing `/`,`:`,`\`
* `Aws\SecurityHub` - Add ROOT type for TargetType model
* `Aws\Glue` - Add optional field JobMode to CreateJob and UpdateJob APIs.

## 3.308.4 - 2024-05-28

* `Aws\Kafka` - Adds ControllerNodeInfo in ListNodes response to support Raft mode for MSK
* `Aws\SWF` - This release adds new APIs for deleting activity type and workflow type resources.
* `Aws\EC2` - Providing support to accept BgpAsnExtended attribute
* `Aws\DynamoDB` - Doc-only update for DynamoDB. Specified the IAM actions needed to authorize a user to create a table with a resource-based policy.

## 3.308.3 - 2024-05-24

* `Aws\DynamoDB` - Documentation only updates for DynamoDB.
* `Aws\IoTFleetWise` - AWS IoT FleetWise now supports listing vehicles with attributes filter, ListVehicles API is updated to support additional attributes filter.
* `Aws\ManagedBlockchain` - This is a minor documentation update to address the impact of the shut down of the Goerli and Polygon networks.

## 3.308.2 - 2024-05-23

* `Aws\OpsWorks` - Documentation-only update for OpsWorks Stacks.
* `Aws\EMRServerless` - This release adds the capability to run interactive workloads using Apache Livy Endpoint.

## 3.308.1 - 2024-05-22

* `Aws\KMS` - This release includes feature to import customer's asymmetric (RSA, ECC and SM2) and HMAC keys into KMS in China.
* `Aws\CloudFormation` - Added DeletionMode FORCE_DELETE_STACK for deleting a stack that is stuck in DELETE_FAILED state due to resource deletion failure.
* `Aws\WAFV2` - You can now use Security Lake to collect web ACL traffic data.
* `Aws\Chatbot` - This change adds support for tagging Chatbot configurations.
* `Aws\OpenSearchService` - This release adds support for enabling or disabling a data source configured as part of Zero-ETL integration with Amazon S3, by setting its status.

## 3.308.0 - 2024-05-21

* `Aws\StorageGateway` - Added new SMBSecurityStrategy enum named MandatoryEncryptionNoAes128, new mode enforces encryption and disables AES 128-bit algorithums.
* `Aws\Lightsail` - This release adds support for Amazon Lightsail instances to switch between dual-stack or IPv4 only and IPv6-only public IP address types.
* `Aws\PI` - Performance Insights added a new input parameter called AuthorizedActions to support the fine-grained access feature. Performance Insights also restricted the acceptable input characters.
* `Aws\Glue` - Add Maintenance window to CreateJob and UpdateJob APIs and JobRun response. Add a new Job Run State for EXPIRED.
* `Aws\RDS` - Updates Amazon RDS documentation for Db2 license through AWS Marketplace.
* `Aws\CloudFront` - Model update; no change to SDK functionality.
* `Aws\MailManager` - This release includes a new Amazon SES feature called Mail Manager, which is a set of email gateway capabilities designed to help customers strengthen their organization's email infrastructure, simplify email workflow management, and streamline email compliance control.

## 3.307.2 - 2024-05-20

* `Aws\RDS` - This release adds support for EngineLifecycleSupport on DBInstances, DBClusters, and GlobalClusters.
* `Aws\SecretsManager` - add v2 smoke tests and smithy smokeTests trait for SDK testing
* `Aws\ControlTower` - Added ListControlOperations API and filtering support for ListEnabledControls API. Updates also includes added metadata for enabled controls and control operations.
* `Aws\BedrockAgent` - This release adds support for using Guardrails with Bedrock Agents.
* `Aws\BedrockAgentRuntime` - This release adds support for using Guardrails with Bedrock Agents.
* `Aws\OSIS` - Add support for creating an OpenSearch Ingestion pipeline that is attached to a provided VPC. Add information about the destinations of an OpenSearch Ingestion pipeline to the GetPipeline and ListPipelines APIs.

## 3.307.1 - 2024-05-17

* `Aws\ElasticLoadBalancingv2` - This release adds dualstack-without-public-ipv4 IP address type for ALB.
* `Aws\ApplicationAutoScaling` - add v2 smoke tests and smithy smokeTests trait for SDK testing.
* `Aws\CodeBuild` - Aws CodeBuild now supports 36 hours build timeout
* `Aws\LakeFormation` - Introduces a new API, GetDataLakePrincipal, that returns the identity of the invoking principal
* `Aws\Transfer` - Enable use of CloudFormation traits in Smithy model to improve generated CloudFormation schema from the Smithy API model.

## 3.307.0 - 2024-05-16

* `Aws\User-Agent` - Update user agent implementation for supporting AppId and user agent version
* `Aws\SecretsManager` - Documentation updates for AWS Secrets Manager
* `Aws\Connect` - Adding Contact Flow metrics to the GetMetricDataV2 API
* `Aws\ACMPCA` - This release adds support for waiters to fail on AccessDeniedException when having insufficient permissions
* `Aws\Kafka` - AWS MSK support for Broker Removal.
* `Aws\QuickSight` - This release adds DescribeKeyRegistration and UpdateKeyRegistration APIs to manage QuickSight Customer Managed Keys (CMK).
* `Aws\MWAA` - Amazon MWAA now supports Airflow web server auto scaling to automatically handle increased demand from REST APIs, Command Line Interface (CLI), or more Airflow User Interface (UI) users. Customers can specify maximum and minimum web server instances during environment creation and update workflow.
* `Aws\SageMaker` - Introduced WorkerAccessConfiguration to SageMaker Workteam. This allows customers to configure resource access for workers in a workteam.

## 3.306.7 - 2024-05-15

* `Aws\` - Remove Honeycode and AlexaForBusiness clients from the SDK since they have been discontinued.
* `Aws\BedrockAgentRuntime` - Updating Bedrock Knowledge Base Metadata & Filters feature with two new filters listContains and stringContains
* `Aws\DataSync` - Task executions now display a CANCELLING status when an execution is in the process of being cancelled.
* `Aws\ManagedGrafana` - This release adds new ServiceAccount and ServiceAccountToken APIs.
* `Aws\SecurityHub` - Documentation-only update for AWS Security Hub
* `Aws\MedicalImaging` - Added support for importing medical imaging data from Amazon S3 buckets across accounts and regions.
* `Aws\CodeBuild` - CodeBuild Reserved Capacity VPC Support

## 3.306.6 - 2024-05-14

* `Aws\Connect` - Amazon Connect provides enhanced search capabilities for flows & flow modules on the Connect admin website and programmatically using APIs. You can search for flows and flow modules by name, description, type, status, and tags, to filter and identify a specific flow in your Connect instances.
* `Aws\S3` - Updated a few x-id in the http uri traits

## 3.306.5 - 2024-05-13

* `Aws\VPCLattice` - This release adds TLS Passthrough support. It also increases max number of target group per rule to 10.
* `Aws\EventBridge` - Amazon EventBridge introduces KMS customer-managed key (CMK) encryption support for custom and partner events published on EventBridge Event Bus (including default bus) and UpdateEventBus API.

## 3.306.4 - 2024-05-10

* `Aws\SageMaker` - Introduced support for G6 instance types on Sagemaker Notebook Instances and on SageMaker Studio for JupyterLab and CodeEditor applications.
* `Aws\GreengrassV2` - Mark ComponentVersion in ComponentDeploymentSpecification as required.
* `Aws\SSOOIDC` - Updated request parameters for PKCE support.
* `Aws\ApplicationDiscoveryService` - add v2 smoke tests and smithy smokeTests trait for SDK testing

## 3.306.3 - 2024-05-09

* `Aws\VerifiedPermissions` - Adds policy effect and actions fields to Policy API's.
* `Aws\SsmSap` - Added support for application-aware start/stop of SAP applications running on EC2 instances, with SSM for SAP
* `Aws\BedrockAgentRuntime` - This release adds support to provide guardrail configuration and modify inference parameters that are then used in RetrieveAndGenerate API in Agents for Amazon Bedrock.
* `Aws\Pinpoint` - This release adds support for specifying email message headers for Email Templates, Campaigns, Journeys and Send Messages.
* `Aws\Route53Resolver` - Update the DNS Firewall settings to correct a spelling issue.

## 3.306.2 - 2024-05-08

* `Aws\ECR` - This release adds pull through cache rules support for GitLab container registry in Amazon ECR.
* `Aws\CognitoIdentityProvider` - Add EXTERNAL_PROVIDER enum value to UserStatusType.
* `Aws\FMS` - The policy scope resource tag is always a string value, either a non-empty string or an empty string.
* `Aws\EC2` - Adding Precision Hardware Clock (PHC) to public API DescribeInstanceTypes
* `Aws\Polly` - Add new engine - generative - that builds the most expressive conversational voices.
* `Aws\SQS` - This release adds MessageSystemAttributeNames to ReceiveMessageRequest to replace AttributeNames.

## 3.306.1 - 2024-05-07

* `Aws\Budgets` - This release adds tag support for budgets and budget actions.
* `Aws\Route53Profiles` - Doc only update for Route 53 profiles that fixes some link issues
* `Aws\B2bi` - Documentation update to clarify the MappingTemplate definition.
* `Aws\ResilienceHub` - AWS Resilience Hub has expanded its drift detection capabilities by introducing a new type of drift detection - application resource drift. This new enhancement detects changes, such as the addition or deletion of resources within the application's input sources.

## 3.306.0 - 2024-05-06

* `Aws\Parser` - Adds support for event streaming on JSON-RPC protocol parser
* `Aws\MediaLive` - AWS Elemental MediaLive now supports configuring how SCTE 35 passthrough triggers segment breaks in HLS and MediaPackage output groups. Previously, messages triggered breaks in all these output groups. The new option is to trigger segment breaks only in groups that have SCTE 35 passthrough enabled.

## 3.305.9 - 2024-05-03

* `Aws\` - Fixes issue with manually configured signature versions.
* `Aws\Connect` - This release adds 5 new APIs for managing attachments: StartAttachedFileUpload, CompleteAttachedFileUpload, GetAttachedFile, BatchGetAttachedFileMetadata, DeleteAttachedFile. These APIs can be used to programmatically upload and download attachments to Connect resources, like cases.
* `Aws\SageMaker` - Amazon SageMaker Inference now supports m6i, c6i, r6i, m7i, c7i, r7i and g5 instance types for Batch Transform Jobs
* `Aws\DataSync` - Updated guidance on using private or self-signed certificate authorities (CAs) with AWS DataSync object storage locations.
* `Aws\ConnectCases` - This feature supports the release of Files related items
* `Aws\SESv2` - Adds support for specifying replacement headers per BulkEmailEntry in SendBulkEmail in SESv2.
* `Aws\Inspector2` - This release adds CSV format to GetCisScanReport for Inspector v2
* `Aws\BedrockAgent` - This release adds support for using Provisioned Throughput with Bedrock Agents.

## 3.305.8 - 2024-05-02

* `Aws\EC2` - This release includes a new API for retrieving the public endorsement key of the EC2 instance's Nitro Trusted Platform Module (NitroTPM).
* `Aws\Personalize` - This releases ability to delete users and their data, including their metadata and interactions data, from a dataset group.
* `Aws\DynamoDB` - This release adds support to specify an optional, maximum OnDemandThroughput for DynamoDB tables and global secondary indexes in the CreateTable or UpdateTable APIs. You can also override the OnDemandThroughput settings by calling the ImportTable, RestoreFromPointInTime, or RestoreFromBackup APIs.
* `Aws\RedshiftServerless` - Update Redshift Serverless List Scheduled Actions Output Response to include Namespace Name.

## 3.305.7 - 2024-05-01

* `Aws\SESv2` - Fixes ListContacts and ListImportJobs APIs to use POST instead of GET.
* `Aws\BedrockAgent` - This release adds support for using MongoDB Atlas as a vector store when creating a knowledge base.
* `Aws\SecurityHub` - Updated CreateMembers API request with limits.
* `Aws\EC2` - Documentation updates for Amazon EC2.
* `Aws\PersonalizeRuntime` - This release adds support for a Reason attribute for predicted items generated by User-Personalization-v2.

## 3.305.6 - 2024-04-30

* `Aws\QuickSight` - New Q embedding supporting Generative Q&A
* `Aws\OpenSearchService` - This release enables customers to create Route53 A and AAAA alias record types to point custom endpoint domain to OpenSearch domain's dualstack search endpoint.
* `Aws\ChimeSDKVoice` - Due to changes made by the Amazon Alexa service, GetSipMediaApplicationAlexaSkillConfiguration and PutSipMediaApplicationAlexaSkillConfiguration APIs are no longer available for use. For more information, refer to the Alexa Smart Properties page.
* `Aws\signer` - Documentation updates for AWS Signer. Adds cross-account signing constraint and definitions for cross-account actions.
* `Aws\PinpointSMSVoiceV2` - Amazon Pinpoint has added two new features Multimedia services (MMS) and protect configurations. Use the three new MMS APIs to send media messages to a mobile phone which includes image, audio, text, or video files. Use the ten new protect configurations APIs to block messages to specific countries.
* `Aws\Route53Resolver` - Release of FirewallDomainRedirectionAction parameter on the Route 53 DNS Firewall Rule. This allows customers to configure a DNS Firewall rule to inspect all the domains in the DNS redirection chain (default) , such as CNAME, ALIAS, DNAME, etc., or just the first domain and trust the rest.
* `Aws\QBusiness` - This is a general availability (GA) release of Amazon Q Business. Q Business enables employees in an enterprise to get comprehensive answers to complex questions and take actions through a unified, intuitive web-based chat experience - using an enterprise's existing content, data, and systems.
* `Aws\FMS` - AWS Firewall Manager now supports the network firewall service stream exception policy feature for accounts within your organization.
* `Aws\CodeArtifact` - Add support for the Ruby package format.
* `Aws\Omics` - Add support for workflow sharing and dynamic run storage
* `Aws\SageMaker` - Amazon SageMaker Training now supports the use of attribute-based access control (ABAC) roles for training job execution roles. Amazon SageMaker Inference now supports G6 instance types.

## 3.305.5 - 2024-04-29

* `Aws\ConnectCases` - This feature releases DeleteField, DeletedLayout, and DeleteTemplate API's
* `Aws\Amplify` - Updating max results limit for listing any resources (Job, Artifacts, Branch, BackendResources, DomainAssociation) to 50 with the exception of list apps that where max results can be up to 100.
* `Aws\Inspector2` - Update Inspector2 to include new Agentless API parameters.
* `Aws\TranscribeService` - This update provides error messaging for generative call summarization in Transcribe Call Analytics
* `Aws\TimestreamQuery` - This change allows users to update and describe account settings associated with their accounts.
* `Aws\TrustedAdvisor` - This release adds the BatchUpdateRecommendationResourceExclusion API to support batch updates of Recommendation Resource exclusion statuses and introduces a new exclusion status filter to the ListRecommendationResources and ListOrganizationRecommendationResources APIs.

## 3.305.4 - 2024-04-26

* `Aws\OAM` - This release introduces support for Source Accounts to define which Metrics and Logs to share with the Monitoring Account
* `Aws\RDS` - SupportsLimitlessDatabase field added to describe-db-engine-versions to indicate whether the DB engine version supports Aurora Limitless Database.
* `Aws\Support` - Releasing minor endpoint updates.
* `Aws\MarketplaceEntitlementService` - Releasing minor endpoint updates.
* `Aws\CodePipeline` - Add ability to manually and automatically roll back a pipeline stage to a previously successful execution.
* `Aws\ConnectCampaignService` - This release adds support for specifying if Answering Machine should wait for prompt sound.
* `Aws\CognitoIdentityProvider` - Add LimitExceededException to SignUp errors

## 3.305.3 - 2024-04-25

* `Aws\Credentials` - Makes the SSO token to be refreshed when required and allowed by the rules states on the sso token provider specs.
* `Aws\FMS` - AWS Firewall Manager adds support for network ACL policies to manage Amazon Virtual Private Cloud (VPC) network access control lists (ACLs) for accounts in your organization.
* `Aws\SFN` - Add new ValidateStateMachineDefinition operation, which performs syntax checking on the definition of a Amazon States Language (ASL) state machine.
* `Aws\IVSRealTime` - Bug Fix: IVS Real Time does not support ARNs using the `svs` prefix.
* `Aws\AppSync` - UpdateGraphQLAPI documentation update and datasource introspection secret arn update
* `Aws\IVS` - Bug Fix: IVS does not support arns with the `svs` prefix
* `Aws\RDS` - Updates Amazon RDS documentation for setting local time zones for RDS for Db2 DB instances.

## 3.305.2 - 2024-04-24

* `Aws\EntityResolution` - Support Batch Unique IDs Deletion.
* `Aws\DataSync` - This change allows users to disable and enable the schedules associated with their tasks.
* `Aws\EMRContainers` - EMRonEKS Service support for SecurityConfiguration enforcement for Spark Jobs.
* `Aws\EC2` - Launching capability for customers to enable or disable automatic assignment of public IPv4 addresses to their network interface
* `Aws\SSM` - Add SSM DescribeInstanceProperties API to public AWS SDK.
* `Aws\GameLift` - Amazon GameLift releases container fleets support for public preview. Deploy Linux-based containerized game server software for hosting on Amazon GameLift.

## 3.305.1 - 2024-04-23

* `Aws\BedrockAgentRuntime` - This release introduces zero-setup file upload support for the RetrieveAndGenerate API. This allows you to chat with your data without setting up a Knowledge Base.
* `Aws\PI` - Clarifies how aggregation works for GetResourceMetrics in the Performance Insights API.
* `Aws\WorkSpacesWeb` - Added InstanceType and MaxConcurrentSessions parameters on CreatePortal and UpdatePortal Operations as well as the ability to read Customer Managed Key & Additional Encryption Context parameters on supported resources (Portal, BrowserSettings, UserSettings, IPAccessSettings)
* `Aws\BedrockAgent` - Introducing the ability to create multiple data sources per knowledge base, specify S3 buckets as data sources from external accounts, and exposing levers to define the deletion behavior of the underlying vector store data.
* `Aws\Bedrock` - This release introduces Model Evaluation and Guardrails for Amazon Bedrock.
* `Aws\RDS` - Fix the example ARN for ModifyActivityStreamRequest
* `Aws\EC2` - This release introduces EC2 AMI Deregistration Protection, a new AMI property that can be enabled by customers to protect an AMI against an unintended deregistration. This release also enables the AMI owners to view the AMI 'LastLaunchedTime' in DescribeImages API.
* `Aws\BedrockRuntime` - This release introduces Guardrails for Amazon Bedrock.
* `Aws\CostExplorer` - Added additional metadata that might be applicable to your reservation recommendations.

## 3.305.0 - 2024-04-22

* `Aws\BedrockAgent` - Releasing the support for simplified configuration and return of control
* `Aws\SageMaker` - This release adds support for Real-Time Collaboration and Shared Space for JupyterLab App on SageMaker Studio.
* `Aws\Route53Profiles` - Route 53 Profiles allows you to apply a central DNS configuration across many VPCs regardless of account.
* `Aws\ServiceDiscovery` - This release adds examples to several Cloud Map actions.
* `Aws\RedshiftServerless` - Updates description of schedule field for scheduled actions.
* `Aws\PaymentCryptography` - Adding support to TR-31/TR-34 exports for optional headers, allowing customers to add additional metadata (such as key version and KSN) when exporting keys from the service.
* `Aws\Transfer` - Adding new API to support remote directory listing using SFTP connector
* `Aws\BedrockAgentRuntime` - Releasing the support for simplified configuration and return of control

## 3.304.8 - 2024-04-19

* `Aws\Personalize` - This releases auto training capability while creating a solution and automatically syncing latest solution versions when creating/updating a campaign
* `Aws\InternetMonitor` - This update introduces the GetInternetEvent and ListInternetEvents APIs, which provide access to internet events displayed on the Amazon CloudWatch Internet Weather Map.
* `Aws\Glue` - Adding RowFilter in the response for GetUnfilteredTableMetadata API

## 3.304.7 - 2024-04-18

* `Aws\drs` - Outpost ARN added to Source Server and Recovery Instance
* `Aws\WorkSpaces` - Adds new APIs for managing and sharing WorkSpaces BYOL configuration across accounts.
* `Aws\RolesAnywhere` - This release introduces the PutAttributeMapping and DeleteAttributeMapping APIs. IAM Roles Anywhere now provides the capability to define a set of mapping rules, allowing customers to specify which data is extracted from their X.509 end-entity certificates.
* `Aws\GuardDuty` - Added IPv6Address fields for local and remote IP addresses
* `Aws\EMRServerless` - This release adds the capability to publish detailed Spark engine metrics to Amazon Managed Service for Prometheus (AMP) for enhanced monitoring for Spark jobs.
* `Aws\QuickSight` - This release adds support for the Cross Sheet Filter and Control features, and support for warnings in asset imports for any permitted errors encountered during execution
* `Aws\SageMaker` - Removed deprecated enum values and updated API documentation.

## 3.304.6 - 2024-04-17

* `Aws\QBusiness` - This release adds support for IAM Identity Center (IDC) as the identity gateway for Q Business. It also allows users to provide an explicit intent for Q Business to identify how the Chat request should be handled.
* `Aws\EC2` - Documentation updates for Elastic Compute Cloud (EC2).

## 3.304.5 - 2024-04-16

* `Aws\BedrockAgent` - For Create Agent API, the agentResourceRoleArn parameter is no longer required.
* `Aws\EntityResolution` - Cross Account Resource Support .
* `Aws\WellArchitected` - AWS Well-Architected now has a Connector for Jira to allow customers to efficiently track workload risks and improvement efforts and create closed-loop mechanisms.
* `Aws\EMRServerless` - This release adds support for shuffle optimized disks that allow larger disk sizes and higher IOPS to efficiently run shuffle heavy workloads.
* `Aws\MainframeModernization` - Adding new ListBatchJobRestartPoints API and support for restart batch job.
* `Aws\MediaPackageV2` - Dash v2 is a MediaPackage V2 feature to support egressing on DASH manifest format.
* `Aws\IoTWireless` - Add PublicGateways in the GetWirelessStatistics call response, indicating the LoRaWAN public network accessed by the device.
* `Aws\LakeFormation` - This release adds Lake Formation managed RAM support for the 4 APIs - "DescribeLakeFormationIdentityCenterConfiguration", "CreateLakeFormationIdentityCenterConfiguration", "DescribeLakeFormationIdentityCenterConfiguration", and "DeleteLakeFormationIdentityCenterConfiguration"
* `Aws\Outposts` - This release adds new APIs to allow customers to configure their Outpost capacity at order-time.

## 3.304.4 - 2024-04-12

* `Aws\HealthLake` - Added new CREATE_FAILED status for data stores. Added new errorCause to DescribeFHIRDatastore API and ListFHIRDatastores API response for additional insights into data store creation and deletion workflows.
* `Aws\CloudFormation` - Adding support for the new parameter "IncludePropertyValues" in the CloudFormation DescribeChangeSet API. When this parameter is included, the DescribeChangeSet response will include more detailed information such as before and after values for the resource properties that will change.
* `Aws\ConfigService` - Updates documentation for AWS Config
* `Aws\KMS` - This feature supports the ability to specify a custom rotation period for automatic key rotations, the ability to perform on-demand key rotations, and visibility into your key material rotations.
* `Aws\Outposts` - This release adds EXPEDITORS as a valid shipment carrier.
* `Aws\NeptuneGraph` - Update to API documentation to resolve customer reported issues.
* `Aws\IoTFleetHub` - Documentation updates for AWS IoT Fleet Hub to clarify that Fleet Hub supports organization instance of IAM Identity Center.
* `Aws\Transfer` - This change releases support for importing self signed certificates to the Transfer Family for sending outbound file transfers over TLS/HTTPS.
* `Aws\Redshift` - Adds support for Amazon Redshift DescribeClusterSnapshots API to include Snapshot ARN response field.
* `Aws\MediaTailor` - Added InsertionMode to PlaybackConfigurations. This setting controls whether players can use stitched or guided ad insertion. The default for players that do not specify an insertion mode is stitched.
* `Aws\Glue` - Modifying request for GetUnfilteredTableMetadata for view-related fields.

## 3.304.3 - 2024-04-11

* `Aws\Batch` - This release adds the task properties field to attempt details and the name field on EKS container detail.
* `Aws\MediaLive` - AWS Elemental MediaLive introduces workflow monitor, a new feature that enables the visualization and monitoring of your media workflows. Create signal maps of your existing workflows and monitor them by creating notification and monitoring template groups.
* `Aws\WAFV2` - Adds an updated version of smoke tests, including smithy trait, for SDK testing.
* `Aws\RDS` - Updates Amazon RDS documentation for Standard Edition 2 support in RDS Custom for Oracle.
* `Aws\Pipes` - LogConfiguration ARN validation fixes
* `Aws\Omics` - This release adds support for retrieval of S3 direct access metadata on sequence stores and read sets, and adds support for SHA256up and SHA512up HealthOmics ETags.
* `Aws\CodeBuild` - Support access tokens for Bitbucket sources
* `Aws\IAM` - For CreateOpenIDConnectProvider API, the ThumbprintList parameter is no longer required.
* `Aws\S3Control` - Documentation updates for Amazon S3-control.
* `Aws\CloudFront` - CloudFront origin access control extends support to AWS Lambda function URLs and AWS Elemental MediaPackage v2 origins.
* `Aws\CloudWatch` - This release adds support for Metric Characteristics for CloudWatch Anomaly Detection. Anomaly Detector now takes Metric Characteristics object with Periodic Spikes boolean field that tells Anomaly Detection that spikes that repeat at the same time every week are part of the expected pattern.

## 3.304.2 - 2024-04-10

* `Aws\NetworkMonitor` - Examples were added to CloudWatch Network Monitor commands.
* `Aws\Rekognition` - Added support for ContentType to content moderation detections.
* `Aws\WorkSpacesThinClient` - Adding tags field to SoftwareSet. Removing tags fields from Summary objects. Changing the list of exceptions in tagging APIs. Fixing an issue where the SDK returns empty tags in Get APIs.
* `Aws\SupplyChain` - This release includes API SendDataIntegrationEvent for AWS Supply Chain
* `Aws\CleanRooms` - AWS Clean Rooms Differential Privacy is now fully available. Differential privacy protects against user-identification attempts.
* `Aws\QConnect` - This release adds a new QiC public API updateSession and updates an existing QiC public API createSession
* `Aws\Connect` - This release adds new Submit Auto Evaluation Action for Amazon Connect Rules.

## 3.304.1 - 2024-04-09

* `Aws\MediaConvert` - This release includes support for bringing your own fonts to use for burn-in or DVB-Sub captioning workflows.
* `Aws\Pinpoint` - The OrchestrationSendingRoleArn has been added to the email channel and is used to send emails from campaigns or journeys.
* `Aws\RDS` - This release adds support for specifying the CA certificate to use for the new db instance when restoring from db snapshot, restoring from s3, restoring to point in time, and creating a db instance read replica.
* `Aws\CodeBuild` - Add new webhook filter types for GitHub webhooks

## 3.304.0 - 2024-04-08

* `Aws\ControlCatalog` - This is the initial SDK release for AWS Control Catalog, a central catalog for AWS managed controls. This release includes 3 new APIs - ListDomains, ListObjectives, and ListCommonControls - that vend high-level data to categorize controls across the AWS platform.
* `Aws\mgn` - Added USE_SOURCE as default option to LaunchConfigurationTemplate bootMode parameter.
* `Aws\NetworkMonitor` - Updated the allowed monitorName length for CloudWatch Network Monitor.

## 3.303.4 - 2024-04-05

* `Aws\QuickSight` - Adding IAMIdentityCenterInstanceArn parameter to CreateAccountSubscription
* `Aws\ResourceGroups` - Added a new QueryErrorCode RESOURCE_TYPE_NOT_SUPPORTED that is returned by the ListGroupResources operation if the group query contains unsupported resource types.
* `Aws\VerifiedPermissions` - Adding BatchIsAuthorizedWithToken API which supports multiple authorization requests against a PolicyStore given a bearer token.

## 3.303.3 - 2024-04-04

* `Aws\VerifiedPermissions` - Adds GroupConfiguration field to Identity Source API's
* `Aws\B2bi` - Adding support for X12 5010 HIPAA EDI version and associated transaction sets.
* `Aws\EC2` - Amazon EC2 G6 instances powered by NVIDIA L4 Tensor Core GPUs can be used for a wide range of graphics-intensive and machine learning use cases. Gr6 instances also feature NVIDIA L4 GPUs and can be used for graphics workloads with higher memory requirements.
* `Aws\EMRContainers` - This release adds support for integration with EKS AccessEntry APIs to enable automatic Cluster Access for EMR on EKS.
* `Aws\CleanRooms` - Feature: New schemaStatusDetails field to the existing Schema object that displays a status on Schema API responses to show whether a schema is queryable or not. New BatchGetSchemaAnalysisRule API to retrieve multiple schemaAnalysisRules using a single API call.
* `Aws\IVS` - API update to include an SRT ingest endpoint and passphrase for all channels.

## 3.303.2 - 2024-04-03

* `Aws\CleanRoomsML` - The release includes a public SDK for AWS Clean Rooms ML APIs, making them globally available to developers worldwide.
* `Aws\Transfer` - Add ability to specify Security Policies for SFTP Connectors
* `Aws\GroundStation` - This release adds visibilityStartTime and visibilityEndTime to DescribeContact and ListContacts responses.
* `Aws\MedicalImaging` - SearchImageSets API now supports following enhancements - Additional support for searching on UpdatedAt and SeriesInstanceUID - Support for searching existing filters between dates/times - Support for sorting the search result by Ascending/Descending - Additional parameters returned in the response
* `Aws\Lambda` - Add Ruby 3.3 (ruby3.3) support to AWS Lambda
* `Aws\DocDB` - This release adds Global Cluster Switchover capability which enables you to change your global cluster's primary AWS Region, the region that serves writes, while preserving the replication between all regions in the global cluster.
* `Aws\DataZone` - This release supports the feature of dataQuality to enrich asset with dataQualityResult in Amazon DataZone.
* `Aws\CloudFormation` - This release would return a new field - PolicyAction in cloudformation's existed DescribeChangeSetResponse, showing actions we are going to apply on the physical resource (e.g., Delete, Retain) according to the user's template
* `Aws\MediaLive` - Cmaf Ingest outputs are now supported in Media Live

## 3.303.1 - 2024-04-02

* `Aws\ivschat` - Doc-only update. Changed "Resources" to "Key Concepts" in docs and updated text.
* `Aws\SecurityHub` - Documentation updates for AWS Security Hub
* `Aws\RolesAnywhere` - This release increases the limit on the roleArns request parameter for the *Profile APIs that support it. This parameter can now take up to 250 role ARNs.
* `Aws\ECS` - Documentation only update for Amazon ECS.
* `Aws\Glue` - Adding View related fields to responses of read-only Table APIs.

## 3.303.0 - 2024-04-01

* `Aws\CloudWatch` - This release adds support for CloudWatch Anomaly Detection on cross-account metrics. SingleMetricAnomalyDetector and MetricDataQuery inputs to Anomaly Detection APIs now take an optional AccountId field.
* `Aws\EMR` - This release fixes a broken link in the documentation.
* `Aws\Deadline` - AWS Deadline Cloud is a new fully managed service that helps customers set up, deploy, and scale rendering projects in minutes, so they can improve the efficiency of their rendering pipelines and take on more projects.
* `Aws\DataZone` - This release supports the feature of AI recommendations for descriptions to enrich the business data catalog in Amazon DataZone.
* `Aws\Lightsail` - This release adds support to upgrade the TLS version of the distribution.

## 3.302.0 - 2024-03-29

* `Aws\NeptuneGraph` - Add the new API Start-Import-Task for Amazon Neptune Analytics.
* `Aws\CodeBuild` - Add new fleet status code for Reserved Capacity.
* `Aws\B2bi` - Supporting new EDI X12 transaction sets for X12 versions 4010, 4030, and 5010.
* `Aws\IoTWireless` - Add support for retrieving key historical and live metrics for LoRaWAN devices and gateways
* `Aws\InternetMonitor` - This release adds support to allow customers to track cross account monitors through ListMonitor, GetMonitor, ListHealthEvents, GetHealthEvent, StartQuery APIs.
* `Aws\CodeConnections` - Duplicating the CodeStar Connections service into the new, rebranded AWS CodeConnections service.
* `Aws\SageMaker` - This release adds support for custom images for the CodeEditor App on SageMaker Studio
* `Aws\MarketplaceCatalog` - This release enhances the ListEntities API to support ResaleAuthorizationId filter and sort for OfferEntity in the request and the addition of a ResaleAuthorizationId field in the response of OfferSummary.

## 3.301.10 - 2024-03-28

* `Aws\EKS` - Add multiple customer error code to handle customer caused failure when managing EKS node groups
* `Aws\ComputeOptimizer` - This release enables AWS Compute Optimizer to analyze and generate recommendations with a new customization preference, Memory Utilization.
* `Aws\NeptuneGraph` - Update ImportTaskCancelled waiter to evaluate task state correctly and minor documentation changes.
* `Aws\QuickSight` - Amazon QuickSight: Adds support for setting up VPC Endpoint restrictions for accessing QuickSight Website.
* `Aws\OAM` - This release adds support for sharing AWS::InternetMonitor::Monitor resources.
* `Aws\EC2` - Amazon EC2 C7gd, M7gd and R7gd metal instances with up to 3.8 TB of local NVMe-based SSD block-level storage have up to 45% improved real-time NVMe storage performance than comparable Graviton2-based instances.
* `Aws\GuardDuty` - Add EC2 support for GuardDuty Runtime Monitoring auto management.
* `Aws\CodeCatalyst` - This release adds support for understanding pending changes to subscriptions by including two new response parameters for the GetSubscription API for Amazon CodeCatalyst.

## 3.301.9 - 2024-03-27

* `Aws\BedrockAgentRuntime` - This release introduces filtering support on Retrieve and RetrieveAndGenerate APIs.
* `Aws\ElastiCache` - Added minimum capacity to Amazon ElastiCache Serverless. This feature allows customer to ensure minimum capacity even without current load
* `Aws\SecretsManager` - Documentation updates for Secrets Manager
* `Aws\BedrockAgent` - This changes introduces metadata documents statistics and also updates the documentation for bedrock agent.
* `Aws\Batch` - This feature allows AWS Batch to support configuration of imagePullSecrets and allowPrivilegeEscalation for jobs running on EKS

## 3.301.8 - 2024-03-26

* `Aws\CostExplorer` - Adds support for backfill of cost allocation tags, with new StartCostAllocationTagBackfill and ListCostAllocationTagBackfillHistory API.
* `Aws\finspace` - Add new operation delete-kx-cluster-node and add status parameter to list-kx-cluster-node operation.
* `Aws\ECS` - This is a documentation update for Amazon ECS.
* `Aws\EC2` - Documentation updates for Elastic Compute Cloud (EC2).
* `Aws\BedrockAgentRuntime` - This release adds support to customize prompts sent through the RetrieveAndGenerate API in Agents for Amazon Bedrock.

## 3.301.7 - 2024-03-25

* `Aws\EC2` - Added support for ModifyInstanceMetadataDefaults and GetInstanceMetadataDefaults to set Instance Metadata Service account defaults
* `Aws\SageMaker` - Introduced support for the following new instance types on SageMaker Studio for JupyterLab and CodeEditor applications: m6i, m6id, m7i, c6i, c6id, c7i, r6i, r6id, r7i, and p5
* `Aws\ECS` - Documentation only update for Amazon ECS.
* `Aws\MediaLive` - Exposing TileMedia H265 options
* `Aws\EMRContainers` - This release increases the number of supported job template parameters from 20 to 100.
* `Aws\GlobalAccelerator` - AWS Global Accelerator now supports cross-account sharing for bring your own IP addresses.
* `Aws\CodeBuild` - Supporting GitLab and GitLab Self Managed as source types in AWS CodeBuild.

## 3.301.6 - 2024-03-22

* `Aws\kendra` - Documentation update, March 2024. Corrects some docs for Amazon Kendra.
* `Aws\Pricing` - Add ResourceNotFoundException to ListPriceLists and GetPriceListFileUrl APIs
* `Aws\RolesAnywhere` - This release relaxes constraints on the durationSeconds request parameter for the *Profile APIs that support it. This parameter can now take on values that go up to 43200.
* `Aws\SecurityHub` - Added new resource detail object to ASFF, including resource for LastKnownExploitAt
* `Aws\Firehose` - Updates Amazon Firehose documentation for message regarding Enforcing Tags IAM Policy.

## 3.301.5 - 2024-03-21

* `Aws\CodeArtifact` - This release adds Package groups to CodeArtifact so you can more conveniently configure package origin controls for multiple packages.

## 3.301.4 - 2024-03-20

* `Aws\ManagedBlockchainQuery` - AMB Query: update GetTransaction to include transactionId as input
* `Aws\CodeBuild` - This release adds support for new webhook events (RELEASED and PRERELEASED) and filter types (TAG_NAME and RELEASE_NAME).
* `Aws\SavingsPlans` - Introducing the Savings Plans Return feature enabling customers to return their Savings Plans within 7 days of purchase.
* `Aws\Connect` - This release updates the *InstanceStorageConfig APIs to support a new ResourceType: REAL_TIME_CONTACT_ANALYSIS_CHAT_SEGMENTS. Use this resource type to enable streaming for real-time analysis of chat contacts and to associate a Kinesis stream where real-time analysis chat segments will be published.
* `Aws\AccessAnalyzer` - This release adds support for policy validation and external access findings for DynamoDB tables and streams. IAM Access Analyzer helps you author functional and secure resource-based policies and identify cross-account access. Updated service API, documentation, and paginators.
* `Aws\DynamoDB` - This release introduces 3 new APIs ('GetResourcePolicy', 'PutResourcePolicy' and 'DeleteResourcePolicy') and modifies the existing 'CreateTable' API for the resource-based policy support. It also modifies several APIs to accept a 'TableArn' for the 'TableName' parameter.

## 3.301.3 - 2024-03-19

* `Aws\finspace` - Adding new attributes readWrite and onDemand to dataview models for Database Maintenance operations.
* `Aws\ManagedBlockchainQuery` - Introduces a new API for Amazon Managed Blockchain Query: ListFilteredTransactionEvents.
* `Aws\CloudFormation` - Documentation update, March 2024. Corrects some formatting.
* `Aws\CloudWatchLogs` - Update LogSamples field in Anomaly model to be a list of LogEvent
* `Aws\EC2` - This release adds the new DescribeMacHosts API operation for getting information about EC2 Mac Dedicated Hosts. Users can now see the latest macOS versions that their underlying Apple Mac can support without needing to be updated.

## 3.301.2 - 2024-03-18

* `Aws\S3` - Fix two issues with response root node names.
* `Aws\KMS` - Adds the ability to use the default policy name by omitting the policyName parameter in calls to PutKeyPolicy and GetKeyPolicy
* `Aws\CloudFormation` - This release supports for a new API ListStackSetAutoDeploymentTargets, which provider auto-deployment configuration as a describable resource. Customers can now view the specific combinations of regions and OUs that are being auto-deployed.
* `Aws\TimestreamQuery` - Documentation updates, March 2024
* `Aws\RDS` - This release launches the ModifyIntegration API and support for data filtering for zero-ETL Integrations.
* `Aws\MediaTailor` - This release adds support to allow customers to show different content within a channel depending on metadata associated with the viewer.

## 3.301.1 - 2024-03-15

* `Aws\S3` - Documentation updates for Amazon S3.
* `Aws\EC2` - Add media accelerator and neuron device information on the describe instance types API.
* `Aws\Backup` - This release introduces a boolean attribute ManagedByAWSBackupOnly as part of ListRecoveryPointsByResource api to filter the recovery points based on ownership. This attribute can be used to filter out the recovery points protected by AWSBackup.
* `Aws\KinesisAnalyticsV2` - Support for Flink 1.18 in Managed Service for Apache Flink
* `Aws\SageMaker` - Adds m6i, m6id, m7i, c6i, c6id, c7i, r6i r6id, r7i, p5 instance type support to Sagemaker Notebook Instances and miscellaneous wording fixes for previous Sagemaker documentation.
* `Aws\WorkSpacesThinClient` - Removed unused parameter kmsKeyArn from UpdateDeviceRequest
* `Aws\Connect` - This release adds Hierarchy based Access Control fields to Security Profile public APIs and adds support for UserAttributeFilter to SearchUsers API.
* `Aws\CodeBuild` - AWS CodeBuild now supports overflow behavior on Reserved Capacity.

## 3.301.0 - 2024-03-14

* `Aws\` - Amazon IOT Roborunner has been removed from the SDK because it has been discontinued.
* `Aws\EC2InstanceConnect` - This release includes a new exception type "SerialConsoleSessionUnsupportedException" for SendSerialConsoleSSHPublicKey API.
* `Aws\ElasticLoadBalancingv2` - This release allows you to configure HTTP client keep-alive duration for communication between clients and Application Load Balancers.
* `Aws\RDS` - Updates Amazon RDS documentation for EBCDIC collation for RDS for Db2.
* `Aws\Amplify` - Documentation updates for Amplify. Identifies the APIs available only to apps created using Amplify Gen 1.
* `Aws\TimestreamInfluxDB` - This is the initial SDK release for Amazon Timestream for InfluxDB. Amazon Timestream for InfluxDB is a new time-series database engine that makes it easy for application developers and DevOps teams to run InfluxDB databases on AWS for near real-time time-series applications using open source APIs.
* `Aws\SecretsManager` - Doc only update for Secrets Manager
* `Aws\FIS` - This release adds support for previewing target resources before running a FIS experiment. It also adds resource ARNs for actions, experiments, and experiment templates to API responses.

## 3.300.17 - 2024-03-13

* `Aws\S3` - This release makes the default option for S3 on Outposts request signing to use the SigV4A algorithm when using AWS Common Runtime (CRT).
* `Aws\KinesisAnalyticsV2` - Support new RuntimeEnvironmentUpdate parameter within UpdateApplication API allowing callers to change the Flink version upon which their application runs.
* `Aws\IVSRealTime` - adds support for multiple new composition layout configuration options (grid, pip)

## 3.300.16 - 2024-03-12

* `Aws\EC2` - Documentation updates for Amazon EC2.
* `Aws\Kafka` - Added support for specifying the starting position of topic replication in MSK-Replicator.
* `Aws\Connect` - This release increases MaxResults limit to 500 in request for SearchUsers, SearchQueues and SearchRoutingProfiles APIs of Amazon Connect.
* `Aws\CloudFormation` - CloudFormation documentation update for March, 2024
* `Aws\SSM` - March 2024 doc-only updates for Systems Manager.

## 3.300.15 - 2024-03-11

* `Aws\ElastiCache` - Revisions to API text that are now to be carried over to SDK text, changing usages of "SFO" in code examples to "us-west-1", and some other typos.
* `Aws\CodeStarconnections` - Added a sync configuration enum to disable publishing of deployment status to source providers (PublishDeploymentStatus). Added a sync configuration enum (TriggerStackUpdateOn) to only trigger changes.
* `Aws\MediaPackageV2` - This release enables customers to safely update their MediaPackage v2 channel groups, channels and origin endpoints using entity tags.

## 3.300.14 - 2024-03-08

* `Aws\EndpointV2` - Updates auth scheme selection criteria
* `Aws\CloudTrail` - Added exceptions to CreateTrail, DescribeTrails, and ListImportFailures APIs.
* `Aws\Transfer` - Added DES_EDE3_CBC to the list of supported encryption algorithms for messages sent with an AS2 connector.
* `Aws\BedrockAgentRuntime` - Documentation update for Bedrock Runtime Agent
* `Aws\CodeBuild` - This release adds support for a new webhook event: PULL_REQUEST_CLOSED.
* `Aws\CognitoIdentityProvider` - Add ConcurrentModificationException to SetUserPoolMfaConfig
* `Aws\GuardDuty` - Add RDS Provisioned and Serverless Usage types
* `Aws\Batch` - This release adds JobStateTimeLimitActions setting to the Job Queue API. It allows you to configure an action Batch can take for a blocking job in front of the queue after the defined period of time. The new parameter applies for ECS, EKS, and FARGATE Job Queues.

## 3.300.13 - 2024-03-07

* `Aws\Snowball` - Doc-only update for change to EKS-Anywhere ordering.
* `Aws\Lambda` - Documentation updates for AWS Lambda
* `Aws\WAFV2` - You can increase the max request body inspection size for some regional resources. The size setting is in the web ACL association config. Also, the AWSManagedRulesBotControlRuleSet EnableMachineLearning setting now takes a Boolean instead of a primitive boolean type, for languages like Java.
* `Aws\AppConfig` - AWS AppConfig now supports dynamic parameters, which enhance the functionality of AppConfig Extensions by allowing you to provide parameter values to your Extensions at the time you deploy your configuration.
* `Aws\WorkSpaces` - Added note for user decoupling
* `Aws\EC2` - This release adds an optional parameter to RegisterImage and CopyImage APIs to support tagging AMIs at the time of creation.
* `Aws\RDS` - Updates Amazon RDS documentation for io2 storage for Multi-AZ DB clusters
* `Aws\PaymentCryptographyData` - AWS Payment Cryptography EMV Decrypt Feature Release
* `Aws\ManagedGrafana` - Adds support for the new GrafanaToken as part of the Amazon Managed Grafana Enterprise plugins upgrade to associate your AWS account with a Grafana Labs account.

## 3.300.12 - 2024-03-06

* `Aws\Redshift` - Update for documentation only. Covers port ranges, definition updates for data sharing, and definition updates to cluster-snapshot documentation.
* `Aws\RDS` - Updated the input of CreateDBCluster and ModifyDBCluster to support setting CA certificates. Updated the output of DescribeDBCluster to show current CA certificate setting value.
* `Aws\imagebuilder` - Add PENDING status to Lifecycle Execution resource status. Add StartTime and EndTime to ListLifecycleExecutionResource API response.
* `Aws\VerifiedPermissions` - Deprecating details in favor of configuration for GetIdentitySource and ListIdentitySources APIs.
* `Aws\DynamoDB` - Doc only updates for DynamoDB documentation
* `Aws\MWAA` - Amazon MWAA adds support for Apache Airflow v2.8.1.

## 3.300.11 - 2024-03-05

* `Aws\SESv2` - Adds support for providing custom headers within SendEmail and SendBulkEmail for SESv2.
* `Aws\Chatbot` - Minor update to documentation.
* `Aws\Organizations` - This release contains an endpoint addition
* `Aws\APIGateway` - Documentation updates for Amazon API Gateway

## 3.300.10 - 2024-03-04

* `Aws\CloudFormation` - Add DetailedStatus field to DescribeStackEvents and DescribeStacks APIs
* `Aws\Organizations` - Documentation update for AWS Organizations
* `Aws\FSx` - Added support for creating FSx for NetApp ONTAP file systems with up to 12 HA pairs, delivering up to 72 GB/s of read throughput and 12 GB/s of write throughput.

## 3.300.9 - 2024-03-01

* `Aws\AccessAnalyzer` - Fixed a typo in description field.
* `Aws\AutoScaling` - With this release, Amazon EC2 Auto Scaling groups, EC2 Fleet, and Spot Fleet improve the default price protection behavior of attribute-based instance type selection of Spot Instances, to consistently select from a wide range of instance types.
* `Aws\EC2` - With this release, Amazon EC2 Auto Scaling groups, EC2 Fleet, and Spot Fleet improve the default price protection behavior of attribute-based instance type selection of Spot Instances, to consistently select from a wide range of instance types.

## 3.300.8 - 2024-02-29

* `Aws\SageMaker` - Adds support for ModelDataSource in Model Packages to support unzipped models. Adds support to specify SourceUri for models which allows registration of models without mandating a container for hosting. Using SourceUri, customers can decouple the model from hosting information during registration.
* `Aws\SecurityLake` - Add capability to update the Data Lake's MetaStoreManager Role in order to perform required data lake updates to use Iceberg table format in their data lake or update the role for any other reason.
* `Aws\QuickSight` - TooltipTarget for Combo chart visuals; ColumnConfiguration limit increase to 2000; Documentation Update
* `Aws\DocDBElastic` - Launched Elastic Clusters Readable Secondaries, Start/Stop, Configurable Shard Instance count, Automatic Backups and Snapshot Copying
* `Aws\MigrationHubOrchestrator` - Adds new CreateTemplate, UpdateTemplate and DeleteTemplate APIs.
* `Aws\LexModelsV2` - This release makes AMAZON.QnAIntent generally available in Amazon Lex. This generative AI feature leverages large language models available through Amazon Bedrock to automate frequently asked questions (FAQ) experience for end-users.
* `Aws\EKS` - Added support for new AL2023 AMIs to the supported AMITypes.

## 3.300.7 - 2024-02-28

* `Aws\EC2` - This release increases the range of MaxResults for GetNetworkInsightsAccessScopeAnalysisFindings to 1,000.
* `Aws\IoT` - This release reduces the maximum results returned per query invocation from 500 to 100 for the SearchIndex API. This change has no implications as long as the API is invoked until the nextToken is NULL.
* `Aws\Batch` - This release adds Batch support for configuration of multicontainer jobs in ECS, Fargate, and EKS. This support is available for all types of jobs, including both array jobs and multi-node parallel jobs.
* `Aws\BedrockAgentRuntime` - This release adds support to override search strategy performed by the Retrieve and RetrieveAndGenerate APIs for Amazon Bedrock Agents
* `Aws\WAFV2` - AWS WAF now supports configurable time windows for request aggregation with rate-based rules. Customers can now select time windows of 1 minute, 2 minutes or 10 minutes, in addition to the previously supported 5 minutes.
* `Aws\CostExplorer` - This release introduces the new API 'GetApproximateUsageRecords', which retrieves estimated usage records for hourly granularity or resource-level data at daily granularity.

## 3.300.6 - 2024-02-27

* `Aws\AmplifyUIBuilder` - We have added the ability to tag resources after they are created

## 3.300.5 - 2024-02-26

* `Aws\KafkaConnect` - Adds support for tagging, with new TagResource, UntagResource and ListTagsForResource APIs to manage tags and updates to existing APIs to allow tag on create. This release also adds support for the new DeleteWorkerConfiguration API.
* `Aws\RDS` - This release adds support for gp3 data volumes for Multi-AZ DB Clusters.
* `Aws\drs` - Added volume status to DescribeSourceServer replicated volumes.
* `Aws\APIGateway` - Documentation updates for Amazon API Gateway.

## 3.300.4 - 2024-02-23

* `Aws\QLDB` - Clarify possible values for KmsKeyArn and EncryptionDescription.
* `Aws\CloudWatchRUM` - Doc-only update for new RUM metrics that were added
* `Aws\RDS` - Add pattern and length based validations for DBShardGroupIdentifier
* `Aws\AppSync` - Documentation only updates for AppSync

## 3.300.3 - 2024-02-22

* `Aws\InternetMonitor` - This release adds IPv4 prefixes to health events
* `Aws\KinesisVideo` - Increasing NextToken parameter length restriction for List APIs from 512 to 1024.

## 3.300.2 - 2024-02-21

* `Aws\MediaLive` - MediaLive now supports the ability to restart pipelines in a running channel.
* `Aws\IoTEvents` - Increase the maximum length of descriptions for Inputs, Detector Models, and Alarm Models
* `Aws\SSM` - This release adds support for sharing Systems Manager parameters with other AWS accounts.
* `Aws\LookoutEquipment` - This release adds a field exposing model quality to read APIs for models. It also adds a model quality field to the API response when creating an inference scheduler.

## 3.300.1 - 2024-02-20

* `Aws\DynamoDB` - Publishing quick fix for doc only update.
* `Aws\Lambda` - Add .NET 8 (dotnet8) Runtime support to AWS Lambda.
* `Aws\Firehose` - This release updates a few Firehose related APIs.

## 3.300.0 - 2024-02-19

* `Aws\Keyspaces` - Documentation updates for Amazon Keyspaces
* `Aws\Chatbot` - This release adds support for AWS Chatbot. You can now monitor, operate, and troubleshoot your AWS resources with interactive ChatOps using the AWS SDK.
* `Aws\Amplify` - This release contains API changes that enable users to configure their Amplify domains with their own custom SSL/TLS certificate.
* `Aws\IVS` - Changed description for latencyMode in Create/UpdateChannel and Channel/ChannelSummary.
* `Aws\MediaTailor` - MediaTailor: marking #AdBreak.OffsetMillis as required.
* `Aws\ConfigService` - Documentation updates for the AWS Config CLI

## 3.299.1 - 2024-02-16

* `Aws\Firehose` - This release adds support for Data Message Extraction for decompressed CloudWatch logs, and to use a custom file extension or time zone for S3 destinations.
* `Aws\EMR` - adds fine grained control over Unhealthy Node Replacement to Amazon ElasticMapReduce
* `Aws\SNS` - This release marks phone numbers as sensitive inputs.
* `Aws\ConnectParticipant` - Doc only update to GetTranscript API reference guide to inform users about presence of events in the chat transcript.
* `Aws\Lambda` - Documentation-only updates for Lambda to clarify a number of existing actions and properties.
* `Aws\RDS` - Doc only update for a valid option in DB parameter group

## 3.299.0 - 2024-02-15

* `Aws\Polly` - Amazon Polly adds 1 new voice - Burcu (tr-TR)
* `Aws\OpenSearchService` - Adds additional supported instance types.
* `Aws\Detective` - Doc only updates for content enhancement
* `Aws\Artifact` - This is the initial SDK release for AWS Artifact. AWS Artifact provides on-demand access to compliance and third-party compliance reports. This release includes access to List and Get reports, along with their metadata. This release also includes access to AWS Artifact notifications settings.
* `Aws\CodePipeline` - Add ability to override timeout on action level.
* `Aws\SageMaker` - This release adds a new API UpdateClusterSoftware for SageMaker HyperPod. This API allows users to patch HyperPod clusters with latest platform softwares.
* `Aws\HealthLake` - This release adds a new response parameter, JobProgressReport, to the DescribeFHIRImportJob and ListFHIRImportJobs API operation. JobProgressReport provides details on the progress of the import job on the server.
* `Aws\SecretsManager` - Doc only update for Secrets Manager
* `Aws\GuardDuty` - Marked fields IpAddressV4, PrivateIpAddress, Email as Sensitive.

## 3.298.10 - 2024-02-14

* `Aws\ControlTower` - Adds support for new Baseline and EnabledBaseline APIs for automating multi-account governance.
* `Aws\LookoutEquipment` - This feature allows customers to see pointwise model diagnostics results for their models.
* `Aws\QBusiness` - This release adds the metadata-boosting feature, which allows customers to easily fine-tune the underlying ranking of retrieved RAG passages in order to optimize Q&A answer relevance. It also adds new feedback reasons for the PutFeedback API.

## 3.298.9 - 2024-02-13

* `Aws\` - Fixes issue with configured endpoint urls.
* `Aws\ResourceExplorer2` - Resource Explorer now uses newly supported IPv4 'amazonaws.com' endpoints by default.
* `Aws\MarketplaceCatalog` - AWS Marketplace Catalog API now supports setting intent on requests
* `Aws\SecurityLake` - Documentation updates for Security Lake
* `Aws\Lightsail` - This release adds support to upgrade the major version of a database.

## 3.298.8 - 2024-02-12

* `Aws\NeptuneGraph` - Adding a new option "parameters" for data plane api ExecuteQuery to support running parameterized query via SDK.
* `Aws\AppSync` - Adds support for new options on GraphqlAPIs, Resolvers and Data Sources for emitting Amazon CloudWatch metrics for enhanced monitoring of AppSync APIs.
* `Aws\CloudWatch` - This release enables PutMetricData API request payload compression by default.
* `Aws\Route53Domains` - This release adds bill contact support for RegisterDomain, TransferDomain, UpdateDomainContact and GetDomainDetail API.

## 3.298.7 - 2024-02-09

* `Aws\ECS` - Documentation only update for Amazon ECS.
* `Aws\Pricing` - Add Throttling Exception to all APIs.
* `Aws\PrometheusService` - Overall documentation updates.
* `Aws\IoT` - This release allows AWS IoT Core users to enable Online Certificate Status Protocol (OCSP) Stapling for TLS X.509 Server Certificates when creating and updating AWS IoT Domain Configurations with Custom Domain.
* `Aws\Batch` - This feature allows Batch to support configuration of repository credentials for jobs running on ECS
* `Aws\CostOptimizationHub` - Adding includeMemberAccounts field to the response of ListEnrollmentStatuses API.
* `Aws\Braket` - Creating a job will result in DeviceOfflineException when using an offline device, and DeviceRetiredException when using a retired device.

## 3.298.6 - 2024-02-08

* `Aws\WorkSpaces` - This release introduces User-Decoupling feature. This feature allows Workspaces Core customers to provision workspaces without providing users. CreateWorkspaces and DescribeWorkspaces APIs will now take a new optional parameter "WorkspaceName".
* `Aws\CodePipeline` - Add ability to execute pipelines with new parallel & queued execution modes and add support for triggers with filtering on branches and file paths.
* `Aws\QuickSight` - General Interactions for Visuals; Waterfall Chart Color Configuration; Documentation Update

## 3.298.5 - 2024-02-07

* `Aws\DataSync` - AWS DataSync now supports manifests for specifying files or objects to transfer.
* `Aws\LexModelsV2` - This release introduces a new bot replication feature as part of Lex Global Resiliency offering. This feature leverages a new set of APIs that allow customers to create bot replicas and replicate changes to bots across regions.
* `Aws\Redshift` - LisRecommendations API to fetch Amazon Redshift Advisor recommendations.

## 3.298.4 - 2024-02-06

* `Aws\WAFV2` - You can now delete an API key that you've created for use with your CAPTCHA JavaScript integration API.
* `Aws\ECS` - This release is a documentation only update to address customer issues.
* `Aws\AppSync` - Support for environment variables in AppSync GraphQL APIs
* `Aws\CloudWatchLogs` - This release adds a new field, logGroupArn, to the response of the logs:DescribeLogGroups action.
* `Aws\OpenSearchService` - This release adds clear visibility to the customers on the changes that they make on the domain.
* `Aws\ElasticsearchService` - This release adds clear visibility to the customers on the changes that they make on the domain.

## 3.298.3 - 2024-02-05

* `Aws\WorkSpaces` - Added definitions of various WorkSpace states
* `Aws\Glue` - Introduce Catalog Encryption Role within Glue Data Catalog Settings. Introduce SASL/PLAIN as an authentication method for Glue Kafka connections

## 3.298.2 - 2024-02-02

* `Aws\DynamoDB` - Any number of users can execute up to 50 concurrent restores (any type of restore) in a given account.
* `Aws\SageMaker` - Amazon SageMaker Canvas adds GenerativeAiSettings support for CanvasAppSettings.

## 3.298.1 - 2024-02-01

* `Aws\IVS` - This release introduces a new resource Playback Restriction Policy which can be used to geo-restrict or domain-restrict channel stream playback when associated with a channel. New APIs to support this resource were introduced in the form of Create/Delete/Get/Update/List.
* `Aws\ManagedBlockchainQuery` - This release adds support for transactions that have not reached finality. It also removes support for the status property from the response of the GetTransaction operation. You can use the confirmationStatus and executionStatus properties to determine the status of the transaction.
* `Aws\MediaConvert` - This release includes support for broadcast-mixed audio description tracks.
* `Aws\NeptuneGraph` - Adding new APIs in SDK for Amazon Neptune Analytics. These APIs include operations to execute, cancel, list queries and get the graph summary.
* `Aws\CognitoIdentityProvider` - Added CreateIdentityProvider and UpdateIdentityProvider details for new SAML IdP features

## 3.298.0 - 2024-01-31

* `Aws\` - Adds support for the PHP 8.3 runtime
* `Aws\SSM` - This release adds an optional Duration parameter to StateManager Associations. This allows customers to specify how long an apply-only-on-cron association execution should run. Once the specified Duration is out all the ongoing cancellable commands or automations are cancelled.
* `Aws\Glue` - Update page size limits for GetJobRuns and GetTriggers APIs.
* `Aws\CloudFormation` - CloudFormation IaC generator allows you to scan existing resources in your account and select resources to generate a template for a new or existing CloudFormation stack.
* `Aws\ElasticLoadBalancingv2` - This release enables unhealthy target draining intervals for Network Load Balancers.

## 3.297.4 - 2024-01-30

* `Aws\DataZone` - Add new skipDeletionCheck to DeleteDomain. Add new skipDeletionCheck to DeleteProject which also automatically deletes dependent objects
* `Aws\Route53` - Update the SDKs for text changes in the APIs.

## 3.297.3 - 2024-01-29

* `Aws\Snowball` - Modified description of createaddress to include direction to add path when providing a JSON file.
* `Aws\MWAA` - This release adds MAINTENANCE environment status for Amazon MWAA environments.
* `Aws\RDS` - Introduced support for the InsufficientDBInstanceCapacityFault error in the RDS RestoreDBClusterFromSnapshot and RestoreDBClusterToPointInTime API methods. This provides enhanced error handling, ensuring a more robust experience.
* `Aws\AutoScaling` - EC2 Auto Scaling customers who use attribute based instance-type selection can now intuitively define their Spot instances price protection limit as a percentage of the lowest priced On-Demand instance type.
* `Aws\Comprehend` - Comprehend PII analysis now supports Spanish input documents.
* `Aws\EC2` - EC2 Fleet customers who use attribute based instance-type selection can now intuitively define their Spot instances price protection limit as a percentage of the lowest priced On-Demand instance type.

## 3.297.2 - 2024-01-26

* `Aws\Inspector2` - This release adds ECR container image scanning based on their lastRecordedPullTime.
* `Aws\Connect` - Update list and string length limits for predefined attributes.
* `Aws\SageMaker` - Amazon SageMaker Automatic Model Tuning now provides an API to programmatically delete tuning jobs.

## 3.297.1 - 2024-01-25

* `Aws\S3` - Fixes warning in S3 client when region is not provided in constructor
* `Aws\Lightsail` - This release adds support for IPv6-only instance plans.
* `Aws\ACMPCA` - AWS Private CA now supports an option to omit the CDP extension from issued certificates, when CRL revocation is enabled.

## 3.297.0 - 2024-01-24

* `Aws\Credentials` - Adds support for specifying custom IMDS endpoint when using the InstanceProfileProvider.
* `Aws\EC2` - Introduced a new clientToken request parameter on CreateNetworkAcl and CreateRouteTable APIs. The clientToken parameter allows idempotent operations on the APIs.
* `Aws\ECS` - Documentation updates for Amazon ECS.
* `Aws\Outposts` - DeviceSerialNumber parameter is now optional in StartConnection API
* `Aws\StorageGateway` - Add DeprecationDate and SoftwareVersion to response of ListGateways.
* `Aws\RDS` - This release adds support for Aurora Limitless Database.

## 3.296.8 - 2024-01-23

* `Aws\Inspector2` - This release adds support for CIS scans on EC2 instances.

## 3.296.7 - 2024-01-22

* `Aws\CloudFrontKeyValueStore` - This release improves upon the DescribeKeyValueStore API by returning two additional fields, Status of the KeyValueStore and the FailureReason in case of failures during creation of KeyValueStore.
* `Aws\EC2` - Documentation updates for Amazon EC2.
* `Aws\Organizations` - Doc only update for quota increase change
* `Aws\ConnectCases` - This release adds the ability to view audit history on a case and introduces a new parameter, performedBy, for CreateCase and UpdateCase API's.
* `Aws\finspace` - Allow customer to set zip default through command line arguments.
* `Aws\RDS` - Introduced support for the InsufficientDBInstanceCapacityFault error in the RDS CreateDBCluster API method. This provides enhanced error handling, ensuring a more robust experience when creating database clusters with insufficient instance capacity.
* `Aws\AppConfigData` - Fix FIPS Endpoints in aws-us-gov.
* `Aws\Cloud9` - Doc-only update around removing AL1 from list of available AMIs for Cloud9
* `Aws\ECS` - This release adds support for Transport Layer Security (TLS) and Configurable Timeout to ECS Service Connect. TLS facilitates privacy and data security for inter-service communications, while Configurable Timeout allows customized per-request timeout and idle timeout for Service Connect services.

## 3.296.6 - 2024-01-19

* `Aws\Athena` - Introducing new NotebookS3LocationUri parameter to Athena ImportNotebook API. Payload is no longer required and either Payload or NotebookS3LocationUri needs to be provided (not both) for a successful ImportNotebook API call. If both are provided, an InvalidRequestException will be thrown.
* `Aws\DynamoDB` - This release adds support for including ApproximateCreationDateTimePrecision configurations in EnableKinesisStreamingDestination API, adds the same as an optional field in the response of DescribeKinesisStreamingDestination, and adds support for a new UpdateKinesisStreamingDestination API.
* `Aws\QConnect` - Increased Quick Response name max length to 100
* `Aws\CodeBuild` - Release CodeBuild Reserved Capacity feature

## 3.296.5 - 2024-01-18

* `Aws\CloudTrail` - This release adds a new API ListInsightsMetricData to retrieve metric data from CloudTrail Insights.
* `Aws\Connect` - GetMetricDataV2 now supports 3 groupings
* `Aws\SageMakerFeatureStoreRuntime` - Increase BatchGetRecord limits from 10 items to 100 items
* `Aws\drs` - Removed invalid and unnecessary default values.
* `Aws\Firehose` - Allow support for Snowflake as a Kinesis Data Firehose delivery destination.
* `Aws\B2bi` - Increasing TestMapping inputFileContent file size limit to 5MB and adding file size limit 250KB for TestParsing input file. This release also includes exposing InternalServerException for Tag APIs.

## 3.296.4 - 2024-01-17

* `Aws\DynamoDB` - Updating note for enabling streams for UpdateTable.
* `Aws\Keyspaces` - This release adds support for Multi-Region Replication with provisioned tables, and Keyspaces auto scaling APIs

## 3.296.3 - 2024-01-17

* `Aws\DynamoDB` - Updating note for enabling streams for UpdateTable.
* `Aws\Keyspaces` - This release adds support for Multi-Region Replication with provisioned tables, and Keyspaces auto scaling APIs

## 3.296.2 - 2024-01-16

* `Aws\Rekognition` - This release adds ContentType and TaxonomyLevel attributes to DetectModerationLabels and GetMediaAnalysisJob API responses.
* `Aws\IoTFleetWise` - Updated APIs: SignalNodeType query parameter has been added to ListSignalCatalogNodesRequest and ListVehiclesResponse has been extended with attributes field.
* `Aws\SecurityHub` - Documentation updates for AWS Security Hub
* `Aws\PaymentCryptography` - Provide an additional option for key exchange using RSA wrap/unwrap in addition to tr-34/tr-31 in ImportKey and ExportKey operations. Added new key usage (type) TR31_M1_ISO_9797_1_MAC_KEY, for use with Generate/VerifyMac dataplane operations with ISO9797 Algorithm 1 MAC calculations.
* `Aws\Macie2` - This release adds support for analyzing Amazon S3 objects that are encrypted using dual-layer server-side encryption with AWS KMS keys (DSSE-KMS). It also adds support for reporting DSSE-KMS details in statistics and metadata about encryption settings for S3 buckets and objects.
* `Aws\IoT` - Revert release of LogTargetTypes
* `Aws\PersonalizeRuntime` - Documentation updates for Amazon Personalize
* `Aws\Personalize` - Documentation updates for Amazon Personalize.

## 3.296.1 - 2024-01-14

* `Aws\SageMaker` - This release will have ValidationException thrown if certain invalid app types are provided. The release will also throw ValidationException if more than 10 account ids are provided in VpcOnlyTrustedAccounts.

## 3.296.0 - 2024-01-12

* `Aws\ConnectParticipant` - Introduce new Supervisor participant role
* `Aws\S3Control` - S3 On Outposts team adds dualstack endpoints support for S3Control and S3Outposts API calls.
* `Aws\LocationService` - Location SDK documentation update. Added missing fonts to the MapConfiguration data type. Updated note for the SubMunicipality property in the place data type.
* `Aws\Transfer` - AWS Transfer Family now supports static IP addresses for SFTP & AS2 connectors and for async MDNs on AS2 servers.
* `Aws\Connect` - Supervisor Barge for Chat is now supported through the MonitorContact API.
* `Aws\MWAA` - This Amazon MWAA feature release includes new fields in CreateWebLoginToken response model. The new fields IamIdentity and AirflowIdentity will let you match identifications, as the Airflow identity length is currently hashed to 64 characters.
* `Aws\SupplyChain` - This release includes APIs CreateBillOfMaterialsImportJob and GetBillOfMaterialsImportJob.

## 3.295.10 - 2024-01-11

* `Aws\CloudFront` - Throw exception when an empty signature for signed url is generated.
* `Aws\SecretsManager` - Doc only update for Secrets Manager
* `Aws\EC2` - This release adds support for adding an ElasticBlockStorage volume configurations in ECS RunTask/StartTask/CreateService/UpdateService APIs. The configuration allows for attaching EBS volumes to ECS Tasks.
* `Aws\WorkSpaces` - Added AWS Workspaces RebootWorkspaces API - Extended Reboot documentation update
* `Aws\ECS` - This release adds support for adding an ElasticBlockStorage volume configurations in ECS RunTask/StartTask/CreateService/UpdateService APIs. The configuration allows for attaching EBS volumes to ECS Tasks.
* `Aws\EventBridge` - Adding AppSync as an EventBridge Target
* `Aws\IoTFleetWise` - The following dataTypes have been removed: CUSTOMER_DECODED_INTERFACE in NetworkInterfaceType; CUSTOMER_DECODED_SIGNAL_INFO_IS_NULL in SignalDecoderFailureReason; CUSTOMER_DECODED_SIGNAL_NETWORK_INTERFACE_INFO_IS_NULL in NetworkInterfaceFailureReason; CUSTOMER_DECODED_SIGNAL in SignalDecoderType
* `Aws\IoT` - Add ConflictException to Update APIs of AWS IoT Software Package Catalog

## 3.295.9 - 2024-01-10

* `Aws\QConnect` - QueryAssistant and GetRecommendations will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
* `Aws\ConnectCampaignService` - Minor pattern updates for Campaign and Dial Request API fields.
* `Aws\CloudWatchLogs` - Add support for account level subscription filter policies to PutAccountPolicy, DescribeAccountPolicies, and DeleteAccountPolicy APIs. Additionally, PutAccountPolicy has been modified with new optional "selectionCriteria" parameter for resource selection.
* `Aws\Route53` - Route53 now supports geoproximity routing in AWS regions
* `Aws\ConnectWisdomService` - QueryAssistant and GetRecommendations will be discontinued starting June 1, 2024. To receive generative responses after March 1, 2024 you will need to create a new Assistant in the Connect console and integrate the Amazon Q in Connect JavaScript library (amazon-q-connectjs) into your applications.
* `Aws\LocationService` - This release adds API support for custom layers for the maps service APIs: CreateMap, UpdateMap, DescribeMap.
* `Aws\RedshiftServerless` - Updates to ConfigParameter for RSS workgroup, removal of use_fips_ssl

## 3.295.8 - 2024-01-08

* `Aws\EC2` - Amazon EC2 R7iz bare metal instances are powered by custom 4th generation Intel Xeon Scalable processors.
* `Aws\Route53Resolver` - This release adds support for query type configuration on firewall rules that enables customers for granular action (ALLOW, ALERT, BLOCK) by DNS query type.
* `Aws\CodeBuild` - Aws CodeBuild now supports new compute type BUILD_GENERAL1_XLARGE

## 3.295.7 - 2024-01-05

* `Aws\Connect` - Minor trait updates for User APIs
* `Aws\RedshiftServerless` - use_fips_ssl and require_ssl parameter support for Workgroup, UpdateWorkgroup, and CreateWorkgroup
* `Aws\QConnect` - Marked SearchQuickResponses API as readonly.
* `Aws\KMS` - Documentation updates for AWS Key Management Service (KMS).

## 3.295.6 - 2024-01-04

* `Aws\DocDB` - Adding PerformanceInsightsEnabled and PerformanceInsightsKMSKeyId fields to DescribeDBInstances Response.
* `Aws\SageMaker` - Adding support for provisioned throughput mode for SageMaker Feature Groups
* `Aws\ECS` - This release adds support for managed instance draining which facilitates graceful termination of Amazon ECS instances.
* `Aws\ElasticsearchService` - This release adds support for new or existing Amazon OpenSearch domains to enable TLS 1.3 or TLS 1.2 with perfect forward secrecy cipher suites for domain endpoints.
* `Aws\ServiceCatalog` - Added Idempotency token support to Service Catalog AssociateServiceActionWithProvisioningArtifact, DisassociateServiceActionFromProvisioningArtifact, DeleteServiceAction API
* `Aws\ConfigService` - Updated ResourceType enum with new resource types onboarded by AWS Config in November and December 2023.
* `Aws\Lightsail` - This release adds support to set up an HTTPS endpoint on an instance.
* `Aws\OpenSearchService` - This release adds support for new or existing Amazon OpenSearch domains to enable TLS 1.3 or TLS 1.2 with perfect forward secrecy cipher suites for domain endpoints.

## 3.295.5 - 2024-01-03

* `Aws\Connect` - Amazon Connect, Contact Lens Evaluation API increase evaluation notes max length to 3072.
* `Aws\MediaConvert` - This release includes video engine updates including HEVC improvements, support for ingesting VP9 encoded video in MP4 containers, and support for user-specified 3D LUTs.

## 3.295.4 - 2023-12-29

* `Aws\LocationService` - This release introduces a new parameter to bypasses an API key's expiry conditions and delete the key.
* `Aws\QuickSight` - Add LinkEntityArn support for different partitions; Add UnsupportedUserEditionException in UpdateDashboardLinks API; Add support for New Reader Experience Topics
* `Aws\AppRunner` - AWS App Runner adds Python 3.11 and Node.js 18 runtimes.

## 3.295.3 - 2023-12-28

* `Aws\KinesisVideoArchivedMedia` - NoDataRetentionException thrown when GetImages requested for a Stream that does not retain data (that is, has a DataRetentionInHours of 0).
* `Aws\SageMaker` - Amazon SageMaker Studio now supports Docker access from within app container
* `Aws\CodeStarconnections` - New integration with the GitLab self-managed provider type.

## 3.295.2 - 2023-12-27

* `Aws\EMR` - Add support for customers to modify cluster attribute auto-terminate post cluster launch

## 3.295.1 - 2023-12-26

* `Aws\IAM` - Documentation updates for AWS Identity and Access Management (IAM).

## 3.295.0 - 2023-12-22

* `Aws\Omics` - Provides minor corrections and an updated description of APIs.
* `Aws\SecretsManager` - Update endpoint rules and examples.
* `Aws\LakeFormation` - This release adds additional configurations on GetTemporaryGlueTableCredentials for Query Session Context.
* `Aws\S3` - Added additional examples for some operations.
* `Aws\Glue` - This release adds additional configurations for Query Session Context on the following APIs: GetUnfilteredTableMetadata, GetUnfilteredPartitionMetadata, GetUnfilteredPartitionsMetadata.
* `Aws\BedrockAgent` - Adding Claude 2.1 support to Bedrock Agents
* `Aws\NetworkMonitor` - CloudWatch Network Monitor is a new service within CloudWatch that will help network administrators and operators continuously monitor network performance metrics such as round-trip-time and packet loss between their AWS-hosted applications and their on-premises locations.
* `Aws\MediaConnect` - This release adds the DescribeSourceMetadata API. This API can be used to view the stream information of the flow's source.

## 3.294.5 - 2023-12-21

* `Aws\NeptuneGraph` - Adds Waiters for successful creation and deletion of Graph, Graph Snapshot, Import Task and Private Endpoints for Neptune Analytics
* `Aws\PrometheusService` - This release updates Amazon Managed Service for Prometheus APIs to support customer managed KMS keys.
* `Aws\RDS` - This release adds support for using RDS Data API with Aurora PostgreSQL Serverless v2 and provisioned DB clusters.
* `Aws\CodeCommit` - AWS CodeCommit now supports customer managed keys from AWS Key Management Service. UpdateRepositoryEncryptionKey is added for updating the key configuration. CreateRepository, GetRepository, BatchGetRepositories are updated with new input or output parameters.
* `Aws\RDSDataService` - This release adds support for using RDS Data API with Aurora PostgreSQL Serverless v2 and provisioned DB clusters.
* `Aws\MediaLive` - MediaLive now supports the ability to configure the audio that an AWS Elemental Link UHD device produces, when the device is configured as the source for a flow in AWS Elemental MediaConnect.
* `Aws\SageMaker` - Amazon SageMaker Training now provides model training container access for debugging purposes. Amazon SageMaker Search now provides the ability to use visibility conditions to limit resource access to a single domain or multiple domains.
* `Aws\BedrockAgent` - This release introduces Amazon Aurora as a vector store on Knowledge Bases for Amazon Bedrock
* `Aws\AppIntegrationsService` - The Amazon AppIntegrations service adds DeleteApplication API for deleting applications, and updates APIs to support third party applications reacting to workspace events and make data requests to Amazon Connect for agent and contact events.
* `Aws\Connect` - Adds APIs to manage User Proficiencies and Predefined Attributes. Enhances StartOutboundVoiceContact API input. Introduces SearchContacts API. Enhances DescribeContact API. Adds an API to update Routing Attributes in QueuePriority and QueueTimeAdjustmentSeconds.

## 3.294.4 - 2023-12-20

* `Aws\EKS` - Add support for cluster insights, new EKS capability that surfaces potentially upgrade impacting issues.
* `Aws\AppStream` - This release introduces configurable clipboard, allowing admins to specify the maximum length of text that can be copied by the users from their device to the remote session and vice-versa.
* `Aws\GuardDuty` - This release 1) introduces a new API: GetOrganizationStatistics , and 2) adds a new UsageStatisticType TOP_ACCOUNTS_BY_FEATURE for GetUsageStatistics API
* `Aws\Route53` - Amazon Route 53 now supports the Canada West (Calgary) Region (ca-west-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `Aws\MediaTailor` - Adds the ability to configure time shifting on MediaTailor channels using the TimeShiftConfiguration field
* `Aws\ManagedBlockchainQuery` - Adding Confirmation Status and Execution Status to GetTransaction Response.

## 3.294.3 - 2023-12-19

* `Aws\ChimeSDKMeetings` - Add meeting features to specify a maximum camera resolution, a maximum content sharing resolution, and a maximum number of attendees for a given meeting.
* `Aws\FSx` - Added support for FSx for OpenZFS on-demand data replication across AWS accounts and/or regions.Added the IncludeShared attribute for DescribeSnapshots.Added the CopyStrategy attribute for OpenZFSVolumeConfiguration.
* `Aws\AppSync` - This release adds additional configurations on GraphQL APIs for limits on query depth, resolver count, and introspection
* `Aws\RDS` - RDS - The release adds two new APIs: DescribeDBRecommendations and ModifyDBRecommendation
* `Aws\EC2` - Provision BYOIPv4 address ranges and advertise them by specifying the network border groups option in Los Angeles, Phoenix and Dallas AWS Local Zones.
* `Aws\MarketplaceCatalog` - AWS Marketplace now supports a new API, BatchDescribeEntities, which returns metadata and content for multiple entities.

## 3.294.2 - 2023-12-18

* `Aws\QuickSight` - A docs-only release to add missing entities to the API reference.
* `Aws\Route53Resolver` - Add DOH protocols in resolver endpoints.
* `Aws\CognitoIdentityProvider` - Amazon Cognito now supports trigger versions that define the fields in the request sent to pre token generation Lambda triggers.
* `Aws\EKS` - Add support for EKS Cluster Access Management.

## 3.294.1 - 2023-12-15

* `Aws\Signature` - Fixes issues with CloudfrontKeyValueStore sigv4a operations.
* `Aws\KMS` - Documentation updates for AWS Key Management Service
* `Aws\ConnectCases` - Increase number of fields that can be included in CaseEventIncludedData from 50 to 200
* `Aws\Connect` - Adds relatedContactId field to StartOutboundVoiceContact API input. Introduces PauseContact API and ResumeContact API for Task contacts. Adds pause duration, number of pauses, timestamps for last paused and resumed events to DescribeContact API response. Adds new Rule type and new Rule action.
* `Aws\SageMaker` - This release 1) introduces a new API: DeleteCompilationJob , and 2) adds InfraCheckConfig for Create/Describe training job API
* `Aws\RDS` - Updates Amazon RDS documentation by adding code examples
* `Aws\Cloud9` - Updated Cloud9 API documentation for AL2023 release

## 3.294.0 - 2023-12-14

* `Aws\GameLift` - Amazon GameLift adds the ability to add and update the game properties of active game sessions.
* `Aws\BillingConductor` - Billing Conductor is releasing a new API, GetBillingGroupCostReport, which provides the ability to retrieve/view the Billing Group Cost Report broken down by attributes for a specific billing group.
* `Aws\OpenSearchService` - Updating documentation for Amazon OpenSearch Service support for new zero-ETL integration with Amazon S3.
* `Aws\QuickSight` - Update Dashboard Links support; SingleAxisOptions support; Scatterplot Query limit support.
* `Aws\ControlTower` - Documentation updates for AWS Control Tower.
* `Aws\AppStream` - This release includes support for images of Windows Server 2022 platform.
* `Aws\B2bi` - Documentation updates for AWS B2B Data Interchange
* `Aws\Connect` - This release adds support for more granular billing using tags (key:value pairs)
* `Aws\NeptuneGraph` - This is the initial SDK release for Amazon Neptune Analytics
* `Aws\Firehose` - This release, 1) adds configurable buffering hints for the Splunk destination, and 2) reduces the minimum configurable buffering interval for supported destinations
* `Aws\IoT` - This release adds the ability to self-manage certificate signing in AWS IoT Core fleet provisioning using the new certificate provider resource.
* `Aws\WorkSpaces` - Updated note to ensure customers understand running modes.

## 3.293.10 - 2023-12-13

* `Aws\` - Updates trace middleware such that it does not always expect a request.
* `Aws\drs` - Adding AgentVersion to SourceServer and RecoveryInstance structures

## 3.293.9 - 2023-12-12

* `Aws\Parser` - Fixes the event parser iterator so it handles the different scenarios stated by smithy docs.
* `Aws\imagebuilder` - This release adds the Image Workflows feature to give more flexibility and control over the image building and testing process.
* `Aws\LocationService` - This release 1) adds sub-municipality field in Places API for searching and getting places information, and 2) allows optimizing route calculation based on expected arrival time.
* `Aws\CloudWatchLogs` - This release introduces the StartLiveTail API to tail ingested logs in near real time.

## 3.293.8 - 2023-12-11

* `Aws\Neptune` - This release adds a new parameter configuration setting to the Neptune cluster related APIs that can be leveraged to switch between the underlying supported storage modes.
* `Aws\Pinpoint` - This release includes Amazon Pinpoint API documentation updates pertaining to campaign message sending rate limits.
* `Aws\SecurityHub` - Added new resource detail objects to ASFF, including resources for AwsDynamoDbTable, AwsEc2ClientVpnEndpoint, AwsMskCluster, AwsS3AccessPoint, AwsS3Bucket

## 3.293.7 - 2023-12-08

* `Aws\CloudWatch` - Adds support for the OpenTelemetry 1.0 output format in CloudWatch Metric Streams.
* `Aws\EC2` - M2 Mac instances are built on Apple M2 Mac mini computers. I4i instances are powered by 3rd generation Intel Xeon Scalable processors. C7i compute optimized, M7i general purpose and R7i memory optimized instances are powered by custom 4th Generation Intel Xeon Scalable processors.
* `Aws\finspace` - Releasing Scaling Group, Dataview, and Volume APIs

## 3.293.6 - 2023-12-07

* `Aws\EndpointV2` - Adds endpoint resolution middleware and refactors endpoint resolution logic
* `Aws\CodeDeploy` - This release adds support for two new CodeDeploy features: 1) zonal deployments for Amazon EC2 in-place deployments, 2) deployments triggered by Auto Scaling group termination lifecycle hook events.

## 3.293.5 - 2023-12-06

* `Aws\Connect` - Releasing Tagging Support for Instance Management APIS
* `Aws\PaymentCryptography` - AWS Payment Cryptography IPEK feature release
* `Aws\EC2` - Releasing the new cpuManufacturer attribute within the DescribeInstanceTypes API response which notifies our customers with information on who the Manufacturer is for the processor attached to the instance, for example: Intel.
* `Aws\Comprehend` - Documentation updates for Trust and Safety features.
* `Aws\Backup` - AWS Backup - Features: Add VaultType to the output of DescribeRecoveryPoint, ListRecoveryPointByBackupVault API and add ResourceType to the input of ListRestoreJobs API

## 3.293.4 - 2023-12-05

* `Aws\CleanRoomsML` - Updated service title from cleanroomsml to CleanRoomsML.
* `Aws\Athena` - Adding IdentityCenter enabled request for interactive query
* `Aws\CloudFormation` - Documentation update, December 2023
* `Aws\EC2` - Adds A10G, T4G, and H100 as accelerator name options and Habana as an accelerator manufacturer option for attribute based selection

## 3.293.3 - 2023-12-04

* `Aws\MediaLive` - Adds support for custom color correction on channels using 3D LUT files.
* `Aws\Braket` - This release enhances service support to create quantum tasks and hybrid jobs associated with Braket Direct Reservations.
* `Aws\AppRegistry` - Documentation-only updates for Dawn
* `Aws\BillingConductor` - This release adds the ability to specify a linked account of the billing group for the custom line item resource.
* `Aws\Cloud9` - This release adds the requirement to include the imageId parameter in the CreateEnvironmentEC2 API call.
* `Aws\CloudFormation` - Including UPDATE_* states as a success status for CreateStack waiter.
* `Aws\finspace` - Release General Purpose type clusters

## 3.293.2 - 2023-12-01

* `Aws\RecycleBin` - Added resource identifier in the output and updated error handling.
* `Aws\QConnect` - This release adds the PutFeedback API and allows providing feedback against the specified assistant for the specified target.
* `Aws\VerifiedPermissions` - Adds description field to PolicyStore API's and namespaces field to GetSchema.

## 3.293.1 - 2023-11-30

* `Aws\Glue` - Adds observation and analyzer support to the GetDataQualityResult and BatchGetDataQualityResult APIs.
* `Aws\ARCZonalShift` - This release adds a new capability, zonal autoshift. You can configure zonal autoshift so that AWS shifts traffic for a resource away from an Availability Zone, on your behalf, when AWS determines that there is an issue that could potentially affect customers in the Availability Zone.
* `Aws\SageMaker` - This release adds support for 1/ Code Editor, based on Code-OSS, Visual Studio Code Open Source, a new fully managed IDE option in SageMaker Studio 2/ JupyterLab, a new fully managed JupyterLab IDE experience in SageMaker Studio

## 3.293.0 - 2023-11-30

* `Aws\MarketplaceDeployment` - AWS Marketplace Deployment is a new service that provides essential features that facilitate the deployment of software, data, and services procured through AWS Marketplace.
* `Aws\MarketplaceAgreement` - The AWS Marketplace Agreement Service provides an API interface that helps AWS Marketplace sellers manage their agreements, including listing, filtering, and viewing details about their agreements.
* `Aws\RedshiftServerless` - This release adds the following support for Amazon Redshift Serverless: 1) cross-account cross-VPCs, 2) copying snapshots across Regions, 3) scheduling snapshot creation, and 4) restoring tables from a recovery point.
* `Aws\MarketplaceCatalog` - This release enhances the ListEntities API to support new entity type-specific strongly typed filters in the request and entity type-specific strongly typed summaries in the response.

## 3.292.0 - 2023-11-29

* `Aws\STS` - Documentation updates for AWS Security Token Service.
* `Aws\OpenSearchService` - Launching Amazon OpenSearch Service support for new zero-ETL integration with Amazon S3. Customers can now manage their direct query data sources to Amazon S3 programatically
* `Aws\CleanRoomsML` - Public Preview SDK release of AWS Clean Rooms ML APIs
* `Aws\OpenSearchServerless` - Amazon OpenSearch Serverless collections support an additional attribute called standby-replicas. This allows to specify whether a collection should have redundancy enabled.
* `Aws\ApplicationAutoScaling` - Amazon SageMaker customers can now use Application Auto Scaling to automatically scale the number of Inference Component copies across an endpoint to meet the varying demand of their workloads.
* `Aws\CleanRooms` - AWS Clean Rooms now provides differential privacy to protect against user-identification attempts and machine learning modeling to allow two parties to identify similar users in their data.
* `Aws\SageMaker` - This release adds following support 1/ Improved SDK tooling for model deployment. 2/ New Inference Component based features to lower inference costs and latency 3/ SageMaker HyperPod management. 4/ Additional parameters for FM Fine Tuning in Autopilot
* `Aws\SageMakerRuntime` - This release adds InferenceComponentName to InvokeEndpoint and InvokeEndpointWithResponseStream APIs to get inferences from the deployed InferenceComponents.

## 3.291.0 - 2023-11-28

* `Aws\S3` - This release adds support for the S3express identity provider
* `Aws\Bedrock` - This release adds support for customization types, model life cycle status and minor versions/aliases for model identifiers.
* `Aws\BedrockAgentRuntime` - This release introduces Agents for Amazon Bedrock Runtime
* `Aws\S3Control` - Adds support for S3 Express One Zone, and InvocationSchemaVersion 2.0 for S3 Batch Operations.
* `Aws\QBusiness` - Amazon Q - a generative AI powered application that your employees can use to ask questions and get answers from knowledge spread across disparate content repositories, summarize reports, write articles, take actions, and much more - all within their company's connected content repositories.
* `Aws\CustomerProfiles` - This release introduces DetectProfileObjectType API to auto generate object type mapping.
* `Aws\Connect` - Added support for following capabilities: Amazon Connect's in-app, web, and video calling. Two-way SMS integrations. Contact Lens real-time chat analytics feature. Amazon Connect Analytics Datalake capability. Capability to configure real time chat rules.
* `Aws\QConnect` - Amazon Q in Connect, an LLM-enhanced evolution of Amazon Connect Wisdom. This release adds generative AI support to Amazon Q Connect QueryAssistant and GetRecommendations APIs.
* `Aws\AccessAnalyzer` - This release adds support for external access findings for S3 directory buckets to help you easily identify cross-account access. Updated service API, documentation, and paginators.
* `Aws\BedrockRuntime` - This release adds support for minor versions/aliases for invoke model identifier.
* `Aws\BedrockAgent` - This release introduces Agents for Amazon Bedrock
* `Aws\S3` - Adds support for S3 Express One Zone.

## 3.290.1 - 2023-11-28

* `Aws\ElastiCache` - Launching Amazon ElastiCache Serverless that enables you to create a cache in under a minute without any capacity management. ElastiCache Serverless monitors the cache's memory, CPU, and network usage and scales both vertically and horizontally to support your application's requirements.

## 3.290.0 - 2023-11-27

* `Aws\Glue` - add observations support to DQ CodeGen config model + update document for connectiontypes supported by ConnectorData entities
* `Aws\FIS` - AWS FIS adds support for multi-account experiments & empty target resolution. This release also introduces the CreateTargetAccountConfiguration API that allows experiments across multiple AWS accounts, and the ListExperimentResolvedTargets API to list target details.
* `Aws\EFS` - Adding support for EFS Replication to existing file system.
* `Aws\Backup` - AWS Backup now supports restore testing, a new feature that allows customers to automate restore testing and validating their backups. Additionally, this release adds support for EBS Snapshots Archive tier.
* `Aws\TranscribeService` - This release adds support for AWS HealthScribe APIs within Amazon Transcribe
* `Aws\B2bi` - This is the initial SDK release for AWS B2B Data Interchange.
* `Aws\SecurityHub` - Adds and updates APIs to support central configuration. This feature allows the Security Hub delegated administrator to configure Security Hub for their entire AWS Org across multiple regions from a home Region. With this release, findings also include account name and application metadata.
* `Aws\AppSync` - This update enables introspection of Aurora cluster databases using the RDS Data API
* `Aws\RDS` - Updates Amazon RDS documentation for support for RDS for Db2.
* `Aws\ControlTower` - This release adds the following support: 1. The EnableControl API can configure controls that are configurable. 2. The GetEnabledControl API shows the configured parameters on an enabled control. 3. The new UpdateEnabledControl API can change parameters on an enabled control.

## 3.289.0 - 2023-11-27

* `Aws\IoTFleetWise` - AWS IoT FleetWise introduces new APIs for vision system data, such as data collected from cameras, radars, and lidars. You can now model and decode complex data types.
* `Aws\CostOptimizationHub` - This release launches Cost Optimization Hub, a new AWS Billing and Cost Management feature that helps you consolidate and prioritize cost optimization recommendations across your AWS Organizations member accounts and AWS Regions, so that you can get the most out of your AWS spend.
* `Aws\ECS` - Adds a new 'type' property to the Setting structure. Adds a new AccountSetting - guardDutyActivate for ECS.
* `Aws\TranscribeService` - This release adds support for transcriptions from audio sources in 64 new languages and introduces generative call summarization in Transcribe Call Analytics (Post call)
* `Aws\CloudTrail` - CloudTrail Lake now supports federating event data stores. giving users the ability to run queries against their event data using Amazon Athena.
* `Aws\Repostspace` - Initial release of AWS re:Post Private
* `Aws\S3` - Adding new params - Key and Prefix, to S3 API operations for supporting S3 Access Grants. Note - These updates will not change any of the existing S3 API functionality.
* `Aws\EKS` - This release adds support for EKS Pod Identity feature. EKS Pod Identity makes it easy for customers to obtain IAM permissions for the applications running in their EKS clusters.
* `Aws\SecurityHub` - Adds and updates APIs to support customizable security controls. This feature allows Security Hub customers to provide custom parameters for security controls. With this release, findings for controls that support custom parameters will include the parameters used to generate the findings.
* `Aws\S3Control` - Introduce Amazon S3 Access Grants, a new S3 access control feature that maps identities in directories such as Active Directory, or AWS Identity and Access Management (IAM) Principals, to datasets in S3.
* `Aws\ManagedBlockchain` - Add optional NetworkType property to Accessor APIs
* `Aws\ComputeOptimizer` - This release enables AWS Compute Optimizer to analyze and generate recommendations with customization and discounts preferences.
* `Aws\BCMDataExports` - Users can create, read, update, delete Exports of billing and cost management data. Users can get details of Export Executions and details of Tables for exporting. Tagging support is provided for Exports
* `Aws\WorkSpaces` - The release introduces Multi-Region Resilience one-way data replication that allows you to replicate data from your primary WorkSpace to a standby WorkSpace in another AWS Region. DescribeWorkspaces now returns the status of data replication.
* `Aws\ConfigService` - Support Periodic Recording for Configuration Recorder
* `Aws\GuardDuty` - Add support for Runtime Monitoring for ECS and ECS-EC2.
* `Aws\LexModelsV2` - This release introduces new generative AI features in AWS Lex: Assisted Slot Resolution, Descriptive Bot Building, and Sample Utterance Generation. These features leverage large language models available through Amazon Bedrock to improve the bot builder and customer experiences.
* `Aws\FreeTier` - This is the initial SDK release for the AWS Free Tier GetFreeTierUsage API
* `Aws\PrometheusService` - This release adds support for the Amazon Managed Service for Prometheus collector, a fully managed, agentless Prometheus metrics scraping capability.
* `Aws\SecretsManager` - AWS Secrets Manager has released the BatchGetSecretValue API, which allows customers to fetch up to 20 Secrets with a single request using a list of secret names or filters.
* `Aws\Redshift` - This release adds support for multi-data warehouse writes through data sharing.
* `Aws\QuickSight` - This release launches new APIs for trusted identity propagation setup and supports creating datasources using trusted identity propagation as authentication method for QuickSight accounts configured with IAM Identity Center.
* `Aws\PersonalizeEvents` - This release enables PutActions and PutActionInteractions
* `Aws\PersonalizeRuntime` - Enables metadata in recommendations and next best action recommendations
* `Aws\CodeStarconnections` - This release adds support for the CloudFormation Git sync feature. Git sync enables updating a CloudFormation stack from a template stored in a Git repository.
* `Aws\LexRuntimeV2` - This release introduces support for interpretationSource in the runtime service response.
* `Aws\EKSAuth` - This release adds support for EKS Pod Identity feature. EKS Pod Identity makes it easy for customers to obtain IAM permissions for their applications running in the EKS clusters.
* `Aws\Detective` - Added new APIs in Detective to support resource investigations
* `Aws\FSx` - Added support for FSx for ONTAP scale-out file systems and FlexGroup volumes. Added the HAPairs field and ThroughputCapacityPerHAPair for filesystem. Added AggregateConfiguration (containing Aggregates and ConstituentsPerAggregate) and SizeInBytes for volume.
* `Aws\ElasticLoadBalancingv2` - This release enables both mutual authentication (mTLS), and Automatic Target Weights (ATW) for Application Load Balancers.
* `Aws\EFS` - Adding support for EFS Archive lifecycle configuration.
* `Aws\WorkSpacesThinClient` - Initial release of Amazon WorkSpaces Thin Client
* `Aws\Personalize` - Enables metadata in recommendations, recommendations with themes, and next best action recommendations
* `Aws\LakeFormation` - This release adds four new APIs "DescribeLakeFormationIdentityCenterConfiguration", "CreateLakeFormationIdentityCenterConfiguration", "DescribeLakeFormationIdentityCenterConfiguration", and "DeleteLakeFormationIdentityCenterConfiguration", and also updates the corresponding documentation.
* `Aws\AccessAnalyzer` - IAM Access Analyzer now continuously monitors IAM roles and users in your AWS account or organization to generate findings for unused access. Additionally, IAM Access Analyzer now provides custom policy checks to validate that IAM policies adhere to your security standards ahead of deployments.
* `Aws\ControlTower` - Add APIs to create and manage a landing zone.
* `Aws\CloudWatchLogs` - Added APIs to Create, Update, Get, List and Delete LogAnomalyDetectors and List and Update Anomalies in Detector. Added LogGroupClass attribute for LogGroups to classify loggroup as Standard loggroup with all capabilities or InfrequentAccess loggroup with limited capabilities.
* `Aws\SFN` - Adds new TestState operation which accepts the definition of a single state and executes it. You can test a state without creating a state machine or updating an existing state machine.

## 3.288.1 - 2023-11-22

* `Aws\s3` - Disables transformation of request URI paths with dot segments
* `Aws\S3Control` - Amazon S3 Batch Operations now manages buckets or prefixes in a single step.
* `Aws\SageMaker` - This feature adds the end user license agreement status as a model access configuration parameter.
* `Aws\Kinesis` - This release adds support for resource based policies on streams and consumers.

## 3.288.0 - 2023-11-21

* `Aws\CloudFrontKeyValueStore` - This release adds support for CloudFront KeyValueStore, a globally managed key value datastore associated with CloudFront Functions.
* `Aws\CloudFront` - This release adds support for CloudFront KeyValueStore, a globally managed key value datastore associated with CloudFront Functions.
* `Aws\S3` - Add support for automatic date based partitioning in S3 Server Access Logs.
* `Aws\EC2` - Documentation updates for Amazon EC2.
* `Aws\IoTSiteWise` - Adds 1/ user-defined unique identifier for asset and model metadata, 2/ asset model components, and 3/ query API for asset metadata and telemetry data. Supports 4/ multi variate anomaly detection using Amazon Lookout for Equipment, 5/ warm storage tier, and 6/ buffered ingestion of time series data.
* `Aws\IoTTwinMaker` - This release adds following support. 1. New APIs for metadata bulk operations. 2. Modify the component type API to support composite component types - nesting component types within one another. 3. New list APIs for components and properties. 4. Support the larger scope digital twin modeling.
* `Aws\InspectorScan` - This release adds support for the new Amazon Inspector Scan API. The new Inspector Scan API can synchronously scan SBOMs adhering to the CycloneDX v1.5 format.

## 3.287.1 - 2023-11-20

* `Aws\Credentials` - Adds hostname resolution for the EcsCredentialProvider.
* `Aws\EC2` - This release adds support for Security group referencing over Transit gateways, enabling you to simplify Security group management and control of instance-to-instance traffic across VPCs that are connected by Transit gateway.
* `Aws\DocDB` - Amazon DocumentDB updates for new cluster storage configuration: Amazon DocumentDB I/O-Optimized.
* `Aws\CodeStarconnections` - This release updates a few CodeStar Connections related APIs.

## 3.287.0 - 2023-11-17

* `Aws\` - Removes the original Macie service, which has been deprecated.
* `Aws\Sqs` - Updates response md5 validation
* `Aws\ECR` - Documentation and operational updates for Amazon ECR, adding support for pull through cache rules for upstream registries that require authentication.
* `Aws\CodePipeline` - CodePipeline now supports overriding source revisions to achieve manual re-deploy of a past revision
* `Aws\MediaLive` - MediaLive has now added support for per-output static image overlay.
* `Aws\Connect` - This release adds WISDOM_QUICK_RESPONSES as new IntegrationType of Connect IntegrationAssociation resource and bug fixes.
* `Aws\InternetMonitor` - Adds new querying capabilities for running data queries on a monitor
* `Aws\EC2` - This release adds new features for Amazon VPC IP Address Manager (IPAM) Allowing a choice between Free and Advanced Tiers, viewing public IP address insights across regions and in Amazon Cloudwatch, use IPAM to plan your subnet IPs within a VPC and bring your own autonomous system number to IPAM.
* `Aws\EventBridge` - Introduces a new rule state ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS for matching with Get, List and Describe AWS API call events from CloudTrail.
* `Aws\OSIS` - Add support for enabling a persistent buffer when creating or updating an OpenSearch Ingestion pipeline. Add tags to Pipeline and PipelineSummary response models.
* `Aws\VerifiedPermissions` - Adding BatchIsAuthorized API which supports multiple authorization requests against a PolicyStore
* `Aws\IVS` - type & defaulting refinement to various range properties
* `Aws\SSOAdmin` - Improves support for configuring RefreshToken and TokenExchange grants on applications.
* `Aws\Cloud9` - A minor doc only update related to changing the date of an API change.
* `Aws\SSOOIDC` - Adding support for `sso-oauth:CreateTokenWithIAM`.
* `Aws\S3` - Removes all default 0 values for numbers and false values for booleans
* `Aws\RDS` - This release adds support for option groups and replica enhancements to Amazon RDS Custom.
* `Aws\DLM` - Added support for SAP HANA in Amazon Data Lifecycle Manager EBS snapshot lifecycle policies with pre and post scripts.
* `Aws\AppMesh` - Change the default value of these fields from 0 to null: MaxConnections, MaxPendingRequests, MaxRequests, HealthCheckThreshold, PortNumber, and HealthCheckPolicy -> port. Users are not expected to perceive the change, except that badRequestException is thrown when required fields missing configured.
* `Aws\KinesisVideo` - Docs only build to bring up-to-date with public docs.
* `Aws\STS` - API updates for the AWS Security Token Service
* `Aws\ivschat` - type & defaulting refinement to various range properties
* `Aws\RedshiftServerless` - Updated SDK for Amazon Redshift Serverless, which provides the ability to configure a connection with IAM Identity Center to manage user and group access to databases.
* `Aws\TrustedAdvisor` - AWS Trusted Advisor introduces new APIs to enable you to programmatically access Trusted Advisor best practice checks, recommendations, and prioritized recommendations. Trusted Advisor APIs enable you to integrate Trusted Advisor with your operational tools to automate your workloads.
* `Aws\CodeStarconnections` - This release adds support for the CloudFormation Git sync feature. Git sync enables updating a CloudFormation stack from a template stored in a Git repository.
* `Aws\ConnectWisdomService` - This release adds QuickResponse as a new Wisdom resource and Wisdom APIs for import, create, read, search, update and delete QuickResponse resources.
* `Aws\Redshift` - Updated SDK for Amazon Redshift, which you can use to configure a connection with IAM Identity Center to manage access to databases. With these, you can create a connection through a managed application. You can also change a managed application, delete it, or get information about an existing one.
* `Aws\LocationService` - Remove default value and allow nullable for request parameters having minimum value larger than zero.
* `Aws\Pipes` - TargetParameters now properly supports BatchJobParameters.ArrayProperties.Size and BatchJobParameters.RetryStrategy.Attempts being optional, and EcsTaskParameters.Overrides.EphemeralStorage.SizeInGiB now properly required when setting EphemeralStorage
* `Aws\mgn` - Removed invalid and unnecessary default values.
* `Aws\CloudFormation` - This release adds a new flag ImportExistingResources to CreateChangeSet. Specify this parameter on a CREATE- or UPDATE-type change set to import existing resources with custom names instead of recreating them.
* `Aws\EMR` - Launch support for IAM Identity Center Trusted Identity Propagation and workspace storage encryption using AWS KMS in EMR Studio
* `Aws\Athena` - Adding SerivicePreProcessing time metric

## 3.286.3 - 2023-11-16

* `Aws\SSOAdmin` - Instances bound to a single AWS account, API operations for managing instances and applications, and assignments to applications are now supported. Trusted identity propagation is also supported, with new API operations for managing trusted token issuers and application grants and scopes.
* `Aws\SSM` - This release introduces the ability to filter automation execution steps which have parent steps. In addition, runbook variable information is returned by GetAutomationExecution and parent step information is returned by the DescribeAutomationStepExecutions API.
* `Aws\FSx` - Enables customers to update their PerUnitStorageThroughput on their Lustre file systems.
* `Aws\Kafka` - Added a new API response field which determines if there is an action required from the customer regarding their cluster.
* `Aws\EC2` - Enable use of tenant-specific PublicSigningKeyUrl from device trust providers and onboard jumpcloud as a new device trust provider.
* `Aws\Glue` - Introduces new column statistics APIs to support statistics generation for tables within the Glue Data Catalog.
* `Aws\Transfer` - Introduced S3StorageOptions for servers to enable directory listing optimizations and added Type fields to logical directory mappings.
* `Aws\IVSRealTime` - This release introduces server side composition and recording for stages.
* `Aws\Lambda` - Adds support for logging configuration in Lambda Functions. Customers will have more control how their function logs are captured and to which cloud watch log group they are delivered also.
* `Aws\QuickSight` - Custom permission support for QuickSight roles; Three new datasources STARBURST, TRINO, BIGQUERY; Lenient mode changes the default behavior to allow for exporting and importing with certain UI allowed errors, Support for permissions and tags export and import.
* `Aws\PinpointSMSVoiceV2` - Amazon Pinpoint now offers additional operations as part of version 2 of the SMS and voice APIs. This release includes 26 new APIs to create and manage phone number registrations, add verified destination numbers, and request sender IDs.
* `Aws\IoT` - GA release the ability to index and search devices based on their GeoLocation data. With GeoQueries you can narrow your search to retrieve devices located in the desired geographic boundary.
* `Aws\SageMaker` - Amazon SageMaker Studio now supports Trainium instance types - trn1.2xlarge, trn1.32xlarge, trn1n.32xlarge.
* `Aws\SSMIncidents` - Introduces new APIs ListIncidentFindings and BatchGetIncidentFindings to use findings related to an incident.
* `Aws\MediaPackage` - DRM_TOP_LEVEL_COMPACT allows placing content protection elements at the MPD level and referenced at the AdaptationSet level
* `Aws\Macie2` - This release adds support for configuring Macie to assume an IAM role when retrieving sample occurrences of sensitive data reported by findings.
* `Aws\Polly` - Add new engine - long-form - dedicated for longer content, such as news articles, training materials, or marketing videos.
* `Aws\CodeCatalyst` - This release includes updates to the Dev Environment APIs to include an optional vpcConnectionName parameter that supports using Dev Environments with Amazon VPC.
* `Aws\imagebuilder` - This release adds the Image Lifecycle Management feature to automate the process of deprecating, disabling and deleting outdated images and their associated resources.
* `Aws\DLM` - This release adds support for Amazon Data Lifecycle Manager default policies for EBS snapshots and EBS-backed AMIs.

## 3.286.2 - 2023-11-15

* `Aws\Sqs` - Moves queue url middleware, which is no longer needed after the SQS migration from query to json protocol.
* `Aws\RDS` - Updates Amazon RDS documentation for support for upgrading RDS for MySQL snapshots from version 5.7 to version 8.0.
* `Aws\finspace` - Adding deprecated trait on Dataset Browser Environment APIs
* `Aws\MWAA` - This Amazon MWAA release adds support for customer-managed VPC endpoints. This lets you choose whether to create, and manage your environment's VPC endpoints, or to have Amazon MWAA create, and manage them for you.
* `Aws\AutoScaling` - This release introduces Instance Maintenance Policy, a new EC2 Auto Scaling capability that allows customers to define whether instances are launched before or after existing instances are terminated during instance replacement operations.
* `Aws\Lambda` - Add Java 21 (java21) support to AWS Lambda
* `Aws\EC2` - AWS EBS now supports Snapshot Lock, giving users the ability to lock an EBS Snapshot to prohibit deletion of the snapshot. This release introduces the LockSnapshot, UnlockSnapshot & DescribeLockedSnapshots APIs to manage lock configuration for snapshots. The release also includes the dl2q_24xlarge.
* `Aws\Redshift` - The custom domain name SDK for Amazon Redshift provisioned clusters is updated with additional required parameters for modify and delete operations. Additionally, users can provide domain names with longer top-level domains.
* `Aws\CodeCatalyst` - This release adds functionality for retrieving information about workflows and workflow runs and starting workflow runs in Amazon CodeCatalyst.
* `Aws\CloudTrail` - The Lake Repricing feature lets customers configure a BillingMode for an event data store. The BillingMode determines the cost for ingesting and storing events and the default and maximum retention period for the event data store.
* `Aws\S3Control` - Add 5 APIs to create, update, get, list, delete S3 Storage Lens group(eg. CreateStorageLensGroup), 3 APIs for tagging(TagResource,UntagResource,ListTagsForResource), and update to StorageLensConfiguration to allow metrics to be aggregated on Storage Lens groups.
* `Aws\FinSpaceData` - Adding deprecated trait to APIs in this name space.
* `Aws\SsmSap` - Update the default value of MaxResult to 50.

## 3.286.1 - 2023-11-14

* `Aws\Pipes` - Added support (via new LogConfiguration field in CreatePipe and UpdatePipe APIs) for logging to Amazon CloudWatch Logs, Amazon Simple Storage Service (Amazon S3), and Amazon Kinesis Data Firehose
* `Aws\SageMaker` - This release makes Model Registry Inference Specification fields as not required.
* `Aws\Backup` - AWS Backup - Features: Provide Job Summary for your backup activity.
* `Aws\SFN` - This release adds support to redrive executions in AWS Step Functions with a new RedriveExecution operation.
* `Aws\ResourceExplorer2` - Resource Explorer supports multi-account search. You can now use Resource Explorer to search and discover resources across AWS accounts within your organization or organizational unit.
* `Aws\Glue` - Introduces new storage optimization APIs to support automatic compaction of Apache Iceberg tables.
* `Aws\IoT` - This release introduces new attributes in API CreateSecurityProfile, UpdateSecurityProfile and DescribeSecurityProfile to support management of Metrics Export for AWS IoT Device Defender Detect.
* `Aws\signer` - Documentation updates for AWS Signer
* `Aws\Connect` - Introducing SegmentAttributes parameter for StartChatContact API
* `Aws\MediaTailor` - Removed unnecessary default values.
* `Aws\Lambda` - Add Python 3.12 (python3.12) support to AWS Lambda
* `Aws\CleanRooms` - This feature provides the ability for the collaboration creator to configure either the member who can run queries or a different member in the collaboration to be billed for query compute costs.

## 3.286.0 - 2023-11-13

* `Aws\Credentials` - This implementation allows disabling IMDSv1 fallback by using environment variables, config file, and explicit client configuration.
* `Aws\AppRegistry` - When the customer associates a resource collection to their application with this new feature, then a new application tag will be applied to all supported resources that are part of that collection. This allows customers to more easily find the application that is associated with those resources.
* `Aws\ECS` - Adds a Client Token parameter to the ECS RunTask API. The Client Token parameter allows for idempotent RunTask requests.
* `Aws\DataExchange` - Removed Required trait for DataSet.OriginDetails.ProductId.
* `Aws\DatabaseMigrationService` - Added new Db2 LUW Target endpoint with related endpoint settings. New executeTimeout endpoint setting for mysql endpoint. New ReplicationDeprovisionTime field for serverless describe-replications.
* `Aws\EC2` - Adds the new EC2 DescribeInstanceTopology API, which you can use to retrieve the network topology of your running instances on select platform types to determine their relative proximity to each other.
* `Aws\EMR` - Updated GetClusterSessionCredentials API to allow Amazon SageMaker Studio to connect to EMR on EC2 clusters to support IdentityCenter/PEZ integration.

## 3.285.4 - 2023-11-10

* `Aws\MediaConvert` - This release includes the ability to specify any input source as the primary input for corresponding follow modes, and allows users to specify fit and fill behaviors without resizing content.
* `Aws\EC2` - EC2 adds API updates to enable ENA Express at instance launch time.
* `Aws\CostandUsageReportService` - This release adds support for tagging and customers can now tag report definitions. Additionally, ReportStatus is now added to report definition to show when the last delivered time stamp and if it succeeded or not.
* `Aws\FMS` - Adds optimizeUnassociatedWebACL flag to ManagedServiceData, updates third-party firewall examples, and other minor documentation updates.
* `Aws\ControlTower` - AWS Control Tower supports tagging for enabled controls. This release introduces TagResource, UntagResource and ListTagsForResource APIs to manage tags in existing enabled controls. It updates EnabledControl API to tag resources at creation time.
* `Aws\RDS` - Updates Amazon RDS documentation for zero-ETL integrations.
* `Aws\MarketplaceEntitlementService` - Add paginators to GetEntitlements.

## 3.285.3 - 2023-11-09

* `Aws\Comprehend` - This release adds support for toxicity detection and prompt safety classification.
* `Aws\CloudWatchLogs` - Update to support new APIs for delivery of logs from AWS services.
* `Aws\EKS` - Adding EKS Anywhere subscription related operations.
* `Aws\Omics` - Support UBAM filetype for Omics Storage and make referenceArn optional
* `Aws\EC2` - AWS EBS now supports Block Public Access for EBS Snapshots. This release introduces the EnableSnapshotBlockPublicAccess, DisableSnapshotBlockPublicAccess and GetSnapshotBlockPublicAccessState APIs to manage account-level public access settings for EBS Snapshots in an AWS Region.
* `Aws\Connect` - This release adds the ability to integrate customer lambda functions with Connect attachments for scanning and updates the ListIntegrationAssociations API to support filtering on IntegrationArn.
* `Aws\CloudFormation` - Added new ConcurrencyMode feature for AWS CloudFormation StackSets for faster deployments to target accounts.
* `Aws\Lambda` - Add Custom runtime on Amazon Linux 2023 (provided.al2023) support to AWS Lambda.
* `Aws\CloudTrail` - The Insights in Lake feature lets customers enable CloudTrail Insights on a source CloudTrail Lake event data store and create a destination event data store to collect Insights events based on unusual management event activity in the source event data store.

## 3.285.2 - 2023-11-09

* `Aws\SQS` - This release enables customers to call SQS using AWS JSON-1.0 protocol and bug fix.

## 3.285.1 - 2023-11-08

* `Aws\RDS` - This Amazon RDS release adds support for patching the OS of an RDS Custom for Oracle DB instance. You can now upgrade the database or operating system using the modify-db-instance command.
* `Aws\ResilienceHub` - AWS Resilience Hub enhances Resiliency Score, providing actionable recommendations to improve application resilience. Amazon Elastic Kubernetes Service (EKS) operational recommendations have been added to help improve the resilience posture of your applications.
* `Aws\LexModelsV2` - AWS Lex now supports selective log capture in conversation logs. When you enable this option within the conversation log settings, only the utterances that trigger intents and slots specified in session attributes will be logged.
* `Aws\SQS` - This release enables customers to call SQS using AWS JSON-1.0 protocol.
* `Aws\ConnectCases` - This release adds the ability to add/view comment authors through CreateRelatedItem and SearchRelatedItems API. For more information see https://docs.aws.amazon.com/cases/latest/APIReference/Welcome.html
* `Aws\GuardDuty` - Added API support for new GuardDuty EKS Audit Log finding types.
* `Aws\Omics` - Adding Run UUID and Run Output URI: GetRun and StartRun API response has two new fields "uuid" and "runOutputUri".
* `Aws\RedshiftServerless` - Added a new parameter in the workgroup that helps you control your cost for compute resources. This feature provides a ceiling for RPUs that Amazon Redshift Serverless can scale up to. When automatic compute scaling is required, having a higher value for MaxRPU can enhance query throughput.
* `Aws\Lambda` - Add Node 20 (nodejs20.x) support to AWS Lambda.
* `Aws\DataSync` - This change allows for 0 length access keys and secret keys for object storage locations. Users can now pass in empty string credentials.
* `Aws\Connect` - This release clarifies in our public documentation that InstanceId is a requirement for SearchUsers API requests.

## 3.285.0 - 2023-11-07

* `Aws\Credentials` - In the EcsCredentialProvider, adds support for additional token auth source as well as support/validation for local link addresses
* `Aws\RDS` - This Amazon RDS release adds support for the multi-tenant configuration. In this configuration, an RDS DB instance can contain multiple tenant databases. In RDS for Oracle, a tenant database is a pluggable database (PDB).
* `Aws\DataExchange` - Updated SendDataSetNotificationRequest Comment to be maximum length 4096.
* `Aws\DLM` - Added support for pre and post scripts in Amazon Data Lifecycle Manager EBS snapshot lifecycle policies.

## 3.284.1 - 2023-11-06

* `Aws\` - Adds middleware which, for query compatible services, ensures input values are cast to their modeled type
* `Aws\MWAA` - This release adds support for Apache Airflow version 2.7.2. This version release includes support for deferrable operators and triggers.
* `Aws\CodeBuild` - AWS CodeBuild now supports AWS Lambda compute.
* `Aws\IAM` - Add partitional endpoint for iso-e.
* `Aws\Connect` - Added new API that allows Amazon Connect Outbound Campaigns to create contacts in Amazon Connect when ingesting your dial requests.
* `Aws\Route53` - Add partitional endpoints for iso-e and iso-f.
* `Aws\CostExplorer` - This release extends the GetReservationPurchaseRecommendation API to support recommendations for Amazon MemoryDB reservations.
* `Aws\DocDB` - Update the input of CreateDBInstance and ModifyDBInstance to support setting CA Certificates. Update the output of DescribeDBInstance and DescribeDBEngineVersions to show current and supported CA certificates.
* `Aws\Polly` - Amazon Polly adds new US English voices - Danielle and Gregory. Danielle and Gregory are available as Neural voices only.

## 3.284.0 - 2023-11-03

* `Aws\LaunchWizard` - AWS Launch Wizard is a service that helps reduce the time it takes to deploy applications to the cloud while providing a guided deployment experience.
* `Aws\Connect` - Amazon Connect Chat introduces Create Persistent Contact Association API, allowing customers to choose when to resume previous conversations from previous chats, eliminating the need to repeat themselves and allowing agents to provide personalized service with access to entire conversation history.
* `Aws\ConfigService` - Updated ResourceType enum with new resource types onboarded by AWS Config in October 2023.
* `Aws\IoTWireless` - Added LoRaWAN version 1.0.4 support

## 3.283.18 - 2023-11-02

* `Aws\Glue` - This release introduces Google BigQuery Source and Target in AWS Glue CodeGenConfigurationNode.
* `Aws\Connect` - GetMetricDataV2 API: Update to include new metrics PERCENT_NON_TALK_TIME, PERCENT_TALK_TIME, PERCENT_TALK_TIME_AGENT, PERCENT_TALK_TIME_CUSTOMER
* `Aws\NetworkFirewall` - This release introduces the stateless rule analyzer, which enables you to analyze your stateless rules for asymmetric routing.
* `Aws\GameLift` - Amazon GameLift adds support for shared credentials, which allows applications that are deployed on managed EC2 fleets to interact with other AWS resources.
* `Aws\QuickSight` - This release introduces Float Decimal Type as SubType in QuickSight SPICE datasets and Custom week start and Custom timezone options in Analysis and Dashboard.
* `Aws\AppRunner` - AWS App Runner now supports using dual-stack address type for the public endpoint of your incoming traffic.

## 3.283.17 - 2023-11-01

* `Aws\Redshift` - Added support for Multi-AZ deployments for Provisioned RA3 clusters that provide 99.99% SLA availability.
* `Aws\SageMaker` - Support for batch transform input in Model dashboard
* `Aws\Connect` - Adds the BatchGetFlowAssociation API which returns flow associations (flow-resource) corresponding to the list of resourceArns supplied in the request. This release also adds IsDefault, LastModifiedRegion and LastModifiedTime fields to the responses of several Describe and List APIs.
* `Aws\GlobalAccelerator` - Global Accelerator now support accelerators with cross account endpoints.
* `Aws\RDS` - This release adds support for customized networking resources to Amazon RDS Custom.

## 3.283.16 - 2023-10-31

* `Aws\EC2` - Capacity Blocks for ML are a new EC2 purchasing option for reserving GPU instances on a future date to support short duration machine learning (ML) workloads. Capacity Blocks automatically place instances close together inside Amazon EC2 UltraClusters for low-latency, high-throughput networking.
* `Aws\Neptunedata` - Minor change to not retry CancelledByUserException
* `Aws\Amplify` - Add backend field to CreateBranch and UpdateBranch requests. Add pagination support for ListApps, ListDomainAssociations, ListBranches, and ListJobs
* `Aws\ApplicationInsights` - Automate attaching managed policies
* `Aws\MainframeModernization` - Added name filter ability for ListDataSets API, added ForceUpdate for Updating environment and BatchJob submission using S3BatchJobIdentifier
* `Aws\Translate` - Added support for Brevity translation settings feature.

## 3.283.15 - 2023-10-30

* `Aws\finspace` - Introducing new API UpdateKxClusterCodeConfiguration, introducing new cache types for clusters and introducing new deployment modes for updating clusters.
* `Aws\DataExchange` - We added a new API action: SendDataSetNotification.
* `Aws\Connect` - This release adds InstanceId field for phone number APIs.
* `Aws\ResilienceHub` - Introduced the ability to filter applications by their last assessment date and time and have included metrics for the application's estimated workload Recovery Time Objective (RTO) and estimated workload Recovery Point Objective (RPO).
* `Aws\MediaPackageV2` - This feature allows customers to create a combination of manifest filtering, startover and time delay configuration that applies to all egress requests by default.
* `Aws\S3Outposts` - Updated ListOutpostsWithS3 API response to include S3OutpostArn for use with AWS RAM.
* `Aws\ConnectWisdomService` - This release added necessary API documents on creating a Wisdom knowledge base to integrate with S3.
* `Aws\RedshiftServerless` - Added support for custom domain names for Amazon Redshift Serverless workgroups. This feature enables customers to create a custom domain name and use ACM to generate fully secure connections to it.
* `Aws\DataSync` - Platform version changes to support AL1 deprecation initiative.
* `Aws\RDS` - This release launches the CreateIntegration, DeleteIntegration, and DescribeIntegrations APIs to manage zero-ETL Integrations.

## 3.283.14 - 2023-10-27

* `Aws\Pinpoint` - Updated documentation to describe the case insensitivity for EndpointIds.
* `Aws\WAFV2` - Updates the descriptions for the calls that manage web ACL associations, to provide information for customer-managed IAM policies.
* `Aws\Neptune` - Update TdeCredentialPassword type to SensitiveString
* `Aws\EMR` - Updated CreateCluster API request and DescribeCluster API responses to include EbsRootVolumeIops, and EbsRootVolumeThroughput attributes that specify the user configured root volume IOPS and throughput for Amazon EBS root device volume. This feature will be available from Amazon EMR releases 6.15.0
* `Aws\Redshift` - added support to create a dual stack cluster

## 3.283.13 - 2023-10-26

* `Aws\SsmSap` - AWS Systems Manager for SAP added support for registration and discovery of SAP ABAP applications
* `Aws\SNS` - Message Archiving and Replay is now supported in Amazon SNS for FIFO topics.
* `Aws\Redshift` - Add Redshift APIs GetResourcePolicy, DeleteResourcePolicy, PutResourcePolicy and DescribeInboundIntegrations for the new Amazon Redshift Zero-ETL integration feature, which can be used to control data ingress into Redshift namespace, and view inbound integrations.
* `Aws\OpenSearchService` - You can specify ipv4 or dualstack IPAddressType for cluster endpoints. If you specify IPAddressType as dualstack, the new endpoint will be visible under the 'EndpointV2' parameter and will support IPv4 and IPv6 requests. Whereas, the 'Endpoint' will continue to serve IPv4 requests.
* `Aws\AppStream` - This release introduces multi-session fleets, allowing customers to provision more than one user session on a single fleet instance.
* `Aws\Transfer` - No API changes from previous release. This release migrated the model to Smithy keeping all features unchanged.
* `Aws\EC2` - Launching GetSecurityGroupsForVpc API. This API gets security groups that can be associated by the AWS account making the request with network interfaces in the specified VPC.
* `Aws\SageMaker` - Amazon Sagemaker Autopilot now supports Text Generation jobs.
* `Aws\NetworkFirewall` - Network Firewall now supports inspection of outbound SSL/TLS traffic.

## 3.283.12 - 2023-10-25

* `Aws\ConnectCases` - Increase maximum length of CommentBody to 3000, and increase maximum length of StringValue to 1500
* `Aws\IAM` - Updates to GetAccessKeyLastUsed action to replace NoSuchEntity error with AccessDeniedException error.
* `Aws\GroundStation` - This release will allow KMS alias names to be used when creating Mission Profiles

## 3.283.11 - 2023-10-24

* `Aws\` - Updates aws-crt-php dependency due to breaking changes introduced by the latest MacOS platform update
* `Aws\MigrationHubStrategyRecommendations` - This release introduces multi-data-source feature in Migration Hub Strategy Recommendations. This feature now supports vCenter as a data source to fetch inventory in addition to ADS and Import from file workflow that is currently supported with MHSR collector.
* `Aws\EKS` - Added support for Cluster Subnet and Security Group mutability.
* `Aws\OpenSearchServerless` - This release includes the following new APIs: CreateLifecyclePolicy, UpdateLifecyclePolicy, BatchGetLifecyclePolicy, DeleteLifecyclePolicy, ListLifecyclePolicies and BatchGetEffectiveLifecyclePolicy to support the data lifecycle management feature.
* `Aws\CodePipeline` - Add ability to trigger pipelines from git tags, define variables at pipeline level and new pipeline type V2.
* `Aws\EC2` - This release updates the documentation for InstanceInterruptionBehavior and HibernationOptionsRequest to more accurately describe the behavior of these two parameters when using Spot hibernation.
* `Aws\IAM` - Add the partitional endpoint for IAM in iso-f.
* `Aws\MigrationHubConfig` - This release introduces DeleteHomeRegionControl API that customers can use to delete the Migration Hub Home Region configuration

## 3.283.10 - 2023-10-23

* `Aws\NetworkManager` - This release adds API support for Tunnel-less Connect (NoEncap Protocol) for AWS Cloud WAN
* `Aws\Rekognition` - Amazon Rekognition introduces StartMediaAnalysisJob, GetMediaAnalysisJob, and ListMediaAnalysisJobs operations to run a bulk analysis of images with a Detect Moderation model.
* `Aws\RedshiftServerless` - This release adds support for customers to see the patch version and workgroup version in Amazon Redshift Serverless.
* `Aws\MarketplaceCommerceAnalytics` - The StartSupportDataExport operation has been deprecated as part of the Product Support Connection deprecation. As of December 2022, Product Support Connection is no longer supported.

## 3.283.9 - 2023-10-20

* `Aws\AppConfig` - Update KmsKeyIdentifier constraints to support AWS KMS multi-Region keys.
* `Aws\ApplicationDiscoveryService` - This release introduces three new APIs: StartBatchDeleteConfigurationTask, DescribeBatchDeleteConfigurationTask, and BatchDeleteAgents.
* `Aws\AppIntegrationsService` - Updated ScheduleConfig to be an optional input to CreateDataIntegration to support event driven downloading of files from sources such as Amazon s3 using Amazon Connect AppIntegrations.
* `Aws\MedicalImaging` - Updates on documentation links
* `Aws\Connect` - This release adds support for updating phone number metadata, such as phone number description.
* `Aws\SSM` - This release introduces a new API: DeleteOpsItem. This allows deletion of an OpsItem.

## 3.283.8 - 2023-10-19

* `Aws\` - Removes the GameSparks service, which is no longer active as of 10/19/2023.
* `Aws\SecretsManager` - Documentation updates for Secrets Manager
* `Aws\OpenSearchService` - Added Cluster Administrative options for node restart, opensearch process restart and opensearch dashboard restart for Multi-AZ without standby domains
* `Aws\QuickSight` - This release adds the following: 1) Trino and Starburst Database Connectors 2) Custom total for tables and pivot tables 3) Enable restricted folders 4) Add rolling dates for time equality filters 5) Refine DataPathValue and introduce DataPathType 6) Add SeriesType to ReferenceLineDataConfiguration
* `Aws\VerifiedPermissions` - Improving Amazon Verified Permissions Create experience
* `Aws\Neptunedata` - Doc changes to add IAM action mappings for the data actions.
* `Aws\WorkSpaces` - Documentation updates for WorkSpaces
* `Aws\Omics` - This change enables customers to retrieve failure reasons with detailed status messages for their failed runs
* `Aws\ManagedBlockchainQuery` - This release adds support for Ethereum Sepolia network
* `Aws\ServiceCatalog` - Introduce support for EXTERNAL product and provisioning artifact type in CreateProduct and CreateProvisioningArtifact APIs.
* `Aws\EC2` - Amazon EC2 C7a instances, powered by 4th generation AMD EPYC processors, are ideal for high performance, compute-intensive workloads such as high performance computing. Amazon EC2 R7i instances are next-generation memory optimized and powered by custom 4th Generation Intel Xeon Scalable processors.

## 3.283.7 - 2023-10-18

* `Aws\ConnectWisdomService` - This release adds an max limit of 25 recommendation ids for NotifyRecommendationsReceived API.
* `Aws\DynamoDB` - Updating descriptions for several APIs.
* `Aws\RDS` - This release adds support for upgrading the storage file system configuration on the DB instance using a blue/green deployment or a read replica.
* `Aws\Cloud9` - Update to imageId parameter behavior and dates updated.
* `Aws\kendra` - Changes for a new feature in Amazon Kendra's Query API to Collapse/Expand query results

## 3.283.6 - 2023-10-18

* `Aws\ConnectWisdomService` - This release adds an max limit of 25 recommendation ids for NotifyRecommendationsReceived API.
* `Aws\DynamoDB` - Updating descriptions for several APIs.
* `Aws\RDS` - This release adds support for upgrading the storage file system configuration on the DB instance using a blue/green deployment or a read replica.
* `Aws\Cloud9` - Update to imageId parameter behavior and dates updated.
* `Aws\kendra` - Changes for a new feature in Amazon Kendra's Query API to Collapse/Expand query results

## 3.283.5 - 2023-10-17

* `Aws\CodePipeline` - Add retryMode ALL_ACTIONS to RetryStageExecution API that retries a failed stage starting from first action in the stage
* `Aws\GuardDuty` - Add domainWithSuffix finding field to dnsRequestAction
* `Aws\GlobalAccelerator` - Fixed error where ListCustomRoutingEndpointGroups did not have a paginator
* `Aws\ECS` - Documentation only updates to address Amazon ECS tickets.
* `Aws\Kafka` - AWS Managed Streaming for Kafka is launching MSK Replicator, a new feature that enables customers to reliably replicate data across Amazon MSK clusters in same or different AWS regions. You can now use SDK to create, list, describe, delete, update, and manage tags of MSK Replicators.
* `Aws\ApplicationDiscoveryService` - This release introduces three new APIs: StartBatchDeleteConfigurationTask, DescribeBatchDeleteConfigurationTask, and BatchDeleteAgents.
* `Aws\Route53RecoveryControlConfig` - Adds permissions for GetResourcePolicy to support returning details about AWS Resource Access Manager resource policies for shared resources.
* `Aws\Route53RecoveryCluster` - Adds Owner field to ListRoutingControls API.

## 3.283.4 - 2023-10-16

* `Aws\Script` - Adds retry mechanism to removeunusedservices script.
* `Aws\ManagedBlockchainQuery` - This release introduces two new APIs: GetAssetContract and ListAssetContracts. This release also adds support for Bitcoin Testnet.
* `Aws\XRay` - This releases enhances GetTraceSummaries API to support new TimeRangeType Service to query trace summaries by segment end time.
* `Aws\drs` - Updated exsiting API to allow AWS Elastic Disaster Recovery support of launching recovery into existing EC2 instances.
* `Aws\CloudFormation` - SDK and documentation updates for UpdateReplacePolicy
* `Aws\Transfer` - Documentation updates for AWS Transfer Family
* `Aws\OpenSearchService` - This release allows customers to list and associate optional plugin packages with compatible Amazon OpenSearch Service clusters for enhanced functionality.
* `Aws\RedshiftServerless` - Added support for managing credentials of serverless namespace admin using AWS Secrets Manager.
* `Aws\SESv2` - This release provides enhanced visibility into your SES identity verification status. This will offer you more actionable insights, enabling you to promptly address any verification-related issues.
* `Aws\Redshift` - Added support for managing credentials of provisioned cluster admin using AWS Secrets Manager.
* `Aws\MediaPackageV2` - This release allows customers to manage MediaPackage v2 resource using CloudFormation.
* `Aws\EntityResolution` - This launch expands our matching techniques to include provider-based matching to help customer match, link, and enhance records with minimal data movement. With data service providers, we have removed the need for customers to build bespoke integrations,.

## 3.283.3 - 2023-10-12

* `Aws\EC2` - This release adds Ubuntu Pro as a supported platform for On-Demand Capacity Reservations and adds support for setting an Amazon Machine Image (AMI) to disabled state. Disabling the AMI makes it private if it was previously shared, and prevents new EC2 instance launches from it.
* `Aws\TranscribeService` - This release is to enable m4a format to customers
* `Aws\ConfigService` - Add enums for resource types supported by Config
* `Aws\Glue` - Extending version control support to GitLab and Bitbucket from AWSGlue
* `Aws\CustomerProfiles` - Adds sensitive trait to various shapes in Customer Profiles Calculated Attribute API model.
* `Aws\RDS` - This release adds support for adding a dedicated log volume to open-source RDS instances.
* `Aws\Inspector2` - Add MacOs ec2 platform support
* `Aws\MachineLearning` - This release marks Password field as sensitive
* `Aws\AutoScaling` - Update the NotificationMetadata field to only allow visible ascii characters. Add paginators to DescribeInstanceRefreshes, DescribeLoadBalancers, and DescribeLoadBalancerTargetGroups
* `Aws\Lambda` - Adds support for Lambda functions to access Dual-Stack subnets over IPv6, via an opt-in flag in CreateFunction and UpdateFunctionConfiguration APIs
* `Aws\WorkSpaces` - Updated the CreateWorkspaces action documentation to clarify that the PCoIP protocol is only available for Windows bundles.
* `Aws\ElasticLoadBalancingv2` - This release enables routing policies with Availability Zone affinity for Network Load Balancers.
* `Aws\LocationService` - This release adds endpoint updates for all AWS Location resource operations.
* `Aws\Pricing` - Documentation updates for Price List
* `Aws\Textract` - This release adds 9 new APIs for adapter and adapter version management, 3 new APIs for tagging, and updates AnalyzeDocument and StartDocumentAnalysis API parameters for using adapters.
* `Aws\Rekognition` - Amazon Rekognition introduces support for Custom Moderation. This allows the enhancement of accuracy for detect moderation labels operations by creating custom adapters tuned on customer data.
* `Aws\ControlTower` - Added new EnabledControl resource details to ListEnabledControls API and added new GetEnabledControl API.
* `Aws\IVSRealTime` - Update GetParticipant to return additional metadata.
* `Aws\AuditManager` - This release introduces a new limit to the awsAccounts parameter. When you create or update an assessment, there is now a limit of 200 AWS accounts that can be specified in the assessment scope.
* `Aws\SageMaker` - Amazon SageMaker Canvas adds KendraSettings and DirectDeploySettings support for CanvasAppSettings

## 3.283.2 - 2023-10-06

* `Aws\MarketplaceCatalog` - This release adds support for Document type as an alternative for stringified JSON for StartChangeSet, DescribeChangeSet and DescribeEntity APIs
* `Aws\QuickSight` - NullOption in FilterListConfiguration; Dataset schema/table max length increased; Support total placement for pivot table visual; Lenient mode relaxes the validation to create resources with definition; Data sources can be added to folders; Redshift data sources support IAM Role-based authentication
* `Aws\Transfer` - This release updates the max character limit of PreAuthenticationLoginBanner and PostAuthenticationLoginBanner to 4096 characters
* `Aws\EC2` - Documentation updates for Elastic Compute Cloud (EC2).
* `Aws\FSx` - After performing steps to repair the Active Directory configuration of a file system, use this action to initiate the process of attempting to recover to the file system.

## 3.283.1 - 2023-10-05

* `Aws\WorkSpaces` - This release introduces Manage applications. This feature allows users to manage their WorkSpaces applications by associating or disassociating their WorkSpaces with applications. The DescribeWorkspaces API will now additionally return OperatingSystemName in its responses.
* `Aws\Route53` - Add hostedzonetype filter to ListHostedZones API.
* `Aws\StorageGateway` - Add SoftwareVersion to response of DescribeGatewayInformation.
* `Aws\RDS` - Updates Amazon RDS documentation for corrections and minor improvements.
* `Aws\SecurityHub` - Added new resource detail objects to ASFF, including resources for AwsEventsEventbus, AwsEventsEndpoint, AwsDmsEndpoint, AwsDmsReplicationTask, AwsDmsReplicationInstance, AwsRoute53HostedZone, and AwsMskCluster
* `Aws\Omics` - Add Etag Support for Omics Storage in ListReadSets and GetReadSetMetadata API

## 3.283.0 - 2023-10-04

* `Aws\DataZone` - Initial release of Amazon DataZone
* `Aws\mgn` - This release includes the following new APIs: ListConnectors, CreateConnector, UpdateConnector, DeleteConnector and UpdateSourceServer to support the source action framework feature.
* `Aws\AppConfig` - AWS AppConfig introduces KMS customer-managed key (CMK) encryption support for data saved to AppConfig's hosted configuration store.
* `Aws\SageMaker` - Adding support for AdditionalS3DataSource, a data source used for training or inference that is in addition to the input dataset or model data.
* `Aws\MediaTailor` - Updates DescribeVodSource to include a list of ad break opportunities in the response

## 3.282.2 - 2023-10-03

* `Aws\LocationService` - Amazon Location Service adds support for bounding polygon queries. Additionally, the GeofenceCount field has been added to the DescribeGeofenceCollection API response.
* `Aws\OAM` - This release adds support for sharing AWS::ApplicationInsights::Application resources.
* `Aws\Connect` - GetMetricDataV2 API: Update to include new metrics CONTACTS_RESOLVED_IN_X , AVG_HOLD_TIME_ALL_CONTACTS , AVG_RESOLUTION_TIME , ABANDONMENT_RATE , AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS with added features: Interval Period, TimeZone, Negate MetricFilters, Extended date time range.
* `Aws\WellArchitected` - AWS Well-Architected now supports Review Templates that allows you to create templates with pre-filled answers for Well-Architected and Custom Lens best practices.
* `Aws\MediaConvert` - This release adds the ability to replace video frames without modifying the audio essence.
* `Aws\SageMaker` - This release allows users to run Selective Execution in SageMaker Pipelines without SourcePipelineExecutionArn if selected steps do not have any dependent steps.

## 3.282.1 - 2023-10-02

* `Aws\CloudFront` - Repopulates endpoint ruleset file for api version 2015-07-27 which was removed in a models sync.
* `Aws\SSO` - Fix FIPS Endpoints in aws-us-gov.
* `Aws\STS` - STS API updates for assumeRole
* `Aws\BedrockRuntime` - Add model timeout exception for InvokeModelWithResponseStream API and update validator for invoke model identifier.
* `Aws\EC2` - Introducing Amazon EC2 R7iz instances with 3.9 GHz sustained all-core turbo frequency and deliver up to 20% better performance than previous generation z1d instances.
* `Aws\ManagedBlockchain` - Remove Rinkeby as option from Ethereum APIs
* `Aws\Bedrock` - Provisioned throughput feature with Amazon and third-party base models, and update validators for model identifier and taggable resource ARNs.
* `Aws\RDS` - Adds DefaultCertificateForNewLaunches field in the DescribeCertificates API response.
* `Aws\Transfer` - Documentation updates for AWS Transfer Family

## 3.282.0 - 2023-09-28

* `Aws\SageMakerFeatureStoreRuntime` - Feature Store supports read/write of records with collection type features.
* `Aws\WAFV2` - Correct and improve the documentation for the FieldToMatch option JA3 fingerprint.
* `Aws\EC2` - Adds support for Customer Managed Key encryption for Amazon Verified Access resources
* `Aws\BedrockRuntime` - Run Inference: Added support to run the inference on models. Includes set of APIs for running inference in streaming and non-streaming mode.
* `Aws\IoTFleetWise` - AWS IoT FleetWise now supports encryption through a customer managed AWS KMS key. The PutEncryptionConfiguration and GetEncryptionConfiguration APIs were added.
* `Aws\Bedrock` - Model Invocation logging added to enable or disable logs in customer account. Model listing and description support added. Provisioned Throughput feature added. Custom model support added for creating custom models. Also includes list, and delete functions for custom model.
* `Aws\Budgets` - Update DescribeBudgets and DescribeBudgetNotificationsForAccount MaxResults limit to 1000.
* `Aws\SageMaker` - Online store feature groups supports Standard and InMemory tier storage types for low latency storage for real-time data retrieval. The InMemory tier supports collection types List, Set, and Vector.

## 3.281.15 - 2023-09-27

* `Aws\Textract` - This release adds new feature - Layout to Analyze Document API which can automatically extract layout elements such as titles, paragraphs, headers, section headers, lists, page numbers, footers, table areas, key-value areas and figure areas and order the elements as a human would read.
* `Aws\CognitoIdentityProvider` - The UserPoolType Status field is no longer used.
* `Aws\Firehose` - Features : Adding support for new data ingestion source to Kinesis Firehose - AWS Managed Services Kafka.
* `Aws\IoT` - Added support for IoT Rules Engine Kafka Action Headers

## 3.281.14 - 2023-09-26

* `Aws\EC2` - The release includes AWS verified access to support FIPs compliance in North America regions
* `Aws\AppIntegrationsService` - The Amazon AppIntegrations service adds a set of APIs (in preview) to manage third party applications to be used in Amazon Connect agent workspace.
* `Aws\Pinpoint` - Update documentation for RemoveAttributes to more accurately reflect its behavior when attributes are deleted.
* `Aws\DynamoDB` - Amazon DynamoDB now supports Incremental Export as an enhancement to the existing Export Table
* `Aws\S3` - This release adds a new field COMPLETED to the ReplicationStatus Enum. You can now use this field to validate the replication status of S3 objects using the AWS SDK.
* `Aws\AppRunner` - This release allows an App Runner customer to specify a custom source directory to run the build & start command. This change allows App Runner to support monorepo based repositories
* `Aws\CodeDeploy` - CodeDeploy now supports In-place and Blue/Green EC2 deployments with multiple Classic Load Balancers and multiple Target Groups.
* `Aws\LakeFormation` - This release adds three new API support "CreateLakeFormationOptIn", "DeleteLakeFormationOptIn" and "ListLakeFormationOptIns", and also updates the corresponding documentation.
* `Aws\Connect` - This release updates a set of Amazon Connect APIs that provides the ability to integrate third party applications in the Amazon Connect agent workspace.

## 3.281.13 - 2023-09-25

* `Aws\AmplifyUIBuilder` - Support for generating code that is compatible with future versions of amplify project dependencies.
* `Aws\WAFV2` - You can now perform an exact match against the web request's JA3 fingerprint.
* `Aws\EMRServerless` - This release adds support for application-wide default job configurations.
* `Aws\ChimeSDKMediaPipelines` - Adds support for sending WebRTC audio to Amazon Kineses Video Streams.
* `Aws\FinSpaceData` - Adding sensitive trait to attributes. Change max SessionDuration from 720 to 60. Correct "ApiAccess" attribute to "apiAccess" to maintain consistency between APIs.
* `Aws\SSM` - This release updates the enum values for ResourceType in SSM DescribeInstanceInformation input and ConnectionStatus in GetConnectionStatus output.
* `Aws\QuickSight` - Added ability to tag users upon creation.

## 3.281.12 - 2023-09-22

* `Aws\Braket` - This release adds support to view the device queue depth (the number of queued quantum tasks and hybrid jobs on a device) and queue position for a quantum task and hybrid job.
* `Aws\EFS` - Documentation updates for Elastic File System
* `Aws\CloudWatchEvents` - Adds sensitive trait to various shapes in Jetstream Connections API model.
* `Aws\GuardDuty` - Add `EKS_CLUSTER_NAME` to filter and sort key.
* `Aws\MediaConvert` - This release supports the creation of of audio-only tracks in CMAF output groups.
* `Aws\EC2` - EC2 M2 Pro Mac instances are powered by Apple M2 Pro Mac Mini computers featuring 12 core CPU, 19 core GPU, 32 GiB of memory, and 16 core Apple Neural Engine and uniquely enabled by the AWS Nitro System through high-speed Thunderbolt connections.
* `Aws\DatabaseMigrationService` - new vendors for DMS CSF: MongoDB, MariaDB, DocumentDb and Redshift

## 3.281.11 - 2023-09-20

* `Aws\AppRunner` - This release adds improvements for managing App Runner auto scaling configuration resources. New APIs: UpdateDefaultAutoScalingConfiguration and ListServicesForAutoScalingConfiguration. Updated API: DeleteAutoScalingConfiguration.
* `Aws\CodeArtifact` - Add support for the Swift package format.
* `Aws\CloudWatchLogs` - Add ClientToken to QueryDefinition CFN Handler in CWL
* `Aws\KinesisVideo` - Updated DescribeMediaStorageConfiguration, StartEdgeConfigurationUpdate, ImageGenerationConfiguration$SamplingInterval, and UpdateMediaStorageConfiguration to match AWS Docs.
* `Aws\S3` - Fix an issue where the SDK can fail to unmarshall response due to NumberFormatException
* `Aws\ServiceDiscovery` - Adds a new DiscoverInstancesRevision API and also adds InstanceRevision field to the DiscoverInstances API response.
* `Aws\SSOOIDC` - Update FIPS endpoints in aws-us-gov.
* `Aws\AppConfig` - Enabling boto3 paginators for list APIs and adding documentation around ServiceQuotaExceededException errors

## 3.281.10 - 2023-09-19

* `Aws\Outposts` - This release adds the InstanceFamilies field to the ListAssets response.
* `Aws\EC2` - This release adds support for C7i, and R7a instance types.
* `Aws\SageMaker` - This release adds support for one-time model monitoring schedules that are executed immediately without delay, explicit data analysis windows for model monitoring schedules and exclude features attributes to remove features from model monitor analysis.

## 3.281.9 - 2023-09-18

* `Aws\WorkMail` - This release includes four new APIs UpdateUser, UpdateGroup, ListGroupsForEntity and DescribeEntity, along with RemoteUsers and some enhancements to existing APIs.
* `Aws\ApplicationDiscoveryService` - Add sensitive protection for customer information
* `Aws\Macie2` - This release changes the default managedDataIdentifierSelector setting for new classification jobs to RECOMMENDED. By default, new classification jobs now use the recommended set of managed data identifiers.

## 3.281.8 - 2023-09-15

* `Aws\SageMaker` - This release introduces Skip Model Validation for Model Packages
* `Aws\Connect` - New rule type (OnMetricDataUpdate) has been added
* `Aws\AppStream` - This release introduces app block builder, allowing customers to provision a resource to package applications into an app block
* `Aws\DataSync` - Documentation-only updates for AWS DataSync.

## 3.281.7 - 2023-09-14

* `Aws\AppStream` - This release introduces multi-session fleets, allowing customers to provision more than one user session on a single fleet instance.
* `Aws\CloudFormation` - Documentation updates for AWS CloudFormation
* `Aws\EntityResolution` - Changed "ResolutionTechniques" and "MappedInputFields" in workflow and schema mapping operations to be required fields.
* `Aws\LookoutEquipment` - This release adds APIs for the new scheduled retraining feature.

## 3.281.6 - 2023-09-13

* `Aws\Cloud9` - Update to include information on Ubuntu 18 deprecation.
* `Aws\IVSRealTime` - Doc only update that changes description for ParticipantToken.
* `Aws\drs` - Updated existing APIs and added new ones to support using AWS Elastic Disaster Recovery post-launch actions. Added support for new regions.
* `Aws\SimSpaceWeaver` - Edited the introductory text for the API reference.
* `Aws\GuardDuty` - Add `managementType` field to ListCoverage API response.
* `Aws\XRay` - Add StartTime field in GetTraceSummaries API response for each TraceSummary.
* `Aws\InternetMonitor` - This release updates the Amazon CloudWatch Internet Monitor API domain name.
* `Aws\Firehose` - DocumentIdOptions has been added for the Amazon OpenSearch destination.

## 3.281.5 - 2023-09-12

* `Aws\EventBridge` - Adds sensitive trait to various shapes in Jetstream Connections API model.
* `Aws\EC2` - This release adds support for restricting public sharing of AMIs through AMI Block Public Access
* `Aws\kendra` - Amazon Kendra now supports confidence score buckets for retrieved passage results using the Retrieve API.

## 3.281.4 - 2023-09-11

* `Aws\QuickSight` - This release launches new updates to QuickSight KPI visuals - support for sparklines, new templated layout and new targets for conditional formatting rules.
* `Aws\ECR` - This release will have ValidationException be thrown from ECR LifecyclePolicy APIs in regions LifecyclePolicy is not supported, this includes existing Amazon Dedicated Cloud (ADC) regions. This release will also change Tag: TagValue and Tag: TagKey to required.
* `Aws\MediaLive` - AWS Elemental Link now supports attaching a Link UHD device to a MediaConnect flow.

## 3.281.3 - 2023-09-08

* `Aws\SageMaker` - Autopilot APIs will now support holiday featurization for Timeseries models. The models will now hold holiday metadata and should be able to accommodate holiday effect during inference.
* `Aws\WorkSpaces` - A new field "ErrorDetails" will be added to the output of "DescribeWorkspaceImages" API call. This field provides in-depth details about the error occurred during image import process. These details include the possible causes of the errors and troubleshooting information.
* `Aws\FSx` - Amazon FSx documentation fixes
* `Aws\SSOAdmin` - Content updates to IAM Identity Center API for China Regions.

## 3.281.2 - 2023-09-07

* `Aws\SecurityHub` - Documentation updates for AWS Security Hub
* `Aws\Neptunedata` - Minor changes to send unsigned requests to Neptune clusters
* `Aws\SimSpaceWeaver` - BucketName and ObjectKey are now required for the S3Location data type. BucketName is now required for the S3Destination data type.

## 3.281.1 - 2023-09-06

* `Aws\WAFV2` - The targeted protection level of the Bot Control managed rule group now provides optional, machine-learning analysis of traffic statistics to detect some bot-related activity. You can enable or disable the machine learning functionality through the API.
* `Aws\ElasticLoadBalancingv2` - This release enables default UDP connection termination and disabling unhealthy target connection termination for Network Load Balancers.
* `Aws\MediaLive` - Adds advanced Output Locking options for Epoch Locking: Custom Epoch and Jam Sync Time
* `Aws\EC2` - This release adds 'outpost' location type to the DescribeInstanceTypeOfferings API, allowing customers that have been allowlisted for outpost to query their offerings in the API.
* `Aws\Appflow` - Adding OAuth2.0 support for servicenow connector.

## 3.281.0 - 2023-09-05

* `Aws\` - Adds support for service-specific endpoint url configuration.
* `Aws\EC2` - Introducing Amazon EC2 C7gd, M7gd, and R7gd Instances with up to 3.8 TB of local NVMe-based SSD block-level storage. These instances are powered by AWS Graviton3 processors, delivering up to 25% better performance over Graviton2-based instances.
* `Aws\ComputeOptimizer` - This release adds support to provide recommendations for G4dn and P3 instances that use NVIDIA GPUs.
* `Aws\EventBridge` - Improve Endpoint Ruleset test coverage.
* `Aws\VPCLattice` - This release adds Lambda event structure version config support for LAMBDA target groups. It also adds newline support for auth policies.
* `Aws\Cloud9` - Added support for Ubuntu 22.04 that was not picked up in a previous Trebuchet request. Doc-only update.
* `Aws\ECS` - Documentation only update for Amazon ECS.
* `Aws\BillingConductor` - This release adds support for line item filtering in for the custom line item resource.
* `Aws\SageMaker` - SageMaker Neo now supports data input shape derivation for Pytorch 2.0 and XGBoost compilation job for cloud instance targets. You can skip DataInputConfig field during compilation job creation. You can also access derived information from model in DescribeCompilationJob response.
* `Aws\RDS` - Add support for feature integration with AWS Backup.

## 3.280.2 - 2023-09-01

* `Aws\Connect` - Amazon Connect adds the ability to read, create, update, delete, and list view resources, and adds the ability to read, create, delete, and list view versions.
* `Aws\IdentityStore` - New Identity Store content for China Region launch
* `Aws\Neptunedata` - Removed the descriptive text in the introduction.
* `Aws\ChimeSDKMediaPipelines` - This release adds support for the Voice Analytics feature for customer-owned KVS streams as part of the Amazon Chime SDK call analytics.

## 3.280.1 - 2023-08-31

* `Aws\CloudHSM` - Deprecating CloudHSM Classic API Service.
* `Aws\ConnectCampaignService` - Amazon Connect outbound campaigns has launched agentless dialing mode which enables customers to make automated outbound calls without agent engagement. This release updates three of the campaign management API's to support the new agentless dialing mode and the new dialing capacity field.
* `Aws\SageMakerRuntime` - This release adds a new InvokeEndpointWithResponseStream API to support streaming of model responses.
* `Aws\ManagedGrafana` - Marking SAML RoleValues attribute as sensitive and updating VpcConfiguration attributes to match documentation.
* `Aws\ConnectParticipant` - Amazon Connect Participant Service adds the ability to get a view resource using a view token, which is provided in a participant message, with the release of the DescribeView API.
* `Aws\CustomerProfiles` - Adds sensitive trait to various shapes in Customer Profiles API model.
* `Aws\ECS` - This release adds support for an account-level setting that you can use to configure the number of days for AWS Fargate task retirement.
* `Aws\KafkaConnect` - Minor model changes for Kafka Connect as well as endpoint updates.
* `Aws\PaymentCryptographyData` - Make KeyCheckValue field optional when using asymmetric keys as Key Check Values typically only apply to symmetric keys
* `Aws\IVS` - Updated "type" description for CreateChannel, UpdateChannel, Channel, and ChannelSummary.
* `Aws\Health` - Adds new API DescribeEntityAggregatesForOrganization that retrieves entity aggregates across your organization. Also adds support for resource status filtering in DescribeAffectedEntitiesForOrganization, resource status aggregates in the DescribeEntityAggregates response, and new resource statuses.
* `Aws\CloudWatchEvents` - Documentation updates for CloudWatch Events.
* `Aws\ChimeSDKMediaPipelines` - This release adds support for feature Voice Enhancement for Call Recording as part of Amazon Chime SDK call analytics.

## 3.280.0 - 2023-08-30

* `Aws\` - Adds default region resolution, which resolves the region from `AWS_REGION` and the shared config file, respectively.
* `Aws\Appflow` - Add SAP source connector parallel and pagination feature
* `Aws\AuditManager` - This release marks some assessment metadata as sensitive. We added a sensitive trait to the following attributes: assessmentName, emailAddress, scope, createdBy, lastUpdatedBy, and userName.
* `Aws\NetworkFirewall` - Network Firewall increasing pagination token string length
* `Aws\DataSync` - AWS DataSync introduces Task Reports, a new feature that provides detailed reports of data transfer operations for each task execution.
* `Aws\AppRunner` - App Runner adds support for Bitbucket. You can now create App Runner connection that connects to your Bitbucket repositories and deploy App Runner service with the source code stored in a Bitbucket repository.
* `Aws\PcaConnectorAd` - The Connector for AD allows you to use a fully-managed AWS Private CA as a drop-in replacement for your self-managed enterprise CAs without local agents or proxy servers. Enterprises that use AD to manage Windows environments can reduce their private certificate authority (CA) costs and complexity.
* `Aws\SageMaker` - Amazon SageMaker Canvas adds IdentityProviderOAuthSettings support for CanvasAppSettings
* `Aws\CleanRooms` - This release decouples member abilities in a collaboration. With this change, the member who can run queries no longer needs to be the same as the member who can receive results.
* `Aws\Neptunedata` - Allows customers to execute data plane actions like bulk loading graphs, issuing graph queries using Gremlin and openCypher directly from the SDK.

## 3.279.9 - 2023-08-29

* `Aws\FSx` - Documentation updates for project quotas.
* `Aws\Omics` - Add RetentionMode support for Runs.
* `Aws\SESv2` - Adds support for the new Export and Message Insights features: create, get, list and cancel export jobs; get message insights.
* `Aws\CognitoIdentityProvider` - Added API example requests and responses for several operations. Fixed the validation regex for user pools Identity Provider name.

## 3.279.8 - 2023-08-28

* `Aws\Organizations` - Documentation updates for permissions and links.
* `Aws\Backup` - Add support for customizing time zone for backup window in backup plan rules.
* `Aws\WorkSpacesWeb` - WorkSpaces Web now enables Admins to configure which cookies are synchronized from an end-user's local browser to the in-session browser. In conjunction with a browser extension, this feature enables enhanced Single-Sign On capability by reducing the number of times an end-user has to authenticate.
* `Aws\ComputeOptimizer` - This release enables AWS Compute Optimizer to analyze and generate licensing optimization recommendations for sql server running on EC2 instances.
* `Aws\SecurityLake` - Remove incorrect regex enforcement on pagination tokens.
* `Aws\ServiceQuotas` - Service Quotas now supports viewing the applied quota value and requesting a quota increase for a specific resource in an AWS account.

## 3.279.7 - 2023-08-25

* `Aws\CloudWatch` - Doc-only update to get doc bug fixes into the SDK docs
* `Aws\CloudTrail` - Add ThrottlingException with error code 429 to handle CloudTrail Delegated Admin request rate exceeded on organization resources.
* `Aws\Detective` - Added protections to interacting with fields containing customer information.

## 3.279.6 - 2023-08-24

* `Aws\RDS` - This release updates the supported versions for Percona XtraBackup in Aurora MySQL.
* `Aws\MediaTailor` - Adds new source location AUTODETECT_SIGV4 access type.
* `Aws\S3` - Updates to endpoint ruleset tests to address Smithy validation issues.
* `Aws\MediaConvert` - This release includes additional audio channel tags in Quicktime outputs, support for film grain synthesis for AV1 outputs, ability to create audio-only FLAC outputs, and ability to specify Amazon S3 destination storage class.
* `Aws\Glue` - Added API attributes that help in the monitoring of sessions.
* `Aws\EC2` - Amazon EC2 M7a instances, powered by 4th generation AMD EPYC processors, deliver up to 50% higher performance compared to M6a instances. Amazon EC2 Hpc7a instances, powered by 4th Gen AMD EPYC processors, deliver up to 2.5x better performance compared to Amazon EC2 Hpc6a instances.
* `Aws\MediaLive` - MediaLive now supports passthrough of KLV data to a HLS output group with a TS container. MediaLive now supports setting an attenuation mode for AC3 audio when the coding mode is 3/2 LFE. MediaLive now supports specifying whether to include filler NAL units in RTMP output group settings.
* `Aws\S3Control` - Updates to endpoint ruleset tests to address Smithy validation issues and standardize the capitalization of DualStack.
* `Aws\QuickSight` - Excel support in Snapshot Export APIs. Removed Required trait for some insight Computations. Namespace-shared Folders support. Global Filters support. Table pin Column support.
* `Aws\VerifiedPermissions` - Documentation updates for Amazon Verified Permissions.

## 3.279.5 - 2023-08-23

* `Aws\APIGateway` - This release adds RootResourceId to GetRestApi response.
* `Aws\Polly` - Amazon Polly adds 1 new voice - Zayd (ar-AE)
* `Aws\EC2` - Marking fields as sensitive on BundleTask and GetPasswordData

## 3.279.4 - 2023-08-22

* `Aws\VerifiedPermissions` - Documentation updates for Amazon Verified Permissions. Increases max results per page for ListPolicyStores, ListPolicies, and ListPolicyTemplates APIs from 20 to 50.
* `Aws\RDS` - Adding parameters to CreateCustomDbEngineVersion reserved for future use.
* `Aws\GlobalAccelerator` - Global Accelerator now supports Client Ip Preservation for Network Load Balancer endpoints.
* `Aws\CostExplorer` - This release adds the LastUpdatedDate and LastUsedDate timestamps to help you manage your cost allocation tags.

## 3.279.3 - 2023-08-21

* `Aws\EC2` - The DeleteKeyPair API has been updated to return the keyPairId when an existing key pair is deleted.
* `Aws\finspace` - Allow customers to manage outbound traffic from their Kx Environment when attaching a transit gateway by providing network acl entries. Allow the customer to choose how they want to update the databases on a cluster allowing updates to possibly be faster than usual.
* `Aws\Route53Domains` - Fixed typos in description fields
* `Aws\RDS` - Adding support for RDS Aurora Global Database Unplanned Failover
* `Aws\Cloud9` - Doc only update to add Ubuntu 22.04 as an Image ID option for Cloud9

## 3.279.2 - 2023-08-18

* `Aws\SecurityHub` - Added Inspector Lambda code Vulnerability section to ASFF, including GeneratorDetails, EpssScore, ExploitAvailable, and CodeVulnerabilities.
* `Aws\CodeCommit` - Add new ListFileCommitHistory operation to retrieve commits which introduced changes to a specific file.

## 3.279.1 - 2023-08-17

* `Aws\EC2` - Adds support for SubnetConfigurations to allow users to select their own IPv4 and IPv6 addresses for Interface VPC endpoints
* `Aws\GameLift` - Amazon GameLift updates its instance types support.

## 3.279.0 - 2023-08-16

* `Aws\` - This version ends support for PHP versions below 7.2.5
* `Aws\CloudWatch` - Doc-only update to incorporate several doc bug fixes
* `Aws\LexModelsV2` - This release updates the Custom Vocabulary Weight field to support a value of 0.

## 3.278.3 - 2023-08-15

* `Aws\PI` - AWS Performance Insights for Amazon RDS is launching Performance Analysis On Demand, a new feature that allows you to analyze database performance metrics and find out the performance issues. You can now use SDK to create, list, get, delete, and manage tags of performance analysis reports.
* `Aws\SageMaker` - SageMaker Inference Recommender now provides SupportedResponseMIMETypes from DescribeInferenceRecommendationsJob response
* `Aws\EC2` - Documentation updates for Elastic Compute Cloud (EC2).
* `Aws\ChimeSDKMeetings` - Updated API documentation to include additional exceptions.
* `Aws\Glue` - AWS Glue Crawlers can now accept SerDe overrides from a custom csv classifier. The two SerDe options are LazySimpleSerDe and OpenCSVSerDe. In case, the user wants crawler to do the selection, "None" can be selected for this purpose.
* `Aws\Route53Domains` - Provide explanation if CheckDomainTransferability return false. Provide requestId if a request is already submitted. Add sensitive protection for customer information

## 3.278.2 - 2023-08-14

* `Aws\Omics` - This release provides support for annotation store versioning and cross account sharing for Omics Analytics
* `Aws\MediaPackage` - Fix SDK logging of certain fields.
* `Aws\Transfer` - Documentation updates for AWS Transfer Family

## 3.278.1 - 2023-08-11

* `Aws\QuickSight` - New Authentication method for Account subscription - IAM Identity Center. Hierarchy layout support, default column width support and related style properties for pivot table visuals. Non-additive topic field aggregations for Topic API
* `Aws\AmplifyBackend` - Adds sensitive trait to required input shapes.
* `Aws\EC2` - Amazon EC2 P5 instances, powered by the latest NVIDIA H100 Tensor Core GPUs, deliver the highest performance in EC2 for deep learning (DL) and HPC applications. M7i-flex and M7i instances are next-generation general purpose instances powered by custom 4th Generation Intel Xeon Scalable processors.
* `Aws\ConfigService` - Updated ResourceType enum with new resource types onboarded by AWS Config in July 2023.
* `Aws\SWF` - This release adds new API parameters to override workflow task list for workflow executions.
* `Aws\SES` - Doc only updates to include: 1) Clarified which part of an email address where it's okay to have Punycode when it contains non-ASCII characters for the SendRawEmail action and other actions where this is applicable. 2) Updated S3Action description with new MB max bucket size from 30 to 40.

## 3.278.0 - 2023-08-10

* `Aws\Multipart` - Include ChecksumAlgorithm member in Multipart Upload and Copy for flexible checksums
* `Aws\CloudTrail` - Documentation updates for CloudTrail.
* `Aws\Transfer` - Documentation updates for AW Transfer Family
* `Aws\Omics` - This release adds instanceType to GetRunTask & ListRunTasks responses.
* `Aws\SecretsManager` - Add additional InvalidRequestException to list of possible exceptions for ListSecret.
* `Aws\Connect` - This release adds APIs to provision agents that are global / available in multiple AWS regions and distribute them across these regions by percentage.
* `Aws\ElasticLoadBalancingv2` - This release enables configuring security groups for Network Load Balancers

## 3.277.12 - 2023-08-09

* `Aws\` - Updates size determination logic for request compression
* `Aws\ChimeSDKVoice` - Updating CreatePhoneNumberOrder, UpdatePhoneNumber and BatchUpdatePhoneNumbers APIs, adding phone number name
* `Aws\GlobalAccelerator` - Documentation update for dualstack EC2 endpoint support
* `Aws\GuardDuty` - Added autoEnable ALL to UpdateOrganizationConfiguration and DescribeOrganizationConfiguration APIs.
* `Aws\FSx` - For FSx for Lustre, add new data repository task type, RELEASE_DATA_FROM_FILESYSTEM, to release files that have been archived to S3. For FSx for Windows, enable support for configuring and updating SSD IOPS, and for updating storage type. For FSx for OpenZFS, add new deployment type, MULTI_AZ_1.
* `Aws\SageMaker` - This release adds support for cross account access for SageMaker Model Cards through AWS RAM.

## 3.277.11 - 2023-08-08

* `Aws\Backup` - This release introduces a new logically air-gapped vault (Preview) in AWS Backup that stores immutable backup copies, which are locked by default and isolated with encryption using AWS owned keys. Logically air-gapped vault (Preview) allows secure recovery of application data across accounts.
* `Aws\ServiceCatalog` - Introduce support for HashiCorp Terraform Cloud in Service Catalog by addying TERRAFORM_CLOUD product type in CreateProduct and CreateProvisioningArtifact API.
* `Aws\ElastiCache` - Added support for cluster mode in online migration and test migration API

## 3.277.10 - 2023-08-07

* `Aws\` - Removes validation of supplying the `version` configuration option to client constructors, defaulting to 'latest'`
* `Aws\Rekognition` - This release adds code snippets for Amazon Rekognition Custom Labels.
* `Aws\Detective` - Updated the email validation regex to be in line with the TLD name specifications.
* `Aws\KinesisVideo` - This release enables minimum of Images SamplingInterval to be as low as 200 milliseconds in Kinesis Video Stream Image feature.
* `Aws\IVSRealTime` - Add QUOTA_EXCEEDED and PUBLISHER_NOT_FOUND to EventErrorCode for stage health events.
* `Aws\KinesisVideoArchivedMedia` - This release enables minimum of Images SamplingInterval to be as low as 200 milliseconds in Kinesis Video Stream Image feature.

## 3.277.9 - 2023-08-04

* `Aws\ACMPCA` - Documentation correction for AWS Private CA
* `Aws\Connect` - Added a new API UpdateRoutingProfileAgentAvailabilityTimer to update agent availability timer of a routing profile.
* `Aws\DataSync` - Display cloud storage used capacity at a cluster level.
* `Aws\ECS` - This is a documentation update to address various tickets.
* `Aws\SageMaker` - Including DataCaptureConfig key in the Amazon Sagemaker Search's transform job object

## 3.277.8 - 2023-08-03

* `Aws\AutoScaling` - Documentation changes related to Amazon EC2 Auto Scaling APIs.
* `Aws\Cloud9` - Updated the deprecation date for Amazon Linux. Doc only update.
* `Aws\DatabaseMigrationService` - The release makes public API for DMS Schema Conversion feature.
* `Aws\EC2` - This release adds new parameter isPrimaryIPv6 to allow assigning an IPv6 address as a primary IPv6 address to a network interface which cannot be changed to give equivalent functionality available for network interfaces with primary IPv4 address.
* `Aws\SageMaker` - Amazon SageMaker now supports running training jobs on p5.48xlarge instance types.

## 3.277.7 - 2023-08-02

* `Aws\Budgets` - As part of CAE tagging integration we need to update our budget names regex filter to prevent customers from using "/action/" in their budget names.
* `Aws\CognitoIdentityProvider` - New feature that logs Cognito user pool error messages to CloudWatch logs.
* `Aws\Glue` - This release includes additional Glue Streaming KAKFA SASL property types.
* `Aws\ResilienceHub` - Drift Detection capability added when applications policy has moved from a meet to breach state. Customers will be able to exclude operational recommendations and receive credit in their resilience score. Customers can now add ARH permissions to an existing or new role.
* `Aws\SageMaker` - SageMaker Inference Recommender introduces a new API GetScalingConfigurationRecommendation to recommend auto scaling policies based on completed Inference Recommender jobs.

## 3.277.6 - 2023-08-01

* `Aws\Batch` - This release adds support for price capacity optimized allocation strategy for Spot Instances.
* `Aws\DatabaseMigrationService` - Adding new API describe-engine-versions which provides information about the lifecycle of a replication instance's version.
* `Aws\InternetMonitor` - This release adds a new feature for Amazon CloudWatch Internet Monitor that enables customers to set custom thresholds, for performance and availability drops, for impact limited to a single city-network to trigger creation of a health event.
* `Aws\MediaLive` - AWS Elemental Link devices now report their Availability Zone. Link devices now support the ability to change their Availability Zone.
* `Aws\Polly` - Amazon Polly adds new French Belgian voice - Isabelle. Isabelle is available as Neural voice only.
* `Aws\RDS` - Added support for deleted clusters PiTR.
* `Aws\SageMaker` - Add Stairs TrafficPattern and FlatInvocations to RecommendationJobStoppingConditions

## 3.277.5 - 2023-07-31

* `Aws\AmplifyUIBuilder` - Amplify Studio releases GraphQL support for codegen job action.
* `Aws\AutoScaling` - You can now configure an instance refresh to set its status to 'failed' when it detects that a specified CloudWatch alarm has gone into the ALARM state. You can also choose to roll back the instance refresh automatically when the alarm threshold is met.
* `Aws\CleanRooms` - This release introduces custom SQL queries - an expanded set of SQL you can run. This release adds analysis templates, a new resource for storing pre-defined custom SQL queries ahead of time. This release also adds the Custom analysis rule, which lets you approve analysis templates for querying.
* `Aws\CodeStarconnections` - New integration with the Gitlab provider type.
* `Aws\Inspector2` - This release adds 1 new API: BatchGetFindingDetails to retrieve enhanced vulnerability intelligence details for findings.
* `Aws\LookoutEquipment` - This release includes new import resource, model versioning and resource policy features.
* `Aws\Omics` - Add CreationType filter for ListReadSets
* `Aws\RDS` - This release adds support for Aurora MySQL local write forwarding, which allows for forwarding of write operations from reader DB instances to the writer DB instance.
* `Aws\Route53` - Amazon Route 53 now supports the Israel (Tel Aviv) Region (il-central-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `Aws\Scheduler` - This release introduces automatic deletion of schedules in EventBridge Scheduler. If configured, EventBridge Scheduler automatically deletes a schedule after the schedule has completed its last invocation.
* `Aws\drs` - Add support for in-aws right sizing

## 3.277.4 - 2023-07-28

* `Aws\` - This release adds .json.php artifacts for EntityResolution and ManagedBlockchainQuery services

## 3.277.3 - 2023-07-28

* `Aws\ApplicationInsights` - This release enable customer to add/remove/update more than one workload for a component
* `Aws\CloudFormation` - This SDK release is for the feature launch of AWS CloudFormation RetainExceptOnCreate. It adds a new parameter retainExceptOnCreate in the following APIs: CreateStack, UpdateStack, RollbackStack, ExecuteChangeSet.
* `Aws\CloudFront` - Add a new JavaScript runtime version for CloudFront Functions.
* `Aws\Connect` - This release adds support for new number types.
* `Aws\Kafka` - Amazon MSK has introduced new versions of ListClusterOperations and DescribeClusterOperation APIs. These v2 APIs provide information and insights into the ongoing operations of both MSK Provisioned and MSK Serverless clusters.
* `Aws\Pinpoint` - Added support for sending push notifications using the FCM v1 API with json credentials. Amazon Pinpoint customers can now deliver messages to Android devices using both FCM v1 API and the legacy FCM/GCM API

## 3.277.2 - 2023-07-28

* `Aws\SQS` - Documentation changes related to SQS APIs.

## 3.277.1 - 2023-07-27

* `Aws\AutoScaling` - This release updates validation for instance types used in the AllowedInstanceTypes and ExcludedInstanceTypes parameters of the InstanceRequirements property of a MixedInstancesPolicy.
* `Aws\EBS` - SDK and documentation updates for Amazon Elastic Block Store API
* `Aws\EC2` - SDK and documentation updates for Amazon Elastic Block Store APIs
* `Aws\EKS` - Add multiple customer error code to handle customer caused failure when managing EKS node groups
* `Aws\SageMaker` - Expose ProfilerConfig attribute in SageMaker Search API response.

## 3.277.0 - 2023-07-26

* `Aws\CloudControlApi` - Updates the documentation for CreateResource.
* `Aws\EntityResolution` - AWS Entity Resolution can effectively match a source record from a customer relationship management (CRM) system with a source record from a marketing system containing campaign information.
* `Aws\Glue` - Release Glue Studio Snowflake Connector Node for SDK/CLI
* `Aws\HealthLake` - Updating the HealthLake service documentation.
* `Aws\ManagedBlockchainQuery` - Amazon Managed Blockchain (AMB) Query provides serverless access to standardized, multi-blockchain datasets with developer-friendly APIs.
* `Aws\MediaConvert` - This release includes general updates to user documentation.
* `Aws\Omics` - The service is renaming as a part of AWS Health.
* `Aws\OpenSearchServerless` - This release adds new collection type VectorSearch.
* `Aws\Polly` - Amazon Polly adds 1 new voice - Lisa (nl-BE)
* `Aws\Route53` - Update that corrects the documents for received feedback.

## 3.276.5 - 2023-07-25

* `Aws\BillingConductor` - Added support for Auto-Assocate Billing Groups for CreateBillingGroup, UpdateBillingGroup, and ListBillingGroups.
* `Aws\ConnectWisdomService` - This release added two new data types: AssistantIntegrationConfiguration, and SessionIntegrationConfiguration to support Wisdom integration with Amazon Connect Chat
* `Aws\CustomerProfiles` - Amazon Connect Customer Profiles now supports rule-based resolution to match and merge similar profiles into unified profiles, helping companies deliver faster and more personalized customer service by providing access to relevant customer information for agents and automated experiences.
* `Aws\DataSync` - AWS DataSync now supports Microsoft Azure Blob Storage locations.
* `Aws\DynamoDB` - Documentation updates for DynamoDB
* `Aws\EC2` - This release adds an instance's peak and baseline network bandwidth as well as the memory sizes of an instance's inference accelerators to DescribeInstanceTypes.
* `Aws\EMRServerless` - This release adds support for publishing application logs to CloudWatch.
* `Aws\Lambda` - Add Python 3.11 (python3.11) support to AWS Lambda
* `Aws\RDS` - This release adds support for monitoring storage optimization progress on the DescribeDBInstances API.
* `Aws\STS` - API updates for the AWS Security Token Service
* `Aws\SageMaker` - Mark ContentColumn and TargetLabelColumn as required Targets in TextClassificationJobConfig in CreateAutoMLJobV2API
* `Aws\SecurityHub` - Add support for CONTAINS and NOT_CONTAINS comparison operators for Automation Rules string filters and map filters
* `Aws\Transfer` - This release adds support for SFTP Connectors.

## 3.276.4 - 2023-07-24

* `Aws\ApiGatewayV2` - Documentation updates for Amazon API Gateway.
* `Aws\ChimeSDKMediaPipelines` - AWS Media Pipeline compositing enhancement and Media Insights Pipeline auto language identification.
* `Aws\CloudFormation` - This release supports filtering by DRIFT_STATUS for existing API ListStackInstances and adds support for a new API ListStackInstanceResourceDrifts. Customers can now view resource drift information from their StackSet management accounts.
* `Aws\CostExplorer` - This release introduces the new API 'GetSavingsPlanPurchaseRecommendationDetails', which retrieves the details for a Savings Plan recommendation. It also updates the existing API 'GetSavingsPlansPurchaseRecommendation' to include the recommendation detail ID.
* `Aws\EC2` - Add "disabled" enum value to SpotInstanceState.
* `Aws\Glue` - Added support for Data Preparation Recipe node in Glue Studio jobs
* `Aws\QuickSight` - This release launches new Snapshot APIs for CSV and PDF exports, adds support for info icon for filters and parameters in Exploration APIs, adds modeled exception to the DeleteAccountCustomization API, and introduces AttributeAggregationFunction's ability to add UNIQUE_VALUE aggregation in tooltips.

## 3.276.3 - 2023-07-21

* `Aws\Glue` - This release adds support for AWS Glue Crawler with Apache Hudi Tables, allowing Crawlers to discover Hudi Tables in S3 and register them in Glue Data Catalog for query engines to query against.
* `Aws\MediaConvert` - This release includes improvements to Preserve 444 handling, compatibility of HEVC sources without frame rates, and general improvements to MP4 outputs.
* `Aws\RDS` - Adds support for the DBSystemID parameter of CreateDBInstance to RDS Custom for Oracle.
* `Aws\WorkSpaces` - Fixed VolumeEncryptionKey descriptions

## 3.276.2 - 2023-07-20

* `Aws\CodeCatalyst` - This release adds support for updating and deleting spaces and projects in Amazon CodeCatalyst. It also adds support for creating, getting, and deleting source repositories in CodeCatalyst projects.
* `Aws\ConnectCases` - This release adds the ability to assign a case to a queue or user.
* `Aws\LexModelsV2` - This release updates type for Channel field in SessionSpecification and UtteranceSpecification
* `Aws\Route53Resolver` - This release adds support for Route 53 On Outposts, a new feature that allows customers to run Route 53 Resolver and Resolver endpoints locally on their Outposts.
* `Aws\S3` - Improve performance of S3 clients by simplifying and optimizing endpoint resolution.
* `Aws\SageMaker` - Cross account support for SageMaker Feature Store
* `Aws\SageMakerFeatureStoreRuntime` - Cross account support for SageMaker Feature Store
* `Aws\SecurityLake` - Adding support for Tags on Create and Resource Tagging API.
* `Aws\TranscribeService` - Added API argument --toxicity-detection to startTranscriptionJob API, which allows users to view toxicity scores of submitted audio.

## 3.276.1 - 2023-07-20

* `Aws\SavingsPlans` - Savings Plans endpoints update

## 3.276.0 - 2023-07-19

* `Aws\CloudFormation` - SDK and documentation updates for GetTemplateSummary API (unrecognized resources)
* `Aws\EC2` - Amazon EC2 documentation updates.
* `Aws\ManagedGrafana` - Amazon Managed Grafana now supports grafanaVersion update for existing workspaces with UpdateWorkspaceConfiguration API. DescribeWorkspaceConfiguration API additionally returns grafanaVersion. A new ListVersions API lists available versions or, if given a workspaceId, the versions it can upgrade to.
* `Aws\MedicalImaging` - General Availability (GA) release of AWS Health Imaging, enabling customers to store, transform, and analyze medical imaging data at petabyte-scale.
* `Aws\RAM` - This release adds support for securely sharing with AWS service principals.
* `Aws\SsmSap` - Added support for SAP Hana High Availability discovery (primary and secondary nodes) and Backint agent installation with SSM for SAP.
* `Aws\WAFV2` - Added the URI path to the custom aggregation keys that you can specify for a rate-based rule.

## 3.275.9 - 2023-07-18

* `Aws\CodeGuruSecurity` - Documentation updates for CodeGuru Security.
* `Aws\Connect` - GetMetricDataV2 API: Update to include Contact Lens Conversational Analytics Metrics
* `Aws\ElasticsearchService` - Regex Validation on the ElasticSearch Engine Version attribute
* `Aws\LexModelsV2` - This release adds support for Lex Developers to view analytics for their bots.
* `Aws\MainframeModernization` - Allows UpdateEnvironment to update the environment to 0 host capacity. New GetSignedBluinsightsUrl API
* `Aws\Snowball` - Adds support for RACK_5U_C. This is the first AWS Snow Family device designed to meet U.S. Military Ruggedization Standards (MIL-STD-810H) with 208 vCPU device in a portable, compact 5U, half-rack width form-factor.
* `Aws\Translate` - Added DOCX word document support to TranslateDocument API

## 3.275.8 - 2023-07-17

* `Aws\CodeArtifact` - Doc only update for AWS CodeArtifact
* `Aws\DocDB` - Added major version upgrade option in ModifyDBCluster API
* `Aws\EC2` - Add Nitro TPM support on DescribeInstanceTypes
* `Aws\Glue` - Adding new supported permission type flags to get-unfiltered endpoints that callers may pass to indicate support for enforcing Lake Formation fine-grained access control on nested column attributes.
* `Aws\IVS` - This release provides the flexibility to configure what renditions or thumbnail qualities to record when creating recording configuration.
* `Aws\LakeFormation` - Adds supports for ReadOnlyAdmins and AllowFullTableExternalDataAccess. Adds NESTED_PERMISSION and NESTED_CELL_PERMISSION to SUPPORTED_PERMISSION_TYPES enum. Adds CREATE_LF_TAG on catalog resource and ALTER, DROP, and GRANT_WITH_LF_TAG_EXPRESSION on LF Tag resource.

## 3.275.7 - 2023-07-13

* `Aws\CognitoIdentityProvider` - API model updated in Amazon Cognito
* `Aws\Connect` - Add support for deleting Queues and Routing Profiles.
* `Aws\DataSync` - Added LunCount to the response object of DescribeStorageSystemResourcesResponse, LunCount represents the number of LUNs on a storage system resource.
* `Aws\DatabaseMigrationService` - Enhanced PostgreSQL target endpoint settings for providing Babelfish support.
* `Aws\EC2` - This release adds support for the C7gn and Hpc7g instances. C7gn instances are powered by AWS Graviton3 processors and the fifth-generation AWS Nitro Cards. Hpc7g instances are powered by AWS Graviton 3E processors and provide up to 200 Gbps network bandwidth.
* `Aws\FSx` - Amazon FSx for NetApp ONTAP now supports SnapLock, an ONTAP feature that enables you to protect your files in a volume by transitioning them to a write once, read many (WORM) state.
* `Aws\IAM` - Documentation updates for AWS Identity and Access Management (IAM).
* `Aws\MediaTailor` - Adds categories to MediaTailor channel assembly alerts
* `Aws\Personalize` - This release provides ability to customers to change schema associated with their datasets in Amazon Personalize
* `Aws\Proton` - This release adds support for deployment history for Proton provisioned resources
* `Aws\S3` - S3 Inventory now supports Object Access Control List and Object Owner as available object metadata fields in inventory reports.
* `Aws\SageMaker` - Amazon SageMaker Canvas adds WorkspeceSettings support for CanvasAppSettings
* `Aws\SecretsManager` - Documentation updates for Secrets Manager

## 3.275.6 - 2023-07-11

* `Aws\CognitoIdentityProvider` - API model updated in Amazon Cognito

## 3.275.5 - 2023-07-07

* `Aws\CloudWatchLogs` - Add CMK encryption support for CloudWatch Logs Insights query result data
* `Aws\DatabaseMigrationService` - Releasing DMS Serverless. Adding support for PostgreSQL 15.x as source and target endpoint. Adding support for DocDB Elastic Clusters with sharded collections, PostgreSQL datatype mapping customization and disabling hostname validation of the certificate authority in Kafka endpoint settings
* `Aws\Glue` - This release enables customers to create new Apache Iceberg tables and associated metadata in Amazon S3 by using native AWS Glue CreateTable operation.
* `Aws\MediaLive` - This release enables the use of Thumbnails in AWS Elemental MediaLive.
* `Aws\MediaTailor` - The AWS Elemental MediaTailor SDK for Channel Assembly has added support for EXT-X-CUE-OUT and EXT-X-CUE-IN tags to specify ad breaks in HLS outputs, including support for EXT-OATCLS, EXT-X-ASSET, and EXT-X-CUE-OUT-CONT accessory tags.

## 3.275.4 - 2023-07-06

* `Aws\EC2` - Add Nitro Enclaves support on DescribeInstanceTypes
* `Aws\LocationService` - This release adds support for authenticating with Amazon Location Service's Places & Routes APIs with an API Key. Also, with this release developers can publish tracked device position updates to Amazon EventBridge.
* `Aws\Outposts` - Added paginator support to several APIs. Added the ISOLATED enum value to AssetState.
* `Aws\QuickSight` - This release includes below three changes: small multiples axes improvement, field based coloring, removed required trait from Aggregation function for TopBottomFilter.
* `Aws\RDS` - Updates Amazon RDS documentation for creating DB instances and creating Aurora global clusters.

## 3.275.3 - 2023-07-05

* `Aws\ComprehendMedical` - Update to Amazon Comprehend Medical documentation.
* `Aws\Connect` - GetMetricDataV2 API: Channels filters do not count towards overall limitation of 100 filter values.
* `Aws\KMS` - Added Dry Run Feature to cryptographic and cross-account mutating KMS APIs (14 in all). This feature allows users to test their permissions and parameters before making the actual API call.
* `Aws\SecurityHub` - Documentation updates for AWS Security Hub
* `Aws\mgn` - This release introduces the Global view feature and new Replication state APIs.

## 3.275.2 - 2023-07-03

* `Aws\Batch` - This feature allows customers to use AWS Batch with Linux with ARM64 CPU Architecture and X86_64 CPU Architecture with Windows OS on Fargate Platform.
* `Aws\SageMaker` - SageMaker Inference Recommender now accepts new fields SupportedEndpointType and ServerlessConfiguration to support serverless endpoints.

## 3.275.1 - 2023-06-30

* `Aws\ECS` - Added new field "credentialspecs" to the ecs task definition to support gMSA of windows/linux in both domainless and domain-joined mode
* `Aws\IVS` - Corrects the HTTP response code in the generated docs for PutMetadata and DeleteRecordingConfiguration APIs.
* `Aws\MediaConvert` - This release includes improved color handling of overlays and general updates to user documentation.
* `Aws\PrometheusService` - AWS SDK service model generation tool version upgrade.
* `Aws\SageMaker` - This release adds support for rolling deployment in SageMaker Inference.
* `Aws\Transfer` - Add outbound Basic authentication support to AS2 connectors
* `Aws\VerifiedPermissions` - This release corrects several broken links in the documentation.

## 3.275.0 - 2023-06-29

* `Aws\` - Adds support for automatically compressing request bodies when a service supports it.
* `Aws\AppStream` - This release introduces app block builder, allowing customers to provision a resource to package applications into an app block
* `Aws\Chime` - The Amazon Chime SDK APIs in the Chime namespace are no longer supported. Customers should use APIs in the dedicated Amazon Chime SDK namespaces: ChimeSDKIdentity, ChimeSDKMediaPipelines, ChimeSDKMeetings, ChimeSDKMessaging, and ChimeSDKVoice.
* `Aws\CleanRooms` - This release adds support for the OR operator in RSQL join match conditions and the ability to control which operators (AND, OR) are allowed in a join match condition.
* `Aws\DynamoDB` - This release adds ReturnValuesOnConditionCheckFailure parameter to PutItem, UpdateItem, DeleteItem, ExecuteStatement, BatchExecuteStatement and ExecuteTransaction APIs. When set to ALL_OLD, API returns a copy of the item as it was when a conditional write failed
* `Aws\GameLift` - Amazon GameLift now supports game builds that use the Amazon Linux 2023 (AL2023) operating system.
* `Aws\Glue` - This release adds support for AWS Glue Crawler with Iceberg Tables, allowing Crawlers to discover Iceberg Tables in S3 and register them in Glue Data Catalog for query engines to query against.
* `Aws\SageMaker` - Adding support for timeseries forecasting in the CreateAutoMLJobV2 API.

## 3.274.1 - 2023-06-28

* `Aws\InternetMonitor` - This release adds a new feature for Amazon CloudWatch Internet Monitor that enables customers to set custom thresholds, for performance and availability drops, for triggering when to create a health event.
* `Aws\KinesisAnalyticsV2` - Support for new runtime environment in Kinesis Data Analytics Studio: Zeppelin-0.10, Apache Flink-1.15
* `Aws\Lambda` - Surface ResourceConflictException in DeleteEventSourceMapping
* `Aws\Omics` - Add Common Workflow Language (CWL) as a supported language for Omics workflows
* `Aws\RDS` - Amazon Relational Database Service (RDS) now supports joining a RDS for SQL Server instance to a self-managed Active Directory.
* `Aws\S3` - The S3 LISTObjects, ListObjectsV2 and ListObjectVersions API now supports a new optional header x-amz-optional-object-attributes. If header contains RestoreStatus as the value, then S3 will include Glacier restore status i.e. isRestoreInProgress and RestoreExpiryDate in List response.
* `Aws\SageMaker` - This release adds support for Model Cards Model Registry integration.

## 3.274.0 - 2023-06-27

* `Aws\AppFabric` - Initial release of AWS AppFabric for connecting SaaS applications for better productivity and security.
* `Aws\Appflow` - This release adds support to bypass SSO with the SAPOData connector when connecting to an SAP instance.
* `Aws\EMRServerless` - This release adds support to update the release label of an EMR Serverless application to upgrade it to a different version of Amazon EMR via UpdateApplication API.
* `Aws\IVS` - IVS customers can now revoke the viewer session associated with an auth token, to prevent and stop playback using that token.
* `Aws\KinesisVideo` - General Availability (GA) release of Kinesis Video Streams at Edge, enabling customers to provide a configuration for the Kinesis Video Streams EdgeAgent running on an on-premise IoT device. Customers can now locally record from cameras and stream videos to the cloud on a configured schedule.
* `Aws\Macie2` - This release adds support for configuring new classification jobs to use the set of managed data identifiers that we recommend for jobs. For the managed data identifier selection type (managedDataIdentifierSelector), specify RECOMMENDED.
* `Aws\PrivateNetworks` - This release allows Private5G customers to choose different commitment plans (60-days, 1-year, 3-years) when placing new orders, enables automatic renewal option for 1-year and 3-years commitments. It also allows customers to update the commitment plan of an existing radio unit.
* `Aws\SSM` - Systems Manager doc-only update for June 2023.
* `Aws\SageMaker` - Introducing TTL for online store records in feature groups.
* `Aws\SageMakerFeatureStoreRuntime` - Introducing TTL for online store records for feature groups.
* `Aws\VerifiedPermissions` - This update fixes several broken links to the Cedar documentation.

## 3.273.8 - 2023-06-26

* `Aws\Connect` - This release provides a way to search for existing tags within an instance. Before tagging a resource, ensure consistency by searching for pre-existing key:value pairs.
* `Aws\Glue` - Timestamp Starting Position For Kinesis and Kafka Data Sources in a Glue Streaming Job
* `Aws\GuardDuty` - Add support for user.extra.sessionName in Kubernetes Audit Logs Findings.
* `Aws\IAM` - Support for a new API "GetMFADevice" to present MFA device metadata such as device certifications
* `Aws\Pinpoint` - Added time zone estimation support for journeys

## 3.273.7 - 2023-06-23

* `Aws\DevOpsGuru` - This release adds support for encryption via customer managed keys.
* `Aws\FSx` - Update to Amazon FSx documentation.
* `Aws\RDS` - Documentation improvements for create, describe, and modify DB clusters and DB instances.
* `Aws\VerifiedPermissions` - Added improved descriptions and new code samples to SDK documentation.

## 3.273.6 - 2023-06-22

* `Aws\ChimeSDKIdentity` - AppInstanceBots can be configured to be invoked or not using the Target or the CHIME.mentions attribute for ChannelMessages
* `Aws\ChimeSDKMessaging` - ChannelMessages can be made visible to sender and intended recipient rather than all channel members with the target attribute. For example, a user can send messages to a bot and receive messages back in a group channel without other members seeing them.
* `Aws\SFN` - Adds support for Versions and Aliases. Adds 8 operations: PublishStateMachineVersion, DeleteStateMachineVersion, ListStateMachineVersions, CreateStateMachineAlias, DescribeStateMachineAlias, UpdateStateMachineAlias, DeleteStateMachineAlias, ListStateMachineAliases
* `Aws\kendra` - Introducing Amazon Kendra Retrieve API that can be used to retrieve relevant passages or text excerpts given an input query.

## 3.273.5 - 2023-06-21

* `Aws\DynamoDB` - Documentation updates for DynamoDB
* `Aws\EMR` - This release introduces a new Amazon EMR EPI called ListSupportedInstanceTypes that returns a list of all instance types supported by a given EMR release.
* `Aws\Inspector2` - This release adds support for Software Bill of Materials (SBOM) export and the general availability of code scanning for AWS Lambda functions.
* `Aws\MQ` - The Cross Region Disaster Recovery feature allows to replicate a brokers state from one region to another in order to provide customers with multi-region resiliency in the event of a regional outage.
* `Aws\MediaConvert` - This release introduces the bandwidth reduction filter for the HEVC encoder, increases the limits of outputs per job, and updates support for the Nagra SDK to version 1.14.7.
* `Aws\SageMaker` - This release provides support in SageMaker for output files in training jobs to be uploaded without compression and enable customer to deploy uncompressed model from S3 to real-time inference Endpoints. In addition, ml.trn1n.32xlarge is added to supported instance type list in training job.
* `Aws\Transfer` - This release adds a new parameter StructuredLogDestinations to CreateServer, UpdateServer APIs.

## 3.273.4 - 2023-06-20

* `Aws\Appflow` - This release adds new API to reset connector metadata cache
* `Aws\ConfigService` - Updated ResourceType enum with new resource types onboarded by AWS Config in May 2023.
* `Aws\EC2` - Adds support for targeting Dedicated Host allocations by assetIds in AWS Outposts
* `Aws\Lambda` - This release adds RecursiveInvocationException to the Invoke API and InvokeWithResponseStream API.
* `Aws\Redshift` - Added support for custom domain names for Redshift Provisioned clusters. This feature enables customers to create a custom domain name and use ACM to generate fully secure connections to it.

## 3.273.3 - 2023-06-19

* `Aws\CloudFormation` - Specify desired CloudFormation behavior in the event of ChangeSet execution failure using the CreateChangeSet OnStackFailure parameter
* `Aws\EC2` - API changes to AWS Verified Access to include data from trust providers in logs
* `Aws\ECS` - Documentation only update to address various tickets.
* `Aws\Glue` - This release adds support for creating cross region table/database resource links
* `Aws\Pricing` - This release updates the PriceListArn regex pattern.
* `Aws\Route53Domains` - Update MaxItems upper bound to 1000 for ListPricesRequest
* `Aws\SageMaker` - Amazon Sagemaker Autopilot releases CreateAutoMLJobV2 and DescribeAutoMLJobV2 for Autopilot customers with ImageClassification, TextClassification and Tabular problem type config support.

## 3.273.2 - 2023-06-16

* `Aws\Account` - Improve pagination support for ListRegions
* `Aws\ApplicationDiscoveryService` - Add Amazon EC2 instance recommendations export
* `Aws\Connect` - Updates the *InstanceStorageConfig APIs to support a new ResourceType: SCREEN_RECORDINGS to enable screen recording and specify the storage configurations for publishing the recordings. Also updates DescribeInstance and ListInstances APIs to include InstanceAccessUrl attribute in the API response.
* `Aws\IAM` - Documentation updates for AWS Identity and Access Management (IAM).
* `Aws\S3` - This release adds SDK support for request-payer request header and request-charged response header in the "GetBucketAccelerateConfiguration", "ListMultipartUploads", "ListObjects", "ListObjectsV2" and "ListObjectVersions" S3 APIs.

## 3.273.1 - 2023-06-15

* `Aws\AuditManager` - This release introduces 2 Audit Manager features: CSV exports and new manual evidence options. You can now export your evidence finder results in CSV format. In addition, you can now add manual evidence to a control by entering free-form text or uploading a file from your browser.
* `Aws\EFS` - Documentation updates for EFS.
* `Aws\GuardDuty` - Updated descriptions for some APIs.
* `Aws\LocationService` - Amazon Location Service adds categories to places, including filtering on those categories in searches. Also, you can now add metadata properties to your geofences.

## 3.273.0 - 2023-06-13

* `Aws\CloudTrail` - This feature allows users to view dashboards for CloudTrail Lake event data stores.
* `Aws\CodeGuruSecurity` - Initial release of Amazon CodeGuru Security APIs
* `Aws\EC2` - This release introduces a new feature, EC2 Instance Connect Endpoint, that enables you to connect to a resource over TCP, without requiring the resource to have a public IPv4 address.
* `Aws\Lightsail` - This release adds pagination for the Get Certificates API operation.
* `Aws\S3` - Integrate double encryption feature to SDKs.
* `Aws\SecurityHub` - Add support for Security Hub Automation Rules
* `Aws\SimSpaceWeaver` - This release fixes using aws-us-gov ARNs in API calls and adds documentation for snapshot APIs.
* `Aws\VerifiedPermissions` - GA release of Amazon Verified Permissions.
* `Aws\WAFV2` - You can now detect and block fraudulent account creation attempts with the new AWS WAF Fraud Control account creation fraud prevention (ACFP) managed rule group AWSManagedRulesACFPRuleSet.
* `Aws\WellArchitected` - AWS Well-Architected now supports Profiles that help customers prioritize which questions to focus on first by providing a list of prioritized questions that are better aligned with their business goals and outcomes.
* `Aws\drs` - Added APIs to support network replication and recovery using AWS Elastic Disaster Recovery.
* `Aws\imagebuilder` - Change the Image Builder ImagePipeline dateNextRun field to more accurately describe the data.

## 3.272.2 - 2023-06-12

* `Aws\AmplifyUIBuilder` - AWS Amplify UIBuilder is launching Codegen UI, a new feature that enables you to generate your amplify uibuilder components and forms.
* `Aws\DynamoDB` - Documentation updates for DynamoDB
* `Aws\DynamoDBStreams` - Documentation updates for DynamoDB Streams
* `Aws\FSx` - Amazon FSx for NetApp ONTAP now supports joining a storage virtual machine (SVM) to Active Directory after the SVM has been created.
* `Aws\OpenSearchService` - This release adds support for SkipUnavailable connection property for cross cluster search
* `Aws\Rekognition` - This release adds support for improved accuracy with user vector in Amazon Rekognition Face Search. Adds new APIs: AssociateFaces, CreateUser, DeleteUser, DisassociateFaces, ListUsers, SearchUsers, SearchUsersByImage. Also adds new face metadata that can be stored: user vector.
* `Aws\SageMaker` - Sagemaker Neo now supports compilation for inferentia2 (ML_INF2) and Trainium1 (ML_TRN1) as available targets. With these devices, you can run your workloads at highest performance with lowest cost. inferentia2 (ML_INF2) is available in CMH and Trainium1 (ML_TRN1) is available in IAD currently

## 3.272.1 - 2023-06-09

* `Aws\ACMPCA` - Document-only update to refresh CLI documentation for AWS Private CA. No change to the service.
* `Aws\Connect` - This release adds search APIs for Prompts, Quick Connects and Hours of Operations, which can be used to search for those resources within a Connect Instance.
* `Aws\S3` - Fixes a bug with checksum calculation of CRC32 in flexible checksums

## 3.272.0 - 2023-06-08

* `Aws\Athena` - You can now define custom spark properties at start of the session for use cases like cluster encryption, table formats, and general Spark tuning.
* `Aws\ComprehendMedical` - This release supports a new set of entities and traits.
* `Aws\PaymentCryptography` - Initial release of AWS Payment Cryptography Control Plane service for creating and managing cryptographic keys used during card payment processing.
* `Aws\PaymentCryptographyData` - Initial release of AWS Payment Cryptography DataPlane Plane service for performing cryptographic operations typically used during card payment processing.
* `Aws\ServiceCatalog` - New parameter added in ServiceCatalog DescribeProvisioningArtifact api - IncludeProvisioningArtifactParameters. This parameter can be used to return information about the parameters used to provision the product
* `Aws\TimestreamWrite` - This release adds the capability for customers to define how their data should be partitioned, optimizing for certain access patterns. This definition will take place as a part of the table creation.

## 3.271.10 - 2023-06-07

* `Aws\CloudFormation` - AWS CloudFormation StackSets is updating the deployment experience for all stackset operations to skip suspended AWS accounts during deployments. StackSets will skip target AWS accounts that are suspended and set the Detailed Status of the corresponding stack instances as SKIPPED_SUSPENDED_ACCOUNT
* `Aws\CloudWatchLogs` - This change adds support for account level data protection policies using 3 new APIs, PutAccountPolicy, DeleteAccountPolicy and DescribeAccountPolicy. DescribeLogGroup API has been modified to indicate if account level policy is applied to the LogGroup via "inheritedProperties" list in the response.
* `Aws\CustomerProfiles` - This release introduces event stream related APIs.
* `Aws\DirectConnect` - This update corrects the jumbo frames mtu values from 9100 to 8500 for transit virtual interfaces.
* `Aws\EMRContainers` - EMR on EKS adds support for log rotation of Spark container logs with EMR-6.11.0 onwards, to the StartJobRun API.
* `Aws\IoTDeviceAdvisor` - AWS IoT Core Device Advisor now supports new Qualification Suite test case list. With this update, customers can more easily create new qualification test suite with an empty rootGroup input.

## 3.271.9 - 2023-06-06

* `Aws\Connect` - GetMetricDataV2 API is now available in AWS GovCloud(US) region.
* `Aws\EMR` - This release provides customers the ability to specify an allocation strategies amongst PRICE_CAPACITY_OPTIMIZED, CAPACITY_OPTIMIZED, LOWEST_PRICE, DIVERSIFIED for Spot instances in Instance Feet cluster. This enables customers to choose an allocation strategy best suited for their workload.
* `Aws\IAM` - This release updates the AccountAlias regex pattern with the same length restrictions enforced by the length constraint.
* `Aws\Inspector2` - Adds new response properties and request parameters for 'last scanned at' on the ListCoverage operation. This feature allows you to search and view the date of which your resources were last scanned by Inspector.
* `Aws\IoT` - Adding IoT Device Management Software Package Catalog APIs to register, store, and report system software packages, along with their versions and metadata in a centralized location.
* `Aws\IoTDataPlane` - Update thing shadow name regex to allow '$' character
* `Aws\LexModelsV2` - This release adds support for Lex Developers to create test sets and to execute those test-sets against their bots.
* `Aws\QuickSight` - QuickSight support for pivot table field collapse state, radar chart range scale and multiple scope options in conditional formatting.
* `Aws\SQS` - Amazon SQS adds three new APIs - StartMessageMoveTask, CancelMessageMoveTask, and ListMessageMoveTasks to automate redriving messages from dead-letter queues to source queues or a custom destination.
* `Aws\signer` - AWS Signer is launching Container Image Signing, a new feature that enables you to sign and verify container images. This feature enables you to validate that only container images you approve are used in your enterprise.

## 3.271.8 - 2023-06-05

* `Aws\CloudFormation` - AWS CloudFormation StackSets provides customers with three new APIs to activate, deactivate, and describe AWS Organizations trusted access which is needed to get started with service-managed StackSets.
* `Aws\EC2` - Making InstanceTagAttribute as the required parameter for the DeregisterInstanceEventNotificationAttributes and RegisterInstanceEventNotificationAttributes APIs.
* `Aws\FraudDetector` - Added new variable types, new DateTime data type, and new rules engine functions for interacting and working with DateTime data types.
* `Aws\KMS` - This release includes feature to import customer's asymmetric (RSA and ECC) and HMAC keys into KMS. It also includes feature to allow customers to specify number of days to schedule a KMS key deletion as a policy condition key.
* `Aws\Keyspaces` - This release adds support for MRR GA launch, and includes multiregion support in create-keyspace, get-keyspace, and list-keyspace.
* `Aws\Lambda` - Add Ruby 3.2 (ruby3.2) Runtime support to AWS Lambda.
* `Aws\MWAA` - This release adds ROLLING_BACK and CREATING_SNAPSHOT environment statuses for Amazon MWAA environments.
* `Aws\finspace` - Releasing new Managed kdb Insights APIs

## 3.271.7 - 2023-06-02

* `Aws\Athena` - This release introduces the DeleteCapacityReservation API and the ability to manage capacity reservations using CloudFormation
* `Aws\CloudTrail` - This feature allows users to start and stop event ingestion on a CloudTrail Lake event data store.
* `Aws\SageMaker` - This release adds Selective Execution feature that allows SageMaker Pipelines users to run selected steps in a pipeline.
* `Aws\WAFV2` - Added APIs to describe managed products. The APIs retrieve information about rule groups that are managed by AWS and by AWS Marketplace sellers.

## 3.271.6 - 2023-06-01

* `Aws\AlexaForBusiness` - Alexa for Business has been deprecated and is no longer supported.
* `Aws\Appflow` - Added ability to select DataTransferApiType for DescribeConnector and CreateFlow requests when using Async supported connectors. Added supportedDataTransferType to DescribeConnector/DescribeConnectors/ListConnector response.
* `Aws\CustomerProfiles` - This release introduces calculated attribute related APIs.
* `Aws\IVS` - API Update for IVS Advanced Channel type
* `Aws\SageMaker` - Amazon Sagemaker Autopilot adds support for Parquet file input to NLP text classification jobs.
* `Aws\WAFV2` - Corrected the information for the header order FieldToMatch setting

## 3.271.5 - 2023-05-31

* `Aws\ConfigService` - Resource Types Exclusion feature launch by AWS Config
* `Aws\FraudDetector` - This release enables publishing event predictions from Amazon Fraud Detector (AFD) to Amazon EventBridge. For example, after getting predictions from AFD, Amazon EventBridge rules can be configured to trigger notification through an SNS topic, send a message with SES, or trigger Lambda workflows.
* `Aws\HealthLake` - This release adds a new request parameter to the CreateFHIRDatastore API operation. IdentityProviderConfiguration specifies how you want to authenticate incoming requests to your Healthlake Data Store.
* `Aws\MainframeModernization` - Adds an optional create-only 'roleArn' property to Application resources. Enables PS and PO data set org types.
* `Aws\RDS` - This release adds support for changing the engine for Oracle using the ModifyDbInstance API
* `Aws\ServiceCatalog` - Documentation updates for ServiceCatalog.
* `Aws\WorkSpacesWeb` - WorkSpaces Web now allows you to control which IP addresses your WorkSpaces Web portal may be accessed from.

## 3.271.4 - 2023-05-30

* `Aws\ChimeSDKVoice` - Added optional CallLeg field to StartSpeakerSearchTask API request
* `Aws\Glue` - Added Runtime parameter to allow selection of Ray Runtime
* `Aws\GroundStation` - Updating description of GetMinuteUsage to be clearer.
* `Aws\IoTFleetWise` - Campaigns now support selecting Timestream or S3 as the data destination, Signal catalogs now support "Deprecation" keyword released in VSS v2.1 and "Comment" keyword released in VSS v3.0
* `Aws\LocationService` - This release adds API support for political views for the maps service APIs: CreateMap, UpdateMap, DescribeMap.
* `Aws\MemoryDB` - Amazon MemoryDB for Redis now supports AWS Identity and Access Management authentication access to Redis clusters starting with redis-engine version 7.0
* `Aws\Personalize` - This release provides support for the exclusion of certain columns for training when creating a solution and creating or updating a recommender with Amazon Personalize.
* `Aws\Polly` - Amazon Polly adds 2 new voices - Sofie (da-DK) and Niamh (en-IE)
* `Aws\SecurityHub` - Added new resource detail objects to ASFF, including resources for AwsGuardDutyDetector, AwsAmazonMqBroker, AwsEventSchemasRegistry, AwsAppSyncGraphQlApi and AwsStepFunctionStateMachine.
* `Aws\SecurityLake` - Log sources are now versioned. AWS log sources and custom sources will now come with a version identifier that enables producers to vend multiple schema versions to subscribers. Security Lake API have been refactored to more closely align with AWS API conventions.
* `Aws\WAFV2` - This SDK release provides customers the ability to use Header Order as a field to match.

## 3.271.3 - 2023-05-26

* `Aws\Connect` - Documentation update for a new Initiation Method value in DescribeContact API
* `Aws\IoTWireless` - Add Multicast Group support in Network Analyzer Configuration.
* `Aws\SageMaker` - Added ml.p4d and ml.inf1 as supported instance type families for SageMaker Notebook Instances.

## 3.271.2 - 2023-05-25

* `Aws\ApplicationAutoScaling` - With this release, ElastiCache customers will be able to use predefined metricType "ElastiCacheDatabaseCapacityUsageCountedForEvictPercentage" for their ElastiCache instances.
* `Aws\CodePipeline` - Add PollingDisabledAt time information in PipelineMetadata object of GetPipeline API.
* `Aws\GameLift` - GameLift FleetIQ users can now filter game server claim requests to exclude servers on instances that are draining.
* `Aws\Glue` - Added ability to create data quality rulesets for shared, cross-account Glue Data Catalog tables. Added support for dataset comparison rules through a new parameter called AdditionalDataSources. Enhanced the data quality results with a map containing profiled metric values.
* `Aws\MigrationHubRefactorSpaces` - This SDK update allows for path parameter syntax to be passed to the CreateRoute API. Path parameter syntax require parameters to be enclosed in {} characters. This update also includes a new AppendSourcePath field which lets users forward the source path to the Service URL endpoint.
* `Aws\SageMaker` - Amazon SageMaker Automatic Model Tuning now supports enabling Autotune for tuning jobs which can choose tuning job configurations.

## 3.271.1 - 2023-05-24

* `Aws\AppSync` - This release introduces AppSync Merged APIs, which provide the ability to compose multiple source APIs into a single federated/merged API.
* `Aws\Connect` - Amazon Connect Evaluation Capabilities: validation improvements
* `Aws\CostandUsageReportService` - Add support for split cost allocation data on a report.
* `Aws\SageMaker` - SageMaker now provides an instantaneous deployment recommendation through the DescribeModel API

## 3.271.0 - 2023-05-23

* `Aws\` - Added support for calling TranslateDocument API.
* `Aws\` - Added ModelNameEquals, ModelPackageVersionArnEquals in request and ModelName, SamplePayloadUrl, ModelPackageVersionArn in response of ListInferenceRecommendationsJobs API. Added Invocation timestamps in response of DescribeInferenceRecommendationsJob API & ListInferenceRecommendationsJobSteps API.
* `Aws\` - Fixes issue that could cause calls to GetAdminScope and ListAdminAccountsForOrganization to return a 500 Internal Server error.

## 3.270.1 - 2023-05-22

* `Aws\Backup` - Added support for tags on restore.
* `Aws\Pinpoint` - Amazon Pinpoint is deprecating the tags parameter in the UpdateSegment, UpdateCampaign, UpdateEmailTemplate, UpdateSmsTemplate, UpdatePushTemplate, UpdateInAppTemplate and UpdateVoiceTemplate. Amazon Pinpoint will end support tags parameter by May 22, 2023.
* `Aws\QuickSight` - Add support for Asset Bundle, Geospatial Heatmaps.

## 3.270.0 - 2023-05-19

* `Aws\Backup` - Add ResourceArn, ResourceType, and BackupVaultName to ListRecoveryPointsByLegalHold API response.
* `Aws\ConnectCases` - This release adds the ability to create fields with type Url through the CreateField API. For more information see https://docs.aws.amazon.com/cases/latest/APIReference/Welcome.html
* `Aws\MediaPackageV2` - Adds support for the MediaPackage Live v2 API
* `Aws\SESv2` - This release allows customers to update scaling mode property of dedicated IP pools with PutDedicatedIpPoolScalingAttributes call.

## 3.269.14 - 2023-05-18

* `Aws\Athena` - Removing SparkProperties from EngineConfiguration object for StartSession API call
* `Aws\CloudTrail` - Add ConflictException to PutEventSelectors, add (Channel/EDS)ARNInvalidException to Tag APIs. These exceptions provide customers with more specific error messages instead of internal errors.
* `Aws\ComputeOptimizer` - In this launch, we add support for showing integration status with external metric providers such as Instana, Datadog ...etc in GetEC2InstanceRecommendations and ExportEC2InstanceRecommendations apis
* `Aws\Connect` - You can programmatically create and manage prompts using APIs, for example, to extract prompts stored within Amazon Connect and add them to your Amazon S3 bucket. AWS CloudTrail, AWS CloudFormation and tagging are supported.
* `Aws\EC2` - Add support for i4g.large, i4g.xlarge, i4g.2xlarge, i4g.4xlarge, i4g.8xlarge and i4g.16xlarge instances powered by AWS Graviton2 processors that deliver up to 15% better compute performance than our other storage-optimized instances.
* `Aws\ECS` - Documentation only release to address various tickets.
* `Aws\MediaConvert` - This release introduces a new MXF Profile for XDCAM which is strictly compliant with the SMPTE RDD 9 standard and improved handling of output name modifiers.
* `Aws\RDS` - RDS documentation update for the EngineVersion parameter of ModifyDBSnapshot
* `Aws\STS` - API updates for the AWS Security Token Service
* `Aws\SageMakerGeospatial` - This release makes ExecutionRoleArn a required field in the StartEarthObservationJob API.

## 3.269.13 - 2023-05-16

* `Aws\Detective` - Added and updated API operations in Detective to support the integration of ASFF Security Hub findings.
* `Aws\DirectConnect` - This release includes an update to the mtu value for CreateTransitVirtualInterface from 9001 mtu to 8500 mtu.
* `Aws\Glue` - Add Support for Tags for Custom Entity Types
* `Aws\SecretsManager` - Documentation updates for Secrets Manager
* `Aws\WAFV2` - My AWS Service (placeholder) - You can now rate limit web requests based on aggregation keys other than IP addresses, and you can aggregate using combinations of keys. You can also rate limit all requests that match a scope-down statement, without further aggregation.

## 3.269.12 - 2023-05-15

* `Aws\Athena` - You can now define custom spark properties at start of the session for use cases like cluster encryption, table formats, and general Spark tuning.
* `Aws\CodeCatalyst` - With this release, the users can list the active sessions connected to their Dev Environment on AWS CodeCatalyst
* `Aws\Kafka` - Added a fix to make clusterarn a required field in ListClientVpcConnections and RejectClientVpcConnection APIs
* `Aws\Rekognition` - This release adds a new EyeDirection attribute in Amazon Rekognition DetectFaces and IndexFaces APIs which predicts the yaw and pitch angles of a person's eye gaze direction for each face detected in the image.
* `Aws\RolesAnywhere` - Adds support for custom notification settings in a trust anchor. Introduces PutNotificationSettings and ResetNotificationSettings API's. Updates DurationSeconds max value to 3600.
* `Aws\Transfer` - This release introduces the ability to require both password and SSH key when users authenticate to your Transfer Family servers that use the SFTP protocol.

## 3.269.11 - 2023-05-11

* `Aws\Connect` - This release updates GetMetricDataV2 API, to support metric data up-to last 35 days
* `Aws\ElastiCache` - Added support to modify the cluster mode configuration for the existing ElastiCache ReplicationGroups. Customers can now modify the configuration from cluster mode disabled to cluster mode enabled.
* `Aws\ElasticsearchService` - This release fixes DescribePackages API error with null filter value parameter.
* `Aws\Health` - Add support for regional endpoints
* `Aws\IVSRealTime` - Add methods for inspecting and debugging stages: ListStageSessions, GetStageSession, ListParticipants, GetParticipant, and ListParticipantEvents.
* `Aws\Omics` - This release provides support for Ready2Run and GPU workflows, an improved read set filter, the direct upload of read sets into Omics Storage, and annotation parsing for analytics stores.
* `Aws\OpenSearchService` - This release fixes DescribePackages API error with null filter value parameter.
* `Aws\Route53Resolver` - Update FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\Support` - This release adds 2 new Support APIs, DescribeCreateCaseOptions and DescribeSupportedLanguages. You can use these new APIs to get available support languages.

## 3.269.10 - 2023-05-10

* `Aws\EMR` - EMR Studio now supports programmatically executing a Notebooks on an EMR on EKS cluster. In addition, notebooks can now be executed by specifying its location in S3.
* `Aws\RDS` - Amazon Relational Database Service (RDS) updates for the new Aurora I/O-Optimized storage type for Amazon Aurora DB clusters
* `Aws\SWF` - This release adds a new API parameter to exclude old history events from decision tasks.

## 3.269.9 - 2023-05-09

* `Aws\ApplicationAutoScaling` - With this release, Amazon SageMaker Serverless Inference customers can use Application Auto Scaling to auto scale the provisioned concurrency of their serverless endpoints.
* `Aws\Glue` - This release adds AmazonRedshift Source and Target nodes in addition to DynamicTransform OutputSchemas
* `Aws\SageMaker` - This release includes support for (1) Provisioned Concurrency for Amazon SageMaker Serverless Inference and (2) UpdateEndpointWeightsAndCapacities API for Serverless endpoints.

## 3.269.8 - 2023-05-08

* `Aws\Glue` - Support large worker types G.4x and G.8x for Glue Spark
* `Aws\GuardDuty` - Add AccessDeniedException 403 Error message code to support 3 Tagging related APIs
* `Aws\IoTSiteWise` - Provide support for 20,000 max results for GetAssetPropertyValueHistory/BatchGetAssetPropertyValueHistory and 15 minute aggregate resolution for GetAssetPropertyAggregates/BatchGetAssetPropertyAggregates
* `Aws\STS` - Documentation updates for AWS Security Token Service.

## 3.269.7 - 2023-05-05

* `Aws\EC2` - This release adds support the inf2 and trn1n instances. inf2 instances are purpose built for deep learning inference while trn1n instances are powered by AWS Trainium accelerators and they build on the capabilities of Trainium-powered trn1 instances.
* `Aws\Inspector2` - Amazon Inspector now allows customers to search its vulnerability intelligence database if any of the Inspector scanning types are activated.
* `Aws\MediaTailor` - This release adds support for AFTER_LIVE_EDGE mode configuration for avail suppression, and adding a fill-policy setting that sets the avail suppression to PARTIAL_AVAIL or FULL_AVAIL_ONLY when AFTER_LIVE_EDGE is enabled.
* `Aws\SQS` - Revert previous SQS protocol change.

## 3.269.6 - 2023-05-04

* `Aws\CloudWatch` - Adds support for filtering by metric names in CloudWatch Metric Streams.
* `Aws\ConfigService` - Updated ResourceType enum with new resource types onboarded by AWS Config in April 2023.
* `Aws\Connect` - Remove unused InvalidParameterException from CreateParticipant API
* `Aws\ECS` - Documentation update for new error type NamespaceNotFoundException for CreateCluster and UpdateCluster
* `Aws\NetworkFirewall` - This release adds support for the Suricata REJECT option in midstream exception configurations.
* `Aws\OpenSearchService` - DescribeDomainNodes: A new API that provides configuration information for nodes part of the domain
* `Aws\QuickSight` - Add support for Topic, Dataset parameters and VPC
* `Aws\Rekognition` - This release adds a new attribute FaceOccluded. Additionally, you can now select attributes individually (e.g. ["DEFAULT", "FACE_OCCLUDED", "AGE_RANGE"] instead of ["ALL"]), which can reduce response time.
* `Aws\S3` - Documentation updates for Amazon S3
* `Aws\SQS` - This release enables customers to call SQS using AWS JSON-1.0 protocol.
* `Aws\SageMaker` - We added support for ml.inf2 and ml.trn1 family of instances on Amazon SageMaker for deploying machine learning (ML) models for Real-time and Asynchronous inference. You can use these instances to achieve high performance at a low cost for generative artificial intelligence (AI) models.
* `Aws\SecurityHub` - Add support for Finding History.

## 3.269.5 - 2023-05-03

* `Aws\AppSync` - Private API support for AWS AppSync. With Private APIs, you can now create GraphQL APIs that can only be accessed from your Amazon Virtual Private Cloud ("VPC").
* `Aws\EC2` - Adds an SDK paginator for GetNetworkInsightsAccessScopeAnalysisFindings
* `Aws\Inspector2` - This feature provides deep inspection for linux based instance
* `Aws\IoTTwinMaker` - This release adds a field for GetScene API to return error code and message from dependency services.
* `Aws\NetworkFirewall` - AWS Network Firewall now supports policy level HOME_NET variable overrides.
* `Aws\OpenSearchService` - Amazon OpenSearch Service adds the option to deploy a domain across multiple Availability Zones, with each AZ containing a complete copy of data and with nodes in one AZ acting as a standby. This option provides 99.99% availability and consistent performance in the event of infrastructure failure.
* `Aws\WellArchitected` - This release deepens integration with AWS Service Catalog AppRegistry to improve workload resource discovery.

## 3.269.4 - 2023-05-02

* `Aws\Appflow` - This release adds new API to cancel flow executions.
* `Aws\Connect` - Amazon Connect Service Rules API update: Added OnContactEvaluationSubmit event source to support user configuring evaluation form rules.
* `Aws\ECS` - Documentation only update to address Amazon ECS tickets.
* `Aws\ResilienceHub` - This release will improve resource level transparency in applications by discovering previously hidden resources.
* `Aws\SageMaker` - Amazon Sagemaker Autopilot supports training models with sample weights and additional objective metrics.
* `Aws\kendra` - AWS Kendra now supports configuring document fields/attributes via the GetQuerySuggestions API. You can now base query suggestions on the contents of document fields.

## 3.269.3 - 2023-05-01

* `Aws\ComputeOptimizer` - support for tag filtering within compute optimizer. ability to filter recommendation results by tag and tag key value pairs. ability to filter by inferred workload type added.
* `Aws\KMS` - This release makes the NitroEnclave request parameter Recipient and the response field for CiphertextForRecipient available in AWS SDKs. It also adds the regex pattern for CloudHsmClusterId validation.

## 3.269.2 - 2023-04-28

* `Aws\Appflow` - Adds Jwt Support for Salesforce Credentials.
* `Aws\Athena` - You can now use capacity reservations on Amazon Athena to run SQL queries on fully-managed compute capacity.
* `Aws\DirectConnect` - This release corrects the jumbo frames MTU from 9100 to 8500.
* `Aws\EFS` - This release adds PAUSED and PAUSING state as a returned value for DescribeReplicationConfigurations response.
* `Aws\IoT` - This release allows AWS IoT Core users to specify a TLS security policy when creating and updating AWS IoT Domain Configurations.
* `Aws\ManagedGrafana` - This release adds support for the grafanaVersion parameter in CreateWorkspace.
* `Aws\Rekognition` - Added support for aggregating moderation labels by video segment timestamps for Stored Video Content Moderation APIs and added additional information about the job to all Stored Video Get API responses.
* `Aws\SimSpaceWeaver` - Added a new CreateSnapshot API. For the StartSimulation API, SchemaS3Location is now optional, added a new SnapshotS3Location parameter. For the DescribeSimulation API, added SNAPSHOT_IN_PROGRESS simulation state, deprecated SchemaError, added new fields: StartError and SnapshotS3Location.
* `Aws\WAFV2` - You can now associate a web ACL with a Verified Access instance.
* `Aws\WorkSpaces` - Added Windows 11 to support Microsoft_Office_2019

## 3.269.1 - 2023-04-27

* `Aws\` - Takes explicit dependency on psr/http-message >= 1.0 to avoid conflicts.
* `Aws\EC2` - This release adds support for AMD SEV-SNP on EC2 instances.
* `Aws\EMRContainers` - This release adds GetManagedEndpointSessionCredentials, a new API that allows customers to generate an auth token to connect to a managed endpoint, enabling features such as self-hosted Jupyter notebooks for EMR on EKS.
* `Aws\GuardDuty` - Added API support to initiate on-demand malware scan on specific resources.
* `Aws\IoTDeviceAdvisor` - AWS IoT Core Device Advisor now supports MQTT over WebSocket. With this update, customers can run all three test suites of AWS IoT Core Device Advisor - qualification, custom, and long duration tests - using Signature Version 4 for MQTT over WebSocket.
* `Aws\Kafka` - Amazon MSK has added new APIs that allows multi-VPC private connectivity and cluster policy support for Amazon MSK clusters that simplify connectivity and access between your Apache Kafka clients hosted in different VPCs and AWS accounts and your Amazon MSK clusters.
* `Aws\Lambda` - Add Java 17 (java17) support to AWS Lambda
* `Aws\MarketplaceCatalog` - Enabled Pagination for List Entities and List Change Sets operations
* `Aws\OSIS` - Documentation updates for OpenSearch Ingestion
* `Aws\QLDB` - Documentation updates for Amazon QLDB
* `Aws\SageMaker` - Added ml.p4d.24xlarge and ml.p4de.24xlarge as supported instances for SageMaker Studio
* `Aws\XRay` - Updated X-Ray documentation with Resource Policy API descriptions.

## 3.269.0 - 2023-04-26

* `Aws\OSIS` - Initial release for OpenSearch Ingestion

## 3.268.18 - 2023-04-25

* `Aws\ChimeSDKMessaging` - Remove non actionable field from UpdateChannelReadMarker and DeleteChannelRequest. Add precise exceptions to DeleteChannel and DeleteStreamingConfigurations error cases.
* `Aws\Connect` - Amazon Connect, Contact Lens Evaluation API release including ability to manage forms and to submit contact evaluations.
* `Aws\DataSync` - This release adds 13 new APIs to support AWS DataSync Discovery GA.
* `Aws\DirectoryService` - New field added in AWS Managed Microsoft AD DescribeSettings response and regex pattern update for UpdateSettings value. Added length validation to RemoteDomainName.
* `Aws\Pinpoint` - Adds support for journey runs and querying journey execution metrics based on journey runs. Adds execution metrics to campaign activities. Updates docs for Advanced Quiet Time.

## 3.268.17 - 2023-04-24

* `Aws\Appflow` - Increased the max length for RefreshToken and AuthCode from 2048 to 4096.
* `Aws\CodeCatalyst` - Documentation updates for Amazon CodeCatalyst.
* `Aws\EC2` - API changes to AWS Verified Access related to identity providers' information.
* `Aws\MediaConvert` - This release introduces a noise reduction pre-filter, linear interpolation deinterlace mode, video pass-through, updated default job settings, and expanded LC-AAC Stereo audio bitrate ranges.
* `Aws\Rekognition` - Added new status result to Liveness session status.

## 3.268.16 - 2023-04-21

* `Aws\Connect` - This release adds a new API CreateParticipant. For Amazon Connect Chat, you can use this new API to customize chat flow experiences.
* `Aws\ECS` - Documentation update to address various Amazon ECS tickets.
* `Aws\FMS` - AWS Firewall Manager adds support for multiple administrators. You can now delegate more than one administrator per organization.

## 3.263.14 - 2023-04-20

* `Aws\Chime` - Adds support for Hindi and Thai languages and additional Amazon Transcribe parameters to the StartMeetingTranscription API.
* `Aws\ChimeSDKMediaPipelines` - This release adds support for specifying the recording file format in an S3 recording sink configuration.
* `Aws\ChimeSDKMeetings` - Adds support for Hindi and Thai languages and additional Amazon Transcribe parameters to the StartMeetingTranscription API.
* `Aws\GameLift` - Amazon GameLift supports creating Builds for Windows 2016 operating system.
* `Aws\GuardDuty` - This release adds support for the new Lambda Protection feature.
* `Aws\IoT` - Support additional OTA states in GetOTAUpdate API
* `Aws\SageMaker` - Amazon SageMaker Canvas adds ModelRegisterSettings support for CanvasAppSettings.
* `Aws\Snowball` - Adds support for Amazon S3 compatible storage. AWS Snow Family customers can now use Amazon S3 compatible storage on Snowball Edge devices. Also adds support for V3_5S. This is a refreshed AWS Snowball Edge Storage Optimized device type with 210TB SSD (customer usable).
* `Aws\WAFV2` - You can now create encrypted API keys to use in a client application integration of the JavaScript CAPTCHA API . You can also retrieve a list of your API keys and the JavaScript application integration URL.

## 3.263.13 - 2023-04-19

* `Aws\Comprehend` - This release supports native document models for custom classification, in addition to plain-text models. You train native document models using documents (PDF, Word, images) in their native format.
* `Aws\ECS` - This release supports the Account Setting "TagResourceAuthorization" that allows for enhanced Tagging security controls.
* `Aws\RAM` - This release adds support for customer managed permissions. Customer managed permissions enable customers to author and manage tailored permissions for resources shared using RAM.
* `Aws\RDS` - Adds support for the ImageId parameter of CreateCustomDBEngineVersion to RDS Custom for Oracle
* `Aws\S3` - Provides support for "Snow" Storage class.
* `Aws\S3` - Removes ACL from bucket creation in S3 Streamwrapper.
* `Aws\S3Control` - Provides support for overriding endpoint when region is "snow". This will enable bucket APIs for Amazon S3 Compatible storage on Snow Family devices.
* `Aws\SecretsManager` - Documentation updates for Secrets Manager
* `Aws\SecurityHub` - Update that adds SDK code examples for Security Hub

## 3.263.12 - 2023-04-17

* `Aws\Appflow` - This release adds a Client Token parameter to the following AppFlow APIs: Create/Update Connector Profile, Create/Update Flow, Start Flow, Register Connector, Update Connector Registration. The Client Token parameter allows idempotent operations for these APIs.
* `Aws\DynamoDB` - Documentation updates for DynamoDB API
* `Aws\EMRServerless` - The GetJobRun API has been updated to include the job's billed resource utilization. This utilization shows the aggregate vCPU, memory and storage that AWS has billed for the job run. The billed resources include a 1-minute minimum usage for workers, plus additional storage over 20 GB per worker.
* `Aws\InternetMonitor` - This release includes a new configurable value, TrafficPercentageToMonitor, which allows users to adjust the amount of traffic monitored by percentage
* `Aws\IoTWireless` - Supports the new feature of LoRaWAN roaming, allows to configure MaxEirp for LoRaWAN gateway, and allows to configure PingSlotPeriod for LoRaWAN multicast group
* `Aws\Lambda` - Add Python 3.10 (python3.10) support to AWS Lambda
* `Aws\drs` - Changed existing APIs and added new APIs to support using an account-level launch configuration template with AWS Elastic Disaster Recovery.

## 3.263.11 - 2023-04-14

* `Aws\ECS` - This release supports ephemeral storage for AWS Fargate Windows containers.
* `Aws\Lambda` - This release adds SnapStart related exceptions to InvokeWithResponseStream API. IAM access related documentation is also added for this API.
* `Aws\MigrationHubRefactorSpaces` - Doc only update for Refactor Spaces environments without network bridge feature.
* `Aws\RDS` - This release adds support of modifying the engine mode of database clusters.

## 3.263.10 - 2023-04-13

* `Aws\ChimeSDKVoice` - This release adds tagging support for Voice Connectors and SIP Media Applications
* `Aws\MediaConnect` - Gateway is a new feature of AWS Elemental MediaConnect. Gateway allows the deployment of on-premises resources for the purpose of transporting live video to and from the AWS Cloud.

## 3.263.9 - 2023-04-12

* `Aws\GroundStation` - AWS Ground Station Wideband DigIF GA Release
* `Aws\ManagedBlockchain` - Removal of the Ropsten network. The Ethereum foundation ceased support of Ropsten on December 31st, 2022..

## 3.263.8 - 2023-04-11

* `Aws\ECRPublic` - This release will allow using registry alias as registryId in BatchDeleteImage request.
* `Aws\EMRServerless` - This release extends GetJobRun API to return job run timeout (executionTimeoutMinutes) specified during StartJobRun call (or default timeout of 720 minutes if none was specified).
* `Aws\EventBridge` - EventBridge PutTarget support for multiple SQL arguments on RedshiftDataParameters
* `Aws\IoT` - Re-release to remove unexpected API changes
* `Aws\IoTDataPlane` - This release adds support for MQTT5 user properties when calling the AWS IoT GetRetainedMessage API
* `Aws\WAFV2` - For web ACLs that protect CloudFront protections, the default request body inspection size is now 16 KB, and you can use the new association configuration to increase the inspection size further, up to 64 KB. Sizes over 16 KB can incur additional costs.

## 3.263.7 - 2023-04-10

* `Aws\Connect` - This release adds the ability to configure an agent's routing profile to receive contacts from multiple channels at the same time via extending the UpdateRoutingProfileConcurrency, CreateRoutingProfile and DescribeRoutingProfile APIs.
* `Aws\ECS` - This release adds support for enabling FIPS compliance on Amazon ECS Fargate tasks
* `Aws\MarketplaceCatalog` - Added three new APIs to support resource sharing: GetResourcePolicy, PutResourcePolicy, and DeleteResourcePolicy. Added new OwnershipType field to ListEntities request to let users filter on entities that are shared with them. Increased max page size of ListEntities response from 20 to 50 results.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK now supports conversion of 608 paint-on captions to pop-on captions for SCC sources.
* `Aws\Omics` - Remove unexpected API changes.
* `Aws\Rekognition` - This release adds support for Face Liveness APIs in Amazon Rekognition. Updates UpdateStreamProcessor to return ResourceInUseException Exception. Minor updates to API documentation.

## 3.263.6 - 2023-04-07

* `Aws\DLM` - Updated timestamp format for GetLifecyclePolicy API
* `Aws\DocDB` - This release adds a new parameter 'DBClusterParameterGroupName' to 'RestoreDBClusterFromSnapshot' API to associate the name of the DB cluster parameter group while performing restore.
* `Aws\FSx` - Amazon FSx for Lustre now supports creating data repository associations on Persistent_1 and Scratch_2 file systems.
* `Aws\Lambda` - This release adds a new Lambda InvokeWithResponseStream API to support streaming Lambda function responses. The release also adds a new InvokeMode parameter to Function Url APIs to control whether the response will be streamed or buffered.
* `Aws\QuickSight` - This release has two changes: adding the OR condition to tag-based RLS rules in CreateDataSet and UpdateDataSet; adding RefreshSchedule and Incremental RefreshProperties operations for users to programmatically configure SPICE dataset ingestions.
* `Aws\RedshiftDataAPIService` - Update documentation of API descriptions as needed in support of temporary credentials with IAM identity.
* `Aws\ServiceCatalog` - Updates description for property

## 3.263.5 - 2023-04-06

* `Aws\CloudFormation` - Including UPDATE_COMPLETE as a failed status for DeleteStack waiter.
* `Aws\GreengrassV2` - Add support for SUCCEEDED value in coreDeviceExecutionStatus field. Documentation updates for Greengrass V2.
* `Aws\Proton` - This release adds support for the AWS Proton service sync feature. Service sync enables managing an AWS Proton service (creating and updating instances) and all of it's corresponding service instances from a Git repository.
* `Aws\RDS` - Adds and updates the SDK examples

## 3.263.4 - 2023-04-05

* `Aws\AppRunner` - App Runner adds support for seven new vCPU and memory configurations.
* `Aws\ConfigService` - This release adds resourceType enums for types released in March 2023.
* `Aws\ECS` - This is a document only updated to add information about Amazon Elastic Inference (EI).
* `Aws\IVSRealTime` - Fix ParticipantToken ExpirationTime format
* `Aws\IdentityStore` - Documentation updates for Identity Store CLI command reference.
* `Aws\NetworkFirewall` - AWS Network Firewall now supports IPv6-only subnets.
* `Aws\ServiceCatalog` - removed incorrect product type value
* `Aws\VPCLattice` - This release removes the entities in the API doc model package for auth policies.

## 3.263.3 - 2023-04-04

* `Aws\AmplifyUIBuilder` - Support StorageField and custom displays for data-bound options in form builder. Support non-string operands for predicates in collections. Support choosing client to get token from.
* `Aws\AutoScaling` - Documentation updates for Amazon EC2 Auto Scaling
* `Aws\DataExchange` - This release updates the value of MaxResults.
* `Aws\EC2` - C6in, M6in, M6idn, R6in and R6idn bare metal instances are powered by 3rd Generation Intel Xeon Scalable processors and offer up to 200 Gbps of network bandwidth.
* `Aws\ElasticInference` - Updated public documentation for the Describe and Tagging APIs.
* `Aws\SageMaker` - Amazon SageMaker Asynchronous Inference now allows customer's to receive failure model responses in S3 and receive success/failure model responses in SNS notifications.
* `Aws\SageMakerRuntime` - Amazon SageMaker Asynchronous Inference now provides customers a FailureLocation as a response parameter in InvokeEndpointAsync API to capture the model failure responses.
* `Aws\WAFV2` - This release rolls back association config feature for webACLs that protect CloudFront protections.

## 3.263.2 - 2023-04-03

* `Aws\Glue` - Add support for database-level federation
* `Aws\LakeFormation` - Add support for database-level federation
* `Aws\LicenseManager` - This release adds grant override options to the CreateGrantVersion API. These options can be used to specify grant replacement behavior during grant activation.
* `Aws\MWAA` - This Amazon MWAA release adds the ability to customize the Apache Airflow environment by launching a shell script at startup. This shell script is hosted in your environment's Amazon S3 bucket. Amazon MWAA runs the script before installing requirements and initializing the Apache Airflow process.
* `Aws\ServiceCatalog` - This release introduces Service Catalog support for Terraform open source. It enables 1. The notify* APIs to Service Catalog. These APIs are used by the terraform engine to notify the result of the provisioning engine execution. 2. Adds a new TERRAFORM_OPEN_SOURCE product type in CreateProduct API.
* `Aws\WAFV2` - For web ACLs that protect CloudFront protections, the default request body inspection size is now 16 KB, and you can use the new association configuration to increase the inspection size further, up to 64 KB. Sizes over 16 KB can incur additional costs.

## 3.263.1 - 2023-03-31

* `Aws\EC2` - Documentation updates for EC2 On Demand Capacity Reservations
* `Aws\InternetMonitor` - This release adds a new feature for Amazon CloudWatch Internet Monitor that enables customers to deliver internet measurements to Amazon S3 buckets as well as CloudWatch Logs.
* `Aws\ResilienceHub` - Adding EKS related documentation for appTemplateBody
* `Aws\S3` - Documentation updates for Amazon S3
* `Aws\SMS` - Deprecating AWS Server Migration Service.
* `Aws\SageMakerFeatureStoreRuntime` - In this release, you can now chose between soft delete and hard delete when calling the DeleteRecord API, so you have more flexibility when it comes to managing online store data.

## 3.263.0 - 2023-03-30

* `Aws\Athena` - Make DefaultExecutorDpuSize and CoordinatorDpuSize fields optional in StartSession
* `Aws\AutoScaling` - Amazon EC2 Auto Scaling now supports Elastic Load Balancing traffic sources with the AttachTrafficSources, DetachTrafficSources, and DescribeTrafficSources APIs. This release also introduces a new activity status, "WaitingForConnectionDraining", for VPC Lattice to the DescribeScalingActivities API.
* `Aws\Batch` - This feature allows Batch on EKS to support configuration of Pod Labels through Metadata for Batch on EKS Jobs.
* `Aws\ComputeOptimizer` - This release adds support for HDD EBS volume types and io2 Block Express. We are also adding support for 61 new instance types and instances that have non consecutive runtime.
* `Aws\Credentials` - Fixes a bug with the new SSO login flow where the wrong index was being looked at for the SSO client provider region
* `Aws\EC2` - This release adds support for Tunnel Endpoint Lifecycle control, a new feature that provides Site-to-Site VPN customers with better visibility and control of their VPN tunnel maintenance updates.
* `Aws\EMR` - Updated DescribeCluster and ListClusters API responses to include ErrorDetail that specifies error code, programmatically accessible error data,and an error message. ErrorDetail provides the underlying reason for cluster failure and recommends actions to simplify troubleshooting of EMR clusters.
* `Aws\Glue` - This release adds support for AWS Glue Data Quality, which helps you evaluate and monitor the quality of your data and includes the API for creating, deleting, or updating data quality rulesets, runs and evaluations.
* `Aws\GuardDuty` - Added EKS Runtime Monitoring feature support to existing detector, finding APIs and introducing new Coverage APIs
* `Aws\IVS` - Amazon Interactive Video Service (IVS) now offers customers the ability to configure IVS channels to allow insecure RTMP ingest.
* `Aws\NetworkFirewall` - AWS Network Firewall added TLS inspection configurations to allow TLS traffic inspection.
* `Aws\SageMakerGeospatial` - Amazon SageMaker geospatial capabilities now supports server-side encryption with customer managed KMS key and SageMaker notebooks with a SageMaker geospatial image in a Amazon SageMaker Domain with VPC only mode.
* `Aws\Token` - Removes an instance of the utf8_encode function that was deprecated as of 8.2
* `Aws\VPCLattice` - General Availability (GA) release of Amazon VPC Lattice
* `Aws\WellArchitected` - AWS Well-Architected SDK now supports getting consolidated report metrics and generating a consolidated report PDF.
* `Aws\drs` - Adding a field to the replication configuration APIs to support the auto replicate new disks feature. We also deprecated RetryDataReplication.
* `Aws\imagebuilder` - Adds support for new image workflow details and image vulnerability detection.
* `Aws\kendra` - AWS Kendra now supports featured results for a query.

## 3.262.4 - 2023-03-29

* `Aws\OpenSearchServerless` - This release includes two new exception types "ServiceQuotaExceededException" and "OcuLimitExceededException".
* `Aws\RDS` - Add support for creating a read replica DB instance from a Multi-AZ DB cluster.

## 3.262.3 - 2023-03-28

* `Aws\IoTDataPlane` - Add endpoint ruleset support for cn-north-1.
* `Aws\SSMContacts` - This release adds 12 new APIs as part of Oncall Schedule feature release, adds support for a new contact type: ONCALL_SCHEDULE. Check public documentation for AWS ssm-contacts for more information
* `Aws\SSMIncidents` - Increased maximum length of "TriggerDetails.rawData" to 10K characters and "IncidentSummary" to 8K characters.

## 3.262.2 - 2023-03-27

* `Aws\AppRegistry` - In this release, we started supporting ARN in applicationSpecifier and attributeGroupSpecifier. GetAttributeGroup, ListAttributeGroups and ListAttributeGroupsForApplication APIs will now have CreatedBy field in the response.
* `Aws\Athena` - Enforces a minimal level of encryption for the workgroup for query and calculation results that are written to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the administrator or higher when they submit queries.
* `Aws\ChimeSDKVoice` - Documentation updates for Amazon Chime SDK Voice.
* `Aws\Connect` - This release introduces support for RelatedContactId in the StartChatContact API. Interactive message and interactive message response have been added to the list of supported message content types for this API as well.
* `Aws\ConnectParticipant` - This release provides an update to the SendMessage API to handle interactive message response content-types.
* `Aws\IoTWireless` - Introducing new APIs that enable Sidewalk devices to communicate with AWS IoT Core through Sidewalk gateways. This will empower AWS customers to connect Sidewalk devices with other AWS IoT Services, creating possibilities for seamless integration and advanced device management.
* `Aws\MediaLive` - AWS Elemental MediaLive now supports ID3 tag insertion for audio only HLS output groups. AWS Elemental Link devices now support tagging.
* `Aws\SageMaker` - Fixed some improperly rendered links in SDK documentation.
* `Aws\SecurityHub` - Added new resource detail objects to ASFF, including resources for AwsEksCluster, AWSS3Bucket, AwsEc2RouteTable and AwsEC2Instance.
* `Aws\VoiceID` - Amazon Connect Voice ID now supports multiple fraudster watchlists. Every domain has a default watchlist where all existing fraudsters are placed by default. Custom watchlists may now be created, managed, and evaluated against for known fraudster detection.

## 3.262.1 - 2023-03-24

* `Aws\CloudWatch` - Doc-only update to correct alarm actions list
* `Aws\Comprehend` - This release adds a new field (FlywheelArn) to the EntitiesDetectionJobProperties object. The FlywheelArn field is returned in the DescribeEntitiesDetectionJob and ListEntitiesDetectionJobs responses when the EntitiesDetection job is started with a FlywheelArn instead of an EntityRecognizerArn .
* `Aws\RDS` - Added error code CreateCustomDBEngineVersionFault for when the create custom engine version for Custom engines fails.

## 3.262.0 - 2023-03-23

* `Aws\Batch` - This feature allows Batch to support configuration of ephemeral storage size for jobs running on FARGATE
* `Aws\ChimeSDKIdentity` - AppInstanceBots can be used to add a bot powered by Amazon Lex to chat channels. ExpirationSettings provides automatic resource deletion for AppInstanceUsers.
* `Aws\ChimeSDKMediaPipelines` - This release adds Amazon Chime SDK call analytics. Call analytics include voice analytics, which provides speaker search and voice tone analysis. These capabilities can be used with Amazon Transcribe and Transcribe Call Analytics to generate machine-learning-powered insights from real-time audio.
* `Aws\ChimeSDKMessaging` - ExpirationSettings provides automatic resource deletion for Channels.
* `Aws\ChimeSDKVoice` - This release adds Amazon Chime SDK call analytics. Call analytics include voice analytics, which provides speaker search and voice tone analysis. These capabilities can be used with Amazon Transcribe and Transcribe Call Analytics to generate machine-learning-powered insights from real-time audio.
* `Aws\CodeArtifact` - Repository CreationTime is added to the CreateRepository and ListRepositories API responses.
* `Aws\GuardDuty` - Adds AutoEnableOrganizationMembers attribute to DescribeOrganizationConfiguration and UpdateOrganizationConfiguration APIs.
* `Aws\IVSRealTime` - Initial release of the Amazon Interactive Video Service RealTime API.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK now supports passthrough of ID3v2 tags for audio inputs to audio-only HLS outputs.
* `Aws\SageMaker` - Amazon SageMaker Autopilot adds two new APIs - CreateAutoMLJobV2 and DescribeAutoMLJobV2. Amazon SageMaker Notebook Instances now supports the ml.geospatial.interactive instance type.
* `Aws\ServiceDiscovery` - Reverted the throttling exception RequestLimitExceeded for AWS Cloud Map APIs introduced in SDK version 1.12.424 2023-03-09 to previous exception specified in the ErrorCode.
* `Aws\Textract` - The AnalyzeDocument - Tables feature adds support for new elements in the API: table titles, footers, section titles, summary cells/tables, and table type.

## 3.261.17 - 2023-03-22

* `Aws\IAM` - Documentation updates for AWS Identity and Access Management (IAM).
* `Aws\IoTTwinMaker` - This release adds support of adding metadata when creating a new scene or updating an existing scene.
* `Aws\NetworkManager` - This release includes an update to create-transit-gateway-route-table-attachment, showing example usage for TransitGatewayRouteTableArn.
* `Aws\Pipes` - This release improves validation on the ARNs in the API model
* `Aws\ResilienceHub` - This release provides customers with the ability to import resources from within an EKS cluster and assess the resiliency of EKS cluster workloads.
* `Aws\SSM` - This Patch Manager release supports creating, updating, and deleting Patch Baselines for AmazonLinux2023, AlmaLinux.

## 3.261.16 - 2023-03-21

* `Aws\ChimeSDKMessaging` - Amazon Chime SDK messaging customers can now manage streaming configuration for messaging data for archival and analysis.
* `Aws\CleanRooms` - GA Release of AWS Clean Rooms, Added Tagging Functionality
* `Aws\EC2` - This release adds support for AWS Network Firewall, AWS PrivateLink, and Gateway Load Balancers to Amazon VPC Reachability Analyzer, and it makes the path destination optional as long as a destination address in the filter at source is provided.
* `Aws\IoTSiteWise` - Provide support for tagging of data streams and enabling tag based authorization for property alias
* `Aws\mgn` - This release introduces the Import and export feature and expansion of the post-launch actions

## 3.261.15 - 2023-03-20

* `Aws\ApplicationAutoScaling` - With this release customers can now tag their Application Auto Scaling registered targets with key-value pairs and manage IAM permissions for all the tagged resources centrally.
* `Aws\Neptune` - This release makes following few changes. db-cluster-identifier is now a required parameter of create-db-instance. describe-db-cluster will now return PendingModifiedValues and GlobalClusterIdentifier fields in the response.
* `Aws\S3Outposts` - S3 On Outposts added support for endpoint status, and a failed endpoint reason, if any
* `Aws\WorkDocs` - This release adds a new API, SearchResources, which enable users to search through metadata and content of folders, documents, document versions and comments in a WorkDocs site.

## 3.261.14 - 2023-03-17

* `Aws\BillingConductor` - This release adds a new filter to ListAccountAssociations API and a new filter to ListBillingGroups API.
* `Aws\ConfigService` - This release adds resourceType enums for types released from October 2022 through February 2023.
* `Aws\DatabaseMigrationService` - S3 setting to create AWS Glue Data Catalog. Oracle setting to control conversion of timestamp column. Support for Kafka SASL Plain authentication. Setting to map boolean from PostgreSQL to Redshift. SQL Server settings to force lob lookup on inline LOBs and to control access of database logs.

## 3.261.13 - 2023-03-16

* `Aws\GuardDuty` - Updated 9 APIs for feature enablement to reflect expansion of GuardDuty to features. Added new APIs and updated existing APIs to support RDS Protection GA.
* `Aws\ResourceExplorer2` - Documentation updates for APIs.
* `Aws\SageMakerRuntime` - Documentation updates for SageMaker Runtime

## 3.261.12 - 2023-03-15

* `Aws\MigrationHubStrategyRecommendations` - This release adds the binary analysis that analyzes IIS application DLLs on Windows and Java applications on Linux to provide anti-pattern report without configuring access to the source code.
* `Aws\S3Control` - Added support for S3 Object Lambda aliases.
* `Aws\SecurityLake` - Make Create/Get/ListSubscribers APIs return resource share ARN and name so they can be used to validate the RAM resource share to accept. GetDatalake can be used to track status of UpdateDatalake and DeleteDatalake requests.

## 3.261.11 - 2023-03-14

* `Aws\ApplicationAutoScaling` - Application Auto Scaling customers can now use mathematical functions to customize the metric used with Target Tracking policies within the policy configuration itself, saving the cost and effort of publishing the customizations as a separate metric.
* `Aws\DataExchange` - This release enables data providers to license direct access to S3 objects encrypted with Customer Managed Keys (CMK) in AWS KMS through AWS Data Exchange. Subscribers can use these keys to decrypt, then use the encrypted S3 objects shared with them, without creating or managing copies.
* `Aws\DirectConnect` - describe-direct-connect-gateway-associations includes a new status, updating, indicating that the association is currently in-process of updating.
* `Aws\EC2` - This release adds a new DnsOptions key (PrivateDnsOnlyForInboundResolverEndpoint) to CreateVpcEndpoint and ModifyVpcEndpoint APIs.
* `Aws\IAM` - Documentation only updates to correct customer-reported issues
* `Aws\Keyspaces` - Adding support for client-side timestamps

## 3.261.10 - 2023-03-13

* `Aws\AppIntegrationsService` - Adds FileConfiguration to Amazon AppIntegrations CreateDataIntegration supporting scheduled downloading of third party files into Amazon Connect from sources such as Microsoft SharePoint.
* `Aws\ConnectWisdomService` - This release extends Wisdom CreateKnowledgeBase API to support SharePoint connector type by removing the @required trait for objectField
* `Aws\LakeFormation` - This release updates the documentation regarding Get/Update DataCellsFilter
* `Aws\S3Control` - Added support for cross-account Multi-Region Access Points. Added support for S3 Replication for S3 on Outposts.
* `Aws\Tnb` - This release adds tagging support to the following Network Instance APIs : Instantiate, Update, Terminate.

## 3.261.9 - 2023-03-10

* `Aws\SecretsManager` - The type definitions of SecretString and SecretBinary now have a minimum length of 1 in the model to match the exception thrown when you pass in empty values.
* `Aws\ivschat` - This release adds a new exception returned when calling AWS IVS chat UpdateLoggingConfiguration. Now UpdateLoggingConfiguration can return ConflictException when invalid updates are made in sequence to Logging Configurations.

## 3.261.8 - 2023-03-09

* `Aws\CloudWatchEvidently` - Updated entity override documentation
* `Aws\CodeArtifact` - This release introduces the generic package format, a mechanism for storing arbitrary binary assets. It also adds a new API, PublishPackageVersion, to allow for publishing generic packages.
* `Aws\Connect` - This release adds a new API, GetMetricDataV2, which returns metric data for Amazon Connect.
* `Aws\NetworkManager` - This update provides example usage for TransitGatewayRouteTableArn.
* `Aws\QuickSight` - This release has two changes: add state persistence feature for embedded dashboard and console in GenerateEmbedUrlForRegisteredUser API; add properties for hidden collapsed row dimensions in PivotTableOptions.
* `Aws\RedshiftDataAPIService` - Added support for Redshift Serverless workgroup-arn wherever the WorkgroupName parameter is available.
* `Aws\SESv2` - This release introduces a new recommendation in Virtual Deliverability Manager Advisor, which detects missing or misconfigured Brand Indicator for Message Identification (BIMI) DNS records for customer sending identities.
* `Aws\SageMaker` - Amazon SageMaker Inference now allows SSM access to customer's model container by setting the "EnableSSMAccess" parameter for a ProductionVariant in CreateEndpointConfig API.
* `Aws\ServiceDiscovery` - Updated all AWS Cloud Map APIs to provide consistent throttling exception (RequestLimitExceeded)
* `Aws\Signature` - Adds support for sigV4a presigned urls.

## 3.261.7 - 2023-03-08

* `Aws\Athena` - A new field SubstatementType is added to GetQueryExecution API, so customers have an error free way to detect the query type and interpret the result.
* `Aws\DynamoDB` - Adds deletion protection support to DynamoDB tables. Tables with deletion protection enabled cannot be deleted. Deletion protection is disabled by default, can be enabled via the CreateTable or UpdateTable APIs, and is visible in TableDescription. This setting is not replicated for Global Tables.
* `Aws\EC2` - Introducing Amazon EC2 C7g, M7g and R7g instances, powered by the latest generation AWS Graviton3 processors and deliver up to 25% better performance over Graviton2-based instances.
* `Aws\LakeFormation` - This release adds two new API support "GetDataCellsFiler" and "UpdateDataCellsFilter", and also updates the corresponding documentation.
* `Aws\MediaPackage` - This release provides the date and time live resources were created.
* `Aws\MediaPackageVod` - This release provides the date and time VOD resources were created.
* `Aws\Route53Resolver` - Add dual-stack and IPv6 support for Route 53 Resolver Endpoint,Add IPv6 target IP in Route 53 Resolver Forwarding Rule
* `Aws\SageMaker` - There needs to be a user identity to specify the SageMaker user who perform each action regarding the entity. However, these is a not a unified concept of user identity across SageMaker service that could be used today.

## 3.261.6 - 2023-03-07

* `Aws\DatabaseMigrationService` - This release adds DMS Fleet Advisor Target Recommendation APIs and exposes functionality for DMS Fleet Advisor. It adds functionality to start Target Recommendation calculation.
* `Aws\LocationService` - Documentation update for the release of 3 additional map styles for use with Open Data Maps: Open Data Standard Dark, Open Data Visualization Light & Open Data Visualization Dark.

## 3.261.5 - 2023-03-06

* `Aws\Account` - AWS Account alternate contact email addresses can now have a length of 254 characters and contain the character "|".
* `Aws\IVS` - Updated text description in DeleteChannel, Stream, and StreamSummary.

## 3.261.4 - 2023-03-03

* `Aws\DynamoDB` - Documentation updates for DynamoDB.
* `Aws\EC2` - This release adds support for a new boot mode for EC2 instances called 'UEFI Preferred'.
* `Aws\Macie2` - Documentation updates for Amazon Macie
* `Aws\MediaConvert` - The AWS Elemental MediaConvert SDK has improved handling for different input and output color space combinations.
* `Aws\MediaLive` - AWS Elemental MediaLive adds support for Nielsen watermark timezones.
* `Aws\TranscribeService` - Amazon Transcribe now supports role access for these API operations: CreateVocabulary, UpdateVocabulary, CreateVocabularyFilter, and UpdateVocabularyFilter.

## 3.261.3 - 2023-03-02

* `Aws\IoT` - A recurring maintenance window is an optional configuration used for rolling out the job document to all devices in the target group observing a predetermined start time, duration, and frequency that the maintenance window occurs.
* `Aws\MigrationHubStrategyRecommendations` - This release updates the File Import API to allow importing servers already discovered by customers with reduced pre-requisites.
* `Aws\Organizations` - This release introduces a new reason code, ACCOUNT_CREATION_NOT_COMPLETE, to ConstraintViolationException in CreateOrganization API.
* `Aws\PI` - This release adds a new field PeriodAlignment to allow the customer specifying the returned timestamp of time periods to be either the start or end time.
* `Aws\Pipes` - This release fixes some input parameter range and patterns.
* `Aws\SageMaker` - Add a new field "EndpointMetrics" in SageMaker Inference Recommender "ListInferenceRecommendationsJobSteps" API response.

## 3.261.2 - 2023-03-01

* `Aws\CodeCatalyst` - Published Dev Environments StopDevEnvironmentSession API
* `Aws\Pricing` - This release adds 2 new APIs - ListPriceLists which returns a list of applicable price lists, and GetPriceListFileUrl which outputs a URL to retrieve your price lists from the generated file from ListPriceLists
* `Aws\S3Outposts` - S3 on Outposts introduces a new API ListOutpostsWithS3, with this API you can list all your Outposts with S3 capacity.

## 3.261.1 - 2023-02-28

* `Aws\Comprehend` - Amazon Comprehend now supports flywheels to help you train and manage new model versions for custom models.
* `Aws\EC2` - This release allows IMDS support to be set to v2-only on an existing AMI, so that all future instances launched from that AMI will use IMDSv2 by default.
* `Aws\KMS` - AWS KMS is deprecating the RSAES_PKCS1_V1_5 wrapping algorithm option in the GetParametersForImport API that is used in the AWS KMS Import Key Material feature. AWS KMS will end support for this wrapping algorithm by October 1, 2023.
* `Aws\Lightsail` - This release adds Lightsail for Research feature support, such as GUI session access, cost estimates, stop instance on idle, and disk auto mount.
* `Aws\ManagedBlockchain` - This release adds support for tagging to the accessor resource in Amazon Managed Blockchain
* `Aws\Omics` - Minor model changes to accomodate batch imports feature

## 3.261.0 - 2023-02-27

* `Aws\DevOpsGuru` - This release adds the description field on ListAnomaliesForInsight and DescribeAnomaly API responses for proactive anomalies.
* `Aws\InternetMonitor` - CloudWatch Internet Monitor is a a new service within CloudWatch that will help application developers and network engineers continuously monitor internet performance metrics such as availability and performance between their AWS-hosted applications and end-users of these applications
* `Aws\Lambda` - This release adds the ability to create ESMs with Document DB change streams as event source. For more information see https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html.
* `Aws\MediaConvert` - The AWS Elemental MediaConvert SDK has added support for HDR10 to SDR tone mapping, and animated GIF video input sources.
* `Aws\TimestreamWrite` - This release adds the ability to ingest batched historical data or migrate data in bulk from S3 into Timestream using CSV files.
* `Aws\drs` - New fields were added to reflect availability zone data in source server and recovery instance description commands responses, as well as source server launch status.

## 3.260.3 - 2023-02-24

* `Aws\Connect` - StartTaskContact API now supports linked task creation with a new optional RelatedContactId parameter
* `Aws\ConnectCases` - This release adds the ability to delete domains through the DeleteDomain API. For more information see https://docs.aws.amazon.com/cases/latest/APIReference/Welcome.html
* `Aws\Redshift` - Documentation updates for Redshift API bringing it in line with IAM best practices.
* `Aws\SecurityHub` - New Security Hub APIs and updates to existing APIs that help you consolidate control findings and enable and disable controls across all supported standards
* `Aws\ServiceCatalog` - Documentation updates for Service Catalog

## 3.260.2 - 2023-02-23

* `Aws\Appflow` - This release enables the customers to choose whether to use Private Link for Metadata and Authorization call when using a private Salesforce connections
* `Aws\ECS` - This release supports deleting Amazon ECS task definitions that are in the INACTIVE state.
* `Aws\GuardDuty` - Updated API and data types descriptions for CreateFilter, UpdateFilter, and TriggerDetails.
* `Aws\IoTWireless` - In this release, we add additional capabilities for the FUOTA which allows user to configure the fragment size, the sending interval and the redundancy ratio of the FUOTA tasks
* `Aws\LocationService` - This release adds support for using Maps APIs with an API Key in addition to AWS Cognito. This includes support for adding, listing, updating and deleting API Keys.
* `Aws\Macie2` - This release adds support for a new finding type, Policy:IAMUser/S3BucketSharedWithCloudFront, and S3 bucket metadata that indicates if a bucket is shared with an Amazon CloudFront OAI or OAC.
* `Aws\ManagedGrafana` - Doc-only update. Updated information on attached role policies for customer provided roles
* `Aws\WAFV2` - You can now associate an AWS WAF v2 web ACL with an AWS App Runner service.

## 3.260.1 - 2023-02-22

* `Aws\ChimeSDKVoice` - This release introduces support for Voice Connector media metrics in the Amazon Chime SDK Voice namespace
* `Aws\CloudFront` - CloudFront now supports block lists in origin request policies so that you can forward all headers, cookies, or query string from viewer requests to the origin *except* for those specified in the block list.
* `Aws\CloudWatchRUM` - CloudWatch RUM now supports CloudWatch Custom Metrics
* `Aws\DataSync` - AWS DataSync has relaxed the minimum length constraint of AccessKey for Object Storage locations to 1.
* `Aws\OpenSearchService` - This release lets customers configure Off-peak window and software update related properties for a new/existing domain. It enhances the capabilities of StartServiceSoftwareUpdate API; adds 2 new APIs - ListScheduledActions & UpdateScheduledAction; and allows Auto-tune to make use of Off-peak window.
* `Aws\SSM` - Document only update for Feb 2023

## 3.260.0 - 2023-02-21

* `Aws\QuickSight` - S3 data sources now accept a custom IAM role.
* `Aws\ResilienceHub` - In this release we improved resilience hub application creation and maintenance by introducing new resource and app component crud APIs, improving visibility and maintenance of application input sources and added support for additional information attributes to be provided by customers.
* `Aws\SecurityHub` - Documentation updates for AWS Security Hub
* `Aws\Tnb` - This is the initial SDK release for AWS Telco Network Builder (TNB). AWS Telco Network Builder is a network automation service that helps you deploy and manage telecom networks.

## 3.259.1 - 2023-02-20

* `Aws\AuditManager` - This release introduces a ServiceQuotaExceededException to the UpdateAssessmentFrameworkShare API operation.
* `Aws\Connect` - Reasons for failed diff has been approved by SDK Reviewer

## 3.259.0 - 2023-02-17

* `Aws\` - Emit a warning to users on PHP versions 7.2.4 and below that we are ending support for this language version on 08/15/2023
* `Aws\AppRunner` - This release supports removing MaxSize limit for AutoScalingConfiguration.
* `Aws\Glue` - Release of Delta Lake Data Lake Format for Glue Studio Service

## 3.258.12 - 2023-02-16

* `Aws\EMR` - This release provides customers the ability to define a timeout period for procuring capacity during a resize operation for Instance Fleet clusters. Customers can specify this timeout using the ResizeSpecifications parameter supported by RunJobFlow, ModifyInstanceFleet and AddInstanceFleet APIs.
* `Aws\IVS` - Doc-only update. Updated text description in DeleteChannel, Stream, and StreamSummary.
* `Aws\ManagedGrafana` - With this release Amazon Managed Grafana now supports inbound Network Access Control that helps you to restrict user access to your Grafana workspaces
* `Aws\WAFV2` - Added a notice for account takeover prevention (ATP). The interface incorrectly lets you to configure ATP response inspection in regional web ACLs in Region US East (N. Virginia), without returning an error. ATP response inspection is only available in web ACLs that protect CloudFront distributions.

## 3.258.11 - 2023-02-15

* `Aws\CloudTrail` - This release adds an InsufficientEncryptionPolicyException type to the StartImport endpoint
* `Aws\EFS` - Documentation update for EFS to support IAM best practices.
* `Aws\FraudDetector` - This release introduces Lists feature which allows customers to reference a set of values in Fraud Detector's rules. With Lists, customers can dynamically manage these attributes in real time. Lists can be created/deleted and its contents can be modified using the Fraud Detector API.
* `Aws\Glue` - Fix DirectJDBCSource not showing up in CLI code gen
* `Aws\PrivateNetworks` - This release introduces a new StartNetworkResourceUpdate API, which enables return/replacement of hardware from a NetworkSite.
* `Aws\RDS` - Database Activity Stream support for RDS for SQL Server.
* `Aws\WAFV2` - For protected CloudFront distributions, you can now use the AWS WAF Fraud Control account takeover prevention (ATP) managed rule group to block new login attempts from clients that have recently submitted too many failed login attempts.

## 3.258.10 - 2023-02-14

* `Aws\` - Adds integ tests for CRT features.
* `Aws\AppConfig` - AWS AppConfig now offers the option to set a version label on hosted configuration versions. Version labels allow you to identify specific hosted configuration versions based on an alternate versioning scheme that you define.
* `Aws\DataSync` - With this launch, we are giving customers the ability to use older SMB protocol versions, enabling them to use DataSync to copy data to and from their legacy storage arrays.
* `Aws\EC2` - With this release customers can turn host maintenance on or off when allocating or modifying a supported dedicated host. Host maintenance is turned on by default for supported hosts.

## 3.258.9 - 2023-02-13

* `Aws\Account` - This release of the Account Management API enables customers to view and manage whether AWS Opt-In Regions are enabled or disabled for their Account. For more information, see https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-regions.html
* `Aws\AppConfigData` - AWS AppConfig now offers the option to set a version label on hosted configuration versions. If a labeled hosted configuration version is deployed, its version label is available in the GetLatestConfiguration response.
* `Aws\Snowball` - Adds support for EKS Anywhere on Snowball. AWS Snow Family customers can now install EKS Anywhere service on Snowball Edge Compute Optimized devices.

## 3.258.8 - 2023-02-10

* `Aws\AutoScaling` - You can now either terminate/replace, ignore, or wait for EC2 Auto Scaling instances on standby or protected from scale in. Also, you can also roll back changes from a failed instance refresh.
* `Aws\Connect` - This update provides the Wisdom session ARN for contacts enabled for Wisdom in the chat channel.
* `Aws\EC2` - Adds support for waiters that automatically poll for an imported snapshot until it reaches the completed state.
* `Aws\Polly` - Amazon Polly adds two new neural Japanese voices - Kazuha, Tomoko
* `Aws\SNS` - This release adds support for SNS X-Ray active tracing as well as other updates.
* `Aws\SageMaker` - Amazon SageMaker Autopilot adds support for selecting algorithms in CreateAutoMLJob API.

## 3.258.7 - 2023-02-09

* `Aws\ChimeSDKMeetings` - Documentation updates for Chime Meetings SDK
* `Aws\CloudWatchEvidently` - Updated entity overrides parameter to accept up to 2500 overrides or a total of 40KB.
* `Aws\EMRContainers` - EMR on EKS allows configuring retry policies for job runs through the StartJobRun API. Using retry policies, a job cause a driver pod to be restarted automatically if it fails or is deleted. The job's status can be seen in the DescribeJobRun and ListJobRun APIs and monitored using CloudWatch events.
* `Aws\LexModelsV2` - AWS Lex now supports Network of Bots.
* `Aws\LexRuntimeV2` - AWS Lex now supports Network of Bots.
* `Aws\Lightsail` - Documentation updates for Lightsail
* `Aws\MigrationHubRefactorSpaces` - This release adds support for creating environments with a network fabric type of NONE
* `Aws\WorkDocs` - Doc only update for the WorkDocs APIs.
* `Aws\WorkSpaces` - Removed Windows Server 2016 BYOL and made changes based on IAM campaign.

## 3.258.6 - 2023-02-08

* `Aws\Backup` - This release added one attribute (resource name) in the output model of our 9 existing APIs in AWS backup so that customers will see the resource name at the output. No input required from Customers.
* `Aws\CloudFront` - CloudFront Origin Access Control extends support to AWS Elemental MediaStore origins.
* `Aws\Glue` - DirectJDBCSource + Glue 4.0 streaming options
* `Aws\LakeFormation` - This release removes the LFTagpolicyResource expression limits.

## 3.258.5 - 2023-02-07

* `Aws\Transfer` - Updated the documentation for the ImportCertificate API call, and added examples.

## 3.258.4 - 2023-02-06

* `Aws\ComputeOptimizer` - AWS Compute optimizer can now infer if Kafka is running on an instance.
* `Aws\CustomerProfiles` - This release deprecates the PartyType and Gender enum data types from the Profile model and replaces them with new PartyTypeString and GenderString attributes, which accept any string of length up to 255.
* `Aws\FraudDetector` - My AWS Service (Amazon Fraud Detector) - This release introduces Cold Start Model Training which optimizes training for small datasets and adds intelligent methods for treating unlabeled data. You can now train Online Fraud Insights or Transaction Fraud Insights models with minimal historical-data.
* `Aws\MediaConvert` - The AWS Elemental MediaConvert SDK has added improved scene change detection capabilities and a bandwidth reduction filter, along with video quality enhancements, to the AVC encoder.
* `Aws\Outposts` - Adds OrderType to Order structure. Adds PreviousOrderId and PreviousLineItemId to LineItem structure. Adds new line item status REPLACED. Increases maximum length of pagination token.

## 3.258.3 - 2023-02-03

* `Aws\` - Increase the minimum required version of the CRT repo
* `Aws\Proton` - Add new GetResourcesSummary API
* `Aws\Redshift` - Corrects descriptions of the parameters for the API operations RestoreFromClusterSnapshot, RestoreTableFromClusterSnapshot, and CreateCluster.

## 3.258.2 - 2023-02-02

* `Aws\AppConfig` - AWS AppConfig introduces KMS customer-managed key (CMK) encryption of configuration data, along with AWS Secrets Manager as a new configuration data source. S3 objects using SSE-KMS encryption and SSM Parameter Store SecureStrings are also now supported.
* `Aws\CloudWatchLogs` - Fixed issue which caused an infinite loop during GetLogEvents auto-pagination
* `Aws\Connect` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\EC2` - Documentation updates for EC2.
* `Aws\ElasticLoadBalancingv2` - The GWLB Flex Health Check project updates the default values of healthy-threshold-count from 3 to 5 and unhealthy-threshold-count from 3 to 2
* `Aws\Keyspaces` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\QuickSight` - QuickSight support for Radar Chart and Dashboard Publish Options
* `Aws\Redshift` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\SSOAdmin` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.

## 3.258.1 - 2023-02-01

* `Aws\DevOpsGuru` - This release adds filter support ListAnomalyForInsight API.
* `Aws\ForecastService` - This release will enable customer select INCREMENTAL as ImportModel in Forecast's CreateDatasetImportJob API. Verified latest SDK containing required attribute, following https://w.amazon.com/bin/view/AWS-Seer/Launch/Trebuchet/
* `Aws\IAM` - Documentation updates for AWS Identity and Access Management (IAM).
* `Aws\MediaTailor` - The AWS Elemental MediaTailor SDK for Channel Assembly has added support for program updates, and the ability to clip the end of VOD sources in programs.
* `Aws\SNS` - Additional attributes added for set-topic-attributes.
* `Aws\SignatureProvider` - Fixes issue with selecting correct provider when sigv4a signing is specified.

## 3.258.0 - 2023-01-31

* `Aws\AccessAnalyzer` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\AppSync` - This release introduces the feature to support EventBridge as AppSync data source.
* `Aws\CloudTrail` - Add new "Channel" APIs to enable users to manage channels used for CloudTrail Lake integrations, and "Resource Policy" APIs to enable users to manage the resource-based permissions policy attached to a channel.
* `Aws\CloudTrailData` - Add CloudTrail Data Service to enable users to ingest activity events from non-AWS sources into CloudTrail Lake.
* `Aws\CodeArtifact` - This release introduces a new DeletePackage API, which enables deletion of a package and all of its versions from a repository.
* `Aws\ConnectParticipant` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\EC2` - This launch allows customers to associate up to 8 IP addresses to their NAT Gateways to increase the limit on concurrent connections to a single destination by eight times from 55K to 440K.
* `Aws\GroundStation` - DigIF Expansion changes to the Customer APIs.
* `Aws\IoT` - Added support for IoT Rules Engine Cloudwatch Logs action batch mode.
* `Aws\Kinesis` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\OpenSearchService` - Amazon OpenSearch Service adds the option for a VPC endpoint connection between two domains when the local domain uses OpenSearch version 1.3 or 2.3. You can now use remote reindex to copy indices from one VPC domain to another without a reverse proxy.
* `Aws\Outposts` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\Polly` - Amazon Polly adds two new neural American English voices - Ruth, Stephen
* `Aws\SageMaker` - Amazon SageMaker Automatic Model Tuning now supports more completion criteria for Hyperparameter Optimization.
* `Aws\SecurityHub` - New fields have been added to the AWS Security Finding Format. Compliance.SecurityControlId is a unique identifier for a security control across standards. Compliance.AssociatedStandards contains all enabled standards in which a security control is enabled.
* `Aws\Support` - This fixes incorrect endpoint construction when a customer is explicitly setting a region.

## 3.257.11 - 2023-01-30

* `Aws\ApplicationDiscoveryService` - Update ImportName validation to 255 from the current length of 100
* `Aws\CloudDirectory` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\CloudFormation` - This feature provides a method of obtaining which regions a stackset has stack instances deployed in.
* `Aws\DLM` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\EC2` - We add Prefix Lists as a new route destination option for LocalGatewayRoutes. This will allow customers to create routes to Prefix Lists. Prefix List routes will allow customers to group individual CIDR routes with the same target into a single route.
* `Aws\Kafka` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\MediaConvert` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\SWF` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\imagebuilder` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.

## 3.257.10 - 2023-01-27

* `Aws\` - Modernizes integ tests, removes integ test that relies on SigV2.
* `Aws\AppStream` - Fixing the issue where Appstream waiters hang for fleet_started and fleet_stopped.
* `Aws\ApplicationAutoScaling` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\ElasticBeanstalk` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\FIS` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\Glacier` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\Greengrass` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.
* `Aws\GreengrassV2` - Enabled FIPS endpoints for GovCloud (US) in SDK.
* `Aws\MediaTailor` - This release introduces the As Run logging type, along with API and documentation updates.
* `Aws\Outposts` - Adding support for payment term in GetOrder, CreateOrder responses.
* `Aws\SageMaker` - This release supports running SageMaker Training jobs with container images that are in a private Docker registry.
* `Aws\SageMakerRuntime` - Amazon SageMaker Runtime which supports InvokeEndpointAsync asynchronously can now invoke endpoints with custom timeout values. Asynchronous invocations support longer processing times.
* `Aws\ServerlessApplicationRepository` - Enabled FIPS endpoints for GovCloud (US) regions in SDK.

## 3.257.9 - 2023-01-26

* `Aws\` - Enables new SSO login format to be used by the SSO Credential provider
* `Aws\EventBridge` - Minor comments for Redshift Serverless workgroup target support.
* `Aws\IoTFleetWise` - Add model validation to BatchCreateVehicle and BatchUpdateVehicle operations that invalidate requests with an empty vehicles list.
* `Aws\S3` - Allow FIPS to be used with path-style URLs.

## 3.257.8 - 2023-01-25

* `Aws\CloudFormation` - Enabled FIPS aws-us-gov endpoints in SDK.
* `Aws\EC2` - This release adds new functionality that allows customers to provision IPv6 CIDR blocks through Amazon VPC IP Address Manager (IPAM) as well as allowing customers to utilize IPAM Resource Discovery APIs.
* `Aws\MainframeModernization` - Add returnCode, batchJobIdentifier in GetBatchJobExecution response, for user to view the batch job execution result & unique identifier from engine. Also removed unused headers from REST APIs
* `Aws\Polly` - Add 5 new neural voices - Sergio (es-ES), Andres (es-MX), Remi (fr-FR), Adriano (it-IT) and Thiago (pt-BR).
* `Aws\RedshiftServerless` - Added query monitoring rules as possible parameters for create and update workgroup operations.
* `Aws\S3Control` - Add additional endpoint tests for S3 Control. Fix missing endpoint parameters for PutBucketVersioning and GetBucketVersioning. Prior to this fix, those operations may have resulted in an invalid endpoint being resolved.
* `Aws\STS` - Doc only change to update wording in a key topic
* `Aws\SageMaker` - SageMaker Inference Recommender now decouples from Model Registry and could accept Model Name to invoke inference recommendations job; Inference Recommender now provides CPU/Memory Utilization metrics data in recommendation output.

## 3.257.7 - 2023-01-24

* `Aws\GlueDataBrew` - Enabled FIPS us-gov-west-1 endpoints in SDK.
* `Aws\Route53` - Amazon Route 53 now supports the Asia Pacific (Melbourne) Region (ap-southeast-4) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `Aws\SsmSap` - This release provides updates to documentation and support for listing operations performed by AWS Systems Manager for SAP.

## 3.257.6 - 2023-01-23

* `Aws\EndpointV2` - Test fixes related to signing, particularly sigv4a.
* `Aws\Lambda` - Release Lambda RuntimeManagementConfig, enabling customers to better manage runtime updates to their Lambda functions. This release adds two new APIs, GetRuntimeManagementConfig and PutRuntimeManagementConfig, as well as support on existing Create/Get/Update function APIs.
* `Aws\SageMaker` - Amazon SageMaker Inference now supports P4de instance types.

## 3.257.5 - 2023-01-20

* `Aws\EC2` - C6in, M6in, M6idn, R6in and R6idn instances are powered by 3rd Generation Intel Xeon Scalable processors (code named Ice Lake) with an all-core turbo frequency of 3.5 GHz.
* `Aws\IVS` - API and Doc update. Update to arns field in BatchGetStreamKey. Also updates to operations and structures.
* `Aws\QuickSight` - This release adds support for data bars in QuickSight table and increases pivot table field well limit.

## 3.257.4 - 2023-01-19

* `Aws\Appflow` - Adding support for Salesforce Pardot connector in Amazon AppFlow.
* `Aws\CloudWatchLogs` - Bug fix - Removed the regex pattern validation from CoralModel to avoid potential security issue.
* `Aws\CodeArtifact` - Documentation updates for CodeArtifact
* `Aws\Connect` - Amazon Connect Chat introduces Persistent Chat, allowing customers to resume previous conversations with context and transcripts carried over from previous chats, eliminating the need to repeat themselves and allowing agents to provide personalized service with access to entire conversation history.
* `Aws\ConnectParticipant` - This release updates Amazon Connect Participant's GetTranscript api to provide transcripts of past chats on a persistent chat session.
* `Aws\EC2` - Adds SSM Parameter Resource Aliasing support to EC2 Launch Templates. Launch Templates can now store parameter aliases in place of AMI Resource IDs. CreateLaunchTemplateVersion and DescribeLaunchTemplateVersions now support a convenience flag, ResolveAlias, to return the resolved parameter value.
* `Aws\Glue` - Release Glue Studio Hudi Data Lake Format for SDK/CLI
* `Aws\GroundStation` - Add configurable prepass and postpass times for DataflowEndpointGroup. Add Waiter to allow customers to wait for a contact that was reserved through ReserveContact
* `Aws\MediaLive` - AWS Elemental MediaLive adds support for SCTE 35 preRollMilliSeconds.
* `Aws\OpenSearchService` - This release adds the enhanced dry run option, that checks for validation errors that might occur when deploying configuration changes and provides a summary of these errors, if any. The feature will also indicate whether a blue/green deployment will be required to apply a change.
* `Aws\Panorama` - Added AllowMajorVersionUpdate option to OTAJobConfig to make appliance software major version updates opt-in.
* `Aws\SageMaker` - HyperParameterTuningJobs now allow passing environment variables into the corresponding TrainingJobs

## 3.257.3 - 2023-01-18

* `Aws\CloudWatch` - Enable cross-account streams in CloudWatch Metric Streams via Observability Access Manager.
* `Aws\EFS` - Documentation updates for EFS access points limit increase
* `Aws\WAFV2` - Improved the visibility of the guidance for updating AWS WAF resources, such as web ACLs and rule groups.
* `Aws\crypto` - Sets the default AAD to an empty string instead of null to silence deprecation warnings
* `Aws\ivschat` - Updates the range for a Chat Room's maximumMessageRatePerSecond field.

## 3.257.2 - 2023-01-17

* `Aws\BillingConductor` - This release adds support for SKU Scope for pricing plans.
* `Aws\Cloud9` - Added minimum value to AutomaticStopTimeMinutes parameter.
* `Aws\NetworkFirewall` - Network Firewall now allows creation of dual stack endpoints, enabling inspection of IPv6 traffic.
* `Aws\S3` - Updates to ContentMD5 api documentation.
* `Aws\imagebuilder` - Add support for AWS Marketplace product IDs as input during CreateImageRecipe for the parent-image parameter. Add support for listing third-party components.

## 3.257.1 - 2023-01-13

* `Aws\Connect` - This release updates the responses of UpdateContactFlowContent, UpdateContactFlowMetadata, UpdateContactFlowName and DeleteContactFlow API with empty responses.
* `Aws\EC2` - Documentation updates for EC2.
* `Aws\Outposts` - This release adds POWER_30_KVA as an option for PowerDrawKva. PowerDrawKva is part of the RackPhysicalProperties structure in the CreateSite request.
* `Aws\ResourceGroups` - AWS Resource Groups customers can now turn on Group Lifecycle Events in their AWS account. When you turn this on, Resource Groups monitors your groups for changes to group state or membership. Those changes are sent to Amazon EventBridge as events that you can respond to using rules you create.
* `Aws\S3` - Update to `bucket_endpoint` documentation

## 3.257.0 - 2023-01-12

* `Aws\Api` - Ensures query is separated by `/` when a request uri path is empty.
* `Aws\CleanRooms` - Initial release of AWS Clean Rooms
* `Aws\CloudWatchLogs` - Bug fix: logGroupName is now not a required field in GetLogEvents, FilterLogEvents, GetLogGroupFields, and DescribeLogStreams APIs as logGroupIdentifier can be provided instead
* `Aws\Lambda` - Add support for MaximumConcurrency parameter for SQS event source. Customers can now limit the maximum concurrent invocations for their SQS Event Source Mapping.
* `Aws\MediaConvert` - The AWS Elemental MediaConvert SDK has added support for compact DASH manifest generation, audio normalization using TruePeak measurements, and the ability to clip the sample range in the color corrector.
* `Aws\SecretsManager` - Update documentation for new ListSecrets and DescribeSecret parameters

## 3.256.2 - 2023-01-11

* `Aws\kendra` - This release adds support to new document types - RTF, XML, XSLT, MS_EXCEL, CSV, JSON, MD

## 3.256.1 - 2023-01-10

* `Aws\LocationService` - This release adds support for two new route travel models, Bicycle and Motorcycle which can be used with Grab data source.
* `Aws\RDS` - This release adds support for configuring allocated storage on the CreateDBInstanceReadReplica, RestoreDBInstanceFromDBSnapshot, and RestoreDBInstanceToPointInTime APIs.

## 3.256.0 - 2023-01-09

* `Aws\ECRPublic` - This release for Amazon ECR Public makes several change to bring the SDK into sync with the API.
* `Aws\KendraRanking` - Introducing Amazon Kendra Intelligent Ranking, a new set of Kendra APIs that leverages Kendra semantic ranking capabilities to improve the quality of search results from other search services (i.e. OpenSearch, ElasticSearch, Solr).
* `Aws\NetworkFirewall` - Network Firewall now supports the Suricata rule action reject, in addition to the actions pass, drop, and alert.
* `Aws\RAM` - Enabled FIPS aws-us-gov endpoints in SDK.
* `Aws\WorkSpacesWeb` - This release adds support for a new portal authentication type: AWS IAM Identity Center (successor to AWS Single Sign-On).

## 3.255.11 - 2023-01-06

* `Aws\ACMPCA` - Added revocation parameter validation: bucket names must match S3 bucket naming rules and CNAMEs conform to RFC2396 restrictions on the use of special characters in URIs.
* `Aws\AuditManager` - This release introduces a new data retention option in your Audit Manager settings. You can now use the DeregistrationPolicy parameter to specify if you want to delete your data when you deregister Audit Manager.

## 3.255.10 - 2023-01-05

* `Aws\AmplifyBackend` - Updated GetBackendAPIModels response to include ModelIntrospectionSchema json string
* `Aws\AppRunner` - This release adds support of securely referencing secrets and configuration data that are stored in Secrets Manager and SSM Parameter Store by adding them as environment secrets in your App Runner service.
* `Aws\Connect` - Documentation update for a new Initiation Method value in DescribeContact API
* `Aws\EMRServerless` - Adds support for customized images. You can now provide runtime images when creating or updating EMR Serverless Applications.
* `Aws\Lightsail` - Documentation updates for Amazon Lightsail.
* `Aws\MWAA` - MWAA supports Apache Airflow version 2.4.3.
* `Aws\RDS` - This release adds support for specifying which certificate authority (CA) to use for a DB instance's server certificate during DB instance creation, as well as other CA enhancements.

## 3.255.9 - 2023-01-04

* `Aws\ApplicationAutoScaling` - Customers can now use the existing DescribeScalingActivities API to also see the detailed and machine-readable reasons for Application Auto Scaling not scaling their resources and, if needed, take the necessary corrective actions.
* `Aws\CloudWatchLogs` - Update to remove sequenceToken as a required field in PutLogEvents calls.
* `Aws\SSM` - Adding support for QuickSetup Document Type in Systems Manager

## 3.255.8 - 2023-01-03

* `Aws\SecurityLake` - Allow CreateSubscriber API to take string input that allows setting more descriptive SubscriberDescription field. Make souceTypes field required in model level for UpdateSubscriberRequest as it is required for every API call on the backend. Allow ListSubscribers take any String as nextToken param.

## 3.255.7 - 2022-12-30

* `Aws\CloudFront` - Extend response headers policy to support removing headers from viewer responses
* `Aws\IoTFleetWise` - Update documentation - correct the epoch constant value of default value for expiryTime field in CreateCampaign request.

## 3.255.6 - 2022-12-29

* `Aws\APIGateway` - Documentation updates for Amazon API Gateway
* `Aws\ConnectWisdomService` - This release extends Wisdom CreateContent and StartContentUpload APIs to support PDF and MicrosoftWord docx document uploading.
* `Aws\EMR` - Added GetClusterSessionCredentials API to allow Amazon SageMaker Studio to connect to EMR on EC2 clusters with runtime roles and AWS Lake Formation-based access control for Apache Spark, Apache Hive, and Presto queries.
* `Aws\SecretsManager` - Added owning service filter, include planned deletion flag, and next rotation date response parameter in ListSecrets.

## 3.255.5 - 2022-12-28

* `Aws\ElastiCache` - This release allows you to modify the encryption in transit setting, for existing Redis clusters. You can now change the TLS configuration of your Redis clusters without the need to re-build or re-provision the clusters or impact application availability.
* `Aws\NetworkFirewall` - AWS Network Firewall now provides status messages for firewalls to help you troubleshoot when your endpoint fails.
* `Aws\RDS` - This release adds support for Custom Engine Version (CEV) on RDS Custom SQL Server.
* `Aws\Route53RecoveryControlConfig` - Added support for Python paginators in the route53-recovery-control-config List* APIs.

## 3.255.4 - 2022-12-27

* `Aws\MemoryDB` - This release adds support for MemoryDB Reserved nodes which provides a significant discount compared to on-demand node pricing. Reserved nodes are not physical nodes, but rather a billing discount applied to the use of on-demand nodes in your account.
* `Aws\Transfer` - Add additional operations to throw ThrottlingExceptions

## 3.255.3 - 2022-12-23

* `Aws\Connect` - Support for Routing Profile filter, SortCriteria, and grouping by Routing Profiles for GetCurrentMetricData API. Support for RoutingProfiles, UserHierarchyGroups, and Agents as filters, NextStatus and AgentStatusName for GetCurrentUserData. Adds ApproximateTotalCount to both APIs.
* `Aws\ConnectParticipant` - Amazon Connect Chat introduces the Message Receipts feature. This feature allows agents and customers to receive message delivered and read receipts after they send a chat message.
* `Aws\Detective` - This release adds a missed AccessDeniedException type to several endpoints.
* `Aws\FSx` - Fix a bug where a recent release might break certain existing SDKs.
* `Aws\Inspector2` - Amazon Inspector adds support for scanning NodeJS 18.x and Go 1.x AWS Lambda function runtimes.

## 3.255.2 - 2022-12-22

* `Aws\ComputeOptimizer` - This release enables AWS Compute Optimizer to analyze and generate optimization recommendations for ecs services running on Fargate.
* `Aws\Connect` - Amazon Connect Chat introduces the Idle Participant/Autodisconnect feature, which allows users to set timeouts relating to the activity of chat participants, using the new UpdateParticipantRoleConfig API.
* `Aws\IoTDeviceAdvisor` - This release adds the following new features: 1) Documentation updates for IoT Device Advisor APIs. 2) Updated required request parameters for IoT Device Advisor APIs. 3) Added new service feature: ability to provide the test endpoint when customer executing the StartSuiteRun API.
* `Aws\KinesisVideoWebRTCStorage` - Amazon Kinesis Video Streams offers capabilities to stream video and audio in real-time via WebRTC to the cloud for storage, playback, and analytical processing. Customers can use our enhanced WebRTC SDK and cloud APIs to enable real-time streaming, as well as media ingestion to the cloud.
* `Aws\RDS` - Add support for managing master user password in AWS Secrets Manager for the DBInstance and DBCluster.
* `Aws\SecretsManager` - Documentation updates for Secrets Manager
* `Aws\Signature` - Rollback MD5 breaking change

## 3.255.1 - 2022-12-22

* `Aws\Connect` - Amazon Connect Chat now allows for JSON (application/json) message types to be sent as part of the initial message in the StartChatContact API.
* `Aws\ConnectParticipant` - Amazon Connect Chat now allows for JSON (application/json) message types to be sent in the SendMessage API.
* `Aws\LicenseManagerLinuxSubscriptions` - AWS License Manager now offers cross-region, cross-account tracking of commercial Linux subscriptions on AWS. This includes subscriptions purchased as part of EC2 subscription-included AMIs, on the AWS Marketplace, or brought to AWS via Red Hat Cloud Access Program.
* `Aws\Macie2` - This release adds support for analyzing Amazon S3 objects that use the S3 Glacier Instant Retrieval (Glacier_IR) storage class.
* `Aws\S3` - Fixes bug where MD5 header is not added for PutObject and UploadPart
* `Aws\SSM` - Doc-only updates for December 2022.
* `Aws\SageMaker` - This release enables adding RStudio Workbench support to an existing Amazon SageMaker Studio domain. It allows setting your RStudio on SageMaker environment configuration parameters and also updating the RStudioConnectUrl and RStudioPackageManagerUrl parameters for existing domains
* `Aws\Scheduler` - Updated the ListSchedules and ListScheduleGroups APIs to allow the NamePrefix field to start with a number. Updated the validation for executionRole field to support any role name.
* `Aws\Support` - Documentation updates for the AWS Support API
* `Aws\Transfer` - This release adds support for Decrypt as a workflow step type.

## 3.254.1 - 2022-12-20

* `Aws\Batch` - Adds isCancelled and isTerminated to DescribeJobs response.
* `Aws\EC2` - Adds support for pagination in the EC2 DescribeImages API.
* `Aws\LookoutEquipment` - This release adds support for listing inference schedulers by status.
* `Aws\MediaLive` - This release adds support for two new features to AWS Elemental MediaLive. First, you can now burn-in timecodes to your MediaLive outputs. Second, we now now support the ability to decode Dolby E audio when it comes in on an input.
* `Aws\NimbleStudio` - Amazon Nimble Studio now supports configuring session storage volumes and persistence, as well as backup and restore sessions through launch profiles.
* `Aws\ResourceExplorer2` - Documentation updates for AWS Resource Explorer.
* `Aws\Route53Domains` - Use Route 53 domain APIs to change owner, create/delete DS record, modify IPS tag, resend authorization. New: AssociateDelegationSignerToDomain, DisassociateDelegationSignerFromDomain, PushDomain, ResendOperationAuthorization. Updated: UpdateDomainContact, ListOperations, CheckDomainTransferability.
* `Aws\SageMaker` - Amazon SageMaker Autopilot adds support for new objective metrics in CreateAutoMLJob API.
* `Aws\Signature` - Fix an issue where attempting to sign an invalid header in with SigV4a would cause a seg fault
* `Aws\TranscribeService` - Enable our batch transcription jobs for Swedish and Vietnamese.

## 3.254.0 - 2022-12-19

* `Aws\Athena` - Add missed InvalidRequestException in GetCalculationExecutionCode,StopCalculationExecution APIs. Correct required parameters (Payload and Type) in UpdateNotebook API. Change Notebook size from 15 Mb to 10 Mb.
* `Aws\ECS` - This release adds support for alarm-based rollbacks in ECS, a new feature that allows customers to add automated safeguards for Amazon ECS service rolling updates.
* `Aws\KinesisVideo` - Amazon Kinesis Video Streams offers capabilities to stream video and audio in real-time via WebRTC to the cloud for storage, playback, and analytical processing. Customers can use our enhanced WebRTC SDK and cloud APIs to enable real-time streaming, as well as media ingestion to the cloud.
* `Aws\KinesisVideoWebRTCStorage` - Amazon Kinesis Video Streams offers capabilities to stream video and audio in real-time via WebRTC to the cloud for storage, playback, and analytical processing. Customers can use our enhanced WebRTC SDK and cloud APIs to enable real-time streaming, as well as media ingestion to the cloud.
* `Aws\RDS` - Add support for --enable-customer-owned-ip to RDS create-db-instance-read-replica API for RDS on Outposts.
* `Aws\SageMaker` - AWS Sagemaker - Sagemaker Images now supports Aliases as secondary identifiers for ImageVersions. SageMaker Images now supports additional metadata for ImageVersions for better images management.

## 3.253.4 - 2022-12-16

* `Aws\Appflow` - This release updates the ListConnectorEntities API action so that it returns paginated responses that customers can retrieve with next tokens.
* `Aws\CloudFront` - Updated documentation for CloudFront
* `Aws\DataSync` - AWS DataSync now supports the use of tags with task executions. With this new feature, you can apply tags each time you execute a task, giving you greater control and management over your task executions.
* `Aws\EFS` - General documentation updates for EFS.
* `Aws\GuardDuty` - This release provides the valid characters for the Description and Name field.
* `Aws\IoTFleetWise` - Updated error handling for empty resource names in "UpdateSignalCatalog" and "GetModelManifest" operations.
* `Aws\S3` - Fixes issue with path-style endpoints which resulted in duplicated buckets in request uri path.
* `Aws\SageMaker` - AWS sagemaker - Features: This release adds support for random seed, it's an integer value used to initialize a pseudo-random number generator. Setting a random seed will allow the hyperparameter tuning search strategies to produce more consistent configurations for the same tuning job.

## 3.253.3 - 2022-12-15

* `Aws\BackupGateway` - This release adds support for VMware vSphere tags, enabling customer to protect VMware virtual machines using tag-based policies for AWS tags mapped from vSphere tags. This release also adds support for customer-accessible gateway-hypervisor interaction log and upload bandwidth rate limit schedule.
* `Aws\Connect` - Added support for "English - New Zealand" and "English - South African" to be used with Amazon Connect Custom Vocabulary APIs.
* `Aws\ECS` - This release adds support for container port ranges in ECS, a new capability that allows customers to provide container port ranges to simplify use cases where multiple ports are in use in a container. This release updates TaskDefinition mutation APIs and the Task description APIs.
* `Aws\EKS` - Add support for Windows managed nodes groups.
* `Aws\Glue` - This release adds support for AWS Glue Crawler with native DeltaLake tables, allowing Crawlers to classify Delta Lake format tables and catalog them for query engines to query against.
* `Aws\Kinesis` - Added StreamARN parameter for Kinesis Data Streams APIs. Added a new opaque pagination token for ListStreams. SDKs will auto-generate Account Endpoint when accessing Kinesis Data Streams.
* `Aws\LocationService` - This release adds support for a new style, "VectorOpenDataStandardLight" which can be used with the new data source, "Open Data Maps (Preview)".
* `Aws\MainframeModernization` - Adds an optional create-only `KmsKeyId` property to Environment and Application resources.
* `Aws\SageMaker` - SageMaker Inference Recommender now allows customers to load tests their models on various instance types using private VPC.
* `Aws\SecurityHub` - Added new resource details objects to ASFF, including resources for AwsEc2LaunchTemplate, AwsSageMakerNotebookInstance, AwsWafv2WebAcl and AwsWafv2RuleGroup.
* `Aws\Translate` - Raised the input byte size limit of the Text field in the TranslateText API to 10000 bytes.

## 3.253.2 - 2022-12-14

* `Aws\CloudWatch` - Adding support for Metrics Insights Alarms
* `Aws\CostExplorer` - This release supports percentage-based thresholds on Cost Anomaly Detection alert subscriptions.
* `Aws\NetworkManager` - Appliance Mode support for AWS Cloud WAN.
* `Aws\RedshiftDataAPIService` - This release adds a new --client-token field to ExecuteStatement and BatchExecuteStatement operations. Customers can now run queries with the additional client token parameter to ensures idempotency.
* `Aws\SageMakerMetrics` - Update SageMaker Metrics documentation.

## 3.253.1 - 2022-12-13

* `Aws\CloudTrail` - Merging mainline branch for service model into mainline release branch. There are no new APIs.
* `Aws\EndpointV2` - Fixes bug which allowed client-provided http schemes to be overwritten during endpoint resolution.
* `Aws\RDS` - This deployment adds ClientPasswordAuthType field to the Auth structure of the DBProxy.

## 3.253.0 - 2022-12-12

* `Aws\CustomerProfiles` - This release allows custom strings in PartyType and Gender through 2 new attributes in the CreateProfile and UpdateProfile APIs: PartyTypeString and GenderString.
* `Aws\EC2` - This release updates DescribeFpgaImages to show supported instance types of AFIs in its response.
* `Aws\EndpointV2` - Update to standard library ParseArn function.
* `Aws\KinesisVideo` - This release adds support for public preview of Kinesis Video Stream at Edge enabling customers to provide configuration for the Kinesis Video Stream EdgeAgent running on an on-premise IoT device. Customers can now locally record from cameras and stream videos to the cloud on configured schedule.
* `Aws\LookoutforVision` - This documentation update adds kms:GenerateDataKey as a required permission to StartModelPackagingJob.
* `Aws\MigrationHubRefactorSpaces` - This release adds support for Lambda alias service endpoints. Lambda alias ARNs can now be passed into CreateService.
* `Aws\RDS` - Update the RDS API model to support copying option groups during the CopyDBSnapshot operation
* `Aws\Rekognition` - Adds support for "aliases" and "categories", inclusion and exclusion filters for labels and label categories, and aggregating labels by video segment timestamps for Stored Video Label Detection APIs.
* `Aws\SageMakerMetrics` - This release introduces support SageMaker Metrics APIs.
* `Aws\WAFV2` - Documents the naming requirement for logging destinations that you use with web ACLs.

## 3.252.6 - 2022-12-09

* `Aws\CloudWatchLogs` - Doc-only update for CloudWatch Logs, for Tagging Permissions clarifications
* `Aws\IoTFleetWise` - Deprecated assignedValue property for actuators and attributes. Added a message to invalid nodes and invalid decoder manifest exceptions.
* `Aws\MediaLive` - Link devices now support buffer size (latency) configuration. A higher latency value means a longer delay in transmitting from the device to MediaLive, but improved resiliency. A lower latency value means a shorter delay, but less resiliency.
* `Aws\MediaPackageVod` - This release provides the approximate number of assets in a packaging group.

## 3.252.5 - 2022-12-08

* `Aws\AutoScaling` - Adds support for metric math for target tracking scaling policies, saving you the cost and effort of publishing a custom metric to CloudWatch. Also adds support for VPC Lattice by adding the Attach/Detach/DescribeTrafficSources APIs and a new health check type to the CreateAutoScalingGroup API.
* `Aws\IoTTwinMaker` - This release adds the following new features: 1) New APIs for managing a continuous sync of assets and asset models from AWS IoT SiteWise. 2) Support user friendly names for component types (ComponentTypeName) and properties (DisplayName).
* `Aws\MigrationHubStrategyRecommendations` - This release adds known application filtering, server selection for assessments, support for potential recommendations, and indications for configuration and assessment status. For more information, see the AWS Migration Hub documentation at https://docs.aws.amazon.com/migrationhub/index.html

## 3.252.4 - 2022-12-07

* `Aws\CloudFront` - Introducing UpdateDistributionWithStagingConfig that can be used to promote the staging configuration to the production.
* `Aws\CostExplorer` - This release adds the LinkedAccountName field to the GetAnomalies API response under RootCause
* `Aws\EKS` - Adds support for EKS add-ons configurationValues fields and DescribeAddonConfiguration function
* `Aws\EndpointDiscovery` - Re-enables endpoint discovery for services/operations that require it.
* `Aws\KMS` - Updated examples and exceptions for External Key Store (XKS).

## 3.252.3 - 2022-12-06

* `Aws\BillingConductor` - This release adds the Tiering Pricing Rule feature.
* `Aws\Connect` - This release provides APIs that enable you to programmatically manage rules for Contact Lens conversational analytics and third party applications. For more information, see https://docs.aws.amazon.com/connect/latest/APIReference/rules-api.html
* `Aws\DynamoDB` - Endpoint Ruleset update: Use http instead of https for the "local" region.
* `Aws\DynamoDBStreams` - Endpoint Ruleset update: Use http instead of https for the "local" region.
* `Aws\RDS` - This release adds the BlueGreenDeploymentNotFoundFault to the AddTagsToResource, ListTagsForResource, and RemoveTagsFromResource operations.
* `Aws\SageMakerFeatureStoreRuntime` - For online + offline Feature Groups, added ability to target PutRecord and DeleteRecord actions to only online store, or only offline store. If target store parameter is not specified, actions will apply to both stores.

## 3.252.2 - 2022-12-05

* `Aws\CostExplorer` - This release introduces two new APIs that offer a 1-click experience to refresh Savings Plans recommendations. The two APIs are StartSavingsPlansPurchaseRecommendationGeneration and ListSavingsPlansPurchaseRecommendationGeneration.
* `Aws\EC2` - Documentation updates for EC2.
* `Aws\RDS` - This release adds the InvalidDBInstanceStateFault to the RestoreDBClusterFromSnapshot operation.
* `Aws\TranscribeService` - Amazon Transcribe now supports creating custom language models in the following languages: Japanese (ja-JP) and German (de-DE).
* `Aws\ivschat` - Adds PendingVerification error type to messaging APIs to block the resource usage for accounts identified as being fraudulent.

## 3.252.1 - 2022-12-02

* `Aws\AppSync` - Fixes the URI for the evaluatecode endpoint to include the /v1 prefix (ie. "/v1/dataplane-evaluatecode").
* `Aws\ECS` - Documentation updates for Amazon ECS
* `Aws\FMS` - AWS Firewall Manager now supports Fortigate Cloud Native Firewall as a Service as a third-party policy type.
* `Aws\MediaConvert` - The AWS Elemental MediaConvert SDK has added support for configurable ID3 eMSG box attributes and the ability to signal them with InbandEventStream tags in DASH and CMAF outputs.
* `Aws\MediaLive` - Updates to Event Signaling and Management (ESAM) API and documentation.
* `Aws\Polly` - Add language code for Finnish (fi-FI)
* `Aws\Proton` - CreateEnvironmentAccountConnection RoleArn input is now optional
* `Aws\RedshiftServerless` - Add Table Level Restore operations for Amazon Redshift Serverless. Add multi-port support for Amazon Redshift Serverless endpoints. Add Tagging support to Snapshots and Recovery Points in Amazon Redshift Serverless.
* `Aws\SNS` - This release adds the message payload-filtering feature to the SNS Subscribe, SetSubscriptionAttributes, and GetSubscriptionAttributes API actions

## 3.252.0 - 2022-12-01

* `Aws\CodeCatalyst` - This release adds operations that support customers using the AWS Toolkits and Amazon CodeCatalyst, a unified software development service that helps developers develop, deploy, and maintain applications in the cloud. For more information, see the documentation.
* `Aws\Comprehend` - Comprehend now supports semi-structured documents (such as PDF files or image files) as inputs for custom analysis using the synchronous APIs (ClassifyDocument and DetectEntities).
* `Aws\GameLift` - GameLift introduces a new feature, GameLift Anywhere. GameLift Anywhere allows you to integrate your own compute resources with GameLift. You can also use GameLift Anywhere to iteratively test your game servers without uploading the build to GameLift for every iteration.
* `Aws\Pipes` - AWS introduces new Amazon EventBridge Pipes which allow you to connect sources (SQS, Kinesis, DDB, Kafka, MQ) to Targets (14+ EventBridge Targets) without any code, with filtering, batching, input transformation, and an optional Enrichment stage (Lambda, StepFunctions, ApiGateway, ApiDestinations)
* `Aws\SFN` - This release adds support for the AWS Step Functions Map state in Distributed mode. The changes include a new MapRun resource and several new and modified APIs.

## 3.251.0 - 2022-11-30

* `Aws\AccessAnalyzer` - This release adds support for S3 cross account access points. IAM Access Analyzer will now produce public or cross account findings when it detects bucket delegation to external account access points.
* `Aws\Athena` - This release includes support for using Apache Spark in Amazon Athena.
* `Aws\DataExchange` - This release enables data providers to license direct access to data in their Amazon S3 buckets or AWS Lake Formation data lakes through AWS Data Exchange. Subscribers get read-only access to the data and can use it in downstream AWS services, like Amazon Athena, without creating or managing copies.
* `Aws\DocDBElastic` - Launched Amazon DocumentDB Elastic Clusters. You can now use the SDK to create, list, update and delete Amazon DocumentDB Elastic Cluster resources
* `Aws\Glue` - This release adds support for AWS Glue Data Quality, which helps you evaluate and monitor the quality of your data and includes the API for creating, deleting, or updating data quality rulesets, runs and evaluations.
* `Aws\S3Control` - Amazon S3 now supports cross-account access points. S3 bucket owners can now allow trusted AWS accounts to create access points associated with their bucket.
* `Aws\SageMaker` - Added Models as part of the Search API. Added Model shadow deployments in realtime inference, and shadow testing in managed inference. Added support for shared spaces, geospatial APIs, Model Cards, AutoMLJobStep in pipelines, Git repositories on user profiles and domains, Model sharing in Jumpstart.
* `Aws\SageMakerGeospatial` - This release provides Amazon SageMaker geospatial APIs to build, train, deploy and visualize geospatial models.

## 3.250.0 - 2022-11-29

* `Aws\Credentials` - Emit warning rather than log error when extending IMDS credentials
* `Aws\EC2` - This release adds support for AWS Verified Access and the Hpc6id Amazon EC2 compute optimized instance type, which features 3rd generation Intel Xeon Scalable processors.
* `Aws\Firehose` - Allow support for the Serverless offering for Amazon OpenSearch Service as a Kinesis Data Firehose delivery destination.
* `Aws\KMS` - AWS KMS introduces the External Key Store (XKS), a new feature for customers who want to protect their data with encryption keys stored in an external key management system under their control.
* `Aws\Omics` - Amazon Omics is a new, purpose-built service that can be used by healthcare and life science organizations to store, query, and analyze omics data. The insights from that data can be used to accelerate scientific discoveries and improve healthcare.
* `Aws\OpenSearchServerless` - Publish SDK for Amazon OpenSearch Serverless
* `Aws\SecurityLake` - Amazon Security Lake automatically centralizes security data from cloud, on-premises, and custom sources into a purpose-built data lake stored in your account. Security Lake makes it easier to analyze security data, so you can improve the protection of your workloads, applications, and data
* `Aws\SimSpaceWeaver` - AWS SimSpace Weaver is a new service that helps customers build spatial simulations at new levels of scale - resulting in virtual worlds with millions of dynamic entities. See the AWS SimSpace Weaver developer guide for more details on how to get started. https://docs.aws.amazon.com/simspaceweaver

## 3.249.0 - 2022-11-29

* `Aws\ARCZonalShift` - Amazon Route 53 Application Recovery Controller Zonal Shift is a new service that makes it easy to shift traffic away from an Availability Zone in a Region. See the developer guide for more information: https://docs.aws.amazon.com/r53recovery/latest/dg/what-is-route53-recovery.html
* `Aws\ComputeOptimizer` - Adds support for a new recommendation preference that makes it possible for customers to optimize their EC2 recommendations by utilizing an external metrics ingestion service to provide metrics.
* `Aws\ConfigService` - With this release, you can use AWS Config to evaluate your resources for compliance with Config rules before they are created or updated. Using Config rules in proactive mode enables you to test and build compliant resource templates or check resource configurations at the time they are provisioned.
* `Aws\EC2` - Introduces ENA Express, which uses AWS SRD and dynamic routing to increase throughput and minimize latency, adds support for trust relationships between Reachability Analyzer and AWS Organizations to enable cross-account analysis, and adds support for Infrastructure Performance metric subscriptions.
* `Aws\EKS` - Adds support for additional EKS add-ons metadata and filtering fields
* `Aws\FSx` - This release adds support for 4GB/s / 160K PIOPS FSx for ONTAP file systems and 10GB/s / 350K PIOPS FSx for OpenZFS file systems (Single_AZ_2). For FSx for ONTAP, this also adds support for DP volumes, snapshot policy, copy tags to backups, and Multi-AZ route table updates.
* `Aws\Glue` - This release allows the creation of Custom Visual Transforms (Dynamic Transforms) to be created via AWS Glue CLI/SDK.
* `Aws\Inspector2` - This release adds support for Inspector to scan AWS Lambda.
* `Aws\Lambda` - Adds support for Lambda SnapStart, which helps improve the startup performance of functions. Customers can now manage SnapStart based functions via CreateFunction and UpdateFunctionConfiguration APIs
* `Aws\LicenseManagerUserSubscriptions` - AWS now offers fully-compliant, Amazon-provided licenses for Microsoft Office Professional Plus 2021 Amazon Machine Images (AMIs) on Amazon EC2. These AMIs are now available on the Amazon EC2 console and on AWS Marketplace to launch instances on-demand without any long-term licensing commitments.
* `Aws\Macie2` - Added support for configuring Macie to continually sample objects from S3 buckets and inspect them for sensitive data. Results appear in statistics, findings, and other data that Macie provides.
* `Aws\QuickSight` - This release adds new Describe APIs and updates Create and Update APIs to support the data model for Dashboards, Analyses, and Templates.
* `Aws\S3Control` - Added two new APIs to support Amazon S3 Multi-Region Access Point failover controls: GetMultiRegionAccessPointRoutes and SubmitMultiRegionAccessPointRoutes. The failover control APIs are supported in the following Regions: us-east-1, us-west-2, eu-west-1, ap-southeast-2, and ap-northeast-1.
* `Aws\SecurityHub` - Adding StandardsManagedBy field to DescribeStandards API response

## 3.248.0 - 2022-11-28

* `Aws\Backup` - AWS Backup introduces support for legal hold and application stack backups. AWS Backup Audit Manager introduces support for cross-Region, cross-account reports.
* `Aws\CloudWatch` - Adds cross-account support to the GetMetricData API. Adds cross-account support to the ListMetrics API through the usage of the IncludeLinkedAccounts flag and the new OwningAccounts field.
* `Aws\CloudWatchLogs` - Updates to support CloudWatch Logs data protection and CloudWatch cross-account observability
* `Aws\ECS` - This release adds support for ECS Service Connect, a new capability that simplifies writing and operating resilient distributed applications. This release updates the TaskDefinition, Cluster, Service mutation APIs with Service connect constructs and also adds a new ListServicesByNamespace API.
* `Aws\EFS` - This release adds elastic as a new ThroughputMode value for EFS file systems and adds AFTER_1_DAY as a value for TransitionToIARules.
* `Aws\IoT` - Job scheduling enables the scheduled rollout of a Job with start and end times and a customizable end behavior when end time is reached. This is available for continuous and snapshot jobs. Added support for MQTT5 properties to AWS IoT TopicRule Republish Action.
* `Aws\IoTDataPlane` - This release adds support for MQTT5 properties to AWS IoT HTTP Publish API.
* `Aws\IoTWireless` - This release includes a new feature for customers to calculate the position of their devices by adding three new APIs: UpdateResourcePosition, GetResourcePosition, and GetPositionEstimate.
* `Aws\OAM` - Amazon CloudWatch Observability Access Manager is a new service that allows configuration of the CloudWatch cross-account observability feature.
* `Aws\Organizations` - This release introduces delegated administrator for AWS Organizations, a new feature to help you delegate the management of your Organizations policies, enabling you to govern your AWS organization in a decentralized way. You can now allow member accounts to manage Organizations policies.
* `Aws\RDS` - This release enables new Aurora and RDS feature called Blue/Green Deployments that makes updates to databases safer, simpler and faster.
* `Aws\Textract` - This release adds support for classifying and splitting lending documents by type, and extracting information by using the Analyze Lending APIs. This release also includes support for summarized information of the processed lending document package, in addition to per document results.
* `Aws\TranscribeService` - This release adds support for 'inputType' for post-call and real-time (streaming) Call Analytics within Amazon Transcribe.
* `Aws\TranscribeStreaming` - This release adds support for real-time (streaming) and post-call Call Analytics within Amazon Transcribe.
* `Aws\drs` - Non breaking changes to existing APIs, and additional APIs added to support in-AWS failing back using AWS Elastic Disaster Recovery.
* `Aws\kendra` - Amazon Kendra now supports preview of table information from HTML tables in the search results. The most relevant cells with their corresponding rows, columns are displayed as a preview in the search result. The most relevant table cell or cells are also highlighted in table preview.
* `Aws\mgn` - This release adds support for Application and Wave management. We also now support custom post-launch actions.

## 3.247.2 - 2022-11-23

* `Aws\ManagedGrafana` - This release includes support for configuring a Grafana workspace to connect to a datasource within a VPC as well as new APIs for configuring Grafana settings.
* `Aws\RecycleBin` - This release adds support for Rule Lock for Recycle Bin, which allows you to lock retention rules so that they can no longer be modified or deleted.

## 3.247.1 - 2022-11-22

* `Aws\Appflow` - Adding support for Amazon AppFlow to transfer the data to Amazon Redshift databases through Amazon Redshift Data API service. This feature will support the Redshift destination connector on both public and private accessible Amazon Redshift Clusters and Amazon Redshift Serverless.
* `Aws\EndpointV2` - Fixes #2575
* `Aws\KinesisAnalyticsV2` - Support for Apache Flink 1.15 in Kinesis Data Analytics.

## 3.247.0 - 2022-11-21

* `Aws\` - Add support for PHP 8.2
* `Aws\EndpointV2` - Fixes #2572
* `Aws\Route53` - Amazon Route 53 now supports the Asia Pacific (Hyderabad) Region (ap-south-2) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.

## 3.246.0 - 2022-11-18

* `Aws\` - Removes SsmSap, which is to be re-released with an updated service id.
* `Aws\Appflow` - AppFlow provides a new API called UpdateConnectorRegistration to update a custom connector that customers have previously registered. With this API, customers no longer need to unregister and then register a connector to make an update.
* `Aws\AuditManager` - This release introduces a new feature for Audit Manager: Evidence finder. You can now use evidence finder to quickly query your evidence, and add the matching evidence results to an assessment report.
* `Aws\ChimeSDKVoice` - Amazon Chime Voice Connector, Voice Connector Group and PSTN Audio Service APIs are now available in the Amazon Chime SDK Voice namespace. See https://docs.aws.amazon.com/chime-sdk/latest/dg/sdk-available-regions.html for more details.
* `Aws\CloudFront` - CloudFront API support for staging distributions and associated traffic management policies.
* `Aws\Connect` - Added AllowedAccessControlTags and TagRestrictedResource for Tag Based Access Control on Amazon Connect Webpage
* `Aws\DynamoDB` - Updated minor fixes for DynamoDB documentation.
* `Aws\DynamoDBStreams` - Updated minor fixes for DynamoDB documentation.
* `Aws\EC2` - This release adds support for copying an Amazon Machine Image's tags when copying an AMI.
* `Aws\Glue` - AWSGlue Crawler - Adding support for Table and Column level Comments with database level datatypes for JDBC based crawler.
* `Aws\IoTRoboRunner` - AWS IoT RoboRunner is a new service that makes it easy to build applications that help multi-vendor robots work together seamlessly. See the IoT RoboRunner developer guide for more details on getting started. https://docs.aws.amazon.com/iotroborunner/latest/dev/iotroborunner-welcome.html
* `Aws\QuickSight` - This release adds the following: 1) Asset management for centralized assets governance 2) QuickSight Q now supports public embedding 3) New Termination protection flag to mitigate accidental deletes 4) Athena data sources now accept a custom IAM role 5) QuickSight supports connectivity to Databricks
* `Aws\SFN` - This release adds support for using Step Functions service integrations to invoke any cross-account AWS resource, even if that service doesn't support resource-based policies or cross-account calls. See https://docs.aws.amazon.com/step-functions/latest/dg/concepts-access-cross-acct-resources.html
* `Aws\SageMaker` - Added DisableProfiler flag as a new field in ProfilerConfig
* `Aws\ServiceCatalog` - This release 1. adds support for Principal Name Sharing with Service Catalog portfolio sharing. 2. Introduces repo sourced products which are created and managed with existing SC APIs. These products are synced to external repos and auto create new product versions based on changes in the repo.
* `Aws\SsmSap` - AWS Systems Manager for SAP provides simplified operations and management of SAP applications such as SAP HANA. With this release, SAP customers and partners can automate and simplify their SAP system administration tasks such as backup/restore of SAP HANA.
* `Aws\Transfer` - Adds a NONE encryption algorithm type to AS2 connectors, providing support for skipping encryption of the AS2 message body when a HTTPS URL is also specified.

## 3.245.1 - 2022-11-17

* `Aws\Amplify` - Adds a new value (WEB_COMPUTE) to the Platform enum that allows customers to create Amplify Apps with Server-Side Rendering support.
* `Aws\AppRegistry` - This release adds support for tagged resource associations, which allows you to associate a group of resources with a defined resource tag key and value to the application.
* `Aws\AppSync` - This release introduces the APPSYNC_JS runtime, and adds support for JavaScript in AppSync functions and AppSync pipeline resolvers.
* `Aws\Appflow` - AppFlow simplifies the preparation and cataloging of SaaS data into the AWS Glue Data Catalog where your data can be discovered and accessed by AWS analytics and ML services. AppFlow now also supports data field partitioning and file size optimization to improve query performance and reduce cost.
* `Aws\CloudWatchRUM` - CloudWatch RUM now supports custom events. To use custom events, create an app monitor or update an app monitor with CustomEvent Status as ENABLED.
* `Aws\DatabaseMigrationService` - Adds support for Internet Protocol Version 6 (IPv6) on DMS Replication Instances
* `Aws\EC2` - This release adds a new optional parameter "privateIpAddress" for the CreateNatGateway API. PrivateIPAddress will allow customers to select a custom Private IPv4 address instead of having it be auto-assigned.
* `Aws\EMRServerless` - Adds support for AWS Graviton2 based applications. You can now select CPU architecture when creating new applications or updating existing ones.
* `Aws\ElasticLoadBalancingv2` - Provides new target group attributes to turn on/off cross zone load balancing and configure target group health for Network Load Balancers and Application Load Balancers. Provides improvements to health check configuration for Network Load Balancers.
* `Aws\EndpointV2` - Adds error test cases for endpoint protocol tests.
* `Aws\Lambda` - Add Node 18 (nodejs18.x) support to AWS Lambda.
* `Aws\Personalize` - This release provides support for creation and use of metric attributions in AWS Personalize
* `Aws\Polly` - Add two new neural voices - Ola (pl-PL) and Hala (ar-AE).
* `Aws\S3Control` - Added 34 new S3 Storage Lens metrics to support additional customer use cases.
* `Aws\STS` - Documentation updates for AWS Security Token Service.
* `Aws\SecretsManager` - Documentation updates for Secrets Manager.
* `Aws\SecurityHub` - Added SourceLayerArn and SourceLayerHash field for security findings. Updated AwsLambdaFunction Resource detail
* `Aws\Textract` - This release adds support for specifying and extracting information from documents using the Signatures feature within Analyze Document API
* `Aws\Token` - Removes deprecated self callable from the TokenProvider
* `Aws\WorkSpaces` - The release introduces CreateStandbyWorkspaces, an API that allows you to create standby WorkSpaces associated with a primary WorkSpace in another Region. DescribeWorkspaces now includes related WorkSpaces properties. DescribeWorkspaceBundles and CreateWorkspaceBundle now return more bundle details.
* `Aws\ivschat` - Adds LoggingConfiguration APIs for IVS Chat - a feature that allows customers to store and record sent messages in a chat room to S3 buckets, CloudWatch logs, or Kinesis firehose.

## 3.245.0 - 2022-11-16

* `Aws\Batch` - Documentation updates related to Batch on EKS
* `Aws\BillingConductor` - This release adds a new feature BillingEntity pricing rule.
* `Aws\CloudFormation` - Added UnsupportedTarget HandlerErrorCode for use with CFN Resource Hooks
* `Aws\ComprehendMedical` - This release supports new set of entities and traits. It also adds new category (BEHAVIORAL_ENVIRONMENTAL_SOCIAL).
* `Aws\Connect` - This release adds a new MonitorContact API for initiating monitoring of ongoing Voice and Chat contacts.
* `Aws\EKS` - Adds support for customer-provided placement groups for Kubernetes control plane instances when creating local EKS clusters on Outposts
* `Aws\ElastiCache` - for Redis now supports AWS Identity and Access Management authentication access to Redis clusters starting with redis-engine version 7.0
* `Aws\IoTTwinMaker` - This release adds the following: 1) ExecuteQuery API allows users to query their AWS IoT TwinMaker Knowledge Graph 2) Pricing plan APIs allow users to configure and manage their pricing mode 3) Support for property groups and tabular property values in existing AWS IoT TwinMaker APIs.
* `Aws\PersonalizeEvents` - This release provides support for creation and use of metric attributions in AWS Personalize
* `Aws\Proton` - Add support for sorting and filtering in ListServiceInstances
* `Aws\RDS` - This release adds support for container databases (CDBs) to Amazon RDS Custom for Oracle. A CDB contains one PDB at creation. You can add more PDBs using Oracle SQL. You can also customize your database installation by setting the Oracle base, Oracle home, and the OS user name and group.
* `Aws\SSM` - This release adds support for cross account access in CreateOpsItem, UpdateOpsItem and GetOpsItem. It introduces new APIs to setup resource policies for SSM resources: PutResourcePolicy, GetResourcePolicies and DeleteResourcePolicy.
* `Aws\SSMIncidents` - Add support for PagerDuty integrations on ResponsePlan, IncidentRecord, and RelatedItem APIs
* `Aws\Token` - Adds the ability to authenticate requests through bearer tokens
* `Aws\Transfer` - Allow additional operations to throw ThrottlingException
* `Aws\XRay` - This release adds new APIs - PutResourcePolicy, DeleteResourcePolicy, ListResourcePolicies for supporting resource based policies for AWS X-Ray.

## 3.244.0 - 2022-11-15

* `Aws\Connect` - This release updates the APIs: UpdateInstanceAttribute, DescribeInstanceAttribute, and ListInstanceAttributes. You can use it to programmatically enable/disable enhanced contact monitoring using attribute type ENHANCED_CONTACT_MONITORING on the specified Amazon Connect instance.
* `Aws\EndpointV2` - Fixes #2558, #2559
* `Aws\GreengrassV2` - Adds new parent target ARN paramater to CreateDeployment, GetDeployment, and ListDeployments APIs for the new subdeployments feature.
* `Aws\Route53` - Amazon Route 53 now supports the Europe (Spain) Region (eu-south-2) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `Aws\WorkSpaces` - This release introduces ModifyCertificateBasedAuthProperties, a new API that allows control of certificate-based auth properties associated with a WorkSpaces directory. The DescribeWorkspaceDirectories API will now additionally return certificate-based auth properties in its responses.

## 3.243.1 - 2022-11-14

* `Aws\CustomerProfiles` - This release enhances the SearchProfiles API by providing functionality to search for profiles using multiple keys and logical operators.
* `Aws\LakeFormation` - This release adds a new parameter "Parameters" in the DataLakeSettings.
* `Aws\ManagedBlockchain` - Updating the API docs data type: NetworkEthereumAttributes, and the operations DeleteNode, and CreateNode to also include the supported Goerli network.
* `Aws\Proton` - Add support for CodeBuild Provisioning
* `Aws\RDS` - This release adds support for restoring an RDS Multi-AZ DB cluster snapshot to a Single-AZ deployment or a Multi-AZ DB instance deployment.
* `Aws\Sts` - Fixes a bug where incorrect regional endpoint settings are derived.
* `Aws\WorkDocs` - Added 2 new document related operations, DeleteDocumentVersion and RestoreDocumentVersions.
* `Aws\XRay` - This release enhances GetServiceGraph API to support new type of edge to represent links between SQS and Lambda in event-driven applications.

## 3.243.0 - 2022-11-14

* `Aws\CustomerProfiles` - This release enhances the SearchProfiles API by providing functionality to search for profiles using multiple keys and logical operators.
* `Aws\EndpointV2` - Adds new endpoint provider for the AWS SDKs Endpoints 2.0 initiative.
* `Aws\LakeFormation` - This release adds a new parameter "Parameters" in the DataLakeSettings.
* `Aws\ManagedBlockchain` - Updating the API docs data type: NetworkEthereumAttributes, and the operations DeleteNode, and CreateNode to also include the supported Goerli network.
* `Aws\Proton` - Add support for CodeBuild Provisioning
* `Aws\RDS` - This release adds support for restoring an RDS Multi-AZ DB cluster snapshot to a Single-AZ deployment or a Multi-AZ DB instance deployment.
* `Aws\WorkDocs` - Added 2 new document related operations, DeleteDocumentVersion and RestoreDocumentVersions.
* `Aws\XRay` - This release enhances GetServiceGraph API to support new type of edge to represent links between SQS and Lambda in event-driven applications.

## 3.242.1 - 2022-11-11

* `Aws\Glue` - Added links related to enabling job bookmarks.
* `Aws\IoT` - This release add new api listRelatedResourcesForAuditFinding and new member type IssuerCertificates for Iot device device defender Audit.
* `Aws\LicenseManager` - AWS License Manager now supports onboarded Management Accounts or Delegated Admins to view granted licenses aggregated from all accounts in the organization.
* `Aws\MarketplaceCatalog` - Added three new APIs to support tagging and tag-based authorization: TagResource, UntagResource, and ListTagsForResource. Added optional parameters to the StartChangeSet API to support tagging a resource while making a request to create it.
* `Aws\Rekognition` - Adding support for ImageProperties feature to detect dominant colors and image brightness, sharpness, and contrast, inclusion and exclusion filters for labels and label categories, new fields to the API response, "aliases" and "categories"
* `Aws\SSMIncidents` - RelatedItems now have an ID field which can be used for referencing them else where. Introducing event references in TimelineEvent API and increasing maximum length of "eventData" to 12K characters.
* `Aws\SecurityHub` - Documentation updates for Security Hub

## 3.242.0 - 2022-11-10

* `Aws\AutoScaling` - This release adds a new price capacity optimized allocation strategy for Spot Instances to help customers optimize provisioning of Spot Instances via EC2 Auto Scaling, EC2 Fleet, and Spot Fleet. It allocates Spot Instances based on both spare capacity availability and Spot Instance price.
* `Aws\EC2` - This release adds a new price capacity optimized allocation strategy for Spot Instances to help customers optimize provisioning of Spot Instances via EC2 Auto Scaling, EC2 Fleet, and Spot Fleet. It allocates Spot Instances based on both spare capacity availability and Spot Instance price.
* `Aws\ECS` - This release adds support for task scale-in protection with updateTaskProtection and getTaskProtection APIs. UpdateTaskProtection API can be used to protect a service managed task from being terminated by scale-in events and getTaskProtection API to get the scale-in protection status of a task.
* `Aws\ElasticsearchService` - Amazon OpenSearch Service now offers managed VPC endpoints to connect to your Amazon OpenSearch Service VPC-enabled domain in a Virtual Private Cloud (VPC). This feature allows you to privately access OpenSearch Service domain without using public IPs or requiring traffic to traverse the Internet.
* `Aws\ResourceExplorer2` - Text only updates to some Resource Explorer descriptions.
* `Aws\Scheduler` - AWS introduces the new Amazon EventBridge Scheduler. EventBridge Scheduler is a serverless scheduler that allows you to create, run, and manage tasks from one central, managed service.

## 3.241.1 - 2022-11-09

* `Aws\Connect` - This release adds new fields SignInUrl, UserArn, and UserId to GetFederationToken response payload.
* `Aws\ConnectCases` - This release adds the ability to disable templates through the UpdateTemplate API. Disabling templates prevents customers from creating cases using the template. For more information see https://docs.aws.amazon.com/cases/latest/APIReference/Welcome.html
* `Aws\EC2` - Amazon EC2 Trn1 instances, powered by AWS Trainium chips, are purpose built for high-performance deep learning training. u-24tb1.112xlarge and u-18tb1.112xlarge High Memory instances are purpose-built to run large in-memory databases.
* `Aws\GroundStation` - This release adds the preview of customer-provided ephemeris support for AWS Ground Station, allowing space vehicle owners to provide their own position and trajectory information for a satellite.
* `Aws\MediaPackageVod` - This release adds "IncludeIframeOnlyStream" for Dash endpoints.
* `Aws\TranscribeStreaming` - This will release hi-IN and th-TH

## 3.241.0 - 2022-11-08

* `Aws\ACM` - Support added for requesting elliptic curve certificate key algorithm types P-256 (EC_prime256v1) and P-384 (EC_secp384r1).
* `Aws\BillingConductor` - This release adds the Recurring Custom Line Item feature along with a new API ListCustomLineItemVersions.
* `Aws\EC2` - This release enables sharing of EC2 Placement Groups across accounts and within AWS Organizations using Resource Access Manager
* `Aws\FMS` - AWS Firewall Manager now supports importing existing AWS Network Firewall firewalls into Firewall Manager policies.
* `Aws\Lightsail` - This release adds support for Amazon Lightsail to automate the delegation of domains registered through Amazon Route 53 to Lightsail DNS management and to automate record creation for DNS validation of Lightsail SSL/TLS certificates.
* `Aws\OpenSearchService` - Amazon OpenSearch Service now offers managed VPC endpoints to connect to your Amazon OpenSearch Service VPC-enabled domain in a Virtual Private Cloud (VPC). This feature allows you to privately access OpenSearch Service domain without using public IPs or requiring traffic to traverse the Internet.
* `Aws\Polly` - Amazon Polly adds new voices: Elin (sv-SE), Ida (nb-NO), Laura (nl-NL) and Suvi (fi-FI). They are available as neural voices only.
* `Aws\ResourceExplorer2` - This is the initial SDK release for AWS Resource Explorer. AWS Resource Explorer lets your users search for and discover your AWS resources across the AWS Regions in your account.
* `Aws\Route53` - Amazon Route 53 now supports the Europe (Zurich) Region (eu-central-2) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.

## 3.240.11 - 2022-11-07

* `Aws\Athena` - Adds support for using Query Result Reuse
* `Aws\AutoScaling` - This release adds support for two new attributes for attribute-based instance type selection - NetworkBandwidthGbps and AllowedInstanceTypes.
* `Aws\CloudTrail` - This release includes support for configuring a delegated administrator to manage an AWS Organizations organization CloudTrail trails and event data stores, and AWS Key Management Service encryption of CloudTrail Lake event data stores.
* `Aws\EC2` - This release adds support for two new attributes for attribute-based instance type selection - NetworkBandwidthGbps and AllowedInstanceTypes.
* `Aws\ElastiCache` - Added support for IPv6 and dual stack for Memcached and Redis clusters. Customers can now launch new Redis and Memcached clusters with IPv6 and dual stack networking support.
* `Aws\LexModelsV2` - Amazon Lex now supports new APIs for viewing and editing Custom Vocabulary in bots.
* `Aws\MediaConvert` - The AWS Elemental MediaConvert SDK has added support for setting the SDR reference white point for HDR conversions and conversion of HDR10 to DolbyVision without mastering metadata.
* `Aws\SSM` - This release includes support for applying a CloudWatch alarm to multi account multi region Systems Manager Automation
* `Aws\WAFV2` - The geo match statement now adds labels for country and region. You can match requests at the region level by combining a geo match statement with label match statements.
* `Aws\WellArchitected` - This release adds support for integrations with AWS Trusted Advisor and AWS Service Catalog AppRegistry to improve workload discovery and speed up your workload reviews.
* `Aws\WorkSpaces` - This release adds protocols attribute to workspaces properties data type. This enables customers to migrate workspaces from PC over IP (PCoIP) to WorkSpaces Streaming Protocol (WSP) using create and modify workspaces public APIs.

## 3.240.10 - 2022-11-04

* `Aws\CloudWatchLogs` - Doc-only update for bug fixes and support of export to buckets encrypted with SSE-KMS
* `Aws\EC2` - This release adds API support for the recipient of an AMI account share to remove shared AMI launch permissions.
* `Aws\EMRContainers` - Adding support for Job templates. Job templates allow you to create and store templates to configure Spark applications parameters. This helps you ensure consistent settings across applications by reusing and enforcing configuration overrides in data pipelines.

## 3.240.9 - 2022-11-03

* `Aws\MemoryDB` - Adding support for r6gd instances for MemoryDB Redis with data tiering. In a cluster with data tiering enabled, when available memory capacity is exhausted, the least recently used data is automatically tiered to solid state drives for cost-effective capacity scaling with minimal performance impact.
* `Aws\SageMaker` - Amazon SageMaker now supports running training jobs on ml.trn1 instance types.

## 3.240.8 - 2022-11-02

* `Aws\IoTSiteWise` - This release adds the ListAssetModelProperties and ListAssetProperties APIs. You can list all properties that belong to a single asset model or asset using these two new APIs.
* `Aws\S3Control` - S3 on Outposts launches support for Lifecycle configuration for Outposts buckets. With S3 Lifecycle configuration, you can mange objects so they are stored cost effectively. You can manage objects using size-based rules and specify how many noncurrent versions bucket will retain.
* `Aws\SSMIncidents` - Adds support for tagging replication-set on creation.
* `Aws\SageMaker` - This release updates Framework model regex for ModelPackage to support new Framework version xgboost, sklearn.

## 3.240.7 - 2022-11-01

* `Aws\RDS` - Relational Database Service - This release adds support for configuring Storage Throughput on RDS database instances.
* `Aws\Textract` - Add ocr results in AnalyzeIDResponse as blocks

## 3.240.6 - 2022-10-31

* `Aws\AppRunner` - This release adds support for private App Runner services. Services may now be configured to be made private and only accessible from a VPC. The changes include a new VpcIngressConnection resource and several new and modified APIs.
* `Aws\CloudWatchLogs` - SDK release to support tagging for destinations and log groups with TagResource. Also supports tag on create with PutDestination.
* `Aws\Connect` - Amazon connect now support a new API DismissUserContact to dismiss or remove terminated contacts in Agent CCP
* `Aws\EC2` - Elastic IP transfer is a new Amazon VPC feature that allows you to transfer your Elastic IP addresses from one AWS Account to another.
* `Aws\IoT` - This release adds the Amazon Location action to IoT Rules Engine.
* `Aws\SESv2` - This release includes support for interacting with the Virtual Deliverability Manager, allowing you to opt in/out of the feature and to retrieve recommendations and metric data.
* `Aws\Textract` - This release introduces additional support for 30+ normalized fields such as vendor address and currency. It also includes OCR output in the response and accuracy improvements for the already supported fields in previous version

## 3.240.5 - 2022-10-28

* `Aws\AppRunner` - AWS App Runner adds .NET 6, Go 1, PHP 8.1 and Ruby 3.1 runtimes.
* `Aws\AppStream` - This release includes CertificateBasedAuthProperties in CreateDirectoryConfig and UpdateDirectoryConfig.
* `Aws\Cloud9` - Update to the documentation section of the Cloud9 API Reference guide.
* `Aws\CloudFormation` - This release adds more fields to improves visibility of AWS CloudFormation StackSets information in following APIs: ListStackInstances, DescribeStackInstance, ListStackSetOperationResults, ListStackSetOperations, DescribeStackSetOperation.
* `Aws\GameSparks` - Add LATEST as a possible GameSDK Version on snapshot
* `Aws\MediaTailor` - This release introduces support for SCTE-35 segmentation descriptor messages which can be sent within time signal messages.
* `Aws\PrivateNetworks` - Fix incorrect endpoint-prefix in endpoint ruleset.
* `Aws\SupportApp` - Fix incorrect endpoint-prefix in endpoint ruleset.

## 3.240.4 - 2022-10-27

* `Aws\EC2` - Feature supports the replacement of instance root volume using an updated AMI without requiring customers to stop their instance.
* `Aws\FMS` - Add support NetworkFirewall Managed Rule Group Override flag in GetViolationDetails API
* `Aws\Glue` - Added support for custom datatypes when using custom csv classifier.
* `Aws\Redshift` - This release clarifies use for the ElasticIp parameter of the CreateCluster and RestoreFromClusterSnapshot APIs.
* `Aws\SageMaker` - This change allows customers to provide a custom entrypoint script for the docker container to be run while executing training jobs, and provide custom arguments to the entrypoint script.
* `Aws\WAFV2` - This release adds the following: Challenge rule action, to silently verify client browsers; rule group rule action override to any valid rule action, not just Count; token sharing between protected applications for challenge/CAPTCHA token; targeted rules option for Bot Control managed rule group.

## 3.240.3 - 2022-10-26

* `Aws\IAM` - Doc only update that corrects instances of CLI not using an entity.
* `Aws\Kafka` - This release adds support for Tiered Storage. UpdateStorage allows you to control the Storage Mode for supported storage tiers.
* `Aws\Neptune` - Added a new cluster-level attribute to set the capacity range for Neptune Serverless instances.
* `Aws\SageMaker` - Amazon SageMaker Automatic Model Tuning now supports specifying Grid Search strategy for tuning jobs, which evaluates all hyperparameter combinations exhaustively based on the categorical hyperparameters provided.

## 3.240.2 - 2022-10-25

* `Aws\AccessAnalyzer` - This release adds support for six new resource types in IAM Access Analyzer to help you easily identify public and cross-account access to your AWS resources. Updated service API, documentation, and paginators.
* `Aws\LocationService` - Added new map styles with satellite imagery for map resources using HERE as a data provider.
* `Aws\MediaTailor` - This release is a documentation update
* `Aws\RDS` - Relational Database Service - This release adds support for exporting DB cluster data to Amazon S3.
* `Aws\WorkSpaces` - This release adds new enums for supporting Workspaces Core features, including creating Manual running mode workspaces, importing regular Workspaces Core images and importing g4dn Workspaces Core images.

## 3.240.1 - 2022-10-24

* `Aws\ACMPCA` - AWS Private Certificate Authority (AWS Private CA) now offers usage modes which are combination of features to address specific use cases.
* `Aws\Batch` - This release adds support for AWS Batch on Amazon EKS.
* `Aws\DataSync` - Added support for self-signed certificates when using object storage locations; added BytesCompressed to the TaskExecution response.
* `Aws\SageMaker` - SageMaker Inference Recommender now supports a new API ListInferenceRecommendationJobSteps to return the details of all the benchmark we create for an inference recommendation job.

## 3.240.0 - 2022-10-21

* `Aws\Aws` - Adds artifacts for endpoint resolution per the AWS Endpoints V2 initiative.
* `Aws\CognitoIdentityProvider` - This release adds a new "DeletionProtection" field to the UserPool in Cognito. Application admins can configure this value with either ACTIVE or INACTIVE value. Setting this field to ACTIVE will prevent a user pool from accidental deletion.
* `Aws\S3` - S3 on Outposts launches support for automatic bucket-style alias. You can use the automatic access point alias instead of an access point ARN for any object-level operation in an Outposts bucket.
* `Aws\SageMaker` - CreateInferenceRecommenderjob API now supports passing endpoint details directly, that will help customers to identify the max invocation and max latency they can achieve for their model and the associated endpoint along with getting recommendations on other instances.

## 3.239.2 - 2022-10-20

* `Aws\CloudWatchRUM` - CloudWatch RUM now supports Extended CloudWatch Metrics with Additional Dimensions
* `Aws\DevOpsGuru` - This release adds information about the resources DevOps Guru is analyzing.
* `Aws\GlobalAccelerator` - Global Accelerator now supports AddEndpoints and RemoveEndpoints operations for standard endpoint groups.
* `Aws\ResilienceHub` - In this release, we are introducing support for regional optimization for AWS Resilience Hub applications. It also includes a few documentation updates to improve clarity.

## 3.239.1 - 2022-10-19

* `Aws\ChimeSDKMessaging` - Documentation updates for Chime Messaging SDK
* `Aws\CloudTrail` - This release includes support for exporting CloudTrail Lake query results to an Amazon S3 bucket.
* `Aws\ConfigService` - This release adds resourceType enums for AppConfig, AppSync, DataSync, EC2, EKS, Glue, GuardDuty, SageMaker, ServiceDiscovery, SES, Route53 types.
* `Aws\Connect` - This release adds API support for managing phone numbers that can be used across multiple AWS regions through telephony traffic distribution.
* `Aws\EventBridge` - Updates internal logic for constructing API endpoints. We have added rule-based endpoints and internal model parameters.
* `Aws\ManagedBlockchain` - Adding new Accessor APIs for Amazon Managed Blockchain
* `Aws\S3` - Updates internal logic for constructing API endpoints. We have added rule-based endpoints and internal model parameters.
* `Aws\S3Control` - Updates internal logic for constructing API endpoints. We have added rule-based endpoints and internal model parameters.
* `Aws\SupportApp` - This release adds the RegisterSlackWorkspaceForOrganization API. You can use the API to register a Slack workspace for an AWS account that is part of an organization.
* `Aws\WorkSpacesWeb` - WorkSpaces Web now supports user access logging for recording session start, stop, and URL navigation.

## 3.239.0 - 2022-10-18

* `Aws\Api` - Parse json error code if it is present in HTTP response header
* `Aws\FraudDetector` - Documentation Updates for Amazon Fraud Detector
* `Aws\SESv2` - This release allows subscribers to enable Dedicated IPs (managed) to send email via a fully managed dedicated IP experience. It also adds identities' VerificationStatus in the response of GetEmailIdentity and ListEmailIdentities APIs, and ImportJobs counts in the response of ListImportJobs API.
* `Aws\SageMaker` - This change allows customers to enable data capturing while running a batch transform job, and configure monitoring schedule to monitoring the captured data.
* `Aws\ServiceDiscovery` - Updated the ListNamespaces API to support the NAME and HTTP_NAME filters, and the BEGINS_WITH filter condition.

## 3.238.6 - 2022-10-17

* `Aws\Greengrass` - This change allows customers to specify FunctionRuntimeOverride in FunctionDefinitionVersion. This configuration can be used if the runtime on the device is different from the AWS Lambda runtime specified for that function.
* `Aws\SageMaker` - This release adds support for C7g, C6g, C6gd, C6gn, M6g, M6gd, R6g, and R6gn Graviton instance types in Amazon SageMaker Inference.

## 3.238.5 - 2022-10-14

* `Aws\MediaConvert` - MediaConvert now supports specifying the minimum percentage of the HRD buffer available at the end of each encoded video segment.

## 3.238.4 - 2022-10-13

* `Aws\AmplifyUIBuilder` - We are releasing the ability for fields to be configured as arrays.
* `Aws\Appflow` - With this update, you can choose which Salesforce API is used by Amazon AppFlow to transfer data to or from your Salesforce account. You can choose the Salesforce REST API or Bulk API 2.0. You can also choose for Amazon AppFlow to pick the API automatically.
* `Aws\Connect` - This release adds support for a secondary email and a mobile number for Amazon Connect instance users.
* `Aws\ConnectWisdomService` - This release updates the GetRecommendations API to include a trigger event list for classifying and grouping recommendations.
* `Aws\DirectoryService` - This release adds support for describing and updating AWS Managed Microsoft AD set up.
* `Aws\ECS` - Documentation update to address tickets.
* `Aws\GuardDuty` - Add UnprocessedDataSources to CreateDetectorResponse which specifies the data sources that couldn't be enabled during the CreateDetector request. In addition, update documentations.
* `Aws\IAM` - Documentation updates for the AWS Identity and Access Management API Reference.
* `Aws\IoTFleetWise` - Documentation update for AWS IoT FleetWise
* `Aws\MediaLive` - AWS Elemental MediaLive now supports forwarding SCTE-35 messages through the Event Signaling and Management (ESAM) API, and can read those SCTE-35 messages from an inactive source.
* `Aws\MediaPackageVod` - This release adds SPEKE v2 support for MediaPackage VOD. Speke v2 is an upgrade to the existing SPEKE API to support multiple encryption keys, based on an encryption contract selected by the customer.
* `Aws\Panorama` - Pause and resume camera stream processing with SignalApplicationInstanceNodeInstances. Reboot an appliance with CreateJobForDevices. More application state information in DescribeApplicationInstance response.
* `Aws\RDSDataService` - Doc update to reflect no support for schema parameter on BatchExecuteStatement API
* `Aws\SSM` - Support of AmazonLinux2022 by Patch Manager
* `Aws\SSMIncidents` - Update RelatedItem enum to support Tasks
* `Aws\Transfer` - This release adds an option for customers to configure workflows that are triggered when files are only partially received from a client due to premature session disconnect.
* `Aws\Translate` - This release enables customers to specify multiple target languages in asynchronous batch translation requests.

## 3.238.3 - 2022-10-07

* `Aws\CodeGuruReviewer` - Documentation update to replace broken link.
* `Aws\ElasticLoadBalancingv2` - Gateway Load Balancer adds a new feature (target_failover) for customers to rebalance existing flows to a healthy target after marked unhealthy or deregistered. This allows graceful patching/upgrades of target appliances during maintenance windows, and helps reduce unhealthy target failover time.
* `Aws\GreengrassV2` - This release adds error status details for deployments and components that failed on a device and adds features to improve visibility into component installation.
* `Aws\QuickSight` - Amazon QuickSight now supports SecretsManager Secret ARN in place of CredentialPair for DataSource creation and update. This release also has some minor documentation updates and removes CountryCode as a required parameter in GeoSpatialColumnGroup

## 3.238.2 - 2022-10-06

* `Aws\ResilienceHub` - Documentation change for AWS Resilience Hub. Doc-only update to fix Documentation layout

## 3.238.1 - 2022-10-05

* `Aws\Glue` - This SDK release adds support to sync glue jobs with source control provider. Additionally, a new parameter called SourceControlDetails will be added to Job model.
* `Aws\NetworkFirewall` - StreamExceptionPolicy configures how AWS Network Firewall processes traffic when a network connection breaks midstream
* `Aws\Outposts` - This release adds the Asset state information to the ListAssets response. The ListAssets request supports filtering on Asset state.

## 3.238.0 - 2022-10-04

* `Aws\Connect` - Updated the CreateIntegrationAssociation API to support the CASES_DOMAIN IntegrationType.
* `Aws\ConnectCases` - This release adds APIs for Amazon Connect Cases. Cases allows your agents to quickly track and manage customer issues that require multiple interactions, follow-up tasks, and teams in your contact center. For more information, see https://docs.aws.amazon.com/cases/latest/APIReference/Welcome.html
* `Aws\EC2` - Added EnableNetworkAddressUsageMetrics flag for ModifyVpcAttribute, DescribeVpcAttribute APIs.
* `Aws\ECS` - Documentation updates to address various Amazon ECS tickets.
* `Aws\S3Control` - S3 Object Lambda adds support to allow customers to intercept HeadObject and ListObjects requests and introduce their own compute. These requests were previously proxied to S3.
* `Aws\WorkMail` - This release adds support for impersonation roles in Amazon WorkMail.

## 3.237.2 - 2022-10-03

* `Aws\AccessAnalyzer` - AWS IAM Access Analyzer policy validation introduces new checks for role trust policies. As customers author a policy, IAM Access Analyzer policy validation evaluates the policy for any issues to make it easier for customers to author secure policies.
* `Aws\EC2` - Adding an imdsSupport attribute to EC2 AMIs
* `Aws\Snowball` - Adds support for V3_5C. This is a refreshed AWS Snowball Edge Compute Optimized device type with 28TB SSD, 104 vCPU and 416GB memory (customer usable).

## 3.237.1 - 2022-09-30

* `Aws\CodeDeploy` - This release allows you to override the alarm configurations when creating a deployment.
* `Aws\DLM` - This release adds support for archival of single-volume snapshots created by Amazon Data Lifecycle Manager policies
* `Aws\DevOpsGuru` - This release adds filter feature on AddNotificationChannel API, enable customer to configure the SNS notification messages by Severity or MessageTypes
* `Aws\SSOOIDC` - Documentation updates for the IAM Identity Center OIDC CLI Reference.
* `Aws\SageMaker` - A new parameter called ExplainerConfig is added to CreateEndpointConfig API to enable SageMaker Clarify online explainability feature.
* `Aws\SageMakerRuntime` - A new parameter called EnableExplanations is added to InvokeEndpoint API to enable on-demand SageMaker Clarify online explainability requests.

## 3.237.0 - 2022-09-29

* `Aws\ACM` - This update returns additional certificate details such as certificate SANs and allows sorting in the ListCertificates API.
* `Aws\EC2` - u-3tb1 instances are powered by Intel Xeon Platinum 8176M (Skylake) processors and are purpose-built to run large in-memory databases.
* `Aws\EMRServerless` - This release adds API support to debug Amazon EMR Serverless jobs in real-time with live application UIs
* `Aws\FSx` - This release adds support for Amazon File Cache.
* `Aws\MigrationHubOrchestrator` - Introducing AWS MigrationHubOrchestrator. This is the first public release of AWS MigrationHubOrchestrator.
* `Aws\Polly` - Added support for the new Cantonese voice - Hiujin. Hiujin is available as a Neural voice only.
* `Aws\Proton` - This release adds an option to delete pipeline provisioning repositories using the UpdateAccountSettings API
* `Aws\SageMaker` - SageMaker Training Managed Warm Pools let you retain provisioned infrastructure to reduce latency for repetitive training workloads.
* `Aws\SecretsManager` - Documentation updates for Secrets Manager
* `Aws\Translate` - This release enables customers to access control rights on Translate resources like Parallel Data and Custom Terminology using Tag Based Authorization.
* `Aws\WorkSpaces` - This release includes diagnostic log uploading feature. If it is enabled, the log files of WorkSpaces Windows client will be sent to Amazon WorkSpaces automatically for troubleshooting. You can use modifyClientProperty api to enable/disable this feature.

## 3.236.1 - 2022-09-27

* `Aws\CostExplorer` - This release is to support retroactive Cost Categories. The new field will enable you to retroactively apply new and existing cost category rules to previous months.
* `Aws\LocationService` - This release adds place IDs, which are unique identifiers of places, along with a new GetPlace operation, which can be used with place IDs to find a place again later. UnitNumber and UnitType are also added as new properties of places.
* `Aws\kendra` - My AWS Service (placeholder) - Amazon Kendra now provides a data source connector for DropBox. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-dropbox.html

## 3.236.0 - 2022-09-26

* `Aws\CostandUsageReportService` - This release adds two new support regions(me-central-1/eu-south-2) for OSG.
* `Aws\IoTFleetWise` - General availability (GA) for AWS IoT Fleetwise. It adds AWS IoT Fleetwise to AWS SDK. For more information, see https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/Welcome.html.
* `Aws\SSM` - This release includes support for applying a CloudWatch alarm to Systems Manager capabilities like Automation, Run Command, State Manager, and Maintenance Windows.

## 3.235.15 - 2022-09-23

* `Aws\AppRunner` - AWS App Runner adds a Node.js 16 runtime.
* `Aws\EC2` - Letting external AWS customers provide ImageId as a Launch Template override in FleetLaunchTemplateOverridesRequest
* `Aws\LexModelsV2` - This release introduces additional optional parameters promptAttemptsSpecification to PromptSpecification, which enables the users to configure interrupt setting and Audio, DTMF and Text input configuration for the initial and retry prompt played by the Bot
* `Aws\Lightsail` - This release adds Instance Metadata Service (IMDS) support for Lightsail instances.
* `Aws\NimbleStudio` - Amazon Nimble Studio adds support for on-demand Amazon Elastic Compute Cloud (EC2) G3 and G5 instances, allowing customers to utilize additional GPU instance types for their creative projects.
* `Aws\SSM` - This release adds new SSM document types ConformancePackTemplate and CloudFormation
* `Aws\WAFV2` - Add the default specification for ResourceType in ListResourcesForWebACL.

## 3.235.14 - 2022-09-22

* `Aws\BackupGateway` - Changes include: new GetVirtualMachineApi to fetch a single user's VM, improving ListVirtualMachines to fetch filtered VMs as well as all VMs, and improving GetGatewayApi to now also return the gateway's MaintenanceStartTime.
* `Aws\DeviceFarm` - This release adds the support for VPC-ENI based connectivity for private devices on AWS Device Farm.
* `Aws\EC2` - Documentation updates for Amazon EC2.
* `Aws\Glue` - Added support for S3 Event Notifications for Catalog Target Crawlers.
* `Aws\IdentityStore` - Documentation updates for the Identity Store CLI Reference.

## 3.235.13 - 2022-09-21

* `Aws\Comprehend` - Amazon Comprehend now supports synchronous mode for targeted sentiment API operations.
* `Aws\S3Control` - S3 on Outposts launches support for object versioning for Outposts buckets. With S3 Versioning, you can preserve, retrieve, and restore every version of every object stored in your buckets. You can recover from both unintended user actions and application failures.
* `Aws\SageMaker` - SageMaker now allows customization on Canvas Application settings, including enabling/disabling time-series forecasting and specifying an Amazon Forecast execution role at both the Domain and UserProfile levels.

## 3.235.12 - 2022-09-20

* `Aws\EC2` - This release adds support for blocked paths to Amazon VPC Reachability Analyzer.

## 3.235.11 - 2022-09-19

* `Aws\CloudTrail` - This release includes support for importing existing trails into CloudTrail Lake.
* `Aws\EC2` - This release adds CapacityAllocations field to DescribeCapacityReservations
* `Aws\MediaConnect` - This change allows the customer to use the SRT Caller protocol as part of their flows
* `Aws\RDS` - This release adds support for Amazon RDS Proxy with SQL Server compatibility.

## 3.235.10 - 2022-09-16

* `Aws\CodeStarNotifications` - This release adds tag based access control for the UntagResource API.
* `Aws\ECS` - This release supports new task definition sizes.

## 3.235.9 - 2022-09-15

* `Aws\DynamoDB` - Increased DynamoDB transaction limit from 25 to 100.
* `Aws\EC2` - This feature allows customers to create tags for vpc-endpoint-connections and vpc-endpoint-service-permissions.
* `Aws\SageMaker` - Amazon SageMaker Automatic Model Tuning now supports specifying Hyperband strategy for tuning jobs, which uses a multi-fidelity based tuning strategy to stop underperforming hyperparameter configurations early.

## 3.235.8 - 2022-09-14

* `Aws\AmplifyUIBuilder` - Amplify Studio UIBuilder is introducing forms functionality. Forms can be configured from Data Store models, JSON, or from scratch. These forms can then be generated in your project and used like any other React components.
* `Aws\EC2` - This update introduces API operations to manage and create local gateway route tables, CoIP pools, and VIF group associations.

## 3.235.7 - 2022-09-13

* `Aws\` - Add support for php 8.0 and 8.1
* `Aws\CloudWatchEvidently` - This release adds support for the client-side evaluation - powered by AWS AppConfig feature.
* `Aws\CustomerProfiles` - Added isUnstructured in response for Customer Profiles Integration APIs
* `Aws\EC2` - Two new features for local gateway route tables: support for static routes targeting Elastic Network Interfaces and direct VPC routing.
* `Aws\Transfer` - This release introduces the ability to have multiple server host keys for any of your Transfer Family servers that use the SFTP protocol.
* `Aws\drs` - Fixed the data type of lagDuration that is returned in Describe Source Server API
* `Aws\kendra` - This release enables our customer to choose the option of Sharepoint 2019 for the on-premise Sharepoint connector.

## 3.235.6 - 2022-09-12

* `Aws\EKS` - Adding support for local Amazon EKS clusters on Outposts

## 3.235.5 - 2022-09-09

* `Aws\CloudTrail` - This release adds CloudTrail getChannel and listChannels APIs to allow customer to view the ServiceLinkedChannel configurations.
* `Aws\LexModelsV2` - This release is for supporting Composite Slot Type feature in AWS Lex V2. Composite Slot Type will help developer to logically group coherent slots and maintain their inter-relationships in runtime conversation.
* `Aws\LexRuntimeV2` - This release is for supporting Composite Slot Type feature in AWS Lex V2. Composite Slot Type will help developer to logically group coherent slots and maintain their inter-relationships in runtime conversation.
* `Aws\PI` - Increases the maximum values of two RDS Performance Insights APIs. The maximum value of the Limit parameter of DimensionGroup is 25. The MaxResult maximum is now 25 for the following APIs: DescribeDimensionKeys, GetResourceMetrics, ListAvailableResourceDimensions, and ListAvailableResourceMetrics.
* `Aws\Redshift` - This release updates documentation for AQUA features and other description updates.

## 3.235.4 - 2022-09-08

* `Aws\EC2` - This release adds support to send VPC Flow Logs to kinesis-data-firehose as new destination type
* `Aws\EMRContainers` - EMR on EKS now allows running Spark SQL using the newly introduced Spark SQL Job Driver in the Start Job Run API
* `Aws\LookoutMetrics` - Release dimension value filtering feature to allow customers to define dimension filters for including only a subset of their dataset to be used by LookoutMetrics.
* `Aws\MediaLive` - This change exposes API settings which allow Dolby Atmos and Dolby Vision to be used when running a channel using Elemental Media Live
* `Aws\Route53` - Amazon Route 53 now supports the Middle East (UAE) Region (me-central-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `Aws\SSM` - This release adds support for Systems Manager State Manager Association tagging.
* `Aws\SageMaker` - This release adds Mode to AutoMLJobConfig.

## 3.235.3 - 2022-09-07

* `Aws\DataExchange` - Documentation updates for AWS Data Exchange.
* `Aws\EC2` - Documentation updates for Amazon EC2.
* `Aws\EKS` - Adds support for EKS Addons ResolveConflicts "preserve" flag. Also adds new update failed status for EKS Addons.
* `Aws\FSx` - Documentation update for Amazon FSx.
* `Aws\Inspector2` - This release adds new fields like fixAvailable, fixedInVersion and remediation to the finding model. The requirement to have vulnerablePackages in the finding model has also been removed. The documentation has been updated to reflect these changes.
* `Aws\IoTSiteWise` - Allow specifying units in Asset Properties
* `Aws\SNS` - Amazon SNS introduces the Data Protection Policy APIs, which enable customers to attach a data protection policy to an SNS topic. This allows topic owners to enable the new message data protection feature to audit and block sensitive data that is exchanged through their topics.
* `Aws\SageMaker` - SageMaker Hosting now allows customization on ML instance storage volume size, model data download timeout and inference container startup ping health check timeout for each ProductionVariant in CreateEndpointConfig API.

## 3.235.2 - 2022-09-06

* `Aws\IdentityStore` - Documentation updates for the Identity Store CLI Reference.
* `Aws\SageMaker` - This release adds HyperParameterTuningJob type in Search API.

## 3.235.1 - 2022-09-02

* `Aws\CognitoIdentityProvider` - This release adds a new "AuthSessionValidity" field to the UserPoolClient in Cognito. Application admins can configure this value for their users' authentication duration, which is currently fixed at 3 minutes, up to 15 minutes. Setting this field will also apply to the SMS MFA authentication flow.
* `Aws\Connect` - This release adds search APIs for Routing Profiles and Queues, which can be used to search for those resources within a Connect Instance.
* `Aws\MediaPackage` - Added support for AES_CTR encryption to CMAF origin endpoints
* `Aws\SageMaker` - This release enables administrators to attribute user activity and API calls from Studio notebooks, Data Wrangler and Canvas to specific users even when users share the same execution IAM role. ExecutionRoleIdentityConfig at Sagemaker domain level enables this feature.
* `Aws\Signature` - The visibility of the SignatureV4::getHeaderBlacklist() method has been changed from private to protected to allow overriding the method in extending classes. By default this method prevents headers from being signed to avoid issues with signature mismatches when sending requests through proxies; however you may want to be able to force some headers to be signed for request integrity reasons.

## 3.235.0 - 2022-09-01

* `Aws\CodeGuruReviewer` - Documentation updates to fix formatting issues in CLI and SDK documentation.
* `Aws\ControlTower` - This release contains the first SDK for AWS Control Tower. It introduces a new set of APIs: EnableControl, DisableControl, GetControlOperation, and ListEnabledControls.
* `Aws\Route53` - Documentation updates for Amazon Route 53.

## 3.234.7 - 2022-08-31

* `Aws\CloudFront` - Update API documentation for CloudFront origin access control (OAC)
* `Aws\IVS` - IVS Merge Fragmented Streams. This release adds support for recordingReconnectWindow field in IVS recordingConfigurations. For more information see https://docs.aws.amazon.com/ivs/latest/APIReference/Welcome.html
* `Aws\IdentityStore` - Expand IdentityStore API to support Create, Read, Update, Delete and Get operations for User, Group and GroupMembership resources.
* `Aws\IoTThingsGraph` - This release deprecates all APIs of the ThingsGraph service
* `Aws\RDSDataService` - Documentation updates for RDS Data API
* `Aws\SageMaker` - SageMaker Inference Recommender now accepts Inference Recommender fields: Domain, Task, Framework, SamplePayloadUrl, SupportedContentTypes, SupportedInstanceTypes, directly in our CreateInferenceRecommendationsJob API through ContainerConfig

## 3.234.6 - 2022-08-30

* `Aws\GreengrassV2` - Adds topologyFilter to ListInstalledComponentsRequest which allows filtration of components by ROOT or ALL (including root and dependency components). Adds lastStatusChangeTimestamp to ListInstalledComponents response to show the last time a component changed state on a device.
* `Aws\IdentityStore` - Documentation updates for the Identity Store CLI Reference.
* `Aws\LookoutEquipment` - This release adds new apis for providing labels.
* `Aws\Macie2` - This release of the Amazon Macie API adds support for using allow lists to define specific text and text patterns to ignore when inspecting data sources for sensitive data.
* `Aws\SSO` - Documentation updates for the AWS IAM Identity Center Portal CLI Reference.
* `Aws\SSOAdmin` - Documentation updates for the AWS IAM Identity Center CLI Reference.

## 3.234.5 - 2022-08-29

* `Aws\FSx` - Documentation updates for Amazon FSx for NetApp ONTAP.
* `Aws\VoiceID` - Amazon Connect Voice ID now detects voice spoofing. When a prospective fraudster tries to spoof caller audio using audio playback or synthesized speech, Voice ID will return a risk score and outcome to indicate the how likely it is that the voice is spoofed.

## 3.234.4 - 2022-08-26

* `Aws\MediaPackage` - This release adds Ads AdTriggers and AdsOnDeliveryRestrictions to describe calls for CMAF endpoints on MediaPackage.
* `Aws\RDS` - Removes support for RDS Custom from DBInstanceClass in ModifyDBInstance

## 3.234.3 - 2022-08-25

* `Aws\ElasticLoadBalancingv2` - Documentation updates for ELBv2. Gateway Load Balancer now supports Configurable Flow Stickiness, enabling you to configure the hashing used to maintain stickiness of flows to a specific target appliance.
* `Aws\GameLift` - This release adds support for eight EC2 local zones as fleet locations; Atlanta, Chicago, Dallas, Denver, Houston, Kansas City (us-east-1-mci-1a), Los Angeles, and Phoenix. It also adds support for C5d, C6a, C6i, and R5d EC2 instance families.
* `Aws\IoTWireless` - This release includes a new feature for the customers to enable the LoRa gateways to send out beacons for Class B devices and an option to select one or more gateways for Class C devices when sending the LoRaWAN downlink messages.
* `Aws\Panorama` - Support sorting and filtering in ListDevices API, and add more fields to device listings and single device detail
* `Aws\SSOOIDC` - Updated required request parameters on IAM Identity Center's OIDC CreateToken action.
* `Aws\ivschat` - Documentation change for IVS Chat API Reference. Doc-only update to add a paragraph on ARNs to the Welcome section.

## 3.234.2 - 2022-08-24

* `Aws\CloudFront` - Adds support for CloudFront origin access control (OAC), making it possible to restrict public access to S3 bucket origins in all AWS Regions, those with SSE-KMS, and more.
* `Aws\ConfigService` - AWS Config now supports ConformancePackTemplate documents in SSM Docs for the deployment and update of conformance packs.
* `Aws\IAM` - Documentation updates for AWS Identity and Access Management (IAM).
* `Aws\IVS` - Documentation Change for IVS API Reference - Doc-only update to type field description for CreateChannel and UpdateChannel actions and for Channel data type. Also added Amazon Resource Names (ARNs) paragraph to Welcome section.
* `Aws\QuickSight` - Added a new optional property DashboardVisual under ExperienceConfiguration parameter of GenerateEmbedUrlForAnonymousUser and GenerateEmbedUrlForRegisteredUser API operations. This supports embedding of specific visuals in QuickSight dashboards.
* `Aws\Transfer` - Documentation updates for AWS Transfer Family

## 3.234.1 - 2022-08-23

* `Aws\RDS` - RDS for Oracle supports Oracle Data Guard switchover and read replica backups.
* `Aws\SSOAdmin` - Documentation updates to reflect service rename - AWS IAM Identity Center (successor to AWS Single Sign-On)

## 3.234.0 - 2022-08-22

* `Aws\DocDB` - Update document for volume clone
* `Aws\EC2` - R6a instances are powered by 3rd generation AMD EPYC (Milan) processors delivering all-core turbo frequency of 3.6 GHz. C6id, M6id, and R6id instances are powered by 3rd generation Intel Xeon Scalable processor (Ice Lake) delivering all-core turbo frequency of 3.5 GHz.
* `Aws\ForecastQueryService` - releasing What-If Analysis APIs
* `Aws\ForecastService` - releasing What-If Analysis APIs and update ARN regex pattern to be more strict in accordance with security recommendation
* `Aws\IoTSiteWise` - Enable non-unique asset names under different hierarchies
* `Aws\LexModelsV2` - This release introduces a new feature to stop a running BotRecommendation Job for Automated Chatbot Designer.
* `Aws\SecurityHub` - Added new resource details objects to ASFF, including resources for AwsBackupBackupVault, AwsBackupBackupPlan and AwsBackupRecoveryPoint. Added FixAvailable, FixedInVersion and Remediation to Vulnerability.
* `Aws\SupportApp` - This is the initial SDK release for the AWS Support App in Slack.

## 3.233.6 - 2022-08-19

* `Aws\Connect` - This release adds SearchSecurityProfiles API which can be used to search for Security Profile resources within a Connect Instance.
* `Aws\LookoutMetrics` - This release is to make GetDataQualityMetrics API publicly available.
* `Aws\ivschat` - Documentation Change for IVS Chat API Reference - Doc-only update to change text/description for tags field.
* `Aws\kendra` - This release adds support for a new authentication type - Personal Access Token (PAT) for confluence server.

## 3.233.5 - 2022-08-18

* `Aws\ChimeSDKMediaPipelines` - The Amazon Chime SDK now supports live streaming of real-time video from the Amazon Chime SDK sessions to streaming platforms such as Amazon IVS and Amazon Elemental MediaLive. We have also added support for concatenation to create a single media capture file.
* `Aws\CloudWatch` - Add support for managed Contributor Insights Rules
* `Aws\CognitoIdentityProvider` - This change is being made simply to fix the public documentation based on the models. We have included the PasswordChange and ResendCode events, along with the Pass, Fail and InProgress status. We have removed the Success and Failure status which are never returned by our APIs.
* `Aws\DynamoDB` - This release adds support for importing data from S3 into a new DynamoDB table
* `Aws\EC2` - This release adds support for VPN log options , a new feature allowing S2S VPN connections to send IKE activity logs to CloudWatch Logs
* `Aws\NetworkManager` - Add TransitGatewayPeeringAttachmentId property to TransitGatewayPeering Model

## 3.233.4 - 2022-08-17

* `Aws\AppMesh` - AWS App Mesh release to support Multiple Listener and Access Log Format feature
* `Aws\ConnectCampaignService` - Updated exceptions for Amazon Connect Outbound Campaign api's.
* `Aws\LakeFormation` - This release adds a new API support "AssumeDecoratedRoleWithSAML" and also release updates the corresponding documentation.
* `Aws\Lambda` - Added support for customization of Consumer Group ID for MSK and Kafka Event Source Mappings.
* `Aws\LexModelsV2` - This release introduces support for enhanced conversation design with the ability to define custom conversation flows with conditional branching and new bot responses.
* `Aws\RDS` - Adds support for Internet Protocol Version 6 (IPv6) for RDS Aurora database clusters.
* `Aws\SecretsManager` - Documentation updates for Secrets Manager.
* `Aws\kendra` - This release adds Zendesk connector (which allows you to specify Zendesk SAAS platform as data source), Proxy Support for Sharepoint and Confluence Server (which allows you to specify the proxy configuration if proxy is required to connect to your Sharepoint/Confluence Server as data source).

## 3.233.3 - 2022-08-16

* `Aws\Rekognition` - This release adds APIs which support copying an Amazon Rekognition Custom Labels model and managing project policies across AWS account.
* `Aws\ServiceCatalog` - Documentation updates for Service Catalog

## 3.233.2 - 2022-08-15

* `Aws\CloudFront` - Adds Http 3 support to distributions
* `Aws\ConnectWisdomService` - This release introduces a new API PutFeedback that allows submitting feedback to Wisdom on content relevance.
* `Aws\IdentityStore` - Documentation updates to reflect service rename - AWS IAM Identity Center (successor to AWS Single Sign-On)
* `Aws\SSO` - Documentation updates to reflect service rename - AWS IAM Identity Center (successor to AWS Single Sign-On)

## 3.233.1 - 2022-08-12

* `Aws\ChimeSDKMessaging` - The Amazon Chime SDK now supports channels with up to one million participants with elastic channels.
* `Aws\IVS` - Updates various list api MaxResults ranges
* `Aws\PersonalizeRuntime` - This release provides support for promotions in AWS Personalize runtime.
* `Aws\PrometheusService` - This release adds log APIs that allow customers to manage logging for their Amazon Managed Service for Prometheus workspaces.
* `Aws\RDS` - Adds support for RDS Custom to DBInstanceClass in ModifyDBInstance

## 3.233.0 - 2022-08-11

* `Aws\BackupStorage` - This is the first public release of AWS Backup Storage. We are exposing some previously-internal APIs for use by external services. These APIs are not meant to be used directly by customers.
* `Aws\Glue` - Add support for Python 3.9 AWS Glue Python Shell jobs
* `Aws\PrivateNetworks` - This is the initial SDK release for AWS Private 5G. AWS Private 5G is a managed service that makes it easy to deploy, operate, and scale your own private mobile network at your on-premises location.

## 3.232.5 - 2022-08-10

* `Aws\DLM` - This release adds support for excluding specific data (non-boot) volumes from multi-volume snapshot sets created by snapshot lifecycle policies
* `Aws\EC2` - This release adds support for excluding specific data (non-root) volumes from multi-volume snapshot sets created from instances.

## 3.232.4 - 2022-08-09

* `Aws\AugmentedAIRuntime` - Fix bug with parsing ISO-8601 CreationTime in Java SDK in DescribeHumanLoop
* `Aws\CloudWatch` - Various quota increases related to dimensions and custom metrics
* `Aws\LocationService` - Amazon Location Service now allows circular geofences in BatchPutGeofence, PutGeofence, and GetGeofence APIs.
* `Aws\SageMaker` - Amazon SageMaker Automatic Model Tuning now supports specifying multiple alternate EC2 instance types to make tuning jobs more robust when the preferred instance type is not available due to insufficient capacity.

## 3.232.3 - 2022-08-08

* `Aws\Glue` - Add an option to run non-urgent or non-time sensitive Glue Jobs on spare capacity
* `Aws\IdentityStore` - Documentation updates to reflect service rename - AWS IAM Identity Center (successor to AWS Single Sign-On)
* `Aws\IoTWireless` - AWS IoT Wireless release support for sidewalk data reliability.
* `Aws\Pinpoint` - Adds support for Advance Quiet Time in Journeys. Adds RefreshOnSegmentUpdate and WaitForQuietTime to JourneyResponse.
* `Aws\QuickSight` - A series of documentation updates to the QuickSight API reference.
* `Aws\SSO` - Documentation updates to reflect service rename - AWS IAM Identity Center (successor to AWS Single Sign-On)
* `Aws\SSOAdmin` - Documentation updates to reflect service rename - AWS IAM Identity Center (successor to AWS Single Sign-On)
* `Aws\SSOOIDC` - Documentation updates to reflect service rename - AWS IAM Identity Center (successor to AWS Single Sign-On)

## 3.232.2 - 2022-08-04

* `Aws\ChimeSDKMeetings` - Adds support for Tags on Amazon Chime SDK WebRTC sessions
* `Aws\ConfigService` - Add resourceType enums for Athena, GlobalAccelerator, Detective and EC2 types
* `Aws\DatabaseMigrationService` - Documentation updates for Database Migration Service (DMS).
* `Aws\IoT` - The release is to support attach a provisioning template to CACert for JITP function, Customer now doesn't have to hardcode a roleArn and templateBody during register a CACert to enable JITP.

## 3.232.1 - 2022-08-03

* `Aws\CognitoIdentityProvider` - Add a new exception type, ForbiddenException, that is returned when request is not allowed
* `Aws\WAFV2` - You can now associate an AWS WAF web ACL with an Amazon Cognito user pool.

## 3.232.0 - 2022-08-02

* `Aws\LicenseManagerUserSubscriptions` - This release supports user based subscription for Microsoft Visual Studio Professional and Enterprise on EC2.
* `Aws\Personalize` - This release adds support for incremental bulk ingestion for the Personalize CreateDatasetImportJob API.

## 3.231.18 - 2022-08-01

* `Aws\ConfigService` - Documentation update for PutConfigRule and PutOrganizationConfigRule
* `Aws\WorkSpaces` - This release introduces ModifySamlProperties, a new API that allows control of SAML properties associated with a WorkSpaces directory. The DescribeWorkspaceDirectories API will now additionally return SAML properties in its responses.

## 3.231.17 - 2022-07-29

* `Aws\EC2` - Documentation updates for Amazon EC2.
* `Aws\FSx` - Documentation updates for Amazon FSx
* `Aws\Shield` - AWS Shield Advanced now supports filtering for ListProtections and ListProtectionGroups.

## 3.231.16 - 2022-07-28

* `Aws\EC2` - Documentation updates for VM Import/Export.
* `Aws\ElasticsearchService` - This release adds support for gp3 EBS (Elastic Block Store) storage.
* `Aws\LookoutforVision` - This release introduces support for image segmentation models and updates CPU accelerator options for models hosted on edge devices.
* `Aws\OpenSearchService` - This release adds support for gp3 EBS (Elastic Block Store) storage.

## 3.231.15 - 2022-07-27

* `Aws\AuditManager` - This release adds an exceeded quota exception to several APIs. We added a ServiceQuotaExceededException for the following operations: CreateAssessment, CreateControl, CreateAssessmentFramework, and UpdateAssessmentStatus.
* `Aws\Chime` - Chime VoiceConnector will now support ValidateE911Address which will allow customers to prevalidate their addresses included in their SIP invites for emergency calling
* `Aws\ConfigService` - This release adds ListConformancePackComplianceScores API to support the new compliance score feature, which provides a percentage of the number of compliant rule-resource combinations in a conformance pack compared to the number of total possible rule-resource combinations in the conformance pack.
* `Aws\GlobalAccelerator` - Global Accelerator now supports dual-stack accelerators, enabling support for IPv4 and IPv6 traffic.
* `Aws\MarketplaceCatalog` - The SDK for the StartChangeSet API will now automatically set and use an idempotency token in the ClientRequestToken request parameter if the customer does not provide it.
* `Aws\Polly` - Amazon Polly adds new English and Hindi voice - Kajal. Kajal is available as Neural voice only.
* `Aws\S3` - Refactor of filepath resolution for S3 Transfer
* `Aws\SSM` - Adding doc updates for OpsCenter support in Service Setting actions.
* `Aws\WorkSpaces` - Added CreateWorkspaceImage API to create a new WorkSpace image from an existing WorkSpace.

## 3.231.14 - 2022-07-26

* `Aws\AppSync` - Adds support for a new API to evaluate mapping templates with mock data, allowing you to remotely unit test your AppSync resolvers and functions.
* `Aws\Detective` - Added the ability to get data source package information for the behavior graph. Graph administrators can now start (or stop) optional datasources on the behavior graph.
* `Aws\GuardDuty` - Amazon GuardDuty introduces a new Malware Protection feature that triggers malware scan on selected EC2 instance resources, after the service detects a potentially malicious activity.
* `Aws\LookoutforVision` - This release introduces support for the automatic scaling of inference units used by Amazon Lookout for Vision models.
* `Aws\Macie2` - This release adds support for retrieving (revealing) sample occurrences of sensitive data that Amazon Macie detects and reports in findings.
* `Aws\RDS` - Adds support for using RDS Proxies with RDS for MariaDB databases.
* `Aws\Rekognition` - This release introduces support for the automatic scaling of inference units used by Amazon Rekognition Custom Labels models.
* `Aws\SecurityHub` - Documentation updates for AWS Security Hub
* `Aws\Transfer` - AWS Transfer Family now supports Applicability Statement 2 (AS2), a network protocol used for the secure and reliable transfer of critical Business-to-Business (B2B) data over the public internet using HTTP/HTTPS as the transport mechanism.

## 3.231.13 - 2022-07-25

* `Aws\AutoScaling` - Documentation update for Amazon EC2 Auto Scaling.

## 3.231.12 - 2022-07-22

* `Aws\Account` - This release enables customers to manage the primary contact information for their AWS accounts. For more information, see https://docs.aws.amazon.com/accounts/latest/reference/API_Operations.html
* `Aws\EC2` - Added support for EC2 M1 Mac instances. For more information, please visit aws.amazon.com/mac.
* `Aws\IoTDeviceAdvisor` - Added new service feature (Early access only) - Long Duration Test, where customers can test the IoT device to observe how it behaves when the device is in operation for longer period.
* `Aws\MediaLive` - Link devices now support remote rebooting. Link devices now support maintenance windows. Maintenance windows allow a Link device to install software updates without stopping the MediaLive channel. The channel will experience a brief loss of input from the device while updates are installed.
* `Aws\RDS` - This release adds the "ModifyActivityStream" API with support for audit policy state locking and unlocking.
* `Aws\TranscribeService` - Remove unsupported language codes for StartTranscriptionJob and update VocabularyFileUri for UpdateMedicalVocabulary

## 3.231.11 - 2022-07-21

* `Aws\Athena` - This feature allows customers to retrieve runtime statistics for completed queries
* `Aws\CloudWatch` - Adding support for the suppression of Composite Alarm actions
* `Aws\Credentials` - fixes issue with attempt count when refreshing credentials
* `Aws\DatabaseMigrationService` - Documentation updates for Database Migration Service (DMS).
* `Aws\DocDB` - Enable copy-on-write restore type
* `Aws\EC2InstanceConnect` - This release includes a new exception type "EC2InstanceUnavailableException" for SendSSHPublicKey and SendSerialConsoleSSHPublicKey APIs.
* `Aws\FraudDetector` - The release introduces Account Takeover Insights (ATI) model. The ATI model detects fraud relating to account takeover. This release also adds support for new variable types: ARE_CREDENTIALS_VALID and SESSION_ID and adds new structures to Model Version APIs.
* `Aws\IoTSiteWise` - Added asynchronous API to ingest bulk historical and current data into IoT SiteWise.
* `Aws\NetworkFirewall` - Network Firewall now supports referencing dynamic IP sets from stateful rule groups, for IP sets stored in Amazon VPC prefix lists.
* `Aws\RDS` - Adds support for creating an RDS Proxy for an RDS for MariaDB database.
* `Aws\kendra` - Amazon Kendra now provides Oauth2 support for SharePoint Online. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html

## 3.231.10 - 2022-07-20

* `Aws\ACMPCA` - AWS Certificate Manager (ACM) Private Certificate Authority (PCA) documentation updates
* `Aws\IoT` - GA release the ability to enable/disable IoT Fleet Indexing for Device Defender and Named Shadow information, and search them through IoT Fleet Indexing APIs. This includes Named Shadow Selection as a part of the UpdateIndexingConfiguration API.

## 3.231.9 - 2022-07-19

* `Aws\DevOpsGuru` - Added new APIs for log anomaly detection feature.
* `Aws\Glue` - Documentation updates for AWS Glue Job Timeout and Autoscaling
* `Aws\SageMaker` - Fixed an issue with cross account QueryLineage
* `Aws\SagemakerEdgeManager` - Amazon SageMaker Edge Manager provides lightweight model deployment feature to deploy machine learning models on requested devices.
* `Aws\WorkSpaces` - Increased the character limit of the login message from 850 to 2000 characters.

## 3.231.8 - 2022-07-18

* `Aws\ApplicationDiscoveryService` - Add AWS Agentless Collector details to the GetDiscoverySummary API response
* `Aws\EC2` - Documentation updates for Amazon EC2.
* `Aws\ElastiCache` - Adding AutoMinorVersionUpgrade in the DescribeReplicationGroups API
* `Aws\KMS` - Added support for the SM2 KeySpec in China Partition Regions
* `Aws\MediaPackage` - This release adds "IncludeIframeOnlyStream" for Dash endpoints and increases the number of supported video and audio encryption presets for Speke v2
* `Aws\SSOAdmin` - AWS SSO now supports attaching customer managed policies and a permissions boundary to your permission sets. This release adds new API operations to manage and view the customer managed policies and the permissions boundary for a given permission set.
* `Aws\SageMaker` - Amazon SageMaker Edge Manager provides lightweight model deployment feature to deploy machine learning models on requested devices.

## 3.231.7 - 2022-07-15

* `Aws\CloudWatchEvidently` - This release adds support for the new segmentation feature.
* `Aws\DataSync` - Documentation updates for AWS DataSync regarding configuring Amazon FSx for ONTAP location security groups and SMB user permissions.
* `Aws\S3` - Fixed possible issue in TransferManager's downloadDirectory operation where files could be downloaded to some sibling directories of the destination directory if the key contained specially-crafted relative paths.
* `Aws\WAFV2` - This SDK release provide customers ability to add sensitivity level for WAF SQLI Match Statements.
* `Aws\drs` - Changed existing APIs to allow choosing a dynamic volume type for replicating volumes, to reduce costs for customers.

## 3.231.6 - 2022-07-14

* `Aws\Athena` - This release updates data types that contain either QueryExecutionId, NamedQueryId or ExpectedBucketOwner. Ids must be between 1 and 128 characters and contain only non-whitespace characters. ExpectedBucketOwner must be 12-digit string.
* `Aws\CodeArtifact` - This release introduces Package Origin Controls, a mechanism used to counteract Dependency Confusion attacks. Adds two new APIs, PutPackageOriginConfiguration and DescribePackage, and updates the ListPackage, DescribePackageVersion and ListPackageVersion APIs in support of the feature.
* `Aws\ConfigService` - Update ResourceType enum with values for Route53Resolver, Batch, DMS, Workspaces, Stepfunctions, SageMaker, ElasticLoadBalancingV2, MSK types
* `Aws\EC2` - This release adds flow logs for Transit Gateway to allow customers to gain deeper visibility and insights into network traffic through their Transit Gateways.
* `Aws\FMS` - Adds support for strict ordering in stateful rule groups in Network Firewall policies.
* `Aws\Glue` - This release adds an additional worker type for Glue Streaming jobs.
* `Aws\Inspector2` - This release adds support for Inspector V2 scan configurations through the get and update configuration APIs. Currently this allows configuring ECR automated re-scan duration to lifetime or 180 days or 30 days.
* `Aws\NimbleStudio` - Amazon Nimble Studio adds support for IAM-based access to AWS resources for Nimble Studio components and custom studio components. Studio Component scripts use these roles on Nimble Studio workstation to mount filesystems, access S3 buckets, or other configured resources in the Studio's AWS account
* `Aws\Outposts` - This release adds the ShipmentInformation and AssetInformationList fields to the GetOrder API response.
* `Aws\SageMaker` - This release adds support for G5, P4d, and C6i instance types in Amazon SageMaker Inference and increases the number of hyperparameters that can be searched from 20 to 30 in Amazon SageMaker Automatic Model Tuning
* `Aws\kendra` - This release adds AccessControlConfigurations which allow you to redefine your document level access control without the need for content re-indexing.

## 3.231.5 - 2022-07-13

* `Aws\AppConfig` - Adding Create, Get, Update, Delete, and List APIs for new two new resources: Extensions and ExtensionAssociations.

## 3.231.4 - 2022-07-12

* `Aws\NetworkManager` - This release adds general availability API support for AWS Cloud WAN.

## 3.231.3 - 2022-07-11

* `Aws\EC2` - Build, manage, and monitor a unified global network that connects resources running across your cloud and on-premises environments using the AWS Cloud WAN APIs.
* `Aws\Redshift` - This release adds a new --snapshot-arn field for describe-cluster-snapshots, describe-node-configuration-options, restore-from-cluster-snapshot, authorize-snapshot-acsess, and revoke-snapshot-acsess APIs. It allows customers to give a Redshift snapshot ARN or a Redshift Serverless ARN as input.
* `Aws\RedshiftServerless` - Removed prerelease language for GA launch.

## 3.231.2 - 2022-07-08

* `Aws\Backup` - This release adds support for authentication using IAM user identity instead of passed IAM role, identified by excluding the IamRoleArn field in the StartRestoreJob API. This feature applies to only resource clients with a destructive restore nature (e.g. SAP HANA).

## 3.231.1 - 2022-07-07

* `Aws\ChimeSDKMeetings` - Adds support for AppKeys and TenantIds in Amazon Chime SDK WebRTC sessions
* `Aws\DatabaseMigrationService` - New api to migrate event subscriptions to event bridge rules
* `Aws\IoT` - This release adds support to register a CA certificate without having to provide a verification certificate. This also allows multiple AWS accounts to register the same CA in the same region.
* `Aws\IoTWireless` - Adds 5 APIs: PutPositionConfiguration, GetPositionConfiguration, ListPositionConfigurations, UpdatePosition, GetPosition for the new Positioning Service feature which enables customers to configure solvers to calculate position of LoRaWAN devices, or specify position of LoRaWAN devices & gateways.
* `Aws\SageMaker` - Heterogeneous clusters: the ability to launch training jobs with multiple instance types. This enables running component of the training job on the instance type that is most suitable for it. e.g. doing data processing and augmentation on CPU instances and neural network training on GPU instances

## 3.231.0 - 2022-07-06

* `Aws\CloudFormation` - My AWS Service (placeholder) - Add a new feature Account-level Targeting for StackSet operation
* `Aws\Script` - Support for removing unused AWS services via Composer.
* `Aws\Synthetics` - This release introduces Group feature, which enables users to group cross-region canaries.

## 3.230.0 - 2022-07-05

* `Aws\ConfigService` - Updating documentation service limits
* `Aws\LexModelsV2` - This release introduces additional optional parameters "messageSelectionStrategy" to PromptSpecification, which enables the users to configure the bot to play messages in orderly manner.
* `Aws\QuickSight` - This release allows customers to programmatically create QuickSight accounts with Enterprise and Enterprise + Q editions. It also releases allowlisting domains for embedding QuickSight dashboards at runtime through the embedding APIs.
* `Aws\RDS` - Adds waiters support for DBCluster.
* `Aws\RolesAnywhere` - IAM Roles Anywhere allows your workloads such as servers, containers, and applications to obtain temporary AWS credentials and use the same IAM roles and policies that you have configured for your AWS workloads to access AWS resources.
* `Aws\SSMIncidents` - Adds support for tagging incident-record on creation by providing incident tags in the template within a response-plan.

## 3.229.2 - 2022-07-01

* `Aws\` - Change service namespace generation to use the service id instead of service full name for parity across SDKs
* `Aws\DatabaseMigrationService` - Added new features for AWS DMS version 3.4.7 that includes new endpoint settings for S3, OpenSearch, Postgres, SQLServer and Oracle.
* `Aws\RDS` - Adds support for additional retention periods to Performance Insights.

## 3.229.1 - 2022-06-30

* `Aws\Athena` - This feature introduces the API support for Athena's parameterized query and BatchGetPreparedStatement API.
* `Aws\CustomerProfiles` - This release adds the optional MinAllowedConfidenceScoreForMerging parameter to the CreateDomain, UpdateDomain, and GetAutoMergingPreview APIs in Customer Profiles. This parameter is used as a threshold to influence the profile auto-merging step of the Identity Resolution process.
* `Aws\EMR` - This release adds support for the ExecutionRoleArn parameter in the AddJobFlowSteps and DescribeStep APIs. Customers can use ExecutionRoleArn to specify the IAM role used for each job they submit using the AddJobFlowSteps API.
* `Aws\Glue` - This release adds tag as an input of CreateDatabase
* `Aws\MWAA` - Documentation updates for Amazon Managed Workflows for Apache Airflow.
* `Aws\Pricing` - Documentation update for GetProducts Response.
* `Aws\WellArchitected` - Added support for UpdateGlobalSettings API. Added status filter to ListWorkloadShares and ListLensShares.
* `Aws\WorkMail` - This release adds support for managing user availability configurations in Amazon WorkMail.
* `Aws\kendra` - Amazon Kendra now provides a data source connector for alfresco

## 3.229.0 - 2022-06-29

* `Aws\AppStream` - Includes support for StreamingExperienceSettings in CreateStack and UpdateStack APIs
* `Aws\EMR` - This release introduces additional optional parameter "Throughput" to VolumeSpecification to enable user to configure throughput for gp3 ebs volumes.
* `Aws\ElasticLoadBalancingv2` - This release adds two attributes for ALB. One, helps to preserve the host header and the other helps to modify, preserve, or remove the X-Forwarded-For header in the HTTP request.
* `Aws\MediaLive` - This release adds support for automatic renewal of MediaLive reservations at the end of each reservation term. Automatic renewal is optional. This release also adds support for labelling accessibility-focused audio and caption tracks in HLS outputs.
* `Aws\RedshiftServerless` - Add new API operations for Amazon Redshift Serverless, a new way of using Amazon Redshift without needing to manually manage provisioned clusters. The new operations let you interact with Redshift Serverless resources, such as create snapshots, list VPC endpoints, delete resource policies, and more.
* `Aws\SageMaker` - This release adds: UpdateFeatureGroup, UpdateFeatureMetadata, DescribeFeatureMetadata APIs; FeatureMetadata type in Search API; LastModifiedTime, LastUpdateStatus, OnlineStoreTotalSizeBytes in DescribeFeatureGroup API.
* `Aws\Translate` - Added ListLanguages API which can be used to list the languages supported by Translate.

## 3.228.5 - 2022-06-28

* `Aws\DataSync` - AWS DataSync now supports Amazon FSx for NetApp ONTAP locations.
* `Aws\EC2` - This release adds a new spread placement group to EC2 Placement Groups: host level spread, which spread instances between physical hosts, available to Outpost customers only. CreatePlacementGroup and DescribePlacementGroups APIs were updated with a new parameter: SpreadLevel to support this feature.
* `Aws\FinSpaceData` - Release new API GetExternalDataViewAccessDetails
* `Aws\Polly` - Add 4 new neural voices - Pedro (es-US), Liam (fr-CA), Daniel (de-DE) and Arthur (en-GB).

## 3.228.4 - 2022-06-27

* `Aws\IoT` - This release ease the restriction for the input of tag value to align with AWS standard, now instead of min length 1, we change it to min length 0.

## 3.228.3 - 2022-06-24

* `Aws\Glue` - This release enables the new ListCrawls API for viewing the AWS Glue Crawler run history.
* `Aws\RDSDataService` - Documentation updates for RDS Data API

## 3.228.2 - 2022-06-23

* `Aws\Guzzle` - Bump Guzzle versions to address CVE-2022-31090 and CVE-2022-31091
* `Aws\LookoutEquipment` - This release adds visualizations to the scheduled inference results. Users will be able to see interference results, including diagnostic results from their running inference schedulers.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has released support for automatic DolbyVision metadata generation when converting HDR10 to DolbyVision.
* `Aws\MigrationHubRefactorSpaces` - This release adds the new API UpdateRoute that allows route to be updated to ACTIVE/INACTIVE state. In addition, CreateRoute API will now allow users to create route in ACTIVE/INACTIVE state.
* `Aws\SageMaker` - SageMaker Ground Truth now supports Virtual Private Cloud. Customers can launch labeling jobs and access to their private workforce in VPC mode.
* `Aws\mgn` - New and modified APIs for the Post-Migration Framework

## 3.228.1 - 2022-06-22

* `Aws\APIGateway` - Documentation updates for Amazon API Gateway
* `Aws\Pricing` - This release introduces 1 update to the GetProducts API. The serviceCode attribute is now required when you use the GetProductsRequest.
* `Aws\Transfer` - Until today, the service supported only RSA host keys and user keys. Now with this launch, Transfer Family has expanded the support for ECDSA and ED25519 host keys and user keys, enabling customers to support a broader set of clients by choosing RSA, ECDSA, and ED25519 host and user keys.

## 3.228.0 - 2022-06-21

* `Aws\EC2` - This release adds support for Private IP VPNs, a new feature allowing S2S VPN connections to use private ip addresses as the tunnel outside ip address over Direct Connect as transport.
* `Aws\ECS` - Amazon ECS UpdateService now supports the following parameters: PlacementStrategies, PlacementConstraints and CapacityProviderStrategy.
* `Aws\S3` - Adds support for new object and bucket existence methods within the streamwrapper via `registerStreamWrapperV2`
* `Aws\WellArchitected` - Adds support for lens tagging, Adds support for multiple helpful-resource urls and multiple improvement-plan urls.

## 3.227.1 - 2022-06-20

* `Aws\DirectoryService` - This release adds support for describing and updating AWS Managed Microsoft AD settings
* `Aws\Kafka` - Documentation updates to use Az Id during cluster creation.
* `Aws\Outposts` - This release adds the AssetLocation structure to the ListAssets response. AssetLocation includes the RackElevation for an Asset.

## 3.227.0 - 2022-06-17

* `Aws\Connect` - This release updates these APIs: UpdateInstanceAttribute, DescribeInstanceAttribute and ListInstanceAttributes. You can use it to programmatically enable/disable High volume outbound communications using attribute type HIGH_VOLUME_OUTBOUND on the specified Amazon Connect instance.
* `Aws\ConnectCampaignService` - Added Amazon Connect high volume outbound communications SDK.
* `Aws\DynamoDB` - Doc only update for DynamoDB service
* `Aws\DynamoDBStreams` - Doc only update for DynamoDB service

## 3.226.0 - 2022-06-16

* `Aws\RedshiftDataAPIService` - This release adds a new --workgroup-name field to operations that connect to an endpoint. Customers can now execute queries against their serverless workgroups.
* `Aws\SecretsManager` - Documentation updates for Secrets Manager
* `Aws\SecurityHub` - Added Threats field for security findings. Added new resource details for ECS Container, ECS Task, RDS SecurityGroup, Kinesis Stream, EC2 TransitGateway, EFS AccessPoint, CloudFormation Stack, CloudWatch Alarm, VPC Peering Connection and WAF Rules

## 3.225.5 - 2022-06-15

* `Aws\AppRegistry` - This release adds a new API ListAttributeGroupsForApplication that returns associated attribute groups of an application. In addition, the UpdateApplication and UpdateAttributeGroup APIs will not allow users to update the 'Name' attribute.
* `Aws\FinSpaceData` - This release adds a new set of APIs, GetPermissionGroup, DisassociateUserFromPermissionGroup, AssociateUserToPermissionGroup, ListPermissionGroupsByUser, ListUsersByPermissionGroup.
* `Aws\GuardDuty` - Adds finding fields available from GuardDuty Console. Adds FreeTrial related operations. Deprecates the use of various APIs related to Master Accounts and Replace them with Administrator Accounts.
* `Aws\WorkSpaces` - Added new field "reason" to OperationNotSupportedException. Receiving this exception in the DeregisterWorkspaceDirectory API will now return a reason giving more context on the failure.

## 3.225.4 - 2022-06-14

* `Aws\Budgets` - Add a budgets ThrottlingException. Update the CostFilters value pattern.
* `Aws\LookoutMetrics` - Adding filters to Alert and adding new UpdateAlert API.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for rules that constrain Automatic-ABR rendition selection when generating ABR package ladders.

## 3.225.3 - 2022-06-13

* `Aws\` - Revert previous guzzle bump due to lack of exposure to security advisories
* `Aws\Outposts` - This release adds API operations AWS uses to install Outpost servers.

## 3.225.2 - 2022-06-10

* `Aws\` - Bump Guzzle 6 and 7 due to security advisory
* `Aws\` - Remove RedshiftServerless service
* `Aws\FraudDetector` - Documentation updates for Amazon Fraud Detector (AWSHawksNest)

## 3.225.1 - 2022-06-09

* `Aws\ChimeSDKMeetings` - Adds support for live transcription in AWS GovCloud (US) Regions.

## 3.225.0 - 2022-06-08

* `Aws\DatabaseMigrationService` - This release adds DMS Fleet Advisor APIs and exposes functionality for DMS Fleet Advisor. It adds functionality to create and modify fleet advisor instances, and to collect and analyze information about the local data infrastructure.
* `Aws\IAM` - Documentation updates for AWS Identity and Access Management (IAM).
* `Aws\MainframeModernization` - AWS Mainframe Modernization service is a managed mainframe service and set of tools for planning, migrating, modernizing, and running mainframe workloads on AWS
* `Aws\Neptune` - This release adds support for Neptune to be configured as a global database, with a primary DB cluster in one region, and up to five secondary DB clusters in other regions.
* `Aws\Redshift` - Adds new API GetClusterCredentialsWithIAM to return temporary credentials.

## 3.224.5 - 2022-06-07

* `Aws\AuditManager` - This release introduces 2 updates to the Audit Manager API. The roleType and roleArn attributes are now required when you use the CreateAssessment or UpdateAssessment operation. We also added a throttling exception to the RegisterAccount API operation.
* `Aws\CostExplorer` - Added two new APIs to support cost allocation tags operations: ListCostAllocationTags, UpdateCostAllocationTagsStatus.

## 3.224.4 - 2022-06-06

* `Aws\ChimeSDKMessaging` - This release adds support for searching channels by members via the SearchChannels API, removes required restrictions for Name and Mode in UpdateChannel API and enhances CreateChannel API by exposing member and moderator list as well as channel id as optional parameters.
* `Aws\Connect` - This release adds a new API, GetCurrentUserData, which returns real-time details about users' current activity.

## 3.224.3 - 2022-06-02

* `Aws\ApplicationInsights` - Provide Account Level onboarding support through CFN/CLI
* `Aws\CodeArtifact` - Documentation updates for CodeArtifact
* `Aws\Connect` - This release adds the following features: 1) New APIs to manage (create, list, update) task template resources, 2) Updates to startTaskContact API to support task templates, and 3) new TransferContact API to programmatically transfer in-progress tasks via a contact flow.
* `Aws\Proton` - Add new "Components" API to enable users to Create, Delete and Update AWS Proton components.
* `Aws\VoiceID` - Added a new attribute ServerSideEncryptionUpdateDetails to Domain and DomainSummary.
* `Aws\kendra` - Amazon Kendra now provides a data source connector for GitHub. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-github.html

## 3.224.2 - 2022-06-01

* `Aws\BackupGateway` - Adds GetGateway and UpdateGatewaySoftwareNow API and adds hypervisor name to UpdateHypervisor API
* `Aws\ChimeSDKMeetings` - Adds support for centrally controlling each participant's ability to send and receive audio, video and screen share within a WebRTC session. Attendee capabilities can be specified when the attendee is created and updated during the session with the new BatchUpdateAttendeeCapabilitiesExcept API.
* `Aws\ForecastService` - Added Format field to Import and Export APIs in Amazon Forecast. Added TimeSeriesSelector to Create Forecast API.
* `Aws\Route53` - Add new APIs to support Route 53 IP Based Routing

## 3.224.1 - 2022-05-31

* `Aws\CognitoIdentityProvider` - Amazon Cognito now supports IP Address propagation for all unauthenticated APIs (e.g. SignUp, ForgotPassword).
* `Aws\IoTSiteWise` - This release adds the following new optional field to the IoT SiteWise asset resource: assetDescription.
* `Aws\LookoutMetrics` - Adding backtest mode to detectors using the Cloudwatch data source.
* `Aws\SageMaker` - Amazon SageMaker Notebook Instances now support Jupyter Lab 3.
* `Aws\TranscribeService` - Amazon Transcribe now supports automatic language identification for multi-lingual audio in batch mode.
* `Aws\drs` - Changed existing APIs and added new APIs to accommodate using multiple AWS accounts with AWS Elastic Disaster Recovery.

## 3.224.0 - 2022-05-27

* `Aws\` - Removed `EMRServerlessWebService`, which was released with an incorrect name
* `Aws\Appflow` - Adding the following features/changes: Parquet output that preserves typing from the source connector, Failed executions threshold before deactivation for scheduled flows, increasing max size of access and refresh token from 2048 to 4096
* `Aws\DataSync` - AWS DataSync now supports TLS encryption in transit, file system policies and access points for EFS locations.
* `Aws\EMRServerless` - This release adds support for Amazon EMR Serverless, a serverless runtime environment that simplifies running analytics applications using the latest open source frameworks such as Apache Spark and Apache Hive.
* `Aws\SageMaker` - Amazon SageMaker Notebook Instances now allows configuration of Instance Metadata Service version and Amazon SageMaker Studio now supports G5 instance types.

## 3.223.0 - 2022-05-26

* `Aws\` - Add missing PHPDoc annotation for PromiseInterface implementations.
* `Aws\EC2` - C7g instances, powered by the latest generation AWS Graviton3 processors, provide the best price performance in Amazon EC2 for compute-intensive workloads.
* `Aws\ForecastService` - Introduced a new field in Auto Predictor as Time Alignment Boundary. It helps in aligning the timestamps generated during Forecast exports
* `Aws\Lightsail` - Amazon Lightsail now supports the ability to configure a Lightsail Container Service to pull images from Amazon ECR private repositories in your account.

## 3.222.20 - 2022-05-25

* `Aws\APIGateway` - Documentation updates for Amazon API Gateway
* `Aws\AppRunner` - Documentation-only update added for CodeConfiguration.
* `Aws\CloudFormation` - Add a new parameter statusReason to DescribeStackSetOperation output for additional details
* `Aws\FSx` - This release adds root squash support to FSx for Lustre to restrict root level access from clients by mapping root users to a less-privileged user/group with limited permissions.
* `Aws\LookoutMetrics` - Adding AthenaSourceConfig for MetricSet APIs to support Athena as a data source.
* `Aws\SageMaker` - Amazon SageMaker Autopilot adds support for manually selecting features from the input dataset using the CreateAutoMLJob API.
* `Aws\SecretsManager` - Documentation updates for Secrets Manager
* `Aws\VoiceID` - VoiceID will now automatically expire Speakers if they haven't been accessed for Enrollment, Re-enrollment or Successful Auth for three years. The Speaker APIs now return a "LastAccessedAt" time for Speakers, and the EvaluateSession API returns "SPEAKER_EXPIRED" Auth Decision for EXPIRED Speakers.

## 3.222.19 - 2022-05-24

* `Aws\CognitoIdentityProvider` - Amazon Cognito now supports requiring attribute verification (ex. email and phone number) before update.
* `Aws\EC2` - Stop Protection feature enables customers to protect their instances from accidental stop actions.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for rules that constrain Automatic-ABR rendition selection when generating ABR package ladders.
* `Aws\NetworkManager` - This release adds Multi Account API support for a TGW Global Network, to enable and disable AWSServiceAccess with AwsOrganizations for Network Manager service and dependency CloudFormation StackSets service.
* `Aws\ivschat` - Doc-only update. For MessageReviewHandler structure, added timeout period in the description of the fallbackResult field

## 3.222.18 - 2022-05-23

* `Aws\ElastiCache` - Added support for encryption in transit for Memcached clusters. Customers can now launch Memcached cluster with encryption in transit enabled when using Memcached version 1.6.12 or later.
* `Aws\ForecastService` - New APIs for Monitor that help you understand how your predictors perform over time.
* `Aws\Personalize` - Adding modelMetrics as part of DescribeRecommender API response for Personalize.

## 3.222.17 - 2022-05-20

* `Aws\CloudWatchLogs` - Doc-only update to publish the new valid values for log retention
* `Aws\Comprehend` - Comprehend releases 14 new entity types for DetectPiiEntities and ContainsPiiEntities APIs.

## 3.222.16 - 2022-05-19

* `Aws\GameSparks` - This release adds an optional DeploymentResult field in the responses of GetStageDeploymentIntegrationTests and ListStageDeploymentIntegrationTests APIs.
* `Aws\LookoutMetrics` - In this release we added SnsFormat to SNSConfiguration to support human readable alert.

## 3.222.15 - 2022-05-18

* `Aws\AppMesh` - This release updates the existing Create and Update APIs for meshes and virtual nodes by adding a new IP preference field. This new IP preference field can be used to control the IP versions being used with the mesh and allows for IPv6 support within App Mesh.
* `Aws\Batch` - Documentation updates for AWS Batch.
* `Aws\GreengrassV2` - This release adds the new DeleteDeployment API operation that you can use to delete deployment resources. This release also adds support for discontinued AWS-provided components, so AWS can communicate when a component has any issues that you should consider before you deploy it.
* `Aws\IoTEventsData` - Introducing new API for deleting detectors: BatchDeleteDetector.
* `Aws\QuickSight` - API UpdatePublicSharingSettings enables IAM admins to enable/disable account level setting for public access of dashboards. When enabled, owners/co-owners for dashboards can enable public access on their dashboards. These dashboards can only be accessed through share link or embedding.
* `Aws\Transfer` - AWS Transfer Family now supports SetStat server configuration option, which provides the ability to ignore SetStat command issued by file transfer clients, enabling customers to upload files without any errors.

## 3.222.14 - 2022-05-17

* `Aws\Glue` - This release adds a new optional parameter called codeGenNodeConfiguration to CRUD job APIs that allows users to manage visual jobs via APIs. The updated CreateJob and UpdateJob will create jobs that can be viewed in Glue Studio as a visual graph. GetJob can be used to get codeGenNodeConfiguration.
* `Aws\KMS` - Add HMAC best practice tip, annual rotation of AWS managed keys.

## 3.222.13 - 2022-05-16

* `Aws\ApplicationDiscoveryService` - Add Migration Evaluator Collector details to the GetDiscoverySummary API response
* `Aws\CloudFront` - Introduced a new error (TooLongCSPInResponseHeadersPolicy) that is returned when the value of the Content-Security-Policy header in a response headers policy exceeds the maximum allowed length.
* `Aws\Rekognition` - Documentation updates for Amazon Rekognition.
* `Aws\ResilienceHub` - In this release, we are introducing support for Amazon Elastic Container Service, Amazon Route 53, AWS Elastic Disaster Recovery, AWS Backup in addition to the existing supported Services. This release also supports Terraform file input from S3 and scheduling daily assessments
* `Aws\STS` - Documentation updates for AWS Security Token Service.
* `Aws\ServiceCatalog` - Updated the descriptions for the ListAcceptedPortfolioShares API description and the PortfolioShareType parameters.
* `Aws\WorkSpacesWeb` - Amazon WorkSpaces Web now supports Administrator timeout control

## 3.222.12 - 2022-05-13

* `Aws\ManagedGrafana` - This release adds APIs for creating and deleting API keys in an Amazon Managed Grafana workspace.

## 3.222.11 - 2022-05-12

* `Aws\Credentials` - Made implicit conversion of float to int explicit (to avoid deprivation errors in php8.1)
* `Aws\EC2` - This release introduces a target type Gateway Load Balancer Endpoint for mirrored traffic. Customers can now specify GatewayLoadBalancerEndpoint option during the creation of a traffic mirror target.
* `Aws\FinSpaceData` - We've now deprecated CreateSnapshot permission for creating a data view, instead use CreateDataView permission.
* `Aws\IoT` - Documentation update for China region ListMetricValues for IoT
* `Aws\Lambda` - Lambda releases NodeJs 16 managed runtime to be available in all commercial regions.
* `Aws\Lightsail` - This release adds support to include inactive database bundles in the response of the GetRelationalDatabaseBundles request.
* `Aws\Outposts` - Documentation updates for AWS Outposts.
* `Aws\SSMIncidents` - Adding support for dynamic SSM Runbook parameter values. Updating validation pattern for engagements. Adding ConflictException to UpdateReplicationSet API contract.
* `Aws\Transfer` - AWS Transfer Family now accepts ECDSA keys for server host keys
* `Aws\WorkSpaces` - Increased the character limit of the login message from 600 to 850 characters.
* `Aws\ivschat` - Documentation-only updates for IVS Chat API Reference.
* `Aws\kendra` - Amazon Kendra now provides a data source connector for Jira. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-jira.html

## 3.222.10 - 2022-05-11

* `Aws\EC2` - This release updates AWS PrivateLink APIs to support IPv6 for PrivateLink Services and Endpoints of type 'Interface'.
* `Aws\SecretsManager` - Doc only update for Secrets Manager that fixes several customer-reported issues.

## 3.222.9 - 2022-05-10

* `Aws\ComputeOptimizer` - Documentation updates for Compute Optimizer
* `Aws\EC2` - Added support for using NitroTPM and UEFI Secure Boot on EC2 instances.
* `Aws\EKS` - Adds BOTTLEROCKET_ARM_64_NVIDIA and BOTTLEROCKET_x86_64_NVIDIA AMI types to EKS managed nodegroups
* `Aws\EMR` - This release updates the Amazon EMR ModifyInstanceGroups API to support "MERGE" type cluster reconfiguration. Also, added the ability to specify a particular Amazon Linux release for all nodes in a cluster launch request.
* `Aws\MigrationHubRefactorSpaces` - AWS Migration Hub Refactor Spaces documentation only update to fix a formatting issue.

## 3.222.8 - 2022-05-09

* `Aws\CloudControlApi` - SDK release for Cloud Control API to include paginators for Python SDK.
* `Aws\CloudWatchEvidently` - Add detail message inside GetExperimentResults API response to indicate experiment result availability
* `Aws\SSMContacts` - Fixed an error in the DescribeEngagement example for AWS Incident Manager.

## 3.222.7 - 2022-05-06

* `Aws\EC2` - Add new state values for IPAMs, IPAM Scopes, and IPAM Pools.
* `Aws\LocationService` - Amazon Location Service now includes a MaxResults parameter for ListGeofences requests.
* `Aws\MediaPackage` - This release adds Dvb Dash 2014 as an available profile option for Dash Origin Endpoints.
* `Aws\RDS` - Various documentation improvements.
* `Aws\Redshift` - Introduces new field 'LoadSampleData' in CreateCluster operation. Customers can now specify 'LoadSampleData' option during creation of a cluster, which results in loading of sample data in the cluster that is created.
* `Aws\SecurityHub` - Documentation updates for Security Hub API reference

## 3.222.6 - 2022-05-05

* `Aws\DataSync` - AWS DataSync now supports a new ObjectTags Task API option that can be used to control whether Object Tags are transferred.
* `Aws\EC2` - Amazon EC2 I4i instances are powered by 3rd generation Intel Xeon Scalable processors and feature up to 30 TB of local AWS Nitro SSD storage
* `Aws\IoT` - AWS IoT Jobs now allows you to create up to 100,000 active continuous and snapshot jobs by using concurrency control.
* `Aws\kendra` - AWS Kendra now supports hierarchical facets for a query. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/filtering.html

## 3.222.5 - 2022-05-04

* `Aws\Backup` - Adds support to 2 new filters about job complete time for 3 list jobs APIs in AWS Backup
* `Aws\IoTSecureTunneling` - This release introduces a new API RotateTunnelAccessToken that allow revoking the existing tokens and generate new tokens
* `Aws\Lightsail` - Documentation updates for Lightsail
* `Aws\SSM` - This release adds the TargetMaps parameter in SSM State Manager API.

## 3.222.4 - 2022-05-03

* `Aws\EC2` - Adds support for allocating Dedicated Hosts on AWS Outposts. The AllocateHosts API now accepts an OutpostArn request parameter, and the DescribeHosts API now includes an OutpostArn response parameter.
* `Aws\KinesisVideo` - Add support for multiple image feature related APIs for configuring image generation and notification of a video stream. Add "GET_IMAGES" to the list of supported API names for the GetDataEndpoint API.
* `Aws\KinesisVideoArchivedMedia` - Add support for GetImages API for retrieving images from a video stream
* `Aws\S3` - Documentation only update for doc bug fixes for the S3 API docs.
* `Aws\SageMaker` - SageMaker Autopilot adds new metrics for all candidate models generated by Autopilot experiments; RStudio on SageMaker now allows users to bring your own development environment in a custom image.

## 3.222.3 - 2022-05-02

* `Aws\Organizations` - This release adds the INVALID_PAYMENT_INSTRUMENT as a fail reason and an error message.
* `Aws\Outposts` - This release adds a new API called ListAssets to the Outposts SDK, which lists the hardware assets in an Outpost.
* `Aws\Synthetics` - CloudWatch Synthetics has introduced a new feature to provide customers with an option to delete the underlying resources that Synthetics canary creates when the user chooses to delete the canary.

## 3.222.2 - 2022-04-29

* `Aws\CodeGuruReviewer` - Amazon CodeGuru Reviewer now supports suppressing recommendations from being generated on specific files and directories.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK nows supports creation of Dolby Vision profile 8.1, the ability to generate black frames of video, and introduces audio-only DASH and CMAF support.
* `Aws\RDS` - Feature - Adds support for Internet Protocol Version 6 (IPv6) on RDS database instances.
* `Aws\SSM` - Update the StartChangeRequestExecution, adding TargetMaps to the Runbook parameter
* `Aws\WAFV2` - You can now inspect all request headers and all cookies. You can now specify how to handle oversize body contents in your rules that inspect the body.

## 3.222.1 - 2022-04-28

* `Aws\AuditManager` - This release adds documentation updates for Audit Manager. We provided examples of how to use the Custom_ prefix for the keywordValue attribute. We also provided more details about the DeleteAssessmentReport operation.
* `Aws\Braket` - This release enables Braket Hybrid Jobs with Embedded Simulators to have multiple instances.
* `Aws\Connect` - This release introduces an API for changing the current agent status of a user in Connect.
* `Aws\EC2` - This release adds support to query the public key and creation date of EC2 Key Pairs. Additionally, the format (pem or ppk) of a key pair can be specified when creating a new key pair.
* `Aws\GuardDuty` - Documentation update for API description.
* `Aws\NetworkFirewall` - AWS Network Firewall adds support for stateful threat signature AWS managed rule groups.

## 3.222.0 - 2022-04-27

* `Aws\Amplify` - Documentation only update to support the Amplify GitHub App feature launch
* `Aws\ChimeSDKMediaPipelines` - For Amazon Chime SDK meetings, the Amazon Chime Media Pipelines SDK allows builders to capture audio, video, and content share streams. You can also capture meeting events, live transcripts, and data messages. The pipelines save the artifacts to an Amazon S3 bucket that you designate.
* `Aws\CloudTrail` - Increases the retention period maximum to 2557 days. Deprecates unused fields of the ListEventDataStores API response. Updates documentation.
* `Aws\IoTWireless` - Add list support for event configurations, allow to get and update event configurations by resource type, support LoRaWAN events; Make NetworkAnalyzerConfiguration as a resource, add List, Create, Delete API support; Add FCntStart attribute support for ABP WirelessDevice.
* `Aws\LookoutEquipment` - This release adds the following new features: 1) Introduces an option for automatic schema creation 2) Now allows for Ingestion of data containing most common errors and allows automatic data cleaning 3) Introduces new API ListSensorStatistics that gives further information about the ingested data
* `Aws\Rekognition` - This release adds support to configure stream-processor resources for label detections on streaming-videos. UpateStreamProcessor API is also launched with this release, which could be used to update an existing stream-processor.
* `Aws\SageMaker` - Amazon SageMaker Autopilot adds support for custom validation dataset and validation ratio through the CreateAutoMLJob and DescribeAutoMLJob APIs.

## 3.221.0 - 2022-04-26

* `Aws\CloudFront` - CloudFront now supports the Server-Timing header in HTTP responses sent from CloudFront. You can use this header to view metrics that help you gain insights about the behavior and performance of CloudFront. To use this header, enable it in a response headers policy.
* `Aws\Glue` - This release adds documentation for the APIs to create, read, delete, list, and batch read of AWS Glue custom patterns, and for Lake Formation configuration settings in the AWS Glue crawler.
* `Aws\Lightsail` - This release adds support for Lightsail load balancer HTTP to HTTPS redirect and TLS policy configuration.
* `Aws\NetworkFirewall` - AWS Network Firewall now enables customers to use a customer managed AWS KMS key for the encryption of their firewall resources.
* `Aws\Pricing` - Documentation updates for Price List API
* `Aws\SageMaker` - SageMaker Inference Recommender now accepts customer KMS key ID for encryption of endpoints and compilation outputs created during inference recommendation.
* `Aws\ivschat` - Adds new APIs for IVS Chat, a feature for building interactive chat experiences alongside an IVS broadcast.

## 3.220.4 - 2022-04-25

* `Aws\Connect` - This release adds SearchUsers API which can be used to search for users with a Connect Instance
* `Aws\GameLift` - Documentation updates for Amazon GameLift.
* `Aws\MQ` - This release adds the CRITICAL_ACTION_REQUIRED broker state and the ActionRequired API property. CRITICAL_ACTION_REQUIRED informs you when your broker is degraded. ActionRequired provides you with a code which you can use to find instructions in the Developer Guide on how to resolve the issue.
* `Aws\RDSDataService` - Support to receive SQL query results in the form of a simplified JSON string. This enables developers using the new JSON string format to more easily convert it to an object using popular JSON string parsing libraries.
* `Aws\SecurityHub` - Security Hub now lets you opt-out of auto-enabling the defaults standards (CIS and FSBP) in accounts that are auto-enabled with Security Hub via Security Hub's integration with AWS Organizations.

## 3.220.3 - 2022-04-22

* `Aws\ChimeSDKMeetings` - Include additional exceptions types.
* `Aws\EC2` - Adds support for waiters that automatically poll for a deleted NAT Gateway until it reaches the deleted state.

## 3.220.2 - 2022-04-21

* `Aws\ConnectWisdomService` - This release updates the GetRecommendations API to include a trigger event list for classifying and grouping recommendations.
* `Aws\ElastiCache` - Doc only update for ElastiCache
* `Aws\Glue` - This release adds APIs to create, read, delete, list, and batch read of Glue custom entity types
* `Aws\IoTSiteWise` - This release adds 3 new batch data query APIs : BatchGetAssetPropertyValue, BatchGetAssetPropertyValueHistory and BatchGetAssetPropertyAggregates
* `Aws\IoTTwinMaker` - General availability (GA) for AWS IoT TwinMaker. For more information, see https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/Welcome.html
* `Aws\LookoutMetrics` - Added DetectMetricSetConfig API for detecting configuration required for creating metric set from provided S3 data source.
* `Aws\MediaTailor` - This release introduces tiered channels and adds support for live sources. Customers using a STANDARD channel can now create programs using live sources.
* `Aws\MultiRegionClient` - Adds support for using custom handlers with multi-region clients
* `Aws\SecretsManager` - Documentation updates for Secrets Manager
* `Aws\StorageGateway` - This release adds support for minimum of 5 character length virtual tape barcodes.

## 3.220.1 - 2022-04-20

* `Aws\Connect` - This release adds APIs to search, claim, release, list, update, and describe phone numbers. You can also use them to associate and disassociate contact flows to phone numbers.
* `Aws\Macie2` - Sensitive data findings in Amazon Macie now indicate how Macie found the sensitive data that produced a finding (originType).
* `Aws\RDS` - Added a new cluster-level attribute to set the capacity range for Aurora Serverless v2 instances.
* `Aws\mgn` - Removed required annotation from input fields in Describe operations requests. Added quotaValue to ServiceQuotaExceededException

## 3.220.0 - 2022-04-19

* `Aws\AutoScaling` - EC2 Auto Scaling now adds default instance warm-up times for all scaling activities, health check replacements, and other replacement events in the Auto Scaling instance lifecycle.
* `Aws\KMS` - Adds support for KMS keys and APIs that generate and verify HMAC codes
* `Aws\Personalize` - Adding StartRecommender and StopRecommender APIs for Personalize.
* `Aws\Polly` - Amazon Polly adds new Austrian German voice - Hannah. Hannah is available as Neural voice only.
* `Aws\Redshift` - Introduces new fields for LogDestinationType and LogExports on EnableLogging requests and Enable/Disable/DescribeLogging responses. Customers can now select CloudWatch Logs as a destination for their Audit Logs.
* `Aws\S3` - Adds DoesBucketExistV2 and DoesObjectExistV2 helper methods
* `Aws\SSM` - Added offset support for specifying the number of days to wait after the date and time specified by a CRON expression when creating SSM association.
* `Aws\Textract` - This release adds support for specifying and extracting information from documents using the Queries feature within Analyze Document API
* `Aws\Transfer` - This release contains corrected HomeDirectoryMappings examples for several API functions: CreateAccess, UpdateAccess, CreateUser, and UpdateUser,.
* `Aws\WorkLink` - Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
* `Aws\kendra` - Amazon Kendra now provides a data source connector for Quip. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-quip.html

## 3.219.5 - 2022-04-15

* `Aws\Athena` - This release adds subfields, ErrorMessage, Retryable, to the AthenaError response object in the GetQueryExecution API when a query fails.
* `Aws\Lightsail` - This release adds support to describe the synchronization status of the account-level block public access feature for your Amazon Lightsail buckets.
* `Aws\RDS` - Removes Amazon RDS on VMware with the deletion of APIs related to Custom Availability Zones and Media installation

## 3.219.4 - 2022-04-14

* `Aws\AppStream` - Includes updates for create and update fleet APIs to manage the session scripts locations for Elastic fleets.
* `Aws\Appflow` - Enables users to pass custom token URL parameters for Oauth2 authentication during create connector profile
* `Aws\Batch` - Enables configuration updates for compute environments with BEST_FIT_PROGRESSIVE and SPOT_CAPACITY_OPTIMIZED allocation strategies.
* `Aws\CloudWatch` - Updates documentation for additional statistics in CloudWatch Metric Streams.
* `Aws\EC2` - Documentation updates for Amazon EC2.
* `Aws\Glue` - Auto Scaling for Glue version 3.0 and later jobs to dynamically scale compute resources. This SDK change provides customers with the auto-scaled DPU usage

## 3.219.3 - 2022-04-13

* `Aws\CloudWatch` - Adds support for additional statistics in CloudWatch Metric Streams.
* `Aws\FSx` - This release adds support for deploying FSx for ONTAP file systems in a single Availability Zone.

## 3.219.2 - 2022-04-12

* `Aws\DevOpsGuru` - This release adds new APIs DeleteInsight to deletes the insight along with the associated anomalies, events and recommendations.
* `Aws\EC2` - X2idn and X2iedn instances are powered by 3rd generation Intel Xeon Scalable processors with an all-core turbo frequency up to 3.5 GHzAmazon EC2. C6a instances are powered by 3rd generation AMD EPYC processors.
* `Aws\EFS` - Amazon EFS adds support for a ThrottlingException when using the CreateAccessPoint API if the account is nearing the AccessPoint limit(120).
* `Aws\IoTTwinMaker` - This release adds the following new features: 1) ListEntities API now supports search using ExternalId. 2) BatchPutPropertyValue and GetPropertyValueHistory API now allows users to represent time in sub-second level precisions.

## 3.219.1 - 2022-04-11

* `Aws\AmplifyUIBuilder` - In this release, we have added the ability to bind events to component level actions.
* `Aws\AppRunner` - This release adds tracing for App Runner services with X-Ray using AWS Distro for OpenTelemetry. New APIs: CreateObservabilityConfiguration, DescribeObservabilityConfiguration, ListObservabilityConfigurations, and DeleteObservabilityConfiguration. Updated APIs: CreateService and UpdateService.
* `Aws\WorkSpaces` - Added API support that allows customers to create GPU-enabled WorkSpaces using EC2 G4dn instances.

## 3.219.0 - 2022-04-08

* `Aws\EventBridge` - Adds sigv4 support for EventBridge putEvents calls when opt-in parameter EndpointId is specified
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for the pass-through of WebVTT styling to WebVTT outputs, pass-through of KLV metadata to supported formats, and improved filter support for processing 444/RGB content.
* `Aws\MediaPackageVod` - This release adds ScteMarkersSource as an available field for Dash Packaging Configurations. When set to MANIFEST, MediaPackage will source the SCTE-35 markers from the manifest. When set to SEGMENTS, MediaPackage will source the SCTE-35 markers from the segments.
* `Aws\WAFV2` - Add a new CurrentDefaultVersion field to ListAvailableManagedRuleGroupVersions API response; add a new VersioningSupported boolean to each ManagedRuleGroup returned from ListAvailableManagedRuleGroups API response.

## 3.218.5 - 2022-04-07

* `Aws\APIGateway` - ApiGateway CLI command get-usage now includes usagePlanId, startDate, and endDate fields in the output to match documentation.
* `Aws\DocDB` - Added support to enable/disable performance insights when creating or modifying db instances
* `Aws\EventBridge` - Adds new EventBridge Endpoint resources for disaster recovery, multi-region failover, and cross-region replication capabilities to help you build resilient event-driven applications.
* `Aws\PI` - Adds support for DocumentDB to the Performance Insights API.
* `Aws\Personalize` - This release provides tagging support in AWS Personalize.
* `Aws\SageMaker` - Amazon Sagemaker Notebook Instances now supports G5 instance types

## 3.218.4 - 2022-04-06

* `Aws\ConfigService` - Add resourceType enums for AWS::EMR::SecurityConfiguration and AWS::SageMaker::CodeRepository
* `Aws\Lambda` - This release adds new APIs for creating and managing Lambda Function URLs and adds a new FunctionUrlAuthType parameter to the AddPermission API. Customers can use Function URLs to create built-in HTTPS endpoints on their functions.
* `Aws\Panorama` - Added Brand field to device listings.
* `Aws\kendra` - Amazon Kendra now provides a data source connector for Box. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-box.html

## 3.218.3 - 2022-04-05

* `Aws\DataSync` - AWS DataSync now supports Amazon FSx for OpenZFS locations.
* `Aws\FSx` - Provide customers more visibility into file system status by adding new "Misconfigured Unavailable" status for Amazon FSx for Windows File Server.
* `Aws\S3Control` - Documentation-only update for doc bug fixes for the S3 Control API docs.
* `Aws\SecurityHub` - Added additional ASFF details for RdsSecurityGroup AutoScalingGroup, ElbLoadBalancer, CodeBuildProject and RedshiftCluster.

## 3.218.2 - 2022-04-04

* `Aws\IoT` - AWS IoT - AWS IoT Device Defender adds support to list metric datapoints collected for IoT devices through the ListMetricValues API
* `Aws\Proton` - SDK release to support tagging for AWS Proton Repository resource
* `Aws\SMS` - Revised product update notice for SMS console deprecation.
* `Aws\ServiceCatalog` - This release adds ProvisioningArtifictOutputKeys to DescribeProvisioningParameters to reference the outputs of a Provisioned Product and deprecates ProvisioningArtifactOutputs.

## 3.218.1 - 2022-04-01

* `Aws\Connect` - This release updates these APIs: UpdateInstanceAttribute, DescribeInstanceAttribute and ListInstanceAttributes. You can use it to programmatically enable/disable multi-party conferencing using attribute type MULTI_PARTY_CONFERENCING on the specified Amazon Connect instance.

## 3.218.0 - 2022-03-31

* `Aws\AuditManager` - This release adds documentation updates for Audit Manager. The updates provide data deletion guidance when a customer deregisters Audit Manager or deregisters a delegated administrator.
* `Aws\CloudControlApi` - SDK release for Cloud Control API in Amazon Web Services China (Beijing) Region, operated by Sinnet, and Amazon Web Services China (Ningxia) Region, operated by NWCD
* `Aws\GlueDataBrew` - This AWS Glue Databrew release adds feature to support ORC as an input format.
* `Aws\ManagedGrafana` - This release adds tagging support to the Managed Grafana service. New APIs: TagResource, UntagResource and ListTagsForResource. Updates: add optional field tags to support tagging while calling CreateWorkspace.
* `Aws\PinpointSMSVoiceV2` - Amazon Pinpoint now offers a version 2.0 suite of SMS and voice APIs, providing increased control over sending and configuration. This release is a new SDK for sending SMS and voice messages called PinpointSMSVoiceV2.
* `Aws\Route53RecoveryCluster` - This release adds a new API "ListRoutingControls" to list routing control states using the highly reliable Route 53 ARC data plane endpoints.
* `Aws\WorkSpaces` - Added APIs that allow you to customize the logo, login message, and help links in the WorkSpaces client login page. To learn more, visit https://docs.aws.amazon.com/workspaces/latest/adminguide/customize-branding.html

## 3.217.0 - 2022-03-30

* `Aws\Credentials` - Add support for ECS full uri and auth token environment variables
* `Aws\EC2` - This release simplifies the auto-recovery configuration process enabling customers to set the recovery behavior to disabled or default
* `Aws\FMS` - AWS Firewall Manager now supports the configuration of third-party policies that can use either the centralized or distributed deployment models.
* `Aws\FSx` - This release adds support for modifying throughput capacity for FSx for ONTAP file systems.
* `Aws\IoT` - Doc only update for IoT that fixes customer-reported issues.
* `Aws\IoTDataPlane` - Update the default AWS IoT Core Data Plane endpoint from VeriSign signed to ATS signed. If you have firewalls with strict egress rules, configure the rules to grant you access to data-ats.iot.[region].amazonaws.com or data-ats.iot.[region].amazonaws.com.cn.

## 3.216.4 - 2022-03-29

* `Aws\Organizations` - This release provides the new CloseAccount API that enables principals in the management account to close any member account within an organization.

## 3.216.3 - 2022-03-28

* `Aws\ACMPCA` - Updating service name entities
* `Aws\MediaLive` - This release adds support for selecting a maintenance window.

## 3.216.2 - 2022-03-25

* `Aws\Batch` - Bug Fix: Fixed a bug where shapes were marked as unboxed and were not serialized and sent over the wire, causing an API error from the service.
* `Aws\EC2` - This is release adds support for Amazon VPC Reachability Analyzer to analyze path through a Transit Gateway.
* `Aws\SSM` - This Patch Manager release supports creating, updating, and deleting Patch Baselines for Rocky Linux OS.

## 3.216.1 - 2022-03-24

* `Aws\ConfigService` - Added new APIs GetCustomRulePolicy and GetOrganizationCustomRulePolicy, and updated existing APIs PutConfigRule, DescribeConfigRule, DescribeConfigRuleEvaluationStatus, PutOrganizationConfigRule, DescribeConfigRule to support a new feature for building AWS Config rules with AWS CloudFormation Guard
* `Aws\Lambda` - Adds support for increased ephemeral storage (/tmp) up to 10GB for Lambda functions. Customers can now provision up to 10 GB of ephemeral storage per function instance, a 20x increase over the previous limit of 512 MB.
* `Aws\TranscribeService` - This release adds an additional parameter for subtitling with Amazon Transcribe batch jobs: outputStartIndex.

## 3.216.0 - 2022-03-23

* `Aws\AuditManager` - This release updates 1 API parameter, the SnsArn attribute. The character length and regex pattern for the SnsArn attribute have been updated, which enables you to deselect an SNS topic when using the UpdateSettings operation.
* `Aws\EBS` - Increased the maximum supported value for the Timeout parameter of the StartSnapshot API from 60 minutes to 4320 minutes. Changed the HTTP error code for ConflictException from 503 to 409.
* `Aws\ElastiCache` - Doc only update for ElastiCache
* `Aws\GameSparks` - Released the preview of Amazon GameSparks, a fully managed AWS service that provides a multi-service backend for game developers.
* `Aws\Redshift` - This release adds a new [--encrypted | --no-encrypted] field in restore-from-cluster-snapshot API. Customers can now restore an unencrypted snapshot to a cluster encrypted with AWS Managed Key or their own KMS key.
* `Aws\SSM` - Update AddTagsToResource, ListTagsForResource, and RemoveTagsFromResource APIs to reflect the support for tagging Automation resources. Includes other minor documentation updates.
* `Aws\Transfer` - Documentation updates for AWS Transfer Family to describe how to remove an associated workflow from a server.

## 3.215.2 - 2022-03-22

* `Aws\CostExplorer` - Added three new APIs to support tagging and resource-level authorization on Cost Explorer resources: TagResource, UntagResource, ListTagsForResource. Added optional parameters to CreateCostCategoryDefinition, CreateAnomalySubscription and CreateAnomalyMonitor APIs to support Tag On Create.
* `Aws\ECS` - Documentation only update to address tickets
* `Aws\LakeFormation` - The release fixes the incorrect permissions called out in the documentation - DESCRIBE_TAG, ASSOCIATE_TAG, DELETE_TAG, ALTER_TAG. This trebuchet release fixes the corresponding SDK and documentation.
* `Aws\LocationService` - Amazon Location Service now includes a MaxResults parameter for GetDevicePositionHistory requests.
* `Aws\Polly` - Amazon Polly adds new Catalan voice - Arlet. Arlet is available as Neural voice only.

## 3.215.1 - 2022-03-21

* `Aws\ChimeSDKMeetings` - Add support for media replication to link multiple WebRTC media sessions together to reach larger and global audiences. Participants connected to a replica session can be granted access to join the primary session and can switch sessions with their existing WebRTC connection
* `Aws\ECR` - This release includes a fix in the DescribeImageScanFindings paginated output.
* `Aws\MediaConnect` - This release adds support for selecting a maintenance window.
* `Aws\QuickSight` - AWS QuickSight Service Features - Expand public API support for group management.
* `Aws\RAM` - Document improvements to the RAM API operations and parameter descriptions.

## 3.215.0 - 2022-03-18

* `Aws\Client` - Adds support for Lambda recursion detection.
* `Aws\Glue` - Added 9 new APIs for AWS Glue Interactive Sessions: ListSessions, StopSession, CreateSession, GetSession, DeleteSession, RunStatement, GetStatement, ListStatements, CancelStatement

## 3.214.0 - 2022-03-16

* `Aws\ACMPCA` - AWS Certificate Manager (ACM) Private Certificate Authority (CA) now supports customizable certificate subject names and extensions.
* `Aws\AmplifyBackend` - Adding the ability to customize Cognito verification messages for email and SMS in CreateBackendAuth and UpdateBackendAuth. Adding deprecation documentation for ForgotPassword in CreateBackendAuth and UpdateBackendAuth
* `Aws\BillingConductor` - This is the initial SDK release for AWS Billing Conductor. The AWS Billing Conductor is a customizable billing service, allowing you to customize your billing data to match your desired business structure.
* `Aws\S3Outposts` - S3 on Outposts is releasing a new API, ListSharedEndpoints, that lists all endpoints associated with S3 on Outpost, that has been shared by Resource Access Manager (RAM).
* `Aws\SSMIncidents` - Removed incorrect validation pattern for IncidentRecordSource.invokedBy

## 3.213.1 - 2022-03-15

* `Aws\CognitoIdentityProvider` - Updated EmailConfigurationType and SmsConfigurationType to reflect that you can now choose Amazon SES and Amazon SNS resources in the same Region.
* `Aws\DataExchange` - This feature enables data providers to use the RevokeRevision operation to revoke subscriber access to a given revision. Subscribers are unable to interact with assets within a revoked revision.
* `Aws\EC2` - Adds the Cascade parameter to the DeleteIpam API. Customers can use this parameter to automatically delete their IPAM, including non-default scopes, pools, cidrs, and allocations. There mustn't be any pools provisioned in the default public scope to use this parameter.
* `Aws\ECS` - Documentation only update to address tickets
* `Aws\Keyspaces` - Fixing formatting issues in CLI and SDK documentation
* `Aws\LocationService` - New HERE style "VectorHereExplore" and "VectorHereExploreTruck".
* `Aws\RDS` - Various documentation improvements
* `Aws\RoboMaker` - This release deprecates ROS, Ubuntu and Gazbeo from RoboMaker Simulation Service Software Suites in favor of user-supplied containers and Relaxed Software Suites.

## 3.213.0 - 2022-03-14

* `Aws\ConfigService` - Add resourceType enums for AWS::ECR::PublicRepository and AWS::EC2::LaunchTemplate
* `Aws\Credentials` - Add support for cases when IMDS is unable to refresh credentials
* `Aws\ElastiCache` - Doc only update for ElastiCache
* `Aws\TimestreamQuery` - Amazon Timestream Scheduled Queries now support Timestamp datatype in a multi-measure record.
* `Aws\kendra` - Amazon Kendra now provides a data source connector for Slack. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-slack.html

## 3.212.7 - 2022-03-11

* `Aws\Chime` - Chime VoiceConnector Logging APIs will now support MediaMetricLogs. Also CreateMeetingDialOut now returns AccessDeniedException.
* `Aws\Connect` - This release adds support for enabling Rich Messaging when starting a new chat session via the StartChatContact API. Rich Messaging enables the following formatting options: bold, italics, hyperlinks, bulleted lists, and numbered lists.
* `Aws\Lambda` - Adds PrincipalOrgID support to AddPermission API. Customers can use it to manage permissions to lambda functions at AWS Organizations level.
* `Aws\Outposts` - This release adds address filters for listSites
* `Aws\SecretsManager` - Documentation updates for Secrets Manager.
* `Aws\TranscribeStreamingService` - Amazon Transcribe StartTranscription API now supports additional parameters for Language Identification feature: customVocabularies and customFilterVocabularies

## 3.212.6 - 2022-03-10

* `Aws\` - Passing null to hash_init is deprecated on PHP 8.1.
* `Aws\LexModelsV2` - This release makes slotTypeId an optional parameter in CreateSlot and UpdateSlot APIs in Amazon Lex V2 for model building. Customers can create and update slots without specifying a slot type id.
* `Aws\TranscribeService` - Documentation fix for API `StartMedicalTranscriptionJobRequest`, now showing min sample rate as 16khz
* `Aws\Transfer` - Adding more descriptive error types for managed workflows

## 3.212.5 - 2022-03-09

* `Aws\Comprehend` - Amazon Comprehend now supports extracting the sentiment associated with entities such as brands, products and services from text documents.

## 3.212.4 - 2022-03-08

* `Aws\EKS` - Introducing a new enum for NodeGroup error code: Ec2SubnetMissingIpv6Assignment
* `Aws\Endpoints` - Fixes an issue where variant tags could be resolved in an order-dependent manner
* `Aws\Keyspaces` - Adding link to CloudTrail section in Amazon Keyspaces Developer Guide
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for reading timecode from AVCHD sources and now provides the ability to segment WebVTT at the same interval as the video and audio in HLS packages.

## 3.212.3 - 2022-03-07

* `Aws\ChimeSDKMeetings` - Adds support for Transcribe language identification feature to the StartMeetingTranscription API.
* `Aws\ECS` - Amazon ECS UpdateService API now supports additional parameters: loadBalancers, propagateTags, enableECSManagedTags, and serviceRegistries
* `Aws\MigrationHubRefactorSpaces` - AWS Migration Hub Refactor Spaces documentation update.

## 3.212.2 - 2022-03-04

* `Aws\Connect` - This release updates the *InstanceStorageConfig APIs so they support a new ResourceType: REAL_TIME_CONTACT_ANALYSIS_SEGMENTS. Use this resource type to enable streaming for real-time contact analysis and to associate the Kinesis stream where real-time contact analysis segments will be published.
* `Aws\DevOpsGuru` - Amazon DevOps Guru now integrates with Amazon CodeGuru Profiler. You can view CodeGuru Profiler recommendations for your AWS Lambda function in DevOps Guru. This feature is enabled by default for new customers as of 3/4/2022. Existing customers can enable this feature with UpdateEventSourcesConfig.
* `Aws\EC2` - Documentation updates for Amazon EC2.
* `Aws\Macie` - Amazon Macie Classic (macie) has been discontinued and is no longer available. A new Amazon Macie (macie2) is now available with significant design improvements and additional features.
* `Aws\STS` - Documentation updates for AWS Security Token Service.
* `Aws\Synthetics` - Allow custom handler function.
* `Aws\Transfer` - Add waiters for server online and offline.

## 3.212.1 - 2022-03-03

* `Aws\Appflow` - Launching Amazon AppFlow Marketo as a destination connector SDK.
* `Aws\FSx` - This release adds support for data repository associations to use root ("/") as the file system path
* `Aws\GreengrassV2` - Doc only update that clarifies Create Deployment section.
* `Aws\TimestreamQuery` - Documentation only update for SDK and CLI
* `Aws\kendra` - Amazon Kendra now suggests spell corrections for a query. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/query-spell-check.html

## 3.212.0 - 2022-03-02

* `Aws\Athena` - This release adds support for S3 Object Ownership by allowing the S3 bucket owner full control canned ACL to be set when Athena writes query results to S3 buckets.
* `Aws\CloudTrail` - Add bytesScanned field into responses of DescribeQuery and GetQueryResults.
* `Aws\ECR` - This release adds support for tracking images lastRecordedPullTime.
* `Aws\GameLift` - Minor updates to address errors.
* `Aws\Keyspaces` - This release adds support for data definition language (DDL) operations

## 3.211.1 - 2022-03-01

* `Aws\KafkaConnect` - Adds operation for custom plugin deletion (DeleteCustomPlugin) and adds new StateDescription field to DescribeCustomPlugin and DescribeConnector responses to return errors from asynchronous resource creation.
* `Aws\MediaPackage` - This release adds Hybridcast as an available profile option for Dash Origin Endpoints.
* `Aws\RDS` - Documentation updates for Multi-AZ DB clusters.
* `Aws\mgn` - Add support for GP3 and IO2 volume types. Add bootMode to LaunchConfiguration object (and as a parameter to UpdateLaunchConfigurationRequest).

## 3.211.0 - 2022-02-28

* `Aws\Amplify` - Add repositoryCloneMethod field for hosting an Amplify app. This field shows what authorization method is used to clone the repo: SSH, TOKEN, or SIGV4.
* `Aws\AmplifyUIBuilder` - We are adding the ability to configure workflows and actions for components.
* `Aws\AppRegistry` - AppRegistry is deprecating Application and Attribute-Group Name update feature. In this release, we are marking the name attributes for Update APIs as deprecated to give a heads up to our customers.
* `Aws\Athena` - This release adds support for updating an existing named query.
* `Aws\EC2` - This release adds support for new AMI property 'lastLaunchedTime'
* `Aws\FIS` - This release adds logging support for AWS Fault Injection Simulator experiments. Experiment templates can now be configured to send experiment activity logs to Amazon CloudWatch Logs or to an S3 bucket.
* `Aws\FSx` - This release adds support for the following FSx for OpenZFS features: snapshot lifecycle transition messages, force flag for deleting file systems with child resources, LZ4 data compression, custom record sizes, and unsetting volume quotas and reservations.
* `Aws\FinSpaceData` - Add new APIs for managing Users and Permission Groups.
* `Aws\Route53RecoveryCluster` - This release adds a new API option to enable overriding safety rules to allow routing control state updates.
* `Aws\S3` - Restores automatic content-md5 calculating as a result of S3 model changes

## 3.210.0 - 2022-02-25

* `Aws\ElastiCache` - Doc only update for ElastiCache
* `Aws\Panorama` - Added NTP server configuration parameter to ProvisionDevice operation. Added alternate software fields to DescribeDevice response
* `Aws\S3` - Adds support for flexible checksums

## 3.209.31 - 2022-02-24

* `Aws\AutoScaling` - You can now hibernate instances in a warm pool to stop instances without deleting their RAM contents. You can now also return instances to the warm pool on scale in, instead of always terminating capacity that you will need later.
* `Aws\FMS` - AWS Firewall Manager now supports the configuration of AWS Network Firewall policies with either centralized or distributed deployment models. This release also adds support for custom endpoint configuration, where you can choose which Availability Zones to create firewall endpoints in.
* `Aws\GlueDataBrew` - This AWS Glue Databrew release adds feature to merge job outputs into a max number of files for S3 File output type.
* `Aws\Lightsail` - This release adds support to delete and create Lightsail default key pairs that you can use with Lightsail instances.
* `Aws\Route53` - SDK doc update for Route 53 to update some parameters with new information.
* `Aws\S3` - This release adds support for new integrity checking capabilities in Amazon S3. You can choose from four supported checksum algorithms for data integrity checking on your upload and download requests. In addition, AWS SDK can automatically calculate a checksum as it streams data into S3
* `Aws\S3Control` - Amazon S3 Batch Operations adds support for new integrity checking capabilities in Amazon S3.
* `Aws\Transfer` - Support automatic pagination when listing AWS Transfer Family resources.

## 3.209.30 - 2022-02-23

* `Aws\Lambda` - Lambda releases .NET 6 managed runtime to be available in all commercial regions.
* `Aws\Textract` - Added support for merged cells and column header for table response.
* `Aws\Transfer` - The file input selection feature provides the ability to use either the originally uploaded file or the output file from the previous workflow step, enabling customers to make multiple copies of the original file while keeping the source file intact for file archival.

## 3.209.29 - 2022-02-22

* `Aws\AppRunner` - AWS App Runner adds a Java platform (Corretto 8, Corretto 11 runtimes) and a Node.js 14 runtime.
* `Aws\Translate` - This release enables customers to use translation settings for formality customization in their synchronous translation output.
* `Aws\WAFV2` - Updated descriptions for logging configuration.

## 3.209.28 - 2022-02-21

* `Aws\CustomerProfiles` - This release introduces apis CreateIntegrationWorkflow, DeleteWorkflow, ListWorkflows, GetWorkflow and GetWorkflowSteps. These apis are used to manage and view integration workflows.
* `Aws\DynamoDB` - DynamoDB ExecuteStatement API now supports Limit as a request parameter to specify the maximum number of items to evaluate. If specified, the service will process up to the Limit and the results will include a LastEvaluatedKey value to continue the read in a subsequent operation.
* `Aws\imagebuilder` - This release adds support to enable faster launching for Windows AMIs created by EC2 Image Builder.

## 3.209.27 - 2022-02-18

* `Aws\Budgets` - This change introduces DescribeBudgetNotificationsForAccount API which returns budget notifications for the specified account
* `Aws\GameLift` - Increase string list limit from 10 to 100.
* `Aws\Handler` - Fixes a bug where the PHP Error class couldn't be successfully caught in GuzzleV6/GuzzleHandler.
* `Aws\Transfer` - Properties for Transfer Family used with SFTP, FTP, and FTPS protocols. Display Banners are bodies of text that can be displayed before and/or after a user authenticates onto a server using one of the previously mentioned protocols.

## 3.209.26 - 2022-02-17

* `Aws\Backup` - AWS Backup add new S3_BACKUP_OBJECT_FAILED and S3_RESTORE_OBJECT_FAILED event types in BackupVaultNotifications events list.
* `Aws\CloudWatchEvidently` - Add support for filtering list of experiments and launches by status
* `Aws\IAM` - Documentation updates for AWS Identity and Access Management (IAM).
* `Aws\Redshift` - SDK release for Cross region datasharing and cost-control for cross region datasharing

## 3.209.25 - 2022-02-16

* `Aws\Budgets` - Adds support for auto-adjusting budgets, a new budget method alongside fixed and planned. Auto-adjusting budgets introduces new metadata to configure a budget limit baseline using a historical lookback average or current period forecast.
* `Aws\CostExplorer` - AWS Cost Anomaly Detection now supports SNS FIFO topic subscribers.
* `Aws\EC2` - Documentation updates for EC2.
* `Aws\Glue` - Support for optimistic locking in UpdateTable
* `Aws\SSM` - Assorted ticket fixes and updates for AWS Systems Manager.

## 3.209.24 - 2022-02-14

* `Aws\Appflow` - Launching Amazon AppFlow SAP as a destination connector SDK.
* `Aws\Athena` - This release adds a subfield, ErrorType, to the AthenaError response object in the GetQueryExecution API when a query fails.
* `Aws\RDS` - Adds support for determining which Aurora PostgreSQL versions support Babelfish.

## 3.209.23 - 2022-02-11

* `Aws\SSM` - Documentation updates for AWS Systems Manager.

## 3.209.22 - 2022-02-10

* `Aws\CloudFormation` - This SDK release adds AWS CloudFormation Hooks HandlerErrorCodes
* `Aws\LookoutforVision` - This release makes CompilerOptions in Lookout for Vision's StartModelPackagingJob's Configuration object optional.
* `Aws\Pinpoint` - This SDK release adds a new paramater creation date for GetApp and GetApps Api call
* `Aws\SNS` - Customer requested typo fix in API documentation.
* `Aws\WAFV2` - Adds support for AWS WAF Fraud Control account takeover prevention (ATP), with configuration options for the new managed rule group AWSManagedRulesATPRuleSet and support for application integration SDKs for Android and iOS mobile apps.

## 3.209.21 - 2022-02-09

* `Aws\CloudFormation` - This SDK release is for the feature launch of AWS CloudFormation Hooks.

## 3.209.20 - 2022-02-08

* `Aws\AppRunner` - This release adds support for App Runner to route outbound network traffic of a service through an Amazon VPC. New API: CreateVpcConnector, DescribeVpcConnector, ListVpcConnectors, and DeleteVpcConnector. Updated API: CreateService, DescribeService, and UpdateService.
* `Aws\S3Control` - This release adds support for S3 Batch Replication. Batch Replication lets you replicate existing objects, already replicated objects to new destinations, and objects that previously failed to replicate. Customers will receive object-level visibility of progress and a detailed completion report.
* `Aws\SageMaker` - Autopilot now generates an additional report with information on the performance of the best model, such as a Confusion matrix and Area under the receiver operating characteristic (AUC-ROC). The path to the report can be found in CandidateArtifactLocations.
* `Aws\kendra` - Amazon Kendra now provides a data source connector for Amazon FSx. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-fsx.html

## 3.209.19 - 2022-02-07

* `Aws\AuditManager` - This release updates 3 API parameters. UpdateAssessmentFrameworkControlSet now requires the controls attribute, and CreateAssessmentFrameworkControl requires the id attribute. Additionally, UpdateAssessmentFramework now has a minimum length constraint for the controlSets attribute.
* `Aws\EventBridge` - Documentation updates for EventBridge
* `Aws\SSMIncidents` - Update RelatedItem enum to support SSM Automation
* `Aws\Synthetics` - Adding names parameters to the Describe APIs.

## 3.209.18 - 2022-02-04

* `Aws\Athena` - You can now optionally specify the account ID that you expect to be the owner of your query results output location bucket in Athena. If the account ID of the query results bucket owner does not match the specified account ID, attempts to output to the bucket will fail with an S3 permissions error.
* `Aws\LakeFormation` - Add support for calling Update Table Objects without a TransactionId.
* `Aws\RDS` - updates for RDS Custom for Oracle 12.1 support
* `Aws\S3` - Improved error handling for failed writes and appends on unclosed streams.

## 3.209.17 - 2022-02-03

* `Aws\EC2` - adds support for AMIs in Recycle Bin
* `Aws\MarketplaceMetering` - Add CustomerAWSAccountId to ResolveCustomer API response and increase UsageAllocation limit to 2500.
* `Aws\RecycleBin` - Add EC2 Image recycle bin support.
* `Aws\RoboMaker` - The release deprecates the use various APIs of RoboMaker Deployment Service in favor of AWS IoT GreenGrass v2.0.

## 3.209.16 - 2022-02-02

* `Aws\Appflow` - Launching Amazon AppFlow Custom Connector SDK.
* `Aws\Comprehend` - Amazon Comprehend now supports sharing and importing custom trained models from one AWS account to another within the same region.
* `Aws\CostExplorer` - Doc-only update for Cost Explorer API that adds INVOICING_ENTITY dimensions
* `Aws\DynamoDB` - Documentation update for DynamoDB Java SDK.
* `Aws\EMR` - Documentation updates for Amazon EMR.
* `Aws\ElastiCache` - Documentation update for AWS ElastiCache
* `Aws\ElasticsearchService` - Allows customers to get progress updates for blue/green deployments
* `Aws\FIS` - Added GetTargetResourceType and ListTargetResourceTypesAPI actions. These actions return additional details about resource types and parameters that can be targeted by FIS actions. Added a parameters field for the targets that can be specified in experiment templates.
* `Aws\Glue` - Launch Protobuf support for AWS Glue Schema Registry
* `Aws\IoT` - This release adds support for configuring AWS IoT logging level per client ID, source IP, or principal ID.
* `Aws\Personalize` - Adding minRecommendationRequestsPerSecond attribute to recommender APIs.

## 3.209.15 - 2022-01-28

* `Aws\AppConfig` - Documentation updates for AWS AppConfig
* `Aws\AppConfigData` - Documentation updates for AWS AppConfig Data.
* `Aws\Athena` - This release adds a field, AthenaError, to the GetQueryExecution response object when a query fails.
* `Aws\CognitoIdentityProvider` - Doc updates for Cognito user pools API Reference.
* `Aws\SageMaker` - This release added a new NNA accelerator compilation support for Sagemaker Neo.
* `Aws\SecretsManager` - Feature are ready to release on Jan 28th

## 3.209.14 - 2022-01-27

* `Aws\Amplify` - Doc only update to the description of basicauthcredentials to describe the required encoding and format.
* `Aws\Connect` - This release adds support for configuring a custom chat duration when starting a new chat session via the StartChatContact API. The default value for chat duration is 25 hours, minimum configurable value is 1 hour (60 minutes) and maximum configurable value is 7 days (10,080 minutes).
* `Aws\EC2` - X2ezn instances are powered by Intel Cascade Lake CPUs that deliver turbo all core frequency of up to 4.5 GHz and up to 100 Gbps of networking bandwidth
* `Aws\Kafka` - Amazon MSK has updated the CreateCluster and UpdateBrokerStorage API that allows you to specify volume throughput during cluster creation and broker volume updates.
* `Aws\OpenSearchService` - Allows customers to get progress updates for blue/green deployments

## 3.209.13 - 2022-01-26

* `Aws\` - Update the API guide docs site to use the latest version of jquery and jquery-migrate.
* `Aws\CodeGuruReviewer` - Added failure state and adjusted timeout in waiter
* `Aws\EBS` - Documentation updates for Amazon EBS Direct APIs.
* `Aws\FraudDetector` - Added new APIs for viewing past predictions and obtaining prediction metadata including prediction explanations: ListEventPredictions and GetEventPredictionMetadata
* `Aws\SageMaker` - API changes relating to Fail steps in model building pipeline and add PipelineExecutionFailureReason in PipelineExecutionSummary.
* `Aws\SecurityHub` - Adding top level Sample boolean field

## 3.209.12 - 2022-01-25

* `Aws\Connect` - This release adds support for custom vocabularies to be used with Contact Lens. Custom vocabularies improve transcription accuracy for one or more specific words.
* `Aws\EFS` - Use Amazon EFS Replication to replicate your Amazon EFS file system in the AWS Region of your preference.
* `Aws\FSx` - This release adds support for growing SSD storage capacity and growing/shrinking SSD IOPS for FSx for ONTAP file systems.
* `Aws\GuardDuty` - Amazon GuardDuty expands threat detection coverage to protect Amazon Elastic Kubernetes Service (EKS) workloads.

## 3.209.11 - 2022-01-24

* `Aws\` - Suppress warning generated on is_readable calls to ini files
* `Aws\Route53RecoveryReadiness` - Updated documentation for Route53 Recovery Readiness APIs.

## 3.209.10 - 2022-01-21

* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for 4K AV1 output resolutions & 10-bit AV1 color, the ability to ingest sidecar Dolby Vision XML metadata files, and the ability to flag WebVTT and IMSC tracks for accessibility in HLS.
* `Aws\TranscribeService` - Add support for granular PIIEntityTypes when using Batch ContentRedaction.

## 3.209.9 - 2022-01-20

* `Aws\` - Add missing PHPDoc annotations for ArrayAccess and Countable implementations.
* `Aws\Connect` - This release adds tagging support for UserHierarchyGroups resource.
* `Aws\EC2` - C6i, M6i and R6i instances are powered by a third-generation Intel Xeon Scalable processor (Ice Lake) delivering all-core turbo frequency of 3.5 GHz
* `Aws\FIS` - Added action startTime and action endTime timestamp fields to the ExperimentAction object
* `Aws\GuardDuty` - Amazon GuardDuty findings now include remoteAccountDetails under AwsApiCallAction section if instance credential is exfiltrated.
* `Aws\MediaTailor` - This release adds support for multiple Segment Delivery Configurations. Users can provide a list of names and URLs when creating or editing a source location. When retrieving content, users can send a header to choose which URL should be used to serve content.

## 3.209.8 - 2022-01-19

* `Aws\EC2InstanceConnect` - Adds support for ED25519 keys. PushSSHPublicKey Availability Zone parameter is now optional. Adds EC2InstanceStateInvalidException for instances that are not running. This was previously a service exception, so this may require updating your code to handle this new exception.
* `Aws\Macie2` - This release of the Amazon Macie API introduces stricter validation of requests to create custom data identifiers.

## 3.209.7 - 2022-01-18

* `Aws\CloudTrail` - This release fixes a documentation bug in the description for the readOnly field selector in advanced event selectors. The description now clarifies that users omit the readOnly field selector to select both Read and Write management events.
* `Aws\EC2` - Add support for AWS Client VPN client login banner and session timeout.
* `Aws\IVS` - This release adds support for the new Thumbnail Configuration property for Recording Configurations. For more information see https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html
* `Aws\LocationService` - This release adds the CalculateRouteMatrix API which calculates routes for the provided departure and destination positions. The release also deprecates the use of pricing plan across all verticals.
* `Aws\StorageGateway` - Documentation update for adding bandwidth throttling support for S3 File Gateways.

## 3.209.6 - 2022-01-14

* `Aws\ApplicationInsights` - Application Insights support for Active Directory and SharePoint
* `Aws\ConfigService` - Update ResourceType enum with values for CodeDeploy, EC2 and Kinesis resources
* `Aws\Honeycode` - Added read and write api support for multi-select picklist. And added errorcode field to DescribeTableDataImportJob API output, when import job fails.
* `Aws\LookoutMetrics` - This release adds a new DeactivateAnomalyDetector API operation.
* `Aws\RAM` - This release adds the ListPermissionVersions API which lists the versions for a given permission.

## 3.209.5 - 2022-01-13

* `Aws\ElastiCache` - AWS ElastiCache for Redis has added a new Engine Log LogType in LogDelivery feature. You can now publish the Engine Log from your Amazon ElastiCache for Redis clusters to Amazon CloudWatch Logs and Amazon Kinesis Data Firehose.
* `Aws\Glue` - This SDK release adds support to pass run properties when starting a workflow run
* `Aws\LexRuntimeV2` - This release adds support for sending hints to Amazon Lex V2 runtime APIs. Bot developers can provide runtime hints to help improve the recognition of slot values.
* `Aws\NimbleStudio` - Amazon Nimble Studio now supports validation for Launch Profiles. Launch Profiles now report static validation results after create/update to detect errors in network or active directory configuration.
* `Aws\Pinpoint` - Adds JourneyChannelSettings to WriteJourneyRequest
* `Aws\SSM` - AWS Systems Manager adds category support for DescribeDocument API

## 3.209.4 - 2022-01-12

* `Aws\EC2` - Hpc6a instances are powered by a third-generation AMD EPYC processors (Milan) delivering all-core turbo frequency of 3.4 GHz
* `Aws\ElastiCache` - Doc only update for ElastiCache
* `Aws\FMS` - Shield Advanced policies for Amazon CloudFront resources now support automatic application layer DDoS mitigation. The max length for SecurityServicePolicyData ManagedServiceData is now 8192 characters, instead of 4096.
* `Aws\Honeycode` - Honeycode is releasing new APIs to allow user to create, delete and list tags on resources.
* `Aws\LexModelsV2` - This release adds support for Custom vocabulary in Amazon Lex V2 APIs for model building. Customers can give Amazon Lex V2 more information about how to process audio conversations with a bot by creating a custom vocabulary in a specific language.
* `Aws\PI` - This release adds three Performance Insights APIs. Use ListAvailableResourceMetrics to get available metrics, GetResourceMetadata to get feature metadata, and ListAvailableResourceDimensions to list available dimensions. The AdditionalMetrics field in DescribeDimensionKeys retrieves per-SQL metrics.

## 3.209.3 - 2022-01-11

* `Aws\CostExplorer` - Doc only update for Cost Explorer API that fixes missing clarifications for MatchOptions definitions
* `Aws\EC2` - EC2 Capacity Reservations now supports RHEL instance platforms (RHEL with SQL Server Standard, RHEL with SQL Server Enterprise, RHEL with SQL Server Web, RHEL with HA, RHEL with HA and SQL Server Standard, RHEL with HA and SQL Server Enterprise)
* `Aws\FinSpaceData` - Documentation updates for FinSpace.
* `Aws\IoTEventsData` - This release provides documentation updates for Timer.timestamp in the IoT Events API Reference Guide.
* `Aws\RDS` - This release adds the db-proxy event type to support subscribing to RDS Proxy events.
* `Aws\WorkSpaces` - Introducing new APIs for Workspaces audio optimization with Amazon Connect: CreateConnectClientAddIn, DescribeConnectClientAddIns, UpdateConnectClientAddIn and DeleteConnectClientAddIn.
* `Aws\kendra` - Amazon Kendra now supports advanced query language and query-less search.

## 3.209.2 - 2022-01-10

* `Aws\ComputeOptimizer` - Adds support for new Compute Optimizer capability that makes it easier for customers to optimize their EC2 instances by leveraging multiple CPU architectures.
* `Aws\EC2` - New feature: Updated EC2 API to support faster launching for Windows images. Optimized images are pre-provisioned, using snapshots to launch instances up to 65% faster.
* `Aws\GlueDataBrew` - This SDK release adds support for specifying a Bucket Owner for an S3 location.
* `Aws\LookoutMetrics` - This release adds FailureType in the response of DescribeAnomalyDetector.
* `Aws\TranscribeService` - Documentation updates for Amazon Transcribe.

## 3.209.1 - 2022-01-07

* `Aws\MediaLive` - This release adds support for selecting the Program Date Time (PDT) Clock source algorithm for HLS outputs.

## 3.209.0 - 2022-01-06

* `Aws\` - This commit adds defaults config: an opt-in feature which allows users to specify default configuration options to be loaded from a shared file
* `Aws\AppSync` - AppSync: AWS AppSync now supports configurable batching sizes for AWS Lambda resolvers, Direct AWS Lambda resolvers and pipeline functions
* `Aws\EC2` - This release introduces On-Demand Capacity Reservation support for Cluster Placement Groups, adds Tags on instance Metadata, and includes documentation updates for Amazon EC2.
* `Aws\ElasticsearchService` - Amazon OpenSearch Service adds support for Fine Grained Access Control for existing domains running Elasticsearch version 6.7 and above
* `Aws\IoTWireless` - Downlink Queue Management feature provides APIs for customers to manage the queued messages destined to device inside AWS IoT Core for LoRaWAN. Customer can view, delete or purge the queued message(s). It allows customer to preempt the queued messages and let more urgent messages go through.
* `Aws\MWAA` - This release adds a "Source" field that provides the initiator of an update, such as due to an automated patch from AWS or due to modification via Console or API.
* `Aws\MediaTailor` - This release adds support for filler slate when updating MediaTailor channels that use the linear playback mode.
* `Aws\OpenSearchService` - Amazon OpenSearch Service adds support for Fine Grained Access Control for existing domains running Elasticsearch version 6.7 and above

## 3.208.10 - 2022-01-05

* `Aws\AppStream` - Includes APIs for App Entitlement management regarding entitlement and entitled application association.
* `Aws\CloudTrail` - This release adds support for CloudTrail Lake, a new feature that lets you run SQL-based queries on events that you have aggregated into event data stores. New APIs have been added for creating and managing event data stores, and creating, running, and managing queries in CloudTrail Lake.
* `Aws\EC2` - This release adds a new API called ModifyVpcEndpointServicePayerResponsibility which allows VPC endpoint service owners to take payer responsibility of their VPC Endpoint connections.
* `Aws\ECS` - Documentation update for ticket fixes.
* `Aws\EKS` - Amazon EKS now supports running applications using IPv6 address space
* `Aws\Glue` - Add Delta Lake target support for Glue Crawler and 3rd Party Support for Lake Formation
* `Aws\IoT` - This release adds an automatic retry mechanism for AWS IoT Jobs. You can now define a maximum number of retries for each Job rollout, along with the criteria to trigger the retry for FAILED/TIMED_OUT/ALL(both FAILED an TIMED_OUT) job.
* `Aws\LakeFormation` - Add new APIs for 3rd Party Support for Lake Formation
* `Aws\QuickSight` - Multiple Doc-only updates for Amazon QuickSight.
* `Aws\SageMaker` - Amazon SageMaker now supports running training jobs on ml.g5 instance types.
* `Aws\Snowball` - Updating validation rules for interfaces used in the Snowball API to tighten security of service.

## 3.208.9 - 2022-01-04

* `Aws\Rekognition` - This release introduces a new field IndexFacesModelVersion, which is the version of the face detect and storage model that was used when indexing the face vector.
* `Aws\S3` - Minor doc-based updates based on feedback bugs received.
* `Aws\S3Control` - Documentation updates for the renaming of Glacier to Glacier Flexible Retrieval.

## 3.208.8 - 2022-01-03

* `Aws\Detective` - Added and updated API operations to support the Detective integration with AWS Organizations. New actions are used to manage the delegated administrator account and the integration configuration.
* `Aws\GreengrassV2` - This release adds the API operations to manage the Greengrass role associated with your account and to manage the core device connectivity information. Greengrass V2 customers can now depend solely on Greengrass V2 SDK for all the API operations needed to manage their fleets.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added strength levels to the Sharpness Filter and now permits OGG files to be specified as sidecar audio inputs.
* `Aws\RDS` - Multiple doc-only updates for Relational Database Service (RDS)
* `Aws\SageMaker` - The release allows users to pass pipeline definitions as Amazon S3 locations and control the pipeline execution concurrency using ParallelismConfiguration. It also adds support of EMR jobs as pipeline steps.

## 3.208.7 - 2021-12-21

* `Aws\ChimeSDKMessaging` - The Amazon Chime SDK now supports updating message attributes via channel flows
* `Aws\LookoutMetrics` - This release adds support for Causal Relationships. Added new ListAnomalyGroupRelatedMetrics API operation and InterMetricImpactDetails API data type
* `Aws\MediaConnect` - You can now use the Fujitsu-QoS protocol for your MediaConnect sources and outputs to transport content to and from Fujitsu devices.
* `Aws\NimbleStudio` - Amazon Nimble Studio adds support for users to upload files during a streaming session using NICE DCV native client or browser.
* `Aws\QLDB` - Amazon QLDB now supports journal exports in JSON and Ion Binary formats. This release adds an optional OutputFormat parameter to the ExportJournalToS3 API.
* `Aws\Transfer` - Property for Transfer Family used with the FTPS protocol. TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session.
* `Aws\WorkMail` - This release allows customers to change their email monitoring configuration in Amazon WorkMail.
* `Aws\imagebuilder` - Added a note to infrastructure configuration actions and data types concerning delivery of Image Builder event messages to encrypted SNS topics. The key that's used to encrypt the SNS topic must reside in the account that Image Builder runs under.

## 3.208.6 - 2021-12-20

* `Aws\APIGateway` - Documentation updates for Amazon API Gateway
* `Aws\CustomerProfiles` - This release adds an optional parameter, ObjectTypeNames to the PutIntegration API to support multiple object types per integration option. Besides, this release introduces Standard Order Objects which contain data from third party systems and each order object belongs to a specific profile.
* `Aws\DataSync` - AWS DataSync now supports FSx Lustre Locations.
* `Aws\DevOpsGuru` - Adds Tags support to DescribeOrganizationResourceCollectionHealth
* `Aws\FinSpaceData` - Make dataset description optional and allow s3 export for dataviews
* `Aws\ForecastService` - Adds ForecastDimensions field to the DescribeAutoPredictorResponse
* `Aws\LocationService` - Making PricingPlan optional as part of create resource API.
* `Aws\Redshift` - This release adds API support for managed Redshift datashares. Customers can now interact with a Redshift datashare that is managed by a different service, such as AWS Data Exchange.
* `Aws\SageMaker` - This release adds a new ContentType field in AutoMLChannel for SageMaker CreateAutoMLJob InputDataConfig.
* `Aws\SecurityHub` - Added new resource details objects to ASFF, including resources for Firewall, and RuleGroup, FirewallPolicy Added additional details for AutoScalingGroup, LaunchConfiguration, and S3 buckets.
* `Aws\imagebuilder` - This release adds support for importing and exporting VM Images as part of the Image Creation workflow via EC2 VM Import/Export.

## 3.208.5 - 2021-12-13

* `Aws\SecretsManager` - Documentation updates for Secrets Manager

## 3.208.4 - 2021-12-09

* `Aws\` - This release adds #[ReturnTypeWillChange] attribute where it is needed and fixes a deprecation notice when pass null to rawurlencode() for PHP 8.1 compatibility
* `Aws\EC2` - Adds waiters support for internet gateways.
* `Aws\LexModelsV2` - Added support for grammar slot type in Amazon Lex. You can author your own grammar in the XML format per the SRGS specification to collect information in a conversation.
* `Aws\NetworkFirewall` - This release adds support for managed rule groups.
* `Aws\Route53Domains` - Amazon Route 53 domain registration APIs now support filtering and sorting in the ListDomains API, deleting a domain by using the DeleteDomain API and getting domain pricing information by using the ListPrices API.
* `Aws\Route53RecoveryControlConfig` - This release adds tagging supports to Route53 Recovery Control Configuration. New APIs: TagResource, UntagResource and ListTagsForResource. Updates: add optional field `tags` to support tagging while calling CreateCluster, CreateControlPanel and CreateSafetyRule.
* `Aws\SMS` - This release adds SMS discontinuation information to the API and CLI references.
* `Aws\SavingsPlans` - Adds the ability to specify Savings Plans hourly commitments using five digits after the decimal point.

## 3.208.3 - 2021-12-08

* `Aws\CloudWatchLogs` - This release adds AWS Organizations support as condition key in destination policy for cross account Subscriptions in CloudWatch Logs.
* `Aws\ComprehendMedical` - This release adds a new set of APIs (synchronous and batch) to support the SNOMED-CT ontology.
* `Aws\Health` - Documentation updates for AWS Health
* `Aws\IoT` - This release allows customer to enable caching of custom authorizer on HTTP protocol for clients that use persistent or Keep-Alive connection in order to reduce the number of Lambda invocations.
* `Aws\LookoutforVision` - This release adds new APIs for packaging an Amazon Lookout for Vision model as an AWS IoT Greengrass component.
* `Aws\Outposts` - This release adds the UpdateOutpost API.
* `Aws\SageMaker` - This release added a new Ambarella device(amba_cv2) compilation support for Sagemaker Neo.
* `Aws\Support` - Documentation updates for AWS Support.

## 3.208.2 - 2021-12-06

* `Aws\AppSync` - AWS AppSync now supports custom domain names, allowing you to associate a domain name that you own with an AppSync API in your account.
* `Aws\LocationService` - This release adds support for Accuracy position filtering, position metadata and autocomplete for addresses and points of interest based on partial or misspelled free-form text.
* `Aws\Route53` - Add PriorRequestNotComplete exception to UpdateHostedZoneComment API

## 3.208.1 - 2021-12-03

* `Aws\Rekognition` - This release added new KnownGender types for Celebrity Recognition.

## 3.208.0 - 2021-12-02

* `Aws\AmplifyUIBuilder` - This release introduces the actions and data types for the new Amplify UI Builder API. The Amplify UI Builder API provides a programmatic interface for creating and configuring user interface (UI) component libraries and themes for use in Amplify applications.
* `Aws\NetworkManager` - This release adds API support for AWS Cloud WAN.
* `Aws\RAM` - This release adds the ability to use the new ResourceRegionScope parameter on List operations that return lists of resources or resource types. This new parameter filters the results by letting you differentiate between global or regional resource types.

## 3.207.1 - 2021-12-01

* `Aws\DevOpsGuru` - DevOps Guru now provides detailed, database-specific analyses of performance issues and recommends corrective actions for Amazon Aurora database instances with Performance Insights turned on. You can also use AWS tags to choose which resources to analyze and define your applications.
* `Aws\DirectConnect` - Adds SiteLink support to private and transit virtual interfaces. SiteLink is a new Direct Connect feature that allows routing between Direct Connect points of presence.
* `Aws\DynamoDB` - Add support for Table Classes and introduce the Standard Infrequent Access table class.
* `Aws\EC2` - This release adds support for Amazon VPC IP Address Manager (IPAM), which enables you to plan, track, and monitor IP addresses for your workloads. This release also adds support for VPC Network Access Analyzer, which enables you to analyze network access to resources in your Virtual Private Clouds.
* `Aws\LexModelsV2` - This release introduces a new feature, Automated Chatbot Designer, that helps customers automatically create a bot design from existing conversation transcripts. The feature uses machine learning to discover most common intents and the information needed to fulfill them.
* `Aws\SageMaker` - This release enables - 1/ Inference endpoint configuration recommendations and ability to run custom load tests to meet performance needs. 2/ Deploy serverless inference endpoints. 3/ Query, filter and retrieve end-to-end ML lineage graph, and incorporate model quality/bias detection in ML workflow.
* `Aws\SageMakerRuntime` - Adding new exception types for InvokeEndpoint
* `Aws\Shield` - This release adds API support for Automatic Application Layer DDoS Mitigation for AWS Shield Advanced. Customers can now enable automatic DDoS mitigation in count or block mode for layer 7 protected resources.
* `Aws\kendra` - Experience Builder allows customers to build search applications without writing code. Analytics Dashboard provides quality and usability metrics for Kendra indexes. Custom Document Enrichment allows customers to build a custom ingestion pipeline to pre-process documents and generate metadata.

## 3.207.0 - 2021-11-30

* `Aws\AccessAnalyzer` - AWS IAM Access Analyzer now supports policy validation for resource policies attached to S3 buckets and access points. You can run additional policy checks by specifying the S3 resource type you want to attach to your resource policy.
* `Aws\BackupGateway` - Initial release of AWS Backup gateway which enables you to centralize and automate protection of on-premises VMware and VMware Cloud on AWS workloads using AWS Backup.
* `Aws\EC2` - This release adds support for Is4gen and Im4gn instances. This release also adds a new subnet attribute, enableLniAtDeviceIndex, to support local network interfaces, which are logical networking components that connect an EC2 instance to your on-premises network.
* `Aws\FSx` - This release adds support for the FSx for OpenZFS file system type, FSx for Lustre file systems with the Persistent_2 deployment type, and FSx for Lustre file systems with Amazon S3 data repository associations and automatic export policies.
* `Aws\Glue` - Support for DataLake transactions
* `Aws\IoT` - Added the ability to enable/disable IoT Fleet Indexing for Device Defender and Named Shadow information, and search them through IoT Fleet Indexing APIs.
* `Aws\IoTTwinMaker` - AWS IoT TwinMaker makes it faster and easier to create, visualize and monitor digital twins of real-world systems like buildings, factories and industrial equipment to optimize operations. Learn more: https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/Welcome.html (New Service) (Preview)
* `Aws\Kafka` - This release adds three new V2 APIs. CreateClusterV2 for creating both provisioned and serverless clusters. DescribeClusterV2 for getting information about provisioned and serverless clusters and ListClustersV2 for listing all clusters (both provisioned and serverless) in your account.
* `Aws\Kinesis` - Amazon Kinesis Data Streams now supports on demand streams.
* `Aws\LakeFormation` - This release adds support for row and cell-based access control in Lake Formation. It also adds support for Lake Formation Governed Tables, which support ACID transactions and automatic storage optimizations.
* `Aws\Outposts` - This release adds the SupportedHardwareType parameter to CreateOutpost.
* `Aws\RedshiftDataAPIService` - Data API now supports serverless queries.
* `Aws\S3` - Introduce Amazon S3 Glacier Instant Retrieval storage class and a new setting in S3 Object Ownership to disable ACLs for bucket and the objects in it.
* `Aws\Snowball` - Tapeball is to integrate tape gateway onto snowball, it enables customer to transfer local data on the tape to snowball,and then ingest the data into tape gateway on the cloud.
* `Aws\StorageGateway` - Added gateway type VTL_SNOW. Added new SNOWBALL HostEnvironment for gateways running on a Snowball device. Added new field HostEnvironmentId to serve as an identifier for the HostEnvironment on which the gateway is running.
* `Aws\WorkSpacesWeb` - This is the initial SDK release for Amazon WorkSpaces Web. Amazon WorkSpaces Web is a low-cost, fully managed WorkSpace built to deliver secure web-based workloads and software-as-a-service (SaaS) application access to users within existing web browsers.

## 3.206.0 - 2021-11-29

* `Aws\CloudWatchEvidently` - Introducing Amazon CloudWatch Evidently. This is the first public release of Amazon CloudWatch Evidently.
* `Aws\CloudWatchRUM` - This is the first public release of CloudWatch RUM
* `Aws\ComputeOptimizer` - Adds support for the enhanced infrastructure metrics paid feature. Also adds support for two new sets of resource efficiency metrics, including savings opportunity metrics and performance improvement opportunity metrics.
* `Aws\DataExchange` - This release enables providers and subscribers to use Data Set, Job, and Asset operations to work with API assets from Amazon API Gateway. In addition, this release enables subscribers to use the SendApiAsset operation to invoke a provider's Amazon API Gateway API that they are entitled to.
* `Aws\EC2` - This release adds support for G5g and M6a instances. This release also adds support for Amazon EBS Snapshots Archive, a feature that enables you to archive your EBS snapshots; and Recycle Bin, a feature that enables you to protect your EBS snapshots against accidental deletion.
* `Aws\ECR` - This release adds supports for pull through cache rules and enhanced scanning.
* `Aws\Inspector2` - This release adds support for the new Amazon Inspector API. The new Amazon Inspector can automatically discover and scan Amazon EC2 instances and Amazon ECR container images for software vulnerabilities and unintended network exposure, and report centralized findings across multiple AWS accounts.
* `Aws\IoTSiteWise` - AWS IoT SiteWise now supports retention configuration for the hot tier storage.
* `Aws\RecycleBin` - This release adds support for Recycle Bin.
* `Aws\S3` - Amazon S3 Event Notifications adds Amazon EventBridge as a destination and supports additional event types. The PutBucketNotificationConfiguration API can now skip validation of Amazon SQS, Amazon SNS and AWS Lambda destinations.
* `Aws\SSM` - Added two new attributes to DescribeInstanceInformation called SourceId and SourceType along with new string filters SourceIds and SourceTypes to filter instance records.
* `Aws\WellArchitected` - This update provides support for Well-Architected API users to use custom lens features.

## 3.205.0 - 2021-11-29

* `Aws\MigrationHubRefactorSpaces` - This is the initial SDK release for AWS Migration Hub Refactor Spaces
* `Aws\Personalize` - This release adds API support for Recommenders and BatchSegmentJobs.
* `Aws\PersonalizeRuntime` - This release adds inference support for Recommenders.
* `Aws\Textract` - This release adds support for synchronously analyzing identity documents through a new API: AnalyzeID

## 3.204.6 - 2021-11-26

* `Aws\AutoScaling` - Documentation updates for Amazon EC2 Auto Scaling.
* `Aws\EC2` - Documentation updates for EC2.
* `Aws\IoTDeviceAdvisor` - Documentation update for Device Advisor GetEndpoint API
* `Aws\Outposts` - This release adds new APIs for working with Outpost sites and orders.
* `Aws\Pinpoint` - Added a One-Time Password (OTP) management feature. You can use the Amazon Pinpoint API to generate OTP codes and send them to your users as SMS messages. Your apps can then call the API to verify the OTP codes that your users input
* `Aws\mgn` - Application Migration Service now supports an additional replication method that does not require agent installation on each source server. This option is available for source servers running on VMware vCenter versions 6.7 and 7.0.

## 3.204.5 - 2021-11-24

* `Aws\AutoScaling` - Customers can now configure predictive scaling policies to proactively scale EC2 Auto Scaling groups based on any CloudWatch metrics that more accurately represent the load on the group than the four predefined metrics. They can also use math expressions to further customize the metrics.
* `Aws\CustomerProfiles` - This release introduces a new auto-merging feature for profile matching. The auto-merging configurations can be set via CreateDomain API or UpdateDomain API. You can use GetIdentityResolutionJob API and ListIdentityResolutionJobs API to fetch job status.
* `Aws\ElastiCache` - Doc only update for ElastiCache
* `Aws\IoTSiteWise` - AWS IoT SiteWise now accepts data streams that aren't associated with any asset properties. You can organize data by updating data stream associations.
* `Aws\Lambda` - Remove Lambda function url apis
* `Aws\Proton` - This release adds APIs for getting the outputs and provisioned stacks for Environments, Pipelines, and ServiceInstances. You can now add tags to EnvironmentAccountConnections. It also adds APIs for working with PR-based provisioning. Also, it adds APIs for syncing templates with a git repository.
* `Aws\TimestreamQuery` - Releasing Amazon Timestream Scheduled Queries. It makes real-time analytics more performant and cost-effective for customers by calculating and storing frequently accessed aggregates, and other computations, typically used in operational dashboards, business reports, and other analytics applications
* `Aws\TimestreamWrite` - This release adds support for multi-measure records and magnetic store writes. Multi-measure records allow customers to store multiple measures in a single table row. Magnetic store writes enable customers to write late arrival data (data with timestamp in the past) directly into the magnetic store.
* `Aws\Translate` - This release enables customers to use translation settings to mask profane words and phrases in their translation output.
* `Aws\imagebuilder` - This release adds support for sharing AMIs with Organizations within an EC2 Image Builder Distribution Configuration.

## 3.204.4 - 2021-11-23

* `Aws\Backup` - This release adds new opt-in settings for advanced features for DynamoDB backups
* `Aws\DynamoDB` - DynamoDB PartiQL now supports ReturnConsumedCapacity, which returns capacity units consumed by PartiQL APIs if the request specified returnConsumedCapacity parameter. PartiQL APIs include ExecuteStatement, BatchExecuteStatement, and ExecuteTransaction.
* `Aws\EC2` - This release adds a new parameter ipv6Native to the allow creation of IPv6-only subnets using the CreateSubnet operation, and the operation ModifySubnetAttribute includes new parameters to modify subnet attributes to use resource-based naming and enable DNS resolutions for Private DNS name.
* `Aws\ECS` - Documentation update for ARM support on Amazon ECS.
* `Aws\ElastiCache` - Adding support for r6gd instances for Redis with data tiering. In a cluster with data tiering enabled, when available memory capacity is exhausted, the least recently used data is automatically tiered to solid state drives for cost-effective capacity scaling with minimal performance impact.
* `Aws\ElasticLoadBalancingv2` - This release allows you to create internal Application and Network Load Balancers in dualstack mode. This release also adds an attribute to block internet gateway (IGW) access to the load balancer, preventing unintended access to your internal load balancers through an internet gateway.
* `Aws\FinSpaceData` - Update documentation for createChangeset API.
* `Aws\IoT` - This release introduces a new feature, Managed Job Template, for AWS IoT Jobs Service. Customers can now use service provided managed job templates to easily create jobs for supported standard job actions.
* `Aws\IoTDeviceAdvisor` - This release introduces a new feature for Device Advisor: ability to execute multiple test suites in parallel for given customer account. You can use GetEndpoint API to get the device-level test endpoint and call StartSuiteRun with "parallelRun=true" to run suites in parallel.
* `Aws\IoTWireless` - Two new APIs, GetNetworkAnalyzerConfiguration and UpdateNetworkAnalyzerConfiguration, are added for the newly released Network Analyzer feature which enables customers to view real-time frame information and logs from LoRaWAN devices and gateways.
* `Aws\Lambda` - Release Lambda event source filtering for SQS, Kinesis Streams, and DynamoDB Streams.
* `Aws\Macie2` - Documentation updates for Amazon Macie
* `Aws\OpenSearchService` - This release adds an optional parameter dry-run for the UpdateDomainConfig API to perform basic validation checks, and detect the deployment type that will be required for the configuration change, without actually applying the change.
* `Aws\RDS` - Adds support for Multi-AZ DB clusters for RDS for MySQL and RDS for PostgreSQL.
* `Aws\Redshift` - This release adds support for reserved node exchange with restore/resize
* `Aws\S3` - Introduce two new Filters to S3 Lifecycle configurations - ObjectSizeGreaterThan and ObjectSizeLessThan. Introduce a new way to trigger actions on noncurrent versions by providing the number of newer noncurrent versions along with noncurrent days.
* `Aws\SQS` - Amazon SQS adds a new queue attribute, SqsManagedSseEnabled, which enables server-side queue encryption using SQS owned encryption keys.
* `Aws\STS` - Documentation updates for AWS Security Token Service.
* `Aws\WorkSpaces` - Documentation updates for Amazon WorkSpaces

## 3.204.3 - 2021-11-22

* `Aws\Braket` - This release adds support for Amazon Braket Hybrid Jobs.
* `Aws\ChimeSDKMeetings` - Added new APIs for enabling Echo Reduction with Voice Focus.
* `Aws\CloudFormation` - This release include SDK changes for the feature launch of Stack Import to Service Managed StackSet.
* `Aws\Connect` - This release adds support for UpdateContactFlowMetadata, DeleteContactFlow and module APIs. For details, see the Release Notes in the Amazon Connect Administrator Guide.
* `Aws\DatabaseMigrationService` - Added new S3 endpoint settings to allow to convert the current UTC time into a specified time zone when a date partition folder is created. Using with 'DatePartitionedEnabled'.
* `Aws\EKS` - Adding missing exceptions to RegisterCluster operation
* `Aws\ElasticsearchService` - This release adds an optional parameter dry-run for the UpdateElasticsearchDomainConfig API to perform basic validation checks, and detect the deployment type that will be required for the configuration change, without actually applying the change.
* `Aws\FinSpaceData` - Add new APIs for managing Datasets, Changesets, and Dataviews.
* `Aws\QuickSight` - Add support for Exasol data source, 1 click enterprise embedding and email customization.
* `Aws\RDS` - Adds local backup support to Amazon RDS on AWS Outposts.
* `Aws\S3Control` - Added Amazon CloudWatch publishing option for S3 Storage Lens metrics.
* `Aws\SSM` - Adds new parameter to CreateActivation API . This parameter is for "internal use only".
* `Aws\TranscribeStreamingService` - This release adds language identification support for streaming transcription.

## 3.204.2 - 2021-11-19

* `Aws\AppStream` - Includes APIs for managing resources for Elastic fleets: applications, app blocks, and application-fleet associations.
* `Aws\ApplicationInsights` - Application Insights now supports monitoring for HANA
* `Aws\Batch` - Documentation updates for AWS Batch.
* `Aws\CloudFormation` - The StackSets ManagedExecution feature will allow concurrency for non-conflicting StackSet operations and queuing the StackSet operations that conflict at a given time for later execution.
* `Aws\Endpoints` - Fixes exception that some customers were getting with the new fips configuration provider where it couldn't find the is_fips_pseudo_region function
* `Aws\Lambda` - Add support for Lambda Function URLs. Customers can use Function URLs to create built-in HTTPS endpoints on their functions.
* `Aws\LexRuntimeV2` - Now supports styled slots in Lex V2 runtime. Customers can provide inputs like "a as in apple b for beta" which will be resolved to "ab" as slot value.
* `Aws\MediaLive` - This release adds support for specifying a SCTE-35 PID on input. MediaLive now supports SCTE-35 PID selection on inputs containing one or more active SCTE-35 PIDs.
* `Aws\Redshift` - Added support of default IAM role for CreateCluster, RestoreFromClusterSnapshot and ModifyClusterIamRoles APIs

## 3.204.1 - 2021-11-18

* `Aws\AppConfig` - Add Type to support feature flag configuration profiles
* `Aws\AuditManager` - This release introduces a new feature for Audit Manager: Dashboard views. You can now view insights data for your active assessments, and quickly identify non-compliant evidence that needs to be remediated.
* `Aws\Chime` - Adds new Transcribe API parameters to StartMeetingTranscription, including support for content identification and redaction (PII & PHI), partial results stabilization, and custom language models.
* `Aws\ChimeSDKMeetings` - Adds new Transcribe API parameters to StartMeetingTranscription, including support for content identification and redaction (PII & PHI), partial results stabilization, and custom language models.
* `Aws\CloudWatch` - CloudWatch Anomaly Detection now supports anomaly detectors that use metric math as input.
* `Aws\ForecastService` - NEW CreateExplanability API that helps you understand how attributes such as price, promotion, etc. contributes to your forecasted values; NEW CreateAutoPredictor API that trains up to 40% more accurate forecasting model, saves up to 50% of retraining time, and provides model level explainability.
* `Aws\GlueDataBrew` - This SDK release adds the following new features: 1) PII detection in profile jobs, 2) Data quality rules, enabling validation of data quality in profile jobs, 3) SQL query-based datasets for Amazon Redshift and Snowflake data sources, and 4) Connecting DataBrew datasets with Amazon AppFlow flows.
* `Aws\IVS` - Add APIs for retrieving stream session information and support for filtering live streams by health. For more information, see https://docs.aws.amazon.com/ivs/latest/userguide/stream-health.html
* `Aws\Kafka` - Amazon MSK has added a new API that allows you to update the connectivity settings for an existing cluster to enable public accessibility.
* `Aws\Lambda` - Added support for CLIENT_CERTIFICATE_TLS_AUTH and SERVER_ROOT_CA_CERTIFICATE as SourceAccessType for MSK and Kafka event source mappings.
* `Aws\LexModelsV2` - Added support for Polly Neural TTS (NTTS) voices. Customers can choose between 'standard' and 'neural' for Polly Engine configuration per locale when creating or updating an Amazon Lex bot.
* `Aws\RedshiftDataAPIService` - Rolling back Data API serverless features until dependencies are live.

## 3.204.0 - 2021-11-17

* `Aws\APIGateway` - Documentation updates for Amazon API Gateway.
* `Aws\AmplifyBackend` - New APIs to support the Amplify Storage category. Add and manage file storage in your Amplify app backend.
* `Aws\AppConfigData` - AWS AppConfig Data is a new service that allows you to retrieve configuration deployed by AWS AppConfig. See the AppConfig user guide for more details on getting started. https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html
* `Aws\DevOpsGuru` - Add paginator for DescribeResourceCollectionHealth
* `Aws\RedshiftDataAPIService` - Data API now supports serverless requests.
* `Aws\SNS` - Amazon SNS introduces the PublishBatch API, which enables customers to publish up to 10 messages per API request. The new API is valid for Standard and FIFO topics.
* `Aws\drs` - Introducing AWS Elastic Disaster Recovery (AWS DRS), a new service that minimizes downtime and data loss with fast, reliable recovery of on-premises and cloud-based applications using affordable storage, minimal compute, and point-in-time recovery.

## 3.203.1 - 2021-11-16

* `Aws\CloudTrail` - CloudTrail Insights now supports ApiErrorRateInsight, which enables customers to identify unusual activity in their AWS account based on API error codes and their rate.
* `Aws\LocationService` - This release adds the support for Relevance, Distance, Time Zone, Language and Interpolated Address for Geocoding and Reverse Geocoding.

## 3.203.0 - 2021-11-15

* `Aws\AppStream` - This release includes support for images of AmazonLinux2 platform type.
* `Aws\DatabaseMigrationService` - Add Settings in JSON format for the source GCP MySQL endpoint
* `Aws\EC2` - Adds a new VPC Subnet attribute "EnableDns64." When enabled on IPv6 Subnets, the Amazon-Provided DNS Resolver returns synthetic IPv6 addresses for IPv4-only destinations.
* `Aws\EKS` - Adding Tags support to Cluster Registrations.
* `Aws\MigrationHubStrategyRecommendations` - AWS SDK for Migration Hub Strategy Recommendations. It includes APIs to start the portfolio assessment, import portfolio data for assessment, and to retrieve recommendations. For more information, see the AWS Migration Hub documentation at https://docs.aws.amazon.com/migrationhub/index.html
* `Aws\SSM` - Adds support for Session Reason and Max Session Duration for Systems Manager Session Manager.
* `Aws\Transfer` - AWS Transfer Family now supports integrating a custom identity provider using AWS Lambda
* `Aws\WAFV2` - Your options for logging web ACL traffic now include Amazon CloudWatch Logs log groups and Amazon S3 buckets.

## 3.202.2 - 2021-11-12

* `Aws\Connect` - This release adds APIs for creating and managing scheduled tasks. Additionally, adds APIs to describe and update a contact and list associated references.
* `Aws\DevOpsGuru` - Add support for cross account APIs.
* `Aws\EC2` - C6i instances are powered by a third-generation Intel Xeon Scalable processor (Ice Lake) delivering all-core turbo frequency of 3.5 GHz. G5 instances feature up to 8 NVIDIA A10G Tensor Core GPUs and second generation AMD EPYC processors.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added automatic modes for GOP configuration and added the ability to ingest screen recordings generated by Safari on MacOS 12 Monterey.
* `Aws\SSM` - This Patch Manager release supports creating Patch Baselines for RaspberryPi OS (formerly Raspbian)

## 3.202.1 - 2021-11-11

* `Aws\DynamoDB` - Updated Help section for "dynamodb update-contributor-insights" API
* `Aws\EC2` - This release provides an additional route target for the VPC route table.
* `Aws\Translate` - This release enables customers to import Multi-Directional Custom Terminology and use Multi-Directional Custom Terminology in both real-time translation and asynchronous batch translation.

## 3.202.0 - 2021-11-10

* `Aws\Backup` - AWS Backup SDK provides new options when scheduling backups: select supported services and resources that are assigned to a particular tag, linked to a combination of tags, or can be identified by a partial tag value, and exclude resources from their assignments.
* `Aws\ECS` - This release adds support for container instance health.
* `Aws\ResilienceHub` - Initial release of AWS Resilience Hub, a managed service that enables you to define, validate, and track the resilience of your applications on AWS

## 3.201.0 - 2021-11-09

* `Aws\` - Added support for services to add fips and dualstack endpoint information to the endpoints.json file and have it resolve a custom endpoint.
* `Aws\Batch` - Adds support for scheduling policy APIs.
* `Aws\GreengrassV2` - This release adds support for Greengrass core devices running Windows. You can now specify name of a Windows user to run a component.
* `Aws\Health` - Documentation updates for AWS Health.

## 3.200.2 - 2021-11-08

* `Aws\ChimeSDKMeetings` - Updated format validation for ids and regions.
* `Aws\EC2` - This release adds internal validation on the GatewayAssociationState field
* `Aws\SageMaker` - SageMaker CreateEndpoint and UpdateEndpoint APIs now support additional deployment configuration to manage traffic shifting options and automatic rollback monitoring. DescribeEndpoint now shows new in-progress deployment details with stage status.
* `Aws\WAFV2` - You can now configure rules to run a CAPTCHA check against web requests and, as needed, send a CAPTCHA challenge to the client.

## 3.200.1 - 2021-11-05

* `Aws\Api` - Fixed issue where comma delimited unix timestamps could not be parsed
* `Aws\EC2` - DescribeInstances now returns customer-owned IP addresses for instances running on an AWS Outpost.
* `Aws\ResourceGroupsTaggingAPI` - Documentation updates and improvements.
* `Aws\Translate` - This release enable customers to use their own KMS keys to encrypt output files when they submit a batch transform job.

## 3.200.0 - 2021-11-04

* `Aws\ChimeSDKMeetings` - The Amazon Chime SDK Meetings APIs allow software developers to create meetings and attendees for interactive audio, video, screen and content sharing in custom meeting applications which use the Amazon Chime SDK.
* `Aws\Connect` - This release adds CRUD operation support for Security profile resource in Amazon Connect
* `Aws\EC2` - This release adds a new instance replacement strategy for EC2 Fleet, Spot Fleet. Now you can select an action to perform when your instance gets a rebalance notification. EC2 Fleet, Spot Fleet can launch a replacement then terminate the instance that received notification after a termination delay
* `Aws\IoTWireless` - Adding APIs for the FUOTA (firmware update over the air) and multicast for LoRaWAN devices and APIs to support event notification opt-in feature for Sidewalk related events. A few existing APIs need to be modified for this new feature.
* `Aws\SageMaker` - ListDevices and DescribeDevice now show Edge Manager agent version.

## 3.199.10 - 2021-11-03

* `Aws\ConnectParticipant` - This release adds a new boolean attribute - Connect Participant - to the CreateParticipantConnection API, which can be used to mark the participant as connected.
* `Aws\DataSync` - AWS DataSync now supports Hadoop Distributed File System (HDFS) Locations
* `Aws\Macie2` - This release adds support for specifying the severity of findings that a custom data identifier produces, based on the number of occurrences of text that matches the detection criteria.
* `Aws\finspace` - Adds superuser and data-bundle parameters to CreateEnvironment API

## 3.199.9 - 2021-11-02

* `Aws\CloudFront` - CloudFront now supports response headers policies to add HTTP headers to the responses that CloudFront sends to viewers. You can use these policies to add CORS headers, control browser caching, and more, without modifying your origin or writing any code.
* `Aws\Connect` - Amazon Connect Chat now supports real-time message streaming.
* `Aws\NimbleStudio` - Amazon Nimble Studio adds support for users to stop and start streaming sessions.

## 3.199.8 - 2021-11-01

* `Aws\Lightsail` - This release adds support to enable access logging for buckets in the Lightsail object storage service.
* `Aws\Neptune` - Adds support for major version upgrades to ModifyDbCluster API
* `Aws\NetworkManager` - This release adds API support to aggregate resources, routes, and telemetry data across a Global Network.
* `Aws\Rekognition` - This Amazon Rekognition Custom Labels release introduces the management of datasets with projects

## 3.199.7 - 2021-10-29

* `Aws\ApplicationInsights` - Added Monitoring support for SQL Server Failover Cluster Instance. Additionally, added a new API to allow one-click monitoring of containers resources.
* `Aws\Connect` - Amazon Connect Chat now supports real-time message streaming.
* `Aws\EC2` - Support added for AMI sharing with organizations and organizational units in ModifyImageAttribute API
* `Aws\Rekognition` - This release added new attributes to Rekognition Video GetCelebrityRecognition API operations.
* `Aws\TranscribeService` - Transcribe and Transcribe Call Analytics now support automatic language identification along with custom vocabulary, vocabulary filter, custom language model and PII redaction.

## 3.199.6 - 2021-10-28

* `Aws\ConnectParticipant` - This release adds a new boolean attribute - Connect Participant - to the CreateParticipantConnection API, which can be used to mark the participant as connected.
* `Aws\EC2` - Added new read-only DenyAllIGWTraffic network interface attribute. Added support for DL1 24xlarge instances powered by Habana Gaudi Accelerators for deep learning model training workloads
* `Aws\ECS` - Amazon ECS now supports running Fargate tasks on Windows Operating Systems Families which includes Windows Server 2019 Core and Windows Server 2019 Full.
* `Aws\GameLift` - Added support for Arm-based AWS Graviton2 instances, such as M6g, C6g, and R6g.
* `Aws\SSMIncidents` - Updating documentation, adding new field to ConflictException to indicate earliest retry timestamp for some operations, increase maximum length of nextToken fields
* `Aws\SageMaker` - This release adds support for RStudio on SageMaker.

## 3.199.5 - 2021-10-27

* `Aws\AutoScaling` - This release adds support for attribute-based instance type selection, a new EC2 Auto Scaling feature that lets customers express their instance requirements as a set of attributes, such as vCPU, memory, and storage.
* `Aws\Credentials` - Deletes an unused symlink that is breaking some containers.
* `Aws\EC2` - This release adds: attribute-based instance type selection for EC2 Fleet, Spot Fleet, a feature that lets customers express instance requirements as attributes like vCPU, memory, and storage; and Spot placement score, a feature that helps customers identify an optimal location to run Spot workloads.
* `Aws\EKS` - EKS managed node groups now support BOTTLEROCKET_x86_64 and BOTTLEROCKET_ARM_64 AMI types.
* `Aws\SageMaker` - This release allows customers to describe one or more versioned model packages through BatchDescribeModelPackage, update project via UpdateProject, modify and read customer metadata properties using Create, Update and Describe ModelPackage and enables cross account registration of model packages.
* `Aws\Textract` - This release adds support for asynchronously analyzing invoice and receipt documents through two new APIs: StartExpenseAnalysis and GetExpenseAnalysis

## 3.199.4 - 2021-10-26

* `Aws\ChimeSDKIdentity` - The Amazon Chime SDK now supports push notifications through Amazon Pinpoint
* `Aws\ChimeSDKMessaging` - The Amazon Chime SDK now supports push notifications through Amazon Pinpoint
* `Aws\Credentials` - Respect the AWS_PROFILE environment variable when using the default provider chain
* `Aws\EMRContainers` - This feature enables auto-generation of certificate to secure the managed-endpoint and removes the need for customer provided certificate-arn during managed-endpoint setup.

## 3.199.3 - 2021-10-25

* `Aws\AuditManager` - This release introduces a new feature for Audit Manager: Custom framework sharing. You can now share your custom frameworks with another AWS account, or replicate them into another AWS Region under your own account.
* `Aws\EC2` - This release adds support to create a VPN Connection that is not attached to a Gateway at the time of creation. Use this to create VPNs associated with Core Networks, or modify your VPN and attach a gateway using the modify API after creation.
* `Aws\RDS` - This release adds support for Amazon RDS Custom, which is a new RDS management type that gives you full access to your database and operating system. For more information, see https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-custom.html
* `Aws\Route53Resolver` - New API for ResolverConfig, which allows autodefined rules for reverse DNS resolution to be disabled for a VPC

## 3.199.2 - 2021-10-22

* `Aws\` - Fixed bugs that would arise from sending an incorrect content-type header to some services.
* `Aws\AuditManager` - This release introduces character restrictions for ControlSet names. We updated regex patterns for the following attributes: ControlSet, CreateAssessmentFrameworkControlSet, and UpdateAssessmentFrameworkControlSet.
* `Aws\Chime` - Chime VoiceConnector and VoiceConnectorGroup APIs will now return an ARN.
* `Aws\QuickSight` - Added QSearchBar option for GenerateEmbedUrlForRegisteredUser ExperienceConfiguration to support Q search bar embedding

## 3.199.1 - 2021-10-21

* `Aws\Connect` - Released Amazon Connect hours of operation API for general availability (GA). This API also supports AWS CloudFormation. For more information, see Amazon Connect Resource Type Reference in the AWS CloudFormation User Guide.

## 3.199.0 - 2021-10-20

* `Aws\` - Adds support for guzzlehttp/psr7 V2
* `Aws\Appflow` - Feature to add support for JSON-L format for S3 as a source.
* `Aws\DirectConnect` - This release adds 4 new APIS, which needs to be public able
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for specifying caption time delta in milliseconds and the ability to apply color range legalization to source content other than AVC video.
* `Aws\MediaPackage` - When enabled, MediaPackage passes through digital video broadcasting (DVB) subtitles into the output.
* `Aws\MediaPackageVod` - MediaPackage passes through digital video broadcasting (DVB) subtitles into the output.
* `Aws\Panorama` - General availability for AWS Panorama. AWS SDK for Panorama includes APIs to manage your devices and nodes, and deploy computer vision applications to the edge. For more information, see the AWS Panorama documentation at http://docs.aws.amazon.com/panorama
* `Aws\SecurityHub` - Added support for cross-Region finding aggregation, which replicates findings from linked Regions to a single aggregation Region. Added operations to view, enable, update, and delete the finding aggregation.
* `Aws\TranscribeStreamingService` - This release adds custom language support for streaming transcription.

## 3.198.8 - 2021-10-19

* `Aws\ChimeSDKMessaging` - The Amazon Chime SDK now allows developers to execute business logic on in-flight messages before they are delivered to members of a messaging channel with channel flows.
* `Aws\DataExchange` - This release adds support for our public preview of AWS Data Exchange for Amazon Redshift. This enables data providers to list products including AWS Data Exchange datashares for Amazon Redshift, giving subscribers read-only access to provider data in Amazon Redshift.

## 3.198.7 - 2021-10-18

* `Aws\IVS` - Bug fix: remove unsupported maxResults and nextToken pagination parameters from ListTagsForResource
* `Aws\QuickSight` - AWS QuickSight Service Features - Add IP Restriction UI and public APIs support.

## 3.198.6 - 2021-10-15

* `Aws\EFS` - EFS adds documentation for a new exception for short identifiers to be thrown after its migration to long resource identifiers.
* `Aws\Glue` - Enable S3 event base crawler API.

## 3.198.5 - 2021-10-14

* `Aws\AutoScaling` - Amazon EC2 Auto Scaling now supports filtering describe Auto Scaling groups API using tags
* `Aws\ElasticLoadBalancingv2` - Adds new option to filter by availability on each type of load balancer when describing ssl policies.
* `Aws\RoboMaker` - Adding support to GPU simulation jobs as well as non-ROS simulation jobs.
* `Aws\SageMaker` - This release updates the provisioning artifact ID to an optional parameter in CreateProject API. The provisioning artifact ID defaults to the latest provisioning artifact ID of the product if you don't provide one.

## 3.198.4 - 2021-10-13

* `Aws\ConfigService` - Adding Config support for AWS::OpenSearch::Domain
* `Aws\EC2` - This release adds support for additional VPC Flow Logs delivery options to S3, such as Apache Parquet formatted files, Hourly partitions and Hive-compatible S3 prefixes
* `Aws\KinesisAnalyticsV2` - Support for Apache Flink 1.13 in Kinesis Data Analytics. Changed the required status of some Update properties to better fit the corresponding Create properties.
* `Aws\StorageGateway` - Adding support for Audit Logs on NFS shares and Force Closing Files on SMB shares.
* `Aws\WorkMail` - This release adds APIs for adding, removing and retrieving details of mail domains

## 3.198.3 - 2021-10-12

* `Aws\CloudSearch` - Adds an additional validation exception for Amazon CloudSearch configuration APIs for better error handling.
* `Aws\EC2` - EncryptionSupport for InstanceStorageInfo added to DescribeInstanceTypes API
* `Aws\ECS` - Documentation only update to address tickets.
* `Aws\MediaTailor` - MediaTailor now supports ad prefetching.

## 3.198.2 - 2021-10-11

* `Aws\EC2` - Documentation update for Amazon EC2.
* `Aws\ElasticLoadBalancingv2` - Enable support for ALB IPv6 Target Groups (IP Address Type)
* `Aws\FraudDetector` - New model type: Transaction Fraud Insights, which is optimized for online transaction fraud. Stored Events, which allows customers to send and store data directly within Amazon Fraud Detector. Batch Import, which allows customers to upload a CSV file of historic event data for processing and storage
* `Aws\MediaLive` - This release adds support for Transport Stream files as an input type to MediaLive encoders.

## 3.198.1 - 2021-10-08

* `Aws\EC2` - This release removes a requirement for filters on SearchLocalGatewayRoutes operations.
* `Aws\LexModelsV2` - Added configuration support for an Amazon Lex bot to provide fulfillment progress updates to users while their requests are being processed. See documentation for more details: https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html
* `Aws\LexRuntimeV2` - Added configuration support for an Amazon Lex bot to provide fulfillment progress updates to users while their requests are being processed. See documentation for more details: https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html
* `Aws\MediaConvert` - AWS Elemental MediaConvert has added the ability to set account policies which control access restrictions for HTTP, HTTPS, and S3 content sources.
* `Aws\SecretsManager` - Documentation updates for Secrets Manager
* `Aws\SecurityHub` - Added new resource details objects to ASFF, including resources for WAF rate-based rules, EC2 VPC endpoints, ECR repositories, EKS clusters, X-Ray encryption, and OpenSearch domains. Added additional details for CloudFront distributions, CodeBuild projects, ELB V2 load balancers, and S3 buckets.

## 3.198.0 - 2021-10-07

* `Aws\Backup` - Launch of AWS Backup Vault Lock, which protects your backups from malicious and accidental actions, works with existing backup policies, and helps you meet compliance requirements.
* `Aws\Chime` - This release enables customers to configure Chime MediaCapturePipeline via API.
* `Aws\Firehose` - Allow support for Amazon Opensearch Service(successor to Amazon Elasticsearch Service) as a Kinesis Data Firehose delivery destination.
* `Aws\ManagedGrafana` - Initial release of the SDK for Amazon Managed Grafana API.
* `Aws\Schemas` - Removing unused request/response objects.
* `Aws\kendra` - Amazon Kendra now supports indexing and querying documents in different languages.

## 3.197.1 - 2021-10-06

* `Aws\AmplifyBackend` - Adding a new field 'AmplifyFeatureFlags' to the response of the GetBackend operation. It will return a stringified version of the cli.json file for the given Amplify project.
* `Aws\FSx` - This release adds support for Lustre 2.12 to FSx for Lustre.
* `Aws\SageMaker` - This release adds a new TrainingInputMode FastFile for SageMaker Training APIs.
* `Aws\kendra` - Amazon Kendra now supports integration with AWS SSO

## 3.197.0 - 2021-10-05

* `Aws\` - Added support for internal union types, allowing services to specify that exactly one of a number of input options needs to be non null
* `Aws\ApplicationAutoScaling` - With this release, Application Auto Scaling adds support for Amazon Neptune. Customers can now automatically add or remove Read Replicas of their Neptune clusters to keep the average CPU Utilization at the target value specified by the customers.
* `Aws\Backup` - AWS Backup Audit Manager framework report.
* `Aws\EC2` - Released Capacity Reservation Fleet, a feature of Amazon EC2 Capacity Reservations, which provides a way to manage reserved capacity across instance types. For more information: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-fleets.html
* `Aws\Glue` - This release adds tag as an input of CreateConnection
* `Aws\LocationService` - Add support for PositionFiltering.
* `Aws\WorkMail` - This release allows customers to change their inbound DMARC settings in Amazon WorkMail.

## 3.196.2 - 2021-10-04

* `Aws\CodeBuild` - CodeBuild now allows you to select how batch build statuses are sent to the source provider for a project.
* `Aws\EFS` - EFS adds a new exception for short identifiers to be thrown after its migration to long resource identifiers.
* `Aws\KMS` - Added SDK examples for ConnectCustomKeyStore, CreateCustomKeyStore, CreateKey, DeleteCustomKeyStore, DescribeCustomKeyStores, DisconnectCustomKeyStore, GenerateDataKeyPair, GenerateDataKeyPairWithoutPlaintext, GetPublicKey, ReplicateKey, Sign, UpdateCustomKeyStore and Verify APIs

## 3.196.1 - 2021-10-01

* `Aws\AppRunner` - This release contains several minor bug fixes.
* `Aws\SSM` - When "AutoApprovable" is true for a Change Template, then specifying --auto-approve (boolean) in Start-Change-Request-Execution will create a change request that bypasses approver review. (except for change calendar restrictions)
* `Aws\Synthetics` - CloudWatch Synthetics now enables customers to choose a customer managed AWS KMS key or an Amazon S3-managed key instead of an AWS managed key (default) for the encryption of artifacts that the canary stores in Amazon S3. CloudWatch Synthetics also supports artifact S3 location updation now.

## 3.196.0 - 2021-09-30

* `Aws\Account` - This release of the Account Management API enables customers to manage the alternate contacts for their AWS accounts. For more information, see https://docs.aws.amazon.com/accounts/latest/reference/accounts-welcome.html
* `Aws\CloudControlApi` - Initial release of the SDK for AWS Cloud Control API
* `Aws\DataExchange` - This release enables subscribers to set up automatic exports of newly published revisions using the new EventAction API.
* `Aws\Macie2` - Amazon S3 bucket metadata now indicates whether an error or a bucket's permissions settings prevented Amazon Macie from retrieving data about the bucket or the bucket's objects.
* `Aws\NetworkFirewall` - This release adds support for strict ordering for stateful rule groups. Using strict ordering, stateful rules are evaluated in the exact order in which you provide them.
* `Aws\WorkMail` - This release adds support for mobile device access overrides management in Amazon WorkMail.
* `Aws\WorkSpaces` - Added CreateUpdatedWorkspaceImage API to update WorkSpace images with latest software and drivers. Updated DescribeWorkspaceImages API to display if there are updates available for WorkSpace images.

## 3.195.2 - 2021-09-29

* `Aws\Lambda` - Adds support for Lambda functions powered by AWS Graviton2 processors. Customers can now select the CPU architecture for their functions.
* `Aws\PrometheusService` - This release adds alert manager and rule group namespace APIs
* `Aws\SesV2` - This release includes the ability to use 2048 bits RSA key pairs for DKIM in SES, either with Easy DKIM or Bring Your Own DKIM.

## 3.195.1 - 2021-09-28

* `Aws\Transfer` - Added changes for managed workflows feature APIs.
* `Aws\imagebuilder` - Fix description for AmiDistributionConfiguration Name property, which actually refers to the output AMI name. Also updated for consistent terminology to use "base" image, and another update to fix description text.

## 3.195.0 - 2021-09-27

* `Aws\AppIntegrationsService` - The Amazon AppIntegrations service enables you to configure and reuse connections to external applications.
* `Aws\Connect` - This release updates a set of APIs: CreateIntegrationAssociation, ListIntegrationAssociations, CreateUseCase, and StartOutboundVoiceContact. You can use it to create integrations with Amazon Pinpoint for the Amazon Connect Campaigns use case, Amazon Connect Voice ID, and Amazon Connect Wisdom.
* `Aws\ConnectWisdomService` - Released Amazon Connect Wisdom, a feature of Amazon Connect, which provides real-time recommendations and search functionality in general availability (GA). For more information, see https://docs.aws.amazon.com/wisdom/latest/APIReference/Welcome.html.
* `Aws\ElasticLoadBalancingv2` - Adds new ALB-type target group to facilitate forwarding traffic from NLB to ALB
* `Aws\Pinpoint` - Added support for journey with contact center activity
* `Aws\VoiceID` - Released the Amazon Voice ID SDK, for usage with the Amazon Connect Voice ID feature released for Amazon Connect.

## 3.194.5 - 2021-09-24

* `Aws\EC2` - DescribeInstances now returns Platform Details, Usage Operation, and Usage Operation Update Time.
* `Aws\LicenseManager` - AWS License Manager now allows customers to get the LicenseArn in the Checkout API Response.

## 3.194.4 - 2021-09-23

* `Aws\AppSync` - Documented the new OpenSearchServiceDataSourceConfig data type. Added deprecation notes to the ElasticsearchDataSourceConfig data type.
* `Aws\MediaConvert` - This release adds style and positioning support for caption or subtitle burn-in from rich text sources such as TTML. This release also introduces configurable image-based trick play track generation.
* `Aws\SSM` - Added cutoff behavior support for preventing new task invocations from starting when the maintenance window cutoff time is reached.

## 3.194.3 - 2021-09-22

* `Aws\IAM` - Added changes to OIDC API about not using port numbers in the URL.
* `Aws\LexModelsV2` - This release adds support for utterances statistics for bots built using Lex V2 console and APIs. For details, see: https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html
* `Aws\LicenseManager` - AWS License Manager now allows customers to change their Windows Server or SQL license types from Bring-Your-Own-License (BYOL) to License Included or vice-versa (using the customer's media).
* `Aws\MediaPackageVod` - MediaPackage VOD will now return the current processing statuses of an asset's endpoints. The status can be QUEUED, PROCESSING, PLAYABLE, or FAILED.
* `Aws\MediaTailor` - This release adds support to configure logs for playback configuration.
* `Aws\WAFV2` - Added the regex match rule statement, for matching web requests against a single regular expression.
* `Aws\imagebuilder` - This feature adds support for specifying GP3 volume throughput and configuring instance metadata options for instances launched by EC2 Image Builder.

## 3.194.2 - 2021-09-21

* `Aws\Comprehend` - Amazon Comprehend now supports versioning of custom models, improved training with ONE_DOC_PER_FILE text documents for custom entity recognition, ability to provide specific test sets during training, and live migration to new model endpoints.
* `Aws\EC2` - This update adds support for downloading configuration templates using new APIs (GetVpnConnectionDeviceTypes and GetVpnConnectionDeviceSampleConfiguration) and Internet Key Exchange version 2 (IKEv2) parameters for many popular CGW devices.
* `Aws\ECR` - This release adds additional support for repository replication
* `Aws\IoT` - This release adds support for verifying, viewing and filtering AWS IoT Device Defender detect violations with four verification states.
* `Aws\Kafka` - Added StateInfo to ClusterInfo

## 3.194.1 - 2021-09-17

* `Aws\DatabaseMigrationService` - Optional flag force-planned-failover added to reboot-replication-instance API call. This flag can be used to test a planned failover scenario used during some maintenance operations.
* `Aws\ElasticsearchService` - This release adds an optional parameter in the ListDomainNames API to filter domains based on the engine type (OpenSearch/Elasticsearch).
* `Aws\OpenSearchService` - This release adds an optional parameter in the ListDomainNames API to filter domains based on the engine type (OpenSearch/Elasticsearch).

## 3.194.0 - 2021-09-16

* `Aws\KafkaConnect` - This is the initial SDK release for Amazon Managed Streaming for Apache Kafka Connect (MSK Connect).
* `Aws\Macie2` - This release adds support for specifying which managed data identifiers are used by a classification job, and retrieving a list of managed data identifiers that are available.
* `Aws\Pinpoint` - This SDK release adds a new feature for Pinpoint campaigns, in-app messaging.
* `Aws\RoboMaker` - Adding support to create container based Robot and Simulation applications by introducing an environment field
* `Aws\S3` - Add support for access point arn filtering in S3 CW Request Metrics
* `Aws\SageMaker` - Add API for users to retry a failed pipeline execution or resume a stopped one.
* `Aws\TranscribeService` - This release adds support for subtitling with Amazon Transcribe batch jobs.

## 3.193.4 - 2021-09-14

* `Aws\Chime` - Adds support for SipHeaders parameter for CreateSipMediaApplicationCall.
* `Aws\Comprehend` - Amazon Comprehend now allows you to train and run PDF and Word documents for custom entity recognition. With PDF and Word formats, you can extract information from documents containing headers, lists and tables.
* `Aws\EC2` - This release adds support for vt1 3xlarge, 6xlarge and 24xlarge instances powered by Xilinx Alveo U30 Media Accelerators for video transcoding workloads
* `Aws\SageMaker` - This release adds support for "Project Search"
* `Aws\TranscribeStreamingService` - Amazon Transcribe now supports PII Identification and Redaction for streaming transcription.
* `Aws\WAFV2` - This release adds support for including rate based rules in a rule group.

## 3.193.3 - 2021-09-13

* `Aws\EC2` - Adds support for T3 instances on Amazon EC2 Dedicated Hosts.
* `Aws\IoT` - AWS IoT Rules Engine adds OpenSearch action. The OpenSearch rule action lets you stream data from IoT sensors and applications to Amazon OpenSearch Service which is a successor to Amazon Elasticsearch Service.

## 3.193.2 - 2021-09-10

* `Aws\CloudFormation` - Doc only update for CloudFormation that fixes several customer-reported issues.
* `Aws\ECR` - This release updates terminology around KMS keys.
* `Aws\QuickSight` - Add new data source type for Amazon OpenSearch (successor to Amazon ElasticSearch).
* `Aws\RDS` - This release adds support for providing a custom timeout value for finding a scaling point during autoscaling in Aurora Serverless v1.
* `Aws\SageMaker` - This release adds support for "Lifecycle Configurations" to SageMaker Studio
* `Aws\TranscribeService` - This release adds an API option for startTranscriptionJob and startMedicalTranscriptionJob that allows the user to specify encryption context key value pairs for batch jobs.

## 3.193.1 - 2021-09-09

* `Aws\CodeGuruReviewer` - The Amazon CodeGuru Reviewer API now includes the RuleMetadata data object and a Severity attribute on a RecommendationSummary object. A RuleMetadata object contains information about a rule that generates a recommendation. Severity indicates how severe the issue associated with a recommendation is.
* `Aws\EMR` - This release enables customers to login to EMR Studio using AWS Identity and Access Management (IAM) identities or identities in their Identity Provider (IdP) via IAM.
* `Aws\LookoutEquipment` - Added OffCondition parameter to CreateModel API

## 3.193.0 - 2021-09-08

* `Aws\Kafka` - Amazon MSK has added a new API that allows you to update the encrypting and authentication settings for an existing cluster.
* `Aws\OpenSearchService` - Updated Configuration APIs for Amazon OpenSearch Service (successor to Amazon Elasticsearch Service)
* `Aws\RAM` - A minor text-only update that fixes several customer issues.
* `Aws\S3` - Option to overload parameter on multipart copy

## 3.192.1 - 2021-09-07

* `Aws\EKS` - Adding RegisterCluster and DeregisterCluster operations, to support connecting external clusters to EKS.
* `Aws\ElastiCache` - Doc only update for ElastiCache
* `Aws\ForecastService` - Predictor creation now supports selecting an accuracy metric to optimize in AutoML and hyperparameter optimization. This release adds additional accuracy metrics for predictors - AverageWeightedQuantileLoss, MAPE and MASE.
* `Aws\MediaPackage` - SPEKE v2 support for live CMAF packaging type. SPEKE v2 is an upgrade to the existing SPEKE API to support multiple encryption keys, it supports live DASH currently.
* `Aws\PrometheusService` - This release adds tagging support for Amazon Managed Service for Prometheus workspace.
* `Aws\SSMContacts` - Added SDK examples for SSM-Contacts.
* `Aws\XRay` - Updated references to AWS KMS keys and customer managed keys to reflect current terminology.

## 3.192.0 - 2021-09-03

* `Aws\ChimeSDKIdentity` - Documentation updates for Chime
* `Aws\ChimeSDKMessaging` - Documentation updates for Chime
* `Aws\CodeGuruReviewer` - Added support for CodeInconsistencies detectors
* `Aws\FraudDetector` - Enhanced GetEventPrediction API response to include risk scores from imported SageMaker models
* `Aws\Outposts` - This release adds a new API CreateOrder.
* `Aws\S3` - Added support for S3 multi-region access points

## 3.191.10 - 2021-09-02

* `Aws\ACMPCA` - Private Certificate Authority Service now allows customers to enable an online certificate status protocol (OCSP) responder service on their private certificate authorities. Customers can also optionally configure a custom CNAME for their OCSP responder.
* `Aws\AccessAnalyzer` - Updates service API, documentation, and paginators to support multi-region access points from Amazon S3.
* `Aws\EBS` - Documentation updates for Amazon EBS direct APIs.
* `Aws\EFS` - Adds support for EFS Intelligent-Tiering, which uses EFS Lifecycle Management to monitor file access patterns and is designed to automatically transition files to and from your corresponding Infrequent Access (IA) storage classes.
* `Aws\FSx` - Announcing Amazon FSx for NetApp ONTAP, a new service that provides fully managed shared storage in the AWS Cloud with the data access and management capabilities of ONTAP.
* `Aws\LexModelBuildingService` - Lex now supports Korean (ko-KR) locale.
* `Aws\QuickSight` - This release adds support for referencing parent datasets as sources in a child dataset.
* `Aws\S3Control` - S3 Multi-Region Access Points provide a single global endpoint to access a data set that spans multiple S3 buckets in different AWS Regions.
* `Aws\Schemas` - This update include the support for Schema Discoverer to discover the events sent to the bus from another account. The feature will be enabled by default when discoverer is created or updated but can also be opt-in or opt-out by specifying the value for crossAccount.
* `Aws\SecurityHub` - New ASFF Resources: AwsAutoScalingLaunchConfiguration, AwsEc2VpnConnection, AwsEcrContainerImage. Added KeyRotationStatus to AwsKmsKey. Added AccessControlList, BucketLoggingConfiguration,BucketNotificationConfiguration and BucketNotificationConfiguration to AwsS3Bucket.
* `Aws\Transfer` - AWS Transfer Family introduces Managed Workflows for creating, executing, monitoring, and standardizing post file transfer processing

## 3.191.9 - 2021-09-01

* `Aws\AppRegistry` - Introduction of GetAssociatedResource API and GetApplication response extension for Resource Groups support.
* `Aws\CloudTrail` - Documentation updates for CloudTrail
* `Aws\ConfigService` - Documentation updates for config
* `Aws\EC2` - Added LaunchTemplate support for the IMDS IPv6 endpoint
* `Aws\MediaTailor` - This release adds support for wall clock programs in LINEAR channels.

## 3.191.8 - 2021-08-31

* `Aws\ComputeOptimizer` - Documentation updates for Compute Optimizer
* `Aws\IoT` - Added Create/Update/Delete/Describe/List APIs for a new IoT resource named FleetMetric. Added a new Fleet Indexing query API named GetBucketsAggregation. Added a new field named DisconnectedReason in Fleet Indexing query response. Updated their related documentations.
* `Aws\MemoryDB` - Documentation updates for MemoryDB
* `Aws\Polly` - Amazon Polly adds new South African English voice - Ayanda. Ayanda is available as Neural voice only.
* `Aws\SQS` - Amazon SQS adds a new queue attribute, RedriveAllowPolicy, which includes the dead-letter queue redrive permission parameters. It defines which source queues can specify dead-letter queues as a JSON object.

## 3.191.7 - 2021-08-30

* `Aws\CloudFormation` - AWS CloudFormation allows you to iteratively develop your applications when failures are encountered without rolling back successfully provisioned resources. By specifying stack failure options, you can troubleshoot resources in a CREATE_FAILED or UPDATE_FAILED status.
* `Aws\CodeBuild` - Documentation updates for CodeBuild
* `Aws\Firehose` - This release adds the Dynamic Partitioning feature to Kinesis Data Firehose service for S3 destinations.
* `Aws\KMS` - This release has changes to KMS nomenclature to remove the word master from both the "Customer master key" and "CMK" abbreviation and replace those naming conventions with "KMS key".

## 3.191.6 - 2021-08-27

* `Aws\EC2` - This release adds the BootMode flag to the ImportImage API and showing the detected BootMode of an ImportImage task.
* `Aws\EMR` - Amazon EMR now supports auto-terminating idle EMR clusters. You can specify the idle timeout value when enabling auto-termination for both running and new clusters and Amazon EMR automatically terminates the cluster when idle timeout kicks in.
* `Aws\S3` - Documentation updates for Amazon S3.

## 3.191.5 - 2021-08-26

* `Aws\ComputeOptimizer` - Adds support for 1) the AWS Graviton (AWS_ARM64) recommendation preference for Amazon EC2 instance and Auto Scaling group recommendations, and 2) the ability to get the enrollment statuses for all member accounts of an organization.
* `Aws\EC2` - Support added for resizing VPC prefix lists
* `Aws\Rekognition` - This release added new attributes to Rekognition RecognizeCelebities and GetCelebrityInfo API operations.
* `Aws\TranscribeService` - This release adds support for batch transcription in six new languages - Afrikaans, Danish, Mandarin Chinese (Taiwan), New Zealand English, South African English, and Thai.

## 3.191.4 - 2021-08-25

* `Aws\CloudWatchEvents` - AWS CWEvents adds an enum of EXTERNAL for EcsParameters LaunchType for PutTargets API
* `Aws\DataSync` - Added include filters to CreateTask and UpdateTask, and added exclude filters to StartTaskExecution, giving customers more granular control over how DataSync transfers files, folders, and objects.
* `Aws\EC2` - Support added for IMDS IPv6 endpoint
* `Aws\EventBridge` - AWS EventBridge adds an enum of EXTERNAL for EcsParameters LaunchType for PutTargets API
* `Aws\FMS` - AWS Firewall Manager now supports triggering resource cleanup workflow when account or resource goes out of policy scope for AWS WAF, Security group, AWS Network Firewall, and Amazon Route 53 Resolver DNS Firewall policies.

## 3.191.3 - 2021-08-24

* `Aws\IoTDataPlane` - Updated Publish with support for new Retain flag and added two new API operations: GetRetainedMessage, ListRetainedMessages.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added MBAFF encoding support for AVC video and the ability to pass encryption context from the job settings to S3.
* `Aws\Polly` - Amazon Polly adds new New Zealand English voice - Aria. Aria is available as Neural voice only.
* `Aws\SSM` - Updated Parameter Store property for logging improvements.
* `Aws\TranscribeService` - This release adds support for feature tagging with Amazon Transcribe batch jobs.

## 3.191.2 - 2021-08-23

* `Aws\APIGateway` - Adding some of the pending releases (1) Adding WAF Filter to GatewayResponseType enum (2) Ensuring consistent error model for all operations (3) Add missing BRE to GetVpcLink operation
* `Aws\Backup` - AWS Backup - Features: Evaluate your backup activity and generate audit reports.
* `Aws\DLM` - Added AMI deprecation support for Amazon Data Lifecycle Manager EBS-backed AMI policies.
* `Aws\DatabaseMigrationService` - Amazon AWS DMS service now support Redis target endpoint migration. Now S3 endpoint setting is capable to setup features which are used to be configurable only in extract connection attributes.
* `Aws\FraudDetector` - Updated an element of the DescribeModelVersion API response (LogitMetrics -> logOddsMetrics) for clarity. Added new exceptions to several APIs to protect against unlikely scenarios.
* `Aws\Glue` - Add support for Custom Blueprints
* `Aws\IoTSiteWise` - Documentation updates for AWS IoT SiteWise

## 3.191.1 - 2021-08-20

* `Aws\Comprehend` - Add tagging support for Comprehend async inference job.
* `Aws\EC2` - encryptionInTransitSupported added to DescribeInstanceTypes API
* `Aws\EKS` - Adds support for EKS add-ons "preserve" flag, which allows customers to maintain software on their EKS clusters after removing it from EKS add-ons management.
* `Aws\RoboMaker` - Documentation updates for RoboMaker

## 3.191.0 - 2021-08-19

* `Aws\Appflow` - This release adds support for SAPOData connector and extends Veeva connector for document extraction.
* `Aws\ApplicationAutoScaling` - This release extends Application Auto Scaling support for replication group of Amazon ElastiCache Redis clusters. Auto Scaling monitors and automatically expands node group count and number of replicas per node group when a critical usage threshold is met or according to customer-defined schedule.
* `Aws\EC2` - The ImportImage API now supports the ability to create AMIs with AWS-managed licenses for Microsoft SQL Server for both Windows and Linux.
* `Aws\MemoryDB` - AWS MemoryDB SDK now supports all APIs for newly launched MemoryDB service.

## 3.190.5 - 2021-08-18

* `Aws\CodeBuild` - CodeBuild now allows you to make the build results for your build projects available to the public without requiring access to an AWS account.
* `Aws\Route53` - Documentation updates for route53
* `Aws\Route53Resolver` - Documentation updates for Route 53 Resolver
* `Aws\SageMaker` - Amazon SageMaker now supports Asynchronous Inference endpoints. Adds PlatformIdentifier field that allows Notebook Instance creation with different platform selections. Increases the maximum number of containers in multi-container endpoints to 15. Adds more instance types to InstanceType field.
* `Aws\SageMakerRuntime` - Amazon SageMaker Runtime now supports InvokeEndpointAsync to asynchronously invoke endpoints that were created with the AsyncInferenceConfig object in the EndpointConfig. Asynchronous invocations support larger payload sizes in Amazon S3 and longer processing times.

## 3.190.4 - 2021-08-17

* `Aws\Cloud9` - Added DryRun parameter to CreateEnvironmentEC2 API. Added ManagedCredentialsActions parameter to UpdateEnvironment API
* `Aws\CloudDirectory` - Documentation updates for clouddirectory
* `Aws\CloudWatchLogs` - Documentation-only update for CloudWatch Logs
* `Aws\CostExplorer` - This release is a new feature for Cost Categories: Split charge rules. Split charge rules enable you to allocate shared costs between your cost category values.
* `Aws\EC2` - This release adds support for EC2 ED25519 key pairs for authentication

## 3.190.3 - 2021-08-16

* `Aws\CodeBuild` - CodeBuild now allows you to select how batch build statuses are sent to the source provider for a project.
* `Aws\ConfigService` - Update ResourceType enum with values for Backup Plan, Selection, Vault, RecoveryPoint; ECS Cluster, Service, TaskDefinition; EFS AccessPoint, FileSystem; EKS Cluster; ECR Repository resources
* `Aws\DirectoryService` - This release adds support for describing client authentication settings.
* `Aws\IoTSiteWise` - AWS IoT SiteWise added query window for the interpolation interval. AWS IoT SiteWise computes each interpolated value by using data points from the timestamp of each interval minus the window to the timestamp of each interval plus the window.
* `Aws\LicenseManager` - AWS License Manager now allows end users to call CheckoutLicense API using new CheckoutType PERPETUAL. Perpetual checkouts allow sellers to check out a quantity of entitlements to be drawn down for consumption.
* `Aws\S3` - Documentation updates for Amazon S3

## 3.190.2 - 2021-08-13

* `Aws\CustomerProfiles` - This release introduces Standard Profile Objects, namely Asset and Case which contain values populated by data from third party systems and belong to a specific profile. This release adds an optional parameter, ObjectFilter to the ListProfileObjects API in order to search for these Standard Objects.
* `Aws\EMR` - Amazon EMR customers can now specify custom AMIs at the instance level in their clusters. This allows using custom AMIs in clusters that have instances with different instruction set architectures, e.g. m5.xlarge (x86) and m6g.xlarge (ARM).
* `Aws\ElastiCache` - This release adds ReplicationGroupCreateTime field to ReplicationGroup which indicates the UTC time when ElastiCache ReplicationGroup is created
* `Aws\QuickSight` - Documentation updates for QuickSight.

## 3.190.1 - 2021-08-12

* `Aws\APIGateway` - Adding support for ACM imported or private CA certificates for mTLS enabled domain names
* `Aws\ApiGatewayV2` - Adding support for ACM imported or private CA certificates for mTLS enabled domain names
* `Aws\GlueDataBrew` - This SDK release adds support for the output of a recipe job results to Tableau Hyper format.
* `Aws\Lambda` - Lambda Python 3.9 runtime launch
* `Aws\SageMaker` - Amazon SageMaker Autopilot adds new metrics for all candidate models generated by Autopilot experiments.

## 3.190.0 - 2021-08-11

* `Aws\CodeBuild` - CodeBuild now allows you to make the build results for your build projects available to the public without requiring access to an AWS account.
* `Aws\EBS` - Documentation updates for Amazon EBS direct APIs.
* `Aws\ECS` - Documentation updates for ECS.
* `Aws\NimbleStudio` - Add new attribute 'ownedBy' in Streaming Session APIs. 'ownedBy' represents the AWS SSO Identity Store User ID of the owner of the Streaming Session resource.
* `Aws\Route53` - Documentation updates for route53
* `Aws\SnowDeviceManagement` - AWS Snow Family customers can remotely monitor and operate their connected AWS Snowcone devices.

## 3.189.0 - 2021-08-10

* `Aws\` - Enable support for internal document model types to allow the sending of raw json directly to services
* `Aws\Chime` - Add support for "auto" in Region field of StartMeetingTranscription API request.

## 3.188.1 - 2021-08-09

* `Aws\Rekognition` - This release adds support for four new types of segments (opening credits, content segments, slates, and studio logos), improved accuracy for credits and shot detection and new filters to control black frame detection.
* `Aws\SSM` - Documentation updates for AWS Systems Manager.
* `Aws\WAFV2` - This release adds APIs to support versioning feature of AWS WAF Managed rule groups

## 3.188.0 - 2021-08-06

* `Aws\Athena` - Documentation updates for Athena.
* `Aws\ChimeSDKIdentity` - The Amazon Chime SDK Identity APIs allow software developers to create and manage unique instances of their messaging applications.
* `Aws\ChimeSDKMessaging` - The Amazon Chime SDK Messaging APIs allow software developers to send and receive messages in custom messaging applications.
* `Aws\Connect` - This release adds support for agent status and hours of operation. For details, see the Release Notes in the Amazon Connect Administrator Guide.
* `Aws\Lightsail` - This release adds support to track when a bucket access key was last used.
* `Aws\Synthetics` - Documentation updates for Visual Monitoring feature and other doc ticket fixes.

## 3.187.3 - 2021-08-05

* `Aws\AutoScaling` - EC2 Auto Scaling adds configuration checks and Launch Template validation to Instance Refresh.
* `Aws\LexModelsV2` - Customers can now toggle the active field on prompts and responses.

## 3.187.2 - 2021-08-04

* `Aws\EventBridge` - Documentation updates to add EC2 Image Builder as a target on PutTargets.
* `Aws\RDS` - This release adds AutomaticRestartTime to the DescribeDBInstances and DescribeDBClusters operations. AutomaticRestartTime indicates the time when a stopped DB instance or DB cluster is restarted automatically.
* `Aws\SSMIncidents` - Documentation updates for Incident Manager.
* `Aws\TranscribeService` - This release adds support for call analytics (batch) within Amazon Transcribe.
* `Aws\imagebuilder` - Updated list actions to include a list of valid filters that can be used in the request.

## 3.187.1 - 2021-08-04

* `Aws\` - Instance Profile Provider now has new input for IP version, taking IPv4 or IPv6.  Default behavior hasn't changed, but new defaults if IPv6 is explicitly enabled.
* `Aws\Glue` - Add ConcurrentModificationException to create-table, delete-table, create-database, update-database, delete-database
* `Aws\IoTSiteWise` - My AWS Service (placeholder) - This release introduces custom Intervals and offset for tumbling window in metric for AWS IoT SiteWise.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added control over the passthrough of XDS captions metadata to outputs.
* `Aws\Proton` - Docs only add idempotent create apis
* `Aws\Redshift` - API support for Redshift Data Sharing feature.

## 3.186.4 - 2021-08-02

* `Aws\GreengrassV2` - This release adds support for component system resource limits and idempotent Create operations. You can now specify the maximum amount of CPU and memory resources that each component can use.
* `Aws\SSMContacts` - Added new attribute in AcceptCode API. AcceptCodeValidation takes in two values - ENFORCE, IGNORE. ENFORCE forces validation of accept code and IGNORE ignores it which is also the default behavior; Corrected TagKeyList length from 200 to 50

## 3.186.3 - 2021-07-30

* `Aws\AppSync` - AWS AppSync now supports a new authorization mode allowing you to define your own authorization logic using an AWS Lambda function.
* `Aws\ElasticLoadBalancingv2` - Client Port Preservation ALB Attribute Launch
* `Aws\SageMaker` - API changes with respect to Lambda steps in model building pipelines. Adds several waiters to async Sagemaker Image APIs. Add more instance types to AppInstanceType field
* `Aws\SecretsManager` - Add support for KmsKeyIds in the ListSecretVersionIds API response

## 3.186.2 - 2021-07-29

* `Aws\Chime` - Adds support for live transcription of meetings with Amazon Transcribe and Amazon Transcribe Medical. The new APIs, StartMeetingTranscription and StopMeetingTranscription, control the generation of user-attributed transcriptions sent to meeting clients via Amazon Chime SDK data messages.
* `Aws\EC2` - This release adds support for G4ad xlarge and 2xlarge instances powered by AMD Radeon Pro V520 GPUs and AMD 2nd Generation EPYC processors
* `Aws\IoT` - Increase maximum credential duration of role alias to 12 hours.
* `Aws\IoTSiteWise` - Added support for AWS IoT SiteWise Edge. You can now create an AWS IoT SiteWise gateway that runs on AWS IoT Greengrass V2. With the gateway, you can collect local server and equipment data, process the data, and export the selected data from the edge to the AWS Cloud.
* `Aws\SavingsPlans` - Documentation update for valid Savings Plans offering ID pattern

## 3.186.1 - 2021-07-28

* `Aws\CloudFormation` - SDK update to support Importing existing Stacks to new/existing Self Managed StackSet - Stack Import feature.
* `Aws\SSOAdmin` - Documentation updates for arn:aws:trebuchet:::service:v1:03a2216d-1cda-4696-9ece-1387cb6f6952

## 3.186.0 - 2021-07-27

* `Aws\Batch` - Add support for ListJob filters
* `Aws\IoTAnalytics` - IoT Analytics now supports creating a dataset resource with IoT SiteWise MultiLayerStorage data stores, enabling customers to query industrial data within the service. This release includes adding JOIN functionality for customers to query multiple data sources in a dataset.
* `Aws\IoTWireless` - Add SidewalkManufacturingSn as an identifier to allow Customer to query WirelessDevice, in the response, AmazonId is added in the case that Sidewalk device is return.
* `Aws\LexModelsV2` - Add waiters that automatically poll for resource status for asynchronous operations, such as building a bot
* `Aws\QuickSight` - Add support to use row-level security with tags when embedding dashboards for users not provisioned in QuickSight
* `Aws\RedshiftDataAPIService` - Added structures to support new Data API operation BatchExecuteStatement, used to execute multiple SQL statements within a single transaction.
* `Aws\Route53` - This release adds support for the RECOVERY_CONTROL health check type to be used in conjunction with Route53 Application Recovery Controller.
* `Aws\Route53RecoveryCluster` - Amazon Route 53 Application Recovery Controller's routing control - Routing Control Data Plane APIs help you update the state (On/Off) of the routing controls to reroute traffic across application replicas in a 100% available manner.
* `Aws\Route53RecoveryControlConfig` - Amazon Route 53 Application Recovery Controller's routing control - Routing Control Configuration APIs help you create and delete clusters, control panels, routing controls and safety rules. State changes (On/Off) of routing controls are not part of configuration APIs.
* `Aws\Route53RecoveryReadiness` - Amazon Route 53 Application Recovery Controller's readiness check capability continually monitors resource quotas, capacity, and network routing policies to ensure that the recovery environment is scaled and configured to take over when needed.
* `Aws\Shield` - Change name of DDoS Response Team (DRT) to Shield Response Team (SRT)

## 3.185.21 - 2021-07-26

* `Aws\CloudWatch` - SDK update to support creation of Cross-Account Metric Alarms and update API documentation.
* `Aws\IdentityStore` - Documentation updates for SSO API Ref.
* `Aws\Proton` - Documentation-only update links
* `Aws\S3Control` - S3 Access Point aliases can be used anywhere you use S3 bucket names to access data in S3
* `Aws\Synthetics` - CloudWatch Synthetics now supports visual testing in its canaries.
* `Aws\Textract` - Adds support for AnalyzeExpense, a new API to extract relevant data such as contact information, items purchased, and vendor name, from almost any invoice or receipt without the need for any templates or configuration.

## 3.185.20 - 2021-07-23

* `Aws\S3Outposts` - Add on-premise access type support for endpoints
* `Aws\SecurityHub` - Added product name, company name, and Region fields for security findings. Added details objects for RDS event subscriptions and AWS ECS services. Added fields to the details for AWS Elasticsearch domains.
* `Aws\imagebuilder` - Update to documentation to reapply missing change to SSM uninstall switch default value and improve description.

## 3.185.19 - 2021-07-22

* `Aws\EC2` - This release allows customers to assign prefixes to their elastic network interface and to reserve IP blocks in their subnet CIDRs. These reserved blocks can be used to assign prefixes to elastic network interfaces or be excluded from auto-assignment.
* `Aws\ElasticLoadBalancingv2` - Adds support for enabling TLS protocol version and cipher suite headers to be sent to backend targets for Application Load Balancers.
* `Aws\GlueDataBrew` - This SDK release adds two new features: 1) Output to Native JDBC destinations and 2) Adding configurations to profile jobs
* `Aws\MediaLive` - MediaLive now supports passing through style data on WebVTT caption outputs.
* `Aws\QLDB` - Amazon QLDB now supports ledgers encrypted with customer managed KMS keys. Changes in CreateLedger, UpdateLedger and DescribeLedger APIs to support the changes.
* `Aws\S3Control` - Documentation updates for Amazon S3-control

## 3.185.18 - 2021-07-21

* `Aws\CodeBuild` - AWS CodeBuild now allows you to set the access permissions for build artifacts, project artifacts, and log files that are uploaded to an Amazon S3 bucket that is owned by another account.
* `Aws\EMR` - EMR now supports new DescribeReleaseLabel and ListReleaseLabel APIs. They can provide Amazon EMR release label details. You can programmatically list available releases and applications for a specific Amazon EMR release label.
* `Aws\ElasticLoadBalancingv2` - Adds support for enabling TLS protocol version and cipher suite headers to be sent to backend targets for Application Load Balancers.
* `Aws\IAM` - Documentation updates for AWS Identity and Access Management (IAM).
* `Aws\Lambda` - New ResourceConflictException error code for PutFunctionEventInvokeConfig, UpdateFunctionEventInvokeConfig, and DeleteFunctionEventInvokeConfig operations.
* `Aws\Personalize` - My AWS Service (placeholder) - Making minProvisionedTPS an optional parameter when creating a campaign. If not provided, it defaults to 1.
* `Aws\Proton` - Documentation updates for AWS Proton
* `Aws\RDS` - Adds the OriginalSnapshotCreateTime field to the DBSnapshot response object. This field timestamps the underlying data of a snapshot and doesn't change when the snapshot is copied.
* `Aws\kendra` - Amazon Kendra now provides a data source connector for Amazon WorkDocs. For more information, see https://docs.aws.amazon.com/kendra/latest/dg/data-source-workdocs.html

## 3.185.17 - 2021-07-20

* `Aws\ComputeOptimizer` - Documentation updates for Compute Optimizer
* `Aws\EC2` - Added idempotency to the CreateVolume API using the ClientToken request parameter

## 3.185.16 - 2021-07-19

* `Aws\DirectConnect` - Documentation updates for directconnect
* `Aws\EMRContainers` - Updated DescribeManagedEndpoint and ListManagedEndpoints to return failureReason and stateDetails in API response.
* `Aws\Health` - In the Health API, the maximum number of entities for the EventFilter and EntityFilter data types has changed from 100 to 99. This change is related to an internal optimization of the AWS Health service.
* `Aws\LocationService` - Add five new API operations: UpdateGeofenceCollection, UpdateMap, UpdatePlaceIndex, UpdateRouteCalculator, UpdateTracker.
* `Aws\RoboMaker` - This release allows customers to create a new version of WorldTemplates with support for Doors.
* `Aws\imagebuilder` - Documentation updates for reversal of default value for additional instance configuration SSM switch, plus improved descriptions for semantic versioning.

## 3.185.15 - 2021-07-16

* `Aws\AppIntegrationsService` - Documentation update for AppIntegrations Service
* `Aws\AuditManager` - This release relaxes the S3 URL character restrictions in AWS Audit Manager. Regex patterns have been updated for the following attributes: s3RelativePath, destination, and s3ResourcePath. 'AWS' terms have also been replaced with entities to align with China Rebrand documentation efforts.
* `Aws\Chime` - This SDK release adds Account Status as one of the attributes in Account API response

## 3.185.14 - 2021-07-15

* `Aws\CognitoIdentityProvider` - Documentation updates for cognito-idp
* `Aws\EC2` - This feature enables customers to specify weekly recurring time window(s) for scheduled events that reboot, stop or terminate EC2 instances.
* `Aws\ECS` - Documentation updates for support of awsvpc mode on Windows.
* `Aws\Endpoint` - Fixed bug where the wrong endpoint was being generated for FIPS endpoints with object lambdas
* `Aws\IoTSiteWise` - Update the default endpoint for the APIs used to manage asset models, assets, gateways, tags, and account configurations. If you have firewalls with strict egress rules, configure the rules to grant you access to api.iotsitewise.[region].amazonaws.com or api.iotsitewise.[cn-region].amazonaws.com.cn.
* `Aws\LexModelBuildingService` - Lex now supports the en-IN locale

## 3.185.13 - 2021-07-14

* `Aws\ACM` - Added support for RSA 3072 SSL certificate import
* `Aws\DatabaseMigrationService` - Release of feature needed for ECA-Endpoint settings. This allows customer to delete a field in endpoint settings by using --exact-settings flag in modify-endpoint api. This also displays default values for certain required fields of endpoint settings in describe-endpoint-settings api.
* `Aws\Glue` - Add support for Event Driven Workflows
* `Aws\HealthLake` - General availability for Amazon HealthLake. StartFHIRImportJob and StartFHIRExportJob APIs now require AWS KMS parameter. For more information, see the Amazon HealthLake Documentation https://docs.aws.amazon.com/healthlake/index.html.
* `Aws\Lightsail` - This release adds support for the Amazon Lightsail object storage service, which allows you to create buckets and store objects.
* `Aws\WellArchitected` - This update provides support for Well-Architected API users to mark answer choices as not applicable.

## 3.185.12 - 2021-07-13

* `Aws\` - Removes a broken smoke test for device farms
* `Aws\AmplifyBackend` - Added Sign in with Apple OAuth provider.
* `Aws\DevOpsGuru` - Add paginator for GetCostEstimation
* `Aws\DirectConnect` - This release adds a new filed named awsLogicalDeviceId that it displays the AWS Direct Connect endpoint which terminates a physical connection's BGP Sessions.
* `Aws\LexModelBuildingService` - Customers can now migrate bots built with Lex V1 APIs to V2 APIs. This release adds APIs to initiate and manage the migration of a bot.
* `Aws\Pricing` - Documentation updates for api.pricing
* `Aws\Redshift` - Release new APIs to support new Redshift feature - Authentication Profile
* `Aws\SSM` - Changes to OpsCenter APIs to support a new feature, operational insights.

## 3.185.11 - 2021-07-12

* `Aws\EKS` - Documentation updates for Wesley to support the parallel node upgrade feature.
* `Aws\kendra` - Amazon Kendra now supports Principal Store

## 3.185.10 - 2021-07-09

* `Aws\FraudDetector` - This release adds support for ML Explainability to display model variable importance value in Amazon Fraud Detector.
* `Aws\MediaConvert` - MediaConvert now supports color, style and position information passthrough from 608 and Teletext to SRT and WebVTT subtitles. MediaConvert now also supports Automatic QVBR quality levels for QVBR RateControlMode.
* `Aws\SageMaker` - Releasing new APIs related to Tuning steps in model building pipelines.

## 3.185.9 - 2021-07-08

* `Aws\DevOpsGuru` - Add AnomalyReportedTimeRange field to include open and close time of anomalies.
* `Aws\EKS` - Added waiters for EKS FargateProfiles.
* `Aws\FMS` - AWS Firewall Manager now supports route table monitoring, and provides remediation action recommendations to security administrators for AWS Network Firewall policies with misconfigured routes.
* `Aws\MediaTailor` - Add ListAlerts for Channel, Program, Source Location, and VOD Source to return alerts for resources.
* `Aws\Outposts` - Added property filters for listOutposts
* `Aws\SSMContacts` - Updated description for CreateContactChannel contactId.

## 3.185.8 - 2021-07-07

* `Aws\Chime` - Releasing new APIs for AWS Chime MediaCapturePipeline
* `Aws\CloudFront` - Amazon CloudFront now provides two new APIs, ListConflictingAliases and AssociateAlias, that help locate and move Alternate Domain Names (CNAMEs) if you encounter the CNAMEAlreadyExists error code.
* `Aws\EC2` - This release adds resource ids and tagging support for VPC security group rules.
* `Aws\IAM` - Documentation updates for AWS Identity and Access Management (IAM).
* `Aws\IoTSiteWise` - This release add storage configuration APIs for AWS IoT SiteWise.
* `Aws\MQ` - adds support for modifying the maintenance window for brokers.
* `Aws\STS` - Documentation updates for AWS Security Token Service.
* `Aws\StorageGateway` - Adding support for oplocks for SMB file shares, S3 Access Point and S3 Private Link for all file shares and IP address support for file system associations

## 3.185.7 - 2021-07-06

* `Aws\EKS` - Adding new error code UnsupportedAddonModification for Addons in EKS
* `Aws\Lambda` - Added support for AmazonMQRabbitMQ as an event source. Added support for VIRTUAL_HOST as SourceAccessType for streams event source mappings.
* `Aws\Macie2` - Sensitive data findings in Amazon Macie now include enhanced location data for JSON and JSON Lines files
* `Aws\SNS` - Documentation updates for Amazon SNS.
* `Aws\imagebuilder` - Adds support for specifying parameters to customize components for recipes. Expands configuration of the Amazon EC2 instances that are used for building and testing images, including the ability to specify commands to run on launch, and more control over installation and removal of the SSM agent.
* `Aws\mgn` - Bug fix: Remove not supported EBS encryption type "NONE"

## 3.185.6 - 2021-07-02

* `Aws\EC2` - This release removes network-insights-boundary
* `Aws\ElasticLoadBalancingv2` - Documentation updates for elasticloadbalancingv2

## 3.185.5 - 2021-07-01

* `Aws\EC2` - Adding a new reserved field to support future infrastructure improvements for Amazon EC2 Fleet.
* `Aws\SQS` - Documentation updates for Amazon SQS.
* `Aws\SageMaker` - SageMaker model registry now supports up to 5 containers and associated environment variables.

## 3.185.4 - 2021-06-30

* `Aws\AutoScaling` - Amazon EC2 Auto Scaling infrastructure improvements and optimizations.
* `Aws\GlueDataBrew` - Adds support for the output of job results to the AWS Glue Data Catalog.
* `Aws\MediaPackageVod` - Add support for Widevine DRM on CMAF packaging configurations. Both Widevine and FairPlay DRMs can now be used simultaneously, with CBCS encryption.
* `Aws\SSMContacts` - Fixes the tag key length range to 128 chars, tag value length to 256 chars; Adds support for UTF-8 chars for contact and channel names, Allows users to unset name in UpdateContact API; Adds throttling exception to StopEngagement API, validation exception to APIs UntagResource, ListTagsForResource
* `Aws\ServiceDiscovery` - AWS Cloud Map now allows configuring the TTL of the SOA record for a hosted zone to control the negative caching for new services.
* `Aws\kendra` - Amazon Kendra Enterprise Edition now offered in smaller more granular units to enable customers with smaller workloads. Virtual Storage Capacity units now offer scaling in increments of 100,000 documents (up to 30GB) per unit and Virtual Query Units offer scaling increments of 8,000 queries per day.

## 3.185.3 - 2021-06-28

* `Aws\Glue` - Add JSON Support for Glue Schema Registry
* `Aws\MediaConvert` - MediaConvert adds support for HDR10+, ProRes 4444, and XAVC outputs, ADM/DAMF support for Dolby Atmos ingest, and alternative audio and WebVTT caption ingest via HLS inputs. MediaConvert also now supports creating trickplay outputs for Roku devices for HLS, CMAF, and DASH output groups.
* `Aws\Redshift` - Added InvalidClusterStateFault to the DisableLogging API, thrown when calling the API on a non available cluster.
* `Aws\SageMaker` - Sagemaker Neo now supports running compilation jobs using customer's Amazon VPC

## 3.185.2 - 2021-06-25

* `Aws\AmplifyBackend` - Imports an existing backend authentication resource.
* `Aws\Proton` - Added waiters for template registration, service operations, and environment deployments.
* `Aws\Snowball` - AWS Snow Family customers can remotely monitor and operate their connected AWS Snowcone devices. AWS Snowball Edge Storage Optimized customers can now import and export their data using NFS.

## 3.185.1 - 2021-06-24

* `Aws\Chime` - Adds EventIngestionUrl field to MediaPlacement
* `Aws\Cloud9` - Minor update to AWS Cloud9 documentation to allow correct parsing of outputted text
* `Aws\CodeBuild` - BucketOwnerAccess is currently not supported
* `Aws\Connect` - Released Amazon Connect quick connects management API for general availability (GA). For more information, see https://docs.aws.amazon.com/connect/latest/APIReference/Welcome.html
* `Aws\DAX` - Add support for encryption in transit to DAX clusters.
* `Aws\SecurityHub` - Added new resource details for ECS clusters and ECS task definitions. Added additional information for S3 buckets, Elasticsearch domains, and API Gateway V2 stages.
* `Aws\Transfer` - Customers can successfully use legacy clients with Transfer Family endpoints enabled for FTPS and FTP behind routers, firewalls, and load balancers by providing a Custom IP address used for data channel communication.
* `Aws\WAFV2` - Added support for 15 new text transformation.
* `Aws\kendra` - Amazon Kendra now supports SharePoint 2013 and SharePoint 2016 when using a SharePoint data source.

## 3.185.0 - 2021-06-23

* `Aws\` - User agent header updated to include info on OS and language version
* `Aws\Cloud9` - Updated documentation for CreateEnvironmentEC2 to explain that because Amazon Linux AMI has ended standard support as of December 31, 2020, we recommend you choose Amazon Linux 2--which includes long term support through 2023--for new AWS Cloud9 environments.
* `Aws\CloudFront` - Amazon CloudFront adds support for a new security policy, TLSv1.2_2021.
* `Aws\CloudSearch` - This release replaces previous generation CloudSearch instances with equivalent new instances that provide better stability at the same price.
* `Aws\CloudWatchEvents` - Added the following parameters to ECS targets: CapacityProviderStrategy, EnableECSManagedTags, EnableExecuteCommand, PlacementConstraints, PlacementStrategy, PropagateTags, ReferenceId, and Tags
* `Aws\CodeGuruReviewer` - Adds support for S3 based full repository analysis and changed lines scan.
* `Aws\DocDB` - DocumentDB documentation-only edits
* `Aws\EC2` - This release adds support for provisioning your own IP (BYOIP) range in multiple regions. This feature is in limited Preview for this release. Contact your account manager if you are interested in this feature.
* `Aws\EventBridge` - Added the following parameters to ECS targets: CapacityProviderStrategy, EnableECSManagedTags, EnableExecuteCommand, PlacementConstraints, PlacementStrategy, PropagateTags, ReferenceId, and Tags
* `Aws\LicenseManager` - AWS License Manager now allows license administrators and end users to communicate to each other by setting custom status reasons when updating the status on a granted license.
* `Aws\MediaTailor` - Update GetChannelSchedule to return information on ad breaks.
* `Aws\QuickSight` - Releasing new APIs for AWS QuickSight Folders

## 3.184.7 - 2021-06-21

* `Aws\CloudFormation` - CloudFormation registry service now supports 3rd party public type sharing

## 3.184.6 - 2021-06-17

* `Aws\Chime` - This release adds a new API UpdateSipMediaApplicationCall, to update an in-progress call for SipMediaApplication.
* `Aws\RDS` - This release enables Database Activity Streams for RDS Oracle
* `Aws\SageMaker` - Enable ml.g4dn instance types for SageMaker Batch Transform and SageMaker Processing
* `Aws\kendra` - Amazon Kendra now supports the indexing of web documents for search through the web crawler.

## 3.184.5 - 2021-06-16

* `Aws\EC2` - This release adds support for VLAN-tagged network traffic over an Elastic Network Interface (ENI). This feature is in limited Preview for this release. Contact your account manager if you are interested in this feature.
* `Aws\KMS` - Adds support for multi-Region keys
* `Aws\MediaTailor` - Adds AWS Secrets Manager Access Token Authentication for Source Locations
* `Aws\RDS` - This release enables fast cloning in Aurora Serverless. You can now clone between Aurora Serverless clusters and Aurora Provisioned clusters.

## 3.184.4 - 2021-06-15

* `Aws\Connect` - This release adds new sets of APIs: AssociateBot, DisassociateBot, and ListBots. You can use it to programmatically add an Amazon Lex bot or Amazon Lex V2 bot on the specified Amazon Connect instance
* `Aws\EC2` - EC2 M5n, M5dn, R5n, R5dn metal instances with 100 Gbps network performance and Elastic Fabric Adapter (EFA) for ultra low latency
* `Aws\LexModelsV2` - This release adds support for Multi Valued slots in Amazon Lex V2 APIs for model building
* `Aws\LexRuntimeV2` - This release adds support for Multi Valued slots in Amazon Lex V2 APIs for runtime
* `Aws\RedshiftDataAPIService` - Redshift Data API service now supports SQL parameterization.

## 3.184.3 - 2021-06-14

* `Aws\GreengrassV2` - We have verified the APIs being released here and are ready to release
* `Aws\IoTAnalytics` - Adds support for data store partitions.
* `Aws\LookoutMetrics` - Added "LEARNING" status for anomaly detector and updated description for "Offset" parameter in MetricSet APIs.

## 3.184.2 - 2021-06-11

* `Aws\EC2` - Amazon EC2 adds new AMI property to flag outdated AMIs
* `Aws\MediaConnect` - When you enable source failover, you can now designate one of two sources as the primary source. You can choose between two failover modes to prevent any disruption to the video stream. Merge combines the sources into a single stream. Failover allows switching between a primary and a backup stream.
* `Aws\MediaLive` - AWS MediaLive now supports OCR-based conversion of DVB-Sub and SCTE-27 image-based source captions to WebVTT, and supports ingest of ad avail decorations in HLS input manifests.

## 3.184.1 - 2021-06-10

* `Aws\AppMesh` - AppMesh now supports additional routing capabilities in match and rewrites for Gateway Routes and Routes. Additionally, App Mesh also supports specifying DNS Response Types in Virtual Nodes.
* `Aws\Appflow` - Adding MAP_ALL task type support.
* `Aws\Chime` - This SDK release adds support for UpdateAccount API to allow users to update their default license on Chime account.
* `Aws\CognitoIdentityProvider` - Amazon Cognito now supports targeted sign out through refresh token revocation
* `Aws\EC2` - This release adds a new optional parameter connectivityType (public, private) for the CreateNatGateway API. Private NatGateway does not require customers to attach an InternetGateway to the VPC and can be used for communication with other VPCs and on-premise networks.
* `Aws\ManagedBlockchain` - This release supports KMS customer-managed Customer Master Keys (CMKs) on member-specific Hyperledger Fabric resources.
* `Aws\RAM` - AWS Resource Access Manager (RAM) is releasing new field isResourceTypeDefault in ListPermissions and GetPermission response, and adding permissionArn parameter to GetResourceShare request to filter by permission attached
* `Aws\Redshift` - Added InvalidClusterStateFault to the ModifyAquaConfiguration API, thrown when calling the API on a non available cluster.
* `Aws\SageMaker` - Using SageMaker Edge Manager with AWS IoT Greengrass v2 simplifies accessing, maintaining, and deploying models to your devices. You can now create deployable IoT Greengrass components during edge packaging jobs. You can choose to create a device fleet with or without creating an AWS IoT role alias.
* `Aws\SageMakerFeatureStoreRuntime` - Release BatchGetRecord API for AWS SageMaker Feature Store Runtime.

## 3.184.0 - 2021-06-09

* `Aws\PersonalizeEvents` - Support for unstructured text inputs in the items dataset to to automatically extract key information from product/content description as an input when creating solution versions.
* `Aws\Proton` - This is the initial SDK release for AWS Proton
* `Aws\Transfer` - Documentation updates for the AWS Transfer Family service.
* `Aws\kendra` - AWS Kendra now supports checking document status.

## 3.183.15 - 2021-06-08

* `Aws\CognitoIdentityProvider` - Documentation updates for cognito-idp
* `Aws\FSx` - This release adds support for auditing end-user access to files, folders, and file shares using Windows event logs, enabling customers to meet their security and compliance needs.
* `Aws\Macie2` - This release of the Amazon Macie API introduces stricter validation of S3 object criteria for classification jobs.
* `Aws\ServiceCatalog` - increase max pagesize for List/Search apis

## 3.183.14 - 2021-06-07

* `Aws\EKS` - Added updateConfig option that allows customers to control upgrade velocity in Managed Node Group.
* `Aws\Glue` - Add SampleSize variable to S3Target to enable s3-sampling feature through API.
* `Aws\Personalize` - Update regex validation in kmsKeyArn and s3 path API parameters for AWS Personalize APIs
* `Aws\SageMaker` - AWS SageMaker - Releasing new APIs related to Callback steps in model building pipelines. Adds experiment integration to model building pipelines.

## 3.183.13 - 2021-06-04

* `Aws\AutoScaling` - Documentation updates for Amazon EC2 Auto Scaling
* `Aws\CloudTrail` - AWS CloudTrail supports data events on new service resources, including Amazon DynamoDB tables and S3 Object Lambda access points.
* `Aws\MediaLive` - Add support for automatically setting the H.264 adaptive quantization and GOP B-frame fields.
* `Aws\PI` - The new GetDimensionKeyDetails action retrieves the attributes of the specified dimension group for a DB instance or data source.
* `Aws\QLDB` - Documentation updates for Amazon QLDB
* `Aws\RDS` - Documentation updates for RDS: fixing an outdated link to the RDS documentation in DBInstance$DBInstanceStatus

## 3.183.12 - 2021-06-03

* `Aws\ForecastService` - Added optional field AutoMLOverrideStrategy to CreatePredictor API that allows users to customize AutoML strategy. If provided in CreatePredictor request, this field is visible in DescribePredictor and GetAccuracyMetrics responses.
* `Aws\Route53Resolver` - Documentation updates for Route 53 Resolver
* `Aws\S3` - S3 Inventory now supports Bucket Key Status
* `Aws\S3Control` - Amazon S3 Batch Operations now supports S3 Bucket Keys.
* `Aws\SSM` - Documentation updates for ssm to fix customer reported issue

## 3.183.11 - 2021-06-02

* `Aws\AutoScaling` - You can now launch EC2 instances with GP3 volumes when using Auto Scaling groups with Launch Configurations
* `Aws\Braket` - Introduction of a RETIRED status for devices.
* `Aws\DocDB` - This SDK release adds support for DocDB global clusters.
* `Aws\ECS` - Documentation updates for Amazon ECS.
* `Aws\IAM` - Documentation updates for AWS Identity and Access Management (IAM).
* `Aws\Lightsail` - Documentation updates for Lightsail

## 3.183.10 - 2021-06-01

* `Aws\EC2` - Added idempotency to CreateNetworkInterface using the ClientToken parameter.
* `Aws\IoTWireless` - Added six new public customer logging APIs to allow customers to set/get/reset log levels at resource type and resource id level. The log level set from the APIs will be used to filter log messages that can be emitted to CloudWatch in customer accounts.
* `Aws\Polly` - Amazon Polly adds new Canadian French voice - Gabrielle. Gabrielle is available as Neural voice only.
* `Aws\SNS` - This release adds SMS sandbox in Amazon SNS and the ability to view all configured origination numbers. The SMS sandbox provides a safe environment for sending SMS messages, without risking your reputation as an SMS sender.
* `Aws\ServiceDiscovery` - Bugfixes - The DiscoverInstances API operation now provides an option to return all instances for health-checked services when there are no healthy instances available.

## 3.183.9 - 2021-05-28

* `Aws\DataSync` - Added SecurityDescriptorCopyFlags option that allows for control of which components of SMB security descriptors are copied from source to destination objects.
* `Aws\LocationService` - Adds support for calculation of routes, resource tagging and customer provided KMS keys.
* `Aws\LookoutMetrics` - Allowing dot(.) character in table name for RDS and Redshift as source connector.

## 3.183.8 - 2021-05-27

* `Aws\DeviceFarm` - Introduces support for using our desktop testing service with applications hosted within your Virtual Private Cloud (VPC).
* `Aws\FSx` - This release adds LZ4 data compression support to FSx for Lustre to reduce storage consumption of both file system storage and file system backups.
* `Aws\IoTEvents` - Releasing new APIs for AWS IoT Events Alarms
* `Aws\IoTEventsData` - Releasing new APIs for AWS IoT Events Alarms
* `Aws\IoTSiteWise` - IoT SiteWise Monitor Portal API updates to add alarms feature configuration.
* `Aws\Lightsail` - Documentation updates for Lightsail
* `Aws\ResourceGroups` - Documentation updates for Resource Groups.
* `Aws\SQS` - Documentation updates for Amazon SQS for General Availability of high throughput for FIFO queues.
* `Aws\kendra` - Amazon Kendra now suggests popular queries in order to help guide query typing and help overall accuracy.

## 3.183.7 - 2021-05-27

* `Aws\EC2` - This release removes resource ids and tagging support for VPC security group rules.

## 3.183.6 - 2021-05-26

* `Aws\ACMPCA` - This release enables customers to store CRLs in S3 buckets with Block Public Access enabled. The release adds the S3ObjectAcl parameter to the CreateCertificateAuthority and UpdateCertificateAuthority APIs to allow customers to choose whether their CRL will be publicly available.
* `Aws\CloudFront` - Documentation fix for CloudFront
* `Aws\EC2` - This release adds resource ids and tagging support for VPC security group rules.
* `Aws\ECS` - The release adds support for registering External instances to your Amazon ECS clusters.
* `Aws\MWAA` - Adds scheduler count selection for Environments using Airflow version 2.0.2 or later.
* `Aws\Outposts` - Add ConflictException to DeleteOutpost, CreateOutpost
* `Aws\QLDB` - Support STANDARD permissions mode in CreateLedger and DescribeLedger. Add UpdateLedgerPermissionsMode to update permissions mode on existing ledgers.

## 3.183.5 - 2021-05-25

* `Aws\IoT` - This release includes support for a new feature: Job templates for AWS IoT Device Management Jobs. The release includes job templates as a new resource and APIs for managing job templates.
* `Aws\Transfer` - AWS Transfer Family customers can now use AWS Managed Active Directory or AD Connector to authenticate their end users, enabling seamless migration of file transfer workflows that rely on AD authentication, without changing end users' credentials or needing a custom authorizer.
* `Aws\WorkSpaces` - Adds support for Linux device types in WorkspaceAccessProperties

## 3.183.4 - 2021-05-24

* `Aws\CloudWatchLogs` - This release provides dimensions and unit support for metric filters.
* `Aws\ComputeOptimizer` - Adds support for 1) additional instance types, 2) additional instance metrics, 3) finding reasons for instance recommendations, and 4) platform differences between a current instance and a recommended instance type.
* `Aws\CostExplorer` - Introduced FindingReasonCodes, PlatformDifferences, DiskResourceUtilization and NetworkResourceUtilization to GetRightsizingRecommendation action
* `Aws\EC2` - This release adds support for creating and managing EC2 On-Demand Capacity Reservations on Outposts.
* `Aws\QuickSight` - Add new parameters on RegisterUser and UpdateUser APIs to assign or update external ID associated to QuickSight users federated through web identity.

## 3.183.3 - 2021-05-21

* `Aws\EFS` - EFS now supports account preferences. Utilizing the new capability, users can customize some aspects of their experience using EFS APIs and the EFS Console. The first preference clients are able to set is whether to start using longer File System and Mount Target IDs before EFS migrates to such IDs.
* `Aws\ForecastService` - Updated attribute statistics in DescribeDatasetImportJob response to support Long values
* `Aws\OpsWorksCM` - New PUPPET_API_CRL attribute returned by DescribeServers API; new EngineVersion of 2019 available for Puppet Enterprise servers.
* `Aws\S3` - Documentation updates for Amazon S3

## 3.183.2 - 2021-05-20

* `Aws\IAM` - Documentation updates for AWS Identity and Access Management (IAM).
* `Aws\LexModelsV2` - Customers can now use resource-based policies to control access to their Lex V2 bots. This release adds APIs to attach and manage permissions for a bot or a bot alias. For details, see: https://docs.aws.amazon.com/lexv2/latest/dg/security_iam_service-with-iam.html
* `Aws\Personalize` - Added new API to stop a solution version creation that is pending or in progress for Amazon Personalize
* `Aws\QuickSight` - Add ARN based Row Level Security support to CreateDataSet/UpdateDataSet APIs.

## 3.183.1 - 2021-05-19

* `Aws\AutoScaling` - With this release, customers can easily use Predictive Scaling as a policy directly through Amazon EC2 Auto Scaling configurations to proactively scale their applications ahead of predicted demand.
* `Aws\EKS` - Update the EKS AddonActive waiter.
* `Aws\IAM` - Add pagination to ListUserTags operation
* `Aws\KinesisAnalyticsV2` - Kinesis Data Analytics now allows rapid iteration on Apache Flink stream processing through the Kinesis Data Analytics Studio feature.
* `Aws\Lightsail` - Documentation updates for Amazon Lightsail.
* `Aws\Rekognition` - Amazon Rekognition Custom Labels adds support for customer managed encryption, using AWS Key Management Service, of image files copied into the service and files written back to the customer.

## 3.183.0 - 2021-05-18

* `Aws\AppRunner` - AWS App Runner is a service that provides a fast, simple, and cost-effective way to deploy from source code or a container image directly to a scalable and secure web application in the AWS Cloud.
* `Aws\ComputeOptimizer` - This release enables compute optimizer to support exporting recommendations to Amazon S3 for EBS volumes and Lambda Functions.
* `Aws\IoTSiteWise` - Documentation updates for AWS IoT SiteWise.
* `Aws\LexModelsV2` - This release adds support for exporting and importing Lex V2 bots and bot locales. It also adds validations to enforce minimum number of tags on Lex V2 resources. For details, see https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html
* `Aws\LicenseManager` - AWS License Manager now supports periodic report generation.
* `Aws\Personalize` - Amazon Personalize now supports the ability to optimize a solution for a custom objective in addition to maximizing relevance.
* `Aws\Support` - Documentation updates for support

## 3.182.0 - 2021-05-17

* `Aws\` - Performed the migration to static API to in order to use the future versions Guzzle\Psr7 using the [migration guide](https://github.com/guzzle/psr7#upgrading-from-function-api).
* `Aws\Api` - Fixed a bug where certain characters weren't escaped in the XML encoding
* `Aws\ApplicationCostProfiler` - APIs for AWS Application Cost Profiler.
* `Aws\AugmentedAIRuntime` - Documentation updates for Amazon A2I Runtime model
* `Aws\ElastiCache` - Documentation updates for elasticache
* `Aws\IoTDeviceAdvisor` - AWS IoT Core Device Advisor is fully managed test capability for IoT devices. Device manufacturers can use Device Advisor to test their IoT devices for reliable and secure connectivity with AWS IoT.
* `Aws\MediaConnect` - MediaConnect now supports JPEG XS for AWS Cloud Digital Interface (AWS CDI) uncompressed workflows, allowing you to establish a bridge between your on-premises live video network and the AWS Cloud.
* `Aws\Neptune` - Neptune support for CopyTagsToSnapshots

## 3.181.2 - 2021-05-14

* `Aws\CloudWatchEvents` - Update InputTransformer variable limit from 10 to 100 variables.
* `Aws\Detective` - Updated descriptions of array parameters to add the restrictions on the array and value lengths.
* `Aws\ElasticsearchService` - Adds support for cold storage.
* `Aws\Endpoint` - Support for FIPS and handle global regions
* `Aws\EventBridge` - Update InputTransformer variable limit from 10 to 100 variables.
* `Aws\Macie2` - This release of the Amazon Macie API adds support for defining run-time, S3 bucket criteria for classification jobs. It also adds resources for querying data about AWS resources that Macie monitors.
* `Aws\SecurityHub` - Updated descriptions to add notes on array lengths.
* `Aws\TranscribeService` - Transcribe Medical now supports identification of PHI entities within transcripts
* `Aws\imagebuilder` - Text-only updates for bundled documentation feedback tickets - spring 2021.

## 3.181.1 - 2021-05-12

* `Aws\EC2` - High Memory virtual instances are powered by Intel Sky Lake CPUs and offer up to 12TB of memory.

## 3.181.0 - 2021-05-11

* `Aws\S3Control` - Documentation updates for Amazon S3-control
* `Aws\SSMContacts` - AWS Systems Manager Incident Manager enables faster resolution of critical application availability and performance issues, management of contacts and post incident analysis
* `Aws\SSMIncidents` - AWS Systems Manager Incident Manager enables faster resolution of critical application availability and performance issues, management of contacts and post-incident analysis
* `Aws\TranscribeStreamingService` - Amazon Transcribe supports partial results stabilization for streaming transcription.

## 3.180.6 - 2021-05-10

* `Aws\CodeArtifact` - Documentation updates for CodeArtifact
* `Aws\ConfigService` - Adds paginator to multiple APIs: By default, the paginator allows user to iterate over the results and allows the CLI to return up to 1000 results.
* `Aws\ECS` - This release contains updates for Amazon ECS.
* `Aws\EKS` - This release updates create-nodegroup and update-nodegroup-config APIs for adding/updating taints on managed nodegroups.
* `Aws\IoTWireless` - Add three new optional fields to support filtering and configurable sub-band in WirelessGateway APIs. The filtering is for all the RF region supported. The sub-band configuration is only applicable to LoRa gateways of US915 or AU915 RF region.
* `Aws\KinesisAnalyticsV2` - Amazon Kinesis Analytics now supports ListApplicationVersions and DescribeApplicationVersion API for Apache Flink applications
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for Kantar SNAP File Audio Watermarking with a Kantar Watermarking account, and Display Definition Segment(DDS) segment data controls for DVB-Sub caption outputs.
* `Aws\SSM` - This release adds new APIs to associate, disassociate and list related items in SSM OpsCenter; and this release adds DisplayName as a version-level attribute for SSM Documents and introduces two new document types: ProblemAnalysis, ProblemAnalysisTemplate.

## 3.180.5 - 2021-05-07

* `Aws\Connect` - Adds tagging support for Connect APIs CreateIntegrationAssociation and CreateUseCase.
* `Aws\LakeFormation` - This release adds Tag Based Access Control to AWS Lake Formation service
* `Aws\LookoutMetrics` - Enforcing UUID style for parameters that are already in UUID format today. Documentation specifying eventual consistency of lookoutmetrics resources.

## 3.180.4 - 2021-05-06

* `Aws\Kafka` - IAM Access Control for Amazon MSK enables you to create clusters that use IAM to authenticate clients and to allow or deny Apache Kafka actions for those clients.
* `Aws\SSM` - SSM feature release - ChangeCalendar integration with StateManager.
* `Aws\ServiceDiscovery` - Bugfix: Improved input validation for RegisterInstance action, InstanceId field
* `Aws\Snowball` - AWS Snow Family adds APIs for ordering and managing Snow jobs with long term pricing

## 3.180.3 - 2021-05-05

* `Aws\AuditManager` - This release updates the CreateAssessmentFrameworkControlSet and UpdateAssessmentFrameworkControlSet API data types. For both of these data types, the control set name is now a required attribute.
* `Aws\KinesisAnalyticsV2` - Amazon Kinesis Analytics now supports RollbackApplication for Apache Flink applications to revert the application to the previous running version
* `Aws\NimbleStudio` - Documentation Updates for Amazon Nimble Studio.
* `Aws\SageMaker` - Amazon SageMaker Autopilot now provides the ability to automatically deploy the best model to an endpoint

## 3.180.2 - 2021-05-05

* `Aws\FinSpaceData` - Documentation updates for FinSpaceData API.
* `Aws\finspace` - Documentation updates for FinSpace API.
* `Aws\finspace` - Fixed bug where incorrect Content-Type header was being sent to the Finspace and FinspaceData services

## 3.180.1 - 2021-05-04

* `Aws\ACMPCA` - This release adds the KeyStorageSecurityStandard parameter to the CreateCertificateAuthority API to allow customers to mandate a security standard to which the CA key will be stored within.
* `Aws\Chime` - This release adds the ability to search for and order international phone numbers for Amazon Chime SIP media applications.
* `Aws\DevOpsGuru` - Added GetCostEstimation and StartCostEstimation to get the monthly resource usage cost and added ability to view resource health by AWS service name and to search insights be AWS service name.
* `Aws\Health` - Documentation updates for health
* `Aws\SageMaker` - Enable retrying Training and Tuning Jobs that fail with InternalServerError by setting RetryStrategy.

## 3.180.0 - 2021-05-03

* `Aws\Chime` - Added new BatchCreateChannelMembership API to support multiple membership creation for channels
* `Aws\FinSpaceData` - This is the initial SDK release for the data APIs for Amazon FinSpace. Amazon FinSpace is a data management and analytics application for the financial services industry (FSI).
* `Aws\MTurk` - Documentation updates for Amazon Mechanical Turk, GetAccountBalanceOperation operation
* `Aws\SecurityHub` - Updated ASFF to add the following new resource details objects: AwsEc2NetworkAcl, AwsEc2Subnet, and AwsElasticBeanstalkEnvironment.
* `Aws\finspace` - This is the initial SDK release for the management APIs for Amazon FinSpace. Amazon FinSpace is a data management and analytics service for the financial services industry (FSI).

## 3.179.2 - 2021-04-30

* `Aws\CloudFront` - CloudFront now supports CloudFront Functions, a native feature of CloudFront that enables you to write lightweight functions in JavaScript for high-scale, latency-sensitive CDN customizations.
* `Aws\CustomerProfiles` - This release introduces GetMatches and MergeProfiles APIs to fetch and merge duplicate profiles
* `Aws\ForecastService` - Added new DeleteResourceTree operation that helps in deleting all the child resources of a given resource including the given resource.
* `Aws\MarketplaceCatalog` - Allows user defined names for Changes in a ChangeSet. Users can use ChangeNames to reference properties in another Change within a ChangeSet. This feature allows users to make changes to an entity when the entity identifier is not yet available while constructing the StartChangeSet request.
* `Aws\Personalize` - Update URL for dataset export job documentation.
* `Aws\RoboMaker` - Adds ROS2 Foxy as a supported Robot Software Suite Version and Gazebo 11 as a supported Simulation Software Suite Version
* `Aws\S3` - Generalized DateTime to DateTimeInterface in an S3Client's createPresignedRequest function and in Cloudfront/LogFileIterator's NormalizeDateValue function

## 3.179.1 - 2021-04-29

* `Aws\Chime` - Increase AppInstanceUserId length to 64 characters
* `Aws\ECS` - Add support for EphemeralStorage on TaskDefinition and TaskOverride
* `Aws\Macie2` - The Amazon Macie API now provides S3 bucket metadata that indicates whether a bucket policy requires server-side encryption of objects when objects are uploaded to the bucket.
* `Aws\Organizations` - Minor text updates for AWS Organizations API Reference

## 3.179.0 - 2021-04-28

* `Aws\CloudFormation` - Add CallAs parameter to GetTemplateSummary to enable use with StackSets delegated administrator integration
* `Aws\Connect` - Updated max number of tags that can be attached from 200 to 50. MaxContacts is now an optional parameter for the UpdateQueueMaxContact API.
* `Aws\IoTSiteWise` - AWS IoT SiteWise interpolation API will get interpolated values for an asset property per specified time interval during a period of time.
* `Aws\MediaPackageVod` - MediaPackage now offers the option to place your Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) encoder metadata in every video segment instead of in the init fragment for DASH and CMAF endpoints.
* `Aws\NimbleStudio` - Amazon Nimble Studio is a virtual studio service that empowers visual effects, animation, and interactive content teams to create content securely within a scalable, private cloud service.

## 3.178.11 - 2021-04-27

* `Aws\AuditManager` - This release restricts using backslashes in control, assessment, and framework names. The controlSetName field of the UpdateAssessmentFrameworkControlSet API now allows strings without backslashes.
* `Aws\S3` - Bugfix to apply the correct signature to certain functions in S3 object lambda requests

## 3.178.10 - 2021-04-26

* `Aws\CodeGuruReviewer` - Include KMS Key Details in Repository Association APIs to enable usage of customer managed KMS Keys.
* `Aws\EC2` - Adding support for Red Hat Enterprise Linux with HA for Reserved Instances.
* `Aws\EKS` - This release updates existing Amazon EKS input validation so customers will see an InvalidParameterException instead of a ParamValidationError when they enter 0 for minSize and/or desiredSize. It also adds LaunchTemplate information to update responses and a new "CUSTOM" value for AMIType.
* `Aws\Glue` - Adding Kafka Client Auth Related Parameters
* `Aws\IoTWireless` - Add a new optional field MessageType to support Sidewalk devices in SendDataToWirelessDevice API
* `Aws\KinesisAnalyticsV2` - Amazon Kinesis Data Analytics now supports custom application maintenance configuration using UpdateApplicationMaintenanceConfiguration API for Apache Flink applications. Customers will have visibility when their application is under maintenance status using 'MAINTENANCE' application status.
* `Aws\MediaConvert` - Documentation updates for mediaconvert
* `Aws\Personalize` - Added support for exporting data imported into an Amazon Personalize dataset to a specified data source (Amazon S3 bucket).

## 3.178.9 - 2021-04-23

* `Aws\MediaPackage` - Add support for Widevine DRM on CMAF origin endpoints. Both Widevine and FairPlay DRMs can now be used simultaneously, with CBCS encryption.
* `Aws\SNS` - Amazon SNS adds two new attributes, TemplateId and EntityId, for using sender IDs to send SMS messages to destinations in India.

## 3.178.8 - 2021-04-22

* `Aws\CognitoIdentityProvider` - Documentation updates for cognito-idp
* `Aws\ElastiCache` - This release introduces log delivery of Redis slow log from Amazon ElastiCache.
* `Aws\ForecastService` - This release adds EstimatedTimeRemaining minutes field to the DescribeDatasetImportJob, DescribePredictor, DescribeForecast API response which denotes the time remaining to complete the job IN_PROGRESS.
* `Aws\SecurityHub` - Replaced the term "master" with "administrator". Added new actions to replace AcceptInvitation, GetMasterAccount, and DisassociateFromMasterAccount. In Member, replaced MasterId with AdministratorId.

## 3.178.7 - 2021-04-21

* `Aws\CloudFormation` - Added support for creating and updating stack sets with self-managed permissions from templates that reference macros.
* `Aws\Detective` - Added parameters to track the data volume in bytes for a member account. Deprecated the existing parameters that tracked the volume as a percentage of the allowed volume for a behavior graph. Changes reflected in MemberDetails object.
* `Aws\GroundStation` - Support new S3 Recording Config allowing customers to write downlink data directly to S3.
* `Aws\Redshift` - Add operations: AddPartner, DescribePartners, DeletePartner, and UpdatePartnerStatus to support tracking integration status with data partners.
* `Aws\kendra` - Amazon Kendra now enables users to override index-level boosting configurations for each query.

## 3.178.6 - 2021-04-19

* `Aws\CostExplorer` - Adding support for Sagemaker savings plans in GetSavingsPlansPurchaseRecommendation API
* `Aws\SavingsPlans` - Added support for Amazon SageMaker in Machine Learning Savings Plans

## 3.178.5 - 2021-04-15

* `Aws\DatabaseMigrationService` - AWS DMS added support of TLS for Kafka endpoint. Added Describe endpoint setting API for DMS endpoints.
* `Aws\STS` - STS now supports assume role with Web Identity using JWT token length upto 20000 characters

## 3.178.4 - 2021-04-14

* `Aws\CodeStarconnections` - This release adds tagging support for CodeStar Connections Host resources
* `Aws\ConfigService` - Add exception for DeleteRemediationConfiguration and DescribeRemediationExecutionStatus
* `Aws\MediaConnect` - For flows that use Listener protocols, you can now easily locate an output's outbound IP address for a private internet. Additionally, MediaConnect now supports the Waiters feature that makes it easier to poll for the status of a flow until it reaches its desired state.
* `Aws\Route53` - Documentation updates for route53

## 3.178.3 - 2021-04-13

* `Aws\ComprehendMedical` - The InferICD10CM API now returns TIME_EXPRESSION entities that refer to medical conditions.
* `Aws\Lightsail` - Documentation updates for Amazon Lightsail.
* `Aws\RDS` - Clarify that enabling or disabling automated backups causes a brief downtime, not an outage.
* `Aws\Redshift` - Added support to enable AQUA in Amazon Redshift clusters.
* `Aws\STS` - This release adds the SourceIdentity parameter that can be set when assuming a role.

## 3.178.2 - 2021-04-12

* `Aws\CodeBuild` - AWS CodeBuild now allows you to set the access permissions for build artifacts, project artifacts, and log files that are uploaded to an Amazon S3 bucket that is owned by another account.
* `Aws\FSx` - Support for cross-region and cross-account backup copies

## 3.178.1 - 2021-04-09

* `Aws\EC2` - Add paginator support to DescribeStoreImageTasks and update documentation.
* `Aws\Redshift` - Add support for case sensitive table level restore
* `Aws\Shield` - CreateProtection now throws InvalidParameterException instead of InternalErrorException when system tags (tag with keys prefixed with "aws:") are passed in.

## 3.178.0 - 2021-04-08

* `Aws\AppStream` - This release provides support for image updates
* `Aws\AutoScaling` - Amazon EC2 Auto Scaling announces Warm Pools that help applications to scale out faster by pre-initializing EC2 instances and save money by requiring fewer continuously running instances
* `Aws\CustomerProfiles` - Documentation updates for Put-Integration API
* `Aws\KinesisVideoArchivedMedia` - Documentation updates for archived.kinesisvideo
* `Aws\LookoutEquipment` - This release introduces support for Amazon Lookout for Equipment.
* `Aws\RAM` - Documentation updates for AWS RAM resource sharing
* `Aws\RoboMaker` - This release allows RoboMaker customers to specify custom tools to run with their simulation job

## 3.177.0 - 2021-04-07

* `Aws\AccessAnalyzer` - IAM Access Analyzer now analyzes your CloudTrail events to identify actions and services that have been used by an IAM entity (user or role) and generates an IAM policy that is based on that activity.
* `Aws\ElastiCache` - This release adds tagging support for all AWS ElastiCache resources except Global Replication Groups.
* `Aws\IVS` - This release adds support for the Auto-Record to S3 feature. Amazon IVS now enables you to save your live video to Amazon S3.
* `Aws\StorageGateway` - File Gateway APIs now support FSx for Windows as a cloud storage.
* `Aws\mgn` - Add new service - Application Migration Service.

## 3.176.9 - 2021-04-06

* `Aws\Cloud9` - Documentation updates for Cloud9
* `Aws\EC2` - This release adds support for storing EBS-backed AMIs in S3 and restoring them from S3 to enable cross-partition copying of AMIs
* `Aws\MediaLive` - MediaLive VPC outputs update to include Availability Zones, Security groups, Elastic Network Interfaces, and Subnet Ids in channel response
* `Aws\SSM` - Supports removing a label or labels from a parameter, enables ScheduledEndTime and ChangeDetails for StartChangeRequestExecution API, supports critical/security/other noncompliant count for patch API.

## 3.176.8 - 2021-04-05

* `Aws\Appflow` - Added destination properties for Zendesk.
* `Aws\AuditManager` - AWS Audit Manager has updated the GetAssessment API operation to include a new response field called userRole. The userRole field indicates the role information and IAM ARN of the API caller.
* `Aws\MediaLive` - MediaLive now support HTML5 Motion Graphics overlay

## 3.176.7 - 2021-04-02

* `Aws\MediaPackage` - SPEKE v2 is an upgrade to the existing SPEKE API to support multiple encryption keys, based on an encryption contract selected by the customer.
* `Aws\imagebuilder` - This release adds support for Block Device Mappings for container image builds, and adds distribution configuration support for EC2 launch templates in AMI builds.

## 3.176.6 - 2021-04-01

* `Aws\EC2` - VPC Flow Logs Service adds a new API, GetFlowLogsIntegrationTemplate, which generates CloudFormation templates for Athena. For more info, see https://docs.aws.amazon.com/console/vpc/flow-logs/athena
* `Aws\FMS` - Added Firewall Manager policy support for AWS Route 53 Resolver DNS Firewall.
* `Aws\LexModelBuildingService` - Lex now supports the ja-JP locale
* `Aws\LexRuntimeService` - Amazon Lex now supports base64-encoded message and input transcript fields.
* `Aws\Lightsail` - - This release adds support for state detail for Amazon Lightsail container services.
* `Aws\MediaConvert` - MediaConvert now supports HLS ingest, sidecar WebVTT ingest, Teletext color & style passthrough to TTML subtitles, TTML to WebVTT subtitle conversion with style, & DRC profiles in AC3 audio.
* `Aws\Route53Resolver` - Route 53 Resolver DNS Firewall is a firewall service that allows you to filter and regulate outbound DNS traffic for your VPCs.
* `Aws\WAFV2` - Added support for ScopeDownStatement for ManagedRuleGroups, Labels, LabelMatchStatement, and LoggingFilter. For more information on these features, see the AWS WAF Developer Guide.
* `Aws\kendra` - AWS Kendra's ServiceNow data source now supports OAuth 2.0 authentication and knowledge article filtering via a ServiceNow query.

## 3.176.5 - 2021-03-31

* `Aws\Batch` - AWS Batch adds support for Amazon EFS File System
* `Aws\Cloud9` - Add ImageId input parameter to CreateEnvironmentEC2 endpoint. New parameter enables creation of environments with different AMIs.
* `Aws\CloudFormation` - 1. Added a new parameter "RegionConcurrencyType" in OperationPreferences. 2. Changed the name of "AccountUrl" to "AccountsUrl" in "DeploymentTargets" parameter.
* `Aws\CloudHSM` - Minor documentation and link updates.
* `Aws\CognitoSync` - Minor documentation updates and link updates.
* `Aws\Comprehend` - Support for customer managed KMS encryption of Comprehend custom models
* `Aws\DataPipeline` - Minor documentation updates and link updates.
* `Aws\Detective` - Added the ability to assign tag values to Detective behavior graphs. Tag values can be used for attribute-based access control, and for cost allocation for billing.
* `Aws\DirectConnect` - This release adds MACsec support to AWS Direct Connect
* `Aws\IoT` - Added ability to prefix search on attribute value for ListThings API.
* `Aws\IoTWireless` - Add Sidewalk support to APIs: GetWirelessDevice, ListWirelessDevices, GetWirelessDeviceStatistics. Add Gateway connection status in GetWirelessGatewayStatistics API.
* `Aws\MachineLearning` - Minor documentation updates and link updates.
* `Aws\Pricing` - Minor documentation and link updates.
* `Aws\Redshift` - Enable customers to share access to their Redshift clusters from other VPCs (including VPCs from other accounts).
* `Aws\TranscribeService` - Amazon Transcribe now supports creating custom language models in the following languages: British English (en-GB), Australian English (en-AU), Indian Hindi (hi-IN), and US Spanish (es-US).
* `Aws\WorkMail` - This release adds support for mobile device access rules management in Amazon WorkMail.

## 3.176.4 - 2021-03-30

* `Aws\CloudWatch` - SDK update for new Metric Streams feature
* `Aws\ConfigService` - Adding new APIs to support ConformancePack Compliance CI in Aggregators
* `Aws\EC2` - ReplaceRootVolume feature enables customers to replace the EBS root volume of a running instance to a previously known state. Add support to grant account-level access to the EC2 serial console
* `Aws\EC2InstanceConnect` - Adding support to push SSH keys to the EC2 serial console in order to allow an SSH connection to your Amazon EC2 instance's serial port.
* `Aws\FraudDetector` - This release adds support for Batch Predictions in Amazon Fraud Detector.
* `Aws\GlueDataBrew` - This SDK release adds two new dataset features: 1) support for specifying a database connection as a dataset input 2) support for dynamic datasets that accept configurable parameters in S3 path.
* `Aws\Pinpoint` - Added support for journey pause/resume, journey updatable import segment and journey quiet time wait.
* `Aws\SageMaker` - Amazon SageMaker Autopilot now supports 1) feature importance reports for AutoML jobs and 2) PartialFailures for AutoML jobs

## 3.176.3 - 2021-03-29

* `Aws\DocDB` - This release adds support for Event Subscriptions to DocumentDB.
* `Aws\Glue` - Allow Dots in Registry and Schema Names for CreateRegistry, CreateSchema; Fixed issue when duplicate keys are present and not returned as part of QuerySchemaVersionMetadata.
* `Aws\IAM` - AWS Identity and Access Management GetAccessKeyLastUsed API will throw a custom error if customer public key is not found for access keys.
* `Aws\LocationService` - Amazon Location added support for specifying pricing plan information on resources in alignment with our cost model.
* `Aws\WAFV2` - Added custom request handling and custom response support in rule actions and default action; Added the option to inspect the web request body as parsed and filtered JSON.

## 3.176.2 - 2021-03-26

* `Aws\CloudWatchEvents` - Add support for SageMaker Model Builder Pipelines Targets to EventBridge
* `Aws\CustomerProfiles` - This release adds an optional parameter named FlowDefinition in PutIntegrationRequest.
* `Aws\EventBridge` - Add support for SageMaker Model Builder Pipelines Targets to EventBridge
* `Aws\IoTWireless` - Support tag-on-create for WirelessDevice.
* `Aws\TranscribeService` - Amazon Transcribe now supports tagging words that match your vocabulary filter for batch transcription.

## 3.176.1 - 2021-03-26

* `Aws\LookoutMetrics` - Allowing uppercase alphabets for RDS and Redshift database names.
* `Aws\LookoutMetrics` - Fixed bug where incorrect Content-Type header was being sent to the LookoutMetrics service

## 3.176.0 - 2021-03-25

* `Aws\AlexaForBusiness` - Added support for enabling and disabling data retention in the CreateProfile and UpdateProfile APIs and retrieving the state of data retention for a profile in the GetProfile API.
* `Aws\LookoutMetrics` - Amazon Lookout for Metrics is now generally available. You can use Lookout for Metrics to monitor your data for anomalies. For more information, see the Amazon Lookout for Metrics Developer Guide.
* `Aws\MediaLive` - EML now supports handling HDR10 and HLG 2020 color space from a Link input.
* `Aws\Rekognition` - "This release introduces AWS tagging support for Amazon Rekognition collections, stream processors, and Custom Label models."
* `Aws\SQS` - Documentation updates for Amazon SQS
* `Aws\SageMaker` - This feature allows customer to specify the environment variables in their CreateTrainingJob requests.

## 3.175.3 - 2021-03-24

* `Aws\EC2` - maximumEfaInterfaces added to DescribeInstanceTypes API
* `Aws\Greengrass` - Updated the parameters to make name required for CreateGroup API.
* `Aws\Route53` - Documentation updates for route53
* `Aws\S3` - Documentation updates for Amazon S3
* `Aws\S3Control` - Documentation updates for s3-control
* `Aws\SES` - Adds support for generating V4 SMTP credentials for SES
* `Aws\SSM` - This release allows SSM Explorer customers to enable OpsData sources across their organization when creating a resource data sync.

## 3.175.2 - 2021-03-23

* `Aws\CostExplorer` - You can now create cost categories with inherited value rules and specify default values for any uncategorized costs.
* `Aws\FIS` - Updated maximum allowed size of action parameter from 64 to 1024
* `Aws\GameLift` - GameLift adds support for using event notifications to monitor game session placements. Specify an SNS topic or use CloudWatch Events to track activity for a game session queue.
* `Aws\IAM` - Documentation updates for IAM operations and descriptions.
* `Aws\Redshift` - Removed APIs to control AQUA on clusters.

## 3.175.1 - 2021-03-22

* `Aws\CodeArtifact` - Documentation updates for CodeArtifact
* `Aws\EC2` - This release adds support for UEFI boot on selected AMD- and Intel-based EC2 instances.
* `Aws\Macie2` - This release of the Amazon Macie API adds support for publishing sensitive data findings to AWS Security Hub and specifying which categories of findings to publish to Security Hub.
* `Aws\Redshift` - Added support to enable AQUA in Amazon Redshift clusters.

## 3.175.0 - 2021-03-19

* `Aws\EC2` - X2gd instances are the next generation of memory-optimized instances powered by AWS-designed, Arm-based AWS Graviton2 processors.
* `Aws\S3` - Added support for object lambda endpoints.
* `Aws\SageMaker` - Adding authentication support for pulling images stored in private Docker registries to build containers for real-time inference.

## 3.174.3 - 2021-03-18

* `Aws\AutoScaling` - Amazon EC2 Auto Scaling Instance Refresh now supports phased deployments.
* `Aws\Redshift` - Add new fields for additional information about VPC endpoint for clusters with reallocation enabled, and a new field for total storage capacity for all clusters.
* `Aws\S3` - S3 Object Lambda is a new S3 feature that enables users to apply their own custom code to process the output of a standard S3 GET request by automatically invoking a Lambda function with a GET request
* `Aws\S3Control` - S3 Object Lambda is a new S3 feature that enables users to apply their own custom code to process the output of a standard S3 GET request by automatically invoking a Lambda function with a GET request
* `Aws\SecurityHub` - New object for separate provider and customer values. New objects track S3 Public Access Block configuration and identify sensitive data. BatchImportFinding requests are limited to 100 findings.

## 3.174.2 - 2021-03-17

* `Aws\Batch` - Making serviceRole an optional parameter when creating a compute environment. If serviceRole is not provided then Service Linked Role will be created (or reused if it already exists).
* `Aws\SageMaker` - Support new target device ml_eia2 in SageMaker CreateCompilationJob API

## 3.174.1 - 2021-03-16

* `Aws\AccessAnalyzer` - This release adds support for the ValidatePolicy API. IAM Access Analyzer is adding over 100 policy checks and actionable recommendations that help you validate your policies during authoring.
* `Aws\GameLift` - GameLift expands to six new AWS Regions, adds support for multi-location fleets to streamline management of hosting resources, and lets you customize more of the game session placement process.
* `Aws\IAM` - Documentation updates for AWS Identity and Access Management (IAM).
* `Aws\Lambda` - Allow empty list for function response types
* `Aws\MWAA` - This release adds UPDATE_FAILED and UNAVAILABLE MWAA environment states.
* `Aws\MediaConnect` - This release adds support for the SRT-listener protocol on sources and outputs.
* `Aws\MediaTailor` - MediaTailor channel assembly is a new manifest-only service that allows you to assemble linear streams using your existing VOD content.

## 3.174.0 - 2021-03-15

* `Aws\CodeDeploy` - AWS CodeDeploy can now detect instances running an outdated revision of your application and automatically update them with the latest revision.
* `Aws\ECS` - This is for ecs exec feature release which includes two new APIs - execute-command and update-cluster and an AWS CLI customization for execute-command API
* `Aws\EMR` - Amazon EMR customers can now specify Resource Group to target Capacity Reservations in their EMR clusters with instance fleets using allocation strategy.
* `Aws\FIS` - Initial release of AWS Fault Injection Simulator, a managed service that enables you to perform fault injection experiments on your AWS workloads
* `Aws\TranscribeStreamingService` - AWS Transcribe now supports real-time transcription for Chinese (zh-CN) and confidence scores in the transcription output.

## 3.173.28 - 2021-03-12

* `Aws\CostandUsageReportService` - - Added optional billingViewArn field for OSG.
* `Aws\MediaTailor` - MediaTailor channel assembly is a new manifest-only service that allows you to assemble linear streams using your existing VOD content.
* `Aws\WorkSpaces` - Adds API support for WorkSpaces bundle management operations.

## 3.173.27 - 2021-03-11

* `Aws\Comprehend` - ContainsPiiEntities API analyzes the input text for the presence of personally identifiable information(PII) and returns the labels of identified PII entity types such as name, address etc.
* `Aws\MediaLive` - MediaLive supports the ability to apply a canned ACL to output sent to an AWS S3 bucket; supports ability to specify position for EBU-TT and TTML output captions converted from Teletext source.
* `Aws\NetworkFirewall` - Correct the documentation about how you can provide rule group rules
* `Aws\WAFV2` - Correct the documentation about JSON body parsing behavior and IP set update behavior

## 3.173.26 - 2021-03-10

* `Aws\AccessAnalyzer` - This release adds support to preview IAM Access Analyzer findings for a resource before deploying resource permission changes.
* `Aws\Backup` - Added support for enabling continuous backups.
* `Aws\S3` - Adding ID element to the CORSRule schema
* `Aws\SSM` - Systems Manager support for tagging OpsMetadata.

## 3.173.25 - 2021-03-09

* `Aws\AutoScaling` - EC2 Auto Scaling now supports setting a local time zone for cron expressions in scheduled actions, removing the need to adjust for Daylight Saving Time (DST)
* `Aws\CodeGuruProfiler` - Update documentation to include Python. Add ConflictException for DeleteProfilingGroup. Add FrameMetricValue.
* `Aws\EFS` - AWS EFS is introducing one-zone file systems.
* `Aws\IoTWireless` - Add max value to Seq in SendDataToWirelessDevice API"
* `Aws\RDS` - This release adds support for Amazon RDS Proxy endpoints.

## 3.173.24 - 2021-03-08

* `Aws\AutoScaling` - Documentation updates for autoscaling for capacity-optimized-prioritized SpotAllocationStrategy
* `Aws\EMR` - Amazon EMR customers can now specify how EC2 On-Demand Capacity Reservations are used in their EMR clusters with instance fleets using allocation strategy.
* `Aws\KinesisVideoArchivedMedia` - Increase the maximum HLS and MPEG-DASH manifest size from 1,000 to 5,000 fragments.
* `Aws\Lambda` - Documentation updates for Lambda. Constraint updates to AddLayerVersionPermission's Action and OrganizationId parameters, and AddPermission's Principal and SourceAccount parameters.
* `Aws\S3` - Amazon S3 Documentation updates
* `Aws\S3Control` - Documentation updates for Amazon S3

## 3.173.23 - 2021-03-05

* `Aws\Appflow` - Documentation updates for arn:aws:trebuchet:::service:v1:decb008d-e0d8-44a4-b93c-092f0355d523
* `Aws\Athena` - Adds APIs to create, list, update, and delete prepared SQL statements that have optional placeholder parameters. A prepared statement can use different values for these parameters each time it is run.
* `Aws\CodePipeline` - Updated the parameters to make actionType required for UpdateActionType
* `Aws\EC2` - Expands EC2/Spot Fleet capacity-optimized allocation strategy to allow users to prioritize instance pools. Fleet attempts to fulfill priorities on a best-effort basis but optimizes for capacity first.
* `Aws\LicenseManager` - License Manager Automated Discovery now supports Exclusion Filters.
* `Aws\MediaLive` - Medialive now supports the ability to transfer AWS Elemental Link devices to another region.
* `Aws\NetworkFirewall` - Added a new UpdateToken output field to the PerObjectStatus as part of firewall sync state. This is added to track which version of the object the firewall is in sync or pending synchronization.
* `Aws\Shield` - Add support for tagging of Shield protection and protection group resources.

## 3.173.22 - 2021-03-04

* `Aws\CloudWatchEvents` - Introducing support for EventBridge Api Destinations - any HTTP APIs as Targets, with managed authorization via EventBridge Connections.
* `Aws\EventBridge` - Introducing support for EventBridge Api Destinations - any HTTP APIs as Targets, with managed authorization via EventBridge Connections.
* `Aws\MWAA` - This release introduces a new MinWorker parameter to the CreateEnvironment and UpdateEnvironment APIs. MinWorker allows the users to set a minimum worker count for worker auto-scaling operations.
* `Aws\SageMaker` - This release adds the ResolvedOutputS3Uri to the DescribeFeatureGroup API to indicate the S3 prefix where offline data is stored in a feature group
* `Aws\ServiceDiscovery` - Supports creating API-only services under DNS namespace. Add namespace syntax validation.

## 3.173.21 - 2021-03-03

* `Aws\ACM` - Adds 2 new APIs to add and retrieve account configuration in AWS Certificate Manager.
* `Aws\CloudWatchEvents` - Adds TraceHeader to PutEventsRequestEntry to support AWS X-Ray trace-ids on events generated using the PutEvents operation.
* `Aws\CodeBuild` - AWS CodeBuild now supports Session Manager debugging for batch builds.
* `Aws\ElasticsearchService` - AWS ElasticSearch Feature : Support for adding tags in elastic search domain during domain creation
* `Aws\ForecastService` - Added new StopResource operation that stops Amazon Forecast resource jobs that are in progress.
* `Aws\Macie2` - This release of the Amazon Macie API includes miscellaneous updates and improvements to the documentation.
* `Aws\SecretsManager` - Added support for multi-Region secrets APIs ReplicateSecretToRegions, RemoveRegionsFromReplication, and StopReplicationToReplica
* `Aws\WellArchitected` - This release supports tagging on AWS Well-Architected workloads.

## 3.173.20 - 2021-03-02

* `Aws\ComputeOptimizer` - Documentation updates for Compute Optimizer
* `Aws\DataSync` - Additional API Support to update NFS/SMB/ObjectStorage locations
* `Aws\DirectConnect` - Doc only update for AWS Direct Connect that fixes several customer-reported issues
* `Aws\EventBridge` - Adds TraceHeader to PutEventsRequestEntry to support AWS X-Ray trace-ids on events generated using the PutEvents operation.
* `Aws\IoTWireless` - Add ARN & Tags for PartnerAccount related APIs and WirelessGatewayTaskDefinition related APIs
* `Aws\ManagedBlockchain` - Updates for Ethereum general availability release.

## 3.173.19 - 2021-03-01

* `Aws\AlexaForBusiness` - Added support for optional tags in CreateAddressBook, CreateConferenceProvider, CreateContact, CreateGatewayGroup, CreateNetworkProfile and RegisterAVSDevice APIs.
* `Aws\CodePipeline` - Added a new field to the ListPipelines API to allow maximum search results of 1000
* `Aws\EKS` - Adding new error code AdmissionRequestDenied for Addons in EKS
* `Aws\SSM` - Add Support for Patch Manger Baseline Override parameter.

## 3.173.18 - 2021-02-26

* `Aws\EKS` - Amazon EKS now supports adding KMS envelope encryption to existing clusters to enhance security for secrets
* `Aws\EMR` - Added UpdateStudio API that allows updating a few attributes of an EMR Studio.
* `Aws\S3` - Add RequestPayer to GetObjectTagging and PutObjectTagging.
* `Aws\SSOAdmin` - Relax constraint on List* API pagination tokens to include underscore character

## 3.173.17 - 2021-02-25

* `Aws\Detective` - Changed "master account" to "administrator account." A new AdministratorId field replaces the deprecated MasterId field. Added an option to disable email notifications for member account invitations.
* `Aws\GlueDataBrew` - This SDK release adds two new dataset features: 1) support for specifying the file format for a dataset, and 2) support for specifying whether the first row of a CSV or Excel file contains a header.
* `Aws\Lightsail` - Documentation updates for Lightsail
* `Aws\Transfer` - Corrected the upper limit for TestIdentityProvider input lengths to 1024 characters
* `Aws\imagebuilder` - This release introduces a new API (ListImagePackages) for listing packages installed on an image, and adds support for GP3 volume types, and for specifying a time zone in an image pipeline schedule.

## 3.173.16 - 2021-02-24

* `Aws\Appflow` - # Adding 'Amazon Honeycode' , 'Amazon Lookout for Metrics' and 'Amazon Connect Customer Profiles' as Destinations.
* `Aws\ComputeOptimizer` - Documentation updates for Compute Optimizer
* `Aws\ECRPublic` - This release adds support for AWS tags on Amazon ECR Public repositories.
* `Aws\ElasticsearchService` - Amazon Elasticsearch Service now supports Auto-Tune, which monitors performance metrics and automatically optimizes domains
* `Aws\MediaPackageVod` - AWS Elemental MediaPackage provides access logs that capture detailed information about requests sent to a customer's MediaPackage VOD packaging group.

## 3.173.15 - 2021-02-23

* `Aws\AutoScaling` - Adds a new optional IncludeDeletedGroups parameter to the DescribeScalingActivities API.
* `Aws\Connect` - Documentation updates for AWS Connect (MediaConcurrency Limit).
* `Aws\Glue` - Updating the page size for Glue catalog getter APIs.
* `Aws\IoTEvents` - This release adds an Analyze feature to AWS IoT Events that lets customers analyze their detector models for runtime issues.
* `Aws\Pinpoint` - Enables AWS Pinpoint customers to use Entity Id and Template Id when sending SMS message. These parameters can be obtained from the regulatory body of the country where you are trying to send the SMS.
* `Aws\QuickSight` - Documentation updates for QuickSight Row Level Security
* `Aws\RedshiftDataAPIService` - This release adds an additional parameter 'ConnectedDatabase' into ListSchemasRequest, ListTablesRequest and DescribeTableRequest to support the metadata sharing across databases.
* `Aws\S3Control` - Documentation updates for s3-control

## 3.173.14 - 2021-02-22

* `Aws\SageMaker` - Amazon SageMaker now supports core dump for SageMaker Endpoints and direct invocation of a single container in a SageMaker Endpoint that hosts multiple containers.
* `Aws\SageMakerRuntime` - SageMaker Runtime now supports a new TargetContainerHostname header to invoke a model in a specific container if the endpoint hosts multiple containers and is configured to use direct invocation.

## 3.173.13 - 2021-02-19

* `Aws\RDS` - Added awsBackupRecoveryPointArn in ModifyDBInstanceRequest and in the response of ModifyDBInstance.

## 3.173.12 - 2021-02-18

* `Aws\CloudFormation` - Adding the 'callAs' parameter to all CloudFormation StackSets APIs except getTemplateSummary to support creating and managing service-managed StackSets with AWS Organizations Delegated Administrators
* `Aws\CodeBuild` - AWS CodeBuild now allows you to specify a separate bucket owner as part of the S3 destination in a report group.
* `Aws\Health` - Documentation updates for health
* `Aws\SageMaker` - This release adds expires-in-seconds parameter to the CreatePresignedDomainUrl API for support of a configurable TTL.

## 3.173.11 - 2021-02-17

* `Aws\ConfigService` - Added INSUFFICIENT_DATA in ConformancePackComplianceType.
* `Aws\EC2` - This release includes a new filter for describe-vpc-endpoint-services.
* `Aws\LookoutforVision` - This release for Amazon Lookout for Vision includes documentation updates and a correction to the Status field returned in the response from StartModel and StopModel.

## 3.173.10 - 2021-02-16

* `Aws\CodeBuild` - This release provides per-project limits for the number of concurrent builds
* `Aws\DevOpsGuru` - Amazon DevOps Guru is GA ready. This API update added a describeFeedback Api allows users to view submitted insight feedback. The release date is 02/16/2021

## 3.173.9 - 2021-02-15

* `Aws\ConfigService` - Added option to provide KMS key to AWS Config DeliveryChannel
* `Aws\KinesisVideoArchivedMedia` - The ListFragments and GetMediaForFragmentList APIs now support StreamName or StreamARN as input parameters.
* `Aws\Lightsail` - Documentation updates for Lightsail
* `Aws\MediaLive` - AWS MediaLive now supports Automatic-Input-Failover for CDI Inputs.
* `Aws\MediaTailor` - MediaTailor now supports specifying aliases for dynamic variables. This allows use cases such as binding multiple origin domains to a single MediaTailor playback configuration.
* `Aws\Pinpoint` - Lets customers use origination number when specifying SMS message configuration for Campaigns and Journeys.
* `Aws\RedshiftDataAPIService` - This release enables fine grant access control in ListStatements, GetStatementResult, CancelStatement and DescribeStatement.
* `Aws\WorkMailMessageFlow` - This release allows customers to update email messages as they flow in and out of Amazon WorkMail

## 3.173.8 - 2021-02-12

* `Aws\AppSync` - Approve release for appsync local on pipeline resolver
* `Aws\CodePipeline` - The release provides new GetActionType and UpdateActionType APIs for viewing and editing action types in CodePipeline.
* `Aws\Detective` - The API definition now indicates that the format for timestamps is an ISO 8601 date-time string
* `Aws\EKS` - Amazon EKS now supports OpenId Connect (OIDC) compatible identity providers as a user authentication option
* `Aws\ElasticLoadBalancingv2` - Adds a target group attribute for application-based stickiness for Application Load Balancers and an update to the client IP preservation attribute for Network Load Balancers.
* `Aws\IAM` - AWS Identity and Access Management now supports tagging for the following resources: customer managed policies, identity providers, instance profiles, server certificates, and virtual MFA devices.
* `Aws\Macie2` - This release of the Amazon Macie API replaces the term master account with the term administrator account, including deprecating APIs that use the previous term and adding APIs that use the new term.
* `Aws\PersonalizeEvents` - Increased maximum char size of PutUsers and PutItems properties.
* `Aws\RDS` - EngineMode in the response of DescribeDBClusterSnapshots. SupportedEngineModes, SupportsParallelQuery and SupportsGlobalDatabases in ValidUpgradeTarget of DBEngineVersions in DescribeDBEngineVersions.
* `Aws\WAFV2` - Added the option to inspect the web request body as parsed and filtered JSON (new FieldToMatch type JsonBody), in addition to the existing option to inspect the web request body as plain text.

## 3.173.7 - 2021-02-11

* `Aws\GlueDataBrew` - This release adds support for profile job sampling, which determines the number of rows on which the profile job will be executed.
* `Aws\RDS` - Adding support for RDS Aurora Global Database Failover

## 3.173.6 - 2021-02-09

* `Aws\GameLift` - GameLift FleetIQ users can now use AMD instance families in supported Regions. In addition, FlexMatch matchmaking notification now supports SNS FIFO topics.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for WMA audio only ingest, SMPTE-TT text and image caption ingest, and MPEG-2 video in MXF OP1a outputs.
* `Aws\QLDBSession` - This release adds CapacityExceededException to the AWS QLDBSession API.
* `Aws\QuickSight` - QuickSight now supports Python's paginators for Exploration APIs.
* `Aws\SageMaker` - Add a new optional FrameworkVersion field to Sagemaker Neo CreateCompilationJob API

## 3.173.5 - 2021-02-08

* `Aws\CloudTrail` - ConflictException is now thrown when certain operations are called on resources before CloudTrail has time to load the resources. Two new exceptions have been added to the PutInsightSelectors API.
* `Aws\DataExchange` - This release introduces the new ExportRevision job type, which allows for the export of an entire revision.
* `Aws\ElastiCache` - Documentation updates for elasticache
* `Aws\ElasticLoadBalancingv2` - Adds a target group attribute for application-based stickiness for Application Load Balancers.
* `Aws\GlobalAccelerator` - Global Accelerator now supports bringing your own IP addresses for custom routing accelerators
* `Aws\IVS` - Fixed an issue where StreamStartTime could not be unmarshalled from response. Changed DeleteChannel and DeleteStreamKey response codes to 204.
* `Aws\IoTSiteWise` - Recall CreatePresignedPortalUrl API
* `Aws\Macie2` - This release of the Amazon Macie API adds support for specifying a time range in queries for usage data.

## 3.173.4 - 2021-02-05

* `Aws\ElasticLoadBalancingv2` - Adds a target group attribute for client IP preservation for Network Load Balancers.
* `Aws\Macie` - Documentation updates for Amazon Macie Classic. We replaced the term "master account" with the term "administrator account." An administrator account is used to centrally manage multiple accounts.
* `Aws\Organizations` - Added support for a few additional exception codes for some AWS Organizations APIs.

## 3.173.3 - 2021-02-04

* `Aws\Appflow` - Adding schedule offset as an input for scheduled flows in CreateFlow API. Also, adding data pull start time and data pull end time for DescribeFlowExecutionRecords API response.
* `Aws\Athena` - Adds the Athena ListEngineVersions action and the EngineVersion data type. ListEngineVersions returns the available Athena engine versions, including Auto, as a list of EngineVersion objects.
* `Aws\DLM` - Provide support for EBS Local Snapshots on AWS Outpost in Data Lifecycle Manager (DLM).
* `Aws\EC2` - AWS Outposts now supports EBS local snapshots on Outposts that allows customers to store snapshots of EBS volumes and AMIs locally on S3 on Outposts.
* `Aws\EMRContainers` - This release is to correct the timestamp format to ISO8601 for the date parameters in the describe and list API response objects of Job Run and Virtual Clusters.
* `Aws\QuickSight` - API release for field folders feature.

## 3.173.2 - 2021-02-04

* `Aws\S3` - This release fixes an issue with URL generation

## 3.173.1 - 2021-02-03

* `Aws\AuditManager` - This release adds AccessDeniedException to GetServicesInScope API.
* `Aws\CodeBuild` - Documentation updates for codebuild
* `Aws\ComputeOptimizer` - Documentation updates for Compute Optimizer
* `Aws\CostExplorer` - Clarify valid values for the filter parameter for certain APIs.
* `Aws\EC2` - EC2 Public IP now supports API for setting PTR records on Elastic IP address.
* `Aws\GlueDataBrew` - This release adds the DescribeJobRun API to allow customers retrieve details of a given job run
* `Aws\IoTSiteWise` - Update AccessPolicy API input to support IAM role for IAM mode. Iam role is added as part of accessPolicyIdentity.
* `Aws\Lambda` - Support for creating Lambda Functions using 'nodejs14.x'
* `Aws\S3` - Fix issue with s3 request uri generation
* `Aws\SecurityHub` - Added a ProductArn parameter to DescribeProducts. ProductArn is used to identify the integration to return details for.
* `Aws\WorkMail` - Increased maximum length of ipRanges values for Access Control Rules from 10 to 1024.

## 3.173.0 - 2021-02-02

* `Aws\` - Added privatelink functionality
* `Aws\AppMesh` - App Mesh now supports mutual TLS with two-way peer authentication. You can specify client certificates, server-side TLS validation, and matching of Subject Alternative Names.
* `Aws\ApplicationAutoScaling` - With this release, scheduled actions of Application Auto Scaling can be created in the local time zone and automatically adjusted according to daylight saving changes.
* `Aws\IoTWireless` - Add enum value MqttTopic for Destination ExpressionType, add LoRaWANNetworkServerCertificateId for GetWirelessGatewayCertificate API
* `Aws\LocationService` - Doc only update for Amazon Location Maps that fixes a customer related issue regarding MapConfiguration
* `Aws\LookoutforVision` - This release includes the General Availability (GA) SDK for Amazon Lookout for Vision. New for GA is tagging support for Amazon Lookout for Vision models.
* `Aws\MediaLive` - AWS Elemental MediaLive now supports Image Media Playlists on HLS outputs, version 0.4 (trick-mode).
* `Aws\Organizations` - Documentation updates for AWS Organizations.
* `Aws\RDSDataService` - With the Data API, you can now use UUID and JSON data types as input to your database. Also with the Data API, you can now have a LONG type value returned from your database as a STRING value.
* `Aws\Route53` - Documentation updates for Route 53
* `Aws\S3Control` - Amazon S3 Batch Operations now supports Delete Object Tagging

## 3.172.4 - 2021-01-29

* `Aws\Connect` - Added API to manage queues or get hours of operation for a queue programmatically, which can be used to create new/update queues, or take actions when skills are outside of their hours of operation.
* `Aws\LexModelsV2` - Fixed bug where incorrect Content-Type header was being sent to the LexModelsV2 service
* `Aws\Macie2` - This release of the Amazon Macie API adds support for using object prefixes to refine the scope of a classification job.
* `Aws\MediaLive` - "AWS Elemental MediaLive now supports output to a private VPC. When this property is specified, the output will egress from a user specified VPC."
* `Aws\TranscribeStreamingService` - Amazon Transcribe Streaming Medical now supports Protected Health Information (PHI) identification which enables you to identify PHI entities based on HIPAA Privacy Rule.

## 3.172.3 - 2021-01-28

* `Aws\CloudWatch` - Update to SDK to support label time zones in CloudWatch GetMetricData
* `Aws\GlueDataBrew` - This SDK release adds support for specifying a custom delimiter for input CSV datasets and for CSV job outputs.
* `Aws\IoT` - Documentation updates for IoT DeleteOTAUpdate API
* `Aws\ManagedBlockchain` - This release supports tagging on Amazon Managed Blockchain resources.
* `Aws\RoboMaker` - This release allows Robomaker customers to specify configuration for uploading logs and artifacts generated by their simulation jobs.
* `Aws\WellArchitected` - Documentation updates for AWS Well-Architected Tool

## 3.172.2 - 2021-01-27

* `Aws\AccessAnalyzer` - This release adds Secrets Manager secrets as a supported resource in IAM Access Analyzer to help you identify secrets that can be accessed from outside your account or AWS organization.
* `Aws\CustomerProfiles` - This release makes Uri a required parameter in GetIntegrationRequest and DeleteIntegrationRequest.
* `Aws\ElastiCache` - Add support to pass ParameterGroup name as part updating Engine Version of Global Datastore.
* `Aws\ElasticsearchService` - Amazon Elasticsearch Service adds support for node-to-node encryption and encryption at rest for existing domains running Elasticsearch version 6.7 and above
* `Aws\Lightsail` - Documentation updates for Lightsail
* `Aws\SesV2` - This release includes the ability to assign a configuration set to an email identity (a domain or email address), which allows the settings from the configuration set to be applied to the identity.

## 3.172.1 - 2021-01-26

* `Aws\Backup` - Documentation updates for AWS Backup

## 3.172.0 - 2021-01-22

* `Aws\EC2` - Introducing startDate field for CapacityReservation object for the date and time which the reservation started and adding reserved parameter for ModifyCapacityReservation.
* `Aws\GreengrassV2` - Documentation updates that improve clarity and fix broken links.
* `Aws\LexModelsV2` - This release adds support for Amazon Lex V2 APIs for model building.
* `Aws\LexRuntimeV2` - This release adds support for Amazon Lex V2 APIs for runtime, including Streaming APIs for conversation management.
* `Aws\RDS` - Documentation updates for Amazon RDS
* `Aws\Redshift` - Update VPC endpoint field names.
* `Aws\SSM` - Documentation updates for the ListDocumentFilters API action.

## 3.171.21 - 2021-01-21

* `Aws\Kafka` - Amazon MSK has added a new API that allows you to update all the brokers in the cluster to the specified type.
* `Aws\ResourceGroupsTaggingAPI` - This release adds a new parameter ResourceARNList to Resource Groups Tagging api GetResources api to allow customers retrieve tag data for specific resources.
* `Aws\SecurityHub` - This release of ASFF adds a new Action object and a new resource details object - AwsSsmPatchCompliance. It also adds several new attributes for the AwsEc2NetworkInterface resource type.

## 3.171.20 - 2021-01-19

* `Aws\ACMPCA` - ACM Private CA is launching additional certificate templates and API parameters. This allows customers to create custom certificates for their identity and secure communication use cases.
* `Aws\Chime` - Add support for specifying ChimeBearer header as part of the request for Amazon Chime SDK messaging APIs. Documentation updates.
* `Aws\ECS` - This release adds support to include task definition metadata information such as registeredAt, deregisteredAt, registeredBy as part of DescribeTaskDefinition API.

## 3.171.19 - 2021-01-15

* `Aws\SNS` - Documentation updates for Amazon SNS.

## 3.171.18 - 2021-01-14

* `Aws\CognitoIdentity` - Add Attributes For Access Control support for Amazon Cognito Identity Pools to facilitate access to AWS resources based on attributes from social and corporate identity providers
* `Aws\Pinpoint` - Customers can create segments using 5 new filters. Filters can check for the presence of a substring in attributes and can perform time-based comparisons formatted as ISO_INSTANT datetimes.
* `Aws\S3Control` - Amazon S3 Batch Operations now supports restoring objects from the S3 Intelligent-Tiering Archive Access and Deep Archive Access tiers.
* `Aws\SageMaker` - This feature allows customers to enable/disable model caching on Multi-Model endpoints.

## 3.171.17 - 2021-01-13

* `Aws\FraudDetector` - Added support for cancelling a model version that is TRAINING_IN_PROGRESS.
* `Aws\Personalize` - Miscellaneous updates and improvements to the documentation

## 3.171.16 - 2021-01-12

* `Aws\AppStream` - Adds support for the Smart Card Redirection feature
* `Aws\AuditManager` - This release introduces tag support for assessment frameworks. You can now add, remove, and get tags from existing frameworks, and specify the tags to apply when creating a custom framework.
* `Aws\ElastiCache` - Documentation updates for elasticache
* `Aws\Lightsail` - This release adds IPv6 support for Amazon Lightsail instances, container services, CDN distributions, and load balancers.
* `Aws\SSM` - AWS Systems Manager adds pagination support for DescribeDocumentPermission API

## 3.171.15 - 2021-01-11

* `Aws\KMS` - Adds support for filtering grants by grant ID and grantee principal in ListGrants requests to AWS KMS.
* `Aws\RDS` - This releases adds support for Major Version Upgrades on Aurora MySQL Global Clusters. Customers will be able to upgrade their whole Aurora MySQL Global Cluster to a new major engine version.

## 3.171.14 - 2021-01-07

* `Aws\CodePipeline` - Adding cancelled status and summary for executions aborted by pipeline updates.
* `Aws\DevOpsGuru` - Add resourceHours field in GetAccountHealth API to show total number of resource hours AWS Dev Ops Guru has done work for in the last hour.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for I-Frame-only HLS manifest generation in CMAF outputs.

## 3.171.13 - 2021-01-06

* `Aws\AutoScaling` - This update increases the number of instance types that can be added to the overrides within an mixed instances group configuration.
* `Aws\AutoScalingPlans` - Documentation updates for AWS Auto Scaling
* `Aws\Transfer` - This release adds support for Amazon EFS, so customers can transfer files over SFTP, FTPS and FTP in and out of Amazon S3 as well as Amazon EFS.

## 3.171.12 - 2021-01-05

* `Aws\ApplicationAutoScaling` - Documentation updates for Application Auto Scaling
* `Aws\CostExplorer` - - ### Features - Add new GetCostcategories API - Support filter for GetDimensions, GetTags and GetCostcategories api - Support sortBy metrics for GetDimensions, GetTags and GetCostcategories api

## 3.171.11 - 2021-01-04

* `Aws\CloudSearch` - This release adds support for new Amazon CloudSearch instances.
* `Aws\HealthLake` - Amazon HealthLake now supports exporting data from FHIR Data Stores in Preview.

## 3.171.10 - 2020-12-31

* `Aws\ServiceCatalog` - Enhanced Service Catalog DescribeProvisioningParameters API to return new parameter constraints, i.e., MinLength, MaxLength, MinValue, MaxValue, ConstraintDescription and AllowedPattern

## 3.171.9 - 2020-12-30

* `Aws\ElastiCache` - Documentation updates for elasticache
* `Aws\Macie2` - This release of the Amazon Macie API includes miscellaneous updates and improvements to the documentation.

## 3.171.8 - 2020-12-29

* `Aws\ACMPCA` - This release adds a new parameter "CsrExtensions" in the "CertificateAuthorityConfiguration" data structure, which allows customers to add the addition of KU and SIA into the CA CSR.
* `Aws\ApiGatewayV2` - Amazon API Gateway now supports data mapping for HTTP APIs which allows customers to modify HTTP Request before sending it to their integration and HTTP Response before sending it to the invoker.

## 3.171.7 - 2020-12-28

* `Aws\CloudFront` - Amazon CloudFront has deprecated the CreateStreamingDistribution and CreateStreamingDistributionWithTags APIs as part of discontinuing support for Real-Time Messaging Protocol (RTMP) distributions.

## 3.171.6 - 2020-12-23

* `Aws\ComputeOptimizer` - This release enables AWS Compute Optimizer to analyze and generate optimization recommendations for lambda functions.
* `Aws\DatabaseMigrationService` - AWS DMS launches support for AWS Secrets Manager to manage Oracle ASM Database credentials
* `Aws\ResourceGroups` - Add operation `PutGroupConfiguration`. Support dedicated hosts and add `Pending` in operations `Un/GroupResources`. Add `Resources` in `ListGroupResources` and deprecate `ResourceIdentifiers`.

## 3.171.5 - 2020-12-22

* `Aws\Connect` - This release adds support for quick connects. For details, see the Release Notes in the Amazon Connect Administrator Guide.
* `Aws\CostExplorer` - This release adds additional metadata that may be applicable to the Rightsizing Recommendations.
* `Aws\ElastiCache` - Documentation updates for elasticache
* `Aws\Glue` - AWS Glue Find Matches machine learning transforms now support column importance scores.
* `Aws\IoTWireless` - Adding the ability to use Fingerprint in GetPartnerAccount and ListPartnerAccounts API responses to protect sensitive customer account information.
* `Aws\RDS` - Adds customer-owned IP address (CoIP) support to Amazon RDS on AWS Outposts.
* `Aws\SSM` - SSM Maintenance Window support for registering/updating maintenance window tasks without targets.

## 3.171.4 - 2020-12-22

* `Aws\Connect` - This release adds support for quick connects. For details, see the Release Notes in the Amazon Connect Administrator Guide.
* `Aws\CostExplorer` - This release adds additional metadata that may be applicable to the Rightsizing Recommendations.
* `Aws\ElastiCache` - Documentation updates for elasticache
* `Aws\Glue` - AWS Glue Find Matches machine learning transforms now support column importance scores.
* `Aws\IoTWireless` - Adding the ability to use Fingerprint in GetPartnerAccount and ListPartnerAccounts API responses to protect sensitive customer account information.
* `Aws\RDS` - Adds customer-owned IP address (CoIP) support to Amazon RDS on AWS Outposts.
* `Aws\SSM` - SSM Maintenance Window support for registering/updating maintenance window tasks without targets.

## 3.171.3 - 2020-12-21

* `Aws\APIGateway` - Documentation updates for Amazon API Gateway.
* `Aws\AppRegistry` - New API `SyncResouce` to update AppRegistry system tags.
* `Aws\Batch` - Documentation updates for batch
* `Aws\ConfigService` - AWS Config adds support to save advanced queries. New API operations - GetStoredQuery, PutStoredQuery, ListStoredQueries, DeleteStoredQuery
* `Aws\ConnectParticipant` - This release adds three new APIs: StartAttachmentUpload, CompleteAttachmentUpload, and GetAttachment. For Amazon Connect Chat, you can use these APIs to share files in chat conversations.
* `Aws\Credentials` - Bugfix to throw an exception on empty token file.
* `Aws\DatabaseMigrationService` - AWS DMS launches support for AWS Secrets Manager to manage source and target database credentials.
* `Aws\EC2` - This release adds Tag On Create feature support for the AllocateAddress API.
* `Aws\Glue` - Add 4 connection properties: SECRET_ID, CONNECTOR_URL, CONNECTOR_TYPE, CONNECTOR_CLASS_NAME. Add two connection types: MARKETPLACE, CUSTOM
* `Aws\ManagedBlockchain` - Added support for provisioning and managing public Ethereum nodes on main and test networks supporting secure access using Sigv4 and standard open-source Ethereum APIs.
* `Aws\Outposts` - In this release, AWS Outposts adds support for three new APIs: TagResource, UntagResource, and ListTagsForResource. Customers can now manage tags for their resources through the SDK.
* `Aws\QLDBSession` - Adds "TimingInformation" to all SendCommand API results and "IOUsage" to ExecuteStatementResult, FetchPageResult and CommitTransactionResult.
* `Aws\S3` - Format GetObject's Expires header to be an http-date instead of iso8601
* `Aws\SecurityHub` - Finding providers can now use BatchImportFindings to update Confidence, Criticality, RelatedFindings, Severity, and Types.
* `Aws\ServiceQuotas` - Added the ability to tag applied quotas.

## 3.171.2 - 2020-12-18

* `Aws\` - Removed dev guide from this repo and linked to the new repo where it is hosted
* `Aws\EC2` - EBS io2 volumes now supports Multi-Attach
* `Aws\PersonalizeRuntime` - Updated FilterValues regex pattern to align with Filter Expression.
* `Aws\RDS` - Adds IAM DB authentication information to the PendingModifiedValues output of the DescribeDBInstances API. Adds ClusterPendingModifiedValues information to the output of the DescribeDBClusters API.

## 3.171.1 - 2020-12-17

* `Aws\` - Fix using ecs credentials provider on multi-threaded servers
* `Aws\ConfigService` - Adding PutExternalEvaluation API which grants permission to deliver evaluation result to AWS Config
* `Aws\Credentials` - Aligns the credential resolver to the documentation and other SDK behaviors.
* `Aws\DLM` - Provide Cross-account copy event based policy support in DataLifecycleManager (DLM)
* `Aws\EC2` - C6gn instances are powered by AWS Graviton2 processors and offer 100 Gbps networking bandwidth. These instances deliver up to 40% better price-performance benefit versus comparable x86-based instances
* `Aws\Handler` - GuzzleHandler now accepts errors as well as exceptions on failure; errors are added to the body of the RejectionException from the promise
* `Aws\KMS` - Added CreationDate and LastUpdatedDate timestamps to ListAliases API response
* `Aws\Route53` - This release adds support for DNSSEC signing in Amazon Route 53.
* `Aws\Route53Resolver` - Route 53 Resolver adds support for enabling resolver DNSSEC validation in virtual private cloud (VPC).
* `Aws\SQS` - Amazon SQS adds queue attributes to enable high throughput FIFO.
* `Aws\ServiceCatalog` - Support TagOptions sharing with Service Catalog portfolio sharing.
* `Aws\imagebuilder` - This release adds support for building and distributing container images within EC2 Image Builder.

## 3.171.0 - 2020-12-16

* `Aws\CostExplorer` - This release updates the "MonitorArnList" from a list of String to be a list of Arn for both CreateAnomalySubscription and UpdateAnomalySubscription APIs
* `Aws\LocationService` - Initial release of Amazon Location Service. A new geospatial service providing capabilities to render maps, geocode/reverse geocode, track device locations, and detect geofence entry/exit events.
* `Aws\PrometheusService` - Documentation updates for Amazon Managed Service for Prometheus
* `Aws\QuickSight` - QuickSight now supports connecting to federated data sources of Athena
* `Aws\WellArchitected` - This is the first release of AWS Well-Architected Tool API support, use to review your workload and compare against the latest AWS architectural best practices.

## 3.170.0 - 2020-12-15

* `Aws\GreengrassV2` - AWS IoT Greengrass V2 is a new major version of AWS IoT Greengrass. This release adds several updates such as modular components, continuous deployments, and improved ease of use.
* `Aws\IoT` - AWS IoT Rules Engine adds Kafka Action that allows sending data to Apache Kafka clusters inside a VPC. AWS IoT Device Defender adds custom metrics and machine-learning based anomaly detection.
* `Aws\IoTAnalytics` - FileFormatConfiguration enables data store to save data in JSON or Parquet format. S3Paths enables you to specify the S3 objects that save your channel messages when you reprocess the pipeline.
* `Aws\IoTDeviceAdvisor` - AWS IoT Core Device Advisor is fully managed test capability for IoT devices. Device manufacturers can use Device Advisor to test their IoT devices for reliable and secure connectivity with AWS IoT.
* `Aws\IoTFleetHub` - AWS IoT Fleet Hub, a new feature of AWS IoT Device Management that provides a web application for monitoring and managing device fleets connected to AWS IoT at scale.
* `Aws\IoTWireless` - AWS IoT for LoRaWAN enables customers to setup a private LoRaWAN network by connecting their LoRaWAN devices and gateways to the AWS cloud without managing a LoRaWAN Network Server.
* `Aws\Lambda` - Added support for Apache Kafka as a event source. Added support for TumblingWindowInSeconds for streams event source mappings. Added support for FunctionResponseTypes for streams event source mappings
* `Aws\PrometheusService` - (New Service) Amazon Managed Service for Prometheus is a fully managed Prometheus-compatible monitoring service that makes it easy to monitor containerized applications securely and at scale.
* `Aws\SSM` - Adding support for Change Manager API content

## 3.169.0 - 2020-12-14

* `Aws\` - Added support for github actions
* `Aws\` - Fix using ecs credentials provider on multi-threaded servers
* `Aws\DevOpsGuru` - Documentation updates for DevOps Guru.
* `Aws\EC2` - Add c5n.metal to ec2 instance types list
* `Aws\GlobalAccelerator` - This release adds support for custom routing accelerators

## 3.168.3 - 2020-12-11

* `Aws\AutoScaling` - Documentation updates and corrections for Amazon EC2 Auto Scaling API Reference and SDKs.
* `Aws\CloudTrail` - CloudTrailInvalidClientTokenIdException is now thrown when a call results in the InvalidClientTokenId error code. The Name parameter of the AdvancedEventSelector data type is now optional.
* `Aws\CloudWatch` - Documentation updates for monitoring
* `Aws\GuardDuty` - Documentation updates for GuardDuty
* `Aws\IoTSiteWise` - Added the ListAssetRelationships operation and support for composite asset models, which represent structured sets of properties within asset models.
* `Aws\PI` - You can group DB load according to the dimension groups for database, application, and session type. Amazon RDS also supports the dimensions db.name, db.application.name, and db.session_type.name.

## 3.168.2 - 2020-12-10

* `Aws\EC2` - TGW connect simplifies connectivity of SD-WAN appliances; IGMP support for TGW multicast; VPC Reachability Analyzer for VPC resources connectivity analysis.
* `Aws\NetworkManager` - This release adds API support for Transit Gateway Connect integration into AWS Network Manager.
* `Aws\kendra` - Amazon Kendra now supports adding synonyms to an index through the new Thesaurus resource.

## 3.168.1 - 2020-12-09

* `Aws\EC2` - This release adds support for G4ad instances powered by AMD Radeon Pro V520 GPUs and AMD 2nd Generation EPYC processors
* `Aws\GlobalAccelerator` - This release adds support for custom routing accelerators
* `Aws\Redshift` - Add support for availability zone relocation feature.

## 3.168.0 - 2020-12-08

* `Aws\AuditManager` - AWS Audit Manager helps you continuously audit your AWS usage to simplify how you manage risk and compliance. This update releases the first version of the AWS Audit Manager APIs and SDK.
* `Aws\ECR` - This release adds support for configuring cross-region and cross-account replication of your Amazon ECR images.
* `Aws\EMRContainers` - This release adds support for Amazon EMR on EKS, a simple way to run Spark on Kubernetes.
* `Aws\ForecastService` - This release adds support for the Amazon Forecast Weather Index which can increase forecasting accuracy by automatically including weather forecasts in demand forecasts.
* `Aws\HealthLake` - This release introduces Amazon HealthLake (preview), a HIPAA-eligible service that enables healthcare and life sciences customers to store, transform, query, and analyze health data in the AWS Cloud.
* `Aws\QuickSight` - Added new parameters for join optimization.
* `Aws\Rds` - Added optional configurable lifetime value to Rds AuthTokenGenerator
* `Aws\SageMaker` - This feature helps you monitor model performance characteristics such as accuracy, identify undesired bias in your ML models, and explain model decisions better with explainability drift detection.
* `Aws\SageMakerRuntime` - This feature allows customers to invoke their endpoint with an inference ID. If used and data capture for the endpoint is enabled, this ID will be captured along with request data.
* `Aws\SagemakerEdgeManager` - Amazon SageMaker Edge Manager makes it easy to optimize, secure, monitor, and maintain machine learning (ML) models across fleets of edge devices such as smart cameras, smart speakers, and robots.
* `Aws\kendra` - 1. Amazon Kendra connector for Google Drive repositories 2. Amazon Kendra's relevance ranking models are regularly tuned for each customer by capturing end-user search patterns and feedback.

## 3.167.0 - 2020-12-07

* `Aws\` - Adds cross region pre-signing to various methods in DocDbClient, RdsClient, and NeptuneClient
* `Aws\AppRegistry` - AWS Service Catalog AppRegistry now supports adding, removing, and listing tags on resources after they are created.
* `Aws\DatabaseMigrationService` - Added PreserveTransaction setting to preserve order of CDC for S3 as target. Added CsvNoSupValue setting to replace empty value for columns not included in the supplemental log for S3 as target.

## 3.166.2 - 2020-12-04

* `Aws\DirectoryService` - Documentation updates for ds - updated descriptions
* `Aws\EC2` - This release introduces tag-on-create capability for the CreateImage API. A user can now specify tags that will be applied to the new resources (image, snapshots or both), during creation time.
* `Aws\Kafka` - Adding HEALING to ClusterState.
* `Aws\Lambda` - Added the additional enum InvalidImage to StateReasonCode and LastUpdateStatusReasonCode fields.
* `Aws\LicenseManager` - Automated Discovery now has support for custom tags, and detects software uninstalls.
* `Aws\MediaLive` - AWS Elemental MediaLive now supports black video and audio silence as new conditions to trigger automatic input failover.
* `Aws\Multipart` - Added a validation that a file hasn't been corrupted
* `Aws\RDS` - Adds support for Amazon RDS Cross-Region Automated Backups, the ability to setup automatic replication of snapshots and transaction logs from a primary AWS Region to a secondary AWS Region.
* `Aws\SSM` - AWS Systems Manager Patch Manager MAC OS Support and OpsMetadata Store APIs to store operational metadata for an Application.
* `Aws\WorkSpaces` - Update the import-workspace-image API to have "BYOL_REGULAR_WSP" as a valid input string for ingestion-process.

## 3.166.1 - 2020-12-03

* `Aws\AmplifyBackend` - Regular documentation updates.
* `Aws\Batch` - This release adds support for customer to run Batch Jobs on ECS Fargate, the serverless compute engine built for containers on AWS. Customer can also propagate Job and Job Definition Tags to ECS Task.
* `Aws\ComputeOptimizer` - This release enables AWS Compute Optimizer to analyze and generate optimization recommendations for EBS volumes that are attached to instances.
* `Aws\LicenseManager` - AWS License Manager enables managed entitlements for AWS customers and Software Vendors (ISV). You can track and distribute license entitlements from AWS Marketplace and supported ISVs.

## 3.166.0 - 2020-12-01

* `Aws\CustomerProfiles` - This is the first release of Amazon Connect Customer Profiles, a unified customer profile for your Amazon Connect contact center.
* `Aws\Profile` - PR to remove profile folder from aws-models.

## 3.165.0 - 2020-12-01

* `Aws\AmplifyBackend` - (New Service) The Amplify Admin UI offers an accessible way to develop app backends and manage app content. We recommend that you use the Amplify Admin UI to manage the backend of your Amplify app.
* `Aws\AppIntegrationsService` - The Amazon AppIntegrations service (in preview release) enables you to configure and reuse connections to external applications.
* `Aws\Connect` - This release adds an Amazon Connect API that provides the ability to create tasks, and a set of APIs (in preview) to configure AppIntegrations associations with Amazon Connect instances.
* `Aws\ConnectContactLens` - Contact Lens for Amazon Connect analyzes conversations, both real-time and post-call. The ListRealtimeContactAnalysisSegments API returns a list of analysis segments for a real-time analysis session.
* `Aws\DevOpsGuru` - (New Service) Amazon DevOps Guru is available in public preview. It's a fully managed service that uses machine learning to analyze your operational solutions to help you find and troubleshoot issues.
* `Aws\DirectoryService` - Adding client authentication feature for AWS AD Connector
* `Aws\EC2` - This release adds support for: EBS gp3 volumes; and D3/D3en/R5b/M5zn instances powered by Intel Cascade Lake CPUs
* `Aws\ECRPublic` - Supports Amazon Elastic Container Registry (Amazon ECR) Public, a fully managed registry that makes it easy for a developer to publicly share container software worldwide for anyone to download.
* `Aws\EKS` - Amazon EKS now allows you to define and manage the lifecycle for Kubernetes add-ons for your clusters. This release adds support for the AWS VPC CNI (vpc-cni).
* `Aws\Honeycode` - Introducing APIs to read and write directly from Honeycode tables. Use APIs to pull table and column metadata, then use the read and write APIs to programmatically read and write from the tables.
* `Aws\Lambda` - This release includes support for a new feature: Container images support in AWS Lambda. This adds APIs for deploying functions as container images. AWS Lambda now supports memory up to 10240MB.
* `Aws\LookoutforVision` - This release introduces support for Amazon Lookout for Vision.
* `Aws\Profile` - This is the first release of Amazon Connect Customer Profiles, a unified customer profile for your Amazon Connect contact center.
* `Aws\S3` - S3 adds support for multiple-destination replication, option to sync replica modifications; S3 Bucket Keys to reduce cost of S3 SSE with AWS KMS
* `Aws\SageMaker` - Amazon SageMaker Pipelines for ML workflows. Amazon SageMaker Feature Store, a fully managed repository for ML features.
* `Aws\SageMakerFeatureStoreRuntime` - This release adds support for Amazon SageMaker Feature Store, which makes it easy for customers to create, version, share, and manage curated data for machine learning (ML) development.

## 3.164.1 - 2020-12-01

* `Aws\` - Use the assertSame to make assert equals strict, test namespace improvements
* `Aws\` - Code changes to mock exceptions correctly in mockhandler
* `Aws\EC2` - This release introduces Amazon EC2 Mac1 instances, a new Amazon EC2 instance family built on Apple Mac mini computers, powered by AWS Nitro System, and support running macOS workloads on Amazon EC2

## 3.164.0 - 2020-11-24

* `Aws\Appflow` - Upsolver as a destination connector and documentation update.
* `Aws\Batch` - Add Ec2Configuration in ComputeEnvironment.ComputeResources. Use in CreateComputeEnvironment API to enable AmazonLinux2 support.
* `Aws\CloudFormation` - Adds support for the new Modules feature for CloudFormation. A module encapsulates one or more resources and their respective configurations for reuse across your organization.
* `Aws\CloudTrail` - CloudTrail now includes advanced event selectors, which give you finer-grained control over the events that are logged to your trail.
* `Aws\CodeBuild` - Adding GetReportGroupTrend API for Test Reports.
* `Aws\CognitoIdentityProvider` - This release adds ability to configure Cognito User Pools with third party sms and email providers for sending notifications to users.
* `Aws\Comprehend` - Support Comprehend events detection APIs
* `Aws\ElasticBeanstalk` - Updates the Integer constraint of DescribeEnvironmentManagedActionHistory's MaxItems parameter to [1, 100].
* `Aws\FSx` - This release adds the capability to increase storage capacity of Amazon FSx for Lustre file systems, providing the flexibility to meet evolving storage needs over time.
* `Aws\GameLift` - GameLift FlexMatch is now available as a standalone matchmaking solution. FlexMatch now provides customizable matchmaking for games hosted peer-to-peer, on-premises, or on cloud compute primitives.
* `Aws\IoTSiteWise` - This release adds support for customer managed customer master key (CMK) based encryption in IoT SiteWise.
* `Aws\LexModelBuildingService` - Lex now supports es-419, de-DE locales
* `Aws\MWAA` - (New Service) Amazon MWAA is a managed service for Apache Airflow that makes it easy for data engineers and data scientists to execute data processing workflows in the cloud.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for Vorbis and Opus audio in OGG/OGA containers.
* `Aws\QuickSight` - Support for embedding without user registration. New enum EmbeddingIdentityType. A potential breaking change. Affects code that refers IdentityType enum type directly instead of literal string value.
* `Aws\SFN` - This release of the AWS Step Functions SDK introduces support for Synchronous Express Workflows
* `Aws\TimestreamWrite` - Adds support of upserts for idempotent updates to Timestream.
* `Aws\TranscribeStreamingService` - Amazon Transcribe Medical streaming added medical specialties and HTTP/2 support. Amazon Transcribe streaming supports additional languages. Both support OGG/OPUS and FLAC codecs for streaming.

## 3.163.3 - 2020-11-23

* `Aws\ApplicationInsights` - Add Detected Workload to ApplicationComponent which shows the workloads that installed in the component
* `Aws\AutoScaling` - Documentation updates and corrections for Amazon EC2 Auto Scaling API Reference and SDKs.
* `Aws\CodeArtifact` - Add support for the NuGet package format.
* `Aws\CodeStarconnections` - Added support for the UpdateHost API.
* `Aws\DynamoDB` - With this release, you can capture data changes in any Amazon DynamoDB table as an Amazon Kinesis data stream. You also can use PartiQL (SQL-compatible language) to manipulate data in DynamoDB tables.
* `Aws\EC2` - This release adds support for Multiple Private DNS names to DescribeVpcEndpointServices response.
* `Aws\ECS` - This release adds support for updating capacity providers, specifying custom instance warmup periods for capacity providers, and using deployment circuit breaker for your ECS Services.
* `Aws\EMR` - Add API support for EMR Studio, a new notebook-first IDE for data scientists and data engineers with single sign-on, Jupyter notebooks, automated infrastructure provisioning, and job diagnosis.
* `Aws\ElastiCache` - Documentation updates for elasticache
* `Aws\ForecastService` - Releasing the set of PredictorBacktestExportJob APIs which allow customers to export backtest values and item-level metrics data from Predictor training.
* `Aws\Glue` - Feature1 - Glue crawler adds data lineage configuration option. Feature2 - AWS Glue Data Catalog adds APIs for PartitionIndex creation and deletion as part of Enhancement Partition Management feature.
* `Aws\IoT` - This release enables users to identify different file types in the over-the-air update (OTA) functionality using fileType parameter for CreateOTAUpdate API
* `Aws\Kafka` - Adding MAINTENANCE and REBOOTING_BROKER to Cluster states.
* `Aws\Lambda` - This release includes support for new feature: Code Signing for AWS Lambda. This adds new resources and APIs to configure Lambda functions to accept and verify signed code artifacts at deployment.
* `Aws\LicenseManager` - AWS License Manager now provides the ability for license administrators to be able to associate license configurations to AMIs shared with their AWS account
* `Aws\Outposts` - Support specifying tags during the creation of the Outpost resource. Tags are now returned in the response body of Outpost APIs.
* `Aws\SSOAdmin` - AWS Single Sign-On now enables attribute-based access control for workforce identities to simplify permissions in AWS
* `Aws\SecurityHub` - Updated the account management API to support the integration with AWS Organizations. Added new methods to allow users to view and manage the delegated administrator account for Security Hub.
* `Aws\TimestreamQuery` - Amazon Timestream now supports "QueryStatus" in Query API which has information about cumulative bytes scanned, metered, as well as progress percentage for the query.
* `Aws\Translate` - This update adds new operations to create and manage parallel data in Amazon Translate. Parallel data is a resource that you can use to run Active Custom Translation jobs.
* `Aws\signer` - AWS Signer is launching code-signing for AWS Lambda. Now customers can cryptographically sign Lambda code to ensure trust, integrity, and functionality.

## 3.163.2 - 2020-11-20

* `Aws\AppMesh` - This release makes tag value a required attribute of the tag's key-value pair.
* `Aws\AppRegistry` - AWS Service Catalog AppRegistry Documentation update
* `Aws\Chime` - The Amazon Chime SDK for messaging provides the building blocks needed to build chat and other real-time collaboration features.
* `Aws\CloudHSMV2` - Added managed backup retention, a feature that enables customers to retain backups for a configurable period after which CloudHSM service will automatically delete them.
* `Aws\CodeGuruReviewer` - This release supports tagging repository association resources in Amazon CodeGuru Reviewer.
* `Aws\CognitoIdentity` - Added SDK pagination support for ListIdentityPools
* `Aws\Connect` - This release adds a set of Amazon Connect APIs to programmatically control instance creation, modification, description and deletion.
* `Aws\Kafka` - This release adds support for PER TOPIC PER PARTITION monitoring on AWS MSK clusters.
* `Aws\Macie2` - The Amazon Macie API now provides S3 bucket metadata that indicates whether any one-time or recurring classification jobs are configured to analyze data in a bucket.
* `Aws\S3` - Add new documentation regarding automatically generated Content-MD5 headers when using the SDK or CLI.

## 3.163.1 - 2020-11-19

* `Aws\AutoScaling` - You can now create Auto Scaling groups with multiple launch templates using a mixed instances policy, making it easy to deploy an AMI with an architecture that is different from the rest of the group.
* `Aws\CloudWatchEvents` - EventBridge now supports Resource-based policy authorization on event buses. This enables cross-account PutEvents API calls, creating cross-account rules, and simplifies permission management.
* `Aws\CostExplorer` - Additional metadata that may be applicable to the recommendation.
* `Aws\DirectoryService` - Adding multi-region replication feature for AWS Managed Microsoft AD
* `Aws\EventBridge` - EventBridge now supports Resource-based policy authorization on event buses. This enables cross-account PutEvents API calls, creating cross-account rules, and simplifies permission management.
* `Aws\Glue` - Adding support for Glue Schema Registry. The AWS Glue Schema Registry is a new feature that allows you to centrally discover, control, and evolve data stream schemas.
* `Aws\KinesisAnalyticsV2` - Amazon Kinesis Data Analytics now supports building and running streaming applications using Apache Flink 1.11 and provides a way to access the Apache Flink dashboard for supported Flink versions.
* `Aws\Lambda` - Added the starting position and starting position timestamp to ESM Configuration. Now customers will be able to view these fields for their ESM.
* `Aws\LexModelBuildingService` - Amazon Lex supports managing input and output contexts as well as default values for slots.
* `Aws\LexRuntimeService` - Amazon Lex now supports the ability to view and manage active contexts associated with a user session.
* `Aws\MediaLive` - The AWS Elemental MediaLive APIs and SDKs now support the ability to see the software update status on Link devices
* `Aws\Redshift` - Amazon Redshift support for returning ClusterNamespaceArn in describeClusters

## 3.163.0 - 2020-11-18

* `Aws\Backup` - AWS Backup now supports cross-account backup, enabling AWS customers to securely copy their backups across their AWS accounts within their AWS organizations.
* `Aws\CloudFormation` - This release adds ChangeSets support for Nested Stacks. ChangeSets offer a preview of how proposed changes to a stack might impact existing resources or create new ones.
* `Aws\CodeBuild` - AWS CodeBuild - Adding Status field for Report Group
* `Aws\Credentials` - Implements the AWS_SHARED_CREDENTIALS_FILE environment variable for specifying a file to retrieve credentials from
* `Aws\EC2` - EC2 Fleet adds support of DeleteFleets API for instant type fleets. Now you can delete an instant type fleet and terminate all associated instances with a single API call.
* `Aws\ElastiCache` - Adding Memcached 1.6 to parameter family
* `Aws\Outposts` - Mark the Name parameter in CreateOutpost as required.
* `Aws\S3Control` - AWS S3 Storage Lens provides visibility into your storage usage and activity trends at the organization or account level, with aggregations by Region, storage class, bucket, and prefix.

## 3.162.0 - 2020-11-17

* `Aws\Chime` - This release adds CRUD APIs for Amazon Chime SipMediaApplications and SipRules. It also adds the API for creating outbound PSTN calls for Amazon Chime meetings.
* `Aws\Connect` - This release adds support for user hierarchy group and user hierarchy structure. For details, see the Release Notes in the Amazon Connect Administrator Guide.
* `Aws\FMS` - Added Firewall Manager policy support for AWS Network Firewall resources.
* `Aws\Macie2` - The Amazon Macie API now has a lastRunErrorStatus property to indicate if account- or bucket-level errors occurred during the run of a one-time classification job or the latest run of a recurring job.
* `Aws\NetworkFirewall` - (New Service) AWS Network Firewall is a managed network layer firewall service that makes it easy to secure your virtual private cloud (VPC) networks and block malicious traffic.
* `Aws\RDS` - Support copy-db-snapshot in the one region on cross clusters and local cluster for RDSonVmware. Add target-custom-availability-zone parameter to specify where a snapshot should be copied.

## 3.161.2 - 2020-11-16

* `Aws\CodePipeline` - We show details about inbound executions and id of action executions in GetPipelineState API. We also add ConflictException to StartPipelineExecution, RetryStageExecution, StopPipelineExecution APIs.
* `Aws\DatabaseMigrationService` - Adding MoveReplicationTask feature to move replication tasks between instances
* `Aws\IoTSecureTunneling` - Support using multiple data streams per tunnel using the Secure Tunneling multiplexing feature.
* `Aws\IoTSiteWise` - This release supports Unicode characters for string operations in formulae computes in SiteWise. For more information, search for SiteWise in Amazon What's new or refer the SiteWise documentation.
* `Aws\QuickSight` - Adding new parameters for dashboard persistence
* `Aws\SNS` - Documentation updates for Amazon SNS.
* `Aws\SageMaker` - This feature enables customers to encrypt their Amazon SageMaker Studio storage volumes with customer master keys (CMKs) managed by them in AWS Key Management Service (KMS).
* `Aws\ServiceCatalog` - Support import of CloudFormation stacks into Service Catalog provisioned products.
* `Aws\Synthetics` - AWS Synthetics now supports Environment Variables to assign runtime parameters in the canary scripts.

## 3.161.1 - 2020-11-13

* `Aws\ElasticLoadBalancingv2` - Adds dualstack support for Network Load Balancers (TCP/TLS only), an attribute for WAF fail open for Application Load Balancers, and an attribute for connection draining for Network Load Balancers.
* `Aws\Shield` - This release adds APIs for two new features: 1) Allow customers to bundle resources into protection groups and treat as a single unit. 2) Provide per-account event summaries to all AWS customers.
* `Aws\Textract` - AWS Textract now allows customers to specify their own KMS key to be used for asynchronous jobs output results, AWS Textract now also recognizes handwritten text from English documents.

## 3.161.0 - 2020-11-12

* `Aws\AppRegistry` - AWS Service Catalog AppRegistry provides a repository of your applications, their resources, and the application metadata that you use within your enterprise.
* `Aws\IoT` - This release adds a batchMode parameter to the IotEvents, IotAnalytics, and Firehose actions which allows customers to send an array of messages to the corresponding services
* `Aws\LexModelBuildingService` - Lex now supports es-ES, it-IT, fr-FR and fr-CA locales
* `Aws\Lightsail` - This release adds support for Amazon Lightsail container services. You can now create a Lightsail container service, and deploy Docker images to it.
* `Aws\PersonalizeRuntime` - Adds support to use dynamic filters with Personalize.
* `Aws\Polly` - Amazon Polly adds new Australian English female voice - Olivia. Olivia is available as Neural voice only.
* `Aws\RoboMaker` - This release introduces Robomaker Worldforge TagsOnCreate which allows customers to tag worlds as they are being generated by providing the tags while configuring a world generation job.

## 3.160.0 - 2020-11-11

* `Aws\Amplify` - Whereas previously custom headers were set via the app's buildspec, custom headers can now be set directly on the Amplify app for both ci/cd and manual deploy apps.
* `Aws\ForecastService` - Providing support of custom quantiles in CreatePredictor API.
* `Aws\GlueDataBrew` - This is the initial SDK release for AWS Glue DataBrew. DataBrew is a visual data preparation tool that enables users to clean and normalize data without writing any code.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for Automated ABR encoding and improved the reliability of embedded captions in accelerated outputs.
* `Aws\QuickSight` - QuickSight now supports Column-level security and connecting to Oracle data source.
* `Aws\ServiceCatalog` - Adding support to remove a Provisioned Product launch role via UpdateProvisionedProductProperties

## 3.159.1 - 2020-11-10

* `Aws\AutoScaling` - Documentation updates and corrections for Amazon EC2 Auto Scaling API Reference and SDKs.
* `Aws\EC2` - This release adds support for Gateway Load Balancer VPC endpoints and VPC endpoint services
* `Aws\ElasticLoadBalancingv2` - Added support for Gateway Load Balancers, which make it easy to deploy, scale, and run third-party virtual networking appliances.
* `Aws\SSM` - Add SessionId as a filter for DescribeSessions API

## 3.159.0 - 2020-11-09

* `Aws\` - Removes sensitive data from debug logs
* `Aws\DataSync` - DataSync now enables customers to adjust the network bandwidth used by a running AWS DataSync task.
* `Aws\DynamoDB` - This release adds supports for exporting Amazon DynamoDB table data to Amazon S3 to perform analytics at any scale.
* `Aws\ECS` - This release provides native support for specifying Amazon FSx for Windows File Server file systems as volumes in your Amazon ECS task definitions.
* `Aws\ElasticsearchService` - Adding support for package versioning in Amazon Elasticsearch Service
* `Aws\FSx` - This release adds support for creating DNS aliases for Amazon FSx for Windows File Server, and using AWS Backup to automate scheduled, policy-driven backup plans for Amazon FSx file systems.
* `Aws\IoTAnalytics` - AWS IoT Analytics now supports Late Data Notifications for datasets, dataset content creation using previous version IDs, and includes the LastMessageArrivalTime attribute for channels and datastores.
* `Aws\Macie2` - Sensitive data findings in Amazon Macie now include enhanced location data for Apache Avro object containers and Apache Parquet files.
* `Aws\S3` - S3 Intelligent-Tiering adds support for Archive and Deep Archive Access tiers; S3 Replication adds replication metrics and failure notifications, brings feature parity for delete marker replication
* `Aws\SSM` - add a new filter to allow customer to filter automation executions by using resource-group which used for execute automation
* `Aws\StorageGateway` - Added bandwidth rate limit schedule for Tape and Volume Gateways

## 3.158.22 - 2020-11-06

* `Aws\DLM` - Amazon Data Lifecycle Manager now supports the creation and retention of EBS-backed Amazon Machine Images
* `Aws\EC2` - Network card support with four new attributes: NetworkCardIndex, NetworkPerformance, DefaultNetworkCardIndex, and MaximumNetworkInterfaces, added to the DescribeInstanceTypes API.
* `Aws\IoTSiteWise` - Remove the CreatePresignedPortalUrl API
* `Aws\MediaLive` - Support for SCTE35 ad markers in OnCuePoint style in RTMP outputs.
* `Aws\SSM` - Documentation updates for Systems Manager

## 3.158.21 - 2020-11-05

* `Aws\AppMesh` - This release adds circuit breaking capabilities to your mesh with connection pooling and outlier detection support.
* `Aws\CloudWatchEvents` - With this release, customers can now reprocess past events by storing the events published on event bus in an encrypted archive.
* `Aws\DynamoDB` - This release adds a new ReplicaStatus INACCESSIBLE_ENCRYPTION_CREDENTIALS for the Table description, indicating when a key used to encrypt a regional replica table is not accessible.
* `Aws\EC2` - Documentation updates for EC2.
* `Aws\ElasticsearchService` - Amazon Elasticsearch Service now provides the ability to define a custom endpoint for your domain and link an SSL certificate from ACM, making it easier to refer to Kibana and the domain endpoint.
* `Aws\EventBridge` - With this release, customers can now reprocess past events by storing the events published on event bus in an encrypted archive.
* `Aws\FraudDetector` - Added support for deleting resources like Variables, ExternalModels, Outcomes, Models, ModelVersions, Labels, EventTypes and EntityTypes. Updated DeleteEvent operation to catch missing exceptions.
* `Aws\Lambda` - Support Amazon MQ as an Event Source.
* `Aws\RDS` - Supports a new parameter to set the max allocated storage in gigabytes for the CreateDBInstanceReadReplica API.
* `Aws\kendra` - Amazon Kendra now supports providing user context in your query requests, Tokens can be JSON or JWT format. This release also introduces support for Confluence cloud datasources.

## 3.158.20 - 2020-11-04

* `Aws\AutoScaling` - Capacity Rebalance helps you manage and maintain workload availability during Spot interruptions by proactively augmenting your Auto Scaling group with a new instance before interrupting an old one.
* `Aws\CloudWatch` - Documentation updates for monitoring
* `Aws\EC2` - Added support for Client Connect Handler for AWS Client VPN. Fleet supports launching replacement instances in response to Capacity Rebalance recommendation.
* `Aws\ElasticsearchService` - Amazon Elasticsearch Service now supports native SAML authentication that seamlessly integrates with the customers' existing SAML 2.0 Identity Provider (IdP).
* `Aws\IoT` - Updated API documentation and added paginator for AWS Iot Registry ListThingPrincipals API.
* `Aws\MQ` - Amazon MQ introduces support for RabbitMQ, a popular message-broker with native support for AMQP 0.9.1. You can now create fully-managed RabbitMQ brokers in the cloud.
* `Aws\MarketplaceMetering` - Adding Vendor Tagging Support in MeterUsage and BatchMeterUsage API.
* `Aws\ServiceCatalog` - Service Catalog API ListPortfolioAccess can now support a maximum PageSize of 100.
* `Aws\TranscribeStreamingService` - With this release, Amazon Transcribe now supports real-time transcription from audio sources in Italian (it-IT) and German(de-DE).
* `Aws\XRay` - Releasing new APIs GetInsightSummaries, GetInsightEvents, GetInsight, GetInsightImpactGraph and updating GetTimeSeriesServiceStatistics API for AWS X-Ray Insights feature

## 3.158.19 - 2020-11-02

* `Aws\EC2` - This release adds support for the following features: 1. P4d instances based on NVIDIA A100 GPUs. 2. NetworkCardIndex attribute to support multiple network cards.

## 3.158.18 - 2020-10-30

* `Aws\Braket` - This release supports tagging for Amazon Braket quantum-task resources. It also supports tag-based access control for quantum-task APIs.
* `Aws\DatabaseMigrationService` - Adding DocDbSettings to support DocumentDB as a source.
* `Aws\ElastiCache` - Documentation updates for AWS ElastiCache
* `Aws\Macie2` - This release of the Amazon Macie API adds an eqExactMatch operator for filtering findings. With this operator you can increase the precision of your finding filters and suppression rules.
* `Aws\MediaLive` - Support for HLS discontinuity tags in the child manifests. Support for incomplete segment behavior in the media output. Support for automatic input failover condition settings.
* `Aws\SNS` - Documentation updates for Amazon SNS
* `Aws\imagebuilder` - This feature increases the number of accounts that can be added to the Launch permissions within an Image Builder Distribution configuration.

## 3.158.17 - 2020-10-29

* `Aws\APIGateway` - Support disabling the default execute-api endpoint for REST APIs.
* `Aws\CodeArtifact` - Add support for tagging of CodeArtifact domain and repository resources.
* `Aws\EC2` - Support for Appliance mode on Transit Gateway that simplifies deployment of stateful network appliances. Added support for AWS Client VPN Self-Service Portal.
* `Aws\ElasticLoadBalancingv2` - Application Load Balancer (ALB) now supports the gRPC protocol-version. With this release, customers can use ALB to route and load balance gRPC traffic between gRPC enabled clients and microservices.
* `Aws\MarketplaceCommerceAnalytics` - Documentation updates for marketplacecommerceanalytics to specify four data sets which are deprecated.
* `Aws\SesV2` - This release enables customers to manage their own contact lists and end-user subscription preferences.
* `Aws\StorageGateway` - Adding support for access based enumeration on SMB file shares, file share visibility on SMB file shares, and file upload notifications for all file shares

## 3.158.16 - 2020-10-28

* `Aws\EC2` - AWS Nitro Enclaves general availability. Added support to RunInstances for creating enclave-enabled EC2 instances. New APIs to associate an ACM certificate with an IAM role, for enclave consumption.
* `Aws\IoT` - This release adds support for GG-Managed Job Namespace
* `Aws\WorkMail` - Documentation update for Amazon WorkMail

## 3.158.15 - 2020-10-27

* `Aws\Glue` - AWS Glue machine learning transforms now support encryption-at-rest for labels and trained models.
* `Aws\S3` - Added validation that required S3 parameters are non empty

## 3.158.14 - 2020-10-26

* `Aws\Neptune` - This feature enables custom endpoints for Amazon Neptune clusters. Custom endpoints simplify connection management when clusters contain instances with different capacities and configuration settings.
* `Aws\SageMaker` - This release enables customers to bring custom images for use with SageMaker Studio notebooks.
* `Aws\kendra` - Amazon Kendra now supports indexing data from Confluence Server.

## 3.158.13 - 2020-10-23

* `Aws\Macie2` - This release of the Amazon Macie API includes miscellaneous updates and improvements to the documentation.
* `Aws\MediaTailor` - MediaTailor now supports ad marker passthrough for HLS. Use AdMarkerPassthrough to pass EXT-X-CUE-IN, EXT-X-CUE-OUT, and EXT-X-SPLICEPOINT-SCTE35 from origin manifests into personalized manifests.
* `Aws\QuickSight` - Support description on columns.

## 3.158.12 - 2020-10-22

* `Aws\AccessAnalyzer` - API Documentation updates for IAM Access Analyzer.
* `Aws\Appflow` - Salesforce connector creation with customer provided client id and client secret, incremental pull configuration, salesforce upsert write operations and execution ID when on-demand flows are executed.
* `Aws\SNS` - SNS now supports a new class of topics: FIFO (First-In-First-Out). FIFO topics provide strictly-ordered, deduplicated, filterable, encryptable, many-to-many messaging at scale.
* `Aws\ServiceCatalog` - Documentation updates for servicecatalog

## 3.158.11 - 2020-10-21

* `Aws\CloudFront` - CloudFront adds support for managing the public keys for signed URLs and signed cookies directly in CloudFront (it no longer requires the AWS root account).
* `Aws\EC2` - instance-storage-info nvmeSupport added to DescribeInstanceTypes API
* `Aws\GlobalAccelerator` - This release adds support for specifying port overrides on AWS Global Accelerator endpoint groups.
* `Aws\Glue` - AWS Glue crawlers now support incremental crawls for the Amazon Simple Storage Service (Amazon S3) data source.
* `Aws\Organizations` - AWS Organizations renamed the 'master account' to 'management account'.
* `Aws\kendra` - This release adds custom data sources: a new data source type that gives you full control of the documents added, modified or deleted during a data source sync while providing run history metrics.

## 3.158.10 - 2020-10-20

* `Aws\AppSync` - Documentation updates to AppSync to correct several typos.
* `Aws\Batch` - Adding evaluateOnExit to job retry strategies.
* `Aws\ElasticBeanstalk` - EnvironmentStatus enum update to include Aborting, LinkingFrom and LinkingTo

## 3.158.9 - 2020-10-19

* `Aws\` - Fixed issue with polyfill referencing to wrong IDN folder structure in generated zip file
* `Aws\Backup` - Documentation updates for Cryo
* `Aws\CloudFront` - Amazon CloudFront adds support for Origin Shield.
* `Aws\Credentials` - Suppressed a file access warning in AssumeRoleWithWebIdentityCredentialProvider
* `Aws\DocDB` - Documentation updates for docdb
* `Aws\SSM` - This Patch Manager release now supports Common Vulnerabilities and Exposure (CVE) Ids for missing packages via the DescribeInstancePatches API.
* `Aws\ServiceCatalog` - An Admin can now update the launch role associated with a Provisioned Product. Admins and End Users can now view the launch role associated with a Provisioned Product.

## 3.158.8 - 2020-10-16

* `Aws\MediaLive` - The AWS Elemental MediaLive APIs and SDKs now support the ability to transfer the ownership of MediaLive Link devices across AWS accounts.
* `Aws\Organizations` - Documentation updates for AWS Organizations.

## 3.158.7 - 2020-10-15

* `Aws\AccessAnalyzer` - This release adds support for the ApplyArchiveRule api in IAM Access Analyzer. The ApplyArchiveRule api allows users to apply an archive rule retroactively to existing findings in an analyzer.
* `Aws\Budgets` - This release introduces AWS Budgets Actions, allowing you to define an explicit response(or set of responses) to take when your budget exceeds it's action threshold.
* `Aws\CostExplorer` - This release improves email validation for subscriptions on the SDK endpoints.
* `Aws\DatabaseMigrationService` - When creating Endpoints, Replication Instances, and Replication Tasks, the feature provides you the option to specify friendly name to the resources.
* `Aws\Glue` - API Documentation updates for Glue Get-Plan API
* `Aws\GroundStation` - Adds error message attribute to DescribeContact DataflowDetails
* `Aws\IoT` - Add new variable, lastStatusChangeDate, to DescribeDomainConfiguration API
* `Aws\Macie2` - This release of the Amazon Macie API adds support for pausing and resuming classification jobs. Also, sensitive data findings now include location data for up to 15 occurrences of sensitive data.
* `Aws\RDS` - Return tags for all resources in the output of DescribeDBInstances, DescribeDBSnapshots, DescribeDBClusters, and DescribeDBClusterSnapshots API operations.
* `Aws\Rekognition` - This SDK Release introduces new API (DetectProtectiveEquipment) for Amazon Rekognition. This release also adds ServiceQuotaExceeded exception to Amazon Rekognition IndexFaces API.
* `Aws\SSM` - This Patch Manager release now supports searching for available packages from Amazon Linux and Amazon Linux 2 via the DescribeAvailablePatches API.
* `Aws\Transfer` - Add support to associate VPC Security Groups at server creation.
* `Aws\WorkMail` - Add CreateOrganization and DeleteOrganization API operations.
* `Aws\WorkSpaces` - Documentation updates for WorkSpaces
* `Aws\XRay` - Enhancing CreateGroup, UpdateGroup, GetGroup and GetGroups APIs to support configuring X-Ray Insights Notifications. Adding TraceLimit information into X-Ray BatchGetTraces API response.

## 3.158.6 - 2020-10-09

* `Aws\Amplify` - Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval - enabling can make code changes can take up to 10 minutes to roll out.
* `Aws\EKS` - This release introduces a new Amazon EKS error code: "ClusterUnreachable"
* `Aws\MediaLive` - WAV audio output. Extracting ancillary captions in MP4 file inputs. Priority on channels feeding a multiplex (higher priority channels will tend to have higher video quality).
* `Aws\ServiceCatalog` - This new API takes either a ProvisonedProductId or a ProvisionedProductName, along with a list of 1 or more output keys and responds with the (key,value) pairs of those outputs.
* `Aws\Snowball` - We added new APIs to allow customers to better manage their device shipping. You can check if your shipping label expired, generate a new label, and tell us that you received or shipped your job.

## 3.158.5 - 2020-10-08

* `Aws\CloudWatchEvents` - Amazon EventBridge (formerly called CloudWatch Events) adds support for target Dead-letter Queues and custom retry policies.
* `Aws\CostExplorer` - You can now create hierarchical cost categories by choosing "Cost Category" as a dimension. You can also track the status of your cost category updates to your cost and usage information.
* `Aws\Credentials` - Fixes an issue involving outdated exceptions in Guzzle 7 with the InstanceProfileProvider workflow.
* `Aws\EC2` - AWS EC2 RevokeSecurityGroupIngress and RevokeSecurityGroupEgress APIs will return IpPermissions which do not match with any existing IpPermissions for security groups in default VPC and EC2-Classic.
* `Aws\EventBridge` - Amazon EventBridge adds support for target Dead Letter Queues (DLQs) and custom retry policies.
* `Aws\RDS` - Supports a new parameter to set the max allocated storage in gigabytes for restore database instance from S3 and restore database instance to a point in time APIs.
* `Aws\Rekognition` - This release provides location information for the manifest validation files.
* `Aws\SNS` - Documentation updates for SNS.
* `Aws\SageMaker` - This release enables Sagemaker customers to convert Tensorflow and PyTorch models to CoreML (ML Model) format.

## 3.158.4 - 2020-10-07

* `Aws\ComputeOptimizer` - This release enables AWS Compute Optimizer to analyze EC2 instance-level EBS read and write operations, and throughput when generating recommendations for your EC2 instances and Auto Scaling groups.
* `Aws\CostExplorer` - Enables Rightsizing Recommendations to analyze and present EC2 instance-level EBS metrics when generating recommendations. Returns AccessDeniedException if the account is not opted into Rightsizing
* `Aws\ElastiCache` - This release introduces User and UserGroup to allow customers to have access control list of the Redis resources for AWS ElastiCache. This release also adds support for Outposts for AWS ElastiCache.
* `Aws\MediaPackage` - AWS Elemental MediaPackage provides access logs that capture detailed information about requests sent to a customer's MediaPackage channel.

## 3.158.3 - 2020-10-06

* `Aws\DatabaseMigrationService` - Added new S3 endpoint settings to allow partitioning CDC data by date for S3 as target. Exposed some Extra Connection Attributes as endpoint settings for relational databases as target.
* `Aws\EC2` - This release supports returning additional information about local gateway virtual interfaces, and virtual interface groups.
* `Aws\KinesisAnalyticsV2` - Amazon Kinesis Analytics now supports StopApplication with 'force' option
* `Aws\MarketplaceCatalog` - AWS Marketplace Catalog now supports FailureCode for change workflows to help differentiate client errors and server faults.

## 3.158.2 - 2020-10-05

* `Aws\Credentials` - Added circular reference check on assume_role
* `Aws\DynamoDB` - This release adds a new ReplicaStatus REGION DISABLED for the Table description. This state indicates that the AWS Region for the replica is inaccessible because the AWS Region is disabled.
* `Aws\DynamoDBStreams` - Documentation updates for streams.dynamodb
* `Aws\Glue` - AWS Glue crawlers now support Amazon DocumentDB (with MongoDB compatibility) and MongoDB collections. You can choose to crawl the entire data set or only a small sample to reduce crawl time.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for AVC-I and VC3 encoding in the MXF OP1a container, Nielsen non-linear watermarking, and InSync FrameFormer frame rate conversion.
* `Aws\SageMaker` - This release adds support for launching Amazon SageMaker Studio in your VPC. Use AppNetworkAccessType in CreateDomain API to disable access to public internet and restrict the network traffic to VPC.

## 3.158.1 - 2020-10-02

* `Aws\Batch` - Support tagging for Batch resources (compute environment, job queue, job definition and job) and tag based access control on Batch APIs
* `Aws\Credentials` - Throws a more informative error when trying to read SSO from non existing profile
* `Aws\ElasticLoadBalancingv2` - This release adds support for tagging listeners, rules, and target groups on creation. This release also supported tagging operations through tagging api's for listeners and rules.
* `Aws\PersonalizeEvents` - Adds new APIs to write item and user records to Datasets.
* `Aws\RDS` - Adds the NCHAR Character Set ID parameter to the CreateDbInstance API for RDS Oracle.
* `Aws\S3` - Amazon S3 Object Ownership is a new S3 feature that enables bucket owners to automatically assume ownership of objects that are uploaded to their buckets by other AWS Accounts.
* `Aws\ServiceDiscovery` - Added support for optional parameters for DiscoverInstances API in AWS Cloud Map

## 3.158.0 - 2020-10-01

* `Aws\AppSync` - Exposes the wafWebAclArn field on GraphQL api records. The wafWebAclArn field contains the amazon resource name of a WAF Web ACL if the AWS AppSync API is associated with one.
* `Aws\EMR` - Documentation updates for elasticmapreduce
* `Aws\Glue` - Adding additional optional map parameter to get-plan api
* `Aws\Kafka` - Added support for Enabling Zookeeper Encryption in Transit for AWS MSK.
* `Aws\QuickSight` - QuickSight now supports connecting to AWS Timestream data source
* `Aws\S3` - Adds support to S3 and S3 Control clients for managing resources stored on S3 Outposts via Outposts-specific ARNs and endpoints.
* `Aws\WAFV2` - AWS WAF is now available for AWS AppSync GraphQL APIs. AWS WAF protects against malicious attacks with AWS Managed Rules or your own custom rules. For more information see the AWS WAF Developer Guide.

## 3.157.0 - 2020-09-30

* `Aws\ApplicationAutoScaling` - This release extends Auto Scaling support for cluster storage of Managed Streaming for Kafka. Auto Scaling monitors and automatically expands storage capacity when a critical usage threshold is met.
* `Aws\Credentials` - Fix credentialprovider error with undefined index source_profile when using credential_source
* `Aws\DataSync` - This release enables customers to create s3 location for S3 bucket's located on an AWS Outpost.
* `Aws\DirectConnect` - Documentation updates for AWS Direct Connect.
* `Aws\EMR` - Amazon EMR customers can now use EC2 placement group to influence the placement of master nodes in a high-availability (HA) cluster across distinct underlying hardware to improve cluster availability.
* `Aws\IoT` - AWS IoT Rules Engine adds Timestream action. The Timestream rule action lets you stream time-series data from IoT sensors and applications to Amazon Timestream databases for time series analysis.
* `Aws\MediaConnect` - MediaConnect now supports reservations to provide a discounted rate for a specific outbound bandwidth over a period of time.
* `Aws\Pinpoint` - Amazon Pinpoint - Features - Customers can start a journey based on an event being triggered by an endpoint or user.
* `Aws\S3` - Amazon S3 on Outposts expands object storage to on-premises AWS Outposts environments, enabling you to store and retrieve objects using S3 APIs and features.
* `Aws\S3Control` - Amazon S3 on Outposts expands object storage to on-premises AWS Outposts environments, enabling you to store and retrieve objects using S3 APIs and features.
* `Aws\S3Outposts` - Amazon S3 on Outposts expands object storage to on-premises AWS Outposts environments, enabling you to store and retrieve objects using S3 APIs and features.
* `Aws\SecurityHub` - Added several new resource details objects. Added additional details for CloudFront distributions, IAM roles, and IAM access keys. Added a new ResourceRole attribute for resources.
* `Aws\imagebuilder` - EC2 Image Builder adds support for copying AMIs created by Image Builder to accounts specific to each Region.

## 3.156.0 - 2020-09-29

* `Aws\Connect` - Update TagResource API documentation to include Contact Flows and Routing Profiles as supported resources.
* `Aws\EC2` - This release adds support for Client to Client routing for AWS Client VPN.
* `Aws\SSM` - Simple update to description of ComplianceItemStatus.
* `Aws\Schemas` - Added support for schemas of type JSONSchemaDraft4. Added ExportSchema API that converts schemas in AWS Events registry and Discovered schemas from OpenApi3 to JSONSchemaDraft4.
* `Aws\TimestreamQuery` - (New Service) Amazon Timestream is a fast, scalable, fully managed, purpose-built time series database that makes it easy to store and analyze trillions of time series data points per day.
* `Aws\TimestreamWrite` - (New Service) Amazon Timestream is a fast, scalable, fully managed, purpose-built time series database that makes it easy to store and analyze trillions of time series data points per day.

## 3.155.4 - 2020-09-28

* `Aws\ApplicationAutoScaling` - This release extends Application Auto Scaling support to AWS Comprehend Entity Recognizer endpoint, allowing automatic updates to provisioned Inference Units to maintain targeted utilization level.
* `Aws\RDS` - This release adds the InsufficientAvailableIPsInSubnetFault error for RDS Proxy.
* `Aws\S3` - Corrected urlencoding of CopySource key for MultipartCopy

## 3.155.3 - 2020-09-25

* `Aws\Batch` - Support custom logging, executionRole, secrets, and linuxParameters (initProcessEnabled, maxSwap, swappiness, sharedMemorySize, and tmpfs). Also, add new context keys for awslogs.
* `Aws\ConfigService` - Make the delivery-s3-bucket as an optional parameter for conformance packs and organizational conformance packs
* `Aws\DocDB` - Documentation updates for docdb
* `Aws\EC2` - This release supports returning additional information about local gateway resources, such as the local gateway route table.
* `Aws\FraudDetector` - Increased maximum length of eventVariables values for GetEventPrediction from 256 to 1024.
* `Aws\STS` - Documentation update for AssumeRole error

## 3.155.2 - 2020-09-24

* `Aws\Amplify` - Allow Oauth Token in CreateApp call to be a maximum of 1000 characters instead of 100
* `Aws\EKS` - Amazon EKS now supports configuring your cluster's service CIDR during cluster creation.
* `Aws\SavingsPlans` - Introducing Queued SavingsPlans that will enable customers to queue their purchase request of Savings Plans for future dates.
* `Aws\Synthetics` - AWS Synthetics now supports AWS X-Ray Active Tracing feature. RunConfig is now an optional parameter with timeout updated from (60 - 900 seconds) to (3 - 840 seconds).
* `Aws\Textract` - AWS Textract now supports output results for asynchronous jobs to customer specified s3 bucket.
* `Aws\TranscribeService` - Amazon Transcribe now supports WebM, OGG, AMR and AMR-WB as input formats. You can also specify an output key as a location within your S3 buckets to store the output of your transcription jobs.

## 3.155.1 - 2020-09-23

* `Aws\Backup` - This release allows customers to enable or disable advanced backup settings in backup plan. As part of this feature AWS Backup added support for Windows VSS backup option for EC2 resources.
* `Aws\CostExplorer` - This release provides access to Cost Anomaly Detection Public Preview APIs. Cost Anomaly Detection finds cost anomalies based on your historical cost and usage using Machine Learning models.
* `Aws\QuickSight` - Added Sheet information to DescribeDashboard, DescribeTemplate and DescribeAnalysis API response.
* `Aws\Translate` - Improvements to DeleteTerminology API.

## 3.155.0 - 2020-09-22

* `Aws\Comprehend` - Amazon Comprehend integrates with Amazon SageMaker GroundTruth to allow its customers to annotate their datasets using GroundTruth and train their models using Comprehend Custom APIs.
* `Aws\Credentials` - Added credential provider which retrieves cached SSO credentials from the CLI
* `Aws\Credentials` - Fixes a crash in PHP 8.0 by calling array_values on the default chain array passed into self::chain
* `Aws\DynamoDBStreams` - Documentation updates for streams.dynamodb
* `Aws\LexModelBuildingService` - Lex now supports es-US locales
* `Aws\WorkMail` - Adding support for Mailbox Export APIs

## 3.154.7 - 2020-09-21

* `Aws\CloudWatchEvents` - Add support for Redshift Data API Targets
* `Aws\EventBridge` - Add support for Redshift Data API Targets
* `Aws\Glue` - Adding support to update multiple partitions of a table in a single request
* `Aws\IoTSiteWise` - This release supports IAM mode for SiteWise Monitor portals
* `Aws\RDS` - Documentation updates for the RDS DescribeExportTasks API
* `Aws\ResourceGroups` - Documentation updates and corrections for Resource Groups API Reference and SDKs.
* `Aws\ResourceGroupsTaggingAPI` - Documentation updates for the Resource Groups Tagging API.

## 3.154.6 - 2020-09-18

* `Aws\CodeStarconnections` - New integration with the GitHub provider type.
* `Aws\MediaLive` - AWS Elemental MediaLive now supports batch operations, which allow users to start, stop, and delete multiple MediaLive resources with a single request.
* `Aws\SSOAdmin` - Documentation updates for AWS SSO APIs.

## 3.154.5 - 2020-09-17

* `Aws\APIGateway` - Adds support for mutual TLS authentication for public regional REST Apis
* `Aws\ApiGatewayV2` - Adds support for mutual TLS authentication and disableAPIExecuteEndpoint for public regional HTTP Apis
* `Aws\CloudFront` - Documentation updates for CloudFront
* `Aws\Comprehend` - Amazon Comprehend now supports detecting Personally Identifiable Information (PII) entities in a document.
* `Aws\ElasticsearchService` - Adds support for data plane audit logging in Amazon Elasticsearch Service.
* `Aws\TranscribeStreamingService` - Amazon Transcribe now supports channel identification in real-time streaming, which enables you to transcribe multi-channel streaming audio.
* `Aws\kendra` - Amazon Kendra now supports additional file formats and metadata for FAQs.

## 3.154.4 - 2020-09-16

* `Aws\Connect` - This release adds support for contact flows and routing profiles. For details, see the Release Notes in the Amazon Connect Administrator Guide.
* `Aws\DLM` - Customers can now provide multiple schedules within a single Data Lifecycle Manager (DLM) policy. Each schedule supports tagging, Fast Snapshot Restore (FSR) and cross region copy individually.
* `Aws\Greengrass` - This release includes the ability to set run-time configuration for a Greengrass core. The Telemetry feature, also included in this release, can be configured via run-time configuration per core.
* `Aws\SSM` - The ComplianceItemEntry Status description was updated to address Windows patches that aren't applicable.
* `Aws\ServiceCatalog` - Enhance DescribeProvisionedProduct API to allow useProvisionedProduct Name as Input, so customer can provide ProvisionedProduct Name instead of ProvisionedProduct Id to describe a ProvisionedProduct.

## 3.154.3 - 2020-09-15

* `Aws\Budgets` - Documentation updates for Daily Cost and Usage budgets
* `Aws\EC2` - T4g instances are powered by AWS Graviton2 processors
* `Aws\Kafka` - Added new API's to support SASL SCRAM Authentication with MSK Clusters.
* `Aws\MediaLive` - AWS Elemental MediaLive now supports CDI (Cloud Digital Interface) inputs which enable uncompressed video from applications on Elastic Cloud Compute (EC2), AWS Media Services, and from AWS partners
* `Aws\Organizations` - AWS Organizations now enables you to add tags to the AWS accounts, organizational units, organization root, and policies in your organization.
* `Aws\SageMaker` - Sagemaker Ground Truth: Added support for a new Streaming feature which helps to continuously feed data and receive labels in real time. This release adds a new input and output SNS data channel.
* `Aws\TranscribeService` - Amazon Transcribe now supports automatic language identification, which enables you to transcribe audio files without needing to know the language in advance.
* `Aws\kendra` - Amazon Kendra now returns confidence scores for 'document' query responses.

## 3.154.2 - 2020-09-14

* `Aws\DocDB` - Updated API documentation and added paginators for DescribeCertificates, DescribeDBClusterParameterGroups, DescribeDBClusterParameters, DescribeDBClusterSnapshots and DescribePendingMaintenanceActions
* `Aws\EC2` - This release adds support for the T4G instance family to the EC2 ModifyDefaultCreditSpecification and GetDefaultCreditSpecification APIs.
* `Aws\ManagedBlockchain` - Introducing support for Hyperledger Fabric 1.4. When using framework version 1.4, the state database may optionally be specified when creating peer nodes (defaults to CouchDB).
* `Aws\SFN` - This release of the AWS Step Functions SDK introduces support for AWS X-Ray.
* `Aws\Test` - Tweaks test for PartitionEndpointProvider to accomodate changed S3 endpoint.

## 3.154.1 - 2020-09-11

* `Aws\WorkSpaces` - Adds API support for WorkSpaces Cross-Region Redirection feature.

## 3.154.0 - 2020-09-10

* `Aws\CloudFront` - Cloudfront adds support for Brotli. You can enable brotli caching and compression support by enabling it in your Cache Policy.
* `Aws\EBS` - Documentation updates for Amazon EBS direct APIs.
* `Aws\Pinpoint` - Update SMS message model description to clearly indicate that the MediaUrl field is reserved for future use and is not supported by Pinpoint as of today.
* `Aws\S3` - Bucket owner verification feature added. This feature introduces the x-amz-expected-bucket-owner and x-amz-source-expected-bucket-owner headers.
* `Aws\SSOAdmin` - This is an initial release of AWS Single Sign-On (SSO) Access Management APIs. This release adds support for SSO operations which could be used for managing access to AWS accounts.

## 3.153.0 - 2020-09-09

* `Aws\Glue` - Adding support for partitionIndexes to improve GetPartitions performance.
* `Aws\KinesisAnalyticsV2` - Kinesis Data Analytics is adding new AUTOSCALING application status for applications during auto scaling and also adding FlinkRunConfigurationDescription in the ApplicationDetails.
* `Aws\RedshiftDataAPIService` - The Amazon Redshift Data API is generally available. This release enables querying Amazon Redshift data and listing various database objects.

## 3.152.1 - 2020-09-08

* `Aws\ApiGatewayV2` - You can now secure HTTP APIs using Lambda authorizers and IAM authorizers. These options enable you to make flexible auth decisions using a Lambda function, or using IAM policies, respectively.
* `Aws\CodeBuild` - AWS CodeBuild - Support keyword search for test cases in DecribeTestCases API . Allow deletion of reports in the report group, before deletion of report group using the deleteReports flag.
* `Aws\ElasticLoadBalancingv2` - Adds support for Application Load Balancers on Outposts.
* `Aws\LexModelBuildingService` - Amazon Lex supports en-AU locale
* `Aws\QuickSight` - Adds tagging support for QuickSight customization resources. A user can now specify a list of tags when creating a customization resource and use a customization ARN in QuickSight's tagging APIs.

## 3.152.0 - 2020-09-04

* `Aws\Credentials` - This change adds support for the credential_source option in the credential file.
* `Aws\SSM` - Documentation-only updates for AWS Systems Manager
* `Aws\WorkSpaces` - Adding support for Microsoft Office 2016 and Microsoft Office 2019 in BYOL Images
* `Aws\XRay` - Enhancing CreateGroup, UpdateGroup, GetGroup and GetGroups APIs to support configuring X-Ray Insights

## 3.151.6 - 2020-09-03

* `Aws\GuardDuty` - GuardDuty findings triggered by failed events now include the error code name within the AwsApiCallAction section.
* `Aws\MediaPackage` - Enables inserting a UTCTiming XML tag in the output manifest of a DASH endpoint which a media player will use to help with time synchronization.
* `Aws\SFN` - This release of the AWS Step Functions SDK introduces support for payloads up to 256KB for Standard and Express workflows
* `Aws\kendra` - Amazon Kendra now returns confidence scores for both 'answer' and 'question and answer' query responses.

## 3.151.5 - 2020-09-02

* `Aws\Credentials` - Web identity credential provider now clears cached path for web identity token if token file fails to load.
* `Aws\EC2` - This release adds a new transit gateway attachment state and resource type.
* `Aws\Macie2` - This release of the Amazon Macie API introduces additional statistics for the size and count of Amazon S3 objects that Macie can analyze as part of a classification job.

## 3.151.4 - 2020-09-01

* `Aws\CodeGuruReviewer` - Add support for repository analysis based code reviews
* `Aws\S3` - Fixes an issue where a stream would be created that uploaded a file name instead of the file for a multipart upload
* `Aws\SecurityHub` - Added a PatchSummary object for security findings. The PatchSummary object provides details about the patch compliance status of an instance.

## 3.151.3 - 2020-08-31

* `Aws\Backup` - Documentation updates for Cryo
* `Aws\CloudFront` - CloudFront now supports real-time logging for CloudFront distributions. CloudFront real-time logs are more detailed, configurable, and are available in real time.
* `Aws\EC2` - Amazon EC2 and Spot Fleet now support modification of launch template configs for a running fleet enabling instance type, instance weight, AZ, and AMI updates without losing the current fleet ID.
* `Aws\SQS` - Documentation updates for SQS.

## 3.151.2 - 2020-08-28

* `Aws\CloudFront` - You can now manage CloudFront's additional, real-time metrics with the CloudFront API.
* `Aws\CostandUsageReportService` - This release add MONTHLY as the new supported TimeUnit for ReportDefinition.
* `Aws\EMR` - Amazon EMR adds support for ICMP, port -1, in Block Public Access Exceptions and API access for EMR Notebooks execution. You can now non-interactively execute EMR Notebooks and pass input parameters.
* `Aws\Route53` - Documentation updates for Route 53

## 3.151.1 - 2020-08-27

* `Aws\EC2` - Introduces support to initiate Internet Key Exchange (IKE) negotiations for VPN connections from AWS. A user can now send the initial IKE message to their Customer Gateway (CGW) from VPN endpoints.
* `Aws\GameLift` - GameLift FleetIQ as a standalone feature is now generally available. FleetIQ makes low-cost Spot instances viable for game hosting. Use GameLift FleetIQ with your EC2 Auto Scaling groups.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for WebM DASH outputs as well as H.264 4:2:2 10-bit output in MOV and MP4.
* `Aws\Redshift` - Documentation updates for Amazon Redshift.

## 3.151.0 - 2020-08-26

* `Aws\Appflow` - Amazon AppFlow is a fully managed integration service that securely transfers data between AWS services and SaaS applications. This update releases the first version of Amazon AppFlow APIs and SDK.
* `Aws\Route53Resolver` - Route 53 Resolver adds support for resolver query logs
* `Aws\S3` - Documentation updates for S3 methods with ambiguous success

## 3.150.3 - 2020-08-24

* `Aws\CloudWatchLogs` - Documentation updates for CloudWatch Logs
* `Aws\DatabaseMigrationService` - Added new endpoint settings to include columns with Null and Empty value when using Kinesis and Kafka as target. Added a new endpoint setting to set maximum message size when using Kafka as target.
* `Aws\EC2` - This release enables customers to use VPC prefix lists in their transit gateway route tables, and it adds support for Provisioned IOPS SSD (io2) EBS volumes.
* `Aws\IoTSiteWise` - Add traversalDirection to ListAssociatedAssetsRequest and add portal status to ListPortalsResponse
* `Aws\Kafka` - Add UpdateConfiguration and DeleteConfiguration operations.
* `Aws\SSM` - Add string length constraints to OpsDataAttributeName and OpsFilterValue.
* `Aws\XRay` - AWS X-Ray now supports tagging on sampling rules and groups.

## 3.150.2 - 2020-08-20

* `Aws\ApiGatewayV2` - Customers can now create Amazon API Gateway HTTP APIs that route requests to AWS AppConfig, Amazon EventBridge, Amazon Kinesis Data Streams, Amazon SQS, and AWS Step Functions.
* `Aws\Chime` - Documentation updates for chime
* `Aws\FSx` - Documentation updates for Amazon FSx

## 3.150.1 - 2020-08-19

* `Aws\IVS` - Amazon Interactive Video Service (IVS) now offers customers the ability to create private channels, allowing customers to restrict their streams by channel or viewer.
* `Aws\LakeFormation` - Adding additional field in ListPermissions API response to return RAM resource share ARN if a resource were shared through AWS RAM service.
* `Aws\Organizations` - Minor documentation updates for AWS Organizations
* `Aws\ServiceCatalog` - Enhance SearchProvisionedProducts API to allow queries using productName and provisioningArtifactName. Added lastProvisioningRecordId and lastSuccessfulRecordId to Read ProvisionedProduct APIs
* `Aws\StorageGateway` - Added WORM, tape retention lock, and custom pool features for virtual tapes.
* `Aws\TranscribeStreamingService` - Amazon Transcribe and Amazon Transcribe Medical now enable you to identify different speakers in your real-time streams with speaker identification.

## 3.150.0 - 2020-08-18

* `Aws\CodeBuild` - Documentation updates for codebuild
* `Aws\CognitoIdentityProvider` - Adding the option to use a service linked role to publish events to Pinpoint.
* `Aws\DataSync` - DataSync support for filters as input arguments to the ListTasks and ListLocations API calls.
* `Aws\IdentityStore` - AWS Single Sign-On (SSO) Identity Store service provides an interface to retrieve all of your users and groups. It enables entitlement management per user or group for AWS SSO and other IDPs.
* `Aws\SecurityHub` - New details for DynamoDB tables, Elastic IP addresses, IAM policies and users, RDS DB clusters and snapshots, and Secrets Manager secrets. Added details for AWS KMS keys and RDS DB instances.
* `Aws\SesV2` - This release includes new APIs to allow customers to add or remove email addresses from their account-level suppression list in bulk.

## 3.149.2 - 2020-08-17

* `Aws\ACM` - ACM provides support for the new Private CA feature Cross-account CA sharing. ACM users can issue certificates signed by a private CA belonging to another account where the CA was shared with them.
* `Aws\ACMPCA` - ACM Private CA is launching cross-account support. This allows customers to share their private CAs with other accounts, AWS Organizations, and organizational units to issue end-entity certificates.
* `Aws\ECR` - This feature adds support for pushing and pulling Open Container Initiative (OCI) artifacts.
* `Aws\ElasticLoadBalancing` - Adds support for HTTP Desync Mitigation in Classic Load Balancers.
* `Aws\ElasticLoadBalancingv2` - Adds support for HTTP Desync Mitigation in Application Load Balancers.
* `Aws\Kinesis` - Introducing ShardFilter for ListShards API to filter the shards using a position in the stream, and ChildShards support for GetRecords and SubscribeToShard API to discover children shards on shard end
* `Aws\QuickSight` - Amazon QuickSight now supports programmatic creation and management of analyses with new APIs.
* `Aws\RoboMaker` - This release introduces RoboMaker Simulation WorldForge, a capability that automatically generates one or more simulation worlds.

## 3.149.1 - 2020-08-14

* `Aws\AppStream` - Adds support for the Desktop View feature
* `Aws\Braket` - Fixing bug in our SDK model where device status and device type had been flipped.
* `Aws\EC2` - New C5ad instances featuring AMD's 2nd Generation EPYC processors, offering up to 96 vCPUs, 192 GiB of instance memory, 3.8 TB of NVMe based SSD instance storage, and 20 Gbps in Network bandwidth
* `Aws\LicenseManager` - This release includes ability to enforce license assignment rules with EC2 Dedicated Hosts.
* `Aws\SageMaker` - Amazon SageMaker now supports 1) creating real-time inference endpoints using model container images from Docker registries in customers' VPC 2) AUC(Area under the curve) as AutoPilot objective metric

## 3.149.0 - 2020-08-13

* `Aws\AppSync` - Documentation update for AWS AppSync support for Direct Lambda Resolvers.
* `Aws\Braket` - Amazon Braket general availability with Device and Quantum Task operations.
* `Aws\CognitoIdentityProvider` - Adding ability to customize expiry for Refresh, Access and ID tokens.
* `Aws\EC2` - Added MapCustomerOwnedIpOnLaunch and CustomerOwnedIpv4Pool to ModifySubnetAttribute to allow CoIP auto assign. Fields are returned in DescribeSubnets and DescribeNetworkInterfaces responses.
* `Aws\EKS` - Adding support for customer provided EC2 launch templates and AMIs to EKS Managed Nodegroups. Also adds support for Arm-based instances to EKS Managed Nodegroups.
* `Aws\Macie2` - This release of the Amazon Macie API includes miscellaneous updates and improvements to the documentation.
* `Aws\RDS` - This release allows customers to specify a replica mode when creating or modifying a Read Replica, for DB engines which support this feature.

## 3.148.3 - 2020-08-12

* `Aws\Cloud9` - Add ConnectionType input parameter to CreateEnvironmentEC2 endpoint. New parameter enables creation of environments with SSM connection.
* `Aws\Comprehend` - Amazon Comprehend Custom Entity Recognition now supports Spanish, German, French, Italian and Portuguese and up to 25 entity types per model.
* `Aws\EC2` - Introduces support for IPv6-in-IPv4 IPsec tunnels. A user can now send traffic from their on-premise IPv6 network to AWS VPCs that have IPv6 support enabled.
* `Aws\FSx` - This release adds the capability to create persistent file systems for throughput-intensive workloads using Hard Disk Drive (HDD) storage and an optional read-only Solid-State Drive (SSD) cache.
* `Aws\IoT` - Audit finding suppressions: Device Defender enables customers to turn off non-compliant findings for specific resources on a per check basis.
* `Aws\Lambda` - Support for creating Lambda Functions using 'java8.al2' and 'provided.al2'
* `Aws\Transfer` - Adds security policies to control cryptographic algorithms advertised by your server, additional characters in usernames and length increase, and FIPS compliant endpoints in the US and Canada regions.
* `Aws\WorkSpaces` - Adds optional EnableWorkDocs property to WorkspaceCreationProperties in the ModifyWorkspaceCreationProperties API

## 3.148.2 - 2020-08-11

* `Aws\Build\Docs` - Moves cookie consent into footer
* `Aws\EC2` - This release rolls back the EC2 On-Demand Capacity Reservations (ODCRs) release 1.11.831 published on 2020-07-30, which was deployed in error.
* `Aws\Lambda` - Support Managed Streaming for Kafka as an Event Source. Support retry until record expiration for Kinesis and Dynamodb streams event source mappings.
* `Aws\Organizations` - Minor documentation update for AWS Organizations
* `Aws\S3` - Add support for in-region CopyObject and UploadPartCopy through S3 Access Points
* `Aws\S3` - Change cache clearing in StreamWrapper to account for custom protocol use.

## 3.148.1 - 2020-08-10

* `Aws\EC2` - Remove CoIP Auto-Assign feature references.
* `Aws\Glue` - Starting today, you can further control orchestration of your ETL workloads in AWS Glue by specifying the maximum number of concurrent runs for a Glue workflow.
* `Aws\SavingsPlans` - Updates to the list of services supported by this API.

## 3.148.0 - 2020-08-07

* `Aws\Glue` - AWS Glue now adds support for Network connection type enabling you to access resources inside your VPC using Glue crawlers and Glue ETL jobs.
* `Aws\Organizations` - Documentation updates for some new error reasons.
* `Aws\S3` - Updates Amazon S3 API reference documentation. 
* `Aws\S3\Crypto` - This change includes fixes for issues that were reported by Sophie Schmieg from the Google ISE team, and for issues that were discovered by AWS Cryptography.
* `Aws\SMS` - In this release, AWS Server Migration Service (SMS) has added new features: 1. APIs to work with application and instance level validation 2. Import application catalog from AWS Application Discovery Service 3. For an application you can start on-demand replication

## 3.147.14 - 2020-08-06

* `Aws\EC2` - This release supports Wavelength resources, including carrier gateways, and carrier IP addresses.
* `Aws\LexModelBuildingService` - Amazon Lex supports the option to enable accuracy improvements and specify an intent classification confidence score threshold.
* `Aws\LexRuntimeService` - Amazon Lex supports intent classification confidence scores along with a list of the top five intents.
* `Aws\Personalize` - Add 'exploration' functionality
* `Aws\PersonalizeEvents` - Adds support implicit and explicit impression input
* `Aws\PersonalizeRuntime` - Adds support for implicit impressions

## 3.147.13 - 2020-08-05

* `Aws\AppSync` - AWS AppSync releases support for Direct Lambda Resolvers.
* `Aws\FSx` - Documentation updates for StorageCapacity input value format.
* `Aws\ResourceGroupsTaggingAPI` - Documentation updates for the Resource Group Tagging API namespace.
* `Aws\SNS` - Documentation updates for SNS.
* `Aws\TranscribeService` - Amazon Transcribe now supports custom language models, which can improve transcription accuracy for your specific use case.

## 3.147.12 - 2020-08-04

* `Aws\Health` - Documentation updates for health

## 3.147.11 - 2020-08-03

* `Aws\` - Updates docs to comply with GDPR laws
* `Aws\SSM` - Adds a waiter for CommandExecuted and paginators for various other APIs.

## 3.147.10 - 2020-07-31

* `Aws\Chime` - This release increases the CreateMeetingWithAttendee max attendee limit to 10.
* `Aws\PersonalizeRuntime` - Adds support to use filters with Personalized Ranking recipe
* `Aws\ResourceGroupsTaggingAPI` - Updates to the list of services supported by this API.
* `Aws\StorageGateway` - Add support for gateway VM deprecation dates
* `Aws\WAFV2` - Add ManagedByFirewallManager flag to the logging configuration, which indicates whether AWS Firewall Manager controls the configuration.

## 3.147.9 - 2020-07-30

* `Aws\CloudFront` - Documentation updates for CloudFront
* `Aws\CodeBuild` - Adding support for BuildBatch, and CodeCoverage APIs. BuildBatch allows you to model your project environment in source, and helps start multiple builds with a single API call. CodeCoverage allows you to track your code coverage using AWS CodeBuild. 
* `Aws\EC2` - EC2 On-Demand Capacity Reservations now adds support to bring your own licenses (BYOL) of Windows operating system to launch EC2 instances. 
* `Aws\GuardDuty` - GuardDuty can now provide detailed cost metrics broken down by account, data source, and S3 resources, based on the past 30 days of usage. This new feature also supports viewing cost metrics for all member accounts as a GuardDuty master.
* `Aws\Kafka` - Amazon MSK has added a new API that allows you to reboot brokers within a cluster. 
* `Aws\Organizations` - Documentation updates for AWS Organizations
* `Aws\ResourceGroups` - Improved documentation for Resource Groups API operations.
* `Aws\ServiceCatalog` - This release adds support for ProvisionProduct, UpdateProvisionedProduct & DescribeProvisioningParameters by product name, provisioning artifact name and path name. In addition DescribeProvisioningParameters now returns a list of provisioning artifact outputs.
* `Aws\SesV2` - This release makes more API operations available to customers in version 2 of the Amazon SES API. With these additions, customers can now access sending authorization, custom verification email, and template API operations. With this release, Amazon SES is also providing new and updated APIs to allow customers to request production access.

## 3.147.8 - 2020-07-29

* `Aws\EC2` - Adding support to target EC2 On-Demand Capacity Reservations within an AWS Resource Group to launch EC2 instances.
* `Aws\ECR` - This release adds support for encrypting the contents of your Amazon ECR repository with customer master keys (CMKs) stored in AWS Key Management Service.
* `Aws\Firehose` - This release includes a new Kinesis Data Firehose feature that supports data delivery to Https endpoint and to partners. You can now use Kinesis Data Firehose to ingest real-time data and deliver to Https endpoint and partners in a serverless, reliable, and salable manner.
* `Aws\GuardDuty` - GuardDuty now supports S3 Data Events as a configurable data source type. This feature expands GuardDuty's monitoring scope to include S3 data plane operations, such as GetObject and PutObject. This data source is optional and can be enabled or disabled at anytime. Accounts already using GuardDuty must first enable the new feature to use it; new accounts will be enabled by default. GuardDuty masters can configure this data source for individual member accounts and GuardDuty masters associated through AWS Organizations can automatically enable the data source in member accounts.
* `Aws\ResourceGroups` - Resource Groups released a new feature that enables you to create a group with an associated configuration that specifies how other AWS services interact with the group. There are two new operations `GroupResources` and `UngroupResources` to work on a group with a configuration. In this release, you can associate EC2 Capacity Reservations with a resource group. Resource Groups also added a new request parameter `Group` to replace `GroupName` for all existing operations.
* `Aws\S3\Crypto` - Add crypto-specific user-agent string to encryption clients.
* `Aws\ServiceDiscovery` - Added new attribute AWS_EC2_INSTANCE_ID for RegisterInstance API 

## 3.147.7 - 2020-07-28

* `Aws\AutoScaling` - Now you can enable Instance Metadata Service Version 2 (IMDSv2) or disable the instance metadata endpoint with Launch Configurations.
* `Aws\EC2` - Introduces support for tag-on-create capability for the following APIs: CreateVpnConnection, CreateVpnGateway, and CreateCustomerGateway. A user can now add tags while creating these resources. For further detail, please see AWS Tagging Strategies.
* `Aws\IVS` - Added a new error code, PendingVerification, to differentiate between errors caused by insufficient IAM permissions and errors caused by account verification.
* `Aws\MediaLive` - AWS Elemental MediaLive now supports several new features: EBU-TT-D captions in Microsoft Smooth outputs; interlaced video in HEVC outputs; video noise reduction (using temporal filtering) in HEVC outputs.
* `Aws\RDS` - Adds reporting of manual cluster snapshot quota to DescribeAccountAttributes API
* `Aws\SecurityHub` - Added UpdateSecurityHubConfiguration API. Security Hub now allows customers to choose whether to automatically enable new controls that are added to an existing standard that the customer enabled. For example, if you enabled Foundational Security Best Practices for an account, you can automatically enable new controls as we add them to that standard. By default, new controls are enabled.
* `Aws\imagebuilder` - This release updates distribution configurations to allow periods in AMI names.

## 3.147.6 - 2020-07-27

* `Aws\DataSync` - Today AWS DataSync releases support for self-managed object storage Locations and the new TransferMode Option.
* `Aws\DatabaseMigrationService` - Basic endpoint settings for relational databases, Preflight validation API.
* `Aws\EC2` - m6gd, c6gd, r6gd instances are powered by AWS Graviton2 processors and support local NVMe instance storage
* `Aws\FraudDetector` - Moved the eventTypeName attribute for PutExternalModel API to inputConfiguration. Model ID's no longer allow hyphens.
* `Aws\Glue` - Add ability to manually resume workflows in AWS Glue providing customers further control over the orchestration of ETL workloads.
* `Aws\SSM` - Assorted doc ticket-fix updates for Systems Manager.

## 3.147.5 - 2020-07-24

* `Aws\` - Adds region validation as a valid host label when region is being used to construct an endpoint. Note this does not take effect when a custom endpoint is supplied.
* `Aws\CloudWatch` - AWS CloudWatch ListMetrics now supports an optional parameter (RecentlyActive) to filter results by only metrics that have received new datapoints in the past 3 hours. This enables more targeted metric data retrieval through the Get APIs
* `Aws\FSx` - Documentation update for FSx for Lustre
* `Aws\FraudDetector` - GetPrediction has been replaced with GetEventPrediction. PutExternalModel has been simplified to accept a role ARN.
* `Aws\MQ` - Amazon MQ now supports LDAP (Lightweight Directory Access Protocol), providing authentication and authorization of Amazon MQ users via a customer designated LDAP server.
* `Aws\Macie2` - This release of the Amazon Macie API introduces additional criteria for sorting and filtering query results for account quotas and usage statistics.
* `Aws\MediaConnect` - You can now disable an entitlement to stop streaming content to the subscriber's flow temporarily. When you are ready to allow content to start streaming to the subscriber's flow again, you can enable the entitlement.
* `Aws\MediaPackage` - The release adds daterange as a new ad marker option. This option enables MediaPackage to insert EXT-X-DATERANGE tags in HLS and CMAF manifests. The EXT-X-DATERANGE tag is used to signal ad and program transition events.
* `Aws\SageMaker` - Sagemaker Ground Truth:Added support for OIDC (OpenID Connect) to authenticate workers via their own identity provider instead of through Amazon Cognito. This release adds new APIs (CreateWorkforce, DeleteWorkforce, and ListWorkforces) to SageMaker Ground Truth service. Sagemaker Neo: Added support for detailed target device description by using TargetPlatform fields - OS, architecture, and accelerator. Added support for additional compilation parameters by using JSON field CompilerOptions. Sagemaker Search: SageMaker Search supports transform job details in trial components.
* `Aws\kendra` - Amazon Kendra now supports sorting query results based on document attributes. Amazon Kendra also introduced an option to enclose table and column names with double quotes for database data sources. 

## 3.147.4 - 2020-07-23

* `Aws\ConfigService` - Adding service linked configuration aggregation support along with new enums for config resource coverage
* `Aws\DirectConnect` - Documentation updates for AWS Direct Connect
* `Aws\FSx` - Adds support for AutoImport, a new FSx for Lustre feature that allows customers to configure their FSx file system to automatically update its contents when new objects are added to S3 or existing objects are overwritten.
* `Aws\Glue` - Added new ConnectionProperties: "KAFKA_SSL_ENABLED" (to toggle SSL connections) and "KAFKA_CUSTOM_CERT" (import CA certificate file)
* `Aws\Lightsail` - This release adds support for Amazon Lightsail content delivery network (CDN) distributions and SSL/TLS certificates.
* `Aws\WorkSpaces` - Added UpdateWorkspaceImagePermission API to share Amazon WorkSpaces images across AWS accounts.

## 3.147.3 - 2020-07-22

* `Aws\MediaLive` - The AWS Elemental MediaLive APIs and SDKs now support the ability to get thumbnails for MediaLive devices that are attached or not attached to a channel. Previously, this thumbnail feature was available only on the console.
* `Aws\QuickSight` - New API operations - GetSessionEmbedUrl, CreateNamespace, DescribeNamespace, ListNamespaces, DeleteNamespace, DescribeAccountSettings, UpdateAccountSettings, CreateAccountCustomization, DescribeAccountCustomization, UpdateAccountCustomization, DeleteAccountCustomization. Modified API operations to support custom permissions restrictions - RegisterUser, UpdateUser, UpdateDashboardPermissions

## 3.147.2 - 2020-07-21

* `Aws\CodeGuruProfiler` - Amazon CodeGuru Profiler now supports resource tagging APIs, tags-on-create and tag-based access control features. You can now tag profiling groups for better resource and access control management.

## 3.147.1 - 2020-07-20

* `Aws\CloudFront` - CloudFront adds support for cache policies and origin request policies. With these new policies, you can now more granularly control the query string, header, and cookie values that are included in the cache key and in requests that CloudFront sends to your origin.
* `Aws\CodeBuild` - AWS CodeBuild adds support for Session Manager and Windows 2019 Environment type
* `Aws\EC2` - Added support for tag-on-create for CreateVpcPeeringConnection and CreateRouteTable. You can now specify tags when creating any of these resources. For more information about tagging, see AWS Tagging Strategies. Add poolArn to the response of DescribeCoipPools.
* `Aws\FMS` - Added managed policies for auditing security group rules, including the use of managed application and protocol lists.
* `Aws\FraudDetector` - Introduced flexible model training dataset requirements for Online Fraud Insights so that customers can choose any two inputs to train a model instead of being required to use 'email' and 'IP address' at minimum. Added support for resource ARNs, resource tags, resource-based IAM policies and identity-based policies that limit access to a resource based on tags. Added support for customer-managed customer master key (CMK) data encryption. Added new Event Type, Entity Type, and Label APIs. An event type defines the structure for an event sent to Amazon Fraud Detector, including the variables sent as part of the event, the entity performing the event, and the labels that classify the event. Introduced the GetEventPrediction API.
* `Aws\GroundStation` - Adds optional MTU property to DataflowEndpoint and adds contact source and destination details to DescribeContact response.
* `Aws\RDS` - Add a new SupportsParallelQuery output field to DescribeDBEngineVersions. This field shows whether the engine version supports parallelquery. Add a new SupportsGlobalDatabases output field to DescribeDBEngineVersions and DescribeOrderableDBInstanceOptions. This field shows whether global database is supported by engine version or the combination of engine version and instance class.

## 3.147.0 - 2020-07-17

* `Aws\` - Added the use_aws_shared_config_files client constructor option to not attempt to access shared config files.
* `Aws\AppSync` - Documentation update to Cachingconfig.cachingKeys to include $context.source as a valid value.
* `Aws\ApplicationAutoScaling` - Documentation updates for Application Auto Scaling
* `Aws\Connect` - This release adds a set of Amazon Connect APIs to programmatically control call recording with start, stop, pause and resume functions.
* `Aws\Crypto` - Tweaks the wrap algorithm name for KmsMaterialsProviderV2 for the sake of cross-SDK consistency.
* `Aws\EC2` - Documentation updates for EC2
* `Aws\ElasticBeanstalk` - Add waiters for `EnvironmentExists`, `EnvironmentUpdated`, and `EnvironmentTerminated`. Add paginators for `DescribeEnvironmentManagedActionHistory` and `ListPlatformVersions`.
* `Aws\Macie2` - This release of the Amazon Macie API includes miscellaneous updates and improvements to the documentation.

## 3.146.0 - 2020-07-15

* `Aws\` - Fixes issue with transfer stats not being populated for calls with retried exceptions.
* `Aws\IVS` - Introducing Amazon Interactive Video Service - a managed live streaming solution that is quick and easy to set up, and ideal for creating interactive video experiences.

## 3.145.4 - 2020-07-09

* `Aws\AlexaForBusiness` - Added support for registering an AVS device directly to a room using RegisterAVSDevice with a room ARN
* `Aws\Amplify` - Documentation update to the introduction text to specify that this is the Amplify Console API.
* `Aws\AppMesh` - AppMesh now supports Ingress which allows resources outside a mesh to communicate to resources that are inside the mesh. See https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html
* `Aws\CloudHSMV2` - Documentation updates for cloudhsmv2
* `Aws\CloudWatchEvents` - Amazon CloudWatch Events/EventBridge adds support for API Gateway as a target.
* `Aws\Comprehend` - AWS Comprehend now supports Real-time Analysis with Custom Entity Recognition. 
* `Aws\EBS` - This release introduces the following set of actions for the EBS direct APIs: 1. StartSnapshot, which creates a new Amazon EBS snapshot. 2. PutSnapshotBlock, which writes a block of data to a snapshot. 3. CompleteSnapshot, which seals and completes a snapshot after blocks of data have been written to it.
* `Aws\EventBridge` - Amazon EventBridge adds support for API Gateway as a target.
* `Aws\SNS` - This release adds support for SMS origination number as an attribute in the MessageAttributes parameter for the SNS Publish API.
* `Aws\SageMaker` - This release adds the DeleteHumanTaskUi API to Amazon Augmented AI
* `Aws\SecretsManager` - Adds support for filters on the ListSecrets API to allow filtering results by name, tag key, tag value, or description. Adds support for the BlockPublicPolicy option on the PutResourcePolicy API to block resource policies which grant a wide range of IAM principals access to secrets. Adds support for the ValidateResourcePolicy API to validate resource policies for syntax and prevent lockout error scenarios and wide access to secrets. 
* `Aws\WAFV2` - Added the option to use IP addresses from an HTTP header that you specify, instead of using the web request origin. Available for IP set matching, geo matching, and rate-based rule count aggregation.

## 3.145.3 - 2020-07-08

* `Aws\CostExplorer` - Customers can now see Instance Name alongside each rightsizing recommendation.
* `Aws\EC2` - EC2 Spot now enables customers to tag their Spot Instances Requests on creation.
* `Aws\ForecastService` - With this release, Amazon Forecast now supports the ability to add a tag to any resource via the launch of three new APIs: TagResouce, UntagResource and ListTagsForResource. A tag is a simple label consisting of a customer-defined key and an optional value allowing for easier resource management.
* `Aws\Organizations` - We have launched a self-service option to make it easier for customers to manage the use of their content by AI services. Certain AI services (Amazon CodeGuru Profiler, Amazon Comprehend, Amazon Lex, Amazon Polly, Amazon Rekognition, Amazon Textract, Amazon Transcribe, and Amazon Translate) may use content to improve the service. Customers have been able to opt out of this use by contacting AWS Support, and now they can opt out on a self-service basis by setting an Organizations policy for all or an individual AI service listed above. Please refer to the technical documentation in the online AWS Organizations User Guide for more details.

## 3.145.2 - 2020-07-07

* `Aws\CloudFront` - Amazon CloudFront adds support for a new security policy, TLSv1.2_2019.
* `Aws\EC2` - DescribeAvailabilityZones now returns additional data about Availability Zones and Local Zones.
* `Aws\EFS` - This release adds support for automatic backups of Amazon EFS file systems to further simplify backup management. 
* `Aws\Glue` - AWS Glue Data Catalog supports cross account sharing of tables through AWS Lake Formation
* `Aws\LakeFormation` -  AWS Lake Formation supports sharing tables with other AWS accounts and organizations
* `Aws\StorageGateway` - Adding support for file-system driven directory refresh, Case Sensitivity toggle for SMB File Shares, and S3 Prefixes and custom File Share names

## 3.145.1 - 2020-07-06

* `Aws\IoTSiteWise` - This release supports optional start date and end date parameters for the GetAssetPropertyValueHistory API.
* `Aws\QuickSight` - Add Theme APIs and update Dashboard APIs to support theme overrides.
* `Aws\RDS` - Adds support for Amazon RDS on AWS Outposts.

## 3.145.0 - 2020-07-02

* `Aws\Api` - Fixed bug with marshalling empty strings from dynamodb
* `Aws\Build` - Updated packager code to work with Guzzle 7.
* `Aws\Connect` - Documentation updates for Amazon Connect.
* `Aws\ElastiCache` - Documentation updates for elasticache
* `Aws\S3` - Adds a V2 implementation for the S3 encryption client, which has an updated encryption workflow and should be used over the original encryption client when possible.

## 3.144.2 - 2020-07-01

* `Aws\AppSync` - AWS AppSync supports new 12xlarge instance for server-side API caching
* `Aws\Chime` - This release supports third party emergency call routing configuration for Amazon Chime Voice Connectors.
* `Aws\CodeBuild` - Support build status config in project source
* `Aws\RDS` - This release adds the exceptions KMSKeyNotAccessibleFault and InvalidDBClusterStateFault to the Amazon RDS ModifyDBInstance API.
* `Aws\SecurityHub` - This release adds additional details for findings. There are now finding details for auto scaling groups, EC2 volumes, and EC2 VPCs. You can identify detected vulnerabilities and provide related network paths.
* `Aws\imagebuilder` - EC2 Image Builder adds support for encrypted AMI distribution.

## 3.144.1 - 2020-06-30

* `Aws\CodeGuruReviewer` - Release GitHub Enterprise Server source provider integration
* `Aws\ComprehendMedical` - This release adds the relationships between MedicalCondition and Anatomy in DetectEntitiesV2 API.
* `Aws\EC2` - Added support for tag-on-create for CreateVpc, CreateEgressOnlyInternetGateway, CreateSecurityGroup, CreateSubnet, CreateNetworkInterface, CreateNetworkAcl, CreateDhcpOptions and CreateInternetGateway. You can now specify tags when creating any of these resources. For more information about tagging, see AWS Tagging Strategies.
* `Aws\ECR` - Add a new parameter (ImageDigest) and a new exception (ImageDigestDoesNotMatchException) to PutImage API to support pushing image by digest.
* `Aws\RDS` - Documentation updates for rds

## 3.144.0 - 2020-06-29

* `Aws\Api` - Added defensive parsing of timestamps so it can take epoch or ISO8601 without knowing the type.
* `Aws\AutoScaling` - Documentation updates for Amazon EC2 Auto Scaling.
* `Aws\CodeGuruProfiler` - Amazon CodeGuru Profiler is now generally available. The Profiler helps developers to optimize their software, troubleshoot issues in production, and identify their most expensive lines of code. As part of general availability, we are launching: Profiling of AWS Lambda functions, Anomaly detection in CPU profiles, Color My Code on flame graphs, Expanding presence to 10 AWS regions.
* `Aws\CodeStarconnections` - Updated and new APIs in support of hosts for connections to installed provider types. New integration with the GitHub Enterprise Server provider type.
* `Aws\EC2` - Virtual Private Cloud (VPC) customers can now create and manage their own Prefix Lists to simplify VPC configurations.
* `Aws\S3` - Allows for unicode character keys in multipart copy.

## 3.143.2 - 2020-06-26

* `Aws\CloudFormation` - ListStackInstances and DescribeStackInstance now return a new `StackInstanceStatus` object that contains `DetailedStatus` values: a disambiguation of the more generic `Status` value. ListStackInstances output can now be filtered on `DetailedStatus` using the new `Filters` parameter.
* `Aws\CognitoIdentityProvider` - Don't require Authorization for InitiateAuth and RespondToAuthChallenge.
* `Aws\DatabaseMigrationService` - This release contains miscellaneous API documentation updates for AWS DMS in response to several customer reported issues.
* `Aws\QuickSight` - Added support for cross-region DataSource credentials copying.
* `Aws\SageMaker` - The new 'ModelClientConfig' parameter being added for CreateTransformJob and DescribeTransformJob api actions enable customers to configure model invocation related parameters such as timeout and retry.

## 3.143.1 - 2020-06-25

* `Aws\EC2` - Added support for tag-on-create for Host Reservations in Dedicated Hosts. You can now specify tags when you create a Host Reservation for a Dedicated Host. For more information about tagging, see AWS Tagging Strategies.
* `Aws\Glue` - This release adds new APIs to support column level statistics in AWS Glue Data Catalog

## 3.143.0 - 2020-06-24

* `Aws\Amplify` - This release of AWS Amplify Console introduces support for automatically creating custom subdomains for branches based on user-defined glob patterns, as well as automatically cleaning up Amplify branches when their corresponding git branches are deleted.
* `Aws\AutoScaling` - Documentation updates for Amazon EC2 Auto Scaling.
* `Aws\Backup` - Customers can now manage and monitor their backups in a policied manner across their AWS accounts, via an integration between AWS Backup and AWS Organizations
* `Aws\CodeCommit` - This release introduces support for reactions to CodeCommit comments. Users will be able to select from a pre-defined list of emojis to express their reaction to any comments.
* `Aws\EMR` - Amazon EMR customers can now set allocation strategies for On-Demand and Spot instances in their EMR clusters with instance fleets. These allocation strategies use real-time capacity insights to provision clusters faster and make the most efficient use of available spare capacity to allocate Spot instances to reduce interruptions. 
* `Aws\FSx` - This release adds the capability to take highly-durable, incremental backups of your FSx for Lustre persistent file systems. This capability makes it easy to further protect your file system data and to meet business and regulatory compliance requirements.
* `Aws\Honeycode` - Introducing Amazon Honeycode - a fully managed service that allows you to quickly build mobile and web apps for teams without programming.
* `Aws\IAM` - Documentation updates for iam
* `Aws\Organizations` - This release adds support for a new backup policy type for AWS Organizations.

## 3.142.8 - 2020-06-23

* `Aws\MediaTailor` - AWS Elemental MediaTailor SDK now allows configuration of Bumper.
* `Aws\Organizations` - Added a new error message to support the requirement for a Business License on AWS accounts in China to create an organization.

## 3.142.7 - 2020-06-22

* `Aws\EC2` - This release adds Tag On Create feature support for the ImportImage, ImportSnapshot, ExportImage and CreateInstanceExportTask APIs.
* `Aws\EMR` - Adding support for MaximumCoreCapacityUnits parameter for EMR Managed Scaling. It allows users to control how many units/nodes are added to the CORE group/fleet. Remaining units/nodes are added to the TASK groups/fleet in the cluster.
* `Aws\RDS` - Added paginators for various APIs.
* `Aws\Rekognition` - This update adds the ability to detect black frames, end credits, shots, and color bars in stored videos
* `Aws\SQS` - AWS SQS adds pagination support for ListQueues and ListDeadLetterSourceQueues APIs

## 3.142.6 - 2020-06-19

* `Aws\EC2` - Adds support to tag elastic-gpu on the RunInstances api
* `Aws\ElastiCache` - Documentation updates for elasticache
* `Aws\MediaLive` - AWS Elemental MediaLive now supports Input Prepare schedule actions. This feature improves existing input switching by allowing users to prepare an input prior to switching to it.
* `Aws\OpsWorksCM` - Documentation updates for AWS OpsWorks CM.

## 3.142.5 - 2020-06-18

* `Aws\MarketplaceMetering` - Documentation updates for meteringmarketplace
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for NexGuard FileMarker SDK, which allows NexGuard partners to watermark proprietary content in mezzanine and OTT streaming contexts.
* `Aws\RDS` - Adding support for global write forwarding on secondary clusters in an Aurora global database.
* `Aws\Route53` - Added a new ListHostedZonesByVPC API for customers to list all the private hosted zones that a specified VPC is associated with.
* `Aws\SSM` - Added offset support for specifying the number of days to wait after the date and time specified by a CRON expression before running the maintenance window.
* `Aws\SesV2` - You can now configure Amazon SES to send event notifications when the delivery of an email is delayed because of a temporary issue. For example, you can receive a notification if the recipient's inbox is full, or if there's a temporary problem with the receiving email server.
* `Aws\Support` - Documentation updates for support

## 3.142.4 - 2020-06-17

* `Aws\AppMesh` - Adds support for route and virtual node listener timeouts.
* `Aws\EC2` - nvmeSupport added to DescribeInstanceTypes API
* `Aws\Macie2` - This is a documentation-only update to the Amazon Macie API. This update contains miscellaneous editorial improvements to various API descriptions.
* `Aws\Route53` - Add PriorRequestNotComplete exception to AssociateVPCWithHostedZone API
* `Aws\Snowball` - AWS Snowcone is a portable, rugged and secure device for edge computing and data transfer. You can use Snowcone to collect, process, and move data to AWS, either offline by shipping the device to AWS or online by using AWS DataSync. With 2 CPUs and 4 GB RAM of compute and 8 TB of storage, Snowcone can run edge computing workloads and store data securely. Snowcone's small size (8.94" x 5.85" x 3.25" / 227 mm x 148.6 mm x 82.65 mm) allows you to set it next to machinery in a factory. Snowcone weighs about 4.5 lbs. (2 kg), so you can carry one in a backpack, use it with battery-based operation, and use the Wi-Fi interface to gather sensor data. Snowcone supports a file interface with NFS support. 

## 3.142.3 - 2020-06-16

* `Aws\AutoScaling` - Introducing instance refresh, a feature that helps you update all instances in an Auto Scaling group in a rolling fashion (for example, to apply a new AMI or instance type). You can control the pace of the refresh by defining the percentage of the group that must remain running/healthy during the replacement process and the time for new instances to warm up between replacements.
* `Aws\CloudFront` - Documentation updates for CloudFront
* `Aws\DataExchange` - This release fixes a bug in the AWS Data Exchange Python and NodeJS SDKs. The 'KmsKeyArn' field in the create-job API was configured to be required instead of optional. We updated this field to be optional in this release.
* `Aws\Lambda` - Adds support for using Amazon Elastic File System (persistent storage) with AWS Lambda. This enables customers to share data across function invocations, read large reference data files, and write function output to a persistent and shared store.
* `Aws\Polly` - Amazon Polly adds new US English child voice - Kevin. Kevin is available as Neural voice only.
* `Aws\QLDB` - Documentation updates for Amazon QLDB

## 3.142.2 - 2020-06-15

* `Aws\AlexaForBusiness` - Adding support for optional tags in CreateBusinessReportSchedule, CreateProfile and CreateSkillGroup APIs
* `Aws\AppConfig` - This release adds a hosted configuration source provider. Customers can now store their application configurations directly in AppConfig, without the need for an external configuration source.
* `Aws\Chime` - feature: Chime: This release introduces the ability to create an AWS Chime SDK meeting with attendees.
* `Aws\CognitoIdentityProvider` - Updated all AuthParameters to be sensitive.
* `Aws\IoT` - Added support for job executions rollout configuration, job abort configuration, and job executions timeout configuration for AWS IoT Over-the-Air (OTA) Update Feature.

## 3.142.1 - 2020-06-12

* `Aws\APIGateway` - Documentation updates for Amazon API Gateway
* `Aws\CloudFormation` - The following parameters now return the organization root ID or organizational unit (OU) IDs that you specified for DeploymentTargets: the OrganizationalUnitIds parameter on StackSet and the OrganizationalUnitId parameter on StackInstance, StackInstanceSummary, and StackSetOperationResultSummary
* `Aws\Glue` - You can now choose to crawl the entire table or just a sample of records in DynamoDB when using AWS Glue crawlers. Additionally, you can also specify a scanning rate for crawling DynamoDB tables.
* `Aws\StorageGateway` - Display EndpointType in DescribeGatewayInformation

## 3.142.0 - 2020-06-11

* `Aws\Crypto` - This implements a pure-PHP implementation of GMAC, which, when combined with OpenSSL's AES implementations (both AES-ECB and AES-CTR) allows the support of AES-GCM on PHP versions older than 7.1.
* `Aws\DynamoDb` - Marshal empty strings.
* `Aws\ECS` - This release adds support for deleting capacity providers.
* `Aws\IoTDataPlane` - As part of this release, we are introducing a new feature called named shadow, which extends the capability of AWS IoT Device Shadow to support multiple shadows for a single IoT device. With this release, customers can store different device state data into different shadows, and as a result access only the required state data when needed and reduce individual shadow size.
* `Aws\LexModelBuildingService` - This change adds the built-in AMAZON.KendraSearchIntent that enables integration with Amazon Kendra.
* `Aws\imagebuilder` - EC2 Image Builder now supports specifying a custom working directory for your build and test workflows. In addition, Image Builder now supports defining tags that are applied to ephemeral resources created by EC2 Image Builder as part of the image creation workflow. 

## 3.141.0 - 2020-06-10

* `Aws\` - Made the getSignatureProvider method public.
* `Aws\AppConfig` - This release allows customers to choose from a list of predefined deployment strategies while starting deployments.
* `Aws\CodeArtifact` - Added support for AWS CodeArtifact.
* `Aws\ComputeOptimizer` - Compute Optimizer supports exporting recommendations to Amazon S3.
* `Aws\DLM` - Reducing the schedule name of DLM Lifecycle policy from 500 to 120 characters. 
* `Aws\EC2` - New C6g instances powered by AWS Graviton2 processors and ideal for running advanced, compute-intensive workloads; New R6g instances powered by AWS Graviton2 processors and ideal for running memory-intensive workloads.
* `Aws\Lightsail` - Documentation updates for lightsail
* `Aws\Macie2` - This release of the Amazon Macie API removes support for the ArchiveFindings and UnarchiveFindings operations. This release also adds UNKNOWN as an encryption type for S3 bucket metadata.
* `Aws\ServiceCatalog` - Service Catalog Documentation Update for Integration with AWS Organizations Delegated Administrator feature
* `Aws\Shield` - Corrections to the supported format for contact phone numbers and to the description for the create subscription action.

## 3.140.4 - 2020-06-09

* `Aws\Transfer` - This release updates the API so customers can test use of Source IP to allow, deny or limit access to data in their S3 buckets after integrating their identity provider.

## 3.140.3 - 2020-06-08

* `Aws\ServiceDiscovery` - Added support for tagging Service and Namespace type resources in Cloud Map
* `Aws\Shield` - This release adds the option for customers to identify a contact name and method that the DDoS Response Team can proactively engage when a Route 53 Health Check that is associated with a Shield protected resource fails.

## 3.140.2 - 2020-06-05

* `Aws\APIGateway` - Amazon API Gateway now allows customers of REST APIs to skip trust chain validation for backend server certificates for HTTP and VPC Link Integration. This feature enables customers to configure their REST APIs to integrate with backends that are secured with certificates vended from private certificate authorities (CA) or certificates that are self-signed.
* `Aws\CloudFront` - Amazon CloudFront adds support for configurable origin connection attempts and origin connection timeout.
* `Aws\ElasticBeanstalk` - These API changes enable an IAM user to associate an operations role with an Elastic Beanstalk environment, so that the IAM user can call Elastic Beanstalk actions without having access to underlying downstream AWS services that these actions call.
* `Aws\Personalize` - [Personalize] Adds ability to create and apply filters.
* `Aws\PersonalizeRuntime` - [Personalize] Adds ability to apply filter to real-time recommendations
* `Aws\Pinpoint` - This release enables additional functionality for the Amazon Pinpoint journeys feature. With this release, you can send messages through additional channels, including SMS, push notifications, and custom channels.
* `Aws\SageMakerRuntime` - You can now specify the production variant to send the inference request to, when invoking a SageMaker Endpoint that is running two or more variants.
* `Aws\ServiceCatalog` - This release adds support for DescribeProduct and DescribeProductAsAdmin by product name, DescribeProvisioningArtifact by product name or provisioning artifact name, returning launch paths as part of DescribeProduct output and adds maximum length for provisioning artifact name and provisioning artifact description.

## 3.140.1 - 2020-06-04

* `Aws\EC2` - New C5a instances, the latest generation of EC2's compute-optimized instances featuring AMD's 2nd Generation EPYC processors. C5a instances offer up to 96 vCPUs, 192 GiB of instance memory, 20 Gbps in Network bandwidth; New G4dn.metal bare metal instance with 8 NVIDIA T4 GPUs.
* `Aws\Lightsail` - This release adds the BurstCapacityPercentage and BurstCapacityTime instance metrics, which allow you to track the burst capacity available to your instance.
* `Aws\MarketplaceMetering` - Documentation updates for meteringmarketplace
* `Aws\MediaPackageVod` - You can now restrict direct access to AWS Elemental MediaPackage by securing requests for VOD content using CDN authorization. With CDN authorization, content requests require a specific HTTP header and authorization code.
* `Aws\SSM` - SSM State Manager support for executing an association only at specified CRON schedule after creating/updating an association.

## 3.140.0 - 2020-06-03

* `Aws\Build\Docs` - Tweak docs redirect logic to use uid if possible.
* `Aws\DirectConnect` - This release supports the virtual interface failover test, which allows you to verify that traffic routes over redundant virtual interfaces when you bring your primary virtual interface out of service.
* `Aws\ElastiCache` - This release improves the Multi-AZ feature in ElastiCache by adding a separate flag and proper validations.
* `Aws\ElasticsearchService` - Amazon Elasticsearch Service now offers support for cross-cluster search, enabling you to perform searches, aggregations, and visualizations across multiple Amazon Elasticsearch Service domains with a single query or from a single Kibana interface. New feature includes the ability to setup connection, required to perform cross-cluster search, between domains using an approval workflow.
* `Aws\Glue` - Adding databaseName in the response for GetUserDefinedFunctions() API.
* `Aws\IAM` - GenerateServiceLastAccessedDetails will now return ActionLastAccessed details for certain S3 control plane actions
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for the encoding of VP8 or VP9 video in WebM container with Vorbis or Opus audio.
* `Aws\S3` - Modified Content-MD5 checksum logic to use modeled httpChecksumRequired trait instead of a hard-coded list of operations.

## 3.139.1 - 2020-06-02

* `Aws\GuardDuty` - Amazon GuardDuty findings now include S3 bucket details under the resource section if an S3 Bucket was one of the affected resources

## 3.139.0 - 2020-06-01

* `Aws\Athena` - This release adds support for connecting Athena to your own Apache Hive Metastores in addition to the AWS Glue Data Catalog. For more information, please see https://docs.aws.amazon.com/athena/latest/ug/connect-to-data-source-hive.html
* `Aws\EMR` - Amazon EMR now supports encrypting log files with AWS Key Management Service (KMS) customer managed keys.
* `Aws\EndpointDiscovery` - Endpoint discovery behavior is modified to be enabled by default if any operation in a service requires it. Disabling endpoint discovery in configuration will disable it even for required operations.
* `Aws\FSx` - New capabilities to update storage capacity and throughput capacity of your file systems, providing the flexibility to grow file storage and to scale up or down the available performance as needed to meet evolving storage needs over time.
* `Aws\KMS` - AWS Key Management Service (AWS KMS): If the GenerateDataKeyPair or GenerateDataKeyPairWithoutPlaintext APIs are called on a CMK in a custom key store (origin == AWS_CLOUDHSM), they return an UnsupportedOperationException. If a call to UpdateAlias causes a customer to exceed the Alias resource quota, the UpdateAlias API returns a LimitExceededException.
* `Aws\SageMaker` - We are releasing HumanTaskUiArn as a new parameter in CreateLabelingJob and RenderUiTemplate which can take an ARN for a system managed UI to render a task. 
* `Aws\WorkLink` - Amazon WorkLink now supports resource tagging for fleets.

## 3.138.10 - 2020-05-28

* `Aws\Kafka` - New APIs for upgrading the Apache Kafka version of a cluster and to find out compatible upgrade paths
* `Aws\MarketplaceCatalog` - AWS Marketplace Catalog now supports accessing initial change payloads with DescribeChangeSet operation.
* `Aws\QLDBSession` - Documentation updates for Amazon QLDB Session
* `Aws\WorkMail` - This release adds support for Amazon WorkMail organization-level retention policies.

## 3.138.9 - 2020-05-27

* `Aws\ElasticLoadBalancingv2` - This release added support for HTTP/2 ALPN preference lists for Network Load Balancers
* `Aws\GuardDuty` - Documentation updates for GuardDuty
* `Aws\build/packager` - Adds package symfony/polyfill-intl-idn to .zip and .phar releases if the package exists in vendor directory.

## 3.138.8 - 2020-05-26

* `Aws\DLM` - Allowing cron expression in the DLM policy creation schedule. 
* `Aws\EC2` - ebsOptimizedInfo, efaSupported and supportedVirtualizationTypes added to DescribeInstanceTypes API
* `Aws\ElastiCache` - Amazon ElastiCache now allows you to use resource based policies to manage access to operations performed on ElastiCache resources. Also, Amazon ElastiCache now exposes ARN (Amazon Resource Names) for ElastiCache resources such as Cache Clusters and Parameter Groups. ARNs can be used to apply IAM policies to ElastiCache resources.
* `Aws\Macie` - This is a documentation-only update to the Amazon Macie Classic API. This update corrects out-of-date references to the service name.
* `Aws\QuickSight` - Add DataSetArns to QuickSight DescribeDashboard API response.
* `Aws\SSM` - The AWS Systems Manager GetOpsSummary API action now supports multiple OpsResultAttributes in the request. Currently, this feature only supports OpsResultAttributes with the following TypeNames: [AWS:EC2InstanceComputeOptimizer] or [AWS:EC2InstanceInformation, AWS:EC2InstanceComputeOptimizer]. These TypeNames can be used along with either or both of the following: [AWS:EC2InstanceRecommendation, AWS:RecommendationSource]

## 3.138.7 - 2020-05-22

* `Aws\AutoScaling` - Documentation updates for Amazon EC2 Auto Scaling
* `Aws\IoTSiteWise` - This release adds support for the standard deviation auto-computed aggregate and improved support for portal logo images in SiteWise.

## 3.138.6 - 2020-05-21

* `Aws\CodeBuild` - CodeBuild adds support for tagging with report groups
* `Aws\EC2` - From this release onwards ProvisionByoipCidr publicly supports IPv6. Updated ProvisionByoipCidr API to support tags for public IPv4 and IPv6 pools. Added NetworkBorderGroup to the DescribePublicIpv4Pools response.
* `Aws\S3` - Deprecates unusable input members bound to Content-MD5 header. Updates example and documentation.
* `Aws\Synthetics` - AWS CloudWatch Synthetics now supports configuration of allocated memory for a canary.

## 3.138.5 - 2020-05-20

* `Aws\AppMesh` - List APIs for all resources now contain additional information: when a resource was created, last updated, and its current version number.
* `Aws\ApplicationAutoScaling` - Documentation updates for Application Auto Scaling
* `Aws\Backup` - This release allows customers to enable or disable AWS Backup support for an AWS resource type. This release also includes new APIs, update-region-settings and describe-region-settings, which can be used to opt in to a specific resource type. For all current AWS Backup customers, the default settings enable support for EBS, EC2, StorageGateway, EFS, DDB and RDS resource types. 
* `Aws\Chime` - Amazon Chime enterprise account administrators can now set custom retention policies on chat data in the Amazon Chime application.
* `Aws\CodeDeploy` - Amazon ECS customers using application and network load balancers can use CodeDeploy BlueGreen hook to invoke a CloudFormation stack update. With this update you can view CloudFormation deployment and target details via existing APIs and use your stack Id to list or delete all deployments associated with the stack.
* `Aws\MediaLive` - AWS Elemental MediaLive now supports the ability to ingest the content that is streaming from an AWS Elemental Link device: https://aws.amazon.com/medialive/features/link/. This release also adds support for SMPTE-2038 and input state waiters.
* `Aws\S3` - Fixes incorrect host for dualstack and accelerate endpoints in non-AWS partitions.
* `Aws\SecurityHub` - For findings related to controls, the finding information now includes the reason behind the current status of the control. A new field for the findings original severity allows finding providers to use the severity values from the system they use to assign severity.
* `Aws\TranscribeStreamingService` - This release adds support for vocabulary filtering in streaming with which you can filter unwanted words from the real-time transcription results. Visit https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html to learn more.

## 3.138.4 - 2020-05-19

* `Aws\Chime` - You can now receive Voice Connector call events through SNS or SQS.
* `Aws\EC2` - This release adds support for Federated Authentication via SAML-2.0 in AWS ClientVPN.
* `Aws\Health` - Feature: Health: AWS Health added a new field to differentiate Public events from Account-Specific events in the API request and response. Visit https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html to learn more.
* `Aws\TranscribeService` - Documentation updates for Amazon Transcribe.

## 3.138.3 - 2020-05-18

* `Aws\Chime` - Amazon Chime now supports redacting chat messages.
* `Aws\DynamoDB` - Documentation updates for dynamodb 
* `Aws\EC2` - This release changes the RunInstances CLI and SDK's so that if you do not specify a client token, a randomly generated token is used for the request to ensure idempotency.
* `Aws\ECS` - This release adds support for specifying environment files to add environment variables to your containers.
* `Aws\Macie2` - Documentation updates for Amazon Macie
* `Aws\QLDB` - Amazon QLDB now supports Amazon Kinesis data streams. You can now emit QLDB journal data, via the new QLDB Streams feature, directly to Amazon Kinesis supporting event processing and analytics among related use cases.

## 3.138.2 - 2020-05-15

* `Aws\CloudFormation` - This release adds support for the following features: 1. DescribeType and ListTypeVersions APIs now output a field IsDefaultVersion, indicating if a version is the default version for its type; 2. Add StackRollbackComplete waiter feature to wait until stack status is UPDATE_ROLLBACK_COMPLETE; 3. Add paginators in DescribeAccountLimits, ListChangeSets, ListStackInstances, ListStackSetOperationResults, ListStackSetOperations, ListStackSets APIs.
* `Aws\ECR` - This release adds support for specifying an image manifest media type when pushing a manifest to Amazon ECR.
* `Aws\Glue` - Starting today, you can stop the execution of Glue workflows that are running. AWS Glue workflows are directed acyclic graphs (DAGs) of Glue triggers, crawlers and jobs. Using a workflow, you can design a complex multi-job extract, transform, and load (ETL) activity that AWS Glue can execute and track as single entity. 
* `Aws\STS` - API updates for STS

## 3.138.1 - 2020-05-14

* `Aws\EC2` - Amazon EC2 now supports adding AWS resource tags for associations between VPCs and local gateways, at creation time.
* `Aws\imagebuilder` - This release adds a new parameter (SupportedOsVersions) to the Components API. This parameter lists the OS versions supported by a component.

## 3.138.0 - 2020-05-13

* `Aws\ElastiCache` - Amazon ElastiCache now supports auto-update of ElastiCache clusters after the "recommended apply by date" of service update has passed. ElastiCache will use your maintenance window to schedule the auto-update of applicable clusters. For more information, see https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/Self-Service-Updates.html and https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Self-Service-Updates.html
* `Aws\Macie2` - This release introduces a new major version of the Amazon Macie API. You can use this version of the API to develop tools and applications that interact with the new Amazon Macie.

## 3.137.8 - 2020-05-12

* `Aws\IoTSiteWise` - Documentation updates for iot-bifrost
* `Aws\WorkMail` - Minor API fixes and updates to the documentation.

## 3.137.7 - 2020-05-11

* `Aws\CodeGuruReviewer` - Add Bitbucket integration APIs
* `Aws\EC2` - M6g instances are our next-generation general purpose instances powered by AWS Graviton2 processors
* `Aws\kendra` - Amazon Kendra is now generally available. As part of general availability, we are launching * Developer edition * Ability to scale your Amazon Kendra index with capacity units * Support for new connectors * Support for new tagging API's * Support for Deleting data source * Metrics for data source sync operations * Metrics for query & storage utilization

## 3.137.6 - 2020-05-08

* `Aws\GuardDuty` - Documentation updates for GuardDuty
* `Aws\ResourceGroupsTaggingAPI` - Documentation updates for resourcegroupstaggingapi
* `Aws\SageMaker` - This release adds a new parameter (EnableInterContainerTrafficEncryption) to CreateProcessingJob API to allow for enabling inter-container traffic encryption on processing jobs.

## 3.137.5 - 2020-05-07

* `Aws\AppConfig` - The description of the AWS AppConfig GetConfiguration API action was amended to include important information about calling ClientConfigurationVersion when you configure clients to call GetConfiguration.
* `Aws\CloudWatchLogs` - Amazon CloudWatch Logs now offers the ability to interact with Logs Insights queries via the new PutQueryDefinition, DescribeQueryDefinitions, and DeleteQueryDefinition APIs.
* `Aws\CodeBuild` - Add COMMIT_MESSAGE enum for webhook filter types
* `Aws\EC2` - Amazon EC2 now adds warnings to identify issues when creating a launch template or launch template version.
* `Aws\Lightsail` - This release adds support for the following options in instance public ports: Specify source IP addresses, specify ICMP protocol like PING, and enable/disable the Lightsail browser-based SSH and RDP clients' access to your instance.
* `Aws\Route53` - Amazon Route 53 now supports the EU (Milan) Region (eu-south-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `Aws\SSM` - This Patch Manager release supports creating patch baselines for Oracle Linux and Debian

## 3.137.4 - 2020-05-06

* `Aws\CodeStarconnections` - Added support for tagging resources in AWS CodeStar Connections
* `Aws\ComprehendMedical` - New Batch Ontology APIs for ICD-10 and RxNorm will provide batch capability of linking the information extracted by Comprehend Medical to medical ontologies. The new ontology linking APIs make it easy to detect medications and medical conditions in unstructured clinical text and link them to RxNorm and ICD-10-CM codes respectively. This new feature can help you reduce the cost, time and effort of processing large amounts of unstructured medical text with high accuracy.

## 3.137.3 - 2020-05-05

* `Aws\EC2` - With this release, you can call ModifySubnetAttribute with two new parameters: MapCustomerOwnedIpOnLaunch and CustomerOwnedIpv4Pool, to map a customerOwnedIpv4Pool to a subnet. You will also see these two new fields in the DescribeSubnets response. If your subnet has a customerOwnedIpv4Pool mapped, your network interface will get an auto assigned customerOwnedIpv4 address when placed onto an instance.
* `Aws\SSM` - AWS Systems Manager Parameter Store launches new data type to support aliases in EC2 APIs
* `Aws\Support` - Documentation updates for support

## 3.137.2 - 2020-05-04

* `Aws\APIGateway` - Documentation updates for Amazon API Gateway
* `Aws\EC2` - With this release, you can include enriched metadata in Amazon Virtual Private Cloud (Amazon VPC) flow logs published to Amazon CloudWatch Logs or Amazon Simple Storage Service (S3). Prior to this, custom format VPC flow logs enriched with additional metadata could be published only to S3. With this launch, we are also adding additional metadata fields that provide insights about the location such as AWS Region, AWS Availability Zone, AWS Local Zone, AWS Wavelength Zone, or AWS Outpost where the network interface where flow logs are captured exists. 
* `Aws\S3Control` - Amazon S3 Batch Operations now supports Object Lock.

## 3.137.1 - 2020-05-01

* `Aws\EFS` - Change the TagKeys argument for UntagResource to a URL parameter to address an issue with the Java and .NET SDKs.
* `Aws\SSM` - Added TimeoutSeconds as part of ListCommands API response.

## 3.137.0 - 2020-04-30

* `Aws\IoT` - AWS IoT Core released Fleet Provisioning for scalable onboarding of IoT devices to the cloud. This release includes support for customer's Lambda functions to validate devices during onboarding. Fleet Provisioning also allows devices to send Certificate Signing Requests (CSR) to AWS IoT Core for signing and getting a unique certificate. Lastly, AWS IoT Core added a feature to register the same certificate for multiple accounts in the same region without needing to register the certificate authority (CA).
* `Aws\IoTEvents` - Doc only update to correct APIs and related descriptions
* `Aws\Lambda` - Documentation updates for Lambda
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for including AFD signaling in MXF wrapper.
* `Aws\S3` - Adds change to S3 parsing logic to correctly interpret certain 200 responses with a functionally empty body as connection errors.
* `Aws\Schemas` - Add support for resource policies for Amazon EventBridge Schema Registry, which is now generally available.
* `Aws\StorageGateway` - Adding support for S3_INTELLIGENT_TIERING as a storage class option

## 3.136.0 - 2020-04-29

* `Aws\IoTSiteWise` - AWS IoT SiteWise is a managed service that makes it easy to collect, store, organize and monitor data from industrial equipment at scale. You can use AWS IoT SiteWise to model your physical assets, processes and facilities, quickly compute common industrial performance metrics, and create fully managed web applications to help analyze industrial equipment data, prevent costly equipment issues, and reduce production inefficiencies.
* `Aws\ServiceDiscovery` - Documentation updates for servicediscovery
* `Aws\TranscribeService` - With this release, you can now use Amazon Transcribe to create medical custom vocabularies and use them in both medical real-time streaming and medical batch transcription jobs.
* `Aws\WAF` - This release add migration API for AWS WAF Classic ("waf" and "waf-regional"). The migration API will parse through your web ACL and generate a CloudFormation template into your S3 bucket. Deploying this template will create equivalent web ACL under new AWS WAF ("wafv2").
* `Aws\WAFRegional` - This release add migration API for AWS WAF Classic ("waf" and "waf-regional"). The migration API will parse through your web ACL and generate a CloudFormation template into your S3 bucket. Deploying this template will create equivalent web ACL under new AWS WAF ("wafv2").

## 3.135.6 - 2020-04-28

* `Aws\ECR` - This release adds support for multi-architecture images also known as a manifest list
* `Aws\KinesisVideo` - Add "GET_CLIP" to the list of supported API names for the GetDataEndpoint API.
* `Aws\KinesisVideoArchivedMedia` - Add support for the GetClip API for retrieving media from a video stream in the MP4 format.
* `Aws\MediaLive` - AWS Elemental MediaLive now supports several new features: enhanced VQ for H.264 (AVC) output encodes; passthrough of timed metadata and of Nielsen ID3 metadata in fMP4 containers in HLS outputs; the ability to generate a SCTE-35 sparse track without additional segmentation, in Microsoft Smooth outputs; the ability to select the audio from a TS input by specifying the audio track; and conversion of HDR colorspace in the input to an SDR colorspace in the output.
* `Aws\Route53` - Amazon Route 53 now supports the Africa (Cape Town) Region (af-south-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.
* `Aws\SSM` - SSM State Manager support for adding list association filter for Resource Group and manual mode of managing compliance for an association. 

## 3.135.5 - 2020-04-27

* `Aws\AccessAnalyzer` - This release adds support for inclusion of S3 Access Point policies in IAM Access Analyzer evaluation of S3 bucket access. IAM Access Analyzer now reports findings for buckets shared through access points and identifies the access point that permits access.
* `Aws\DataExchange` - This release introduces AWS Data Exchange support for configurable encryption parameters when exporting data sets to Amazon S3. 
* `Aws\DatabaseMigrationService` - Adding minimum replication engine version for describe-endpoint-types api.
* `Aws\SageMaker` - Change to the input, ResourceSpec, changing EnvironmentArn to SageMakerImageArn. This affects the following preview APIs: CreateDomain, DescribeDomain, UpdateDomain, CreateUserProfile, DescribeUserProfile, UpdateUserProfile, CreateApp and DescribeApp.

## 3.135.4 - 2020-04-24

* `Aws\DLM` - Enable 1hour frequency in the schedule creation for Data LifeCycle Manager.
* `Aws\ElasticInference` - This feature allows customers to describe the accelerator types and offerings on any region where Elastic Inference is available.
* `Aws\IoT` - This release adds a new exception type to the AWS IoT SetV2LoggingLevel API.

## 3.135.3 - 2020-04-23

* `Aws\ApplicationAutoScaling` - This release supports Auto Scaling in Amazon Keyspaces for Apache Cassandra.
* `Aws\Endpoint` - Fix for partition endpoint history logic for keys with hyphens.
* `Aws\Firehose` - You can now deliver streaming data to an Amazon Elasticsearch Service domain in an Amazon VPC. You can now compress streaming data delivered to S3 using Hadoop-Snappy in addition to Gzip, Zip and Snappy formats.
* `Aws\MediaPackageVod` - Adds tagging support for PackagingGroups, PackagingConfigurations, and Assets
* `Aws\Pinpoint` - This release of the Amazon Pinpoint API enhances support for sending campaigns through custom channels to locations such as AWS Lambda functions or web applications. Campaigns can now use CustomDeliveryConfiguration and CampaignCustomMessage to configure custom channel settings for a campaign.
* `Aws\RAM` - AWS Resource Access Manager (RAM) provides a new ListResourceTypes action. This action lets you list the resource types that can be shared using AWS RAM.
* `Aws\RDS` - Adds support for AWS Local Zones, including a new optional parameter AvailabilityZoneGroup for the DescribeOrderableDBInstanceOptions operation.
* `Aws\StorageGateway` - Added AutomaticTapeCreation APIs
* `Aws\Transfer` - This release adds support for transfers over FTPS and FTP in and out of Amazon S3, which makes it easy to migrate File Transfer Protocol over SSL (FTPS) and FTP workloads to AWS, in addition to the existing support for Secure File Transfer Protocol (SFTP).

## 3.135.2 - 2020-04-22

* `Aws\CodeGuruReviewer` - Add support for code review and recommendation feedback APIs.
* `Aws\ElasticsearchService` - This change adds a new field 'OptionalDeployment' to ServiceSoftwareOptions to indicate whether a service software update is optional or mandatory. If True, it indicates that the update is optional, and the service software is not automatically updated. If False, the service software is automatically updated after AutomatedUpdateDate.
* `Aws\FMS` - This release is to support AWS Firewall Manager policy with Organizational Unit scope. 
* `Aws\Redshift` - Amazon Redshift support for usage limits
* `Aws\TranscribeStreamingService` - Adding ServiceUnavailableException as one of the expected exceptions

## 3.135.1 - 2020-04-21

* `Aws\CostExplorer` - Cost Explorer Rightsizing Recommendations integrates with Compute Optimizer and begins offering across instance family rightsizing recommendations, adding to existing support for within instance family rightsizing recommendations. 
* `Aws\EMR` - Amazon EMR adds support for configuring a managed scaling policy for an Amazon EMR cluster. This enables automatic resizing of a cluster to optimize for job execution speed and reduced cluster cost.
* `Aws\GuardDuty` - AWS GuardDuty now supports using AWS Organizations delegated administrators to create and manage GuardDuty master and member accounts. The feature also allows GuardDuty to be automatically enabled on associated organization accounts.
* `Aws\Route53Domains` - You can now programmatically transfer domains between AWS accounts without having to contact AWS Support

## 3.135.0 - 2020-04-20

* `Aws\ApiGatewayV2` - You can now export an OpenAPI 3.0 compliant API definition file for Amazon API Gateway HTTP APIs using the Export API.
* `Aws\CostExplorer` - Cost Categories API is now General Available with new dimensions and operations support. You can map costs by account name, service, and charge type dimensions as well as use contains, starts with, and ends with operations. Cost Categories can also be used in RI and SP coverage reports.
* `Aws\Glue` - Added a new ConnectionType "KAFKA" and a ConnectionProperty "KAFKA_BOOTSTRAP_SERVERS" to support Kafka connection.
* `Aws\IoTEvents` - API update that allows users to add AWS Iot SiteWise actions while creating Detector Model in AWS Iot Events
* `Aws\Synthetics` - Introducing CloudWatch Synthetics. This is the first public release of CloudWatch Synthetics.

## 3.134.8 - 2020-04-17

* `Aws\FraudDetector` - Added support for a new rule engine execution mode. Customers will be able to configure their detector versions to evaluate all rules and return outcomes from all 'matched' rules in the GetPrediction API response. Added support for deleting Detectors (DeleteDetector) and Rule Versions (DeleteRuleVersion).
* `Aws\OpsWorksCM` - Documentation updates for opsworkscm

## 3.134.7 - 2020-04-16

* `Aws\AugmentedAIRuntime` - This release updates Amazon Augmented AI ListHumanLoops and StartHumanLoop APIs.
* `Aws\EC2` - Amazon EC2 now supports adding AWS resource tags for placement groups and key pairs, at creation time. The CreatePlacementGroup API will now return placement group information when created successfully. The DeleteKeyPair API now supports deletion by resource ID.
* `Aws\Glue` - This release adds support for querying GetUserDefinedFunctions API without databaseName.
* `Aws\IoTEvents` - API update that allows users to customize event action payloads, and adds support for Amazon DynamoDB actions.
* `Aws\Lambda` - Sample code for AWS Lambda operations
* `Aws\MediaConvert` - AWS Elemental MediaConvert now allows you to specify your input captions frame rate for SCC captions sources.
* `Aws\MediaTailor` - AWS Elemental MediaTailor SDK now allows configuration of Avail Suppression.
* `Aws\MigrationHub` - Adding ThrottlingException
* `Aws\RDS` - This release adds support for Amazon RDS Proxy with PostgreSQL compatibility.
* `Aws\SageMaker` - Amazon SageMaker now supports running training jobs on ml.g4dn and ml.c5n instance types. Amazon SageMaker supports in "IN" operation for Search now.
* `Aws\SecurityHub` - Added a new BatchUpdateFindings action, which allows customers to update selected information about their findings. Security Hub customers use BatchUpdateFindings to track their investigation into a finding. BatchUpdateFindings is intended to replace the UpdateFindings action, which is deprecated.
* `Aws\Snowball` - An update to the Snowball Edge Storage Optimized device has been launched. Like the previous version, it has 80 TB of capacity for data transfer. Now it has 40 vCPUs, 80 GiB, and a 1 TiB SATA SSD of memory for EC2 compatible compute. The 80 TB of capacity can also be used for EBS-like volumes for AMIs.
* `Aws\imagebuilder` - This release includes support for additional OS Versions within EC2 Image Builder.

## 3.134.6 - 2020-04-08

* `Aws\Chime` - feature: Chime: This release introduces the ability to tag Amazon Chime SDK meeting resources. You can use tags to organize and identify your resources for cost allocation. 
* `Aws\CloudFormation` - The OrganizationalUnitIds parameter on StackSet and the OrganizationalUnitId parameter on StackInstance, StackInstanceSummary, and StackSetOperationResultSummary are now reserved for internal use. No data is returned for this parameter.
* `Aws\CodeGuruProfiler` - CodeGuruProfiler adds support for resource based authorization to submit profile data.
* `Aws\EC2` - This release provides the ability to include tags in EC2 event notifications. 
* `Aws\ECS` - This release provides native support for specifying Amazon EFS file systems as volumes in your Amazon ECS task definitions.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK adds support for queue hopping. Jobs can now hop from their original queue to a specified alternate queue, based on the maximum wait time that you specify in the job settings.
* `Aws\MigrationHubConfig` - Adding ThrottlingException

## 3.134.5 - 2020-04-07

* `Aws\APIGateway` - Documentation updates for Amazon API Gateway.
* `Aws\CodeGuruReviewer` - API updates for CodeGuruReviewer 
* `Aws\MediaConnect` - You can now send content from your MediaConnect flow to your virtual private cloud (VPC) without going over the public internet.

## 3.134.4 - 2020-04-06

* `Aws\Chime` - Amazon Chime proxy phone sessions let you provide two users with a shared phone number to communicate via voice or text for up to 12 hours without revealing personal phone numbers. When users call or message the provided phone number, they are connected to the other party and their private phone numbers are replaced with the shared number in Caller ID.
* `Aws\ElasticBeanstalk` - This release adds a new action, ListPlatformBranches, and updates two actions, ListPlatformVersions and DescribePlatformVersion, to support the concept of Elastic Beanstalk platform branches.
* `Aws\IAM` - Documentation updates for AWS Identity and Access Management (IAM).
* `Aws\TranscribeService` - This release adds support for batch transcription jobs within Amazon Transcribe Medical.

## 3.134.3 - 2020-04-03

* `Aws\PersonalizeRuntime` - Amazon Personalize: Add new response field "score" to each item returned by GetRecommendations and GetPersonalizedRanking (HRNN-based recipes only)
* `Aws\RoboMaker` - Added support for limiting simulation unit usage, giving more predictable control over simulation cost

## 3.134.2 - 2020-04-02

* `Aws\CloudWatch` - Amazon CloudWatch Contributor Insights adds support for tags and tagging on resource creation. 
* `Aws\GameLift` - Public preview of GameLift FleetIQ as a standalone feature. GameLift FleetIQ makes it possible to use low-cost Spot instances by limiting the chance of interruptions affecting game sessions. FleetIQ is a feature of the managed GameLift service, and can now be used with game hosting in EC2 Auto Scaling groups that you manage in your own account.
* `Aws\MediaLive` - AWS Elemental MediaLive now supports Automatic Input Failover. This feature provides resiliency upstream of the channel, before ingest starts.
* `Aws\RDS` - Documentation updates for RDS: creating read replicas is now supported for SQL Server DB instances
* `Aws\Redshift` - Documentation updates for redshift

## 3.134.1 - 2020-04-01

* `Aws\IoT` - This release introduces Dimensions for AWS IoT Device Defender. Dimensions can be used in Security Profiles to collect and monitor fine-grained metrics.
* `Aws\MediaConnect` - You can now send content from your virtual private cloud (VPC) to your MediaConnect flow without going over the public internet.

## 3.134.0 - 2020-03-31

* `Aws\` - Adds support for standard and adaptive retry modes. Standard mode adds a retry quota system, while the experimental adaptive mode adds a client-side rate limiting feature on top of standard mode.
* `Aws\AppConfig` - This release adds an event log to deployments. In the case of a deployment rollback, the event log details the rollback reason.
* `Aws\Detective` - Removing the notes that Detective is in preview, in preparation for the Detective GA release.
* `Aws\ElasticInference` - This release includes improvements for the Amazon Elastic Inference service.
* `Aws\FMS` - This release contains FMS wafv2 support.
* `Aws\Glue` - Add two enums for MongoDB connection: Added "CONNECTION_URL" to "ConnectionPropertyKey" and added "MONGODB" to "ConnectionType"
* `Aws\Lambda` - AWS Lambda now supports .NET Core 3.1
* `Aws\MediaStore` - This release adds support for CloudWatch Metrics. You can now set a policy on your container to dictate which metrics MediaStore sends to CloudWatch.
* `Aws\OpsWorksCM` - Documentation updates for OpsWorks-CM CreateServer values.
* `Aws\Organizations` - Documentation updates for AWS Organizations
* `Aws\Pinpoint` - This release of the Amazon Pinpoint API introduces MMS support for SMS messages.
* `Aws\Rekognition` - This release adds DeleteProject and DeleteProjectVersion APIs to Amazon Rekognition Custom Labels.
* `Aws\StorageGateway` - Adding audit logging support for SMB File Shares
* `Aws\WAFV2` - Added support for AWS Firewall Manager for WAFv2 and PermissionPolicy APIs for WAFv2.

## 3.133.47 - 2020-03-30

* `Aws\AccessAnalyzer` - This release adds support for the creation and management of IAM Access Analyzer analyzers with type organization. An analyzer with type organization continuously monitors all supported resources within the AWS organization and reports findings when they allow access from outside the organization.

## 3.133.46 - 2020-03-27

* `Aws\GlobalAccelerator` - This update adds an event history to the ListByoipCidr API call. This enables you to see the changes that you've made for an IP address range that you bring to AWS Global Accelerator through bring your own IP address (BYOIP).
* `Aws\ServiceCatalog` - Added "LocalRoleName" as an acceptable Parameter for Launch type in CreateConstraint and UpdateConstraint APIs
* `Aws\kendra` - The Amazon Kendra Microsoft SharePoint data source now supports include and exclude regular expressions and change log features. Include and exclude regular expressions enable you to provide a list of regular expressions to match the display URL of SharePoint documents to either include or exclude documents respectively. When you enable the changelog feature it enables Amazon Kendra to use the SharePoint change log to determine which documents to update in the index.

## 3.133.45 - 2020-03-26

* `Aws\FSx` - This release includes two changes: a new lower-cost, storage type called HDD (Hard Disk Drive), and a new generation of the Single-AZ deployment type called Single AZ 2. The HDD storage type can be selected on Multi AZ 1 and Single AZ 2 deployment types.
* `Aws\SageMaker` - This release updates Amazon Augmented AI CreateFlowDefinition API and DescribeFlowDefinition response.
* `Aws\SecurityHub` - Security Hub has now made it easier to opt out of default standards when you enable Security Hub. We added a new Boolean parameter to EnableSecurityHub called EnableDefaultStandards. If that parameter is true, Security Hub's default standards are enabled. A new Boolean parameter for standards, EnabledByDefault, indicates whether a standard is a default standard. Today, the only default standard is CIS AWS Foundations Benchmark v1.2. Additional default standards will be added in the future.To learn more, visit our documentation on the EnableSecurityHub API action.

## 3.133.44 - 2020-03-25

* `Aws\ApplicationInsights` - Amazon CloudWatch Application Insights for .NET and SQL Server now integrates with Amazon CloudWatch Events (AWS CodeDeploy, AWS Health and Amazon EC2 state changes). This feature enables customers to view events related to problems detected by CloudWatch Application Insights, and reduce mean-time-to-resolution (MTTR).
* `Aws\CostExplorer` - Customers can now receive Savings Plans recommendations at the member (linked) account level.
* `Aws\Detective` - The new ACCEPTED_BUT_DISABLED member account status indicates that a member account that accepted the invitation is blocked from contributing data to the behavior graph. The reason is provided in the new DISABLED_REASON property. The new StartMonitoringMember operation enables a blocked member account.
* `Aws\ElasticsearchService` - Adding support for customer packages (dictionary files) to Amazon Elasticsearch Service
* `Aws\ManagedBlockchain` - Amazon Managed Blockchain now has support to publish Hyperledger Fabric peer node, chaincode, and certificate authority (CA) logs to Amazon CloudWatch Logs.
* `Aws\XRay` - GetTraceSummaries - Now provides additional root cause attribute ClientImpacting which indicates whether root cause impacted trace client.

## 3.133.43 - 2020-03-24

* `Aws\Athena` - Documentation updates for Athena, including QueryExecutionStatus QUEUED and RUNNING states. QUEUED now indicates that the query has been submitted to the service. RUNNING indicates that the query is in execution phase.
* `Aws\EKS` - Adding new error codes: Ec2SubnetInvalidConfiguration and NodeCreationFailure for Nodegroups in EKS
* `Aws\Organizations` - Introduces actions for giving a member account administrative Organizations permissions for an AWS service. You can run this action only for AWS services that support this feature.
* `Aws\RDSDataService` - Documentation updates for rds-data

## 3.133.42 - 2020-03-23

* `Aws\ApiGatewayV2` - Documentation updates to reflect that the default timeout for integrations is now 30 seconds for HTTP APIs.
* `Aws\EKS` - Adding new error code IamLimitExceeded for Nodegroups in EKS
* `Aws\Route53` - Documentation updates for Route 53.

## 3.133.41 - 2020-03-20

* `Aws\ServiceCatalog` - Added "productId" and "portfolioId" to responses from CreateConstraint, UpdateConstraint, ListConstraintsForPortfolio, and DescribeConstraint APIs

## 3.133.40 - 2020-03-19

* `Aws\ACM` - AWS Certificate Manager documentation updated on API calls ImportCertificate and ListCertificate. Specific updates included input constraints, private key size for import and next token size for list.
* `Aws\Outposts` - Documentation updates for AWS Outposts.

## 3.133.39 - 2020-03-18

* `Aws\MediaConnect` - Feature adds the ability for a flow to have multiple redundant sources that provides resiliency to a source failing. The new APIs added to enable the feature are, AddFlowSources, RemoveFlowSource and UpdateFlow.
* `Aws\Personalize` - [Personalize] Adds support for returning hyperparameter values of the best performing model in a HPO job.
* `Aws\RDS` - Updated the MaxRecords type in DescribeExportTasks to Integer.

## 3.133.38 - 2020-03-17

* `Aws\Crypto` - This release fixes a discrepancy between the Encryption/Decryption trait implementations and AbstractCryptoClient method signature.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for: AV1 encoding in File Group MP4, DASH and CMAF DASH outputs; PCM/WAV audio output in MPEG2-TS containers; and Opus audio in Webm inputs.

## 3.133.37 - 2020-03-16

* `Aws\CognitoIdentityProvider` - Additional response field "CompromisedCredentialsDetected" added to AdminListUserAuthEvents.
* `Aws\ECS` - This release adds the ability to update the task placement strategy and constraints for Amazon ECS services.
* `Aws\ElastiCache` - Amazon ElastiCache now supports Global Datastore for Redis. Global Datastore for Redis offers fully managed, fast, reliable and secure cross-region replication. Using Global Datastore for Redis, you can create cross-region read replica clusters for ElastiCache for Redis to enable low-latency reads and disaster recovery across regions. You can create, modify and describe a Global Datastore, as well as add or remove regions from your Global Datastore and promote a region as primary in Global Datastore.
* `Aws\S3Control` - Amazon S3 now supports Batch Operations job tagging.
* `Aws\SSM` - Resource data sync for AWS Systems Manager Inventory now includes destination data sharing. This feature enables you to synchronize inventory data from multiple AWS accounts into a central Amazon S3 bucket. To use this feature, all AWS accounts must be listed in AWS Organizations.

## 3.133.36 - 2020-03-13

* `Aws\AppConfig` - This release adds S3 as a configuration source provider.

## 3.133.35 - 2020-03-12

* `Aws\ApiGatewayV2` - Amazon API Gateway HTTP APIs is now generally available. HTTP APIs offer the core functionality of REST API at up to 71% lower price compared to REST API, 60% lower p99 latency, and is significantly easier to use. As part of general availability, we added new features to route requests to private backends such as private ALBs, NLBs, and IP/ports. We also brought over a set of features from REST API such as Stage Variables, and Stage/Route level throttling. Custom domain names can also now be used with both REST And HTTP APIs.
* `Aws\EC2` - Documentation updates for EC2
* `Aws\IoT` - As part of this release, we are extending capability of AWS IoT Rules Engine to support IoT Cloudwatch log action. The IoT Cloudwatch log rule action lets you send messages from IoT sensors and applications to Cloudwatch logs for troubleshooting and debugging.
* `Aws\LexModelBuildingService` - Amazon Lex now supports tagging for bots, bot aliases and bot channels. 
* `Aws\SecurityHub` - The AWS Security Finding Format is being augmented with the following changes. 21 new resource types without corresponding details objects are added. Another new resource type, AwsS3Object, has an accompanying details object. Severity.Label is a new string field that indicates the severity of a finding. The available values are: INFORMATIONAL, LOW, MEDIUM, HIGH, CRITICAL. The new string field Workflow.Status indicates the status of the investigation into a finding. The available values are: NEW, NOTIFIED, RESOLVED, SUPPRESSED.

## 3.133.34 - 2020-03-11

* `Aws\EFS` - Documentation updates for elasticfilesystem
* `Aws\Redshift` - Amazon Redshift now supports operations to pause and resume a cluster on demand or on a schedule.

## 3.133.33 - 2020-03-10

* `Aws\EC2` - Documentation updates for EC2
* `Aws\IoTEvents` - API update that adds a new parameter, durationExpression, to SetTimerAction, and deprecates seconds
* `Aws\MarketplaceCommerceAnalytics` - Change the disbursement data set to look past 31 days instead until the beginning of the month.
* `Aws\ServerlessApplicationRepository` - AWS Serverless Application Repository now supports sharing applications privately with AWS Organizations.
* `Aws\TranscribeService` - Amazon Transcribe's Automatic Content Redaction feature enables you to automatically redact sensitive personally identifiable information (PII) from transcription results. It replaces each instance of an identified PII utterance with a [PII] tag in the transcript.

## 3.133.32 - 2020-03-09

* `Aws\DatabaseMigrationService` - Added new settings for Kinesis target to include detailed transaction info; to capture table DDL details; to use single-line unformatted json, which can be directly queried by AWS Athena if data is streamed into S3 through AWS Kinesis Firehose. Added CdcInsertsAndUpdates in S3 target settings to allow capture ongoing insertions and updates only.
* `Aws\EC2` - Amazon Virtual Private Cloud (VPC) NAT Gateway adds support for tagging on resource creation.
* `Aws\MediaLive` - AWS Elemental MediaLive now supports the ability to configure the Preferred Channel Pipeline for channels contributing to a Multiplex.

## 3.133.31 - 2020-03-06

* `Aws\AppMesh` - App Mesh now supports sharing a Mesh with other AWS accounts. Customers can use AWS Resource Access Manager to share their Mesh with other accounts in their organization to connection applications within a single service mesh. See https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html for details.
* `Aws\EC2` - This release provides customers with a self-service option to enable Local Zones.
* `Aws\GuardDuty` - Amazon GuardDuty findings now include the OutpostArn if the finding is generated for an AWS Outposts EC2 host.
* `Aws\RoboMaker` - Added support for streaming a GUI from robot and simulation applications
* `Aws\signer` - This release enables signing image format override in PutSigningProfile requests, adding two more enum fields, JSONEmbedded and JSONDetached. This release also extends the length limit of SigningProfile name from 20 to 64.

## 3.133.30 - 2020-03-05

* `Aws\EC2` - You can now create AWS Client VPN Endpoints with a specified VPC and Security Group. Additionally, you can modify these attributes when modifying the endpoint. 
* `Aws\EKS` - Amazon EKS now supports adding a KMS key to your cluster for envelope encryption of Kubernetes secrets.
* `Aws\GuardDuty` - Add a new finding field for EC2 findings indicating the instance's local IP address involved in the threat.
* `Aws\OpsWorksCM` - Updated the Tag regex pattern to align with AWS tagging APIs.

## 3.133.29 - 2020-03-04

* `Aws\Build` - Add custom retry handling for github release artifact uploads to handle github API quirks.
* `Aws\Pinpoint` - This release of the Amazon Pinpoint API introduces support for integrating recommender models with email, push notification, and SMS message templates. You can now use these types of templates to connect to recommender models and add personalized recommendations to messages that you send from campaigns and journeys.

## 3.133.28 - 2020-03-03

* `Aws\EC2` - Amazon VPC Flow Logs adds support for tags and tagging on resource creation.

## 3.133.27 - 2020-03-02

* `Aws\CloudWatch` - Introducing Amazon CloudWatch Composite Alarms
* `Aws\ComprehendMedical` - New Time Expression feature, part of DetectEntitiesV2 API will provide temporal relations to existing NERe entities such as Medication, Test, Treatment, Procedure and Medical conditions. 

## 3.133.26 - 2020-02-29

* `Aws\ConfigService` - Correcting list of supported resource types.

## 3.133.25 - 2020-02-28

* `Aws\AccessAnalyzer` - This release includes improvements and fixes bugs for the IAM Access Analyzer feature.
* `Aws\AppMesh` - App Mesh now supports Transport Layer Security (TLS) between Virtual Nodes in a Mesh. Customers can use managed certificates from an AWS Certificate Manager Private Certificate Authority or bring their own certificates from the local file system to encrypt traffic between their workloads. See https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual-node-tls.html for details.
* `Aws\AugmentedAIRuntime` - This release updates Amazon Augmented AI ListHumanLoops API, DescribeHumanLoop response, StartHumanLoop response and type names of SDK fields. 
* `Aws\CodeGuruProfiler` - Documentation updates for Amazon CodeGuru Profiler
* `Aws\ConfigService` - Accepts a structured query language (SQL) SELECT command and an aggregator name, performs the corresponding search on resources aggregated by the aggregator, and returns resource configurations matching the properties.
* `Aws\ElasticLoadBalancingv2` - Added a target group attribute to support sticky sessions for Network Load Balancers.
* `Aws\Glue` - AWS Glue adds resource tagging support for Machine Learning Transforms and adds a new API, ListMLTransforms to support tag filtering. With this feature, customers can use tags in AWS Glue to organize and control access to Machine Learning Transforms. 
* `Aws\QuickSight` - Added SearchDashboards API that allows listing of dashboards that a specific user has access to.
* `Aws\WorkDocs` - Documentation updates for workdocs

## 3.133.24 - 2020-02-27

* `Aws\GlobalAccelerator` - This release adds support for adding tags to accelerators and bringing your own IP address to AWS Global Accelerator (BYOIP).
* `Aws\Lightsail` - Adds support to create notification contacts in Amazon Lightsail, and to create instance, database, and load balancer metric alarms that notify you based on the value of a metric relative to a threshold that you specify.

## 3.133.23 - 2020-02-26

* `Aws\EC2` - This release changes the RunInstances CLI and SDK's so that if you do not specify a client token, a randomly generated token is used for the request to ensure idempotency.
* `Aws\SageMaker` - SageMaker UpdateEndpoint API now supports retained variant properties, e.g., instance count, variant weight. SageMaker ListTrials API filter by TrialComponentName. Make ExperimentConfig name length limits consistent with CreateExperiment, CreateTrial, and CreateTrialComponent APIs.
* `Aws\SecurityHub` - Security Hub has added to the DescribeProducts API operation a new response field called IntegrationTypes. The IntegrationTypes field lists the types of actions that a product performs relative to Security Hub such as send findings to Security Hub and receive findings from Security Hub.
* `Aws\TranscribeService` - Amazon Transcribe's Automatic Content Redaction feature enables you to automatically redact sensitive personally identifiable information (PII) from transcription results. It replaces each instance of an identified PII utterance with a [PII] tag in the transcript.

## 3.133.22 - 2020-02-25

* `Aws\Kafka` - Amazon MSK has added support for Broker Log delivery to CloudWatch, S3, and Firehose.
* `Aws\Outposts` - This release adds DeleteSite and DeleteOutpost. 
* `Aws\SFN` - This release adds support for CloudWatch Logs for Standard Workflows.
* `Aws\SecretsManager` - This release increases the maximum allowed size of SecretString or SecretBinary from 10KB to 64KB in the CreateSecret, UpdateSecret, PutSecretValue and GetSecretValue APIs.

## 3.133.21 - 2020-02-24

* `Aws\CloudWatchEvents` - This release allows you to create and manage tags for event buses.
* `Aws\DocDB` - Documentation updates for docdb
* `Aws\EventBridge` - This release allows you to create and manage tags for event buses.
* `Aws\FSx` - Announcing persistent file systems for Amazon FSx for Lustre that are ideal for longer-term storage and workloads, and a new generation of scratch file systems that offer higher burst throughput for spiky workloads.
* `Aws\IoTEvents` - Documentation updates for iotcolumbo
* `Aws\Snowball` - AWS Snowball adds a field for entering your GSTIN when creating AWS Snowball jobs in the Asia Pacific (Mumbai) region. 

## 3.133.20 - 2020-02-21

* `Aws\Redshift` - Extend elastic resize to support resizing clusters to different instance types.
* `Aws\WAFV2` - Documentation updates for AWS WAF (wafv2) to correct the guidance for associating a web ACL to a CloudFront distribution.
* `Aws\imagebuilder` - This release of EC2 Image Builder increases the maximum policy document size for Image Builder resource-based policy APIs.

## 3.133.19 - 2020-02-20

* `Aws\AppConfig` - This release adds exponential growth type support for deployment strategies.
* `Aws\Pinpoint` - As of this release of the Amazon Pinpoint API, the Title property is optional for the CampaignEmailMessage object. 
* `Aws\SavingsPlans` - Added support for AWS Lambda in Compute Savings Plans

## 3.133.18 - 2020-02-19

* `Aws\AutoScaling` - Doc update for EC2 Auto Scaling: Add Enabled parameter for PutScalingPolicy
* `Aws\Lambda` - AWS Lambda now supports Ruby 2.7
* `Aws\ServiceCatalog` - "ListPortfolioAccess" API now has a new optional parameter "OrganizationParentId". When it is provided and if the portfolio with the "PortfolioId" given was shared with an organization or organizational unit with "OrganizationParentId", all accounts in the organization sub-tree under parent which inherit an organizational portfolio share will be listed, rather than all accounts with external shares. To accommodate long lists returned from the new option, the API now supports pagination.

## 3.133.17 - 2020-02-18

* `Aws\AutoScaling` - Amazon EC2 Auto Scaling now supports the ability to enable/disable target tracking, step scaling, and simple scaling policies.
* `Aws\Chime` - Added AudioFallbackUrl to support Chime SDK client.
* `Aws\RDS` - This release supports Microsoft Active Directory authentication for Amazon Aurora.

## 3.133.16 - 2020-02-17

* `Aws\Cloud9` - AWS Cloud9 now supports the ability to tag Cloud9 development environments. 
* `Aws\DynamoDB` - Amazon DynamoDB enables you to restore your DynamoDB backup or table data across AWS Regions such that the restored table is created in a different AWS Region from where the source table or backup resides. You can do cross-region restores between AWS commercial Regions, AWS China Regions, and AWS GovCloud (US) Regions. 
* `Aws\EC2` - Documentation updates for EC2
* `Aws\Rekognition` - This update adds the ability to detect text in videos and adds filters to image and video text detection.

## 3.133.15 - 2020-02-14

* `Aws\Build\Docs` - Adds customization in docs redirect map builder to avoid service name conflict.
* `Aws\EC2` - You can now enable Multi-Attach on Provisioned IOPS io1 volumes through the create-volume API.
* `Aws\MediaTailor` - AWS Elemental MediaTailor SDK now allows configuration of Personalization Threshold for HLS and DASH streams.
* `Aws\SecurityHub` - Security Hub has released a new DescribeStandards API action. This API action allows a customer to list all of the standards available in an account. For each standard, the list provides the customer with the standard name, description, and ARN. Customers can use the ARN as an input to the BatchEnableStandards API action. To learn more, visit our API documentation.
* `Aws\Shield` - This release adds support for associating Amazon Route 53 health checks to AWS Shield Advanced protected resources.
* `Aws\Test\S3` - Adds a test to verify S3 CopyObject functionality with a bucket ARN for the CopySource.

## 3.133.14 - 2020-02-13

* `Aws\MediaPackageVod` - Adds support for DASH with multiple media presentation description periods triggered by presence of SCTE-35 ad markers in the manifest.Also adds optional configuration for DASH SegmentTemplateFormat to refer to segments by Number with Duration, Number with Timeline or Time with Timeline and compact the manifest by combining duplicate SegmentTemplate tags.

## 3.133.13 - 2020-02-12

* `Aws\Chime` - Documentation updates for Amazon Chime
* `Aws\DirectoryService` - Release to add the ExpirationDateTime as an output to ListCertificates so as to ease customers to look into their certificate lifetime and make timely decisions about renewing them.
* `Aws\EC2` - This release adds support for tagging public IPv4 pools.
* `Aws\ElasticsearchService` - Amazon Elasticsearch Service now offers fine-grained access control, which adds multiple capabilities to give tighter control over data. New features include the ability to use roles to define granular permissions for indices, documents, or fields and to extend Kibana with read-only views and secure multi-tenant support.
* `Aws\Glue` - Adding ability to add arguments that cannot be overridden to AWS Glue jobs
* `Aws\Neptune` - This launch enables Neptune start-db-cluster and stop-db-cluster. Stopping and starting Amazon Neptune clusters helps you manage costs for development and test environments. You can temporarily stop all the DB instances in your cluster, instead of setting up and tearing down all the DB instances each time that you use the cluster.
* `Aws\S3` - Fixing incorrect detection of host-style endpoint pattern while using IP address
* `Aws\S3\Transfer` - Fix handling of 'debug' values different than true and valid resources.
* `Aws\WorkMail` - This release adds support for access control rules management in Amazon WorkMail.

## 3.133.12 - 2020-02-11

* `Aws\CloudFormation` - This release of AWS CloudFormation StackSets allows you to centrally manage deployments to all the accounts in your organization or specific organizational units (OUs) in AWS Organizations. You will also be able to enable automatic deployments to any new accounts added to your organization or OUs. The permissions needed to deploy across accounts will automatically be taken care of by the StackSets service.
* `Aws\CognitoIdentityProvider` - Features:This release adds a new setting for a user pool to allow if customer wants their user signup/signin with case insensitive username. The current default setting is case sensitive, and for our next release we will change it to case insensitive.
* `Aws\EC2` - Amazon EC2 Now Supports Tagging Spot Fleet.

## 3.133.11 - 2020-02-10

* `Aws\DocDB` - Added clarifying information that Amazon DocumentDB shares operational technology with Amazon RDS and Amazon Neptune.
* `Aws\KMS` - The ConnectCustomKeyStore API now provides a new error code (SUBNET_NOT_FOUND) for customers to better troubleshoot if their "connect-custom-key-store" operation fails.

## 3.133.10 - 2020-02-07

* `Aws\RDS` - Documentation updates for RDS: when restoring a DB cluster from a snapshot, must create DB instances
* `Aws\RoboMaker` - This release adds support for simulation job batches
* `Aws\imagebuilder` - This version of the SDK includes bug fixes and documentation updates.

## 3.133.9 - 2020-02-06

* `Aws\AppSync` - AWS AppSync now supports X-Ray
* `Aws\CodeBuild` - AWS CodeBuild adds support for Amazon Elastic File Systems
* `Aws\EBS` - Documentation updates for EBS direct APIs.
* `Aws\EC2` - This release adds platform details and billing info to the DescribeImages API.
* `Aws\ECR` - This release contains updated text for the GetAuthorizationToken API.
* `Aws\LexModelBuildingService` - Amazon Lex now supports AMAZON.AlphaNumeric with regular expressions.

## 3.133.8 - 2020-02-05

* `Aws\DLM` - Updated the maximum number of tags that can be added to a snapshot using DLM to 45.
* `Aws\EC2` - This release provides support for tagging when you create a VPC endpoint, or VPC endpoint service.
* `Aws\ForecastQueryService` - Documentation updates for Amazon Forecast.
* `Aws\GroundStation` - Adds dataflowEndpointRegion property to DataflowEndpointConfig. The dateCreated, lastUpdated, and tags properties on GetSatellite have been deprecated.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for fine-tuned QVBR quality level.
* `Aws\ResourceGroupsTaggingAPI` - Documentation-only update that adds services to the list of supported services.
* `Aws\SecurityHub` - Additional resource types are now supported in the AWS Security Finding Format (ASFF). The following new resource types are added, each having an accompanying resource details object with fields for security finding providers to populate: AwsCodeBuildProject, AwsEc2NetworkInterface, AwsEc2SecurityGroup, AwsElasticsearchDomain, AwsLambdaLayerVersion, AwsRdsDbInstance, and AwsWafWebAcl. The following resource types are added without an accompanying details object: AutoscalingAutoscalingGroup, AwsDynamoDbTable, AwsEc2Eip, AwsEc2Snapshot, AwsEc2Volume, AwsRdsDbSnapshot, AwsRedshiftCluster, and AwsS3Object. The number of allowed resources per finding is increased from 10 to 32. A new field is added in the Compliance object, RelatedRequirements. To learn more, visit our documentation on the ASFF.

## 3.133.7 - 2020-02-04

* `Aws\CloudFront` - Documentation updates for CloudFront
* `Aws\EC2` - Amazon VPC Flow Logs adds support for 1-minute aggregation intervals.
* `Aws\IoT` - Updated ThrottlingException documentation to report that the error code is 400, and not 429, to reflect actual system behaviour.
* `Aws\Kafka` - This release enables AWS MSK customers to list Apache Kafka versions that are supported on AWS MSK clusters. Also includes changes to expose additional details of a cluster's state in DescribeCluster and ListClusters APIs.
* `Aws\SSM` - This feature ensures that an instance is patched up to the available patches on a particular date. It can be enabled by selecting the 'ApproveUntilDate' option as the auto-approval rule while creating the patch baseline. ApproveUntilDate - The cutoff date for auto approval of released patches. Any patches released on or before this date will be installed automatically.
* `Aws\StorageGateway` - Adding KVM as a support hypervisor
* `Aws\WorkMail` - This release adds support for tagging Amazon WorkMail organizations.

## 3.133.6 - 2020-01-24

* `Aws\DataSync` - AWS DataSync now supports FSx for Windows File Server Locations
* `Aws\ECS` - This release provides support for tagging Amazon ECS task sets for services using external deployment controllers.
* `Aws\EKS` - Adding new error codes for Nodegroups in EKS
* `Aws\OpsWorksCM` - AWS OpsWorks for Chef Automate now supports in-place upgrade to Chef Automate 2. Eligible servers can be updated through the management console, CLI and APIs.
* `Aws\WorkSpaces` - Documentation updates for WorkSpaces

## 3.133.5 - 2020-01-23

* `Aws\IAM` - This release enables the Identity and Access Management policy simulator to simulate permissions boundary policies.
* `Aws\RDS` - This SDK release introduces APIs that automate the export of Amazon RDS snapshot data to Amazon S3. The new APIs include: StartExportTask, CancelExportTask, DescribeExportTasks. These APIs automate the extraction of data from an RDS snapshot and export it to an Amazon S3 bucket. The data is stored in a compressed, consistent, and query-able format. After the data is exported, you can query it directly using tools such as Amazon Athena or Redshift Spectrum. You can also consume the data as part of a data lake solution. If you archive the data in S3 Infrequent Access or Glacier, you can reduce long term data storage costs by applying data lifecycle policies.

## 3.133.4 - 2020-01-21

* `Aws\ApplicationDiscoveryService` - Documentation updates for the AWS Application Discovery Service.
* `Aws\CodePipeline` - AWS CodePipeline enables an ability to stop pipeline executions.
* `Aws\EC2` - Add an enum value to the result of DescribeByoipCidrs to support CIDRs that are not publicly advertisable.
* `Aws\IoTEvents` - Documentation updates for iotcolumbo
* `Aws\MarketplaceCommerceAnalytics` - Remove 4 deprecated data sets, change some data sets available dates to 2017-09-15

## 3.133.3 - 2020-01-20

* `Aws\AlexaForBusiness` - Add support for CreatedTime and ConnectionStatusUpdatedTime in response of SearchDevices API.
* `Aws\ApplicationInsights` - This release adds support for a list API to retrieve the configuration events logged during periodic updates to an application by Amazon CloudWatch Application Insights. 
* `Aws\CloudWatch` - Updating DescribeAnomalyDetectors API to return AnomalyDetector Status value in response.
* `Aws\EC2` - This release provides support for a preview of bringing your own IPv6 addresses (BYOIP for IPv6) for use in AWS.
* `Aws\KMS` - The ConnectCustomKeyStore operation now provides new error codes (USER_LOGGED_IN and USER_NOT_FOUND) for customers to better troubleshoot if their connect custom key store operation fails. Password length validation during CreateCustomKeyStore now also occurs on the client side. 
* `Aws\Lambda` - Added reason codes to StateReasonCode (InvalidSubnet, InvalidSecurityGroup) and LastUpdateStatusReasonCode (SubnetOutOfIPAddresses, InvalidSubnet, InvalidSecurityGroup) for functions that connect to a VPC.

## 3.133.2 - 2020-01-17

* `Aws\Batch` - This release ensures INACTIVE job definitions are permanently deleted after 180 days.
* `Aws\CloudHSMV2` - This release introduces resource-level and tag-based access control for AWS CloudHSM resources. You can now tag CloudHSM backups, tag CloudHSM clusters on creation, and tag a backup as you copy it to another region.
* `Aws\ECS` - This release provides a public preview for specifying Amazon EFS file systems as volumes in your Amazon ECS task definitions.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for MP3 audio only outputs.
* `Aws\Neptune` - This release includes Deletion Protection for Amazon Neptune databases.
* `Aws\Redshift` - Documentation updates for redshift

## 3.133.1 - 2020-01-16

* `Aws\DirectoryService` - To reduce the number of errors our customers are facing, we have modified the requirements of input parameters for two of Directory Service APIs.
* `Aws\EC2` - Client VPN now supports Port Configuration for VPN Endpoints, allowing usage of either port 443 or port 1194.
* `Aws\SageMaker` - This release adds two new APIs (UpdateWorkforce and DescribeWorkforce) to SageMaker Ground Truth service for workforce IP whitelisting.

## 3.133.0 - 2020-01-15

* `Aws\` - Added retry for EC2ThrottledException
* `Aws\EC2` - General Update to EC2 Docs and SDKs
* `Aws\Organizations` - Updated description for PolicyID parameter and ConstraintViolationException.
* `Aws\SSM` - Document updates for Patch Manager 'NoReboot' feature.
* `Aws\SecurityHub` - Add support for DescribeStandardsControls and UpdateStandardsControl. These new Security Hub API operations are used to track and manage whether a compliance standards control is enabled.
* `Aws\Test\Integ` - Modify S3 integration context event hooks, as well as retry logic to take into account S3 eventual consistency characteristics.

## 3.132.5 - 2020-01-14

* `Aws\EC2` - This release adds support for partition placement groups and instance metadata option in Launch Templates

## 3.132.4 - 2020-01-13

* `Aws\Backup` - Cross-region backup is a new AWS Backup feature that allows enterprises to copy backups across multiple AWS services to different regions. 
* `Aws\EC2` - Documentation updates for the StopInstances API. You can now stop and start an Amazon EBS-backed Spot Instance at will, instead of relying on the Stop interruption behavior to stop your Spot Instances when interrupted.
* `Aws\EFS` - This release adds support for managing EFS file system policies and EFS Access Points.

## 3.132.3 - 2020-01-10

* `Aws\Chime` - Add shared profile support to new and existing users
* `Aws\CloudFront` - CloudFront Signer now accepts PEM formatted private keys stored as variables in addition to the path to a key file.
* `Aws\EC2` - This release introduces the ability to tag egress only internet gateways, local gateways, local gateway route tables, local gateway virtual interfaces, local gateway virtual interface groups, local gateway route table VPC association and local gateway route table virtual interface group association. You can use tags to organize and identify your resources for cost allocation. 
* `Aws\RDS` - This release adds an operation that enables users to override the system-default SSL/TLS certificate for new Amazon RDS DB instances temporarily, or remove the customer override.
* `Aws\SageMaker` - SageMaker ListTrialComponents API filter by TrialName and ExperimentName.
* `Aws\Transfer` - This release introduces a new endpoint type that allows you to attach Elastic IP addresses from your AWS account with your server's endpoint directly and whitelist access to your server by client's internet IP address(es) using VPC Security Groups.
* `Aws\WorkSpaces` - Added the migrate feature to Amazon WorkSpaces.

## 3.132.2 - 2020-01-09

* `Aws\CloudWatchLogs` - Documentation updates for logs
* `Aws\STS` - Documentation updates for sts

## 3.132.1 - 2020-01-08

* `Aws\ApiGatewayV2` - Adds an alias 'GetApiResource' for the 'GetApi' operation to avoid a naming conflict with the generic AwsClient 'GetApi' method.
* `Aws\CostExplorer` - Documentation updates for CreateCostCategoryDefinition and UpdateCostCategoryDefinition API
* `Aws\FMS` - AWS Firewall Manager now supports tagging, and tag-based access control, of policies.
* `Aws\Translate` - This release adds a new family of APIs for asynchronous batch translation service that provides option to translate large collection of text or HTML documents stored in Amazon S3 folder. This service accepts a batch of up to 5 GB in size per API call with each document not exceeding 1 MB size and the number of documents not exceeding 1 million per batch. See documentation for more information. 

## 3.132.0 - 2020-01-07

* `Aws\` - Adds support for the 'AWS_CONFIG_FILE' environment variable to set the default config file location. This is implemented for all configuration provider classes extending AbstractConfigurationProvider.
* `Aws\CodeBuild` - Add encryption key override to StartBuild API in AWS CodeBuild.
* `Aws\MigrationHub` - ListApplicationStates API provides a list of all application migration states
* `Aws\XRay` - Documentation updates for xray

## 3.131.0 - 2020-01-06

* `Aws\` - Add support for Guzzle7.
* `Aws\CloudFront` - Modifies CloudFront Signer to accept a passphrase for the key file. Modifies Signer test to use a fixed test key file.
* `Aws\Comprehend` - Amazon Comprehend now supports Multilabel document classification
* `Aws\EC2` - This release supports service providers configuring a private DNS name for services other than AWS services and services available in the AWS marketplace. This feature allows consumers to access the service using an existing DNS name without making changes to their applications.
* `Aws\MediaPackage` - You can now restrict direct access to AWS Elemental MediaPackage by securing requests for live content using CDN authorization. With CDN authorization, content requests require a specific HTTP header and authorization code.

## 3.130.3 - 2020-01-02

* `Aws\CostExplorer` - Documentation updates for GetReservationUtilization for the Cost Explorer API.
* `Aws\ECR` - Adds waiters for ImageScanComplete and LifecyclePolicyPreviewComplete
* `Aws\LexModelBuildingService` - Documentation updates for Amazon Lex.
* `Aws\Lightsail` - This release adds support for Certificate Authority (CA) certificate identifier to managed databases in Amazon Lightsail.

## 3.130.2 - 2019-12-23

* `Aws\Detective` - Updated the documentation for Amazon Detective.
* `Aws\FSx` - This release adds a new family of APIs (create-data-repository-task, describe-data-repository-task, and cancel-data-repository-task) that allow users to perform operations between their file system and its linked data repository.
* `Aws\Health` - With this release, you can now centrally aggregate AWS Health events from all accounts in your AWS organization. Visit AWS Health documentation to learn more about enabling and using this feature: https://docs.aws.amazon.com/health/latest/ug/organizational-view-health.html. 

## 3.130.1 - 2019-12-20

* `Aws\DeviceFarm` - Introduced browser testing support through AWS Device Farm
* `Aws\EC2` - This release introduces the ability to tag key pairs, placement groups, export tasks, import image tasks, import snapshot tasks and export image tasks. You can use tags to organize and identify your resources for cost allocation. 
* `Aws\EKS` - Amazon EKS now supports restricting access to the API server public endpoint by applying CIDR blocks
* `Aws\Pinpoint` - This release of the Amazon Pinpoint API introduces versioning support for message templates.
* `Aws\RDS` - This release adds an operation that enables users to specify whether a database is restarted when its SSL/TLS certificate is rotated. Only customers who do not use SSL/TLS should use this operation.
* `Aws\Redshift` - Documentation updates for Amazon Redshift RA3 node types.
* `Aws\SSM` - This release updates the attachments support to include AttachmentReference source for Automation documents.
* `Aws\SecurityHub` - Additional resource types are now fully supported in the AWS Security Finding Format (ASFF). These resources include AwsElbv2LoadBalancer, AwsKmsKey, AwsIamRole, AwsSqsQueue, AwsLambdaFunction, AwsSnsTopic, and AwsCloudFrontDistribution. Each of these resource types includes an accompanying resource details object with fields for security finding providers to populate. Updates were made to the AwsIamAccessKey resource details object to include information on principal ID and name. To learn more, visit our documentation on the ASFF.
* `Aws\TranscribeService` - AWS Transcribe now supports vocabulary filtering that allows customers to input words to the service that they don't want to see in the output transcript.

## 3.130.0 - 2019-12-19

* `Aws\CodeStarconnections` - Public beta for Bitbucket Cloud support in AWS CodePipeline through integration with AWS CodeStar connections.
* `Aws\Credentials` - Brings PHP SDK inline with Python's boto3, allowing setting instance metadata timeout and retries from environment variables
* `Aws\DLM` - You can now copy snapshots across regions using Data Lifecycle Manager (DLM). You can enable policies which, along with create, can now also copy snapshots to one or more AWS region(s). Copies can be scheduled for up to three regions from a single policy and retention periods are set for each region separately. 
* `Aws\EC2` - We are updating the supportedRootDevices field to supportedRootDeviceTypes for DescribeInstanceTypes API to ensure that the actual value is returned, correcting a previous error in the model.
* `Aws\GameLift` - Amazon GameLift now supports ARNs for all key GameLift resources, tagging for GameLift resource authorization management, and updated documentation that articulates GameLift's resource authorization strategy.
* `Aws\LexModelBuildingService` - Amazon Lex now supports conversation logs and slot obfuscation.
* `Aws\PersonalizeRuntime` - Add context map to get-recommendations and get-personalized-ranking request objects to provide contextual metadata at inference time
* `Aws\SSM` - This release allows customers to add tags to Automation execution, enabling them to sort and filter executions in different ways, such as by resource, purpose, owner, or environment.
* `Aws\TranscribeService` - Amazon Transcribe supports job queuing for the StartTranscriptionJob API.

## 3.129.3 - 2019-12-18

* `Aws\Build\Docs` - Adds a hook for custom examples in API documentation generation.
* `Aws\CloudFront` - Documentation updates for CloudFront
* `Aws\EC2` - This release introduces the ability to tag Elastic Graphics accelerators. You can use tags to organize and identify your accelerators for cost allocation.
* `Aws\OpsWorksCM` - AWS OpsWorks CM now supports tagging, and tag-based access control, of servers and backups.
* `Aws\ResourceGroupsTaggingAPI` - Documentation updates for resourcegroupstaggingapi
* `Aws\S3` - Updates Amazon S3 endpoints allowing you to configure your client to opt-in to using S3 with the us-east-1 regional endpoint, instead of global.

## 3.129.2 - 2019-12-17

* `Aws\EC2` - Documentation updates for Amazon EC2
* `Aws\ECS` - Documentation updates for Amazon ECS.
* `Aws\IoT` - Added a new Over-the-Air (OTA) Update feature that allows you to use different, or multiple, protocols to transfer an image from the AWS cloud to IoT devices.
* `Aws\KinesisAnalyticsV2` - Kinesis Data Analytics service now supports running Java applications using Flink 1.8.
* `Aws\MediaLive` - AWS Elemental MediaLive now supports HLS ID3 segment tagging, HLS redundant manifests for CDNs that support different publishing/viewing endpoints, fragmented MP4 (fMP4), and frame capture intervals specified in milliseconds.
* `Aws\SSM` - Added support for Cloud Watch Output and Document Version to the Run Command tasks in Maintenance Windows.

## 3.129.1 - 2019-12-16

* `Aws\ComprehendMedical` - New Ontology linking APIs will provides medication concepts normalization and Diagnoses codes from input text. In this release we will provide two APIs - RxNorm and ICD10-CM. 
* `Aws\EC2` - You can now configure your EC2 Fleet to preferentially use EC2 Capacity Reservations for launching On-Demand instances, enabling you to fully utilize the available (and unused) Capacity Reservations before launching On-Demand instances on net new capacity.
* `Aws\MQ` - Amazon MQ now supports throughput-optimized message brokers, backed by Amazon EBS.

## 3.129.0 - 2019-12-13

* `Aws\Api\Parser` - Add support for parsing XML attributes for models using XML-based protocols.
* `Aws\CodeBuild` - CodeBuild adds support for cross account
* `Aws\Detective` - This is the initial release of Amazon Detective.
* `Aws\SesV2` - Added the ability to use your own public-private key pair to configure DKIM authentication for a domain identity.

## 3.128.4 - 2019-12-12

* `Aws\AccessAnalyzer` - This release includes improvements and fixes bugs for the IAM Access Analyzer feature.

## 3.128.3 - 2019-12-11

* `Aws\EC2` - This release allows customers to attach multiple Elastic Inference Accelerators to a single EC2 instance. It adds support for a Count parameter for each Elastic Inference Accelerator type you specify on the RunInstances and LaunchTemplate APIs.

## 3.128.2 - 2019-12-10

* `Aws\S3Control` - Adds AccountId validation for S3Control.
* `Aws\kendra` - 1. Adding DocumentTitleFieldName as an optional configuration for SharePoint. 2. updating s3 object pattern to support all s3 keys.

## 3.128.1 - 2019-12-09

* `Aws\KMS` - The Verify operation now returns KMSInvalidSignatureException on invalid signatures. The Sign and Verify operations now return KMSInvalidStateException when a request is made against a CMK pending deletion.
* `Aws\Kafka` - AWS MSK has added support for Open Monitoring with Prometheus.
* `Aws\QuickSight` - Documentation updates for QuickSight
* `Aws\SSM` - Adds the SSM GetCalendarState API and ChangeCalendar SSM Document type. These features enable the forthcoming Systems Manager Change Calendar feature, which will allow you to schedule events during which actions should (or should not) be performed.
* `Aws\Test` - Adds a test bootstrap patch for a PHPUnit class file that triggers deprecation warnings for PHP 7.4+. This is necessary because the SDK supports older versions of PHP and currently relies on older, now unsupported, versions of PHPUnit.

## 3.128.0 - 2019-12-05

* `Aws\ApiGatewayV2` - Amazon API Gateway now supports HTTP APIs (beta), enabling customers to quickly build high performance RESTful APIs that are up to 71% cheaper than REST APIs also available from API Gateway. HTTP APIs are optimized for building APIs that proxy to AWS Lambda functions or HTTP backends, making them ideal for serverless workloads. Using HTTP APIs, you can secure your APIs using OIDC and OAuth 2 out of box, quickly build web applications using a simple CORS experience, and get started immediately with automatic deployment and simple create workflows.
* `Aws\KinesisVideo` - Introduces management of signaling channels for Kinesis Video Streams.
* `Aws\KinesisVideoSignalingChannels` - Announcing support for WebRTC in Kinesis Video Streams, as fully managed capability. You can now use simple APIs to enable your connected devices, web, and mobile apps with real-time two-way media streaming capabilities.
* `Aws\Test\S3` - Fixes stream reading issue in TransferTest with PHP 7.4.

## 3.127.0 - 2019-12-04

* `Aws\` - Fixes array offset null issue and test stream class for PHP 7.4.
* `Aws\ApplicationAutoScaling` - This release supports auto scaling of provisioned concurrency for AWS Lambda.
* `Aws\EBS` - This release introduces the EBS direct APIs for Snapshots: 1. ListSnapshotBlocks, which lists the block indexes and block tokens for blocks in an Amazon EBS snapshot. 2. ListChangedBlocks, which lists the block indexes and block tokens for blocks that are different between two snapshots of the same volume/snapshot lineage. 3. GetSnapshotBlock, which returns the data in a block of an Amazon EBS snapshot.
* `Aws\Lambda` - - Added the ProvisionedConcurrency type and operations. Allocate provisioned concurrency to enable your function to scale up without fluctuations in latency. Use PutProvisionedConcurrencyConfig to configure provisioned concurrency on a version of a function, or on an alias.
* `Aws\RDS` - This release adds support for the Amazon RDS Proxy
* `Aws\Rekognition` - This SDK Release introduces APIs for Amazon Rekognition Custom Labels feature (CreateProjects, CreateProjectVersion,DescribeProjects, DescribeProjectVersions, StartProjectVersion, StopProjectVersion and DetectCustomLabels). Also new is AugmentedAI (Human In The Loop) Support for DetectModerationLabels in Amazon Rekognition.
* `Aws\S3` - Adds support for using S3 Access Point ARNs in Bucket fields for S3 operations and helper classes.
* `Aws\SFN` - This release of the AWS Step Functions SDK introduces support for Express Workflows.
* `Aws\SageMaker` - You can now use SageMaker Autopilot for automatically training and tuning candidate models using a combination of various feature engineering, ML algorithms, and hyperparameters determined from the user's input data. SageMaker Automatic Model Tuning now supports tuning across multiple algorithms. With Amazon SageMaker Experiments users can create Experiments, ExperimentTrials, and ExperimentTrialComponents to track, organize, and evaluate their ML training jobs. With Amazon SageMaker Debugger, users can easily debug training jobs using a number of pre-built rules provided by Amazon SageMaker, or build custom rules. With Amazon SageMaker Processing, users can run on-demand, distributed, and fully managed jobs for data pre- or post- processing or model evaluation. With Amazon SageMaker Model Monitor, a user can create MonitoringSchedules to automatically monitor endpoints to detect data drift and other issues and get alerted on them. This release also includes the preview version of Amazon SageMaker Studio with Domains, UserProfiles, and Apps. This release also includes the preview version of Amazon Augmented AI to easily implement human review of machine learning predictions by creating FlowDefinitions, HumanTaskUis, and HumanLoops.

## 3.126.0 - 2019-12-03

* `Aws\AugmentedAIRuntime` - This release adds support for Amazon Augmented AI, which makes it easy to build workflows for human review of machine learning predictions.
* `Aws\CodeGuruProfiler` - (New Service) Amazon CodeGuru Profiler analyzes application CPU utilization and latency characteristics to show you where you are spending the most cycles in your application. This analysis is presented in an interactive flame graph that helps you easily understand which paths consume the most resources, verify that your application is performing as expected, and uncover areas that can be optimized further.
* `Aws\CodeGuruReviewer` - This is the preview release of Amazon CodeGuru Reviewer.
* `Aws\ComputeOptimizer` - Initial release of AWS Compute Optimizer. AWS Compute Optimizer recommends optimal AWS Compute resources to reduce costs and improve performance for your workloads.
* `Aws\EC2` - This release adds support for the following features: 1. An option to enable acceleration for Site-to-Site VPN connections, to improve connection performance by leveraging AWS Global Accelerator; 2. Inf1 instances featuring up to 16 AWS Inferentia chips, custom-built for ML inference applications to deliver low latency and high throughput performance. Use Inf1 instances to run high scale ML inference applications such as image recognition, speech recognition, natural language processing, personalization, and fraud detection at the lowest cost in the cloud. Inf1 instances will soon be available for use with Amazon SageMaker, Amazon EKS and Amazon ECS. To get started, see https://aws.amazon.com/ec2/instance-types/Inf1; 3. The ability to associate route tables with internet gateways and virtual private gateways, and define routes to insert network and security virtual appliances in the path of inbound and outbound traffic. For more information on Amazon VPC Ingress Routing, see https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html#gateway-route-table; 4. AWS Local Zones that place compute, storage, database, and other select services closer to you for applications that require very low latency to your end-users. AWS Local Zones also allow you to seamlessly connect to the full range of services in the AWS Region through the same APIs and tool sets; 5. Launching and viewing EC2 instances and EBS volumes running locally in Outposts. This release also introduces a new local gateway (LGW) with Outposts to enable connectivity between Outposts and local on-premises networks as well as the internet; 6. Peering Transit Gateways between regions simplifying creation of secure and private global networks on AWS; 7. Transit Gateway Multicast, enabling multicast routing within and between VPCs using Transit Gateway as a multicast router.
* `Aws\ECS` - This release supports ECS Capacity Providers, Fargate Spot, and ECS Cluster Auto Scaling. These features enable new ways for ECS to manage compute capacity used by tasks.
* `Aws\EKS` - Introducing Amazon EKS with Fargate. Customers can now use Amazon EKS to launch pods directly onto AWS Fargate, the serverless compute engine built for containers on AWS. 
* `Aws\ElasticsearchService` - UltraWarm storage provides a cost-effective way to store large amounts of read-only data on Amazon Elasticsearch Service. Rather than attached storage, UltraWarm nodes use Amazon S3 and a sophisticated caching solution to improve performance. For indices that you are not actively writing to and query less frequently, UltraWarm storage offers significantly lower costs per GiB. In Elasticsearch, these warm indices behave just like any other index. You can query them using the same APIs or use them to create dashboards in Kibana.
* `Aws\FraudDetector` - Amazon Fraud Detector is a fully managed service that makes it easy to identify potentially fraudulent online activities such as online payment fraud and the creation of fake accounts. Amazon Fraud Detector uses your data, machine learning (ML), and more than 20 years of fraud detection expertise from Amazon to automatically identify potentially fraudulent online activity so you can catch more fraud faster.
* `Aws\NetworkManager` - This is the initial SDK release for AWS Network Manager.
* `Aws\Outposts` - This is the initial release for AWS Outposts, a fully managed service that extends AWS infrastructure, services, APIs, and tools to customer sites. AWS Outposts enables you to launch and run EC2 instances and EBS volumes locally at your on-premises location. This release introduces new APIs for creating and viewing Outposts. 
* `Aws\S3` - Amazon S3 Access Points is a new S3 feature that simplifies managing data access at scale for shared data sets on Amazon S3. Access Points provide a customizable way to access the objects in a bucket, with a unique hostname and access policy that enforces the specific permissions and network controls for any request made through the access point. This represents a new way of provisioning access to shared data sets.
* `Aws\S3Control` - Amazon S3 Access Points is a new S3 feature that simplifies managing data access at scale for shared data sets on Amazon S3. Access Points provide a customizable way to access the objects in a bucket, with a unique hostname and access policy that enforces the specific permissions and network controls for any request made through the access point. This represents a new way of provisioning access to shared data sets.
* `Aws\Textract` - This SDK Release introduces Amazon Augmented AI support for Amazon Textract AnalyzeDocument API. Image byte payloads for synchronous operations have increased from 5 MB to 10 MB.
* `Aws\kendra` - It is a preview launch of Amazon Kendra. Amazon Kendra is a managed, highly accurate and easy to use enterprise search service that is powered by machine learning.

## 3.125.0 - 2019-12-02

* `Aws\AccessAnalyzer` - Introducing AWS IAM Access Analyzer, an IAM feature that makes it easy for AWS customers to ensure that their resource-based policies provide only the intended access to resources outside their AWS accounts.

## 3.124.0 - 2019-12-02

* `Aws\EC2` - AWS now provides a new BYOL experience for software licenses, such as Windows and SQL Server, that require a dedicated physical server. You can now enjoy the flexibility and cost effectiveness of using your own licenses on Amazon EC2 Dedicated Hosts, but with the simplicity, resiliency, and elasticity of AWS. You can specify your Dedicated Host management preferences, such as host allocation, host capacity utilization, and instance placement in AWS License Manager. Once set up, AWS takes care of these administrative tasks on your behalf, so that you can seamlessly launch virtual machines (instances) on Dedicated Hosts just like you would launch an EC2 instance with AWS provided licenses.
* `Aws\LicenseManager` - AWS License Manager now automates discovery of bring-your-own-license usage across the customers organization. With few simple settings, customers can add bring your own license product information along with licensing rules, which would enable License Manager to automatically track the instances that have the specified products installed. If License Manager detects any violation of licensing rules, it would notify the customers designated license administrator to take corrective action.
* `Aws\Schemas` - This release introduces support for Amazon EventBridge schema registry, making it easy to discover and write code for events in EventBridge.
* `Aws\imagebuilder` - This is the first release of EC2 Image Builder, a service that provides a managed experience for automating the creation of EC2 AMIs.

## 3.123.0 - 2019-11-26

* `Aws\CognitoIdentityProvider` - This release adds a new setting for a user pool to configure which recovery methods a user can use to recover their account via the forgot password operation.
* `Aws\DirectoryService` - This release will introduce optional encryption over LDAP network traffic using SSL certificates between customer's self-managed AD and AWS Directory Services instances. The release also provides APIs for Certificate management.
* `Aws\DynamoDB` - 1) Amazon Contributor Insights for Amazon DynamoDB is a diagnostic tool for identifying frequently accessed keys and understanding database traffic trends. 2) Support for displaying new fields when a table's encryption state is Inaccessible or the table have been Archived.
* `Aws\ElasticInference` - Amazon Elastic Inference allows customers to attach Elastic Inference Accelerators to Amazon EC2 and Amazon ECS tasks, thus providing low-cost GPU-powered acceleration and reducing the cost of running deep learning inference. This release allows customers to add or remove tags for their Elastic Inference Accelerators.
* `Aws\MediaTailor` - AWS Elemental MediaTailor SDK now allows configuration of the Live Pre-Roll feature for HLS and DASH streams.
* `Aws\Organizations` - Introduces the DescribeEffectivePolicy action, which returns the contents of the policy that's in effect for the account.
* `Aws\QuickSight` - Documentation updates for QuickSight
* `Aws\RDSDataService` - Type hints to improve handling of some specific parameter types (date/time, decimal etc) for ExecuteStatement and BatchExecuteStatement APIs
* `Aws\ResourceGroupsTaggingAPI` - You can use tag policies to help standardize on tags across your organization's resources.
* `Aws\ServerlessApplicationRepository` - AWS Serverless Application Repository now supports verified authors. Verified means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.
* `Aws\WorkSpaces` - For the WorkspaceBundle API, added the image identifier and the time of the last update.

## 3.122.0 - 2019-11-25

* `Aws\AlexaForBusiness` - API update for Alexa for Business: This update enables the use of meeting room configuration that can be applied to a room profile. These settings help improve and measure utilization on Alexa for Business enabled rooms. New features include end meeting reminders, intelligent room release and room utilization analytics report.
* `Aws\AppConfig` - Introducing AWS AppConfig, a new service that enables customers to quickly deploy validated configurations to applications of any size in a controlled and monitored fashion.
* `Aws\ApplicationAutoScaling` - This release supports auto scaling of document classifier endpoints for Comprehend; and supports target tracking based on the average capacity utilization metric for AppStream 2.0 fleets. 
* `Aws\ApplicationInsights` - CloudWatch Application Insights for .NET and SQL Server includes the follwing features: -Tagging Create and manage tags for your applications.-Custom log pattern matching. Define custom log patterns to be detected and monitored.-Resource-level permissions. Specify applications users can access.
* `Aws\Athena` - This release adds additional query lifecycle metrics to the QueryExecutionStatistics object in GetQueryExecution response.
* `Aws\CloudWatch` - This release adds a new feature called "Contributor Insights". "Contributor Insights" supports the following 6 new APIs (PutInsightRule, DeleteInsightRules, EnableInsightRules, DisableInsightRules, DescribeInsightRules and GetInsightRuleReport). 
* `Aws\CodeBuild` - CodeBuild adds support for test reporting
* `Aws\CognitoIdentityProvider` - Amazon Cognito Userpools now supports Sign in with Apple as an Identity Provider.
* `Aws\Comprehend` - Amazon Comprehend now supports real-time analysis with Custom Classification
* `Aws\CostExplorer` - This launch provides customers with access to Cost Category Public Beta APIs.
* `Aws\DLM` - You can now set time based retention policies on Data Lifecycle Manager. With this launch, DLM allows you to set snapshot retention period in the following interval units: days, weeks, months and years.
* `Aws\EC2` - This release adds two new APIs: 1. ModifyDefaultCreditSpecification, which allows you to set default credit specification at the account level per AWS Region, per burstable performance instance family, so that all new burstable performance instances in the account launch using the new default credit specification. 2. GetDefaultCreditSpecification, which allows you to get current default credit specification per AWS Region, per burstable performance instance family. This release also adds new client exceptions for StartInstances and StopInstances.
* `Aws\ElasticLoadBalancingv2` - This release of Elastic Load Balancing V2 adds new subnet features for Network Load Balancers and a new routing algorithm for Application Load Balancers. 
* `Aws\Greengrass` - IoT Greengrass supports machine learning resources in 'No container' mode.
* `Aws\IoT` - This release adds: 1) APIs for fleet provisioning claim and template, 2) endpoint configuration and custom domains, 3) support for enhanced custom authentication, d) support for 4 additional audit checks: Device and CA certificate key quality checks, IoT role alias over-permissive check and IoT role alias access to unused services check, 5) extended capability of AWS IoT Rules Engine to support IoT SiteWise rule action. The IoT SiteWise rule action lets you send messages from IoT sensors and applications to IoT SiteWise asset properties
* `Aws\IoTSecureTunneling` - This release adds support for IoT Secure Tunneling to remote access devices behind restricted firewalls.
* `Aws\KMS` - AWS Key Management Service (KMS) now enables creation and use of asymmetric Customer Master Keys (CMKs) and the generation of asymmetric data key pairs.
* `Aws\KinesisAnalyticsV2` - Kinesis Data Analytics service adds support to configure Java applications to access resources in a VPC. Also releasing support to configure Java applications to set allowNonRestoreState flag through the service APIs.
* `Aws\Lambda` - Added the function state and update status to the output of GetFunctionConfiguration and other actions. Check the state information to ensure that a function is ready before you perform operations on it. Functions take time to become ready when you connect them to a VPC.Added the EventInvokeConfig type and operations to configure error handling options for asynchronous invocation. Use PutFunctionEventInvokeConfig to configure the number of retries and the maximum age of events when you invoke the function asynchronously.Added on-failure and on-success destination settings for asynchronous invocation. Configure destinations to send an invocation record to an SNS topic, an SQS queue, an EventBridge event bus, or a Lambda function.Added error handling options to event source mappings. This enables you to configure the number of retries, configure the maximum age of records, or retry with smaller batches when an error occurs when a function processes a Kinesis or DynamoDB stream.Added the on-failure destination setting to event source mappings. This enables you to send discarded events to an SNS topic or SQS queue when all retries fail or when the maximum record age is exceeded when a function processes a Kinesis or DynamoDB stream.Added the ParallelizationFactor option to event source mappings to increase concurrency per shard when a function processes a Kinesis or DynamoDB stream.
* `Aws\LexRuntimeService` - Amazon Lex adds "sessionId" attribute to the PostText and PostContent response.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for 8K outputs and support for QuickTime Animation Codec (RLE) inputs.
* `Aws\MediaLive` - AWS Elemental MediaLive now supports the ability to create a multiple program transport stream (MPTS).
* `Aws\MediaPackageVod` - Adds a domain name to PackagingGroups, representing the fully qualified domain name for Assets created in the group.
* `Aws\RAM` - AWS RAM provides new APIs to view the permissions granted to principals in a resource share. This release also creates corresponding resource shares for supported services that use resource policies, as well as an API to promote them to standard shares that can be managed in RAM.
* `Aws\RDS` - Cluster Endpoints can now be tagged by using --tags in the create-db-cluster-endpoint API
* `Aws\Redshift` - This release contains changes for 1. Redshift Scheduler 2. Update to the DescribeNodeConfigurationOptions to include a new action type recommend-node-config
* `Aws\SSM` - AWS Systems Manager Documents now supports more Document Types: ApplicationConfiguration, ApplicationConfigurationSchema and DeploymentStrategy. This release also extends Document Permissions capabilities and introduces a new Force flag for DeleteDocument API.
* `Aws\SesV2` - This release includes support for automatically suppressing email addresses that result in hard bounce or complaint events at the account level, and for managing addresses on this account-level suppression list.
* `Aws\WAFV2` - This release introduces new set of APIs ("wafv2") for AWS WAF. Major changes include single set of APIs for creating/updating resources in global and regional scope, and rules are configured directly into web ACL instead of being referenced. The previous APIs ("waf" and "waf-regional") are now referred as AWS WAF Classic. For more information visit: https://docs.aws.amazon.com/waf/latest/APIReference/Welcome.html

## 3.121.1 - 2019-11-22

* `Aws\ACM` - This release adds support for Tag-Based IAM for AWS Certificate Manager and adding tags to certificates upon creation.
* `Aws\ApplicationAutoScaling` - Update default endpoint for Application Auto Scaling.
* `Aws\AutoScalingPlans` - Update default endpoint for AWS Auto Scaling.
* `Aws\CodeBuild` - Add Canonical ARN to LogsLocation.
* `Aws\EC2` - This release adds two new APIs (DescribeInstanceTypes and DescribeInstanceTypeOfferings) that give customers access to instance type attributes and regional and zonal offerings.
* `Aws\EMR` - Amazon EMR adds support for concurrent step execution and cancelling running steps. Amazon EMR has added a new Outpost ARN field in the ListCluster and DescribeCluster API responses that is populated for clusters launched in an AWS Outpost subnet.
* `Aws\ForecastService` - This release adds two key updates to existing APIs. 1. Amazon Forecast can now generate forecasts in any quantile using the optional parameter forecastTypes in the CreateForecast API and 2. You can get additional details (metrics and relevant error messages) on your AutoML runs using the DescribePredictor and GetAccuracyMetrics APIs.
* `Aws\MediaPackageVod` - Includes the submission time of Asset ingestion request in the API response for Create/List/Describe Assets.
* `Aws\Rekognition` - This release adds enhanced face filtering support to the IndexFaces API operation, and introduces face filtering for CompareFaces and SearchFacesByImage API operations.
* `Aws\SNS` - Added documentation for the dead-letter queue feature.
* `Aws\SSM` - Add RebootOption and LastNoRebootInstallOperationTime for DescribeInstancePatchStates and DescribeInstancePatchStatesForPatchGroup API
* `Aws\STS` - Support tagging for STS sessions and tag based access control for the STS APIs

## 3.121.0 - 2019-11-21

* `Aws\Amplify` - This release of AWS Amplify Console introduces support for backend environments. Backend environments are containers for AWS deployments. Each environment is a collection of AWS resources.
* `Aws\AppSync` - AppSync: AWS AppSync now supports the ability to add, configure, and maintain caching for your AWS AppSync GraphQL API.
* `Aws\ConfigService` - AWS Config launches Custom Configuration Items. A new feature which allows customers to publish resource configuration for third-party resources, custom, or on-premises servers.
* `Aws\Connect` - This release adds a new API: StartChatContact. You can use it to programmatically start a chat on the specified Amazon Connect instance. Learn more here: https://docs.aws.amazon.com/connect/latest/APIReference/Welcome.html 
* `Aws\ConnectParticipant` - This release adds 5 new APIs: CreateParticipantConnection, DisconnectParticipant, GetTranscript, SendEvent, and SendMessage. For Amazon Connect chat, you can use them to programmatically perform participant actions on the configured Amazon Connect instance. Learn more here: https://docs.aws.amazon.com/connect-participant/latest/APIReference/Welcome.html
* `Aws\DynamoDB` - With this release, you can convert an existing Amazon DynamoDB table to a global table by adding replicas in other AWS Regions.
* `Aws\EC2` - This release adds support for attaching AWS License Manager Configurations to Amazon Machine Image (AMI) using ImportImage API; and adds support for running different instance sizes on EC2 Dedicated Hosts
* `Aws\Glue` - This release adds support for Glue 1.0 compatible ML Transforms.
* `Aws\LexModelBuildingService` - Amazon Lex now supports Sentiment Analysis
* `Aws\LexRuntimeService` - Amazon Lex now supports Sentiment Analysis
* `Aws\MarketplaceMetering` - Documentation updates for the AWS Marketplace Metering Service.
* `Aws\SSM` - The release contains new API and API changes for AWS Systems Manager Explorer product.
* `Aws\TranscribeService` - With this release, Amazon Transcribe now supports transcriptions from audio sources in Hebrew (he-IL), Swiss German (de-CH), Japanese (ja-JP), Turkish (tr-TR), Arabic-Gulf (ar-AE), Malay (ms-MY), Telugu (te-IN)

## 3.120.0 - 2019-11-20

* `Aws\ApplicationDiscoveryService` - New exception type for use with Migration Hub home region
* `Aws\Chime` - Adds APIs to create and manage meeting session resources for the Amazon Chime SDK
* `Aws\CloudTrail` -  1. This release adds two new APIs, GetInsightSelectors and PutInsightSelectors, which let you configure CloudTrail Insights event delivery on a trail. An Insights event is a new type of event that is generated when CloudTrail detects unusual activity in your AWS account. In this release, only "ApiCallRateInsight" is a supported Insights event type. 2. This release also adds the new "ExcludeManagementEventSource" option to the existing PutEventSelectors API. This field currently supports only AWS Key Management Services.
* `Aws\CodeCommit` - This release adds support for creating pull request approval rules and pull request approval rule templates in AWS CodeCommit. This allows developers to block merges of pull requests, contingent on the approval rules being satisfiied.
* `Aws\Credentials` - Tweak instance profile provider fallback behavior.
* `Aws\DLM` - DLM now supports Fast Snapshot Restore. You can enable Fast Restore on snapshots created by DLM, provide the AZs and the number of snapshots to be enabled with this capability.
* `Aws\DataSync` - Update to configure task to run periodically on a schedule
* `Aws\EC2` - This release of Amazon Elastic Compute Cloud (Amazon EC2) introduces support for Amazon Elastic Block Store (Amazon EBS) fast snapshot restores.
* `Aws\ECS` - Added support for CPU and memory task-level overrides on the RunTask and StartTask APIs. Added location information to Tasks.
* `Aws\FSx` - Announcing a Multi-AZ deployment type for Amazon FSx for Windows File Server, providing fully-managed Windows file storage with high availability and redundancy across multiple AWS Availability Zones.
* `Aws\Firehose` - With this release, Amazon Kinesis Data Firehose allows server side encryption with customer managed CMKs. Customer managed CMKs ( "Customer Master Keys") are AWS Key Management Service (KMS) keys that are fully managed by the customer. With customer managed CMKs, customers can establish and maintain their key policies, IAM policies, rotating policies and add tags. For more information about AWS KMS and CMKs, please refer to: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html. Please refer to the following link to create CMKs: https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-create-cmk.html
* `Aws\MediaStore` - This release fixes a broken link in the SDK documentation.
* `Aws\MigrationHub` - New exception type for use with Migration Hub home region
* `Aws\MigrationHubConfig` - AWS Migration Hub Config Service allows you to get and set the Migration Hub home region for use with AWS Migration Hub and Application Discovery Service
* `Aws\QuickSight` - Amazon QuickSight now supports programmatic creation and management of data sources, data sets, dashboards and templates with new APIs. Templates hold dashboard metadata, and can be used to create copies connected to the same or different dataset as required. Also included in this release are APIs for SPICE ingestions, fine-grained access control over AWS resources using AWS Identity and Access Management (IAM) policies, as well AWS tagging. APIs are supported for both Standard and Enterprise Edition, with edition-specific support for specific functionality.
* `Aws\S3` - This release introduces support for Amazon S3 Replication Time Control, a new feature of S3 Replication that provides a predictable replication time backed by a Service Level Agreement. S3 Replication Time Control helps customers meet compliance or business requirements for data replication, and provides visibility into the replication process with new Amazon CloudWatch Metrics.
* `Aws\StorageGateway` - The new DescribeAvailabilityMonitorTest API provides the results of the most recent High Availability monitoring test. The new StartAvailabilityMonitorTest API verifies the storage gateway is configured for High Availability monitoring. The new ActiveDirectoryStatus response element has been added to the DescribeSMBSettings and JoinDomain APIs to indicate the status of the gateway after the most recent JoinDomain operation. The new TimeoutInSeconds parameter of the JoinDomain API allows for the configuration of the timeout in which the JoinDomain operation must complete.
* `Aws\TranscribeService` - With this release Amazon Transcribe enables alternative transcriptions so that you can see different interpretations of transcribed audio.

## 3.119.0 - 2019-11-19

* `Aws\AutoScaling` - Amazon EC2 Auto Scaling now supports Instance Weighting and Max Instance Lifetime. Instance Weighting allows specifying the capacity units for each instance type included in the MixedInstancesPolicy and how they would contribute to your application's performance. Max Instance Lifetime allows specifying the maximum length of time that an instance can be in service. If any instances are approaching this limit, Amazon EC2 Auto Scaling gradually replaces them.
* `Aws\CloudFormation` - This release of AWS CloudFormation StackSets enables users to detect drift on a stack set and the stack instances that belong to that stack set.
* `Aws\CodeBuild` - Add support for ARM and GPU-enhanced build environments and a new SSD-backed Linux compute type with additional CPU and memory in CodeBuild
* `Aws\ConfigService` - AWSConfig launches support for conformance packs. A conformance pack is a new resource type that allows you to package a collection of Config rules and remediation actions into a single entity. You can create and deploy conformance packs into your account or across all accounts in your organization
* `Aws\Credentials` - Support new secure data flow for the calls to the Instance Metadata Service.
* `Aws\EC2` - This release adds support for RunInstances to specify the metadata options for new instances; adds a new API, ModifyInstanceMetadataOptions, which lets you modify the metadata options for a running or stopped instance; and adds support for CreateCustomerGateway to specify a device name.
* `Aws\ElasticLoadBalancingv2` - This release allows forward actions on Application Load Balancers to route requests to multiple target groups, based on the weight you specify for each target group.
* `Aws\IAM` - IAM reports the timestamp when a role's credentials were last used to make an AWS request. This helps you identify unused roles and remove them confidently from your AWS accounts.
* `Aws\IoT` - As part of this release, we are extending the capability of AWS IoT Rules Engine to send messages directly to customer's own web services/applications. Customers can now create topic rules with HTTP actions to route messages from IoT Core directly to URL's that they own. Ownership is proved by creating and confirming topic rule destinations.
* `Aws\Lambda` - This release provides three new runtimes to support Node.js 12 (initially 12.13.0), Python 3.8 and Java 11. 
* `Aws\S3` - Added support for S3 us-east-1 regional endpoint setting and corresponding configuration.

## 3.118.0 - 2019-11-18

* `Aws\CloudFormation` - This release introduces APIs for the CloudFormation Registry, a new service to submit and discover resource providers with which you can manage third-party resources natively in CloudFormation.
* `Aws\CostExplorer` - add EstimatedOnDemandCostWithCurrentCommitment to GetSavingsPlansPurchaseRecommendationRequest API
* `Aws\Pinpoint` - This release of the Amazon Pinpoint API introduces support for using and managing message templates for messages that are sent through the voice channel. It also introduces support for specifying default values for message variables in message templates. 
* `Aws\RDS` - Documentation updates for rds
* `Aws\S3` - Added support for S3 Replication for existing objects. This release allows customers who have requested and been granted access to replicate existing S3 objects across buckets.
* `Aws\SSM` - The release contains new API and API changes for AWS Systems Manager Explorer product.
* `Aws\SageMaker` - Amazon SageMaker now supports multi-model endpoints to host multiple models on an endpoint using a single inference container.
* `Aws\SageMakerRuntime` - Amazon SageMaker Runtime now supports a new TargetModel header to invoke a specific model hosted on multi model endpoints.

## 3.117.2 - 2019-11-15

* `Aws\Chime` - This release adds support for Chime Room Management APIs
* `Aws\CloudWatchLogs` - Documentation updates for logs
* `Aws\CognitoIdentityProvider` - This release adds a new option in the User Pool to allow specifying sender's name in the emails sent by Amazon Cognito. This release also adds support to add SES Configuration Set to the emails sent by Amazon Cognito.
* `Aws\EC2` - You can now add tags while copying snapshots. Previously, a user had to first copy the snapshot and then add tags to the copied snapshot manually. Moving forward, you can specify the list of tags you wish to be applied to the copied snapshot as a parameter on the Copy Snapshot API. 
* `Aws\EKS` - Introducing Amazon EKS managed node groups, a new feature that lets you easily provision worker nodes for Amazon EKS clusters and keep them up to date using the Amazon EKS management console, CLI, and APIs.
* `Aws\EMR` - Access to the cluster ARN makes it easier for you to author resource-level permissions policies in AWS Identity and Access Management. To simplify the process of obtaining the cluster ARN, Amazon EMR has added a new field containing the cluster ARN to all API responses that include the cluster ID.
* `Aws\ElasticLoadBalancingv2` - Documentation-only change to the default value of the routing.http.drop_invalid_header_fields.enabled attribute.
* `Aws\GuardDuty` - This release includes new operations related to findings export, including: CreatePublishingDestination, UpdatePublishingDestination, DescribePublishingDestination, DeletePublishingDestination and ListPublishingDestinations.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for DolbyVision encoding, and SCTE35 & ESAM insertion to DASH ISO EMSG.
* `Aws\SSM` - This release updates AWS Systems Manager Parameter Store documentation for the enhanced search capability.
* `Aws\WorkSpaces` - Added APIs to register your directories with Amazon WorkSpaces and to modify directory details. 

## 3.117.1 - 2019-11-14

* `Aws\CognitoIdentityProvider` - This release adds a new setting at user pool client to prevent user existence related errors during authentication, confirmation, and password recovery related operations. This release also adds support to enable or disable specific authentication flows for a user pool client.
* `Aws\Connect` - This release enhances the existing user management APIs and adds 3 new APIs - TagResource, UntagResource, and ListTagsForResource to support tagging Amazon Connect users, which facilitates more granular access controls for Amazon Connect users within an Amazon Connect instance. You can learn more about the new APIs here: https://docs.aws.amazon.com/connect/latest/APIReference/Welcome.html.
* `Aws\MarketplaceMetering` - Added CustomerNotEntitledException in MeterUsage API for Container use case.
* `Aws\Personalize` - Amazon Personalize: Adds ability to get batch recommendations by creating a batch inference job.
* `Aws\SSM` - Updates support for adding attachments to Systems Manager Automation documents

## 3.117.0 - 2019-11-13

* `Aws\CloudSearch` - Amazon CloudSearch domains let you require that all traffic to the domain arrive over HTTPS. This security feature helps you block clients that send unencrypted requests to the domain.
* `Aws\Credentials` - Adds extra catch block in AssumeRoleWithWebIdentityCredentialProvider to account for non-AWS exceptions.
* `Aws\DLM` - You can now add tags to a lifecycle policy in Data Lifecycle Manager (DLM). Tags allow you to categorize your policies in different ways, such as by department, purpose or owner. You can also enable resource level permissions based on tags to set access control on ability to modify or delete a tagged policy.
* `Aws\DataExchange` - Introducing AWS Data Exchange, a service that makes it easy for AWS customers to securely create, manage, access, and exchange data sets in the cloud.
* `Aws\IoT` - This release adds the custom fields definition support in the index definition for AWS IoT Fleet Indexing Service. Custom fields can be used as an aggregation field to run aggregations with both existing GetStatistics API and newly added GetCardinality, GetPercentiles APIs. GetStatistics will return all statistics (min/max/sum/avg/count...) with this release. For more information, please refer to our latest documentation: https://docs.aws.amazon.com/iot/latest/developerguide/iot-indexing.html
* `Aws\SesV2` - This is the first release of version 2 of the Amazon SES API. You can use this API to configure your Amazon SES account, and to send email. This API extends the functionality that exists in the previous version of the Amazon SES API.

## 3.116.0 - 2019-11-12

* `Aws\CodePipeline` - AWS CodePipeline now supports the use of variables in action configuration.
* `Aws\DynamoDB` - Amazon DynamoDB enables you to restore your data to a new DynamoDB table using a point-in-time or on-demand backup. You now can modify the settings on the new restored table. Specifically, you can exclude some or all of the local and global secondary indexes from being created with the restored table. In addition, you can change the billing mode and provisioned capacity settings.
* `Aws\ElasticLoadBalancingv2` - You can configure your Application Load Balancer to either drop invalid header fields or forward them to targets.
* `Aws\MarketplaceCatalog` - This is the first release for the AWS Marketplace Catalog service which allows you to list, describe and manage change requests on your published entities on AWS Marketplace. 
* `Aws\TranscribeService` - With this release, Amazon Transcribe now supports transcriptions from audio sources in Welsh English (en-WL), Scottish English(en-AB), Irish English(en-IE), Farsi(fa-IR), Tamil(ta-IN), Indonesian(id-ID), Portuguese (pt-PT), Dutch(nl-NL).

## 3.115.2 - 2019-11-11

* `Aws\CloudFormation` - The Resource Import feature enables customers to import existing AWS resources into new or existing CloudFormation Stacks.
* `Aws\CostExplorer` - This launch provides customers with access to GetCostAndUsageWithResources API.

## 3.115.1 - 2019-11-08

* `Aws\CognitoIdentity` - This release adds support for disabling classic flow.
* `Aws\ECR` - This release contains ticket fixes for Amazon ECR.

## 3.115.0 - 2019-11-07

* `Aws\Comprehend` - This release adds new languages (ar, hi, ko, ja, zh, zh-TW) for Amazon Comprehend's DetectSentiment, DetectEntities, DetectKeyPhrases, BatchDetectSentiment, BatchDetectEntities and BatchDetectKeyPhrases APIs
* `Aws\SSM` - AWS Systems Manager Session Manager target length increased to 400.
* `Aws\SSO` - This is an initial release of AWS Single Sign-On (SSO) end-user access. This release adds support for accessing AWS accounts assigned in AWS SSO using short term credentials.
* `Aws\SSOOIDC` - This is an initial release of AWS Single Sign-On OAuth device code authorization service.

## 3.114.1 - 2019-11-06

* `Aws\SavingsPlans` - This is the first release of Savings Plans, a new flexible pricing model that offers low prices on Amazon EC2 and AWS Fargate usage.

## 3.114.0 - 2019-11-06

* `Aws\Budgets` - Documentation updates for budgets to track Savings Plans utilization and coverage
* `Aws\CodeBuild` - Add support for Build Number, Secrets Manager and Exported Environment Variables.
* `Aws\CostExplorer` - This launch provides customers with access to Savings Plans management APIs.
* `Aws\EFS` - EFS customers can select a lifecycle policy that automatically moves files that have not been accessed for 7 days into the EFS Infrequent Access (EFS IA) storage class. EFS IA provides price/performance that is cost-optimized for files that are not accessed every day.
* `Aws\SavingsPlans` - This is the first release of Savings Plans, a new flexible pricing model that offers low prices on Amazon EC2 and AWS Fargate usage.
* `Aws\signer` - This release adds support for tagging code-signing profiles in AWS Signer.

## 3.113.0 - 2019-11-05

* `Aws\CodeStarNotifications` - This release adds a notification manager for events in repositories, build projects, deployments, and pipelines. You can now configure rules and receive notifications about events that occur for resources. Each notification includes a status message as well as a link to the resource (repository, build project, deployment application, or pipeline) whose event generated the notification.
* `Aws\RDS` - Documentation updates for Amazon RDS

## 3.112.35 - 2019-11-04

* `Aws\DAX` - Documentation updates for dax
* `Aws\EC2` - Documentation updates for ec2
* `Aws\RoboMaker` - RoboMaker Fleet Management launch a feature to verify your robot is ready to download and install the new robot application using a download condition file, which is a script run on the robot prior to downloading the new deployment. 

## 3.112.34 - 2019-11-01

* `Aws\CloudTrail` - This release adds two new APIs, GetTrail and ListTrails, and support for adding tags when you create a trail by using a new TagsList parameter on CreateTrail operations.
* `Aws\DatabaseMigrationService` - This release contains task timeline attributes in replication task statistics. This release also adds a note to the documentation for the CdcStartPosition task request parameter. This note describes how to enable the use of native CDC start points for a PostgreSQL source by setting the new slotName extra connection attribute on the source endpoint to the name of an existing logical replication slot.
* `Aws\Pinpoint` - This release of the Amazon Pinpoint API introduces support for using and managing journeys, and querying analytics data for journeys.

## 3.112.33 - 2019-10-31

* `Aws\Amplify` - This release of AWS Amplify Console introduces support for Web Previews. This feature allows user to create ephemeral branch deployments from pull request submissions made to a connected repository. A pull-request preview deploys every pull request made to your Git repository to a unique preview URL.
* `Aws\S3` - S3 Inventory now supports a new field 'IntelligentTieringAccessTier' that reports the access tier (frequent or infrequent) of objects stored in Intelligent-Tiering storage class.
* `Aws\Support` - The status descriptions for TrustedAdvisorCheckRefreshStatus have been updated

## 3.112.32 - 2019-10-30

* `Aws\ElastiCache` - Amazon ElastiCache for Redis 5.0.5 now allows you to modify authentication tokens by setting and rotating new tokens. You can now modify active tokens while in use, or add brand-new tokens to existing encryption-in-transit enabled clusters that were previously setup without authentication tokens. This is a two-step process that allows you to set and rotate the token without interrupting client requests.

## 3.112.31 - 2019-10-29

* `Aws\AppStream` - Adds support for providing domain names that can embed streaming sessions
* `Aws\Cloud9` - Added CREATING and CREATE_FAILED environment lifecycle statuses. 

## 3.112.30 - 2019-10-28

* `Aws\S3` - Adding support in SelectObjectContent for scanning a portion of an object specified by a scan range.

## 3.112.29 - 2019-10-28

* `Aws\ECR` - This release of Amazon Elastic Container Registry Service (Amazon ECR) introduces support for image scanning. This identifies the software vulnerabilities in the container image based on the Common Vulnerabilities and Exposures (CVE) database.
* `Aws\ElastiCache` - Amazon ElastiCache adds support for migrating Redis workloads hosted on Amazon EC2 into ElastiCache by syncing the data between the source Redis cluster and target ElastiCache for Redis cluster in real time. For more information, see https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/migrate-to-elasticache.html.
* `Aws\Transfer` - This release adds logical directories support to your AWS SFTP server endpoint, so you can now create logical directory structures mapped to Amazon Simple Storage Service (Amazon S3) bucket paths for users created and stored within the service. Amazon S3 bucket names and paths can now be hidden from AWS SFTP users, providing an additional level of privacy to meet security requirements. You can lock down your SFTP users' access to designated folders (commonly referred to as 'chroot'), and simplify complex folder structures for data distribution through SFTP without replicating files across multiple users.

## 3.112.28 - 2019-10-24

* `Aws\AppMesh` - This release adds support for the gRPC and HTTP/2 protocols.
* `Aws\Chime` - * This release introduces Voice Connector PDX region and defaults previously created Voice Connectors to IAD. You can create Voice Connector Groups and add region specific Voice Connectors to direct telephony traffic across AWS regions in case of regional failures. With this release you can add phone numbers to Voice Connector Groups and can bulk move phone numbers between Voice Connectors, between Voice Connector and Voice Connector Groups and between Voice Connector Groups. Voice Connector now supports additional settings to enable SIP Log capture. This is in addition to the launch of Voice Connector Cloud Watch metrics in this release. This release also supports assigning outbound calling name (CNAM) to AWS account and individual phone numbers assigned to Voice Connectors. * Voice Connector now supports a setting to enable real time audio streaming delivered via Kinesis Audio streams. Please note that recording Amazon Chime Voice Connector calls with this feature maybe be subject to laws or regulations regarding the recording of telephone calls and other electronic communications. AWS Customer and their end users' have the responsibility to comply with all applicable laws regarding the recording, including properly notifying all participants in a recorded session or to a recorded communication that the session or communication is being recorded and obtain their consent.
* `Aws\EC2` - This release updates CreateFpgaImage to support tagging FPGA images on creation
* `Aws\GameLift` - Amazon GameLift offers expanded hardware options for game hosting: Custom game builds can use the Amazon Linux 2 operating system, and fleets for both custom builds and Realtime servers can now use C5, M5, and R5 instance types.
* `Aws\SageMaker` - Adds support for the new family of Elastic Inference Accelerators (eia2) for SageMaker Hosting and Notebook Services

## 3.112.27 - 2019-10-23

* `Aws\Connect` - This release adds 4 new APIs ListQueues, ListPhoneNumbers, ListContactFlows, and ListHoursOfOperations, which can be used to programmatically list Queues, PhoneNumbers, ContactFlows, and HoursOfOperations configured for an Amazon Connect instance respectively. You can learn more about the new APIs here: https://docs.aws.amazon.com/connect/latest/APIReference/Welcome.html.
* `Aws\Polly` - Amazon Polly adds new female voices: US Spanish - Lupe and Brazilian Portuguese - Camila; both voices are available in Standard and Neural engine.
* `Aws\STS` - AWS Security Token Service (STS) now supports a regional configuration flag to make the client respect the region without the need for the endpoint parameter. 

## 3.112.26 - 2019-10-22

* `Aws\IoTEvents` - Add support for new serial evaluation method for events in a detector model.
* `Aws\OpsWorksCM` - AWS OpsWorks for Chef Automate (OWCA) now allows customers to use a custom domain and respective certificate, for their AWS OpsWorks For Chef Automate servers. Customers can now provide a CustomDomain, CustomCertificate and CustomPrivateKey in CreateServer API to configure their Chef Automate servers with a custom domain and certificate.

## 3.112.25 - 2019-10-18

* `Aws\CloudWatch` - New Period parameter added to MetricDataQuery structure.

## 3.112.24 - 2019-10-17

* `Aws\Batch` - Adding support for Compute Environment Allocation Strategies 
* `Aws\RDS` - Amazon RDS now supports Amazon RDS on VMware with the introduction of APIs related to Custom Availability Zones and Media installation.
* `Aws\WorkSpaces` - Updates Smoke Test

## 3.112.23 - 2019-10-16

* `Aws\Kafka` - AWS MSK has added support for adding brokers to a cluster.
* `Aws\MarketplaceCommerceAnalytics` - add 2 more values for the supporting sections - age of past due funds + uncollected funds breakdown
* `Aws\RoboMaker` - This release adds support for ROS2 Dashing as a beta feature

## 3.112.22 - 2019-10-15

* `Aws\KinesisVideoArchivedMedia` - Add ON_DISCONTINUITY mode to the GetHLSStreamingSessionURL API

## 3.112.21 - 2019-10-14

* `Aws\Personalize` - AWS Personalize: Adds ability to create a solution version using FULL or UPDATE training mode
* `Aws\WorkSpaces` - Documentation updates for WorkSpaces

## 3.112.20 - 2019-10-11

* `Aws\Greengrass` - Greengrass OTA service supports Raspbian/Armv6l platforms.

## 3.112.19 - 2019-10-10

* `Aws\EC2` - New EC2 M5n, M5dn, R5n, R5dn instances with 100 Gbps network performance and Elastic Fabric Adapter (EFA) for ultra low latency; New A1.metal bare metal instance powered by AWS Graviton Processors
* `Aws\FMS` - Firewall Manager now supports Amazon VPC security groups, making it easier to configure and manage security groups across multiple accounts from a single place.
* `Aws\IoTAnalytics` - Add `completionTime` to API call ListDatasetContents.
* `Aws\LexRuntimeService` - Amazon Lex now supports Session API checkpoints

## 3.112.18 - 2019-10-09

* `Aws\ElastiCache` - Amazon ElastiCache now allows you to apply available service updates on demand to your Memcached and Redis Cache Clusters. Features included: (1) Access to the list of applicable service updates and their priorities. (2) Service update monitoring and regular status updates. (3) Recommended apply-by-dates for scheduling the service updates. (4) Ability to stop and later re-apply updates. For more information, see https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/Self-Service-Updates.html and https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Self-Service-Updates.html
* `Aws\Kafka` - Updated documentation for Amazon Managed Streaming for Kafka service.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for Dolby Atmos encoding, up to 36 outputs, accelerated transcoding with frame capture and preferred acceleration feature.

## 3.112.17 - 2019-10-08

* `Aws\DataSync` - Add Sync options to enable/disable TaskQueueing
* `Aws\EventBridge` - Documentation updates for Amazon EventBridge.
* `Aws\Firehose` - With this release, you can use Amazon Kinesis Firehose delivery streams to deliver streaming data to Amazon Elasticsearch Service version 7.x clusters. For technical documentation, look for CreateDeliveryStream operation in Amazon Kinesis Firehose API reference.
* `Aws\Organizations` - Documentation updates for organizations

## 3.112.16 - 2019-10-07

* `Aws\DirectConnect` - This release adds a service provider field for physical connection creation and provides a list of available partner providers for each Direct Connect location.
* `Aws\Firehose` - Amazon Kinesis Data Firehose now allows delivering data to Elasticsearch clusters set up in a different AWS account than the Firehose AWS account. For technical documentation, look for ElasticsearchDestinationConfiguration in the Amazon Kinesis Firehose API reference.
* `Aws\Glue` - AWS Glue now provides ability to use custom certificates for JDBC Connections.
* `Aws\Pinpoint` - This release of the Amazon Pinpoint API introduces support for using and managing message templates.
* `Aws\PinpointEmail` - This release of the Amazon Pinpoint Email API introduces support for using and managing message templates.
* `Aws\Snowball` - AWS Snowball Edge now allows you to perform an offline update to the software of your Snowball Edge device when your device is not connected to the internet. Previously, updating your Snowball Edge's software required that the device be connected to the internet or be sent back to AWS. Now, you can keep your Snowball Edge software up to date even if your device(s) cannot connect to the internet, or are required to run in an air-gapped environment. To complete offline updates, download the software update from a client machine with connection to the internet using the AWS Command Line Interface (CLI). Then, have the Snowball Edge device download and install the software update using the Snowball Edge device API. For more information about offline updates, visit the Snowball Edge documentation page.

## 3.112.15 - 2019-10-04

* `Aws\CognitoIdentityProvider` - This release adds ClientMetadata input parameter to multiple Cognito User Pools operations, making this parameter available to the customer configured lambda triggers as applicable. 
* `Aws\MediaPackage` - New Harvest Job APIs to export segment-accurate content windows from MediaPackage Origin Endpoints to S3. See https://docs.aws.amazon.com/mediapackage/latest/ug/harvest-jobs.html for more info
* `Aws\SSM` - Documentation updates for Systems Manager / StartSession.

## 3.112.14 - 2019-10-03

* `Aws\ApplicationAutoScaling` - Documentation updates for Application Auto Scaling
* `Aws\Credentials` - Fixed an issue that the credentials by process provider won't cache.
* `Aws\DeviceFarm` - Documentation updates for devicefarm
* `Aws\EC2` - This release allows customers to purchase regional EC2 RIs on a future date.
* `Aws\ElasticsearchService` - Amazon Elasticsearch Service now supports configuring additional options for domain endpoint, such as whether to require HTTPS for all traffic.

## 3.112.13 - 2019-10-02

* `Aws\Lightsail` - This release adds support for the automatic snapshots add-on for instances and block storage disks.

## 3.112.12 - 2019-10-01

* `Aws\DocDB` - This release provides support for describe and modify CA certificates.

## 3.112.11 - 2019-09-30

* `Aws\MQ` - Amazon MQ now includes the ability to scale your brokers by changing the host instance type. See the hostInstanceType property of UpdateBrokerInput (https://docs.aws.amazon.com/amazon-mq/latest/api-reference/brokers-broker-id.html#brokers-broker-id-model-updatebrokerinput), and pendingHostInstanceType property of DescribeBrokerOutput (https://docs.aws.amazon.com/amazon-mq/latest/api-reference/brokers-broker-id.html#brokers-broker-id-model-describebrokeroutput).
* `Aws\RDS` - This release adds support for creating a Read Replica with Active Directory domain information. This release updates RDS API to indicate whether an OrderableDBInstanceOption supports Kerberos Authentication.
* `Aws\WAF` - Lowering the threshold for Rate Based rule from 2000 to 100.

## 3.112.10 - 2019-09-27

* `Aws\Amplify` - This release adds access logs APIs and artifact APIs for AWS Amplify Console.
* `Aws\ECS` - This release of Amazon Elastic Container Service (Amazon ECS) removes FirelensConfiguration from the DescribeTask output during the FireLens public preview.

## 3.112.9 - 2019-09-26

* `Aws\CodePipeline` - Documentation updates for CodePipeline
* `Aws\SSM` - This release updates the AWS Systems Manager Parameter Store PutParameter and LabelParameterVersion APIs to return the "Tier" of parameter created/updated and the "parameter version" labeled respectively. 

## 3.112.8 - 2019-09-25

* `Aws\DatabaseMigrationService` - This release adds a new DeleteConnection API to delete the connection between a replication instance and an endpoint. It also adds an optional S3 setting to specify the precision of any TIMESTAMP column values written to an S3 object file in .parquet format.
* `Aws\GlobalAccelerator` - API Update for AWS Global Accelerator to support for DNS aliasing.
* `Aws\SageMaker` - Enable G4D and R5 instances in SageMaker Hosting Services

## 3.112.7 - 2019-09-24

* `Aws\ComprehendMedical` - Use Amazon Comprehend Medical to analyze medical text stored in the specified Amazon S3 bucket. Use the console to create and manage batch analysis jobs, or use the batch APIs to detect both medical entities and protected health information (PHI). The batch APIs start, stop, list, and retrieve information about batch analysis jobs. This release also includes DetectEntitiesV2 operation which returns the Acuity and Direction entities as attributes instead of types.
* `Aws\DataSync` - Added S3StorageClass, OverwriteMode sync option, and ONLY_FILES_TRANSFERRED setting for the VerifyMode sync option.
* `Aws\S3` - Tweak S3 stream wrapper size logic for seekable streams.
* `Aws\TranscribeService` - With this update Amazon Transcribe enables you to provide an AWS KMS key to encrypt your transcription output.

## 3.112.6 - 2019-09-23

* `Aws\RDSDataService` - RDS Data API now supports Amazon Aurora Serverless PostgreSQL databases.
* `Aws\Redshift` - Adds API operation DescribeNodeConfigurationOptions and associated data structures.

## 3.112.5 - 2019-09-20

* `Aws\EC2` - G4 instances are Amazon EC2 instances based on NVIDIA T4 GPUs and are designed to provide cost-effective machine learning inference for applications, like image classification, object detection, recommender systems, automated speech recognition, and language translation. G4 instances are also a cost-effective platform for building and running graphics-intensive applications, such as remote graphics workstations, video transcoding, photo-realistic design, and game streaming in the cloud. To get started with G4 instances visit https://aws.amazon.com/ec2/instance-types/g4.
* `Aws\Greengrass` - Greengrass OTA service now returns the updated software version in the PlatformSoftwareVersion parameter of a CreateSoftwareUpdateJob response
* `Aws\RDS` - Add a new LeaseID output field to DescribeReservedDBInstances, which shows the unique identifier for the lease associated with the reserved DB instance. AWS Support might request the lease ID for an issue related to a reserved DB instance.
* `Aws\WorkSpaces` - Adds the WorkSpaces restore feature

## 3.112.4 - 2019-09-19

* `Aws\ECS` - This release of Amazon Elastic Container Service (Amazon ECS) introduces support for container image manifest digests. This enables you to identify all tasks launched using a container image pulled from ECR in order to correlate what was built with where it is running.
* `Aws\Glue` - AWS Glue DevEndpoints now supports GlueVersion, enabling you to choose Apache Spark 2.4.3 (in addition to Apache Spark 2.2.1). In addition to supporting the latest version of Spark, you will also have the ability to choose between Python 2 and Python 3.
* `Aws\MediaConnect` - When you grant an entitlement, you can now specify the percentage of the entitlement data transfer that you want the subscriber to be responsible for.

## 3.112.3 - 2019-09-18

* `Aws\APIGateway` - Amazon API Gateway simplifies accessing PRIVATE APIs by allowing you to associate one or more Amazon Virtual Private Cloud (VPC) Endpoints to a private API. API Gateway will create and manage DNS alias records necessary for easily invoking the private APIs. With this feature, you can leverage private APIs in web applications hosted within your VPCs.
* `Aws\RAM` - AWS RAM provides a new ListPendingInvitationResources API action that lists the resources in a resource share that is shared with you but that the invitation is still pending for
* `Aws\WAFRegional` - Lowering the threshold for Rate Based rule from 2000 to 100.

## 3.112.2 - 2019-09-17

* `Aws\` - Respect client region when assuming credential role via web identity token.
* `Aws\Athena` - This release adds DataManifestLocation field indicating the location and file name of the data manifest file. Users can get a list of files that the Athena query wrote or intended to write from the manifest file.
* `Aws\IAM` - Documentation updates for iam
* `Aws\Personalize` - [Personalize] Adds trainingHours to solutionVersion properties.

## 3.112.1 - 2019-09-16

* `Aws\EKS` - This release lets customers add tags to an Amazon EKS cluster. These tags can be used to control access to the EKS API for managing the cluster using IAM. The Amazon EKS TagResource API allows customers to associate tags with their cluster. Customers can list tags for a cluster using the ListTagsForResource API and remove tags from a cluster with the UntagResource API. Note: tags are specific to the EKS cluster resource, they do not propagate to other AWS resources used by the cluster.
* `Aws\MediaConvert` - AWS Elemental MediaConvert SDK has added support for multi-DRM SPEKE with CMAF outputs, MP3 ingest, and options for improved video quality.

## 3.112.0 - 2019-09-12

* `Aws\EC2` - Fix for FleetActivityStatus and FleetStateCode enum
* `Aws\ElasticLoadBalancingv2` - Documentation updates for elasticloadbalancingv2: This release adds support for TLS SNI on Network Load Balancers 
* `Aws\MediaLive` - AWS Elemental MediaLive now supports High Efficiency Video Coding (HEVC) for standard-definition (SD), high-definition (HD), and ultra-high-definition (UHD) encoding with HDR support.Encoding with HEVC offers a number of advantages. While UHD video requires an advanced codec beyond H.264 (AVC), high frame rate (HFR) or High Dynamic Range (HDR) content in HD also benefit from HEVC's advancements. In addition, benefits can be achieved with HD and SD content even if HDR and HFR are not needed.
* `Aws\WorkMailMessageFlow` - This release allows customers to access email messages as they flow to and from Amazon WorkMail.

## 3.111.2 - 2019-09-11

* `Aws\ConfigService` - Adding input validation for the OrganizationConfigRuleName string.
* `Aws\EC2` - This release adds support for new data fields and log format in VPC flow logs.
* `Aws\MediaConnect` - This release adds support for the RIST protocol on sources and outputs.
* `Aws\RDS` - This release allows customers to specify a custom parameter group when creating a Read Replica, for DB engines which support this feature.
* `Aws\SES` - Updated API documentation to correct broken links, and to update content based on customer feedback.
* `Aws\SFN` - Fixing letter case in Map history event details to be small case

## 3.111.1 - 2019-09-10

* `Aws\StorageGateway` - The CloudWatchLogGroupARN parameter of the UpdateGatewayInformation API allows for configuring the gateway to use a CloudWatch log-group where Storage Gateway health events will be logged. 

## 3.111.0 - 2019-09-09

* `Aws\AppMesh` - This release adds support for http retry policies.
* `Aws\AppStream` - IamRoleArn support in CreateFleet, UpdateFleet, CreateImageBuilder APIs
* `Aws\EC2` - This release expands Site-to-Site VPN tunnel options to allow customers to restrict security algorithms and configure timer settings for VPN connections. Customers can specify these new options while creating new VPN connections, or they can modify the tunnel options on existing connections using a new API.
* `Aws\MarketplaceCommerceAnalytics` - Add FDP+FPS (monthly_revenue_field_demonstration_usage + monthly_revenue_flexible_payment_schedule) to Marketplace Commerce Analytics Service
* `Aws\QLDB` - (New Service) Amazon QLDB is a fully managed ledger database that provides a transparent, immutable, and cryptographically verifiable transaction log owned by a central trusted authority. Amazon QLDB is a new class of serverless database that eliminates the need to engage in the complex development effort of building your own ledger-like applications and it automatically scales to support the demands of your application. Introduces Amazon QLDB API operations needed for managing Amazon QLDB ledgers. This includes the ability to manage Amazon QLDB ledgers, cryptographically verify documents, and export the journal in a ledger.
* `Aws\QLDBSession` - (New Service) Amazon QLDB is a fully managed ledger database that provides a transparent, immutable, and cryptographically verifiable transaction log owned by a central trusted authority. Amazon QLDB is a new class of serverless database that eliminates the need to engage in the complex development effort of building your own ledger-like applications and it automatically scales to support the demands of your application. Introduces Amazon QLDB API operations needed for interacting with data in Amazon QLDB ledgers.
* `Aws\RoboMaker` - Support for Connectivity to Simulation. When you need to interact with the applications in your simulation job, you can connect to your robot application or simulation application with port forwarding. When you configure port forwarding, traffic will be forwarded from the simulation job port to the application port. Port forwarding makes it easy to connect with tools such as ROS Bridge and other tools. This can be useful when you want to debug or run custom tools to interact with your applications. 

## 3.110.11 - 2019-09-06

* `Aws\KinesisAnalytics` - Documentation updates for kinesisanalytics

## 3.110.10 - 2019-09-05

* `Aws\ConfigService` - AWS Config now includes the option for marking RemediationConfigurations as automatic, removing the need to call the StartRemediationExecution API. Manual control over resource execution rate is also included, and RemediationConfigurations are now ARN addressable. Exceptions to exclude account resources from being remediated can be configured with the new PutRemediationExceptions, DescribeRemediationExceptions, and DeleteRemediationExceptions APIs.

## 3.110.9 - 2019-09-04

* `Aws\EKS` - Amazon EKS DescribeCluster API returns a new OIDC issuer field that can be used to create OIDC identity provider for IAM for Service Accounts feature.
* `Aws\SFN` - Added support for new history events
* `Aws\TranscribeService` - MediaFormat is now optional for StartTranscriptionJob API.

## 3.110.8 - 2019-09-03

* `Aws\ECS` - This release of Amazon Elastic Container Service (Amazon ECS) introduces support for attaching Amazon Elastic Inference accelerators to your containers. This enables you to run deep learning inference workloads with hardware acceleration in a more efficient way.
* `Aws\GameLift` - You can now make use of PKI resources to provide more secure connections between your game clients and servers. To learn more, please refer to the public Amazon GameLift documentation.
* `Aws\ResourceGroupsTaggingAPI` - Documentation updates for resourcegroupstaggingapi

## 3.110.7 - 2019-08-30

* `Aws\ApiGatewayManagementApi` - You can use getConnection to return information about the connection (when it is connected, IP address, etc) and deleteConnection to disconnect the given connection
* `Aws\ECS` - This release of Amazon Elastic Container Service (Amazon ECS) introduces support for modifying the cluster settings for existing clusters, which enables you to toggle whether Container Insights is enabled or not. Support is also introduced for custom log routing using the ECS FireLens integration.
* `Aws\MQ` - Adds support for updating security groups selection of an Amazon MQ broker.

## 3.110.6 - 2019-08-29

* `Aws\ApplicationAutoScaling` - With the current release, you can suspend and later resume any of the following scaling actions in Application Auto Scaling: scheduled scaling actions, dynamic scaling in actions, dynamic scaling out actions.
* `Aws\CodePipeline` - Introducing pipeline execution trigger details in ListPipelineExecutions API.
* `Aws\ECS` - This release of Amazon Elastic Container Service (Amazon ECS) introduces support for including Docker container IDs in the API response when describing and stopping tasks. This enables customers to easily map containers to the tasks they are associated with.
* `Aws\ElastiCache` - Amazon ElastiCache for Redis now supports encryption at rest using customer managed customer master keys (CMKs) in AWS Key Management Service (KMS). Amazon ElastiCache now supports cluster names upto 40 characters for replicationGoups and upto 50 characters for cacheClusters.
* `Aws\Lambda` - Adds a "MaximumBatchingWindowInSeconds" parameter to event source mapping api's. Usable by Dynamodb and Kinesis event sources.

## 3.110.5 - 2019-08-28

* `Aws\GlobalAccelerator` - API Update for AWS Global Accelerator Client IP Preservation
* `Aws\MediaConvert` - This release adds the ability to send a job to an on-demand queue while simulating the performance of a job sent to a reserved queue. Use this setting to estimate the number of reserved transcoding slots (RTS) you need for a reserved queue.
* `Aws\SQS` - Added support for message system attributes, which currently lets you send AWS X-Ray trace IDs through Amazon SQS.

## 3.110.4 - 2019-08-27

* `Aws\Organizations` - Documentation updates for organizations

## 3.110.3 - 2019-08-26

* `Aws\` - Fixes EventParsingIterator example
* `Aws\SSM` - This feature adds "default tier" to the AWS Systems Manager Parameter Store for parameter creation and update. AWS customers can now set the "default tier" to one of the following values: Standard (default), Advanced or Intelligent-Tiering. This allows customers to create advanced parameters or parameters in corresponding tiers with one setting rather than code change to specify parameter tiers.
* `Aws\SecurityHub` - This release resolves an issue with the DescribeHub action, changes the MasterId and InvitationId parameters for AcceptInvitation to Required, and changes the AccountIds parameter for DeleteInvitations and DeclineInvitations to Required.

## 3.110.2 - 2019-08-23

* `Aws\EC2` - This release of EC2 VM Import Export adds support for exporting Amazon Machine Image(AMI)s to a VM file
* `Aws\MediaPackageVod` - Adds optional Constant Initialization Vector (IV) to HLS Encryption for MediaPackage VOD.
* `Aws\TranscribeService` - Amazon Transcribe - support transcriptions from audio sources in Russian (ru-RU) and Chinese (zh-CN).

## 3.110.1 - 2019-08-22

* `Aws\DataSync` - This release adds support for SMB location type.
* `Aws\RDS` - This release allows users to enable RDS Data API while creating Aurora Serverless databases. 
* `Aws\Test\Integ` - Modifies waiter settings for S3 integration test.

## 3.110.0 - 2019-08-21

* `Aws\ElastiCache` - ElastiCache extends support for Scale down for Redis Cluster-mode enabled and disabled replication groups 
* `Aws\ForecastQueryService` - Amazon Forecast is a fully managed machine learning service that makes it easy for customers to generate accurate forecasts using their historical time-series data
* `Aws\ForecastService` - Amazon Forecast is a fully managed machine learning service that makes it easy for customers to generate accurate forecasts using their historical time-series data
* `Aws\PersonalizeRuntime` - Increased limits on number of items recommended and reranked: The maximum number of results returned from getRecommendations API has been increased to 200. The maximum number of items which can be reranked via getPersonalizedRanking API has been increased to 200.
* `Aws\Rekognition` - Documentation updates for Amazon Rekognition.
* `Aws\SQS` - This release provides a way to add metadata tags to a queue when it is created. You can use tags to organize and identify your Amazon SQS queues for cost allocation.
* `Aws\SageMaker` - Amazon SageMaker now supports Amazon EFS and Amazon FSx for Lustre file systems as data sources for training machine learning models. Amazon SageMaker now supports running training jobs on ml.p3dn.24xlarge instance type. This instance type is offered as a limited private preview for certain SageMaker customers. If you are interested in joining the private preview, please reach out to the SageMaker Product Management team via AWS Support."

## 3.109.8 - 2019-08-20

* `Aws\AlexaForBusiness` - Adding support for optional locale input in CreateProfile and UpdateProfile APIs
* `Aws\AppStream` - Includes API updates to support streaming through VPC endpoints for image builders and stacks.
* `Aws\SageMaker` - Amazon SageMaker introduces Managed Spot Training. Increases the maximum number of metric definitions to 40 for SageMaker Training and Hyperparameter Tuning Jobs. SageMaker Neo adds support for Acer aiSage and Qualcomm QCS605 and QCS603. 
* `Aws\Transfer` - New field in response of TestIdentityProvider

## 3.109.7 - 2019-08-19

* `Aws\AppMesh` - Fix for HttpMethod enum
* `Aws\CostandUsageReportService` - New IAM permission required for editing AWS Cost and Usage Reports - Starting today, you can allow or deny IAM users permission to edit Cost & Usage Reports through the API and the Billing and Cost Management console. To allow users to edit Cost & Usage Reports, ensure that they have 'cur: ModifyReportDefinition' permission. Refer to the technical documentation (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_cur_ModifyReportDefinition.html) for additional details.

## 3.109.6 - 2019-08-16

* `Aws\ECS` - This release of Amazon Elastic Container Service (Amazon ECS) introduces support for controlling the usage of swap space on a per-container basis for Linux containers.
* `Aws\EMR` - Amazon EMR has introduced an account level configuration called Block Public Access that allows you to block clusters with ports open to traffic from public IP sources (i.e. 0.0.0.0/0 for IPv4 and ::/0 for IPv6) from launching. Individual ports or port ranges can be added as exceptions to allow public access.
* `Aws\RoboMaker` - Two feature release: 1. AWS RoboMaker introduces log-based simulation. Log-based simulation allows you to play back pre-recorded log data such as sensor streams for testing robotic functions like localization, mapping, and object detection. Use the AWS RoboMaker SDK to test your robotic applications. 2. AWS RoboMaker allow customer to setup a robot deployment timeout when CreateDeploymentJob.

## 3.109.5 - 2019-08-15

* `Aws\AppMesh` - This release adds support for http header based routing and route prioritization.
* `Aws\Athena` - This release adds support for querying S3 Requester Pays buckets. Users can enable this feature through their Workgroup settings.
* `Aws\CodeCommit` - This release adds an API, BatchGetCommits, that allows retrieval of metadata for multiple commits in an AWS CodeCommit repository.
* `Aws\EC2` - This release adds an option to use private certificates from AWS Certificate Manager (ACM) to authenticate a Site-to-Site VPN connection's tunnel endpoints and customer gateway device. 
* `Aws\Glue` - GetJobBookmarks API is withdrawn.
* `Aws\StorageGateway` - CreateSnapshotFromVolumeRecoveryPoint API supports new parameter: Tags (to be attached to the created resource)

## 3.109.4 - 2019-08-14

* `Aws\EC2` - This release adds a new API called SendDiagnosticInterrupt, which allows you to send diagnostic interrupts to your EC2 instance.

## 3.109.3 - 2019-08-13

* `Aws\AppSync` - Adds a configuration option for AppSync GraphQL APIs

## 3.109.2 - 2019-08-12

* `Aws\ApplicationAutoScaling` - Documentation updates for Application Auto Scaling
* `Aws\AutoScaling` - Amazon EC2 Auto Scaling now supports a new Spot allocation strategy "capacity-optimized" that fulfills your request using Spot Instance pools that are optimally chosen based on the available Spot capacity.
* `Aws\CloudWatch` - Documentation updates for monitoring
* `Aws\Rekognition` - Adding new Emotion, Fear

## 3.109.1 - 2019-08-09

* `Aws\` - Retry InvalidIdentityToken errors for AssumeRoleWithWebIdentityCredentialProvider
* `Aws\GuardDuty` - New "evidence" field in the finding model to provide evidence information explaining why the finding has been triggered. Currently only threat-intelligence findings have this field. Some documentation updates.
* `Aws\IoT` - This release adds Quality of Service (QoS) support for AWS IoT rules engine republish action.
* `Aws\LexRuntimeService` - Manage Amazon Lex session state using APIs on the client
* `Aws\MediaConvert` - AWS Elemental MediaConvert has added support for multi-DRM SPEKE with CMAF outputs, MP3 ingest, and options for improved video quality. 
* `Aws\Redshift` - Add expectedNextSnapshotScheduleTime and expectedNextSnapshotScheduleTimeStatus to redshift cluster object.
* `Aws\Test\Integ` - Add waiter to S3 integration test to prevent failed bucket deletions on cleanup.

## 3.109.0 - 2019-08-08

* `Aws\CodeBuild` - CodeBuild adds CloudFormation support for SourceCredential
* `Aws\Glue` - You can now use AWS Glue to find matching records across dataset even without identifiers to join on by using the new FindMatches ML Transform. Find related products, places, suppliers, customers, and more by teaching a custom machine learning transformation that you can use to identify matching matching records as part of your analysis, data cleaning, or master data management project by adding the FindMatches transformation to your Glue ETL Jobs. If your problem is more along the lines of deduplication, you can use the FindMatches in much the same way to identify customers who have signed up more than ones, products that have accidentally been added to your product catalog more than once, and so forth. Using the FindMatches MLTransform, you can teach a Transform your definition of a duplicate through examples, and it will use machine learning to identify other potential duplicates in your dataset. As with data integration, you can then use your new Transform in your deduplication projects by adding the FindMatches transformation to your Glue ETL Jobs. This release also contains additional APIs that support AWS Lake Formation.
* `Aws\LakeFormation` - Lake Formation: (New Service) AWS Lake Formation is a fully managed service that makes it easier for customers to build, secure and manage data lakes. AWS Lake Formation simplifies and automates many of the complex manual steps usually required to create data lakes including collecting, cleaning and cataloging data and securely making that data available for analytics and machine learning.
* `Aws\OpsWorksCM` - This release adds support for Chef Automate 2 specific engine attributes.

## 3.108.6 - 2019-08-07

* `Aws\ApplicationInsights` - CloudWatch Application Insights for .NET and SQL Server now provides integration with AWS Systems Manager OpsCenter. This integration allows you to view and resolve problems and operational issues detected for selected applications.

## 3.108.5 - 2019-08-06

* `Aws\Batch` - Documentation updates for AWS Batch

## 3.108.4 - 2019-08-05

* `Aws\DataSync` - Support VPC endpoints.
* `Aws\EC2` - Amazon EC2 now supports a new Spot allocation strategy "Capacity-optimized" that fulfills your request using Spot Instance pools that are optimally chosen based on the available Spot capacity.
* `Aws\IoT` - In this release, AWS IoT Device Defender introduces audit mitigation actions that can be applied to audit findings to help mitigate security issues.

## 3.108.3 - 2019-08-02

* `Aws\` - Added static code analysis using PHPStan to Travis CI configuration.
* `Aws\STS` - Documentation updates for sts

## 3.108.2 - 2019-07-30

* `Aws\MediaConvert` - MediaConvert adds support for specifying priority (-50 to 50) on jobs submitted to on demand or reserved queues
* `Aws\Polly` - Amazon Polly adds support for Neural text-to-speech engine.
* `Aws\Route53` - Amazon Route 53 now supports the Middle East (Bahrain) Region (me-south-1) for latency records, geoproximity records, and private DNS for Amazon VPCs in that region.

## 3.108.1 - 2019-07-29

* `Aws\CodeCommit` - This release supports better exception handling for merges.

## 3.108.0 - 2019-07-26

* `Aws\Batch` - AWS Batch now supports SDK auto-pagination and Job-level docker devices.
* `Aws\CloudWatchLogs` - Allow for specifying multiple log groups in an Insights query, and deprecate storedByte field for LogStreams and interleaved field for FilterLogEventsRequest.
* `Aws\CostExplorer` - Adds support for resource optimization recommendations.
* `Aws\Credentials` - Update web identity provider to handle all exceptions.
* `Aws\EC2` - You can now create EC2 Capacity Reservations using Availability Zone ID or Availability Zone name. You can view usage of Amazon EC2 Capacity Reservations per AWS account.
* `Aws\Glue` - This release provides GetJobBookmark and GetJobBookmarks APIs. These APIs enable users to look at specific versions or all versions of the JobBookmark for a specific job. This release also enables resetting the job bookmark to a specific run via an enhancement of the ResetJobBookmark API.
* `Aws\Greengrass` - Greengrass OTA service supports openwrt/aarch64 and openwrt/armv7l platforms.
* `Aws\MediaConnect` - This release adds support for the Zixi pull protocol on outputs.
* `Aws\Sts` - Added support for STS regional endpoints and corresponding configuration.

## 3.107.8 - 2019-07-25

* `Aws\ECR` - This release adds support for immutable image tags.
* `Aws\MediaConvert` - AWS Elemental MediaConvert has added several features including support for: audio normalization using ITU BS.1770-3, 1770-4 algorithms, extension of job progress indicators, input cropping rectangle & output position rectangle filters per input, and dual SCC caption mapping to additional codecs and containers. 
* `Aws\MediaLive` - AWS Elemental MediaLive is adding Input Clipping, Immediate Mode Input Switching, and Dynamic Inputs.

## 3.107.7 - 2019-07-24

* `Aws\EC2` - This release introduces support for split tunnel with AWS Client VPN, and also adds support for opt-in Regions in DescribeRegions API. In addition, customers can now also tag Launch Templates on creation.
* `Aws\Glue` - This release provides GlueVersion option for Job APIs and WorkerType option for DevEndpoint APIs. Job APIs enable users to pick specific GlueVersion for a specific job and pin the job to a specific runtime environment. DevEndpoint APIs enable users to pick different WorkerType for memory intensive workload.
* `Aws\Pinpoint` - This release adds support for programmatic access to many of the same campaign metrics that are displayed on the Amazon Pinpoint console. You can now use the Amazon Pinpoint API to monitor and assess performance data for campaigns, and integrate metrics data with other reporting tools. We update the metrics data continuously, resulting in a data latency timeframe that is limited to approximately two hours.
* `Aws\STS` - New STS GetAccessKeyInfo API operation that returns the account identifier for the specified access key ID.

## 3.107.6 - 2019-07-23

* `Aws\SSM` - You can now use Maintenance Windows to select a resource group as the target. By selecting a resource group as the target of a Maintenance Window, customers can perform routine tasks across different resources such as Amazon Elastic Compute Cloud (AmazonEC2) instances, Amazon Elastic Block Store (Amazon EBS) volumes, and Amazon Simple Storage Service(Amazon S3) buckets within the same recurring time window.
* `Aws\SecretsManager` - This release increases the maximum allowed size of SecretString or SecretBinary from 7KB to 10KB in the CreateSecret, UpdateSecret, PutSecretValue and GetSecretValue APIs. This release also increases the maximum allowed size of ResourcePolicy from 4KB to 20KB in the GetResourcePolicy and PutResourcePolicy APIs.

## 3.107.5 - 2019-07-22

* `Aws\MQ` - Adds support for AWS Key Management Service (KMS) to offer server-side encryption. You can now select your own customer managed CMK, or use an AWS managed CMK in your KMS account.
* `Aws\Shield` - Adding new VectorType (HTTP_Reflection) and related top contributor types to describe WordPress Pingback DDoS attacks.

## 3.107.4 - 2019-07-19

* `Aws\IoTEvents` - Adds support for IoT Events, Lambda, SQS and Kinesis Firehose actions.
* `Aws\SQS` - This release updates the information about the availability of FIFO queues and includes miscellaneous fixes.

## 3.107.3 - 2019-07-18

* `Aws\CodeDeploy` - Documentation updates for codedeploy
* `Aws\Comprehend` - Amazon Comprehend now supports multiple entities for custom entity recognition
* `Aws\ECS` - This release of Amazon Elastic Container Service (Amazon ECS) introduces support for cluster settings. Cluster settings specify whether CloudWatch Container Insights is enabled or disabled for the cluster.
* `Aws\ElastiCache` - Updates for Elasticache

## 3.107.2 - 2019-07-17

* `Aws\AutoScaling` - Documentation updates for autoscaling
* `Aws\ConfigService` - This release adds more granularity to the status of an OrganizationConfigRule by adding a new status. It also adds an exception when organization access is denied.
* `Aws\Credentials` - Adds retry option for invalid json returned to instance profile credential provider.
* `Aws\DatabaseMigrationService` - S3 endpoint settings update: 1) Option to append operation column to full-load files. 2) Option to add a commit timestamp column to full-load and cdc files. Updated DescribeAccountAttributes to include UniqueAccountIdentifier.

## 3.107.1 - 2019-07-12

* `Aws\ApiGatewayV2` - Bug fix (Add tags field to Update Stage , Api and DomainName Responses )
* `Aws\Build` - Adds API documentation generation for modeled exception error shapes.
* `Aws\ElasticsearchService` - Amazon Elasticsearch Service now supports M5, C5, and R5 instance types.
* `Aws\IAM` - Removed exception that was indicated but never thrown for IAM GetAccessKeyLastUsed API
* `Aws\RoboMaker` - Added Melodic as a supported Robot Software Suite Version
* `Aws\Test` - Add back partition endpoint tests for DynamoDb local endpoints.

## 3.107.0 - 2019-07-11

* `Aws\CloudWatchEvents` - Adds APIs for partner event sources, partner event buses, and custom event buses. These new features are managed in the EventBridge service.
* `Aws\EventBridge` - Amazon EventBridge is a serverless event bus service that makes it easy to connect your applications with data from a variety of sources, including AWS services, partner applications, and your own applications.

## 3.106.1 - 2019-07-10

* `Aws\Credentials` - Fixes empty or unknown profile name causing error in default chain.
* `Aws\Glacier` - Documentation updates for glacier
* `Aws\QuickSight` - Amazon QuickSight now supports embedding dashboards for all non-federated QuickSight users. This includes IAM users, AD users and users from the QuickSight user pool. The get-dashboard-embed-url API accepts QUICKSIGHT as identity type with a user ARN to authenticate the embeddable dashboard viewer as a non-federated user.
* `Aws\ServiceCatalog` - This release adds support for Parameters in ExecuteProvisionedProductServiceAction and adds functionality to get the default parameter values for a Self-Service Action execution against a Provisioned Product via DescribeServiceActionExecutionParameters

## 3.106.0 - 2019-07-09

* `Aws\` - Added support for assuming credential role via web identity token.
* `Aws\Amplify` - This release adds webhook APIs and manual deployment APIs for AWS Amplify Console.
* `Aws\CloudWatch` - This release adds three new APIs (PutAnomalyDetector, DeleteAnomalyDetector, and DescribeAnomalyDetectors) to support the new feature, CloudWatch Anomaly Detection. In addition, PutMetricAlarm and DescribeAlarms APIs are updated to support management of Anomaly Detection based alarms.
* `Aws\ConfigService` - AWS Config now supports a new set of APIs to manage AWS Config rules across your organization in AWS Organizations. Using this capability, you can centrally create, update, and delete AWS Config rules across all accounts in your organization. This capability is particularly useful if you have a need to deploy a common set of AWS Config rules across all accounts. You can also specify accounts where AWS Config rules should not be created. In addition, you can use these APIs from the master account in AWS Organizations to enforce governance by ensuring that the underlying AWS Config rules are not modifiable by your organization member accounts.These APIs work for both managed and custom AWS Config rules. For more information, see Enabling AWS Config Rules Across all Accounts in Your Organization in the AWS Config Developer Guide.The new APIs are available in all commercial AWS Regions where AWS Config and AWS Organizations are supported. For the full list of supported Regions, see AWS Regions and Endpoints in the AWS General Reference. To learn more about AWS Config, visit the AWS Config webpage. To learn more about AWS Organizations, visit the AWS Organizations webpage.
* `Aws\EFS` - EFS customers can now enable Lifecycle Management for all file systems. You can also now select from one of four Lifecycle Management policies (14, 30, 60 and 90 days), to automatically move files that have not been accessed for the period of time defined by the policy, from the EFS Standard storage class to the EFS Infrequent Access (IA) storage class. EFS IA provides price/performance that is cost-optimized for files that are not accessed every day.
* `Aws\Functions` - Avoid repeatedly loading compiled JSON.
* `Aws\GameLift` - GameLift FlexMatch now supports matchmaking of up to 200 players per game session, and FlexMatch can now automatically backfill your game sessions whenever there is an open slot.
* `Aws\KinesisVideo` - Add "GET_DASH_STREAMING_SESSION_URL" as an API name to the GetDataEndpoint API.
* `Aws\KinesisVideoArchivedMedia` - Adds support for the GetDASHStreamingSessionURL API. Also adds support for the Live Replay playback mode of the GetHLSStreamingSessionURL API.
* `Aws\WAF` - Updated SDK APIs to add tags to WAF Resources: WebACL, Rule, Rulegroup and RateBasedRule. Tags can also be added during creation of these resources.
* `Aws\WAFRegional` - Updated SDK APIs to add tags to WAF Resources: WebACL, Rule, Rulegroup and RateBasedRule. Tags can also be added during creation of these resources.

## 3.105.0 - 2019-07-08

* `Aws\Api` - Added support for unmarshalling modeled exception data returned by services.
* `Aws\CostExplorer` - This release introduces a new operation called GetUsageForecast, which allows you to programmatically access AWS Cost Explorer's forecasting engine on usage data (running hours, data transfer, etc).
* `Aws\DynamoDb` - Added support configuring data attribute type as 'binary', defaults to 'string'.
* `Aws\S3` - Added support for passing options to presign via createPresignedRequest.

## 3.104.1 - 2019-07-03

* `Aws\EC2` - AssignPrivateIpAddresses response includes two new fields: AssignedPrivateIpAddresses, NetworkInterfaceId
* `Aws\RDS` - This release supports Cross-Account Cloning for Amazon Aurora clusters.
* `Aws\S3` - Add S3 x-amz-server-side-encryption-context support.
* `Aws\SWF` - This release adds APIs that allow adding and removing tags to a SWF domain, and viewing tags for a domain. It also enables adding tags when creating a domain.

## 3.104.0 - 2019-07-02

* `Aws\AppStream` - Adding ImageBuilderName in Fleet API and Documentation updates for AppStream. 
* `Aws\ClientSideMonitoring` - Added client configuration options for client-side monitoring.
* `Aws\MediaStore` - This release adds support for tagging, untagging, and listing tags for AWS Elemental MediaStore containers.

## 3.103.2 - 2019-07-01

* `Aws\DocDB` - This release provides support for cluster delete protection and the ability to stop and start clusters.
* `Aws\EC2` - This release adds support for specifying a maximum hourly price for all On-Demand and Spot instances in both Spot Fleet and EC2 Fleet.
* `Aws\Organizations` - Specifying the tag key and tag value is required for tagging requests.
* `Aws\RDS` - This release adds support for RDS DB Cluster major version upgrade 

## 3.103.1 - 2019-06-28

* `Aws\AlexaForBusiness` - This release allows developers and customers to add SIP addresses and international phone numbers to contacts.
* `Aws\EC2` - You can now launch 8xlarge and 16xlarge instance sizes on the general purpose M5 and memory optimized R5 instance types.
* `Aws\Redshift` - ClusterAvailabilityStatus: The availability status of the cluster for queries. Possible values are the following: Available, Unavailable, Maintenance, Modifying, Failed.
* `Aws\WorkSpaces` - Minor API fixes for WorkSpaces.

## 3.103.0 - 2019-06-27

* `Aws\DirectConnect` - Tags will now be included in the API responses of all supported resources (Virtual interfaces, Connections, Interconnects and LAGs). You can also add tags while creating these resources.
* `Aws\EC2InstanceConnect` - Amazon EC2 Instance Connect is a simple and secure way to connect to your instances using Secure Shell (SSH). With EC2 Instance Connect, you can control SSH access to your instances using AWS Identity and Access Management (IAM) policies as well as audit connection requests with AWS CloudTrail events. In addition, you can leverage your existing SSH keys or further enhance your security posture by generating one-time use SSH keys each time an authorized user connects.
* `Aws\Pinpoint` - This release includes editorial updates for the Amazon Pinpoint API documentation.
* `Aws\WorkSpaces` - Added support for the WorkSpaces restore feature and copying WorkSpaces Images across AWS Regions.

## 3.102.1 - 2019-06-27

* `Aws\DynamoDB` - Documentation updates for dynamodb
* `Aws\Test` - Removed outdated endpoints tests.

## 3.102.0 - 2019-06-26

* `Aws\` - Auto assume credential role using profile in `~/.aws/config`
* `Aws\ApiGatewayV2` - You can now perform tag operations on ApiGatewayV2 Resources (typically associated with WebSocket APIs)
* `Aws\CodeCommit` - This release supports better exception handling for merges.
* `Aws\Test` - Updated endpoints file with corresponding updated partition tests.

## 3.101.1 - 2019-06-25

* `Aws\EC2` - Starting today, you can use Traffic Mirroring to copy network traffic from an elastic network interface of Amazon EC2 instances and then send it to out-of-band security and monitoring appliances for content inspection, threat monitoring, and troubleshooting. These appliances can be deployed as individual instances, or as a fleet of instances behind a Network Load Balancer with a User Datagram Protocol (UDP) listener. Traffic Mirroring supports filters and packet truncation, so that you only extract the traffic of interest to monitor by using monitoring tools of your choice.
* `Aws\EKS` - Changing Amazon EKS full service name to Amazon Elastic Kubernetes Service.

## 3.101.0 - 2019-06-24

* `Aws\APIGateway` - Customers can pick different security policies (TLS version + cipher suite) for custom domains in API Gateway
* `Aws\ApiGatewayV2` - Customers can get information about security policies set on custom domain resources in API Gateway
* `Aws\ApplicationInsights` - CloudWatch Application Insights detects errors and exceptions from logs, including .NET custom application logs, SQL Server logs, IIS logs, and more, and uses a combination of built-in rules and machine learning, such as dynamic baselining, to identify common problems. You can then easily drill into specific issues with CloudWatch Automatic Dashboards that are dynamically generated. These dashboards contain the most recent alarms, a summary of relevant metrics, and log snippets to help you identify root cause.
* `Aws\ElasticLoadBalancingv2` - This release adds support for UDP on Network Load Balancers
* `Aws\FSx` - Starting today, you can join your Amazon FSx for Windows File Server file systems to your organization's self-managed Microsoft Active Directory while creating the file system. You can also perform in-place updates of file systems to keep your Active Directory configuration up to date.
* `Aws\ResourceGroupsTaggingAPI` - Updated service APIs and documentation.
* `Aws\SSM` - AWS Systems Manager now supports deleting a specific version of a SSM Document.
* `Aws\SecurityHub` - This release includes a new Tags parameter for the EnableSecurityHub operation, and the following new operations: DescribeHub, CreateActionTarget, DeleteActionTarget, DescribeActionTargets, UpdateActionTarget, TagResource, UntagResource, and ListTagsforResource. It removes the operation ListProductSubscribers, and makes Title and Description required attributes of AwsSecurityFinding.
* `Aws\ServiceQuotas` - Service Quotas enables you to view and manage your quotas for AWS services from a central location.

## 3.100.9 - 2019-06-21

* `Aws\DeviceFarm` - This release includes updated documentation about the default timeout value for test runs and remote access sessions. This release also includes miscellaneous bug fixes for the documentation.
* `Aws\IAM` - We are making it easier for you to manage your permission guardrails i.e. service control policies by enabling you to retrieve the last timestamp when an AWS service was accessed within an account or AWS Organizations entity.
* `Aws\KinesisVideoMedia` - Documentation updates for Amazon Kinesis Video Streams.
* `Aws\MediaPackage` - Added two new origin endpoint fields for configuring which SCTE-35 messages are treated as advertisements.

## 3.100.8 - 2019-06-20

* `Aws\ACMPCA` - ACM Private CA is launching Root CAs and hierarchy management, a new feature that expands the scope of ACM Private CA from supporting only subordinate issuing CAs, to now include a full CA hierarchy that includes root CAs - the cryptographic root of trust for an organization.
* `Aws\ClientSideMonitoring` - Support host configuration for CSM
* `Aws\Glue` - Starting today, you can now use workflows in AWS Glue to author directed acyclic graphs (DAGs) of Glue triggers, crawlers and jobs. Workflows enable orchestration of your ETL workloads by building dependencies between Glue entities (triggers, crawlers and jobs). You can visually track status of the different nodes in the workflows on the console making it easier to monitor progress and troubleshoot issues. Also, you can share parameters across entities in the workflow.
* `Aws\Health` - API improvements for the AWS Health service.
* `Aws\IoTEventsData` - "The colon character ':' is now permitted in Detector Model 'key' parameter values.
* `Aws\OpsWorks` - Documentation updates for OpsWorks Stacks.
* `Aws\RDS` - This release adds support for RDS storage autoscaling

## 3.100.7 - 2019-06-19

* `Aws\EKS` - Changing Amazon EKS full service name to Amazon Elastic Kubernetes Service.

## 3.100.6 - 2019-06-18

* `Aws\EC2` - You can now launch new 12xlarge, 24xlarge, and metal instance sizes on the Amazon EC2 compute optimized C5 instance types featuring 2nd Gen Intel Xeon Scalable Processors.
* `Aws\ResourceGroupsTaggingAPI` - You can use tag policies to help standardize on tags across your organization's resources.

## 3.100.5 - 2019-06-17

* `Aws\Neptune` - This release adds a feature to configure Amazon Neptune to publish audit logs to Amazon CloudWatch Logs.
* `Aws\RoboMaker` - Add the ServiceUnavailableException (503) into CreateSimulationJob API.
* `Aws\ServiceCatalog` - Restrict concurrent calls by a single customer account for CreatePortfolioShare and DeletePortfolioShare when sharing/unsharing to an Organization.

## 3.100.4 - 2019-06-14

* `Aws\AppStream` - Added 2 new values(WINDOWS_SERVER_2016, WINDOWS_SERVER_2019) for PlatformType enum.
* `Aws\CloudFront` - A new datatype in the CloudFront API, AliasICPRecordal, provides the ICP recordal status for CNAMEs associated with distributions. AWS services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content publicly on an alternate domain name, also known as a CNAME, that they have added to CloudFront. The status value is returned in the CloudFront response; you cannot configure it yourself. The status is set to APPROVED for all CNAMEs (aliases) in regions outside of China.
* `Aws\EC2` - Correction to enumerations in EC2 client.
* `Aws\Personalize` - Documentation updates for Amazon Personalize.

## 3.100.3 - 2019-06-13

* `Aws\Api` - Fix json parse error when extracting header
* `Aws\AppMesh` - This release adds support for AWS Cloud Map as a service discovery method for virtual nodes.
* `Aws\EC2` - G4 instances are Amazon EC2 instances based on NVIDIA T4 GPUs and are designed to provide cost-effective machine learning inference for applications, like image classification, object detection, recommender systems, automated speech recognition, and language translation. G4 instances are also a cost-effective platform for building and running graphics-intensive applications, such as remote graphics workstations, video transcoding, photo-realistic design, and game streaming in the cloud. To get started with G4 instances visit https://aws.amazon.com/ec2/instance-types/g4.
* `Aws\ElastiCache` - This release is to add support for reader endpoint for cluster-mode disabled Amazon ElastiCache for Redis clusters.
* `Aws\GuardDuty` - Support for tagging functionality in Create and Get operations for Detector, IP Set, Threat Intel Set, and Finding Filter resources and 3 new tagging APIs: ListTagsForResource, TagResource, and UntagResource.

## 3.100.2 - 2019-06-12

* `Aws\ServiceCatalog` - This release adds a new field named Guidance to update provisioning artifact, this field can be set by the administrator to provide guidance to end users about which provisioning artifacts to use.

## 3.100.1 - 2019-06-11

* `Aws\SageMaker` - The default TaskTimeLimitInSeconds of labeling job is increased to 8 hours. Batch Transform introduces a new DataProcessing field which supports input and output filtering and data joining. Training job increases the max allowed input channels from 8 to 20.

## 3.100.0 - 2019-06-10

* `Aws\CodeBuild` - AWS CodeBuild adds support for source version on project level.
* `Aws\CodeCommit` - This release adds two merge strategies for merging pull requests: squash and three-way. It also adds functionality for resolving merge conflicts, testing merge outcomes, and for merging branches using one of the three supported merge strategies.
* `Aws\Personalize` - Amazon Personalize is a machine learning service that makes it easy for developers to create individualized recommendations for customers using their applications.
* `Aws\PersonalizeEvents` - Introducing Amazon Personalize - a machine learning service that makes it easy for developers to create individualized recommendations for customers using their applications.
* `Aws\PersonalizeRuntime` - Amazon Personalize is a machine learning service that makes it easy for developers to create individualized recommendations for customers using their applications.

## 3.99.4 - 2019-06-07

* `Aws\EC2` - Adds DNS entries and NLB ARNs to describe-vpc-endpoint-connections API response. Adds owner ID to describe-vpc-endpoints and create-vpc-endpoint API responses.

## 3.99.3 - 2019-06-06

* `Aws\CloudWatchLogs` - Documentation updates for logs
* `Aws\DynamoDB` - Documentation updates for dynamodb
* `Aws\ECS` - This release of Amazon Elastic Container Service (Amazon ECS) introduces support for launching container instances using supported Amazon EC2 instance types that have increased elastic network interface density. Using these instance types and opting in to the awsvpcTrunking account setting provides increased elastic network interface (ENI) density on newly launched container instances which allows you to place more tasks on each container instance.
* `Aws\GuardDuty` - Improve FindingCriteria Condition field names, support long-typed conditions and deprecate old Condition field names.
* `Aws\MediaConnect` - This release adds support for encrypting entitlements using Secure Packager and Encoder Key Exchange (SPEKE).
* `Aws\Organizations` - You can tag and untag accounts in your organization and view tags on an account in your organization.
* `Aws\SES` - You can now specify whether the Amazon Simple Email Service must deliver email over a connection that is encrypted using Transport Layer Security (TLS).
* `Aws\SSM` - OpsCenter is a new Systems Manager capability that allows you to view, diagnose, and remediate, operational issues, aka OpsItems, related to various AWS resources by bringing together contextually relevant investigation information. New APIs to create, update, describe, and get OpsItems as well as OpsItems summary API. 

## 3.99.2 - 2019-06-05

* `Aws\Glue` - Support specifying python version for Python shell jobs. A new parameter PythonVersion is added to the JobCommand data type.

## 3.99.1 - 2019-06-04

* `Aws\EC2` - This release adds support for Host Recovery feature which automatically restarts instances on to a new replacement host if failures are detected on Dedicated Host.
* `Aws\ElastiCache` - Amazon ElastiCache now allows you to apply available service updates on demand. Features included: (1) Access to the list of applicable service updates and their priorities. (2) Service update monitoring and regular status updates. (3) Recommended apply-by-dates for scheduling the service updates, which is critical if your cluster is in ElastiCache-supported compliance programs. (4) Ability to stop and later re-apply updates. For more information, see https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Self-Service-Updates.html
* `Aws\IAM` - This release adds validation for policy path field. This field is now restricted to be max 512 characters.
* `Aws\S3` - Documentation updates for s3
* `Aws\StorageGateway` - AWS Storage Gateway now supports AWS PrivateLink, enabling you to administer and use gateways without needing to use public IP addresses or a NAT/Internet Gateway, while avoiding traffic from going over the internet.

## 3.99.0 - 2019-06-03

* `Aws\` - Auto assume credential role from source_profile
* `Aws\ClientSideMonitoring` - Unwrapping errors for CSM options will default to disabling it.
* `Aws\EC2` - Amazon EC2 I3en instances are the new storage-optimized instances offering up to 60 TB NVMe SSD instance storage and up to 100 Gbps of network bandwidth.
* `Aws\RDS` - Amazon RDS Data API is generally available. Removing beta notes in the documentation.

## 3.98.0 - 2019-05-30

* `Aws\CodeCommit` - This release adds APIs that allow adding and removing tags to a repository, and viewing tags for a repository. It also enables adding tags when creating a repository.
* `Aws\IoTAnalytics` - IoT Analytics adds the option to use your own S3 bucket to store channel and data store resources. Previously, only service-managed storage was used.
* `Aws\IoTEvents` - The AWS IoT Events service allows customers to monitor their IoT devices and sensors to detect failures or changes in operation and to trigger actions when these events occur
* `Aws\IoTEventsData` - The AWS IoT Events service allows customers to monitor their IoT devices and sensors to detect failures or changes in operation and to trigger actions when these events occur
* `Aws\Kafka` - Updated APIs for Amazon MSK to enable new features such as encryption in transit, client authentication, and scaling storage.
* `Aws\PinpointEmail` - You can now specify whether the Amazon Pinpoint Email service must deliver email over a connection that is encrypted using Transport Layer Security (TLS).
* `Aws\RDS` - This release adds support for Activity Streams for database clusters.
* `Aws\RDSDataService` - The RDS Data API is generally available for the MySQL-compatible edition of Amazon Aurora Serverless in the US East (N. Virginia and Ohio), US West (Oregon), EU (Ireland), and Asia Pacific (Tokyo) regions. This service enables you to easily access Aurora Serverless clusters with web services-based applications including AWS Lambda and AWS AppSync. The new APIs included in this SDK release are ExecuteStatement, BatchExecuteStatement, BeginTransaction, CommitTransaction, and RollbackTransaction. The ExecuteSql API is deprecated; instead use ExecuteStatement which provides additional functionality including transaction support.
* `Aws\ServiceCatalog` - Service Catalog ListStackInstancesForProvisionedProduct API enables customers to get details of a provisioned product with type "CFN_STACKSET". By passing the provisioned product id, the API will list account, region and status of each stack instances that are associated with this provisioned product.

## 3.97.0 - 2019-05-29

* `Aws\DLM` - Customers can now simultaneously take snapshots of multiple EBS volumes attached to an EC2 instance. With this new capability, snapshots guarantee crash-consistency across multiple volumes by preserving the order of IO operations. This new feature is fully integrated with Amazon Data Lifecycle Manager (DLM) allowing customers to automatically manage snapshots by creating lifecycle policies. 
* `Aws\EC2` - Customers can now simultaneously take snapshots of multiple EBS volumes attached to an EC2 instance. With this new capability, snapshots guarantee crash-consistency across multiple volumes by preserving the order of IO operations. This new feature is fully integrated with Amazon Data Lifecycle Manager (DLM) allowing customers to automatically manage snapshots by creating lifecycle policies. 
* `Aws\IoTThingsGraph` - Initial release.
* `Aws\Pinpoint` - Removes aliases in favor of generic aliasing
* `Aws\RDS` - Documentation updates for rds
* `Aws\SSM` - Systems Manager - Documentation updates
* `Aws\SecurityHub` - This update adds the ListProductSubscribers API, DescribeProducts API, removes CONTAINS as a comparison value for the StringFilter, and only allows use of EQUALS instead of CONTAINS in MapFilter. 

## 3.96.0 - 2019-05-28

* `Aws\` - Adds general support for service operation aliasing defined in a JSON file.
* `Aws\Chime` - This release adds the ability to search and order toll free phone numbers for Voice Connectors.
* `Aws\GroundStation` - AWS Ground Station is a fully managed service that enables you to control satellite communications, downlink and process satellite data, and scale your satellite operations efficiently and cost-effectively without having to build or manage your own ground station infrastructure.
* `Aws\PinpointEmail` - This release adds support for programmatic access to Deliverability dashboard subscriptions and the deliverability data provided by the Deliverability dashboard for domains and IP addresses. The data includes placement metrics for campaigns that use subscribed domains to send email.
* `Aws\RDS` - Add a new output field Status to DBEngineVersion which shows the status of the engine version (either available or deprecated). Add a new parameter IncludeAll to DescribeDBEngineVersions to make it possible to return both available and deprecated engine versions. These changes enable a user to create a Read Replica of an DB instance on a deprecated engine version.
* `Aws\RoboMaker` - Added support for an additional robot software suite (Gazebo 9) and for cancelling deployment jobs.
* `Aws\STS` - Documentation updates for iam
* `Aws\StorageGateway` - Introduce AssignTapePool operation to allow customers to migrate tapes between pools.
* `Aws\TranscribeService` - Amazon Transcribe - support transcriptions from audio sources in Modern Standard Arabic (ar-SA).
* `Aws\WAF` - Documentation updates for waf

## 3.95.0 - 2019-05-24

* `Aws\` - Adds support for 'requiresLength' trait, adding headers as necessary for streaming operations.
* `Aws\CodeDeploy` - AWS CodeDeploy now supports tagging for the application and deployment group resources.
* `Aws\MediaStoreData` - MediaStore - This release adds support for chunked transfer of objects, which reduces latency by making an object available for downloading while it is still being uploaded.
* `Aws\OpsWorksCM` - Documentation updates for OpsWorks for Chef Automate; attribute values updated for Chef Automate 2.0 release.

## 3.94.3 - 2019-05-23

* `Aws\Api` - Preserve path on custom endpoints
* `Aws\EC2` - New APIs to enable EBS encryption by default feature. Once EBS encryption by default is enabled in a region within the account, all new EBS volumes and snapshot copi