<?php
// This file was auto-generated from sdk-root/src/data/amplifyuibuilder/2021-08-11/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The Amplify UI Builder API provides a programmatic interface for creating and configuring user interface (UI) component libraries and themes for use in your Amplify applications. You can then connect these UI components to an application\'s backend Amazon Web Services resources.</p> <p>You can also use the Amplify Studio visual designer to create UI components and model data for an app. For more information, see <a href="https://docs.amplify.aws/console/adminui/intro">Introduction</a> in the <i>Amplify Docs</i>.</p> <p>The Amplify Framework is a comprehensive set of SDKs, libraries, tools, and documentation for client app development. For more information, see the <a href="https://docs.amplify.aws/">Amplify Framework</a>. For more information about deploying an Amplify application to Amazon Web Services, see the <a href="https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html">Amplify User Guide</a>.</p>', 'operations' => [ 'CreateComponent' => '<p>Creates a new component for an Amplify app.</p>', 'CreateForm' => '<p>Creates a new form for an Amplify app.</p>', 'CreateTheme' => '<p>Creates a theme to apply to the components in an Amplify app.</p>', 'DeleteComponent' => '<p>Deletes a component from an Amplify app.</p>', 'DeleteForm' => '<p>Deletes a form from an Amplify app.</p>', 'DeleteTheme' => '<p>Deletes a theme from an Amplify app.</p>', 'ExchangeCodeForToken' => '<note> <p>This is for internal use.</p> </note> <p>Amplify uses this action to exchange an access code for a token.</p>', 'ExportComponents' => '<p>Exports component configurations to code that is ready to integrate into an Amplify app.</p>', 'ExportForms' => '<p>Exports form configurations to code that is ready to integrate into an Amplify app.</p>', 'ExportThemes' => '<p>Exports theme configurations to code that is ready to integrate into an Amplify app.</p>', 'GetCodegenJob' => '<p>Returns an existing code generation job.</p>', 'GetComponent' => '<p>Returns an existing component for an Amplify app.</p>', 'GetForm' => '<p>Returns an existing form for an Amplify app.</p>', 'GetMetadata' => '<p>Returns existing metadata for an Amplify app.</p>', 'GetTheme' => '<p>Returns an existing theme for an Amplify app.</p>', 'ListCodegenJobs' => '<p>Retrieves a list of code generation jobs for a specified Amplify app and backend environment.</p>', 'ListComponents' => '<p>Retrieves a list of components for a specified Amplify app and backend environment.</p>', 'ListForms' => '<p>Retrieves a list of forms for a specified Amplify app and backend environment.</p>', 'ListTagsForResource' => '<p>Returns a list of tags for a specified Amazon Resource Name (ARN).</p>', 'ListThemes' => '<p>Retrieves a list of themes for a specified Amplify app and backend environment.</p>', 'PutMetadataFlag' => '<p>Stores the metadata information about a feature on a form.</p>', 'RefreshToken' => '<note> <p>This is for internal use.</p> </note> <p>Amplify uses this action to refresh a previously issued access token that might have expired.</p>', 'StartCodegenJob' => '<p>Starts a code generation job for a specified Amplify app and backend environment.</p>', 'TagResource' => '<p>Tags the resource with a tag key and value.</p>', 'UntagResource' => '<p>Untags a resource with a specified Amazon Resource Name (ARN).</p>', 'UpdateComponent' => '<p>Updates an existing component.</p>', 'UpdateForm' => '<p>Updates an existing form.</p>', 'UpdateTheme' => '<p>Updates an existing theme.</p>', ], 'shapes' => [ 'ActionParameters' => [ 'base' => '<p>Represents the event action configuration for an element of a <code>Component</code> or <code>ComponentChild</code>. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components. <code>ActionParameters</code> defines the action that is performed when an event occurs on the component.</p>', 'refs' => [ 'ComponentEvent$parameters' => '<p>Describes information about the action.</p>', ], ], 'ApiConfiguration' => [ 'base' => '<p>Describes the API configuration for a code generation job.</p>', 'refs' => [ 'ReactStartCodegenJobData$apiConfiguration' => '<p>The API configuration for the code generation job.</p>', ], ], 'AppId' => [ 'base' => NULL, 'refs' => [ 'CodegenJob$appId' => '<p>The ID of the Amplify app associated with the code generation job.</p>', 'CodegenJobSummary$appId' => '<p>The unique ID of the Amplify app associated with the code generation job.</p>', 'GetCodegenJobRequest$appId' => '<p>The unique ID of the Amplify app associated with the code generation job.</p>', 'ListCodegenJobsRequest$appId' => '<p>The unique ID for the Amplify app.</p>', 'StartCodegenJobRequest$appId' => '<p>The unique ID for the Amplify app.</p>', ], ], 'AssociatedFieldsList' => [ 'base' => NULL, 'refs' => [ 'CodegenGenericDataRelationshipType$associatedFields' => '<p>The associated fields of the data relationship.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CodegenDependency$isSemVer' => '<p>Determines if the dependency package is using Semantic versioning. If set to true, it indicates that the dependency package uses Semantic versioning.</p>', 'CodegenFeatureFlags$isRelationshipSupported' => '<p>Specifes whether a code generation job supports data relationships.</p>', 'CodegenFeatureFlags$isNonModelSupported' => '<p>Specifies whether a code generation job supports non models.</p>', 'CodegenGenericDataField$required' => '<p>Specifies whether the generic data field is required.</p>', 'CodegenGenericDataField$readOnly' => '<p>Specifies whether the generic data field is read-only.</p>', 'CodegenGenericDataField$isArray' => '<p>Specifies whether the generic data field is an array.</p>', 'CodegenGenericDataModel$isJoinTable' => '<p>Specifies whether the generic data model is a join table.</p>', 'CodegenGenericDataRelationshipType$canUnlinkAssociatedModel' => '<p>Specifies whether the relationship can unlink the associated model.</p>', 'CodegenGenericDataRelationshipType$isHasManyIndex' => '<p>Specifies whether the <code>@index</code> directive is supported for a <code>hasMany</code> data relationship.</p>', 'CodegenJob$autoGenerateForms' => '<p>Specifies whether to autogenerate forms in the code generation job.</p>', 'ComponentProperty$configured' => '<p>Specifies whether the user configured the property in Amplify Studio after importing it.</p>', 'FieldConfig$excluded' => '<p>Specifies whether to hide a field.</p>', 'FieldInputConfig$required' => '<p>Specifies a field that requires input.</p>', 'FieldInputConfig$readOnly' => '<p>Specifies a read only field.</p>', 'FieldInputConfig$defaultChecked' => '<p>Specifies whether a field has a default value.</p>', 'FieldInputConfig$isArray' => '<p>Specifies whether to render the field as an array. This property is ignored if the <code>dataSourceType</code> for the form is a Data Store.</p>', 'FileUploaderFieldConfig$showThumbnails' => '<p>Specifies whether to display or hide the image preview after selecting a file for upload. The default value is <code>true</code> to display the image preview.</p>', 'FileUploaderFieldConfig$isResumable' => '<p>Allows the file upload operation to be paused and resumed. The default value is <code>false</code>.</p> <p>When <code>isResumable</code> is set to <code>true</code>, the file uploader uses a multipart upload to break the files into chunks before upload. The progress of the upload isn\'t continuous, because the file uploader uploads a chunk at a time.</p>', 'FormButton$excluded' => '<p>Specifies whether the button is visible on the form.</p>', 'ReactStartCodegenJobData$renderTypeDeclarations' => '<p>Specifies whether the code generation job should render type declaration files.</p>', 'ReactStartCodegenJobData$inlineSourceMap' => '<p>Specifies whether the code generation job should render inline source maps.</p>', 'SectionalElement$excluded' => '<p>Excludes a sectional element that was generated by default for a specified data model.</p>', 'StartCodegenJobData$autoGenerateForms' => '<p>Specifies whether to autogenerate forms in the code generation job.</p>', ], ], 'CodegenDependencies' => [ 'base' => NULL, 'refs' => [ 'CodegenJob$dependencies' => '<p>Lists the dependency packages that may be required for the project code to run.</p>', ], ], 'CodegenDependency' => [ 'base' => '<p>Dependency package that may be required for the project code to run.</p>', 'refs' => [ 'CodegenDependencies$member' => NULL, ], ], 'CodegenFeatureFlags' => [ 'base' => '<p>Describes the feature flags that you can specify for a code generation job.</p>', 'refs' => [ 'CodegenJob$features' => NULL, 'StartCodegenJobData$features' => '<p>The feature flags for a code generation job.</p>', ], ], 'CodegenGenericDataEnum' => [ 'base' => '<p>Describes the enums in a generic data schema.</p>', 'refs' => [ 'CodegenGenericDataEnums$value' => NULL, ], ], 'CodegenGenericDataEnumValuesList' => [ 'base' => NULL, 'refs' => [ 'CodegenGenericDataEnum$values' => '<p>The list of enum values in the generic data schema.</p>', ], ], 'CodegenGenericDataEnums' => [ 'base' => NULL, 'refs' => [ 'CodegenJobGenericDataSchema$enums' => '<p>The name of a <code>CodegenGenericDataEnum</code>.</p>', ], ], 'CodegenGenericDataField' => [ 'base' => '<p>Describes a field in a generic data schema.</p>', 'refs' => [ 'CodegenGenericDataFields$value' => NULL, 'CodegenGenericDataNonModelFields$value' => NULL, ], ], 'CodegenGenericDataFieldDataType' => [ 'base' => NULL, 'refs' => [ 'CodegenGenericDataField$dataType' => '<p>The data type for the generic data field.</p>', ], ], 'CodegenGenericDataFields' => [ 'base' => NULL, 'refs' => [ 'CodegenGenericDataModel$fields' => '<p>The fields in the generic data model.</p>', ], ], 'CodegenGenericDataModel' => [ 'base' => '<p>Describes a model in a generic data schema.</p>', 'refs' => [ 'CodegenGenericDataModels$value' => NULL, ], ], 'CodegenGenericDataModels' => [ 'base' => NULL, 'refs' => [ 'CodegenJobGenericDataSchema$models' => '<p>The name of a <code>CodegenGenericDataModel</code>.</p>', ], ], 'CodegenGenericDataNonModel' => [ 'base' => '<p>Describes a non-model in a generic data schema.</p>', 'refs' => [ 'CodegenGenericDataNonModels$value' => NULL, ], ], 'CodegenGenericDataNonModelFields' => [ 'base' => NULL, 'refs' => [ 'CodegenGenericDataNonModel$fields' => '<p>The fields in a generic data schema non model.</p>', ], ], 'CodegenGenericDataNonModels' => [ 'base' => NULL, 'refs' => [ 'CodegenJobGenericDataSchema$nonModels' => '<p>The name of a <code>CodegenGenericDataNonModel</code>.</p>', ], ], 'CodegenGenericDataRelationshipType' => [ 'base' => '<p>Describes the relationship between generic data models.</p>', 'refs' => [ 'CodegenGenericDataField$relationship' => '<p>The relationship of the generic data schema.</p>', ], ], 'CodegenJob' => [ 'base' => '<p>Describes the configuration for a code generation job that is associated with an Amplify app.</p>', 'refs' => [ 'GetCodegenJobResponse$job' => '<p>The configuration settings for the code generation job.</p>', 'StartCodegenJobResponse$entity' => '<p>The code generation job for a UI component that is associated with an Amplify app.</p>', ], ], 'CodegenJobAsset' => [ 'base' => '<p>Describes an asset for a code generation job.</p>', 'refs' => [ 'CodegenJob$asset' => '<p>The <code>CodegenJobAsset</code> to use for the code generation job.</p>', ], ], 'CodegenJobGenericDataSchema' => [ 'base' => '<p>Describes the data schema for a code generation job.</p>', 'refs' => [ 'CodegenJob$genericDataSchema' => NULL, 'StartCodegenJobData$genericDataSchema' => '<p>The data schema to use for a code generation job.</p>', ], ], 'CodegenJobGenericDataSourceType' => [ 'base' => NULL, 'refs' => [ 'CodegenJobGenericDataSchema$dataSourceType' => '<p>The type of the data source for the schema. Currently, the only valid value is an Amplify <code>DataStore</code>.</p>', ], ], 'CodegenJobRenderConfig' => [ 'base' => '<p>Describes the configuration information for rendering the UI component associated with the code generation job.</p>', 'refs' => [ 'CodegenJob$renderConfig' => NULL, 'StartCodegenJobData$renderConfig' => '<p>The code generation configuration for the codegen job.</p>', ], ], 'CodegenJobStatus' => [ 'base' => NULL, 'refs' => [ 'CodegenJob$status' => '<p>The status of the code generation job.</p>', ], ], 'CodegenJobSummary' => [ 'base' => '<p>A summary of the basic information about the code generation job.</p>', 'refs' => [ 'CodegenJobSummaryList$member' => NULL, ], ], 'CodegenJobSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCodegenJobsResponse$entities' => '<p>The list of code generation jobs for the Amplify app.</p>', ], ], 'CodegenPrimaryKeysList' => [ 'base' => NULL, 'refs' => [ 'CodegenGenericDataModel$primaryKeys' => '<p>The primary keys of the generic data model.</p>', ], ], 'Component' => [ 'base' => '<p>Contains the configuration settings for a user interface (UI) element for an Amplify app. A component is configured as a primary, stand-alone UI element. Use <code>ComponentChild</code> to configure an instance of a <code>Component</code>. A <code>ComponentChild</code> instance inherits the configuration of the main <code>Component</code>.</p>', 'refs' => [ 'ComponentList$member' => NULL, 'CreateComponentResponse$entity' => '<p>Describes the configuration of the new component.</p>', 'GetComponentResponse$component' => '<p>Represents the configuration settings for the component.</p>', 'UpdateComponentResponse$entity' => '<p>Describes the configuration of the updated component.</p>', ], ], 'ComponentBindingProperties' => [ 'base' => NULL, 'refs' => [ 'Component$bindingProperties' => '<p>The information to connect a component\'s properties to data at runtime. You can\'t specify <code>tags</code> as a valid property for <code>bindingProperties</code>.</p> <p/>', 'CreateComponentData$bindingProperties' => '<p>The data binding information for the component\'s properties.</p>', 'UpdateComponentData$bindingProperties' => '<p>The data binding information for the component\'s properties.</p>', ], ], 'ComponentBindingPropertiesValue' => [ 'base' => '<p>Represents the data binding configuration for a component at runtime. You can use <code>ComponentBindingPropertiesValue</code> to add exposed properties to a component to allow different values to be entered when a component is reused in different places in an app.</p>', 'refs' => [ 'ComponentBindingProperties$value' => NULL, ], ], 'ComponentBindingPropertiesValueProperties' => [ 'base' => '<p>Represents the data binding configuration for a specific property using data stored in Amazon Web Services. For Amazon Web Services connected properties, you can bind a property to data stored in an Amazon S3 bucket, an Amplify DataStore model or an authenticated user attribute.</p>', 'refs' => [ 'ComponentBindingPropertiesValue$bindingProperties' => '<p>Describes the properties to customize with data at runtime.</p>', ], ], 'ComponentChild' => [ 'base' => '<p>A nested UI configuration within a parent <code>Component</code>.</p>', 'refs' => [ 'ComponentChildList$member' => NULL, ], ], 'ComponentChildList' => [ 'base' => NULL, 'refs' => [ 'Component$children' => '<p>A list of the component\'s <code>ComponentChild</code> instances.</p>', 'ComponentChild$children' => '<p>The list of <code>ComponentChild</code> instances for this component.</p>', 'CreateComponentData$children' => '<p>A list of child components that are instances of the main component.</p>', 'UpdateComponentData$children' => '<p>The components that are instances of the main component.</p>', ], ], 'ComponentCollectionProperties' => [ 'base' => NULL, 'refs' => [ 'Component$collectionProperties' => '<p>The data binding configuration for the component\'s properties. Use this for a collection component. You can\'t specify <code>tags</code> as a valid property for <code>collectionProperties</code>.</p>', 'CreateComponentData$collectionProperties' => '<p>The data binding configuration for customizing a component\'s properties. Use this for a collection component.</p>', 'UpdateComponentData$collectionProperties' => '<p>The configuration for binding a component\'s properties to a data model. Use this for a collection component.</p>', ], ], 'ComponentConditionProperty' => [ 'base' => '<p>Represents a conditional expression to set a component property. Use <code>ComponentConditionProperty</code> to set a property to different values conditionally, based on the value of another property.</p>', 'refs' => [ 'ComponentProperty$condition' => '<p>The conditional expression to use to assign a value to the component property.</p>', ], ], 'ComponentDataConfiguration' => [ 'base' => '<p>Describes the configuration for binding a component\'s properties to data.</p>', 'refs' => [ 'ComponentCollectionProperties$value' => NULL, ], ], 'ComponentEvent' => [ 'base' => '<p>Describes the configuration of an event. You can bind an event and a corresponding action to a <code>Component</code> or a <code>ComponentChild</code>. A button click is an example of an event. </p>', 'refs' => [ 'ComponentEvents$value' => NULL, ], ], 'ComponentEvents' => [ 'base' => NULL, 'refs' => [ 'Component$events' => '<p>Describes the events that can be raised on the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>', 'ComponentChild$events' => '<p>Describes the events that can be raised on the child component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>', 'CreateComponentData$events' => '<p>The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>', 'UpdateComponentData$events' => '<p>The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.</p>', ], ], 'ComponentList' => [ 'base' => NULL, 'refs' => [ 'ExportComponentsResponse$entities' => '<p>Represents the configuration of the exported components.</p>', ], ], 'ComponentName' => [ 'base' => NULL, 'refs' => [ 'Component$name' => '<p>The name of the component.</p>', 'ComponentSummary$name' => '<p>The name of the component.</p>', 'CreateComponentData$name' => '<p>The name of the component</p>', 'UpdateComponentData$name' => '<p>The name of the component to update.</p>', ], ], 'ComponentOverrides' => [ 'base' => NULL, 'refs' => [ 'Component$overrides' => '<p>Describes the component\'s properties that can be overriden in a customized instance of the component. You can\'t specify <code>tags</code> as a valid property for <code>overrides</code>.</p>', 'ComponentVariant$overrides' => '<p>The properties of the component variant that can be overriden when customizing an instance of the component. You can\'t specify <code>tags</code> as a valid property for <code>overrides</code>.</p>', 'CreateComponentData$overrides' => '<p>Describes the component properties that can be overriden to customize an instance of the component.</p>', 'UpdateComponentData$overrides' => '<p>Describes the properties that can be overriden to customize the component.</p>', ], ], 'ComponentOverridesValue' => [ 'base' => NULL, 'refs' => [ 'ComponentOverrides$value' => NULL, ], ], 'ComponentProperties' => [ 'base' => NULL, 'refs' => [ 'ActionParameters$fields' => '<p>A dictionary of key-value pairs mapping Amplify Studio properties to fields in a data model. Use when the action performs an operation on an Amplify DataStore model.</p>', 'Component$properties' => '<p>Describes the component\'s properties. You can\'t specify <code>tags</code> as a valid property for <code>properties</code>.</p>', 'ComponentChild$properties' => '<p>Describes the properties of the child component. You can\'t specify <code>tags</code> as a valid property for <code>properties</code>.</p>', 'CreateComponentData$properties' => '<p>Describes the component\'s properties.</p>', 'UpdateComponentData$properties' => '<p>Describes the component\'s properties.</p>', ], ], 'ComponentProperty' => [ 'base' => '<p>Describes the configuration for all of a component\'s properties. Use <code>ComponentProperty</code> to specify the values to render or bind by default.</p>', 'refs' => [ 'ActionParameters$type' => '<p>The type of navigation action. Valid values are <code>url</code> and <code>anchor</code>. This value is required for a navigation action.</p>', 'ActionParameters$url' => '<p>The URL to the location to open. Specify this value for a navigation action.</p>', 'ActionParameters$anchor' => '<p>The HTML anchor link to the location to open. Specify this value for a navigation action.</p>', 'ActionParameters$target' => '<p>The element within the same component to modify when the action occurs.</p>', 'ActionParameters$global' => '<p>Specifies whether the user should be signed out globally. Specify this value for an auth sign out action.</p>', 'ActionParameters$id' => '<p>The unique ID of the component that the <code>ActionParameters</code> apply to.</p>', 'ComponentConditionProperty$then' => '<p>The value to assign to the property if the condition is met.</p>', 'ComponentConditionProperty$else' => '<p>The value to assign to the property if the condition is not met.</p>', 'ComponentProperties$value' => NULL, 'ComponentPropertyList$member' => NULL, 'MutationActionSetStateParameter$set' => '<p>The state configuration to assign to the property.</p>', ], ], 'ComponentPropertyBindingProperties' => [ 'base' => '<p>Associates a component property to a binding property. This enables exposed properties on the top level component to propagate data to the component\'s property values.</p>', 'refs' => [ 'ComponentProperty$bindingProperties' => '<p>The information to bind the component property to data at runtime.</p>', 'ComponentProperty$collectionBindingProperties' => '<p>The information to bind the component property to data at runtime. Use this for collection components.</p>', ], ], 'ComponentPropertyList' => [ 'base' => NULL, 'refs' => [ 'ComponentProperty$concat' => '<p>A list of component properties to concatenate to create the value to assign to this component property.</p>', ], ], 'ComponentSummary' => [ 'base' => '<p>Contains a summary of a component. This is a read-only data type that is returned by <code>ListComponents</code>.</p>', 'refs' => [ 'ComponentSummaryList$member' => NULL, ], ], 'ComponentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListComponentsResponse$entities' => '<p>The list of components for the Amplify app.</p>', ], ], 'ComponentType' => [ 'base' => NULL, 'refs' => [ 'Component$componentType' => '<p>The type of the component. This can be an Amplify custom UI component or another custom component.</p>', 'ComponentSummary$componentType' => '<p>The component type.</p>', 'CreateComponentData$componentType' => '<p>The component type. This can be an Amplify custom UI component or another custom component.</p>', 'UpdateComponentData$componentType' => '<p>The type of the component. This can be an Amplify custom UI component or another custom component.</p>', ], ], 'ComponentVariant' => [ 'base' => '<p>Describes the style configuration of a unique variation of a main component.</p>', 'refs' => [ 'ComponentVariants$member' => NULL, ], ], 'ComponentVariantValues' => [ 'base' => NULL, 'refs' => [ 'ComponentVariant$variantValues' => '<p>The combination of variants that comprise this variant. You can\'t specify <code>tags</code> as a valid property for <code>variantValues</code>.</p>', ], ], 'ComponentVariants' => [ 'base' => NULL, 'refs' => [ 'Component$variants' => '<p>A list of the component\'s variants. A variant is a unique style configuration of a main component.</p>', 'CreateComponentData$variants' => '<p>A list of the unique variants of this component.</p>', 'UpdateComponentData$variants' => '<p>A list of the unique variants of the main component being updated.</p>', ], ], 'CreateComponentData' => [ 'base' => '<p>Represents all of the information that is required to create a component.</p>', 'refs' => [ 'CreateComponentRequest$componentToCreate' => '<p>Represents the configuration of the component to create.</p>', ], ], 'CreateComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFormData' => [ 'base' => '<p>Represents all of the information that is required to create a form.</p>', 'refs' => [ 'CreateFormRequest$formToCreate' => '<p>Represents the configuration of the form to create.</p>', ], ], 'CreateFormRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFormResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateThemeData' => [ 'base' => '<p>Represents all of the information that is required to create a theme.</p>', 'refs' => [ 'CreateThemeRequest$themeToCreate' => '<p>Represents the configuration of the theme to create.</p>', ], ], 'CreateThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateThemeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataStoreRenderConfig' => [ 'base' => '<p>Describes the DataStore configuration for an API for a code generation job.</p>', 'refs' => [ 'ApiConfiguration$dataStoreConfig' => '<p>The configuration for an application using DataStore APIs.</p>', ], ], 'DeleteComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFormRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExchangeCodeForTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExchangeCodeForTokenRequestBody' => [ 'base' => '<p>Describes the configuration of a request to exchange an access code for a token.</p>', 'refs' => [ 'ExchangeCodeForTokenRequest$request' => '<p>Describes the configuration of the request.</p>', ], ], 'ExchangeCodeForTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportComponentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportComponentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportFormsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportFormsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportThemesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportThemesResponse' => [ 'base' => NULL, 'refs' => [], ], 'FeaturesMap' => [ 'base' => NULL, 'refs' => [ 'GetMetadataResponse$features' => '<p>Represents the configuration settings for the features metadata.</p>', ], ], 'FieldConfig' => [ 'base' => '<p>Describes the configuration information for a field in a table.</p>', 'refs' => [ 'FieldsMap$value' => NULL, ], ], 'FieldInputConfig' => [ 'base' => '<p>Describes the configuration for the default input values to display for a field.</p>', 'refs' => [ 'FieldConfig$inputType' => '<p>Describes the configuration for the default input value to display for a field.</p>', ], ], 'FieldPosition' => [ 'base' => '<p>Describes the field position.</p>', 'refs' => [ 'FieldConfig$position' => '<p>Specifies the field position.</p>', 'FormButton$position' => '<p>The position of the button.</p>', 'SectionalElement$position' => '<p>Specifies the position of the text in a field for a <code>Text</code> sectional element.</p>', ], ], 'FieldValidationConfiguration' => [ 'base' => '<p>Describes the validation configuration for a field.</p>', 'refs' => [ 'ValidationsList$member' => NULL, ], ], 'FieldsMap' => [ 'base' => NULL, 'refs' => [ 'CreateFormData$fields' => '<p>The configuration information for the form\'s fields.</p>', 'Form$fields' => '<p>Stores the information about the form\'s fields.</p>', 'UpdateFormData$fields' => '<p>The configuration information for the form\'s fields.</p>', ], ], 'FileUploaderFieldConfig' => [ 'base' => '<p>Describes the configuration for the file uploader field.</p>', 'refs' => [ 'FieldInputConfig$fileUploaderConfig' => '<p>The configuration for the file uploader field.</p>', ], ], 'FixedPosition' => [ 'base' => NULL, 'refs' => [ 'FieldPosition$fixed' => '<p>The field position is fixed and doesn\'t change in relation to other fields.</p>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'FieldInputConfig$minValue' => '<p>The minimum value to display for the field.</p>', 'FieldInputConfig$maxValue' => '<p>The maximum value to display for the field.</p>', 'FieldInputConfig$step' => '<p>The stepping increment for a numeric value in a field.</p>', ], ], 'Form' => [ 'base' => '<p>Contains the configuration settings for a <code>Form</code> user interface (UI) element for an Amplify app. A form is a component you can add to your project by specifying a data source as the default configuration for the form.</p>', 'refs' => [ 'CreateFormResponse$entity' => '<p>Describes the configuration of the new form.</p>', 'FormList$member' => NULL, 'GetFormResponse$form' => '<p>Represents the configuration settings for the form.</p>', 'UpdateFormResponse$entity' => '<p>Describes the configuration of the updated form.</p>', ], ], 'FormActionType' => [ 'base' => NULL, 'refs' => [ 'CreateFormData$formActionType' => '<p>Specifies whether to perform a create or update action on the form.</p>', 'Form$formActionType' => '<p>The operation to perform on the specified form.</p>', 'FormSummary$formActionType' => '<p>The type of operation to perform on the form.</p>', 'UpdateFormData$formActionType' => '<p>Specifies whether to perform a create or update action on the form.</p>', ], ], 'FormBindingElement' => [ 'base' => '<p>Describes how to bind a component property to form data.</p>', 'refs' => [ 'FormBindings$value' => NULL, ], ], 'FormBindings' => [ 'base' => NULL, 'refs' => [ 'ComponentProperty$bindings' => '<p>The information to bind the component property to form data.</p>', ], ], 'FormButton' => [ 'base' => '<p>Describes the configuration for a button UI element that is a part of a form.</p>', 'refs' => [ 'FormCTA$clear' => '<p>Displays a clear button.</p>', 'FormCTA$cancel' => '<p>Displays a cancel button.</p>', 'FormCTA$submit' => '<p>Displays a submit button.</p>', ], ], 'FormButtonsPosition' => [ 'base' => NULL, 'refs' => [ 'FormCTA$position' => '<p>The position of the button.</p>', ], ], 'FormCTA' => [ 'base' => '<p>Describes the call to action button configuration for the form.</p>', 'refs' => [ 'CreateFormData$cta' => '<p>The <code>FormCTA</code> object that stores the call to action configuration for the form.</p>', 'Form$cta' => '<p>Stores the call to action configuration for the form.</p>', 'UpdateFormData$cta' => '<p>The <code>FormCTA</code> object that stores the call to action configuration for the form.</p>', ], ], 'FormDataSourceType' => [ 'base' => NULL, 'refs' => [ 'FormDataTypeConfig$dataSourceType' => '<p>The data source type, either an Amplify DataStore model or a custom data type.</p>', ], ], 'FormDataTypeConfig' => [ 'base' => '<p>Describes the data type configuration for the data source associated with a form.</p>', 'refs' => [ 'CreateFormData$dataType' => '<p>The type of data source to use to create the form.</p>', 'Form$dataType' => '<p>The type of data source to use to create the form.</p>', 'FormSummary$dataType' => '<p>The form\'s data source type.</p>', 'UpdateFormData$dataType' => '<p>The type of data source to use to create the form.</p>', ], ], 'FormInputBindingProperties' => [ 'base' => NULL, 'refs' => [ 'ValueMappings$bindingProperties' => '<p>The information to bind fields to data at runtime.</p>', ], ], 'FormInputBindingPropertiesValue' => [ 'base' => '<p>Represents the data binding configuration for a form\'s input fields at runtime.You can use <code>FormInputBindingPropertiesValue</code> to add exposed properties to a form to allow different values to be entered when a form is reused in different places in an app.</p>', 'refs' => [ 'FormInputBindingProperties$value' => NULL, ], ], 'FormInputBindingPropertiesValueProperties' => [ 'base' => '<p>Represents the data binding configuration for a specific property using data stored in Amazon Web Services. For Amazon Web Services connected properties, you can bind a property to data stored in an Amplify DataStore model.</p>', 'refs' => [ 'FormInputBindingPropertiesValue$bindingProperties' => '<p>Describes the properties to customize with data at runtime.</p>', ], ], 'FormInputValueProperty' => [ 'base' => '<p>Describes the configuration for an input field on a form. Use <code>FormInputValueProperty</code> to specify the values to render or bind by default.</p>', 'refs' => [ 'FormInputValuePropertyList$member' => NULL, 'ValueMapping$displayValue' => '<p>The value to display for the complex object.</p>', 'ValueMapping$value' => '<p>The complex object.</p>', ], ], 'FormInputValuePropertyBindingProperties' => [ 'base' => '<p>Associates a form property to a binding property. This enables exposed properties on the top level form to propagate data to the form\'s property values.</p>', 'refs' => [ 'FormInputValueProperty$bindingProperties' => '<p>The information to bind fields to data at runtime.</p>', ], ], 'FormInputValuePropertyList' => [ 'base' => NULL, 'refs' => [ 'FormInputValueProperty$concat' => '<p>A list of form properties to concatenate to create the value to assign to this field property.</p>', ], ], 'FormList' => [ 'base' => NULL, 'refs' => [ 'ExportFormsResponse$entities' => '<p>Represents the configuration of the exported forms.</p>', ], ], 'FormName' => [ 'base' => NULL, 'refs' => [ 'CreateFormData$name' => '<p>The name of the form.</p>', 'Form$name' => '<p>The name of the form.</p>', 'FormSummary$name' => '<p>The name of the form.</p>', 'UpdateFormData$name' => '<p>The name of the form.</p>', ], ], 'FormStyle' => [ 'base' => '<p>Describes the configuration for the form\'s style.</p>', 'refs' => [ 'CreateFormData$style' => '<p>The configuration for the form\'s style.</p>', 'Form$style' => '<p>Stores the configuration for the form\'s style.</p>', 'UpdateFormData$style' => '<p>The configuration for the form\'s style.</p>', ], ], 'FormStyleConfig' => [ 'base' => '<p>Describes the configuration settings for the form\'s style properties.</p>', 'refs' => [ 'FormStyle$horizontalGap' => '<p>The spacing for the horizontal gap.</p>', 'FormStyle$verticalGap' => '<p>The spacing for the vertical gap.</p>', 'FormStyle$outerPadding' => '<p>The size of the outer padding for the form.</p>', ], ], 'FormSummary' => [ 'base' => '<p>Describes the basic information about a form.</p>', 'refs' => [ 'FormSummaryList$member' => NULL, ], ], 'FormSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListFormsResponse$entities' => '<p>The list of forms for the Amplify app.</p>', ], ], 'GenericDataRelationshipType' => [ 'base' => NULL, 'refs' => [ 'CodegenGenericDataRelationshipType$type' => '<p>The data relationship type.</p>', ], ], 'GetCodegenJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCodegenJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFormRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFormResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetThemeResponse' => [ 'base' => NULL, 'refs' => [], ], 'GraphQLRenderConfig' => [ 'base' => '<p>Describes the GraphQL configuration for an API for a code generation job.</p>', 'refs' => [ 'ApiConfiguration$graphQLConfig' => '<p>The configuration for an application using GraphQL APIs.</p>', ], ], 'IdentifierList' => [ 'base' => NULL, 'refs' => [ 'ComponentDataConfiguration$identifiers' => '<p>A list of IDs to use to bind data to a component. Use this property to bind specifically chosen data, rather than data retrieved from a query.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ExchangeCodeForTokenResponse$expiresIn' => '<p>The date and time when the new access token expires.</p>', 'FileUploaderFieldConfig$maxFileCount' => '<p>Specifies the maximum number of files that can be selected to upload. The default value is an unlimited number of files.</p>', 'FileUploaderFieldConfig$maxSize' => '<p>The maximum file size in bytes that the file uploader will accept. The default value is an unlimited file size.</p>', 'NumValues$member' => NULL, 'RefreshTokenResponse$expiresIn' => '<p>The date and time when the new access token expires.</p>', 'SectionalElement$level' => '<p>Specifies the size of the font for a <code>Heading</code> sectional element. Valid values are <code>1 | 2 | 3 | 4 | 5 | 6</code>.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal error has occurred. Please retry your request.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>An invalid or out-of-range value was supplied for the input parameter.</p>', 'refs' => [], ], 'JSModule' => [ 'base' => NULL, 'refs' => [ 'ReactStartCodegenJobData$module' => '<p>The JavaScript module type.</p>', ], ], 'JSScript' => [ 'base' => NULL, 'refs' => [ 'ReactStartCodegenJobData$script' => '<p>The file type to use for a JavaScript project.</p>', ], ], 'JSTarget' => [ 'base' => NULL, 'refs' => [ 'ReactStartCodegenJobData$target' => '<p>The ECMAScript specification to use.</p>', ], ], 'LabelDecorator' => [ 'base' => NULL, 'refs' => [ 'CreateFormData$labelDecorator' => '<p>Specifies an icon or decoration to display on the form.</p>', 'Form$labelDecorator' => '<p>Specifies an icon or decoration to display on the form.</p>', 'UpdateFormData$labelDecorator' => '<p>Specifies an icon or decoration to display on the form.</p>', ], ], 'ListCodegenJobsLimit' => [ 'base' => NULL, 'refs' => [ 'ListCodegenJobsRequest$maxResults' => '<p>The maximum number of jobs to retrieve.</p>', ], ], 'ListCodegenJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCodegenJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEntityLimit' => [ 'base' => NULL, 'refs' => [ 'ListComponentsRequest$maxResults' => '<p>The maximum number of components to retrieve.</p>', 'ListFormsRequest$maxResults' => '<p>The maximum number of forms to retrieve.</p>', 'ListThemesRequest$maxResults' => '<p>The maximum number of theme results to return in the response.</p>', ], ], 'ListFormsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFormsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThemesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThemesResponse' => [ 'base' => NULL, 'refs' => [], ], 'MutationActionSetStateParameter' => [ 'base' => '<p>Represents the state configuration when an action modifies a property of another element within the same component.</p>', 'refs' => [ 'ActionParameters$state' => '<p>A key-value pair that specifies the state property name and its initial value.</p>', ], ], 'NoApiRenderConfig' => [ 'base' => '<p>Describes the configuration for an application with no API being used.</p>', 'refs' => [ 'ApiConfiguration$noApiConfig' => '<p>The configuration for an application with no API being used.</p>', ], ], 'NumValues' => [ 'base' => NULL, 'refs' => [ 'FieldValidationConfiguration$numValues' => '<p>The validation to perform on a number value.</p>', ], ], 'OperandType' => [ 'base' => NULL, 'refs' => [ 'Predicate$operandType' => '<p>The type of value to use when performing the evaluation.</p>', ], ], 'Predicate' => [ 'base' => '<p>Stores information for generating Amplify DataStore queries. Use a <code>Predicate</code> to retrieve a subset of the data in a collection.</p>', 'refs' => [ 'ComponentDataConfiguration$predicate' => '<p>Represents the conditional logic to use when binding data to a component. Use this property to retrieve only a subset of the data in a collection.</p>', 'PredicateList$member' => NULL, ], ], 'PredicateList' => [ 'base' => NULL, 'refs' => [ 'ComponentBindingPropertiesValueProperties$predicates' => '<p>A list of predicates for binding a component\'s properties to data.</p>', 'Predicate$or' => '<p>A list of predicates to combine logically.</p>', 'Predicate$and' => '<p>A list of predicates to combine logically.</p>', ], ], 'PutMetadataFlagBody' => [ 'base' => '<p>Stores the metadata information about a feature on a form.</p>', 'refs' => [ 'PutMetadataFlagRequest$body' => '<p>The metadata information to store.</p>', ], ], 'PutMetadataFlagRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReactCodegenDependencies' => [ 'base' => '<p>Indicates the dependency version of the project code to be generated by Amazon Web Services Amplify. The version of the generated code output is determined by the version number contained in <code>aws-amplify</code>.</p>', 'refs' => [ 'ReactStartCodegenJobData$dependencies' => '<p>Lists the dependency packages that may be required for the project code to run.</p>', ], ], 'ReactStartCodegenJobData' => [ 'base' => '<p>Describes the code generation job configuration for a React project.</p>', 'refs' => [ 'CodegenJobRenderConfig$react' => '<p>The name of the <code>ReactStartCodegenJobData</code> object.</p>', ], ], 'RefreshTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'RefreshTokenRequestBody' => [ 'base' => '<p>Describes a refresh token.</p>', 'refs' => [ 'RefreshTokenRequest$refreshTokenBody' => '<p>Information about the refresh token request.</p>', ], ], 'RefreshTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'RelatedModelFieldsList' => [ 'base' => NULL, 'refs' => [ 'CodegenGenericDataRelationshipType$relatedModelFields' => '<p>The related model fields in the data relationship.</p>', ], ], 'ResourceConflictException' => [ 'base' => '<p>The resource specified in the request conflicts with an existing resource.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The requested resource does not exist, or access was denied.</p>', 'refs' => [], ], 'SectionalElement' => [ 'base' => '<p>Stores the configuration information for a visual helper element for a form. A sectional element can be a header, a text block, or a divider. These elements are static and not associated with any data.</p>', 'refs' => [ 'SectionalElementMap$value' => NULL, ], ], 'SectionalElementMap' => [ 'base' => NULL, 'refs' => [ 'CreateFormData$sectionalElements' => '<p>The configuration information for the visual helper elements for the form. These elements are not associated with any data.</p>', 'Form$sectionalElements' => '<p>Stores the visual helper elements for the form that are not associated with any data.</p>', 'UpdateFormData$sectionalElements' => '<p>The configuration information for the visual helper elements for the form. These elements are not associated with any data.</p>', ], ], 'SensitiveString' => [ 'base' => NULL, 'refs' => [ 'ExchangeCodeForTokenRequestBody$code' => '<p>The access code to send in the request.</p>', 'ExchangeCodeForTokenRequestBody$clientId' => '<p>The ID of the client to request the token from.</p>', 'ExchangeCodeForTokenResponse$accessToken' => '<p>The access token.</p>', 'ExchangeCodeForTokenResponse$refreshToken' => '<p>The token to use to refresh a previously issued access token that might have expired.</p>', 'RefreshTokenRequestBody$token' => '<p>The token to use to refresh a previously issued access token that might have expired.</p>', 'RefreshTokenRequestBody$clientId' => '<p>The ID of the client to request the token from.</p>', 'RefreshTokenResponse$accessToken' => '<p>The access token.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of service resources or operations for your Amazon Web Services account. </p>', 'refs' => [], ], 'SortDirection' => [ 'base' => NULL, 'refs' => [ 'SortProperty$direction' => '<p>The direction of the sort, either ascending or descending.</p>', ], ], 'SortProperty' => [ 'base' => '<p>Describes how to sort the data that you bind to a component.</p>', 'refs' => [ 'SortPropertyList$member' => NULL, ], ], 'SortPropertyList' => [ 'base' => NULL, 'refs' => [ 'ComponentDataConfiguration$sort' => '<p>Describes how to sort the component\'s properties.</p>', ], ], 'StartCodegenJobData' => [ 'base' => '<p>The code generation job resource configuration.</p>', 'refs' => [ 'StartCodegenJobRequest$codegenJobToCreate' => '<p>The code generation job resource configuration.</p>', ], ], 'StartCodegenJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartCodegenJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StorageAccessLevel' => [ 'base' => NULL, 'refs' => [ 'FileUploaderFieldConfig$accessLevel' => '<p>The access level to assign to the uploaded files in the Amazon S3 bucket where they are stored. The valid values for this property are <code>private</code>, <code>protected</code>, or <code>public</code>. For detailed information about the permissions associated with each access level, see <a href="https://docs.amplify.aws/lib/storage/configureaccess/q/platform/js/">File access levels</a> in the <i>Amplify documentation</i>.</p>', ], ], 'StrValues' => [ 'base' => NULL, 'refs' => [ 'FieldValidationConfiguration$strValues' => '<p>The validation to perform on a string value.</p>', 'FileUploaderFieldConfig$acceptedFileTypes' => '<p>The file types that are allowed to be uploaded by the file uploader. Provide this information in an array of strings specifying the valid file extensions.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ActionParameters$model' => '<p>The name of the data model. Use when the action performs an operation on an Amplify DataStore model.</p>', 'AssociatedFieldsList$member' => NULL, 'CodegenDependency$name' => '<p>Name of the dependency package.</p>', 'CodegenDependency$supportedVersion' => '<p>Indicates the version of the supported dependency package.</p>', 'CodegenDependency$reason' => '<p>Indicates the reason to include the dependency package in your project code.</p>', 'CodegenGenericDataEnumValuesList$member' => NULL, 'CodegenGenericDataEnums$key' => NULL, 'CodegenGenericDataField$dataTypeValue' => '<p>The value of the data type for the generic data field.</p>', 'CodegenGenericDataFields$key' => NULL, 'CodegenGenericDataModels$key' => NULL, 'CodegenGenericDataNonModelFields$key' => NULL, 'CodegenGenericDataNonModels$key' => NULL, 'CodegenGenericDataRelationshipType$relatedModelName' => '<p>The name of the related model in the data relationship.</p>', 'CodegenGenericDataRelationshipType$relatedJoinFieldName' => '<p>The name of the related join field in the data relationship.</p>', 'CodegenGenericDataRelationshipType$relatedJoinTableName' => '<p>The name of the related join table in the data relationship.</p>', 'CodegenGenericDataRelationshipType$belongsToFieldOnRelatedModel' => '<p>The value of the <code>belongsTo</code> field on the related data model. </p>', 'CodegenJob$environmentName' => '<p>The name of the backend environment associated with the code generation job.</p>', 'CodegenJob$statusMessage' => '<p>The customized status message for the code generation job.</p>', 'CodegenJobAsset$downloadUrl' => '<p>The URL to use to access the asset.</p>', 'CodegenJobSummary$environmentName' => '<p>The name of the backend environment associated with the code generation job.</p>', 'CodegenPrimaryKeysList$member' => NULL, 'Component$appId' => '<p>The unique ID of the Amplify app associated with the component.</p>', 'Component$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'Component$sourceId' => '<p>The unique ID of the component in its original source system, such as Figma.</p>', 'Component$schemaVersion' => '<p>The schema version of the component when it was imported.</p>', 'ComponentBindingProperties$key' => NULL, 'ComponentBindingPropertiesValue$type' => '<p>The property type.</p>', 'ComponentBindingPropertiesValue$defaultValue' => '<p>The default value of the property.</p>', 'ComponentBindingPropertiesValueProperties$model' => '<p>An Amplify DataStore model.</p>', 'ComponentBindingPropertiesValueProperties$field' => '<p>The field to bind the data to.</p>', 'ComponentBindingPropertiesValueProperties$userAttribute' => '<p>An authenticated user attribute.</p>', 'ComponentBindingPropertiesValueProperties$bucket' => '<p>An Amazon S3 bucket.</p>', 'ComponentBindingPropertiesValueProperties$key' => '<p>The storage key for an Amazon S3 bucket.</p>', 'ComponentBindingPropertiesValueProperties$defaultValue' => '<p>The default value to assign to the property.</p>', 'ComponentBindingPropertiesValueProperties$slotName' => '<p>The name of a component slot.</p>', 'ComponentChild$componentType' => '<p>The type of the child component. </p>', 'ComponentChild$name' => '<p>The name of the child component.</p>', 'ComponentChild$sourceId' => '<p>The unique ID of the child component in its original source system, such as Figma.</p>', 'ComponentCollectionProperties$key' => NULL, 'ComponentConditionProperty$property' => '<p>The name of the conditional property.</p>', 'ComponentConditionProperty$field' => '<p>The name of a field. Specify this when the property is a data model.</p>', 'ComponentConditionProperty$operator' => '<p>The operator to use to perform the evaluation, such as <code>eq</code> to represent equals.</p>', 'ComponentConditionProperty$operand' => '<p>The value of the property to evaluate.</p>', 'ComponentConditionProperty$operandType' => '<p>The type of the property to evaluate.</p>', 'ComponentDataConfiguration$model' => '<p>The name of the data model to use to bind data to a component.</p>', 'ComponentEvent$action' => '<p>The action to perform when a specific event is raised.</p>', 'ComponentEvent$bindingEvent' => '<p>Binds an event to an action on a component. When you specify a <code>bindingEvent</code>, the event is called when the action is performed.</p>', 'ComponentEvents$key' => NULL, 'ComponentOverrides$key' => NULL, 'ComponentOverridesValue$key' => NULL, 'ComponentOverridesValue$value' => NULL, 'ComponentProperties$key' => NULL, 'ComponentProperty$value' => '<p>The value to assign to the component property.</p>', 'ComponentProperty$defaultValue' => '<p>The default value to assign to the component property.</p>', 'ComponentProperty$model' => '<p>The data model to use to assign a value to the component property.</p>', 'ComponentProperty$event' => '<p>An event that occurs in your app. Use this for workflow data binding.</p>', 'ComponentProperty$userAttribute' => '<p>An authenticated user attribute to use to assign a value to the component property.</p>', 'ComponentProperty$type' => '<p>The component type.</p>', 'ComponentProperty$importedValue' => '<p>The default value assigned to the property when the component is imported into an app.</p>', 'ComponentProperty$componentName' => '<p>The name of the component that is affected by an event.</p>', 'ComponentProperty$property' => '<p>The name of the component\'s property that is affected by an event.</p>', 'ComponentPropertyBindingProperties$property' => '<p>The component property to bind to the data field.</p>', 'ComponentPropertyBindingProperties$field' => '<p>The data field to bind the property to.</p>', 'ComponentSummary$appId' => '<p>The unique ID of the Amplify app associated with the component.</p>', 'ComponentSummary$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'ComponentVariantValues$key' => NULL, 'ComponentVariantValues$value' => NULL, 'CreateComponentData$sourceId' => '<p>The unique ID of the component in its original source system, such as Figma.</p>', 'CreateComponentData$schemaVersion' => '<p>The schema version of the component when it was imported.</p>', 'CreateComponentRequest$appId' => '<p>The unique ID of the Amplify app to associate with the component.</p>', 'CreateComponentRequest$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'CreateComponentRequest$clientToken' => '<p>The unique client token.</p>', 'CreateFormData$schemaVersion' => '<p>The schema version of the form.</p>', 'CreateFormRequest$appId' => '<p>The unique ID of the Amplify app to associate with the form.</p>', 'CreateFormRequest$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'CreateFormRequest$clientToken' => '<p>The unique client token.</p>', 'CreateThemeRequest$appId' => '<p>The unique ID of the Amplify app associated with the theme.</p>', 'CreateThemeRequest$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'CreateThemeRequest$clientToken' => '<p>The unique client token.</p>', 'DeleteComponentRequest$appId' => '<p>The unique ID of the Amplify app associated with the component to delete.</p>', 'DeleteComponentRequest$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'DeleteFormRequest$appId' => '<p>The unique ID of the Amplify app associated with the form to delete.</p>', 'DeleteFormRequest$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'DeleteThemeRequest$appId' => '<p>The unique ID of the Amplify app associated with the theme to delete.</p>', 'DeleteThemeRequest$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'ExchangeCodeForTokenRequestBody$redirectUri' => '<p>The location of the application that will receive the access code.</p>', 'ExportComponentsRequest$appId' => '<p>The unique ID of the Amplify app to export components to.</p>', 'ExportComponentsRequest$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'ExportComponentsRequest$nextToken' => '<p>The token to request the next page of results.</p>', 'ExportComponentsResponse$nextToken' => '<p>The pagination token that\'s included if more results are available.</p>', 'ExportFormsRequest$appId' => '<p>The unique ID of the Amplify app to export forms to.</p>', 'ExportFormsRequest$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'ExportFormsRequest$nextToken' => '<p>The token to request the next page of results.</p>', 'ExportFormsResponse$nextToken' => '<p>The pagination token that\'s included if more results are available.</p>', 'ExportThemesRequest$appId' => '<p>The unique ID of the Amplify app to export the themes to.</p>', 'ExportThemesRequest$environmentName' => '<p>The name of the backend environment that is part of the Amplify app.</p>', 'ExportThemesRequest$nextToken' => '<p>The token to request the next page of results.</p>', 'ExportThemesResponse$nextToken' => '<p>The pagination token that\'s included if more results are available.</p>', 'FeaturesMap$key' => NULL, 'FeaturesMap$value' => NULL, 'FieldConfig$label' => '<p>The label for the field.</p>', 'FieldInputConfig$type' => '<p>The input type for the field. </p>', 'FieldInputConfig$placeholder' => '<p>The text to display as a placeholder for the field.</p>', 'FieldInputConfig$defaultValue' => '<p>The default value for the field.</p>', 'FieldInputConfig$descriptiveText' => '<p>The text to display to describe the field.</p>', 'FieldInputConfig$defaultCountryCode' => '<p>The default country code for a phone number.</p>', 'FieldInputConfig$name' => '<p>The name of the field.</p>', 'FieldInputConfig$value' => '<p>The value for the field.</p>', 'FieldPosition$rightOf' => '<p>The field position is to the right of the field specified by the string.</p>', 'FieldPosition$below' => '<p>The field position is below the field specified by the string.</p>', 'FieldValidationConfiguration$type' => '<p>The validation to perform on an object type.<code/> </p>', 'FieldValidationConfiguration$validationMessage' => '<p>The validation message to display.</p>', 'FieldsMap$key' => NULL, 'Form$appId' => '<p>The unique ID of the Amplify app associated with the form.</p>', 'Form$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'Form$schemaVersion' => '<p>The schema version of the form when it was imported.</p>', 'FormBindingElement$element' => '<p>The name of the component to retrieve a value from.</p>', 'FormBindingElement$property' => '<p>The property to retrieve a value from.</p>', 'FormBindings$key' => NULL, 'FormButton$children' => '<p>Describes the button\'s properties.</p>', 'FormDataTypeConfig$dataTypeName' => '<p>The unique name of the data type you are using as the data source for the form.</p>', 'FormInputBindingProperties$key' => NULL, 'FormInputBindingPropertiesValue$type' => '<p>The property type.</p>', 'FormInputBindingPropertiesValueProperties$model' => '<p>An Amplify DataStore model.</p>', 'FormInputValueProperty$value' => '<p>The value to assign to the input field.</p>', 'FormInputValuePropertyBindingProperties$property' => '<p>The form property to bind to the data field.</p>', 'FormInputValuePropertyBindingProperties$field' => '<p>The data field to bind the property to.</p>', 'FormStyleConfig$tokenReference' => '<p>A reference to a design token to use to bind the form\'s style properties to an existing theme.</p>', 'FormStyleConfig$value' => '<p>The value of the style setting.</p>', 'FormSummary$appId' => '<p>The unique ID for the app associated with the form summary.</p>', 'FormSummary$environmentName' => '<p>The name of the backend environment that is part of the Amplify app.</p>', 'GetCodegenJobRequest$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app associated with the code generation job.</p>', 'GetComponentRequest$appId' => '<p>The unique ID of the Amplify app.</p>', 'GetComponentRequest$environmentName' => '<p>The name of the backend environment that is part of the Amplify app.</p>', 'GetFormRequest$appId' => '<p>The unique ID of the Amplify app.</p>', 'GetFormRequest$environmentName' => '<p>The name of the backend environment that is part of the Amplify app.</p>', 'GetMetadataRequest$appId' => '<p>The unique ID of the Amplify app.</p>', 'GetMetadataRequest$environmentName' => '<p>The name of the backend environment that is part of the Amplify app.</p>', 'GetThemeRequest$appId' => '<p>The unique ID of the Amplify app.</p>', 'GetThemeRequest$environmentName' => '<p>The name of the backend environment that is part of the Amplify app.</p>', 'GraphQLRenderConfig$typesFilePath' => '<p>The path to the GraphQL types file, relative to the component output directory.</p>', 'GraphQLRenderConfig$queriesFilePath' => '<p>The path to the GraphQL queries file, relative to the component output directory.</p>', 'GraphQLRenderConfig$mutationsFilePath' => '<p>The path to the GraphQL mutations file, relative to the component output directory.</p>', 'GraphQLRenderConfig$subscriptionsFilePath' => '<p>The path to the GraphQL subscriptions file, relative to the component output directory.</p>', 'GraphQLRenderConfig$fragmentsFilePath' => '<p>The path to the GraphQL fragments file, relative to the component output directory.</p>', 'IdentifierList$member' => NULL, 'InternalServerException$message' => NULL, 'InvalidParameterException$message' => NULL, 'ListCodegenJobsRequest$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'ListCodegenJobsRequest$nextToken' => '<p>The token to request the next page of results.</p>', 'ListCodegenJobsResponse$nextToken' => '<p>The pagination token that\'s included if more results are available.</p>', 'ListComponentsRequest$appId' => '<p>The unique ID for the Amplify app.</p>', 'ListComponentsRequest$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'ListComponentsRequest$nextToken' => '<p>The token to request the next page of results.</p>', 'ListComponentsResponse$nextToken' => '<p>The pagination token that\'s included if more results are available.</p>', 'ListFormsRequest$appId' => '<p>The unique ID for the Amplify app.</p>', 'ListFormsRequest$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'ListFormsRequest$nextToken' => '<p>The token to request the next page of results.</p>', 'ListFormsResponse$nextToken' => '<p>The pagination token that\'s included if more results are available.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) to use to list tags.</p>', 'ListThemesRequest$appId' => '<p>The unique ID for the Amplify app.</p>', 'ListThemesRequest$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'ListThemesRequest$nextToken' => '<p>The token to request the next page of results.</p>', 'ListThemesResponse$nextToken' => '<p>The pagination token that\'s returned if more results are available.</p>', 'MutationActionSetStateParameter$componentName' => '<p>The name of the component that is being modified.</p>', 'MutationActionSetStateParameter$property' => '<p>The name of the component property to apply the state configuration to.</p>', 'Predicate$field' => '<p>The field to query.</p>', 'Predicate$operator' => '<p>The operator to use to perform the evaluation.</p>', 'Predicate$operand' => '<p>The value to use when performing the evaluation.</p>', 'PutMetadataFlagBody$newValue' => '<p>The new information to store.</p>', 'PutMetadataFlagRequest$appId' => '<p>The unique ID for the Amplify app.</p>', 'PutMetadataFlagRequest$environmentName' => '<p>The name of the backend environment that is part of the Amplify app.</p>', 'PutMetadataFlagRequest$featureName' => '<p>The name of the feature associated with the metadata.</p>', 'ReactCodegenDependencies$key' => NULL, 'ReactCodegenDependencies$value' => NULL, 'RelatedModelFieldsList$member' => NULL, 'ResourceConflictException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'SectionalElement$type' => '<p>The type of sectional element. Valid values are <code>Heading</code>, <code>Text</code>, and <code>Divider</code>.</p>', 'SectionalElement$text' => '<p>The text for a <code>Text</code> sectional element.</p>', 'SectionalElement$orientation' => '<p>Specifies the orientation for a <code>Divider</code> sectional element. Valid values are <code>horizontal</code> or <code>vertical</code>.</p>', 'SectionalElementMap$key' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'SortProperty$field' => '<p>The field to perform the sort on.</p>', 'StartCodegenJobRequest$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'StartCodegenJobRequest$clientToken' => '<p>The idempotency token used to ensure that the code generation job request completes only once.</p>', 'StrValues$member' => NULL, 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) to use to tag a resource.</p>', 'Theme$appId' => '<p>The unique ID for the Amplify app associated with the theme.</p>', 'Theme$environmentName' => '<p>The name of the backend environment that is a part of the Amplify app.</p>', 'ThemeSummary$appId' => '<p>The unique ID for the app associated with the theme summary.</p>', 'ThemeSummary$environmentName' => '<p>The name of the backend environment that is part of the Amplify app.</p>', 'ThemeValue$value' => '<p>The value of a theme property.</p>', 'ThemeValues$key' => '<p>The name of the property.</p>', 'ThrottlingException$message' => NULL, 'UnauthorizedException$message' => NULL, 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) to use to untag a resource.</p>', 'UpdateComponentData$sourceId' => '<p>The unique ID of the component in its original source system, such as Figma.</p>', 'UpdateComponentData$schemaVersion' => '<p>The schema version of the component when it was imported.</p>', 'UpdateComponentRequest$appId' => '<p>The unique ID for the Amplify app.</p>', 'UpdateComponentRequest$environmentName' => '<p>The name of the backend environment that is part of the Amplify app.</p>', 'UpdateComponentRequest$clientToken' => '<p>The unique client token.</p>', 'UpdateFormData$schemaVersion' => '<p>The schema version of the form.</p>', 'UpdateFormRequest$appId' => '<p>The unique ID for the Amplify app.</p>', 'UpdateFormRequest$environmentName' => '<p>The name of the backend environment that is part of the Amplify app.</p>', 'UpdateFormRequest$clientToken' => '<p>The unique client token.</p>', 'UpdateThemeRequest$appId' => '<p>The unique ID for the Amplify app.</p>', 'UpdateThemeRequest$environmentName' => '<p>The name of the backend environment that is part of the Amplify app.</p>', 'UpdateThemeRequest$clientToken' => '<p>The unique client token.</p>', ], ], 'SyntheticTimestamp_date_time' => [ 'base' => NULL, 'refs' => [ 'CodegenJob$createdAt' => '<p>The time that the code generation job was created.</p>', 'CodegenJob$modifiedAt' => '<p>The time that the code generation job was modified.</p>', 'CodegenJobSummary$createdAt' => '<p>The time that the code generation job summary was created.</p>', 'CodegenJobSummary$modifiedAt' => '<p>The time that the code generation job summary was modified.</p>', 'Component$createdAt' => '<p>The time that the component was created.</p>', 'Component$modifiedAt' => '<p>The time that the component was modified.</p>', 'Theme$createdAt' => '<p>The time that the theme was created.</p>', 'Theme$modifiedAt' => '<p>The time that the theme was modified.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys to use to untag a resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CodegenJob$tags' => '<p>One or more key-value pairs to use when tagging the code generation job.</p>', 'Component$tags' => '<p>One or more key-value pairs to use when tagging the component.</p>', 'CreateComponentData$tags' => '<p>One or more key-value pairs to use when tagging the component data.</p>', 'CreateFormData$tags' => '<p>One or more key-value pairs to use when tagging the form data.</p>', 'CreateThemeData$tags' => '<p>One or more key-value pairs to use when tagging the theme data.</p>', 'Form$tags' => '<p>One or more key-value pairs to use when tagging the form.</p>', 'ListTagsForResourceResponse$tags' => '<p>A list of tag key value pairs for a specified Amazon Resource Name (ARN).</p>', 'StartCodegenJobData$tags' => '<p>One or more key-value pairs to use when tagging the code generation job data.</p>', 'TagResourceRequest$tags' => '<p>A list of tag key value pairs for a specified Amazon Resource Name (ARN).</p>', 'Theme$tags' => '<p>One or more key-value pairs to use when tagging the theme.</p>', ], ], 'Theme' => [ 'base' => '<p>A theme is a collection of style settings that apply globally to the components associated with an Amplify application.</p>', 'refs' => [ 'CreateThemeResponse$entity' => '<p>Describes the configuration of the new theme.</p>', 'GetThemeResponse$theme' => '<p>Represents the configuration settings for the theme.</p>', 'ThemeList$member' => NULL, 'UpdateThemeResponse$entity' => '<p>Describes the configuration of the updated theme.</p>', ], ], 'ThemeList' => [ 'base' => NULL, 'refs' => [ 'ExportThemesResponse$entities' => '<p>Represents the configuration of the exported themes.</p>', ], ], 'ThemeName' => [ 'base' => NULL, 'refs' => [ 'CreateThemeData$name' => '<p>The name of the theme.</p>', 'Theme$name' => '<p>The name of the theme.</p>', 'ThemeSummary$name' => '<p>The name of the theme.</p>', 'UpdateThemeData$name' => '<p>The name of the theme to update.</p>', ], ], 'ThemeSummary' => [ 'base' => '<p>Describes the basic information about a theme.</p>', 'refs' => [ 'ThemeSummaryList$member' => NULL, ], ], 'ThemeSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListThemesResponse$entities' => '<p>The list of themes for the Amplify app.</p>', ], ], 'ThemeValue' => [ 'base' => '<p>Describes the configuration of a theme\'s properties.</p>', 'refs' => [ 'ThemeValues$value' => '<p>The value of the property.</p>', ], ], 'ThemeValues' => [ 'base' => '<p>A key-value pair that defines a property of a theme.</p>', 'refs' => [ 'ThemeValuesList$member' => NULL, ], ], 'ThemeValuesList' => [ 'base' => NULL, 'refs' => [ 'CreateThemeData$values' => '<p>A list of key-value pairs that deﬁnes the properties of the theme.</p>', 'CreateThemeData$overrides' => '<p>Describes the properties that can be overriden to customize an instance of the theme.</p>', 'Theme$values' => '<p>A list of key-value pairs that defines the properties of the theme.</p>', 'Theme$overrides' => '<p>Describes the properties that can be overriden to customize a theme.</p>', 'ThemeValue$children' => '<p>A list of key-value pairs that define the theme\'s properties.</p>', 'UpdateThemeData$values' => '<p>A list of key-value pairs that define the theme\'s properties.</p>', 'UpdateThemeData$overrides' => '<p>Describes the properties that can be overriden to customize the theme.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'TokenProviders' => [ 'base' => NULL, 'refs' => [ 'ExchangeCodeForTokenRequest$provider' => '<p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>', 'RefreshTokenRequest$provider' => '<p>The third-party provider for the token. The only valid value is <code>figma</code>.</p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>You don\'t have permission to perform this operation.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComponentData' => [ 'base' => '<p>Updates and saves all of the information about a component, based on component ID.</p>', 'refs' => [ 'UpdateComponentRequest$updatedComponent' => '<p>The configuration of the updated component.</p>', ], ], 'UpdateComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFormData' => [ 'base' => '<p>Updates and saves all of the information about a form, based on form ID.</p>', 'refs' => [ 'UpdateFormRequest$updatedForm' => '<p>The request accepts the following data in JSON format.</p>', ], ], 'UpdateFormRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFormResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemeData' => [ 'base' => '<p>Saves the data binding information for a theme.</p>', 'refs' => [ 'UpdateThemeRequest$updatedTheme' => '<p>The configuration of the updated theme.</p>', ], ], 'UpdateThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemeResponse' => [ 'base' => NULL, 'refs' => [], ], 'Uuid' => [ 'base' => NULL, 'refs' => [ 'CodegenJob$id' => '<p>The unique ID for the code generation job.</p>', 'CodegenJobSummary$id' => '<p>The unique ID for the code generation job summary.</p>', 'Component$id' => '<p>The unique ID of the component.</p>', 'ComponentSummary$id' => '<p>The unique ID of the component.</p>', 'DeleteComponentRequest$id' => '<p>The unique ID of the component to delete.</p>', 'DeleteFormRequest$id' => '<p>The unique ID of the form to delete.</p>', 'DeleteThemeRequest$id' => '<p>The unique ID of the theme to delete.</p>', 'Form$id' => '<p>The unique ID of the form.</p>', 'FormSummary$id' => '<p>The ID of the form.</p>', 'GetCodegenJobRequest$id' => '<p>The unique ID of the code generation job.</p>', 'GetComponentRequest$id' => '<p>The unique ID of the component.</p>', 'GetFormRequest$id' => '<p>The unique ID of the form.</p>', 'GetThemeRequest$id' => '<p>The unique ID for the theme.</p>', 'Theme$id' => '<p>The ID for the theme.</p>', 'ThemeSummary$id' => '<p>The ID of the theme.</p>', 'UpdateComponentData$id' => '<p>The unique ID of the component to update.</p>', 'UpdateComponentRequest$id' => '<p>The unique ID for the component.</p>', 'UpdateFormRequest$id' => '<p>The unique ID for the form.</p>', 'UpdateThemeData$id' => '<p>The unique ID of the theme to update.</p>', 'UpdateThemeRequest$id' => '<p>The unique ID for the theme.</p>', ], ], 'ValidationsList' => [ 'base' => NULL, 'refs' => [ 'FieldConfig$validations' => '<p>The validations to perform on the value in the field.</p>', ], ], 'ValueMapping' => [ 'base' => '<p>Associates a complex object with a display value. Use <code>ValueMapping</code> to store how to represent complex objects when they are displayed.</p>', 'refs' => [ 'ValueMappingList$member' => NULL, ], ], 'ValueMappingList' => [ 'base' => NULL, 'refs' => [ 'ValueMappings$values' => '<p>The value and display value pairs.</p>', ], ], 'ValueMappings' => [ 'base' => '<p>Represents the data binding configuration for a value map.</p>', 'refs' => [ 'FieldInputConfig$valueMappings' => '<p>The information to use to customize the input fields with data at runtime.</p>', ], ], ],];
