<?php
// This file was auto-generated from sdk-root/src/data/appsync/2017-07-25/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AppSync provides API actions for creating and interacting with data sources using GraphQL from your application.</p>', 'operations' => [ 'AssociateApi' => '<p>Maps an endpoint to your custom domain.</p>', 'AssociateMergedGraphqlApi' => '<p>Creates an association between a Merged API and source API using the source API\'s identifier.</p>', 'AssociateSourceGraphqlApi' => '<p>Creates an association between a Merged API and source API using the Merged API\'s identifier.</p>', 'CreateApiCache' => '<p>Creates a cache for the GraphQL API.</p>', 'CreateApiKey' => '<p>Creates a unique key that you can distribute to clients who invoke your API.</p>', 'CreateDataSource' => '<p>Creates a <code>DataSource</code> object.</p>', 'CreateDomainName' => '<p>Creates a custom <code>DomainName</code> object.</p>', 'CreateFunction' => '<p>Creates a <code>Function</code> object.</p> <p>A function is a reusable entity. You can use multiple functions to compose the resolver logic.</p>', 'CreateGraphqlApi' => '<p>Creates a <code>GraphqlApi</code> object.</p>', 'CreateResolver' => '<p>Creates a <code>Resolver</code> object.</p> <p>A resolver converts incoming requests into a format that a data source can understand, and converts the data source\'s responses into GraphQL.</p>', 'CreateType' => '<p>Creates a <code>Type</code> object.</p>', 'DeleteApiCache' => '<p>Deletes an <code>ApiCache</code> object.</p>', 'DeleteApiKey' => '<p>Deletes an API key.</p>', 'DeleteDataSource' => '<p>Deletes a <code>DataSource</code> object.</p>', 'DeleteDomainName' => '<p>Deletes a custom <code>DomainName</code> object.</p>', 'DeleteFunction' => '<p>Deletes a <code>Function</code>.</p>', 'DeleteGraphqlApi' => '<p>Deletes a <code>GraphqlApi</code> object.</p>', 'DeleteResolver' => '<p>Deletes a <code>Resolver</code> object.</p>', 'DeleteType' => '<p>Deletes a <code>Type</code> object.</p>', 'DisassociateApi' => '<p>Removes an <code>ApiAssociation</code> object from a custom domain.</p>', 'DisassociateMergedGraphqlApi' => '<p>Deletes an association between a Merged API and source API using the source API\'s identifier and the association ID.</p>', 'DisassociateSourceGraphqlApi' => '<p>Deletes an association between a Merged API and source API using the Merged API\'s identifier and the association ID.</p>', 'EvaluateCode' => '<p>Evaluates the given code and returns the response. The code definition requirements depend on the specified runtime. For <code>APPSYNC_JS</code> runtimes, the code defines the request and response functions. The request function takes the incoming request after a GraphQL operation is parsed and converts it into a request configuration for the selected data source operation. The response function interprets responses from the data source and maps it to the shape of the GraphQL field output type. </p>', 'EvaluateMappingTemplate' => '<p>Evaluates a given template and returns the response. The mapping template can be a request or response template.</p> <p>Request templates take the incoming request after a GraphQL operation is parsed and convert it into a request configuration for the selected data source operation. Response templates interpret responses from the data source and map it to the shape of the GraphQL field output type.</p> <p>Mapping templates are written in the Apache Velocity Template Language (VTL).</p>', 'FlushApiCache' => '<p>Flushes an <code>ApiCache</code> object.</p>', 'GetApiAssociation' => '<p>Retrieves an <code>ApiAssociation</code> object.</p>', 'GetApiCache' => '<p>Retrieves an <code>ApiCache</code> object.</p>', 'GetDataSource' => '<p>Retrieves a <code>DataSource</code> object.</p>', 'GetDataSourceIntrospection' => '<p>Retrieves the record of an existing introspection. If the retrieval is successful, the result of the instrospection will also be returned. If the retrieval fails the operation, an error message will be returned instead.</p>', 'GetDomainName' => '<p>Retrieves a custom <code>DomainName</code> object.</p>', 'GetFunction' => '<p>Get a <code>Function</code>.</p>', 'GetGraphqlApi' => '<p>Retrieves a <code>GraphqlApi</code> object.</p>', 'GetGraphqlApiEnvironmentVariables' => '<p>Retrieves the list of environmental variable key-value pairs associated with an API by its ID value.</p>', 'GetIntrospectionSchema' => '<p>Retrieves the introspection schema for a GraphQL API.</p>', 'GetResolver' => '<p>Retrieves a <code>Resolver</code> object.</p>', 'GetSchemaCreationStatus' => '<p>Retrieves the current status of a schema creation operation.</p>', 'GetSourceApiAssociation' => '<p>Retrieves a <code>SourceApiAssociation</code> object.</p>', 'GetType' => '<p>Retrieves a <code>Type</code> object.</p>', 'ListApiKeys' => '<p>Lists the API keys for a given API.</p> <note> <p>API keys are deleted automatically 60 days after they expire. However, they may still be included in the response until they have actually been deleted. You can safely call <code>DeleteApiKey</code> to manually delete a key before it\'s automatically deleted.</p> </note>', 'ListDataSources' => '<p>Lists the data sources for a given API.</p>', 'ListDomainNames' => '<p>Lists multiple custom domain names.</p>', 'ListFunctions' => '<p>List multiple functions.</p>', 'ListGraphqlApis' => '<p>Lists your GraphQL APIs.</p>', 'ListResolvers' => '<p>Lists the resolvers for a given API and type.</p>', 'ListResolversByFunction' => '<p>List the resolvers that are associated with a specific function.</p>', 'ListSourceApiAssociations' => '<p>Lists the <code>SourceApiAssociationSummary</code> data.</p>', 'ListTagsForResource' => '<p>Lists the tags for a resource.</p>', 'ListTypes' => '<p>Lists the types for a given API.</p>', 'ListTypesByAssociation' => '<p>Lists <code>Type</code> objects by the source API association ID.</p>', 'PutGraphqlApiEnvironmentVariables' => '<p>Creates a list of environmental variables in an API by its ID value. </p> <p>When creating an environmental variable, it must follow the constraints below:</p> <ul> <li> <p>Both JavaScript and VTL templates support environmental variables.</p> </li> <li> <p>Environmental variables are not evaluated before function invocation.</p> </li> <li> <p>Environmental variables only support string values.</p> </li> <li> <p>Any defined value in an environmental variable is considered a string literal and not expanded.</p> </li> <li> <p>Variable evaluations should ideally be performed in the function code.</p> </li> </ul> <p>When creating an environmental variable key-value pair, it must follow the additional constraints below:</p> <ul> <li> <p>Keys must begin with a letter.</p> </li> <li> <p>Keys must be at least two characters long.</p> </li> <li> <p>Keys can only contain letters, numbers, and the underscore character (_).</p> </li> <li> <p>Values can be up to 512 characters long.</p> </li> <li> <p>You can configure up to 50 key-value pairs in a GraphQL API.</p> </li> </ul> <p>You can create a list of environmental variables by adding it to the <code>environmentVariables</code> payload as a list in the format <code>{"key1":"value1","key2":"value2", …}</code>. Note that each call of the <code>PutGraphqlApiEnvironmentVariables</code> action will result in the overwriting of the existing environmental variable list of that API. This means the existing environmental variables will be lost. To avoid this, you must include all existing and new environmental variables in the list each time you call this action.</p>', 'StartDataSourceIntrospection' => '<p>Creates a new introspection. Returns the <code>introspectionId</code> of the new introspection after its creation. </p>', 'StartSchemaCreation' => '<p>Adds a new schema to your GraphQL API.</p> <p>This operation is asynchronous. Use to determine when it has completed.</p>', 'StartSchemaMerge' => '<p>Initiates a merge operation. Returns a status that shows the result of the merge operation.</p>', 'TagResource' => '<p>Tags a resource with user-supplied tags.</p>', 'UntagResource' => '<p>Untags a resource.</p>', 'UpdateApiCache' => '<p>Updates the cache for the GraphQL API.</p>', 'UpdateApiKey' => '<p>Updates an API key. You can update the key as long as it\'s not deleted.</p>', 'UpdateDataSource' => '<p>Updates a <code>DataSource</code> object.</p>', 'UpdateDomainName' => '<p>Updates a custom <code>DomainName</code> object.</p>', 'UpdateFunction' => '<p>Updates a <code>Function</code> object.</p>', 'UpdateGraphqlApi' => '<p>Updates a <code>GraphqlApi</code> object.</p>', 'UpdateResolver' => '<p>Updates a <code>Resolver</code> object.</p>', 'UpdateSourceApiAssociation' => '<p>Updates some of the configuration choices of a particular source API association.</p>', 'UpdateType' => '<p>Updates a <code>Type</code> object.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have access to perform this operation on this resource.</p>', 'refs' => [], ], 'AdditionalAuthenticationProvider' => [ 'base' => '<p>Describes an additional authentication provider.</p>', 'refs' => [ 'AdditionalAuthenticationProviders$member' => NULL, ], ], 'AdditionalAuthenticationProviders' => [ 'base' => NULL, 'refs' => [ 'CreateGraphqlApiRequest$additionalAuthenticationProviders' => '<p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>', 'GraphqlApi$additionalAuthenticationProviders' => '<p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>', 'UpdateGraphqlApiRequest$additionalAuthenticationProviders' => '<p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>', ], ], 'ApiAssociation' => [ 'base' => '<p>Describes an <code>ApiAssociation</code> object.</p>', 'refs' => [ 'AssociateApiResponse$apiAssociation' => '<p>The <code>ApiAssociation</code> object.</p>', 'GetApiAssociationResponse$apiAssociation' => '<p>The <code>ApiAssociation</code> object.</p>', ], ], 'ApiCache' => [ 'base' => '<p>The <code>ApiCache</code> object.</p>', 'refs' => [ 'CreateApiCacheResponse$apiCache' => '<p>The <code>ApiCache</code> object.</p>', 'GetApiCacheResponse$apiCache' => '<p>The <code>ApiCache</code> object.</p>', 'UpdateApiCacheResponse$apiCache' => '<p>The <code>ApiCache</code> object.</p>', ], ], 'ApiCacheStatus' => [ 'base' => NULL, 'refs' => [ 'ApiCache$status' => '<p>The cache instance status.</p> <ul> <li> <p> <b>AVAILABLE</b>: The instance is available for use.</p> </li> <li> <p> <b>CREATING</b>: The instance is currently creating.</p> </li> <li> <p> <b>DELETING</b>: The instance is currently deleting.</p> </li> <li> <p> <b>MODIFYING</b>: The instance is currently modifying.</p> </li> <li> <p> <b>FAILED</b>: The instance has failed creation.</p> </li> </ul>', ], ], 'ApiCacheType' => [ 'base' => NULL, 'refs' => [ 'ApiCache$type' => '<p>The cache instance type. Valid values are </p> <ul> <li> <p> <code>SMALL</code> </p> </li> <li> <p> <code>MEDIUM</code> </p> </li> <li> <p> <code>LARGE</code> </p> </li> <li> <p> <code>XLARGE</code> </p> </li> <li> <p> <code>LARGE_2X</code> </p> </li> <li> <p> <code>LARGE_4X</code> </p> </li> <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li> <li> <p> <code>LARGE_12X</code> </p> </li> </ul> <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p> <p>The following legacy instance types are available, but their use is discouraged:</p> <ul> <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li> <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li> <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li> <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li> <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li> <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li> <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li> </ul>', 'CreateApiCacheRequest$type' => '<p>The cache instance type. Valid values are </p> <ul> <li> <p> <code>SMALL</code> </p> </li> <li> <p> <code>MEDIUM</code> </p> </li> <li> <p> <code>LARGE</code> </p> </li> <li> <p> <code>XLARGE</code> </p> </li> <li> <p> <code>LARGE_2X</code> </p> </li> <li> <p> <code>LARGE_4X</code> </p> </li> <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li> <li> <p> <code>LARGE_12X</code> </p> </li> </ul> <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p> <p>The following legacy instance types are available, but their use is discouraged:</p> <ul> <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li> <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li> <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li> <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li> <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li> <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li> <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li> </ul>', 'UpdateApiCacheRequest$type' => '<p>The cache instance type. Valid values are </p> <ul> <li> <p> <code>SMALL</code> </p> </li> <li> <p> <code>MEDIUM</code> </p> </li> <li> <p> <code>LARGE</code> </p> </li> <li> <p> <code>XLARGE</code> </p> </li> <li> <p> <code>LARGE_2X</code> </p> </li> <li> <p> <code>LARGE_4X</code> </p> </li> <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li> <li> <p> <code>LARGE_12X</code> </p> </li> </ul> <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p> <p>The following legacy instance types are available, but their use is discouraged:</p> <ul> <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li> <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li> <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li> <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li> <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li> <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li> <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li> </ul>', ], ], 'ApiCachingBehavior' => [ 'base' => NULL, 'refs' => [ 'ApiCache$apiCachingBehavior' => '<p>Caching behavior.</p> <ul> <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li> <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li> </ul>', 'CreateApiCacheRequest$apiCachingBehavior' => '<p>Caching behavior.</p> <ul> <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li> <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li> </ul>', 'UpdateApiCacheRequest$apiCachingBehavior' => '<p>Caching behavior.</p> <ul> <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li> <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li> </ul>', ], ], 'ApiKey' => [ 'base' => '<p>Describes an API key.</p> <p>Customers invoke AppSync GraphQL API operations with API keys as an identity mechanism. There are two key versions:</p> <p> <b>da1</b>: We introduced this version at launch in November 2017. These keys always expire after 7 days. Amazon DynamoDB TTL manages key expiration. These keys ceased to be valid after February 21, 2018, and they should no longer be used.</p> <ul> <li> <p> <code>ListApiKeys</code> returns the expiration time in milliseconds.</p> </li> <li> <p> <code>CreateApiKey</code> returns the expiration time in milliseconds.</p> </li> <li> <p> <code>UpdateApiKey</code> is not available for this key version.</p> </li> <li> <p> <code>DeleteApiKey</code> deletes the item from the table.</p> </li> <li> <p>Expiration is stored in DynamoDB as milliseconds. This results in a bug where keys are not automatically deleted because DynamoDB expects the TTL to be stored in seconds. As a one-time action, we deleted these keys from the table on February 21, 2018.</p> </li> </ul> <p> <b>da2</b>: We introduced this version in February 2018 when AppSync added support to extend key expiration.</p> <ul> <li> <p> <code>ListApiKeys</code> returns the expiration time and deletion time in seconds.</p> </li> <li> <p> <code>CreateApiKey</code> returns the expiration time and deletion time in seconds and accepts a user-provided expiration time in seconds.</p> </li> <li> <p> <code>UpdateApiKey</code> returns the expiration time and and deletion time in seconds and accepts a user-provided expiration time in seconds. Expired API keys are kept for 60 days after the expiration time. You can update the key expiration time as long as the key isn\'t deleted.</p> </li> <li> <p> <code>DeleteApiKey</code> deletes the item from the table.</p> </li> <li> <p>Expiration is stored in DynamoDB as seconds. After the expiration time, using the key to authenticate will fail. However, you can reinstate the key before deletion.</p> </li> <li> <p>Deletion is stored in DynamoDB as seconds. The key is deleted after deletion time.</p> </li> </ul>', 'refs' => [ 'ApiKeys$member' => NULL, 'CreateApiKeyResponse$apiKey' => '<p>The API key.</p>', 'UpdateApiKeyResponse$apiKey' => '<p>The API key.</p>', ], ], 'ApiKeyLimitExceededException' => [ 'base' => '<p>The API key exceeded a limit. Try your request again.</p>', 'refs' => [], ], 'ApiKeyValidityOutOfBoundsException' => [ 'base' => '<p>The API key expiration must be set to a value between 1 and 365 days from creation (for <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).</p>', 'refs' => [], ], 'ApiKeys' => [ 'base' => NULL, 'refs' => [ 'ListApiKeysResponse$apiKeys' => '<p>The <code>ApiKey</code> objects.</p>', ], ], 'ApiLimitExceededException' => [ 'base' => '<p>The GraphQL API exceeded a limit. Try your request again.</p>', 'refs' => [], ], 'AppSyncRuntime' => [ 'base' => '<p>Describes a runtime used by an Amazon Web Services AppSync pipeline resolver or Amazon Web Services AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.</p>', 'refs' => [ 'CreateFunctionRequest$runtime' => NULL, 'CreateResolverRequest$runtime' => NULL, 'EvaluateCodeRequest$runtime' => '<p>The runtime to be used when evaluating the code. Currently, only the <code>APPSYNC_JS</code> runtime is supported.</p>', 'FunctionConfiguration$runtime' => NULL, 'Resolver$runtime' => NULL, 'UpdateFunctionRequest$runtime' => NULL, 'UpdateResolverRequest$runtime' => NULL, ], ], 'AssociateApiRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateApiResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMergedGraphqlApiRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMergedGraphqlApiResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSourceGraphqlApiRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSourceGraphqlApiResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociationStatus' => [ 'base' => NULL, 'refs' => [ 'ApiAssociation$associationStatus' => '<p>Identifies the status of an association.</p> <ul> <li> <p> <b>PROCESSING</b>: The API association is being created. You cannot modify association requests during processing.</p> </li> <li> <p> <b>SUCCESS</b>: The API association was successful. You can modify associations after success.</p> </li> <li> <p> <b>FAILED</b>: The API association has failed. You can modify associations after failure.</p> </li> </ul>', ], ], 'AuthenticationType' => [ 'base' => NULL, 'refs' => [ 'AdditionalAuthenticationProvider$authenticationType' => '<p>The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda.</p>', 'CreateGraphqlApiRequest$authenticationType' => '<p>The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda.</p>', 'GraphqlApi$authenticationType' => '<p>The authentication type.</p>', 'UpdateGraphqlApiRequest$authenticationType' => '<p>The new authentication type for the <code>GraphqlApi</code> object.</p>', ], ], 'AuthorizationConfig' => [ 'base' => '<p>The authorization configuration in case the HTTP endpoint requires authorization.</p>', 'refs' => [ 'HttpDataSourceConfig$authorizationConfig' => '<p>The authorization configuration in case the HTTP endpoint requires authorization.</p>', ], ], 'AuthorizationType' => [ 'base' => NULL, 'refs' => [ 'AuthorizationConfig$authorizationType' => '<p>The authorization type that the HTTP endpoint requires.</p> <ul> <li> <p> <b>AWS_IAM</b>: The authorization type is Signature Version 4 (SigV4).</p> </li> </ul>', ], ], 'AwsIamConfig' => [ 'base' => '<p>The Identity and Access Management (IAM) configuration.</p>', 'refs' => [ 'AuthorizationConfig$awsIamConfig' => '<p>The Identity and Access Management (IAM) settings.</p>', ], ], 'BadRequestDetail' => [ 'base' => '<p>Provides further details for the reason behind the bad request. For reason type <code>CODE_ERROR</code>, the detail will contain a list of code errors.</p>', 'refs' => [ 'BadRequestException$detail' => NULL, ], ], 'BadRequestException' => [ 'base' => '<p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and then try again.</p>', 'refs' => [], ], 'BadRequestReason' => [ 'base' => '<p>Provides context for the cause of the bad request. The only supported value is <code>CODE_ERROR</code>.</p>', 'refs' => [ 'BadRequestException$reason' => NULL, ], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'GetIntrospectionSchemaResponse$schema' => '<p>The schema, in GraphQL Schema Definition Language (SDL) format.</p> <p>For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL documentation</a>.</p>', 'StartSchemaCreationRequest$definition' => '<p>The schema definition, in GraphQL schema language format.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ApiCache$transitEncryptionEnabled' => '<p>Transit encryption flag when connecting to cache. You cannot update this setting after creation.</p>', 'ApiCache$atRestEncryptionEnabled' => '<p>At-rest encryption flag for cache. You cannot update this setting after creation.</p>', 'CreateApiCacheRequest$transitEncryptionEnabled' => '<p>Transit encryption flag when connecting to cache. You cannot update this setting after creation.</p>', 'CreateApiCacheRequest$atRestEncryptionEnabled' => '<p>At-rest encryption flag for cache. You cannot update this setting after creation.</p>', 'CreateGraphqlApiRequest$xrayEnabled' => '<p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>', 'DynamodbDataSourceConfig$useCallerCredentials' => '<p>Set to TRUE to use Amazon Cognito credentials with this data source.</p>', 'DynamodbDataSourceConfig$versioned' => '<p>Set to TRUE to use Conflict Detection and Resolution with this data source.</p>', 'GetDataSourceIntrospectionRequest$includeModelsSDL' => '<p>A boolean flag that determines whether SDL should be generated for introspected types or not. If set to <code>true</code>, each model will contain an <code>sdl</code> property that contains the SDL for that type. The SDL only contains the type data and no additional metadata or directives. </p>', 'GraphqlApi$xrayEnabled' => '<p>A flag indicating whether to use X-Ray tracing for this <code>GraphqlApi</code>.</p>', 'LogConfig$excludeVerboseContent' => '<p>Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging level.</p>', 'UpdateGraphqlApiRequest$xrayEnabled' => '<p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>', ], ], 'BooleanValue' => [ 'base' => NULL, 'refs' => [ 'GetIntrospectionSchemaRequest$includeDirectives' => '<p>A flag that specifies whether the schema introspection should contain directives.</p>', ], ], 'CacheHealthMetricsConfig' => [ 'base' => NULL, 'refs' => [ 'ApiCache$healthMetricsConfig' => '<p>Controls how cache health metrics will be emitted to CloudWatch. Cache health metrics include:</p> <ul> <li> <p>NetworkBandwidthOutAllowanceExceeded: The network packets dropped because the throughput exceeded the aggregated bandwidth limit. This is useful for diagnosing bottlenecks in a cache configuration.</p> </li> <li> <p>EngineCPUUtilization: The CPU utilization (percentage) allocated to the Redis process. This is useful for diagnosing bottlenecks in a cache configuration.</p> </li> </ul> <p>Metrics will be recorded by API ID. You can set the value to <code>ENABLED</code> or <code>DISABLED</code>.</p>', 'CreateApiCacheRequest$healthMetricsConfig' => '<p>Controls how cache health metrics will be emitted to CloudWatch. Cache health metrics include:</p> <ul> <li> <p>NetworkBandwidthOutAllowanceExceeded: The network packets dropped because the throughput exceeded the aggregated bandwidth limit. This is useful for diagnosing bottlenecks in a cache configuration.</p> </li> <li> <p>EngineCPUUtilization: The CPU utilization (percentage) allocated to the Redis process. This is useful for diagnosing bottlenecks in a cache configuration.</p> </li> </ul> <p>Metrics will be recorded by API ID. You can set the value to <code>ENABLED</code> or <code>DISABLED</code>.</p>', 'UpdateApiCacheRequest$healthMetricsConfig' => '<p>Controls how cache health metrics will be emitted to CloudWatch. Cache health metrics include:</p> <ul> <li> <p>NetworkBandwidthOutAllowanceExceeded: The network packets dropped because the throughput exceeded the aggregated bandwidth limit. This is useful for diagnosing bottlenecks in a cache configuration.</p> </li> <li> <p>EngineCPUUtilization: The CPU utilization (percentage) allocated to the Redis process. This is useful for diagnosing bottlenecks in a cache configuration.</p> </li> </ul> <p>Metrics will be recorded by API ID. You can set the value to <code>ENABLED</code> or <code>DISABLED</code>.</p>', ], ], 'CachingConfig' => [ 'base' => '<p>The caching configuration for a resolver that has caching activated.</p>', 'refs' => [ 'CreateResolverRequest$cachingConfig' => '<p>The caching configuration for the resolver.</p>', 'Resolver$cachingConfig' => '<p>The caching configuration for the resolver.</p>', 'UpdateResolverRequest$cachingConfig' => '<p>The caching configuration for the resolver.</p>', ], ], 'CachingKeys' => [ 'base' => NULL, 'refs' => [ 'CachingConfig$cachingKeys' => '<p>The caching keys for a resolver that has caching activated.</p> <p>Valid values are entries from the <code>$context.arguments</code>, <code>$context.source</code>, and <code>$context.identity</code> maps.</p>', ], ], 'CertificateArn' => [ 'base' => NULL, 'refs' => [ 'CreateDomainNameRequest$certificateArn' => '<p>The Amazon Resource Name (ARN) of the certificate. This can be an Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server certificate.</p>', 'DomainNameConfig$certificateArn' => '<p>The Amazon Resource Name (ARN) of the certificate. This can be an Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server certificate.</p>', ], ], 'Code' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$code' => '<p>The <code>function</code> code that contains the request and response functions. When code is used, the <code>runtime</code> is required. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.</p>', 'CreateResolverRequest$code' => '<p>The <code>resolver</code> code that contains the request and response functions. When code is used, the <code>runtime</code> is required. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.</p>', 'EvaluateCodeRequest$code' => '<p>The code definition to be evaluated. Note that <code>code</code> and <code>runtime</code> are both required for this action. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.</p>', 'FunctionConfiguration$code' => '<p>The <code>function</code> code that contains the request and response functions. When code is used, the <code>runtime</code> is required. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.</p>', 'Resolver$code' => '<p>The <code>resolver</code> code that contains the request and response functions. When code is used, the <code>runtime</code> is required. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.</p>', 'UpdateFunctionRequest$code' => '<p>The <code>function</code> code that contains the request and response functions. When code is used, the <code>runtime</code> is required. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.</p>', 'UpdateResolverRequest$code' => '<p>The <code>resolver</code> code that contains the request and response functions. When code is used, the <code>runtime</code> is required. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.</p>', ], ], 'CodeError' => [ 'base' => '<p>Describes an AppSync error.</p>', 'refs' => [ 'CodeErrors$member' => NULL, ], ], 'CodeErrorColumn' => [ 'base' => NULL, 'refs' => [ 'CodeErrorLocation$column' => '<p>The column number in the code. Defaults to <code>0</code> if unknown.</p>', ], ], 'CodeErrorLine' => [ 'base' => NULL, 'refs' => [ 'CodeErrorLocation$line' => '<p>The line number in the code. Defaults to <code>0</code> if unknown.</p>', ], ], 'CodeErrorLocation' => [ 'base' => '<p>Describes the location of the error in a code sample.</p>', 'refs' => [ 'CodeError$location' => '<p>The line, column, and span location of the error in the code.</p>', ], ], 'CodeErrorSpan' => [ 'base' => NULL, 'refs' => [ 'CodeErrorLocation$span' => '<p>The span/length of the error. Defaults to <code>-1</code> if unknown.</p>', ], ], 'CodeErrors' => [ 'base' => NULL, 'refs' => [ 'BadRequestDetail$codeErrors' => '<p>Contains the list of errors in the request.</p>', 'EvaluateCodeErrorDetail$codeErrors' => '<p>Contains the list of <code>CodeError</code> objects.</p>', ], ], 'CognitoUserPoolConfig' => [ 'base' => '<p>Describes an Amazon Cognito user pool configuration.</p>', 'refs' => [ 'AdditionalAuthenticationProvider$userPoolConfig' => '<p>The Amazon Cognito user pool configuration.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>Another modification is in progress at this time and it must complete before you can make your change.</p>', 'refs' => [], ], 'ConflictDetectionType' => [ 'base' => NULL, 'refs' => [ 'SyncConfig$conflictDetection' => '<p>The Conflict Detection strategy to use.</p> <ul> <li> <p> <b>VERSION</b>: Detect conflicts based on object versions for this resolver.</p> </li> <li> <p> <b>NONE</b>: Do not detect conflicts when invoking this resolver.</p> </li> </ul>', ], ], 'ConflictHandlerType' => [ 'base' => NULL, 'refs' => [ 'SyncConfig$conflictHandler' => '<p>The Conflict Resolution strategy to perform in the event of a conflict.</p> <ul> <li> <p> <b>OPTIMISTIC_CONCURRENCY</b>: Resolve conflicts by rejecting mutations when versions don\'t match the latest version at the server.</p> </li> <li> <p> <b>AUTOMERGE</b>: Resolve conflicts with the Automerge conflict resolution strategy.</p> </li> <li> <p> <b>LAMBDA</b>: Resolve conflicts with an Lambda function supplied in the <code>LambdaConflictHandlerConfig</code>.</p> </li> </ul>', ], ], 'Context' => [ 'base' => NULL, 'refs' => [ 'EvaluateCodeRequest$context' => '<p>The map that holds all of the contextual information for your resolver invocation. A <code>context</code> is required for this action.</p>', 'EvaluateMappingTemplateRequest$context' => '<p>The map that holds all of the contextual information for your resolver invocation. A <code>context</code> is required for this action.</p>', ], ], 'CreateApiCacheRequest' => [ 'base' => '<p>Represents the input of a <code>CreateApiCache</code> operation.</p>', 'refs' => [], ], 'CreateApiCacheResponse' => [ 'base' => '<p>Represents the output of a <code>CreateApiCache</code> operation.</p>', 'refs' => [], ], 'CreateApiKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateApiKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainNameResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFunctionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGraphqlApiRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGraphqlApiResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResolverRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResolverResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataSource' => [ 'base' => '<p>Describes a data source.</p>', 'refs' => [ 'CreateDataSourceResponse$dataSource' => '<p>The <code>DataSource</code> object.</p>', 'DataSources$member' => NULL, 'GetDataSourceResponse$dataSource' => '<p>The <code>DataSource</code> object.</p>', 'UpdateDataSourceResponse$dataSource' => '<p>The updated <code>DataSource</code> object.</p>', ], ], 'DataSourceIntrospectionModel' => [ 'base' => '<p>Contains the introspected data that was retrieved from the data source.</p>', 'refs' => [ 'DataSourceIntrospectionModels$member' => NULL, ], ], 'DataSourceIntrospectionModelField' => [ 'base' => '<p>Represents the fields that were retrieved from the introspected data.</p>', 'refs' => [ 'DataSourceIntrospectionModelFields$member' => NULL, ], ], 'DataSourceIntrospectionModelFieldType' => [ 'base' => '<p>Represents the type data for each field retrieved from the introspection.</p>', 'refs' => [ 'DataSourceIntrospectionModelField$type' => '<p>The <code>DataSourceIntrospectionModelFieldType</code> object data.</p>', 'DataSourceIntrospectionModelFieldType$type' => '<p>The <code>DataSourceIntrospectionModelFieldType</code> object data. The <code>type</code> is only present if <code>DataSourceIntrospectionModelFieldType.kind</code> is set to <code>NonNull</code> or <code>List</code>. </p> <p>The <code>type</code> typically contains its own <code>kind</code> and <code>name</code> fields to represent the actual type data. For instance, <code>type</code> could contain a <code>kind</code> value of <code>Scalar</code> with a <code>name</code> value of <code>String</code>. The values <code>Scalar</code> and <code>String</code> will be collectively stored in the <code>values</code> field.</p>', ], ], 'DataSourceIntrospectionModelFieldTypeValues' => [ 'base' => NULL, 'refs' => [ 'DataSourceIntrospectionModelFieldType$values' => '<p>The values of the <code>type</code> field. This field represents the AppSync data type equivalent of the introspected field.</p>', ], ], 'DataSourceIntrospectionModelFields' => [ 'base' => NULL, 'refs' => [ 'DataSourceIntrospectionModel$fields' => '<p>The <code>DataSourceIntrospectionModelField</code> object data.</p>', ], ], 'DataSourceIntrospectionModelIndex' => [ 'base' => '<p>The index that was retrieved from the introspected data.</p>', 'refs' => [ 'DataSourceIntrospectionModel$primaryKey' => '<p>The primary key stored as a <code>DataSourceIntrospectionModelIndex</code> object.</p>', 'DataSourceIntrospectionModelIndexes$member' => NULL, ], ], 'DataSourceIntrospectionModelIndexFields' => [ 'base' => NULL, 'refs' => [ 'DataSourceIntrospectionModelIndex$fields' => '<p>The fields of the index.</p>', ], ], 'DataSourceIntrospectionModelIndexes' => [ 'base' => NULL, 'refs' => [ 'DataSourceIntrospectionModel$indexes' => '<p>The array of <code>DataSourceIntrospectionModelIndex</code> objects.</p>', ], ], 'DataSourceIntrospectionModels' => [ 'base' => NULL, 'refs' => [ 'DataSourceIntrospectionResult$models' => '<p>The array of <code>DataSourceIntrospectionModel</code> objects.</p>', ], ], 'DataSourceIntrospectionResult' => [ 'base' => '<p>Represents the output of a <code>DataSourceIntrospectionResult</code>. This is the populated result of a <code>GetDataSourceIntrospection</code> operation.</p>', 'refs' => [ 'GetDataSourceIntrospectionResponse$introspectionResult' => '<p>The <code>DataSourceIntrospectionResult</code> object data.</p>', ], ], 'DataSourceIntrospectionStatus' => [ 'base' => NULL, 'refs' => [ 'GetDataSourceIntrospectionResponse$introspectionStatus' => '<p>The status of the introspection during retrieval. By default, when a new instrospection is being retrieved, the status will be set to <code>PROCESSING</code>. Once the operation has been completed, the status will change to <code>SUCCESS</code> or <code>FAILED</code> depending on how the data was parsed. A <code>FAILED</code> operation will return an error and its details as an <code>introspectionStatusDetail</code>.</p>', 'StartDataSourceIntrospectionResponse$introspectionStatus' => '<p>The status of the introspection during creation. By default, when a new instrospection has been created, the status will be set to <code>PROCESSING</code>. Once the operation has been completed, the status will change to <code>SUCCESS</code> or <code>FAILED</code> depending on how the data was parsed. A <code>FAILED</code> operation will return an error and its details as an <code>introspectionStatusDetail</code>.</p>', ], ], 'DataSourceLevelMetricsBehavior' => [ 'base' => NULL, 'refs' => [ 'EnhancedMetricsConfig$dataSourceLevelMetricsBehavior' => '<p>Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:</p> <ul> <li> <p>Requests: The number of invocations that occured during a request.</p> </li> <li> <p>Latency: The time to complete a data source invocation.</p> </li> <li> <p>Errors: The number of errors that occurred during a data source invocation.</p> </li> </ul> <p>These metrics can be emitted to CloudWatch per data source or for all data sources in the request. Metrics will be recorded by API ID and data source name. <code>dataSourceLevelMetricsBehavior</code> accepts one of these values at a time:</p> <ul> <li> <p> <code>FULL_REQUEST_DATA_SOURCE_METRICS</code>: Records and emits metric data for all data sources in the request.</p> </li> <li> <p> <code>PER_DATA_SOURCE_METRICS</code>: Records and emits metric data for data sources that have the <code>metricsConfig</code> value set to <code>ENABLED</code>.</p> </li> </ul>', ], ], 'DataSourceLevelMetricsConfig' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$metricsConfig' => '<p>Enables or disables enhanced data source metrics for specified data sources. Note that <code>metricsConfig</code> won\'t be used unless the <code>dataSourceLevelMetricsBehavior</code> value is set to <code>PER_DATA_SOURCE_METRICS</code>. If the <code>dataSourceLevelMetricsBehavior</code> is set to <code>FULL_REQUEST_DATA_SOURCE_METRICS</code> instead, <code>metricsConfig</code> will be ignored. However, you can still set its value.</p> <p> <code>metricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code>.</p>', 'DataSource$metricsConfig' => '<p>Enables or disables enhanced data source metrics for specified data sources. Note that <code>metricsConfig</code> won\'t be used unless the <code>dataSourceLevelMetricsBehavior</code> value is set to <code>PER_DATA_SOURCE_METRICS</code>. If the <code>dataSourceLevelMetricsBehavior</code> is set to <code>FULL_REQUEST_DATA_SOURCE_METRICS</code> instead, <code>metricsConfig</code> will be ignored. However, you can still set its value.</p> <p> <code>metricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code>.</p>', 'UpdateDataSourceRequest$metricsConfig' => '<p>Enables or disables enhanced data source metrics for specified data sources. Note that <code>metricsConfig</code> won\'t be used unless the <code>dataSourceLevelMetricsBehavior</code> value is set to <code>PER_DATA_SOURCE_METRICS</code>. If the <code>dataSourceLevelMetricsBehavior</code> is set to <code>FULL_REQUEST_DATA_SOURCE_METRICS</code> instead, <code>metricsConfig</code> will be ignored. However, you can still set its value.</p> <p> <code>metricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code>.</p>', ], ], 'DataSourceType' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$type' => '<p>The type of the <code>DataSource</code>.</p>', 'DataSource$type' => '<p>The type of the data source.</p> <ul> <li> <p> <b>AWS_LAMBDA</b>: The data source is an Lambda function.</p> </li> <li> <p> <b>AMAZON_DYNAMODB</b>: The data source is an Amazon DynamoDB table.</p> </li> <li> <p> <b>AMAZON_ELASTICSEARCH</b>: The data source is an Amazon OpenSearch Service domain.</p> </li> <li> <p> <b>AMAZON_OPENSEARCH_SERVICE</b>: The data source is an Amazon OpenSearch Service domain.</p> </li> <li> <p> <b>AMAZON_EVENTBRIDGE</b>: The data source is an Amazon EventBridge configuration.</p> </li> <li> <p> <b>NONE</b>: There is no data source. Use this type when you want to invoke a GraphQL operation without connecting to a data source, such as when you\'re performing data transformation with resolvers or invoking a subscription from a mutation.</p> </li> <li> <p> <b>HTTP</b>: The data source is an HTTP endpoint.</p> </li> <li> <p> <b>RELATIONAL_DATABASE</b>: The data source is a relational database.</p> </li> </ul>', 'UpdateDataSourceRequest$type' => '<p>The new data source type.</p>', ], ], 'DataSources' => [ 'base' => NULL, 'refs' => [ 'ListDataSourcesResponse$dataSources' => '<p>The <code>DataSource</code> objects.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'SourceApiAssociation$lastSuccessfulMergeDate' => '<p>The datetime value of the last successful merge of the source API association. The result will be in UTC format and your local time zone.</p>', ], ], 'DefaultAction' => [ 'base' => NULL, 'refs' => [ 'UserPoolConfig$defaultAction' => '<p>The action that you want your GraphQL API to take when a request that uses Amazon Cognito user pool authentication doesn\'t match the Amazon Cognito user pool configuration.</p>', ], ], 'DeleteApiCacheRequest' => [ 'base' => '<p>Represents the input of a <code>DeleteApiCache</code> operation.</p>', 'refs' => [], ], 'DeleteApiCacheResponse' => [ 'base' => '<p>Represents the output of a <code>DeleteApiCache</code> operation.</p>', 'refs' => [], ], 'DeleteApiKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApiKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainNameResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFunctionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGraphqlApiRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGraphqlApiResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResolverRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResolverResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeltaSyncConfig' => [ 'base' => '<p>Describes a Delta Sync configuration.</p>', 'refs' => [ 'DynamodbDataSourceConfig$deltaSyncConfig' => '<p>The <code>DeltaSyncConfig</code> for a versioned data source.</p>', ], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateDomainNameRequest$description' => '<p>A description of the <code>DomainName</code>.</p>', 'DomainNameConfig$description' => '<p>A description of the <code>DomainName</code> configuration.</p>', 'UpdateDomainNameRequest$description' => '<p>A description of the <code>DomainName</code>.</p>', ], ], 'DisassociateApiRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateApiResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMergedGraphqlApiRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMergedGraphqlApiResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSourceGraphqlApiRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSourceGraphqlApiResponse' => [ 'base' => NULL, 'refs' => [], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'ApiAssociation$domainName' => '<p>The domain name.</p>', 'AssociateApiRequest$domainName' => '<p>The domain name.</p>', 'CreateDomainNameRequest$domainName' => '<p>The domain name.</p>', 'DeleteDomainNameRequest$domainName' => '<p>The domain name.</p>', 'DisassociateApiRequest$domainName' => '<p>The domain name.</p>', 'DomainNameConfig$domainName' => '<p>The domain name.</p>', 'GetApiAssociationRequest$domainName' => '<p>The domain name.</p>', 'GetDomainNameRequest$domainName' => '<p>The domain name.</p>', 'UpdateDomainNameRequest$domainName' => '<p>The domain name.</p>', ], ], 'DomainNameConfig' => [ 'base' => '<p>Describes a configuration for a custom domain.</p>', 'refs' => [ 'CreateDomainNameResponse$domainNameConfig' => '<p>The configuration for the <code>DomainName</code>.</p>', 'DomainNameConfigs$member' => NULL, 'GetDomainNameResponse$domainNameConfig' => '<p>The configuration for the <code>DomainName</code>.</p>', 'UpdateDomainNameResponse$domainNameConfig' => '<p>The configuration for the <code>DomainName</code>.</p>', ], ], 'DomainNameConfigs' => [ 'base' => NULL, 'refs' => [ 'ListDomainNamesResponse$domainNameConfigs' => '<p>Lists configurations for multiple domain names.</p>', ], ], 'DynamodbDataSourceConfig' => [ 'base' => '<p>Describes an Amazon DynamoDB data source configuration.</p>', 'refs' => [ 'CreateDataSourceRequest$dynamodbConfig' => '<p>Amazon DynamoDB settings.</p>', 'DataSource$dynamodbConfig' => '<p>DynamoDB settings.</p>', 'UpdateDataSourceRequest$dynamodbConfig' => '<p>The new Amazon DynamoDB configuration.</p>', ], ], 'ElasticsearchDataSourceConfig' => [ 'base' => '<p>Describes an OpenSearch data source configuration.</p> <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. For new data sources, use <a>OpenSearchServiceDataSourceConfig</a> to specify an OpenSearch data source.</p>', 'refs' => [ 'CreateDataSourceRequest$elasticsearchConfig' => '<p>Amazon OpenSearch Service settings.</p> <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. For new data sources, use <a>CreateDataSourceRequest$openSearchServiceConfig</a> to create an OpenSearch data source.</p>', 'DataSource$elasticsearchConfig' => '<p>Amazon OpenSearch Service settings.</p>', 'UpdateDataSourceRequest$elasticsearchConfig' => '<p>The new OpenSearch configuration.</p> <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. Instead, use <a>UpdateDataSourceRequest$openSearchServiceConfig</a> to update an OpenSearch data source.</p>', ], ], 'EnhancedMetricsConfig' => [ 'base' => '<p>Enables and controls the enhanced metrics feature. Enhanced metrics emit granular data on API usage and performance such as AppSync request and error counts, latency, and cache hits/misses. All enhanced metric data is sent to your CloudWatch account, and you can configure the types of data that will be sent. </p> <p>Enhanced metrics can be configured at the resolver, data source, and operation levels. <code>EnhancedMetricsConfig</code> contains three required parameters, each controlling one of these categories:</p> <ol> <li> <p> <code>resolverLevelMetricsBehavior</code>: Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:</p> <ul> <li> <p>GraphQL errors: The number of GraphQL errors that occurred.</p> </li> <li> <p>Requests: The number of invocations that occurred during a request. </p> </li> <li> <p>Latency: The time to complete a resolver invocation.</p> </li> <li> <p>Cache hits: The number of cache hits during a request.</p> </li> <li> <p>Cache misses: The number of cache misses during a request.</p> </li> </ul> <p>These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics will be recorded by API ID and resolver name. <code>resolverLevelMetricsBehavior</code> accepts one of these values at a time:</p> <ul> <li> <p> <code>FULL_REQUEST_RESOLVER_METRICS</code>: Records and emits metric data for all resolvers in the request.</p> </li> <li> <p> <code>PER_RESOLVER_METRICS</code>: Records and emits metric data for resolvers that have the <code>metricsConfig</code> value set to <code>ENABLED</code>.</p> </li> </ul> </li> <li> <p> <code>dataSourceLevelMetricsBehavior</code>: Controls how data source metrics will be emitted to CloudWatch. Data source metrics include:</p> <ul> <li> <p>Requests: The number of invocations that occured during a request.</p> </li> <li> <p>Latency: The time to complete a data source invocation.</p> </li> <li> <p>Errors: The number of errors that occurred during a data source invocation.</p> </li> </ul> <p>These metrics can be emitted to CloudWatch per data source or for all data sources in the request. Metrics will be recorded by API ID and data source name. <code>dataSourceLevelMetricsBehavior</code> accepts one of these values at a time:</p> <ul> <li> <p> <code>FULL_REQUEST_DATA_SOURCE_METRICS</code>: Records and emits metric data for all data sources in the request.</p> </li> <li> <p> <code>PER_DATA_SOURCE_METRICS</code>: Records and emits metric data for data sources that have the <code>metricsConfig</code> value set to <code>ENABLED</code>.</p> </li> </ul> </li> <li> <p> <code>operationLevelMetricsConfig</code>: Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:</p> <ul> <li> <p>Requests: The number of times a specified GraphQL operation was called.</p> </li> <li> <p>GraphQL errors: The number of GraphQL errors that occurred during a specified GraphQL operation.</p> </li> </ul> <p>Metrics will be recorded by API ID and operation name. You can set the value to <code>ENABLED</code> or <code>DISABLED</code>.</p> </li> </ol>', 'refs' => [ 'CreateGraphqlApiRequest$enhancedMetricsConfig' => '<p>The <code>enhancedMetricsConfig</code> object.</p>', 'GraphqlApi$enhancedMetricsConfig' => '<p>The <code>enhancedMetricsConfig</code> object.</p>', 'UpdateGraphqlApiRequest$enhancedMetricsConfig' => '<p>The <code>enhancedMetricsConfig</code> object.</p>', ], ], 'EnvironmentVariableKey' => [ 'base' => NULL, 'refs' => [ 'EnvironmentVariableMap$key' => NULL, ], ], 'EnvironmentVariableMap' => [ 'base' => NULL, 'refs' => [ 'GetGraphqlApiEnvironmentVariablesResponse$environmentVariables' => '<p>The payload containing each environmental variable in the <code>"key" : "value"</code> format.</p>', 'PutGraphqlApiEnvironmentVariablesRequest$environmentVariables' => '<p>The list of environmental variables to add to the API.</p> <p>When creating an environmental variable key-value pair, it must follow the additional constraints below:</p> <ul> <li> <p>Keys must begin with a letter.</p> </li> <li> <p>Keys must be at least two characters long.</p> </li> <li> <p>Keys can only contain letters, numbers, and the underscore character (_).</p> </li> <li> <p>Values can be up to 512 characters long.</p> </li> <li> <p>You can configure up to 50 key-value pairs in a GraphQL API.</p> </li> </ul> <p>You can create a list of environmental variables by adding it to the <code>environmentVariables</code> payload as a list in the format <code>{"key1":"value1","key2":"value2", …}</code>. Note that each call of the <code>PutGraphqlApiEnvironmentVariables</code> action will result in the overwriting of the existing environmental variable list of that API. This means the existing environmental variables will be lost. To avoid this, you must include all existing and new environmental variables in the list each time you call this action.</p>', 'PutGraphqlApiEnvironmentVariablesResponse$environmentVariables' => '<p>The payload containing each environmental variable in the <code>"key" : "value"</code> format.</p>', ], ], 'EnvironmentVariableValue' => [ 'base' => NULL, 'refs' => [ 'EnvironmentVariableMap$value' => NULL, ], ], 'ErrorDetail' => [ 'base' => '<p>Contains the list of errors generated. When using JavaScript, this will apply to the request or response function evaluation.</p>', 'refs' => [ 'EvaluateMappingTemplateResponse$error' => '<p>The <code>ErrorDetail</code> object.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$message' => NULL, 'ConcurrentModificationException$message' => NULL, 'ErrorDetail$message' => '<p>The error payload.</p>', 'EvaluateCodeErrorDetail$message' => '<p>The error payload.</p>', 'GraphQLSchemaException$message' => NULL, ], ], 'EvaluateCodeErrorDetail' => [ 'base' => '<p>Contains the list of errors from a code evaluation response.</p>', 'refs' => [ 'EvaluateCodeResponse$error' => '<p>Contains the payload of the response error.</p>', ], ], 'EvaluateCodeRequest' => [ 'base' => NULL, 'refs' => [], ], 'EvaluateCodeResponse' => [ 'base' => NULL, 'refs' => [], ], 'EvaluateMappingTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'EvaluateMappingTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'EvaluationResult' => [ 'base' => NULL, 'refs' => [ 'EvaluateCodeResponse$evaluationResult' => '<p>The result of the evaluation operation.</p>', 'EvaluateMappingTemplateResponse$evaluationResult' => '<p>The mapping template; this can be a request or response template.</p>', ], ], 'EventBridgeDataSourceConfig' => [ 'base' => '<p>Describes an Amazon EventBridge bus data source configuration.</p>', 'refs' => [ 'CreateDataSourceRequest$eventBridgeConfig' => '<p>Amazon EventBridge settings.</p>', 'DataSource$eventBridgeConfig' => '<p>Amazon EventBridge settings.</p>', 'UpdateDataSourceRequest$eventBridgeConfig' => '<p>The new Amazon EventBridge settings.</p>', ], ], 'FieldLogLevel' => [ 'base' => NULL, 'refs' => [ 'LogConfig$fieldLogLevel' => '<p>The field logging level. Values can be NONE, ERROR, or ALL.</p> <ul> <li> <p> <b>NONE</b>: No field-level logs are captured.</p> </li> <li> <p> <b>ERROR</b>: Logs the following information only for the fields that are in error:</p> <ul> <li> <p>The error section in the server response.</p> </li> <li> <p>Field-level errors.</p> </li> <li> <p>The generated request/response functions that got resolved for error fields.</p> </li> </ul> </li> <li> <p> <b>ALL</b>: The following information is logged for all fields in the query:</p> <ul> <li> <p>Field-level tracing information.</p> </li> <li> <p>The generated request/response functions that got resolved for each field.</p> </li> </ul> </li> </ul>', ], ], 'FlushApiCacheRequest' => [ 'base' => '<p>Represents the input of a <code>FlushApiCache</code> operation.</p>', 'refs' => [], ], 'FlushApiCacheResponse' => [ 'base' => '<p>Represents the output of a <code>FlushApiCache</code> operation.</p>', 'refs' => [], ], 'FunctionConfiguration' => [ 'base' => '<p>A function is a reusable entity. You can use multiple functions to compose the resolver logic.</p>', 'refs' => [ 'CreateFunctionResponse$functionConfiguration' => '<p>The <code>Function</code> object.</p>', 'Functions$member' => NULL, 'GetFunctionResponse$functionConfiguration' => '<p>The <code>Function</code> object.</p>', 'UpdateFunctionResponse$functionConfiguration' => '<p>The <code>Function</code> object.</p>', ], ], 'Functions' => [ 'base' => NULL, 'refs' => [ 'ListFunctionsResponse$functions' => '<p>A list of <code>Function</code> objects.</p>', ], ], 'FunctionsIds' => [ 'base' => NULL, 'refs' => [ 'PipelineConfig$functions' => '<p>A list of <code>Function</code> objects.</p>', ], ], 'GetApiAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetApiAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetApiCacheRequest' => [ 'base' => '<p>Represents the input of a <code>GetApiCache</code> operation.</p>', 'refs' => [], ], 'GetApiCacheResponse' => [ 'base' => '<p>Represents the output of a <code>GetApiCache</code> operation.</p>', 'refs' => [], ], 'GetDataSourceIntrospectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSourceIntrospectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDomainNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDomainNameResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFunctionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetGraphqlApiEnvironmentVariablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGraphqlApiEnvironmentVariablesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetGraphqlApiRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGraphqlApiResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIntrospectionSchemaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIntrospectionSchemaResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResolverResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSchemaCreationStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSchemaCreationStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSourceApiAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSourceApiAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'GraphQLApiIntrospectionConfig' => [ 'base' => NULL, 'refs' => [ 'CreateGraphqlApiRequest$introspectionConfig' => '<p>Sets the value of the GraphQL API to enable (<code>ENABLED</code>) or disable (<code>DISABLED</code>) introspection. If no value is provided, the introspection configuration will be set to <code>ENABLED</code> by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled.</p> <p>For more information about introspection, see <a href="https://graphql.org/learn/introspection/">GraphQL introspection</a>.</p>', 'GraphqlApi$introspectionConfig' => '<p>Sets the value of the GraphQL API to enable (<code>ENABLED</code>) or disable (<code>DISABLED</code>) introspection. If no value is provided, the introspection configuration will be set to <code>ENABLED</code> by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled.</p> <p>For more information about introspection, see <a href="https://graphql.org/learn/introspection/">GraphQL introspection</a>.</p>', 'UpdateGraphqlApiRequest$introspectionConfig' => '<p>Sets the value of the GraphQL API to enable (<code>ENABLED</code>) or disable (<code>DISABLED</code>) introspection. If no value is provided, the introspection configuration will be set to <code>ENABLED</code> by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled.</p> <p>For more information about introspection, see <a href="https://graphql.org/learn/introspection/">GraphQL introspection</a>.</p>', ], ], 'GraphQLApiType' => [ 'base' => NULL, 'refs' => [ 'CreateGraphqlApiRequest$apiType' => '<p>The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged API (<code>MERGED</code>).</p>', 'GraphqlApi$apiType' => '<p>The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged API (<code>MERGED</code>).</p>', 'ListGraphqlApisRequest$apiType' => '<p>The value that indicates whether the GraphQL API is a standard API (<code>GRAPHQL</code>) or merged API (<code>MERGED</code>).</p>', ], ], 'GraphQLApiVisibility' => [ 'base' => NULL, 'refs' => [ 'CreateGraphqlApiRequest$visibility' => '<p>Sets the value of the GraphQL API to public (<code>GLOBAL</code>) or private (<code>PRIVATE</code>). If no value is provided, the visibility will be set to <code>GLOBAL</code> by default. This value cannot be changed once the API has been created.</p>', 'GraphqlApi$visibility' => '<p>Sets the value of the GraphQL API to public (<code>GLOBAL</code>) or private (<code>PRIVATE</code>). If no value is provided, the visibility will be set to <code>GLOBAL</code> by default. This value cannot be changed once the API has been created.</p>', ], ], 'GraphQLSchemaException' => [ 'base' => '<p>The GraphQL schema is not valid.</p>', 'refs' => [], ], 'GraphqlApi' => [ 'base' => '<p>Describes a GraphQL API.</p>', 'refs' => [ 'CreateGraphqlApiResponse$graphqlApi' => '<p>The <code>GraphqlApi</code>.</p>', 'GetGraphqlApiResponse$graphqlApi' => '<p>The <code>GraphqlApi</code> object.</p>', 'GraphqlApis$member' => NULL, 'UpdateGraphqlApiResponse$graphqlApi' => '<p>The updated <code>GraphqlApi</code> object.</p>', ], ], 'GraphqlApis' => [ 'base' => NULL, 'refs' => [ 'ListGraphqlApisResponse$graphqlApis' => '<p>The <code>GraphqlApi</code> objects.</p>', ], ], 'HttpDataSourceConfig' => [ 'base' => '<p>Describes an HTTP data source configuration.</p>', 'refs' => [ 'CreateDataSourceRequest$httpConfig' => '<p>HTTP endpoint settings.</p>', 'DataSource$httpConfig' => '<p>HTTP endpoint settings.</p>', 'UpdateDataSourceRequest$httpConfig' => '<p>The new HTTP endpoint configuration.</p>', ], ], 'InternalFailureException' => [ 'base' => '<p>An internal AppSync error occurred. Try your request again.</p>', 'refs' => [], ], 'LambdaAuthorizerConfig' => [ 'base' => '<p>A <code>LambdaAuthorizerConfig</code> specifies how to authorize AppSync API access when using the <code>AWS_LAMBDA</code> authorizer mode. Be aware that an AppSync API can have only one Lambda authorizer configured at a time.</p>', 'refs' => [ 'AdditionalAuthenticationProvider$lambdaAuthorizerConfig' => '<p>Configuration for Lambda function authorization.</p>', 'CreateGraphqlApiRequest$lambdaAuthorizerConfig' => '<p>Configuration for Lambda function authorization.</p>', 'GraphqlApi$lambdaAuthorizerConfig' => '<p>Configuration for Lambda function authorization.</p>', 'UpdateGraphqlApiRequest$lambdaAuthorizerConfig' => '<p>Configuration for Lambda function authorization.</p>', ], ], 'LambdaConflictHandlerConfig' => [ 'base' => '<p>The <code>LambdaConflictHandlerConfig</code> object when configuring <code>LAMBDA</code> as the Conflict Handler.</p>', 'refs' => [ 'SyncConfig$lambdaConflictHandlerConfig' => '<p>The <code>LambdaConflictHandlerConfig</code> when configuring <code>LAMBDA</code> as the Conflict Handler.</p>', ], ], 'LambdaDataSourceConfig' => [ 'base' => '<p>Describes an Lambda data source configuration.</p>', 'refs' => [ 'CreateDataSourceRequest$lambdaConfig' => '<p>Lambda settings.</p>', 'DataSource$lambdaConfig' => '<p>Lambda settings.</p>', 'UpdateDataSourceRequest$lambdaConfig' => '<p>The new Lambda configuration.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request exceeded a limit. Try your request again.</p>', 'refs' => [], ], 'ListApiKeysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApiKeysResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainNamesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainNamesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFunctionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFunctionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGraphqlApisRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGraphqlApisResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResolversByFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResolversByFunctionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResolversRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResolversResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSourceApiAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSourceApiAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTypesByAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTypesByAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogConfig' => [ 'base' => '<p>The Amazon CloudWatch Logs configuration.</p>', 'refs' => [ 'CreateGraphqlApiRequest$logConfig' => '<p>The Amazon CloudWatch Logs configuration.</p>', 'GraphqlApi$logConfig' => '<p>The Amazon CloudWatch Logs configuration.</p>', 'UpdateGraphqlApiRequest$logConfig' => '<p>The Amazon CloudWatch Logs configuration for the <code>GraphqlApi</code> object.</p>', ], ], 'Logs' => [ 'base' => NULL, 'refs' => [ 'EvaluateCodeResponse$logs' => '<p>A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code> in the evaluated code.</p>', 'EvaluateMappingTemplateResponse$logs' => '<p>A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code> in the evaluated code.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'ApiCache$ttl' => '<p>TTL in seconds for cache entries.</p> <p>Valid values are 1–3,600 seconds.</p>', 'ApiKey$expires' => '<p>The time after which the API key expires. The date is represented as seconds since the epoch, rounded down to the nearest hour.</p>', 'ApiKey$deletes' => '<p>The time after which the API key is deleted. The date is represented as seconds since the epoch, rounded down to the nearest hour.</p>', 'CachingConfig$ttl' => '<p>The TTL in seconds for a resolver that has caching activated.</p> <p>Valid values are 1–3,600 seconds.</p>', 'CreateApiCacheRequest$ttl' => '<p>TTL in seconds for cache entries.</p> <p>Valid values are 1–3,600 seconds.</p>', 'CreateApiKeyRequest$expires' => '<p>From the creation time, the time after which the API key expires. The date is represented as seconds since the epoch, rounded down to the nearest hour. The default value for this parameter is 7 days from creation time. For more information, see .</p>', 'DataSourceIntrospectionModelField$length' => '<p>The length value of the introspected field.</p>', 'DeltaSyncConfig$baseTableTTL' => '<p>The number of minutes that an Item is stored in the data source.</p>', 'DeltaSyncConfig$deltaSyncTableTTL' => '<p>The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.</p>', 'OpenIDConnectConfig$iatTTL' => '<p>The number of milliseconds that a token is valid after it\'s issued to a user.</p>', 'OpenIDConnectConfig$authTTL' => '<p>The number of milliseconds that a token is valid after being authenticated.</p>', 'UpdateApiCacheRequest$ttl' => '<p>TTL in seconds for cache entries.</p> <p>Valid values are 1–3,600 seconds.</p>', 'UpdateApiKeyRequest$expires' => '<p>From the update time, the time after which the API key expires. The date is represented as seconds since the epoch. For more information, see .</p>', ], ], 'MapOfStringToString' => [ 'base' => NULL, 'refs' => [ 'GraphqlApi$uris' => '<p>The URIs.</p>', 'GraphqlApi$dns' => '<p>The DNS records for the API.</p>', ], ], 'MappingTemplate' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$requestMappingTemplate' => '<p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>', 'CreateFunctionRequest$responseMappingTemplate' => '<p>The <code>Function</code> response mapping template.</p>', 'CreateResolverRequest$requestMappingTemplate' => '<p>The mapping template to use for requests.</p> <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p> <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>', 'CreateResolverRequest$responseMappingTemplate' => '<p>The mapping template to use for responses from the data source.</p>', 'FunctionConfiguration$requestMappingTemplate' => '<p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>', 'FunctionConfiguration$responseMappingTemplate' => '<p>The <code>Function</code> response mapping template.</p>', 'Resolver$requestMappingTemplate' => '<p>The request mapping template.</p>', 'Resolver$responseMappingTemplate' => '<p>The response mapping template.</p>', 'UpdateFunctionRequest$requestMappingTemplate' => '<p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>', 'UpdateFunctionRequest$responseMappingTemplate' => '<p>The <code>Function</code> request mapping template.</p>', 'UpdateResolverRequest$requestMappingTemplate' => '<p>The new request mapping template.</p> <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p> <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>', 'UpdateResolverRequest$responseMappingTemplate' => '<p>The new response mapping template.</p>', ], ], 'MaxBatchSize' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$maxBatchSize' => '<p>The maximum batching size for a resolver.</p>', 'CreateResolverRequest$maxBatchSize' => '<p>The maximum batching size for a resolver.</p>', 'FunctionConfiguration$maxBatchSize' => '<p>The maximum batching size for a resolver.</p>', 'Resolver$maxBatchSize' => '<p>The maximum batching size for a resolver.</p>', 'UpdateFunctionRequest$maxBatchSize' => '<p>The maximum batching size for a resolver.</p>', 'UpdateResolverRequest$maxBatchSize' => '<p>The maximum batching size for a resolver.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetDataSourceIntrospectionRequest$maxResults' => '<p>The maximum number of introspected types that will be returned in a single response.</p>', 'ListApiKeysRequest$maxResults' => '<p>The maximum number of results that you want the request to return.</p>', 'ListDataSourcesRequest$maxResults' => '<p>The maximum number of results that you want the request to return.</p>', 'ListDomainNamesRequest$maxResults' => '<p>The maximum number of results that you want the request to return.</p>', 'ListFunctionsRequest$maxResults' => '<p>The maximum number of results that you want the request to return.</p>', 'ListGraphqlApisRequest$maxResults' => '<p>The maximum number of results that you want the request to return.</p>', 'ListResolversByFunctionRequest$maxResults' => '<p>The maximum number of results that you want the request to return.</p>', 'ListResolversRequest$maxResults' => '<p>The maximum number of results that you want the request to return.</p>', 'ListSourceApiAssociationsRequest$maxResults' => '<p>The maximum number of results that you want the request to return.</p>', 'ListTypesByAssociationRequest$maxResults' => '<p>The maximum number of results that you want the request to return.</p>', 'ListTypesRequest$maxResults' => '<p>The maximum number of results that you want the request to return.</p>', ], ], 'MergeType' => [ 'base' => NULL, 'refs' => [ 'SourceApiAssociationConfig$mergeType' => '<p>The property that indicates which merging option is enabled in the source API association.</p> <p>Valid merge types are <code>MANUAL_MERGE</code> (default) and <code>AUTO_MERGE</code>. Manual merges are the default behavior and require the user to trigger any changes from the source APIs to the merged API manually. Auto merges subscribe the merged API to the changes performed on the source APIs so that any change in the source APIs are also made to the merged API. Auto merges use <code>MergedApiExecutionRoleArn</code> to perform merge operations.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>The resource specified in the request was not found. Check the resource, and then try again.</p>', 'refs' => [], ], 'OpenIDConnectConfig' => [ 'base' => '<p>Describes an OpenID Connect (OIDC) configuration.</p>', 'refs' => [ 'AdditionalAuthenticationProvider$openIDConnectConfig' => '<p>The OIDC configuration.</p>', 'CreateGraphqlApiRequest$openIDConnectConfig' => '<p>The OIDC configuration.</p>', 'GraphqlApi$openIDConnectConfig' => '<p>The OpenID Connect configuration.</p>', 'UpdateGraphqlApiRequest$openIDConnectConfig' => '<p>The OpenID Connect configuration for the <code>GraphqlApi</code> object.</p>', ], ], 'OpenSearchServiceDataSourceConfig' => [ 'base' => '<p>Describes an OpenSearch data source configuration.</p>', 'refs' => [ 'CreateDataSourceRequest$openSearchServiceConfig' => '<p>Amazon OpenSearch Service settings.</p>', 'DataSource$openSearchServiceConfig' => '<p>Amazon OpenSearch Service settings.</p>', 'UpdateDataSourceRequest$openSearchServiceConfig' => '<p>The new OpenSearch configuration.</p>', ], ], 'OperationLevelMetricsConfig' => [ 'base' => NULL, 'refs' => [ 'EnhancedMetricsConfig$operationLevelMetricsConfig' => '<p> Controls how operation metrics will be emitted to CloudWatch. Operation metrics include:</p> <ul> <li> <p>Requests: The number of times a specified GraphQL operation was called.</p> </li> <li> <p>GraphQL errors: The number of GraphQL errors that occurred during a specified GraphQL operation.</p> </li> </ul> <p>Metrics will be recorded by API ID and operation name. You can set the value to <code>ENABLED</code> or <code>DISABLED</code>.</p>', ], ], 'OutputType' => [ 'base' => NULL, 'refs' => [ 'GetIntrospectionSchemaRequest$format' => '<p>The schema format: SDL or JSON.</p>', ], ], 'Ownership' => [ 'base' => NULL, 'refs' => [ 'ListGraphqlApisRequest$owner' => '<p>The account owner of the GraphQL API.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'DataSourceIntrospectionResult$nextToken' => '<p>Determines the number of types to be returned in a single response before paginating. This value is typically taken from <code>nextToken</code> value from the previous response.</p>', 'GetDataSourceIntrospectionRequest$nextToken' => '<p>Determines the number of types to be returned in a single response before paginating. This value is typically taken from <code>nextToken</code> value from the previous response.</p>', 'ListApiKeysRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>', 'ListApiKeysResponse$nextToken' => '<p>An identifier to pass in the next request to this operation to return the next set of items in the list.</p>', 'ListDataSourcesRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>', 'ListDataSourcesResponse$nextToken' => '<p>An identifier to pass in the next request to this operation to return the next set of items in the list.</p>', 'ListDomainNamesRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>', 'ListDomainNamesResponse$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>', 'ListFunctionsRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>', 'ListFunctionsResponse$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>', 'ListGraphqlApisRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>', 'ListGraphqlApisResponse$nextToken' => '<p>An identifier to pass in the next request to this operation to return the next set of items in the list.</p>', 'ListResolversByFunctionRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>', 'ListResolversByFunctionResponse$nextToken' => '<p>An identifier that you can use to return the next set of items in the list.</p>', 'ListResolversRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>', 'ListResolversResponse$nextToken' => '<p>An identifier to pass in the next request to this operation to return the next set of items in the list.</p>', 'ListSourceApiAssociationsRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>', 'ListSourceApiAssociationsResponse$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>', 'ListTypesByAssociationRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>', 'ListTypesByAssociationResponse$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>', 'ListTypesRequest$nextToken' => '<p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>', 'ListTypesResponse$nextToken' => '<p>An identifier to pass in the next request to this operation to return the next set of items in the list.</p>', ], ], 'PipelineConfig' => [ 'base' => '<p>The pipeline configuration for a resolver of kind <code>PIPELINE</code>.</p>', 'refs' => [ 'CreateResolverRequest$pipelineConfig' => '<p>The <code>PipelineConfig</code>.</p>', 'Resolver$pipelineConfig' => '<p>The <code>PipelineConfig</code>.</p>', 'UpdateResolverRequest$pipelineConfig' => '<p>The <code>PipelineConfig</code>.</p>', ], ], 'PutGraphqlApiEnvironmentVariablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutGraphqlApiEnvironmentVariablesResponse' => [ 'base' => NULL, 'refs' => [], ], 'QueryDepthLimit' => [ 'base' => NULL, 'refs' => [ 'CreateGraphqlApiRequest$queryDepthLimit' => '<p>The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is <code>0</code> (or unspecified), which indicates there\'s no depth limit. If you set a limit, it can be between <code>1</code> and <code>75</code> nested levels. This field will produce a limit error if the operation falls out of bounds.</p> <p>Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.</p>', 'GraphqlApi$queryDepthLimit' => '<p>The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is <code>0</code> (or unspecified), which indicates there\'s no depth limit. If you set a limit, it can be between <code>1</code> and <code>75</code> nested levels. This field will produce a limit error if the operation falls out of bounds.</p> <p>Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.</p>', 'UpdateGraphqlApiRequest$queryDepthLimit' => '<p>The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is <code>0</code> (or unspecified), which indicates there\'s no depth limit. If you set a limit, it can be between <code>1</code> and <code>75</code> nested levels. This field will produce a limit error if the operation falls out of bounds.</p> <p>Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.</p>', ], ], 'RdsDataApiConfig' => [ 'base' => '<p>Contains the metadata required to introspect the RDS cluster.</p>', 'refs' => [ 'StartDataSourceIntrospectionRequest$rdsDataApiConfig' => '<p>The <code>rdsDataApiConfig</code> object data.</p>', ], ], 'RdsDataApiConfigDatabaseName' => [ 'base' => NULL, 'refs' => [ 'RdsDataApiConfig$databaseName' => '<p>The name of the database in the cluster.</p>', ], ], 'RdsDataApiConfigResourceArn' => [ 'base' => NULL, 'refs' => [ 'RdsDataApiConfig$resourceArn' => '<p>The resource ARN of the RDS cluster.</p>', ], ], 'RdsDataApiConfigSecretArn' => [ 'base' => NULL, 'refs' => [ 'RdsDataApiConfig$secretArn' => '<p>The secret\'s ARN that was obtained from Secrets Manager. A secret consists of secret information, the secret value, plus metadata about the secret. A secret value can be a string or binary. It typically includes the ARN, secret name and description, policies, tags, encryption key from the Key Management Service, and key rotation data.</p>', ], ], 'RdsHttpEndpointConfig' => [ 'base' => '<p>The Amazon Relational Database Service (Amazon RDS) HTTP endpoint configuration.</p>', 'refs' => [ 'RelationalDatabaseDataSourceConfig$rdsHttpEndpointConfig' => '<p>Amazon RDS HTTP endpoint settings.</p>', ], ], 'RelationalDatabaseDataSourceConfig' => [ 'base' => '<p>Describes a relational database data source configuration.</p>', 'refs' => [ 'CreateDataSourceRequest$relationalDatabaseConfig' => '<p>Relational database settings.</p>', 'DataSource$relationalDatabaseConfig' => '<p>Relational database settings.</p>', 'UpdateDataSourceRequest$relationalDatabaseConfig' => '<p>The new relational database configuration.</p>', ], ], 'RelationalDatabaseSourceType' => [ 'base' => NULL, 'refs' => [ 'RelationalDatabaseDataSourceConfig$relationalDatabaseSourceType' => '<p>Source type for the relational database.</p> <ul> <li> <p> <b>RDS_HTTP_ENDPOINT</b>: The relational database source type is an Amazon Relational Database Service (Amazon RDS) HTTP endpoint.</p> </li> </ul>', ], ], 'Resolver' => [ 'base' => '<p>Describes a resolver.</p>', 'refs' => [ 'CreateResolverResponse$resolver' => '<p>The <code>Resolver</code> object.</p>', 'GetResolverResponse$resolver' => '<p>The <code>Resolver</code> object.</p>', 'Resolvers$member' => NULL, 'UpdateResolverResponse$resolver' => '<p>The updated <code>Resolver</code> object.</p>', ], ], 'ResolverCountLimit' => [ 'base' => NULL, 'refs' => [ 'CreateGraphqlApiRequest$resolverCountLimit' => '<p>The maximum number of resolvers that can be invoked in a single request. The default value is <code>0</code> (or unspecified), which will set the limit to <code>10000</code>. When specified, the limit value can be between <code>1</code> and <code>10000</code>. This field will produce a limit error if the operation falls out of bounds.</p>', 'GraphqlApi$resolverCountLimit' => '<p>The maximum number of resolvers that can be invoked in a single request. The default value is <code>0</code> (or unspecified), which will set the limit to <code>10000</code>. When specified, the limit value can be between <code>1</code> and <code>10000</code>. This field will produce a limit error if the operation falls out of bounds.</p>', 'UpdateGraphqlApiRequest$resolverCountLimit' => '<p>The maximum number of resolvers that can be invoked in a single request. The default value is <code>0</code> (or unspecified), which will set the limit to <code>10000</code>. When specified, the limit value can be between <code>1</code> and <code>10000</code>. This field will produce a limit error if the operation falls out of bounds.</p>', ], ], 'ResolverKind' => [ 'base' => NULL, 'refs' => [ 'CreateResolverRequest$kind' => '<p>The resolver type.</p> <ul> <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li> <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li> </ul>', 'Resolver$kind' => '<p>The resolver type.</p> <ul> <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li> <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li> </ul>', 'UpdateResolverRequest$kind' => '<p>The resolver type.</p> <ul> <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li> <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li> </ul>', ], ], 'ResolverLevelMetricsBehavior' => [ 'base' => NULL, 'refs' => [ 'EnhancedMetricsConfig$resolverLevelMetricsBehavior' => '<p>Controls how resolver metrics will be emitted to CloudWatch. Resolver metrics include:</p> <ul> <li> <p>GraphQL errors: The number of GraphQL errors that occurred.</p> </li> <li> <p>Requests: The number of invocations that occurred during a request. </p> </li> <li> <p>Latency: The time to complete a resolver invocation.</p> </li> <li> <p>Cache hits: The number of cache hits during a request.</p> </li> <li> <p>Cache misses: The number of cache misses during a request.</p> </li> </ul> <p>These metrics can be emitted to CloudWatch per resolver or for all resolvers in the request. Metrics will be recorded by API ID and resolver name. <code>resolverLevelMetricsBehavior</code> accepts one of these values at a time:</p> <ul> <li> <p> <code>FULL_REQUEST_RESOLVER_METRICS</code>: Records and emits metric data for all resolvers in the request.</p> </li> <li> <p> <code>PER_RESOLVER_METRICS</code>: Records and emits metric data for resolvers that have the <code>metricsConfig</code> value set to <code>ENABLED</code>.</p> </li> </ul>', ], ], 'ResolverLevelMetricsConfig' => [ 'base' => NULL, 'refs' => [ 'CreateResolverRequest$metricsConfig' => '<p>Enables or disables enhanced resolver metrics for specified resolvers. Note that <code>metricsConfig</code> won\'t be used unless the <code>resolverLevelMetricsBehavior</code> value is set to <code>PER_RESOLVER_METRICS</code>. If the <code>resolverLevelMetricsBehavior</code> is set to <code>FULL_REQUEST_RESOLVER_METRICS</code> instead, <code>metricsConfig</code> will be ignored. However, you can still set its value.</p> <p> <code>metricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code>.</p>', 'Resolver$metricsConfig' => '<p>Enables or disables enhanced resolver metrics for specified resolvers. Note that <code>metricsConfig</code> won\'t be used unless the <code>resolverLevelMetricsBehavior</code> value is set to <code>PER_RESOLVER_METRICS</code>. If the <code>resolverLevelMetricsBehavior</code> is set to <code>FULL_REQUEST_RESOLVER_METRICS</code> instead, <code>metricsConfig</code> will be ignored. However, you can still set its value.</p> <p> <code>metricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code>.</p>', 'UpdateResolverRequest$metricsConfig' => '<p>Enables or disables enhanced resolver metrics for specified resolvers. Note that <code>metricsConfig</code> won\'t be used unless the <code>resolverLevelMetricsBehavior</code> value is set to <code>PER_RESOLVER_METRICS</code>. If the <code>resolverLevelMetricsBehavior</code> is set to <code>FULL_REQUEST_RESOLVER_METRICS</code> instead, <code>metricsConfig</code> will be ignored. However, you can still set its value.</p> <p> <code>metricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code>.</p>', ], ], 'Resolvers' => [ 'base' => NULL, 'refs' => [ 'ListResolversByFunctionResponse$resolvers' => '<p>The list of resolvers.</p>', 'ListResolversResponse$resolvers' => '<p>The <code>Resolver</code> objects.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>', 'TagResourceRequest$resourceArn' => '<p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>', 'UntagResourceRequest$resourceArn' => '<p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$name' => '<p>A user-supplied name for the <code>DataSource</code>.</p>', 'CreateFunctionRequest$name' => '<p>The <code>Function</code> name. The function name does not have to be unique.</p>', 'CreateFunctionRequest$dataSourceName' => '<p>The <code>Function</code> <code>DataSource</code> name.</p>', 'CreateResolverRequest$typeName' => '<p>The name of the <code>Type</code>.</p>', 'CreateResolverRequest$fieldName' => '<p>The name of the field to attach the resolver to.</p>', 'CreateResolverRequest$dataSourceName' => '<p>The name of the data source for which the resolver is being created.</p>', 'DataSource$name' => '<p>The name of the data source.</p>', 'DeleteDataSourceRequest$name' => '<p>The name of the data source.</p>', 'DeleteFunctionRequest$functionId' => '<p>The <code>Function</code> ID.</p>', 'DeleteResolverRequest$typeName' => '<p>The name of the resolver type.</p>', 'DeleteResolverRequest$fieldName' => '<p>The resolver field name.</p>', 'DeleteTypeRequest$typeName' => '<p>The type name.</p>', 'FunctionConfiguration$name' => '<p>The name of the <code>Function</code> object.</p>', 'FunctionConfiguration$dataSourceName' => '<p>The name of the <code>DataSource</code>.</p>', 'GetDataSourceRequest$name' => '<p>The name of the data source.</p>', 'GetFunctionRequest$functionId' => '<p>The <code>Function</code> ID.</p>', 'GetResolverRequest$typeName' => '<p>The resolver type name.</p>', 'GetResolverRequest$fieldName' => '<p>The resolver field name.</p>', 'GetTypeRequest$typeName' => '<p>The type name.</p>', 'GraphqlApi$name' => '<p>The API name.</p>', 'Resolver$typeName' => '<p>The resolver type name.</p>', 'Resolver$fieldName' => '<p>The resolver field name.</p>', 'Resolver$dataSourceName' => '<p>The resolver data source name.</p>', 'Type$name' => '<p>The type name.</p>', 'UpdateDataSourceRequest$name' => '<p>The new name for the data source.</p>', 'UpdateFunctionRequest$name' => '<p>The <code>Function</code> name.</p>', 'UpdateFunctionRequest$functionId' => '<p>The function ID.</p>', 'UpdateFunctionRequest$dataSourceName' => '<p>The <code>Function</code> <code>DataSource</code> name.</p>', 'UpdateResolverRequest$typeName' => '<p>The new type name.</p>', 'UpdateResolverRequest$fieldName' => '<p>The new field name.</p>', 'UpdateResolverRequest$dataSourceName' => '<p>The new data source name.</p>', 'UpdateTypeRequest$typeName' => '<p>The new type name.</p>', ], ], 'RuntimeName' => [ 'base' => NULL, 'refs' => [ 'AppSyncRuntime$name' => '<p>The <code>name</code> of the runtime to use. Currently, the only allowed value is <code>APPSYNC_JS</code>.</p>', ], ], 'SchemaStatus' => [ 'base' => NULL, 'refs' => [ 'GetSchemaCreationStatusResponse$status' => '<p>The current state of the schema (PROCESSING, FAILED, SUCCESS, or NOT_APPLICABLE). When the schema is in the ACTIVE state, you can add data.</p>', 'StartSchemaCreationResponse$status' => '<p>The current state of the schema (PROCESSING, FAILED, SUCCESS, or NOT_APPLICABLE). When the schema is in the ACTIVE state, you can add data.</p>', ], ], 'SourceApiAssociation' => [ 'base' => '<p>Describes the configuration of a source API. A source API is a GraphQL API that is linked to a merged API. There can be multiple source APIs attached to each merged API. When linked to a merged API, the source API\'s schema, data sources, and resolvers will be combined with other linked source API data to form a new, singular API. </p> <p>Source APIs can originate from your account or from other accounts via Amazon Web Services Resource Access Manager. For more information about sharing resources from other accounts, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/what-is.html">What is Amazon Web Services Resource Access Manager?</a> in the <i>Amazon Web Services Resource Access Manager</i> guide.</p>', 'refs' => [ 'AssociateMergedGraphqlApiResponse$sourceApiAssociation' => '<p>The <code>SourceApiAssociation</code> object data.</p>', 'AssociateSourceGraphqlApiResponse$sourceApiAssociation' => '<p>The <code>SourceApiAssociation</code> object data.</p>', 'GetSourceApiAssociationResponse$sourceApiAssociation' => '<p>The <code>SourceApiAssociation</code> object data.</p>', 'UpdateSourceApiAssociationResponse$sourceApiAssociation' => '<p>The <code>SourceApiAssociation</code> object data.</p>', ], ], 'SourceApiAssociationConfig' => [ 'base' => '<p>Describes properties used to specify configurations related to a source API.</p>', 'refs' => [ 'AssociateMergedGraphqlApiRequest$sourceApiAssociationConfig' => '<p>The <code>SourceApiAssociationConfig</code> object data.</p>', 'AssociateSourceGraphqlApiRequest$sourceApiAssociationConfig' => '<p>The <code>SourceApiAssociationConfig</code> object data.</p>', 'SourceApiAssociation$sourceApiAssociationConfig' => '<p>The <code>SourceApiAssociationConfig</code> object data.</p>', 'UpdateSourceApiAssociationRequest$sourceApiAssociationConfig' => '<p>The <code>SourceApiAssociationConfig</code> object data.</p>', ], ], 'SourceApiAssociationStatus' => [ 'base' => NULL, 'refs' => [ 'DisassociateMergedGraphqlApiResponse$sourceApiAssociationStatus' => '<p>The state of the source API association.</p>', 'DisassociateSourceGraphqlApiResponse$sourceApiAssociationStatus' => '<p>The state of the source API association.</p>', 'SourceApiAssociation$sourceApiAssociationStatus' => '<p>The state of the source API association.</p>', 'StartSchemaMergeResponse$sourceApiAssociationStatus' => '<p>The state of the source API association.</p>', ], ], 'SourceApiAssociationSummary' => [ 'base' => '<p>Describes the ARNs and IDs of associations, Merged APIs, and source APIs.</p>', 'refs' => [ 'SourceApiAssociationSummaryList$member' => NULL, ], ], 'SourceApiAssociationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListSourceApiAssociationsResponse$sourceApiAssociationSummaries' => '<p>The <code>SourceApiAssociationSummary</code> object data.</p>', ], ], 'StartDataSourceIntrospectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDataSourceIntrospectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartSchemaCreationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartSchemaCreationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartSchemaMergeRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartSchemaMergeResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ApiAssociation$apiId' => '<p>The API ID.</p>', 'ApiAssociation$deploymentDetail' => '<p>Details about the last deployment status.</p>', 'ApiKey$id' => '<p>The API key ID.</p>', 'ApiKey$description' => '<p>A description of the purpose of the API key.</p>', 'ApiKeyLimitExceededException$message' => NULL, 'ApiKeyValidityOutOfBoundsException$message' => NULL, 'ApiLimitExceededException$message' => NULL, 'AppSyncRuntime$runtimeVersion' => '<p>The <code>version</code> of the runtime to use. Currently, the only allowed version is <code>1.0.0</code>.</p>', 'AssociateApiRequest$apiId' => '<p>The API ID. Private APIs can not be associated with custom domains.</p>', 'AssociateMergedGraphqlApiRequest$sourceApiIdentifier' => '<p>The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source APIs (especially in your account) only require the API ID value or ARN of the source API. However, source APIs from other accounts (cross-account use cases) strictly require the full resource ARN of the source API.</p>', 'AssociateMergedGraphqlApiRequest$mergedApiIdentifier' => '<p>The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.</p>', 'AssociateMergedGraphqlApiRequest$description' => '<p>The description field.</p>', 'AssociateSourceGraphqlApiRequest$mergedApiIdentifier' => '<p>The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.</p>', 'AssociateSourceGraphqlApiRequest$sourceApiIdentifier' => '<p>The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source APIs (especially in your account) only require the API ID value or ARN of the source API. However, source APIs from other accounts (cross-account use cases) strictly require the full resource ARN of the source API.</p>', 'AssociateSourceGraphqlApiRequest$description' => '<p>The description field.</p>', 'AwsIamConfig$signingRegion' => '<p>The signing Amazon Web Services Region for IAM authorization.</p>', 'AwsIamConfig$signingServiceName' => '<p>The signing service name for IAM authorization.</p>', 'CachingKeys$member' => NULL, 'CodeError$errorType' => '<p>The type of code error. </p> <p>Examples include, but aren\'t limited to: <code>LINT_ERROR</code>, <code>PARSER_ERROR</code>.</p>', 'CodeError$value' => '<p>A user presentable error.</p> <p>Examples include, but aren\'t limited to: <code>Parsing error: Unterminated string literal</code>.</p>', 'CognitoUserPoolConfig$userPoolId' => '<p>The user pool ID.</p>', 'CognitoUserPoolConfig$awsRegion' => '<p>The Amazon Web Services Region in which the user pool was created.</p>', 'CognitoUserPoolConfig$appIdClientRegex' => '<p>A regular expression for validating the incoming Amazon Cognito user pool app client ID. If this value isn\'t set, no filtering is applied.</p>', 'CreateApiCacheRequest$apiId' => '<p>The GraphQL API ID.</p>', 'CreateApiKeyRequest$apiId' => '<p>The ID for your GraphQL API.</p>', 'CreateApiKeyRequest$description' => '<p>A description of the purpose of the API key.</p>', 'CreateDataSourceRequest$apiId' => '<p>The API ID for the GraphQL API for the <code>DataSource</code>.</p>', 'CreateDataSourceRequest$description' => '<p>A description of the <code>DataSource</code>.</p>', 'CreateDataSourceRequest$serviceRoleArn' => '<p>The Identity and Access Management (IAM) service role Amazon Resource Name (ARN) for the data source. The system assumes this role when accessing the data source.</p>', 'CreateFunctionRequest$apiId' => '<p>The GraphQL API ID.</p>', 'CreateFunctionRequest$description' => '<p>The <code>Function</code> description.</p>', 'CreateFunctionRequest$functionVersion' => '<p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29. Note that when using VTL and mapping templates, the <code>functionVersion</code> is required.</p>', 'CreateGraphqlApiRequest$name' => '<p>A user-supplied name for the <code>GraphqlApi</code>.</p>', 'CreateGraphqlApiRequest$mergedApiExecutionRoleArn' => '<p>The Identity and Access Management service role ARN for a merged API. The AppSync service assumes this role on behalf of the Merged API to validate access to source APIs at runtime and to prompt the <code>AUTO_MERGE</code> to update the merged API endpoint with the source API changes automatically.</p>', 'CreateGraphqlApiRequest$ownerContact' => '<p>The owner contact information for an API resource.</p> <p>This field accepts any string input with a length of 0 - 256 characters.</p>', 'CreateResolverRequest$apiId' => '<p>The ID for the GraphQL API for which the resolver is being created.</p>', 'CreateTypeRequest$apiId' => '<p>The API ID.</p>', 'CreateTypeRequest$definition' => '<p>The type definition, in GraphQL Schema Definition Language (SDL) format.</p> <p>For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL documentation</a>.</p>', 'DataSource$dataSourceArn' => '<p>The data source Amazon Resource Name (ARN).</p>', 'DataSource$description' => '<p>The description of the data source.</p>', 'DataSource$serviceRoleArn' => '<p>The Identity and Access Management (IAM) service role Amazon Resource Name (ARN) for the data source. The system assumes this role when accessing the data source.</p>', 'DataSourceIntrospectionModel$name' => '<p>The name of the model. For example, this could be the name of a single table in a database.</p>', 'DataSourceIntrospectionModel$sdl' => '<p>Contains the output of the SDL that was generated from the introspected types. This is controlled by the <code>includeModelsSDL</code> parameter of the <code>GetDataSourceIntrospection</code> operation.</p>', 'DataSourceIntrospectionModelField$name' => '<p>The name of the field that was retrieved from the introspected data.</p>', 'DataSourceIntrospectionModelFieldType$kind' => '<p>Specifies the classification of data. For example, this could be set to values like <code>Scalar</code> or <code>NonNull</code> to indicate a fundamental property of the field.</p> <p>Valid values include:</p> <ul> <li> <p> <code>Scalar</code>: Indicates the value is a primitive type (scalar).</p> </li> <li> <p> <code>NonNull</code>: Indicates the field cannot be <code>null</code>.</p> </li> <li> <p> <code>List</code>: Indicates the field contains a list.</p> </li> </ul>', 'DataSourceIntrospectionModelFieldType$name' => '<p>The name of the data type that represents the field. For example, <code>String</code> is a valid <code>name</code> value.</p>', 'DataSourceIntrospectionModelFieldTypeValues$member' => NULL, 'DataSourceIntrospectionModelIndex$name' => '<p>The name of the index.</p>', 'DataSourceIntrospectionModelIndexFields$member' => NULL, 'DeleteApiCacheRequest$apiId' => '<p>The API ID.</p>', 'DeleteApiKeyRequest$apiId' => '<p>The API ID.</p>', 'DeleteApiKeyRequest$id' => '<p>The ID for the API key.</p>', 'DeleteDataSourceRequest$apiId' => '<p>The API ID.</p>', 'DeleteFunctionRequest$apiId' => '<p>The GraphQL API ID.</p>', 'DeleteGraphqlApiRequest$apiId' => '<p>The API ID.</p>', 'DeleteResolverRequest$apiId' => '<p>The API ID.</p>', 'DeleteTypeRequest$apiId' => '<p>The API ID.</p>', 'DeltaSyncConfig$deltaSyncTableName' => '<p>The Delta Sync table name.</p>', 'DisassociateMergedGraphqlApiRequest$sourceApiIdentifier' => '<p>The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source APIs (especially in your account) only require the API ID value or ARN of the source API. However, source APIs from other accounts (cross-account use cases) strictly require the full resource ARN of the source API.</p>', 'DisassociateMergedGraphqlApiRequest$associationId' => '<p>The ID generated by the AppSync service for the source API association.</p>', 'DisassociateSourceGraphqlApiRequest$mergedApiIdentifier' => '<p>The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.</p>', 'DisassociateSourceGraphqlApiRequest$associationId' => '<p>The ID generated by the AppSync service for the source API association.</p>', 'DomainNameConfig$appsyncDomainName' => '<p>The domain name that AppSync provides.</p>', 'DomainNameConfig$hostedZoneId' => '<p>The ID of your Amazon Route 53 hosted zone.</p>', 'DynamodbDataSourceConfig$tableName' => '<p>The table name.</p>', 'DynamodbDataSourceConfig$awsRegion' => '<p>The Amazon Web Services Region.</p>', 'ElasticsearchDataSourceConfig$endpoint' => '<p>The endpoint.</p>', 'ElasticsearchDataSourceConfig$awsRegion' => '<p>The Amazon Web Services Region.</p>', 'EvaluateCodeRequest$function' => '<p>The function within the code to be evaluated. If provided, the valid values are <code>request</code> and <code>response</code>.</p>', 'EventBridgeDataSourceConfig$eventBusArn' => '<p>The ARN of the event bus. For more information about event buses, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-bus.html">Amazon EventBridge event buses</a>.</p>', 'FlushApiCacheRequest$apiId' => '<p>The API ID.</p>', 'FunctionConfiguration$functionId' => '<p>A unique ID representing the <code>Function</code> object.</p>', 'FunctionConfiguration$functionArn' => '<p>The Amazon Resource Name (ARN) of the <code>Function</code> object.</p>', 'FunctionConfiguration$description' => '<p>The <code>Function</code> description.</p>', 'FunctionConfiguration$functionVersion' => '<p>The version of the request mapping template. Currently, only the 2018-05-29 version of the template is supported.</p>', 'FunctionsIds$member' => NULL, 'GetApiCacheRequest$apiId' => '<p>The API ID.</p>', 'GetDataSourceIntrospectionRequest$introspectionId' => '<p>The introspection ID. Each introspection contains a unique ID that can be used to reference the instrospection record.</p>', 'GetDataSourceIntrospectionResponse$introspectionId' => '<p>The introspection ID. Each introspection contains a unique ID that can be used to reference the instrospection record.</p>', 'GetDataSourceIntrospectionResponse$introspectionStatusDetail' => '<p>The error detail field. When a <code>FAILED</code> <code>introspectionStatus</code> is returned, the <code>introspectionStatusDetail</code> will also return the exact error that was generated during the operation.</p>', 'GetDataSourceRequest$apiId' => '<p>The API ID.</p>', 'GetFunctionRequest$apiId' => '<p>The GraphQL API ID.</p>', 'GetGraphqlApiEnvironmentVariablesRequest$apiId' => '<p>The ID of the API from which the environmental variable list will be retrieved.</p>', 'GetGraphqlApiRequest$apiId' => '<p>The API ID for the GraphQL API.</p>', 'GetIntrospectionSchemaRequest$apiId' => '<p>The API ID.</p>', 'GetResolverRequest$apiId' => '<p>The API ID.</p>', 'GetSchemaCreationStatusRequest$apiId' => '<p>The API ID.</p>', 'GetSchemaCreationStatusResponse$details' => '<p>Detailed information about the status of the schema creation operation.</p>', 'GetSourceApiAssociationRequest$mergedApiIdentifier' => '<p>The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.</p>', 'GetSourceApiAssociationRequest$associationId' => '<p>The ID generated by the AppSync service for the source API association.</p>', 'GetTypeRequest$apiId' => '<p>The API ID.</p>', 'GraphqlApi$apiId' => '<p>The API ID.</p>', 'GraphqlApi$arn' => '<p>The Amazon Resource Name (ARN).</p>', 'GraphqlApi$wafWebAclArn' => '<p>The ARN of the WAF access control list (ACL) associated with this <code>GraphqlApi</code>, if one exists.</p>', 'GraphqlApi$mergedApiExecutionRoleArn' => '<p>The Identity and Access Management service role ARN for a merged API. The AppSync service assumes this role on behalf of the Merged API to validate access to source APIs at runtime and to prompt the <code>AUTO_MERGE</code> to update the merged API endpoint with the source API changes automatically.</p>', 'GraphqlApi$owner' => '<p>The account owner of the GraphQL API.</p>', 'GraphqlApi$ownerContact' => '<p>The owner contact information for an API resource.</p> <p>This field accepts any string input with a length of 0 - 256 characters.</p>', 'HttpDataSourceConfig$endpoint' => '<p>The HTTP URL endpoint. You can specify either the domain name or IP, and port combination, and the URL scheme must be HTTP or HTTPS. If you don\'t specify the port, AppSync uses the default port 80 for the HTTP endpoint and port 443 for HTTPS endpoints.</p>', 'InternalFailureException$message' => NULL, 'LambdaAuthorizerConfig$authorizerUri' => '<p>The Amazon Resource Name (ARN) of the Lambda function to be called for authorization. This can be a standard Lambda ARN, a version ARN (<code>.../v3</code>), or an alias ARN. </p> <p> <b>Note</b>: This Lambda function must have the following resource-based policy assigned to it. When configuring Lambda authorizers in the console, this is done for you. To use the Command Line Interface (CLI), run the following:</p> <p> <code>aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction</code> </p>', 'LambdaAuthorizerConfig$identityValidationExpression' => '<p>A regular expression for validation of tokens before the Lambda function is called.</p>', 'LambdaConflictHandlerConfig$lambdaConflictHandlerArn' => '<p>The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.</p>', 'LambdaDataSourceConfig$lambdaFunctionArn' => '<p>The Amazon Resource Name (ARN) for the Lambda function.</p>', 'LimitExceededException$message' => NULL, 'ListApiKeysRequest$apiId' => '<p>The API ID.</p>', 'ListDataSourcesRequest$apiId' => '<p>The API ID.</p>', 'ListFunctionsRequest$apiId' => '<p>The GraphQL API ID.</p>', 'ListResolversByFunctionRequest$apiId' => '<p>The API ID.</p>', 'ListResolversByFunctionRequest$functionId' => '<p>The function ID.</p>', 'ListResolversRequest$apiId' => '<p>The API ID.</p>', 'ListResolversRequest$typeName' => '<p>The type name.</p>', 'ListSourceApiAssociationsRequest$apiId' => '<p>The API ID.</p>', 'ListTypesByAssociationRequest$mergedApiIdentifier' => '<p>The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.</p>', 'ListTypesByAssociationRequest$associationId' => '<p>The ID generated by the AppSync service for the source API association.</p>', 'ListTypesRequest$apiId' => '<p>The API ID.</p>', 'LogConfig$cloudWatchLogsRoleArn' => '<p>The service role that AppSync assumes to publish to CloudWatch logs in your account.</p>', 'Logs$member' => NULL, 'MapOfStringToString$key' => NULL, 'MapOfStringToString$value' => NULL, 'NotFoundException$message' => NULL, 'OpenIDConnectConfig$issuer' => '<p>The issuer for the OIDC configuration. The issuer returned by discovery must exactly match the value of <code>iss</code> in the ID token.</p>', 'OpenIDConnectConfig$clientId' => '<p>The client identifier of the relying party at the OpenID identity provider. This identifier is typically obtained when the relying party is registered with the OpenID identity provider. You can specify a regular expression so that AppSync can validate against multiple client identifiers at a time.</p>', 'OpenSearchServiceDataSourceConfig$endpoint' => '<p>The endpoint.</p>', 'OpenSearchServiceDataSourceConfig$awsRegion' => '<p>The Amazon Web Services Region.</p>', 'PutGraphqlApiEnvironmentVariablesRequest$apiId' => '<p>The ID of the API to which the environmental variable list will be written.</p>', 'RdsHttpEndpointConfig$awsRegion' => '<p>Amazon Web Services Region for Amazon RDS HTTP endpoint.</p>', 'RdsHttpEndpointConfig$dbClusterIdentifier' => '<p>Amazon RDS cluster Amazon Resource Name (ARN).</p>', 'RdsHttpEndpointConfig$databaseName' => '<p>Logical database name.</p>', 'RdsHttpEndpointConfig$schema' => '<p>Logical schema name.</p>', 'RdsHttpEndpointConfig$awsSecretStoreArn' => '<p>Amazon Web Services secret store Amazon Resource Name (ARN) for database credentials.</p>', 'Resolver$resolverArn' => '<p>The resolver Amazon Resource Name (ARN).</p>', 'SourceApiAssociation$associationId' => '<p>The ID generated by the AppSync service for the source API association.</p>', 'SourceApiAssociation$associationArn' => '<p>The Amazon Resource Name (ARN) of the source API association.</p>', 'SourceApiAssociation$sourceApiId' => '<p>The ID of the AppSync source API.</p>', 'SourceApiAssociation$sourceApiArn' => '<p>The Amazon Resource Name (ARN) of the AppSync source API.</p>', 'SourceApiAssociation$mergedApiArn' => '<p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>', 'SourceApiAssociation$mergedApiId' => '<p>The ID of the AppSync Merged API.</p>', 'SourceApiAssociation$description' => '<p>The description field.</p>', 'SourceApiAssociation$sourceApiAssociationStatusDetail' => '<p>The detailed message related to the current state of the source API association.</p>', 'SourceApiAssociationSummary$associationId' => '<p>The ID generated by the AppSync service for the source API association.</p>', 'SourceApiAssociationSummary$associationArn' => '<p>The Amazon Resource Name (ARN) of the source API association.</p>', 'SourceApiAssociationSummary$sourceApiId' => '<p>The ID of the AppSync source API.</p>', 'SourceApiAssociationSummary$sourceApiArn' => '<p>The Amazon Resource Name (ARN) of the AppSync Source API.</p>', 'SourceApiAssociationSummary$mergedApiId' => '<p>The ID of the AppSync Merged API.</p>', 'SourceApiAssociationSummary$mergedApiArn' => '<p>The Amazon Resource Name (ARN) of the AppSync Merged API.</p>', 'SourceApiAssociationSummary$description' => '<p>The description field.</p>', 'StartDataSourceIntrospectionResponse$introspectionId' => '<p>The introspection ID. Each introspection contains a unique ID that can be used to reference the instrospection record.</p>', 'StartDataSourceIntrospectionResponse$introspectionStatusDetail' => '<p>The error detail field. When a <code>FAILED</code> <code>introspectionStatus</code> is returned, the <code>introspectionStatusDetail</code> will also return the exact error that was generated during the operation.</p>', 'StartSchemaCreationRequest$apiId' => '<p>The API ID.</p>', 'StartSchemaMergeRequest$associationId' => '<p>The ID generated by the AppSync service for the source API association.</p>', 'StartSchemaMergeRequest$mergedApiIdentifier' => '<p>The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.</p>', 'Type$description' => '<p>The type description.</p>', 'Type$arn' => '<p>The type Amazon Resource Name (ARN).</p>', 'Type$definition' => '<p>The type definition.</p>', 'UnauthorizedException$message' => NULL, 'UpdateApiCacheRequest$apiId' => '<p>The GraphQL API ID.</p>', 'UpdateApiKeyRequest$apiId' => '<p>The ID for the GraphQL API.</p>', 'UpdateApiKeyRequest$id' => '<p>The API key ID.</p>', 'UpdateApiKeyRequest$description' => '<p>A description of the purpose of the API key.</p>', 'UpdateDataSourceRequest$apiId' => '<p>The API ID.</p>', 'UpdateDataSourceRequest$description' => '<p>The new description for the data source.</p>', 'UpdateDataSourceRequest$serviceRoleArn' => '<p>The new service role Amazon Resource Name (ARN) for the data source.</p>', 'UpdateFunctionRequest$apiId' => '<p>The GraphQL API ID.</p>', 'UpdateFunctionRequest$description' => '<p>The <code>Function</code> description.</p>', 'UpdateFunctionRequest$functionVersion' => '<p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29. Note that when using VTL and mapping templates, the <code>functionVersion</code> is required.</p>', 'UpdateGraphqlApiRequest$apiId' => '<p>The API ID.</p>', 'UpdateGraphqlApiRequest$name' => '<p>The new name for the <code>GraphqlApi</code> object.</p>', 'UpdateGraphqlApiRequest$mergedApiExecutionRoleArn' => '<p>The Identity and Access Management service role ARN for a merged API. The AppSync service assumes this role on behalf of the Merged API to validate access to source APIs at runtime and to prompt the <code>AUTO_MERGE</code> to update the merged API endpoint with the source API changes automatically.</p>', 'UpdateGraphqlApiRequest$ownerContact' => '<p>The owner contact information for an API resource.</p> <p>This field accepts any string input with a length of 0 - 256 characters.</p>', 'UpdateResolverRequest$apiId' => '<p>The API ID.</p>', 'UpdateSourceApiAssociationRequest$associationId' => '<p>The ID generated by the AppSync service for the source API association.</p>', 'UpdateSourceApiAssociationRequest$mergedApiIdentifier' => '<p>The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.</p>', 'UpdateSourceApiAssociationRequest$description' => '<p>The description field.</p>', 'UpdateTypeRequest$apiId' => '<p>The API ID.</p>', 'UpdateTypeRequest$definition' => '<p>The new definition.</p>', 'UserPoolConfig$userPoolId' => '<p>The user pool ID.</p>', 'UserPoolConfig$awsRegion' => '<p>The Amazon Web Services Region in which the user pool was created.</p>', 'UserPoolConfig$appIdClientRegex' => '<p>A regular expression for validating the incoming Amazon Cognito user pool app client ID. If this value isn\'t set, no filtering is applied.</p>', ], ], 'SyncConfig' => [ 'base' => '<p>Describes a Sync configuration for a resolver.</p> <p>Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.</p>', 'refs' => [ 'CreateFunctionRequest$syncConfig' => NULL, 'CreateResolverRequest$syncConfig' => '<p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>', 'FunctionConfiguration$syncConfig' => NULL, 'Resolver$syncConfig' => '<p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>', 'UpdateFunctionRequest$syncConfig' => NULL, 'UpdateResolverRequest$syncConfig' => '<p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>', ], ], 'TTL' => [ 'base' => NULL, 'refs' => [ 'LambdaAuthorizerConfig$authorizerResultTtlInSeconds' => '<p>The number of seconds a response should be cached for. The default is 0 seconds, which disables caching. If you don\'t specify a value for <code>authorizerResultTtlInSeconds</code>, the default value is used. The maximum value is one hour (3600 seconds). The Lambda function can override this by returning a <code>ttlOverride</code> key in its response.</p>', ], ], 'TagKey' => [ 'base' => '<p>The key for the tag.</p>', 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of <code>TagKey</code> objects.</p>', ], ], 'TagMap' => [ 'base' => '<p>A map with keys of <code>TagKey</code> objects and values of <code>TagValue</code> objects.</p>', 'refs' => [ 'CreateGraphqlApiRequest$tags' => '<p>A <code>TagMap</code> object.</p>', 'GraphqlApi$tags' => '<p>The tags.</p>', 'ListTagsForResourceResponse$tags' => '<p>A <code>TagMap</code> object.</p>', 'TagResourceRequest$tags' => '<p>A <code>TagMap</code> object.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => '<p>The value for the tag.</p>', 'refs' => [ 'TagMap$value' => NULL, ], ], 'Template' => [ 'base' => NULL, 'refs' => [ 'EvaluateMappingTemplateRequest$template' => '<p>The mapping template; this can be a request or response template. A <code>template</code> is required for this action.</p>', ], ], 'Type' => [ 'base' => '<p>Describes a type.</p>', 'refs' => [ 'CreateTypeResponse$type' => '<p>The <code>Type</code> object.</p>', 'GetTypeResponse$type' => '<p>The <code>Type</code> object.</p>', 'TypeList$member' => NULL, 'UpdateTypeResponse$type' => '<p>The updated <code>Type</code> object.</p>', ], ], 'TypeDefinitionFormat' => [ 'base' => NULL, 'refs' => [ 'CreateTypeRequest$format' => '<p>The type format: SDL or JSON.</p>', 'GetTypeRequest$format' => '<p>The type format: SDL or JSON.</p>', 'ListTypesByAssociationRequest$format' => '<p>The format type.</p>', 'ListTypesRequest$format' => '<p>The type format: SDL or JSON.</p>', 'Type$format' => '<p>The type format: SDL or JSON.</p>', 'UpdateTypeRequest$format' => '<p>The new type format: SDL or JSON.</p>', ], ], 'TypeList' => [ 'base' => NULL, 'refs' => [ 'ListTypesByAssociationResponse$types' => '<p>The <code>Type</code> objects.</p>', 'ListTypesResponse$types' => '<p>The <code>Type</code> objects.</p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>You aren\'t authorized to perform this operation.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApiCacheRequest' => [ 'base' => '<p>Represents the input of a <code>UpdateApiCache</code> operation.</p>', 'refs' => [], ], 'UpdateApiCacheResponse' => [ 'base' => '<p>Represents the output of a <code>UpdateApiCache</code> operation.</p>', 'refs' => [], ], 'UpdateApiKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApiKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDomainNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDomainNameResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFunctionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGraphqlApiRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGraphqlApiResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResolverRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResolverResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSourceApiAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSourceApiAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'UserPoolConfig' => [ 'base' => '<p>Describes an Amazon Cognito user pool configuration.</p>', 'refs' => [ 'CreateGraphqlApiRequest$userPoolConfig' => '<p>The Amazon Cognito user pool configuration.</p>', 'GraphqlApi$userPoolConfig' => '<p>The Amazon Cognito user pool configuration.</p>', 'UpdateGraphqlApiRequest$userPoolConfig' => '<p>The new Amazon Cognito user pool configuration for the <code>~GraphqlApi</code> object.</p>', ], ], ],];
