<?php
// This file was auto-generated from sdk-root/src/data/apptest/2022-12-06/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS Mainframe Modernization Application Testing provides tools and resources for automated functional equivalence testing for your migration projects.</p>', 'operations' => [ 'CreateTestCase' => '<p>Creates a test case.</p>', 'CreateTestConfiguration' => '<p>Creates a test configuration.</p>', 'CreateTestSuite' => '<p>Creates a test suite.</p>', 'DeleteTestCase' => '<p>Deletes a test case.</p>', 'DeleteTestConfiguration' => '<p>Deletes a test configuration.</p>', 'DeleteTestRun' => '<p>Deletes a test run.</p>', 'DeleteTestSuite' => '<p>Deletes a test suite.</p>', 'GetTestCase' => '<p>Gets a test case.</p>', 'GetTestConfiguration' => '<p>Gets a test configuration.</p>', 'GetTestRunStep' => '<p>Gets a test run step.</p>', 'GetTestSuite' => '<p>Gets a test suite.</p>', 'ListTagsForResource' => '<p>Lists tags for a resource.</p>', 'ListTestCases' => '<p>Lists test cases.</p>', 'ListTestConfigurations' => '<p>Lists test configurations.</p>', 'ListTestRunSteps' => '<p>Lists test run steps.</p>', 'ListTestRunTestCases' => '<p>Lists test run test cases.</p>', 'ListTestRuns' => '<p>Lists test runs.</p>', 'ListTestSuites' => '<p>Lists test suites.</p>', 'StartTestRun' => '<p>Starts a test run.</p>', 'TagResource' => '<p>Specifies tags of a resource.</p>', 'UntagResource' => '<p>Untags a resource.</p>', 'UpdateTestCase' => '<p>Updates a test case.</p>', 'UpdateTestConfiguration' => '<p>Updates a test configuration.</p>', 'UpdateTestSuite' => '<p>Updates a test suite.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The account or role doesn\'t have the right permissions to make the request.</p>', 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'GetTestCaseResponse$testCaseArn' => '<p>The Amazon Resource Name (ARN) of the test case.</p>', 'GetTestConfigurationResponse$testConfigurationArn' => '<p>The test configuration Amazon Resource Name (ARN).</p>', 'GetTestSuiteResponse$testSuiteArn' => '<p>The test suite Amazon Resource Name (ARN).</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the tag resource.</p>', 'TestCaseSummary$testCaseArn' => '<p>The test case Amazon Resource Name (ARN) of the test case summary.</p>', 'TestConfigurationSummary$testConfigurationArn' => '<p>The test configuration ARN of the test configuration summary.</p>', 'TestRunSummary$testRunArn' => '<p>The test run ARN of the test run summary.</p>', 'TestSuiteSummary$testSuiteArn' => '<p>The test suite Amazon Resource Name (ARN) of the test suite summary.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'Batch' => [ 'base' => '<p>Defines a batch.</p>', 'refs' => [ 'MainframeActionType$batch' => '<p>The batch of the mainframe action type.</p>', ], ], 'BatchJobParameters' => [ 'base' => NULL, 'refs' => [ 'Batch$batchJobParameters' => '<p>The batch job parameters of the batch.</p>', 'BatchStepInput$batchJobParameters' => '<p>The batch job parameters of the batch step input.</p>', ], ], 'BatchStepInput' => [ 'base' => '<p>Defines a batch step input.</p>', 'refs' => [ 'BatchSummary$stepInput' => '<p>The step input of the batch summary.</p>', ], ], 'BatchStepOutput' => [ 'base' => '<p>Defines a batch step output.</p>', 'refs' => [ 'BatchSummary$stepOutput' => '<p>The step output of the batch summary.</p>', ], ], 'BatchSummary' => [ 'base' => '<p>Summarizes a batch job.</p>', 'refs' => [ 'MainframeActionSummary$batch' => '<p>The batch of the mainframe action summary.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'GetTestRunStepResponse$beforeStep' => '<p>The before steps of the test run step.</p>', 'GetTestRunStepResponse$afterStep' => '<p>The after steps of the test run step.</p>', 'M2ManagedActionProperties$forceStop' => '<p>Force stops the AWS Mainframe Modernization managed action properties.</p>', 'TestRunStepSummary$beforeStep' => '<p>The before step of the test run step summary.</p>', 'TestRunStepSummary$afterStep' => '<p>The after step of the test run step summary.</p>', ], ], 'CaptureTool' => [ 'base' => NULL, 'refs' => [ 'SourceDatabaseMetadata$captureTool' => '<p>The capture tool of the source database metadata.</p>', 'TargetDatabaseMetadata$captureTool' => '<p>The capture tool of the target database metadata.</p>', ], ], 'CloudFormation' => [ 'base' => '<p>Specifies the CloudFormation template and its parameters.</p>', 'refs' => [ 'ResourceType$cloudFormation' => '<p>The CloudFormation template of the resource type.</p>', ], ], 'CloudFormationAction' => [ 'base' => '<p>Specifies the CloudFormation action.</p>', 'refs' => [ 'ResourceAction$cloudFormationAction' => '<p>The CloudFormation action of the resource action.</p>', ], ], 'CloudFormationActionType' => [ 'base' => NULL, 'refs' => [ 'CloudFormationAction$actionType' => '<p>The action type of the CloudFormation action.</p>', ], ], 'CloudFormationStepSummary' => [ 'base' => '<p>Specifies the CloudFormation step summary.</p>', 'refs' => [ 'ResourceActionSummary$cloudFormation' => '<p>The CloudFormation template of the resource action summary.</p>', ], ], 'CompareAction' => [ 'base' => '<p>Compares the action.</p>', 'refs' => [ 'StepAction$compareAction' => '<p>The compare action of the step action.</p>', ], ], 'CompareActionSummary' => [ 'base' => '<p>Specifies the compare action summary.</p>', 'refs' => [ 'StepRunSummary$compareAction' => '<p>The compare action of the step run summary.</p>', ], ], 'CompareDataSetsStepInput' => [ 'base' => '<p>Specifies the compare data sets step input.</p>', 'refs' => [ 'CompareDataSetsSummary$stepInput' => '<p>The step input of the compare data sets summary.</p>', ], ], 'CompareDataSetsStepOutput' => [ 'base' => '<p>Specifies the compare data sets step output.</p>', 'refs' => [ 'CompareDataSetsSummary$stepOutput' => '<p>The step output of the compare data sets summary.</p>', ], ], 'CompareDataSetsSummary' => [ 'base' => '<p>Compares data sets summary.</p>', 'refs' => [ 'CompareFileType$datasets' => '<p>The data sets in the compare file type.</p>', ], ], 'CompareDatabaseCDCStepInput' => [ 'base' => '<p>Compares the database Change Data Capture (CDC) step input.</p>', 'refs' => [ 'CompareDatabaseCDCSummary$stepInput' => '<p>The step input of the compare database CDC summary.</p>', ], ], 'CompareDatabaseCDCStepOutput' => [ 'base' => '<p>Compares the database CDC step output.</p>', 'refs' => [ 'CompareDatabaseCDCSummary$stepOutput' => '<p>The step output of the compare database CDC summary.</p>', ], ], 'CompareDatabaseCDCSummary' => [ 'base' => '<p>Compares the database CDC summary.</p>', 'refs' => [ 'CompareFileType$databaseCDC' => '<p>The database CDC of the compare file type.</p>', ], ], 'CompareFileType' => [ 'base' => '<p>Compares the file type.</p>', 'refs' => [ 'File$fileType' => '<p>The file type of the file.</p>', ], ], 'ComparisonStatusEnum' => [ 'base' => NULL, 'refs' => [ 'CompareDataSetsStepOutput$comparisonStatus' => '<p>The comparison status of the compare data sets step output.</p>', 'CompareDatabaseCDCStepOutput$comparisonStatus' => '<p>The comparison status of the compare database CDC step output.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The parameters provided in the request conflict with existing resources.</p>', 'refs' => [], ], 'CreateCloudFormationStepInput' => [ 'base' => '<p>Creates the CloudFormation step input.</p>', 'refs' => [ 'CreateCloudFormationSummary$stepInput' => '<p>The step input of the CloudFormation summary.</p>', ], ], 'CreateCloudFormationStepOutput' => [ 'base' => '<p>Creates a CloudFormation step output.</p>', 'refs' => [ 'CreateCloudFormationSummary$stepOutput' => '<p>The step output of the CloudFormation summary.</p>', ], ], 'CreateCloudFormationSummary' => [ 'base' => '<p>Creates a CloudFormation summary.</p>', 'refs' => [ 'CloudFormationStepSummary$createCloudformation' => '<p>Creates the CloudFormation summary of the step.</p>', ], ], 'CreateTestCaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTestCaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTestConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTestConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTestSuiteRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTestSuiteResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataSet' => [ 'base' => '<p>Defines a data set.</p>', 'refs' => [ 'DataSetList$member' => NULL, ], ], 'DataSetList' => [ 'base' => NULL, 'refs' => [ 'BatchStepOutput$dataSetDetails' => '<p>The data set details of the batch step output.</p>', 'CompareDataSetsStepInput$sourceDataSets' => '<p>The source data sets of the compare data sets step input location.</p>', 'CompareDataSetsStepInput$targetDataSets' => '<p>The target data sets of the compare data sets step input location.</p>', 'FileMetadata$dataSets' => '<p>The data sets of the file metadata.</p>', 'TN3270StepOutput$dataSetDetails' => '<p>The data set details of the TN3270 step output.</p>', ], ], 'DataSetType' => [ 'base' => NULL, 'refs' => [ 'DataSet$type' => '<p>The type of the data set.</p>', ], ], 'DatabaseCDC' => [ 'base' => '<p>Defines the Change Data Capture (CDC) of the database.</p>', 'refs' => [ 'FileMetadata$databaseCDC' => '<p>The database CDC of the file metadata.</p>', ], ], 'DeleteCloudFormationStepInput' => [ 'base' => '<p>Deletes the CloudFormation step input.</p>', 'refs' => [ 'DeleteCloudFormationSummary$stepInput' => '<p>The step input of the deleted CloudFormation summary.</p>', ], ], 'DeleteCloudFormationStepOutput' => [ 'base' => '<p>Deletes the CloudFormation summary step output.</p>', 'refs' => [ 'DeleteCloudFormationSummary$stepOutput' => '<p>The step output of the deleted CloudFormation summary.</p>', ], ], 'DeleteCloudFormationSummary' => [ 'base' => '<p>Deletes the CloudFormation summary.</p>', 'refs' => [ 'CloudFormationStepSummary$deleteCloudformation' => '<p>Deletes the CloudFormation summary of the CloudFormation step summary.</p>', ], ], 'DeleteTestCaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTestCaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTestConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTestConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTestRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTestRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTestSuiteRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTestSuiteResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportDataSetNames' => [ 'base' => NULL, 'refs' => [ 'Batch$exportDataSetNames' => '<p>The export data set names of the batch.</p>', 'BatchStepInput$exportDataSetNames' => '<p>The export data set names of the batch step input.</p>', 'TN3270$exportDataSetNames' => '<p>The data set names of the TN3270 protocol.</p>', 'TN3270StepInput$exportDataSetNames' => '<p>The export data set names of the TN3270 step input.</p>', ], ], 'File' => [ 'base' => '<p>Defines a file.</p>', 'refs' => [ 'CompareActionSummary$type' => '<p>The type of the compare action summary.</p>', ], ], 'FileMetadata' => [ 'base' => '<p>Specifies a file metadata.</p>', 'refs' => [ 'InputFile$fileMetadata' => '<p>The file metadata of the input file.</p>', ], ], 'Format' => [ 'base' => NULL, 'refs' => [ 'DataSet$format' => '<p>The format of the data set.</p>', ], ], 'GetTestCaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTestCaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTestConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTestConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTestRunStepRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTestRunStepResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTestSuiteRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTestSuiteResponse' => [ 'base' => NULL, 'refs' => [], ], 'IdempotencyTokenString' => [ 'base' => NULL, 'refs' => [ 'CreateTestCaseRequest$clientToken' => '<p>The client token of the test case.</p>', 'CreateTestConfigurationRequest$clientToken' => '<p>The client token of the test configuration.</p>', 'CreateTestSuiteRequest$clientToken' => '<p>The client token of the test suite.</p>', 'StartTestRunRequest$clientToken' => '<p>The client token of the test run.</p>', ], ], 'Identifier' => [ 'base' => NULL, 'refs' => [ 'CreateTestCaseResponse$testCaseId' => '<p>The test case ID of the test case.</p>', 'CreateTestConfigurationResponse$testConfigurationId' => '<p>The test configuration ID.</p>', 'CreateTestSuiteResponse$testSuiteId' => '<p>The suite ID of the test suite.</p>', 'DeleteTestCaseRequest$testCaseId' => '<p>The test case ID of the test case.</p>', 'DeleteTestConfigurationRequest$testConfigurationId' => '<p>The test ID of the test configuration.</p>', 'DeleteTestRunRequest$testRunId' => '<p>The run ID of the test run.</p>', 'DeleteTestSuiteRequest$testSuiteId' => '<p>The test ID of the test suite.</p>', 'GetTestCaseRequest$testCaseId' => '<p>The request test ID of the test case.</p>', 'GetTestCaseResponse$testCaseId' => '<p>The response test ID of the test case.</p>', 'GetTestConfigurationRequest$testConfigurationId' => '<p>The request test configuration ID.</p>', 'GetTestConfigurationResponse$testConfigurationId' => '<p>The response test configuration ID.</p>', 'GetTestRunStepRequest$testRunId' => '<p>The test run ID of the test run step.</p>', 'GetTestRunStepRequest$testCaseId' => '<p>The test case ID of a test run step.</p>', 'GetTestRunStepRequest$testSuiteId' => '<p>The test suite ID of a test run step.</p>', 'GetTestRunStepResponse$testRunId' => '<p>The test run ID of the test run step.</p>', 'GetTestRunStepResponse$testCaseId' => '<p>The test case ID of the test run step.</p>', 'GetTestRunStepResponse$testSuiteId' => '<p>The test suite ID of the test run step.</p>', 'GetTestSuiteRequest$testSuiteId' => '<p>The ID of the test suite.</p>', 'GetTestSuiteResponse$testSuiteId' => '<p>The response ID of the test suite.</p>', 'ListTestRunStepsRequest$testRunId' => '<p>The test run ID of the test run steps.</p>', 'ListTestRunStepsRequest$testCaseId' => '<p>The test case ID of the test run steps.</p>', 'ListTestRunStepsRequest$testSuiteId' => '<p>The test suite ID of the test run steps.</p>', 'ListTestRunTestCasesRequest$testRunId' => '<p>The test run ID of the test cases.</p>', 'ListTestRunsRequest$testSuiteId' => '<p>The test suite ID of the test runs.</p>', 'M2ManagedApplicationSummary$applicationId' => '<p>The application ID of the AWS Mainframe Modernization managed application summary.</p>', 'StartTestRunRequest$testSuiteId' => '<p>The test suite ID of the test run.</p>', 'StartTestRunRequest$testConfigurationId' => '<p>The configuration ID of the test run.</p>', 'StartTestRunResponse$testRunId' => '<p>The test run ID of the test run.</p>', 'TestCaseIdList$member' => NULL, 'TestCaseList$member' => NULL, 'TestCaseRunSummary$testCaseId' => '<p>The test case id of the test case run summary.</p>', 'TestCaseRunSummary$testRunId' => '<p>The test run id of the test case run summary.</p>', 'TestCaseSummary$testCaseId' => '<p>The test case ID of the test case summary.</p>', 'TestConfigurationIdList$member' => NULL, 'TestConfigurationSummary$testConfigurationId' => '<p>The test configuration ID of the test configuration summary.</p>', 'TestRunIdList$member' => NULL, 'TestRunStepSummary$testRunId' => '<p>The test run ID of the test run step summary.</p>', 'TestRunStepSummary$testCaseId' => '<p>The test case ID of the test run step summary.</p>', 'TestRunStepSummary$testSuiteId' => '<p>The test suite ID of the test run step summary.</p>', 'TestRunSummary$testRunId' => '<p>The test run ID of the test run summary.</p>', 'TestRunSummary$testSuiteId' => '<p>The test suite ID of the test run summary.</p>', 'TestRunSummary$testConfigurationId' => '<p>The test configuration ID of the test run summary.</p>', 'TestSuiteIdList$member' => NULL, 'TestSuiteSummary$testSuiteId' => '<p>The test suite ID of the test suite summary.</p>', 'UpdateTestCaseRequest$testCaseId' => '<p>The test case ID of the test case.</p>', 'UpdateTestCaseResponse$testCaseId' => '<p>The test case ID of the test case.</p>', 'UpdateTestConfigurationRequest$testConfigurationId' => '<p>The test configuration ID of the test configuration.</p>', 'UpdateTestConfigurationResponse$testConfigurationId' => '<p>The configuration ID of the test configuration.</p>', 'UpdateTestSuiteRequest$testSuiteId' => '<p>The test suite ID of the test suite.</p>', 'UpdateTestSuiteResponse$testSuiteId' => '<p>The test suite ID of the test suite.</p>', ], ], 'Input' => [ 'base' => '<p>Specifies the input.</p>', 'refs' => [ 'CompareAction$input' => '<p>The input of the compare action.</p>', ], ], 'InputFile' => [ 'base' => '<p>Specifies the input file.</p>', 'refs' => [ 'Input$file' => '<p>The file in the input.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DataSet$length' => '<p>The length of the data set.</p>', 'InternalServerException$retryAfterSeconds' => '<p>The number of seconds to retry the query.</p>', 'M2ManagedApplicationStepInput$listenerPort' => '<p>The listener port of the AWS Mainframe Modernization managed application step input.</p>', 'M2ManagedApplicationSummary$listenerPort' => '<p>The listener port of the AWS Mainframe Modernization managed application summary.</p>', 'M2NonManagedApplicationStepInput$listenerPort' => '<p>The listener port of the AWS Mainframe Modernization non-managed application step input.</p>', 'M2NonManagedApplicationSummary$listenerPort' => '<p>The listener port of the AWS Mainframe Modernization non-managed application summary.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The number of seconds to retry after for requests that exceed the limit.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An unexpected error occurred during the processing of the request.</p>', 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTestCasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTestCasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTestConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTestConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTestRunStepsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTestRunStepsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTestRunTestCasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTestRunTestCasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTestRunsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTestRunsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTestSuitesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTestSuitesResponse' => [ 'base' => NULL, 'refs' => [], ], 'M2ManagedActionProperties' => [ 'base' => '<p>Specifies the AWS Mainframe Modernization managed action properties.</p>', 'refs' => [ 'M2ManagedApplicationAction$properties' => '<p>The properties of the AWS Mainframe Modernization managed application action.</p>', 'M2ManagedApplicationStepInput$properties' => '<p>The properties of the AWS Mainframe Modernization managed application step input.</p>', ], ], 'M2ManagedActionType' => [ 'base' => NULL, 'refs' => [ 'M2ManagedApplicationAction$actionType' => '<p>The action type of the AWS Mainframe Modernization managed application action.</p>', 'M2ManagedApplicationStepInput$actionType' => '<p>The action type of the AWS Mainframe Modernization managed application step input.</p>', ], ], 'M2ManagedApplication' => [ 'base' => '<p>Specifies the AWS Mainframe Modernization managed application.</p>', 'refs' => [ 'ResourceType$m2ManagedApplication' => '<p>The AWS Mainframe Modernization managed application of the resource type.</p>', ], ], 'M2ManagedApplicationAction' => [ 'base' => '<p>Specifies the AWS Mainframe Modernization managed application action.</p>', 'refs' => [ 'ResourceAction$m2ManagedApplicationAction' => '<p>The AWS Mainframe Modernization managed application action of the resource action.</p>', ], ], 'M2ManagedApplicationStepInput' => [ 'base' => '<p>Specifies the AWS Mainframe Modernization managed application step input.</p>', 'refs' => [ 'M2ManagedApplicationStepSummary$stepInput' => '<p>The step input of the AWS Mainframe Modernization managed application step summary.</p>', ], ], 'M2ManagedApplicationStepOutput' => [ 'base' => '<p>Specifies the AWS Mainframe Modernization managed application step output.</p>', 'refs' => [ 'M2ManagedApplicationStepSummary$stepOutput' => '<p>The step output of the AWS Mainframe Modernization managed application step summary.</p>', ], ], 'M2ManagedApplicationStepSummary' => [ 'base' => '<p>Specifies the AWS Mainframe Modernization managed application step summary.</p>', 'refs' => [ 'ResourceActionSummary$m2ManagedApplication' => '<p>The AWS Mainframe Modernization managed application of the resource action summary.</p>', ], ], 'M2ManagedApplicationSummary' => [ 'base' => '<p>Specifies the AWS Mainframe Modernization managed application summary.</p>', 'refs' => [ 'MainframeResourceSummary$m2ManagedApplication' => '<p>The AWS Mainframe Modernization managed application in the mainframe resource summary.</p>', ], ], 'M2ManagedRuntime' => [ 'base' => NULL, 'refs' => [ 'M2ManagedApplication$runtime' => '<p>The runtime of the AWS Mainframe Modernization managed application.</p>', 'M2ManagedApplicationSummary$runtime' => '<p>The runtime of the AWS Mainframe Modernization managed application summary.</p>', ], ], 'M2NonManagedActionType' => [ 'base' => NULL, 'refs' => [ 'M2NonManagedApplicationAction$actionType' => '<p>The action type of the AWS Mainframe Modernization non-managed application action.</p>', 'M2NonManagedApplicationStepInput$actionType' => '<p>The action type of the AWS Mainframe Modernization non-managed application step input.</p>', ], ], 'M2NonManagedApplication' => [ 'base' => '<p>Specifies the AWS Mainframe Modernization non-managed application.</p>', 'refs' => [ 'ResourceType$m2NonManagedApplication' => '<p>The AWS Mainframe Modernization non-managed application of the resource type.</p>', ], ], 'M2NonManagedApplicationAction' => [ 'base' => '<p>Specifies the AWS Mainframe Modernization non-managed application action.</p>', 'refs' => [ 'ResourceAction$m2NonManagedApplicationAction' => '<p>The AWS Mainframe Modernization non-managed application action of the resource action.</p>', ], ], 'M2NonManagedApplicationStepInput' => [ 'base' => '<p>Specifies the AWS Mainframe Modernization non-managed application step input.</p>', 'refs' => [ 'M2NonManagedApplicationStepSummary$stepInput' => '<p>The step input of the AWS Mainframe Modernization non-managed application step summary.</p>', ], ], 'M2NonManagedApplicationStepOutput' => [ 'base' => '<p>Specifies the AWS Mainframe Modernization non-managed application step output.</p>', 'refs' => [ 'M2NonManagedApplicationStepSummary$stepOutput' => '<p>The step output of the AWS Mainframe Modernization non-managed application step summary.</p>', ], ], 'M2NonManagedApplicationStepSummary' => [ 'base' => '<p>Specifies the AWS Mainframe Modernization non-managed application step summary.</p>', 'refs' => [ 'ResourceActionSummary$m2NonManagedApplication' => '<p>The AWS Mainframe Modernization non-managed application of the resource action summary.</p>', ], ], 'M2NonManagedApplicationSummary' => [ 'base' => '<p>Specifies the AWS Mainframe Modernization non-managed application summary.</p>', 'refs' => [ 'MainframeResourceSummary$m2NonManagedApplication' => '<p>The AWS Mainframe Modernization non-managed application in the mainframe resource summary.</p>', ], ], 'M2NonManagedRuntime' => [ 'base' => NULL, 'refs' => [ 'M2NonManagedApplication$runtime' => '<p>The runtime of the AWS Mainframe Modernization non-managed application.</p>', 'M2NonManagedApplicationStepInput$runtime' => '<p>The runtime of the AWS Mainframe Modernization non-managed application step input.</p>', 'M2NonManagedApplicationSummary$runtime' => '<p>The runtime of the AWS Mainframe Modernization non-managed application summary.</p>', ], ], 'MainframeAction' => [ 'base' => '<p>Specifies the mainframe action.</p>', 'refs' => [ 'StepAction$mainframeAction' => '<p>The mainframe action of the step action.</p>', ], ], 'MainframeActionProperties' => [ 'base' => '<p>Specifies the mainframe action properties.</p>', 'refs' => [ 'BatchStepInput$properties' => '<p>The properties of the batch step input.</p>', 'MainframeAction$properties' => '<p>The properties of the mainframe action.</p>', 'TN3270StepInput$properties' => '<p>The properties of the TN3270 step input.</p>', ], ], 'MainframeActionSummary' => [ 'base' => '<p>Specifies the mainframe action summary.</p>', 'refs' => [ 'StepRunSummary$mainframeAction' => '<p>The mainframe action of the step run summary.</p>', ], ], 'MainframeActionType' => [ 'base' => '<p>Specifies the mainframe action type.</p>', 'refs' => [ 'MainframeAction$actionType' => '<p>The action type of the mainframe action.</p>', ], ], 'MainframeResourceSummary' => [ 'base' => '<p>Specifies the mainframe resource summary.</p>', 'refs' => [ 'BatchStepInput$resource' => '<p>The resource of the batch step input.</p>', 'TN3270StepInput$resource' => '<p>The resource of the TN3270 step input.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListTestCasesRequest$maxResults' => '<p>The maximum results of the test case.</p>', 'ListTestConfigurationsRequest$maxResults' => '<p>The maximum results of the test configuration.</p>', 'ListTestRunStepsRequest$maxResults' => '<p>The maximum number of test run steps to return in one page of results.</p>', 'ListTestRunTestCasesRequest$maxResults' => '<p>The maximum number of test run test cases to return in one page of results.</p>', 'ListTestRunsRequest$maxResults' => '<p>The maximum number of test runs to return in one page of results.</p>', 'ListTestSuitesRequest$maxResults' => '<p>The maximum number of test suites to return in one page of results.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListTestCasesRequest$nextToken' => '<p>The next token of the test cases.</p>', 'ListTestCasesResponse$nextToken' => '<p>The next token in test cases.</p>', 'ListTestConfigurationsRequest$nextToken' => '<p>The next token for the test configurations.</p>', 'ListTestConfigurationsResponse$nextToken' => '<p>The next token in the test configurations.</p>', 'ListTestRunStepsRequest$nextToken' => '<p>The token from a previous step to retrieve the next page of results.</p>', 'ListTestRunStepsResponse$nextToken' => '<p>The token from a previous request to retrieve the next page of results.</p>', 'ListTestRunTestCasesRequest$nextToken' => '<p>The token from a previous request to retrieve the next page of results.</p>', 'ListTestRunTestCasesResponse$nextToken' => '<p>The token from a previous request to retrieve the next page of results.</p>', 'ListTestRunsRequest$nextToken' => '<p>The token from the previous request to retrieve the next page of test run results.</p>', 'ListTestRunsResponse$nextToken' => '<p>The token from the previous request to retrieve the next page of results.</p>', 'ListTestSuitesRequest$nextToken' => '<p>The token from a previous request to retrieve the next page of results.</p>', 'ListTestSuitesResponse$nextToken' => '<p>The token from a previous request to retrieve the next page of test suites results.</p>', ], ], 'Output' => [ 'base' => '<p>Specifies an output.</p>', 'refs' => [ 'CompareAction$output' => '<p>The output of the compare action.</p>', ], ], 'OutputFile' => [ 'base' => '<p>Specifies an output file.</p>', 'refs' => [ 'Output$file' => '<p>The file of the output.</p>', ], ], 'Properties' => [ 'base' => NULL, 'refs' => [ 'CloudFormation$parameters' => '<p>The CloudFormation properties in the CloudFormation template.</p>', 'CreateCloudFormationStepInput$parameters' => '<p>The CloudFormation properties of the CloudFormation step input.</p>', 'CreateCloudFormationStepOutput$exports' => '<p>The exports of the CloudFormation step output.</p>', 'CreateTestConfigurationRequest$properties' => '<p>The properties of the test configuration.</p>', 'GetTestConfigurationResponse$properties' => '<p>The properties of the test configuration.</p>', 'M2ManagedApplicationStepOutput$importDataSetSummary' => '<p>The import data set summary of the AWS Mainframe Modernization managed application step output.</p>', 'UpdateTestConfigurationRequest$properties' => '<p>The properties of the test configuration.</p>', ], ], 'Resource' => [ 'base' => '<p>Specifies a resource.</p>', 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceAction' => [ 'base' => '<p>Specifies a resource action.</p>', 'refs' => [ 'StepAction$resourceAction' => '<p>The resource action of the step action.</p>', ], ], 'ResourceActionSummary' => [ 'base' => '<p>Specifies the resource action summary.</p>', 'refs' => [ 'StepRunSummary$resourceAction' => '<p>The resource action of the step run summary.</p>', ], ], 'ResourceDescription' => [ 'base' => NULL, 'refs' => [ 'CreateTestCaseRequest$description' => '<p>The description of the test case.</p>', 'CreateTestConfigurationRequest$description' => '<p>The description of the test configuration.</p>', 'CreateTestSuiteRequest$description' => '<p>The description of the test suite.</p>', 'GetTestCaseResponse$description' => '<p>The description of the test case.</p>', 'GetTestConfigurationResponse$description' => '<p>The description of the test configuration.</p>', 'GetTestSuiteResponse$description' => '<p>The description of the test suite.</p>', 'Step$description' => '<p>The description of the step.</p>', 'UpdateTestCaseRequest$description' => '<p>The description of the test case.</p>', 'UpdateTestConfigurationRequest$description' => '<p>The description of the test configuration.</p>', 'UpdateTestSuiteRequest$description' => '<p>The description of the test suite.</p>', ], ], 'ResourceList' => [ 'base' => NULL, 'refs' => [ 'CreateTestConfigurationRequest$resources' => '<p>The defined resources of the test configuration.</p>', 'GetTestConfigurationResponse$resources' => '<p>The resources of the test configuration.</p>', 'UpdateTestConfigurationRequest$resources' => '<p>The resources of the test configuration.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'BatchStepInput$batchJobName' => '<p>The batch job name of the batch step input.</p>', 'CreateTestCaseRequest$name' => '<p>The name of the test case.</p>', 'CreateTestConfigurationRequest$name' => '<p>The name of the test configuration.</p>', 'CreateTestSuiteRequest$name' => '<p>The name of the test suite.</p>', 'GetTestCaseResponse$name' => '<p>The name of the test case.</p>', 'GetTestConfigurationResponse$name' => '<p>The test configuration name</p>', 'GetTestRunStepRequest$stepName' => '<p>The step name of the test run step.</p>', 'GetTestRunStepResponse$stepName' => '<p>The step name of the test run step.</p>', 'GetTestSuiteResponse$name' => '<p>The name of the test suite.</p>', 'Resource$name' => '<p>The name of the resource.</p>', 'Step$name' => '<p>The name of the step.</p>', 'TestCaseSummary$name' => '<p>The name of the test case summary.</p>', 'TestConfigurationSummary$name' => '<p>The name of the test configuration summary.</p>', 'TestRunStepSummary$stepName' => '<p>The step name of the test run step summary.</p>', 'TestSuiteSummary$name' => '<p>The name of the test suite summary.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource was not found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => '<p>Specifies the resource type.</p>', 'refs' => [ 'Resource$type' => '<p>The type of the resource.</p>', ], ], 'S3Uri' => [ 'base' => NULL, 'refs' => [ 'BatchStepOutput$dataSetExportLocation' => '<p>The data set export location of the batch step output.</p>', 'BatchStepOutput$dmsOutputLocation' => '<p>The Database Migration Service (DMS) output location of the batch step output.</p>', 'CloudFormation$templateLocation' => '<p>The template location of the CloudFormation template.</p>', 'CompareDataSetsStepInput$sourceLocation' => '<p>The source location of the compare data sets step input location.</p>', 'CompareDataSetsStepInput$targetLocation' => '<p>The target location of the compare data sets step input location.</p>', 'CompareDataSetsStepOutput$comparisonOutputLocation' => '<p>The comparison output location of the compare data sets step output.</p>', 'CreateCloudFormationStepInput$templateLocation' => '<p>The template location of the CloudFormation step input.</p>', 'OutputFile$fileLocation' => '<p>The file location of the output file.</p>', 'Script$scriptLocation' => '<p>The script location of the scripts.</p>', 'ScriptSummary$scriptLocation' => '<p>The script location of the script summary.</p>', 'TN3270StepOutput$dataSetExportLocation' => '<p>The data set export location of the TN3270 step output.</p>', 'TN3270StepOutput$dmsOutputLocation' => '<p>The output location of the TN3270 step output.</p>', 'TN3270StepOutput$scriptOutputLocation' => '<p>The script output location of the TN3270 step output.</p>', ], ], 'Script' => [ 'base' => '<p>Specifies the script.</p>', 'refs' => [ 'TN3270$script' => '<p>The script of the TN3270 protocol.</p>', ], ], 'ScriptSummary' => [ 'base' => '<p>Specifies the scripts summary.</p>', 'refs' => [ 'TN3270StepInput$script' => '<p>The script of the TN3270 step input.</p>', ], ], 'ScriptType' => [ 'base' => NULL, 'refs' => [ 'Script$type' => '<p>The type of the scripts.</p>', 'ScriptSummary$type' => '<p>The type of the script summary.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>One or more quotas for AWS Application Testing exceeds the limit.</p>', 'refs' => [], ], 'ServiceSettings' => [ 'base' => '<p>Specifies the service settings.</p>', 'refs' => [ 'CreateTestConfigurationRequest$serviceSettings' => '<p>The service settings of the test configuration.</p>', 'GetTestConfigurationResponse$serviceSettings' => '<p>The service settings of the test configuration.</p>', 'UpdateTestConfigurationRequest$serviceSettings' => '<p>The service settings of the test configuration.</p>', ], ], 'SourceDatabase' => [ 'base' => NULL, 'refs' => [ 'SourceDatabaseMetadata$type' => '<p>The type of the source database metadata.</p>', ], ], 'SourceDatabaseMetadata' => [ 'base' => '<p>Specifies the source database metadata.</p>', 'refs' => [ 'CompareDatabaseCDCStepInput$sourceMetadata' => '<p>The source metadata of the compare database CDC step input.</p>', 'DatabaseCDC$sourceMetadata' => '<p>The source metadata of the database CDC.</p>', ], ], 'StartTestRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTestRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'Step' => [ 'base' => '<p>Defines a step.</p>', 'refs' => [ 'StepList$member' => NULL, ], ], 'StepAction' => [ 'base' => '<p>Specifies a step action.</p>', 'refs' => [ 'Step$action' => '<p>The action of the step.</p>', ], ], 'StepList' => [ 'base' => NULL, 'refs' => [ 'CreateTestCaseRequest$steps' => '<p>The steps in the test case.</p>', 'CreateTestSuiteRequest$beforeSteps' => '<p>The before steps of the test suite.</p>', 'CreateTestSuiteRequest$afterSteps' => '<p>The after steps of the test suite.</p>', 'GetTestCaseResponse$steps' => '<p>The steps of the test case.</p>', 'GetTestSuiteResponse$beforeSteps' => '<p>The before steps of the test suite.</p>', 'GetTestSuiteResponse$afterSteps' => '<p>The after steps of the test suite. </p>', 'UpdateTestCaseRequest$steps' => '<p>The steps of the test case.</p>', 'UpdateTestSuiteRequest$beforeSteps' => '<p>The before steps for the test suite.</p>', 'UpdateTestSuiteRequest$afterSteps' => '<p>The after steps of the test suite.</p>', ], ], 'StepRunStatus' => [ 'base' => NULL, 'refs' => [ 'GetTestRunStepResponse$status' => '<p>The status of the test run step.</p>', 'TestRunStepSummary$status' => '<p>The status of the test run step summary.</p>', ], ], 'StepRunSummary' => [ 'base' => '<p>Defines the step run summary.</p>', 'refs' => [ 'GetTestRunStepResponse$stepRunSummary' => '<p>The step run summary of the test run step.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'BatchJobParameters$key' => NULL, 'BatchJobParameters$value' => NULL, 'CompareDatabaseCDCStepInput$sourceLocation' => '<p>The source location of the compare database CDC step input.</p>', 'CompareDatabaseCDCStepInput$targetLocation' => '<p>The target location of the compare database CDC step input.</p>', 'CompareDatabaseCDCStepInput$outputLocation' => '<p>The output location of the compare database CDC step input.</p>', 'CompareDatabaseCDCStepOutput$comparisonOutputLocation' => '<p>The comparison output of the compare database CDC step output.</p>', 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The resource ID of the conflicts with existing resources.</p>', 'ConflictException$resourceType' => '<p>The resource type of the conflicts with existing resources.</p>', 'CreateCloudFormationStepOutput$stackId' => '<p>The stack ID of the CloudFormation step output.</p>', 'DeleteCloudFormationStepInput$stackId' => '<p>The stack ID of the deleted CloudFormation step input.</p>', 'GetTestCaseResponse$statusReason' => '<p>The status reason of the test case.</p>', 'GetTestConfigurationResponse$statusReason' => '<p>The status reason of the test configuration.</p>', 'GetTestRunStepResponse$statusReason' => '<p>The status reason of the test run step.</p>', 'GetTestSuiteResponse$statusReason' => '<p>The status reason of the test suite.</p>', 'InternalServerException$message' => NULL, 'M2ManagedApplicationStepInput$applicationId' => '<p>The application ID of the AWS Mainframe Modernization managed application step input.</p>', 'M2ManagedApplicationStepInput$runtime' => '<p>The runtime of the AWS Mainframe Modernization managed application step input.</p>', 'M2ManagedApplicationStepInput$vpcEndpointServiceName' => '<p>The VPC endpoint service name of the AWS Mainframe Modernization managed application step input.</p>', 'M2NonManagedApplicationStepInput$vpcEndpointServiceName' => '<p>The VPC endpoint service name of the AWS Mainframe Modernization non-managed application step input.</p>', 'M2NonManagedApplicationStepInput$webAppName' => '<p>The web app name of the AWS Mainframe Modernization non-managed application step input.</p>', 'M2NonManagedApplicationSummary$vpcEndpointServiceName' => '<p>The VPC endpoint service name of the AWS Mainframe Modernization non-managed application summary.</p>', 'M2NonManagedApplicationSummary$webAppName' => '<p>The web application name of the AWS Mainframe Modernization non-managed application summary.</p>', 'Properties$key' => NULL, 'Properties$value' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>The resource ID of the resource not found.</p>', 'ResourceNotFoundException$resourceType' => '<p>The resource type of the resource not found.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$resourceId' => '<p>The resource ID of AWS Application Testing that exceeded the limit.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The resource type of AWS Application Testing that exceeded the limit.</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>The service code of AWS Application Testing that exceeded the limit.</p>', 'ServiceQuotaExceededException$quotaCode' => '<p>The quote codes of AWS Application Testing that exceeded the limit.</p>', 'ServiceSettings$kmsKeyId' => '<p>The KMS key ID of the service settings.</p>', 'TestCaseLatestVersion$statusReason' => '<p>The status reason of the test case latest version.</p>', 'TestCaseRunSummary$statusReason' => '<p>The status reason of the test case run summary.</p>', 'TestCaseSummary$statusReason' => '<p>The status reason of the test case summary.</p>', 'TestConfigurationLatestVersion$statusReason' => '<p>The status reason of the test configuration latest version.</p>', 'TestConfigurationSummary$statusReason' => '<p>The status reason of the test configuration summary.</p>', 'TestRunStepSummary$statusReason' => '<p>The status reason of the test run step summary.</p>', 'TestRunSummary$statusReason' => '<p>The status reason of the test run summary.</p>', 'TestSuiteLatestVersion$statusReason' => '<p>The status reason of the test suite latest version.</p>', 'TestSuiteSummary$statusReason' => '<p>The status reason of the test suite summary.</p>', 'ThrottlingException$message' => NULL, 'ThrottlingException$serviceCode' => '<p>The service code of requests that exceed the limit.</p>', 'ThrottlingException$quotaCode' => '<p>The quota code of requests that exceed the limit.</p>', 'ValidationException$message' => NULL, 'ValidationExceptionField$name' => '<p>The name of the validation exception field.</p>', 'ValidationExceptionField$message' => '<p>The message stating reason for why service validation failed.</p>', ], ], 'String100' => [ 'base' => NULL, 'refs' => [ 'DataSet$name' => '<p>The name of the data set.</p>', 'ExportDataSetNames$member' => NULL, ], ], 'String50' => [ 'base' => NULL, 'refs' => [ 'DataSet$ccsid' => '<p>The CCSID of the data set.</p>', ], ], 'TN3270' => [ 'base' => '<p>Specifies the TN3270 protocol.</p>', 'refs' => [ 'MainframeActionType$tn3270' => '<p>The tn3270 port of the mainframe action type.</p>', ], ], 'TN3270StepInput' => [ 'base' => '<p>Specifies a TN3270 step input.</p>', 'refs' => [ 'TN3270Summary$stepInput' => '<p>The step input of the TN3270 summary.</p>', ], ], 'TN3270StepOutput' => [ 'base' => '<p>Specifies a TN3270 step output.</p>', 'refs' => [ 'TN3270Summary$stepOutput' => '<p>The step output of the TN3270 summary.</p>', ], ], 'TN3270Summary' => [ 'base' => '<p>Specifies a TN3270 summary.</p>', 'refs' => [ 'MainframeActionSummary$tn3270' => '<p>The tn3270 port of the mainframe action summary.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys of the resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateTestCaseRequest$tags' => '<p>The specified tags of the test case.</p>', 'CreateTestConfigurationRequest$tags' => '<p>The tags of the test configuration.</p>', 'CreateTestSuiteRequest$tags' => '<p>The tags of the test suite.</p>', 'GetTestCaseResponse$tags' => '<p>The tags of the test case.</p>', 'GetTestConfigurationResponse$tags' => '<p>The tags of the test configuration.</p>', 'GetTestSuiteResponse$tags' => '<p>The tags of the test suite.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags of the resource.</p>', 'StartTestRunRequest$tags' => '<p>The tags of the test run.</p>', 'TagResourceRequest$tags' => '<p>The tags of the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TargetDatabase' => [ 'base' => NULL, 'refs' => [ 'TargetDatabaseMetadata$type' => '<p>The type of the target database metadata.</p>', ], ], 'TargetDatabaseMetadata' => [ 'base' => '<p>Specifies a target database metadata.</p>', 'refs' => [ 'CompareDatabaseCDCStepInput$targetMetadata' => '<p>The target metadata location of the compare database CDC step input.</p>', 'DatabaseCDC$targetMetadata' => '<p>The target metadata of the database CDC.</p>', ], ], 'TestCaseIdList' => [ 'base' => NULL, 'refs' => [ 'ListTestCasesRequest$testCaseIds' => '<p>The IDs of the test cases.</p>', ], ], 'TestCaseLatestVersion' => [ 'base' => '<p>Specifies the latest version of a test case.</p>', 'refs' => [ 'GetTestCaseResponse$latestVersion' => '<p>The latest version of the test case.</p>', ], ], 'TestCaseLifecycle' => [ 'base' => NULL, 'refs' => [ 'GetTestCaseResponse$status' => '<p>The status of the test case.</p>', 'TestCaseLatestVersion$status' => '<p>The status of the test case latest version.</p>', 'TestCaseSummary$status' => '<p>The status of the test case summary.</p>', ], ], 'TestCaseList' => [ 'base' => NULL, 'refs' => [ 'TestCases$sequential' => '<p>The sequential of the test case.</p>', ], ], 'TestCaseRunStatus' => [ 'base' => NULL, 'refs' => [ 'TestCaseRunSummary$status' => '<p>The status of the test case run summary.</p>', ], ], 'TestCaseRunSummary' => [ 'base' => '<p>Specifies the test case run summary.</p>', 'refs' => [ 'TestCaseRunSummaryList$member' => NULL, ], ], 'TestCaseRunSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTestRunTestCasesResponse$testRunTestCases' => '<p>The test run of the test cases.</p>', ], ], 'TestCaseSummary' => [ 'base' => '<p>Specifies a test case summary.</p>', 'refs' => [ 'TestCaseSummaryList$member' => NULL, ], ], 'TestCaseSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTestCasesResponse$testCases' => '<p>The test cases in an application.</p>', ], ], 'TestCases' => [ 'base' => '<p>Specifies test cases.</p>', 'refs' => [ 'CreateTestSuiteRequest$testCases' => '<p>The test cases in the test suite.</p>', 'GetTestSuiteResponse$testCases' => '<p>The test cases of the test suite.</p>', 'UpdateTestSuiteRequest$testCases' => '<p>The test cases in the test suite.</p>', ], ], 'TestConfigurationIdList' => [ 'base' => NULL, 'refs' => [ 'ListTestConfigurationsRequest$testConfigurationIds' => '<p>The configuration IDs of the test configurations.</p>', ], ], 'TestConfigurationLatestVersion' => [ 'base' => '<p>Specifies the latest version of the test configuration.</p>', 'refs' => [ 'GetTestConfigurationResponse$latestVersion' => '<p>The latest version of the test configuration.</p>', ], ], 'TestConfigurationLifecycle' => [ 'base' => NULL, 'refs' => [ 'GetTestConfigurationResponse$status' => '<p>The status of the test configuration.</p>', 'TestConfigurationLatestVersion$status' => '<p>The status of the test configuration latest version.</p>', 'TestConfigurationSummary$status' => '<p>The status of the test configuration summary.</p>', ], ], 'TestConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListTestConfigurationsResponse$testConfigurations' => '<p>The test configurations.</p>', ], ], 'TestConfigurationSummary' => [ 'base' => '<p>Specifies a test configuration summary.</p>', 'refs' => [ 'TestConfigurationList$member' => NULL, ], ], 'TestRunIdList' => [ 'base' => NULL, 'refs' => [ 'ListTestRunsRequest$testRunIds' => '<p>The test run IDs of the test runs.</p>', ], ], 'TestRunStatus' => [ 'base' => NULL, 'refs' => [ 'StartTestRunResponse$testRunStatus' => '<p>The test run status of the test run.</p>', 'TestRunSummary$status' => '<p>The status of the test run summary.</p>', ], ], 'TestRunStepSummary' => [ 'base' => '<p>Specifies a test run step summary.</p>', 'refs' => [ 'TestRunStepSummaryList$member' => NULL, ], ], 'TestRunStepSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTestRunStepsResponse$testRunSteps' => '<p>The test run steps of the response query.</p>', ], ], 'TestRunSummary' => [ 'base' => '<p>Specifies a test run summary.</p>', 'refs' => [ 'TestRunSummaryList$member' => NULL, ], ], 'TestRunSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTestRunsResponse$testRuns' => '<p>The test runs of the response query.</p>', ], ], 'TestSuiteIdList' => [ 'base' => NULL, 'refs' => [ 'ListTestSuitesRequest$testSuiteIds' => '<p>The suite ID of the test suites.</p>', ], ], 'TestSuiteLatestVersion' => [ 'base' => '<p>Specifies the latest version of a test suite.</p>', 'refs' => [ 'GetTestSuiteResponse$latestVersion' => '<p>The latest version of the test suite.</p>', ], ], 'TestSuiteLifecycle' => [ 'base' => NULL, 'refs' => [ 'GetTestSuiteResponse$status' => '<p>The status of the test suite.</p>', 'TestSuiteLatestVersion$status' => '<p>The status of the test suite latest version.</p>', 'TestSuiteSummary$status' => '<p>The status of the test suite summary.</p>', ], ], 'TestSuiteList' => [ 'base' => NULL, 'refs' => [ 'ListTestSuitesResponse$testSuites' => '<p>The test suites returned with the response query.</p>', ], ], 'TestSuiteSummary' => [ 'base' => '<p>Specifies the test suite summary.</p>', 'refs' => [ 'TestSuiteList$member' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The number of requests made exceeds the limit.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'GetTestCaseResponse$creationTime' => '<p>The creation time of the test case.</p>', 'GetTestCaseResponse$lastUpdateTime' => '<p>The last update time of the test case.</p>', 'GetTestConfigurationResponse$creationTime' => '<p>The creation time of the test configuration.</p>', 'GetTestConfigurationResponse$lastUpdateTime' => '<p>The last update time of the test configuration.</p>', 'GetTestRunStepResponse$runStartTime' => '<p>The run start time of the test run step.</p>', 'GetTestRunStepResponse$runEndTime' => '<p>The run end time of the test run step.</p>', 'GetTestSuiteResponse$creationTime' => '<p>The creation time of the test suite.</p>', 'GetTestSuiteResponse$lastUpdateTime' => '<p>The last update time of the test suite.</p>', 'TestCaseRunSummary$runStartTime' => '<p>The run start time of the test case run summary.</p>', 'TestCaseRunSummary$runEndTime' => '<p>The run end time of the test case run summary.</p>', 'TestCaseSummary$creationTime' => '<p>The creation time of the test case summary.</p>', 'TestCaseSummary$lastUpdateTime' => '<p>The last update time of the test case summary.</p>', 'TestConfigurationSummary$creationTime' => '<p>The creation time of the test configuration summary.</p>', 'TestConfigurationSummary$lastUpdateTime' => '<p>The last update time of the test configuration summary.</p>', 'TestRunStepSummary$runStartTime' => '<p>The run start time of the test run step summary.</p>', 'TestRunStepSummary$runEndTime' => '<p>The run end time of the test run step summary.</p>', 'TestRunSummary$runStartTime' => '<p>The run start time of the test run summary.</p>', 'TestRunSummary$runEndTime' => '<p>The run end time of the test run summary.</p>', 'TestSuiteSummary$creationTime' => '<p>The creation time of the test suite summary.</p>', 'TestSuiteSummary$lastUpdateTime' => '<p>The last update time of the test suite summary.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTestCaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTestCaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTestConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTestConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTestSuiteRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTestSuiteResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>One or more parameter provided in the request is not valid.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Specifies a validation exception field.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>The field list of the validation exception.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason for the validation exception.</p>', ], ], 'Variable' => [ 'base' => NULL, 'refs' => [ 'Batch$batchJobName' => '<p>The job name of the batch.</p>', 'CloudFormationAction$resource' => '<p>The resource of the CloudFormation action.</p>', 'InputFile$sourceLocation' => '<p>The source location of the input file.</p>', 'InputFile$targetLocation' => '<p>The target location of the input file.</p>', 'M2ManagedActionProperties$importDataSetLocation' => '<p>The import data set location of the AWS Mainframe Modernization managed action properties.</p>', 'M2ManagedApplication$applicationId' => '<p>The application ID of the AWS Mainframe Modernization managed application.</p>', 'M2ManagedApplication$vpcEndpointServiceName' => '<p>The VPC endpoint service name of the AWS Mainframe Modernization managed application.</p>', 'M2ManagedApplication$listenerPort' => '<p>The listener port of the AWS Mainframe Modernization managed application.</p>', 'M2ManagedApplicationAction$resource' => '<p>The resource of the AWS Mainframe Modernization managed application action.</p>', 'M2NonManagedApplication$vpcEndpointServiceName' => '<p>The VPC endpoint service name of the AWS Mainframe Modernization non-managed application.</p>', 'M2NonManagedApplication$listenerPort' => '<p>The listener port of the AWS Mainframe Modernization non-managed application.</p>', 'M2NonManagedApplication$webAppName' => '<p>The web application name of the AWS Mainframe Modernization non-managed application.</p>', 'M2NonManagedApplicationAction$resource' => '<p>The resource of the AWS Mainframe Modernization non-managed application action.</p>', 'MainframeAction$resource' => '<p>The resource of the mainframe action.</p>', 'MainframeActionProperties$dmsTaskArn' => '<p>The DMS task ARN of the mainframe action properties.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'CreateTestCaseResponse$testCaseVersion' => '<p>The test case version of the test case.</p>', 'CreateTestConfigurationResponse$testConfigurationVersion' => '<p>The test configuration version.</p>', 'CreateTestSuiteResponse$testSuiteVersion' => '<p>The suite version of the test suite.</p>', 'GetTestCaseRequest$testCaseVersion' => '<p>The test case version of the test case.</p>', 'GetTestCaseResponse$testCaseVersion' => '<p>The case version of the test case.</p>', 'GetTestConfigurationRequest$testConfigurationVersion' => '<p>The test configuration version.</p>', 'GetTestConfigurationResponse$testConfigurationVersion' => '<p>The test configuration version.</p>', 'GetTestRunStepResponse$testCaseVersion' => '<p>The test case version of the test run step.</p>', 'GetTestRunStepResponse$testSuiteVersion' => '<p>The test suite version of the test run step.</p>', 'GetTestSuiteRequest$testSuiteVersion' => '<p>The version of the test suite.</p>', 'GetTestSuiteResponse$testSuiteVersion' => '<p>The version of the test suite.</p>', 'TestCaseLatestVersion$version' => '<p>The version of the test case latest version.</p>', 'TestCaseRunSummary$testCaseVersion' => '<p>The test case version of the test case run summary.</p>', 'TestCaseSummary$latestVersion' => '<p>The latest version of the test case summary.</p>', 'TestConfigurationLatestVersion$version' => '<p>The version of the test configuration latest version.</p>', 'TestConfigurationSummary$latestVersion' => '<p>The latest version of the test configuration summary.</p>', 'TestRunStepSummary$testCaseVersion' => '<p>The test case version of the test run step summary.</p>', 'TestRunStepSummary$testSuiteVersion' => '<p>The test suite version of the test run step summary.</p>', 'TestRunSummary$testSuiteVersion' => '<p>The test suite version of the test run summary.</p>', 'TestRunSummary$testConfigurationVersion' => '<p>The test configuration version of the test run summary.</p>', 'TestSuiteLatestVersion$version' => '<p>The version of the test suite latest version.</p>', 'TestSuiteSummary$latestVersion' => '<p>The latest version of the test suite summary.</p>', 'UpdateTestCaseResponse$testCaseVersion' => '<p>The test case version of the test case.</p>', 'UpdateTestConfigurationResponse$testConfigurationVersion' => '<p>The configuration version of the test configuration.</p>', 'UpdateTestSuiteResponse$testSuiteVersion' => '<p>The test suite version of the test suite.</p>', ], ], ],];
