<?php
// This file was auto-generated from sdk-root/src/data/athena/2017-05-18/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Athena is an interactive query service that lets you use standard SQL to analyze data directly in Amazon S3. You can point Athena at your data in Amazon S3 and run ad-hoc queries and get results in seconds. Athena is serverless, so there is no infrastructure to set up or manage. You pay only for the queries you run. Athena scales automatically—executing queries in parallel—so results are fast, even with large datasets and complex queries. For more information, see <a href="http://docs.aws.amazon.com/athena/latest/ug/what-is.html">What is Amazon Athena</a> in the <i>Amazon Athena User Guide</i>.</p> <p>If you connect to Athena using the JDBC driver, use version 1.1.0 of the driver or later with the Amazon Athena API. Earlier version drivers do not support the API. For more information and to download the driver, see <a href="https://docs.aws.amazon.com/athena/latest/ug/connect-with-jdbc.html">Accessing Amazon Athena with JDBC</a>.</p>', 'operations' => [ 'BatchGetNamedQuery' => '<p>Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query ID strings. Requires you to have access to the workgroup in which the queries were saved. Use <a>ListNamedQueriesInput</a> to get the list of named query IDs in the specified workgroup. If information could not be retrieved for a submitted query ID, information about the query ID submitted is listed under <a>UnprocessedNamedQueryId</a>. Named queries differ from executed queries. Use <a>BatchGetQueryExecutionInput</a> to get details about each unique query execution, and <a>ListQueryExecutionsInput</a> to get a list of query execution IDs.</p>', 'BatchGetPreparedStatement' => '<p>Returns the details of a single prepared statement or a list of up to 256 prepared statements for the array of prepared statement names that you provide. Requires you to have access to the workgroup to which the prepared statements belong. If a prepared statement cannot be retrieved for the name specified, the statement is listed in <code>UnprocessedPreparedStatementNames</code>.</p>', 'BatchGetQueryExecution' => '<p>Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an array of query execution ID strings. Requires you to have access to the workgroup in which the queries ran. To get a list of query execution IDs, use <a>ListQueryExecutionsInput$WorkGroup</a>. Query executions differ from named (saved) queries. Use <a>BatchGetNamedQueryInput</a> to get details about named queries.</p>', 'CancelCapacityReservation' => '<p>Cancels the capacity reservation with the specified name. Cancelled reservations remain in your account and will be deleted 45 days after cancellation. During the 45 days, you cannot re-purpose or reuse a reservation that has been cancelled, but you can refer to its tags and view it for historical reference. </p>', 'CreateCapacityReservation' => '<p>Creates a capacity reservation with the specified name and number of requested data processing units.</p>', 'CreateDataCatalog' => '<p>Creates (registers) a data catalog with the specified name and properties. Catalogs created are visible to all users of the same Amazon Web Services account.</p>', 'CreateNamedQuery' => '<p>Creates a named query in the specified workgroup. Requires that you have access to the workgroup.</p>', 'CreateNotebook' => '<p>Creates an empty <code>ipynb</code> file in the specified Apache Spark enabled workgroup. Throws an error if a file in the workgroup with the same name already exists.</p>', 'CreatePreparedStatement' => '<p>Creates a prepared statement for use with SQL queries in Athena.</p>', 'CreatePresignedNotebookUrl' => '<p>Gets an authentication token and the URL at which the notebook can be accessed. During programmatic access, <code>CreatePresignedNotebookUrl</code> must be called every 10 minutes to refresh the authentication token. For information about granting programmatic access, see <a href="https://docs.aws.amazon.com/athena/latest/ug/setting-up.html#setting-up-grant-programmatic-access">Grant programmatic access</a>.</p>', 'CreateWorkGroup' => '<p>Creates a workgroup with the specified name. A workgroup can be an Apache Spark enabled workgroup or an Athena SQL workgroup.</p>', 'DeleteCapacityReservation' => '<p>Deletes a cancelled capacity reservation. A reservation must be cancelled before it can be deleted. A deleted reservation is immediately removed from your account and can no longer be referenced, including by its ARN. A deleted reservation cannot be called by <code>GetCapacityReservation</code>, and deleted reservations do not appear in the output of <code>ListCapacityReservations</code>.</p>', 'DeleteDataCatalog' => '<p>Deletes a data catalog.</p>', 'DeleteNamedQuery' => '<p>Deletes the named query if you have access to the workgroup in which the query was saved.</p>', 'DeleteNotebook' => '<p>Deletes the specified notebook.</p>', 'DeletePreparedStatement' => '<p>Deletes the prepared statement with the specified name from the specified workgroup.</p>', 'DeleteWorkGroup' => '<p>Deletes the workgroup with the specified name. The primary workgroup cannot be deleted.</p>', 'ExportNotebook' => '<p>Exports the specified notebook and its metadata.</p>', 'GetCalculationExecution' => '<p>Describes a previously submitted calculation execution.</p>', 'GetCalculationExecutionCode' => '<p>Retrieves the unencrypted code that was executed for the calculation.</p>', 'GetCalculationExecutionStatus' => '<p>Gets the status of a current calculation.</p>', 'GetCapacityAssignmentConfiguration' => '<p>Gets the capacity assignment configuration for a capacity reservation, if one exists.</p>', 'GetCapacityReservation' => '<p>Returns information about the capacity reservation with the specified name.</p>', 'GetDataCatalog' => '<p>Returns the specified data catalog.</p>', 'GetDatabase' => '<p>Returns a database object for the specified database and data catalog.</p>', 'GetNamedQuery' => '<p>Returns information about a single query. Requires that you have access to the workgroup in which the query was saved.</p>', 'GetNotebookMetadata' => '<p>Retrieves notebook metadata for the specified notebook ID.</p>', 'GetPreparedStatement' => '<p>Retrieves the prepared statement with the specified name from the specified workgroup.</p>', 'GetQueryExecution' => '<p>Returns information about a single execution of a query if you have access to the workgroup in which the query ran. Each time a query executes, information about the query execution is saved with a unique ID.</p>', 'GetQueryResults' => '<p>Streams the results of a single query execution specified by <code>QueryExecutionId</code> from the Athena query results location in Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with query results, recent queries, and output files</a> in the <i>Amazon Athena User Guide</i>. This request does not execute the query but returns results. Use <a>StartQueryExecution</a> to run a query.</p> <p>To stream query results successfully, the IAM principal with permission to call <code>GetQueryResults</code> also must have permissions to the Amazon S3 <code>GetObject</code> action for the Athena query results location.</p> <important> <p>IAM principals with permission to the Amazon S3 <code>GetObject</code> action for the query results location are able to retrieve query results from Amazon S3 even if permission to the <code>GetQueryResults</code> action is denied. To restrict user or role access, ensure that Amazon S3 permissions to the Athena query location are denied.</p> </important>', 'GetQueryRuntimeStatistics' => '<p>Returns query execution runtime statistics related to a single execution of a query if you have access to the workgroup in which the query ran. Statistics from the <code>Timeline</code> section of the response object are available as soon as <a>QueryExecutionStatus$State</a> is in a SUCCEEDED or FAILED state. The remaining non-timeline statistics in the response (like stage-level input and output row count and data size) are updated asynchronously and may not be available immediately after a query completes. The non-timeline statistics are also not included when a query has row-level filters defined in Lake Formation.</p>', 'GetSession' => '<p>Gets the full details of a previously created session, including the session status and configuration.</p>', 'GetSessionStatus' => '<p>Gets the current status of a session.</p>', 'GetTableMetadata' => '<p>Returns table metadata for the specified catalog, database, and table.</p>', 'GetWorkGroup' => '<p>Returns information about the workgroup with the specified name.</p>', 'ImportNotebook' => '<p>Imports a single <code>ipynb</code> file to a Spark enabled workgroup. To import the notebook, the request must specify a value for either <code>Payload</code> or <code>NoteBookS3LocationUri</code>. If neither is specified or both are specified, an <code>InvalidRequestException</code> occurs. The maximum file size that can be imported is 10 megabytes. If an <code>ipynb</code> file with the same name already exists in the workgroup, throws an error.</p>', 'ListApplicationDPUSizes' => '<p>Returns the supported DPU sizes for the supported application runtimes (for example, <code>Athena notebook version 1</code>). </p>', 'ListCalculationExecutions' => '<p>Lists the calculations that have been submitted to a session in descending order. Newer calculations are listed first; older calculations are listed later.</p>', 'ListCapacityReservations' => '<p>Lists the capacity reservations for the current account.</p>', 'ListDataCatalogs' => '<p>Lists the data catalogs in the current Amazon Web Services account.</p> <note> <p>In the Athena console, data catalogs are listed as "data sources" on the <b>Data sources</b> page under the <b>Data source name</b> column.</p> </note>', 'ListDatabases' => '<p>Lists the databases in the specified data catalog.</p>', 'ListEngineVersions' => '<p>Returns a list of engine versions that are available to choose from, including the Auto option.</p>', 'ListExecutors' => '<p>Lists, in descending order, the executors that joined a session. Newer executors are listed first; older executors are listed later. The result can be optionally filtered by state.</p>', 'ListNamedQueries' => '<p>Provides a list of available query IDs only for queries saved in the specified workgroup. Requires that you have access to the specified workgroup. If a workgroup is not specified, lists the saved queries for the primary workgroup.</p>', 'ListNotebookMetadata' => '<p>Displays the notebook files for the specified workgroup in paginated format.</p>', 'ListNotebookSessions' => '<p>Lists, in descending order, the sessions that have been created in a notebook that are in an active state like <code>CREATING</code>, <code>CREATED</code>, <code>IDLE</code> or <code>BUSY</code>. Newer sessions are listed first; older sessions are listed later.</p>', 'ListPreparedStatements' => '<p>Lists the prepared statements in the specified workgroup.</p>', 'ListQueryExecutions' => '<p>Provides a list of available query execution IDs for the queries in the specified workgroup. Athena keeps a query history for 45 days. If a workgroup is not specified, returns a list of query execution IDs for the primary workgroup. Requires you to have access to the workgroup in which the queries ran.</p>', 'ListSessions' => '<p>Lists the sessions in a workgroup that are in an active state like <code>CREATING</code>, <code>CREATED</code>, <code>IDLE</code>, or <code>BUSY</code>. Newer sessions are listed first; older sessions are listed later.</p>', 'ListTableMetadata' => '<p>Lists the metadata for the tables in the specified data catalog database.</p>', 'ListTagsForResource' => '<p>Lists the tags associated with an Athena resource.</p>', 'ListWorkGroups' => '<p>Lists available workgroups for the account.</p>', 'PutCapacityAssignmentConfiguration' => '<p>Puts a new capacity assignment configuration for a specified capacity reservation. If a capacity assignment configuration already exists for the capacity reservation, replaces the existing capacity assignment configuration.</p>', 'StartCalculationExecution' => '<p>Submits calculations for execution within a session. You can supply the code to run as an inline code block within the request.</p> <note> <p>The request syntax requires the <a>StartCalculationExecutionRequest$CodeBlock</a> parameter or the <a>CalculationConfiguration$CodeBlock</a> parameter, but not both. Because <a>CalculationConfiguration$CodeBlock</a> is deprecated, use the <a>StartCalculationExecutionRequest$CodeBlock</a> parameter instead.</p> </note>', 'StartQueryExecution' => '<p>Runs the SQL query statements contained in the <code>Query</code>. Requires you to have access to the workgroup in which the query ran. Running queries against an external catalog requires <a>GetDataCatalog</a> permission to the catalog. For code samples using the Amazon Web Services SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the <i>Amazon Athena User Guide</i>.</p>', 'StartSession' => '<p>Creates a session for running calculations within a workgroup. The session is ready when it reaches an <code>IDLE</code> state.</p>', 'StopCalculationExecution' => '<p>Requests the cancellation of a calculation. A <code>StopCalculationExecution</code> call on a calculation that is already in a terminal state (for example, <code>STOPPED</code>, <code>FAILED</code>, or <code>COMPLETED</code>) succeeds but has no effect.</p> <note> <p>Cancelling a calculation is done on a best effort basis. If a calculation cannot be cancelled, you can be charged for its completion. If you are concerned about being charged for a calculation that cannot be cancelled, consider terminating the session in which the calculation is running.</p> </note>', 'StopQueryExecution' => '<p>Stops a query execution. Requires you to have access to the workgroup in which the query ran.</p>', 'TagResource' => '<p>Adds one or more tags to an Athena resource. A tag is a label that you assign to a resource. Each tag consists of a key and an optional value, both of which you define. For example, you can use tags to categorize Athena workgroups, data catalogs, or capacity reservations by purpose, owner, or environment. Use a consistent set of tag keys to make it easier to search and filter the resources in your account. For best practices, see <a href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html">Tagging Best Practices</a>. Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256 UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify more than one tag, separate them by commas.</p>', 'TerminateSession' => '<p>Terminates an active session. A <code>TerminateSession</code> call on a session that is already inactive (for example, in a <code>FAILED</code>, <code>TERMINATED</code> or <code>TERMINATING</code> state) succeeds but has no effect. Calculations running in the session when <code>TerminateSession</code> is called are forcefully stopped, but may display as <code>FAILED</code> instead of <code>STOPPED</code>.</p>', 'UntagResource' => '<p>Removes one or more tags from an Athena resource.</p>', 'UpdateCapacityReservation' => '<p>Updates the number of requested data processing units for the capacity reservation with the specified name.</p>', 'UpdateDataCatalog' => '<p>Updates the data catalog that has the specified name.</p>', 'UpdateNamedQuery' => '<p>Updates a <a>NamedQuery</a> object. The database or workgroup cannot be updated.</p>', 'UpdateNotebook' => '<p>Updates the contents of a Spark notebook.</p>', 'UpdateNotebookMetadata' => '<p>Updates the metadata for a notebook.</p>', 'UpdatePreparedStatement' => '<p>Updates a prepared statement.</p>', 'UpdateWorkGroup' => '<p>Updates the workgroup with the specified name. The workgroup\'s name cannot be changed. Only <code>ConfigurationUpdates</code> can be specified.</p>', ], 'shapes' => [ 'AclConfiguration' => [ 'base' => '<p>Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results. When Athena stores query results in Amazon S3, the canned ACL is set with the <code>x-amz-acl</code> request header. For more information about S3 Object Ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html#object-ownership-overview">Object Ownership settings</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'ResultConfiguration$AclConfiguration' => '<p>Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results. Currently the only supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code>. This is a client-side setting. If workgroup settings override client-side settings, then the query uses the ACL configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. For more information, see <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>', 'ResultConfigurationUpdates$AclConfiguration' => '<p>The ACL configuration for the query results.</p>', ], ], 'Age' => [ 'base' => NULL, 'refs' => [ 'ResultReuseByAgeConfiguration$MaxAgeInMinutes' => '<p>Specifies, in minutes, the maximum age of a previous query result that Athena should consider for reuse. The default is 60.</p>', ], ], 'AllocatedDpusInteger' => [ 'base' => NULL, 'refs' => [ 'CapacityReservation$AllocatedDpus' => '<p>The number of data processing units currently allocated.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceInput$ResourceARN' => '<p>Lists the tags for the resource with the specified ARN.</p>', 'ResourceNotFoundException$ResourceName' => '<p>The name of the Amazon resource.</p>', 'TagResourceInput$ResourceARN' => '<p>Specifies the ARN of the Athena resource to which tags are to be added.</p>', 'UntagResourceInput$ResourceARN' => '<p>Specifies the ARN of the resource from which tags are to be removed.</p>', ], ], 'ApplicationDPUSizes' => [ 'base' => '<p>Contains the application runtime IDs and their supported DPU sizes.</p>', 'refs' => [ 'ApplicationDPUSizesList$member' => NULL, ], ], 'ApplicationDPUSizesList' => [ 'base' => NULL, 'refs' => [ 'ListApplicationDPUSizesOutput$ApplicationDPUSizes' => '<p>A list of the supported DPU sizes that the application runtime supports.</p>', ], ], 'AthenaError' => [ 'base' => '<p>Provides information about an Athena query error. The <code>AthenaError</code> feature provides standardized error information to help you understand failed queries and take steps after a query failure occurs. <code>AthenaError</code> includes an <code>ErrorCategory</code> field that specifies whether the cause of the failed query is due to system error, user error, or other error.</p>', 'refs' => [ 'QueryExecutionStatus$AthenaError' => '<p>Provides information about an Athena query error.</p>', ], ], 'AuthToken' => [ 'base' => NULL, 'refs' => [ 'CreatePresignedNotebookUrlResponse$AuthToken' => '<p>The authentication token for the notebook.</p>', ], ], 'AuthenticationType' => [ 'base' => NULL, 'refs' => [ 'QueryResultsS3AccessGrantsConfiguration$AuthenticationType' => '<p>The authentication type used for Amazon S3 access grants. Currently, only <code>DIRECTORY_IDENTITY</code> is supported.</p>', ], ], 'AwsAccountId' => [ 'base' => NULL, 'refs' => [ 'ResultConfiguration$ExpectedBucketOwner' => '<p>The Amazon Web Services account ID that you expect to be the owner of the Amazon S3 bucket specified by <a>ResultConfiguration$OutputLocation</a>. If set, Athena uses the value for <code>ExpectedBucketOwner</code> when it makes Amazon S3 calls to your specified output location. If the <code>ExpectedBucketOwner</code> Amazon Web Services account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.</p> <p>This is a client-side setting. If workgroup settings override client-side settings, then the query uses the <code>ExpectedBucketOwner</code> setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>', 'ResultConfigurationUpdates$ExpectedBucketOwner' => '<p>The Amazon Web Services account ID that you expect to be the owner of the Amazon S3 bucket specified by <a>ResultConfiguration$OutputLocation</a>. If set, Athena uses the value for <code>ExpectedBucketOwner</code> when it makes Amazon S3 calls to your specified output location. If the <code>ExpectedBucketOwner</code> Amazon Web Services account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.</p> <p>If workgroup settings override client-side settings, then the query uses the <code>ExpectedBucketOwner</code> setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>', ], ], 'BatchGetNamedQueryInput' => [ 'base' => '<p>Contains an array of named query IDs.</p>', 'refs' => [], ], 'BatchGetNamedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetPreparedStatementInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetPreparedStatementOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetQueryExecutionInput' => [ 'base' => '<p>Contains an array of query execution IDs.</p>', 'refs' => [], ], 'BatchGetQueryExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AthenaError$Retryable' => '<p>True if the query might succeed if resubmitted.</p>', 'ColumnInfo$CaseSensitive' => '<p>Indicates whether values in the column are case-sensitive.</p>', 'ResultReuseByAgeConfiguration$Enabled' => '<p>True if previous query results can be reused when the query is run; otherwise, false. The default is false.</p>', 'ResultReuseInformation$ReusedPreviousResult' => '<p>True if a previous query result was reused; false if the result was generated from a new run of the query.</p>', ], ], 'BoxedBoolean' => [ 'base' => NULL, 'refs' => [ 'DeleteWorkGroupInput$RecursiveDeleteOption' => '<p>The option to delete the workgroup and its contents even if the workgroup contains any named queries, query executions, or notebooks.</p>', 'IdentityCenterConfiguration$EnableIdentityCenter' => '<p>Specifies whether the workgroup is IAM Identity Center supported.</p>', 'QueryResultsS3AccessGrantsConfiguration$EnableS3AccessGrants' => '<p>Specifies whether Amazon S3 access grants are enabled for query results.</p>', 'QueryResultsS3AccessGrantsConfiguration$CreateUserLevelPrefix' => '<p>When enabled, appends the user ID as an Amazon S3 path prefix to the query result output location.</p>', 'ResultConfigurationUpdates$RemoveOutputLocation' => '<p>If set to "true", indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the <code>OutputLocation</code> in <code>ResultConfigurationUpdates</code> (the client-side setting), the <code>OutputLocation</code> in the workgroup\'s <code>ResultConfiguration</code> will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>', 'ResultConfigurationUpdates$RemoveEncryptionConfiguration' => '<p>If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side setting) for queries in this workgroup should be ignored and set to null. If set to "false" or not set, and a value is present in the <code>EncryptionConfiguration</code> in <code>ResultConfigurationUpdates</code> (the client-side setting), the <code>EncryptionConfiguration</code> in the workgroup\'s <code>ResultConfiguration</code> will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>', 'ResultConfigurationUpdates$RemoveExpectedBucketOwner' => '<p>If set to "true", removes the Amazon Web Services account ID previously specified for <a>ResultConfiguration$ExpectedBucketOwner</a>. If set to "false" or not set, and a value is present in the <code>ExpectedBucketOwner</code> in <code>ResultConfigurationUpdates</code> (the client-side setting), the <code>ExpectedBucketOwner</code> in the workgroup\'s <code>ResultConfiguration</code> is updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>', 'ResultConfigurationUpdates$RemoveAclConfiguration' => '<p>If set to <code>true</code>, indicates that the previously-specified ACL configuration for queries in this workgroup should be ignored and set to null. If set to <code>false</code> or not set, and a value is present in the <code>AclConfiguration</code> of <code>ResultConfigurationUpdates</code>, the <code>AclConfiguration</code> in the workgroup\'s <code>ResultConfiguration</code> is updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>', 'WorkGroupConfiguration$EnforceWorkGroupConfiguration' => '<p>If set to "true", the settings for the workgroup override client-side settings. If set to "false", client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>', 'WorkGroupConfiguration$PublishCloudWatchMetricsEnabled' => '<p>Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.</p>', 'WorkGroupConfiguration$RequesterPaysEnabled' => '<p>If set to <code>true</code>, allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code>. For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'WorkGroupConfiguration$EnableMinimumEncryptionConfiguration' => '<p>Enforces a minimal level of encryption for the workgroup for query and calculation results that are written to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the administrator or higher when they submit queries.</p> <p>The <code>EnforceWorkGroupConfiguration</code> setting takes precedence over the <code>EnableMinimumEncryptionConfiguration</code> flag. This means that if <code>EnforceWorkGroupConfiguration</code> is true, the <code>EnableMinimumEncryptionConfiguration</code> flag is ignored, and the workgroup configuration for encryption is used.</p>', 'WorkGroupConfigurationUpdates$EnforceWorkGroupConfiguration' => '<p>If set to "true", the settings for the workgroup override client-side settings. If set to "false" client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>', 'WorkGroupConfigurationUpdates$PublishCloudWatchMetricsEnabled' => '<p>Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.</p>', 'WorkGroupConfigurationUpdates$RemoveBytesScannedCutoffPerQuery' => '<p>Indicates that the data usage control limit per query is removed. <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a> </p>', 'WorkGroupConfigurationUpdates$RequesterPaysEnabled' => '<p>If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code>. For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>', 'WorkGroupConfigurationUpdates$RemoveCustomerContentEncryptionConfiguration' => '<p>Removes content encryption configuration from an Apache Spark-enabled Athena workgroup.</p>', 'WorkGroupConfigurationUpdates$EnableMinimumEncryptionConfiguration' => '<p>Enforces a minimal level of encryption for the workgroup for query and calculation results that are written to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the administrator or higher when they submit queries. This setting does not apply to Spark-enabled workgroups.</p> <p>The <code>EnforceWorkGroupConfiguration</code> setting takes precedence over the <code>EnableMinimumEncryptionConfiguration</code> flag. This means that if <code>EnforceWorkGroupConfiguration</code> is true, the <code>EnableMinimumEncryptionConfiguration</code> flag is ignored, and the workgroup configuration for encryption is used.</p>', ], ], 'BytesScannedCutoffValue' => [ 'base' => NULL, 'refs' => [ 'WorkGroupConfiguration$BytesScannedCutoffPerQuery' => '<p>The upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.</p>', 'WorkGroupConfigurationUpdates$BytesScannedCutoffPerQuery' => '<p>The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.</p>', ], ], 'CalculationConfiguration' => [ 'base' => '<p>Contains configuration information for the calculation.</p>', 'refs' => [ 'StartCalculationExecutionRequest$CalculationConfiguration' => '<p>Contains configuration information for the calculation.</p>', ], ], 'CalculationExecutionId' => [ 'base' => NULL, 'refs' => [ 'CalculationSummary$CalculationExecutionId' => '<p>The calculation execution UUID.</p>', 'GetCalculationExecutionCodeRequest$CalculationExecutionId' => '<p>The calculation execution UUID.</p>', 'GetCalculationExecutionRequest$CalculationExecutionId' => '<p>The calculation execution UUID.</p>', 'GetCalculationExecutionResponse$CalculationExecutionId' => '<p>The calculation execution UUID.</p>', 'GetCalculationExecutionStatusRequest$CalculationExecutionId' => '<p>The calculation execution UUID.</p>', 'StartCalculationExecutionResponse$CalculationExecutionId' => '<p>The calculation execution UUID.</p>', 'StopCalculationExecutionRequest$CalculationExecutionId' => '<p>The calculation execution UUID.</p>', ], ], 'CalculationExecutionState' => [ 'base' => NULL, 'refs' => [ 'CalculationStatus$State' => '<p>The state of the calculation execution. A description of each state follows.</p> <p> <code>CREATING</code> - The calculation is in the process of being created.</p> <p> <code>CREATED</code> - The calculation has been created and is ready to run.</p> <p> <code>QUEUED</code> - The calculation has been queued for processing.</p> <p> <code>RUNNING</code> - The calculation is running.</p> <p> <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to stop it.</p> <p> <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.</p> <p> <code>COMPLETED</code> - The calculation has completed without error.</p> <p> <code>FAILED</code> - The calculation failed and is no longer running.</p>', 'ListCalculationExecutionsRequest$StateFilter' => '<p>A filter for a specific calculation execution state. A description of each state follows.</p> <p> <code>CREATING</code> - The calculation is in the process of being created.</p> <p> <code>CREATED</code> - The calculation has been created and is ready to run.</p> <p> <code>QUEUED</code> - The calculation has been queued for processing.</p> <p> <code>RUNNING</code> - The calculation is running.</p> <p> <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to stop it.</p> <p> <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.</p> <p> <code>COMPLETED</code> - The calculation has completed without error.</p> <p> <code>FAILED</code> - The calculation failed and is no longer running.</p>', 'StartCalculationExecutionResponse$State' => '<p> <code>CREATING</code> - The calculation is in the process of being created.</p> <p> <code>CREATED</code> - The calculation has been created and is ready to run.</p> <p> <code>QUEUED</code> - The calculation has been queued for processing.</p> <p> <code>RUNNING</code> - The calculation is running.</p> <p> <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to stop it.</p> <p> <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.</p> <p> <code>COMPLETED</code> - The calculation has completed without error.</p> <p> <code>FAILED</code> - The calculation failed and is no longer running.</p>', 'StopCalculationExecutionResponse$State' => '<p> <code>CREATING</code> - The calculation is in the process of being created.</p> <p> <code>CREATED</code> - The calculation has been created and is ready to run.</p> <p> <code>QUEUED</code> - The calculation has been queued for processing.</p> <p> <code>RUNNING</code> - The calculation is running.</p> <p> <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to stop it.</p> <p> <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.</p> <p> <code>COMPLETED</code> - The calculation has completed without error.</p> <p> <code>FAILED</code> - The calculation failed and is no longer running.</p>', ], ], 'CalculationResult' => [ 'base' => '<p>Contains information about an application-specific calculation result.</p>', 'refs' => [ 'GetCalculationExecutionResponse$Result' => '<p>Contains result information. This field is populated only if the calculation is completed.</p>', ], ], 'CalculationResultType' => [ 'base' => NULL, 'refs' => [ 'CalculationResult$ResultType' => '<p>The data format of the calculation result.</p>', ], ], 'CalculationStatistics' => [ 'base' => '<p>Contains statistics for a notebook calculation.</p>', 'refs' => [ 'GetCalculationExecutionResponse$Statistics' => '<p>Contains information about the data processing unit (DPU) execution time and progress. This field is populated only when statistics are available.</p>', 'GetCalculationExecutionStatusResponse$Statistics' => '<p>Contains information about the DPU execution time and progress.</p>', ], ], 'CalculationStatus' => [ 'base' => '<p>Contains information about the status of a notebook calculation.</p>', 'refs' => [ 'CalculationSummary$Status' => '<p>Contains information about the status of the calculation.</p>', 'GetCalculationExecutionResponse$Status' => '<p>Contains information about the status of the calculation.</p>', 'GetCalculationExecutionStatusResponse$Status' => '<p>Contains information about the calculation execution status.</p>', ], ], 'CalculationSummary' => [ 'base' => '<p>Summary information for a notebook calculation.</p>', 'refs' => [ 'CalculationsList$member' => NULL, ], ], 'CalculationsList' => [ 'base' => NULL, 'refs' => [ 'ListCalculationExecutionsResponse$Calculations' => '<p>A list of <a>CalculationSummary</a> objects.</p>', ], ], 'CancelCapacityReservationInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelCapacityReservationOutput' => [ 'base' => NULL, 'refs' => [], ], 'CapacityAllocation' => [ 'base' => '<p>Contains the submission time of a single allocation request for a capacity reservation and the most recent status of the attempted allocation.</p>', 'refs' => [ 'CapacityReservation$LastAllocation' => NULL, ], ], 'CapacityAllocationStatus' => [ 'base' => NULL, 'refs' => [ 'CapacityAllocation$Status' => '<p>The status of the capacity allocation.</p>', ], ], 'CapacityAssignment' => [ 'base' => '<p>A mapping between one or more workgroups and a capacity reservation.</p>', 'refs' => [ 'CapacityAssignmentsList$member' => NULL, ], ], 'CapacityAssignmentConfiguration' => [ 'base' => '<p>Assigns Athena workgroups (and hence their queries) to capacity reservations. A capacity reservation can have only one capacity assignment configuration, but the capacity assignment configuration can be made up of multiple individual assignments. Each assignment specifies how Athena queries can consume capacity from the capacity reservation that their workgroup is mapped to.</p>', 'refs' => [ 'GetCapacityAssignmentConfigurationOutput$CapacityAssignmentConfiguration' => '<p>The requested capacity assignment configuration for the specified capacity reservation.</p>', ], ], 'CapacityAssignmentsList' => [ 'base' => NULL, 'refs' => [ 'CapacityAssignmentConfiguration$CapacityAssignments' => '<p>The list of assignments that make up the capacity assignment configuration.</p>', 'PutCapacityAssignmentConfigurationInput$CapacityAssignments' => '<p>The list of assignments for the capacity assignment configuration.</p>', ], ], 'CapacityReservation' => [ 'base' => '<p>A reservation for a specified number of data processing units (DPUs). When a reservation is initially created, it has no DPUs. Athena allocates DPUs until the allocated amount equals the requested amount.</p>', 'refs' => [ 'CapacityReservationsList$member' => NULL, 'GetCapacityReservationOutput$CapacityReservation' => '<p>The requested capacity reservation structure.</p>', ], ], 'CapacityReservationName' => [ 'base' => NULL, 'refs' => [ 'CancelCapacityReservationInput$Name' => '<p>The name of the capacity reservation to cancel.</p>', 'CapacityAssignmentConfiguration$CapacityReservationName' => '<p>The name of the reservation that the capacity assignment configuration is for.</p>', 'CapacityReservation$Name' => '<p>The name of the capacity reservation.</p>', 'CreateCapacityReservationInput$Name' => '<p>The name of the capacity reservation to create.</p>', 'DeleteCapacityReservationInput$Name' => '<p>The name of the capacity reservation to delete.</p>', 'GetCapacityAssignmentConfigurationInput$CapacityReservationName' => '<p>The name of the capacity reservation to retrieve the capacity assignment configuration for.</p>', 'GetCapacityReservationInput$Name' => '<p>The name of the capacity reservation.</p>', 'PutCapacityAssignmentConfigurationInput$CapacityReservationName' => '<p>The name of the capacity reservation to put a capacity assignment configuration for.</p>', 'UpdateCapacityReservationInput$Name' => '<p>The name of the capacity reservation.</p>', ], ], 'CapacityReservationStatus' => [ 'base' => NULL, 'refs' => [ 'CapacityReservation$Status' => '<p>The status of the capacity reservation.</p>', ], ], 'CapacityReservationsList' => [ 'base' => NULL, 'refs' => [ 'ListCapacityReservationsOutput$CapacityReservations' => '<p>The capacity reservations for the current account.</p>', ], ], 'CatalogNameString' => [ 'base' => NULL, 'refs' => [ 'CreateDataCatalogInput$Name' => '<p>The name of the data catalog to create. The catalog name must be unique for the Amazon Web Services account and can use a maximum of 127 alphanumeric, underscore, at sign, or hyphen characters. The remainder of the length constraint of 256 is reserved for use by Athena.</p>', 'DataCatalog$Name' => '<p>The name of the data catalog. The catalog name must be unique for the Amazon Web Services account and can use a maximum of 127 alphanumeric, underscore, at sign, or hyphen characters. The remainder of the length constraint of 256 is reserved for use by Athena.</p>', 'DataCatalogSummary$CatalogName' => '<p>The name of the data catalog. The catalog name is unique for the Amazon Web Services account and can use a maximum of 127 alphanumeric, underscore, at sign, or hyphen characters. The remainder of the length constraint of 256 is reserved for use by Athena.</p>', 'DeleteDataCatalogInput$Name' => '<p>The name of the data catalog to delete.</p>', 'GetDataCatalogInput$Name' => '<p>The name of the data catalog to return.</p>', 'GetDatabaseInput$CatalogName' => '<p>The name of the data catalog that contains the database to return.</p>', 'GetTableMetadataInput$CatalogName' => '<p>The name of the data catalog that contains the database and table metadata to return.</p>', 'ListDatabasesInput$CatalogName' => '<p>The name of the data catalog that contains the databases to return.</p>', 'ListTableMetadataInput$CatalogName' => '<p>The name of the data catalog for which table metadata should be returned.</p>', 'QueryExecutionContext$Catalog' => '<p>The name of the data catalog used in the query execution.</p>', 'UpdateDataCatalogInput$Name' => '<p>The name of the data catalog to update. The catalog name must be unique for the Amazon Web Services account and can use a maximum of 127 alphanumeric, underscore, at sign, or hyphen characters. The remainder of the length constraint of 256 is reserved for use by Athena.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInput$ClientRequestToken' => '<p>A unique case-sensitive string used to ensure the request to create the notebook is idempotent (executes only once).</p> <important> <p>This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.</p> </important>', 'ImportNotebookInput$ClientRequestToken' => '<p>A unique case-sensitive string used to ensure the request to import the notebook is idempotent (executes only once).</p> <important> <p>This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.</p> </important>', 'UpdateNotebookInput$ClientRequestToken' => '<p>A unique case-sensitive string used to ensure the request to create the notebook is idempotent (executes only once).</p> <important> <p>This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.</p> </important>', 'UpdateNotebookMetadataInput$ClientRequestToken' => '<p>A unique case-sensitive string used to ensure the request to create the notebook is idempotent (executes only once).</p> <important> <p>This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.</p> </important>', ], ], 'CodeBlock' => [ 'base' => NULL, 'refs' => [ 'CalculationConfiguration$CodeBlock' => '<p>A string that contains the code for the calculation.</p>', 'GetCalculationExecutionCodeResponse$CodeBlock' => '<p>The unencrypted code that was executed for the calculation.</p>', 'StartCalculationExecutionRequest$CodeBlock' => '<p>A string that contains the code of the calculation. Use this parameter instead of <a>CalculationConfiguration$CodeBlock</a>, which is deprecated.</p>', ], ], 'Column' => [ 'base' => '<p>Contains metadata for a column in a table.</p>', 'refs' => [ 'ColumnList$member' => NULL, ], ], 'ColumnInfo' => [ 'base' => '<p>Information about the columns in a query execution result.</p>', 'refs' => [ 'ColumnInfoList$member' => NULL, ], ], 'ColumnInfoList' => [ 'base' => NULL, 'refs' => [ 'ResultSetMetadata$ColumnInfo' => '<p>Information about the columns returned in a query result metadata.</p>', ], ], 'ColumnList' => [ 'base' => NULL, 'refs' => [ 'TableMetadata$Columns' => '<p>A list of the columns in the table.</p>', 'TableMetadata$PartitionKeys' => '<p>A list of the partition keys in the table.</p>', ], ], 'ColumnNullable' => [ 'base' => NULL, 'refs' => [ 'ColumnInfo$Nullable' => '<p>Unsupported constraint. This value always shows as <code>UNKNOWN</code>.</p>', ], ], 'CommentString' => [ 'base' => NULL, 'refs' => [ 'Column$Comment' => '<p>Optional information about the column.</p>', ], ], 'CoordinatorDpuSize' => [ 'base' => NULL, 'refs' => [ 'EngineConfiguration$CoordinatorDpuSize' => '<p>The number of DPUs to use for the coordinator. A coordinator is a special executor that orchestrates processing work and manages other executors in a notebook session. The default is 1.</p>', ], ], 'CreateCapacityReservationInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateCapacityReservationOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataCatalogInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataCatalogOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNamedQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNamedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNotebookInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNotebookOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePreparedStatementInput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePreparedStatementOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedNotebookUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedNotebookUrlResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'CustomerContentEncryptionConfiguration' => [ 'base' => '<p>Specifies the customer managed KMS key that is used to encrypt the user\'s data stores in Athena. When an Amazon Web Services managed key is used, this value is null. This setting does not apply to Athena SQL workgroups.</p>', 'refs' => [ 'WorkGroupConfiguration$CustomerContentEncryptionConfiguration' => '<p>Specifies the KMS key that is used to encrypt the user\'s data stores in Athena. This setting does not apply to Athena SQL workgroups.</p>', 'WorkGroupConfigurationUpdates$CustomerContentEncryptionConfiguration' => NULL, ], ], 'DataCatalog' => [ 'base' => '<p>Contains information about a data catalog in an Amazon Web Services account.</p> <note> <p>In the Athena console, data catalogs are listed as "data sources" on the <b>Data sources</b> page under the <b>Data source name</b> column.</p> </note>', 'refs' => [ 'GetDataCatalogOutput$DataCatalog' => '<p>The data catalog returned.</p>', ], ], 'DataCatalogSummary' => [ 'base' => '<p>The summary information for the data catalog, which includes its name and type.</p>', 'refs' => [ 'DataCatalogSummaryList$member' => NULL, ], ], 'DataCatalogSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDataCatalogsOutput$DataCatalogsSummary' => '<p>A summary list of data catalogs.</p>', ], ], 'DataCatalogType' => [ 'base' => NULL, 'refs' => [ 'CreateDataCatalogInput$Type' => '<p>The type of data catalog to create: <code>LAMBDA</code> for a federated catalog, <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an Glue Data Catalog.</p>', 'DataCatalog$Type' => '<p>The type of data catalog to create: <code>LAMBDA</code> for a federated catalog, <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an Glue Data Catalog.</p>', 'DataCatalogSummary$Type' => '<p>The data catalog type.</p>', 'UpdateDataCatalogInput$Type' => '<p>Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a federated catalog, <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an Glue Data Catalog.</p>', ], ], 'Database' => [ 'base' => '<p>Contains metadata information for a database in a data catalog.</p>', 'refs' => [ 'DatabaseList$member' => NULL, 'GetDatabaseOutput$Database' => '<p>The database returned.</p>', ], ], 'DatabaseList' => [ 'base' => NULL, 'refs' => [ 'ListDatabasesOutput$DatabaseList' => '<p>A list of databases from a data catalog.</p>', ], ], 'DatabaseString' => [ 'base' => NULL, 'refs' => [ 'CreateNamedQueryInput$Database' => '<p>The database to which the query belongs.</p>', 'NamedQuery$Database' => '<p>The database to which the query belongs.</p>', 'QueryExecutionContext$Database' => '<p>The name of the database used in the query execution. The database must exist in the catalog.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'CalculationStatus$SubmissionDateTime' => '<p>The date and time the calculation was submitted for processing.</p>', 'CalculationStatus$CompletionDateTime' => '<p>The date and time the calculation completed processing.</p>', 'NotebookMetadata$CreationTime' => '<p>The time when the notebook was created.</p>', 'NotebookMetadata$LastModifiedTime' => '<p>The time when the notebook was last modified.</p>', 'NotebookSessionSummary$CreationTime' => '<p>The time when the notebook session was created.</p>', 'PreparedStatement$LastModifiedTime' => '<p>The last modified time of the prepared statement.</p>', 'PreparedStatementSummary$LastModifiedTime' => '<p>The last modified time of the prepared statement.</p>', 'QueryExecutionStatus$SubmissionDateTime' => '<p>The date and time that the query was submitted.</p>', 'QueryExecutionStatus$CompletionDateTime' => '<p>The date and time that the query completed.</p>', 'SessionStatus$StartDateTime' => '<p>The date and time that the session started.</p>', 'SessionStatus$LastModifiedDateTime' => '<p>The most recent date and time that the session was modified.</p>', 'SessionStatus$EndDateTime' => '<p>The date and time that the session ended.</p>', 'SessionStatus$IdleSinceDateTime' => '<p>The date and time starting at which the session became idle. Can be empty if the session is not currently idle.</p>', 'WorkGroup$CreationTime' => '<p>The date and time the workgroup was created.</p>', 'WorkGroupSummary$CreationTime' => '<p>The workgroup creation date and time.</p>', ], ], 'Datum' => [ 'base' => '<p>A piece of data (a field in the table).</p>', 'refs' => [ 'datumList$member' => NULL, ], ], 'DefaultExecutorDpuSize' => [ 'base' => NULL, 'refs' => [ 'EngineConfiguration$DefaultExecutorDpuSize' => '<p>The default number of DPUs to use for executors. An executor is the smallest unit of compute that a notebook session can request from Athena. The default is 1.</p>', ], ], 'DeleteCapacityReservationInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCapacityReservationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataCatalogInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataCatalogOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNamedQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNamedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNotebookInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNotebookOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePreparedStatementInput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePreparedStatementOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescriptionString' => [ 'base' => NULL, 'refs' => [ 'CalculationStatistics$Progress' => '<p>The progress of the calculation.</p>', 'CalculationStatus$StateChangeReason' => '<p>The reason for the calculation state change (for example, the calculation was canceled because the session was terminated).</p>', 'CalculationSummary$Description' => '<p>A description of the calculation.</p>', 'CreateDataCatalogInput$Description' => '<p>A description of the data catalog to be created.</p>', 'CreateNamedQueryInput$Description' => '<p>The query description.</p>', 'CreatePreparedStatementInput$Description' => '<p>The description of the prepared statement.</p>', 'DataCatalog$Description' => '<p>An optional description of the data catalog.</p>', 'Database$Description' => '<p>An optional description of the database.</p>', 'GetCalculationExecutionResponse$Description' => '<p>The description of the calculation execution.</p>', 'GetSessionResponse$Description' => '<p>The session description.</p>', 'NamedQuery$Description' => '<p>The query description.</p>', 'PreparedStatement$Description' => '<p>The description of the prepared statement.</p>', 'SessionStatus$StateChangeReason' => '<p>The reason for the session state change (for example, canceled because the session was terminated).</p>', 'SessionSummary$Description' => '<p>The session description.</p>', 'StartCalculationExecutionRequest$Description' => '<p>A description of the calculation.</p>', 'StartSessionRequest$Description' => '<p>The session description.</p>', 'UpdateDataCatalogInput$Description' => '<p>New or modified text that describes the data catalog.</p>', 'UpdatePreparedStatementInput$Description' => '<p>The description of the prepared statement.</p>', ], ], 'EncryptionConfiguration' => [ 'base' => '<p>If query and calculation results are encrypted in Amazon S3, indicates the encryption option used (for example, <code>SSE_KMS</code> or <code>CSE_KMS</code>) and key information.</p>', 'refs' => [ 'ResultConfiguration$EncryptionConfiguration' => '<p>If query and calculation results are encrypted in Amazon S3, indicates the encryption option used (for example, <code>SSE_KMS</code> or <code>CSE_KMS</code>) and key information. This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>', 'ResultConfigurationUpdates$EncryptionConfiguration' => '<p>The encryption configuration for query and calculation results.</p>', 'SessionConfiguration$EncryptionConfiguration' => NULL, ], ], 'EncryptionOption' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfiguration$EncryptionOption' => '<p>Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys (<code>SSE_S3</code>), server-side encryption with KMS-managed keys (<code>SSE_KMS</code>), or client-side encryption with KMS-managed keys (<code>CSE_KMS</code>) is used.</p> <p>If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup\'s setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup. </p>', ], ], 'EngineConfiguration' => [ 'base' => '<p>Contains data processing unit (DPU) configuration settings and parameter mappings for a notebook engine.</p>', 'refs' => [ 'GetSessionResponse$EngineConfiguration' => '<p>Contains engine configuration information like DPU usage.</p>', 'StartSessionRequest$EngineConfiguration' => '<p>Contains engine data processing unit (DPU) configuration settings and parameter mappings.</p>', ], ], 'EngineVersion' => [ 'base' => '<p>The Athena engine version for running queries, or the PySpark engine version for running sessions.</p>', 'refs' => [ 'EngineVersionsList$member' => NULL, 'QueryExecution$EngineVersion' => '<p>The engine version that executed the query.</p>', 'SessionSummary$EngineVersion' => '<p>The engine version used by the session (for example, <code>PySpark engine version 3</code>).</p>', 'WorkGroupConfiguration$EngineVersion' => '<p>The engine version that all queries running on the workgroup use. Queries on the <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.</p>', 'WorkGroupConfigurationUpdates$EngineVersion' => '<p>The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run on the requested engine version. If no value was previously set, the default is Auto. Queries on the <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.</p>', 'WorkGroupSummary$EngineVersion' => '<p>The engine version setting for all queries on the workgroup. Queries on the <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.</p>', ], ], 'EngineVersionsList' => [ 'base' => NULL, 'refs' => [ 'ListEngineVersionsOutput$EngineVersions' => '<p>A list of engine versions that are available to choose from.</p>', ], ], 'ErrorCategory' => [ 'base' => NULL, 'refs' => [ 'AthenaError$ErrorCategory' => '<p>An integer value that specifies the category of a query failure error. The following list shows the category for each integer value.</p> <p> <b>1</b> - System</p> <p> <b>2</b> - User</p> <p> <b>3</b> - Other</p>', ], ], 'ErrorCode' => [ 'base' => '<p>The error code returned when the query execution failed to process, or when the processing request for the named query failed.</p>', 'refs' => [ 'InvalidRequestException$AthenaErrorCode' => NULL, 'UnprocessedNamedQueryId$ErrorCode' => '<p>The error code returned when the processing request for the named query failed, if applicable.</p>', 'UnprocessedPreparedStatementName$ErrorCode' => '<p>The error code returned when the request for the prepared statement failed.</p>', 'UnprocessedQueryExecutionId$ErrorCode' => '<p>The error code returned when the query execution failed to process, if applicable.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'MetadataException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'SessionAlreadyExistsException$Message' => NULL, 'TooManyRequestsException$Message' => NULL, 'UnprocessedNamedQueryId$ErrorMessage' => '<p>The error message returned when the processing request for the named query failed, if applicable.</p>', 'UnprocessedPreparedStatementName$ErrorMessage' => '<p>The error message containing the reason why the prepared statement could not be returned. The following error messages are possible:</p> <ul> <li> <p> <code>INVALID_INPUT</code> - The name of the prepared statement that was provided is not valid (for example, the name is too long).</p> </li> <li> <p> <code>STATEMENT_NOT_FOUND</code> - A prepared statement with the name provided could not be found.</p> </li> <li> <p> <code>UNAUTHORIZED</code> - The requester does not have permission to access the workgroup that contains the prepared statement.</p> </li> </ul>', 'UnprocessedQueryExecutionId$ErrorMessage' => '<p>The error message returned when the query execution failed to process, if applicable.</p>', ], ], 'ErrorType' => [ 'base' => NULL, 'refs' => [ 'AthenaError$ErrorType' => '<p>An integer value that provides specific information about an Athena query error. For the meaning of specific values, see the <a href="https://docs.aws.amazon.com/athena/latest/ug/error-reference.html#error-reference-error-type-reference">Error Type Reference</a> in the <i>Amazon Athena User Guide</i>.</p>', ], ], 'ExecutionParameter' => [ 'base' => NULL, 'refs' => [ 'ExecutionParameters$member' => NULL, ], ], 'ExecutionParameters' => [ 'base' => NULL, 'refs' => [ 'QueryExecution$ExecutionParameters' => '<p>A list of values for the parameters in a query. The values are applied sequentially to the parameters in the query in the order in which the parameters occur. The list of parameters is not returned in the response.</p>', 'StartQueryExecutionInput$ExecutionParameters' => '<p>A list of values for the parameters in a query. The values are applied sequentially to the parameters in the query in the order in which the parameters occur.</p>', ], ], 'ExecutorId' => [ 'base' => NULL, 'refs' => [ 'ExecutorsSummary$ExecutorId' => '<p>The UUID of the executor.</p>', ], ], 'ExecutorState' => [ 'base' => NULL, 'refs' => [ 'ExecutorsSummary$ExecutorState' => '<p>The processing state of the executor. A description of each state follows.</p> <p> <code>CREATING</code> - The executor is being started, including acquiring resources.</p> <p> <code>CREATED</code> - The executor has been started.</p> <p> <code>REGISTERED</code> - The executor has been registered.</p> <p> <code>TERMINATING</code> - The executor is in the process of shutting down.</p> <p> <code>TERMINATED</code> - The executor is no longer running.</p> <p> <code>FAILED</code> - Due to a failure, the executor is no longer running.</p>', 'ListExecutorsRequest$ExecutorStateFilter' => '<p>A filter for a specific executor state. A description of each state follows.</p> <p> <code>CREATING</code> - The executor is being started, including acquiring resources.</p> <p> <code>CREATED</code> - The executor has been started.</p> <p> <code>REGISTERED</code> - The executor has been registered.</p> <p> <code>TERMINATING</code> - The executor is in the process of shutting down.</p> <p> <code>TERMINATED</code> - The executor is no longer running.</p> <p> <code>FAILED</code> - Due to a failure, the executor is no longer running.</p>', ], ], 'ExecutorType' => [ 'base' => NULL, 'refs' => [ 'ExecutorsSummary$ExecutorType' => '<p>The type of executor used for the application (<code>COORDINATOR</code>, <code>GATEWAY</code>, or <code>WORKER</code>).</p>', ], ], 'ExecutorsSummary' => [ 'base' => '<p>Contains summary information about an executor.</p>', 'refs' => [ 'ExecutorsSummaryList$member' => NULL, ], ], 'ExecutorsSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListExecutorsResponse$ExecutorsSummary' => '<p>Contains summary information about the executor.</p>', ], ], 'ExportNotebookInput' => [ 'base' => NULL, 'refs' => [], ], 'ExportNotebookOutput' => [ 'base' => NULL, 'refs' => [], ], 'ExpressionString' => [ 'base' => NULL, 'refs' => [ 'ListTableMetadataInput$Expression' => '<p>A regex filter that pattern-matches table names. If no expression is supplied, metadata for all tables are listed.</p>', ], ], 'FilterDefinition' => [ 'base' => '<p>A string for searching notebook names.</p>', 'refs' => [ 'ListNotebookMetadataInput$Filters' => '<p>Search filter string.</p>', ], ], 'GetCalculationExecutionCodeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCalculationExecutionCodeResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCalculationExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCalculationExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCalculationExecutionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCalculationExecutionStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCapacityAssignmentConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'GetCapacityAssignmentConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetCapacityReservationInput' => [ 'base' => NULL, 'refs' => [], ], 'GetCapacityReservationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetDataCatalogInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDataCatalogOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetDatabaseInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDatabaseOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetNamedQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'GetNamedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetNotebookMetadataInput' => [ 'base' => NULL, 'refs' => [], ], 'GetNotebookMetadataOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPreparedStatementInput' => [ 'base' => NULL, 'refs' => [], ], 'GetPreparedStatementOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryResultsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryResultsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryRuntimeStatisticsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryRuntimeStatisticsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTableMetadataInput' => [ 'base' => NULL, 'refs' => [], ], 'GetTableMetadataOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'CreateNamedQueryInput$ClientRequestToken' => '<p>A unique case-sensitive string used to ensure the request to create the query is idempotent (executes only once). If another <code>CreateNamedQuery</code> request is received, the same response is returned and another query is not created. If a parameter has changed, for example, the <code>QueryString</code>, an error is returned.</p> <important> <p>This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.</p> </important>', 'StartCalculationExecutionRequest$ClientRequestToken' => '<p>A unique case-sensitive string used to ensure the request to create the calculation is idempotent (executes only once). If another <code>StartCalculationExecutionRequest</code> is received, the same response is returned and another calculation is not created. If a parameter has changed, an error is returned.</p> <important> <p>This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.</p> </important>', 'StartQueryExecutionInput$ClientRequestToken' => '<p>A unique case-sensitive string used to ensure the request to create the query is idempotent (executes only once). If another <code>StartQueryExecution</code> request is received, the same response is returned and another query is not created. An error is returned if a parameter, such as <code>QueryString</code>, has changed. A call to <code>StartQueryExecution</code> that uses a previous client request token returns the same <code>QueryExecutionId</code> even if the requester doesn\'t have permission on the tables specified in <code>QueryString</code>.</p> <important> <p>This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.</p> </important>', 'StartSessionRequest$ClientRequestToken' => '<p>A unique case-sensitive string used to ensure the request to create the session is idempotent (executes only once). If another <code>StartSessionRequest</code> is received, the same response is returned and another session is not created. If a parameter has changed, an error is returned.</p> <important> <p>This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.</p> </important>', ], ], 'IdentityCenterApplicationArn' => [ 'base' => NULL, 'refs' => [ 'WorkGroup$IdentityCenterApplicationArn' => '<p>The ARN of the IAM Identity Center enabled application associated with the workgroup.</p>', 'WorkGroupSummary$IdentityCenterApplicationArn' => '<p>The ARN of the IAM Identity Center enabled application associated with the workgroup.</p>', ], ], 'IdentityCenterConfiguration' => [ 'base' => '<p>Specifies whether the workgroup is IAM Identity Center supported.</p>', 'refs' => [ 'WorkGroupConfiguration$IdentityCenterConfiguration' => '<p>Specifies whether the workgroup is IAM Identity Center supported.</p>', ], ], 'IdentityCenterInstanceArn' => [ 'base' => NULL, 'refs' => [ 'IdentityCenterConfiguration$IdentityCenterInstanceArn' => '<p>The IAM Identity Center instance ARN that the workgroup associates to.</p>', ], ], 'ImportNotebookInput' => [ 'base' => NULL, 'refs' => [], ], 'ImportNotebookOutput' => [ 'base' => NULL, 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ColumnInfo$Precision' => '<p>For <code>DECIMAL</code> data types, specifies the total number of digits, up to 38. For performance reasons, we recommend up to 18 digits.</p>', 'ColumnInfo$Scale' => '<p>For <code>DECIMAL</code> data types, specifies the total number of digits in the fractional part of the value. Defaults to 0.</p>', 'SupportedDPUSizeList$member' => NULL, ], ], 'InternalServerException' => [ 'base' => '<p>Indicates a platform issue, which may be due to a transient condition or outage.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>Indicates that something is wrong with the input to the request. For example, a required parameter may be missing or out of range.</p>', 'refs' => [], ], 'KeyString' => [ 'base' => NULL, 'refs' => [ 'ParametersMap$key' => NULL, ], ], 'KmsKey' => [ 'base' => NULL, 'refs' => [ 'CustomerContentEncryptionConfiguration$KmsKey' => '<p>The customer managed KMS key that is used to encrypt the user\'s data stores in Athena.</p>', ], ], 'ListApplicationDPUSizesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationDPUSizesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCalculationExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCalculationExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCapacityReservationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCapacityReservationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListDataCatalogsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListDataCatalogsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListDatabasesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListDatabasesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEngineVersionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEngineVersionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListExecutorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExecutorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListNamedQueriesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNamedQueriesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookMetadataInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookMetadataOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookSessionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPreparedStatementsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListPreparedStatementsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListQueryExecutionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListQueryExecutionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSessionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTableMetadataInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTableMetadataOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkGroupsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkGroupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'CalculationStatistics$DpuExecutionInMillis' => '<p>The data processing unit execution time in milliseconds for the calculation.</p>', 'CreatePresignedNotebookUrlResponse$AuthTokenExpirationTime' => '<p>The UTC epoch time when the authentication token expires.</p>', 'ExecutorsSummary$StartDateTime' => '<p>The date and time that the executor started.</p>', 'ExecutorsSummary$TerminationDateTime' => '<p>The date and time that the executor was terminated.</p>', 'ExecutorsSummary$ExecutorSize' => '<p>The smallest unit of compute that a session can request from Athena. Size is measured in data processing unit (DPU) values, a relative measure of processing power.</p>', 'GetQueryResultsOutput$UpdateCount' => '<p>The number of rows inserted with a <code>CREATE TABLE AS SELECT</code> statement. </p>', 'QueryExecutionStatistics$EngineExecutionTimeInMillis' => '<p>The number of milliseconds that the query took to execute.</p>', 'QueryExecutionStatistics$DataScannedInBytes' => '<p>The number of bytes in the data that was queried.</p>', 'QueryExecutionStatistics$TotalExecutionTimeInMillis' => '<p>The number of milliseconds that Athena took to run the query.</p>', 'QueryExecutionStatistics$QueryQueueTimeInMillis' => '<p>The number of milliseconds that the query was in your query queue waiting for resources. Note that if transient errors occur, Athena might automatically add the query back to the queue.</p>', 'QueryExecutionStatistics$ServicePreProcessingTimeInMillis' => '<p>The number of milliseconds that Athena took to preprocess the query before submitting the query to the query engine.</p>', 'QueryExecutionStatistics$QueryPlanningTimeInMillis' => '<p>The number of milliseconds that Athena took to plan the query processing flow. This includes the time spent retrieving table partitions from the data source. Note that because the query engine performs the query planning, query planning time is a subset of engine processing time.</p>', 'QueryExecutionStatistics$ServiceProcessingTimeInMillis' => '<p>The number of milliseconds that Athena took to finalize and publish the query results after the query engine finished running the query.</p>', 'QueryRuntimeStatisticsRows$InputRows' => '<p>The number of rows read to execute the query.</p>', 'QueryRuntimeStatisticsRows$InputBytes' => '<p>The number of bytes read to execute the query.</p>', 'QueryRuntimeStatisticsRows$OutputBytes' => '<p>The number of bytes returned by the query.</p>', 'QueryRuntimeStatisticsRows$OutputRows' => '<p>The number of rows returned by the query.</p>', 'QueryRuntimeStatisticsTimeline$QueryQueueTimeInMillis' => '<p>The number of milliseconds that the query was in your query queue waiting for resources. Note that if transient errors occur, Athena might automatically add the query back to the queue.</p>', 'QueryRuntimeStatisticsTimeline$ServicePreProcessingTimeInMillis' => '<p> The number of milliseconds that Athena spends on preprocessing before it submits the query to the engine. </p>', 'QueryRuntimeStatisticsTimeline$QueryPlanningTimeInMillis' => '<p>The number of milliseconds that Athena took to plan the query processing flow. This includes the time spent retrieving table partitions from the data source. Note that because the query engine performs the query planning, query planning time is a subset of engine processing time.</p>', 'QueryRuntimeStatisticsTimeline$EngineExecutionTimeInMillis' => '<p>The number of milliseconds that the query took to execute.</p>', 'QueryRuntimeStatisticsTimeline$ServiceProcessingTimeInMillis' => '<p>The number of milliseconds that Athena took to finalize and publish the query results after the query engine finished running the query.</p>', 'QueryRuntimeStatisticsTimeline$TotalExecutionTimeInMillis' => '<p>The number of milliseconds that Athena took to run the query.</p>', 'QueryStage$StageId' => '<p>The identifier for a stage.</p>', 'QueryStage$OutputBytes' => '<p>The number of bytes output from the stage after execution.</p>', 'QueryStage$OutputRows' => '<p>The number of rows output from the stage after execution.</p>', 'QueryStage$InputBytes' => '<p>The number of bytes input into the stage for execution.</p>', 'QueryStage$InputRows' => '<p>The number of rows input into the stage for execution.</p>', 'QueryStage$ExecutionTime' => '<p>Time taken to execute this stage.</p>', 'SessionConfiguration$IdleTimeoutSeconds' => '<p>The idle timeout in seconds for the session.</p>', 'SessionStatistics$DpuExecutionInMillis' => '<p>The data processing unit execution time for a session in milliseconds.</p>', ], ], 'MaxApplicationDPUSizesCount' => [ 'base' => NULL, 'refs' => [ 'ListApplicationDPUSizesInput$MaxResults' => '<p>Specifies the maximum number of results to return.</p>', ], ], 'MaxCalculationsCount' => [ 'base' => NULL, 'refs' => [ 'ListCalculationExecutionsRequest$MaxResults' => '<p>The maximum number of calculation executions to return.</p>', ], ], 'MaxCapacityReservationsCount' => [ 'base' => NULL, 'refs' => [ 'ListCapacityReservationsInput$MaxResults' => '<p>Specifies the maximum number of results to return.</p>', ], ], 'MaxConcurrentDpus' => [ 'base' => NULL, 'refs' => [ 'EngineConfiguration$MaxConcurrentDpus' => '<p>The maximum number of DPUs that can run concurrently.</p>', ], ], 'MaxDataCatalogsCount' => [ 'base' => NULL, 'refs' => [ 'ListDataCatalogsInput$MaxResults' => '<p>Specifies the maximum number of data catalogs to return.</p>', ], ], 'MaxDatabasesCount' => [ 'base' => NULL, 'refs' => [ 'ListDatabasesInput$MaxResults' => '<p>Specifies the maximum number of results to return.</p>', ], ], 'MaxEngineVersionsCount' => [ 'base' => NULL, 'refs' => [ 'ListEngineVersionsInput$MaxResults' => '<p>The maximum number of engine versions to return in this request.</p>', ], ], 'MaxListExecutorsCount' => [ 'base' => NULL, 'refs' => [ 'ListExecutorsRequest$MaxResults' => '<p>The maximum number of executors to return.</p>', ], ], 'MaxNamedQueriesCount' => [ 'base' => NULL, 'refs' => [ 'ListNamedQueriesInput$MaxResults' => '<p>The maximum number of queries to return in this request.</p>', ], ], 'MaxNotebooksCount' => [ 'base' => NULL, 'refs' => [ 'ListNotebookMetadataInput$MaxResults' => '<p>Specifies the maximum number of results to return.</p>', ], ], 'MaxPreparedStatementsCount' => [ 'base' => NULL, 'refs' => [ 'ListPreparedStatementsInput$MaxResults' => '<p>The maximum number of results to return in this request.</p>', ], ], 'MaxQueryExecutionsCount' => [ 'base' => NULL, 'refs' => [ 'ListQueryExecutionsInput$MaxResults' => '<p>The maximum number of query executions to return in this request.</p>', ], ], 'MaxQueryResults' => [ 'base' => NULL, 'refs' => [ 'GetQueryResultsInput$MaxResults' => '<p>The maximum number of results (rows) to return in this request.</p>', ], ], 'MaxSessionsCount' => [ 'base' => NULL, 'refs' => [ 'ListNotebookSessionsRequest$MaxResults' => '<p>The maximum number of notebook sessions to return.</p>', 'ListSessionsRequest$MaxResults' => '<p>The maximum number of sessions to return.</p>', ], ], 'MaxTableMetadataCount' => [ 'base' => NULL, 'refs' => [ 'ListTableMetadataInput$MaxResults' => '<p>Specifies the maximum number of results to return.</p>', ], ], 'MaxTagsCount' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceInput$MaxResults' => '<p>The maximum number of results to be returned per request that lists the tags for the resource.</p>', ], ], 'MaxWorkGroupsCount' => [ 'base' => NULL, 'refs' => [ 'ListWorkGroupsInput$MaxResults' => '<p>The maximum number of workgroups to return in this request.</p>', ], ], 'MetadataException' => [ 'base' => '<p>An exception that Athena received when it called a custom metastore. Occurs if the error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (<code>InternalServerException</code>). For example, if a user-created Lambda function is missing permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</p>', 'refs' => [], ], 'NameString' => [ 'base' => NULL, 'refs' => [ 'ApplicationDPUSizes$ApplicationRuntimeId' => '<p>The name of the supported application runtime (for example, <code>Athena notebook version 1</code>).</p>', 'Column$Name' => '<p>The name of the column.</p>', 'CreateNamedQueryInput$Name' => '<p>The query name.</p>', 'Database$Name' => '<p>The name of the database.</p>', 'EngineVersion$SelectedEngineVersion' => '<p>The engine version requested by the user. Possible values are determined by the output of <code>ListEngineVersions</code>, including AUTO. The default is AUTO.</p>', 'EngineVersion$EffectiveEngineVersion' => '<p>Read only. The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the <code>EffectiveEngineVersion</code> field is ignored.</p>', 'GetDatabaseInput$DatabaseName' => '<p>The name of the database to return.</p>', 'GetSessionResponse$EngineVersion' => '<p>The engine version used by the session (for example, <code>PySpark engine version 3</code>). You can get a list of engine versions by calling <a>ListEngineVersions</a>.</p>', 'GetSessionResponse$NotebookVersion' => '<p>The notebook version.</p>', 'GetTableMetadataInput$DatabaseName' => '<p>The name of the database that contains the table metadata to return.</p>', 'GetTableMetadataInput$TableName' => '<p>The name of the table for which metadata is returned.</p>', 'ListTableMetadataInput$DatabaseName' => '<p>The name of the database for which table metadata should be returned.</p>', 'NamedQuery$Name' => '<p>The query name.</p>', 'SessionSummary$NotebookVersion' => '<p>The notebook version.</p>', 'StartSessionRequest$NotebookVersion' => '<p>The notebook version. This value is supplied automatically for notebook sessions in the Athena console and is not required for programmatic session access. The only valid notebook version is <code>Athena notebook version 1</code>. If you specify a value for <code>NotebookVersion</code>, you must also specify a value for <code>NotebookId</code>. See <a>EngineConfiguration$AdditionalConfigs</a>.</p>', 'TableMetadata$Name' => '<p>The name of the table.</p>', 'UpdateNamedQueryInput$Name' => '<p>The name of the query.</p>', 'WorkGroupConfiguration$AdditionalConfiguration' => '<p>Specifies a user defined JSON string that is passed to the notebook engine.</p>', 'WorkGroupConfigurationUpdates$AdditionalConfiguration' => '<p>Contains a user defined string in JSON format for a Spark-enabled workgroup.</p>', ], ], 'NamedQuery' => [ 'base' => '<p>A query, where <code>QueryString</code> contains the SQL statements that make up the query.</p>', 'refs' => [ 'GetNamedQueryOutput$NamedQuery' => '<p>Information about the query.</p>', 'NamedQueryList$member' => NULL, ], ], 'NamedQueryDescriptionString' => [ 'base' => NULL, 'refs' => [ 'UpdateNamedQueryInput$Description' => '<p>The query description.</p>', ], ], 'NamedQueryId' => [ 'base' => NULL, 'refs' => [ 'CreateNamedQueryOutput$NamedQueryId' => '<p>The unique ID of the query.</p>', 'DeleteNamedQueryInput$NamedQueryId' => '<p>The unique ID of the query to delete.</p>', 'GetNamedQueryInput$NamedQueryId' => '<p>The unique ID of the query. Use <a>ListNamedQueries</a> to get query IDs.</p>', 'NamedQuery$NamedQueryId' => '<p>The unique identifier of the query.</p>', 'NamedQueryIdList$member' => NULL, 'UnprocessedNamedQueryId$NamedQueryId' => '<p>The unique identifier of the named query.</p>', 'UpdateNamedQueryInput$NamedQueryId' => '<p>The unique identifier (UUID) of the query.</p>', ], ], 'NamedQueryIdList' => [ 'base' => NULL, 'refs' => [ 'BatchGetNamedQueryInput$NamedQueryIds' => '<p>An array of query IDs.</p>', 'ListNamedQueriesOutput$NamedQueryIds' => '<p>The list of unique query IDs.</p>', ], ], 'NamedQueryList' => [ 'base' => NULL, 'refs' => [ 'BatchGetNamedQueryOutput$NamedQueries' => '<p>Information about the named query IDs submitted.</p>', ], ], 'NotebookId' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookOutput$NotebookId' => '<p>A unique identifier for the notebook.</p>', 'DeleteNotebookInput$NotebookId' => '<p>The ID of the notebook to delete.</p>', 'ExportNotebookInput$NotebookId' => '<p>The ID of the notebook to export.</p>', 'GetNotebookMetadataInput$NotebookId' => '<p>The ID of the notebook whose metadata is to be retrieved.</p>', 'ImportNotebookOutput$NotebookId' => '<p>The ID assigned to the imported notebook.</p>', 'ListNotebookSessionsRequest$NotebookId' => '<p>The ID of the notebook to list sessions for.</p>', 'NotebookMetadata$NotebookId' => '<p>The notebook ID.</p>', 'UpdateNotebookInput$NotebookId' => '<p>The ID of the notebook to update.</p>', 'UpdateNotebookMetadataInput$NotebookId' => '<p>The ID of the notebook to update the metadata for.</p>', ], ], 'NotebookMetadata' => [ 'base' => '<p>Contains metadata for notebook, including the notebook name, ID, workgroup, and time created.</p>', 'refs' => [ 'ExportNotebookOutput$NotebookMetadata' => '<p>The notebook metadata, including notebook ID, notebook name, and workgroup name.</p>', 'GetNotebookMetadataOutput$NotebookMetadata' => '<p>The metadata that is returned for the specified notebook ID.</p>', 'NotebookMetadataArray$member' => NULL, ], ], 'NotebookMetadataArray' => [ 'base' => NULL, 'refs' => [ 'ListNotebookMetadataOutput$NotebookMetadataList' => '<p>The list of notebook metadata for the specified workgroup.</p>', ], ], 'NotebookName' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInput$Name' => '<p>The name of the <code>ipynb</code> file to be created in the Spark workgroup, without the <code>.ipynb</code> extension.</p>', 'FilterDefinition$Name' => '<p>The name of the notebook to search for.</p>', 'ImportNotebookInput$Name' => '<p>The name of the notebook to import.</p>', 'NotebookMetadata$Name' => '<p>The name of the notebook.</p>', 'UpdateNotebookMetadataInput$Name' => '<p>The name to update the notebook to.</p>', ], ], 'NotebookSessionSummary' => [ 'base' => '<p>Contains the notebook session ID and notebook session creation time.</p>', 'refs' => [ 'NotebookSessionsList$member' => NULL, ], ], 'NotebookSessionsList' => [ 'base' => '<p>A list of notebook sessions.</p>', 'refs' => [ 'ListNotebookSessionsResponse$NotebookSessionsList' => '<p>A list of the sessions belonging to the notebook.</p>', ], ], 'NotebookType' => [ 'base' => NULL, 'refs' => [ 'ImportNotebookInput$Type' => '<p>The notebook content type. Currently, the only valid type is <code>IPYNB</code>.</p>', 'NotebookMetadata$Type' => '<p>The type of notebook. Currently, the only valid type is <code>IPYNB</code>.</p>', 'UpdateNotebookInput$Type' => '<p>The notebook content type. Currently, the only valid type is <code>IPYNB</code>.</p>', ], ], 'ParametersMap' => [ 'base' => NULL, 'refs' => [ 'CreateDataCatalogInput$Parameters' => '<p>Specifies the Lambda function or functions to use for creating the data catalog. This is a mapping whose values depend on the catalog type. </p> <ul> <li> <p>For the <code>HIVE</code> data catalog type, use the following syntax. The <code>metadata-function</code> parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently supported version.</p> <p> <code>metadata-function=<i>lambda_arn</i>, sdk-version=<i>version_number</i> </code> </p> </li> <li> <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets of required parameters, but not both.</p> <ul> <li> <p>If you have one Lambda function that processes metadata and another for reading the actual data, use the following syntax. Both parameters are required.</p> <p> <code>metadata-function=<i>lambda_arn</i>, record-function=<i>lambda_arn</i> </code> </p> </li> <li> <p> If you have a composite Lambda function that processes both metadata and data, use the following syntax to specify your Lambda function.</p> <p> <code>function=<i>lambda_arn</i> </code> </p> </li> </ul> </li> <li> <p>The <code>GLUE</code> type takes a catalog ID parameter and is required. The <code> <i>catalog_id</i> </code> is the account ID of the Amazon Web Services account to which the Glue Data Catalog belongs.</p> <p> <code>catalog-id=<i>catalog_id</i> </code> </p> <ul> <li> <p>The <code>GLUE</code> data catalog type also applies to the default <code>AwsDataCatalog</code> that already exists in your account, of which you can have only one and cannot modify.</p> </li> </ul> </li> </ul>', 'DataCatalog$Parameters' => '<p>Specifies the Lambda function or functions to use for the data catalog. This is a mapping whose values depend on the catalog type. </p> <ul> <li> <p>For the <code>HIVE</code> data catalog type, use the following syntax. The <code>metadata-function</code> parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently supported version.</p> <p> <code>metadata-function=<i>lambda_arn</i>, sdk-version=<i>version_number</i> </code> </p> </li> <li> <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets of required parameters, but not both.</p> <ul> <li> <p>If you have one Lambda function that processes metadata and another for reading the actual data, use the following syntax. Both parameters are required.</p> <p> <code>metadata-function=<i>lambda_arn</i>, record-function=<i>lambda_arn</i> </code> </p> </li> <li> <p> If you have a composite Lambda function that processes both metadata and data, use the following syntax to specify your Lambda function.</p> <p> <code>function=<i>lambda_arn</i> </code> </p> </li> </ul> </li> <li> <p>The <code>GLUE</code> type takes a catalog ID parameter and is required. The <code> <i>catalog_id</i> </code> is the account ID of the Amazon Web Services account to which the Glue catalog belongs.</p> <p> <code>catalog-id=<i>catalog_id</i> </code> </p> <ul> <li> <p>The <code>GLUE</code> data catalog type also applies to the default <code>AwsDataCatalog</code> that already exists in your account, of which you can have only one and cannot modify.</p> </li> </ul> </li> </ul>', 'Database$Parameters' => '<p>A set of custom key/value pairs.</p>', 'EngineConfiguration$AdditionalConfigs' => '<p>Contains additional notebook engine <code>MAP&lt;string, string&gt;</code> parameter mappings in the form of key-value pairs. To specify an Athena notebook that the Jupyter server will download and serve, specify a value for the <a>StartSessionRequest$NotebookVersion</a> field, and then add a key named <code>NotebookId</code> to <code>AdditionalConfigs</code> that has the value of the Athena notebook ID.</p>', 'EngineConfiguration$SparkProperties' => '<p>Specifies custom jar files and Spark properties for use cases like cluster encryption, table formats, and general Spark tuning.</p>', 'TableMetadata$Parameters' => '<p>A set of custom key/value pairs for table properties.</p>', 'UpdateDataCatalogInput$Parameters' => '<p>Specifies the Lambda function or functions to use for updating the data catalog. This is a mapping whose values depend on the catalog type. </p> <ul> <li> <p>For the <code>HIVE</code> data catalog type, use the following syntax. The <code>metadata-function</code> parameter is required. <code>The sdk-version</code> parameter is optional and defaults to the currently supported version.</p> <p> <code>metadata-function=<i>lambda_arn</i>, sdk-version=<i>version_number</i> </code> </p> </li> <li> <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets of required parameters, but not both.</p> <ul> <li> <p>If you have one Lambda function that processes metadata and another for reading the actual data, use the following syntax. Both parameters are required.</p> <p> <code>metadata-function=<i>lambda_arn</i>, record-function=<i>lambda_arn</i> </code> </p> </li> <li> <p> If you have a composite Lambda function that processes both metadata and data, use the following syntax to specify your Lambda function.</p> <p> <code>function=<i>lambda_arn</i> </code> </p> </li> </ul> </li> </ul>', ], ], 'ParametersMapValue' => [ 'base' => NULL, 'refs' => [ 'ParametersMap$value' => NULL, ], ], 'Payload' => [ 'base' => NULL, 'refs' => [ 'ExportNotebookOutput$Payload' => '<p>The content of the exported notebook.</p>', 'ImportNotebookInput$Payload' => '<p>The notebook content to be imported. The payload must be in <code>ipynb</code> format.</p>', 'UpdateNotebookInput$Payload' => '<p>The updated content for the notebook.</p>', ], ], 'PreparedStatement' => [ 'base' => '<p>A prepared SQL statement for use with Athena.</p>', 'refs' => [ 'GetPreparedStatementOutput$PreparedStatement' => '<p>The name of the prepared statement that was retrieved.</p>', 'PreparedStatementDetailsList$member' => NULL, ], ], 'PreparedStatementDetailsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetPreparedStatementOutput$PreparedStatements' => '<p>The list of prepared statements returned.</p>', ], ], 'PreparedStatementNameList' => [ 'base' => NULL, 'refs' => [ 'BatchGetPreparedStatementInput$PreparedStatementNames' => '<p>A list of prepared statement names to return.</p>', ], ], 'PreparedStatementSummary' => [ 'base' => '<p>The name and last modified time of the prepared statement.</p>', 'refs' => [ 'PreparedStatementsList$member' => NULL, ], ], 'PreparedStatementsList' => [ 'base' => NULL, 'refs' => [ 'ListPreparedStatementsOutput$PreparedStatements' => '<p>The list of prepared statements for the workgroup.</p>', ], ], 'PutCapacityAssignmentConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'PutCapacityAssignmentConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'QueryExecution' => [ 'base' => '<p>Information about a single instance of a query execution.</p>', 'refs' => [ 'GetQueryExecutionOutput$QueryExecution' => '<p>Information about the query execution.</p>', 'QueryExecutionList$member' => NULL, ], ], 'QueryExecutionContext' => [ 'base' => '<p>The database and data catalog context in which the query execution occurs.</p>', 'refs' => [ 'QueryExecution$QueryExecutionContext' => '<p>The database in which the query execution occurred.</p>', 'StartQueryExecutionInput$QueryExecutionContext' => '<p>The database within which the query executes.</p>', ], ], 'QueryExecutionId' => [ 'base' => NULL, 'refs' => [ 'GetQueryExecutionInput$QueryExecutionId' => '<p>The unique ID of the query execution.</p>', 'GetQueryResultsInput$QueryExecutionId' => '<p>The unique ID of the query execution.</p>', 'GetQueryRuntimeStatisticsInput$QueryExecutionId' => '<p>The unique ID of the query execution.</p>', 'QueryExecution$QueryExecutionId' => '<p>The unique identifier for each query execution.</p>', 'QueryExecutionIdList$member' => NULL, 'StartQueryExecutionOutput$QueryExecutionId' => '<p>The unique ID of the query that ran as a result of this request.</p>', 'StopQueryExecutionInput$QueryExecutionId' => '<p>The unique ID of the query execution to stop.</p>', 'UnprocessedQueryExecutionId$QueryExecutionId' => '<p>The unique identifier of the query execution.</p>', ], ], 'QueryExecutionIdList' => [ 'base' => NULL, 'refs' => [ 'BatchGetQueryExecutionInput$QueryExecutionIds' => '<p>An array of query execution IDs.</p>', 'ListQueryExecutionsOutput$QueryExecutionIds' => '<p>The unique IDs of each query execution as an array of strings.</p>', ], ], 'QueryExecutionList' => [ 'base' => NULL, 'refs' => [ 'BatchGetQueryExecutionOutput$QueryExecutions' => '<p>Information about a query execution.</p>', ], ], 'QueryExecutionState' => [ 'base' => NULL, 'refs' => [ 'QueryExecutionStatus$State' => '<p>The state of query execution. <code>QUEUED</code> indicates that the query has been submitted to the service, and Athena will execute the query as soon as resources are available. <code>RUNNING</code> indicates that the query is in execution phase. <code>SUCCEEDED</code> indicates that the query completed without errors. <code>FAILED</code> indicates that the query experienced an error and did not complete processing. <code>CANCELLED</code> indicates that a user input interrupted query execution.</p> <note> <p>Athena automatically retries your queries in cases of certain transient errors. As a result, you may see the query state transition from <code>RUNNING</code> or <code>FAILED</code> to <code>QUEUED</code>. </p> </note>', ], ], 'QueryExecutionStatistics' => [ 'base' => '<p>The amount of data scanned during the query execution and the amount of time that it took to execute, and the type of statement that was run.</p>', 'refs' => [ 'QueryExecution$Statistics' => '<p>Query execution statistics, such as the amount of data scanned, the amount of time that the query took to process, and the type of statement that was run.</p>', ], ], 'QueryExecutionStatus' => [ 'base' => '<p>The completion date, current state, submission time, and state change reason (if applicable) for the query execution.</p>', 'refs' => [ 'QueryExecution$Status' => '<p>The completion date, current state, submission time, and state change reason (if applicable) for the query execution.</p>', ], ], 'QueryResultsS3AccessGrantsConfiguration' => [ 'base' => '<p>Specifies whether Amazon S3 access grants are enabled for query results.</p>', 'refs' => [ 'QueryExecution$QueryResultsS3AccessGrantsConfiguration' => '<p>Specifies whether Amazon S3 access grants are enabled for query results.</p>', 'WorkGroupConfiguration$QueryResultsS3AccessGrantsConfiguration' => '<p>Specifies whether Amazon S3 access grants are enabled for query results.</p>', 'WorkGroupConfigurationUpdates$QueryResultsS3AccessGrantsConfiguration' => '<p>Specifies whether Amazon S3 access grants are enabled for query results.</p>', ], ], 'QueryRuntimeStatistics' => [ 'base' => '<p>The query execution timeline, statistics on input and output rows and bytes, and the different query stages that form the query execution plan.</p>', 'refs' => [ 'GetQueryRuntimeStatisticsOutput$QueryRuntimeStatistics' => '<p>Runtime statistics about the query execution.</p>', ], ], 'QueryRuntimeStatisticsRows' => [ 'base' => '<p>Statistics such as input rows and bytes read by the query, rows and bytes output by the query, and the number of rows written by the query.</p>', 'refs' => [ 'QueryRuntimeStatistics$Rows' => NULL, ], ], 'QueryRuntimeStatisticsTimeline' => [ 'base' => '<p>Timeline statistics such as query queue time, planning time, execution time, service processing time, and total execution time.</p>', 'refs' => [ 'QueryRuntimeStatistics$Timeline' => NULL, ], ], 'QueryStage' => [ 'base' => '<p>Stage statistics such as input and output rows and bytes, execution time and stage state. This information also includes substages and the query stage plan.</p>', 'refs' => [ 'QueryRuntimeStatistics$OutputStage' => '<p>Stage statistics such as input and output rows and bytes, execution time, and stage state. This information also includes substages and the query stage plan.</p>', 'QueryStages$member' => NULL, ], ], 'QueryStagePlanNode' => [ 'base' => '<p>Stage plan information such as name, identifier, sub plans, and remote sources.</p>', 'refs' => [ 'QueryStage$QueryStagePlan' => '<p>Stage plan information such as name, identifier, sub plans, and source stages.</p>', 'QueryStagePlanNodes$member' => NULL, ], ], 'QueryStagePlanNodes' => [ 'base' => NULL, 'refs' => [ 'QueryStagePlanNode$Children' => '<p>Stage plan information such as name, identifier, sub plans, and remote sources of child plan nodes/</p>', ], ], 'QueryStages' => [ 'base' => NULL, 'refs' => [ 'QueryStage$SubStages' => '<p>List of sub query stages that form this stage execution plan.</p>', ], ], 'QueryString' => [ 'base' => NULL, 'refs' => [ 'CreateNamedQueryInput$QueryString' => '<p>The contents of the query with all query statements.</p>', 'CreatePreparedStatementInput$QueryStatement' => '<p>The query string for the prepared statement.</p>', 'NamedQuery$QueryString' => '<p>The SQL statements that make up the query.</p>', 'PreparedStatement$QueryStatement' => '<p>The query string for the prepared statement.</p>', 'QueryExecution$Query' => '<p>The SQL query statements which the query execution ran.</p>', 'StartQueryExecutionInput$QueryString' => '<p>The SQL query statements to be executed.</p>', 'UpdateNamedQueryInput$QueryString' => '<p>The contents of the query with all query statements.</p>', 'UpdatePreparedStatementInput$QueryStatement' => '<p>The query string for the prepared statement.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A resource, such as a workgroup, was not found.</p>', 'refs' => [], ], 'ResultConfiguration' => [ 'base' => '<p>The location in Amazon S3 where query and calculation results are stored and the encryption option, if any, used for query and calculation results. These are known as "client-side settings". If workgroup settings override client-side settings, then the query uses the workgroup settings.</p>', 'refs' => [ 'QueryExecution$ResultConfiguration' => '<p>The location in Amazon S3 where query and calculation results are stored and the encryption option, if any, used for query results. These are known as "client-side settings". If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup.</p>', 'StartQueryExecutionInput$ResultConfiguration' => '<p>Specifies information about where and how to save the results of the query execution. If the query runs in a workgroup, then workgroup\'s settings may override query settings. This affects the query results location. The workgroup settings override is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>', 'WorkGroupConfiguration$ResultConfiguration' => '<p>The configuration for the workgroup, which includes the location in Amazon S3 where query and calculation results are stored and the encryption option, if any, used for query and calculation results. To run the query, you must specify the query results location using one of the ways: either in the workgroup using this setting, or for individual queries (client-side), using <a>ResultConfiguration$OutputLocation</a>. If none of them is set, Athena issues an error that no output location is provided.</p>', ], ], 'ResultConfigurationUpdates' => [ 'base' => '<p>The information about the updates in the query results, such as output location and encryption configuration for the query results.</p>', 'refs' => [ 'WorkGroupConfigurationUpdates$ResultConfigurationUpdates' => '<p>The result configuration information about the queries in this workgroup that will be updated. Includes the updated results location and an updated option for encrypting query results.</p>', ], ], 'ResultOutputLocation' => [ 'base' => NULL, 'refs' => [ 'ResultConfiguration$OutputLocation' => '<p>The location in Amazon S3 where your query and calculation results are stored, such as <code>s3://path/to/query/bucket/</code>. To run the query, you must specify the query results location using one of the ways: either for individual queries using either this setting (client-side), or in the workgroup, using <a>WorkGroupConfiguration</a>. If none of them is set, Athena issues an error that no output location is provided. If workgroup settings override client-side settings, then the query uses the settings specified for the workgroup. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>', 'ResultConfigurationUpdates$OutputLocation' => '<p>The location in Amazon S3 where your query and calculation results are stored, such as <code>s3://path/to/query/bucket/</code>. If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup. The "workgroup settings override" is specified in <code>EnforceWorkGroupConfiguration</code> (true/false) in the <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>', 'SessionConfiguration$WorkingDirectory' => '<p>The Amazon S3 location that stores information for the notebook.</p>', ], ], 'ResultReuseByAgeConfiguration' => [ 'base' => '<p>Specifies whether previous query results are reused, and if so, their maximum age.</p>', 'refs' => [ 'ResultReuseConfiguration$ResultReuseByAgeConfiguration' => '<p>Specifies whether previous query results are reused, and if so, their maximum age.</p>', ], ], 'ResultReuseConfiguration' => [ 'base' => '<p>Specifies the query result reuse behavior for the query.</p>', 'refs' => [ 'QueryExecution$ResultReuseConfiguration' => '<p>Specifies the query result reuse behavior that was used for the query.</p>', 'StartQueryExecutionInput$ResultReuseConfiguration' => '<p>Specifies the query result reuse behavior for the query.</p>', ], ], 'ResultReuseInformation' => [ 'base' => '<p>Contains information about whether the result of a previous query was reused.</p>', 'refs' => [ 'QueryExecutionStatistics$ResultReuseInformation' => '<p>Contains information about whether previous query results were reused for the query.</p>', ], ], 'ResultSet' => [ 'base' => '<p>The metadata and rows that make up a query result set. The metadata describes the column structure and data types. To return a <code>ResultSet</code> object, use <a>GetQueryResults</a>.</p>', 'refs' => [ 'GetQueryResultsOutput$ResultSet' => '<p>The results of the query execution.</p>', ], ], 'ResultSetMetadata' => [ 'base' => '<p>The metadata that describes the column structure and data types of a table of query results. To return a <code>ResultSetMetadata</code> object, use <a>GetQueryResults</a>.</p>', 'refs' => [ 'ResultSet$ResultSetMetadata' => '<p>The metadata that describes the column structure and data types of a table of query results.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'SessionConfiguration$ExecutionRole' => '<p>The ARN of the execution role used to access user resources for Spark sessions and Identity Center enabled workgroups. This property applies only to Spark enabled workgroups and Identity Center enabled workgroups.</p>', 'WorkGroupConfiguration$ExecutionRole' => '<p>The ARN of the execution role used to access user resources for Spark sessions and IAM Identity Center enabled workgroups. This property applies only to Spark enabled workgroups and IAM Identity Center enabled workgroups. The property is required for IAM Identity Center enabled workgroups.</p>', 'WorkGroupConfigurationUpdates$ExecutionRole' => '<p>The ARN of the execution role used to access user resources for Spark sessions and Identity Center enabled workgroups. This property applies only to Spark enabled workgroups and Identity Center enabled workgroups.</p>', ], ], 'Row' => [ 'base' => '<p>The rows that make up a query result table.</p>', 'refs' => [ 'RowList$member' => NULL, ], ], 'RowList' => [ 'base' => NULL, 'refs' => [ 'ResultSet$Rows' => '<p>The rows in the table.</p>', ], ], 'S3AclOption' => [ 'base' => NULL, 'refs' => [ 'AclConfiguration$S3AclOption' => '<p>The Amazon S3 canned ACL that Athena should specify when storing query results. Currently the only supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code>. If a query runs in a workgroup and the workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup\'s settings is used for all queries that run in the workgroup. For more information about Amazon S3 canned ACLs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">Canned ACL</a> in the <i>Amazon S3 User Guide</i>.</p>', ], ], 'S3Uri' => [ 'base' => NULL, 'refs' => [ 'CalculationResult$StdOutS3Uri' => '<p>The Amazon S3 location of the <code>stdout</code> file for the calculation.</p>', 'CalculationResult$StdErrorS3Uri' => '<p>The Amazon S3 location of the <code>stderr</code> error messages file for the calculation.</p>', 'CalculationResult$ResultS3Uri' => '<p>The Amazon S3 location of the folder for the calculation results.</p>', 'GetCalculationExecutionResponse$WorkingDirectory' => '<p>The Amazon S3 location in which calculation results are stored.</p>', 'ImportNotebookInput$NotebookS3LocationUri' => '<p>A URI that specifies the Amazon S3 location of a notebook file in <code>ipynb</code> format.</p>', ], ], 'SessionAlreadyExistsException' => [ 'base' => '<p>The specified session already exists.</p>', 'refs' => [], ], 'SessionConfiguration' => [ 'base' => '<p>Contains session configuration information.</p>', 'refs' => [ 'GetSessionResponse$SessionConfiguration' => '<p>Contains the workgroup configuration information used by the session.</p>', ], ], 'SessionId' => [ 'base' => NULL, 'refs' => [ 'CreatePresignedNotebookUrlRequest$SessionId' => '<p>The session ID.</p>', 'GetCalculationExecutionResponse$SessionId' => '<p>The session ID that the calculation ran in.</p>', 'GetSessionRequest$SessionId' => '<p>The session ID.</p>', 'GetSessionResponse$SessionId' => '<p>The session ID.</p>', 'GetSessionStatusRequest$SessionId' => '<p>The session ID.</p>', 'GetSessionStatusResponse$SessionId' => '<p>The session ID.</p>', 'ListCalculationExecutionsRequest$SessionId' => '<p>The session ID.</p>', 'ListExecutorsRequest$SessionId' => '<p>The session ID.</p>', 'ListExecutorsResponse$SessionId' => '<p>The session ID.</p>', 'NotebookSessionSummary$SessionId' => '<p>The notebook session ID.</p>', 'SessionSummary$SessionId' => '<p>The session ID.</p>', 'StartCalculationExecutionRequest$SessionId' => '<p>The session ID.</p>', 'StartSessionResponse$SessionId' => '<p>The session ID.</p>', 'TerminateSessionRequest$SessionId' => '<p>The session ID.</p>', 'UpdateNotebookInput$SessionId' => '<p>The active notebook session ID. Required if the notebook has an active session.</p>', ], ], 'SessionIdleTimeoutInMinutes' => [ 'base' => NULL, 'refs' => [ 'StartSessionRequest$SessionIdleTimeoutInMinutes' => '<p>The idle timeout in minutes for the session.</p>', ], ], 'SessionManagerToken' => [ 'base' => NULL, 'refs' => [ 'ListCalculationExecutionsRequest$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListCalculationExecutionsResponse$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListExecutorsRequest$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListExecutorsResponse$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListSessionsRequest$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListSessionsResponse$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', ], ], 'SessionState' => [ 'base' => NULL, 'refs' => [ 'ListSessionsRequest$StateFilter' => '<p>A filter for a specific session state. A description of each state follows.</p> <p> <code>CREATING</code> - The session is being started, including acquiring resources.</p> <p> <code>CREATED</code> - The session has been started.</p> <p> <code>IDLE</code> - The session is able to accept a calculation.</p> <p> <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.</p> <p> <code>TERMINATING</code> - The session is in the process of shutting down.</p> <p> <code>TERMINATED</code> - The session and its resources are no longer running.</p> <p> <code>DEGRADED</code> - The session has no healthy coordinators.</p> <p> <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.</p>', 'SessionStatus$State' => '<p>The state of the session. A description of each state follows.</p> <p> <code>CREATING</code> - The session is being started, including acquiring resources.</p> <p> <code>CREATED</code> - The session has been started.</p> <p> <code>IDLE</code> - The session is able to accept a calculation.</p> <p> <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.</p> <p> <code>TERMINATING</code> - The session is in the process of shutting down.</p> <p> <code>TERMINATED</code> - The session and its resources are no longer running.</p> <p> <code>DEGRADED</code> - The session has no healthy coordinators.</p> <p> <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.</p>', 'StartSessionResponse$State' => '<p>The state of the session. A description of each state follows.</p> <p> <code>CREATING</code> - The session is being started, including acquiring resources.</p> <p> <code>CREATED</code> - The session has been started.</p> <p> <code>IDLE</code> - The session is able to accept a calculation.</p> <p> <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.</p> <p> <code>TERMINATING</code> - The session is in the process of shutting down.</p> <p> <code>TERMINATED</code> - The session and its resources are no longer running.</p> <p> <code>DEGRADED</code> - The session has no healthy coordinators.</p> <p> <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.</p>', 'TerminateSessionResponse$State' => '<p>The state of the session. A description of each state follows.</p> <p> <code>CREATING</code> - The session is being started, including acquiring resources.</p> <p> <code>CREATED</code> - The session has been started.</p> <p> <code>IDLE</code> - The session is able to accept a calculation.</p> <p> <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.</p> <p> <code>TERMINATING</code> - The session is in the process of shutting down.</p> <p> <code>TERMINATED</code> - The session and its resources are no longer running.</p> <p> <code>DEGRADED</code> - The session has no healthy coordinators.</p> <p> <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.</p>', ], ], 'SessionStatistics' => [ 'base' => '<p>Contains statistics for a session.</p>', 'refs' => [ 'GetSessionResponse$Statistics' => '<p>Contains the DPU execution time.</p>', ], ], 'SessionStatus' => [ 'base' => '<p>Contains information about the status of a session.</p>', 'refs' => [ 'GetSessionResponse$Status' => '<p>Contains information about the status of the session.</p>', 'GetSessionStatusResponse$Status' => '<p>Contains information about the status of the session.</p>', 'SessionSummary$Status' => '<p>Contains information about the session status.</p>', ], ], 'SessionSummary' => [ 'base' => '<p>Contains summary information about a session.</p>', 'refs' => [ 'SessionsList$member' => NULL, ], ], 'SessionsList' => [ 'base' => NULL, 'refs' => [ 'ListSessionsResponse$Sessions' => '<p>A list of sessions.</p>', ], ], 'StartCalculationExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartCalculationExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartQueryExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'StartQueryExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatementName' => [ 'base' => NULL, 'refs' => [ 'CreatePreparedStatementInput$StatementName' => '<p>The name of the prepared statement.</p>', 'DeletePreparedStatementInput$StatementName' => '<p>The name of the prepared statement to delete.</p>', 'GetPreparedStatementInput$StatementName' => '<p>The name of the prepared statement to retrieve.</p>', 'PreparedStatement$StatementName' => '<p>The name of the prepared statement.</p>', 'PreparedStatementNameList$member' => NULL, 'PreparedStatementSummary$StatementName' => '<p>The name of the prepared statement.</p>', 'UnprocessedPreparedStatementName$StatementName' => '<p>The name of a prepared statement that could not be returned due to an error.</p>', 'UpdatePreparedStatementInput$StatementName' => '<p>The name of the prepared statement.</p>', ], ], 'StatementType' => [ 'base' => NULL, 'refs' => [ 'QueryExecution$StatementType' => '<p>The type of query statement that was run. <code>DDL</code> indicates DDL query statements. <code>DML</code> indicates DML (Data Manipulation Language) query statements, such as <code>CREATE TABLE AS SELECT</code>. <code>UTILITY</code> indicates query statements other than DDL and DML, such as <code>SHOW CREATE TABLE</code>, or <code>DESCRIBE TABLE</code>.</p>', ], ], 'StopCalculationExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopCalculationExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopQueryExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'StopQueryExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AthenaError$ErrorMessage' => '<p>Contains a short description of the error that occurred.</p>', 'CapacityAllocation$StatusMessage' => '<p>The status message of the capacity allocation.</p>', 'ColumnInfo$CatalogName' => '<p>The catalog to which the query results belong.</p>', 'ColumnInfo$SchemaName' => '<p>The schema name (database name) to which the query results belong.</p>', 'ColumnInfo$TableName' => '<p>The table name for the query results.</p>', 'ColumnInfo$Name' => '<p>The name of the column.</p>', 'ColumnInfo$Label' => '<p>A column label.</p>', 'ColumnInfo$Type' => '<p>The data type of the column.</p>', 'CreatePresignedNotebookUrlResponse$NotebookUrl' => '<p>The URL of the notebook. The URL includes the authentication token and notebook file name and points directly to the opened notebook.</p>', 'EncryptionConfiguration$KmsKey' => '<p>For <code>SSE_KMS</code> and <code>CSE_KMS</code>, this is the KMS key ARN or ID.</p>', 'QueryExecution$SubstatementType' => '<p>The kind of query statement that was run.</p>', 'QueryExecutionStatistics$DataManifestLocation' => '<p>The location and file name of a data manifest file. The manifest file is saved to the Athena query results location in Amazon S3. The manifest file tracks files that the query wrote to Amazon S3. If the query fails, the manifest file also tracks files that the query intended to write. The manifest is useful for identifying orphaned files resulting from a failed query. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with Query Results, Output Files, and Query History</a> in the <i>Amazon Athena User Guide</i>.</p>', 'QueryExecutionStatus$StateChangeReason' => '<p>Further detail about the status of the query.</p>', 'QueryStage$State' => '<p>State of the stage after query execution.</p>', 'QueryStagePlanNode$Name' => '<p>Name of the query stage plan that describes the operation this stage is performing as part of query execution.</p>', 'QueryStagePlanNode$Identifier' => '<p>Information about the operation this query stage plan node is performing.</p>', 'StringList$member' => NULL, ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'QueryStagePlanNode$RemoteSources' => '<p>Source plan node IDs.</p>', ], ], 'SupportedDPUSizeList' => [ 'base' => NULL, 'refs' => [ 'ApplicationDPUSizes$SupportedDPUSizes' => '<p>A list of the supported DPU sizes that the application runtime supports.</p>', ], ], 'TableMetadata' => [ 'base' => '<p>Contains metadata for a table.</p>', 'refs' => [ 'GetTableMetadataOutput$TableMetadata' => '<p>An object that contains table metadata.</p>', 'TableMetadataList$member' => NULL, ], ], 'TableMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListTableMetadataOutput$TableMetadataList' => '<p>A list of table metadata.</p>', ], ], 'TableTypeString' => [ 'base' => NULL, 'refs' => [ 'TableMetadata$TableType' => '<p>The type of table. In Athena, only <code>EXTERNAL_TABLE</code> is supported.</p>', ], ], 'Tag' => [ 'base' => '<p>A label that you assign to a resource. Athena resources include workgroups, data catalogs, and capacity reservations. Each tag consists of a key and an optional value, both of which you define. For example, you can use tags to categorize Athena resources by purpose, owner, or environment. Use a consistent set of tag keys to make it easier to search and filter the resources in your account. For best practices, see <a href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html">Tagging Best Practices</a>. Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256 UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify more than one tag, separate them by commas. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>A tag key. The tag key length is from 1 to 128 Unicode characters in UTF-8. You can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @. Tag keys are case-sensitive and must be unique per resource. </p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeys' => '<p>A comma-separated list of one or more tag keys whose tags are to be removed from the specified resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateCapacityReservationInput$Tags' => '<p>The tags for the capacity reservation.</p>', 'CreateDataCatalogInput$Tags' => '<p>A list of comma separated tags to add to the data catalog that is created.</p>', 'CreateWorkGroupInput$Tags' => '<p>A list of comma separated tags to add to the workgroup that is created.</p>', 'ListTagsForResourceOutput$Tags' => '<p>The list of tags associated with the specified resource.</p>', 'TagResourceInput$Tags' => '<p>A collection of one or more tags, separated by commas, to be added to an Athena resource.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>A tag value. The tag value length is from 0 to 256 Unicode characters in UTF-8. You can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @. Tag values are case-sensitive. </p>', ], ], 'TargetDpusInteger' => [ 'base' => NULL, 'refs' => [ 'CapacityReservation$TargetDpus' => '<p>The number of data processing units requested.</p>', 'CreateCapacityReservationInput$TargetDpus' => '<p>The number of requested data processing units.</p>', 'UpdateCapacityReservationInput$TargetDpus' => '<p>The new number of requested data processing units.</p>', ], ], 'TerminateSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'TerminateSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ThrottleReason' => [ 'base' => '<p>The reason for the query throttling, for example, when it exceeds the concurrent query limit.</p>', 'refs' => [ 'TooManyRequestsException$Reason' => NULL, ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CapacityAllocation$RequestTime' => '<p>The time when the capacity allocation was requested.</p>', 'CapacityAllocation$RequestCompletionTime' => '<p>The time when the capacity allocation request was completed.</p>', 'CapacityReservation$LastSuccessfulAllocationTime' => '<p>The time of the most recent capacity allocation that succeeded.</p>', 'CapacityReservation$CreationTime' => '<p>The time in UTC epoch millis when the capacity reservation was created.</p>', 'TableMetadata$CreateTime' => '<p>The time that the table was created.</p>', 'TableMetadata$LastAccessTime' => '<p>The last time the table was accessed.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'GetQueryResultsInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'GetQueryResultsOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListApplicationDPUSizesInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated.</p>', 'ListApplicationDPUSizesOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListCapacityReservationsInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated.</p>', 'ListCapacityReservationsOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call.</p>', 'ListDataCatalogsInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call.</p>', 'ListDataCatalogsOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call.</p>', 'ListDatabasesInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListDatabasesOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call.</p>', 'ListEngineVersionsInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListEngineVersionsOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListNamedQueriesInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListNamedQueriesOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListNotebookMetadataInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated.</p>', 'ListNotebookMetadataOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListNotebookSessionsRequest$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListNotebookSessionsResponse$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListPreparedStatementsInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListPreparedStatementsOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListQueryExecutionsInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListQueryExecutionsOutput$NextToken' => '<p>A token to be used by the next request if this request is truncated.</p>', 'ListTableMetadataInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call.</p>', 'ListTableMetadataOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call.</p>', 'ListTagsForResourceInput$NextToken' => '<p>The token for the next set of results, or null if there are no additional results for this request, where the request lists the tags for the resource with the specified ARN.</p>', 'ListTagsForResourceOutput$NextToken' => '<p>A token to be used by the next request if this request is truncated.</p>', 'ListWorkGroupsInput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', 'ListWorkGroupsOutput$NextToken' => '<p>A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the previous page call.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>Indicates that the request was throttled.</p>', 'refs' => [], ], 'TypeString' => [ 'base' => NULL, 'refs' => [ 'Column$Type' => '<p>The data type of the column.</p>', ], ], 'UnprocessedNamedQueryId' => [ 'base' => '<p>Information about a named query ID that could not be processed.</p>', 'refs' => [ 'UnprocessedNamedQueryIdList$member' => NULL, ], ], 'UnprocessedNamedQueryIdList' => [ 'base' => NULL, 'refs' => [ 'BatchGetNamedQueryOutput$UnprocessedNamedQueryIds' => '<p>Information about provided query IDs.</p>', ], ], 'UnprocessedPreparedStatementName' => [ 'base' => '<p>The name of a prepared statement that could not be returned.</p>', 'refs' => [ 'UnprocessedPreparedStatementNameList$member' => NULL, ], ], 'UnprocessedPreparedStatementNameList' => [ 'base' => NULL, 'refs' => [ 'BatchGetPreparedStatementOutput$UnprocessedPreparedStatementNames' => '<p>A list of one or more prepared statements that were requested but could not be returned.</p>', ], ], 'UnprocessedQueryExecutionId' => [ 'base' => '<p>Describes a query execution that failed to process.</p>', 'refs' => [ 'UnprocessedQueryExecutionIdList$member' => NULL, ], ], 'UnprocessedQueryExecutionIdList' => [ 'base' => NULL, 'refs' => [ 'BatchGetQueryExecutionOutput$UnprocessedQueryExecutionIds' => '<p>Information about the query executions that failed to run.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCapacityReservationInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCapacityReservationOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataCatalogInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataCatalogOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNamedQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNamedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNotebookInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNotebookMetadataInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNotebookMetadataOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNotebookOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePreparedStatementInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePreparedStatementOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'WorkGroup' => [ 'base' => '<p>A workgroup, which contains a name, description, creation time, state, and other configuration, listed under <a>WorkGroup$Configuration</a>. Each workgroup enables you to isolate queries for you or your group of users from other queries in the same account, to configure the query results location and the encryption configuration (known as workgroup settings), to enable sending query metrics to Amazon CloudWatch, and to establish per-query data usage control limits for all queries in a workgroup. The workgroup settings override is specified in <code>EnforceWorkGroupConfiguration</code> (true/false) in the <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>', 'refs' => [ 'GetWorkGroupOutput$WorkGroup' => '<p>Information about the workgroup.</p>', ], ], 'WorkGroupConfiguration' => [ 'base' => '<p>The configuration of the workgroup, which includes the location in Amazon S3 where query and calculation results are stored, the encryption option, if any, used for query and calculation results, whether the Amazon CloudWatch Metrics are enabled for the workgroup and whether workgroup settings override query settings, and the data usage limits for the amount of data scanned per query or per workgroup. The workgroup settings override is specified in <code>EnforceWorkGroupConfiguration</code> (true/false) in the <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>. </p>', 'refs' => [ 'CreateWorkGroupInput$Configuration' => '<p>Contains configuration information for creating an Athena SQL workgroup or Spark enabled Athena workgroup. Athena SQL workgroup configuration includes the location in Amazon S3 where query and calculation results are stored, the encryption configuration, if any, used for encrypting query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, the limit for the amount of bytes scanned (cutoff) per query, if it is specified, and whether workgroup\'s settings (specified with <code>EnforceWorkGroupConfiguration</code>) in the <code>WorkGroupConfiguration</code> override client-side settings. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>', 'WorkGroup$Configuration' => '<p>The configuration of the workgroup, which includes the location in Amazon S3 where query and calculation results are stored, the encryption configuration, if any, used for query and calculation results; whether the Amazon CloudWatch Metrics are enabled for the workgroup; whether workgroup settings override client-side settings; and the data usage limits for the amount of data scanned per query or per workgroup. The workgroup settings override is specified in <code>EnforceWorkGroupConfiguration</code> (true/false) in the <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>', ], ], 'WorkGroupConfigurationUpdates' => [ 'base' => '<p>The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query and calculation results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.</p>', 'refs' => [ 'UpdateWorkGroupInput$ConfigurationUpdates' => '<p>Contains configuration updates for an Athena SQL workgroup.</p>', ], ], 'WorkGroupDescriptionString' => [ 'base' => NULL, 'refs' => [ 'CreateWorkGroupInput$Description' => '<p>The workgroup description.</p>', 'UpdateWorkGroupInput$Description' => '<p>The workgroup description.</p>', 'WorkGroup$Description' => '<p>The workgroup description.</p>', 'WorkGroupSummary$Description' => '<p>The workgroup description.</p>', ], ], 'WorkGroupName' => [ 'base' => NULL, 'refs' => [ 'BatchGetPreparedStatementInput$WorkGroup' => '<p>The name of the workgroup to which the prepared statements belong.</p>', 'CreateNamedQueryInput$WorkGroup' => '<p>The name of the workgroup in which the named query is being created.</p>', 'CreateNotebookInput$WorkGroup' => '<p>The name of the Spark enabled workgroup in which the notebook will be created.</p>', 'CreatePreparedStatementInput$WorkGroup' => '<p>The name of the workgroup to which the prepared statement belongs.</p>', 'CreateWorkGroupInput$Name' => '<p>The workgroup name.</p>', 'DeletePreparedStatementInput$WorkGroup' => '<p>The workgroup to which the statement to be deleted belongs.</p>', 'DeleteWorkGroupInput$WorkGroup' => '<p>The unique name of the workgroup to delete.</p>', 'GetDataCatalogInput$WorkGroup' => '<p>The name of the workgroup. Required if making an IAM Identity Center request.</p>', 'GetDatabaseInput$WorkGroup' => '<p>The name of the workgroup for which the metadata is being fetched. Required if requesting an IAM Identity Center enabled Glue Data Catalog.</p>', 'GetPreparedStatementInput$WorkGroup' => '<p>The workgroup to which the statement to be retrieved belongs.</p>', 'GetSessionResponse$WorkGroup' => '<p>The workgroup to which the session belongs.</p>', 'GetTableMetadataInput$WorkGroup' => '<p>The name of the workgroup for which the metadata is being fetched. Required if requesting an IAM Identity Center enabled Glue Data Catalog.</p>', 'GetWorkGroupInput$WorkGroup' => '<p>The name of the workgroup.</p>', 'ImportNotebookInput$WorkGroup' => '<p>The name of the Spark enabled workgroup to import the notebook to.</p>', 'ListDataCatalogsInput$WorkGroup' => '<p>The name of the workgroup. Required if making an IAM Identity Center request.</p>', 'ListDatabasesInput$WorkGroup' => '<p>The name of the workgroup for which the metadata is being fetched. Required if requesting an IAM Identity Center enabled Glue Data Catalog.</p>', 'ListNamedQueriesInput$WorkGroup' => '<p>The name of the workgroup from which the named queries are being returned. If a workgroup is not specified, the saved queries for the primary workgroup are returned.</p>', 'ListNotebookMetadataInput$WorkGroup' => '<p>The name of the Spark enabled workgroup to retrieve notebook metadata for.</p>', 'ListPreparedStatementsInput$WorkGroup' => '<p>The workgroup to list the prepared statements for.</p>', 'ListQueryExecutionsInput$WorkGroup' => '<p>The name of the workgroup from which queries are being returned. If a workgroup is not specified, a list of available query execution IDs for the queries in the primary workgroup is returned.</p>', 'ListSessionsRequest$WorkGroup' => '<p>The workgroup to which the session belongs.</p>', 'ListTableMetadataInput$WorkGroup' => '<p>The name of the workgroup for which the metadata is being fetched. Required if requesting an IAM Identity Center enabled Glue Data Catalog.</p>', 'NamedQuery$WorkGroup' => '<p>The name of the workgroup that contains the named query.</p>', 'NotebookMetadata$WorkGroup' => '<p>The name of the Spark enabled workgroup to which the notebook belongs.</p>', 'PreparedStatement$WorkGroupName' => '<p>The name of the workgroup to which the prepared statement belongs.</p>', 'QueryExecution$WorkGroup' => '<p>The name of the workgroup in which the query ran.</p>', 'StartQueryExecutionInput$WorkGroup' => '<p>The name of the workgroup in which the query is being started.</p>', 'StartSessionRequest$WorkGroup' => '<p>The workgroup to which the session belongs.</p>', 'UpdatePreparedStatementInput$WorkGroup' => '<p>The workgroup for the prepared statement.</p>', 'UpdateWorkGroupInput$WorkGroup' => '<p>The specified workgroup that will be updated.</p>', 'WorkGroup$Name' => '<p>The workgroup name.</p>', 'WorkGroupNamesList$member' => NULL, 'WorkGroupSummary$Name' => '<p>The name of the workgroup.</p>', ], ], 'WorkGroupNamesList' => [ 'base' => NULL, 'refs' => [ 'CapacityAssignment$WorkGroupNames' => '<p>The list of workgroup names for the capacity assignment.</p>', ], ], 'WorkGroupState' => [ 'base' => NULL, 'refs' => [ 'UpdateWorkGroupInput$State' => '<p>The workgroup state that will be updated for the given workgroup.</p>', 'WorkGroup$State' => '<p>The state of the workgroup: ENABLED or DISABLED.</p>', 'WorkGroupSummary$State' => '<p>The state of the workgroup.</p>', ], ], 'WorkGroupSummary' => [ 'base' => '<p>The summary information for the workgroup, which includes its name, state, description, and the date and time it was created.</p>', 'refs' => [ 'WorkGroupsList$member' => NULL, ], ], 'WorkGroupsList' => [ 'base' => NULL, 'refs' => [ 'ListWorkGroupsOutput$WorkGroups' => '<p>A list of <a>WorkGroupSummary</a> objects that include the names, descriptions, creation times, and states for each workgroup.</p>', ], ], 'datumList' => [ 'base' => NULL, 'refs' => [ 'Row$Data' => '<p>The data that populates a row in a query result table.</p>', ], ], 'datumString' => [ 'base' => NULL, 'refs' => [ 'Datum$VarCharValue' => '<p>The value of the datum.</p>', ], ], ],];
