<?php
// This file was auto-generated from sdk-root/src/data/backup-gateway/2021-01-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p><fullname>Backup gateway</fullname> <p>Backup gateway connects Backup to your hypervisor, so you can create, store, and restore backups of your virtual machines (VMs) anywhere, whether on-premises or in the VMware Cloud (VMC) on Amazon Web Services.</p> <p>Add on-premises resources by connecting to a hypervisor through a gateway. Backup will automatically discover the resources in your hypervisor.</p> <p>Use Backup to assign virtual or on-premises resources to a backup plan, or run on-demand backups. Once you have backed up your resources, you can view them and restore them like any resource supported by Backup.</p> <p>To download the Amazon Web Services software to get started, navigate to the Backup console, choose <b>Gateways</b>, then choose <b>Create gateway</b>.</p></p>', 'operations' => [ 'AssociateGatewayToServer' => '<p>Associates a backup gateway with your server. After you complete the association process, you can back up and restore your VMs through the gateway.</p>', 'CreateGateway' => '<p>Creates a backup gateway. After you create a gateway, you can associate it with a server using the <code>AssociateGatewayToServer</code> operation.</p>', 'DeleteGateway' => '<p>Deletes a backup gateway.</p>', 'DeleteHypervisor' => '<p>Deletes a hypervisor.</p>', 'DisassociateGatewayFromServer' => '<p>Disassociates a backup gateway from the specified server. After the disassociation process finishes, the gateway can no longer access the virtual machines on the server.</p>', 'GetBandwidthRateLimitSchedule' => '<p>Retrieves the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. Use this to get a gateway\'s bandwidth rate limit schedule.</p>', 'GetGateway' => '<p>By providing the ARN (Amazon Resource Name), this API returns the gateway.</p>', 'GetHypervisor' => '<p>This action requests information about the specified hypervisor to which the gateway will connect. A hypervisor is hardware, software, or firmware that creates and manages virtual machines, and allocates resources to them.</p>', 'GetHypervisorPropertyMappings' => '<p>This action retrieves the property mappings for the specified hypervisor. A hypervisor property mapping displays the relationship of entity properties available from the on-premises hypervisor to the properties available in Amazon Web Services.</p>', 'GetVirtualMachine' => '<p>By providing the ARN (Amazon Resource Name), this API returns the virtual machine.</p>', 'ImportHypervisorConfiguration' => '<p>Connect to a hypervisor by importing its configuration.</p>', 'ListGateways' => '<p>Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list is ordered by gateway Amazon Resource Name (ARN).</p>', 'ListHypervisors' => '<p>Lists your hypervisors.</p>', 'ListTagsForResource' => '<p>Lists the tags applied to the resource identified by its Amazon Resource Name (ARN).</p>', 'ListVirtualMachines' => '<p>Lists your virtual machines.</p>', 'PutBandwidthRateLimitSchedule' => '<p>This action sets the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have a bandwidth rate limit schedule, which means no bandwidth rate limiting is in effect. Use this to initiate a gateway\'s bandwidth rate limit schedule.</p>', 'PutHypervisorPropertyMappings' => '<p>This action sets the property mappings for the specified hypervisor. A hypervisor property mapping displays the relationship of entity properties available from the on-premises hypervisor to the properties available in Amazon Web Services.</p>', 'PutMaintenanceStartTime' => '<p>Set the maintenance start time for a gateway.</p>', 'StartVirtualMachinesMetadataSync' => '<p>This action sends a request to sync metadata across the specified virtual machines.</p>', 'TagResource' => '<p>Tag the resource.</p>', 'TestHypervisorConfiguration' => '<p>Tests your hypervisor configuration to validate that backup gateway can connect with the hypervisor and its resources.</p>', 'UntagResource' => '<p>Removes tags from the resource.</p>', 'UpdateGatewayInformation' => '<p>Updates a gateway\'s name. Specify which gateway to update using the Amazon Resource Name (ARN) of the gateway in your request.</p>', 'UpdateGatewaySoftwareNow' => '<p>Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.</p> <note> <p>When you make this request, you get a <code>200 OK</code> success response immediately. However, it might take some time for the update to complete.</p> </note>', 'UpdateHypervisor' => '<p>Updates a hypervisor metadata, including its host, username, and password. Specify which hypervisor to update using the Amazon Resource Name (ARN) of the hypervisor in your request.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The operation cannot proceed because you have insufficient permissions.</p>', 'refs' => [], ], 'ActivationKey' => [ 'base' => NULL, 'refs' => [ 'CreateGatewayInput$ActivationKey' => '<p>The activation key of the created gateway.</p>', ], ], 'AssociateGatewayToServerInput' => [ 'base' => NULL, 'refs' => [], ], 'AssociateGatewayToServerOutput' => [ 'base' => NULL, 'refs' => [], ], 'AverageUploadRateLimit' => [ 'base' => NULL, 'refs' => [ 'BandwidthRateLimitInterval$AverageUploadRateLimitInBitsPerSec' => '<p>The average upload rate limit component of the bandwidth rate limit interval, in bits per second. This field does not appear in the response if the upload rate limit is not set.</p> <note> <p>For Backup Gateway, the minimum value is <code>(Value)</code>.</p> </note>', ], ], 'BandwidthRateLimitInterval' => [ 'base' => '<p>Describes a bandwidth rate limit interval for a gateway. A bandwidth rate limit schedule consists of one or more bandwidth rate limit intervals. A bandwidth rate limit interval defines a period of time on one or more days of the week, during which bandwidth rate limits are specified for uploading, downloading, or both.</p>', 'refs' => [ 'BandwidthRateLimitIntervals$member' => NULL, ], ], 'BandwidthRateLimitIntervals' => [ 'base' => NULL, 'refs' => [ 'GetBandwidthRateLimitScheduleOutput$BandwidthRateLimitIntervals' => '<p>An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit intervals have been scheduled, the array is empty.</p>', 'PutBandwidthRateLimitScheduleInput$BandwidthRateLimitIntervals' => '<p>An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit intervals have been scheduled, the array is empty.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The operation cannot proceed because it is not supported.</p>', 'refs' => [], ], 'CreateGatewayInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateGatewayOutput' => [ 'base' => NULL, 'refs' => [], ], 'DayOfMonth' => [ 'base' => NULL, 'refs' => [ 'MaintenanceStartTime$DayOfMonth' => '<p>The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month and 28 represents the last day of the month.</p>', 'PutMaintenanceStartTimeInput$DayOfMonth' => '<p>The day of the month start maintenance on a gateway.</p> <p>Valid values range from <code>Sunday</code> to <code>Saturday</code>.</p>', ], ], 'DayOfWeek' => [ 'base' => NULL, 'refs' => [ 'DaysOfWeek$member' => NULL, 'MaintenanceStartTime$DayOfWeek' => '<p>An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6 represents Saturday. The day of week is in the time zone of the gateway.</p>', 'PutMaintenanceStartTimeInput$DayOfWeek' => '<p>The day of the week to start maintenance on a gateway.</p>', ], ], 'DaysOfWeek' => [ 'base' => NULL, 'refs' => [ 'BandwidthRateLimitInterval$DaysOfWeek' => '<p>The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers from 0 to 6, where 0 represents Sunday and 6 represents Saturday.</p>', ], ], 'DeleteGatewayInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGatewayOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHypervisorInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHypervisorOutput' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateGatewayFromServerInput' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateGatewayFromServerOutput' => [ 'base' => NULL, 'refs' => [], ], 'Gateway' => [ 'base' => '<p>A gateway is an Backup Gateway appliance that runs on the customer\'s network to provide seamless connectivity to backup storage in the Amazon Web Services Cloud.</p>', 'refs' => [ 'Gateways$member' => NULL, ], ], 'GatewayArn' => [ 'base' => NULL, 'refs' => [ 'AssociateGatewayToServerInput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>', 'AssociateGatewayToServerOutput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of a gateway.</p>', 'CreateGatewayOutput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway you create.</p>', 'DeleteGatewayInput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway to delete.</p>', 'DeleteGatewayOutput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway you deleted.</p>', 'DisassociateGatewayFromServerInput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway to disassociate.</p>', 'DisassociateGatewayFromServerOutput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway you disassociated.</p>', 'Gateway$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>', 'GatewayDetails$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of gateways for your account and Amazon Web Services Region.</p>', 'GetBandwidthRateLimitScheduleInput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway. Use the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ListGateways.html"> <code>ListGateways</code> </a> operation to return a list of gateways for your account and Amazon Web Services Region.</p>', 'GetBandwidthRateLimitScheduleOutput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway. Use the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ListGateways.html"> <code>ListGateways</code> </a> operation to return a list of gateways for your account and Amazon Web Services Region.</p>', 'GetGatewayInput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway.</p>', 'PutBandwidthRateLimitScheduleInput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway. Use the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ListGateways.html"> <code>ListGateways</code> </a> operation to return a list of gateways for your account and Amazon Web Services Region.</p>', 'PutBandwidthRateLimitScheduleOutput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway. Use the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ListGateways.html"> <code>ListGateways</code> </a> operation to return a list of gateways for your account and Amazon Web Services Region.</p>', 'PutMaintenanceStartTimeInput$GatewayArn' => '<p>The Amazon Resource Name (ARN) for the gateway, used to specify its maintenance start time.</p>', 'PutMaintenanceStartTimeOutput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of a gateway for which you set the maintenance start time.</p>', 'TestHypervisorConfigurationInput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway to the hypervisor to test.</p>', 'UpdateGatewayInformationInput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway to update.</p>', 'UpdateGatewayInformationOutput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway you updated.</p>', 'UpdateGatewaySoftwareNowInput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway to be updated.</p>', 'UpdateGatewaySoftwareNowOutput$GatewayArn' => '<p>The Amazon Resource Name (ARN) of the gateway you updated.</p>', ], ], 'GatewayDetails' => [ 'base' => '<p>The details of gateway.</p>', 'refs' => [ 'GetGatewayOutput$Gateway' => '<p>By providing the ARN (Amazon Resource Name), this API returns the gateway.</p>', ], ], 'GatewayType' => [ 'base' => NULL, 'refs' => [ 'CreateGatewayInput$GatewayType' => '<p>The type of created gateway.</p>', 'Gateway$GatewayType' => '<p>The type of the gateway.</p>', 'GatewayDetails$GatewayType' => '<p>The type of the gateway type.</p>', ], ], 'Gateways' => [ 'base' => NULL, 'refs' => [ 'ListGatewaysOutput$Gateways' => '<p>A list of your gateways.</p>', ], ], 'GetBandwidthRateLimitScheduleInput' => [ 'base' => NULL, 'refs' => [], ], 'GetBandwidthRateLimitScheduleOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetGatewayInput' => [ 'base' => NULL, 'refs' => [], ], 'GetGatewayOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetHypervisorInput' => [ 'base' => NULL, 'refs' => [], ], 'GetHypervisorOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetHypervisorPropertyMappingsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetHypervisorPropertyMappingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetVirtualMachineInput' => [ 'base' => NULL, 'refs' => [], ], 'GetVirtualMachineOutput' => [ 'base' => NULL, 'refs' => [], ], 'Host' => [ 'base' => NULL, 'refs' => [ 'Hypervisor$Host' => '<p>The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>', 'HypervisorDetails$Host' => '<p>The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>', 'ImportHypervisorConfigurationInput$Host' => '<p>The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>', 'TestHypervisorConfigurationInput$Host' => '<p>The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>', 'UpdateHypervisorInput$Host' => '<p>The updated host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).</p>', ], ], 'HourOfDay' => [ 'base' => NULL, 'refs' => [ 'BandwidthRateLimitInterval$EndHourOfDay' => '<p>The hour of the day to end the bandwidth rate limit interval.</p>', 'BandwidthRateLimitInterval$StartHourOfDay' => '<p>The hour of the day to start the bandwidth rate limit interval.</p>', 'MaintenanceStartTime$HourOfDay' => '<p>The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23). The hour of the day is in the time zone of the gateway.</p>', 'PutMaintenanceStartTimeInput$HourOfDay' => '<p>The hour of the day to start maintenance on a gateway.</p>', ], ], 'Hypervisor' => [ 'base' => '<p>Represents the hypervisor\'s permissions to which the gateway will connect.</p> <p>A hypervisor is hardware, software, or firmware that creates and manages virtual machines, and allocates resources to them.</p>', 'refs' => [ 'Hypervisors$member' => NULL, ], ], 'HypervisorDetails' => [ 'base' => '<p>These are the details of the specified hypervisor. A hypervisor is hardware, software, or firmware that creates and manages virtual machines, and allocates resources to them.</p>', 'refs' => [ 'GetHypervisorOutput$Hypervisor' => '<p>Details about the requested hypervisor.</p>', ], ], 'HypervisorId' => [ 'base' => NULL, 'refs' => [ 'Gateway$HypervisorId' => '<p>The hypervisor ID of the gateway.</p>', 'GatewayDetails$HypervisorId' => '<p>The hypervisor ID of the gateway.</p>', ], ], 'HypervisorState' => [ 'base' => NULL, 'refs' => [ 'Hypervisor$State' => '<p>The state of the hypervisor.</p>', 'HypervisorDetails$State' => '<p>This is the current state of the specified hypervisor.</p> <p>The possible states are <code>PENDING</code>, <code>ONLINE</code>, <code>OFFLINE</code>, or <code>ERROR</code>.</p>', ], ], 'Hypervisors' => [ 'base' => NULL, 'refs' => [ 'ListHypervisorsOutput$Hypervisors' => '<p>A list of your <code>Hypervisor</code> objects, ordered by their Amazon Resource Names (ARNs).</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'GetHypervisorPropertyMappingsOutput$IamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role.</p>', 'PutHypervisorPropertyMappingsInput$IamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role.</p>', ], ], 'ImportHypervisorConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'ImportHypervisorConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>The operation did not succeed because an internal error occurred. Try again later.</p>', 'refs' => [], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'Hypervisor$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the Key Management Service used to encrypt the hypervisor.</p>', 'HypervisorDetails$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS used to encrypt the hypervisor.</p>', 'ImportHypervisorConfigurationInput$KmsKeyArn' => '<p>The Key Management Service for the hypervisor.</p>', ], ], 'ListGatewaysInput' => [ 'base' => NULL, 'refs' => [], ], 'ListGatewaysOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListHypervisorsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListHypervisorsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListVirtualMachinesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListVirtualMachinesOutput' => [ 'base' => NULL, 'refs' => [], ], 'LogGroupArn' => [ 'base' => NULL, 'refs' => [ 'HypervisorDetails$LogGroupArn' => '<p>The Amazon Resource Name (ARN) of the group of gateways within the requested log.</p>', 'UpdateHypervisorInput$LogGroupArn' => '<p>The Amazon Resource Name (ARN) of the group of gateways within the requested log.</p>', ], ], 'MaintenanceStartTime' => [ 'base' => '<p>This is your gateway\'s weekly maintenance start time including the day and time of the week. Note that values are in terms of the gateway\'s time zone. Can be weekly or monthly.</p>', 'refs' => [ 'GatewayDetails$MaintenanceStartTime' => '<p>Returns your gateway\'s weekly maintenance start time including the day and time of the week. Note that values are in terms of the gateway\'s time zone. Can be weekly or monthly.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListGatewaysInput$MaxResults' => '<p>The maximum number of gateways to list.</p>', 'ListHypervisorsInput$MaxResults' => '<p>The maximum number of hypervisors to list.</p>', 'ListVirtualMachinesInput$MaxResults' => '<p>The maximum number of virtual machines to list.</p>', ], ], 'MinuteOfHour' => [ 'base' => NULL, 'refs' => [ 'BandwidthRateLimitInterval$EndMinuteOfHour' => '<p>The minute of the hour to end the bandwidth rate limit interval.</p> <important> <p>The bandwidth rate limit interval ends at the end of the minute. To end an interval at the end of an hour, use the value <code>59</code>.</p> </important>', 'BandwidthRateLimitInterval$StartMinuteOfHour' => '<p>The minute of the hour to start the bandwidth rate limit interval. The interval begins at the start of that minute. To begin an interval exactly at the start of the hour, use the value <code>0</code>.</p>', 'MaintenanceStartTime$MinuteOfHour' => '<p>The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (0 to 59). The minute of the hour is in the time zone of the gateway.</p>', 'PutMaintenanceStartTimeInput$MinuteOfHour' => '<p>The minute of the hour to start maintenance on a gateway.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'CreateGatewayInput$GatewayDisplayName' => '<p>The display name of the created gateway.</p>', 'Gateway$GatewayDisplayName' => '<p>The display name of the gateway.</p>', 'GatewayDetails$GatewayDisplayName' => '<p>The display name of the gateway.</p>', 'Hypervisor$Name' => '<p>The name of the hypervisor.</p>', 'HypervisorDetails$Name' => '<p>This is the name of the specified hypervisor.</p>', 'ImportHypervisorConfigurationInput$Name' => '<p>The name of the hypervisor.</p>', 'UpdateGatewayInformationInput$GatewayDisplayName' => '<p>The updated display name of the gateway.</p>', 'UpdateHypervisorInput$Name' => '<p>The updated name for the hypervisor</p>', 'VirtualMachine$HostName' => '<p>The host name of the virtual machine.</p>', 'VirtualMachine$Name' => '<p>The name of the virtual machine.</p>', 'VirtualMachineDetails$HostName' => '<p>The host name of the virtual machine.</p>', 'VirtualMachineDetails$Name' => '<p>The name of the virtual machine.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListGatewaysInput$NextToken' => '<p>The next item following a partial list of returned resources. For example, if a request is made to return <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListGatewaysOutput$NextToken' => '<p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListHypervisorsInput$NextToken' => '<p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListHypervisorsOutput$NextToken' => '<p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListVirtualMachinesInput$NextToken' => '<p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListVirtualMachinesOutput$NextToken' => '<p>The next item following a partial list of returned resources. For example, if a request is made to return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'ImportHypervisorConfigurationInput$Password' => '<p>The password for the hypervisor.</p>', 'TestHypervisorConfigurationInput$Password' => '<p>The password for the hypervisor.</p>', 'UpdateHypervisorInput$Password' => '<p>The updated password for the hypervisor.</p>', ], ], 'Path' => [ 'base' => NULL, 'refs' => [ 'VirtualMachine$Path' => '<p>The path of the virtual machine.</p>', 'VirtualMachineDetails$Path' => '<p>The path of the virtual machine.</p>', ], ], 'PutBandwidthRateLimitScheduleInput' => [ 'base' => NULL, 'refs' => [], ], 'PutBandwidthRateLimitScheduleOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutHypervisorPropertyMappingsInput' => [ 'base' => NULL, 'refs' => [], ], 'PutHypervisorPropertyMappingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutMaintenanceStartTimeInput' => [ 'base' => NULL, 'refs' => [], ], 'PutMaintenanceStartTimeOutput' => [ 'base' => NULL, 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'GetVirtualMachineInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the virtual machine.</p>', 'ListTagsForResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource\'s tags to list.</p>', 'ListTagsForResourceOutput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource\'s tags that you listed.</p>', 'TagResourceInput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource to tag.</p>', 'TagResourceOutput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource you tagged.</p>', 'UntagResourceInput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource from which to remove tags.</p>', 'UntagResourceOutput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource from which you removed tags.</p>', 'VirtualMachine$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the virtual machine. For example, <code>arn:aws:backup-gateway:us-west-1:0000000000000:vm/vm-0000ABCDEFGIJKL</code>.</p>', 'VirtualMachineDetails$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the virtual machine. For example, <code>arn:aws:backup-gateway:us-west-1:0000000000000:vm/vm-0000ABCDEFGIJKL</code>.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A resource that is required for the action wasn\'t found.</p>', 'refs' => [], ], 'ServerArn' => [ 'base' => NULL, 'refs' => [ 'AssociateGatewayToServerInput$ServerArn' => '<p>The Amazon Resource Name (ARN) of the server that hosts your virtual machines.</p>', 'DeleteHypervisorInput$HypervisorArn' => '<p>The Amazon Resource Name (ARN) of the hypervisor to delete.</p>', 'DeleteHypervisorOutput$HypervisorArn' => '<p>The Amazon Resource Name (ARN) of the hypervisor you deleted.</p>', 'GetHypervisorInput$HypervisorArn' => '<p>The Amazon Resource Name (ARN) of the hypervisor.</p>', 'GetHypervisorPropertyMappingsInput$HypervisorArn' => '<p>The Amazon Resource Name (ARN) of the hypervisor.</p>', 'GetHypervisorPropertyMappingsOutput$HypervisorArn' => '<p>The Amazon Resource Name (ARN) of the hypervisor.</p>', 'Hypervisor$HypervisorArn' => '<p>The Amazon Resource Name (ARN) of the hypervisor.</p>', 'HypervisorDetails$HypervisorArn' => '<p>The Amazon Resource Name (ARN) of the hypervisor.</p>', 'ImportHypervisorConfigurationOutput$HypervisorArn' => '<p>The Amazon Resource Name (ARN) of the hypervisor you disassociated.</p>', 'ListVirtualMachinesInput$HypervisorArn' => '<p>The Amazon Resource Name (ARN) of the hypervisor connected to your virtual machine.</p>', 'PutHypervisorPropertyMappingsInput$HypervisorArn' => '<p>The Amazon Resource Name (ARN) of the hypervisor.</p>', 'PutHypervisorPropertyMappingsOutput$HypervisorArn' => '<p>The Amazon Resource Name (ARN) of the hypervisor.</p>', 'StartVirtualMachinesMetadataSyncInput$HypervisorArn' => '<p>The Amazon Resource Name (ARN) of the hypervisor.</p>', 'StartVirtualMachinesMetadataSyncOutput$HypervisorArn' => '<p>The Amazon Resource Name (ARN) of the hypervisor.</p>', 'UpdateHypervisorInput$HypervisorArn' => '<p>The Amazon Resource Name (ARN) of the hypervisor to update.</p>', 'UpdateHypervisorOutput$HypervisorArn' => '<p>The Amazon Resource Name (ARN) of the hypervisor you updated.</p>', ], ], 'StartVirtualMachinesMetadataSyncInput' => [ 'base' => NULL, 'refs' => [], ], 'StartVirtualMachinesMetadataSyncOutput' => [ 'base' => NULL, 'refs' => [], ], 'SyncMetadataStatus' => [ 'base' => NULL, 'refs' => [ 'HypervisorDetails$LatestMetadataSyncStatus' => '<p>This is the most recent status for the indicated metadata sync.</p>', ], ], 'Tag' => [ 'base' => '<p>A key-value pair you can use to manage, filter, and search for your resources. Allowed characters include UTF-8 letters, numbers, spaces, and the following characters: + - = . _ : /.</p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key part of a tag\'s key-value pair. The key can\'t start with <code>aws:</code>.</p>', 'TagKeys$member' => NULL, 'VmwareToAwsTagMapping$AwsTagKey' => '<p>The key part of the Amazon Web Services tag\'s key-value pair.</p>', ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeys' => '<p>The list of tag keys specifying which tags to remove.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value part of a tag\'s key-value pair.</p>', 'VmwareToAwsTagMapping$AwsTagValue' => '<p>The value part of the Amazon Web Services tag\'s key-value pair.</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateGatewayInput$Tags' => '<p>A list of up to 50 tags to assign to the gateway. Each tag is a key-value pair.</p>', 'ImportHypervisorConfigurationInput$Tags' => '<p>The tags of the hypervisor configuration to import.</p>', 'ListTagsForResourceOutput$Tags' => '<p>A list of the resource\'s tags.</p>', 'TagResourceInput$Tags' => '<p>A list of tags to assign to the resource.</p>', ], ], 'TestHypervisorConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'TestHypervisorConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'ThrottlingException' => [ 'base' => '<p>TPS has been limited to protect against intentional or unintentional high request volumes.</p>', 'refs' => [], ], 'Time' => [ 'base' => NULL, 'refs' => [ 'Gateway$LastSeenTime' => '<p>The last time Backup gateway communicated with the gateway, in Unix format and UTC time.</p>', 'GatewayDetails$LastSeenTime' => '<p>Details showing the last time Backup gateway communicated with the cloud, in Unix format and UTC time.</p>', 'GatewayDetails$NextUpdateAvailabilityTime' => '<p>Details showing the next update availability time of the gateway.</p>', 'HypervisorDetails$LastSuccessfulMetadataSyncTime' => '<p>This is the time when the most recent successful sync of metadata occurred.</p>', 'VirtualMachine$LastBackupDate' => '<p>The most recent date a virtual machine was backed up, in Unix format and UTC time.</p>', 'VirtualMachineDetails$LastBackupDate' => '<p>The most recent date a virtual machine was backed up, in Unix format and UTC time.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGatewayInformationInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGatewayInformationOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGatewaySoftwareNowInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGatewaySoftwareNowOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateHypervisorInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateHypervisorOutput' => [ 'base' => NULL, 'refs' => [], ], 'Username' => [ 'base' => NULL, 'refs' => [ 'ImportHypervisorConfigurationInput$Username' => '<p>The username for the hypervisor.</p>', 'TestHypervisorConfigurationInput$Username' => '<p>The username for the hypervisor.</p>', 'UpdateHypervisorInput$Username' => '<p>The updated username for the hypervisor.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The operation did not succeed because a validation error occurred.</p>', 'refs' => [], ], 'VirtualMachine' => [ 'base' => '<p>A virtual machine that is on a hypervisor.</p>', 'refs' => [ 'VirtualMachines$member' => NULL, ], ], 'VirtualMachineDetails' => [ 'base' => '<p>Your <code>VirtualMachine</code> objects, ordered by their Amazon Resource Names (ARNs).</p>', 'refs' => [ 'GetVirtualMachineOutput$VirtualMachine' => '<p>This object contains the basic attributes of <code>VirtualMachine</code> contained by the output of <code>GetVirtualMachine</code> </p>', ], ], 'VirtualMachines' => [ 'base' => NULL, 'refs' => [ 'ListVirtualMachinesOutput$VirtualMachines' => '<p>A list of your <code>VirtualMachine</code> objects, ordered by their Amazon Resource Names (ARNs).</p>', ], ], 'VmwareCategory' => [ 'base' => NULL, 'refs' => [ 'VmwareTag$VmwareCategory' => '<p>The is the category of VMware.</p>', 'VmwareToAwsTagMapping$VmwareCategory' => '<p>The is the category of VMware.</p>', ], ], 'VmwareTag' => [ 'base' => '<p>A VMware tag is a tag attached to a specific virtual machine. A <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_Tag.html">tag</a> is a key-value pair you can use to manage, filter, and search for your resources.</p> <p>The content of VMware tags can be matched to Amazon Web Services tags.</p>', 'refs' => [ 'VmwareTags$member' => NULL, ], ], 'VmwareTagName' => [ 'base' => NULL, 'refs' => [ 'VmwareTag$VmwareTagName' => '<p>This is the user-defined name of a VMware tag.</p>', 'VmwareToAwsTagMapping$VmwareTagName' => '<p>This is the user-defined name of a VMware tag.</p>', ], ], 'VmwareTags' => [ 'base' => NULL, 'refs' => [ 'VirtualMachineDetails$VmwareTags' => '<p>These are the details of the VMware tags associated with the specified virtual machine.</p>', ], ], 'VmwareToAwsTagMapping' => [ 'base' => '<p>This displays the mapping of on-premises VMware tags to the corresponding Amazon Web Services tags.</p>', 'refs' => [ 'VmwareToAwsTagMappings$member' => NULL, ], ], 'VmwareToAwsTagMappings' => [ 'base' => NULL, 'refs' => [ 'GetHypervisorPropertyMappingsOutput$VmwareToAwsTagMappings' => '<p>This is a display of the mappings of on-premises VMware tags to the Amazon Web Services tags.</p>', 'PutHypervisorPropertyMappingsInput$VmwareToAwsTagMappings' => '<p>This action requests the mappings of on-premises VMware tags to the Amazon Web Services tags.</p>', ], ], 'VpcEndpoint' => [ 'base' => NULL, 'refs' => [ 'GatewayDetails$VpcEndpoint' => '<p>The DNS name for the virtual private cloud (VPC) endpoint the gateway uses to connect to the cloud for backup gateway.</p>', ], ], 'string' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$ErrorCode' => '<p>A description of why you have insufficient permissions.</p>', 'AccessDeniedException$Message' => NULL, 'ConflictException$ErrorCode' => '<p>A description of why the operation is not supported.</p>', 'ConflictException$Message' => NULL, 'HypervisorDetails$LatestMetadataSyncStatusMessage' => '<p>This is the most recent status for the indicated metadata sync.</p>', 'InternalServerException$ErrorCode' => '<p>A description of which internal error occured.</p>', 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$ErrorCode' => '<p>A description of which resource wasn\'t found.</p>', 'ResourceNotFoundException$Message' => NULL, 'ThrottlingException$ErrorCode' => '<p>Error: TPS has been limited to protect against intentional or unintentional high request volumes.</p>', 'ThrottlingException$Message' => NULL, 'ValidationException$ErrorCode' => '<p>A description of what caused the validation error.</p>', 'ValidationException$Message' => NULL, 'VirtualMachine$HypervisorId' => '<p>The ID of the virtual machine\'s hypervisor.</p>', 'VirtualMachineDetails$HypervisorId' => '<p>The ID of the virtual machine\'s hypervisor.</p>', 'VmwareTag$VmwareTagDescription' => '<p>This is a user-defined description of a VMware tag.</p>', ], ], ],];
