<?php
// This file was auto-generated from sdk-root/src/data/backup/2018-11-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Backup</fullname> <p>Backup is a unified backup service designed to protect Amazon Web Services services and their associated data. Backup simplifies the creation, migration, restoration, and deletion of backups, while also providing reporting and auditing.</p>', 'operations' => [ 'CancelLegalHold' => '<p>This action removes the specified legal hold on a recovery point. This action can only be performed by a user with sufficient permissions.</p>', 'CreateBackupPlan' => '<p>Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains information that Backup uses to schedule tasks that create recovery points for resources.</p> <p>If you call <code>CreateBackupPlan</code> with a plan that already exists, you receive an <code>AlreadyExistsException</code> exception.</p>', 'CreateBackupSelection' => '<p>Creates a JSON document that specifies a set of resources to assign to a backup plan. For examples, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json">Assigning resources programmatically</a>. </p>', 'CreateBackupVault' => '<p>Creates a logical container where backups are stored. A <code>CreateBackupVault</code> request includes a name, optionally one or more resource tags, an encryption key, and a request ID.</p> <note> <p>Do not include sensitive data, such as passport numbers, in the name of a backup vault.</p> </note>', 'CreateFramework' => '<p>Creates a framework with one or more controls. A framework is a collection of controls that you can use to evaluate your backup practices. By using pre-built customizable controls to define your policies, you can evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.</p>', 'CreateLegalHold' => '<p>This action creates a legal hold on a recovery point (backup). A legal hold is a restraint on altering or deleting a backup until an authorized user cancels the legal hold. Any actions to delete or disassociate a recovery point will fail with an error if one or more active legal holds are on the recovery point.</p>', 'CreateLogicallyAirGappedBackupVault' => '<p>This request creates a logical container to where backups may be copied.</p> <p>This request includes a name, the Region, the maximum number of retention days, the minimum number of retention days, and optionally can include tags and a creator request ID.</p> <note> <p>Do not include sensitive data, such as passport numbers, in the name of a backup vault.</p> </note>', 'CreateReportPlan' => '<p>Creates a report plan. A report plan is a document that contains information about the contents of the report and where Backup will deliver it.</p> <p>If you call <code>CreateReportPlan</code> with a plan that already exists, you receive an <code>AlreadyExistsException</code> exception.</p>', 'CreateRestoreTestingPlan' => '<p>This is the first of two steps to create a restore testing plan; once this request is successful, finish the procedure with request CreateRestoreTestingSelection.</p> <p>You must include the parameter RestoreTestingPlan. You may optionally include CreatorRequestId and Tags.</p>', 'CreateRestoreTestingSelection' => '<p>This request can be sent after CreateRestoreTestingPlan request returns successfully. This is the second part of creating a resource testing plan, and it must be completed sequentially.</p> <p>This consists of <code>RestoreTestingSelectionName</code>, <code>ProtectedResourceType</code>, and one of the following:</p> <ul> <li> <p> <code>ProtectedResourceArns</code> </p> </li> <li> <p> <code>ProtectedResourceConditions</code> </p> </li> </ul> <p>Each protected resource type can have one single value.</p> <p>A restore testing selection can include a wildcard value ("*") for <code>ProtectedResourceArns</code> along with <code>ProtectedResourceConditions</code>. Alternatively, you can include up to 30 specific protected resource ARNs in <code>ProtectedResourceArns</code>.</p> <p>Cannot select by both protected resource types AND specific ARNs. Request will fail if both are included.</p>', 'DeleteBackupPlan' => '<p>Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will still exist.</p>', 'DeleteBackupSelection' => '<p>Deletes the resource selection associated with a backup plan that is specified by the <code>SelectionId</code>.</p>', 'DeleteBackupVault' => '<p>Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.</p>', 'DeleteBackupVaultAccessPolicy' => '<p>Deletes the policy document that manages permissions on a backup vault.</p>', 'DeleteBackupVaultLockConfiguration' => '<p>Deletes Backup Vault Lock from a backup vault specified by a backup vault name.</p> <p>If the Vault Lock configuration is immutable, then you cannot delete Vault Lock using API operations, and you will receive an <code>InvalidRequestException</code> if you attempt to do so. For more information, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">Vault Lock</a> in the <i>Backup Developer Guide</i>.</p>', 'DeleteBackupVaultNotifications' => '<p>Deletes event notifications for the specified backup vault.</p>', 'DeleteFramework' => '<p>Deletes the framework specified by a framework name.</p>', 'DeleteRecoveryPoint' => '<p>Deletes the recovery point specified by a recovery point ID.</p> <p>If the recovery point ID belongs to a continuous backup, calling this endpoint deletes the existing continuous backup and stops future continuous backup.</p> <p>When an IAM role\'s permissions are insufficient to call this API, the service sends back an HTTP 200 response with an empty HTTP body, but the recovery point is not deleted. Instead, it enters an <code>EXPIRED</code> state.</p> <p> <code>EXPIRED</code> recovery points can be deleted with this API once the IAM role has the <code>iam:CreateServiceLinkedRole</code> action. To learn more about adding this role, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/deleting-backups.html#deleting-backups-troubleshooting"> Troubleshooting manual deletions</a>.</p> <p>If the user or role is deleted or the permission within the role is removed, the deletion will not be successful and will enter an <code>EXPIRED</code> state.</p>', 'DeleteReportPlan' => '<p>Deletes the report plan specified by a report plan name.</p>', 'DeleteRestoreTestingPlan' => '<p>This request deletes the specified restore testing plan.</p> <p>Deletion can only successfully occur if all associated restore testing selections are deleted first.</p>', 'DeleteRestoreTestingSelection' => '<p>Input the Restore Testing Plan name and Restore Testing Selection name.</p> <p>All testing selections associated with a restore testing plan must be deleted before the restore testing plan can be deleted.</p>', 'DescribeBackupJob' => '<p>Returns backup job details for the specified <code>BackupJobId</code>.</p>', 'DescribeBackupVault' => '<p>Returns metadata about a backup vault specified by its name.</p>', 'DescribeCopyJob' => '<p>Returns metadata associated with creating a copy of a resource.</p>', 'DescribeFramework' => '<p>Returns the framework details for the specified <code>FrameworkName</code>.</p>', 'DescribeGlobalSettings' => '<p>Describes whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not a member of an Organizations organization. Example: <code>describe-global-settings --region us-west-2</code> </p>', 'DescribeProtectedResource' => '<p>Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name (ARN), and the Amazon Web Services service type of the saved resource.</p>', 'DescribeRecoveryPoint' => '<p>Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.</p>', 'DescribeRegionSettings' => '<p>Returns the current service opt-in settings for the Region. If service opt-in is enabled for a service, Backup tries to protect that service\'s resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, Backup does not try to protect that service\'s resources in this Region.</p>', 'DescribeReportJob' => '<p>Returns the details associated with creating a report as specified by its <code>ReportJobId</code>.</p>', 'DescribeReportPlan' => '<p>Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.</p>', 'DescribeRestoreJob' => '<p>Returns metadata associated with a restore job that is specified by a job ID.</p>', 'DisassociateRecoveryPoint' => '<p>Deletes the specified continuous backup recovery point from Backup and releases control of that continuous backup to the source service, such as Amazon RDS. The source service will continue to create and retain continuous backups using the lifecycle that you specified in your original backup plan.</p> <p>Does not support snapshot backup recovery points.</p>', 'DisassociateRecoveryPointFromParent' => '<p>This action to a specific child (nested) recovery point removes the relationship between the specified recovery point and its parent (composite) recovery point.</p>', 'ExportBackupPlanTemplate' => '<p>Returns the backup plan that is specified by the plan ID as a backup template.</p>', 'GetBackupPlan' => '<p>Returns <code>BackupPlan</code> details for the specified <code>BackupPlanId</code>. The details are the body of a backup plan in JSON format, in addition to plan metadata.</p>', 'GetBackupPlanFromJSON' => '<p>Returns a valid JSON document specifying a backup plan or an error.</p>', 'GetBackupPlanFromTemplate' => '<p>Returns the template specified by its <code>templateId</code> as a backup plan.</p>', 'GetBackupSelection' => '<p>Returns selection metadata and a document in JSON format that specifies a list of resources that are associated with a backup plan.</p>', 'GetBackupVaultAccessPolicy' => '<p>Returns the access policy document that is associated with the named backup vault.</p>', 'GetBackupVaultNotifications' => '<p>Returns event notifications for the specified backup vault.</p>', 'GetLegalHold' => '<p>This action returns details for a specified legal hold. The details are the body of a legal hold in JSON format, in addition to metadata.</p>', 'GetRecoveryPointRestoreMetadata' => '<p>Returns a set of metadata key-value pairs that were used to create the backup.</p>', 'GetRestoreJobMetadata' => '<p>This request returns the metadata for the specified restore job.</p>', 'GetRestoreTestingInferredMetadata' => '<p>This request returns the minimal required set of metadata needed to start a restore job with secure default settings. <code>BackupVaultName</code> and <code>RecoveryPointArn</code> are required parameters. <code>BackupVaultAccountId</code> is an optional parameter.</p>', 'GetRestoreTestingPlan' => '<p>Returns <code>RestoreTestingPlan</code> details for the specified <code>RestoreTestingPlanName</code>. The details are the body of a restore testing plan in JSON format, in addition to plan metadata.</p>', 'GetRestoreTestingSelection' => '<p>Returns RestoreTestingSelection, which displays resources and elements of the restore testing plan.</p>', 'GetSupportedResourceTypes' => '<p>Returns the Amazon Web Services resource types supported by Backup.</p>', 'ListBackupJobSummaries' => '<p>This is a request for a summary of backup jobs created or running within the most recent 30 days. You can include parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter results.</p> <p>This request returns a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.</p>', 'ListBackupJobs' => '<p>Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of time, consider using these <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">monitoring tools</a>.</p>', 'ListBackupPlanTemplates' => '<p>Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and deletion dates.</p>', 'ListBackupPlanVersions' => '<p>Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation and deletion dates, plan names, and version IDs.</p>', 'ListBackupPlans' => '<p>Returns a list of all active backup plans for an authenticated account. The list contains information such as Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request IDs.</p>', 'ListBackupSelections' => '<p>Returns an array containing metadata of the resources associated with the target backup plan.</p>', 'ListBackupVaults' => '<p>Returns a list of recovery point storage containers along with information about them.</p>', 'ListCopyJobSummaries' => '<p>This request obtains a list of copy jobs created or running within the the most recent 30 days. You can include parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter results.</p> <p>This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.</p>', 'ListCopyJobs' => '<p>Returns metadata about your copy jobs.</p>', 'ListFrameworks' => '<p>Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.</p>', 'ListLegalHolds' => '<p>This action returns metadata about active and previous legal holds.</p>', 'ListProtectedResources' => '<p>Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.</p>', 'ListProtectedResourcesByBackupVault' => '<p>This request lists the protected resources corresponding to each backup vault.</p>', 'ListRecoveryPointsByBackupVault' => '<p>Returns detailed information about the recovery points stored in a backup vault.</p>', 'ListRecoveryPointsByLegalHold' => '<p>This action returns recovery point ARNs (Amazon Resource Names) of the specified legal hold.</p>', 'ListRecoveryPointsByResource' => '<p>Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource Name (ARN).</p> <note> <p>For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.</p> </note>', 'ListReportJobs' => '<p>Returns details about your report jobs.</p>', 'ListReportPlans' => '<p>Returns a list of your report plans. For detailed information about a single report plan, use <code>DescribeReportPlan</code>.</p>', 'ListRestoreJobSummaries' => '<p>This request obtains a summary of restore jobs created or running within the the most recent 30 days. You can include parameters AccountID, State, ResourceType, AggregationPeriod, MaxResults, or NextToken to filter results.</p> <p>This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.</p>', 'ListRestoreJobs' => '<p>Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery process.</p>', 'ListRestoreJobsByProtectedResource' => '<p>This returns restore jobs that contain the specified protected resource.</p> <p>You must include <code>ResourceArn</code>. You can optionally include <code>NextToken</code>, <code>ByStatus</code>, <code>MaxResults</code>, <code>ByRecoveryPointCreationDateAfter</code> , and <code>ByRecoveryPointCreationDateBefore</code>.</p>', 'ListRestoreTestingPlans' => '<p>Returns a list of restore testing plans.</p>', 'ListRestoreTestingSelections' => '<p>Returns a list of restore testing selections. Can be filtered by <code>MaxResults</code> and <code>RestoreTestingPlanName</code>.</p>', 'ListTags' => '<p>Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.</p> <p> <code>ListTags</code> only works for resource types that support full Backup management of their backups. Those resource types are listed in the "Full Backup management" section of the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature availability by resource</a> table.</p>', 'PutBackupVaultAccessPolicy' => '<p>Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a backup vault name and an access policy document in JSON format.</p>', 'PutBackupVaultLockConfiguration' => '<p>Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a minimum and maximum retention period for future backup and copy jobs that target a backup vault.</p> <note> <p>Backup Vault Lock has been assessed by Cohasset Associates for use in environments that are subject to SEC 17a-4, CFTC, and FINRA regulations. For more information about how Backup Vault Lock relates to these regulations, see the <a href="samples/cohassetreport.zip">Cohasset Associates Compliance Assessment.</a> </p> </note>', 'PutBackupVaultNotifications' => '<p>Turns on notifications on a backup vault for the specified topic and events.</p>', 'PutRestoreValidationResult' => '<p>This request allows you to send your independent self-run restore test validation results. <code>RestoreJobId</code> and <code>ValidationStatus</code> are required. Optionally, you can input a <code>ValidationStatusMessage</code>.</p>', 'StartBackupJob' => '<p>Starts an on-demand backup job for the specified resource.</p>', 'StartCopyJob' => '<p>Starts a job to create a one-time copy of the specified resource.</p> <p>Does not support continuous backups.</p>', 'StartReportJob' => '<p>Starts an on-demand report job for the specified report plan.</p>', 'StartRestoreJob' => '<p>Recovers the saved resource identified by an Amazon Resource Name (ARN).</p>', 'StopBackupJob' => '<p>Attempts to cancel a job to create a one-time backup of a resource.</p> <p>This action is not supported for the following services: Amazon FSx for Windows File Server, Amazon FSx for Lustre, Amazon FSx for NetApp ONTAP , Amazon FSx for OpenZFS, Amazon DocumentDB (with MongoDB compatibility), Amazon RDS, Amazon Aurora, and Amazon Neptune.</p>', 'TagResource' => '<p>Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN).</p>', 'UntagResource' => '<p>Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN)</p>', 'UpdateBackupPlan' => '<p>Updates an existing backup plan identified by its <code>backupPlanId</code> with the input document in JSON format. The new version is uniquely identified by a <code>VersionId</code>.</p>', 'UpdateFramework' => '<p>Updates an existing framework identified by its <code>FrameworkName</code> with the input document in JSON format.</p>', 'UpdateGlobalSettings' => '<p>Updates whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not an Organizations management account. Use the <code>DescribeGlobalSettings</code> API to determine the current settings.</p>', 'UpdateRecoveryPointLifecycle' => '<p>Sets the transition lifecycle of a recovery point.</p> <p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.</p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.</p> <p>Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature availability by resource</a> table. Backup ignores this expression for other resource types.</p> <p>This operation does not support continuous backups.</p>', 'UpdateRegionSettings' => '<p>Updates the current service opt-in settings for the Region.</p> <p>Use the <code>DescribeRegionSettings</code> API to determine the resource types that are supported.</p>', 'UpdateReportPlan' => '<p>Updates an existing report plan identified by its <code>ReportPlanName</code> with the input document in JSON format.</p>', 'UpdateRestoreTestingPlan' => '<p>This request will send changes to your specified restore testing plan. <code>RestoreTestingPlanName</code> cannot be updated after it is created.</p> <p> <code>RecoveryPointSelection</code> can contain:</p> <ul> <li> <p> <code>Algorithm</code> </p> </li> <li> <p> <code>ExcludeVaults</code> </p> </li> <li> <p> <code>IncludeVaults</code> </p> </li> <li> <p> <code>RecoveryPointTypes</code> </p> </li> <li> <p> <code>SelectionWindowDays</code> </p> </li> </ul>', 'UpdateRestoreTestingSelection' => '<p>Most elements except the <code>RestoreTestingSelectionName</code> can be updated with this request.</p> <p> <code>RestoreTestingSelection</code> can use either protected resource ARNs or conditions, but not both. That is, if your selection has <code>ProtectedResourceArns</code>, requesting an update with the parameter <code>ProtectedResourceConditions</code> will be unsuccessful.</p>', ], 'shapes' => [ 'ARN' => [ 'base' => NULL, 'refs' => [ 'BackupJob$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'BackupJob$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'BackupJob$ResourceArn' => '<p>An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'BackupPlansListMember$BackupPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>', 'BackupVaultListMember$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'BackupVaultListMember$EncryptionKeyArn' => '<p>A server-side encryption key you can specify to encrypt your backups from services that support full Backup management; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>. If you specify a key, you must specify its ARN, not its alias. If you do not specify a key, Backup creates a KMS key for you by default.</p> <p>To learn which Backup services support full Backup management and how Backup handles encryption for backups from services that do not yet support full Backup, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/encryption.html"> Encryption for backups in Backup</a> </p>', 'CopyAction$DestinationBackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup. For example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'CopyJob$SourceBackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a source copy vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>. </p>', 'CopyJob$SourceRecoveryPointArn' => '<p>An ARN that uniquely identifies a source recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'CopyJob$DestinationBackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a destination copy vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'CopyJob$DestinationRecoveryPointArn' => '<p>An ARN that uniquely identifies a destination recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'CopyJob$ResourceArn' => '<p>The Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>', 'CreateBackupPlanOutput$BackupPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>', 'CreateBackupVaultInput$EncryptionKeyArn' => '<p>The server-side encryption key that is used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>', 'CreateBackupVaultOutput$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'CreateFrameworkOutput$FrameworkArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'CreateLegalHoldOutput$LegalHoldArn' => '<p>This is the ARN (Amazon Resource Number) of the created legal hold.</p>', 'CreateLogicallyAirGappedBackupVaultOutput$BackupVaultArn' => '<p>This is the ARN (Amazon Resource Name) of the vault being created.</p>', 'CreateReportPlanOutput$ReportPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'DeleteBackupPlanOutput$BackupPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>', 'DeleteRecoveryPointInput$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'DescribeBackupJobOutput$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'DescribeBackupJobOutput$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'DescribeBackupJobOutput$ResourceArn' => '<p>An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.</p>', 'DescribeBackupVaultOutput$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'DescribeBackupVaultOutput$EncryptionKeyArn' => '<p>The server-side encryption key that is used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>', 'DescribeFrameworkOutput$FrameworkArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'DescribeProtectedResourceInput$ResourceArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'DescribeProtectedResourceOutput$ResourceArn' => '<p>An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'DescribeProtectedResourceOutput$LastBackupVaultArn' => '<p>This is the ARN (Amazon Resource Name) of the backup vault that contains the most recent backup recovery point.</p>', 'DescribeProtectedResourceOutput$LastRecoveryPointArn' => '<p>This is the ARN (Amazon Resource Name) of the most recent recovery point.</p>', 'DescribeRecoveryPointInput$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'DescribeRecoveryPointOutput$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'DescribeRecoveryPointOutput$BackupVaultArn' => '<p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'DescribeRecoveryPointOutput$SourceBackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally backed up in; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:BackupVault</code>. If the recovery is restored to the same Amazon Web Services account or Region, this value will be <code>null</code>.</p>', 'DescribeRecoveryPointOutput$ResourceArn' => '<p>An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.</p>', 'DescribeRecoveryPointOutput$EncryptionKeyArn' => '<p>The server-side encryption key used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>', 'DescribeRecoveryPointOutput$ParentRecoveryPointArn' => '<p>This is an ARN that uniquely identifies a parent (composite) recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'DescribeRestoreJobOutput$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'DescribeRestoreJobOutput$CreatedResourceArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource whose recovery point is being restored. The format of the ARN depends on the resource type of the backed-up resource.</p>', 'DisassociateRecoveryPointFromParentInput$RecoveryPointArn' => '<p>This is the Amazon Resource Name (ARN) that uniquely identifies the child (nested) recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.</code> </p>', 'DisassociateRecoveryPointInput$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies an Backup recovery point.</p>', 'Framework$FrameworkArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'GetBackupPlanOutput$BackupPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>', 'GetBackupVaultAccessPolicyOutput$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'GetBackupVaultNotificationsOutput$BackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'GetBackupVaultNotificationsOutput$SNSTopicArn' => '<p>An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic; for example, <code>arn:aws:sns:us-west-2:111122223333:MyTopic</code>.</p>', 'GetLegalHoldOutput$LegalHoldArn' => '<p>This is the returned framework ARN for the specified legal hold. An Amazon Resource Name (ARN) uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'GetRecoveryPointRestoreMetadataInput$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'GetRecoveryPointRestoreMetadataOutput$BackupVaultArn' => '<p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'GetRecoveryPointRestoreMetadataOutput$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'LegalHold$LegalHoldArn' => '<p>This is an Amazon Resource Number (ARN) that uniquely identifies the legal hold; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'ListBackupJobsInput$ByResourceArn' => '<p>Returns only backup jobs that match the specified resource Amazon Resource Name (ARN).</p>', 'ListCopyJobsInput$ByResourceArn' => '<p>Returns only copy jobs that match the specified resource Amazon Resource Name (ARN). </p>', 'ListRecoveryPointsByBackupVaultInput$ByResourceArn' => '<p>Returns only recovery points that match the specified resource Amazon Resource Name (ARN).</p>', 'ListRecoveryPointsByBackupVaultInput$ByParentRecoveryPointArn' => '<p>This returns only recovery points that match the specified parent (composite) recovery point Amazon Resource Name (ARN).</p>', 'ListRecoveryPointsByResourceInput$ResourceArn' => '<p>An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'ListRestoreJobsByProtectedResourceInput$ResourceArn' => '<p>Returns only restore jobs that match the specified resource Amazon Resource Name (ARN).</p>', 'ListRestoreJobsInput$ByRestoreTestingPlanArn' => '<p>This returns only restore testing jobs that match the specified resource Amazon Resource Name (ARN).</p>', 'ListTagsInput$ResourceArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the type of resource. Valid targets for <code>ListTags</code> are recovery points, backup plans, and backup vaults.</p>', 'ProtectedResource$ResourceArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'ProtectedResource$LastBackupVaultArn' => '<p>This is the ARN (Amazon Resource Name) of the backup vault that contains the most recent backup recovery point.</p>', 'ProtectedResource$LastRecoveryPointArn' => '<p>This is the ARN (Amazon Resource Name) of the most recent recovery point.</p>', 'PutBackupVaultNotificationsInput$SNSTopicArn' => '<p>The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for example, <code>arn:aws:sns:us-west-2:111122223333:MyVaultTopic</code>.</p>', 'RecoveryPointByBackupVault$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'RecoveryPointByBackupVault$BackupVaultArn' => '<p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'RecoveryPointByBackupVault$SourceBackupVaultArn' => '<p>The backup vault where the recovery point was originally copied from. If the recovery point is restored to the same account this value will be <code>null</code>.</p>', 'RecoveryPointByBackupVault$ResourceArn' => '<p>An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'RecoveryPointByBackupVault$EncryptionKeyArn' => '<p>The server-side encryption key that is used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>', 'RecoveryPointByBackupVault$ParentRecoveryPointArn' => '<p>This is the Amazon Resource Name (ARN) of the parent (composite) recovery point.</p>', 'RecoveryPointByResource$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'RecoveryPointByResource$EncryptionKeyArn' => '<p>The server-side encryption key that is used to protect your backups; for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>', 'RecoveryPointByResource$ParentRecoveryPointArn' => '<p>This is the Amazon Resource Name (ARN) of the parent (composite) recovery point.</p>', 'RecoveryPointCreator$BackupPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>', 'RecoveryPointMember$RecoveryPointArn' => '<p>This is the Amazon Resource Name (ARN) of the parent (composite) recovery point.</p>', 'RecoveryPointMember$ResourceArn' => '<p>This is the Amazon Resource Name (ARN) that uniquely identifies a saved resource.</p>', 'ReportJob$ReportPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'ReportPlan$ReportPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'ResourceArns$member' => NULL, 'ResourceTypeList$member' => NULL, 'RestoreJobCreator$RestoreTestingPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a restore testing plan.</p>', 'RestoreJobsListMember$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'RestoreJobsListMember$CreatedResourceArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'StartBackupJobInput$ResourceArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'StartBackupJobOutput$RecoveryPointArn' => '<p> <i>Note: This field is only returned for Amazon EFS and Advanced DynamoDB resources.</i> </p> <p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'StartCopyJobInput$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point to use for the copy job; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45. </p>', 'StartCopyJobInput$DestinationBackupVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a destination backup vault to copy to; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'StartRestoreJobInput$RecoveryPointArn' => '<p>An ARN that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'TagResourceInput$ResourceArn' => '<p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of the tagged resource.</p>', 'UntagResourceInput$ResourceArn' => '<p>An ARN that uniquely identifies a resource. The format of the ARN depends on the type of the tagged resource.</p>', 'UpdateBackupPlanOutput$BackupPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.</p>', 'UpdateFrameworkOutput$FrameworkArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', 'UpdateRecoveryPointLifecycleInput$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'UpdateRecoveryPointLifecycleOutput$BackupVaultArn' => '<p>An ARN that uniquely identifies a backup vault; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.</p>', 'UpdateRecoveryPointLifecycleOutput$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>', 'UpdateReportPlanOutput$ReportPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'BackupJob$AccountId' => '<p>The account ID that owns the backup job.</p>', 'BackupJobSummary$AccountId' => '<p>The account ID that owns the jobs within the summary.</p>', 'CopyJob$AccountId' => '<p>The account ID that owns the copy job.</p>', 'CopyJobSummary$AccountId' => '<p>The account ID that owns the jobs within the summary.</p>', 'DescribeBackupJobOutput$AccountId' => '<p>Returns the account ID that owns the backup job.</p>', 'DescribeRecoveryPointInput$BackupVaultAccountId' => '<p>This is the account ID of the specified backup vault.</p>', 'DescribeRestoreJobOutput$AccountId' => '<p>Returns the account ID that owns the restore job.</p>', 'GetRecoveryPointRestoreMetadataInput$BackupVaultAccountId' => '<p>This is the account ID of the specified backup vault.</p>', 'ListBackupJobSummariesInput$AccountId' => '<p>Returns the job count for the specified account.</p> <p>If the request is sent from a member account or an account not part of Amazon Web Services Organizations, jobs within requestor\'s account will be returned.</p> <p>Root, admin, and delegated administrator accounts can use the value ANY to return job counts from every account in the organization.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts from all accounts within the authenticated organization, then returns the sum.</p>', 'ListBackupJobsInput$ByAccountId' => '<p>The account ID to list the jobs from. Returns only backup jobs associated with the specified account ID.</p> <p>If used from an Organizations management account, passing <code>*</code> returns all jobs across the organization.</p>', 'ListCopyJobSummariesInput$AccountId' => '<p>Returns the job count for the specified account.</p> <p>If the request is sent from a member account or an account not part of Amazon Web Services Organizations, jobs within requestor\'s account will be returned.</p> <p>Root, admin, and delegated administrator accounts can use the value ANY to return job counts from every account in the organization.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts from all accounts within the authenticated organization, then returns the sum.</p>', 'ListCopyJobsInput$ByAccountId' => '<p>The account ID to list the jobs from. Returns only copy jobs associated with the specified account ID.</p>', 'ListProtectedResourcesByBackupVaultInput$BackupVaultAccountId' => '<p>This is the list of protected resources by backup vault within the vault(s) you specify by account ID.</p>', 'ListRecoveryPointsByBackupVaultInput$BackupVaultAccountId' => '<p>This parameter will sort the list of recovery points by account ID.</p>', 'ListRestoreJobSummariesInput$AccountId' => '<p>Returns the job count for the specified account.</p> <p>If the request is sent from a member account or an account not part of Amazon Web Services Organizations, jobs within requestor\'s account will be returned.</p> <p>Root, admin, and delegated administrator accounts can use the value ANY to return job counts from every account in the organization.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts from all accounts within the authenticated organization, then returns the sum.</p>', 'ListRestoreJobsInput$ByAccountId' => '<p>The account ID to list the jobs from. Returns only restore jobs associated with the specified account ID.</p>', 'RestoreJobSummary$AccountId' => '<p>The account ID that owns the jobs within the summary.</p>', 'RestoreJobsListMember$AccountId' => '<p>The account ID that owns the restore job.</p>', ], ], 'AdvancedBackupSetting' => [ 'base' => '<p>A list of backup options for each resource type.</p>', 'refs' => [ 'AdvancedBackupSettings$member' => NULL, ], ], 'AdvancedBackupSettings' => [ 'base' => NULL, 'refs' => [ 'BackupPlan$AdvancedBackupSettings' => '<p>Contains a list of <code>BackupOptions</code> for each resource type.</p>', 'BackupPlanInput$AdvancedBackupSettings' => '<p>Specifies a list of <code>BackupOptions</code> for each resource type. These settings are only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p>', 'BackupPlansListMember$AdvancedBackupSettings' => '<p>Contains a list of <code>BackupOptions</code> for a resource type.</p>', 'CreateBackupPlanOutput$AdvancedBackupSettings' => '<p>A list of <code>BackupOptions</code> settings for a resource type. This option is only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p>', 'GetBackupPlanOutput$AdvancedBackupSettings' => '<p>Contains a list of <code>BackupOptions</code> for each resource type. The list is populated only if the advanced option is set for the backup plan.</p>', 'UpdateBackupPlanOutput$AdvancedBackupSettings' => '<p>Contains a list of <code>BackupOptions</code> for each resource type.</p>', ], ], 'AggregationPeriod' => [ 'base' => NULL, 'refs' => [ 'ListBackupJobSummariesInput$AggregationPeriod' => '<p>This is the period that sets the boundaries for returned results.</p> <p>Acceptable values include</p> <ul> <li> <p> <code>ONE_DAY</code> for daily job count for the prior 14 days.</p> </li> <li> <p> <code>SEVEN_DAYS</code> for the aggregated job count for the prior 7 days.</p> </li> <li> <p> <code>FOURTEEN_DAYS</code> for aggregated job count for prior 14 days.</p> </li> </ul>', 'ListCopyJobSummariesInput$AggregationPeriod' => '<p>This is the period that sets the boundaries for returned results.</p> <ul> <li> <p> <code>ONE_DAY</code> for daily job count for the prior 14 days.</p> </li> <li> <p> <code>SEVEN_DAYS</code> for the aggregated job count for the prior 7 days.</p> </li> <li> <p> <code>FOURTEEN_DAYS</code> for aggregated job count for prior 14 days.</p> </li> </ul>', 'ListRestoreJobSummariesInput$AggregationPeriod' => '<p>This is the period that sets the boundaries for returned results.</p> <p>Acceptable values include</p> <ul> <li> <p> <code>ONE_DAY</code> for daily job count for the prior 14 days.</p> </li> <li> <p> <code>SEVEN_DAYS</code> for the aggregated job count for the prior 7 days.</p> </li> <li> <p> <code>FOURTEEN_DAYS</code> for aggregated job count for prior 14 days.</p> </li> </ul>', ], ], 'AlreadyExistsException' => [ 'base' => '<p>The required resource already exists.</p>', 'refs' => [], ], 'BackupJob' => [ 'base' => '<p>Contains detailed information about a backup job.</p>', 'refs' => [ 'BackupJobsList$member' => NULL, ], ], 'BackupJobChildJobsInState' => [ 'base' => NULL, 'refs' => [ 'DescribeBackupJobOutput$ChildJobsInState' => '<p>This returns the statistics of the included child (nested) backup jobs.</p>', ], ], 'BackupJobState' => [ 'base' => NULL, 'refs' => [ 'BackupJob$State' => '<p>The current state of a backup job.</p>', 'BackupJobChildJobsInState$key' => NULL, 'DescribeBackupJobOutput$State' => '<p>The current state of a backup job.</p>', 'ListBackupJobsInput$ByState' => '<p>Returns only backup jobs that are in the specified state.</p> <p> <code>Completed with issues</code> is a status found only in the Backup console. For API, this status refers to jobs with a state of <code>COMPLETED</code> and a <code>MessageCategory</code> with a value other than <code>SUCCESS</code>; that is, the status is completed but comes with a status message.</p> <p>To obtain the job count for <code>Completed with issues</code>, run two GET requests, and subtract the second, smaller number:</p> <p>GET /backup-jobs/?state=COMPLETED</p> <p>GET /backup-jobs/?messageCategory=SUCCESS&amp;state=COMPLETED</p>', ], ], 'BackupJobStatus' => [ 'base' => NULL, 'refs' => [ 'BackupJobSummary$State' => '<p>This value is job count for jobs with the specified state.</p>', 'ListBackupJobSummariesInput$State' => '<p>This parameter returns the job count for jobs with the specified state.</p> <p>The the value ANY returns count of all states.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts for all states and returns the sum.</p> <p> <code>Completed with issues</code> is a status found only in the Backup console. For API, this status refers to jobs with a state of <code>COMPLETED</code> and a <code>MessageCategory</code> with a value other than <code>SUCCESS</code>; that is, the status is completed but comes with a status message. To obtain the job count for <code>Completed with issues</code>, run two GET requests, and subtract the second, smaller number:</p> <p>GET /audit/backup-job-summaries?AggregationPeriod=FOURTEEN_DAYS&amp;State=COMPLETED</p> <p>GET /audit/backup-job-summaries?AggregationPeriod=FOURTEEN_DAYS&amp;MessageCategory=SUCCESS&amp;State=COMPLETED</p>', ], ], 'BackupJobSummary' => [ 'base' => '<p>This is a summary of jobs created or running within the most recent 30 days.</p> <p>The returned summary may contain the following: Region, Account, State, RestourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.</p>', 'refs' => [ 'BackupJobSummaryList$member' => NULL, ], ], 'BackupJobSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBackupJobSummariesOutput$BackupJobSummaries' => '<p>This request returns a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.</p>', ], ], 'BackupJobsList' => [ 'base' => NULL, 'refs' => [ 'ListBackupJobsOutput$BackupJobs' => '<p>An array of structures containing metadata about your backup jobs returned in JSON format.</p>', ], ], 'BackupOptionKey' => [ 'base' => NULL, 'refs' => [ 'BackupOptions$key' => NULL, ], ], 'BackupOptionValue' => [ 'base' => NULL, 'refs' => [ 'BackupOptions$value' => NULL, ], ], 'BackupOptions' => [ 'base' => NULL, 'refs' => [ 'AdvancedBackupSetting$BackupOptions' => '<p>Specifies the backup option for a selected resource. This option is only available for Windows VSS backup jobs.</p> <p>Valid values: </p> <p>Set to <code>"WindowsVSS":"enabled"</code> to enable the <code>WindowsVSS</code> backup option and create a Windows VSS backup. </p> <p>Set to <code>"WindowsVSS":"disabled"</code> to create a regular backup. The <code>WindowsVSS</code> option is not enabled by default.</p> <p>If you specify an invalid option, you get an <code>InvalidParameterValueException</code> exception.</p> <p>For more information about Windows VSS backups, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html">Creating a VSS-Enabled Windows Backup</a>.</p>', 'BackupJob$BackupOptions' => '<p>Specifies the backup option for a selected resource. This option is only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p> <p>Valid values: Set to <code>"WindowsVSS":"enabled"</code> to enable the <code>WindowsVSS</code> backup option and create a Windows VSS backup. Set to <code>"WindowsVSS":"disabled"</code> to create a regular backup. If you specify an invalid option, you get an <code>InvalidParameterValueException</code> exception.</p>', 'DescribeBackupJobOutput$BackupOptions' => '<p>Represents the options specified as part of backup plan or on-demand backup job.</p>', 'StartBackupJobInput$BackupOptions' => '<p>Specifies the backup option for a selected resource. This option is only available for Windows Volume Shadow Copy Service (VSS) backup jobs.</p> <p>Valid values: Set to <code>"WindowsVSS":"enabled"</code> to enable the <code>WindowsVSS</code> backup option and create a Windows VSS backup. Set to <code>"WindowsVSS""disabled"</code> to create a regular backup. The <code>WindowsVSS</code> option is not enabled by default.</p>', ], ], 'BackupPlan' => [ 'base' => '<p>Contains an optional backup plan display name and an array of <code>BackupRule</code> objects, each of which specifies a backup rule. Each rule in a backup plan is a separate scheduled task and can back up a different selection of Amazon Web Services resources.</p>', 'refs' => [ 'GetBackupPlanFromJSONOutput$BackupPlan' => '<p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>', 'GetBackupPlanFromTemplateOutput$BackupPlanDocument' => '<p>Returns the body of a backup plan based on the target template, including the name, rules, and backup vault of the plan.</p>', 'GetBackupPlanOutput$BackupPlan' => '<p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>', ], ], 'BackupPlanInput' => [ 'base' => '<p>Contains an optional backup plan display name and an array of <code>BackupRule</code> objects, each of which specifies a backup rule. Each rule in a backup plan is a separate scheduled task. </p>', 'refs' => [ 'CreateBackupPlanInput$BackupPlan' => '<p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>', 'UpdateBackupPlanInput$BackupPlan' => '<p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.</p>', ], ], 'BackupPlanName' => [ 'base' => NULL, 'refs' => [ 'BackupPlan$BackupPlanName' => '<p>The display name of a backup plan. Must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'BackupPlanInput$BackupPlanName' => '<p>The display name of a backup plan. Must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'BackupPlansListMember$BackupPlanName' => '<p>The display name of a saved backup plan.</p>', ], ], 'BackupPlanTemplatesList' => [ 'base' => NULL, 'refs' => [ 'ListBackupPlanTemplatesOutput$BackupPlanTemplatesList' => '<p>An array of template list items containing metadata about your saved templates.</p>', ], ], 'BackupPlanTemplatesListMember' => [ 'base' => '<p>An object specifying metadata associated with a backup plan template.</p>', 'refs' => [ 'BackupPlanTemplatesList$member' => NULL, ], ], 'BackupPlanVersionsList' => [ 'base' => NULL, 'refs' => [ 'ListBackupPlanVersionsOutput$BackupPlanVersionsList' => '<p>An array of version list items containing metadata about your backup plans.</p>', ], ], 'BackupPlansList' => [ 'base' => NULL, 'refs' => [ 'ListBackupPlansOutput$BackupPlansList' => '<p>An array of backup plan list items containing metadata about your saved backup plans.</p>', ], ], 'BackupPlansListMember' => [ 'base' => '<p>Contains metadata about a backup plan.</p>', 'refs' => [ 'BackupPlanVersionsList$member' => NULL, 'BackupPlansList$member' => NULL, ], ], 'BackupRule' => [ 'base' => '<p>Specifies a scheduled task used to back up a selection of resources.</p>', 'refs' => [ 'BackupRules$member' => NULL, ], ], 'BackupRuleInput' => [ 'base' => '<p>Specifies a scheduled task used to back up a selection of resources.</p>', 'refs' => [ 'BackupRulesInput$member' => NULL, ], ], 'BackupRuleName' => [ 'base' => NULL, 'refs' => [ 'BackupRule$RuleName' => '<p>A display name for a backup rule. Must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'BackupRuleInput$RuleName' => '<p>A display name for a backup rule. Must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', ], ], 'BackupRules' => [ 'base' => NULL, 'refs' => [ 'BackupPlan$Rules' => '<p>An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up a selection of resources. </p>', ], ], 'BackupRulesInput' => [ 'base' => NULL, 'refs' => [ 'BackupPlanInput$Rules' => '<p>An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up a selection of resources.</p>', ], ], 'BackupSelection' => [ 'base' => '<p>Used to specify a set of resources to a backup plan.</p> <p>Specifying your desired <code>Conditions</code>, <code>ListOfTags</code>, <code>NotResources</code>, and/or <code>Resources</code> is recommended. If none of these are specified, Backup will attempt to select all supported and opted-in storage resources, which could have unintended cost implications.</p>', 'refs' => [ 'CreateBackupSelectionInput$BackupSelection' => '<p>Specifies the body of a request to assign a set of resources to a backup plan.</p>', 'GetBackupSelectionOutput$BackupSelection' => '<p>Specifies the body of a request to assign a set of resources to a backup plan.</p>', ], ], 'BackupSelectionName' => [ 'base' => NULL, 'refs' => [ 'BackupSelection$SelectionName' => '<p>The display name of a resource selection document. Must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'BackupSelectionsListMember$SelectionName' => '<p>The display name of a resource selection document.</p>', ], ], 'BackupSelectionsList' => [ 'base' => NULL, 'refs' => [ 'ListBackupSelectionsOutput$BackupSelectionsList' => '<p>An array of backup selection list items containing metadata about each resource in the list.</p>', ], ], 'BackupSelectionsListMember' => [ 'base' => '<p>Contains metadata about a <code>BackupSelection</code> object.</p>', 'refs' => [ 'BackupSelectionsList$member' => NULL, ], ], 'BackupVaultEvent' => [ 'base' => NULL, 'refs' => [ 'BackupVaultEvents$member' => NULL, ], ], 'BackupVaultEvents' => [ 'base' => NULL, 'refs' => [ 'GetBackupVaultNotificationsOutput$BackupVaultEvents' => '<p>An array of events that indicate the status of jobs to back up resources to the backup vault.</p>', 'PutBackupVaultNotificationsInput$BackupVaultEvents' => '<p>An array of events that indicate the status of jobs to back up resources to the backup vault.</p> <p>For common use cases and code samples, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/sns-notifications.html">Using Amazon SNS to track Backup events</a>.</p> <p>The following events are supported:</p> <ul> <li> <p> <code>BACKUP_JOB_STARTED</code> | <code>BACKUP_JOB_COMPLETED</code> </p> </li> <li> <p> <code>COPY_JOB_STARTED</code> | <code>COPY_JOB_SUCCESSFUL</code> | <code>COPY_JOB_FAILED</code> </p> </li> <li> <p> <code>RESTORE_JOB_STARTED</code> | <code>RESTORE_JOB_COMPLETED</code> | <code>RECOVERY_POINT_MODIFIED</code> </p> </li> <li> <p> <code>S3_BACKUP_OBJECT_FAILED</code> | <code>S3_RESTORE_OBJECT_FAILED</code> </p> </li> </ul> <note> <p>The list below shows items that are deprecated events (for reference) and are no longer in use. They are no longer supported and will not return statuses or notifications. Refer to the list above for current supported events.</p> </note>', ], ], 'BackupVaultList' => [ 'base' => NULL, 'refs' => [ 'ListBackupVaultsOutput$BackupVaultList' => '<p>An array of backup vault list members containing vault metadata, including Amazon Resource Name (ARN), display name, creation date, number of saved recovery points, and encryption information if the resources saved in the backup vault are encrypted.</p>', ], ], 'BackupVaultListMember' => [ 'base' => '<p>Contains metadata about a backup vault.</p>', 'refs' => [ 'BackupVaultList$member' => NULL, ], ], 'BackupVaultName' => [ 'base' => NULL, 'refs' => [ 'BackupJob$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'BackupRule$TargetBackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'BackupRuleInput$TargetBackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'BackupVaultListMember$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'CreateBackupVaultInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of letters, numbers, and hyphens.</p>', 'CreateBackupVaultOutput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'CreateLogicallyAirGappedBackupVaultInput$BackupVaultName' => '<p>This is the name of the vault that is being created.</p>', 'CreateLogicallyAirGappedBackupVaultOutput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Logically air-gapped backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DeleteBackupVaultAccessPolicyInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DeleteBackupVaultLockConfigurationInput$BackupVaultName' => '<p>The name of the backup vault from which to delete Backup Vault Lock.</p>', 'DeleteBackupVaultNotificationsInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DeleteRecoveryPointInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DescribeBackupJobOutput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DescribeRecoveryPointInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DescribeRecoveryPointOutput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DisassociateRecoveryPointFromParentInput$BackupVaultName' => '<p>This is the name of a logical container where the child (nested) recovery point is stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DisassociateRecoveryPointInput$BackupVaultName' => '<p>The unique name of an Backup vault.</p>', 'GetBackupVaultAccessPolicyInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'GetBackupVaultAccessPolicyOutput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'GetBackupVaultNotificationsInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'GetBackupVaultNotificationsOutput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'GetRecoveryPointRestoreMetadataInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'ListBackupJobsInput$ByBackupVaultName' => '<p>Returns only backup jobs that will be stored in the specified backup vault. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'ListProtectedResourcesByBackupVaultInput$BackupVaultName' => '<p>This is the list of protected resources by backup vault within the vault(s) you specify by name.</p>', 'ListRecoveryPointsByBackupVaultInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p> <note> <p>Backup vault name might not be available when a supported service creates the backup.</p> </note>', 'PutBackupVaultAccessPolicyInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'PutBackupVaultLockConfigurationInput$BackupVaultName' => '<p>The Backup Vault Lock configuration that specifies the name of the backup vault it protects.</p>', 'PutBackupVaultNotificationsInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'RecoveryPointByBackupVault$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'RecoveryPointByResource$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'RecoveryPointMember$BackupVaultName' => '<p>This is the name of the backup vault (the logical container in which backups are stored).</p>', 'StartBackupJobInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'StartCopyJobInput$SourceBackupVaultName' => '<p>The name of a logical source container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'UpdateRecoveryPointLifecycleInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'BackupRule$EnableContinuousBackup' => '<p>Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False (or not specified) causes Backup to create snapshot backups.</p>', 'BackupRuleInput$EnableContinuousBackup' => '<p>Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False (or not specified) causes Backup to create snapshot backups.</p>', 'BackupVaultListMember$Locked' => '<p>A Boolean value that indicates whether Backup Vault Lock applies to the selected backup vault. If <code>true</code>, Vault Lock prevents delete and update operations on the recovery points in the selected vault.</p>', 'DescribeBackupVaultOutput$Locked' => '<p>A Boolean that indicates whether Backup Vault Lock is currently protecting the backup vault. <code>True</code> means that Vault Lock causes delete or update operations on the recovery points stored in the vault to fail.</p>', 'Lifecycle$OptInToArchiveForSupportedResources' => '<p>Optional Boolean. If this is true, this setting will instruct your backup plan to transition supported resources to archive (cold) storage tier in accordance with your lifecycle settings.</p>', 'ListBackupPlansInput$IncludeDeleted' => '<p>A Boolean value with a default value of <code>FALSE</code> that returns deleted backup plans when set to <code>TRUE</code>.</p>', ], ], 'CalculatedLifecycle' => [ 'base' => '<p>Contains <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps, which are used to specify a lifecycle for a recovery point.</p> <p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.</p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.</p> <p>Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature availability by resource</a> table. Backup ignores this expression for other resource types.</p>', 'refs' => [ 'DescribeRecoveryPointOutput$CalculatedLifecycle' => '<p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps.</p>', 'RecoveryPointByBackupVault$CalculatedLifecycle' => '<p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps.</p>', 'UpdateRecoveryPointLifecycleOutput$CalculatedLifecycle' => '<p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code> timestamps.</p>', ], ], 'CancelLegalHoldInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelLegalHoldOutput' => [ 'base' => NULL, 'refs' => [], ], 'ComplianceResourceIdList' => [ 'base' => NULL, 'refs' => [ 'ControlScope$ComplianceResourceIds' => '<p>The ID of the only Amazon Web Services resource that you want your control scope to contain.</p>', ], ], 'Condition' => [ 'base' => '<p>Contains an array of triplets made up of a condition type (such as <code>StringEquals</code>), a key, and a value. Used to filter resources using their tags and assign them to a backup plan. Case sensitive.</p>', 'refs' => [ 'ListOfTags$member' => NULL, ], ], 'ConditionKey' => [ 'base' => NULL, 'refs' => [ 'Condition$ConditionKey' => '<p>The key in a key-value pair. For example, in the tag <code>Department: Accounting</code>, <code>Department</code> is the key.</p>', 'ConditionParameter$ConditionKey' => '<p>The key in a key-value pair. For example, in the tag <code>Department: Accounting</code>, <code>Department</code> is the key.</p>', ], ], 'ConditionParameter' => [ 'base' => '<p>Includes information about tags you define to assign tagged resources to a backup plan.</p>', 'refs' => [ 'ConditionParameters$member' => NULL, ], ], 'ConditionParameters' => [ 'base' => NULL, 'refs' => [ 'Conditions$StringEquals' => '<p>Filters the values of your tagged resources for only those resources that you tagged with the same value. Also called "exact matching."</p>', 'Conditions$StringNotEquals' => '<p>Filters the values of your tagged resources for only those resources that you tagged that do not have the same value. Also called "negated matching."</p>', 'Conditions$StringLike' => '<p>Filters the values of your tagged resources for matching tag values with the use of a wildcard character (*) anywhere in the string. For example, "prod*" or "*rod*" matches the tag value "production".</p>', 'Conditions$StringNotLike' => '<p>Filters the values of your tagged resources for non-matching tag values with the use of a wildcard character (*) anywhere in the string.</p>', ], ], 'ConditionType' => [ 'base' => NULL, 'refs' => [ 'Condition$ConditionType' => '<p>An operation applied to a key-value pair used to assign resources to your backup plan. Condition only supports <code>StringEquals</code>. For more flexible assignment options, including <code>StringLike</code> and the ability to exclude resources from your backup plan, use <code>Conditions</code> (with an "s" on the end) for your <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BackupSelection.html"> <code>BackupSelection</code> </a>.</p>', ], ], 'ConditionValue' => [ 'base' => NULL, 'refs' => [ 'Condition$ConditionValue' => '<p>The value in a key-value pair. For example, in the tag <code>Department: Accounting</code>, <code>Accounting</code> is the value.</p>', 'ConditionParameter$ConditionValue' => '<p>The value in a key-value pair. For example, in the tag <code>Department: Accounting</code>, <code>Accounting</code> is the value.</p>', ], ], 'Conditions' => [ 'base' => '<p>Contains information about which resources to include or exclude from a backup plan using their tags. Conditions are case sensitive.</p>', 'refs' => [ 'BackupSelection$Conditions' => '<p>A list of conditions that you define to assign resources to your backup plans using tags. For example, <code>"StringEquals": { "Key": "aws:ResourceTag/CreatedByCryo", "Value": "true" },</code>. Condition operators are case sensitive.</p> <p> <code>Conditions</code> differs from <code>ListOfTags</code> as follows:</p> <ul> <li> <p>When you specify more than one condition, you only assign the resources that match ALL conditions (using AND logic).</p> </li> <li> <p> <code>Conditions</code> supports <code>StringEquals</code>, <code>StringLike</code>, <code>StringNotEquals</code>, and <code>StringNotLike</code>. <code>ListOfTags</code> only supports <code>StringEquals</code>.</p> </li> </ul>', ], ], 'ConflictException' => [ 'base' => '<p>Backup can\'t perform the action that you requested until it finishes performing a previous action. Try again later.</p>', 'refs' => [], ], 'ControlInputParameter' => [ 'base' => '<p>A list of parameters for a control. A control can have zero, one, or more than one parameter. An example of a control with two parameters is: "backup plan frequency is at least <code>daily</code> and the retention period is at least <code>1 year</code>". The first parameter is <code>daily</code>. The second parameter is <code>1 year</code>.</p>', 'refs' => [ 'ControlInputParameters$member' => NULL, ], ], 'ControlInputParameters' => [ 'base' => NULL, 'refs' => [ 'FrameworkControl$ControlInputParameters' => '<p>A list of <code>ParameterName</code> and <code>ParameterValue</code> pairs.</p>', ], ], 'ControlName' => [ 'base' => NULL, 'refs' => [ 'FrameworkControl$ControlName' => '<p>The name of a control. This name is between 1 and 256 characters.</p>', ], ], 'ControlScope' => [ 'base' => '<p>A framework consists of one or more controls. Each control has its own control scope. The control scope can include one or more resource types, a combination of a tag key and value, or a combination of one resource type and one resource ID. If no scope is specified, evaluations for the rule are triggered when any resource in your recording group changes in configuration.</p> <note> <p>To set a control scope that includes all of a particular resource, leave the <code>ControlScope</code> empty or do not pass it when calling <code>CreateFramework</code>.</p> </note>', 'refs' => [ 'FrameworkControl$ControlScope' => '<p>The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ControlScope.html"> <code>ControlScope</code>.</a> </p>', ], ], 'CopyAction' => [ 'base' => '<p>The details of the copy operation.</p>', 'refs' => [ 'CopyActions$member' => NULL, ], ], 'CopyActions' => [ 'base' => NULL, 'refs' => [ 'BackupRule$CopyActions' => '<p>An array of <code>CopyAction</code> objects, which contains the details of the copy operation.</p>', 'BackupRuleInput$CopyActions' => '<p>An array of <code>CopyAction</code> objects, which contains the details of the copy operation.</p>', ], ], 'CopyJob' => [ 'base' => '<p>Contains detailed information about a copy job.</p>', 'refs' => [ 'CopyJobsList$member' => NULL, 'DescribeCopyJobOutput$CopyJob' => '<p>Contains detailed information about a copy job.</p>', ], ], 'CopyJobChildJobsInState' => [ 'base' => NULL, 'refs' => [ 'CopyJob$ChildJobsInState' => '<p>This returns the statistics of the included child (nested) copy jobs.</p>', ], ], 'CopyJobState' => [ 'base' => NULL, 'refs' => [ 'CopyJob$State' => '<p>The current state of a copy job.</p>', 'CopyJobChildJobsInState$key' => NULL, 'ListCopyJobsInput$ByState' => '<p>Returns only copy jobs that are in the specified state.</p>', ], ], 'CopyJobStatus' => [ 'base' => NULL, 'refs' => [ 'CopyJobSummary$State' => '<p>This value is job count for jobs with the specified state.</p>', 'ListCopyJobSummariesInput$State' => '<p>This parameter returns the job count for jobs with the specified state.</p> <p>The the value ANY returns count of all states.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts for all states and returns the sum.</p>', ], ], 'CopyJobSummary' => [ 'base' => '<p>This is a summary of copy jobs created or running within the most recent 30 days.</p> <p>The returned summary may contain the following: Region, Account, State, RestourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.</p>', 'refs' => [ 'CopyJobSummaryList$member' => NULL, ], ], 'CopyJobSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCopyJobSummariesOutput$CopyJobSummaries' => '<p>This return shows a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.</p>', ], ], 'CopyJobsList' => [ 'base' => NULL, 'refs' => [ 'ListCopyJobsOutput$CopyJobs' => '<p>An array of structures containing metadata about your copy jobs returned in JSON format. </p>', ], ], 'CreateBackupPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateBackupPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateBackupSelectionInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateBackupSelectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateBackupVaultInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateBackupVaultOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateFrameworkInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateFrameworkOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateLegalHoldInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateLegalHoldOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateLogicallyAirGappedBackupVaultInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateLogicallyAirGappedBackupVaultOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateReportPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateReportPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateRestoreTestingPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateRestoreTestingPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateRestoreTestingSelectionInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateRestoreTestingSelectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'CronExpression' => [ 'base' => NULL, 'refs' => [ 'BackupRule$ScheduleExpression' => '<p>A cron expression in UTC specifying when Backup initiates a backup job. For more information about Amazon Web Services cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expressions for Rules</a> in the <i>Amazon CloudWatch Events User Guide.</i>. Two examples of Amazon Web Services cron expressions are <code> 15 * ? * * *</code> (take a backup every hour at 15 minutes past the hour) and <code>0 12 * * ? *</code> (take a backup every day at 12 noon UTC). For a table of examples, click the preceding link and scroll down the page.</p>', 'BackupRuleInput$ScheduleExpression' => '<p>A CRON expression in UTC specifying when Backup initiates a backup job.</p>', ], ], 'DateRange' => [ 'base' => '<p>This is a resource filter containing FromDate: DateTime and ToDate: DateTime. Both values are required. Future DateTime values are not permitted.</p> <p>The date and time are in Unix format and Coordinated Universal Time (UTC), and it is accurate to milliseconds ((milliseconds are optional). For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'refs' => [ 'RecoveryPointSelection$DateRange' => NULL, ], ], 'DeleteBackupPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBackupPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBackupSelectionInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBackupVaultAccessPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBackupVaultInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBackupVaultLockConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBackupVaultNotificationsInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFrameworkInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRecoveryPointInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReportPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRestoreTestingPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRestoreTestingSelectionInput' => [ 'base' => NULL, 'refs' => [], ], 'DependencyFailureException' => [ 'base' => '<p>A dependent Amazon Web Services service or resource returned an error to the Backup service, and the action cannot be completed.</p>', 'refs' => [], ], 'DescribeBackupJobInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBackupJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBackupVaultInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBackupVaultOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCopyJobInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCopyJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFrameworkInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFrameworkOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGlobalSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGlobalSettingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProtectedResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProtectedResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecoveryPointInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecoveryPointOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegionSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegionSettingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReportJobInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReportJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReportPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReportPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRestoreJobInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRestoreJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateRecoveryPointFromParentInput' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateRecoveryPointInput' => [ 'base' => NULL, 'refs' => [], ], 'ExportBackupPlanTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'ExportBackupPlanTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'FormatList' => [ 'base' => NULL, 'refs' => [ 'ReportDeliveryChannel$Formats' => '<p>A list of the format of your reports: <code>CSV</code>, <code>JSON</code>, or both. If not specified, the default format is <code>CSV</code>.</p>', ], ], 'Framework' => [ 'base' => '<p>Contains detailed information about a framework. Frameworks contain controls, which evaluate and report on your backup events and resources. Frameworks generate daily compliance results.</p>', 'refs' => [ 'FrameworkList$member' => NULL, ], ], 'FrameworkControl' => [ 'base' => '<p>Contains detailed information about all of the controls of a framework. Each framework must contain at least one control.</p>', 'refs' => [ 'FrameworkControls$member' => NULL, ], ], 'FrameworkControls' => [ 'base' => NULL, 'refs' => [ 'CreateFrameworkInput$FrameworkControls' => '<p>A list of the controls that make up the framework. Each control in the list has a name, input parameters, and scope.</p>', 'DescribeFrameworkOutput$FrameworkControls' => '<p>A list of the controls that make up the framework. Each control in the list has a name, input parameters, and scope.</p>', 'UpdateFrameworkInput$FrameworkControls' => '<p>A list of the controls that make up the framework. Each control in the list has a name, input parameters, and scope.</p>', ], ], 'FrameworkDescription' => [ 'base' => NULL, 'refs' => [ 'CreateFrameworkInput$FrameworkDescription' => '<p>An optional description of the framework with a maximum of 1,024 characters.</p>', 'DescribeFrameworkOutput$FrameworkDescription' => '<p>An optional description of the framework.</p>', 'Framework$FrameworkDescription' => '<p>An optional description of the framework with a maximum 1,024 characters.</p>', 'UpdateFrameworkInput$FrameworkDescription' => '<p>An optional description of the framework with a maximum 1,024 characters.</p>', ], ], 'FrameworkList' => [ 'base' => NULL, 'refs' => [ 'ListFrameworksOutput$Frameworks' => '<p>A list of frameworks with details for each framework, including the framework name, Amazon Resource Name (ARN), description, number of controls, creation time, and deployment status.</p>', ], ], 'FrameworkName' => [ 'base' => NULL, 'refs' => [ 'CreateFrameworkInput$FrameworkName' => '<p>The unique name of the framework. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', 'CreateFrameworkOutput$FrameworkName' => '<p>The unique name of the framework. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', 'DeleteFrameworkInput$FrameworkName' => '<p>The unique name of a framework.</p>', 'DescribeFrameworkInput$FrameworkName' => '<p>The unique name of a framework.</p>', 'DescribeFrameworkOutput$FrameworkName' => '<p>The unique name of a framework.</p>', 'Framework$FrameworkName' => '<p>The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', 'UpdateFrameworkInput$FrameworkName' => '<p>The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', 'UpdateFrameworkOutput$FrameworkName' => '<p>The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', ], ], 'GetBackupPlanFromJSONInput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupPlanFromJSONOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupPlanFromTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupPlanFromTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupSelectionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupSelectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupVaultAccessPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupVaultAccessPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupVaultNotificationsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetBackupVaultNotificationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetLegalHoldInput' => [ 'base' => NULL, 'refs' => [], ], 'GetLegalHoldOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetRecoveryPointRestoreMetadataInput' => [ 'base' => NULL, 'refs' => [], ], 'GetRecoveryPointRestoreMetadataOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetRestoreJobMetadataInput' => [ 'base' => NULL, 'refs' => [], ], 'GetRestoreJobMetadataOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetRestoreTestingInferredMetadataInput' => [ 'base' => NULL, 'refs' => [], ], 'GetRestoreTestingInferredMetadataOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetRestoreTestingPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'GetRestoreTestingPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetRestoreTestingSelectionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetRestoreTestingSelectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSupportedResourceTypesOutput' => [ 'base' => NULL, 'refs' => [], ], 'GlobalSettings' => [ 'base' => NULL, 'refs' => [ 'DescribeGlobalSettingsOutput$GlobalSettings' => '<p>The status of the flag <code>isCrossAccountBackupEnabled</code>.</p>', 'UpdateGlobalSettingsInput$GlobalSettings' => '<p>A value for <code>isCrossAccountBackupEnabled</code> and a Region. Example: <code>update-global-settings --global-settings isCrossAccountBackupEnabled=false --region us-west-2</code>.</p>', ], ], 'GlobalSettingsName' => [ 'base' => NULL, 'refs' => [ 'GlobalSettings$key' => NULL, ], ], 'GlobalSettingsValue' => [ 'base' => NULL, 'refs' => [ 'GlobalSettings$value' => NULL, ], ], 'IAMPolicy' => [ 'base' => NULL, 'refs' => [ 'GetBackupVaultAccessPolicyOutput$Policy' => '<p>The backup vault access policy document in JSON format.</p>', 'PutBackupVaultAccessPolicyInput$Policy' => '<p>The backup vault access policy document in JSON format.</p>', ], ], 'IAMRoleArn' => [ 'base' => NULL, 'refs' => [ 'BackupJob$IamRoleArn' => '<p>Specifies the IAM role ARN used to create the target recovery point. IAM roles other than the default role must include either <code>AWSBackup</code> or <code>AwsBackup</code> in the role name. For example, <code>arn:aws:iam::123456789012:role/AWSBackupRDSAccess</code>. Role names without those strings lack permissions to perform backup jobs.</p>', 'BackupSelection$IamRoleArn' => '<p>The ARN of the IAM role that Backup uses to authenticate when backing up the target resource; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'BackupSelectionsListMember$IamRoleArn' => '<p>Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'CopyJob$IamRoleArn' => '<p>Specifies the IAM role ARN used to copy the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'DescribeBackupJobOutput$IamRoleArn' => '<p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'DescribeRecoveryPointOutput$IamRoleArn' => '<p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'DescribeRestoreJobOutput$IamRoleArn' => '<p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'RecoveryPointByBackupVault$IamRoleArn' => '<p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'RestoreJobsListMember$IamRoleArn' => '<p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'StartBackupJobInput$IamRoleArn' => '<p>Specifies the IAM role ARN used to create the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'StartCopyJobInput$IamRoleArn' => '<p>Specifies the IAM role ARN used to copy the target recovery point; for example, <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'StartRestoreJobInput$IamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example: <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', ], ], 'InvalidParameterValueException' => [ 'base' => '<p>Indicates that something is wrong with a parameter\'s value. For example, the value is out of range.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong type.</p>', 'refs' => [], ], 'InvalidResourceStateException' => [ 'base' => '<p>Backup is already performing an action on this recovery point. It can\'t perform the action you requested until the first action finishes. Try again later.</p>', 'refs' => [], ], 'IsEnabled' => [ 'base' => NULL, 'refs' => [ 'ResourceTypeManagementPreference$value' => NULL, 'ResourceTypeOptInPreference$value' => NULL, ], ], 'KeyValue' => [ 'base' => '<p>Pair of two related strings. Allowed characters are letters, white space, and numbers that can be represented in UTF-8 and the following characters: <code> + - = . _ : /</code> </p>', 'refs' => [ 'KeyValueList$member' => NULL, ], ], 'KeyValueList' => [ 'base' => NULL, 'refs' => [ 'ProtectedResourceConditions$StringEquals' => '<p>Filters the values of your tagged resources for only those resources that you tagged with the same value. Also called "exact matching."</p>', 'ProtectedResourceConditions$StringNotEquals' => '<p>Filters the values of your tagged resources for only those resources that you tagged that do not have the same value. Also called "negated matching."</p>', ], ], 'LegalHold' => [ 'base' => '<p>A legal hold is an administrative tool that helps prevent backups from being deleted while under a hold. While the hold is in place, backups under a hold cannot be deleted and lifecycle policies that would alter the backup status (such as transition to cold storage) are delayed until the legal hold is removed. A backup can have more than one legal hold. Legal holds are applied to one or more backups (also known as recovery points). These backups can be filtered by resource types and by resource IDs.</p>', 'refs' => [ 'LegalHoldsList$member' => NULL, ], ], 'LegalHoldStatus' => [ 'base' => NULL, 'refs' => [ 'CreateLegalHoldOutput$Status' => '<p>This displays the status of the legal hold returned after creating the legal hold. Statuses can be <code>ACTIVE</code>, <code>PENDING</code>, <code>CANCELED</code>, <code>CANCELING</code>, or <code>FAILED</code>.</p>', 'GetLegalHoldOutput$Status' => '<p>This is the status of the legal hold. Statuses can be <code>ACTIVE</code>, <code>CREATING</code>, <code>CANCELED</code>, and <code>CANCELING</code>.</p>', 'LegalHold$Status' => '<p>This is the status of the legal hold. Statuses can be <code>ACTIVE</code>, <code>CREATING</code>, <code>CANCELED</code>, and <code>CANCELING</code>.</p>', ], ], 'LegalHoldsList' => [ 'base' => NULL, 'refs' => [ 'ListLegalHoldsOutput$LegalHolds' => '<p>This is an array of returned legal holds, both active and previous.</p>', ], ], 'Lifecycle' => [ 'base' => '<p>Contains an array of <code>Transition</code> objects specifying how long in days before a recovery point transitions to cold storage or is deleted.</p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, on the console, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.</p> <p>Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature availability by resource</a> table. Backup ignores this expression for other resource types.</p>', 'refs' => [ 'BackupRule$Lifecycle' => '<p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p> <p>Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature availability by resource</a> table. Backup ignores this expression for other resource types.</p>', 'BackupRuleInput$Lifecycle' => '<p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup will transition and expire backups automatically according to the lifecycle that you define. </p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.</p> <p>Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature availability by resource</a> table. Backup ignores this expression for other resource types.</p> <p>This parameter has a maximum value of 100 years (36,500 days).</p>', 'CopyAction$Lifecycle' => NULL, 'DescribeRecoveryPointOutput$Lifecycle' => '<p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.</p> <p>Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p> <p>Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature availability by resource</a> table. Backup ignores this expression for other resource types.</p>', 'RecoveryPointByBackupVault$Lifecycle' => '<p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p> <p>Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature availability by resource</a> table. Backup ignores this expression for other resource types.</p>', 'StartBackupJobInput$Lifecycle' => '<p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup will transition and expire backups automatically according to the lifecycle that you define. </p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p> <p>Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature availability by resource</a> table. Backup ignores this expression for other resource types.</p> <p>This parameter has a maximum value of 100 years (36,500 days).</p>', 'StartCopyJobInput$Lifecycle' => NULL, 'UpdateRecoveryPointLifecycleInput$Lifecycle' => '<p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. </p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold. </p>', 'UpdateRecoveryPointLifecycleOutput$Lifecycle' => '<p>The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.</p> <p>Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.</p> <p>Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature availability by resource</a> table. Backup ignores this expression for other resource types.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.</p>', 'refs' => [], ], 'ListBackupJobSummariesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupJobSummariesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupJobsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupJobsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupPlanTemplatesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupPlanTemplatesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupPlanVersionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupPlanVersionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupPlansInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupPlansOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupSelectionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupSelectionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupVaultsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListBackupVaultsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCopyJobSummariesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCopyJobSummariesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCopyJobsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCopyJobsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListFrameworksInput' => [ 'base' => NULL, 'refs' => [], ], 'ListFrameworksOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListLegalHoldsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListLegalHoldsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListOfTags' => [ 'base' => NULL, 'refs' => [ 'BackupSelection$ListOfTags' => '<p>A list of conditions that you define to assign resources to your backup plans using tags. For example, <code>"StringEquals": { "Key": "aws:ResourceTag/CreatedByCryo", "Value": "true" },</code>. Condition operators are case sensitive.</p> <p> <code>ListOfTags</code> differs from <code>Conditions</code> as follows:</p> <ul> <li> <p>When you specify more than one condition, you assign all resources that match AT LEAST ONE condition (using OR logic).</p> </li> <li> <p> <code>ListOfTags</code> only supports <code>StringEquals</code>. <code>Conditions</code> supports <code>StringEquals</code>, <code>StringLike</code>, <code>StringNotEquals</code>, and <code>StringNotLike</code>. </p> </li> </ul>', ], ], 'ListProtectedResourcesByBackupVaultInput' => [ 'base' => NULL, 'refs' => [], ], 'ListProtectedResourcesByBackupVaultOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListProtectedResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListProtectedResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRecoveryPointsByBackupVaultInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRecoveryPointsByBackupVaultOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRecoveryPointsByLegalHoldInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRecoveryPointsByLegalHoldOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRecoveryPointsByResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRecoveryPointsByResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListReportJobsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListReportJobsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListReportPlansInput' => [ 'base' => NULL, 'refs' => [], ], 'ListReportPlansOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRestoreJobSummariesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRestoreJobSummariesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRestoreJobsByProtectedResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRestoreJobsByProtectedResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRestoreJobsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRestoreJobsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRestoreTestingPlansInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRestoreTestingPlansInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListRestoreTestingPlansInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', ], ], 'ListRestoreTestingPlansOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRestoreTestingSelectionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRestoreTestingSelectionsInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListRestoreTestingSelectionsInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', ], ], 'ListRestoreTestingSelectionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'BackupJob$BackupSizeInBytes' => '<p>The size, in bytes, of a backup.</p>', 'BackupJob$BytesTransferred' => '<p>The size in bytes transferred to a backup vault at the time that the job status was queried.</p>', 'BackupJobChildJobsInState$value' => NULL, 'BackupVaultListMember$MinRetentionDays' => '<p>The Backup Vault Lock setting that specifies the minimum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a minimum retention period.</p> <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job\'s retention period is shorter than that minimum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>', 'BackupVaultListMember$MaxRetentionDays' => '<p>The Backup Vault Lock setting that specifies the maximum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a maximum retention period on the recovery points in the vault (allowing indefinite storage).</p> <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job\'s retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>', 'CancelLegalHoldInput$RetainRecordInDays' => '<p>The integer amount in days specifying amount of days after this API operation to remove legal hold.</p>', 'CopyJob$BackupSizeInBytes' => '<p>The size, in bytes, of a copy job.</p>', 'CopyJob$NumberOfChildJobs' => '<p>This is the number of child (nested) copy jobs.</p>', 'CopyJobChildJobsInState$value' => NULL, 'CreateLogicallyAirGappedBackupVaultInput$MinRetentionDays' => '<p>This setting specifies the minimum retention period that the vault retains its recovery points. If this parameter is not specified, no minimum retention period is enforced.</p> <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If a job retention period is shorter than that minimum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault.</p>', 'CreateLogicallyAirGappedBackupVaultInput$MaxRetentionDays' => '<p>This is the setting that specifies the maximum retention period that the vault retains its recovery points. If this parameter is not specified, Backup does not enforce a maximum retention period on the recovery points in the vault (allowing indefinite storage).</p> <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault.</p>', 'DescribeBackupJobOutput$BackupSizeInBytes' => '<p>The size, in bytes, of a backup.</p>', 'DescribeBackupJobOutput$BytesTransferred' => '<p>The size in bytes transferred to a backup vault at the time that the job status was queried.</p>', 'DescribeBackupJobOutput$NumberOfChildJobs' => '<p>This returns the number of child (nested) backup jobs.</p>', 'DescribeBackupVaultOutput$MinRetentionDays' => '<p>The Backup Vault Lock setting that specifies the minimum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a minimum retention period.</p> <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job\'s retention period is shorter than that minimum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>', 'DescribeBackupVaultOutput$MaxRetentionDays' => '<p>The Backup Vault Lock setting that specifies the maximum retention period that the vault retains its recovery points. If this parameter is not specified, Vault Lock does not enforce a maximum retention period on the recovery points in the vault (allowing indefinite storage).</p> <p>If specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job\'s retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already stored in the vault prior to Vault Lock are not affected.</p>', 'DescribeProtectedResourceOutput$LatestRestoreExecutionTimeMinutes' => '<p>This is the time in minutes the most recent restore job took to complete.</p>', 'DescribeRecoveryPointOutput$BackupSizeInBytes' => '<p>The size, in bytes, of a backup.</p>', 'DescribeRestoreJobOutput$BackupSizeInBytes' => '<p>The size, in bytes, of the restored resource.</p>', 'DescribeRestoreJobOutput$ExpectedCompletionTimeMinutes' => '<p>The amount of time in minutes that a job restoring a recovery point is expected to take.</p>', 'Lifecycle$MoveToColdStorageAfterDays' => '<p>Specifies the number of days after creation that a recovery point is moved to cold storage.</p>', 'Lifecycle$DeleteAfterDays' => '<p>Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90 days plus <code>MoveToColdStorageAfterDays</code>.</p>', 'PutBackupVaultLockConfigurationInput$MinRetentionDays' => '<p>The Backup Vault Lock configuration that specifies the minimum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization\'s policies require you to retain certain data for at least seven years (2555 days).</p> <p>If this parameter is not specified, Vault Lock will not enforce a minimum retention period.</p> <p>If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job\'s retention period is shorter than that minimum retention period, then the vault fails that backup or copy job, and you should either modify your lifecycle settings or use a different vault. The shortest minimum retention period you can specify is 1 day. Recovery points already saved in the vault prior to Vault Lock are not affected.</p>', 'PutBackupVaultLockConfigurationInput$MaxRetentionDays' => '<p>The Backup Vault Lock configuration that specifies the maximum retention period that the vault retains its recovery points. This setting can be useful if, for example, your organization\'s policies require you to destroy certain data after retaining it for four years (1460 days).</p> <p>If this parameter is not included, Vault Lock does not enforce a maximum retention period on the recovery points in the vault. If this parameter is included without a value, Vault Lock will not enforce a maximum retention period.</p> <p>If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job\'s retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. The longest maximum retention period you can specify is 36500 days (approximately 100 years). Recovery points already saved in the vault prior to Vault Lock are not affected.</p>', 'PutBackupVaultLockConfigurationInput$ChangeableForDays' => '<p>The Backup Vault Lock configuration that specifies the number of days before the lock date. For example, setting <code>ChangeableForDays</code> to 30 on Jan. 1, 2022 at 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.</p> <p>Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable. Therefore, you must set <code>ChangeableForDays</code> to 3 or greater.</p> <p>Before the lock date, you can delete Vault Lock from the vault using <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using <code>PutBackupVaultLockConfiguration</code>. On and after the lock date, the Vault Lock becomes immutable and cannot be changed or deleted.</p> <p>If this parameter is not specified, you can delete Vault Lock from the vault using <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using <code>PutBackupVaultLockConfiguration</code> at any time.</p>', 'RecoveryPointByBackupVault$BackupSizeInBytes' => '<p>The size, in bytes, of a backup.</p>', 'RecoveryPointByResource$BackupSizeBytes' => '<p>The size, in bytes, of a backup.</p>', 'RestoreJobsListMember$BackupSizeInBytes' => '<p>The size, in bytes, of the restored resource.</p>', 'RestoreJobsListMember$ExpectedCompletionTimeMinutes' => '<p>The amount of time in minutes that a job restoring a recovery point is expected to take.</p>', ], ], 'MaxFrameworkInputs' => [ 'base' => NULL, 'refs' => [ 'ListFrameworksInput$MaxResults' => '<p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will return 1 MB of data.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListBackupJobSummariesInput$MaxResults' => '<p>This parameter sets the maximum number of items to be returned.</p> <p>The value is an integer. Range of accepted values is from 1 to 500.</p>', 'ListBackupJobsInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListBackupPlanTemplatesInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListBackupPlanVersionsInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListBackupPlansInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListBackupSelectionsInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListBackupVaultsInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListCopyJobSummariesInput$MaxResults' => '<p>This parameter sets the maximum number of items to be returned.</p> <p>The value is an integer. Range of accepted values is from 1 to 500.</p>', 'ListCopyJobsInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListLegalHoldsInput$MaxResults' => '<p>The maximum number of resource list items to be returned.</p>', 'ListProtectedResourcesByBackupVaultInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListProtectedResourcesInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListRecoveryPointsByBackupVaultInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListRecoveryPointsByLegalHoldInput$MaxResults' => '<p>This is the maximum number of resource list items to be returned.</p>', 'ListRecoveryPointsByResourceInput$MaxResults' => '<p>The maximum number of items to be returned.</p> <note> <p>Amazon RDS requires a value of at least 20.</p> </note>', 'ListReportJobsInput$MaxResults' => '<p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will return 1 MB of data.</p>', 'ListReportPlansInput$MaxResults' => '<p>The number of desired results from 1 to 1000. Optional. If unspecified, the query will return 1 MB of data.</p>', 'ListRestoreJobSummariesInput$MaxResults' => '<p>This parameter sets the maximum number of items to be returned.</p> <p>The value is an integer. Range of accepted values is from 1 to 500.</p>', 'ListRestoreJobsByProtectedResourceInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListRestoreJobsInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', 'ListTagsInput$MaxResults' => '<p>The maximum number of items to be returned.</p>', ], ], 'MessageCategory' => [ 'base' => NULL, 'refs' => [ 'BackupJobSummary$MessageCategory' => '<p>This parameter is the job count for the specified message category.</p> <p>Example strings include <code>AccessDenied</code>, <code>Success</code>, and <code>InvalidParameters</code>. See <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a list of MessageCategory strings.</p> <p>The the value ANY returns count of all message categories.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.</p>', 'CopyJobSummary$MessageCategory' => '<p>This parameter is the job count for the specified message category.</p> <p>Example strings include <code>AccessDenied</code>, <code>Success</code>, and <code>InvalidParameters</code>. See <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a list of MessageCategory strings.</p> <p>The the value ANY returns count of all message categories.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.</p>', 'ListBackupJobSummariesInput$MessageCategory' => '<p>This parameter returns the job count for the specified message category.</p> <p>Example accepted strings include <code>AccessDenied</code>, <code>Success</code>, and <code>InvalidParameters</code>. See <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a list of accepted MessageCategory strings.</p> <p>The the value ANY returns count of all message categories.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.</p>', 'ListCopyJobSummariesInput$MessageCategory' => '<p>This parameter returns the job count for the specified message category.</p> <p>Example accepted strings include <code>AccessDenied</code>, <code>Success</code>, and <code>InvalidParameters</code>. See <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a list of accepted MessageCategory strings.</p> <p>The the value ANY returns count of all message categories.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.</p>', ], ], 'Metadata' => [ 'base' => NULL, 'refs' => [ 'GetRecoveryPointRestoreMetadataOutput$RestoreMetadata' => '<p>The set of metadata key-value pairs that describe the original configuration of the backed-up resource. These values vary depending on the service that is being restored.</p>', 'GetRestoreJobMetadataOutput$Metadata' => '<p>This contains the metadata of the specified backup job.</p>', 'StartRestoreJobInput$Metadata' => '<p>A set of metadata key-value pairs. Contains information, such as a resource name, required to restore a recovery point.</p> <p> You can get configuration metadata about a resource at the time it was backed up by calling <code>GetRecoveryPointRestoreMetadata</code>. However, values in addition to those provided by <code>GetRecoveryPointRestoreMetadata</code> might be required to restore a resource. For example, you might need to provide a new resource name if the original already exists.</p> <p>You need to specify specific metadata to restore an Amazon Elastic File System (Amazon EFS) instance:</p> <ul> <li> <p> <code>file-system-id</code>: The ID of the Amazon EFS file system that is backed up by Backup. Returned in <code>GetRecoveryPointRestoreMetadata</code>.</p> </li> <li> <p> <code>Encrypted</code>: A Boolean value that, if true, specifies that the file system is encrypted. If <code>KmsKeyId</code> is specified, <code>Encrypted</code> must be set to <code>true</code>.</p> </li> <li> <p> <code>KmsKeyId</code>: Specifies the Amazon Web Services KMS key that is used to encrypt the restored file system. You can specify a key from another Amazon Web Services account provided that key it is properly shared with your account via Amazon Web Services KMS.</p> </li> <li> <p> <code>PerformanceMode</code>: Specifies the throughput mode of the file system.</p> </li> <li> <p> <code>CreationToken</code>: A user-supplied value that ensures the uniqueness (idempotency) of the request.</p> </li> <li> <p> <code>newFileSystem</code>: A Boolean value that, if true, specifies that the recovery point is restored to a new Amazon EFS file system.</p> </li> <li> <p> <code>ItemsToRestore</code>: An array of one to five strings where each string is a file path. Use <code>ItemsToRestore</code> to restore specific files or directories rather than the entire file system. This parameter is optional. For example, <code>"itemsToRestore":"[\\"/my.test\\"]"</code>.</p> </li> </ul>', ], ], 'MetadataKey' => [ 'base' => NULL, 'refs' => [ 'Metadata$key' => NULL, ], ], 'MetadataValue' => [ 'base' => NULL, 'refs' => [ 'Metadata$value' => NULL, ], ], 'MissingParameterValueException' => [ 'base' => '<p>Indicates that a required parameter is missing.</p>', 'refs' => [], ], 'ParameterName' => [ 'base' => NULL, 'refs' => [ 'ControlInputParameter$ParameterName' => '<p>The name of a parameter, for example, <code>BackupPlanFrequency</code>.</p>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'ControlInputParameter$ParameterValue' => '<p>The value of parameter, for example, <code>hourly</code>.</p>', ], ], 'ProtectedResource' => [ 'base' => '<p>A structure that contains information about a backed-up resource.</p>', 'refs' => [ 'ProtectedResourcesList$member' => NULL, ], ], 'ProtectedResourceConditions' => [ 'base' => '<p>A list of conditions that you define for resources in your restore testing plan using tags.</p> <p>For example, <code>"StringEquals": { "Key": "aws:ResourceTag/CreatedByCryo", "Value": "true" },</code>. Condition operators are case sensitive.</p>', 'refs' => [ 'RestoreTestingSelectionForCreate$ProtectedResourceConditions' => '<p>If you have included the wildcard in ProtectedResourceArns, you can include resource conditions, such as <code>ProtectedResourceConditions: { StringEquals: [{ key: "XXXX", value: "YYYY" }]</code>.</p>', 'RestoreTestingSelectionForGet$ProtectedResourceConditions' => '<p>In a resource testing selection, this parameter filters by specific conditions such as <code>StringEquals</code> or <code>StringNotEquals</code>.</p>', 'RestoreTestingSelectionForUpdate$ProtectedResourceConditions' => '<p>A list of conditions that you define for resources in your restore testing plan using tags.</p> <p>For example, <code>"StringEquals": { "Key": "aws:ResourceTag/CreatedByCryo", "Value": "true" },</code>. Condition operators are case sensitive.</p>', ], ], 'ProtectedResourcesList' => [ 'base' => NULL, 'refs' => [ 'ListProtectedResourcesByBackupVaultOutput$Results' => '<p>These are the results returned for the request ListProtectedResourcesByBackupVault.</p>', 'ListProtectedResourcesOutput$Results' => '<p>An array of resources successfully backed up by Backup including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.</p>', ], ], 'PutBackupVaultAccessPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'PutBackupVaultLockConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'PutBackupVaultNotificationsInput' => [ 'base' => NULL, 'refs' => [], ], 'PutRestoreValidationResultInput' => [ 'base' => NULL, 'refs' => [], ], 'RecoveryPointByBackupVault' => [ 'base' => '<p>Contains detailed information about the recovery points stored in a backup vault.</p>', 'refs' => [ 'RecoveryPointByBackupVaultList$member' => NULL, ], ], 'RecoveryPointByBackupVaultList' => [ 'base' => NULL, 'refs' => [ 'ListRecoveryPointsByBackupVaultOutput$RecoveryPoints' => '<p>An array of objects that contain detailed information about recovery points saved in a backup vault.</p>', ], ], 'RecoveryPointByResource' => [ 'base' => '<p>Contains detailed information about a saved recovery point.</p>', 'refs' => [ 'RecoveryPointByResourceList$member' => NULL, ], ], 'RecoveryPointByResourceList' => [ 'base' => NULL, 'refs' => [ 'ListRecoveryPointsByResourceOutput$RecoveryPoints' => '<p>An array of objects that contain detailed information about recovery points of the specified resource type.</p> <note> <p>Only Amazon EFS and Amazon EC2 recovery points return BackupVaultName.</p> </note>', ], ], 'RecoveryPointCreator' => [ 'base' => '<p>Contains information about the backup plan and rule that Backup used to initiate the recovery point backup.</p>', 'refs' => [ 'BackupJob$CreatedBy' => '<p>Contains identifying information about the creation of a backup job, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan used to create it.</p>', 'CopyJob$CreatedBy' => NULL, 'DescribeBackupJobOutput$CreatedBy' => '<p>Contains identifying information about the creation of a backup job, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan that is used to create it.</p>', 'DescribeRecoveryPointOutput$CreatedBy' => '<p>Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan used to create it.</p>', 'RecoveryPointByBackupVault$CreatedBy' => '<p>Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan that is used to create it.</p>', ], ], 'RecoveryPointMember' => [ 'base' => '<p>This is a recovery point which is a child (nested) recovery point of a parent (composite) recovery point. These recovery points can be disassociated from their parent (composite) recovery point, in which case they will no longer be a member.</p>', 'refs' => [ 'RecoveryPointsList$member' => NULL, ], ], 'RecoveryPointSelection' => [ 'base' => '<p>This specifies criteria to assign a set of resources, such as resource types or backup vaults.</p>', 'refs' => [ 'CreateLegalHoldInput$RecoveryPointSelection' => '<p>This specifies criteria to assign a set of resources, such as resource types or backup vaults.</p>', 'CreateLegalHoldOutput$RecoveryPointSelection' => '<p>This specifies criteria to assign a set of resources, such as resource types or backup vaults.</p>', 'GetLegalHoldOutput$RecoveryPointSelection' => '<p>This specifies criteria to assign a set of resources, such as resource types or backup vaults.</p>', ], ], 'RecoveryPointStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeRecoveryPointOutput$Status' => '<p>A status code specifying the state of the recovery point.</p> <p> <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window closed. To increase your backup plan window using the API, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html">UpdateBackupPlan</a>. You can also increase your backup plan window using the Console by choosing and editing your backup plan.</p> <p> <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups"> Step 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.</p> <p> <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes the continuous backup to be disabled. This can be caused by the removal of permissions, turning off versioning, turning off events being sent to EventBridge, or disabling the EventBridge rules that are put in place by Backup.</p> <p>To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that versioning is enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule running will result in a new continuous recovery point being created. The recovery points with STOPPED status do not need to be deleted.</p> <p>For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application misconfiguration, or backup failure. To ensure that future continuous backups succeed, refer to the recovery point status and check SAP HANA for details.</p>', 'RecoveryPointByBackupVault$Status' => '<p>A status code specifying the state of the recovery point.</p>', 'RecoveryPointByResource$Status' => '<p>A status code specifying the state of the recovery point.</p>', ], ], 'RecoveryPointsList' => [ 'base' => NULL, 'refs' => [ 'ListRecoveryPointsByLegalHoldOutput$RecoveryPoints' => '<p>This is a list of the recovery points returned by <code>ListRecoveryPointsByLegalHold</code>.</p>', ], ], 'Region' => [ 'base' => NULL, 'refs' => [ 'BackupJobSummary$Region' => '<p>The Amazon Web Services Regions within the job summary.</p>', 'CopyJobSummary$Region' => '<p>This is the Amazon Web Services Regions within the job summary.</p>', 'RestoreJobSummary$Region' => '<p>The Amazon Web Services Regions within the job summary.</p>', ], ], 'ReportDeliveryChannel' => [ 'base' => '<p>Contains information from your report plan about where to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>', 'refs' => [ 'CreateReportPlanInput$ReportDeliveryChannel' => '<p>A structure that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>', 'ReportPlan$ReportDeliveryChannel' => '<p>Contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>', 'UpdateReportPlanInput$ReportDeliveryChannel' => '<p>A structure that contains information about where to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.</p>', ], ], 'ReportDestination' => [ 'base' => '<p>Contains information from your report job about your report destination.</p>', 'refs' => [ 'ReportJob$ReportDestination' => '<p>The S3 bucket name and S3 keys for the destination where the report job publishes the report.</p>', ], ], 'ReportJob' => [ 'base' => '<p>Contains detailed information about a report job. A report job compiles a report based on a report plan and publishes it to Amazon S3.</p>', 'refs' => [ 'DescribeReportJobOutput$ReportJob' => '<p>A list of information about a report job, including its completion and creation times, report destination, unique report job ID, Amazon Resource Name (ARN), report template, status, and status message.</p>', 'ReportJobList$member' => NULL, ], ], 'ReportJobId' => [ 'base' => NULL, 'refs' => [ 'DescribeReportJobInput$ReportJobId' => '<p>The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most 1,024 bytes long. The report job ID cannot be edited.</p>', 'ReportJob$ReportJobId' => '<p>The identifier for a report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most 1,024 bytes long. Report job IDs cannot be edited.</p>', 'StartReportJobOutput$ReportJobId' => '<p>The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most 1,024 bytes long. The report job ID cannot be edited.</p>', ], ], 'ReportJobList' => [ 'base' => NULL, 'refs' => [ 'ListReportJobsOutput$ReportJobs' => '<p>Details about your report jobs in JSON format.</p>', ], ], 'ReportPlan' => [ 'base' => '<p>Contains detailed information about a report plan.</p>', 'refs' => [ 'DescribeReportPlanOutput$ReportPlan' => '<p>Returns details about the report plan that is specified by its name. These details include the report plan\'s Amazon Resource Name (ARN), description, settings, delivery channel, deployment status, creation time, and last attempted and successful run times.</p>', 'ReportPlanList$member' => NULL, ], ], 'ReportPlanDescription' => [ 'base' => NULL, 'refs' => [ 'CreateReportPlanInput$ReportPlanDescription' => '<p>An optional description of the report plan with a maximum of 1,024 characters.</p>', 'ReportPlan$ReportPlanDescription' => '<p>An optional description of the report plan with a maximum 1,024 characters.</p>', 'UpdateReportPlanInput$ReportPlanDescription' => '<p>An optional description of the report plan with a maximum 1,024 characters.</p>', ], ], 'ReportPlanList' => [ 'base' => NULL, 'refs' => [ 'ListReportPlansOutput$ReportPlans' => '<p>A list of your report plans with detailed information for each plan. This information includes the Amazon Resource Name (ARN), report plan name, description, settings, delivery channel, deployment status, creation time, and last times the report plan attempted to and successfully ran.</p>', ], ], 'ReportPlanName' => [ 'base' => NULL, 'refs' => [ 'CreateReportPlanInput$ReportPlanName' => '<p>The unique name of the report plan. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', 'CreateReportPlanOutput$ReportPlanName' => '<p>The unique name of the report plan.</p>', 'DeleteReportPlanInput$ReportPlanName' => '<p>The unique name of a report plan.</p>', 'DescribeReportPlanInput$ReportPlanName' => '<p>The unique name of a report plan.</p>', 'ListReportJobsInput$ByReportPlanName' => '<p>Returns only report jobs with the specified report plan name.</p>', 'ReportPlan$ReportPlanName' => '<p>The unique name of the report plan. This name is between 1 and 256 characters starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', 'StartReportJobInput$ReportPlanName' => '<p>The unique name of a report plan.</p>', 'UpdateReportPlanInput$ReportPlanName' => '<p>The unique name of the report plan. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).</p>', 'UpdateReportPlanOutput$ReportPlanName' => '<p>The unique name of the report plan.</p>', ], ], 'ReportSetting' => [ 'base' => '<p>Contains detailed information about a report setting.</p>', 'refs' => [ 'CreateReportPlanInput$ReportSetting' => '<p>Identifies the report template for the report. Reports are built using a report template. The report templates are:</p> <p> <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code> </p> <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report coverage by Amazon Web Services Regions and frameworks.</p>', 'ReportPlan$ReportSetting' => '<p>Identifies the report template for the report. Reports are built using a report template. The report templates are:</p> <p> <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code> </p> <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report coverage by Amazon Web Services Regions and frameworks.</p>', 'UpdateReportPlanInput$ReportSetting' => '<p>Identifies the report template for the report. Reports are built using a report template. The report templates are:</p> <p> <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code> </p> <p>If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report coverage by Amazon Web Services Regions and frameworks.</p>', ], ], 'ResourceArns' => [ 'base' => NULL, 'refs' => [ 'BackupSelection$Resources' => '<p>A list of Amazon Resource Names (ARNs) to assign to a backup plan. The maximum number of ARNs is 500 without wildcards, or 30 ARNs with wildcards.</p> <p>If you need to assign many resources to a backup plan, consider a different resource selection strategy, such as assigning all resources of a resource type or refining your resource selection using tags.</p>', 'BackupSelection$NotResources' => '<p>A list of Amazon Resource Names (ARNs) to exclude from a backup plan. The maximum number of ARNs is 500 without wildcards, or 30 ARNs with wildcards.</p> <p>If you need to exclude many resources from a backup plan, consider a different resource selection strategy, such as assigning only one or a few resource types or refining your resource selection using tags.</p>', ], ], 'ResourceIdentifiers' => [ 'base' => NULL, 'refs' => [ 'RecoveryPointSelection$ResourceIdentifiers' => '<p>These are the resources included in the resource selection (including type of resources and vaults).</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A resource that is required for the action doesn\'t exist.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'AdvancedBackupSetting$ResourceType' => '<p>Specifies an object containing resource type and backup options. The only supported resource type is Amazon EC2 instances with Windows Volume Shadow Copy Service (VSS). For a CloudFormation example, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/integrate-cloudformation-with-aws-backup.html">sample CloudFormation template to enable Windows VSS</a> in the <i>Backup User Guide</i>.</p> <p>Valid values: <code>EC2</code>.</p>', 'BackupJob$ResourceType' => '<p>The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.</p>', 'BackupJobSummary$ResourceType' => '<p>This value is the job count for the specified resource type. The request <code>GetSupportedResourceTypes</code> returns strings for supported resource types.</p>', 'CopyJob$ResourceType' => '<p>The type of Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>', 'CopyJobSummary$ResourceType' => '<p>This value is the job count for the specified resource type. The request <code>GetSupportedResourceTypes</code> returns strings for supported resource types</p>', 'DescribeBackupJobOutput$ResourceType' => '<p>The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>', 'DescribeProtectedResourceOutput$ResourceType' => '<p>The type of Amazon Web Services resource saved as a recovery point; for example, an Amazon EBS volume or an Amazon RDS database.</p>', 'DescribeRecoveryPointOutput$ResourceType' => '<p>The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>', 'DescribeRestoreJobOutput$ResourceType' => '<p>Returns metadata associated with a restore job listed by resource type.</p>', 'GetRecoveryPointRestoreMetadataOutput$ResourceType' => '<p>This is the resource type associated with the recovery point.</p>', 'ListBackupJobSummariesInput$ResourceType' => '<p>Returns the job count for the specified resource type. Use request <code>GetSupportedResourceTypes</code> to obtain strings for supported resource types.</p> <p>The the value ANY returns count of all resource types.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts for all resource types and returns the sum.</p> <p>The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>', 'ListBackupJobsInput$ByResourceType' => '<p>Returns only backup jobs for the specified resources:</p> <ul> <li> <p> <code>Aurora</code> for Amazon Aurora</p> </li> <li> <p> <code>CloudFormation</code> for CloudFormation</p> </li> <li> <p> <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)</p> </li> <li> <p> <code>DynamoDB</code> for Amazon DynamoDB</p> </li> <li> <p> <code>EBS</code> for Amazon Elastic Block Store</p> </li> <li> <p> <code>EC2</code> for Amazon Elastic Compute Cloud</p> </li> <li> <p> <code>EFS</code> for Amazon Elastic File System</p> </li> <li> <p> <code>FSx</code> for Amazon FSx</p> </li> <li> <p> <code>Neptune</code> for Amazon Neptune</p> </li> <li> <p> <code>Redshift</code> for Amazon Redshift</p> </li> <li> <p> <code>RDS</code> for Amazon Relational Database Service</p> </li> <li> <p> <code>SAP HANA on Amazon EC2</code> for SAP HANA databases</p> </li> <li> <p> <code>Storage Gateway</code> for Storage Gateway</p> </li> <li> <p> <code>S3</code> for Amazon S3</p> </li> <li> <p> <code>Timestream</code> for Amazon Timestream</p> </li> <li> <p> <code>VirtualMachine</code> for virtual machines</p> </li> </ul>', 'ListCopyJobSummariesInput$ResourceType' => '<p>Returns the job count for the specified resource type. Use request <code>GetSupportedResourceTypes</code> to obtain strings for supported resource types.</p> <p>The the value ANY returns count of all resource types.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts for all resource types and returns the sum.</p> <p>The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>', 'ListCopyJobsInput$ByResourceType' => '<p>Returns only backup jobs for the specified resources:</p> <ul> <li> <p> <code>Aurora</code> for Amazon Aurora</p> </li> <li> <p> <code>CloudFormation</code> for CloudFormation</p> </li> <li> <p> <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)</p> </li> <li> <p> <code>DynamoDB</code> for Amazon DynamoDB</p> </li> <li> <p> <code>EBS</code> for Amazon Elastic Block Store</p> </li> <li> <p> <code>EC2</code> for Amazon Elastic Compute Cloud</p> </li> <li> <p> <code>EFS</code> for Amazon Elastic File System</p> </li> <li> <p> <code>FSx</code> for Amazon FSx</p> </li> <li> <p> <code>Neptune</code> for Amazon Neptune</p> </li> <li> <p> <code>Redshift</code> for Amazon Redshift</p> </li> <li> <p> <code>RDS</code> for Amazon Relational Database Service</p> </li> <li> <p> <code>SAP HANA on Amazon EC2</code> for SAP HANA databases</p> </li> <li> <p> <code>Storage Gateway</code> for Storage Gateway</p> </li> <li> <p> <code>S3</code> for Amazon S3</p> </li> <li> <p> <code>Timestream</code> for Amazon Timestream</p> </li> <li> <p> <code>VirtualMachine</code> for virtual machines</p> </li> </ul>', 'ListRecoveryPointsByBackupVaultInput$ByResourceType' => '<p>Returns only recovery points that match the specified resource type(s):</p> <ul> <li> <p> <code>Aurora</code> for Amazon Aurora</p> </li> <li> <p> <code>CloudFormation</code> for CloudFormation</p> </li> <li> <p> <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)</p> </li> <li> <p> <code>DynamoDB</code> for Amazon DynamoDB</p> </li> <li> <p> <code>EBS</code> for Amazon Elastic Block Store</p> </li> <li> <p> <code>EC2</code> for Amazon Elastic Compute Cloud</p> </li> <li> <p> <code>EFS</code> for Amazon Elastic File System</p> </li> <li> <p> <code>FSx</code> for Amazon FSx</p> </li> <li> <p> <code>Neptune</code> for Amazon Neptune</p> </li> <li> <p> <code>Redshift</code> for Amazon Redshift</p> </li> <li> <p> <code>RDS</code> for Amazon Relational Database Service</p> </li> <li> <p> <code>SAP HANA on Amazon EC2</code> for SAP HANA databases</p> </li> <li> <p> <code>Storage Gateway</code> for Storage Gateway</p> </li> <li> <p> <code>S3</code> for Amazon S3</p> </li> <li> <p> <code>Timestream</code> for Amazon Timestream</p> </li> <li> <p> <code>VirtualMachine</code> for virtual machines</p> </li> </ul>', 'ListRestoreJobSummariesInput$ResourceType' => '<p>Returns the job count for the specified resource type. Use request <code>GetSupportedResourceTypes</code> to obtain strings for supported resource types.</p> <p>The the value ANY returns count of all resource types.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts for all resource types and returns the sum.</p> <p>The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.</p>', 'ListRestoreJobsInput$ByResourceType' => '<p>Include this parameter to return only restore jobs for the specified resources:</p> <ul> <li> <p> <code>Aurora</code> for Amazon Aurora</p> </li> <li> <p> <code>CloudFormation</code> for CloudFormation</p> </li> <li> <p> <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)</p> </li> <li> <p> <code>DynamoDB</code> for Amazon DynamoDB</p> </li> <li> <p> <code>EBS</code> for Amazon Elastic Block Store</p> </li> <li> <p> <code>EC2</code> for Amazon Elastic Compute Cloud</p> </li> <li> <p> <code>EFS</code> for Amazon Elastic File System</p> </li> <li> <p> <code>FSx</code> for Amazon FSx</p> </li> <li> <p> <code>Neptune</code> for Amazon Neptune</p> </li> <li> <p> <code>Redshift</code> for Amazon Redshift</p> </li> <li> <p> <code>RDS</code> for Amazon Relational Database Service</p> </li> <li> <p> <code>SAP HANA on Amazon EC2</code> for SAP HANA databases</p> </li> <li> <p> <code>Storage Gateway</code> for Storage Gateway</p> </li> <li> <p> <code>S3</code> for Amazon S3</p> </li> <li> <p> <code>Timestream</code> for Amazon Timestream</p> </li> <li> <p> <code>VirtualMachine</code> for virtual machines</p> </li> </ul>', 'ProtectedResource$ResourceType' => '<p>The type of Amazon Web Services resource; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.</p>', 'RecoveryPointByBackupVault$ResourceType' => '<p>The type of Amazon Web Services resource saved as a recovery point; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.</p>', 'RecoveryPointMember$ResourceType' => '<p>This is the Amazon Web Services resource type that is saved as a recovery point.</p>', 'ResourceTypeManagementPreference$key' => NULL, 'ResourceTypeOptInPreference$key' => NULL, 'ResourceTypes$member' => NULL, 'RestoreJobSummary$ResourceType' => '<p>This value is the job count for the specified resource type. The request <code>GetSupportedResourceTypes</code> returns strings for supported resource types.</p>', 'RestoreJobsListMember$ResourceType' => '<p>The resource type of the listed restore jobs; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only supported resource type is Amazon EC2.</p>', 'StartRestoreJobInput$ResourceType' => '<p>Starts a job to restore a recovery point for one of the following resources:</p> <ul> <li> <p> <code>Aurora</code> for Amazon Aurora</p> </li> <li> <p> <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)</p> </li> <li> <p> <code>CloudFormation</code> for CloudFormation</p> </li> <li> <p> <code>DynamoDB</code> for Amazon DynamoDB</p> </li> <li> <p> <code>EBS</code> for Amazon Elastic Block Store</p> </li> <li> <p> <code>EC2</code> for Amazon Elastic Compute Cloud</p> </li> <li> <p> <code>EFS</code> for Amazon Elastic File System</p> </li> <li> <p> <code>FSx</code> for Amazon FSx</p> </li> <li> <p> <code>Neptune</code> for Amazon Neptune</p> </li> <li> <p> <code>RDS</code> for Amazon Relational Database Service</p> </li> <li> <p> <code>Redshift</code> for Amazon Redshift</p> </li> <li> <p> <code>Storage Gateway</code> for Storage Gateway</p> </li> <li> <p> <code>S3</code> for Amazon S3</p> </li> <li> <p> <code>Timestream</code> for Amazon Timestream</p> </li> <li> <p> <code>VirtualMachine</code> for virtual machines</p> </li> </ul>', ], ], 'ResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'ControlScope$ComplianceResourceTypes' => '<p>Describes whether the control scope includes one or more types of resources, such as <code>EFS</code> or <code>RDS</code>.</p>', ], ], 'ResourceTypeManagementPreference' => [ 'base' => NULL, 'refs' => [ 'DescribeRegionSettingsOutput$ResourceTypeManagementPreference' => '<p>Returns whether Backup fully manages the backups for a resource type.</p> <p>For the benefits of full Backup management, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#full-management"> Full Backup management</a>.</p> <p>For a list of resource types and whether each supports full Backup management, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature availability by resource</a> table.</p> <p>If <code>"DynamoDB":false</code>, you can enable full Backup management for DynamoDB backup by enabling <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html#advanced-ddb-backup-enable-cli"> Backup\'s advanced DynamoDB backup features</a>.</p>', 'UpdateRegionSettingsInput$ResourceTypeManagementPreference' => '<p>Enables or disables full Backup management of backups for a resource type. To enable full Backup management for DynamoDB along with <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html"> Backup\'s advanced DynamoDB backup features</a>, follow the procedure to <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html#advanced-ddb-backup-enable-cli"> enable advanced DynamoDB backup programmatically</a>.</p>', ], ], 'ResourceTypeOptInPreference' => [ 'base' => NULL, 'refs' => [ 'DescribeRegionSettingsOutput$ResourceTypeOptInPreference' => '<p>Returns a list of all services along with the opt-in preferences in the Region.</p>', 'UpdateRegionSettingsInput$ResourceTypeOptInPreference' => '<p>Updates the list of services along with the opt-in preferences for the Region.</p> <p>If resource assignments are only based on tags, then service opt-in settings are applied. If a resource type is explicitly assigned to a backup plan, such as Amazon S3, Amazon EC2, or Amazon RDS, it will be included in the backup even if the opt-in is not enabled for that particular service. If both a resource type and tags are specified in a resource assignment, the resource type specified in the backup plan takes priority over the tag condition. Service opt-in settings are disregarded in this situation.</p>', ], ], 'ResourceTypes' => [ 'base' => NULL, 'refs' => [ 'GetSupportedResourceTypesOutput$ResourceTypes' => '<p>Contains a string with the supported Amazon Web Services resource types:</p> <ul> <li> <p> <code>Aurora</code> for Amazon Aurora</p> </li> <li> <p> <code>DynamoDB</code> for Amazon DynamoDB</p> </li> <li> <p> <code>EBS</code> for Amazon Elastic Block Store</p> </li> <li> <p> <code>EC2</code> for Amazon Elastic Compute Cloud</p> </li> <li> <p> <code>EFS</code> for Amazon Elastic File System</p> </li> <li> <p> <code>FSX</code> for Amazon FSx</p> </li> <li> <p> <code>RDS</code> for Amazon Relational Database Service</p> </li> <li> <p> <code>Storage Gateway</code> for Storage Gateway</p> </li> <li> <p> <code>DocDB</code> for Amazon DocumentDB (with MongoDB compatibility)</p> </li> <li> <p> <code>Neptune</code> for Amazon Neptune</p> </li> </ul>', ], ], 'RestoreDeletionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeRestoreJobOutput$DeletionStatus' => '<p>This notes the status of the data generated by the restore test. The status may be <code>Deleting</code>, <code>Failed</code>, or <code>Successful</code>.</p>', 'RestoreJobsListMember$DeletionStatus' => '<p>This notes the status of the data generated by the restore test. The status may be <code>Deleting</code>, <code>Failed</code>, or <code>Successful</code>.</p>', ], ], 'RestoreJobCreator' => [ 'base' => '<p>Contains information about the restore testing plan that Backup used to initiate the restore job.</p>', 'refs' => [ 'DescribeRestoreJobOutput$CreatedBy' => '<p>Contains identifying information about the creation of a restore job.</p>', 'RestoreJobsListMember$CreatedBy' => '<p>Contains identifying information about the creation of a restore job.</p>', ], ], 'RestoreJobId' => [ 'base' => NULL, 'refs' => [ 'DescribeRestoreJobInput$RestoreJobId' => '<p>Uniquely identifies the job that restores a recovery point.</p>', 'GetRestoreJobMetadataInput$RestoreJobId' => '<p>This is a unique identifier of a restore job within Backup.</p>', 'GetRestoreJobMetadataOutput$RestoreJobId' => '<p>This is a unique identifier of a restore job within Backup.</p>', 'PutRestoreValidationResultInput$RestoreJobId' => '<p>This is a unique identifier of a restore job within Backup.</p>', 'StartRestoreJobOutput$RestoreJobId' => '<p>Uniquely identifies the job that restores a recovery point.</p>', ], ], 'RestoreJobState' => [ 'base' => NULL, 'refs' => [ 'ListRestoreJobSummariesInput$State' => '<p>This parameter returns the job count for jobs with the specified state.</p> <p>The the value ANY returns count of all states.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts for all states and returns the sum.</p>', 'RestoreJobSummary$State' => '<p>This value is job count for jobs with the specified state.</p>', ], ], 'RestoreJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeRestoreJobOutput$Status' => '<p>Status code specifying the state of the job that is initiated by Backup to restore a recovery point.</p>', 'ListRestoreJobsByProtectedResourceInput$ByStatus' => '<p>Returns only restore jobs associated with the specified job status.</p>', 'ListRestoreJobsInput$ByStatus' => '<p>Returns only restore jobs associated with the specified job status.</p>', 'RestoreJobsListMember$Status' => '<p>A status code specifying the state of the job initiated by Backup to restore a recovery point.</p>', ], ], 'RestoreJobSummary' => [ 'base' => '<p>This is a summary of restore jobs created or running within the most recent 30 days.</p> <p>The returned summary may contain the following: Region, Account, State, ResourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.</p>', 'refs' => [ 'RestoreJobSummaryList$member' => NULL, ], ], 'RestoreJobSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListRestoreJobSummariesOutput$RestoreJobSummaries' => '<p>This return contains a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.</p>', ], ], 'RestoreJobsList' => [ 'base' => NULL, 'refs' => [ 'ListRestoreJobsByProtectedResourceOutput$RestoreJobs' => '<p>An array of objects that contain detailed information about jobs to restore saved resources.&gt;</p>', 'ListRestoreJobsOutput$RestoreJobs' => '<p>An array of objects that contain detailed information about jobs to restore saved resources.</p>', ], ], 'RestoreJobsListMember' => [ 'base' => '<p>Contains metadata about a restore job.</p>', 'refs' => [ 'RestoreJobsList$member' => NULL, ], ], 'RestoreTestingPlanForCreate' => [ 'base' => '<p>This contains metadata about a restore testing plan.</p>', 'refs' => [ 'CreateRestoreTestingPlanInput$RestoreTestingPlan' => '<p>A restore testing plan must contain a unique <code>RestoreTestingPlanName</code> string you create and must contain a <code>ScheduleExpression</code> cron. You may optionally include a <code>StartWindowHours</code> integer and a <code>CreatorRequestId</code> string.</p> <p>The <code>RestoreTestingPlanName</code> is a unique string that is the name of the restore testing plan. This cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.</p>', ], ], 'RestoreTestingPlanForGet' => [ 'base' => '<p>This contains metadata about a restore testing plan.</p>', 'refs' => [ 'GetRestoreTestingPlanOutput$RestoreTestingPlan' => '<p>Specifies the body of a restore testing plan. Includes <code>RestoreTestingPlanName</code>.</p>', ], ], 'RestoreTestingPlanForList' => [ 'base' => '<p>This contains metadata about a restore testing plan.</p>', 'refs' => [ 'RestoreTestingPlans$member' => NULL, ], ], 'RestoreTestingPlanForUpdate' => [ 'base' => '<p>This contains metadata about a restore testing plan.</p>', 'refs' => [ 'UpdateRestoreTestingPlanInput$RestoreTestingPlan' => '<p>Specifies the body of a restore testing plan.</p>', ], ], 'RestoreTestingPlans' => [ 'base' => NULL, 'refs' => [ 'ListRestoreTestingPlansOutput$RestoreTestingPlans' => '<p>This is a returned list of restore testing plans.</p>', ], ], 'RestoreTestingRecoveryPointSelection' => [ 'base' => '<p>Required: Algorithm; Required: Recovery point types; IncludeVaults(one or more). Optional: SelectionWindowDays (\'30\' if not specified);ExcludeVaults (list of selectors), defaults to empty list if not listed.</p>', 'refs' => [ 'RestoreTestingPlanForCreate$RecoveryPointSelection' => '<p>Required: Algorithm; Required: Recovery point types; IncludeVaults (one or more). Optional: SelectionWindowDays (\'30\' if not specified); ExcludeVaults (list of selectors), defaults to empty list if not listed.</p>', 'RestoreTestingPlanForGet$RecoveryPointSelection' => '<p>The specified criteria to assign a set of resources, such as recovery point types or backup vaults.</p>', 'RestoreTestingPlanForUpdate$RecoveryPointSelection' => '<p>Required: <code>Algorithm</code>; <code>RecoveryPointTypes</code>; <code>IncludeVaults</code> (<i>one or more</i>).</p> <p>Optional: <i>SelectionWindowDays</i> (<i>\'30\' if not specified</i>); <code>ExcludeVaults</code> (defaults to empty list if not listed).</p>', ], ], 'RestoreTestingRecoveryPointSelectionAlgorithm' => [ 'base' => NULL, 'refs' => [ 'RestoreTestingRecoveryPointSelection$Algorithm' => '<p>Acceptable values include "LATEST_WITHIN_WINDOW" or "RANDOM_WITHIN_WINDOW"</p>', ], ], 'RestoreTestingRecoveryPointType' => [ 'base' => NULL, 'refs' => [ 'RestoreTestingRecoveryPointTypeList$member' => NULL, ], ], 'RestoreTestingRecoveryPointTypeList' => [ 'base' => NULL, 'refs' => [ 'RestoreTestingRecoveryPointSelection$RecoveryPointTypes' => '<p>These are the types of recovery points.</p>', ], ], 'RestoreTestingSelectionForCreate' => [ 'base' => '<p>This contains metadata about a specific restore testing selection.</p> <p>ProtectedResourceType is required, such as Amazon EBS or Amazon EC2.</p> <p>This consists of <code>RestoreTestingSelectionName</code>, <code>ProtectedResourceType</code>, and one of the following:</p> <ul> <li> <p> <code>ProtectedResourceArns</code> </p> </li> <li> <p> <code>ProtectedResourceConditions</code> </p> </li> </ul> <p>Each protected resource type can have one single value.</p> <p>A restore testing selection can include a wildcard value ("*") for <code>ProtectedResourceArns</code> along with <code>ProtectedResourceConditions</code>. Alternatively, you can include up to 30 specific protected resource ARNs in <code>ProtectedResourceArns</code>.</p> <p> <code>ProtectedResourceConditions</code> examples include as <code>StringEquals</code> and <code>StringNotEquals</code>.</p>', 'refs' => [ 'CreateRestoreTestingSelectionInput$RestoreTestingSelection' => '<p>This consists of <code>RestoreTestingSelectionName</code>, <code>ProtectedResourceType</code>, and one of the following:</p> <ul> <li> <p> <code>ProtectedResourceArns</code> </p> </li> <li> <p> <code>ProtectedResourceConditions</code> </p> </li> </ul> <p>Each protected resource type can have one single value.</p> <p>A restore testing selection can include a wildcard value ("*") for <code>ProtectedResourceArns</code> along with <code>ProtectedResourceConditions</code>. Alternatively, you can include up to 30 specific protected resource ARNs in <code>ProtectedResourceArns</code>.</p>', ], ], 'RestoreTestingSelectionForGet' => [ 'base' => '<p>This contains metadata about a restore testing selection.</p>', 'refs' => [ 'GetRestoreTestingSelectionOutput$RestoreTestingSelection' => '<p>Unique name of the restore testing selection.</p>', ], ], 'RestoreTestingSelectionForList' => [ 'base' => '<p>This contains metadata about a restore testing selection.</p>', 'refs' => [ 'RestoreTestingSelections$member' => NULL, ], ], 'RestoreTestingSelectionForUpdate' => [ 'base' => '<p>This contains metadata about a restore testing selection.</p>', 'refs' => [ 'UpdateRestoreTestingSelectionInput$RestoreTestingSelection' => '<p>To update your restore testing selection, you can use either protected resource ARNs or conditions, but not both. That is, if your selection has <code>ProtectedResourceArns</code>, requesting an update with the parameter <code>ProtectedResourceConditions</code> will be unsuccessful.</p>', ], ], 'RestoreTestingSelections' => [ 'base' => NULL, 'refs' => [ 'ListRestoreTestingSelectionsOutput$RestoreTestingSelections' => '<p>The returned restore testing selections associated with the restore testing plan.</p>', ], ], 'RestoreValidationStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeRestoreJobOutput$ValidationStatus' => '<p>This is the status of validation run on the indicated restore job.</p>', 'PutRestoreValidationResultInput$ValidationStatus' => '<p>This is the status of your restore validation.</p>', 'RestoreJobsListMember$ValidationStatus' => '<p>This is the status of validation run on the indicated restore job.</p>', ], ], 'SensitiveStringMap' => [ 'base' => NULL, 'refs' => [ 'CreateRestoreTestingPlanInput$Tags' => '<p>Optional tags to include. A tag is a key-value pair you can use to manage, filter, and search for your resources. Allowed characters include UTF-8 letters,numbers, spaces, and the following characters: + - = . _ : /.</p>', 'RestoreTestingSelectionForCreate$RestoreMetadataOverrides' => '<p>You can override certain restore metadata keys by including the parameter <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code>. Key values are not case sensitive.</p> <p>See the complete list of <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html">restore testing inferred metadata</a>.</p>', 'RestoreTestingSelectionForGet$RestoreMetadataOverrides' => '<p>You can override certain restore metadata keys by including the parameter <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code>. Key values are not case sensitive.</p> <p>See the complete list of <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html">restore testing inferred metadata</a>.</p>', 'RestoreTestingSelectionForUpdate$RestoreMetadataOverrides' => '<p>You can override certain restore metadata keys by including the parameter <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code>. Key values are not case sensitive.</p> <p>See the complete list of <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html">restore testing inferred metadata</a>.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The request failed due to a temporary failure of the server.</p>', 'refs' => [], ], 'StartBackupJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartBackupJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartCopyJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartCopyJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartReportJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartReportJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartRestoreJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartRestoreJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StopBackupJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StorageClass' => [ 'base' => NULL, 'refs' => [ 'DescribeRecoveryPointOutput$StorageClass' => '<p>Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'CreateRestoreTestingPlanInput$CreatorRequestId' => '<p>This is a unique string that identifies the request and allows failed requests to be retriedwithout the risk of running the operation twice. This parameter is optional. If used, this parameter must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'CreateRestoreTestingPlanOutput$RestoreTestingPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies the created restore testing plan.</p>', 'CreateRestoreTestingPlanOutput$RestoreTestingPlanName' => '<p>This unique string is the name of the restore testing plan.</p> <p>The name cannot be changed after creation. The name consists of only alphanumeric characters and underscores. Maximum length is 50.</p>', 'CreateRestoreTestingSelectionInput$CreatorRequestId' => '<p>This is an optional unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. If used, this parameter must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'CreateRestoreTestingSelectionInput$RestoreTestingPlanName' => '<p>Input the restore testing plan name that was returned from the related CreateRestoreTestingPlan request.</p>', 'CreateRestoreTestingSelectionOutput$RestoreTestingPlanArn' => '<p>This is the ARN of the restore testing plan with which the restore testing selection is associated.</p>', 'CreateRestoreTestingSelectionOutput$RestoreTestingPlanName' => '<p>Unique string that is the name of the restore testing plan.</p> <p>The name cannot be changed after creation. The name consists of only alphanumeric characters and underscores. Maximum length is 50.</p>', 'CreateRestoreTestingSelectionOutput$RestoreTestingSelectionName' => '<p>This is the unique name of the restore testing selection that belongs to the related restore testing plan.</p>', 'DeleteRestoreTestingPlanInput$RestoreTestingPlanName' => '<p>Required unique name of the restore testing plan you wish to delete.</p>', 'DeleteRestoreTestingSelectionInput$RestoreTestingPlanName' => '<p>Required unique name of the restore testing plan that contains the restore testing selection you wish to delete.</p>', 'DeleteRestoreTestingSelectionInput$RestoreTestingSelectionName' => '<p>Required unique name of the restore testing selection you wish to delete.</p>', 'GetRestoreTestingInferredMetadataInput$BackupVaultAccountId' => '<p>This is the account ID of the specified backup vault.</p>', 'GetRestoreTestingInferredMetadataInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web ServicesRegion where they are created. They consist of letters, numbers, and hyphens.</p>', 'GetRestoreTestingInferredMetadataInput$RecoveryPointArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>. </p>', 'GetRestoreTestingPlanInput$RestoreTestingPlanName' => '<p>Required unique name of the restore testing plan.</p>', 'GetRestoreTestingSelectionInput$RestoreTestingPlanName' => '<p>Required unique name of the restore testing plan.</p>', 'GetRestoreTestingSelectionInput$RestoreTestingSelectionName' => '<p>Required unique name of the restore testing selection.</p>', 'KeyValue$Key' => '<p>The tag key (String). The key can\'t start with <code>aws:</code>.</p> <p>Length Constraints: Minimum length of 1. Maximum length of 128.</p> <p>Pattern: <code>^(?![aA]{1}[wW]{1}[sS]{1}:)([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]+)$</code> </p>', 'KeyValue$Value' => '<p>The value of the key.</p> <p>Length Constraints: Maximum length of 256.</p> <p>Pattern: <code>^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$</code> </p>', 'ListRestoreTestingPlansInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the nexttoken.</p>', 'ListRestoreTestingPlansOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the nexttoken.</p>', 'ListRestoreTestingSelectionsInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the nexttoken.</p>', 'ListRestoreTestingSelectionsInput$RestoreTestingPlanName' => '<p>Returns restore testing selections by the specified restore testing plan name.</p>', 'ListRestoreTestingSelectionsOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the nexttoken.</p>', 'RestoreTestingPlanForCreate$RestoreTestingPlanName' => '<p>The RestoreTestingPlanName is a unique string that is the name of the restore testing plan. This cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.</p>', 'RestoreTestingPlanForCreate$ScheduleExpression' => '<p>A CRON expression in specified timezone when a restore testing plan is executed.</p>', 'RestoreTestingPlanForCreate$ScheduleExpressionTimezone' => '<p>Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.</p>', 'RestoreTestingPlanForGet$CreatorRequestId' => '<p>This identifies the request and allows failed requests to be retried without the risk of running the operation twice. If the request includes a <code>CreatorRequestId</code> that matches an existing backup plan, that plan is returned. This parameter is optional.</p> <p>If used, this parameter must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'RestoreTestingPlanForGet$RestoreTestingPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a restore testing plan.</p>', 'RestoreTestingPlanForGet$RestoreTestingPlanName' => '<p>This is the restore testing plan name.</p>', 'RestoreTestingPlanForGet$ScheduleExpression' => '<p>A CRON expression in specified timezone when a restore testing plan is executed.</p>', 'RestoreTestingPlanForGet$ScheduleExpressionTimezone' => '<p>Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.</p>', 'RestoreTestingPlanForList$RestoreTestingPlanArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifiesa restore testing plan.</p>', 'RestoreTestingPlanForList$RestoreTestingPlanName' => '<p>This is the restore testing plan name.</p>', 'RestoreTestingPlanForList$ScheduleExpression' => '<p>A CRON expression in specified timezone when a restore testing plan is executed.</p>', 'RestoreTestingPlanForList$ScheduleExpressionTimezone' => '<p>Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.</p>', 'RestoreTestingPlanForUpdate$ScheduleExpression' => '<p>A CRON expression in specified timezone when a restore testing plan is executed.</p>', 'RestoreTestingPlanForUpdate$ScheduleExpressionTimezone' => '<p>Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.</p>', 'RestoreTestingSelectionForCreate$IamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example: <code>arn:aws:iam::123456789012:role/S3Access</code>. </p>', 'RestoreTestingSelectionForCreate$ProtectedResourceType' => '<p>The type of Amazon Web Services resource included in a restore testing selection; for example, an Amazon EBS volume or an Amazon RDS database.</p> <p>Supported resource types accepted include:</p> <ul> <li> <p> <code>Aurora</code> for Amazon Aurora</p> </li> <li> <p> <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)</p> </li> <li> <p> <code>DynamoDB</code> for Amazon DynamoDB</p> </li> <li> <p> <code>EBS</code> for Amazon Elastic Block Store</p> </li> <li> <p> <code>EC2</code> for Amazon Elastic Compute Cloud</p> </li> <li> <p> <code>EFS</code> for Amazon Elastic File System</p> </li> <li> <p> <code>FSx</code> for Amazon FSx</p> </li> <li> <p> <code>Neptune</code> for Amazon Neptune</p> </li> <li> <p> <code>RDS</code> for Amazon Relational Database Service</p> </li> <li> <p> <code>S3</code> for Amazon S3</p> </li> </ul>', 'RestoreTestingSelectionForCreate$RestoreTestingSelectionName' => '<p>This is the unique name of the restore testing selection that belongs to the related restore testing plan.</p>', 'RestoreTestingSelectionForGet$CreatorRequestId' => '<p>This identifies the request and allows failed requests to be retried without the risk of running the operation twice. If the request includes a <code>CreatorRequestId</code> that matches an existing backup plan, that plan is returned. This parameter is optional.</p> <p>If used, this parameter must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'RestoreTestingSelectionForGet$IamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example:<code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'RestoreTestingSelectionForGet$ProtectedResourceType' => '<p>The type of Amazon Web Services resource included in a resource testing selection; for example, an Amazon EBS volume or an Amazon RDS database.</p>', 'RestoreTestingSelectionForGet$RestoreTestingPlanName' => '<p>The RestoreTestingPlanName is a unique string that is the name of the restore testing plan.</p>', 'RestoreTestingSelectionForGet$RestoreTestingSelectionName' => '<p>This is the unique name of the restore testing selection that belongs to the related restore testing plan.</p>', 'RestoreTestingSelectionForList$IamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example: <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'RestoreTestingSelectionForList$ProtectedResourceType' => '<p>The type of Amazon Web Services resource included in a restore testing selection; for example, an Amazon EBS volume or an Amazon RDS database.</p>', 'RestoreTestingSelectionForList$RestoreTestingPlanName' => '<p>Unique string that is the name of the restore testing plan.</p> <p>The name cannot be changed after creation. The name must consist of only alphanumeric characters and underscores. Maximum length is 50.</p>', 'RestoreTestingSelectionForList$RestoreTestingSelectionName' => '<p>Unique name of a restore testing selection.</p>', 'RestoreTestingSelectionForUpdate$IamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example: <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>', 'SensitiveStringMap$key' => NULL, 'SensitiveStringMap$value' => NULL, 'UpdateRestoreTestingPlanInput$RestoreTestingPlanName' => '<p>This is the restore testing plan name you wish to update.</p>', 'UpdateRestoreTestingPlanOutput$RestoreTestingPlanArn' => '<p>Unique ARN (Amazon Resource Name) of the restore testing plan.</p>', 'UpdateRestoreTestingPlanOutput$RestoreTestingPlanName' => '<p>The name cannot be changed after creation. The name consists of only alphanumeric characters and underscores. Maximum length is 50.</p>', 'UpdateRestoreTestingSelectionInput$RestoreTestingPlanName' => '<p>The restore testing plan name is required to update the indicated testing plan.</p>', 'UpdateRestoreTestingSelectionInput$RestoreTestingSelectionName' => '<p>This is the required restore testing selection name of the restore testing selection you wish to update.</p>', 'UpdateRestoreTestingSelectionOutput$RestoreTestingPlanArn' => '<p>Unique string that is the name of the restore testing plan.</p>', 'UpdateRestoreTestingSelectionOutput$RestoreTestingPlanName' => '<p>This is the restore testing plan with which the updated restore testing selection is associated.</p>', 'UpdateRestoreTestingSelectionOutput$RestoreTestingSelectionName' => '<p>This is the returned restore testing selection name.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeyList' => '<p>A list of keys to identify which key-value tags to remove from a resource.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'BackupRule$RecoveryPointTags' => '<p>An array of key-value pair strings that are assigned to resources that are associated with this rule when restored from backup.</p>', 'BackupRuleInput$RecoveryPointTags' => '<p>To help organize your resources, you can assign your own metadata to the resources that you create. Each tag is a key-value pair.</p>', 'CreateBackupPlanInput$BackupPlanTags' => '<p>To help organize your resources, you can assign your own metadata to the resources that you create. Each tag is a key-value pair. The specified tags are assigned to all backups created with this plan.</p>', 'CreateBackupVaultInput$BackupVaultTags' => '<p>Metadata that you can assign to help organize the resources that you create. Each tag is a key-value pair.</p>', 'CreateLegalHoldInput$Tags' => '<p>Optional tags to include. A tag is a key-value pair you can use to manage, filter, and search for your resources. Allowed characters include UTF-8 letters, numbers, spaces, and the following characters: + - = . _ : /. </p>', 'CreateLogicallyAirGappedBackupVaultInput$BackupVaultTags' => '<p>These are the tags that will be included in the newly-created vault.</p>', 'ListTagsOutput$Tags' => '<p>To help organize your resources, you can assign your own metadata to the resources you create. Each tag is a key-value pair.</p>', 'StartBackupJobInput$RecoveryPointTags' => '<p>To help organize your resources, you can assign your own metadata to the resources that you create. Each tag is a key-value pair.</p>', 'TagResourceInput$Tags' => '<p>Key-value pairs that are used to help organize your resources. You can assign your own metadata to the resources you create. For clarity, this is the structure to assign tags: <code>[{"Key":"string","Value":"string"}]</code>.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CreateRestoreTestingPlanOutput$CreationTime' => '<p>The date and time a restore testing plan was created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087AM.</p>', 'CreateRestoreTestingSelectionOutput$CreationTime' => '<p>This is the time the resource testing selection was created successfully.</p>', 'RestoreTestingPlanForGet$CreationTime' => '<p>The date and time that a restore testing plan was created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RestoreTestingPlanForGet$LastExecutionTime' => '<p>The last time a restore test was run with the specified restore testing plan. A date and time, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RestoreTestingPlanForGet$LastUpdateTime' => '<p>The date and time that the restore testing plan was updated. This update is in Unix format and Coordinated Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RestoreTestingPlanForList$CreationTime' => '<p>The date and time that a restore testing plan was created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RestoreTestingPlanForList$LastExecutionTime' => '<p>The last time a restore test was run with the specified restore testing plan. A date and time, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RestoreTestingPlanForList$LastUpdateTime' => '<p>The date and time that the restore testing plan was updated. This update is in Unix format and Coordinated Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RestoreTestingSelectionForGet$CreationTime' => '<p>The date and time that a restore testing selection was created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 201812:11:30.087 AM.</p>', 'RestoreTestingSelectionForList$CreationTime' => '<p>This is the date and time that a restore testing selection was created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26,2018 12:11:30.087 AM.</p>', 'UpdateRestoreTestingPlanOutput$CreationTime' => '<p>This is the time the resource testing plan was created.</p>', 'UpdateRestoreTestingPlanOutput$UpdateTime' => '<p>This is the time the update completed for the restore testing plan.</p>', 'UpdateRestoreTestingSelectionOutput$CreationTime' => '<p>This is the time the resource testing selection was updated successfully.</p>', 'UpdateRestoreTestingSelectionOutput$UpdateTime' => '<p>This is the time the update completed for the restore testing selection.</p>', ], ], 'Timezone' => [ 'base' => NULL, 'refs' => [ 'BackupRule$ScheduleExpressionTimezone' => '<p>This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.</p>', 'BackupRuleInput$ScheduleExpressionTimezone' => '<p>This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBackupPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBackupPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFrameworkInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFrameworkOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGlobalSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRecoveryPointLifecycleInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRecoveryPointLifecycleOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRegionSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReportPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReportPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRestoreTestingPlanInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRestoreTestingPlanOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRestoreTestingSelectionInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRestoreTestingSelectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'VaultNames' => [ 'base' => NULL, 'refs' => [ 'RecoveryPointSelection$VaultNames' => '<p>These are the names of the vaults in which the selected recovery points are contained.</p>', ], ], 'VaultState' => [ 'base' => NULL, 'refs' => [ 'CreateLogicallyAirGappedBackupVaultOutput$VaultState' => '<p>This is the current state of the vault.</p>', ], ], 'VaultType' => [ 'base' => NULL, 'refs' => [ 'DescribeBackupVaultOutput$VaultType' => '<p>This is the type of vault described.</p>', 'DescribeRecoveryPointOutput$VaultType' => '<p>This is the type of vault in which the described recovery point is stored.</p>', 'ListBackupVaultsInput$ByVaultType' => '<p>This parameter will sort the list of vaults by vault type.</p>', 'RecoveryPointByBackupVault$VaultType' => '<p>This is the type of vault in which the described recovery point is stored.</p>', 'RecoveryPointByResource$VaultType' => '<p>This is the type of vault in which the described recovery point is stored.</p>', ], ], 'WindowMinutes' => [ 'base' => NULL, 'refs' => [ 'BackupRule$StartWindowMinutes' => '<p>A value in minutes after a backup is scheduled before a job will be canceled if it doesn\'t start successfully. This value is optional. If this value is included, it must be at least 60 minutes to avoid errors.</p> <p>During the start window, the backup job status remains in <code>CREATED</code> status until it has successfully begun or until the start window time has run out. If within the start window time Backup receives an error that allows the job to be retried, Backup will automatically retry to begin the job at least every 10 minutes until the backup successfully begins (the job status changes to <code>RUNNING</code>) or until the job status changes to <code>EXPIRED</code> (which is expected to occur when the start window time is over).</p>', 'BackupRule$CompletionWindowMinutes' => '<p>A value in minutes after a backup job is successfully started before it must be completed or it will be canceled by Backup. This value is optional.</p>', 'BackupRuleInput$StartWindowMinutes' => '<p>A value in minutes after a backup is scheduled before a job will be canceled if it doesn\'t start successfully. This value is optional. If this value is included, it must be at least 60 minutes to avoid errors.</p> <p>This parameter has a maximum value of 100 years (52,560,000 minutes).</p> <p>During the start window, the backup job status remains in <code>CREATED</code> status until it has successfully begun or until the start window time has run out. If within the start window time Backup receives an error that allows the job to be retried, Backup will automatically retry to begin the job at least every 10 minutes until the backup successfully begins (the job status changes to <code>RUNNING</code>) or until the job status changes to <code>EXPIRED</code> (which is expected to occur when the start window time is over).</p>', 'BackupRuleInput$CompletionWindowMinutes' => '<p>A value in minutes after a backup job is successfully started before it must be completed or it will be canceled by Backup. This value is optional.</p>', 'StartBackupJobInput$StartWindowMinutes' => '<p>A value in minutes after a backup is scheduled before a job will be canceled if it doesn\'t start successfully. This value is optional, and the default is 8 hours. If this value is included, it must be at least 60 minutes to avoid errors.</p> <p>This parameter has a maximum value of 100 years (52,560,000 minutes).</p> <p>During the start window, the backup job status remains in <code>CREATED</code> status until it has successfully begun or until the start window time has run out. If within the start window time Backup receives an error that allows the job to be retried, Backup will automatically retry to begin the job at least every 10 minutes until the backup successfully begins (the job status changes to <code>RUNNING</code>) or until the job status changes to <code>EXPIRED</code> (which is expected to occur when the start window time is over).</p>', 'StartBackupJobInput$CompleteWindowMinutes' => '<p>A value in minutes during which a successfully started backup must complete, or else Backup will cancel the job. This value is optional. This value begins counting down from when the backup was scheduled. It does not add additional time for <code>StartWindowMinutes</code>, or if the backup started later than scheduled.</p> <p>Like <code>StartWindowMinutes</code>, this parameter has a maximum value of 100 years (52,560,000 minutes).</p>', ], ], 'boolean' => [ 'base' => NULL, 'refs' => [ 'BackupJob$IsParent' => '<p>This is a boolean value indicating this is a parent (composite) backup job.</p>', 'CopyJob$IsParent' => '<p>This is a boolean value indicating this is a parent (composite) copy job.</p>', 'DescribeBackupJobOutput$IsParent' => '<p>This returns the boolean value that a backup job is a parent (composite) job.</p>', 'DescribeRecoveryPointOutput$IsEncrypted' => '<p>A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or <code>FALSE</code> if the recovery point is not encrypted.</p>', 'DescribeRecoveryPointOutput$IsParent' => '<p>This returns the boolean value that a recovery point is a parent (composite) job.</p>', 'ListBackupVaultsInput$ByShared' => '<p>This parameter will sort the list of vaults by shared vaults.</p>', 'ListRecoveryPointsByResourceInput$ManagedByAWSBackupOnly' => '<p>This attribute filters recovery points based on ownership.</p> <p>If this is set to <code>TRUE</code>, the response will contain recovery points associated with the selected resources that are managed by Backup.</p> <p>If this is set to <code>FALSE</code>, the response will contain all recovery points associated with the selected resource.</p> <p>Type: Boolean</p>', 'RecoveryPointByBackupVault$IsEncrypted' => '<p>A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or <code>FALSE</code> if the recovery point is not encrypted.</p>', 'RecoveryPointByBackupVault$IsParent' => '<p>This is a boolean value indicating this is a parent (composite) recovery point.</p>', 'RecoveryPointByResource$IsParent' => '<p>This is a boolean value indicating this is a parent (composite) recovery point.</p>', 'StartBackupJobOutput$IsParent' => '<p>This is a returned boolean value indicating this is a parent (composite) backup job.</p>', 'StartCopyJobOutput$IsParent' => '<p>This is a returned boolean value indicating this is a parent (composite) copy job.</p>', 'StartRestoreJobInput$CopySourceTagsToRestoredResource' => '<p>This is an optional parameter. If this equals <code>True</code>, tags included in the backup will be copied to the restored resource.</p> <p>This can only be applied to backups created through Backup.</p>', ], ], 'integer' => [ 'base' => NULL, 'refs' => [ 'BackupJobSummary$Count' => '<p>The value as a number of jobs in a job summary.</p>', 'CopyJobSummary$Count' => '<p>The value as a number of jobs in a job summary.</p>', 'Framework$NumberOfControls' => '<p>The number of controls contained by the framework.</p>', 'ReportSetting$NumberOfFrameworks' => '<p>The number of frameworks a report covers.</p>', 'RestoreJobSummary$Count' => '<p>The value as a number of jobs in a job summary.</p>', 'RestoreTestingPlanForCreate$StartWindowHours' => '<p>Defaults to 24 hours.</p> <p>A value in hours after a restore test is scheduled before a job will be canceled if it doesn\'t start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).</p>', 'RestoreTestingPlanForGet$StartWindowHours' => '<p>Defaults to 24 hours.</p> <p>A value in hours after a restore test is scheduled before a job will be canceled if it doesn\'t start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).</p>', 'RestoreTestingPlanForList$StartWindowHours' => '<p>Defaults to 24 hours.</p> <p>A value in hours after a restore test is scheduled before a job will be canceled if it doesn\'t start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).</p>', 'RestoreTestingPlanForUpdate$StartWindowHours' => '<p>Defaults to 24 hours.</p> <p>A value in hours after a restore test is scheduled before a job will be canceled if it doesn\'t start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).</p>', 'RestoreTestingRecoveryPointSelection$SelectionWindowDays' => '<p>Accepted values are integers from 1 to 365.</p>', 'RestoreTestingSelectionForCreate$ValidationWindowHours' => '<p>This is amount of hours (1 to 168) available to run a validation script on the data. The data will be deleted upon the completion of the validation script or the end of the specified retention period, whichever comes first.</p>', 'RestoreTestingSelectionForGet$ValidationWindowHours' => '<p>This is amount of hours (1 to 168) available to run a validation script on the data. The data will be deleted upon the completion of the validation script or the end of the specified retention period, whichever comes first.</p>', 'RestoreTestingSelectionForList$ValidationWindowHours' => '<p>This value represents the time, in hours, data is retained after a restore test so that optional validation can be completed.</p> <p>Accepted value is an integer between 0 and 168 (the hourly equivalent of seven days).</p>', 'RestoreTestingSelectionForUpdate$ValidationWindowHours' => '<p>This value represents the time, in hours, data is retained after a restore test so that optional validation can be completed.</p> <p>Accepted value is an integer between 0 and 168 (the hourly equivalent of seven days).</p>', ], ], 'long' => [ 'base' => NULL, 'refs' => [ 'BackupVaultListMember$NumberOfRecoveryPoints' => '<p>The number of recovery points that are stored in a backup vault.</p>', 'DescribeBackupVaultOutput$NumberOfRecoveryPoints' => '<p>The number of recovery points that are stored in a backup vault.</p>', ], ], 'string' => [ 'base' => NULL, 'refs' => [ 'AlreadyExistsException$Code' => NULL, 'AlreadyExistsException$Message' => NULL, 'AlreadyExistsException$CreatorRequestId' => '<p/>', 'AlreadyExistsException$Arn' => '<p/>', 'AlreadyExistsException$Type' => '<p/>', 'AlreadyExistsException$Context' => '<p/>', 'BackupJob$BackupJobId' => '<p>Uniquely identifies a request to Backup to back up a resource.</p>', 'BackupJob$StatusMessage' => '<p>A detailed message explaining the status of the job to back up a resource.</p>', 'BackupJob$PercentDone' => '<p>Contains an estimated percentage complete of a job at the time the job status was queried.</p>', 'BackupJob$BackupType' => '<p>Represents the type of backup for a backup job.</p>', 'BackupJob$ParentJobId' => '<p>This uniquely identifies a request to Backup to back up a resource. The return will be the parent (composite) job ID.</p>', 'BackupJob$ResourceName' => '<p>This is the non-unique name of the resource that belongs to the specified backup.</p>', 'BackupJob$MessageCategory' => '<p>This parameter is the job count for the specified message category.</p> <p>Example strings may include <code>AccessDenied</code>, <code>SUCCESS</code>, <code>AGGREGATE_ALL</code>, and <code>INVALIDPARAMETERS</code>. See <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a list of MessageCategory strings.</p> <p>The the value ANY returns count of all message categories.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.</p>', 'BackupPlanTemplatesListMember$BackupPlanTemplateId' => '<p>Uniquely identifies a stored backup plan template.</p>', 'BackupPlanTemplatesListMember$BackupPlanTemplateName' => '<p>The optional display name of a backup plan template.</p>', 'BackupPlansListMember$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'BackupPlansListMember$VersionId' => '<p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>', 'BackupPlansListMember$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. This parameter is optional.</p> <p>If used, this parameter must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'BackupRule$RuleId' => '<p>Uniquely identifies a rule that is used to schedule the backup of a selection of resources.</p>', 'BackupSelectionsListMember$SelectionId' => '<p>Uniquely identifies a request to assign a set of resources to a backup plan.</p>', 'BackupSelectionsListMember$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'BackupSelectionsListMember$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. This parameter is optional.</p> <p>If used, this parameter must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'BackupVaultListMember$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. This parameter is optional.</p> <p>If used, this parameter must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'CancelLegalHoldInput$LegalHoldId' => '<p>Legal hold ID required to remove the specified legal hold on a recovery point.</p>', 'CancelLegalHoldInput$CancelDescription' => '<p>String describing the reason for removing the legal hold.</p>', 'ComplianceResourceIdList$member' => NULL, 'ConflictException$Code' => NULL, 'ConflictException$Message' => NULL, 'ConflictException$Type' => '<p/>', 'ConflictException$Context' => '<p/>', 'CopyJob$CopyJobId' => '<p>Uniquely identifies a copy job.</p>', 'CopyJob$StatusMessage' => '<p>A detailed message explaining the status of the job to copy a resource.</p>', 'CopyJob$ParentJobId' => '<p>This uniquely identifies a request to Backup to copy a resource. The return will be the parent (composite) job ID.</p>', 'CopyJob$CompositeMemberIdentifier' => '<p>This is the identifier of a resource within a composite group, such as nested (child) recovery point belonging to a composite (parent) stack. The ID is transferred from the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax"> logical ID</a> within a stack.</p>', 'CopyJob$ResourceName' => '<p>This is the non-unique name of the resource that belongs to the specified backup.</p>', 'CopyJob$MessageCategory' => '<p>This parameter is the job count for the specified message category.</p> <p>Example strings may include <code>AccessDenied</code>, <code>SUCCESS</code>, <code>AGGREGATE_ALL</code>, and <code>InvalidParameters</code>. See <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a list of MessageCategory strings.</p> <p>The the value ANY returns count of all message categories.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum</p>', 'CreateBackupPlanInput$CreatorRequestId' => '<p>Identifies the request and allows failed requests to be retried without the risk of running the operation twice. If the request includes a <code>CreatorRequestId</code> that matches an existing backup plan, that plan is returned. This parameter is optional.</p> <p>If used, this parameter must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'CreateBackupPlanOutput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'CreateBackupPlanOutput$VersionId' => '<p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. They cannot be edited.</p>', 'CreateBackupSelectionInput$BackupPlanId' => '<p>Uniquely identifies the backup plan to be associated with the selection of resources.</p>', 'CreateBackupSelectionInput$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. This parameter is optional.</p> <p>If used, this parameter must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'CreateBackupSelectionOutput$SelectionId' => '<p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>', 'CreateBackupSelectionOutput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'CreateBackupVaultInput$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. This parameter is optional.</p> <p>If used, this parameter must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'CreateFrameworkInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>CreateFrameworkInput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'CreateLegalHoldInput$Title' => '<p>This is the string title of the legal hold.</p>', 'CreateLegalHoldInput$Description' => '<p>This is the string description of the legal hold.</p>', 'CreateLegalHoldInput$IdempotencyToken' => '<p>This is a user-chosen string used to distinguish between otherwise identical calls. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'CreateLegalHoldOutput$Title' => '<p>This is the string title of the legal hold returned after creating the legal hold.</p>', 'CreateLegalHoldOutput$Description' => '<p>This is the returned string description of the legal hold.</p>', 'CreateLegalHoldOutput$LegalHoldId' => '<p>Legal hold ID returned for the specified legal hold on a recovery point.</p>', 'CreateLogicallyAirGappedBackupVaultInput$CreatorRequestId' => '<p>This is the ID of the creation request.</p> <p>This parameter is optional. If used, this parameter must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'CreateReportPlanInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>CreateReportPlanInput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'DeleteBackupPlanInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'DeleteBackupPlanOutput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'DeleteBackupPlanOutput$VersionId' => '<p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>', 'DeleteBackupSelectionInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'DeleteBackupSelectionInput$SelectionId' => '<p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>', 'DeleteBackupVaultInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DependencyFailureException$Code' => NULL, 'DependencyFailureException$Message' => NULL, 'DependencyFailureException$Type' => '<p/>', 'DependencyFailureException$Context' => '<p/>', 'DescribeBackupJobInput$BackupJobId' => '<p>Uniquely identifies a request to Backup to back up a resource.</p>', 'DescribeBackupJobOutput$BackupJobId' => '<p>Uniquely identifies a request to Backup to back up a resource.</p>', 'DescribeBackupJobOutput$StatusMessage' => '<p>A detailed message explaining the status of the job to back up a resource.</p>', 'DescribeBackupJobOutput$PercentDone' => '<p>Contains an estimated percentage that is complete of a job at the time the job status was queried.</p>', 'DescribeBackupJobOutput$BackupType' => '<p>Represents the actual backup type selected for a backup job. For example, if a successful Windows Volume Shadow Copy Service (VSS) backup was taken, <code>BackupType</code> returns <code>"WindowsVSS"</code>. If <code>BackupType</code> is empty, then the backup type was a regular backup.</p>', 'DescribeBackupJobOutput$ParentJobId' => '<p>This returns the parent (composite) resource backup job ID.</p>', 'DescribeBackupJobOutput$ResourceName' => '<p>This is the non-unique name of the resource that belongs to the specified backup.</p>', 'DescribeBackupJobOutput$MessageCategory' => '<p>This is the job count for the specified message category.</p> <p>Example strings may include <code>AccessDenied</code>, <code>SUCCESS</code>, <code>AGGREGATE_ALL</code>, and <code>INVALIDPARAMETERS</code>. View <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a list of accepted MessageCategory strings.</p>', 'DescribeBackupVaultInput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DescribeBackupVaultInput$BackupVaultAccountId' => '<p>This is the account ID of the specified backup vault.</p>', 'DescribeBackupVaultOutput$BackupVaultName' => '<p>The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.</p>', 'DescribeBackupVaultOutput$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. This parameter is optional. If used, this parameter must contain 1 to 50 alphanumeric or \'-_.\' characters.</p>', 'DescribeCopyJobInput$CopyJobId' => '<p>Uniquely identifies a copy job.</p>', 'DescribeFrameworkOutput$DeploymentStatus' => '<p>The deployment status of a framework. The statuses are:</p> <p> <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code> </p>', 'DescribeFrameworkOutput$FrameworkStatus' => '<p>A framework consists of one or more controls. Each control governs a resource, such as backup plans, backup selections, backup vaults, or recovery points. You can also turn Config recording on or off for each resource. The statuses are:</p> <ul> <li> <p> <code>ACTIVE</code> when recording is turned on for all resources governed by the framework.</p> </li> <li> <p> <code>PARTIALLY_ACTIVE</code> when recording is turned off for at least one resource governed by the framework.</p> </li> <li> <p> <code>INACTIVE</code> when recording is turned off for all resources governed by the framework.</p> </li> <li> <p> <code>UNAVAILABLE</code> when Backup is unable to validate recording status at this time.</p> </li> </ul>', 'DescribeFrameworkOutput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>DescribeFrameworkOutput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'DescribeProtectedResourceOutput$ResourceName' => '<p>This is the non-unique name of the resource that belongs to the specified backup.</p>', 'DescribeRecoveryPointOutput$StatusMessage' => '<p>A status message explaining the status of the recovery point.</p>', 'DescribeRecoveryPointOutput$CompositeMemberIdentifier' => '<p>This is the identifier of a resource within a composite group, such as nested (child) recovery point belonging to a composite (parent) stack. The ID is transferred from the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax"> logical ID</a> within a stack.</p>', 'DescribeRecoveryPointOutput$ResourceName' => '<p>This is the non-unique name of the resource that belongs to the specified backup.</p>', 'DescribeRestoreJobOutput$RestoreJobId' => '<p>Uniquely identifies the job that restores a recovery point.</p>', 'DescribeRestoreJobOutput$StatusMessage' => '<p>A message showing the status of a job to restore a recovery point.</p>', 'DescribeRestoreJobOutput$PercentDone' => '<p>Contains an estimated percentage that is complete of a job at the time the job status was queried.</p>', 'DescribeRestoreJobOutput$ValidationStatusMessage' => '<p>This describes the status of validation run on the indicated restore job.</p>', 'DescribeRestoreJobOutput$DeletionStatusMessage' => '<p>This describes the restore job deletion status.</p>', 'ExportBackupPlanTemplateInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'ExportBackupPlanTemplateOutput$BackupPlanTemplateJson' => '<p>The body of a backup plan template in JSON format.</p> <note> <p>This is a signed JSON document that cannot be modified before being passed to <code>GetBackupPlanFromJSON.</code> </p> </note>', 'FormatList$member' => NULL, 'Framework$DeploymentStatus' => '<p>The deployment status of a framework. The statuses are:</p> <p> <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code> </p>', 'GetBackupPlanFromJSONInput$BackupPlanTemplateJson' => '<p>A customer-supplied backup plan document in JSON format.</p>', 'GetBackupPlanFromTemplateInput$BackupPlanTemplateId' => '<p>Uniquely identifies a stored backup plan template.</p>', 'GetBackupPlanInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'GetBackupPlanInput$VersionId' => '<p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>', 'GetBackupPlanOutput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'GetBackupPlanOutput$VersionId' => '<p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.</p>', 'GetBackupPlanOutput$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. </p>', 'GetBackupSelectionInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'GetBackupSelectionInput$SelectionId' => '<p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>', 'GetBackupSelectionOutput$SelectionId' => '<p>Uniquely identifies the body of a request to assign a set of resources to a backup plan.</p>', 'GetBackupSelectionOutput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'GetBackupSelectionOutput$CreatorRequestId' => '<p>A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice.</p>', 'GetLegalHoldInput$LegalHoldId' => '<p>This is the ID required to use <code>GetLegalHold</code>. This unique ID is associated with a specific legal hold.</p>', 'GetLegalHoldOutput$Title' => '<p>This is the string title of the legal hold.</p>', 'GetLegalHoldOutput$Description' => '<p>This is the returned string description of the legal hold.</p>', 'GetLegalHoldOutput$CancelDescription' => '<p>String describing the reason for removing the legal hold.</p>', 'GetLegalHoldOutput$LegalHoldId' => '<p>This is the returned ID associated with a specified legal hold.</p>', 'InvalidParameterValueException$Code' => NULL, 'InvalidParameterValueException$Message' => NULL, 'InvalidParameterValueException$Type' => '<p/>', 'InvalidParameterValueException$Context' => '<p/>', 'InvalidRequestException$Code' => NULL, 'InvalidRequestException$Message' => NULL, 'InvalidRequestException$Type' => '<p/>', 'InvalidRequestException$Context' => '<p/>', 'InvalidResourceStateException$Code' => NULL, 'InvalidResourceStateException$Message' => NULL, 'InvalidResourceStateException$Type' => '<p/>', 'InvalidResourceStateException$Context' => '<p/>', 'LegalHold$Title' => '<p>This is the title of a legal hold.</p>', 'LegalHold$Description' => '<p>This is the description of a legal hold.</p>', 'LegalHold$LegalHoldId' => '<p>ID of specific legal hold on one or more recovery points.</p>', 'LimitExceededException$Code' => NULL, 'LimitExceededException$Message' => NULL, 'LimitExceededException$Type' => '<p/>', 'LimitExceededException$Context' => '<p/>', 'ListBackupJobSummariesInput$NextToken' => '<p>The next item following a partial list of returned resources. For example, if a request is made to return <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupJobSummariesOutput$AggregationPeriod' => '<p>This is the period that sets the boundaries for returned results.</p> <ul> <li> <p> <code>ONE_DAY</code> for daily job count for the prior 14 days.</p> </li> <li> <p> <code>SEVEN_DAYS</code> for the aggregated job count for the prior 7 days.</p> </li> <li> <p> <code>FOURTEEN_DAYS</code> for aggregated job count for prior 14 days.</p> </li> </ul>', 'ListBackupJobSummariesOutput$NextToken' => '<p>The next item following a partial list of returned resources. For example, if a request is made to return <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupJobsInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupJobsInput$ByParentJobId' => '<p>This is a filter to list child (nested) jobs based on parent job ID.</p>', 'ListBackupJobsInput$ByMessageCategory' => '<p>This is an optional parameter that can be used to filter out jobs with a MessageCategory which matches the value you input.</p> <p>Example strings may include <code>AccessDenied</code>, <code>SUCCESS</code>, <code>AGGREGATE_ALL</code>, and <code>InvalidParameters</code>.</p> <p>View <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> </p> <p>The wildcard () returns count of all message categories.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.</p>', 'ListBackupJobsOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupPlanTemplatesInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupPlanTemplatesOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupPlanVersionsInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'ListBackupPlanVersionsInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupPlanVersionsOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupPlansInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupPlansOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupSelectionsInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'ListBackupSelectionsInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupSelectionsOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupVaultsInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListBackupVaultsOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListCopyJobSummariesInput$NextToken' => '<p>The next item following a partial list of returned resources. For example, if a request is made to return <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListCopyJobSummariesOutput$AggregationPeriod' => '<p>This is the period that sets the boundaries for returned results.</p> <ul> <li> <p> <code>ONE_DAY</code> for daily job count for the prior 14 days.</p> </li> <li> <p> <code>SEVEN_DAYS</code> for the aggregated job count for the prior 7 days.</p> </li> <li> <p> <code>FOURTEEN_DAYS</code> for aggregated job count for prior 14 days.</p> </li> </ul>', 'ListCopyJobSummariesOutput$NextToken' => '<p>The next item following a partial list of returned resources. For example, if a request is made to return <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListCopyJobsInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return MaxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. </p>', 'ListCopyJobsInput$ByDestinationVaultArn' => '<p>An Amazon Resource Name (ARN) that uniquely identifies a source backup vault to copy from; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>. </p>', 'ListCopyJobsInput$ByParentJobId' => '<p>This is a filter to list child (nested) jobs based on parent job ID.</p>', 'ListCopyJobsInput$ByMessageCategory' => '<p>This is an optional parameter that can be used to filter out jobs with a MessageCategory which matches the value you input.</p> <p>Example strings may include <code>AccessDenied</code>, <code>SUCCESS</code>, <code>AGGREGATE_ALL</code>, and <code>INVALIDPARAMETERS</code>.</p> <p>View <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a list of accepted strings.</p> <p>The the value ANY returns count of all message categories.</p> <p> <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.</p>', 'ListCopyJobsOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return MaxResults number of items, NextToken allows you to return more items in your list starting at the location pointed to by the next token. </p>', 'ListFrameworksInput$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListFrameworksOutput$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListLegalHoldsInput$NextToken' => '<p>The next item following a partial list of returned resources. For example, if a request is made to return <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListLegalHoldsOutput$NextToken' => '<p>The next item following a partial list of returned resources. For example, if a request is made to return <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListProtectedResourcesByBackupVaultInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListProtectedResourcesByBackupVaultOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListProtectedResourcesInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListProtectedResourcesOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListRecoveryPointsByBackupVaultInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListRecoveryPointsByBackupVaultInput$ByBackupPlanId' => '<p>Returns only recovery points that match the specified backup plan ID.</p>', 'ListRecoveryPointsByBackupVaultOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListRecoveryPointsByLegalHoldInput$LegalHoldId' => '<p>This is the ID of the legal hold.</p>', 'ListRecoveryPointsByLegalHoldInput$NextToken' => '<p>This is the next item following a partial list of returned resources. For example, if a request is made to return <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListRecoveryPointsByLegalHoldOutput$NextToken' => '<p>This return is the next item following a partial list of returned resources.</p>', 'ListRecoveryPointsByResourceInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListRecoveryPointsByResourceOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListReportJobsInput$ByStatus' => '<p>Returns only report jobs that are in the specified status. The statuses are:</p> <p> <code>CREATED | RUNNING | COMPLETED | FAILED</code> </p>', 'ListReportJobsInput$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListReportJobsOutput$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListReportPlansInput$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListReportPlansOutput$NextToken' => '<p>An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.</p>', 'ListRestoreJobSummariesInput$NextToken' => '<p>The next item following a partial list of returned resources. For example, if a request is made to return <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListRestoreJobSummariesOutput$AggregationPeriod' => '<p>This is the period that sets the boundaries for returned results.</p> <ul> <li> <p> <code>ONE_DAY</code> for daily job count for the prior 14 days.</p> </li> <li> <p> <code>SEVEN_DAYS</code> for the aggregated job count for the prior 7 days.</p> </li> <li> <p> <code>FOURTEEN_DAYS</code> for aggregated job count for prior 14 days.</p> </li> </ul>', 'ListRestoreJobSummariesOutput$NextToken' => '<p>The next item following a partial list of returned resources. For example, if a request is made to return <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListRestoreJobsByProtectedResourceInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request ismade to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListRestoreJobsByProtectedResourceOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows youto return more items in your list starting at the location pointed to by the next token</p>', 'ListRestoreJobsInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListRestoreJobsOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListTagsInput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'ListTagsOutput$NextToken' => '<p>The next item following a partial list of returned items. For example, if a request is made to return <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list starting at the location pointed to by the next token.</p>', 'MissingParameterValueException$Code' => NULL, 'MissingParameterValueException$Message' => NULL, 'MissingParameterValueException$Type' => '<p/>', 'MissingParameterValueException$Context' => '<p/>', 'ProtectedResource$ResourceName' => '<p>This is the non-unique name of the resource that belongs to the specified backup.</p>', 'PutRestoreValidationResultInput$ValidationStatusMessage' => '<p>This is an optional message string you can input to describe the validation status for the restore test validation.</p>', 'RecoveryPointByBackupVault$StatusMessage' => '<p>A message explaining the reason of the recovery point deletion failure.</p>', 'RecoveryPointByBackupVault$CompositeMemberIdentifier' => '<p>This is the identifier of a resource within a composite group, such as nested (child) recovery point belonging to a composite (parent) stack. The ID is transferred from the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax"> logical ID</a> within a stack.</p>', 'RecoveryPointByBackupVault$ResourceName' => '<p>This is the non-unique name of the resource that belongs to the specified backup.</p>', 'RecoveryPointByResource$StatusMessage' => '<p>A message explaining the reason of the recovery point deletion failure.</p>', 'RecoveryPointByResource$ResourceName' => '<p>This is the non-unique name of the resource that belongs to the specified backup.</p>', 'RecoveryPointCreator$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'RecoveryPointCreator$BackupPlanVersion' => '<p>Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. They cannot be edited.</p>', 'RecoveryPointCreator$BackupRuleId' => '<p>Uniquely identifies a rule used to schedule the backup of a selection of resources.</p>', 'ReportDeliveryChannel$S3BucketName' => '<p>The unique name of the S3 bucket that receives your reports.</p>', 'ReportDeliveryChannel$S3KeyPrefix' => '<p>The prefix for where Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path: s3://your-bucket-name/<code>prefix</code>/Backup/us-west-2/year/month/day/report-name. If not specified, there is no prefix.</p>', 'ReportDestination$S3BucketName' => '<p>The unique name of the Amazon S3 bucket that receives your reports.</p>', 'ReportJob$ReportTemplate' => '<p>Identifies the report template for the report. Reports are built using a report template. The report templates are: </p> <p> <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code> </p>', 'ReportJob$Status' => '<p>The status of a report job. The statuses are:</p> <p> <code>CREATED | RUNNING | COMPLETED | FAILED</code> </p> <p> <code>COMPLETED</code> means that the report is available for your review at your designated destination. If the status is <code>FAILED</code>, review the <code>StatusMessage</code> for the reason.</p>', 'ReportJob$StatusMessage' => '<p>A message explaining the status of the report job.</p>', 'ReportPlan$DeploymentStatus' => '<p>The deployment status of a report plan. The statuses are:</p> <p> <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED</code> </p>', 'ReportSetting$ReportTemplate' => '<p>Identifies the report template for the report. Reports are built using a report template. The report templates are:</p> <p> <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code> </p>', 'ResourceIdentifiers$member' => NULL, 'ResourceNotFoundException$Code' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$Type' => '<p/>', 'ResourceNotFoundException$Context' => '<p/>', 'RestoreJobsListMember$RestoreJobId' => '<p>Uniquely identifies the job that restores a recovery point.</p>', 'RestoreJobsListMember$StatusMessage' => '<p>A detailed message explaining the status of the job to restore a recovery point.</p>', 'RestoreJobsListMember$PercentDone' => '<p>Contains an estimated percentage complete of a job at the time the job status was queried.</p>', 'RestoreJobsListMember$ValidationStatusMessage' => '<p>This describes the status of validation run on the indicated restore job.</p>', 'RestoreJobsListMember$DeletionStatusMessage' => '<p>This describes the restore job deletion status.</p>', 'ServiceUnavailableException$Code' => NULL, 'ServiceUnavailableException$Message' => NULL, 'ServiceUnavailableException$Type' => '<p/>', 'ServiceUnavailableException$Context' => '<p/>', 'StartBackupJobInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>StartBackupJob</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'StartBackupJobOutput$BackupJobId' => '<p>Uniquely identifies a request to Backup to back up a resource.</p>', 'StartCopyJobInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>StartCopyJob</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'StartCopyJobOutput$CopyJobId' => '<p>Uniquely identifies a copy job.</p>', 'StartReportJobInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>StartReportJobInput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'StartRestoreJobInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>StartRestoreJob</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'StopBackupJobInput$BackupJobId' => '<p>Uniquely identifies a request to Backup to back up a resource.</p>', 'TagKeyList$member' => NULL, 'UpdateBackupPlanInput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'UpdateBackupPlanOutput$BackupPlanId' => '<p>Uniquely identifies a backup plan.</p>', 'UpdateBackupPlanOutput$VersionId' => '<p>Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version Ids cannot be edited.</p>', 'UpdateFrameworkInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>UpdateFrameworkInput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'UpdateReportPlanInput$IdempotencyToken' => '<p>A customer-chosen string that you can use to distinguish between otherwise identical calls to <code>UpdateReportPlanInput</code>. Retrying a successful request with the same idempotency token results in a success message with no action taken.</p>', 'VaultNames$member' => NULL, 'stringList$member' => NULL, 'stringMap$key' => NULL, 'stringMap$value' => NULL, ], ], 'stringList' => [ 'base' => NULL, 'refs' => [ 'ReportDestination$S3Keys' => '<p>The object key that uniquely identifies your reports in your S3 bucket.</p>', 'ReportSetting$FrameworkArns' => '<p>The Amazon Resource Names (ARNs) of the frameworks a report covers.</p>', 'ReportSetting$Accounts' => '<p>These are the accounts to be included in the report.</p>', 'ReportSetting$OrganizationUnits' => '<p>These are the Organizational Units to be included in the report.</p>', 'ReportSetting$Regions' => '<p>These are the Regions to be included in the report.</p>', 'RestoreTestingRecoveryPointSelection$ExcludeVaults' => '<p>Accepted values include specific ARNs or list of selectors. Defaults to empty list if not listed.</p>', 'RestoreTestingRecoveryPointSelection$IncludeVaults' => '<p>Accepted values include wildcard ["*"] or by specific ARNs or ARN wilcard replacement ["arn:aws:backup:us-west-2:123456789012:backup-vault:asdf", ...] ["arn:aws:backup:*:*:backup-vault:asdf-*", ...]</p>', 'RestoreTestingSelectionForCreate$ProtectedResourceArns' => '<p>Each protected resource can be filtered by its specific ARNs, such as <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or by a wildcard: <code>ProtectedResourceArns: ["*"]</code>, but not both.</p>', 'RestoreTestingSelectionForGet$ProtectedResourceArns' => '<p>You can include specific ARNs, such as <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard: <code>ProtectedResourceArns: ["*"]</code>, but not both.</p>', 'RestoreTestingSelectionForUpdate$ProtectedResourceArns' => '<p>You can include a list of specific ARNs, such as <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard: <code>ProtectedResourceArns: ["*"]</code>, but not both.</p>', ], ], 'stringMap' => [ 'base' => NULL, 'refs' => [ 'ControlScope$Tags' => '<p>The tag key-value pair applied to those Amazon Web Services resources that you want to trigger an evaluation for a rule. A maximum of one key-value pair can be provided. The tag value is optional, but it cannot be an empty string. The structure to assign a tag is: <code>[{"Key":"string","Value":"string"}]</code>.</p>', 'CreateFrameworkInput$FrameworkTags' => '<p>Metadata that you can assign to help organize the frameworks that you create. Each tag is a key-value pair.</p>', 'CreateReportPlanInput$ReportPlanTags' => '<p>Metadata that you can assign to help organize the report plans that you create. Each tag is a key-value pair.</p>', 'GetRestoreTestingInferredMetadataOutput$InferredMetadata' => '<p>This is a string map of the metadata inferred from the request.</p>', ], ], 'timestamp' => [ 'base' => NULL, 'refs' => [ 'BackupJob$CreationDate' => '<p>The date and time a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupJob$CompletionDate' => '<p>The date and time a job to create a backup job is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupJob$ExpectedCompletionDate' => '<p>The date and time a job to back up resources is expected to be completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>ExpectedCompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupJob$StartBy' => '<p>Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job must be started before it is canceled. The value is calculated by adding the start window to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2 hours, the <code>StartBy</code> time would be 8:00 PM on the date specified. The value of <code>StartBy</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupJob$InitiationDate' => '<p>This is the date on which the backup job was initiated.</p>', 'BackupJobSummary$StartTime' => '<p>The value of time in number format of a job start time.</p> <p>This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupJobSummary$EndTime' => '<p>The value of time in number format of a job end time.</p> <p>This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupPlansListMember$CreationDate' => '<p>The date and time a resource backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupPlansListMember$DeletionDate' => '<p>The date and time a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupPlansListMember$LastExecutionDate' => '<p>The last time a job to back up resources was run with this rule. A date and time, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupSelectionsListMember$CreationDate' => '<p>The date and time a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupVaultListMember$CreationDate' => '<p>The date and time a resource backup is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'BackupVaultListMember$LockDate' => '<p>The date and time when Backup Vault Lock configuration becomes immutable, meaning it cannot be changed or deleted.</p> <p>If you applied Vault Lock to your vault without specifying a lock date, you can change your Vault Lock settings, or delete Vault Lock from the vault entirely, at any time.</p> <p>This value is in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'CalculatedLifecycle$MoveToColdStorageAt' => '<p>A timestamp that specifies when to transition a recovery point to cold storage.</p>', 'CalculatedLifecycle$DeleteAt' => '<p>A timestamp that specifies when to delete a recovery point.</p>', 'CopyJob$CreationDate' => '<p>The date and time a copy job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'CopyJob$CompletionDate' => '<p>The date and time a copy job is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'CopyJobSummary$StartTime' => '<p>The value of time in number format of a job start time.</p> <p>This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'CopyJobSummary$EndTime' => '<p>The value of time in number format of a job end time.</p> <p>This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'CreateBackupPlanOutput$CreationDate' => '<p>The date and time that a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'CreateBackupSelectionOutput$CreationDate' => '<p>The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'CreateBackupVaultOutput$CreationDate' => '<p>The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'CreateLegalHoldOutput$CreationDate' => '<p>Time in number format when legal hold was created.</p>', 'CreateLogicallyAirGappedBackupVaultOutput$CreationDate' => '<p>The date and time when the vault was created.</p> <p>This value is in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'CreateReportPlanOutput$CreationTime' => '<p>The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DateRange$FromDate' => '<p>This value is the beginning date, inclusive.</p> <p>The date and time are in Unix format and Coordinated Universal Time (UTC), and it is accurate to milliseconds (milliseconds are optional).</p>', 'DateRange$ToDate' => '<p>This value is the end date, inclusive.</p> <p>The date and time are in Unix format and Coordinated Universal Time (UTC), and it is accurate to milliseconds (milliseconds are optional).</p>', 'DeleteBackupPlanOutput$DeletionDate' => '<p>The date and time a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeBackupJobOutput$CreationDate' => '<p>The date and time that a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeBackupJobOutput$CompletionDate' => '<p>The date and time that a job to create a backup job is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeBackupJobOutput$ExpectedCompletionDate' => '<p>The date and time that a job to back up resources is expected to be completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>ExpectedCompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeBackupJobOutput$StartBy' => '<p>Specifies the time in Unix format and Coordinated Universal Time (UTC) when a backup job must be started before it is canceled. The value is calculated by adding the start window to the scheduled time. So if the scheduled time were 6:00 PM and the start window is 2 hours, the <code>StartBy</code> time would be 8:00 PM on the date specified. The value of <code>StartBy</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeBackupJobOutput$InitiationDate' => '<p>This is the date a backup job was initiated.</p>', 'DescribeBackupVaultOutput$CreationDate' => '<p>The date and time that a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeBackupVaultOutput$LockDate' => '<p>The date and time when Backup Vault Lock configuration cannot be changed or deleted.</p> <p>If you applied Vault Lock to your vault without specifying a lock date, you can change any of your Vault Lock settings, or delete Vault Lock from the vault entirely, at any time.</p> <p>This value is in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeFrameworkOutput$CreationTime' => '<p>The date and time that a framework is created, in ISO 8601 representation. The value of <code>CreationTime</code> is accurate to milliseconds. For example, 2020-07-10T15:00:00.000-08:00 represents the 10th of July 2020 at 3:00 PM 8 hours behind UTC.</p>', 'DescribeGlobalSettingsOutput$LastUpdateTime' => '<p>The date and time that the flag <code>isCrossAccountBackupEnabled</code> was last updated. This update is in Unix format and Coordinated Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeProtectedResourceOutput$LastBackupTime' => '<p>The date and time that a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeProtectedResourceOutput$LatestRestoreJobCreationDate' => '<p>This is the creation date of the most recent restore job.</p>', 'DescribeProtectedResourceOutput$LatestRestoreRecoveryPointCreationDate' => '<p>This is the date the most recent recovery point was created.</p>', 'DescribeRecoveryPointOutput$CreationDate' => '<p>The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeRecoveryPointOutput$CompletionDate' => '<p>The date and time that a job to create a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeRecoveryPointOutput$LastRestoreTime' => '<p>The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeRestoreJobOutput$CreationDate' => '<p>The date and time that a restore job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeRestoreJobOutput$CompletionDate' => '<p>The date and time that a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'DescribeRestoreJobOutput$RecoveryPointCreationDate' => '<p>This is the creation date of the recovery point made by the specifed restore job.</p>', 'Framework$CreationTime' => '<p>The date and time that a framework is created, in ISO 8601 representation. The value of <code>CreationTime</code> is accurate to milliseconds. For example, 2020-07-10T15:00:00.000-08:00 represents the 10th of July 2020 at 3:00 PM 8 hours behind UTC.</p>', 'GetBackupPlanOutput$CreationDate' => '<p>The date and time that a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'GetBackupPlanOutput$DeletionDate' => '<p>The date and time that a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of <code>DeletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'GetBackupPlanOutput$LastExecutionDate' => '<p>The last time a job to back up resources was run with this backup plan. A date and time, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'GetBackupSelectionOutput$CreationDate' => '<p>The date and time a backup selection is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'GetLegalHoldOutput$CreationDate' => '<p>Time in number format when legal hold was created.</p>', 'GetLegalHoldOutput$CancellationDate' => '<p>Time in number when legal hold was cancelled.</p>', 'GetLegalHoldOutput$RetainRecordUntil' => '<p>This is the date and time until which the legal hold record will be retained.</p>', 'LegalHold$CreationDate' => '<p>This is the time in number format when legal hold was created.</p>', 'LegalHold$CancellationDate' => '<p>This is the time in number format when legal hold was cancelled.</p>', 'ListBackupJobsInput$ByCreatedBefore' => '<p>Returns only backup jobs that were created before the specified date.</p>', 'ListBackupJobsInput$ByCreatedAfter' => '<p>Returns only backup jobs that were created after the specified date.</p>', 'ListBackupJobsInput$ByCompleteAfter' => '<p>Returns only backup jobs completed after a date expressed in Unix format and Coordinated Universal Time (UTC).</p>', 'ListBackupJobsInput$ByCompleteBefore' => '<p>Returns only backup jobs completed before a date expressed in Unix format and Coordinated Universal Time (UTC).</p>', 'ListCopyJobsInput$ByCreatedBefore' => '<p>Returns only copy jobs that were created before the specified date.</p>', 'ListCopyJobsInput$ByCreatedAfter' => '<p>Returns only copy jobs that were created after the specified date.</p>', 'ListCopyJobsInput$ByCompleteBefore' => '<p>Returns only copy jobs completed before a date expressed in Unix format and Coordinated Universal Time (UTC).</p>', 'ListCopyJobsInput$ByCompleteAfter' => '<p>Returns only copy jobs completed after a date expressed in Unix format and Coordinated Universal Time (UTC).</p>', 'ListRecoveryPointsByBackupVaultInput$ByCreatedBefore' => '<p>Returns only recovery points that were created before the specified timestamp.</p>', 'ListRecoveryPointsByBackupVaultInput$ByCreatedAfter' => '<p>Returns only recovery points that were created after the specified timestamp.</p>', 'ListReportJobsInput$ByCreationBefore' => '<p>Returns only report jobs that were created before the date and time specified in Unix format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents Friday, January 26, 2018 12:11:30 AM.</p>', 'ListReportJobsInput$ByCreationAfter' => '<p>Returns only report jobs that were created after the date and time specified in Unix format and Coordinated Universal Time (UTC). For example, the value 1516925490 represents Friday, January 26, 2018 12:11:30 AM.</p>', 'ListRestoreJobsByProtectedResourceInput$ByRecoveryPointCreationDateAfter' => '<p>Returns only restore jobs of recovery points that were created after the specified date.</p>', 'ListRestoreJobsByProtectedResourceInput$ByRecoveryPointCreationDateBefore' => '<p>Returns only restore jobs of recovery points that were created before the specified date.</p>', 'ListRestoreJobsInput$ByCreatedBefore' => '<p>Returns only restore jobs that were created before the specified date.</p>', 'ListRestoreJobsInput$ByCreatedAfter' => '<p>Returns only restore jobs that were created after the specified date.</p>', 'ListRestoreJobsInput$ByCompleteBefore' => '<p>Returns only copy jobs completed before a date expressed in Unix format and Coordinated Universal Time (UTC).</p>', 'ListRestoreJobsInput$ByCompleteAfter' => '<p>Returns only copy jobs completed after a date expressed in Unix format and Coordinated Universal Time (UTC).</p>', 'ProtectedResource$LastBackupTime' => '<p>The date and time a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RecoveryPointByBackupVault$CreationDate' => '<p>The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RecoveryPointByBackupVault$CompletionDate' => '<p>The date and time a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RecoveryPointByBackupVault$LastRestoreTime' => '<p>The date and time a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RecoveryPointByResource$CreationDate' => '<p>The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'ReportJob$CreationTime' => '<p>The date and time that a report job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'ReportJob$CompletionTime' => '<p>The date and time that a report job is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'ReportPlan$CreationTime' => '<p>The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'ReportPlan$LastAttemptedExecutionTime' => '<p>The date and time that a report job associated with this report plan last attempted to run, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastAttemptedExecutionTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'ReportPlan$LastSuccessfulExecutionTime' => '<p>The date and time that a report job associated with this report plan last successfully ran, in Unix format and Coordinated Universal Time (UTC). The value of <code>LastSuccessfulExecutionTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RestoreJobSummary$StartTime' => '<p>The value of time in number format of a job start time.</p> <p>This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RestoreJobSummary$EndTime' => '<p>The value of time in number format of a job end time.</p> <p>This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RestoreJobsListMember$CreationDate' => '<p>The date and time a restore job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RestoreJobsListMember$CompletionDate' => '<p>The date and time a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'RestoreJobsListMember$RecoveryPointCreationDate' => '<p>The date on which a recovery point was created.</p>', 'StartBackupJobOutput$CreationDate' => '<p>The date and time that a backup job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'StartCopyJobOutput$CreationDate' => '<p>The date and time that a copy job is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'UpdateBackupPlanOutput$CreationDate' => '<p>The date and time a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', 'UpdateFrameworkOutput$CreationTime' => '<p>The date and time that a framework is created, in ISO 8601 representation. The value of <code>CreationTime</code> is accurate to milliseconds. For example, 2020-07-10T15:00:00.000-08:00 represents the 10th of July 2020 at 3:00 PM 8 hours behind UTC.</p>', 'UpdateReportPlanOutput$CreationTime' => '<p>The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.</p>', ], ], ],];
