<?php
// This file was auto-generated from sdk-root/src/data/bedrock-agent/2023-06-05/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Describes the API operations for creating and managing Amazon Bedrock agents.</p>', 'operations' => [ 'AssociateAgentKnowledgeBase' => '<p>Associates a knowledge base with an agent. If a knowledge base is associated and its <code>indexState</code> is set to <code>Enabled</code>, the agent queries the knowledge base for information to augment its response to the user.</p>', 'CreateAgent' => '<p>Creates an agent that orchestrates interactions between foundation models, data sources, software applications, user conversations, and APIs to carry out tasks to help customers.</p> <ul> <li> <p>Specify the following fields for security purposes.</p> <ul> <li> <p> <code>agentResourceRoleArn</code> – The Amazon Resource Name (ARN) of the role with permissions to invoke API operations on an agent.</p> </li> <li> <p>(Optional) <code>customerEncryptionKeyArn</code> – The Amazon Resource Name (ARN) of a KMS key to encrypt the creation of the agent.</p> </li> <li> <p>(Optional) <code>idleSessionTTLinSeconds</code> – Specify the number of seconds for which the agent should maintain session information. After this time expires, the subsequent <code>InvokeAgent</code> request begins a new session.</p> </li> </ul> </li> <li> <p>To enable your agent to retain conversational context across multiple sessions, include a <code>memoryConfiguration</code> object. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-configure-memory.html">Configure memory</a>.</p> </li> <li> <p>To override the default prompt behavior for agent orchestration and to use advanced prompts, include a <code>promptOverrideConfiguration</code> object. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.</p> </li> <li> <p>If you agent fails to be created, the response returns a list of <code>failureReasons</code> alongside a list of <code>recommendedActions</code> for you to troubleshoot.</p> </li> </ul>', 'CreateAgentActionGroup' => '<p>Creates an action group for an agent. An action group represents the actions that an agent can carry out for the customer by defining the APIs that an agent can call and the logic for calling them.</p> <p>To allow your agent to request the user for additional information when trying to complete a task, add an action group with the <code>parentActionGroupSignature</code> field set to <code>AMAZON.UserInput</code>. </p> <p>To allow your agent to generate, run, and troubleshoot code when trying to complete a task, add an action group with the <code>parentActionGroupSignature</code> field set to <code>AMAZON.CodeInterpreter</code>. </p> <p>You must leave the <code>description</code>, <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields blank for this action group. During orchestration, if your agent determines that it needs to invoke an API in an action group, but doesn\'t have enough information to complete the API request, it will invoke this action group instead and return an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html">Observation</a> reprompting the user for more information.</p>', 'CreateAgentAlias' => '<p>Creates an alias of an agent that can be used to deploy the agent.</p>', 'CreateDataSource' => '<p>Creates a data source connector for a knowledge base.</p> <important> <p>You can\'t change the <code>chunkingConfiguration</code> after you create the data source connector.</p> </important>', 'CreateFlow' => '<p>Creates a prompt flow that you can use to send an input through various steps to yield an output. Configure nodes, each of which corresponds to a step of the flow, and create connections between the nodes to create paths to different outputs. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html">How it works</a> and <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-create.html">Create a flow in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'CreateFlowAlias' => '<p>Creates an alias of a flow for deployment. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html">Deploy a flow in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'CreateFlowVersion' => '<p>Creates a version of the flow that you can deploy. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html">Deploy a flow in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'CreateKnowledgeBase' => '<p>Creates a knowledge base that contains data sources from which information can be queried and used by LLMs. To create a knowledge base, you must first set up your data sources and configure a supported vector store. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup.html">Set up your data for ingestion</a>.</p> <note> <p>If you prefer to let Amazon Bedrock create and manage a vector store for you in Amazon OpenSearch Service, use the console. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-create">Create a knowledge base</a>.</p> </note> <ul> <li> <p>Provide the <code>name</code> and an optional <code>description</code>.</p> </li> <li> <p>Provide the Amazon Resource Name (ARN) with permissions to create a knowledge base in the <code>roleArn</code> field.</p> </li> <li> <p>Provide the embedding model to use in the <code>embeddingModelArn</code> field in the <code>knowledgeBaseConfiguration</code> object.</p> </li> <li> <p>Provide the configuration for your vector store in the <code>storageConfiguration</code> object.</p> <ul> <li> <p>For an Amazon OpenSearch Service database, use the <code>opensearchServerlessConfiguration</code> object. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html">Create a vector store in Amazon OpenSearch Service</a>.</p> </li> <li> <p>For an Amazon Aurora database, use the <code>RdsConfiguration</code> object. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html">Create a vector store in Amazon Aurora</a>.</p> </li> <li> <p>For a Pinecone database, use the <code>pineconeConfiguration</code> object. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-pinecone.html">Create a vector store in Pinecone</a>.</p> </li> <li> <p>For a Redis Enterprise Cloud database, use the <code>redisEnterpriseCloudConfiguration</code> object. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-redis.html">Create a vector store in Redis Enterprise Cloud</a>.</p> </li> </ul> </li> </ul>', 'CreatePrompt' => '<p>Creates a prompt in your prompt library that you can add to a flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html">Prompt management in Amazon Bedrock</a>, <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html">Create a prompt using Prompt management</a> and <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows.html">Prompt flows in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'CreatePromptVersion' => '<p>Creates a static snapshot of your prompt that can be deployed to production. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-deploy.html">Deploy prompts using Prompt management by creating versions</a> in the Amazon Bedrock User Guide.</p>', 'DeleteAgent' => '<p>Deletes an agent.</p>', 'DeleteAgentActionGroup' => '<p>Deletes an action group in an agent.</p>', 'DeleteAgentAlias' => '<p>Deletes an alias of an agent.</p>', 'DeleteAgentVersion' => '<p>Deletes a version of an agent.</p>', 'DeleteDataSource' => '<p>Deletes a data source from a knowledge base.</p>', 'DeleteFlow' => '<p>Deletes a flow.</p>', 'DeleteFlowAlias' => '<p>Deletes an alias of a flow.</p>', 'DeleteFlowVersion' => '<p>Deletes a version of a flow.</p>', 'DeleteKnowledgeBase' => '<p>Deletes a knowledge base. Before deleting a knowledge base, you should disassociate the knowledge base from any agents that it is associated with by making a <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DisassociateAgentKnowledgeBase.html">DisassociateAgentKnowledgeBase</a> request.</p>', 'DeletePrompt' => '<p>Deletes a prompt or a prompt version from the Prompt management tool. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-manage.html#prompt-management-delete.html">Delete prompts from the Prompt management tool</a> and <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-deploy.html#prompt-management-versions-delete.html">Delete a version of a prompt from the Prompt management tool</a> in the Amazon Bedrock User Guide.</p>', 'DisassociateAgentKnowledgeBase' => '<p>Disassociates a knowledge base from an agent.</p>', 'GetAgent' => '<p>Gets information about an agent.</p>', 'GetAgentActionGroup' => '<p>Gets information about an action group for an agent.</p>', 'GetAgentAlias' => '<p>Gets information about an alias of an agent.</p>', 'GetAgentKnowledgeBase' => '<p>Gets information about a knowledge base associated with an agent.</p>', 'GetAgentVersion' => '<p>Gets details about a version of an agent.</p>', 'GetDataSource' => '<p>Gets information about a data source.</p>', 'GetFlow' => '<p>Retrieves information about a flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-manage.html">Manage a flow in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'GetFlowAlias' => '<p>Retrieves information about a flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html">Deploy a flow in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'GetFlowVersion' => '<p>Retrieves information about a version of a flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html">Deploy a flow in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'GetIngestionJob' => '<p>Gets information about a ingestion job, in which a data source is added to a knowledge base.</p>', 'GetKnowledgeBase' => '<p>Gets information about a knoweldge base.</p>', 'GetPrompt' => '<p>Retrieves information about a prompt or a version of it. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-manage.html#prompt-management-view.html">View information about prompts using Prompt management</a> and <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-deploy.html#prompt-management-versions-view.html">View information about a version of your prompt</a> in the Amazon Bedrock User Guide.</p>', 'ListAgentActionGroups' => '<p>Lists the action groups for an agent and information about each one.</p>', 'ListAgentAliases' => '<p>Lists the aliases of an agent and information about each one.</p>', 'ListAgentKnowledgeBases' => '<p>Lists knowledge bases associated with an agent and information about each one.</p>', 'ListAgentVersions' => '<p>Lists the versions of an agent and information about each version.</p>', 'ListAgents' => '<p>Lists the agents belonging to an account and information about each agent.</p>', 'ListDataSources' => '<p>Lists the data sources in a knowledge base and information about each one.</p>', 'ListFlowAliases' => '<p>Returns a list of aliases for a flow.</p>', 'ListFlowVersions' => '<p>Returns a list of information about each flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html">Deploy a flow in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'ListFlows' => '<p>Returns a list of flows and information about each flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-manage.html">Manage a flow in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'ListIngestionJobs' => '<p>Lists the ingestion jobs for a data source and information about each of them.</p>', 'ListKnowledgeBases' => '<p>Lists the knowledge bases in an account and information about each of them.</p>', 'ListPrompts' => '<p>Returns a list of prompts from the Prompt management tool and information about each prompt. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-manage.html#prompt-management-view.html">View information about prompts using Prompt management</a> in the Amazon Bedrock User Guide.</p>', 'ListTagsForResource' => '<p>List all the tags for the resource you specify.</p>', 'PrepareAgent' => '<p>Creates a <code>DRAFT</code> version of the agent that can be used for internal testing.</p>', 'PrepareFlow' => '<p>Prepares the <code>DRAFT</code> version of a flow so that it can be invoked. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-test.html">Test a flow in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'StartIngestionJob' => '<p>Begins an ingestion job, in which a data source is added to a knowledge base.</p>', 'TagResource' => '<p>Associate tags with a resource. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Tagging resources</a> in the Amazon Bedrock User Guide.</p>', 'UntagResource' => '<p>Remove tags from a resource.</p>', 'UpdateAgent' => '<p>Updates the configuration of an agent.</p>', 'UpdateAgentActionGroup' => '<p>Updates the configuration for an action group for an agent.</p>', 'UpdateAgentAlias' => '<p>Updates configurations for an alias of an agent.</p>', 'UpdateAgentKnowledgeBase' => '<p>Updates the configuration for a knowledge base that has been associated with an agent.</p>', 'UpdateDataSource' => '<p>Updates the configurations for a data source connector.</p> <important> <p>You can\'t change the <code>chunkingConfiguration</code> after you create the data source connector. Specify the existing <code>chunkingConfiguration</code>.</p> </important>', 'UpdateFlow' => '<p>Modifies a flow. Include both fields that you want to keep and fields that you want to change. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html">How it works</a> and <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-create.html">Create a flow in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'UpdateFlowAlias' => '<p>Modifies the alias of a flow. Include both fields that you want to keep and ones that you want to change. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html">Deploy a flow in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'UpdateKnowledgeBase' => '<p>Updates the configuration of a knowledge base with the fields that you specify. Because all fields will be overwritten, you must include the same values for fields that you want to keep the same.</p> <p>You can change the following fields:</p> <ul> <li> <p> <code>name</code> </p> </li> <li> <p> <code>description</code> </p> </li> <li> <p> <code>roleArn</code> </p> </li> </ul> <p>You can\'t change the <code>knowledgeBaseConfiguration</code> or <code>storageConfiguration</code> fields, so you must specify the same configurations as when you created the knowledge base. You can send a <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetKnowledgeBase.html">GetKnowledgeBase</a> request and copy the same configurations.</p>', 'UpdatePrompt' => '<p>Modifies a prompt in your prompt library. Include both fields that you want to keep and fields that you want to replace. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html">Prompt management in Amazon Bedrock</a> and <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-manage.html#prompt-management-edit">Edit prompts in your prompt library</a> in the Amazon Bedrock User Guide.</p>', ], 'shapes' => [ 'APISchema' => [ 'base' => '<p>Contains details about the OpenAPI schema for the action group. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI schemas</a>. You can either include the schema directly in the <code>payload</code> field or you can upload it to an S3 bucket and specify the S3 bucket location in the <code>s3</code> field.</p>', 'refs' => [ 'AgentActionGroup$apiSchema' => '<p>Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI schemas</a>.</p>', 'CreateAgentActionGroupRequest$apiSchema' => '<p>Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI schemas</a>.</p>', 'UpdateAgentActionGroupRequest$apiSchema' => '<p>Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI schemas</a>.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>The request is denied because of missing access permissions.</p>', 'refs' => [], ], 'ActionGroupExecutor' => [ 'base' => '<p>Contains details about the Lambda function containing the business logic that is carried out upon invoking the action or the custom control method for handling the information elicited from the user.</p>', 'refs' => [ 'AgentActionGroup$actionGroupExecutor' => '<p>The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon invoking the action or the custom control method for handling the information elicited from the user.</p>', 'CreateAgentActionGroupRequest$actionGroupExecutor' => '<p>The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon invoking the action or the custom control method for handling the information elicited from the user.</p>', 'UpdateAgentActionGroupRequest$actionGroupExecutor' => '<p>The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon invoking the action.</p>', ], ], 'ActionGroupSignature' => [ 'base' => NULL, 'refs' => [ 'AgentActionGroup$parentActionSignature' => '<p>If this field is set as <code>AMAZON.UserInput</code>, the agent can request the user for additional information when trying to complete a task. The <code>description</code>, <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields must be blank for this action group.</p> <p>During orchestration, if the agent determines that it needs to invoke an API in an action group, but doesn\'t have enough information to complete the API request, it will invoke this action group instead and return an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html">Observation</a> reprompting the user for more information.</p>', 'CreateAgentActionGroupRequest$parentActionGroupSignature' => '<p>To allow your agent to request the user for additional information when trying to complete a task, set this field to <code>AMAZON.UserInput</code>. You must leave the <code>description</code>, <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields blank for this action group.</p> <p>To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this field to <code>AMAZON.CodeInterpreter</code>. You must leave the <code>description</code>, <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields blank for this action group.</p> <p>During orchestration, if your agent determines that it needs to invoke an API in an action group, but doesn\'t have enough information to complete the API request, it will invoke this action group instead and return an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html">Observation</a> reprompting the user for more information.</p>', 'UpdateAgentActionGroupRequest$parentActionGroupSignature' => '<p>To allow your agent to request the user for additional information when trying to complete a task, set this field to <code>AMAZON.UserInput</code>. You must leave the <code>description</code>, <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields blank for this action group.</p> <p>During orchestration, if your agent determines that it needs to invoke an API in an action group, but doesn\'t have enough information to complete the API request, it will invoke this action group instead and return an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html">Observation</a> reprompting the user for more information.</p>', ], ], 'ActionGroupState' => [ 'base' => NULL, 'refs' => [ 'ActionGroupSummary$actionGroupState' => '<p>Specifies whether the action group is available for the agent to invoke or not when sending an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a> request.</p>', 'AgentActionGroup$actionGroupState' => '<p>Specifies whether the action group is available for the agent to invoke or not when sending an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a> request.</p>', 'CreateAgentActionGroupRequest$actionGroupState' => '<p>Specifies whether the action group is available for the agent to invoke or not when sending an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a> request.</p>', 'UpdateAgentActionGroupRequest$actionGroupState' => '<p>Specifies whether the action group is available for the agent to invoke or not when sending an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a> request.</p>', ], ], 'ActionGroupSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAgentActionGroupsResponse$actionGroupSummaries' => '<p>A list of objects, each of which contains information about an action group.</p>', ], ], 'ActionGroupSummary' => [ 'base' => '<p>Contains details about an action group.</p>', 'refs' => [ 'ActionGroupSummaries$member' => NULL, ], ], 'Agent' => [ 'base' => '<p>Contains details about an agent.</p>', 'refs' => [ 'CreateAgentResponse$agent' => '<p>Contains details about the agent created.</p>', 'GetAgentResponse$agent' => '<p>Contains details about the agent.</p>', 'UpdateAgentResponse$agent' => '<p>Contains details about the agent that was updated.</p>', ], ], 'AgentActionGroup' => [ 'base' => '<p>Contains details about an action group.</p>', 'refs' => [ 'CreateAgentActionGroupResponse$agentActionGroup' => '<p>Contains details about the action group that was created.</p>', 'GetAgentActionGroupResponse$agentActionGroup' => '<p>Contains details about the action group.</p>', 'UpdateAgentActionGroupResponse$agentActionGroup' => '<p>Contains details about the action group that was updated.</p>', ], ], 'AgentAlias' => [ 'base' => '<p>Contains details about an alias of an agent.</p>', 'refs' => [ 'CreateAgentAliasResponse$agentAlias' => '<p>Contains details about the alias that was created.</p>', 'GetAgentAliasResponse$agentAlias' => '<p>Contains information about the alias.</p>', 'UpdateAgentAliasResponse$agentAlias' => '<p>Contains details about the alias that was updated.</p>', ], ], 'AgentAliasArn' => [ 'base' => NULL, 'refs' => [ 'AgentAlias$agentAliasArn' => '<p>The Amazon Resource Name (ARN) of the alias of the agent.</p>', 'AgentFlowNodeConfiguration$agentAliasArn' => '<p>The Amazon Resource Name (ARN) of the alias of the agent to invoke.</p>', ], ], 'AgentAliasHistoryEvent' => [ 'base' => '<p>Contains details about the history of the alias.</p>', 'refs' => [ 'AgentAliasHistoryEvents$member' => NULL, ], ], 'AgentAliasHistoryEvents' => [ 'base' => NULL, 'refs' => [ 'AgentAlias$agentAliasHistoryEvents' => '<p>Contains details about the history of the alias.</p>', ], ], 'AgentAliasId' => [ 'base' => NULL, 'refs' => [ 'AgentAlias$agentAliasId' => '<p>The unique identifier of the alias of the agent.</p>', 'AgentAliasSummary$agentAliasId' => '<p>Contains details about </p>', 'DeleteAgentAliasRequest$agentAliasId' => '<p>The unique identifier of the alias to delete.</p>', 'DeleteAgentAliasResponse$agentAliasId' => '<p>The unique identifier of the alias that was deleted.</p>', 'GetAgentAliasRequest$agentAliasId' => '<p>The unique identifier of the alias for which to get information.</p>', 'UpdateAgentAliasRequest$agentAliasId' => '<p>The unique identifier of the alias.</p>', ], ], 'AgentAliasRoutingConfiguration' => [ 'base' => NULL, 'refs' => [ 'AgentAlias$routingConfiguration' => '<p>Contains details about the routing configuration of the alias.</p>', 'AgentAliasHistoryEvent$routingConfiguration' => '<p>Contains details about the version of the agent with which the alias is associated.</p>', 'AgentAliasSummary$routingConfiguration' => '<p>Contains details about the version of the agent with which the alias is associated.</p>', 'CreateAgentAliasRequest$routingConfiguration' => '<p>Contains details about the routing configuration of the alias.</p>', 'UpdateAgentAliasRequest$routingConfiguration' => '<p>Contains details about the routing configuration of the alias.</p>', ], ], 'AgentAliasRoutingConfigurationListItem' => [ 'base' => '<p>Contains details about the routing configuration of the alias.</p>', 'refs' => [ 'AgentAliasRoutingConfiguration$member' => NULL, ], ], 'AgentAliasStatus' => [ 'base' => NULL, 'refs' => [ 'AgentAlias$agentAliasStatus' => '<p>The status of the alias of the agent and whether it is ready for use. The following statuses are possible:</p> <ul> <li> <p>CREATING – The agent alias is being created.</p> </li> <li> <p>PREPARED – The agent alias is finished being created or updated and is ready to be invoked.</p> </li> <li> <p>FAILED – The agent alias API operation failed.</p> </li> <li> <p>UPDATING – The agent alias is being updated.</p> </li> <li> <p>DELETING – The agent alias is being deleted.</p> </li> </ul>', 'AgentAliasSummary$agentAliasStatus' => '<p>The status of the alias.</p>', 'DeleteAgentAliasResponse$agentAliasStatus' => '<p>The status of the alias.</p>', ], ], 'AgentAliasSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAgentAliasesResponse$agentAliasSummaries' => '<p>A list of objects, each of which contains information about an alias of the agent.</p>', ], ], 'AgentAliasSummary' => [ 'base' => '<p>Contains details about an alias of an agent.</p>', 'refs' => [ 'AgentAliasSummaries$member' => NULL, ], ], 'AgentArn' => [ 'base' => NULL, 'refs' => [ 'Agent$agentArn' => '<p>The Amazon Resource Name (ARN) of the agent.</p>', 'AgentVersion$agentArn' => '<p>The Amazon Resource Name (ARN) of the agent that the version belongs to.</p>', ], ], 'AgentFlowNodeConfiguration' => [ 'base' => '<p>Defines an agent node in your flow. You specify the agent to invoke at this point in the flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in Amazon Bedrock works</a> in the Amazon Bedrock User Guide.</p>', 'refs' => [ 'FlowNodeConfiguration$agent' => '<p>Contains configurations for an agent node in your flow. Invokes an alias of an agent and returns the response.</p>', ], ], 'AgentKnowledgeBase' => [ 'base' => '<p>Contains details about a knowledge base that is associated with an agent.</p>', 'refs' => [ 'AssociateAgentKnowledgeBaseResponse$agentKnowledgeBase' => '<p>Contains details about the knowledge base that has been associated with the agent.</p>', 'GetAgentKnowledgeBaseResponse$agentKnowledgeBase' => '<p>Contains details about a knowledge base attached to an agent.</p>', 'UpdateAgentKnowledgeBaseResponse$agentKnowledgeBase' => '<p>Contains details about the knowledge base that has been associated with an agent.</p>', ], ], 'AgentKnowledgeBaseSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAgentKnowledgeBasesResponse$agentKnowledgeBaseSummaries' => '<p>A list of objects, each of which contains information about a knowledge base associated with the agent.</p>', ], ], 'AgentKnowledgeBaseSummary' => [ 'base' => '<p>Contains details about a knowledge base associated with an agent.</p>', 'refs' => [ 'AgentKnowledgeBaseSummaries$member' => NULL, ], ], 'AgentRoleArn' => [ 'base' => NULL, 'refs' => [ 'Agent$agentResourceRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the agent.</p>', 'AgentVersion$agentResourceRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the agent.</p>', 'CreateAgentRequest$agentResourceRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the agent.</p>', 'UpdateAgentRequest$agentResourceRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the agent.</p>', ], ], 'AgentStatus' => [ 'base' => NULL, 'refs' => [ 'Agent$agentStatus' => '<p>The status of the agent and whether it is ready for use. The following statuses are possible:</p> <ul> <li> <p>CREATING – The agent is being created.</p> </li> <li> <p>PREPARING – The agent is being prepared.</p> </li> <li> <p>PREPARED – The agent is prepared and ready to be invoked.</p> </li> <li> <p>NOT_PREPARED – The agent has been created but not yet prepared.</p> </li> <li> <p>FAILED – The agent API operation failed.</p> </li> <li> <p>UPDATING – The agent is being updated.</p> </li> <li> <p>DELETING – The agent is being deleted.</p> </li> </ul>', 'AgentSummary$agentStatus' => '<p>The status of the agent.</p>', 'AgentVersion$agentStatus' => '<p>The status of the agent that the version belongs to.</p>', 'AgentVersionSummary$agentStatus' => '<p>The status of the agent to which the version belongs.</p>', 'DeleteAgentResponse$agentStatus' => '<p>The status of the agent.</p>', 'DeleteAgentVersionResponse$agentStatus' => '<p>The status of the agent version.</p>', 'PrepareAgentResponse$agentStatus' => '<p>The status of the <code>DRAFT</code> version and whether it is ready for use.</p>', ], ], 'AgentSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAgentsResponse$agentSummaries' => '<p>A list of objects, each of which contains information about an agent.</p>', ], ], 'AgentSummary' => [ 'base' => '<p>Contains details about an agent.</p>', 'refs' => [ 'AgentSummaries$member' => NULL, ], ], 'AgentVersion' => [ 'base' => '<p>Contains details about a version of an agent.</p>', 'refs' => [ 'GetAgentVersionResponse$agentVersion' => '<p>Contains details about the version of the agent.</p>', ], ], 'AgentVersionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAgentVersionsResponse$agentVersionSummaries' => '<p>A list of objects, each of which contains information about a version of the agent.</p>', ], ], 'AgentVersionSummary' => [ 'base' => '<p>Contains details about a version of an agent.</p>', 'refs' => [ 'AgentVersionSummaries$member' => NULL, ], ], 'AssociateAgentKnowledgeBaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateAgentKnowledgeBaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'BasePromptTemplate' => [ 'base' => NULL, 'refs' => [ 'PromptConfiguration$basePromptTemplate' => '<p>Defines the prompt template with which to replace the default prompt template. You can use placeholder variables in the base prompt template to customize the prompt. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html">Prompt template placeholder variables</a>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts-configure.html">Configure the prompt templates</a>.</p>', ], ], 'BedrockEmbeddingModelArn' => [ 'base' => NULL, 'refs' => [ 'VectorKnowledgeBaseConfiguration$embeddingModelArn' => '<p>The Amazon Resource Name (ARN) of the model used to create vector embeddings for the knowledge base.</p>', ], ], 'BedrockEmbeddingModelConfiguration' => [ 'base' => '<p>The vector configuration details for the Bedrock embeddings model.</p>', 'refs' => [ 'EmbeddingModelConfiguration$bedrockEmbeddingModelConfiguration' => '<p>The vector configuration details on the Bedrock embeddings model.</p>', ], ], 'BedrockFoundationModelConfiguration' => [ 'base' => '<p>Settings for a foundation model used to parse documents for a data source.</p>', 'refs' => [ 'ParsingConfiguration$bedrockFoundationModelConfiguration' => '<p>Settings for a foundation model used to parse documents for a data source.</p>', ], ], 'BedrockModelArn' => [ 'base' => NULL, 'refs' => [ 'BedrockFoundationModelConfiguration$modelArn' => '<p>The model\'s ARN.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'DeleteAgentActionGroupRequest$skipResourceInUseCheck' => '<p>By default, this value is <code>false</code> and deletion is stopped if the resource is in use. If you set it to <code>true</code>, the resource will be deleted even if the resource is in use.</p>', 'DeleteAgentRequest$skipResourceInUseCheck' => '<p>By default, this value is <code>false</code> and deletion is stopped if the resource is in use. If you set it to <code>true</code>, the resource will be deleted even if the resource is in use.</p>', 'DeleteAgentVersionRequest$skipResourceInUseCheck' => '<p>By default, this value is <code>false</code> and deletion is stopped if the resource is in use. If you set it to <code>true</code>, the resource will be deleted even if the resource is in use.</p>', 'DeleteFlowRequest$skipResourceInUseCheck' => '<p>By default, this value is <code>false</code> and deletion is stopped if the resource is in use. If you set it to <code>true</code>, the resource will be deleted even if the resource is in use.</p>', 'DeleteFlowVersionRequest$skipResourceInUseCheck' => '<p>By default, this value is <code>false</code> and deletion is stopped if the resource is in use. If you set it to <code>true</code>, the resource will be deleted even if the resource is in use.</p>', 'ParameterDetail$required' => '<p>Whether the parameter is required for the agent to complete the function for action group invocation.</p>', ], ], 'BucketOwnerAccountId' => [ 'base' => NULL, 'refs' => [ 'S3DataSourceConfiguration$bucketOwnerAccountId' => '<p>The account ID for the owner of the S3 bucket.</p>', ], ], 'ChunkingConfiguration' => [ 'base' => '<p>Details about how to chunk the documents in the data source. A <i>chunk</i> refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.</p>', 'refs' => [ 'VectorIngestionConfiguration$chunkingConfiguration' => '<p>Details about how to chunk the documents in the data source. A <i>chunk</i> refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.</p>', ], ], 'ChunkingStrategy' => [ 'base' => NULL, 'refs' => [ 'ChunkingConfiguration$chunkingStrategy' => '<p>Knowledge base can split your source data into chunks. A <i>chunk</i> refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. You have the following options for chunking your data. If you opt for <code>NONE</code>, then you may want to pre-process your files by splitting them up such that each file corresponds to a chunk.</p> <ul> <li> <p> <code>FIXED_SIZE</code> – Amazon Bedrock splits your source data into chunks of the approximate size that you set in the <code>fixedSizeChunkingConfiguration</code>.</p> </li> <li> <p> <code>HIERARCHICAL</code> – Split documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.</p> </li> <li> <p> <code>SEMANTIC</code> – Split documents into chunks based on groups of similar content derived with natural language processing.</p> </li> <li> <p> <code>NONE</code> – Amazon Bedrock treats each file as one chunk. If you choose this option, you may want to pre-process your documents by splitting them into separate files.</p> </li> </ul>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'Agent$clientToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'AgentActionGroup$clientToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'AgentAlias$clientToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'CreateAgentActionGroupRequest$clientToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'CreateAgentAliasRequest$clientToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'CreateAgentRequest$clientToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'CreateDataSourceRequest$clientToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'CreateFlowAliasRequest$clientToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'CreateFlowRequest$clientToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'CreateFlowVersionRequest$clientToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'CreateKnowledgeBaseRequest$clientToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'CreatePromptRequest$clientToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'CreatePromptVersionRequest$clientToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'StartIngestionJobRequest$clientToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', ], ], 'CollectorFlowNodeConfiguration' => [ 'base' => '<p>Defines a collector node in your flow. This node takes an iteration of inputs and consolidates them into an array in the output. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in Amazon Bedrock works</a> in the Amazon Bedrock User Guide.</p>', 'refs' => [ 'FlowNodeConfiguration$collector' => '<p>Contains configurations for a collector node in your flow. Collects an iteration of inputs and consolidates them into an array of outputs.</p>', ], ], 'ColumnName' => [ 'base' => NULL, 'refs' => [ 'RdsFieldMapping$metadataField' => '<p>The name of the field in which Amazon Bedrock stores metadata about the vector store.</p>', 'RdsFieldMapping$primaryKeyField' => '<p>The name of the field in which Amazon Bedrock stores the ID for each entry.</p>', 'RdsFieldMapping$textField' => '<p>The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.</p>', 'RdsFieldMapping$vectorField' => '<p>The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.</p>', ], ], 'ConditionFlowNodeConfiguration' => [ 'base' => '<p>Defines a condition node in your flow. You can specify conditions that determine which node comes next in the flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in Amazon Bedrock works</a> in the Amazon Bedrock User Guide.</p>', 'refs' => [ 'FlowNodeConfiguration$condition' => '<p>Contains configurations for a Condition node in your flow. Defines conditions that lead to different branches of the flow.</p>', ], ], 'ConflictException' => [ 'base' => '<p>There was a conflict performing an operation.</p>', 'refs' => [], ], 'ConfluenceAuthType' => [ 'base' => NULL, 'refs' => [ 'ConfluenceSourceConfiguration$authType' => '<p>The supported authentication type to authenticate and connect to your Confluence instance.</p>', ], ], 'ConfluenceCrawlerConfiguration' => [ 'base' => '<p>The configuration of the Confluence content. For example, configuring specific types of Confluence content.</p>', 'refs' => [ 'ConfluenceDataSourceConfiguration$crawlerConfiguration' => '<p>The configuration of the Confluence content. For example, configuring specific types of Confluence content.</p>', ], ], 'ConfluenceDataSourceConfiguration' => [ 'base' => '<p>The configuration information to connect to Confluence as your data source.</p>', 'refs' => [ 'DataSourceConfiguration$confluenceConfiguration' => '<p>The configuration information to connect to Confluence as your data source.</p> <note> <p>Confluence data source connector is in preview release and is subject to change.</p> </note>', ], ], 'ConfluenceHostType' => [ 'base' => NULL, 'refs' => [ 'ConfluenceSourceConfiguration$hostType' => '<p>The supported host type, whether online/cloud or server/on-premises.</p>', ], ], 'ConfluenceSourceConfiguration' => [ 'base' => '<p>The endpoint information to connect to your Confluence data source.</p>', 'refs' => [ 'ConfluenceDataSourceConfiguration$sourceConfiguration' => '<p>The endpoint information to connect to your Confluence data source.</p>', ], ], 'CrawlFilterConfiguration' => [ 'base' => '<p>The configuration of filtering the data source content. For example, configuring regular expression patterns to include or exclude certain content.</p>', 'refs' => [ 'ConfluenceCrawlerConfiguration$filterConfiguration' => '<p>The configuration of filtering the Confluence content. For example, configuring regular expression patterns to include or exclude certain content.</p>', 'SalesforceCrawlerConfiguration$filterConfiguration' => '<p>The configuration of filtering the Salesforce content. For example, configuring regular expression patterns to include or exclude certain content.</p>', 'SharePointCrawlerConfiguration$filterConfiguration' => '<p>The configuration of filtering the SharePoint content. For example, configuring regular expression patterns to include or exclude certain content.</p>', ], ], 'CrawlFilterConfigurationType' => [ 'base' => NULL, 'refs' => [ 'CrawlFilterConfiguration$type' => '<p>The type of filtering that you want to apply to certain objects or content of the data source. For example, the <code>PATTERN</code> type is regular expression patterns you can apply to filter your content.</p>', ], ], 'CreateAgentActionGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAgentActionGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAgentAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAgentAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAgentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAgentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateKnowledgeBaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateKnowledgeBaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePromptRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePromptResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePromptVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePromptVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreationMode' => [ 'base' => NULL, 'refs' => [ 'PromptConfiguration$parserMode' => '<p>Specifies whether to override the default parser Lambda function when parsing the raw foundation model output in the part of the agent sequence defined by the <code>promptType</code>. If you set the field as <code>OVERRIDEN</code>, the <code>overrideLambda</code> field in the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html">PromptOverrideConfiguration</a> must be specified with the ARN of a Lambda function.</p>', 'PromptConfiguration$promptCreationMode' => '<p>Specifies whether to override the default prompt template for this <code>promptType</code>. Set this value to <code>OVERRIDDEN</code> to use the prompt that you provide in the <code>basePromptTemplate</code>. If you leave it as <code>DEFAULT</code>, the agent uses a default prompt template.</p>', ], ], 'CustomControlMethod' => [ 'base' => NULL, 'refs' => [ 'ActionGroupExecutor$customControl' => '<p>To return the action group invocation results directly in the <code>InvokeAgent</code> response, specify <code>RETURN_CONTROL</code>.</p>', ], ], 'CustomTransformationConfiguration' => [ 'base' => '<p>Settings for customizing steps in the data source content ingestion pipeline.</p> <p>You can configure the data source to process documents with a Lambda function after they are parsed and converted into chunks. When you add a post-chunking transformation, the service stores chunked documents in an S3 bucket and invokes a Lambda function to process them.</p> <p>To process chunked documents with a Lambda function, define an S3 bucket path for input and output objects, and a transformation that specifies the Lambda function to invoke. You can use the Lambda function to customize how chunks are split, and the metadata for each chunk. </p>', 'refs' => [ 'VectorIngestionConfiguration$customTransformationConfiguration' => '<p>A custom document transformer for parsed data source documents.</p>', ], ], 'DataDeletionPolicy' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$dataDeletionPolicy' => '<p>The data deletion policy for the data source.</p> <p>You can set the data deletion policy to:</p> <ul> <li> <p>DELETE: Deletes all underlying data belonging to the data source from the vector store upon deletion of a knowledge base or data source resource. Note that the vector store itself is not deleted, only the underlying data. This flag is ignored if an Amazon Web Services account is deleted.</p> </li> <li> <p>RETAIN: Retains all underlying data in your vector store upon deletion of a knowledge base or data source resource.</p> </li> </ul>', 'DataSource$dataDeletionPolicy' => '<p>The data deletion policy for the data source.</p>', 'UpdateDataSourceRequest$dataDeletionPolicy' => '<p>The data deletion policy for the data source that you want to update.</p>', ], ], 'DataSource' => [ 'base' => '<p>Contains details about a data source.</p>', 'refs' => [ 'CreateDataSourceResponse$dataSource' => '<p>Contains details about the data source.</p>', 'GetDataSourceResponse$dataSource' => '<p>Contains details about the data source.</p>', 'UpdateDataSourceResponse$dataSource' => '<p>Contains details about the data source.</p>', ], ], 'DataSourceConfiguration' => [ 'base' => '<p>The connection configuration for the data source.</p>', 'refs' => [ 'CreateDataSourceRequest$dataSourceConfiguration' => '<p>The connection configuration for the data source.</p>', 'DataSource$dataSourceConfiguration' => '<p>The connection configuration for the data source.</p>', 'UpdateDataSourceRequest$dataSourceConfiguration' => '<p>The connection configuration for the data source that you want to update.</p>', ], ], 'DataSourceStatus' => [ 'base' => NULL, 'refs' => [ 'DataSource$status' => '<p>The status of the data source. The following statuses are possible:</p> <ul> <li> <p>Available – The data source has been created and is ready for ingestion into the knowledge base.</p> </li> <li> <p>Deleting – The data source is being deleted.</p> </li> </ul>', 'DataSourceSummary$status' => '<p>The status of the data source.</p>', 'DeleteDataSourceResponse$status' => '<p>The status of the data source.</p>', ], ], 'DataSourceSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDataSourcesResponse$dataSourceSummaries' => '<p>A list of objects, each of which contains information about a data source.</p>', ], ], 'DataSourceSummary' => [ 'base' => '<p>Contains details about a data source.</p>', 'refs' => [ 'DataSourceSummaries$member' => NULL, ], ], 'DataSourceType' => [ 'base' => NULL, 'refs' => [ 'DataSourceConfiguration$type' => '<p>The type of data source.</p>', ], ], 'DateTimestamp' => [ 'base' => NULL, 'refs' => [ 'ActionGroupSummary$updatedAt' => '<p>The time at which the action group was last updated.</p>', 'Agent$createdAt' => '<p>The time at which the agent was created.</p>', 'Agent$preparedAt' => '<p>The time at which the agent was last prepared.</p>', 'Agent$updatedAt' => '<p>The time at which the agent was last updated.</p>', 'AgentActionGroup$createdAt' => '<p>The time at which the action group was created.</p>', 'AgentActionGroup$updatedAt' => '<p>The time at which the action group was last updated.</p>', 'AgentAlias$createdAt' => '<p>The time at which the alias of the agent was created.</p>', 'AgentAlias$updatedAt' => '<p>The time at which the alias was last updated.</p>', 'AgentAliasHistoryEvent$endDate' => '<p>The date that the alias stopped being associated to the version in the <code>routingConfiguration</code> object</p>', 'AgentAliasHistoryEvent$startDate' => '<p>The date that the alias began being associated to the version in the <code>routingConfiguration</code> object.</p>', 'AgentAliasSummary$createdAt' => '<p>The time at which the alias of the agent was created.</p>', 'AgentAliasSummary$updatedAt' => '<p>The time at which the alias was last updated.</p>', 'AgentKnowledgeBase$createdAt' => '<p>The time at which the association between the agent and the knowledge base was created.</p>', 'AgentKnowledgeBase$updatedAt' => '<p>The time at which the association between the agent and the knowledge base was last updated.</p>', 'AgentKnowledgeBaseSummary$updatedAt' => '<p>The time at which the knowledge base associated with an agent was last updated.</p>', 'AgentSummary$updatedAt' => '<p>The time at which the agent was last updated.</p>', 'AgentVersion$createdAt' => '<p>The time at which the version was created.</p>', 'AgentVersion$updatedAt' => '<p>The time at which the version was last updated.</p>', 'AgentVersionSummary$createdAt' => '<p>The time at which the version was created.</p>', 'AgentVersionSummary$updatedAt' => '<p>The time at which the version was last updated.</p>', 'CreateFlowAliasResponse$createdAt' => '<p>The time at which the alias was created.</p>', 'CreateFlowAliasResponse$updatedAt' => '<p>The time at which the alias of the flow was last updated.</p>', 'CreateFlowResponse$createdAt' => '<p>The time at which the flow was created.</p>', 'CreateFlowResponse$updatedAt' => '<p>The time at which the flow was last updated.</p>', 'CreateFlowVersionResponse$createdAt' => '<p>The time at which the flow was created.</p>', 'CreatePromptResponse$createdAt' => '<p>The time at which the prompt was created.</p>', 'CreatePromptResponse$updatedAt' => '<p>The time at which the prompt was last updated.</p>', 'CreatePromptVersionResponse$createdAt' => '<p>The time at which the prompt was created.</p>', 'CreatePromptVersionResponse$updatedAt' => '<p>The time at which the prompt was last updated.</p>', 'DataSource$createdAt' => '<p>The time at which the data source was created.</p>', 'DataSource$updatedAt' => '<p>The time at which the data source was last updated.</p>', 'DataSourceSummary$updatedAt' => '<p>The time at which the data source was last updated.</p>', 'FlowAliasSummary$createdAt' => '<p>The time at which the alias was created.</p>', 'FlowAliasSummary$updatedAt' => '<p>The time at which the alias was last updated.</p>', 'FlowSummary$createdAt' => '<p>The time at which the flow was created.</p>', 'FlowSummary$updatedAt' => '<p>The time at which the flow was last updated.</p>', 'FlowVersionSummary$createdAt' => '<p>The time at the flow version was created.</p>', 'GetFlowAliasResponse$createdAt' => '<p>The time at which the flow was created.</p>', 'GetFlowAliasResponse$updatedAt' => '<p>The time at which the flow alias was last updated.</p>', 'GetFlowResponse$createdAt' => '<p>The time at which the flow was created.</p>', 'GetFlowResponse$updatedAt' => '<p>The time at which the flow was last updated.</p>', 'GetFlowVersionResponse$createdAt' => '<p>The time at which the flow was created.</p>', 'GetPromptResponse$createdAt' => '<p>The time at which the prompt was created.</p>', 'GetPromptResponse$updatedAt' => '<p>The time at which the prompt was last updated.</p>', 'IngestionJob$startedAt' => '<p>The time at which the ingestion job started.</p>', 'IngestionJob$updatedAt' => '<p>The time at which the ingestion job was last updated.</p>', 'IngestionJobSummary$startedAt' => '<p>The time at which the ingestion job was started.</p>', 'IngestionJobSummary$updatedAt' => '<p>The time at which the ingestion job was last updated.</p>', 'KnowledgeBase$createdAt' => '<p>The time at which the knowledge base was created.</p>', 'KnowledgeBase$updatedAt' => '<p>The time at which the knowledge base was last updated.</p>', 'KnowledgeBaseSummary$updatedAt' => '<p>The time at which the knowledge base was last updated.</p>', 'PrepareAgentResponse$preparedAt' => '<p>The time at which the <code>DRAFT</code> version of the agent was last prepared.</p>', 'PromptSummary$createdAt' => '<p>The time at which the prompt was created.</p>', 'PromptSummary$updatedAt' => '<p>The time at which the prompt was last updated.</p>', 'UpdateFlowAliasResponse$createdAt' => '<p>The time at which the flow was created.</p>', 'UpdateFlowAliasResponse$updatedAt' => '<p>The time at which the flow alias was last updated.</p>', 'UpdateFlowResponse$createdAt' => '<p>The time at which the flow was created.</p>', 'UpdateFlowResponse$updatedAt' => '<p>The time at which the flow was last updated.</p>', 'UpdatePromptResponse$createdAt' => '<p>The time at which the prompt was created.</p>', 'UpdatePromptResponse$updatedAt' => '<p>The time at which the prompt was last updated.</p>', ], ], 'DeleteAgentActionGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAgentActionGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAgentAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAgentAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAgentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAgentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAgentVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAgentVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKnowledgeBaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKnowledgeBaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePromptRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePromptResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'ActionGroupSummary$description' => '<p>The description of the action group.</p>', 'Agent$description' => '<p>The description of the agent.</p>', 'AgentActionGroup$description' => '<p>The description of the action group.</p>', 'AgentAlias$description' => '<p>The description of the alias of the agent.</p>', 'AgentAliasSummary$description' => '<p>The description of the alias.</p>', 'AgentKnowledgeBase$description' => '<p>The description of the association between the agent and the knowledge base.</p>', 'AgentKnowledgeBaseSummary$description' => '<p>The description of the knowledge base associated with an agent.</p>', 'AgentSummary$description' => '<p>The description of the agent.</p>', 'AgentVersion$description' => '<p>The description of the version.</p>', 'AgentVersionSummary$description' => '<p>The description of the version of the agent.</p>', 'AssociateAgentKnowledgeBaseRequest$description' => '<p>A description of what the agent should use the knowledge base for.</p>', 'CreateAgentActionGroupRequest$description' => '<p>A description of the action group.</p>', 'CreateAgentAliasRequest$description' => '<p>A description of the alias of the agent.</p>', 'CreateAgentRequest$description' => '<p>A description of the agent.</p>', 'CreateDataSourceRequest$description' => '<p>A description of the data source.</p>', 'CreateFlowAliasRequest$description' => '<p>A description for the alias.</p>', 'CreateFlowAliasResponse$description' => '<p>The description of the alias.</p>', 'CreateKnowledgeBaseRequest$description' => '<p>A description of the knowledge base.</p>', 'DataSource$description' => '<p>The description of the data source.</p>', 'DataSourceSummary$description' => '<p>The description of the data source.</p>', 'FlowAliasSummary$description' => '<p>A description of the alias.</p>', 'GetFlowAliasResponse$description' => '<p>The description of the flow.</p>', 'IngestionJob$description' => '<p>The description of the ingestion job.</p>', 'IngestionJobSummary$description' => '<p>The description of the ingestion job.</p>', 'KnowledgeBase$description' => '<p>The description of the knowledge base.</p>', 'KnowledgeBaseSummary$description' => '<p>The description of the knowledge base.</p>', 'StartIngestionJobRequest$description' => '<p>A description of the ingestion job.</p>', 'UpdateAgentActionGroupRequest$description' => '<p>Specifies a new name for the action group.</p>', 'UpdateAgentAliasRequest$description' => '<p>Specifies a new description for the alias.</p>', 'UpdateAgentKnowledgeBaseRequest$description' => '<p>Specifies a new description for the knowledge base associated with an agent.</p>', 'UpdateAgentRequest$description' => '<p>Specifies a new description of the agent.</p>', 'UpdateDataSourceRequest$description' => '<p>Specifies a new description for the data source.</p>', 'UpdateFlowAliasRequest$description' => '<p>A description for the flow alias.</p>', 'UpdateFlowAliasResponse$description' => '<p>The description of the flow.</p>', 'UpdateKnowledgeBaseRequest$description' => '<p>Specifies a new description for the knowledge base.</p>', ], ], 'Dimensions' => [ 'base' => NULL, 'refs' => [ 'BedrockEmbeddingModelConfiguration$dimensions' => '<p>The dimensions details for the vector configuration used on the Bedrock embeddings model.</p>', ], ], 'DisassociateAgentKnowledgeBaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateAgentKnowledgeBaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'DraftVersion' => [ 'base' => NULL, 'refs' => [ 'Agent$agentVersion' => '<p>The version of the agent.</p>', 'AssociateAgentKnowledgeBaseRequest$agentVersion' => '<p>The version of the agent with which you want to associate the knowledge base.</p>', 'CreateAgentActionGroupRequest$agentVersion' => '<p>The version of the agent for which to create the action group.</p>', 'CreateFlowResponse$version' => '<p>The version of the flow. When you create a flow, the version created is the <code>DRAFT</code> version.</p>', 'DeleteAgentActionGroupRequest$agentVersion' => '<p>The version of the agent that the action group belongs to.</p>', 'DisassociateAgentKnowledgeBaseRequest$agentVersion' => '<p>The version of the agent from which to disassociate the knowledge base.</p>', 'FlowSummary$version' => '<p>The latest version of the flow.</p>', 'GetFlowResponse$version' => '<p>The version of the flow for which information was retrieved.</p>', 'UpdateAgentActionGroupRequest$agentVersion' => '<p>The unique identifier of the agent version for which to update the action group.</p>', 'UpdateAgentKnowledgeBaseRequest$agentVersion' => '<p>The version of the agent associated with the knowledge base that you want to update.</p>', 'UpdateFlowResponse$version' => '<p>The version of the flow. When you update a flow, the version updated is the <code>DRAFT</code> version.</p>', ], ], 'EmbeddingModelConfiguration' => [ 'base' => '<p>The configuration details for the embeddings model.</p>', 'refs' => [ 'VectorKnowledgeBaseConfiguration$embeddingModelConfiguration' => '<p>The embeddings model configuration details for the vector model used in Knowledge Base.</p>', ], ], 'EnabledMemoryTypes' => [ 'base' => NULL, 'refs' => [ 'MemoryConfiguration$enabledMemoryTypes' => '<p>The type of memory that is stored. </p>', ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'FailureReasons$member' => NULL, ], ], 'FailureReasons' => [ 'base' => NULL, 'refs' => [ 'Agent$failureReasons' => '<p>Contains reasons that the agent-related API that you invoked failed.</p>', 'AgentAlias$failureReasons' => '<p>Information on the failure of Provisioned Throughput assigned to an agent alias.</p>', 'AgentVersion$failureReasons' => '<p>A list of reasons that the API operation on the version failed.</p>', 'DataSource$failureReasons' => '<p>The detailed reasons on the failure to delete a data source.</p>', 'IngestionJob$failureReasons' => '<p>A list of reasons that the ingestion job failed.</p>', 'KnowledgeBase$failureReasons' => '<p>A list of reasons that the API operation on the knowledge base failed.</p>', ], ], 'FieldName' => [ 'base' => NULL, 'refs' => [ 'MongoDbAtlasFieldMapping$metadataField' => '<p>The name of the field in which Amazon Bedrock stores metadata about the vector store.</p>', 'MongoDbAtlasFieldMapping$textField' => '<p>The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.</p>', 'MongoDbAtlasFieldMapping$vectorField' => '<p>The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.</p>', 'OpenSearchServerlessFieldMapping$metadataField' => '<p>The name of the field in which Amazon Bedrock stores metadata about the vector store.</p>', 'OpenSearchServerlessFieldMapping$textField' => '<p>The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.</p>', 'OpenSearchServerlessFieldMapping$vectorField' => '<p>The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.</p>', 'PineconeFieldMapping$metadataField' => '<p>The name of the field in which Amazon Bedrock stores metadata about the vector store.</p>', 'PineconeFieldMapping$textField' => '<p>The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.</p>', 'RedisEnterpriseCloudFieldMapping$metadataField' => '<p>The name of the field in which Amazon Bedrock stores metadata about the vector store.</p>', 'RedisEnterpriseCloudFieldMapping$textField' => '<p>The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.</p>', 'RedisEnterpriseCloudFieldMapping$vectorField' => '<p>The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.</p>', ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'PatternObjectFilter$exclusionFilters' => '<p>A list of one or more exclusion regular expression patterns to exclude certain object types that adhere to the pattern. If you specify an inclusion and exclusion filter/pattern and both match a document, the exclusion filter takes precedence and the document isn’t crawled.</p>', 'PatternObjectFilter$inclusionFilters' => '<p>A list of one or more inclusion regular expression patterns to include certain object types that adhere to the pattern. If you specify an inclusion and exclusion filter/pattern and both match a document, the exclusion filter takes precedence and the document isn’t crawled.</p>', 'WebCrawlerConfiguration$exclusionFilters' => '<p>A list of one or more exclusion regular expression patterns to exclude certain URLs. If you specify an inclusion and exclusion filter/pattern and both match a URL, the exclusion filter takes precedence and the web content of the URL isn’t crawled.</p>', 'WebCrawlerConfiguration$inclusionFilters' => '<p>A list of one or more inclusion regular expression patterns to include certain URLs. If you specify an inclusion and exclusion filter/pattern and both match a URL, the exclusion filter takes precedence and the web content of the URL isn’t crawled.</p>', ], ], 'FilterPattern' => [ 'base' => NULL, 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilteredObjectType' => [ 'base' => NULL, 'refs' => [ 'PatternObjectFilter$objectType' => '<p>The supported object type or content type of the data source.</p>', ], ], 'FixedSizeChunkingConfiguration' => [ 'base' => '<p>Configurations for when you choose fixed-size chunking. If you set the <code>chunkingStrategy</code> as <code>NONE</code>, exclude this field.</p>', 'refs' => [ 'ChunkingConfiguration$fixedSizeChunkingConfiguration' => '<p>Configurations for when you choose fixed-size chunking. If you set the <code>chunkingStrategy</code> as <code>NONE</code>, exclude this field.</p>', ], ], 'FixedSizeChunkingConfigurationMaxTokensInteger' => [ 'base' => NULL, 'refs' => [ 'FixedSizeChunkingConfiguration$maxTokens' => '<p>The maximum number of tokens to include in a chunk.</p>', ], ], 'FixedSizeChunkingConfigurationOverlapPercentageInteger' => [ 'base' => NULL, 'refs' => [ 'FixedSizeChunkingConfiguration$overlapPercentage' => '<p>The percentage of overlap between adjacent chunks of a data source.</p>', ], ], 'FlowAliasArn' => [ 'base' => NULL, 'refs' => [ 'CreateFlowAliasResponse$arn' => '<p>The Amazon Resource Name (ARN) of the alias.</p>', 'FlowAliasSummary$arn' => '<p>The Amazon Resource Name (ARN) of the flow alias.</p>', 'GetFlowAliasResponse$arn' => '<p>The Amazon Resource Name (ARN) of the flow.</p>', 'UpdateFlowAliasResponse$arn' => '<p>The Amazon Resource Name (ARN) of the flow.</p>', ], ], 'FlowAliasId' => [ 'base' => NULL, 'refs' => [ 'CreateFlowAliasResponse$id' => '<p>The unique identifier of the alias.</p>', 'DeleteFlowAliasResponse$id' => '<p>The unique identifier of the flow.</p>', 'FlowAliasSummary$id' => '<p>The unique identifier of the alias of the flow.</p>', 'GetFlowAliasResponse$id' => '<p>The unique identifier of the alias of the flow.</p>', 'UpdateFlowAliasResponse$id' => '<p>The unique identifier of the alias.</p>', ], ], 'FlowAliasIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteFlowAliasRequest$aliasIdentifier' => '<p>The unique identifier of the alias to be deleted.</p>', 'GetFlowAliasRequest$aliasIdentifier' => '<p>The unique identifier of the alias for which to retrieve information.</p>', 'UpdateFlowAliasRequest$aliasIdentifier' => '<p>The unique identifier of the alias.</p>', ], ], 'FlowAliasRoutingConfiguration' => [ 'base' => NULL, 'refs' => [ 'CreateFlowAliasRequest$routingConfiguration' => '<p>Contains information about the version to which to map the alias.</p>', 'CreateFlowAliasResponse$routingConfiguration' => '<p>Contains information about the version that the alias is mapped to.</p>', 'FlowAliasSummary$routingConfiguration' => '<p>A list of configurations about the versions that the alias maps to. Currently, you can only specify one.</p>', 'GetFlowAliasResponse$routingConfiguration' => '<p>Contains information about the version that the alias is mapped to.</p>', 'UpdateFlowAliasRequest$routingConfiguration' => '<p>Contains information about the version to which to map the alias.</p>', 'UpdateFlowAliasResponse$routingConfiguration' => '<p>Contains information about the version that the alias is mapped to.</p>', ], ], 'FlowAliasRoutingConfigurationListItem' => [ 'base' => '<p>Contains information about a version that the alias maps to.</p>', 'refs' => [ 'FlowAliasRoutingConfiguration$member' => NULL, ], ], 'FlowAliasSummaries' => [ 'base' => NULL, 'refs' => [ 'ListFlowAliasesResponse$flowAliasSummaries' => '<p>A list, each member of which contains information about a flow alias.</p>', ], ], 'FlowAliasSummary' => [ 'base' => '<p>Contains information about an alias of a flow.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListFlowAliases.html#API_agent_ListFlowAliases_ResponseSyntax">ListFlowAliases response</a> </p> </li> </ul>', 'refs' => [ 'FlowAliasSummaries$member' => NULL, ], ], 'FlowArn' => [ 'base' => NULL, 'refs' => [ 'CreateFlowResponse$arn' => '<p>The Amazon Resource Name (ARN) of the flow.</p>', 'CreateFlowVersionResponse$arn' => '<p>The Amazon Resource Name (ARN) of the flow.</p>', 'FlowSummary$arn' => '<p>The Amazon Resource Name (ARN) of the flow.</p>', 'FlowVersionSummary$arn' => '<p>The Amazon Resource Name (ARN) of the flow that the version belongs to.</p>', 'GetFlowResponse$arn' => '<p>The Amazon Resource Name (ARN) of the flow.</p>', 'GetFlowVersionResponse$arn' => '<p>The Amazon Resource Name (ARN) of the flow.</p>', 'UpdateFlowResponse$arn' => '<p>The Amazon Resource Name (ARN) of the flow.</p>', ], ], 'FlowCondition' => [ 'base' => '<p>Defines a condition in the condition node.</p>', 'refs' => [ 'FlowConditions$member' => NULL, ], ], 'FlowConditionExpression' => [ 'base' => NULL, 'refs' => [ 'FlowCondition$expression' => '<p>Defines the condition. You must refer to at least one of the inputs in the condition. For more information, expand the Condition node section in <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html#flows-nodes">Node types in prompt flows</a>.</p>', ], ], 'FlowConditionName' => [ 'base' => NULL, 'refs' => [ 'FlowCondition$name' => '<p>A name for the condition that you can reference.</p>', 'FlowConditionalConnectionConfiguration$condition' => '<p>The condition that triggers this connection. For more information about how to write conditions, see the <b>Condition</b> node type in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/node-types.html">Node types</a> topic in the Amazon Bedrock User Guide.</p>', ], ], 'FlowConditionalConnectionConfiguration' => [ 'base' => '<p>The configuration of a connection between a condition node and another node.</p>', 'refs' => [ 'FlowConnectionConfiguration$conditional' => '<p>The configuration of a connection originating from a Condition node.</p>', ], ], 'FlowConditions' => [ 'base' => NULL, 'refs' => [ 'ConditionFlowNodeConfiguration$conditions' => '<p>An array of conditions. Each member contains the name of a condition and an expression that defines the condition.</p>', ], ], 'FlowConnection' => [ 'base' => '<p>Contains information about a connection between two nodes in the flow.</p>', 'refs' => [ 'FlowConnections$member' => NULL, ], ], 'FlowConnectionConfiguration' => [ 'base' => '<p>The configuration of the connection.</p>', 'refs' => [ 'FlowConnection$configuration' => '<p>The configuration of the connection.</p>', ], ], 'FlowConnectionName' => [ 'base' => NULL, 'refs' => [ 'FlowConnection$name' => '<p>A name for the connection that you can reference.</p>', ], ], 'FlowConnectionType' => [ 'base' => NULL, 'refs' => [ 'FlowConnection$type' => '<p>Whether the source node that the connection begins from is a condition node (<code>Conditional</code>) or not (<code>Data</code>).</p>', ], ], 'FlowConnections' => [ 'base' => NULL, 'refs' => [ 'FlowDefinition$connections' => '<p>An array of connection definitions in the flow.</p>', ], ], 'FlowDataConnectionConfiguration' => [ 'base' => '<p>The configuration of a connection originating from a node that isn\'t a Condition node.</p>', 'refs' => [ 'FlowConnectionConfiguration$data' => '<p>The configuration of a connection originating from a node that isn\'t a Condition node.</p>', ], ], 'FlowDefinition' => [ 'base' => '<p>The definition of the nodes and connections between nodes in the flow.</p>', 'refs' => [ 'CreateFlowRequest$definition' => '<p>A definition of the nodes and connections between nodes in the flow.</p>', 'CreateFlowResponse$definition' => '<p>A definition of the nodes and connections between nodes in the flow.</p>', 'CreateFlowVersionResponse$definition' => '<p>A definition of the nodes and connections in the flow.</p>', 'GetFlowResponse$definition' => '<p>The definition of the nodes and connections between the nodes in the flow.</p>', 'GetFlowVersionResponse$definition' => '<p>The definition of the nodes and connections between nodes in the flow.</p>', 'UpdateFlowRequest$definition' => '<p>A definition of the nodes and the connections between the nodes in the flow.</p>', 'UpdateFlowResponse$definition' => '<p>A definition of the nodes and the connections between nodes in the flow.</p>', ], ], 'FlowDescription' => [ 'base' => NULL, 'refs' => [ 'CreateFlowRequest$description' => '<p>A description for the flow.</p>', 'CreateFlowResponse$description' => '<p>The description of the flow.</p>', 'CreateFlowVersionRequest$description' => '<p>A description of the version of the flow.</p>', 'CreateFlowVersionResponse$description' => '<p>The description of the flow version.</p>', 'FlowSummary$description' => '<p>A description of the flow.</p>', 'GetFlowResponse$description' => '<p>The description of the flow.</p>', 'GetFlowVersionResponse$description' => '<p>The description of the flow.</p>', 'UpdateFlowRequest$description' => '<p>A description for the flow.</p>', 'UpdateFlowResponse$description' => '<p>The description of the flow.</p>', ], ], 'FlowExecutionRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateFlowRequest$executionRoleArn' => '<p>The Amazon Resource Name (ARN) of the service role with permissions to create and manage a flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html">Create a service role for flows in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'CreateFlowResponse$executionRoleArn' => '<p>The Amazon Resource Name (ARN) of the service role with permissions to create a flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html">Create a service role for flows in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'CreateFlowVersionResponse$executionRoleArn' => '<p>The Amazon Resource Name (ARN) of the service role with permissions to create a flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html">Create a service role for flows in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'GetFlowResponse$executionRoleArn' => '<p>The Amazon Resource Name (ARN) of the service role with permissions to create a flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html">Create a service row for flows</a> in the Amazon Bedrock User Guide.</p>', 'GetFlowVersionResponse$executionRoleArn' => '<p>The Amazon Resource Name (ARN) of the service role with permissions to create a flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html">Create a service role for flows in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'UpdateFlowRequest$executionRoleArn' => '<p>The Amazon Resource Name (ARN) of the service role with permissions to create and manage a flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html">Create a service role for flows in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', 'UpdateFlowResponse$executionRoleArn' => '<p>The Amazon Resource Name (ARN) of the service role with permissions to create a flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html">Create a service role for flows in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p>', ], ], 'FlowId' => [ 'base' => NULL, 'refs' => [ 'CreateFlowAliasResponse$flowId' => '<p>The unique identifier of the flow that the alias belongs to.</p>', 'CreateFlowResponse$id' => '<p>The unique identifier of the flow.</p>', 'CreateFlowVersionResponse$id' => '<p>The unique identifier of the flow.</p>', 'DeleteFlowAliasResponse$flowId' => '<p>The unique identifier of the flow that the alias belongs to.</p>', 'DeleteFlowResponse$id' => '<p>The unique identifier of the flow.</p>', 'FlowAliasSummary$flowId' => '<p>The unique identifier of the flow.</p>', 'FlowSummary$id' => '<p>The unique identifier of the flow.</p>', 'FlowVersionSummary$id' => '<p>The unique identifier of the flow.</p>', 'GetFlowAliasResponse$flowId' => '<p>The unique identifier of the flow that the alias belongs to.</p>', 'GetFlowResponse$id' => '<p>The unique identifier of the flow.</p>', 'GetFlowVersionResponse$id' => '<p>The unique identifier of the flow.</p>', 'PrepareFlowResponse$id' => '<p>The unique identifier of the flow.</p>', 'UpdateFlowAliasResponse$flowId' => '<p>The unique identifier of the flow.</p>', 'UpdateFlowResponse$id' => '<p>The unique identifier of the flow.</p>', ], ], 'FlowIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateFlowAliasRequest$flowIdentifier' => '<p>The unique identifier of the flow for which to create an alias.</p>', 'CreateFlowVersionRequest$flowIdentifier' => '<p>The unique identifier of the flow that you want to create a version of.</p>', 'DeleteFlowAliasRequest$flowIdentifier' => '<p>The unique identifier of the flow that the alias belongs to.</p>', 'DeleteFlowRequest$flowIdentifier' => '<p>The unique identifier of the flow.</p>', 'DeleteFlowVersionRequest$flowIdentifier' => '<p>The unique identifier of the flow whose version that you want to delete</p>', 'GetFlowAliasRequest$flowIdentifier' => '<p>The unique identifier of the flow that the alias belongs to.</p>', 'GetFlowRequest$flowIdentifier' => '<p>The unique identifier of the flow.</p>', 'GetFlowVersionRequest$flowIdentifier' => '<p>The unique identifier of the flow for which to get information.</p>', 'ListFlowAliasesRequest$flowIdentifier' => '<p>The unique identifier of the flow for which aliases are being returned.</p>', 'ListFlowVersionsRequest$flowIdentifier' => '<p>The unique identifier of the flow.</p>', 'PrepareFlowRequest$flowIdentifier' => '<p>The unique identifier of the flow.</p>', 'UpdateFlowAliasRequest$flowIdentifier' => '<p>The unique identifier of the flow.</p>', 'UpdateFlowRequest$flowIdentifier' => '<p>The unique identifier of the flow.</p>', ], ], 'FlowName' => [ 'base' => NULL, 'refs' => [ 'CreateFlowRequest$name' => '<p>A name for the flow.</p>', 'CreateFlowResponse$name' => '<p>The name of the flow.</p>', 'CreateFlowVersionResponse$name' => '<p>The name of the flow version.</p>', 'FlowSummary$name' => '<p>The name of the flow.</p>', 'GetFlowResponse$name' => '<p>The name of the flow.</p>', 'GetFlowVersionResponse$name' => '<p>The name of the flow version.</p>', 'UpdateFlowRequest$name' => '<p>A name for the flow.</p>', 'UpdateFlowResponse$name' => '<p>The name of the flow.</p>', ], ], 'FlowNode' => [ 'base' => '<p>Contains configurations about a node in the flow.</p>', 'refs' => [ 'FlowNodes$member' => NULL, ], ], 'FlowNodeConfiguration' => [ 'base' => '<p>Contains configurations for a node in your flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in Amazon Bedrock works</a> in the Amazon Bedrock User Guide.</p>', 'refs' => [ 'FlowNode$configuration' => '<p>Contains configurations for the node.</p>', ], ], 'FlowNodeIODataType' => [ 'base' => NULL, 'refs' => [ 'FlowNodeInput$type' => '<p>The data type of the input. If the input doesn\'t match this type at runtime, a validation error will be thrown.</p>', 'FlowNodeOutput$type' => '<p>The data type of the output. If the output doesn\'t match this type at runtime, a validation error will be thrown.</p>', ], ], 'FlowNodeInput' => [ 'base' => '<p>Contains configurations for an input to a node.</p>', 'refs' => [ 'FlowNodeInputs$member' => NULL, ], ], 'FlowNodeInputExpression' => [ 'base' => NULL, 'refs' => [ 'FlowNodeInput$expression' => '<p>An expression that formats the input for the node. For an explanation of how to create expressions, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-expressions.html">Expressions in Prompt flows in Amazon Bedrock</a>.</p>', ], ], 'FlowNodeInputName' => [ 'base' => NULL, 'refs' => [ 'FlowDataConnectionConfiguration$targetInput' => '<p>The name of the input in the target node that the connection ends at.</p>', 'FlowNodeInput$name' => '<p>A name for the input that you can reference.</p>', ], ], 'FlowNodeInputs' => [ 'base' => NULL, 'refs' => [ 'FlowNode$inputs' => '<p>An array of objects, each of which contains information about an input into the node.</p>', ], ], 'FlowNodeName' => [ 'base' => NULL, 'refs' => [ 'FlowConnection$source' => '<p>The node that the connection starts at.</p>', 'FlowConnection$target' => '<p>The node that the connection ends at.</p>', 'FlowNode$name' => '<p>A name for the node.</p>', ], ], 'FlowNodeOutput' => [ 'base' => '<p>Contains configurations for an output from a node.</p>', 'refs' => [ 'FlowNodeOutputs$member' => NULL, ], ], 'FlowNodeOutputName' => [ 'base' => NULL, 'refs' => [ 'FlowDataConnectionConfiguration$sourceOutput' => '<p>The name of the output in the source node that the connection begins from.</p>', 'FlowNodeOutput$name' => '<p>A name for the output that you can reference.</p>', ], ], 'FlowNodeOutputs' => [ 'base' => NULL, 'refs' => [ 'FlowNode$outputs' => '<p>A list of objects, each of which contains information about an output from the node.</p>', ], ], 'FlowNodeType' => [ 'base' => NULL, 'refs' => [ 'FlowNode$type' => '<p>The type of node. This value must match the name of the key that you provide in the configuration you provide in the <code>FlowNodeConfiguration</code> field.</p>', ], ], 'FlowNodes' => [ 'base' => NULL, 'refs' => [ 'FlowDefinition$nodes' => '<p>An array of node definitions in the flow.</p>', ], ], 'FlowStatus' => [ 'base' => NULL, 'refs' => [ 'CreateFlowResponse$status' => '<p>The status of the flow. When you submit this request, the status will be <code>NotPrepared</code>. If creation fails, the status becomes <code>Failed</code>.</p>', 'CreateFlowVersionResponse$status' => '<p>The status of the flow.</p>', 'FlowSummary$status' => '<p>The status of the flow. The following statuses are possible:</p> <ul> <li> <p>NotPrepared – The flow has been created or updated, but hasn\'t been prepared. If you just created the flow, you can\'t test it. If you updated the flow, the <code>DRAFT</code> version won\'t contain the latest changes for testing. Send a <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html">PrepareFlow</a> request to package the latest changes into the <code>DRAFT</code> version.</p> </li> <li> <p>Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest changes for testing.</p> </li> <li> <p>Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for testing.</p> </li> <li> <p>Failed – The last API operation that you invoked on the flow failed. Send a <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a> request and check the error message in the <code>validations</code> field.</p> </li> </ul>', 'FlowVersionSummary$status' => '<p>The status of the flow.</p>', 'GetFlowResponse$status' => '<p>The status of the flow. The following statuses are possible:</p> <ul> <li> <p>NotPrepared – The flow has been created or updated, but hasn\'t been prepared. If you just created the flow, you can\'t test it. If you updated the flow, the <code>DRAFT</code> version won\'t contain the latest changes for testing. Send a <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html">PrepareFlow</a> request to package the latest changes into the <code>DRAFT</code> version.</p> </li> <li> <p>Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest changes for testing.</p> </li> <li> <p>Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for testing.</p> </li> <li> <p>Failed – The last API operation that you invoked on the flow failed. Send a <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a> request and check the error message in the <code>validations</code> field.</p> </li> </ul>', 'GetFlowVersionResponse$status' => '<p>The status of the flow.</p>', 'PrepareFlowResponse$status' => '<p>The status of the flow. When you submit this request, the status will be <code>NotPrepared</code>. If preparation succeeds, the status becomes <code>Prepared</code>. If it fails, the status becomes <code>FAILED</code>.</p>', 'UpdateFlowResponse$status' => '<p>The status of the flow. When you submit this request, the status will be <code>NotPrepared</code>. If updating fails, the status becomes <code>Failed</code>.</p>', ], ], 'FlowSummaries' => [ 'base' => NULL, 'refs' => [ 'ListFlowsResponse$flowSummaries' => '<p>A list, each member of which contains information about a flow.</p>', ], ], 'FlowSummary' => [ 'base' => '<p>Contains the definition of a flow.</p>', 'refs' => [ 'FlowSummaries$member' => NULL, ], ], 'FlowValidation' => [ 'base' => '<p>Contains information about validation of the flow.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html#API_agent_GetFlow_ResponseSyntax">GetFlow response</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlowVersion.html#API_agent_GetFlowVersion_ResponseSyntax">GetFlowVersion response</a> </p> </li> </ul>', 'refs' => [ 'FlowValidations$member' => NULL, ], ], 'FlowValidationSeverity' => [ 'base' => NULL, 'refs' => [ 'FlowValidation$severity' => '<p>The severity of the issue described in the message.</p>', ], ], 'FlowValidations' => [ 'base' => NULL, 'refs' => [ 'GetFlowResponse$validations' => '<p>A list of validation error messages related to the last failed operation on the flow.</p>', ], ], 'FlowVersionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListFlowVersionsResponse$flowVersionSummaries' => '<p>A list, each member of which contains information about a flow.</p>', ], ], 'FlowVersionSummary' => [ 'base' => '<p>Contains information about the flow version.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListFlowVersions.html#API_agent_ListFlowVersions_ResponseSyntax">ListFlowVersions response</a> </p> </li> </ul>', 'refs' => [ 'FlowVersionSummaries$member' => NULL, ], ], 'Function' => [ 'base' => '<p>Defines parameters that the agent needs to invoke from the user to complete the function. Corresponds to an action in an action group.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_RequestSyntax">CreateAgentActionGroup request</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_ResponseSyntax">CreateAgentActionGroup response</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_RequestSyntax">UpdateAgentActionGroup request</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_ResponseSyntax">UpdateAgentActionGroup response</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentActionGroup.html#API_agent_GetAgentActionGroup_ResponseSyntax">GetAgentActionGroup response</a> </p> </li> </ul>', 'refs' => [ 'Functions$member' => NULL, ], ], 'FunctionDescription' => [ 'base' => NULL, 'refs' => [ 'Function$description' => '<p>A description of the function and its purpose.</p>', ], ], 'FunctionSchema' => [ 'base' => '<p>Defines functions that each define parameters that the agent needs to invoke from the user. Each function represents an action in an action group.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_RequestSyntax">CreateAgentActionGroup request</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_ResponseSyntax">CreateAgentActionGroup response</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_RequestSyntax">UpdateAgentActionGroup request</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_ResponseSyntax">UpdateAgentActionGroup response</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentActionGroup.html#API_agent_GetAgentActionGroup_ResponseSyntax">GetAgentActionGroup response</a> </p> </li> </ul>', 'refs' => [ 'AgentActionGroup$functionSchema' => '<p>Defines functions that each define parameters that the agent needs to invoke from the user. Each function represents an action in an action group.</p>', 'CreateAgentActionGroupRequest$functionSchema' => '<p>Contains details about the function schema for the action group or the JSON or YAML-formatted payload defining the schema.</p>', 'UpdateAgentActionGroupRequest$functionSchema' => '<p>Contains details about the function schema for the action group or the JSON or YAML-formatted payload defining the schema.</p>', ], ], 'Functions' => [ 'base' => NULL, 'refs' => [ 'FunctionSchema$functions' => '<p>A list of functions that each define an action in the action group.</p>', ], ], 'GetAgentActionGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAgentActionGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAgentAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAgentAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAgentKnowledgeBaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAgentKnowledgeBaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAgentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAgentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAgentVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAgentVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFlowAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFlowAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFlowVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFlowVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIngestionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIngestionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetKnowledgeBaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKnowledgeBaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPromptRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPromptResponse' => [ 'base' => NULL, 'refs' => [], ], 'GuardrailConfiguration' => [ 'base' => '<p>Details about the guardrail associated with an agent.</p>', 'refs' => [ 'Agent$guardrailConfiguration' => '<p>Details about the guardrail associated with the agent.</p>', 'AgentSummary$guardrailConfiguration' => '<p>Details about the guardrail associated with the agent.</p>', 'AgentVersion$guardrailConfiguration' => '<p>Details about the guardrail associated with the agent.</p>', 'AgentVersionSummary$guardrailConfiguration' => '<p>Details about the guardrail associated with the agent.</p>', 'CreateAgentRequest$guardrailConfiguration' => '<p>The unique Guardrail configuration assigned to the agent when it is created.</p>', 'UpdateAgentRequest$guardrailConfiguration' => '<p>The unique Guardrail configuration assigned to the agent when it is updated.</p>', ], ], 'GuardrailIdentifier' => [ 'base' => NULL, 'refs' => [ 'GuardrailConfiguration$guardrailIdentifier' => '<p>The unique identifier of the guardrail.</p>', ], ], 'GuardrailVersion' => [ 'base' => NULL, 'refs' => [ 'GuardrailConfiguration$guardrailVersion' => '<p>The version of the guardrail.</p>', ], ], 'HierarchicalChunkingConfiguration' => [ 'base' => '<p>Settings for hierarchical document chunking for a data source. Hierarchical chunking splits documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.</p> <p>You configure the number of tokens to overlap, or repeat across adjacent chunks. For example, if you set overlap tokens to 60, the last 60 tokens in the first chunk are also included at the beginning of the second chunk. For each layer, you must also configure the maximum number of tokens in a chunk.</p>', 'refs' => [ 'ChunkingConfiguration$hierarchicalChunkingConfiguration' => '<p>Settings for hierarchical document chunking for a data source. Hierarchical chunking splits documents into layers of chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the first layer.</p>', ], ], 'HierarchicalChunkingConfigurationOverlapTokensInteger' => [ 'base' => NULL, 'refs' => [ 'HierarchicalChunkingConfiguration$overlapTokens' => '<p>The number of tokens to repeat across chunks in the same layer.</p>', ], ], 'HierarchicalChunkingLevelConfiguration' => [ 'base' => '<p>Token settings for a layer in a hierarchical chunking configuration.</p>', 'refs' => [ 'HierarchicalChunkingLevelConfigurations$member' => NULL, ], ], 'HierarchicalChunkingLevelConfigurationMaxTokensInteger' => [ 'base' => NULL, 'refs' => [ 'HierarchicalChunkingLevelConfiguration$maxTokens' => '<p>The maximum number of tokens that a chunk can contain in this layer.</p>', ], ], 'HierarchicalChunkingLevelConfigurations' => [ 'base' => NULL, 'refs' => [ 'HierarchicalChunkingConfiguration$levelConfigurations' => '<p>Token settings for each layer.</p>', ], ], 'HttpsUrl' => [ 'base' => NULL, 'refs' => [ 'ConfluenceSourceConfiguration$hostUrl' => '<p>The Confluence host URL or instance URL.</p>', 'SalesforceSourceConfiguration$hostUrl' => '<p>The Salesforce host URL or instance URL.</p>', 'SharePointSiteUrls$member' => NULL, ], ], 'Id' => [ 'base' => NULL, 'refs' => [ 'ActionGroupSummary$actionGroupId' => '<p>The unique identifier of the action group.</p>', 'Agent$agentId' => '<p>The unique identifier of the agent.</p>', 'AgentActionGroup$actionGroupId' => '<p>The unique identifier of the action group.</p>', 'AgentActionGroup$agentId' => '<p>The unique identifier of the agent to which the action group belongs.</p>', 'AgentAlias$agentId' => '<p>The unique identifier of the agent.</p>', 'AgentKnowledgeBase$agentId' => '<p>The unique identifier of the agent with which the knowledge base is associated.</p>', 'AgentKnowledgeBase$knowledgeBaseId' => '<p>The unique identifier of the association between the agent and the knowledge base.</p>', 'AgentKnowledgeBaseSummary$knowledgeBaseId' => '<p>The unique identifier of the knowledge base associated with an agent.</p>', 'AgentSummary$agentId' => '<p>The unique identifier of the agent.</p>', 'AgentVersion$agentId' => '<p>The unique identifier of the agent that the version belongs to.</p>', 'AssociateAgentKnowledgeBaseRequest$agentId' => '<p>The unique identifier of the agent with which you want to associate the knowledge base.</p>', 'AssociateAgentKnowledgeBaseRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base to associate with the agent.</p>', 'CreateAgentActionGroupRequest$agentId' => '<p>The unique identifier of the agent for which to create the action group.</p>', 'CreateAgentAliasRequest$agentId' => '<p>The unique identifier of the agent.</p>', 'CreateDataSourceRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base to which to add the data source.</p>', 'DataSource$dataSourceId' => '<p>The unique identifier of the data source.</p>', 'DataSource$knowledgeBaseId' => '<p>The unique identifier of the knowledge base to which the data source belongs.</p>', 'DataSourceSummary$dataSourceId' => '<p>The unique identifier of the data source.</p>', 'DataSourceSummary$knowledgeBaseId' => '<p>The unique identifier of the knowledge base to which the data source belongs.</p>', 'DeleteAgentActionGroupRequest$actionGroupId' => '<p>The unique identifier of the action group to delete.</p>', 'DeleteAgentActionGroupRequest$agentId' => '<p>The unique identifier of the agent that the action group belongs to.</p>', 'DeleteAgentAliasRequest$agentId' => '<p>The unique identifier of the agent that the alias belongs to.</p>', 'DeleteAgentAliasResponse$agentId' => '<p>The unique identifier of the agent that the alias belongs to.</p>', 'DeleteAgentRequest$agentId' => '<p>The unique identifier of the agent to delete.</p>', 'DeleteAgentResponse$agentId' => '<p>The unique identifier of the agent that was deleted.</p>', 'DeleteAgentVersionRequest$agentId' => '<p>The unique identifier of the agent that the version belongs to.</p>', 'DeleteAgentVersionResponse$agentId' => '<p>The unique identifier of the agent that the version belongs to.</p>', 'DeleteDataSourceRequest$dataSourceId' => '<p>The unique identifier of the data source to delete.</p>', 'DeleteDataSourceRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base from which to delete the data source.</p>', 'DeleteDataSourceResponse$dataSourceId' => '<p>The unique identifier of the data source that was deleted.</p>', 'DeleteDataSourceResponse$knowledgeBaseId' => '<p>The unique identifier of the knowledge base to which the data source that was deleted belonged.</p>', 'DeleteFlowVersionResponse$id' => '<p>The unique identifier of the flow.</p>', 'DeleteKnowledgeBaseRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base to delete.</p>', 'DeleteKnowledgeBaseResponse$knowledgeBaseId' => '<p>The unique identifier of the knowledge base that was deleted.</p>', 'DisassociateAgentKnowledgeBaseRequest$agentId' => '<p>The unique identifier of the agent from which to disassociate the knowledge base.</p>', 'DisassociateAgentKnowledgeBaseRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base to disassociate.</p>', 'GetAgentActionGroupRequest$actionGroupId' => '<p>The unique identifier of the action group for which to get information.</p>', 'GetAgentActionGroupRequest$agentId' => '<p>The unique identifier of the agent that the action group belongs to.</p>', 'GetAgentAliasRequest$agentId' => '<p>The unique identifier of the agent to which the alias to get information belongs.</p>', 'GetAgentKnowledgeBaseRequest$agentId' => '<p>The unique identifier of the agent with which the knowledge base is associated.</p>', 'GetAgentKnowledgeBaseRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base associated with the agent.</p>', 'GetAgentRequest$agentId' => '<p>The unique identifier of the agent.</p>', 'GetAgentVersionRequest$agentId' => '<p>The unique identifier of the agent.</p>', 'GetDataSourceRequest$dataSourceId' => '<p>The unique identifier of the data source.</p>', 'GetDataSourceRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base that the data source was added to.</p>', 'GetIngestionJobRequest$dataSourceId' => '<p>The unique identifier of the data source in the ingestion job.</p>', 'GetIngestionJobRequest$ingestionJobId' => '<p>The unique identifier of the ingestion job.</p>', 'GetIngestionJobRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base for which the ingestion job applies.</p>', 'GetKnowledgeBaseRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base for which to get information.</p>', 'IngestionJob$dataSourceId' => '<p>The unique identifier of the ingested data source.</p>', 'IngestionJob$ingestionJobId' => '<p>The unique identifier of the ingestion job.</p>', 'IngestionJob$knowledgeBaseId' => '<p>The unique identifier of the knowledge base to which the data source is being added.</p>', 'IngestionJobSummary$dataSourceId' => '<p>The unique identifier of the data source in the ingestion job.</p>', 'IngestionJobSummary$ingestionJobId' => '<p>The unique identifier of the ingestion job.</p>', 'IngestionJobSummary$knowledgeBaseId' => '<p>The unique identifier of the knowledge base to which the data source is added.</p>', 'KnowledgeBase$knowledgeBaseId' => '<p>The unique identifier of the knowledge base.</p>', 'KnowledgeBaseSummary$knowledgeBaseId' => '<p>The unique identifier of the knowledge base.</p>', 'ListAgentActionGroupsRequest$agentId' => '<p>The unique identifier of the agent.</p>', 'ListAgentAliasesRequest$agentId' => '<p>The unique identifier of the agent.</p>', 'ListAgentKnowledgeBasesRequest$agentId' => '<p>The unique identifier of the agent for which to return information about knowledge bases associated with it.</p>', 'ListAgentVersionsRequest$agentId' => '<p>The unique identifier of the agent.</p>', 'ListDataSourcesRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base for which to return a list of information.</p>', 'ListIngestionJobsRequest$dataSourceId' => '<p>The unique identifier of the data source for which to return ingestion jobs.</p>', 'ListIngestionJobsRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base for which to return ingestion jobs.</p>', 'PrepareAgentRequest$agentId' => '<p>The unique identifier of the agent for which to create a <code>DRAFT</code> version.</p>', 'PrepareAgentResponse$agentId' => '<p>The unique identifier of the agent for which the <code>DRAFT</code> version was created.</p>', 'StartIngestionJobRequest$dataSourceId' => '<p>The unique identifier of the data source to ingest.</p>', 'StartIngestionJobRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base to which to add the data source.</p>', 'UpdateAgentActionGroupRequest$actionGroupId' => '<p>The unique identifier of the action group.</p>', 'UpdateAgentActionGroupRequest$agentId' => '<p>The unique identifier of the agent for which to update the action group.</p>', 'UpdateAgentAliasRequest$agentId' => '<p>The unique identifier of the agent.</p>', 'UpdateAgentKnowledgeBaseRequest$agentId' => '<p>The unique identifier of the agent associated with the knowledge base that you want to update.</p>', 'UpdateAgentKnowledgeBaseRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base that has been associated with an agent.</p>', 'UpdateAgentRequest$agentId' => '<p>The unique identifier of the agent.</p>', 'UpdateDataSourceRequest$dataSourceId' => '<p>The unique identifier of the data source.</p>', 'UpdateDataSourceRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base for the data source.</p>', 'UpdateKnowledgeBaseRequest$knowledgeBaseId' => '<p>The unique identifier of the knowledge base to update.</p>', ], ], 'InferenceConfiguration' => [ 'base' => '<p>Contains inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the <code>promptType</code>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>', 'refs' => [ 'PromptConfiguration$inferenceConfiguration' => '<p>Contains inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the <code>promptType</code>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p>', ], ], 'IngestionJob' => [ 'base' => '<p>Contains details about an ingestion job, which converts a data source to embeddings for a vector store in knowledge base.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_StartIngestionJob.html#API_agent_StartIngestionJob_ResponseSyntax">StartIngestionJob response</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetIngestionJob.html#API_agent_GetIngestionJob_ResponseSyntax">GetIngestionJob response</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListIngestionJobs.html#API_agent_ListIngestionJobs_ResponseSyntax">ListIngestionJob response</a> </p> </li> </ul>', 'refs' => [ 'GetIngestionJobResponse$ingestionJob' => '<p>Contains details about the ingestion job.</p>', 'StartIngestionJobResponse$ingestionJob' => '<p>An object containing information about the ingestion job.</p>', ], ], 'IngestionJobFilter' => [ 'base' => '<p>Defines a filter by which to filter the results.</p>', 'refs' => [ 'IngestionJobFilters$member' => NULL, ], ], 'IngestionJobFilterAttribute' => [ 'base' => NULL, 'refs' => [ 'IngestionJobFilter$attribute' => '<p>The attribute by which to filter the results.</p>', ], ], 'IngestionJobFilterOperator' => [ 'base' => NULL, 'refs' => [ 'IngestionJobFilter$operator' => '<p>The operation to carry out between the attribute and the values.</p>', ], ], 'IngestionJobFilterValue' => [ 'base' => NULL, 'refs' => [ 'IngestionJobFilterValues$member' => NULL, ], ], 'IngestionJobFilterValues' => [ 'base' => NULL, 'refs' => [ 'IngestionJobFilter$values' => '<p>A list of values for the attribute.</p>', ], ], 'IngestionJobFilters' => [ 'base' => NULL, 'refs' => [ 'ListIngestionJobsRequest$filters' => '<p>Contains a definition of a filter for which to filter the results.</p>', ], ], 'IngestionJobSortBy' => [ 'base' => '<p>Parameters by which to sort the results.</p>', 'refs' => [ 'ListIngestionJobsRequest$sortBy' => '<p>Contains details about how to sort the results.</p>', ], ], 'IngestionJobSortByAttribute' => [ 'base' => NULL, 'refs' => [ 'IngestionJobSortBy$attribute' => '<p>The attribute by which to sort the results.</p>', ], ], 'IngestionJobStatistics' => [ 'base' => '<p>Contains the statistics for the ingestion job.</p>', 'refs' => [ 'IngestionJob$statistics' => '<p>Contains statistics about the ingestion job.</p>', 'IngestionJobSummary$statistics' => '<p>Contains statistics for the ingestion job.</p>', ], ], 'IngestionJobStatus' => [ 'base' => NULL, 'refs' => [ 'IngestionJob$status' => '<p>The status of the ingestion job.</p>', 'IngestionJobSummary$status' => '<p>The status of the ingestion job.</p>', ], ], 'IngestionJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListIngestionJobsResponse$ingestionJobSummaries' => '<p>A list of objects, each of which contains information about an ingestion job.</p>', ], ], 'IngestionJobSummary' => [ 'base' => '<p>Contains details about an ingestion job.</p>', 'refs' => [ 'IngestionJobSummaries$member' => NULL, ], ], 'InputFlowNodeConfiguration' => [ 'base' => '<p>Contains configurations for the input flow node for a flow. This node takes the input from flow invocation and passes it to the next node in the data type that you specify.</p>', 'refs' => [ 'FlowNodeConfiguration$input' => '<p>Contains configurations for an input flow node in your flow. The first node in the flow. <code>inputs</code> can\'t be specified for this node.</p>', ], ], 'Instruction' => [ 'base' => NULL, 'refs' => [ 'Agent$instruction' => '<p>Instructions that tell the agent what it should do and how it should interact with users.</p>', 'AgentVersion$instruction' => '<p>The instructions provided to the agent.</p>', 'CreateAgentRequest$instruction' => '<p>Instructions that tell the agent what it should do and how it should interact with users.</p>', 'UpdateAgentRequest$instruction' => '<p>Specifies new instructions that tell the agent what it should do and how it should interact with users.</p>', ], ], 'IntermediateStorage' => [ 'base' => '<p>A location for storing content from data sources temporarily as it is processed by custom components in the ingestion pipeline.</p>', 'refs' => [ 'CustomTransformationConfiguration$intermediateStorage' => '<p>An S3 bucket path for input and output objects.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal server error occurred. Retry your request.</p>', 'refs' => [], ], 'IteratorFlowNodeConfiguration' => [ 'base' => '<p>Contains configurations for an iterator node in a flow. Takes an input that is an array and iteratively sends each item of the array as an output to the following node. The size of the array is also returned in the output.</p> <p>The output flow node at the end of the flow iteration will return a response for each member of the array. To return only one response, you can include a collector node downstream from the iterator node.</p>', 'refs' => [ 'FlowNodeConfiguration$iterator' => '<p>Contains configurations for an iterator node in your flow. Takes an input that is an array and iteratively sends each item of the array as an output to the following node. The size of the array is also returned in the output.</p> <p>The output flow node at the end of the flow iteration will return a response for each member of the array. To return only one response, you can include a collector node downstream from the iterator node.</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'Agent$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key that encrypts the agent.</p>', 'AgentVersion$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key that encrypts the agent.</p>', 'CreateAgentRequest$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key with which to encrypt the agent.</p>', 'CreateFlowRequest$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key to encrypt the flow.</p>', 'CreateFlowResponse$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key that you encrypted the flow with.</p>', 'CreateFlowVersionResponse$customerEncryptionKeyArn' => '<p>The KMS key that the flow is encrypted with.</p>', 'CreatePromptRequest$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key to encrypt the prompt.</p>', 'CreatePromptResponse$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key that you encrypted the prompt with.</p>', 'CreatePromptVersionResponse$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key to encrypt the version of the prompt.</p>', 'GetFlowResponse$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key that the flow is encrypted with.</p>', 'GetFlowVersionResponse$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key that the version of the flow is encrypted with.</p>', 'GetPromptResponse$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key that the prompt is encrypted with.</p>', 'ServerSideEncryptionConfiguration$kmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key used to encrypt the resource.</p>', 'UpdateAgentRequest$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key with which to encrypt the agent.</p>', 'UpdateFlowRequest$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key to encrypt the flow.</p>', 'UpdateFlowResponse$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key that the flow was encrypted with.</p>', 'UpdatePromptRequest$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key to encrypt the prompt.</p>', 'UpdatePromptResponse$customerEncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key to encrypt the prompt.</p>', ], ], 'KnowledgeBase' => [ 'base' => '<p>Contains information about a knowledge base.</p>', 'refs' => [ 'CreateKnowledgeBaseResponse$knowledgeBase' => '<p>Contains details about the knowledge base.</p>', 'GetKnowledgeBaseResponse$knowledgeBase' => '<p>Contains details about the knowledge base.</p>', 'UpdateKnowledgeBaseResponse$knowledgeBase' => '<p>Contains details about the knowledge base.</p>', ], ], 'KnowledgeBaseArn' => [ 'base' => NULL, 'refs' => [ 'KnowledgeBase$knowledgeBaseArn' => '<p>The Amazon Resource Name (ARN) of the knowledge base.</p>', ], ], 'KnowledgeBaseConfiguration' => [ 'base' => '<p>Contains details about the embeddings configuration of the knowledge base.</p>', 'refs' => [ 'CreateKnowledgeBaseRequest$knowledgeBaseConfiguration' => '<p>Contains details about the embeddings model used for the knowledge base.</p>', 'KnowledgeBase$knowledgeBaseConfiguration' => '<p>Contains details about the embeddings configuration of the knowledge base.</p>', 'UpdateKnowledgeBaseRequest$knowledgeBaseConfiguration' => '<p>Specifies the configuration for the embeddings model used for the knowledge base. You must use the same configuration as when the knowledge base was created.</p>', ], ], 'KnowledgeBaseFlowNodeConfiguration' => [ 'base' => '<p>Contains configurations for a knowledge base node in a flow. This node takes a query as the input and returns, as the output, the retrieved responses directly (as an array) or a response generated based on the retrieved responses. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in Amazon Bedrock works</a> in the Amazon Bedrock User Guide.</p>', 'refs' => [ 'FlowNodeConfiguration$knowledgeBase' => '<p>Contains configurations for a knowledge base node in your flow. Queries a knowledge base and returns the retrieved results or generated response.</p>', ], ], 'KnowledgeBaseId' => [ 'base' => NULL, 'refs' => [ 'KnowledgeBaseFlowNodeConfiguration$knowledgeBaseId' => '<p>The unique identifier of the knowledge base to query.</p>', ], ], 'KnowledgeBaseRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateKnowledgeBaseRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base.</p>', 'KnowledgeBase$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base.</p>', 'UpdateKnowledgeBaseRequest$roleArn' => '<p>Specifies a different Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base.</p>', ], ], 'KnowledgeBaseState' => [ 'base' => NULL, 'refs' => [ 'AgentKnowledgeBase$knowledgeBaseState' => '<p>Specifies whether to use the knowledge base or not when sending an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a> request.</p>', 'AgentKnowledgeBaseSummary$knowledgeBaseState' => '<p>Specifies whether the agent uses the knowledge base or not when sending an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a> request.</p>', 'AssociateAgentKnowledgeBaseRequest$knowledgeBaseState' => '<p>Specifies whether to use the knowledge base or not when sending an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a> request.</p>', 'UpdateAgentKnowledgeBaseRequest$knowledgeBaseState' => '<p>Specifies whether the agent uses the knowledge base or not when sending an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a> request.</p>', ], ], 'KnowledgeBaseStatus' => [ 'base' => NULL, 'refs' => [ 'DeleteKnowledgeBaseResponse$status' => '<p>The status of the knowledge base and whether it has been successfully deleted.</p>', 'KnowledgeBase$status' => '<p>The status of the knowledge base. The following statuses are possible:</p> <ul> <li> <p>CREATING – The knowledge base is being created.</p> </li> <li> <p>ACTIVE – The knowledge base is ready to be queried.</p> </li> <li> <p>DELETING – The knowledge base is being deleted.</p> </li> <li> <p>UPDATING – The knowledge base is being updated.</p> </li> <li> <p>FAILED – The knowledge base API operation failed.</p> </li> </ul>', 'KnowledgeBaseSummary$status' => '<p>The status of the knowledge base.</p>', ], ], 'KnowledgeBaseStorageType' => [ 'base' => NULL, 'refs' => [ 'StorageConfiguration$type' => '<p>The vector store service in which the knowledge base is stored.</p>', ], ], 'KnowledgeBaseSummaries' => [ 'base' => NULL, 'refs' => [ 'ListKnowledgeBasesResponse$knowledgeBaseSummaries' => '<p>A list of objects, each of which contains information about a knowledge base.</p>', ], ], 'KnowledgeBaseSummary' => [ 'base' => '<p>Contains details about a knowledge base.</p>', 'refs' => [ 'KnowledgeBaseSummaries$member' => NULL, ], ], 'KnowledgeBaseType' => [ 'base' => NULL, 'refs' => [ 'KnowledgeBaseConfiguration$type' => '<p>The type of data that the data source is converted into for the knowledge base.</p>', ], ], 'LambdaArn' => [ 'base' => NULL, 'refs' => [ 'ActionGroupExecutor$lambda' => '<p>The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon invoking the action.</p>', 'LambdaFunctionFlowNodeConfiguration$lambdaArn' => '<p>The Amazon Resource Name (ARN) of the Lambda function to invoke.</p>', 'PromptOverrideConfiguration$overrideLambda' => '<p>The ARN of the Lambda function to use when parsing the raw foundation model output in parts of the agent sequence. If you specify this field, at least one of the <code>promptConfigurations</code> must contain a <code>parserMode</code> value that is set to <code>OVERRIDDEN</code>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/lambda-parser.html">Parser Lambda function in Agents for Amazon Bedrock</a>.</p>', 'TransformationLambdaConfiguration$lambdaArn' => '<p>The function\'s ARN identifier.</p>', ], ], 'LambdaFunctionFlowNodeConfiguration' => [ 'base' => '<p>Contains configurations for a Lambda function node in the flow. You specify the Lambda function to invoke and the inputs into the function. The output is the response that is defined in the Lambda function. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in Amazon Bedrock works</a> in the Amazon Bedrock User Guide.</p>', 'refs' => [ 'FlowNodeConfiguration$lambdaFunction' => '<p>Contains configurations for a Lambda function node in your flow. Invokes an Lambda function.</p>', ], ], 'LexBotAliasArn' => [ 'base' => NULL, 'refs' => [ 'LexFlowNodeConfiguration$botAliasArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Lex bot alias to invoke.</p>', ], ], 'LexBotLocaleId' => [ 'base' => NULL, 'refs' => [ 'LexFlowNodeConfiguration$localeId' => '<p>The Region to invoke the Amazon Lex bot in.</p>', ], ], 'LexFlowNodeConfiguration' => [ 'base' => '<p>Contains configurations for a Lex node in the flow. You specify a Amazon Lex bot to invoke. This node takes an utterance as the input and returns as the output the intent identified by the Amazon Lex bot. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in Amazon Bedrock works</a> in the Amazon Bedrock User Guide.</p>', 'refs' => [ 'FlowNodeConfiguration$lex' => '<p>Contains configurations for a Lex node in your flow. Invokes an Amazon Lex bot to identify the intent of the input and return the intent as the output.</p>', ], ], 'ListAgentActionGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAgentActionGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAgentAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAgentAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAgentKnowledgeBasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAgentKnowledgeBasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAgentVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAgentVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAgentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAgentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFlowAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFlowAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFlowVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFlowVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFlowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFlowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIngestionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIngestionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListKnowledgeBasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKnowledgeBasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPromptsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPromptsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAgentActionGroupsRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListAgentAliasesRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListAgentKnowledgeBasesRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListAgentVersionsRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListAgentsRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListDataSourcesRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListFlowAliasesRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListFlowVersionsRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListFlowsRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListIngestionJobsRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListKnowledgeBasesRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListPromptsRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', ], ], 'MaximumLength' => [ 'base' => NULL, 'refs' => [ 'InferenceConfiguration$maximumLength' => '<p>The maximum number of tokens to allow in the generated response.</p>', 'PromptModelInferenceConfiguration$maxTokens' => '<p>The maximum number of tokens to return in the response.</p>', ], ], 'MemoryConfiguration' => [ 'base' => '<p>Details of the memory configuration.</p>', 'refs' => [ 'Agent$memoryConfiguration' => '<p>Contains memory configuration for the agent.</p>', 'AgentVersion$memoryConfiguration' => '<p> Contains details of the memory configuration on the version of the agent. </p>', 'CreateAgentRequest$memoryConfiguration' => '<p> Contains the details of the memory configured for the agent.</p>', 'UpdateAgentRequest$memoryConfiguration' => '<p>Specifies the new memory configuration for the agent. </p>', ], ], 'MemoryType' => [ 'base' => NULL, 'refs' => [ 'EnabledMemoryTypes$member' => NULL, ], ], 'Microsoft365TenantId' => [ 'base' => NULL, 'refs' => [ 'SharePointSourceConfiguration$tenantId' => '<p>The identifier of your Microsoft 365 tenant.</p>', ], ], 'ModelIdentifier' => [ 'base' => NULL, 'refs' => [ 'Agent$foundationModel' => '<p>The foundation model used for orchestration by the agent.</p>', 'AgentVersion$foundationModel' => '<p>The foundation model that the version invokes.</p>', 'CreateAgentRequest$foundationModel' => '<p>The foundation model to be used for orchestration by the agent you create.</p>', 'KnowledgeBaseFlowNodeConfiguration$modelId' => '<p>The unique identifier of the model to use to generate a response from the query results. Omit this field if you want to return the retrieved results as an array.</p>', 'UpdateAgentRequest$foundationModel' => '<p>Specifies a new foundation model to be used for orchestration by the agent.</p>', ], ], 'MongoDbAtlasCollectionName' => [ 'base' => NULL, 'refs' => [ 'MongoDbAtlasConfiguration$collectionName' => '<p>The collection name of the knowledge base in MongoDB Atlas.</p>', ], ], 'MongoDbAtlasConfiguration' => [ 'base' => '<p>Contains details about the storage configuration of the knowledge base in MongoDB Atlas. </p>', 'refs' => [ 'StorageConfiguration$mongoDbAtlasConfiguration' => '<p>Contains the storage configuration of the knowledge base in MongoDB Atlas.</p>', ], ], 'MongoDbAtlasDatabaseName' => [ 'base' => NULL, 'refs' => [ 'MongoDbAtlasConfiguration$databaseName' => '<p>The database name in your MongoDB Atlas cluster for your knowledge base.</p>', ], ], 'MongoDbAtlasEndpoint' => [ 'base' => NULL, 'refs' => [ 'MongoDbAtlasConfiguration$endpoint' => '<p>The endpoint URL of your MongoDB Atlas cluster for your knowledge base.</p>', ], ], 'MongoDbAtlasEndpointServiceName' => [ 'base' => NULL, 'refs' => [ 'MongoDbAtlasConfiguration$endpointServiceName' => '<p>The name of the VPC endpoint service in your account that is connected to your MongoDB Atlas cluster.</p>', ], ], 'MongoDbAtlasFieldMapping' => [ 'base' => '<p>Contains the names of the fields to which to map information about the vector store.</p>', 'refs' => [ 'MongoDbAtlasConfiguration$fieldMapping' => '<p>Contains the names of the fields to which to map information about the vector store.</p>', ], ], 'MongoDbAtlasIndexName' => [ 'base' => NULL, 'refs' => [ 'MongoDbAtlasConfiguration$vectorIndexName' => '<p>The name of the MongoDB Atlas vector search index.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'ActionGroupSummary$actionGroupName' => '<p>The name of the action group.</p>', 'Agent$agentName' => '<p>The name of the agent.</p>', 'AgentActionGroup$actionGroupName' => '<p>The name of the action group.</p>', 'AgentAlias$agentAliasName' => '<p>The name of the alias of the agent.</p>', 'AgentAliasSummary$agentAliasName' => '<p>The name of the alias.</p>', 'AgentSummary$agentName' => '<p>The name of the agent.</p>', 'AgentVersion$agentName' => '<p>The name of the agent that the version belongs to.</p>', 'AgentVersionSummary$agentName' => '<p>The name of the agent to which the version belongs.</p>', 'CreateAgentActionGroupRequest$actionGroupName' => '<p>The name to give the action group.</p>', 'CreateAgentAliasRequest$agentAliasName' => '<p>The name of the alias.</p>', 'CreateAgentRequest$agentName' => '<p>A name for the agent that you create.</p>', 'CreateDataSourceRequest$name' => '<p>The name of the data source.</p>', 'CreateFlowAliasRequest$name' => '<p>A name for the alias.</p>', 'CreateFlowAliasResponse$name' => '<p>The name of the alias.</p>', 'CreateKnowledgeBaseRequest$name' => '<p>A name for the knowledge base.</p>', 'DataSource$name' => '<p>The name of the data source.</p>', 'DataSourceSummary$name' => '<p>The name of the data source.</p>', 'FlowAliasSummary$name' => '<p>The name of the alias.</p>', 'Function$name' => '<p>A name for the function.</p>', 'GetFlowAliasResponse$name' => '<p>The name of the flow alias.</p>', 'KnowledgeBase$name' => '<p>The name of the knowledge base.</p>', 'KnowledgeBaseSummary$name' => '<p>The name of the knowledge base.</p>', 'ParameterMap$key' => NULL, 'UpdateAgentActionGroupRequest$actionGroupName' => '<p>Specifies a new name for the action group.</p>', 'UpdateAgentAliasRequest$agentAliasName' => '<p>Specifies a new name for the alias.</p>', 'UpdateAgentRequest$agentName' => '<p>Specifies a new name for the agent.</p>', 'UpdateDataSourceRequest$name' => '<p>Specifies a new name for the data source.</p>', 'UpdateFlowAliasRequest$name' => '<p>The name of the flow alias.</p>', 'UpdateFlowAliasResponse$name' => '<p>The name of the flow alias.</p>', 'UpdateKnowledgeBaseRequest$name' => '<p>Specifies a new name for the knowledge base.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAgentActionGroupsRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListAgentActionGroupsResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListAgentAliasesRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListAgentAliasesResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListAgentKnowledgeBasesRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListAgentKnowledgeBasesResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListAgentVersionsRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListAgentVersionsResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListAgentsRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListAgentsResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListDataSourcesRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListDataSourcesResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListFlowAliasesRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListFlowAliasesResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListFlowVersionsRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListFlowVersionsResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListFlowsRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListFlowsResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListIngestionJobsRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListIngestionJobsResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListKnowledgeBasesRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListKnowledgeBasesResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListPromptsRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListPromptsResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', ], ], 'NonBlankString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'FlowValidation$message' => '<p>A message describing the validation error.</p>', 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, 'ValidationExceptionField$message' => '<p>A message describing why this field failed validation.</p>', 'ValidationExceptionField$name' => '<p>The name of the field.</p>', ], ], 'NumericalVersion' => [ 'base' => NULL, 'refs' => [ 'AgentVersion$version' => '<p>The version number.</p>', 'CreateFlowVersionResponse$version' => '<p>The version of the flow that was created. Versions are numbered incrementally, starting from 1.</p>', 'DeleteAgentVersionRequest$agentVersion' => '<p>The version of the agent to delete.</p>', 'DeleteAgentVersionResponse$agentVersion' => '<p>The version that was deleted.</p>', 'DeleteFlowVersionRequest$flowVersion' => '<p>The version of the flow that you want to delete.</p>', 'DeleteFlowVersionResponse$version' => '<p>The version of the flow being deleted.</p>', 'DeletePromptRequest$promptVersion' => '<p>The version of the prompt to delete.</p>', 'DeletePromptResponse$version' => '<p>The version of the prompt that was deleted.</p>', 'FlowVersionSummary$version' => '<p>The version of the flow.</p>', 'GetAgentVersionRequest$agentVersion' => '<p>The version of the agent.</p>', 'GetFlowVersionRequest$flowVersion' => '<p>The version of the flow for which to get information.</p>', 'GetFlowVersionResponse$version' => '<p>The version of the flow for which information was retrieved.</p>', ], ], 'OpenSearchServerlessCollectionArn' => [ 'base' => NULL, 'refs' => [ 'OpenSearchServerlessConfiguration$collectionArn' => '<p>The Amazon Resource Name (ARN) of the OpenSearch Service vector store.</p>', ], ], 'OpenSearchServerlessConfiguration' => [ 'base' => '<p>Contains details about the storage configuration of the knowledge base in Amazon OpenSearch Service. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html">Create a vector index in Amazon OpenSearch Service</a>.</p>', 'refs' => [ 'StorageConfiguration$opensearchServerlessConfiguration' => '<p>Contains the storage configuration of the knowledge base in Amazon OpenSearch Service.</p>', ], ], 'OpenSearchServerlessFieldMapping' => [ 'base' => '<p>Contains the names of the fields to which to map information about the vector store.</p>', 'refs' => [ 'OpenSearchServerlessConfiguration$fieldMapping' => '<p>Contains the names of the fields to which to map information about the vector store.</p>', ], ], 'OpenSearchServerlessIndexName' => [ 'base' => NULL, 'refs' => [ 'OpenSearchServerlessConfiguration$vectorIndexName' => '<p>The name of the vector store.</p>', ], ], 'OutputFlowNodeConfiguration' => [ 'base' => '<p>Contains configurations for an output flow node in the flow. You specify the data type expected for the input into the node in the <code>type</code> field and how to return the final output in the <code>expression</code> field.</p>', 'refs' => [ 'FlowNodeConfiguration$output' => '<p>Contains configurations for an output flow node in your flow. The last node in the flow. <code>outputs</code> can\'t be specified for this node.</p>', ], ], 'ParameterDescription' => [ 'base' => NULL, 'refs' => [ 'ParameterDetail$description' => '<p>A description of the parameter. Helps the foundation model determine how to elicit the parameters from the user.</p>', ], ], 'ParameterDetail' => [ 'base' => '<p>Contains details about a parameter in a function for an action group.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_RequestSyntax">CreateAgentActionGroup request</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_ResponseSyntax">CreateAgentActionGroup response</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_RequestSyntax">UpdateAgentActionGroup request</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_ResponseSyntax">UpdateAgentActionGroup response</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentActionGroup.html#API_agent_GetAgentActionGroup_ResponseSyntax">GetAgentActionGroup response</a> </p> </li> </ul>', 'refs' => [ 'ParameterMap$value' => NULL, ], ], 'ParameterMap' => [ 'base' => NULL, 'refs' => [ 'Function$parameters' => '<p>The parameters that the agent elicits from the user to fulfill the function.</p>', ], ], 'ParsingConfiguration' => [ 'base' => '<p>Settings for parsing document contents. By default, the service converts the contents of each document into text before splitting it into chunks. To improve processing of PDF files with tables and images, you can configure the data source to convert the pages of text into images and use a model to describe the contents of each page.</p> <p>To use a model to parse PDF documents, set the parsing strategy to <code>BEDROCK_FOUNDATION_MODEL</code> and specify the model to use by ARN. You can also override the default parsing prompt with instructions for how to interpret images and tables in your documents. The following models are supported.</p> <ul> <li> <p>Anthropic Claude 3 Sonnet - <code>anthropic.claude-3-sonnet-20240229-v1:0</code> </p> </li> <li> <p>Anthropic Claude 3 Haiku - <code>anthropic.claude-3-haiku-20240307-v1:0</code> </p> </li> </ul> <p>You can get the ARN of a model with the action. Standard model usage charges apply for the foundation model parsing strategy.</p>', 'refs' => [ 'VectorIngestionConfiguration$parsingConfiguration' => '<p>A custom parser for data source documents.</p>', ], ], 'ParsingPrompt' => [ 'base' => '<p>Instructions for interpreting the contents of a document.</p>', 'refs' => [ 'BedrockFoundationModelConfiguration$parsingPrompt' => '<p>Instructions for interpreting the contents of a document.</p>', ], ], 'ParsingPromptText' => [ 'base' => NULL, 'refs' => [ 'ParsingPrompt$parsingPromptText' => '<p>Instructions for interpreting the contents of a document.</p>', ], ], 'ParsingStrategy' => [ 'base' => NULL, 'refs' => [ 'ParsingConfiguration$parsingStrategy' => '<p>The parsing strategy for the data source.</p>', ], ], 'PatternObjectFilter' => [ 'base' => '<p>The specific filters applied to your data source content. You can filter out or include certain content.</p>', 'refs' => [ 'PatternObjectFilterList$member' => NULL, ], ], 'PatternObjectFilterConfiguration' => [ 'base' => '<p>The configuration of filtering certain objects or content types of the data source.</p>', 'refs' => [ 'CrawlFilterConfiguration$patternObjectFilter' => '<p>The configuration of filtering certain objects or content types of the data source.</p>', ], ], 'PatternObjectFilterList' => [ 'base' => NULL, 'refs' => [ 'PatternObjectFilterConfiguration$filters' => '<p>The configuration of specific filters applied to your data source content. You can filter out or include certain content.</p>', ], ], 'Payload' => [ 'base' => NULL, 'refs' => [ 'APISchema$payload' => '<p>The JSON or YAML-formatted payload defining the OpenAPI schema for the action group. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI schemas</a>.</p>', ], ], 'PineconeConfiguration' => [ 'base' => '<p>Contains details about the storage configuration of the knowledge base in Pinecone. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-pinecone.html">Create a vector index in Pinecone</a>.</p>', 'refs' => [ 'StorageConfiguration$pineconeConfiguration' => '<p>Contains the storage configuration of the knowledge base in Pinecone.</p>', ], ], 'PineconeConnectionString' => [ 'base' => NULL, 'refs' => [ 'PineconeConfiguration$connectionString' => '<p>The endpoint URL for your index management page.</p>', ], ], 'PineconeFieldMapping' => [ 'base' => '<p>Contains the names of the fields to which to map information about the vector store.</p>', 'refs' => [ 'PineconeConfiguration$fieldMapping' => '<p>Contains the names of the fields to which to map information about the vector store.</p>', ], ], 'PineconeNamespace' => [ 'base' => NULL, 'refs' => [ 'PineconeConfiguration$namespace' => '<p>The namespace to be used to write new data to your database.</p>', ], ], 'PrepareAgentRequest' => [ 'base' => NULL, 'refs' => [], ], 'PrepareAgentResponse' => [ 'base' => NULL, 'refs' => [], ], 'PrepareFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'PrepareFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'PrimitiveLong' => [ 'base' => NULL, 'refs' => [ 'IngestionJobStatistics$numberOfDocumentsDeleted' => '<p>The number of source documents that was deleted.</p>', 'IngestionJobStatistics$numberOfDocumentsFailed' => '<p>The number of source documents that failed to be ingested.</p>', 'IngestionJobStatistics$numberOfDocumentsScanned' => '<p>The total number of source documents that were scanned. Includes new, updated, and unchanged documents.</p>', 'IngestionJobStatistics$numberOfMetadataDocumentsModified' => '<p>The number of metadata files that were updated or deleted.</p>', 'IngestionJobStatistics$numberOfMetadataDocumentsScanned' => '<p>The total number of metadata files that were scanned. Includes new, updated, and unchanged files.</p>', 'IngestionJobStatistics$numberOfModifiedDocumentsIndexed' => '<p>The number of modified source documents in the data source that were successfully indexed.</p>', 'IngestionJobStatistics$numberOfNewDocumentsIndexed' => '<p>The number of new source documents in the data source that were successfully indexed.</p>', ], ], 'PromptArn' => [ 'base' => NULL, 'refs' => [ 'CreatePromptResponse$arn' => '<p>The Amazon Resource Name (ARN) of the prompt.</p>', 'CreatePromptVersionResponse$arn' => '<p>The Amazon Resource Name (ARN) of the version of the prompt.</p>', 'GetPromptResponse$arn' => '<p>The Amazon Resource Name (ARN) of the prompt.</p>', 'PromptFlowNodeResourceConfiguration$promptArn' => '<p>The Amazon Resource Name (ARN) of the prompt from Prompt management.</p>', 'PromptSummary$arn' => '<p>The Amazon Resource Name (ARN) of the prompt.</p>', 'UpdatePromptResponse$arn' => '<p>The Amazon Resource Name (ARN) of the prompt.</p>', ], ], 'PromptConfiguration' => [ 'base' => '<p>Contains configurations to override a prompt template in one part of an agent sequence. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.</p>', 'refs' => [ 'PromptConfigurations$member' => NULL, ], ], 'PromptConfigurations' => [ 'base' => NULL, 'refs' => [ 'PromptOverrideConfiguration$promptConfigurations' => '<p>Contains configurations to override a prompt template in one part of an agent sequence. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.</p>', ], ], 'PromptDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePromptRequest$description' => '<p>A description for the prompt.</p>', 'CreatePromptResponse$description' => '<p>The description of the prompt.</p>', 'CreatePromptVersionRequest$description' => '<p>A description for the version of the prompt.</p>', 'CreatePromptVersionResponse$description' => '<p>A description for the prompt version.</p>', 'GetPromptResponse$description' => '<p>The descriptino of the prompt.</p>', 'PromptSummary$description' => '<p>The description of the prompt.</p>', 'UpdatePromptRequest$description' => '<p>A description for the prompt.</p>', 'UpdatePromptResponse$description' => '<p>The description of the prompt.</p>', ], ], 'PromptFlowNodeConfiguration' => [ 'base' => '<p>Contains configurations for a prompt node in the flow. You can use a prompt from Prompt management or you can define one in this node. If the prompt contains variables, the inputs into this node will fill in the variables. The output from this node is the response generated by the model. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in Amazon Bedrock works</a> in the Amazon Bedrock User Guide.</p>', 'refs' => [ 'FlowNodeConfiguration$prompt' => '<p>Contains configurations for a prompt node in your flow. Runs a prompt and generates the model response as the output. You can use a prompt from Prompt management or you can configure one in this node.</p>', ], ], 'PromptFlowNodeInlineConfiguration' => [ 'base' => '<p>Contains configurations for a prompt defined inline in the node.</p>', 'refs' => [ 'PromptFlowNodeSourceConfiguration$inline' => '<p>Contains configurations for a prompt that is defined inline</p>', ], ], 'PromptFlowNodeResourceConfiguration' => [ 'base' => '<p>Contains configurations for a prompt from Prompt management to use in a node.</p>', 'refs' => [ 'PromptFlowNodeSourceConfiguration$resource' => '<p>Contains configurations for a prompt from Prompt management.</p>', ], ], 'PromptFlowNodeSourceConfiguration' => [ 'base' => '<p>Contains configurations for a prompt and whether it is from Prompt management or defined inline.</p>', 'refs' => [ 'PromptFlowNodeConfiguration$sourceConfiguration' => '<p>Specifies whether the prompt is from Prompt management or defined inline.</p>', ], ], 'PromptId' => [ 'base' => NULL, 'refs' => [ 'CreatePromptResponse$id' => '<p>The unique identifier of the prompt.</p>', 'CreatePromptVersionResponse$id' => '<p>The unique identifier of the prompt.</p>', 'DeletePromptResponse$id' => '<p>The unique identifier of the prompt that was deleted.</p>', 'GetPromptResponse$id' => '<p>The unique identifier of the prompt.</p>', 'PromptSummary$id' => '<p>The unique identifier of the prompt.</p>', 'UpdatePromptResponse$id' => '<p>The unique identifier of the prompt.</p>', ], ], 'PromptIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreatePromptVersionRequest$promptIdentifier' => '<p>The unique identifier of the prompt that you want to create a version of.</p>', 'DeletePromptRequest$promptIdentifier' => '<p>The unique identifier of the prompt.</p>', 'GetPromptRequest$promptIdentifier' => '<p>The unique identifier of the prompt.</p>', 'ListPromptsRequest$promptIdentifier' => '<p>The unique identifier of the prompt.</p>', 'UpdatePromptRequest$promptIdentifier' => '<p>The unique identifier of the prompt.</p>', ], ], 'PromptInferenceConfiguration' => [ 'base' => '<p>Contains inference configurations for the prompt.</p>', 'refs' => [ 'PromptFlowNodeInlineConfiguration$inferenceConfiguration' => '<p>Contains inference configurations for the prompt.</p>', 'PromptVariant$inferenceConfiguration' => '<p>Contains inference configurations for the prompt variant.</p>', ], ], 'PromptInputVariable' => [ 'base' => '<p>Contains information about a variable in the prompt.</p>', 'refs' => [ 'PromptInputVariablesList$member' => NULL, ], ], 'PromptInputVariableName' => [ 'base' => NULL, 'refs' => [ 'PromptInputVariable$name' => '<p>The name of the variable.</p>', ], ], 'PromptInputVariablesList' => [ 'base' => NULL, 'refs' => [ 'TextPromptTemplateConfiguration$inputVariables' => '<p>An array of the variables in the prompt template.</p>', ], ], 'PromptModelIdentifier' => [ 'base' => NULL, 'refs' => [ 'PromptFlowNodeInlineConfiguration$modelId' => '<p>The unique identifier of the model to run inference with.</p>', 'PromptVariant$modelId' => '<p>The unique identifier of the model with which to run inference on the prompt.</p>', ], ], 'PromptModelInferenceConfiguration' => [ 'base' => '<p>Contains inference configurations related to model inference for a prompt. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/inference-parameters.html">Inference parameters</a>.</p>', 'refs' => [ 'PromptInferenceConfiguration$text' => '<p>Contains inference configurations for a text prompt.</p>', ], ], 'PromptName' => [ 'base' => NULL, 'refs' => [ 'CreatePromptRequest$name' => '<p>A name for the prompt.</p>', 'CreatePromptResponse$name' => '<p>The name of the prompt.</p>', 'CreatePromptVersionResponse$name' => '<p>The name of the prompt version.</p>', 'GetPromptResponse$name' => '<p>The name of the prompt.</p>', 'PromptSummary$name' => '<p>The name of the prompt.</p>', 'UpdatePromptRequest$name' => '<p>A name for the prompt.</p>', 'UpdatePromptResponse$name' => '<p>The name of the prompt.</p>', ], ], 'PromptOverrideConfiguration' => [ 'base' => '<p>Contains configurations to override prompts in different parts of an agent sequence. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.</p>', 'refs' => [ 'Agent$promptOverrideConfiguration' => '<p>Contains configurations to override prompt templates in different parts of an agent sequence. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.</p>', 'AgentVersion$promptOverrideConfiguration' => '<p>Contains configurations to override prompt templates in different parts of an agent sequence. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.</p>', 'CreateAgentRequest$promptOverrideConfiguration' => '<p>Contains configurations to override prompts in different parts of an agent sequence. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.</p>', 'UpdateAgentRequest$promptOverrideConfiguration' => '<p>Contains configurations to override prompts in different parts of an agent sequence. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.</p>', ], ], 'PromptState' => [ 'base' => NULL, 'refs' => [ 'PromptConfiguration$promptState' => '<p>Specifies whether to allow the agent to carry out the step specified in the <code>promptType</code>. If you set this value to <code>DISABLED</code>, the agent skips that step. The default state for each <code>promptType</code> is as follows.</p> <ul> <li> <p> <code>PRE_PROCESSING</code> – <code>ENABLED</code> </p> </li> <li> <p> <code>ORCHESTRATION</code> – <code>ENABLED</code> </p> </li> <li> <p> <code>KNOWLEDGE_BASE_RESPONSE_GENERATION</code> – <code>ENABLED</code> </p> </li> <li> <p> <code>POST_PROCESSING</code> – <code>DISABLED</code> </p> </li> </ul>', ], ], 'PromptSummaries' => [ 'base' => NULL, 'refs' => [ 'ListPromptsResponse$promptSummaries' => '<p>A list, each member of which contains information about a prompt using Prompt management.</p>', ], ], 'PromptSummary' => [ 'base' => '<p>Contains information about a prompt in your Prompt management tool.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListPrompts.html#API_agent_ListPrompts_ResponseSyntax">ListPrompts response</a> </p> </li> </ul>', 'refs' => [ 'PromptSummaries$member' => NULL, ], ], 'PromptTemplateConfiguration' => [ 'base' => '<p>Contains the message for a prompt. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html">Prompt management in Amazon Bedrock</a>.</p>', 'refs' => [ 'PromptFlowNodeInlineConfiguration$templateConfiguration' => '<p>Contains a prompt and variables in the prompt that can be replaced with values at runtime.</p>', 'PromptVariant$templateConfiguration' => '<p>Contains configurations for the prompt template.</p>', ], ], 'PromptTemplateType' => [ 'base' => NULL, 'refs' => [ 'PromptFlowNodeInlineConfiguration$templateType' => '<p>The type of prompt template.</p>', 'PromptVariant$templateType' => '<p>The type of prompt template to use.</p>', ], ], 'PromptType' => [ 'base' => NULL, 'refs' => [ 'PromptConfiguration$promptType' => '<p>The step in the agent sequence that this prompt configuration applies to.</p>', ], ], 'PromptVariant' => [ 'base' => '<p>Contains details about a variant of the prompt.</p>', 'refs' => [ 'PromptVariantList$member' => NULL, ], ], 'PromptVariantList' => [ 'base' => NULL, 'refs' => [ 'CreatePromptRequest$variants' => '<p>A list of objects, each containing details about a variant of the prompt.</p>', 'CreatePromptResponse$variants' => '<p>A list of objects, each containing details about a variant of the prompt.</p>', 'CreatePromptVersionResponse$variants' => '<p>A list of objects, each containing details about a variant of the prompt.</p>', 'GetPromptResponse$variants' => '<p>A list of objects, each containing details about a variant of the prompt.</p>', 'UpdatePromptRequest$variants' => '<p>A list of objects, each containing details about a variant of the prompt.</p>', 'UpdatePromptResponse$variants' => '<p>A list of objects, each containing details about a variant of the prompt.</p>', ], ], 'PromptVariantName' => [ 'base' => NULL, 'refs' => [ 'CreatePromptRequest$defaultVariant' => '<p>The name of the default variant for the prompt. This value must match the <code>name</code> field in the relevant <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html">PromptVariant</a> object.</p>', 'CreatePromptResponse$defaultVariant' => '<p>The name of the default variant for your prompt.</p>', 'CreatePromptVersionResponse$defaultVariant' => '<p>The name of the default variant for the prompt. This value must match the <code>name</code> field in the relevant <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html">PromptVariant</a> object.</p>', 'GetPromptResponse$defaultVariant' => '<p>The name of the default variant for the prompt. This value must match the <code>name</code> field in the relevant <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html">PromptVariant</a> object.</p>', 'PromptVariant$name' => '<p>The name of the prompt variant.</p>', 'UpdatePromptRequest$defaultVariant' => '<p>The name of the default variant for the prompt. This value must match the <code>name</code> field in the relevant <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html">PromptVariant</a> object.</p>', 'UpdatePromptResponse$defaultVariant' => '<p>The name of the default variant for the prompt. This value must match the <code>name</code> field in the relevant <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html">PromptVariant</a> object.</p>', ], ], 'ProvisionedModelIdentifier' => [ 'base' => NULL, 'refs' => [ 'AgentAliasRoutingConfigurationListItem$provisionedThroughput' => '<p>Information on the Provisioned Throughput assigned to an agent alias.</p>', ], ], 'RdsArn' => [ 'base' => NULL, 'refs' => [ 'RdsConfiguration$resourceArn' => '<p>The Amazon Resource Name (ARN) of the vector store.</p>', ], ], 'RdsConfiguration' => [ 'base' => '<p>Contains details about the storage configuration of the knowledge base in Amazon RDS. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html">Create a vector index in Amazon RDS</a>.</p>', 'refs' => [ 'StorageConfiguration$rdsConfiguration' => '<p>Contains details about the storage configuration of the knowledge base in Amazon RDS. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html">Create a vector index in Amazon RDS</a>.</p>', ], ], 'RdsDatabaseName' => [ 'base' => NULL, 'refs' => [ 'RdsConfiguration$databaseName' => '<p>The name of your Amazon RDS database.</p>', ], ], 'RdsFieldMapping' => [ 'base' => '<p>Contains the names of the fields to which to map information about the vector store.</p>', 'refs' => [ 'RdsConfiguration$fieldMapping' => '<p>Contains the names of the fields to which to map information about the vector store.</p>', ], ], 'RdsTableName' => [ 'base' => NULL, 'refs' => [ 'RdsConfiguration$tableName' => '<p>The name of the table in the database.</p>', ], ], 'RecommendedAction' => [ 'base' => NULL, 'refs' => [ 'RecommendedActions$member' => NULL, ], ], 'RecommendedActions' => [ 'base' => NULL, 'refs' => [ 'Agent$recommendedActions' => '<p>Contains recommended actions to take for the agent-related API that you invoked to succeed.</p>', 'AgentVersion$recommendedActions' => '<p>A list of recommended actions to take for the failed API operation on the version to succeed.</p>', ], ], 'RedisEnterpriseCloudConfiguration' => [ 'base' => '<p>Contains details about the storage configuration of the knowledge base in Redis Enterprise Cloud. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html">Create a vector index in Redis Enterprise Cloud</a>.</p>', 'refs' => [ 'StorageConfiguration$redisEnterpriseCloudConfiguration' => '<p>Contains the storage configuration of the knowledge base in Redis Enterprise Cloud.</p>', ], ], 'RedisEnterpriseCloudEndpoint' => [ 'base' => NULL, 'refs' => [ 'RedisEnterpriseCloudConfiguration$endpoint' => '<p>The endpoint URL of the Redis Enterprise Cloud database.</p>', ], ], 'RedisEnterpriseCloudFieldMapping' => [ 'base' => '<p>Contains the names of the fields to which to map information about the vector store.</p>', 'refs' => [ 'RedisEnterpriseCloudConfiguration$fieldMapping' => '<p>Contains the names of the fields to which to map information about the vector store.</p>', ], ], 'RedisEnterpriseCloudIndexName' => [ 'base' => NULL, 'refs' => [ 'RedisEnterpriseCloudConfiguration$vectorIndexName' => '<p>The name of the vector index.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and try your request again.</p>', 'refs' => [], ], 'RetrievalFlowNodeConfiguration' => [ 'base' => '<p>Contains configurations for a Retrieval node in a flow. This node retrieves data from the Amazon S3 location that you specify and returns it as the output.</p>', 'refs' => [ 'FlowNodeConfiguration$retrieval' => '<p>Contains configurations for a Retrieval node in your flow. Retrieves data from an Amazon S3 location and returns it as the output.</p>', ], ], 'RetrievalFlowNodeS3Configuration' => [ 'base' => '<p>Contains configurations for the Amazon S3 location from which to retrieve data to return as the output from the node.</p>', 'refs' => [ 'RetrievalFlowNodeServiceConfiguration$s3' => '<p>Contains configurations for the Amazon S3 location from which to retrieve data to return as the output from the node.</p>', ], ], 'RetrievalFlowNodeServiceConfiguration' => [ 'base' => '<p>Contains configurations for the service to use for retrieving data to return as the output from the node.</p>', 'refs' => [ 'RetrievalFlowNodeConfiguration$serviceConfiguration' => '<p>Contains configurations for the service to use for retrieving data to return as the output from the node.</p>', ], ], 'S3BucketArn' => [ 'base' => NULL, 'refs' => [ 'S3DataSourceConfiguration$bucketArn' => '<p>The Amazon Resource Name (ARN) of the S3 bucket that contains your data.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'RetrievalFlowNodeS3Configuration$bucketName' => '<p>The name of the Amazon S3 bucket from which to retrieve data.</p>', 'S3Identifier$s3BucketName' => '<p>The name of the S3 bucket.</p>', 'StorageFlowNodeS3Configuration$bucketName' => '<p>The name of the Amazon S3 bucket in which to store the input into the node.</p>', ], ], 'S3BucketUri' => [ 'base' => NULL, 'refs' => [ 'S3Location$uri' => '<p>The location\'s URI. For example, <code>s3://my-bucket/chunk-processor/</code>.</p>', ], ], 'S3DataSourceConfiguration' => [ 'base' => '<p>The configuration information to connect to Amazon S3 as your data source.</p>', 'refs' => [ 'DataSourceConfiguration$s3Configuration' => '<p>The configuration information to connect to Amazon S3 as your data source.</p>', ], ], 'S3Identifier' => [ 'base' => '<p>The identifier information for an Amazon S3 bucket.</p>', 'refs' => [ 'APISchema$s3' => '<p>Contains details about the S3 object containing the OpenAPI schema for the action group. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI schemas</a>.</p>', ], ], 'S3Location' => [ 'base' => '<p>An Amazon S3 location.</p>', 'refs' => [ 'IntermediateStorage$s3Location' => '<p>An S3 bucket path.</p>', ], ], 'S3ObjectKey' => [ 'base' => NULL, 'refs' => [ 'S3Identifier$s3ObjectKey' => '<p>The S3 object key for the S3 resource.</p>', ], ], 'S3Prefix' => [ 'base' => NULL, 'refs' => [ 'S3Prefixes$member' => NULL, ], ], 'S3Prefixes' => [ 'base' => NULL, 'refs' => [ 'S3DataSourceConfiguration$inclusionPrefixes' => '<p>A list of S3 prefixes to include certain files or content. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html">Organizing objects using prefixes</a>.</p>', ], ], 'SalesforceAuthType' => [ 'base' => NULL, 'refs' => [ 'SalesforceSourceConfiguration$authType' => '<p>The supported authentication type to authenticate and connect to your Salesforce instance.</p>', ], ], 'SalesforceCrawlerConfiguration' => [ 'base' => '<p>The configuration of the Salesforce content. For example, configuring specific types of Salesforce content.</p>', 'refs' => [ 'SalesforceDataSourceConfiguration$crawlerConfiguration' => '<p>The configuration of the Salesforce content. For example, configuring specific types of Salesforce content.</p>', ], ], 'SalesforceDataSourceConfiguration' => [ 'base' => '<p>The configuration information to connect to Salesforce as your data source.</p>', 'refs' => [ 'DataSourceConfiguration$salesforceConfiguration' => '<p>The configuration information to connect to Salesforce as your data source.</p> <note> <p>Salesforce data source connector is in preview release and is subject to change.</p> </note>', ], ], 'SalesforceSourceConfiguration' => [ 'base' => '<p>The endpoint information to connect to your Salesforce data source.</p>', 'refs' => [ 'SalesforceDataSourceConfiguration$sourceConfiguration' => '<p>The endpoint information to connect to your Salesforce data source.</p>', ], ], 'SecretArn' => [ 'base' => NULL, 'refs' => [ 'ConfluenceSourceConfiguration$credentialsSecretArn' => '<p>The Amazon Resource Name of an Secrets Manager secret that stores your authentication credentials for your SharePoint site/sites. For more information on the key-value pairs that must be included in your secret, depending on your authentication type, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/confluence-data-source-connector.html#configuration-confluence-connector">Confluence connection configuration</a>.</p>', 'MongoDbAtlasConfiguration$credentialsSecretArn' => '<p>The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that contains user credentials for your MongoDB Atlas cluster.</p>', 'PineconeConfiguration$credentialsSecretArn' => '<p>The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that is linked to your Pinecone API key.</p>', 'RdsConfiguration$credentialsSecretArn' => '<p>The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that is linked to your Amazon RDS database.</p>', 'RedisEnterpriseCloudConfiguration$credentialsSecretArn' => '<p>The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that is linked to your Redis Enterprise Cloud database.</p>', 'SalesforceSourceConfiguration$credentialsSecretArn' => '<p>The Amazon Resource Name of an Secrets Manager secret that stores your authentication credentials for your SharePoint site/sites. For more information on the key-value pairs that must be included in your secret, depending on your authentication type, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/salesforce-data-source-connector.html#configuration-salesforce-connector">Salesforce connection configuration</a>.</p>', 'SharePointSourceConfiguration$credentialsSecretArn' => '<p>The Amazon Resource Name of an Secrets Manager secret that stores your authentication credentials for your SharePoint site/sites. For more information on the key-value pairs that must be included in your secret, depending on your authentication type, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/sharepoint-data-source-connector.html#configuration-sharepoint-connector">SharePoint connection configuration</a>.</p>', ], ], 'SeedUrl' => [ 'base' => '<p>The seed or starting point URL. You should be authorized to crawl the URL.</p>', 'refs' => [ 'SeedUrls$member' => NULL, ], ], 'SeedUrls' => [ 'base' => NULL, 'refs' => [ 'UrlConfiguration$seedUrls' => '<p>One or more seed or starting point URLs.</p>', ], ], 'SemanticChunkingConfiguration' => [ 'base' => '<p>Settings for semantic document chunking for a data source. Semantic chunking splits a document into into smaller documents based on groups of similar content derived from the text with natural language processing.</p> <p>With semantic chunking, each sentence is compared to the next to determine how similar they are. You specify a threshold in the form of a percentile, where adjacent sentences that are less similar than that percentage of sentence pairs are divided into separate chunks. For example, if you set the threshold to 90, then the 10 percent of sentence pairs that are least similar are split. So if you have 101 sentences, 100 sentence pairs are compared, and the 10 with the least similarity are split, creating 11 chunks. These chunks are further split if they exceed the max token size.</p> <p>You must also specify a buffer size, which determines whether sentences are compared in isolation, or within a moving context window that includes the previous and following sentence. For example, if you set the buffer size to <code>1</code>, the embedding for sentence 10 is derived from sentences 9, 10, and 11 combined.</p>', 'refs' => [ 'ChunkingConfiguration$semanticChunkingConfiguration' => '<p>Settings for semantic document chunking for a data source. Semantic chunking splits a document into into smaller documents based on groups of similar content derived from the text with natural language processing.</p>', ], ], 'SemanticChunkingConfigurationBreakpointPercentileThresholdInteger' => [ 'base' => NULL, 'refs' => [ 'SemanticChunkingConfiguration$breakpointPercentileThreshold' => '<p>The dissimilarity threshold for splitting chunks.</p>', ], ], 'SemanticChunkingConfigurationBufferSizeInteger' => [ 'base' => NULL, 'refs' => [ 'SemanticChunkingConfiguration$bufferSize' => '<p>The buffer size.</p>', ], ], 'SemanticChunkingConfigurationMaxTokensInteger' => [ 'base' => NULL, 'refs' => [ 'SemanticChunkingConfiguration$maxTokens' => '<p>The maximum number of tokens that a chunk can contain.</p>', ], ], 'ServerSideEncryptionConfiguration' => [ 'base' => '<p>Contains the configuration for server-side encryption.</p>', 'refs' => [ 'CreateDataSourceRequest$serverSideEncryptionConfiguration' => '<p>Contains details about the server-side encryption for the data source.</p>', 'DataSource$serverSideEncryptionConfiguration' => '<p>Contains details about the configuration of the server-side encryption.</p>', 'UpdateDataSourceRequest$serverSideEncryptionConfiguration' => '<p>Contains details about server-side encryption of the data source.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The number of requests exceeds the service quota. Resubmit your request later.</p>', 'refs' => [], ], 'SessionTTL' => [ 'base' => NULL, 'refs' => [ 'Agent$idleSessionTTLInSeconds' => '<p>The number of seconds for which Amazon Bedrock keeps information about a user\'s conversation with the agent.</p> <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.</p>', 'AgentVersion$idleSessionTTLInSeconds' => '<p>The number of seconds for which Amazon Bedrock keeps information about a user\'s conversation with the agent.</p> <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.</p>', 'CreateAgentRequest$idleSessionTTLInSeconds' => '<p>The number of seconds for which Amazon Bedrock keeps information about a user\'s conversation with the agent.</p> <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.</p>', 'UpdateAgentRequest$idleSessionTTLInSeconds' => '<p>The number of seconds for which Amazon Bedrock keeps information about a user\'s conversation with the agent.</p> <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.</p>', ], ], 'SharePointAuthType' => [ 'base' => NULL, 'refs' => [ 'SharePointSourceConfiguration$authType' => '<p>The supported authentication type to authenticate and connect to your SharePoint site/sites.</p>', ], ], 'SharePointCrawlerConfiguration' => [ 'base' => '<p>The configuration of the SharePoint content. For example, configuring specific types of SharePoint content.</p>', 'refs' => [ 'SharePointDataSourceConfiguration$crawlerConfiguration' => '<p>The configuration of the SharePoint content. For example, configuring specific types of SharePoint content.</p>', ], ], 'SharePointDataSourceConfiguration' => [ 'base' => '<p>The configuration information to connect to SharePoint as your data source.</p>', 'refs' => [ 'DataSourceConfiguration$sharePointConfiguration' => '<p>The configuration information to connect to SharePoint as your data source.</p> <note> <p>SharePoint data source connector is in preview release and is subject to change.</p> </note>', ], ], 'SharePointDomain' => [ 'base' => NULL, 'refs' => [ 'SharePointSourceConfiguration$domain' => '<p>The domain of your SharePoint instance or site URL/URLs.</p>', ], ], 'SharePointHostType' => [ 'base' => NULL, 'refs' => [ 'SharePointSourceConfiguration$hostType' => '<p>The supported host type, whether online/cloud or server/on-premises.</p>', ], ], 'SharePointSiteUrls' => [ 'base' => NULL, 'refs' => [ 'SharePointSourceConfiguration$siteUrls' => '<p>A list of one or more SharePoint site URLs.</p>', ], ], 'SharePointSourceConfiguration' => [ 'base' => '<p>The endpoint information to connect to your SharePoint data source.</p>', 'refs' => [ 'SharePointDataSourceConfiguration$sourceConfiguration' => '<p>The endpoint information to connect to your SharePoint data source.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'IngestionJobSortBy$order' => '<p>The order by which to sort the results.</p>', ], ], 'StartIngestionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartIngestionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StepType' => [ 'base' => NULL, 'refs' => [ 'Transformation$stepToApply' => '<p>When the service applies the transformation.</p>', ], ], 'StopSequences' => [ 'base' => NULL, 'refs' => [ 'InferenceConfiguration$stopSequences' => '<p>A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response.</p>', 'PromptModelInferenceConfiguration$stopSequences' => '<p>A list of strings that define sequences after which the model will stop generating.</p>', ], ], 'StorageConfiguration' => [ 'base' => '<p>Contains the storage configuration of the knowledge base.</p>', 'refs' => [ 'CreateKnowledgeBaseRequest$storageConfiguration' => '<p>Contains details about the configuration of the vector database used for the knowledge base.</p>', 'KnowledgeBase$storageConfiguration' => '<p>Contains details about the storage configuration of the knowledge base.</p>', 'UpdateKnowledgeBaseRequest$storageConfiguration' => '<p>Specifies the configuration for the vector store used for the knowledge base. You must use the same configuration as when the knowledge base was created.</p>', ], ], 'StorageDays' => [ 'base' => NULL, 'refs' => [ 'MemoryConfiguration$storageDays' => '<p>The number of days the agent is configured to retain the conversational context.</p>', ], ], 'StorageFlowNodeConfiguration' => [ 'base' => '<p>Contains configurations for a Storage node in a flow. This node stores the input in an Amazon S3 location that you specify.</p>', 'refs' => [ 'FlowNodeConfiguration$storage' => '<p>Contains configurations for a Storage node in your flow. Stores an input in an Amazon S3 location.</p>', ], ], 'StorageFlowNodeS3Configuration' => [ 'base' => '<p>Contains configurations for the Amazon S3 location in which to store the input into the node.</p>', 'refs' => [ 'StorageFlowNodeServiceConfiguration$s3' => '<p>Contains configurations for the Amazon S3 location in which to store the input into the node.</p>', ], ], 'StorageFlowNodeServiceConfiguration' => [ 'base' => '<p>Contains configurations for the service to use for storing the input into the node.</p>', 'refs' => [ 'StorageFlowNodeConfiguration$serviceConfiguration' => '<p>Contains configurations for the service to use for storing the input into the node.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'StopSequences$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagsMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of keys of the tags to remove from the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagsMap$value' => NULL, ], ], 'TaggableResourcesArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which to list tags.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to tag.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource from which to remove tags.</p>', ], ], 'TagsMap' => [ 'base' => NULL, 'refs' => [ 'CreateAgentAliasRequest$tags' => '<p>Any tags that you want to attach to the alias of the agent.</p>', 'CreateAgentRequest$tags' => '<p>Any tags that you want to attach to the agent.</p>', 'CreateFlowAliasRequest$tags' => '<p>Any tags that you want to attach to the alias of the flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging resources in Amazon Bedrock</a>.</p>', 'CreateFlowRequest$tags' => '<p>Any tags that you want to attach to the flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging resources in Amazon Bedrock</a>.</p>', 'CreateKnowledgeBaseRequest$tags' => '<p>Specify the key-value pairs for the tags that you want to attach to your knowledge base in this object.</p>', 'CreatePromptRequest$tags' => '<p>Any tags that you want to attach to the prompt. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging resources in Amazon Bedrock</a>.</p>', 'CreatePromptVersionRequest$tags' => '<p>Any tags that you want to attach to the version of the prompt. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging resources in Amazon Bedrock</a>.</p>', 'ListTagsForResourceResponse$tags' => '<p>The key-value pairs for the tags associated with the resource.</p>', 'TagResourceRequest$tags' => '<p>An object containing key-value pairs that define the tags to attach to the resource.</p>', ], ], 'Temperature' => [ 'base' => NULL, 'refs' => [ 'InferenceConfiguration$temperature' => '<p>The likelihood of the model selecting higher-probability options while generating a response. A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.</p>', 'PromptModelInferenceConfiguration$temperature' => '<p>Controls the randomness of the response. Choose a lower value for more predictable outputs and a higher value for more surprising outputs.</p>', ], ], 'TextPrompt' => [ 'base' => NULL, 'refs' => [ 'TextPromptTemplateConfiguration$text' => '<p>The message for the prompt.</p>', ], ], 'TextPromptTemplateConfiguration' => [ 'base' => '<p>Contains configurations for a text prompt template. To include a variable, enclose a word in double curly braces as in <code>{{variable}}</code>.</p>', 'refs' => [ 'PromptTemplateConfiguration$text' => '<p>Contains configurations for the text in a message for a prompt.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The number of requests exceeds the limit. Resubmit your request later.</p>', 'refs' => [], ], 'TopK' => [ 'base' => NULL, 'refs' => [ 'InferenceConfiguration$topK' => '<p>While generating a response, the model determines the probability of the following token at each point of generation. The value that you set for <code>topK</code> is the number of most-likely candidates from which the model chooses the next token in the sequence. For example, if you set <code>topK</code> to 50, the model selects the next token from among the top 50 most likely choices.</p>', 'PromptModelInferenceConfiguration$topK' => '<p>The number of most-likely candidates that the model considers for the next token during generation.</p>', ], ], 'TopP' => [ 'base' => NULL, 'refs' => [ 'InferenceConfiguration$topP' => '<p>While generating a response, the model determines the probability of the following token at each point of generation. The value that you set for <code>Top P</code> determines the number of most-likely candidates from which the model chooses the next token in the sequence. For example, if you set <code>topP</code> to 80, the model only selects the next token from the top 80% of the probability distribution of next tokens.</p>', 'PromptModelInferenceConfiguration$topP' => '<p>The percentage of most-likely candidates that the model considers for the next token.</p>', ], ], 'Transformation' => [ 'base' => '<p>A custom processing step for documents moving through a data source ingestion pipeline. To process documents after they have been converted into chunks, set the step to apply to <code>POST_CHUNKING</code>.</p>', 'refs' => [ 'Transformations$member' => NULL, ], ], 'TransformationFunction' => [ 'base' => '<p>A Lambda function that processes documents.</p>', 'refs' => [ 'Transformation$transformationFunction' => '<p>A Lambda function that processes documents.</p>', ], ], 'TransformationLambdaConfiguration' => [ 'base' => '<p>A Lambda function that processes documents.</p>', 'refs' => [ 'TransformationFunction$transformationLambdaConfiguration' => '<p>The Lambda function.</p>', ], ], 'Transformations' => [ 'base' => NULL, 'refs' => [ 'CustomTransformationConfiguration$transformations' => '<p>A Lambda function that processes documents.</p>', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'ParameterDetail$type' => '<p>The data type of the parameter.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAgentActionGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAgentActionGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAgentAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAgentAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAgentKnowledgeBaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAgentKnowledgeBaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAgentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAgentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFlowAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFlowAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKnowledgeBaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKnowledgeBaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePromptRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePromptResponse' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'SeedUrl$url' => '<p>A seed or starting point URL.</p>', ], ], 'UrlConfiguration' => [ 'base' => '<p>The configuration of web URLs that you want to crawl. You should be authorized to crawl the URLs.</p>', 'refs' => [ 'WebSourceConfiguration$urlConfiguration' => '<p>The configuration of the URL/URLs.</p>', ], ], 'ValidationException' => [ 'base' => '<p>Input validation failed. Check your request parameters and retry the request.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Stores information about a field passed inside a request that resulted in an validation error.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>A list of objects containing fields that caused validation errors and their corresponding validation error messages.</p>', ], ], 'VectorIngestionConfiguration' => [ 'base' => '<p>Contains details about how to ingest the documents in a data source.</p>', 'refs' => [ 'CreateDataSourceRequest$vectorIngestionConfiguration' => '<p>Contains details about how to ingest the documents in the data source.</p>', 'DataSource$vectorIngestionConfiguration' => '<p>Contains details about how to ingest the documents in the data source.</p>', 'UpdateDataSourceRequest$vectorIngestionConfiguration' => '<p>Contains details about how to ingest the documents in the data source.</p>', ], ], 'VectorKnowledgeBaseConfiguration' => [ 'base' => '<p>Contains details about the model used to create vector embeddings for the knowledge base.</p>', 'refs' => [ 'KnowledgeBaseConfiguration$vectorKnowledgeBaseConfiguration' => '<p>Contains details about the embeddings model that\'sused to convert the data source.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'AgentActionGroup$agentVersion' => '<p>The version of the agent to which the action group belongs.</p>', 'AgentAliasRoutingConfigurationListItem$agentVersion' => '<p>The version of the agent with which the alias is associated.</p>', 'AgentKnowledgeBase$agentVersion' => '<p>The version of the agent with which the knowledge base is associated.</p>', 'AgentSummary$latestAgentVersion' => '<p>The latest version of the agent.</p>', 'AgentVersionSummary$agentVersion' => '<p>The version of the agent.</p>', 'CreatePromptResponse$version' => '<p>The version of the prompt. When you create a prompt, the version created is the <code>DRAFT</code> version.</p>', 'CreatePromptVersionResponse$version' => '<p>The version of the prompt that was created. Versions are numbered incrementally, starting from 1.</p>', 'FlowAliasRoutingConfigurationListItem$flowVersion' => '<p>The version that the alias maps to.</p>', 'GetAgentActionGroupRequest$agentVersion' => '<p>The version of the agent that the action group belongs to.</p>', 'GetAgentKnowledgeBaseRequest$agentVersion' => '<p>The version of the agent with which the knowledge base is associated.</p>', 'GetPromptRequest$promptVersion' => '<p>The version of the prompt about which you want to retrieve information.</p>', 'GetPromptResponse$version' => '<p>The version of the prompt.</p>', 'ListAgentActionGroupsRequest$agentVersion' => '<p>The version of the agent.</p>', 'ListAgentKnowledgeBasesRequest$agentVersion' => '<p>The version of the agent for which to return information about knowledge bases associated with it.</p>', 'PrepareAgentResponse$agentVersion' => '<p>The version of the agent.</p>', 'PromptSummary$version' => '<p>The version of the prompt that this summary applies to.</p>', 'UpdatePromptResponse$version' => '<p>The version of the prompt. When you update a prompt, the version updated is the <code>DRAFT</code> version.</p>', ], ], 'WebCrawlerConfiguration' => [ 'base' => '<p>The configuration of web URLs that you want to crawl. You should be authorized to crawl the URLs.</p>', 'refs' => [ 'WebDataSourceConfiguration$crawlerConfiguration' => '<p>The Web Crawler configuration details for the web data source.</p>', ], ], 'WebCrawlerLimits' => [ 'base' => '<p>The rate limits for the URLs that you want to crawl. You should be authorized to crawl the URLs.</p>', 'refs' => [ 'WebCrawlerConfiguration$crawlerLimits' => '<p>The configuration of crawl limits for the web URLs.</p>', ], ], 'WebCrawlerLimitsRateLimitInteger' => [ 'base' => NULL, 'refs' => [ 'WebCrawlerLimits$rateLimit' => '<p>The max rate at which pages are crawled, up to 300 per minute per host.</p>', ], ], 'WebDataSourceConfiguration' => [ 'base' => '<p>The configuration details for the web data source.</p>', 'refs' => [ 'DataSourceConfiguration$webConfiguration' => '<p>The configuration of web URLs to crawl for your data source. You should be authorized to crawl the URLs.</p> <note> <p>Crawling web URLs as your data source is in preview release and is subject to change.</p> </note>', ], ], 'WebScopeType' => [ 'base' => NULL, 'refs' => [ 'WebCrawlerConfiguration$scope' => '<p>The scope of what is crawled for your URLs.</p> <p>You can choose to crawl only web pages that belong to the same host or primary domain. For example, only web pages that contain the seed URL "https://docs.aws.amazon.com/bedrock/latest/userguide/" and no other domains. You can choose to include sub domains in addition to the host or primary domain. For example, web pages that contain "aws.amazon.com" can also include sub domain "docs.aws.amazon.com".</p>', ], ], 'WebSourceConfiguration' => [ 'base' => '<p>The configuration of the URL/URLs for the web content that you want to crawl. You should be authorized to crawl the URLs.</p>', 'refs' => [ 'WebDataSourceConfiguration$sourceConfiguration' => '<p>The source configuration details for the web data source.</p>', ], ], ],];
